/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.edt;

import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.fest.util.StackTraces;

abstract class CheckThreadViolationRepaintManager
extends RepaintManager {
    private final boolean completeCheck;
    private final StackTraces stackTraces;
    private WeakReference<JComponent> lastComponent;

    CheckThreadViolationRepaintManager() {
        this(true);
    }

    CheckThreadViolationRepaintManager(boolean completeCheck) {
        this(completeCheck, StackTraces.instance());
    }

    CheckThreadViolationRepaintManager(boolean completeCheck, StackTraces stackTraces) {
        this.completeCheck = completeCheck;
        this.stackTraces = stackTraces;
    }

    public synchronized void addInvalidComponent(JComponent component) {
        this.checkThreadViolations(component);
        super.addInvalidComponent(component);
    }

    public void addDirtyRegion(JComponent component, int x, int y, int w, int h) {
        this.checkThreadViolations(component);
        super.addDirtyRegion(component, x, y, w, h);
    }

    private void checkThreadViolations(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || c.isShowing())) {
            StackTraceElement[] stackTrace;
            boolean imageUpdate = false;
            boolean repaint = false;
            boolean fromSwing = false;
            for (StackTraceElement st : stackTrace = this.stackTraces.stackTraceInCurrentThread()) {
                if (repaint && st.getClassName().startsWith("javax.swing.")) {
                    fromSwing = true;
                }
                if (repaint && "imageUpdate".equals(st.getMethodName())) {
                    imageUpdate = true;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
                fromSwing = false;
            }
            if (imageUpdate) {
                return;
            }
            if (repaint && !fromSwing) {
                return;
            }
            if (this.lastComponent != null && c == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(c);
            this.violationFound(c, stackTrace);
        }
    }

    abstract void violationFound(JComponent var1, StackTraceElement[] var2);
}

