/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import picard.sam.HitsForInsert;
import picard.sam.PrimaryAlignmentSelectionStrategy;

public class BestEndMapqPrimaryAlignmentStrategy
implements PrimaryAlignmentSelectionStrategy {
    private static final MapqComparator MAPQ_COMPARATOR = new MapqComparator();
    private final Random random = new Random(1L);

    @Override
    public void pickPrimaryAlignment(HitsForInsert hits) {
        if (hits.numHits() == 0) {
            throw new IllegalArgumentException("No alignments to pick from");
        }
        Collections.sort(hits.firstOfPairOrFragment, MAPQ_COMPARATOR);
        Collections.sort(hits.secondOfPair, MAPQ_COMPARATOR);
        this.randomlySelectPrimaryFromBest(hits.firstOfPairOrFragment);
        this.randomlySelectPrimaryFromBest(hits.secondOfPair);
        hits.setPrimaryAlignment(0);
        if (!hits.isPaired()) {
            return;
        }
        if (hits.firstOfPairOrFragment.size() <= 1 || hits.secondOfPair.size() <= 1) {
            return;
        }
        int amountToSlide = hits.firstOfPairOrFragment.size() - 1;
        for (int i = 0; i < amountToSlide; ++i) {
            hits.secondOfPair.add(1, null);
        }
    }

    private void randomlySelectPrimaryFromBest(List<SAMRecord> recs) {
        int i;
        if (recs.isEmpty()) {
            return;
        }
        int bestMapq = recs.get(0).getMappingQuality();
        for (i = 1; i < recs.size() && recs.get(i).getMappingQuality() == bestMapq; ++i) {
        }
        int bestIndex = this.random.nextInt(i);
        if (bestIndex == 0) {
            return;
        }
        SAMRecord tmp = recs.get(0);
        recs.set(0, recs.get(bestIndex));
        recs.set(bestIndex, tmp);
    }

    private static class MapqComparator
    implements Comparator<SAMRecord> {
        private MapqComparator() {
        }

        @Override
        public int compare(SAMRecord rec1, SAMRecord rec2) {
            if (rec1.getReadUnmappedFlag()) {
                if (rec2.getReadUnmappedFlag()) {
                    return 0;
                }
                return 1;
            }
            if (rec2.getReadUnmappedFlag()) {
                return -1;
            }
            return -SAMUtils.compareMapqs((int)rec1.getMappingQuality(), (int)rec2.getMappingQuality());
        }
    }
}

