/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.service;

import com.nvidia.common.util.Tuple;
import com.nvidia.cuda.ide.debug.service.CudaMIVariableManager;
import com.nvidia.cuda.ide.debug.service.ICudaExpressions;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateInDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.mi.service.MIExpressions;
import org.eclipse.cdt.dsf.mi.service.MIVariableManager;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CudaExpressionsService
extends MIExpressions
implements ICudaExpressions {
    private final Map<Tuple<IStack.IFrameDMContext, MIExpressions.ExpressionInfo, ?>, ChildrenFetcher> childrenFetchers = new ConcurrentHashMap();

    public CudaExpressionsService(DsfSession session) {
        super(session);
    }

    @Override
    public void createExpressions(IStack.IFrameDMContext stackFrame, IDMContext[] expressions, DataRequestMonitor<IDMContext[]> rm) {
        final IDMContext[] res = new IDMContext[expressions.length];
        CountingRequestMonitor crm = new CountingRequestMonitor((Executor)new ImmediateInDsfExecutor(this.getExecutor()), (RequestMonitor)rm, (DataRequestMonitor)rm, res){
            private final /* synthetic */ DataRequestMonitor val$rm;
            private final /* synthetic */ IDMContext[] val$res;
            {
                this.val$rm = dataRequestMonitor;
                this.val$res = iDMContextArray;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                this.val$rm.setData((Object)this.val$res);
                this.val$rm.done();
            }
        };
        int count = 1;
        int i = 0;
        while (i < expressions.length) {
            final int n = i;
            if (expressions[i] instanceof MIExpressions.MIExpressionDMC) {
                MIExpressions.MIExpressionDMC dmc = (MIExpressions.MIExpressionDMC)expressions[i];
                MIExpressions.ExpressionInfo expressionInfo = dmc.getExpressionInfo();
                if (expressionInfo.getParent() != null) {
                    this.getChild(stackFrame, expressionInfo, new DataRequestMonitor<IDMContext>((Executor)this.getExecutor(), (RequestMonitor)crm){

                        protected void handleSuccess() {
                            res[n] = (IDMContext)this.getData();
                            super.handleSuccess();
                        }
                    });
                    ++count;
                } else {
                    res[i] = this.createExpression((IDMContext)stackFrame, ((IExpressions.IExpressionDMContext)expressions[i]).getExpression());
                }
            }
            ++i;
        }
        crm.setDoneCount(count);
        crm.done();
    }

    protected MIVariableManager createMIVariableManager() {
        return new CudaMIVariableManager(this.getSession(), this.getServicesTracker());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getChild(IStack.IFrameDMContext stackFrame, MIExpressions.ExpressionInfo child, DataRequestMonitor<IDMContext> rm) {
        MIExpressions.ExpressionInfo parent = child.getParent();
        if (parent != null) {
            if (parent.getRelExpr().equals("public") && parent.getParent() != null) {
                parent = parent.getParent();
            }
            Map<Tuple<IStack.IFrameDMContext, MIExpressions.ExpressionInfo, ?>, ChildrenFetcher> map = this.childrenFetchers;
            synchronized (map) {
                Tuple key = Tuple.pair((Object)stackFrame, (Object)parent);
                ChildrenFetcher fetcher = this.childrenFetchers.get(key);
                if (fetcher == null) {
                    fetcher = new ChildrenFetcher(key);
                    this.childrenFetchers.put(key, fetcher);
                }
                fetcher.add(child, rm);
            }
        } else {
            rm.setData((Object)this.createExpression((IDMContext)stackFrame, child.getFullExpr()));
            rm.done();
        }
    }

    protected void register(String[] classes, Dictionary properties) {
        super.register(DebugUtil.ensureContains(classes, CudaExpressionsService.class.getName(), ICudaExpressions.class.getName()), properties);
    }

    public final class ChildrenFetcher
    extends DataRequestMonitor<IExpressions.IExpressionDMContext[]> {
        private final Tuple<IStack.IFrameDMContext, MIExpressions.ExpressionInfo, ?> key;
        private final Collection<Tuple<MIExpressions.ExpressionInfo, DataRequestMonitor<IDMContext>, ?>> queue;

        public ChildrenFetcher(Tuple<IStack.IFrameDMContext, MIExpressions.ExpressionInfo, ?> key) {
            super((Executor)CudaExpressionsService.this.getExecutor(), null);
            this.queue = Collections.synchronizedCollection(new LinkedList());
            this.key = key;
            CudaExpressionsService.this.getChild((IStack.IFrameDMContext)key.getObject1(), (MIExpressions.ExpressionInfo)key.getObject2(), (DataRequestMonitor<IDMContext>)((DataRequestMonitor)new DataRequestMonitor<IDMContext>((Executor)CudaExpressionsService.this.getExecutor(), null){

                protected void handleSuccess() {
                    CudaExpressionsService.this.getSubExpressions((IExpressions.IExpressionDMContext)this.getData(), ChildrenFetcher.this);
                }
            }));
        }

        public void add(MIExpressions.ExpressionInfo child, DataRequestMonitor<IDMContext> rm) {
            this.queue.add(Tuple.pair((Object)child, rm));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleSuccess() {
            Map map = CudaExpressionsService.this.childrenFetchers;
            synchronized (map) {
                CudaExpressionsService.this.childrenFetchers.remove(this.key);
            }
            IExpressions.IExpressionDMContext[] children = (IExpressions.IExpressionDMContext[])this.getData();
            for (Tuple<MIExpressions.ExpressionInfo, DataRequestMonitor<IDMContext>, ?> tuple : this.queue) {
                DataRequestMonitor rm = (DataRequestMonitor)tuple.getObject2();
                MIExpressions.ExpressionInfo expressionInfo = (MIExpressions.ExpressionInfo)tuple.getObject1();
                String relExpr = expressionInfo.getRelExpr();
                if (DebugUtil.isNumber(relExpr)) {
                    MIExpressions.ExpressionInfo newInfo = new MIExpressions.ExpressionInfo(expressionInfo.getFullExpr(), expressionInfo.getRelExpr(), expressionInfo.isDynamic(), (MIExpressions.ExpressionInfo)this.key.getObject2(), expressionInfo.getIndexInParentExpression());
                    MIExpressions.MIExpressionDMC expression = new MIExpressions.MIExpressionDMC(CudaExpressionsService.this.getSession().getId(), newInfo, (IStack.IFrameDMContext)this.key.getObject1());
                    rm.setData((Object)expression);
                } else {
                    this.findMemberExpression(children, (DataRequestMonitor<IDMContext>)rm, expressionInfo.getFullExpr());
                }
                rm.done();
            }
        }

        private void findMemberExpression(IExpressions.IExpressionDMContext[] children, DataRequestMonitor<IDMContext> rm, String relExpr) {
            boolean found = false;
            IExpressions.IExpressionDMContext[] iExpressionDMContextArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IExpressions.IExpressionDMContext child = iExpressionDMContextArray[n2];
                if (child.getExpression().equals(relExpr)) {
                    rm.setData((Object)child);
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", "Failed to find on another thread"));
            }
        }
    }
}

