/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.ui.connection.toolkits;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.AsyncValidator;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.OS;
import com.nvidia.common.util.PageTitleStatusObservable;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.common.wizards.ContextPropertyStore;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.ui.connection.ConnectionStateLabel;
import com.nvidia.cuda.ide.remote.ui.connection.toolkits.CustomToolsWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.statushandlers.StatusManager;

public final class CustomToolsWizardPage
extends WizardPage
implements IWizardPage {
    private final IRemoteConnection connection;
    private final DataBindingContext context;
    private final ContextPropertyStore map;
    private final ICudaToolkit toolkit;

    public CustomToolsWizardPage(DataBindingContext context, ContextPropertyStore map, ICudaToolkit toolkit, IRemoteConnection connection) {
        super("Custom Tools", "CUDA Tools Locations", null);
        this.context = context;
        this.map = map;
        this.toolkit = toolkit;
        this.connection = connection;
        this.setDescription("Customize locations of individual CUDA tools");
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(4, false));
        LinkedList<IObservableValue> values = new LinkedList<IObservableValue>();
        ICudaToolkit.Tool[] toolArray = ICudaToolkit.Tool.values();
        int n = toolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICudaToolkit.Tool tool = toolArray[n2];
            if (tool.isCustomizable()) {
                IObservableValue path = this.map.observeProperty(CustomToolsWizard.getPathProperty(tool));
                path.setValue((Object)this.toolkit.getToolPath(tool));
                new ToolEntry(tool, panel).bind(this.context, path);
                values.add(path);
            }
            ++n2;
        }
        this.context.bindValue((IObservableValue)new PageTitleStatusObservable((WizardPage)this), (IObservableValue)new ValidatorValue(values, this.connection));
        Composite labelPane = new Composite(panel, 0);
        labelPane.setLayoutData((Object)GridDataFactory.defaultsFor((Control)labelPane).span(4, 1).grab(true, false).create());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        labelPane.setLayout((Layout)layout);
        new ConnectionStateLabel(labelPane, (IRunnableContext)this.getContainer(), (IObservableValue)new WritableValue((Object)this.connection, IRemoteConnection.class)).bind(this.context);
        this.setControl((Control)panel);
    }

    private class ToolEntry {
        private final Text text;
        private IObservableValue model;
        private final ICudaToolkit.Tool tool;

        public ToolEntry(final ICudaToolkit.Tool tool, Composite panel) {
            this.tool = tool;
            new Label(panel, 0).setText(tool.fullName());
            this.text = new Text(panel, 2048);
            this.text.setLayoutData((Object)new GridData(768));
            Button browseButton = new Button(panel, 0);
            browseButton.setText("Browse...");
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolEntry.this.browse();
                }
            });
            ToolBar toolbar = new ToolBar(panel, 0x800000);
            ToolItem item = new ToolItem(toolbar, 8);
            item.setToolTipText("Use default");
            item.setImage(SWTUtil.getImage((String)"IMG_ETOOL_CLEAR"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolEntry.this.model.setValue((Object)CustomToolsWizardPage.this.toolkit.getDefaultToolPath(tool));
                    ToolEntry.this.text.setFocus();
                }
            });
        }

        protected void browse() {
            if (!CustomToolsWizardPage.this.connection.isConnected(IRemoteConnection.Service.Files)) {
                try {
                    CustomToolsWizardPage.this.getContainer().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                CustomToolsWizardPage.this.connection.connect(IRemoteConnection.Service.Files, monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e.getCause(), (String)"Unable to establish connection to a remote system", (Object[])new Object[0]), 1);
                    return;
                }
                catch (InterruptedException e) {
                    StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e, (String)"User canceled", (Object[])new Object[0]), 1);
                    return;
                }
            }
            this.text.setFocus();
            String path = (String)this.model.getValue();
            if (CoreUtil.isNullOrEmpty((String)path)) {
                path = CustomToolsWizardPage.this.toolkit.getToolPath(this.tool);
            }
            try {
                String newPath = CustomToolsWizardPage.this.connection.browse(CustomToolsWizardPage.this.getShell(), String.format("Specify location for %s executable", this.tool.executable(OS.Linux)), path);
                if (newPath != null) {
                    this.model.setValue((Object)newPath);
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e.getCause(), (String)"Unable to browse remote file system", (Object[])new Object[0]), 1);
            }
        }

        public void bind(DataBindingContext context, IObservableValue model) {
            this.model = model;
            context.bindValue((IObservableValue)SWTObservables.observeText((Control)this.text, (int)24), model);
        }
    }

    private static final class ValidatorValue
    extends ComputedValue {
        private final IRemoteConnection connection;
        private final AsyncValidator validator;
        private final Collection<IObservableValue> values;

        private ValidatorValue(Collection<IObservableValue> values, IRemoteConnection connection) {
            this.values = values;
            this.connection = connection;
            this.validator = new AsyncValidator();
        }

        protected Object calculate() {
            if (this.connection.isConnected(IRemoteConnection.Service.Files)) {
                return this.validator.submit(this.createValidator(this.values));
            }
            return CoreUtil.warningStatus((String)"Remote paths are not validated", (Object[])new Object[0]);
        }

        private Callable<IStatus> createValidator(Collection<IObservableValue> values) {
            final String[] paths = new String[values.size()];
            int i = 0;
            for (IObservableValue value : values) {
                paths[i++] = (String)value.getValue();
            }
            return new Callable<IStatus>(){

                @Override
                public IStatus call() throws Exception {
                    IStatus status = null;
                    String[] stringArray = paths;
                    int n = paths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String path = stringArray[n2];
                        status = CoreUtil.moreSevere(status, (IStatus)ValidatorValue.this.validate(path));
                        ++n2;
                    }
                    return status;
                }
            };
        }

        private IStatus validate(String path) {
            if (CoreUtil.isNullOrEmpty((String)path) || this.connection.isFile(path, true, (IProgressMonitor)new NullProgressMonitor())) {
                return CoreUtil.OK_STATUS;
            }
            return CoreUtil.errorStatus((String)"Path %s does not point to a valid executable on a remote system", (Object[])new Object[]{path});
        }
    }
}

