/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SignatureBuilder;
import org.eclipse.core.runtime.CoreException;

public abstract class CPPEvaluation
implements ICPPEvaluation {
    CPPEvaluation() {
    }

    @Override
    public IBinding getTemplateDefinition() {
        return null;
    }

    @Override
    public char[] getSignature() {
        SignatureBuilder buf = new SignatureBuilder();
        try {
            this.marshal(buf, true);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{'?'};
        }
        return buf.getSignature();
    }

    protected static IBinding resolveUnknown(ICPPUnknownBinding unknown, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, IASTNode point) {
        try {
            return CPPTemplates.resolveUnknown(unknown, tpMap, packOffset, within, point);
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
            return unknown;
        }
    }

    protected static ICPPTemplateArgument[] instantiateArguments(ICPPTemplateArgument[] args, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, IASTNode point) {
        try {
            return CPPTemplates.instantiateArguments(args, tpMap, packOffset, within, point, false);
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
            return args;
        }
    }

    protected static IBinding instantiateBinding(IBinding binding, ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        try {
            return CPPTemplates.instantiateBinding(binding, tpMap, packOffset, within, maxdepth, point);
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
            return binding;
        }
    }

    protected static boolean containsDependentType(ICPPEvaluation[] evaluations) {
        ICPPEvaluation[] iCPPEvaluationArray = evaluations;
        int n = evaluations.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation eval = iCPPEvaluationArray[n2];
            if (eval.isTypeDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean containsDependentValue(ICPPEvaluation[] evaluations) {
        ICPPEvaluation[] iCPPEvaluationArray = evaluations;
        int n = evaluations.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation eval = iCPPEvaluationArray[n2];
            if (eval.isValueDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean areAllConstantExpressions(ICPPEvaluation[] evaluations, IASTNode point) {
        ICPPEvaluation[] iCPPEvaluationArray = evaluations;
        int n = evaluations.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation eval = iCPPEvaluationArray[n2];
            if (!eval.isConstantExpression(point)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected static boolean isConstexprValue(IValue value, IASTNode point) {
        if (value == null) {
            return false;
        }
        ICPPEvaluation innerEval = value.getEvaluation();
        if (innerEval == null) {
            return value.numericalValue() != null;
        }
        return innerEval.isConstantExpression(point);
    }

    protected static boolean isNullOrConstexprFunc(ICPPFunction function) {
        return function == null || function.isConstexpr();
    }
}

