/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class ExpressionTypes {
    public static IType glvalueType(IType type) {
        return SemanticUtil.getNestedType(type, 6);
    }

    public static IType prvalueType(IType type) {
        return Conversions.lvalue_to_rvalue(type, false);
    }

    public static IType prvalueTypeWithResolvedTypedefs(IType type) {
        return Conversions.lvalue_to_rvalue(type, true);
    }

    public static IASTExpression.ValueCategory valueCategoryFromFunctionCall(ICPPFunction function) {
        ICPPFunctionType ft = function.getType();
        return ExpressionTypes.valueCategoryFromReturnType(ft.getReturnType());
    }

    public static IASTExpression.ValueCategory valueCategoryFromReturnType(IType r) {
        if ((r = SemanticUtil.getNestedType(r, 1)) instanceof ICPPReferenceType) {
            ICPPReferenceType refType = (ICPPReferenceType)r;
            if (!refType.isRValueReference()) {
                return IASTExpression.ValueCategory.LVALUE;
            }
            if (SemanticUtil.getNestedType(refType.getType(), 13) instanceof IFunctionType) {
                return IASTExpression.ValueCategory.LVALUE;
            }
            return IASTExpression.ValueCategory.XVALUE;
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    public static IType typeFromFunctionCall(ICPPFunction function) {
        ICPPFunctionType ft = function.getType();
        return ExpressionTypes.typeFromReturnType(ft.getReturnType());
    }

    public static IType typeFromReturnType(IType type) {
        IType t = SemanticUtil.getNestedType(type, 1);
        if (t instanceof ICPPReferenceType) {
            return ExpressionTypes.glvalueType(type);
        }
        return ExpressionTypes.prvalueType(type);
    }

    public static IType restoreTypedefs(IType type, IType originalType) {
        IType t = SemanticUtil.substituteTypedef(type, originalType);
        if (t != null) {
            return t;
        }
        return type;
    }

    public static IType restoreTypedefs(IType type, IType originalType1, IType originalType2) {
        IType t = SemanticUtil.substituteTypedef(type, originalType1);
        if (t != null) {
            return t;
        }
        if (originalType2 != null && (t = SemanticUtil.substituteTypedef(type, originalType2)) != null) {
            return t;
        }
        return type;
    }
}

