/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

class PDOMCEnumerator
extends PDOMBinding
implements IEnumerator {
    private static final int VALUE = 32;
    protected static final int RECORD_SIZE = 36;

    public PDOMCEnumerator(PDOMLinkage linkage, PDOMNode parent, IEnumerator enumerator) throws CoreException {
        super(linkage, parent, enumerator.getNameCharArray());
        Database db = this.getDB();
        this.storeValue(db, enumerator);
    }

    public PDOMCEnumerator(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    @Override
    protected int getRecordSize() {
        return 36;
    }

    @Override
    public int getNodeType() {
        return 3;
    }

    private void storeValue(Database db, IEnumerator enumerator) throws CoreException {
        IValue value = enumerator.getValue();
        if (value != null) {
            Long val = value.numericalValue();
            db.putInt(this.record + 32L, val == null ? -1 : val.intValue());
        }
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IEnumerator) {
            this.storeValue(this.getDB(), (IEnumerator)newBinding);
        }
    }

    @Override
    public IType getType() {
        IIndexBinding owner = this.getOwner();
        if (owner instanceof IType) {
            return (IType)((Object)owner);
        }
        return null;
    }

    @Override
    public IValue getValue() {
        try {
            int val = this.getDB().getInt(this.record + 32L);
            return Value.create(val);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return Value.UNKNOWN;
        }
    }
}

