/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.handlers.IMissingConnectionHandler;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.RemoteServices;

public class RemoteLocation {
    private String fRemoteServicesId;
    private String fConnectionName;
    private String fDirectory;
    private IRemoteServices fRemoteServices;
    private IRemoteConnection fConnection;

    public static String resolveString(IProject project, String path) {
        if (!path.startsWith("${") || !path.endsWith("}")) {
            return path;
        }
        String newPath = path.substring(2, path.length() - 1);
        String variable = newPath.split(":")[0];
        IPathVariableManager pvm = project.getPathVariableManager();
        String value = pvm.getURIValue(variable.toUpperCase()).toString();
        if (value == null) {
            return path;
        }
        if ((value = value.replaceFirst("file:", "")).endsWith("/") || value.endsWith("\\")) {
            value = value.substring(0, path.length() - 1);
        }
        return newPath.replaceFirst(String.valueOf(variable) + ":*", value);
    }

    public RemoteLocation() {
    }

    public RemoteLocation(RemoteLocation rl) {
        this.fRemoteServicesId = rl.fRemoteServicesId;
        this.fConnectionName = rl.fConnectionName;
        this.fDirectory = rl.fDirectory;
        this.fRemoteServices = rl.fRemoteServices;
        this.fConnection = rl.fConnection;
    }

    public String getConnectionName() {
        return this.fConnectionName;
    }

    public String getDirectory() {
        return this.fDirectory;
    }

    public String getDirectory(IProject project) {
        return RemoteLocation.resolveString(project, this.fDirectory);
    }

    public IRemoteConnection getConnection() throws MissingConnectionException {
        if (this.fRemoteServices == null) {
            this.fRemoteServices = RemoteServices.getRemoteServices((String)this.fRemoteServicesId);
            this.fConnection = null;
        }
        if (this.fConnection == null) {
            IMissingConnectionHandler mcHandler;
            this.fConnection = this.fRemoteServices.getConnectionManager().getConnection(this.fConnectionName);
            if (this.fConnection == null && (mcHandler = SyncManager.getDefaultMissingConnectionHandler()) != null) {
                mcHandler.handle(this.fRemoteServices, this.fConnectionName);
                this.fConnection = this.fRemoteServices.getConnectionManager().getConnection(this.fConnectionName);
            }
        }
        if (this.fConnection == null) {
            throw new MissingConnectionException(this.fConnectionName);
        }
        return this.fConnection;
    }

    public String getRemoteServicesId() {
        return this.fRemoteServicesId;
    }

    public void setConnection(IRemoteConnection connection) {
        this.fRemoteServices = connection.getRemoteServices();
        this.fRemoteServicesId = connection.getRemoteServices().getId();
        this.fConnectionName = connection.getName();
        this.fConnection = connection;
    }

    public void setConnectionName(String connectionName) {
        this.fConnectionName = connectionName;
        this.fConnection = null;
    }

    public void setLocation(String location) {
        this.fDirectory = location;
    }

    public void setRemoteServicesId(String remoteServicesId) {
        this.fRemoteServicesId = remoteServicesId;
        this.fRemoteServices = null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fConnectionName == null ? 0 : this.fConnectionName.hashCode());
        result = 31 * result + (this.fDirectory == null ? 0 : this.fDirectory.hashCode());
        result = 31 * result + (this.fRemoteServicesId == null ? 0 : this.fRemoteServicesId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteLocation other = (RemoteLocation)obj;
        if (this.fConnectionName == null ? other.fConnectionName != null : !this.fConnectionName.equals(other.fConnectionName)) {
            return false;
        }
        if (this.fDirectory == null ? other.fDirectory != null : !this.fDirectory.equals(other.fDirectory)) {
            return false;
        }
        return !(this.fRemoteServicesId == null ? other.fRemoteServicesId != null : !this.fRemoteServicesId.equals(other.fRemoteServicesId));
    }
}

