/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute.impl;

import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.AttributePackage;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.impl.FillImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class ColorDefinitionImpl
extends FillImpl
implements ColorDefinition {
    protected static final int TRANSPARENCY_EDEFAULT = 255;
    protected int transparency = 255;
    protected boolean transparencyESet;
    protected static final int RED_EDEFAULT = 0;
    protected int red = 0;
    protected boolean redESet;
    protected static final int GREEN_EDEFAULT = 0;
    protected int green = 0;
    protected boolean greenESet;
    protected static final int BLUE_EDEFAULT = 0;
    protected int blue = 0;
    protected boolean blueESet;
    private static final double FACTOR = 0.7;

    protected ColorDefinitionImpl() {
    }

    @Override
    public void set(int iRed, int iGreen, int iBlue) {
        this.setRed(iRed);
        this.setGreen(iGreen);
        this.setBlue(iBlue);
        this.setTransparency(255);
    }

    @Override
    public void set(int iRed, int iGreen, int iBlue, int iAlpha) {
        this.setRed(iRed);
        this.setGreen(iGreen);
        this.setBlue(iBlue);
        this.setTransparency(iAlpha);
    }

    @Override
    protected EClass eStaticClass() {
        return AttributePackage.Literals.COLOR_DEFINITION;
    }

    @Override
    public int getTransparency() {
        return this.transparency;
    }

    @Override
    public void setTransparency(int newTransparency) {
        int oldTransparency = this.transparency;
        this.transparency = newTransparency;
        boolean oldTransparencyESet = this.transparencyESet;
        this.transparencyESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldTransparency, this.transparency, !oldTransparencyESet));
        }
    }

    @Override
    public void unsetTransparency() {
        int oldTransparency = this.transparency;
        boolean oldTransparencyESet = this.transparencyESet;
        this.transparency = 255;
        this.transparencyESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 1, oldTransparency, 255, oldTransparencyESet));
        }
    }

    @Override
    public boolean isSetTransparency() {
        return this.transparencyESet;
    }

    @Override
    public int getRed() {
        return this.red;
    }

    @Override
    public void setRed(int newRed) {
        int oldRed = this.red;
        this.red = newRed;
        boolean oldRedESet = this.redESet;
        this.redESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldRed, this.red, !oldRedESet));
        }
    }

    @Override
    public void unsetRed() {
        int oldRed = this.red;
        boolean oldRedESet = this.redESet;
        this.red = 0;
        this.redESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 2, oldRed, 0, oldRedESet));
        }
    }

    @Override
    public boolean isSetRed() {
        return this.redESet;
    }

    @Override
    public int getBlue() {
        return this.blue;
    }

    @Override
    public void setBlue(int newBlue) {
        int oldBlue = this.blue;
        this.blue = newBlue;
        boolean oldBlueESet = this.blueESet;
        this.blueESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldBlue, this.blue, !oldBlueESet));
        }
    }

    @Override
    public void unsetBlue() {
        int oldBlue = this.blue;
        boolean oldBlueESet = this.blueESet;
        this.blue = 0;
        this.blueESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 4, oldBlue, 0, oldBlueESet));
        }
    }

    @Override
    public boolean isSetBlue() {
        return this.blueESet;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getTransparency();
            }
            case 2: {
                return this.getRed();
            }
            case 3: {
                return this.getGreen();
            }
            case 4: {
                return this.getBlue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setTransparency((Integer)newValue);
                return;
            }
            case 2: {
                this.setRed((Integer)newValue);
                return;
            }
            case 3: {
                this.setGreen((Integer)newValue);
                return;
            }
            case 4: {
                this.setBlue((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.unsetTransparency();
                return;
            }
            case 2: {
                this.unsetRed();
                return;
            }
            case 3: {
                this.unsetGreen();
                return;
            }
            case 4: {
                this.unsetBlue();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.isSetTransparency();
            }
            case 2: {
                return this.isSetRed();
            }
            case 3: {
                return this.isSetGreen();
            }
            case 4: {
                return this.isSetBlue();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int getGreen() {
        return this.green;
    }

    @Override
    public void setGreen(int newGreen) {
        int oldGreen = this.green;
        this.green = newGreen;
        boolean oldGreenESet = this.greenESet;
        this.greenESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldGreen, this.green, !oldGreenESet));
        }
    }

    @Override
    public void unsetGreen() {
        int oldGreen = this.green;
        boolean oldGreenESet = this.greenESet;
        this.green = 0;
        this.greenESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 3, oldGreen, 0, oldGreenESet));
        }
    }

    @Override
    public boolean isSetGreen() {
        return this.greenESet;
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (transparency: ");
        if (this.transparencyESet) {
            result.append(this.transparency);
        } else {
            result.append("<unset>");
        }
        result.append(", red: ");
        if (this.redESet) {
            result.append(this.red);
        } else {
            result.append("<unset>");
        }
        result.append(", green: ");
        if (this.greenESet) {
            result.append(this.green);
        } else {
            result.append("<unset>");
        }
        result.append(", blue: ");
        if (this.blueESet) {
            result.append(this.blue);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    protected void set(ColorDefinition src) {
        this.transparency = src.getTransparency();
        this.transparencyESet = src.isSetTransparency();
        this.red = src.getRed();
        this.redESet = src.isSetRed();
        this.green = src.getGreen();
        this.greenESet = src.isSetGreen();
        this.blue = src.getBlue();
        this.blueESet = src.isSetBlue();
    }

    public static final ColorDefinition create(int iRed, int iGreen, int iBlue, int iAlpha) {
        ColorDefinition cd = AttributeFactory.eINSTANCE.createColorDefinition();
        cd.set(iRed, iGreen, iBlue, iAlpha);
        return cd;
    }

    public static final ColorDefinition create(int iRed, int iGreen, int iBlue) {
        ColorDefinition cd = AttributeFactory.eINSTANCE.createColorDefinition();
        cd.set(iRed, iGreen, iBlue);
        return cd;
    }

    public static final ColorDefinition TRANSPARENT() {
        return ColorDefinitionImpl.create(255, 255, 255, 0);
    }

    public static final ColorDefinition RED() {
        return ColorDefinitionImpl.create(255, 0, 0);
    }

    public static final ColorDefinition GREEN() {
        return ColorDefinitionImpl.create(0, 255, 0);
    }

    public static final ColorDefinition BLUE() {
        return ColorDefinitionImpl.create(0, 0, 255);
    }

    public static final ColorDefinition BLACK() {
        return ColorDefinitionImpl.create(0, 0, 0);
    }

    public static final ColorDefinition WHITE() {
        return ColorDefinitionImpl.create(255, 255, 255);
    }

    public static final ColorDefinition YELLOW() {
        return ColorDefinitionImpl.create(255, 255, 0);
    }

    public static final ColorDefinition CYAN() {
        return ColorDefinitionImpl.create(225, 225, 255);
    }

    public static final ColorDefinition GREY() {
        return ColorDefinitionImpl.create(127, 127, 127);
    }

    public static final ColorDefinition ORANGE() {
        return ColorDefinitionImpl.create(255, 197, 41);
    }

    public static final ColorDefinition CREAM() {
        return ColorDefinitionImpl.create(249, 225, 191);
    }

    public static final ColorDefinition PINK() {
        return ColorDefinitionImpl.create(255, 205, 225);
    }

    @Override
    public final ColorDefinition brighter() {
        int r = this.getRed();
        int g = this.getGreen();
        int b = this.getBlue();
        int a = this.getTransparency();
        int i = 3;
        if (r == 0 && g == 0 && b == 0) {
            return ColorDefinitionImpl.create(i, i, i, a);
        }
        if (r >= 0 && r < i) {
            r = i;
        }
        if (g >= 0 && g < i) {
            g = i;
        }
        if (b >= 0 && b < i) {
            b = i;
        }
        return ColorDefinitionImpl.create(Math.min((int)((double)r / 0.7), 255), Math.min((int)((double)g / 0.7), 255), Math.min((int)((double)b / 0.7), 255), a);
    }

    @Override
    public final ColorDefinition darker() {
        return ColorDefinitionImpl.create(Math.max((int)((double)this.getRed() * 0.7), 0), Math.max((int)((double)this.getGreen() * 0.7), 0), Math.max((int)((double)this.getBlue() * 0.7), 0), this.getTransparency());
    }

    @Override
    public final ColorDefinition translucent() {
        ColorDefinition cd = this.copyInstance();
        cd.setTransparency(127);
        return cd;
    }

    @Override
    public final ColorDefinition transparent() {
        ColorDefinition cd = this.copyInstance();
        cd.setTransparency(0);
        return cd;
    }

    @Override
    public final ColorDefinition opaque() {
        ColorDefinition cd = this.copyInstance();
        cd.setTransparency(255);
        return cd;
    }

    @Override
    public void invert() {
        this.setRed(this.getRed() ^ 0xFF);
        this.setGreen(this.getGreen() ^ 0xFF);
        this.setBlue(this.getBlue() ^ 0xFF);
    }

    @Override
    public ColorDefinition copyInstance() {
        ColorDefinitionImpl dest = new ColorDefinitionImpl();
        dest.transparency = this.getTransparency();
        dest.transparencyESet = this.isSetTransparency();
        dest.red = this.getRed();
        dest.redESet = this.isSetRed();
        dest.green = this.getGreen();
        dest.greenESet = this.isSetGreen();
        dest.blue = this.getBlue();
        dest.blueESet = this.isSetBlue();
        return dest;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.blue;
        result = 31 * result + this.green;
        result = 31 * result + this.red;
        result = 31 * result + this.transparency;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorDefinitionImpl other = (ColorDefinitionImpl)obj;
        if (this.blue != other.blue) {
            return false;
        }
        if (this.green != other.green) {
            return false;
        }
        if (this.red != other.red) {
            return false;
        }
        return this.transparency == other.transparency;
    }
}

