/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.internal.ui.views.memory.AddMemoryRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.RenderingViewPane;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class AddMemoryRenderingContextAction
implements IViewActionDelegate {
    private IMemoryRenderingSite fMemoryView;

    public void init(IViewPart view) {
        if (view instanceof IMemoryRenderingSite) {
            this.fMemoryView = (IMemoryRenderingSite)view;
        }
    }

    public void run(IAction action) {
        if (this.fMemoryView == null) {
            return;
        }
        IMemoryRenderingContainer container = this.getRenderingContainer(action);
        if (container != null) {
            AddMemoryRenderingAction addAction = new AddMemoryRenderingAction(container);
            addAction.run();
            addAction.dispose();
        }
    }

    private IMemoryRenderingContainer getRenderingContainer(IAction action) {
        IMemoryRenderingContainer[] viewPanes = this.fMemoryView.getMemoryRenderingContainers();
        String actionId = action.getId();
        IMemoryRenderingContainer selectedPane = null;
        int i = 0;
        while (i < viewPanes.length) {
            if (actionId.indexOf(viewPanes[i].getId()) != -1) {
                selectedPane = viewPanes[i];
                break;
            }
            ++i;
        }
        return selectedPane;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IMemoryRenderingContainer container = this.getRenderingContainer(action);
        if (container instanceof RenderingViewPane) {
            if (!((RenderingViewPane)container).canAddRendering()) {
                action.setEnabled(false);
            } else {
                action.setEnabled(true);
            }
        }
    }
}

