/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.core;

import com.nvidia.common.device.ICudaDevice;
import java.util.Arrays;
import java.util.LinkedList;

public final class Architecture
implements Comparable<Architecture> {
    public static final Architecture[] NONE = new Architecture[0];
    private static final Architecture[] ALL = new Architecture[]{new Architecture(6, 3, 0, false, "sm30"), new Architecture(8, 3, 2, false, "sm31"), new Architecture(7, 3, 5, false, "sm35"), new Architecture(9, 5, 0, false, "sm50"), new Architecture(10, 3, 7, false, "sm37"), new Architecture(11, 5, 2, false, "sm52"), new Architecture(12, 5, 3, false, "sm53"), new Architecture(13, 6, 0, false, "sm60"), new Architecture(14, 6, 1, false, "sm61"), new Architecture(15, 6, 2, false, "sm62"), new Architecture(16, 7, 0, false, "sm70"), new Architecture(17, 7, 2, false, "sm72"), new Architecture(18, 7, 5, false, "sm75")};
    public final String indexFile;
    public final int major;
    public final int minor;
    public final int id;
    public final boolean physicalOnly;

    static {
        Arrays.sort(ALL);
    }

    public static Architecture[] all() {
        return ALL;
    }

    public static Architecture getDefaultArchitecture() {
        return Architecture.get(3, 5);
    }

    public static String[] convertToCommandLineOptions(boolean physical, Architecture ... arch) {
        if (arch == null || arch.length == 0) {
            return new String[0];
        }
        String[] result = new String[arch.length];
        int i = 0;
        Architecture[] architectureArray = arch;
        int n = arch.length;
        int n2 = 0;
        while (n2 < n) {
            Architecture architecture = architectureArray[n2];
            result[i++] = String.format(physical ? "-gencode arch=compute_%d%d,code=sm_%d%d" : "-gencode arch=compute_%d%d,code=compute_%d%d", architecture.getVirtual().major, architecture.getVirtual().minor, architecture.major, architecture.minor);
            ++n2;
        }
        return result;
    }

    public static String[] convertToCommandLineOptions(boolean physical, int mask) {
        return Architecture.convertToCommandLineOptions(physical, Architecture.decode(mask));
    }

    public static int count() {
        return Architecture.all().length;
    }

    public static Architecture[] decode(int mask) {
        LinkedList<Architecture> architectures = new LinkedList<Architecture>();
        Architecture[] architectureArray = Architecture.all();
        int n = architectureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Architecture architecture = architectureArray[n2];
            if ((mask & architecture.getBit()) != 0) {
                architectures.add(architecture);
            }
            ++n2;
        }
        return architectures.toArray(new Architecture[architectures.size()]);
    }

    public static Architecture get(ICudaDevice device) {
        return Architecture.get(device.getVersionMajor(), device.getVersionMinor());
    }

    public static Architecture get(int major, int minor) {
        Architecture[] archs;
        Architecture[] architectureArray = archs = Architecture.all();
        int n = archs.length;
        int n2 = 0;
        while (n2 < n) {
            Architecture architecture = architectureArray[n2];
            if (architecture.major == major && architecture.minor == minor) {
                return architecture;
            }
            ++n2;
        }
        return archs[0];
    }

    private Architecture(int id, int major, int minor, boolean physicalOnly, String indexFile) {
        this.id = id;
        this.major = major;
        this.minor = minor;
        this.physicalOnly = physicalOnly;
        this.indexFile = indexFile;
    }

    @Override
    public int compareTo(Architecture o) {
        int v1 = this.major * 10000 + this.minor;
        int v2 = o.major * 10000 + o.minor;
        return v1 > v2 ? 1 : (v1 == v2 ? 0 : -1);
    }

    public boolean compatible(int versionMajor, int versionMinor, boolean physical) {
        if (physical) {
            return versionMajor == this.major && versionMinor >= this.minor && (versionMajor != 3 || versionMinor == this.minor);
        }
        return versionMajor > this.major || versionMajor == this.major && versionMinor >= this.minor;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Architecture)) {
            return false;
        }
        return this.compareTo((Architecture)obj) == 0;
    }

    public int getBit() {
        return 1 << this.id;
    }

    public String getLabel() {
        return String.format("%d.%d", this.major, this.minor).intern();
    }

    public String getMacroValue() {
        if (this.isPhysicalOnly()) {
            return this.getVirtual().getMacroValue();
        }
        return new StringBuilder(3).append(this.major).append(this.minor).append('0').toString();
    }

    public Architecture getVirtual() {
        if (this.isPhysicalOnly()) {
            Architecture[] architectureObjects = Architecture.all();
            boolean next = false;
            int i = architectureObjects.length - 1;
            while (i >= 0) {
                Architecture arch = architectureObjects[i];
                if (arch == this) {
                    next = true;
                } else if (next && !arch.isPhysicalOnly()) {
                    return arch;
                }
                --i;
            }
            return architectureObjects[0];
        }
        return this;
    }

    public int hashCode() {
        return (9 - this.major) * 31 + (9 - this.minor) * 7;
    }

    public boolean isPhysicalOnly() {
        return this.physicalOnly;
    }

    public boolean supportSeparateCompile() {
        return this.major >= 2;
    }

    public String toString() {
        return String.format("SM %d.%d", this.major, this.minor);
    }
}

