/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamsPipe {
    private final byte[] buffer;
    private boolean closed = false;
    private boolean empty = true;
    private boolean hasIncoming = false;
    private final OutputStream input = new OutputStream(){

        @Override
        public void close() throws IOException {
            StreamsPipe.this.close();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            StreamsPipe.this.writeBytes(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            StreamsPipe.this.writeByte(b);
        }
    };
    private final InputStream output = new InputStream(){

        @Override
        public void close() throws IOException {
            StreamsPipe.this.close();
        }

        @Override
        public int read() throws IOException {
            return StreamsPipe.this.readByte();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return StreamsPipe.this.readBytes(b, off, len);
        }
    };
    private int readpointer = 0;
    private int writepointer = 0;

    public StreamsPipe() {
        this(65536);
    }

    public StreamsPipe(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size should be greater then 0");
        }
        this.buffer = new byte[bufferSize];
    }

    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }

    private synchronized boolean ensureAvailableForRead() throws IOException {
        while (this.empty && !this.closed) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        return !this.empty;
    }

    private synchronized void ensureAvailableForWrite() throws IOException {
        while (!this.empty && this.writepointer == this.readpointer && !this.closed) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public OutputStream getInput() {
        return this.input;
    }

    public InputStream getOutput() {
        return this.output;
    }

    protected synchronized int readByte() throws IOException {
        this.notifyAll();
        if (this.ensureAvailableForRead()) {
            int value = this.buffer[this.readpointer++] & 0xFF;
            this.updatePipeStateAfterRead();
            return value;
        }
        this.notifyAll();
        return -1;
    }

    protected synchronized int readBytes(byte[] b, int off, int len) throws IOException {
        if (this.ensureAvailableForRead()) {
            int read;
            int length;
            for (read = 0; !this.empty && read < len; read += length) {
                int readEnd = this.readpointer >= this.writepointer ? this.buffer.length : this.writepointer;
                length = Math.min(len - read, readEnd - this.readpointer);
                System.arraycopy(this.buffer, this.readpointer, b, off + read, length);
                this.readpointer += length;
                this.updatePipeStateAfterRead();
                if (!this.hasIncoming) continue;
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
            this.notifyAll();
            return read;
        }
        this.notifyAll();
        return -1;
    }

    private synchronized void updatePipeStateAfterRead() {
        if (this.readpointer == this.buffer.length) {
            this.readpointer = 0;
        }
        if (this.readpointer == this.writepointer) {
            this.readpointer = 0;
            this.writepointer = 0;
            this.empty = true;
        }
        this.notifyAll();
    }

    private synchronized void updatePipeStateAfterWrite(int written) {
        this.writepointer += written;
        if (this.writepointer == this.buffer.length) {
            this.writepointer = 0;
        }
        this.empty = false;
        this.notifyAll();
    }

    protected synchronized void writeByte(int b) throws IOException {
        this.ensureAvailableForWrite();
        this.buffer[this.writepointer] = (byte)b;
        this.updatePipeStateAfterWrite(1);
    }

    protected synchronized void writeBytes(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len <= 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int wrote = 0;
        this.hasIncoming = true;
        try {
            while (wrote < len) {
                this.ensureAvailableForWrite();
                int writeEnd = this.writepointer < this.readpointer ? this.readpointer : this.buffer.length;
                int length = Math.min(len - wrote, writeEnd - this.writepointer);
                System.arraycopy(b, off + wrote, this.buffer, this.writepointer, length);
                wrote += length;
                this.updatePipeStateAfterWrite(length);
            }
        }
        finally {
            this.hasIncoming = false;
        }
    }
}

