/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.dwarf;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.cdt.utils.debug.DebugUnknownType;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.tools.DebugSym;
import org.eclipse.cdt.utils.debug.tools.DebugSymsRequestor;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class Dwarf {
    static final String DWARF_DEBUG_INFO = ".debug_info";
    static final String DWARF_DEBUG_ABBREV = ".debug_abbrev";
    static final String DWARF_DEBUG_ARANGES = ".debug_aranges";
    static final String DWARF_DEBUG_LINE = ".debug_line";
    static final String DWARF_DEBUG_FRAME = ".debug_frame";
    static final String DWARF_EH_FRAME = ".eh_frame";
    static final String DWARF_DEBUG_LOC = ".debug_loc";
    static final String DWARF_DEBUG_PUBNAMES = ".debug_pubnames";
    static final String DWARF_DEBUG_STR = ".debug_str";
    static final String DWARF_DEBUG_FUNCNAMES = ".debug_funcnames";
    static final String DWARF_DEBUG_TYPENAMES = ".debug_typenames";
    static final String DWARF_DEBUG_VARNAMES = ".debug_varnames";
    static final String DWARF_DEBUG_WEAKNAMES = ".debug_weaknames";
    static final String DWARF_DEBUG_MACINFO = ".debug_macinfo";
    static final String DWARF_DEBUG_MACRO = ".debug_macro";
    static final String DWARF_DEBUG_TYPES = ".debug_types";
    static final String DWARF_GNU_DEBUGLINK = ".gnu_debuglink";
    static final String DWARF_GNU_DEBUGALTLINK = ".gnu_debugaltlink";
    static final String[] DWARF_SCNNAMES = new String[]{".debug_info", ".debug_abbrev", ".debug_aranges", ".debug_line", ".debug_frame", ".eh_frame", ".debug_loc", ".debug_pubnames", ".debug_str", ".debug_funcnames", ".debug_typenames", ".debug_varnames", ".debug_weaknames", ".debug_macinfo"};
    static final String[] DWARF_ALT_SCNNAMES = new String[]{".debug_info", ".debug_types", ".debug_macro", ".debug_str"};
    Map<String, ByteBuffer> dwarfSections = new HashMap<String, ByteBuffer>();
    Map<String, ByteBuffer> dwarfAltSections = new HashMap<String, ByteBuffer>();
    Map<Integer, Map<Long, AbbreviationEntry>> abbreviationMaps = new HashMap<Integer, Map<Long, AbbreviationEntry>>();
    boolean isLE;
    CompileUnit currentCU;
    boolean printEnabled = true;
    int oldForm = 0;

    public Dwarf(String file) throws IOException {
        Elf exe = new Elf(file);
        this.init(exe);
        exe.dispose();
    }

    public Dwarf(Elf exe) throws IOException {
        this.init(exe);
    }

    public Dwarf(PE exe) throws IOException {
        this.init(exe);
    }

    public void init(Elf exe) throws IOException {
        ByteBuffer data;
        Elf.ELFhdr header = exe.getELFhdr();
        this.isLE = header.e_ident[5] == 1;
        Elf.Section[] sections = exe.getSections();
        Path debugInfoPath = new Path(exe.getFilename());
        Elf.Section gnuDebugLink = exe.getSectionByName(DWARF_GNU_DEBUGLINK);
        if (gnuDebugLink != null && (data = gnuDebugLink.mapSectionData()) != null) {
            try {
                String debugName = this.readString(data);
                if (debugName.length() > 0) {
                    File debugFile = null;
                    IPath p = debugInfoPath.removeLastSegments(1);
                    debugFile = p.append(debugName).toFile();
                    if (!debugFile.exists() && !(debugFile = p.append(".debug").append(debugName).toFile()).exists()) {
                        debugFile = new Path("/usr/lib/debug").append(p).append(debugName).toFile();
                    }
                    if (debugFile.exists()) {
                        Elf debugInfo = new Elf(debugFile.getCanonicalPath());
                        sections = debugInfo.getSections();
                        debugInfoPath = new Path(debugFile.getCanonicalPath());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                CCorePlugin.log(e);
            }
        }
        Elf.Section[] sectionArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            block21: {
                Elf.Section section = sectionArray[n2];
                String name = section.toString();
                if (name.equals(DWARF_GNU_DEBUGALTLINK)) {
                    ByteBuffer data2 = section.mapSectionData();
                    try {
                        Elf.Section[] altSections;
                        File altFile;
                        String altInfoName = this.readString(data2);
                        if (altInfoName.length() <= 0) break block21;
                        Path altPath = new Path(altInfoName);
                        if (!altPath.isAbsolute()) {
                            altPath = debugInfoPath.append((IPath)altPath);
                        }
                        if (!(altFile = altPath.toFile()).exists()) break block21;
                        Elf altInfo = new Elf(altFile.getCanonicalPath());
                        Elf.Section[] sectionArray2 = altSections = altInfo.getSections();
                        int n3 = altSections.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Elf.Section altSection = sectionArray2[n4];
                            String altName = altSection.toString();
                            String[] stringArray = DWARF_ALT_SCNNAMES;
                            int n5 = DWARF_ALT_SCNNAMES.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String element = stringArray[n6];
                                if (altName.equals(element)) {
                                    try {
                                        this.dwarfAltSections.put(element, altSection.mapSectionData());
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        CCorePlugin.log(e);
                                    }
                                }
                                ++n6;
                            }
                            ++n4;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        CCorePlugin.log(e);
                    }
                } else {
                    String[] stringArray = DWARF_SCNNAMES;
                    int n7 = DWARF_SCNNAMES.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        String element = stringArray[n8];
                        if (name.equals(element)) {
                            try {
                                this.dwarfSections.put(element, section.mapSectionData());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                CCorePlugin.log(e);
                            }
                        }
                        ++n8;
                    }
                }
            }
            ++n2;
        }
    }

    public void init(PE exe) throws IOException {
        this.isLE = true;
        Coff.SectionHeader[] sections = exe.getSectionHeaders();
        int i = 0;
        while (i < sections.length) {
            String name = new String(sections[i].s_name).trim();
            if (name.startsWith("/")) {
                int stringTableOffset = Integer.parseInt(name.substring(1));
                name = exe.getStringTableEntry(stringTableOffset);
            }
            String[] stringArray = DWARF_SCNNAMES;
            int n = DWARF_SCNNAMES.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (name.equals(element)) {
                    try {
                        this.dwarfSections.put(element, sections[i].mapSectionData());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        CCorePlugin.log(e);
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    int read_4_bytes(ByteBuffer in) throws IOException {
        try {
            byte[] bytes = new byte[4];
            in.get(bytes);
            return this.read_4_bytes(bytes);
        }
        catch (Exception exception) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
        }
    }

    int read_4_bytes(byte[] bytes) throws IndexOutOfBoundsException {
        if (this.isLE) {
            return (bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
        }
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    long read_8_bytes(ByteBuffer in) throws IOException {
        try {
            byte[] bytes = new byte[8];
            in.get(bytes);
            return this.read_8_bytes(bytes);
        }
        catch (Exception exception) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
        }
    }

    long read_8_bytes(byte[] bytes) throws IndexOutOfBoundsException {
        if (this.isLE) {
            return (bytes[7] & 0xFF) << 56 | (bytes[6] & 0xFF) << 48 | (bytes[5] & 0xFF) << 40 | (bytes[4] & 0xFF) << 32 | (bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
        }
        return (bytes[0] & 0xFF) << 56 | (bytes[1] & 0xFF) << 48 | (bytes[2] & 0xFF) << 40 | (bytes[3] & 0xFF) << 32 | (bytes[4] & 0xFF) << 24 | (bytes[5] & 0xFF) << 16 | (bytes[6] & 0xFF) << 8 | bytes[7] & 0xFF;
    }

    short read_2_bytes(ByteBuffer in) throws IOException {
        try {
            byte[] bytes = new byte[2];
            in.get(bytes);
            return this.read_2_bytes(bytes);
        }
        catch (Exception exception) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.missingBytes"));
        }
    }

    short read_2_bytes(byte[] bytes) throws IndexOutOfBoundsException {
        if (this.isLE) {
            return (short)(((bytes[1] & 0xFF) << 8) + (bytes[0] & 0xFF));
        }
        return (short)(((bytes[0] & 0xFF) << 8) + (bytes[1] & 0xFF));
    }

    long read_unsigned_leb128(ByteBuffer in) throws IOException {
        long result = 0L;
        int shift = 0;
        while (true) {
            byte b = in.get();
            if (!in.hasRemaining()) break;
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    long read_signed_leb128(ByteBuffer in) throws IOException {
        byte b;
        long result = 0L;
        int shift = 0;
        int size = 32;
        do {
            b = in.get();
            if (!in.hasRemaining()) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.noData"));
            }
            result |= (long)(b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        if (shift < size && (b & 0x40) != 0) {
            result |= (long)(-(1 << shift));
        }
        return result;
    }

    public void parse(IDebugEntryRequestor requestor) {
        this.parseDebugInfo(requestor);
    }

    void parseDebugInfo(IDebugEntryRequestor requestor) {
        ByteBuffer data = this.dwarfSections.get(DWARF_DEBUG_INFO);
        if (data != null) {
            try {
                while (data.hasRemaining()) {
                    CompilationUnitHeader header = new CompilationUnitHeader();
                    InitialLengthValue sectionLength = this.readInitialLengthField(data);
                    header.length = sectionLength.length;
                    header.offsetSize = sectionLength.offsetSize;
                    header.version = this.read_2_bytes(data);
                    header.abbreviationOffset = header.offsetSize == 8 ? (int)this.read_8_bytes(data) : this.read_4_bytes(data);
                    header.addressSize = data.get();
                    if (this.printEnabled) {
                        System.out.println("Compilation Unit @ " + Long.toHexString(data.position()));
                        System.out.println(header);
                    }
                    Map<Long, AbbreviationEntry> abbrevs = this.parseDebugAbbreviation(header);
                    ByteBuffer entryBuffer = data.slice();
                    entryBuffer.limit((int)header.length - (header.offsetSize == 8 ? 11 : 7));
                    this.parseDebugInfoEntry(requestor, entryBuffer, abbrevs, header);
                    data.position(data.position() + (int)header.length - (header.offsetSize == 8 ? 11 : 7));
                    if (!this.printEnabled) continue;
                    System.out.println();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    InitialLengthValue readInitialLengthField(ByteBuffer data) throws IOException {
        InitialLengthValue info = new InitialLengthValue();
        info.length = (long)this.read_4_bytes(data) & 0xFFFFFFFFL;
        if (info.length == 0xFFFFFFFFL) {
            info.length = this.read_8_bytes(data);
            info.offsetSize = (byte)8;
        } else if (info.length == 0L) {
            info.length = this.read_8_bytes(data);
            info.offsetSize = (byte)8;
        } else {
            info.offsetSize = (byte)4;
        }
        return info;
    }

    Map<Long, AbbreviationEntry> parseDebugAbbreviation(CompilationUnitHeader header) throws IOException {
        Integer key = new Integer(header.abbreviationOffset);
        Map<Long, AbbreviationEntry> abbrevs = this.abbreviationMaps.get(key);
        if (abbrevs == null) {
            abbrevs = new HashMap<Long, AbbreviationEntry>();
            this.abbreviationMaps.put(key, abbrevs);
            ByteBuffer data = this.dwarfSections.get(DWARF_DEBUG_ABBREV);
            if (data != null) {
                data.position(header.abbreviationOffset);
                while (data.remaining() > 0) {
                    long code = this.read_unsigned_leb128(data);
                    if (code == 0L) break;
                    long tag = this.read_unsigned_leb128(data);
                    byte hasChildren = data.get();
                    AbbreviationEntry entry = new AbbreviationEntry(code, tag, hasChildren);
                    if (this.printEnabled) {
                        System.out.println("\tAbrev Entry: " + code + " " + Long.toHexString(entry.tag) + " " + entry.hasChildren);
                    }
                    long name = 0L;
                    long form = 0L;
                    do {
                        name = this.read_unsigned_leb128(data);
                        form = this.read_unsigned_leb128(data);
                        if (name != 0L) {
                            entry.attributes.add(new Attribute(name, form));
                        }
                        if (!this.printEnabled) continue;
                        System.out.println("\t\t " + Long.toHexString(name) + " " + Long.toHexString(form));
                    } while (name != 0L && form != 0L);
                    abbrevs.put(new Long(code), entry);
                }
            }
        }
        return abbrevs;
    }

    void parseDebugInfoEntry(IDebugEntryRequestor requestor, ByteBuffer in, Map<Long, AbbreviationEntry> abbrevs, CompilationUnitHeader header) throws IOException {
        while (in.remaining() > 0) {
            long code = this.read_unsigned_leb128(in);
            AbbreviationEntry entry = abbrevs.get(new Long(code));
            if (entry == null) continue;
            int len = entry.attributes.size();
            ArrayList<AttributeValue> list = new ArrayList<AttributeValue>(len);
            try {
                int i = 0;
                while (i < len) {
                    Attribute attr = entry.attributes.get(i);
                    Object obj = this.readAttribute((int)attr.form, in, header);
                    list.add(new AttributeValue(attr, obj));
                    ++i;
                }
            }
            catch (IOException iOException) {}
            this.processDebugInfoEntry(requestor, entry, list);
        }
    }

    Object readAttribute(int form, ByteBuffer in, CompilationUnitHeader header) throws IOException {
        Object obj = null;
        switch (form) {
            case 1: {
                obj = this.readAddress(in, header, false);
                break;
            }
            case 16: {
                obj = this.readAddress(in, header, true);
                break;
            }
            case 9: {
                int size = (int)this.read_unsigned_leb128(in);
                byte[] bytes = new byte[size];
                in.get(bytes);
                obj = bytes;
                break;
            }
            case 10: {
                byte size = in.get();
                byte[] bytes = new byte[size & 0xFF];
                in.get(bytes);
                obj = bytes;
                break;
            }
            case 3: {
                short size = this.read_2_bytes(in);
                byte[] bytes = new byte[size & 0xFFFF];
                in.get(bytes);
                obj = bytes;
                break;
            }
            case 4: {
                int size = this.read_4_bytes(in);
                byte[] bytes = new byte[size];
                in.get(bytes);
                obj = bytes;
                break;
            }
            case 11: {
                obj = new Byte(in.get());
                break;
            }
            case 5: {
                obj = new Short(this.read_2_bytes(in));
                break;
            }
            case 6: {
                obj = new Integer(this.read_4_bytes(in));
                break;
            }
            case 7: {
                obj = new Long(this.read_8_bytes(in));
                break;
            }
            case 13: {
                obj = new Long(this.read_signed_leb128(in));
                break;
            }
            case 15: {
                obj = new Long(this.read_unsigned_leb128(in));
                break;
            }
            case 8: {
                byte c;
                StringBuffer sb = new StringBuffer();
                while ((c = in.get()) != -1) {
                    if (c == 0) break;
                    sb.append((char)c);
                }
                obj = sb.toString();
                break;
            }
            case 12: {
                obj = new Byte(in.get());
                break;
            }
            case 14: {
                long offset = header.offsetSize == 8 ? this.read_8_bytes(in) : (long)this.read_4_bytes(in) & 0xFFFFFFFFL;
                ByteBuffer data = this.dwarfSections.get(DWARF_DEBUG_STR);
                if (data == null) {
                    obj = new String();
                    break;
                }
                if (offset < 0L || offset > (long)data.capacity()) {
                    obj = new String();
                    break;
                }
                StringBuffer sb = new StringBuffer();
                data.position((int)offset);
                while (data.hasRemaining()) {
                    byte c = data.get();
                    if (c == 0) break;
                    sb.append((char)c);
                }
                obj = sb.toString();
                break;
            }
            case 7969: {
                long offset = header.offsetSize == 8 ? this.read_8_bytes(in) : (long)this.read_4_bytes(in) & 0xFFFFFFFFL;
                ByteBuffer data = this.dwarfAltSections.get(DWARF_DEBUG_STR);
                if (data == null) {
                    obj = new String();
                    break;
                }
                if (offset < 0L || offset > (long)data.capacity()) {
                    obj = new String();
                    break;
                }
                StringBuffer sb = new StringBuffer();
                data.position((int)offset);
                while (data.hasRemaining()) {
                    byte c = data.get();
                    if (c == 0) break;
                    sb.append((char)c);
                }
                obj = sb.toString();
                break;
            }
            case 17: {
                obj = new Byte(in.get());
                break;
            }
            case 18: {
                obj = new Short(this.read_2_bytes(in));
                break;
            }
            case 19: {
                obj = new Integer(this.read_4_bytes(in));
                break;
            }
            case 20: {
                obj = new Long(this.read_8_bytes(in));
                break;
            }
            case 21: {
                obj = new Long(this.read_unsigned_leb128(in));
                break;
            }
            case 22: {
                int f = (int)this.read_unsigned_leb128(in);
                return this.readAttribute(f, in, header);
            }
            case 7968: {
                if (header.offsetSize == 8) {
                    obj = new Long(this.read_8_bytes(in));
                    break;
                }
                obj = new Long((long)this.read_4_bytes(in) & 0xFFFFFFFFL);
                break;
            }
            case 23: {
                if (header.offsetSize == 8) {
                    obj = new Long(this.read_8_bytes(in));
                    break;
                }
                obj = new Long((long)this.read_4_bytes(in) & 0xFFFFFFFFL);
                break;
            }
            case 24: {
                long size = this.read_unsigned_leb128(in);
                byte[] bytes = new byte[(int)size];
                in.get(bytes);
                obj = bytes;
                break;
            }
            case 25: {
                obj = (byte)1;
                break;
            }
            case 32: {
                obj = new Long(this.read_8_bytes(in));
                break;
            }
            default: {
                if (!this.printEnabled) break;
                System.out.println("Default for " + form);
                System.out.println("Last form is " + this.oldForm);
            }
        }
        this.oldForm = form;
        return obj;
    }

    void processDebugInfoEntry(IDebugEntryRequestor requestor, AbbreviationEntry entry, List<AttributeValue> list) {
        int len = list.size();
        int tag = (int)entry.tag;
        if (this.printEnabled) {
            System.out.println("Abbrev Number " + entry.code);
        }
        int i = 0;
        while (i < len) {
            AttributeValue av = list.get(i);
            if (this.printEnabled) {
                System.out.println(av);
            }
            switch (tag) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 11: {
                    break;
                }
                case 13: {
                    break;
                }
                case 15: {
                    break;
                }
                case 16: {
                    break;
                }
                case 17: {
                    this.processCompileUnit(requestor, list);
                    break;
                }
                case 19: {
                    break;
                }
                case 21: {
                    break;
                }
                case 22: {
                    break;
                }
                case 23: {
                    break;
                }
                case 24: {
                    break;
                }
                case 28: {
                    break;
                }
                case 31: {
                    break;
                }
                case 34: {
                    break;
                }
                case 36: {
                    break;
                }
                case 37: {
                    break;
                }
                case 38: {
                    break;
                }
                case 40: {
                    break;
                }
                case 41: {
                    break;
                }
                case 42: {
                    break;
                }
                case 46: {
                    this.processSubProgram(requestor, list);
                    break;
                }
                case 47: {
                    break;
                }
                case 48: {
                    break;
                }
                case 49: {
                    break;
                }
                case 50: {
                    break;
                }
                case 52: {
                    break;
                }
            }
            ++i;
        }
    }

    Long readAddress(ByteBuffer in, CompilationUnitHeader header, boolean reference) throws IOException {
        long value = 0L;
        byte size = reference ? (header.version < 3 ? header.addressSize : header.offsetSize) : header.addressSize;
        switch (size) {
            case 2: {
                value = this.read_2_bytes(in);
                break;
            }
            case 4: {
                value = this.read_4_bytes(in);
                break;
            }
            case 8: {
                value = this.read_8_bytes(in);
            }
        }
        return new Long(value);
    }

    String readString(ByteBuffer data) {
        StringBuffer sb = new StringBuffer();
        while (data.hasRemaining()) {
            byte c = data.get();
            if (c == 0) break;
            sb.append((char)c);
        }
        String str = sb.toString();
        return str;
    }

    void processSubProgram(IDebugEntryRequestor requestor, List<AttributeValue> list) {
        long lowPC = 0L;
        long highPC = 0L;
        String funcName = "";
        boolean isExtern = false;
        int i = 0;
        while (i < list.size()) {
            AttributeValue av = list.get(i);
            try {
                int name = (int)av.attribute.name;
                switch (name) {
                    case 17: {
                        lowPC = ((Number)av.value).longValue();
                        break;
                    }
                    case 18: {
                        highPC = ((Number)av.value).longValue();
                        break;
                    }
                    case 3: {
                        funcName = (String)av.value;
                        break;
                    }
                    case 63: {
                        isExtern = ((Number)av.value).intValue() > 0;
                    }
                }
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
        requestor.enterFunction(funcName, new DebugUnknownType(""), isExtern, lowPC);
        requestor.exitFunction(highPC);
    }

    void processCompileUnit(IDebugEntryRequestor requestor, List<AttributeValue> list) {
        if (this.currentCU != null) {
            requestor.exitCompilationUnit(this.currentCU.highPC);
        }
        this.currentCU = new CompileUnit();
        int i = 0;
        while (i < list.size()) {
            AttributeValue av = list.get(i);
            try {
                int name = (int)av.attribute.name;
                switch (name) {
                    case 17: {
                        this.currentCU.lowPC = ((Number)av.value).longValue();
                        break;
                    }
                    case 18: {
                        this.currentCU.highPC = ((Number)av.value).longValue();
                        break;
                    }
                    case 3: {
                        this.currentCU.name = (String)av.value;
                        break;
                    }
                    case 19: {
                        this.currentCU.language = ((Number)av.value).intValue();
                        break;
                    }
                    case 16: {
                        this.currentCU.stmtList = ((Number)av.value).intValue();
                        break;
                    }
                    case 67: {
                        this.currentCU.macroInfo = ((Number)av.value).intValue();
                        break;
                    }
                    case 27: {
                        this.currentCU.compDir = (String)av.value;
                        break;
                    }
                    case 37: {
                        this.currentCU.producer = (String)av.value;
                    }
                }
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
        requestor.enterCompilationUnit(this.currentCU.name, this.currentCU.lowPC);
    }

    public static void main(String[] args) {
        try {
            DebugSym[] entries;
            DebugSymsRequestor symreq = new DebugSymsRequestor();
            Dwarf dwarf = new Dwarf(args[0]);
            dwarf.parse(symreq);
            DebugSym[] debugSymArray = entries = symreq.getEntries();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                DebugSym entry = debugSymArray[n2];
                System.out.println(entry);
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class AbbreviationEntry {
        long code;
        long tag;
        byte hasChildren;
        List<Attribute> attributes;

        AbbreviationEntry(long c, long t, byte h) {
            this.code = c;
            this.tag = t;
            this.hasChildren = h;
            this.attributes = new ArrayList<Attribute>();
        }
    }

    class Attribute {
        long name;
        long form;

        Attribute(long n, long f) {
            this.name = n;
            this.form = f;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("name: " + Long.toHexString(this.name));
            sb.append(" value: " + Long.toHexString(this.form));
            return sb.toString();
        }
    }

    class AttributeValue {
        Attribute attribute;
        Object value;

        AttributeValue(Attribute a, Object o) {
            this.attribute = a;
            this.value = o;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.attribute.toString()).append(' ');
            if (this.value != null) {
                Class<?> clazz = this.value.getClass();
                if (clazz.isArray()) {
                    int len = Array.getLength(this.value);
                    sb.append(len).append(' ');
                    sb.append(clazz.getComponentType().toString());
                    sb.append(':');
                    int i = 0;
                    while (i < len) {
                        byte b = Array.getByte(this.value, i);
                        sb.append(' ').append(Integer.toHexString(b));
                        ++i;
                    }
                } else if (this.value instanceof Number) {
                    Number n = (Number)this.value;
                    sb.append(Long.toHexString(n.longValue()));
                } else if (this.value instanceof String) {
                    sb.append(this.value);
                } else {
                    sb.append(this.value);
                }
            }
            return sb.toString();
        }
    }

    class CompilationUnitHeader {
        long length;
        short version;
        int abbreviationOffset;
        byte addressSize;
        byte offsetSize;

        CompilationUnitHeader() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Length: " + this.length).append("\n");
            sb.append("Version: " + this.version).append("\n");
            sb.append("Abbreviation: " + this.abbreviationOffset).append("\n");
            sb.append("Address size: " + this.addressSize).append("\n");
            sb.append("Offset size: " + this.offsetSize).append("\n");
            return sb.toString();
        }
    }

    class CompileUnit {
        long lowPC;
        long highPC;
        int stmtList;
        String name;
        int language;
        int macroInfo;
        String compDir;
        String producer;
        int identifierCase;

        CompileUnit() {
        }
    }

    class InitialLengthValue {
        long length;
        byte offsetSize;

        InitialLengthValue() {
        }
    }
}

