/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.CSSLengthValueHandler;
import org.eclipse.birt.report.model.api.ComplexValueHandle;
import org.eclipse.birt.report.model.api.ComputedValueHandler;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FontSizeValueHandler;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.metadata.DimensionPropertyType;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public class DimensionHandle
extends ComplexValueHandle {
    public DimensionHandle(DesignElementHandle element, StructureContext context) {
        super(element, context);
        assert (context.getPropDefn().getType() instanceof DimensionPropertyType);
    }

    public DimensionHandle(DesignElementHandle element, MemberRef context) {
        super(element, context);
        assert (context.getPropDefn().getType() instanceof DimensionPropertyType);
    }

    public DimensionHandle(DesignElementHandle element, ElementPropertyDefn thePropDefn) {
        super(element, thePropDefn);
        assert (thePropDefn.getType() instanceof DimensionPropertyType);
    }

    public boolean isKeyword() {
        IChoiceSet choiceSet = this.propDefn.getChoices();
        return choiceSet != null && choiceSet.contains(this.getStringValue());
    }

    public double getMeasure() {
        if (this.isKeyword()) {
            return 0.0;
        }
        DimensionValue value = (DimensionValue)this.getValue();
        if (value != null) {
            return value.getMeasure();
        }
        return 0.0;
    }

    public IChoice[] getAllowedUnits() {
        if (this.memberContext == null) {
            return this.propDefn.getAllowedUnits().getChoices();
        }
        return this.memberContext.getPropDefn().getAllowedUnits().getChoices();
    }

    public String getUnits() {
        if (this.isKeyword()) {
            return "";
        }
        DimensionValue value = (DimensionValue)this.getValue();
        if (value != null) {
            return value.getUnits();
        }
        return null;
    }

    public void setAbsolute(double value) throws SemanticException {
        this.setValue(new Double(value));
    }

    public DimensionValue getAbsoluteValue() {
        Object value = this.getValue();
        if (value instanceof String) {
            if ("fontSize".equals(this.getDefn().getName())) {
                FontSizeValueHandler fontSizeValueHandle = new FontSizeValueHandler(this);
                return fontSizeValueHandle.convertFontSizeConstant((String)value);
            }
        } else {
            assert (value instanceof DimensionValue || value == null);
            DimensionValue dimensionValue = (DimensionValue)value;
            if (dimensionValue != null && CSSLengthValueHandler.isAbsoluteUnit(dimensionValue.getUnits())) {
                return dimensionValue;
            }
            if (!this.propDefn.isStyleProperty() || this.getElement().isStyle()) {
                return null;
            }
            if ("fontSize".equalsIgnoreCase(this.getPropertyDefn().getName())) {
                FontSizeValueHandler fontSizeValueHandler = new FontSizeValueHandler(this);
                return fontSizeValueHandler.getAbsoluteValueForFontSize(dimensionValue);
            }
            ComputedValueHandler computedValueHandle = new ComputedValueHandler(this);
            return computedValueHandle.getAbsoluteValueForLength(dimensionValue);
        }
        assert (false);
        return null;
    }

    public String getDefaultUnit() {
        ElementPropertyDefn defn = (ElementPropertyDefn)this.getPropertyDefn();
        if (defn.getTypeCode() == 3) {
            String unit = defn.getDefaultUnit();
            if (!StringUtil.isBlank(unit)) {
                return unit;
            }
            unit = this.getModule().getUnits();
            if (!StringUtil.isBlank(unit)) {
                return unit;
            }
            if (this.getModule().getSession() != null) {
                return this.getModule().getSession().getUnits();
            }
        }
        return "";
    }
}

