/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.model.TimelineKind;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum CuptiActivityKind {
    CUPTI_ACTIVITY_KIND_INVALID(0),
    CUPTI_ACTIVITY_KIND_MEMCPY(1),
    CUPTI_ACTIVITY_KIND_MEMSET(2),
    CUPTI_ACTIVITY_KIND_KERNEL(3),
    CUPTI_ACTIVITY_KIND_DRIVER(4),
    CUPTI_ACTIVITY_KIND_RUNTIME(5),
    CUPTI_ACTIVITY_KIND_EVENT(6),
    CUPTI_ACTIVITY_KIND_METRIC(7),
    CUPTI_ACTIVITY_KIND_DEVICE(8),
    CUPTI_ACTIVITY_KIND_CONTEXT(9),
    CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL(10),
    CUPTI_ACTIVITY_KIND_NAME(11),
    CUPTI_ACTIVITY_KIND_MARKER(12),
    CUPTI_ACTIVITY_KIND_MARKER_DATA(13),
    CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR(14),
    CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS(15),
    CUPTI_ACTIVITY_KIND_BRANCH(16),
    CUPTI_ACTIVITY_KIND_OVERHEAD(17),
    CUPTI_ACTIVITY_KIND_CDP_KERNEL(18),
    CUPTI_ACTIVITY_KIND_PREEMPTION(19),
    CUPTI_ACTIVITY_KIND_ENVIRONMENT(20),
    CUPTI_ACTIVITY_KIND_EVENT_INSTANCE(21),
    CUPTI_ACTIVITY_KIND_MEMCPY2(22),
    CUPTI_ACTIVITY_KIND_METRIC_INSTANCE(23),
    CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION(24),
    CUPTI_ACTIVITY_KIND_UVM_COUNTER(25),
    CUPTI_ACTIVITY_KIND_FUNCTION(26),
    CUPTI_ACTIVITY_KIND_MODULE(27),
    CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE(28),
    CUPTI_ACTIVITY_KIND_SHARED_ACCESS(29),
    CUPTI_ACTIVITY_KIND_PC_SAMPLING(30),
    CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO(31),
    CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION(32),
    CUPTI_ACTIVITY_KIND_OPENACC_DATA(33),
    CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH(34),
    CUPTI_ACTIVITY_KIND_OPENACC_OTHER(35),
    CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION(39),
    CUPTI_ACTIVITY_KIND_NVLINK(40),
    CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT(41),
    CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCE(42),
    CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC(43),
    CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE(44),
    CUPTI_ACTIVITY_KIND_MEMORY(45),
    CUPTI_ACTIVITY_KIND_OPENMP(47),
    CUPTI_ACTIVITY_KIND_PTHREAD(1000);

    private int code;
    private static Map<Integer, CuptiActivityKind> codeMap;

    static {
        codeMap = new HashMap<Integer, CuptiActivityKind>();
        CuptiActivityKind[] cuptiActivityKindArray = CuptiActivityKind.values();
        int n = cuptiActivityKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiActivityKind res = cuptiActivityKindArray[n2];
            codeMap.put(res.getCode(), res);
            ++n2;
        }
    }

    private CuptiActivityKind(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static boolean isFakeCuptiActivity(CuptiActivityKind kind) {
        return kind.getCode() >= CuptiActivityKind.CUPTI_ACTIVITY_KIND_PTHREAD.code;
    }

    public static EnumSet<CuptiActivityKind> getSetFromTimelineKind(TimelineKind timelineKind) {
        EnumSet<CuptiActivityKind> set = EnumSet.noneOf(CuptiActivityKind.class);
        switch (timelineKind) {
            case PROCESS: 
            case THREAD: 
            case DEVICE: 
            case CONTEXT: {
                break;
            }
            case DRIVER: {
                set.add(CUPTI_ACTIVITY_KIND_DRIVER);
                break;
            }
            case KERNELS: 
            case KERNEL: 
            case STREAMS: 
            case STREAM: {
                set.add(CUPTI_ACTIVITY_KIND_CDP_KERNEL);
                set.add(CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL);
                set.add(CUPTI_ACTIVITY_KIND_KERNEL);
                break;
            }
            case MARKER: {
                set.add(CUPTI_ACTIVITY_KIND_MARKER);
                set.add(CUPTI_ACTIVITY_KIND_MARKER_DATA);
                break;
            }
            case MEMCPY_HTOD: 
            case MEMCPY_DTOH: 
            case MEMCPY_DTOD: 
            case MEMCPY_PTOP: {
                set.add(CUPTI_ACTIVITY_KIND_MEMCPY);
                set.add(CUPTI_ACTIVITY_KIND_MEMCPY2);
                break;
            }
            case OVERHEADS: {
                set.add(CUPTI_ACTIVITY_KIND_OVERHEAD);
                break;
            }
            case RUNTIME: {
                set.add(CUPTI_ACTIVITY_KIND_RUNTIME);
                break;
            }
            case UVM: 
            case UVM_MEMCPY_HTOD: 
            case UVM_MEMCPY_DTOH: 
            case UVM_PAGE_FAULT: 
            case UVM_GPU_PAGE_FAULT: {
                set.add(CUPTI_ACTIVITY_KIND_UVM_COUNTER);
                break;
            }
            case OPENACC: {
                set.add(CUPTI_ACTIVITY_KIND_OPENACC_DATA);
                set.add(CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH);
                set.add(CUPTI_ACTIVITY_KIND_OPENACC_OTHER);
                break;
            }
            case PTHREAD: {
                set.add(CUPTI_ACTIVITY_KIND_PTHREAD);
            }
        }
        return set;
    }

    public static long getMaskFromSet(EnumSet<CuptiActivityKind> set) {
        long mask = 0L;
        for (CuptiActivityKind k : set) {
            mask &= (long)(1 << k.getCode());
        }
        return mask;
    }

    public boolean isAnalysisKind() {
        return CUPTI_ACTIVITY_KIND_EVENT.equals((Object)this) || CUPTI_ACTIVITY_KIND_METRIC.equals((Object)this) || CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR.equals((Object)this) || CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS.equals((Object)this) || CUPTI_ACTIVITY_KIND_BRANCH.equals((Object)this) || CUPTI_ACTIVITY_KIND_EVENT_INSTANCE.equals((Object)this) || CUPTI_ACTIVITY_KIND_METRIC_INSTANCE.equals((Object)this) || CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION.equals((Object)this) || CUPTI_ACTIVITY_KIND_SHARED_ACCESS.equals((Object)this) || CUPTI_ACTIVITY_KIND_PC_SAMPLING.equals((Object)this) || CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO.equals((Object)this) || CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION.equals((Object)this);
    }

    public static CuptiActivityKind valueOf(String string) {
        return Enum.valueOf(CuptiActivityKind.class, string);
    }
}

