/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ui.ITitleImageLoadingDelegatee;
import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

public class TitleImageLoadingDelegator {
    private ImageLoader imageLoader = null;
    private ImageData originalImageData;
    private Thread changingImageThread = null;
    private int isLoadingSemaphore = 0;
    private static final String IMAGE_FILENAME = "/icons/en/circle_loader.gif";
    private static final String THREAD_NAME = "changing icon";
    private static final long LOADING_INTERVAL_MS = 50L;

    private ImageData getImageDataFromDelegatee(ITitleImageLoadingDelegatee delegatee) {
        Image originalImage = delegatee.delegateGetTitleImage();
        if (originalImage == null) {
            return null;
        }
        return originalImage.getImageData();
    }

    public TitleImageLoadingDelegator(ITitleImageLoadingDelegatee delegatee) {
        InputStream imageStream = this.getClass().getResourceAsStream(IMAGE_FILENAME);
        if (imageStream != null) {
            this.imageLoader = new ImageLoader();
            this.imageLoader.load(imageStream);
        }
        this.originalImageData = this.getImageDataFromDelegatee(delegatee);
    }

    public synchronized void startLoading(final ITitleImageLoadingDelegatee delegatee) {
        ++this.isLoadingSemaphore;
        if (this.imageLoader == null) {
            return;
        }
        if (this.originalImageData == null) {
            this.originalImageData = this.getImageDataFromDelegatee(delegatee);
        }
        if (this.changingImageThread != null && this.changingImageThread.isAlive()) {
            return;
        }
        this.changingImageThread = new Thread(THREAD_NAME){

            @Override
            public void run() {
                int imageIndex = 0;
                long lastUpdate = System.currentTimeMillis();
                while (!Thread.interrupted()) {
                    long timeSinceLastUpdate = System.currentTimeMillis() - lastUpdate;
                    if (timeSinceLastUpdate < 50L) {
                        try {
                            1.sleep(50L - timeSinceLastUpdate);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                    lastUpdate += timeSinceLastUpdate;
                    final int index = imageIndex++;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Image image = new Image((Device)Display.getDefault(), ((TitleImageLoadingDelegator)(this).TitleImageLoadingDelegator.this).imageLoader.data[index]);
                            delegatee.delegateSetTitleImage(image);
                        }
                    });
                    if (imageIndex < ((TitleImageLoadingDelegator)TitleImageLoadingDelegator.this).imageLoader.data.length) continue;
                    imageIndex = 0;
                }
            }
        };
        this.changingImageThread.start();
    }

    public synchronized void stopLoading(final ITitleImageLoadingDelegatee delegatee) {
        if (this.isLoadingSemaphore > 0) {
            --this.isLoadingSemaphore;
        }
        if (this.isLoadingSemaphore > 0) {
            return;
        }
        if (this.imageLoader == null) {
            return;
        }
        if (this.changingImageThread != null) {
            this.changingImageThread.interrupt();
            try {
                this.changingImageThread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            this.changingImageThread = null;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Image originalImage = new Image((Device)Display.getDefault(), TitleImageLoadingDelegator.this.originalImageData);
                delegatee.delegateSetTitleImage(originalImage);
            }
        });
    }
}

