/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeCreationContext;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludePreferences;
import org.eclipse.core.runtime.CoreException;

public class BindingClassifier {
    private static final String[] TEMPLATES_ALLOWING_INCOMPLETE_ARGUMENT_TYPE = new String[]{"enable_shared_from_this", "declval", "default_delete", "shared_ptr", "unique_ptr", "weak_ptr"};
    private final IncludeCreationContext fContext;
    private final IncludePreferences fPreferences;
    private final Set<IBinding> fBindingsToDefine;
    private final Set<IBinding> fBindingsToForwardDeclare;
    private IASTTranslationUnit fAst;
    private final BindingCollector fBindingCollector;
    private final Set<IBinding> fProcessedDefinedBindings;
    private final Set<IBinding> fProcessedDeclaredBindings;

    public BindingClassifier(IncludeCreationContext context) {
        this.fContext = context;
        this.fPreferences = context.getPreferences();
        this.fBindingsToDefine = new HashSet<IBinding>();
        this.fBindingsToForwardDeclare = new HashSet<IBinding>();
        this.fProcessedDefinedBindings = new HashSet<IBinding>();
        this.fProcessedDeclaredBindings = new HashSet<IBinding>();
        this.fBindingCollector = new BindingCollector();
    }

    public void classifyNodeContents(IASTNode node) {
        if (this.fAst == null) {
            this.fAst = node.getTranslationUnit();
        }
        node.accept((ASTVisitor)this.fBindingCollector);
    }

    public Set<IBinding> getBindingsToDefine() {
        return this.fBindingsToDefine;
    }

    public Set<IBinding> getBindingsToForwardDeclare() {
        return this.fBindingsToForwardDeclare;
    }

    /*
     * Unable to fully structure code
     */
    private void processFunctionParameters(IFunction function, IASTInitializerClause[] arguments) {
        functionIsDefined = this.fProcessedDefinedBindings.contains(function);
        parameters = function.getParameters();
        i = 0;
        while (i < parameters.length && i < arguments.length) {
            parameterType = parameters[i].getType();
            argument = arguments[i];
            if (!(argument instanceof IASTExpression)) ** GOTO lbl14
            argumentType = ((IASTExpression)argument).getExpressionType();
            if (!this.isTypeDefinitionRequiredForConversion(argumentType, parameterType)) {
                if (!functionIsDefined) {
                    this.declareType(parameterType);
                }
            } else {
                this.defineTypeExceptTypedefOrNonFixedEnum(argumentType);
lbl14:
                // 2 sources

                if (!((parameterType = SemanticUtil.getNestedType((IType)parameterType, (int)20)) instanceof ICPPClassType) || this.fAst.getDeclarationsInAST((IBinding)function).length != 0 || !this.hasConvertingConstructor((ICPPClassType)parameterType, argument)) {
                    this.defineTypeExceptTypedefOrNonFixedEnum(parameterType);
                } else if (!functionIsDefined) {
                    this.declareType(parameterType);
                }
            }
            ++i;
        }
    }

    private boolean isTypeDefinitionRequiredForConversion(IType sourceType, IType targetType) {
        if (!(targetType instanceof IPointerType) && !(targetType instanceof ICPPReferenceType)) {
            return true;
        }
        if (targetType instanceof IPointerType && Conversions.isNullPointerConstant((IType)sourceType)) {
            return false;
        }
        sourceType = SemanticUtil.getNestedType((IType)sourceType, (int)20);
        targetType = SemanticUtil.getNestedType((IType)targetType, (int)20);
        if (sourceType instanceof IPointerType && targetType instanceof IPointerType) {
            sourceType = SemanticUtil.getNestedType((IType)((IPointerType)sourceType).getType(), (int)16);
            targetType = SemanticUtil.getNestedType((IType)((IPointerType)targetType).getType(), (int)16);
        }
        return !sourceType.isSameType(targetType);
    }

    private boolean hasConvertingConstructor(ICPPClassType classType, IASTInitializerClause argument) {
        CPPASTName astName = new CPPASTName();
        astName.setName(classType.getNameCharArray());
        astName.setOffsetAndLength((ASTNode)argument);
        CPPASTIdExpression idExp = new CPPASTIdExpression((IASTName)astName);
        idExp.setParent(argument.getParent());
        idExp.setPropertyInParent(IASTFunctionCallExpression.FUNCTION_NAME);
        LookupData lookupData = new LookupData((IASTName)astName);
        lookupData.setFunctionArguments(false, new IASTInitializerClause[]{argument});
        lookupData.qualified = true;
        try {
            IBinding constructor = CPPSemantics.resolveFunction((LookupData)lookupData, (ICPPFunction[])ClassTypeHelper.getConstructors((ICPPClassType)classType, (IASTNode)argument), (boolean)false);
            if (constructor instanceof ICPPConstructor && !((ICPPConstructor)constructor).isExplicit()) {
                return true;
            }
        }
        catch (DOMException dOMException) {}
        return false;
    }

    private boolean hasConvertingConstructor(ICPPClassType classType, IASTNode point) {
        ICPPConstructor[] constructors;
        ICPPConstructor[] iCPPConstructorArray = constructors = ClassTypeHelper.getConstructors((ICPPClassType)classType, (IASTNode)point);
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            IType type;
            ICPPParameter[] parameters;
            ICPPConstructor constructor = iCPPConstructorArray[n2];
            if (!(constructor.isExplicit() || (parameters = constructor.getParameters()).length == 0 || CPPFunction.getRequiredArgumentCount((ICPPParameter[])parameters) > 1 || (type = parameters[0].getType()) instanceof IBasicType && ((IBasicType)type).getKind() == IBasicType.Kind.eVoid || classType.isSameType(type = SemanticUtil.getNestedType((IType)type, (int)20)))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isTypeWithConvertingConstructor(IType type, IASTNode point) {
        return (type = SemanticUtil.getNestedType((IType)type, (int)20)) instanceof ICPPClassType && this.hasConvertingConstructor((ICPPClassType)type, point);
    }

    private Set<IBinding> getRequiredBindings(IBinding binding) {
        if (binding instanceof ICPPNamespace) {
            return Collections.emptySet();
        }
        ArrayDeque<IBinding> queue = new ArrayDeque<IBinding>();
        this.addRequiredBindings(binding, queue);
        HashSet<IBinding> bindings = new HashSet<IBinding>();
        while ((binding = (IBinding)queue.poll()) != null) {
            if (binding instanceof ICPPSpecialization) {
                ICPPTemplateParameterMap parameterMap = ((ICPPSpecialization)binding).getTemplateParameterMap();
                Integer[] integerArray = parameterMap.getAllParameterPositions();
                int n = integerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinding owner;
                    IType type;
                    Integer position = integerArray[n2];
                    ICPPTemplateArgument argument = parameterMap.getArgument(position.intValue());
                    if (argument != null && (type = argument.getTypeValue()) instanceof IBinding && CharArrayUtils.equals((char[])((IBinding)type).getNameCharArray(), (String)"hash") && (owner = ((IBinding)type).getOwner()) instanceof ICPPNamespace && (CharArrayUtils.equals((char[])owner.getNameCharArray(), (String)"std") || CharArrayUtils.equals((char[])owner.getNameCharArray(), (String)"__gnu_cxx"))) {
                        this.addRequiredBindings((IBinding)type, queue);
                    }
                    ++n2;
                }
                this.addRequiredBindings(((ICPPSpecialization)binding).getSpecializedBinding(), queue);
                continue;
            }
            bindings.add(binding);
        }
        return bindings;
    }

    private void addRequiredBindings(IBinding binding, Deque<IBinding> newBindings) {
        if (binding instanceof ICPPMember) {
            if (binding instanceof ICPPMethod) {
                newBindings.add(binding);
            }
            newBindings.add(binding.getOwner());
        } else if (binding instanceof IType) {
            IBinding b = BindingClassifier.getTypeBinding((IType)binding);
            if (b != null) {
                newBindings.add(b);
            }
        } else if (binding instanceof IProblemBinding) {
            IProblemBinding problemBinding = (IProblemBinding)binding;
            IBinding[] candidateBindings = problemBinding.getCandidateBindings();
            if (candidateBindings.length > 0) {
                Collections.addAll(newBindings, candidateBindings);
            } else {
                try {
                    IIndexMacro[] indexMacros = this.fContext.getIndex().findMacros(binding.getNameCharArray(), IndexFilter.ALL, null);
                    Collections.addAll(newBindings, indexMacros);
                }
                catch (CoreException coreException) {}
            }
        } else {
            newBindings.add(binding);
        }
    }

    private void declareType(IType type) {
        IBinding binding = BindingClassifier.getTypeBinding(type);
        if (binding != null) {
            this.declareBinding(binding);
        }
    }

    private void declareBinding(IBinding binding) {
        if (this.fProcessedDefinedBindings.contains(binding)) {
            return;
        }
        if (this.fAst.getDeclarationsInAST(binding).length != 0) {
            return;
        }
        if (!this.fProcessedDeclaredBindings.add(binding)) {
            return;
        }
        if (!this.canForwardDeclare(binding)) {
            this.defineBinding(binding);
            return;
        }
        Set<IBinding> requiredBindings = this.getRequiredBindings(binding);
        for (IBinding requiredBinding : requiredBindings) {
            if (this.fBindingsToForwardDeclare.contains(requiredBinding) || this.fBindingsToDefine.contains(requiredBinding)) {
                return;
            }
            if (this.fAst.getDefinitionsInAST(requiredBinding).length != 0) {
                return;
            }
            if (this.fAst.getDeclarationsInAST(requiredBinding).length != 0) {
                return;
            }
            if (this.canForwardDeclare(requiredBinding)) {
                if (requiredBinding == binding) {
                    this.fBindingsToForwardDeclare.add(requiredBinding);
                    continue;
                }
                this.declareBinding(requiredBinding);
                continue;
            }
            if (requiredBinding == binding) {
                this.fBindingsToDefine.add(requiredBinding);
                continue;
            }
            this.defineBinding(requiredBinding);
        }
    }

    private boolean canForwardDeclare(IBinding binding) {
        boolean canDeclare = false;
        if (binding instanceof ICompositeType) {
            canDeclare = this.fPreferences.forwardDeclareCompositeTypes;
        } else if (binding instanceof IEnumeration) {
            canDeclare = this.fPreferences.forwardDeclareEnums && BindingClassifier.isEnumerationWithoutFixedUnderlyingType(binding);
        } else if (binding instanceof IFunction && !(binding instanceof ICPPMethod)) {
            canDeclare = this.fPreferences.forwardDeclareFunctions;
        } else if (binding instanceof IVariable && ((IVariable)binding).isExtern()) {
            canDeclare = this.fPreferences.forwardDeclareExternalVariables;
        }
        if (canDeclare && !this.fPreferences.forwardDeclareTemplates && (binding instanceof ICPPTemplateDefinition || binding instanceof ICPPSpecialization)) {
            canDeclare = false;
        }
        return canDeclare;
    }

    private boolean mayBeForwardDeclared(IType type) {
        IBinding binding = BindingClassifier.getTypeBinding(type);
        if (binding == null) {
            return false;
        }
        if (!this.fPreferences.assumeTemplatesMayBeForwardDeclared && (binding instanceof ICPPTemplateDefinition || binding instanceof ICPPSpecialization)) {
            return false;
        }
        if (binding instanceof ICompositeType) {
            return true;
        }
        return binding instanceof ICPPEnumeration && ((ICPPEnumeration)binding).getFixedType() != null;
    }

    private void defineTypeExceptTypedefOrNonFixedEnum(IType type) {
        IBinding typeBinding = BindingClassifier.getTypeBinding(type);
        if (typeBinding != null && !(typeBinding instanceof ITypedef) && !BindingClassifier.isEnumerationWithoutFixedUnderlyingType(typeBinding)) {
            this.defineBinding(typeBinding);
        }
    }

    private void defineBinding(IBinding binding) {
        if (!this.markAsDefined(binding)) {
            return;
        }
        if (this.fAst.getDefinitionsInAST(binding).length != 0) {
            return;
        }
        Set<IBinding> requiredBindings = this.getRequiredBindings(binding);
        for (IBinding requiredBinding : requiredBindings) {
            this.fBindingsToForwardDeclare.remove(requiredBinding);
            if (requiredBinding != binding && (!this.markAsDefined(requiredBinding) || this.fAst.getDefinitionsInAST(requiredBinding).length != 0)) continue;
            this.fBindingsToDefine.add(requiredBinding);
        }
    }

    private void defineBindingForName(IASTName name) {
        IBinding binding = name.resolveBinding();
        if (!BindingClassifier.isPartOfExternalMacroDefinition((IASTNode)name)) {
            this.defineBinding(binding);
        }
    }

    private boolean markAsDefined(IBinding binding) {
        if (!this.fProcessedDefinedBindings.add(binding)) {
            return false;
        }
        if (binding instanceof ITypedef) {
            IType type = ((ITypedef)binding).getType();
            if ((type = SemanticUtil.getNestedType((IType)type, (int)16)) instanceof IBinding) {
                this.markAsDefined((IBinding)type);
            }
        } else if (binding instanceof ICPPClassType && this.fAst.getDefinitionsInAST(binding).length == 0) {
            ICPPClassType[] bases;
            ICPPClassType[] iCPPClassTypeArray = bases = ClassTypeHelper.getAllBases((ICPPClassType)((ICPPClassType)binding), (IASTNode)this.fAst);
            int n = bases.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPClassType base = iCPPClassTypeArray[n2];
                this.fProcessedDefinedBindings.add((IBinding)base);
                this.fBindingsToDefine.remove(base);
                this.fBindingsToForwardDeclare.remove(base);
                ++n2;
            }
        }
        return true;
    }

    private void defineFunction(IFunction function, IASTInitializerClause[] arguments) {
        this.defineBinding((IBinding)function);
        this.declareFunction(function, arguments);
    }

    private void declareFunction(IFunction function, IASTInitializerClause[] arguments) {
        if (!this.canForwardDeclare((IBinding)function)) {
            this.defineBinding((IBinding)function);
        }
        IType returnType = function.getType().getReturnType();
        this.defineTypeForBinding((IBinding)function, returnType);
        this.processFunctionParameters(function, arguments);
    }

    private void defineTypeForBinding(IBinding binding, IType type) {
        if (this.isDefined(binding) && !this.mayBeForwardDeclared(type)) {
            ICPPTemplateArgument[] arguments;
            ICPPTemplateInstance instance;
            IBinding template;
            if (type instanceof ICPPTemplateInstance && BindingClassifier.isTemplateAllowingIncompleteArgumentType(template = (instance = (ICPPTemplateInstance)type).getSpecializedBinding()) && (arguments = instance.getTemplateArguments()).length != 0) {
                IType argumentType = arguments[0].getTypeValue();
                this.defineTypeExceptTypedefOrNonFixedEnum(argumentType);
            }
        } else if (!(type instanceof IPointerType) && !(type instanceof ICPPReferenceType)) {
            this.defineTypeExceptTypedefOrNonFixedEnum(type);
        }
    }

    private boolean isDefined(IBinding binding) {
        if (this.fBindingsToDefine.contains(binding)) {
            return true;
        }
        IBinding owner = binding.getOwner();
        return owner instanceof IType && this.fBindingsToDefine.contains(owner);
    }

    private static boolean isTemplateAllowingIncompleteArgumentType(IBinding binding) {
        String name = binding.getName();
        int pos = Arrays.binarySearch(TEMPLATES_ALLOWING_INCOMPLETE_ARGUMENT_TYPE, name);
        if (pos < 0) {
            return false;
        }
        IBinding owner = binding.getOwner();
        if (!(owner instanceof ICPPNamespace)) {
            return false;
        }
        return CharArrayUtils.equals((char[])owner.getNameCharArray(), (String)"std") && owner.getOwner() == null;
    }

    private static IBinding getBindingOfExpression(IASTExpression expression) {
        if (expression instanceof IASTIdExpression) {
            return ((IASTIdExpression)expression).getName().resolveBinding();
        }
        if (expression instanceof IASTFieldReference) {
            return ((IASTFieldReference)expression).getFieldName().resolveBinding();
        }
        return null;
    }

    private static IBinding getTypeBinding(IType type) {
        if ((type = SemanticUtil.getNestedType((IType)type, (int)180)) instanceof IBinding) {
            return (IBinding)type;
        }
        return null;
    }

    public boolean isTemplateArgumentRequiringCompleteType(IASTName name) {
        ICPPASTTypeId typeId = (ICPPASTTypeId)CPPVisitor.findAncestorWithType((IASTNode)name, ICPPASTTypeId.class);
        if (typeId == null || typeId.getPropertyInParent() != ICPPASTTemplateId.TEMPLATE_ID_ARGUMENT) {
            return false;
        }
        ICPPASTTemplateId templateId = (ICPPASTTemplateId)typeId.getParent();
        IBinding template = templateId.resolveBinding();
        if (template instanceof IProblemBinding) {
            return true;
        }
        IBinding owner = template.getOwner();
        if (!(owner instanceof ICPPNamespace) || !CharArrayUtils.equals((char[])owner.getNameCharArray(), (String)"std") || owner.getOwner() != null) {
            return true;
        }
        if (!BindingClassifier.isTemplateAllowingIncompleteArgumentType(template)) {
            return true;
        }
        IASTNode parent = templateId.getParent();
        if (!(parent instanceof ICPPASTNamedTypeSpecifier)) {
            return false;
        }
        if (!((parent = parent.getParent()) instanceof IASTSimpleDeclaration)) {
            return true;
        }
        if (!((parent = parent.getParent()) instanceof ICPPASTCompositeTypeSpecifier)) {
            return true;
        }
        ICPPClassScope classScope = ((ICPPASTCompositeTypeSpecifier)parent).getScope();
        ICPPClassType classType = classScope.getClassType();
        ICPPMethod destructor = ClassTypeHelper.getMethodInClass((ICPPClassType)classType, (ClassTypeHelper.MethodKind)ClassTypeHelper.MethodKind.DTOR, (IASTNode)parent);
        return destructor != null && this.fAst.getDefinitionsInAST((IBinding)destructor).length != 0;
    }

    private static boolean isEnumerationWithoutFixedUnderlyingType(IBinding typeBinding) {
        return typeBinding instanceof IEnumeration && (!(typeBinding instanceof ICPPEnumeration) || ((ICPPEnumeration)typeBinding).getFixedType() == null);
    }

    private static boolean isPartOfExternalMacroDefinition(IASTNode node) {
        IASTNodeLocation[] locations = node.getNodeLocations();
        if (locations.length != 1 || !(locations[0] instanceof IASTMacroExpansionLocation)) {
            return false;
        }
        IASTMacroExpansionLocation macroExpansionLocation = (IASTMacroExpansionLocation)locations[0];
        IASTPreprocessorMacroExpansion macroExpansion = macroExpansionLocation.getExpansion();
        IASTPreprocessorMacroDefinition macroDefinition = macroExpansion.getMacroDefinition();
        if (macroDefinition.isPartOfTranslationUnitFile()) {
            return false;
        }
        if (!(macroDefinition instanceof IASTPreprocessorFunctionStyleMacroDefinition)) {
            return true;
        }
        return !BindingClassifier.containsNameFromTranslationUnit(node);
    }

    private static boolean containsNameFromTranslationUnit(IASTNode node) {
        LocalNameFinder localNameFinder = new LocalNameFinder();
        node.accept((ASTVisitor)localNameFinder);
        return localNameFinder.found;
    }

    private class BindingCollector
    extends ASTVisitor {
        BindingCollector() {
            super(true);
        }

        public int leave(IASTDeclaration declaration) {
            if (BindingClassifier.isPartOfExternalMacroDefinition((IASTNode)declaration)) {
                return 3;
            }
            if (declaration instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration simpleDeclaration = (IASTSimpleDeclaration)declaration;
                IASTDeclSpecifier declSpecifier = simpleDeclaration.getDeclSpecifier();
                IASTDeclarator[] declarators = simpleDeclaration.getDeclarators();
                if (declSpecifier instanceof IASTNamedTypeSpecifier) {
                    boolean staticMember = simpleDeclaration.getParent() instanceof IASTCompositeTypeSpecifier && declSpecifier.getStorageClass() == 3;
                    boolean canBeDeclared = true;
                    if (!staticMember) {
                        IASTDeclarator[] iASTDeclaratorArray = declarators;
                        int n = declarators.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IASTDeclarator declarator = iASTDeclaratorArray[n2];
                            if (!(declarator instanceof IASTFunctionDeclarator) && declarator.getPointerOperators().length == 0) {
                                canBeDeclared = false;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (!canBeDeclared) {
                        IASTName name = ((IASTNamedTypeSpecifier)declSpecifier).getName();
                        BindingClassifier.this.defineBindingForName(name);
                    }
                }
            }
            return 3;
        }

        public int leave(IASTDeclarator declarator) {
            block8: {
                IBinding binding;
                if (BindingClassifier.isPartOfExternalMacroDefinition((IASTNode)declarator)) {
                    return 3;
                }
                if (!(declarator instanceof IASTFunctionDeclarator) || !((binding = declarator.getName().resolveBinding()) instanceof IFunction)) break block8;
                IFunction function = (IFunction)binding;
                IFunctionType functionType = function.getType();
                if (declarator.getPropertyInParent() == IASTFunctionDefinition.DECLARATOR) {
                    IType[] parameterTypes;
                    IType returnType = functionType.getReturnType();
                    if (!(returnType instanceof IPointerType) && !(returnType instanceof ICPPReferenceType)) {
                        BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(returnType);
                    }
                    IType[] iTypeArray = parameterTypes = functionType.getParameterTypes();
                    int n = parameterTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType type = iTypeArray[n2];
                        if (!(type instanceof IPointerType || type instanceof ICPPReferenceType && !BindingClassifier.this.isTypeWithConvertingConstructor(type, (IASTNode)declarator))) {
                            BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(type);
                        }
                        ++n2;
                    }
                } else {
                    IType[] parameterTypes;
                    IType[] iTypeArray = parameterTypes = functionType.getParameterTypes();
                    int n = parameterTypes.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IType type = iTypeArray[n3];
                        if (!(type instanceof IPointerType) && BindingClassifier.this.isTypeWithConvertingConstructor(type, (IASTNode)declarator)) {
                            BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(type);
                        }
                        ++n3;
                    }
                }
            }
            return 3;
        }

        public int leave(IASTDeclSpecifier declSpec) {
            if (BindingClassifier.isPartOfExternalMacroDefinition((IASTNode)declSpec)) {
                return 3;
            }
            if (declSpec instanceof IASTElaboratedTypeSpecifier) {
                return 1;
            }
            return 3;
        }

        public int leave(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier) {
            if (BindingClassifier.isPartOfExternalMacroDefinition((IASTNode)baseSpecifier)) {
                return 3;
            }
            BindingClassifier.this.defineBindingForName(baseSpecifier.getName());
            return 3;
        }

        public int leave(IASTInitializer initializer) {
            if (BindingClassifier.isPartOfExternalMacroDefinition((IASTNode)initializer)) {
                return 3;
            }
            IASTInitializer memberNode = initializer;
            IASTName memberName = null;
            IBinding memberBinding = null;
            while (memberNode != null) {
                if (memberNode instanceof IASTDeclarator) {
                    memberName = ((IASTDeclarator)memberNode).getName();
                    break;
                }
                if (memberNode instanceof ICPPASTConstructorChainInitializer) {
                    memberName = ((ICPPASTConstructorChainInitializer)memberNode).getMemberInitializerId();
                    break;
                }
                memberNode = memberNode.getParent();
            }
            if (memberName != null) {
                memberBinding = memberName.resolveBinding();
            }
            IASTExpression[] arguments = IASTExpression.EMPTY_EXPRESSION_ARRAY;
            if (initializer instanceof ICPPASTConstructorInitializer) {
                ICPPASTConstructorInitializer constructorInitializer = (ICPPASTConstructorInitializer)initializer;
                arguments = constructorInitializer.getArguments();
            } else if (initializer instanceof IASTEqualsInitializer) {
                IASTEqualsInitializer equalsInitializer = (IASTEqualsInitializer)initializer;
                arguments = new IASTInitializerClause[]{equalsInitializer.getInitializerClause()};
            }
            if (memberBinding instanceof IVariable) {
                IType memberType = ((IVariable)memberBinding).getType();
                if (!(memberType instanceof IPointerType) && !(memberType instanceof ICPPReferenceType)) {
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(memberType);
                } else {
                    IASTExpression[] iASTExpressionArray = arguments;
                    int n = arguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType argumentType;
                        IASTExpression argument = iASTExpressionArray[n2];
                        if (argument instanceof IASTExpression && BindingClassifier.this.isTypeDefinitionRequiredForConversion(argumentType = argument.getExpressionType(), memberType)) {
                            BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(memberType);
                            BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(argumentType);
                        }
                        ++n2;
                    }
                }
            } else if (memberBinding instanceof ICPPConstructor) {
                ICPPConstructor constructor = (ICPPConstructor)memberBinding;
                BindingClassifier.this.defineBinding(constructor.getOwner());
                BindingClassifier.this.processFunctionParameters((IFunction)constructor, (IASTInitializerClause[])arguments);
            }
            return 3;
        }

        public int leave(IASTStatement statement) {
            IASTSimpleDeclaration simpleDeclaration;
            IASTDeclSpecifier declSpecifier;
            ICPPASTCatchHandler catchHandler;
            IASTDeclaration declaration;
            if (BindingClassifier.isPartOfExternalMacroDefinition((IASTNode)statement)) {
                return 3;
            }
            if (statement instanceof IASTReturnStatement) {
                IASTReturnStatement returnStatement = (IASTReturnStatement)statement;
                IASTExpression returnValue = returnStatement.getReturnValue();
                if (returnValue != null) {
                    IBinding binding;
                    IASTFunctionDefinition functionDefinition;
                    IASTFunctionDeclarator functionDeclarator;
                    IASTReturnStatement functionDefinitionNode = returnStatement;
                    while (functionDefinitionNode != null && !(functionDefinitionNode instanceof IASTFunctionDefinition)) {
                        functionDefinitionNode = functionDefinitionNode.getParent();
                    }
                    if (functionDefinitionNode != null && (functionDeclarator = (functionDefinition = (IASTFunctionDefinition)functionDefinitionNode).getDeclarator()) != null && (binding = functionDeclarator.getName().resolveBinding()) instanceof IFunction) {
                        IFunction function = (IFunction)binding;
                        IType returnType = function.getType().getReturnType();
                        IType returnValueType = returnValue.getExpressionType();
                        if (BindingClassifier.this.isTypeDefinitionRequiredForConversion(returnValueType, returnType)) {
                            BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(returnType);
                            BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(returnValueType);
                        }
                    }
                }
            } else if (statement instanceof ICPPASTCatchHandler && (declaration = (catchHandler = (ICPPASTCatchHandler)statement).getDeclaration()) instanceof IASTSimpleDeclaration && (declSpecifier = (simpleDeclaration = (IASTSimpleDeclaration)declaration).getDeclSpecifier()) instanceof IASTNamedTypeSpecifier) {
                IASTNamedTypeSpecifier namedTypeSpecifier = (IASTNamedTypeSpecifier)declSpecifier;
                BindingClassifier.this.defineBindingForName(namedTypeSpecifier.getName());
            }
            return 3;
        }

        public int leave(IASTExpression expression) {
            IType conditionExpressionType;
            if (BindingClassifier.isPartOfExternalMacroDefinition((IASTNode)expression)) {
                return 3;
            }
            ASTNodeProperty propertyInParent = expression.getPropertyInParent();
            if (!(propertyInParent != IASTIfStatement.CONDITION && propertyInParent != IASTForStatement.CONDITION && propertyInParent != IASTWhileStatement.CONDITIONEXPRESSION && propertyInParent != IASTDoStatement.CONDITION && propertyInParent != IASTConditionalExpression.LOGICAL_CONDITION || (conditionExpressionType = expression.getExpressionType()) instanceof IPointerType)) {
                BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(conditionExpressionType);
            }
            if (expression instanceof IASTIdExpression) {
                IASTIdExpression idExpression = (IASTIdExpression)expression;
                IBinding binding = idExpression.getName().resolveBinding();
                if (binding instanceof IVariable) {
                    IType variableType = ((IVariable)binding).getType();
                    BindingClassifier.this.defineTypeForBinding(binding, variableType);
                }
            } else if (expression instanceof IASTUnaryExpression) {
                IASTUnaryExpression unaryExpression = (IASTUnaryExpression)expression;
                IASTExpression operand = unaryExpression.getOperand();
                if (operand != null) {
                    ICPPFunction overload;
                    if (unaryExpression instanceof ICPPASTUnaryExpression && (overload = ((ICPPASTUnaryExpression)unaryExpression).getOverload()) != null) {
                        BindingClassifier.this.defineFunction((IFunction)overload, new IASTInitializerClause[]{operand});
                        return 3;
                    }
                    boolean expressionDefinitionRequired = true;
                    switch (unaryExpression.getOperator()) {
                        case 5: 
                        case 11: {
                            expressionDefinitionRequired = false;
                            break;
                        }
                        case 2: 
                        case 7: 
                        case 8: 
                        case 13: 
                        case 15: {
                            if (!(operand.getExpressionType() instanceof IPointerType)) break;
                            expressionDefinitionRequired = false;
                        }
                    }
                    if (expressionDefinitionRequired) {
                        BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(operand.getExpressionType());
                    }
                }
            } else if (expression instanceof IASTBinaryExpression) {
                ICPPFunction overload;
                IASTBinaryExpression binaryExpression = (IASTBinaryExpression)expression;
                if (binaryExpression instanceof ICPPASTBinaryExpression && (overload = ((ICPPASTBinaryExpression)binaryExpression).getOverload()) != null) {
                    BindingClassifier.this.defineFunction((IFunction)overload, new IASTInitializerClause[]{binaryExpression.getOperand1(), binaryExpression.getOperand2()});
                    return 3;
                }
                IType operand1Type = binaryExpression.getOperand1().getExpressionType();
                IType operand2Type = binaryExpression.getOperand2().getExpressionType();
                boolean expression1DefinitionRequired = true;
                boolean expression2DefinitionRequired = true;
                switch (binaryExpression.getOperator()) {
                    case 15: 
                    case 16: {
                        if (operand1Type instanceof IPointerType) {
                            expression1DefinitionRequired = false;
                        }
                        if (!(operand2Type instanceof IPointerType)) break;
                        expression2DefinitionRequired = false;
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 17: 
                    case 28: 
                    case 29: {
                        if (operand1Type instanceof IPointerType && operand2Type instanceof IPointerType) {
                            if (BindingClassifier.this.isTypeDefinitionRequiredForConversion(operand2Type, operand1Type)) break;
                            expression1DefinitionRequired = false;
                            expression2DefinitionRequired = false;
                            break;
                        }
                        if (operand1Type instanceof IPointerType) {
                            expression1DefinitionRequired = false;
                            break;
                        }
                        if (!(operand2Type instanceof IPointerType)) break;
                        expression2DefinitionRequired = false;
                    }
                }
                if (expression1DefinitionRequired) {
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(operand1Type);
                }
                if (expression2DefinitionRequired) {
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(operand2Type);
                }
            } else if (expression instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression functionCallExpression = (IASTFunctionCallExpression)expression;
                IASTExpression functionNameExpression = functionCallExpression.getFunctionNameExpression();
                IBinding binding = BindingClassifier.getBindingOfExpression(functionNameExpression);
                if (binding != null) {
                    if (binding instanceof IFunction) {
                        BindingClassifier.this.declareFunction((IFunction)binding, functionCallExpression.getArguments());
                    } else {
                        if (binding instanceof IType) {
                            BindingClassifier.this.defineBinding(binding);
                        }
                        if (functionCallExpression instanceof IASTImplicitNameOwner) {
                            IASTImplicitName[] implicitNames;
                            IASTImplicitName[] iASTImplicitNameArray = implicitNames = ((IASTImplicitNameOwner)functionCallExpression).getImplicitNames();
                            int n = implicitNames.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IASTImplicitName name = iASTImplicitNameArray[n2];
                                binding = name.resolveBinding();
                                if (binding instanceof IFunction) {
                                    BindingClassifier.this.defineFunction((IFunction)binding, functionCallExpression.getArguments());
                                }
                                ++n2;
                            }
                        }
                    }
                }
            } else if (expression instanceof IASTFieldReference) {
                IASTExpression fieldOwner = ((IASTFieldReference)expression).getFieldOwner();
                IType expressionType = fieldOwner.getExpressionType();
                if (expressionType instanceof IPointerType || expressionType instanceof ICPPReferenceType) {
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(expressionType);
                } else if (!(fieldOwner instanceof IASTIdExpression) && !(fieldOwner instanceof IASTFunctionCallExpression)) {
                    IBinding binding = BindingClassifier.getBindingOfExpression(fieldOwner);
                    if (binding != null) {
                        BindingClassifier.this.defineTypeForBinding(binding, expressionType);
                    } else {
                        BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(expressionType);
                    }
                }
            } else if (expression instanceof ICPPASTNewExpression) {
                BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(((ICPPASTNewExpression)expression).getExpressionType());
            } else if (expression instanceof ICPPASTDeleteExpression) {
                BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(((ICPPASTDeleteExpression)expression).getOperand().getExpressionType());
            } else if (expression instanceof IASTCastExpression) {
                IASTCastExpression castExpression = (IASTCastExpression)expression;
                IType targetType = castExpression.getExpressionType();
                IType sourceType = castExpression.getOperand().getExpressionType();
                if (BindingClassifier.this.isTypeDefinitionRequiredForConversion(sourceType, targetType)) {
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(targetType);
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(sourceType);
                } else if (!(targetType instanceof IPointerType) && !(targetType instanceof ICPPReferenceType)) {
                    BindingClassifier.this.defineTypeExceptTypedefOrNonFixedEnum(targetType);
                }
            }
            return 3;
        }

        public int leave(IASTName name) {
            IBinding binding;
            if (BindingClassifier.isPartOfExternalMacroDefinition((IASTNode)name)) {
                return 3;
            }
            if (name instanceof ICPPASTQualifiedName) {
                ICPPASTNameSpecifier[] qualifier;
                ICPPASTNameSpecifier[] iCPPASTNameSpecifierArray = qualifier = ((ICPPASTQualifiedName)name).getQualifier();
                int n = qualifier.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPASTNameSpecifier nameSpec = iCPPASTNameSpecifierArray[n2];
                    BindingClassifier.this.defineBinding(nameSpec.resolveBinding());
                    ++n2;
                }
            }
            if ((binding = name.resolveBinding()) != null) {
                if (BindingClassifier.this.isTemplateArgumentRequiringCompleteType(name)) {
                    BindingClassifier.this.defineBinding(binding);
                } else {
                    IBinding owner = binding.getOwner();
                    if (owner instanceof IType) {
                        BindingClassifier.this.defineBinding(owner);
                        if (binding instanceof IProblemBinding) {
                            BindingClassifier.this.declareBinding(binding);
                        }
                    } else {
                        BindingClassifier.this.declareBinding(binding);
                    }
                }
            }
            return 3;
        }

        public int leave(IASTTranslationUnit tu) {
            IASTPreprocessorMacroExpansion[] iASTPreprocessorMacroExpansionArray = tu.getMacroExpansions();
            int n = iASTPreprocessorMacroExpansionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPreprocessorMacroExpansion macroExpansion = iASTPreprocessorMacroExpansionArray[n2];
                IASTPreprocessorMacroDefinition macroDefinition = macroExpansion.getMacroDefinition();
                IASTName name = macroDefinition.getName();
                BindingClassifier.this.defineBinding(name.getBinding());
                ++n2;
            }
            return 3;
        }
    }

    public static enum InclusionType {
        DECLARATION,
        DEFINITION;

    }

    private static class LocalNameFinder
    extends ASTVisitor {
        boolean found;

        LocalNameFinder() {
            this.shouldVisitNames = true;
        }

        public int visit(IASTName name) {
            IASTImageLocation imageLocation;
            if (!(name instanceof ICPPASTQualifiedName) && (imageLocation = name.getImageLocation()) != null && imageLocation.getFileName().equals(name.getTranslationUnit().getFilePath())) {
                this.found = true;
                return 2;
            }
            return 3;
        }
    }
}

