/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize.filesystem.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.internal.synchronize.filesystem.ui.FileSystemOperation;
import org.eclipse.rse.internal.synchronize.filesystem.ui.PutOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelParticipantAction;

public class ModelPutAction
extends ModelParticipantAction {
    public static final String PUT_ACTION_ID = "org.eclipse.rse.internal.synchronize.putAction";

    public ModelPutAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
        this.setId(PUT_ACTION_ID);
    }

    protected boolean isEnabledForSelection(IStructuredSelection selection) {
        int mode = this.getConfiguration().getMode();
        if (mode == 2 || mode == 4) {
            return this.getResourceMappings(selection).length > 0;
        }
        return false;
    }

    private ResourceMapping[] getResourceMappings(IStructuredSelection selection) {
        ArrayList<ResourceMapping> mappings = new ArrayList<ResourceMapping>();
        for (Object element : selection) {
            ResourceMapping mapping = Utils.getResourceMapping(element);
            if (mapping == null) continue;
            mappings.add(mapping);
        }
        return mappings.toArray(new ResourceMapping[mappings.size()]);
    }

    public void run() {
        ResourceMapping[] resourceMappings = this.getResourceMappings(this.getStructuredSelection());
        SubscriberScopeManager manager = FileSystemOperation.createScopeManager("Put", resourceMappings);
        try {
            new PutOperation(this.getConfiguration().getSite().getPart(), manager).run();
        }
        catch (InvocationTargetException e) {
            IStatus status = this.getStatus(e);
            ErrorDialog.openError((Shell)this.getConfiguration().getSite().getShell(), null, null, (IStatus)status);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IStatus getStatus(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            return this.getStatus(((InvocationTargetException)throwable).getCause());
        }
        return new Status(4, "org.eclipse.rse.internal.synchronize", 0, "An error occurred during the put.", throwable);
    }
}

