/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.build;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.SWTUtil;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class BuildConfigurationsMenuBuilder {
    private static IProject getSelectedProject(ISelection selection) {
        IProject current = null;
        if (selection instanceof IStructuredSelection) {
            Object[] selected;
            Object[] objectArray = selected = ((IStructuredSelection)selection).toArray();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                IResource resource = BuildConfigurationsMenuBuilder.toResource(object);
                if (resource == null) {
                    return null;
                }
                if (current == null) {
                    current = resource.getProject();
                } else if (!resource.getProject().equals((Object)current)) {
                    return null;
                }
                ++n2;
            }
            return current;
        }
        return null;
    }

    public static IProject getSelectedProject(ISelection selection, IWorkbenchPart part, IWorkbenchWindow window) {
        if (part instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)part).getEditorInput();
            IResource resource = (IResource)input.getAdapter(IResource.class);
            if (resource != null) {
                IProject project = resource.getProject();
                if (CoreModel.getDefault().isNewStyleProject(project)) {
                    return project;
                }
            }
            return null;
        }
        IProject selectedProject = BuildConfigurationsMenuBuilder.getSelectedProject(selection);
        if (selectedProject != null || window == null) {
            return selectedProject;
        }
        return BuildConfigurationsMenuBuilder.getSelectedProject(selection, (IWorkbenchPart)SWTUtil.safeGetActiveEditor((IWorkbenchWindow)window), null);
    }

    private static IResource toResource(Object object) {
        Object resource;
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable && (resource = ((IAdaptable)object).getAdapter(IResource.class)) != null) {
            return (IResource)resource;
        }
        return null;
    }

    public static void updateCurrentBuildConfigurationAndTarget(IProject project, SyncConfig config, String configurationName) throws CoreException {
        ICProjectDescription projectDescription;
        if (config != null) {
            SyncConfigManager.setActive((IProject)project, (SyncConfig)config);
        }
        if (!CoreUtil.isNullOrEmpty((String)configurationName) && (projectDescription = CoreModel.getDefault().getProjectDescription(project, true)) != null) {
            ICConfigurationDescription configuration = projectDescription.getConfigurationByName(configurationName);
            projectDescription.setActiveConfiguration(configuration);
            CoreModel.getDefault().setProjectDescription(project, projectDescription);
        }
    }

    public IAction[] buildMenu(IProject project) {
        ICProjectDescription description = CoreModel.getDefault().getProjectDescription(project, true);
        if (description != null) {
            Collection<Object> list;
            Object[] configs = SyncConfigManager.getConfigs((IProject)project);
            if (CoreUtil.isNullOrEmpty((Object[])configs)) {
                list = this.createSyncConfigSubmenu(description, null, true);
            } else {
                list = new LinkedList();
                Object[] objectArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object syncConfig = objectArray[n2];
                    SyncConfig active = SyncConfigManager.getActive((IProject)project);
                    list.addAll(this.createSyncConfigSubmenu(description, (SyncConfig)syncConfig, active != null && active.equals(syncConfig)));
                    ++n2;
                }
            }
            return list.toArray(new IAction[list.size()]);
        }
        return new IAction[0];
    }

    protected abstract IAction createMenuItem(String var1, SyncConfig var2, String var3);

    private Collection<IAction> createSyncConfigSubmenu(ICProjectDescription description, SyncConfig syncConfig, boolean activeSyncConfig) {
        LinkedList<IAction> actions = new LinkedList<IAction>();
        if (syncConfig != null) {
            Action item = new Action(syncConfig.getConnectionName()){};
            item.setEnabled(false);
            item.setText(syncConfig.getName());
            actions.add((IAction)item);
        }
        ICConfigurationDescription[] configurations = description.getConfigurations();
        ICConfigurationDescription activeConfiguration = description.getActiveConfiguration();
        String prefix = syncConfig == null ? "" : "  ";
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configuration = iCConfigurationDescriptionArray[n2];
            String configurationName = configuration.getName();
            IAction action = this.createMenuItem(String.valueOf(prefix) + configurationName, syncConfig, configurationName);
            if (action != null) {
                action.setChecked(activeSyncConfig && activeConfiguration.equals(configuration));
                actions.add(action);
            }
            ++n2;
        }
        return actions;
    }
}

