/* Copyright 2010-2012 NVIDIA Corporation.  All rights reserved.
  *
  * NOTICE TO LICENSEE:
  *
  * The source code and/or documentation ("Licensed Deliverables") are
  * subject to NVIDIA intellectual property rights under U.S. and
  * international Copyright laws.
  *
  * The Licensed Deliverables contained herein are PROPRIETARY and
  * CONFIDENTIAL to NVIDIA and are being provided under the terms and
  * conditions of a form of NVIDIA software license agreement by and
  * between NVIDIA and Licensee ("License Agreement") or electronically
  * accepted by Licensee.  Notwithstanding any terms or conditions to
  * the contrary in the License Agreement, reproduction or disclosure
  * of the Licensed Deliverables to any third party without the express
  * written consent of NVIDIA is prohibited.
  *
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
  * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
  * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  THEY ARE
  * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
  * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
  * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
  * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
  * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
  * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
  * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
  * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
  * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
  * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
  * OF THESE LICENSED DELIVERABLES.
  *
  * U.S. Government End Users.  These Licensed Deliverables are a
  * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
  * 1995), consisting of "commercial computer software" and "commercial
  * computer software documentation" as such terms are used in 48
  * C.F.R. 12.212 (SEPT 1995) and are provided to the U.S. Government
  * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
  * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
  * U.S. Government End Users acquire the Licensed Deliverables with
  * only those rights set forth herein.
  *
  * Any use of the Licensed Deliverables in individual and commercial
  * software must include, in the user documentation and internal
  * comments to the code, the above Disclaimer and U.S. Government End
  * Users Notice.
  */
#if !defined(CURAND_XORWOW_PRECALCULATED_H_)
#define CURAND_XORWOW_PRECALCULATED_H_

#define PRECALC_NUM_MATRICES (8)
#define PRECALC_BLOCK_SIZE (2)
#define PRECALC_BLOCK_MASK ((1<<PRECALC_BLOCK_SIZE)-1)
#define XORWOW_SEQUENCE_SPACING (67)

static __device__ unsigned int precalc_xorwow_matrix[8][800] = {
{
850664906UL, 2293210629UL, 1517805917UL, 1215500405UL, 1612415445UL, 645388200UL, 824349799UL, 3517232886UL, 4075591755UL, 3089899292UL, 4249786064UL, 3811424903UL, 1100783479UL, 53649761UL, 2817264826UL, 3159462529UL, 1654848550UL, 950025444UL, 3095510002UL, 4080567211UL, 4111078399UL, 3241719305UL, 2788212779UL, 4256963770UL, 2426893717UL, 4190211142UL, 1420776905UL, 3780537969UL, 1102912875UL, 1657948873UL, 3354905256UL, 2519610308UL, 
515777663UL, 3396785394UL, 1832603711UL, 1154211550UL, 1915690212UL, 1933919046UL, 789578337UL, 337961173UL, 1359089498UL, 2249086205UL, 3417955173UL, 862571348UL, 528120760UL, 1265685672UL, 1970052076UL, 3585976752UL, 3645339918UL, 312171257UL, 1360991400UL, 1994321680UL, 2327168468UL, 2540437053UL, 1180483641UL, 2217962701UL, 182726833UL, 590204372UL, 1904496495UL, 2545607041UL, 3697978033UL, 1084030545UL, 3397906968UL, 2192325323UL, 
2704204176UL, 1069092002UL, 2364406907UL, 1578647245UL, 3561974633UL, 3437665426UL, 1464127305UL, 1616628807UL, 2243114101UL, 3639967880UL, 1702613633UL, 2437350057UL, 39991274UL, 2024323584UL, 3795072940UL, 3604530798UL, 443099203UL, 643536212UL, 1919517328UL, 3931285769UL, 427935569UL, 276421624UL, 2492081750UL, 262729512UL, 3088549877UL, 2922650665UL, 1816283755UL, 4246096489UL, 842575914UL, 1460435650UL, 3050522190UL, 2640849794UL, 
3697925816UL, 3465779075UL, 3856929655UL, 1365559780UL, 2897029415UL, 2747033756UL, 3611830629UL, 1891542518UL, 1897590206UL, 437451803UL, 677924906UL, 123809117UL, 3940574372UL, 687640291UL, 3488484529UL, 470218446UL, 1092571016UL, 1537938503UL, 1073323937UL, 611300083UL, 3809285994UL, 3975678726UL, 925845389UL, 2514775760UL, 2859302390UL, 2761919483UL, 993285307UL, 164095287UL, 3736193671UL, 2078946336UL, 1418537059UL, 1202525920UL, 
4234029440UL, 1313593624UL, 2484428922UL, 1833969372UL, 661495122UL, 2217907395UL, 2795045321UL, 2950835531UL, 1402379354UL, 351314168UL, 1902476749UL, 1914974334UL, 2873973176UL, 1321203603UL, 3316118265UL, 3282193947UL, 1342191737UL, 793441242UL, 3281524559UL, 296088733UL, 487851702UL, 712098215UL, 1388727135UL, 1705533557UL, 3557800292UL, 399729516UL, 1355829467UL, 291276309UL, 421164833UL, 1318404599UL, 2064519128UL, 1161612642UL, 
2076623594UL, 850664906UL, 2293210629UL, 1517805917UL, 1215500405UL, 3847487204UL, 645388200UL, 824349799UL, 3517232886UL, 4075591755UL, 2755872609UL, 4249786064UL, 3811424903UL, 1100783479UL, 53649761UL, 1417544262UL, 3159462529UL, 1654848550UL, 950025444UL, 3095510002UL, 1908900347UL, 4111078399UL, 3241719305UL, 2788212779UL, 4256963770UL, 3750258343UL, 4190211142UL, 1420776905UL, 3780537969UL, 1102912875UL, 1690550UL, 3354905256UL, 
2519610308UL, 515777663UL, 3396785394UL, 2658162202UL, 1154211550UL, 1915690212UL, 1933919046UL, 789578337UL, 189880016UL, 1359089498UL, 2249086205UL, 3417955173UL, 862571348UL, 998719835UL, 1265685672UL, 1970052076UL, 3585976752UL, 3645339918UL, 2973042959UL, 1360991400UL, 1994321680UL, 2327168468UL, 2540437053UL, 2283905032UL, 2217962701UL, 182726833UL, 590204372UL, 1904496495UL, 110719262UL, 3697978033UL, 1084030545UL, 3397906968UL, 
2192325323UL, 4133333579UL, 1069092002UL, 2364406907UL, 1578647245UL, 3561974633UL, 3629845331UL, 1464127305UL, 1616628807UL, 2243114101UL, 3639967880UL, 3256744141UL, 2437350057UL, 39991274UL, 2024323584UL, 3795072940UL, 1024703328UL, 443099203UL, 643536212UL, 1919517328UL, 3931285769UL, 2755167056UL, 276421624UL, 2492081750UL, 262729512UL, 3088549877UL, 2817867653UL, 1816283755UL, 4246096489UL, 842575914UL, 1460435650UL, 2276077438UL, 
2640849794UL, 3697925816UL, 3465779075UL, 3856929655UL, 130551477UL, 2897029415UL, 2747033756UL, 3611830629UL, 1891542518UL, 804565809UL, 437451803UL, 677924906UL, 123809117UL, 3940574372UL, 2446610749UL, 3488484529UL, 470218446UL, 1092571016UL, 1537938503UL, 1502147484UL, 611300083UL, 3809285994UL, 3975678726UL, 925845389UL, 872826112UL, 2859302390UL, 2761919483UL, 993285307UL, 164095287UL, 3901654538UL, 2078946336UL, 1418537059UL, 
1202525920UL, 4234029440UL, 704759480UL, 2484428922UL, 1833969372UL, 661495122UL, 2217907395UL, 3287413716UL, 2950835531UL, 1402379354UL, 351314168UL, 1902476749UL, 2033316109UL, 2873973176UL, 1321203603UL, 3316118265UL, 3282193947UL, 1316780684UL, 793441242UL, 3281524559UL, 296088733UL, 487851702UL, 314311643UL, 1388727135UL, 1705533557UL, 3557800292UL, 399729516UL, 1660074989UL, 291276309UL, 421164833UL, 1318404599UL, 2064519128UL, 
3156334112UL, 2076623594UL, 850664906UL, 2293210629UL, 1517805917UL, 335452425UL, 3847487204UL, 645388200UL, 824349799UL, 3517232886UL, 954487767UL, 2755872609UL, 4249786064UL, 3811424903UL, 1100783479UL, 3408594583UL, 1417544262UL, 3159462529UL, 1654848550UL, 950025444UL, 324339737UL, 1908900347UL, 4111078399UL, 3241719305UL, 2788212779UL, 1890540205UL, 3750258343UL, 4190211142UL, 1420776905UL, 3780537969UL, 3716648585UL, 1690550UL, 
3354905256UL, 2519610308UL, 515777663UL, 3758156132UL, 2658162202UL, 1154211550UL, 1915690212UL, 1933919046UL, 844149171UL, 189880016UL, 1359089498UL, 2249086205UL, 3417955173UL, 1031812215UL, 998719835UL, 1265685672UL, 1970052076UL, 3585976752UL, 3174204115UL, 2973042959UL, 1360991400UL, 1994321680UL, 2327168468UL, 714016907UL, 2283905032UL, 2217962701UL, 182726833UL, 590204372UL, 2151450260UL, 110719262UL, 3697978033UL, 1084030545UL, 
3397906968UL, 767772303UL, 4133333579UL, 1069092002UL, 2364406907UL, 1578647245UL, 42955292UL, 3629845331UL, 1464127305UL, 1616628807UL, 2243114101UL, 3222189776UL, 3256744141UL, 2437350057UL, 39991274UL, 2024323584UL, 3142424684UL, 1024703328UL, 443099203UL, 643536212UL, 1919517328UL, 918511196UL, 2755167056UL, 276421624UL, 2492081750UL, 262729512UL, 4246877536UL, 2817867653UL, 1816283755UL, 4246096489UL, 842575914UL, 1425765936UL, 
2276077438UL, 2640849794UL, 3697925816UL, 3465779075UL, 1491702526UL, 130551477UL, 2897029415UL, 2747033756UL, 3611830629UL, 1844578694UL, 804565809UL, 437451803UL, 677924906UL, 123809117UL, 3419189841UL, 2446610749UL, 3488484529UL, 470218446UL, 1092571016UL, 3272535988UL, 1502147484UL, 611300083UL, 3809285994UL, 3975678726UL, 2853681168UL, 872826112UL, 2859302390UL, 2761919483UL, 993285307UL, 1434560128UL, 3901654538UL, 2078946336UL, 
1418537059UL, 1202525920UL, 2530097881UL, 704759480UL, 2484428922UL, 1833969372UL, 661495122UL, 503878844UL, 3287413716UL, 2950835531UL, 1402379354UL, 351314168UL, 4131886119UL, 2033316109UL, 2873973176UL, 1321203603UL, 3316118265UL, 237900321UL, 1316780684UL, 793441242UL, 3281524559UL, 296088733UL, 1730738847UL, 314311643UL, 1388727135UL, 1705533557UL, 3557800292UL, 1553835665UL, 1660074989UL, 291276309UL, 421164833UL, 1318404599UL, 
964731488UL, 3156334112UL, 2076623594UL, 850664906UL, 2293210629UL, 1105350579UL, 335452425UL, 3847487204UL, 645388200UL, 824349799UL, 2789953706UL, 954487767UL, 2755872609UL, 4249786064UL, 3811424903UL, 3937839949UL, 3408594583UL, 1417544262UL, 3159462529UL, 1654848550UL, 624060530UL, 324339737UL, 1908900347UL, 4111078399UL, 3241719305UL, 2294919498UL, 1890540205UL, 3750258343UL, 4190211142UL, 1420776905UL, 2279133729UL, 3716648585UL, 
1690550UL, 3354905256UL, 2519610308UL, 3563975602UL, 3758156132UL, 2658162202UL, 1154211550UL, 1915690212UL, 3505586122UL, 844149171UL, 189880016UL, 1359089498UL, 2249086205UL, 2389487504UL, 1031812215UL, 998719835UL, 1265685672UL, 1970052076UL, 2798611919UL, 3174204115UL, 2973042959UL, 1360991400UL, 1994321680UL, 1684134678UL, 714016907UL, 2283905032UL, 2217962701UL, 182726833UL, 1734988742UL, 2151450260UL, 110719262UL, 3697978033UL, 
1084030545UL, 159906818UL, 767772303UL, 4133333579UL, 1069092002UL, 2364406907UL, 1290801202UL, 42955292UL, 3629845331UL, 1464127305UL, 1616628807UL, 987794861UL, 3222189776UL, 3256744141UL, 2437350057UL, 39991274UL, 3644076751UL, 3142424684UL, 1024703328UL, 443099203UL, 643536212UL, 1487589384UL, 918511196UL, 2755167056UL, 276421624UL, 2492081750UL, 137688638UL, 4246877536UL, 2817867653UL, 1816283755UL, 4246096489UL, 1518475380UL, 
1425765936UL, 2276077438UL, 2640849794UL, 3697925816UL, 4226506771UL, 1491702526UL, 130551477UL, 2897029415UL, 2747033756UL, 2033599579UL, 1844578694UL, 804565809UL, 437451803UL, 677924906UL, 2749065512UL, 3419189841UL, 2446610749UL, 3488484529UL, 470218446UL, 290444026UL, 3272535988UL, 1502147484UL, 611300083UL, 3809285994UL, 2546040767UL, 2853681168UL, 872826112UL, 2859302390UL, 2761919483UL, 4097961150UL, 1434560128UL, 3901654538UL, 
2078946336UL, 1418537059UL, 2725734455UL, 2530097881UL, 704759480UL, 2484428922UL, 1833969372UL, 3999408333UL, 503878844UL, 3287413716UL, 2950835531UL, 1402379354UL, 3861442503UL, 4131886119UL, 2033316109UL, 2873973176UL, 1321203603UL, 1267331405UL, 237900321UL, 1316780684UL, 793441242UL, 3281524559UL, 1273427916UL, 1730738847UL, 314311643UL, 1388727135UL, 1705533557UL, 1474310231UL, 1553835665UL, 1660074989UL, 291276309UL, 421164833UL, 
3884815658UL, 3088049345UL, 3307042227UL, 3228948601UL, 1717605083UL, 1864502063UL, 3799516572UL, 2372822470UL, 2691586476UL, 1172840854UL, 1577099080UL, 870101866UL, 2139291021UL, 406996656UL, 255568268UL, 897760202UL, 674745664UL, 885214361UL, 3753233375UL, 3015215223UL, 1711461259UL, 3241363282UL, 2125360928UL, 2493601640UL, 2350228245UL, 3434627328UL, 2095642963UL, 3360932494UL, 3287396242UL, 4070512427UL, 3415702664UL, 1958354224UL, 
3280206940UL, 3929504236UL, 3390499817UL, 4144225735UL, 3621750606UL, 3205006592UL, 3495743785UL, 269239326UL, 2181299371UL, 2898796651UL, 2613623219UL, 3988711298UL, 2162437858UL, 949553433UL, 3289670000UL, 3559525307UL, 3366925567UL, 2112148665UL, 955626393UL, 1790865381UL, 699223558UL, 3889584301UL, 1020750250UL, 4105283899UL, 2295851818UL, 4045668915UL, 2224770025UL, 766386910UL, 4265157386UL, 89139307UL, 2099710177UL, 1012450874UL, 
1875492446UL, 1927399417UL, 767450812UL, 654474783UL, 4265293038UL, 4041215389UL, 4102336947UL, 4263617328UL, 2135826340UL, 2317231535UL, 3773895729UL, 403151111UL, 1400693138UL, 4255050194UL, 755369466UL, 2325764302UL, 2617301159UL, 4165707294UL, 1206304709UL, 2415645397UL, 4276004841UL, 1457022279UL, 662660652UL, 795140282UL, 828519889UL, 805830562UL, 1179976369UL, 2212548232UL, 755708248UL, 1034682071UL, 899950902UL, 1906046264UL, 
1861009040UL, 310711525UL, 920739741UL, 2322414272UL, 3179236470UL, 81822135UL, 4111390320UL, 1800166783UL, 112253014UL, 688771939UL, 1050990794UL, 3124647483UL, 287052171UL, 1363630156UL, 3447798279UL, 1405733552UL, 3075862538UL, 1682808202UL, 1595154222UL, 1173705692UL, 680713285UL, 2748212230UL, 568610527UL, 3434965538UL, 1114942930UL, 2835858745UL, 2575992250UL, 3243355150UL, 2127580225UL, 1855934450UL, 3915941751UL, 2228679809UL, 
1514780124UL, 1506688039UL, 1033083295UL, 793807083UL, 1120681149UL, 4105670165UL, 3999570340UL, 2083020131UL, 1213356023UL, 3684882757UL, 3375797774UL, 3577986103UL, 2092046164UL, 2593847443UL, 1826450612UL, 367828409UL, 3198272513UL, 1941316667UL, 943707510UL, 907134807UL, 2020457947UL, 1462193665UL, 2964617539UL, 4216491663UL, 2625270800UL, 2395371467UL, 3691003028UL, 3659016793UL, 2381847054UL, 3513105567UL, 3013019506UL, 2731245927UL, 
},
{
1680024716UL, 2112340059UL, 3387475367UL, 2080916186UL, 1431532386UL, 3907378472UL, 2636491350UL, 2176128529UL, 2236616671UL, 3736851460UL, 2604001339UL, 3893075234UL, 3495918635UL, 4116370522UL, 1384310379UL, 3660102574UL, 2030233939UL, 2759207091UL, 49347923UL, 97526506UL, 2566932710UL, 1566181275UL, 3127827248UL, 578401670UL, 1499229308UL, 2581732444UL, 279715551UL, 809690877UL, 1438444015UL, 878935323UL, 1495277039UL, 3417305339UL, 
2858903785UL, 3074075088UL, 603749086UL, 2370669734UL, 391683868UL, 3933465331UL, 2884128106UL, 1478317876UL, 1864988335UL, 2925823809UL, 4133578805UL, 218104493UL, 368652174UL, 1998600344UL, 1109346044UL, 1716435313UL, 415435111UL, 91393686UL, 2536620737UL, 1440068573UL, 481874870UL, 142128108UL, 988825519UL, 2077118779UL, 2858045339UL, 4068162251UL, 115593872UL, 1364244587UL, 3550167006UL, 3728768059UL, 1772423685UL, 2504624145UL, 
248732306UL, 1412607307UL, 4081166331UL, 154438218UL, 1652901877UL, 3932533490UL, 3142799969UL, 3154073676UL, 3112018078UL, 2757873595UL, 2364830126UL, 2855791484UL, 793851407UL, 507785167UL, 263713916UL, 4060700051UL, 3291978358UL, 1584226715UL, 2546417990UL, 450747961UL, 2951067700UL, 2706009093UL, 1788578194UL, 4030171132UL, 2610979903UL, 573420740UL, 4269115622UL, 2180305819UL, 2646894726UL, 716649335UL, 3875715683UL, 853428184UL, 
2436760738UL, 4190071217UL, 2754423535UL, 540698101UL, 4082489821UL, 741976046UL, 267559495UL, 1591532642UL, 2500610323UL, 3203248679UL, 147312102UL, 2772368222UL, 1412987047UL, 2295185573UL, 1932341300UL, 898396308UL, 1837129999UL, 3113914292UL, 2613354524UL, 3141601915UL, 276087167UL, 1887389351UL, 757801450UL, 3752353732UL, 2745818074UL, 1442953464UL, 3802648347UL, 223728071UL, 2169947402UL, 1338125300UL, 3642174036UL, 2794462634UL, 
2326349851UL, 862746036UL, 3577092599UL, 627103363UL, 552173564UL, 4142604459UL, 2310329406UL, 583522272UL, 189323282UL, 1217612313UL, 73550248UL, 2434692829UL, 2757269706UL, 2392210091UL, 3032922600UL, 3573904125UL, 2897178037UL, 2632631469UL, 3085332665UL, 3775619904UL, 2563291734UL, 1351375865UL, 4043427793UL, 1803743084UL, 3112116579UL, 522940594UL, 2690374983UL, 2613871529UL, 3810037031UL, 1765642390UL, 534554747UL, 1930852049UL, 
2264349344UL, 1680024716UL, 2112340059UL, 3387475367UL, 2080916186UL, 75966494UL, 3907378472UL, 2636491350UL, 2176128529UL, 2236616671UL, 2372987046UL, 2604001339UL, 3893075234UL, 3495918635UL, 4116370522UL, 534929913UL, 3660102574UL, 2030233939UL, 2759207091UL, 49347923UL, 987575186UL, 2566932710UL, 1566181275UL, 3127827248UL, 578401670UL, 3731513754UL, 2581732444UL, 279715551UL, 809690877UL, 1438444015UL, 2185866850UL, 1495277039UL, 
3417305339UL, 2858903785UL, 3074075088UL, 4198538376UL, 2370669734UL, 391683868UL, 3933465331UL, 2884128106UL, 1400216510UL, 1864988335UL, 2925823809UL, 4133578805UL, 218104493UL, 2798390374UL, 1998600344UL, 1109346044UL, 1716435313UL, 415435111UL, 1892535124UL, 2536620737UL, 1440068573UL, 481874870UL, 142128108UL, 329082740UL, 2077118779UL, 2858045339UL, 4068162251UL, 115593872UL, 2644000449UL, 3550167006UL, 3728768059UL, 1772423685UL, 
2504624145UL, 2140118619UL, 1412607307UL, 4081166331UL, 154438218UL, 1652901877UL, 3804911318UL, 3142799969UL, 3154073676UL, 3112018078UL, 2757873595UL, 50297646UL, 2855791484UL, 793851407UL, 507785167UL, 263713916UL, 3324588195UL, 3291978358UL, 1584226715UL, 2546417990UL, 450747961UL, 3455625012UL, 2706009093UL, 1788578194UL, 4030171132UL, 2610979903UL, 3835380965UL, 4269115622UL, 2180305819UL, 2646894726UL, 716649335UL, 2607142354UL, 
853428184UL, 2436760738UL, 4190071217UL, 2754423535UL, 456808691UL, 4082489821UL, 741976046UL, 267559495UL, 1591532642UL, 2722205042UL, 3203248679UL, 147312102UL, 2772368222UL, 1412987047UL, 1950543946UL, 1932341300UL, 898396308UL, 1837129999UL, 3113914292UL, 428616392UL, 3141601915UL, 276087167UL, 1887389351UL, 757801450UL, 963534966UL, 2745818074UL, 1442953464UL, 3802648347UL, 223728071UL, 229039300UL, 1338125300UL, 3642174036UL, 
2794462634UL, 2326349851UL, 206115203UL, 3577092599UL, 627103363UL, 552173564UL, 4142604459UL, 1492461846UL, 583522272UL, 189323282UL, 1217612313UL, 73550248UL, 3552211807UL, 2757269706UL, 2392210091UL, 3032922600UL, 3573904125UL, 810640644UL, 2632631469UL, 3085332665UL, 3775619904UL, 2563291734UL, 922608790UL, 4043427793UL, 1803743084UL, 3112116579UL, 522940594UL, 1785093944UL, 2613871529UL, 3810037031UL, 1765642390UL, 534554747UL, 
3528050076UL, 2264349344UL, 1680024716UL, 2112340059UL, 3387475367UL, 3295682653UL, 75966494UL, 3907378472UL, 2636491350UL, 2176128529UL, 3574915532UL, 2372987046UL, 2604001339UL, 3893075234UL, 3495918635UL, 1280296085UL, 534929913UL, 3660102574UL, 2030233939UL, 2759207091UL, 299776535UL, 987575186UL, 2566932710UL, 1566181275UL, 3127827248UL, 3874691533UL, 3731513754UL, 2581732444UL, 279715551UL, 809690877UL, 3100791084UL, 2185866850UL, 
1495277039UL, 3417305339UL, 2858903785UL, 1310351481UL, 4198538376UL, 2370669734UL, 391683868UL, 3933465331UL, 2749085130UL, 1400216510UL, 1864988335UL, 2925823809UL, 4133578805UL, 3352814594UL, 2798390374UL, 1998600344UL, 1109346044UL, 1716435313UL, 1571752941UL, 1892535124UL, 2536620737UL, 1440068573UL, 481874870UL, 2485033697UL, 329082740UL, 2077118779UL, 2858045339UL, 4068162251UL, 3837440666UL, 2644000449UL, 3550167006UL, 3728768059UL, 
1772423685UL, 1176559812UL, 2140118619UL, 1412607307UL, 4081166331UL, 154438218UL, 2902622972UL, 3804911318UL, 3142799969UL, 3154073676UL, 3112018078UL, 2403391233UL, 50297646UL, 2855791484UL, 793851407UL, 507785167UL, 2351826747UL, 3324588195UL, 3291978358UL, 1584226715UL, 2546417990UL, 746876926UL, 3455625012UL, 2706009093UL, 1788578194UL, 4030171132UL, 3779307353UL, 3835380965UL, 4269115622UL, 2180305819UL, 2646894726UL, 2602235234UL, 
2607142354UL, 853428184UL, 2436760738UL, 4190071217UL, 2066757692UL, 456808691UL, 4082489821UL, 741976046UL, 267559495UL, 3001080633UL, 2722205042UL, 3203248679UL, 147312102UL, 2772368222UL, 89950260UL, 1950543946UL, 1932341300UL, 898396308UL, 1837129999UL, 947911286UL, 428616392UL, 3141601915UL, 276087167UL, 1887389351UL, 2583987247UL, 963534966UL, 2745818074UL, 1442953464UL, 3802648347UL, 4229124441UL, 229039300UL, 1338125300UL, 
3642174036UL, 2794462634UL, 2472155633UL, 206115203UL, 3577092599UL, 627103363UL, 552173564UL, 2586882739UL, 1492461846UL, 583522272UL, 189323282UL, 1217612313UL, 3501549884UL, 3552211807UL, 2757269706UL, 2392210091UL, 3032922600UL, 740675778UL, 810640644UL, 2632631469UL, 3085332665UL, 3775619904UL, 3643289881UL, 922608790UL, 4043427793UL, 1803743084UL, 3112116579UL, 2213337398UL, 1785093944UL, 2613871529UL, 3810037031UL, 1765642390UL, 
762472016UL, 3528050076UL, 2264349344UL, 1680024716UL, 2112340059UL, 1372272974UL, 3295682653UL, 75966494UL, 3907378472UL, 2636491350UL, 3117471955UL, 3574915532UL, 2372987046UL, 2604001339UL, 3893075234UL, 915576383UL, 1280296085UL, 534929913UL, 3660102574UL, 2030233939UL, 346368350UL, 299776535UL, 987575186UL, 2566932710UL, 1566181275UL, 3535223896UL, 3874691533UL, 3731513754UL, 2581732444UL, 279715551UL, 2456894951UL, 3100791084UL, 
2185866850UL, 1495277039UL, 3417305339UL, 1618871086UL, 1310351481UL, 4198538376UL, 2370669734UL, 391683868UL, 2009676005UL, 2749085130UL, 1400216510UL, 1864988335UL, 2925823809UL, 58955107UL, 3352814594UL, 2798390374UL, 1998600344UL, 1109346044UL, 3273979614UL, 1571752941UL, 1892535124UL, 2536620737UL, 1440068573UL, 1174168447UL, 2485033697UL, 329082740UL, 2077118779UL, 2858045339UL, 4062921629UL, 3837440666UL, 2644000449UL, 3550167006UL, 
3728768059UL, 2642133401UL, 1176559812UL, 2140118619UL, 1412607307UL, 4081166331UL, 3124905304UL, 2902622972UL, 3804911318UL, 3142799969UL, 3154073676UL, 1449454613UL, 2403391233UL, 50297646UL, 2855791484UL, 793851407UL, 3514201526UL, 2351826747UL, 3324588195UL, 3291978358UL, 1584226715UL, 3636681672UL, 746876926UL, 3455625012UL, 2706009093UL, 1788578194UL, 3451519459UL, 3779307353UL, 3835380965UL, 4269115622UL, 2180305819UL, 3987989524UL, 
2602235234UL, 2607142354UL, 853428184UL, 2436760738UL, 2151617107UL, 2066757692UL, 456808691UL, 4082489821UL, 741976046UL, 3590081269UL, 3001080633UL, 2722205042UL, 3203248679UL, 147312102UL, 3432947806UL, 89950260UL, 1950543946UL, 1932341300UL, 898396308UL, 3828432864UL, 947911286UL, 428616392UL, 3141601915UL, 276087167UL, 2517666433UL, 2583987247UL, 963534966UL, 2745818074UL, 1442953464UL, 2223986807UL, 4229124441UL, 229039300UL, 
1338125300UL, 3642174036UL, 1053796945UL, 2472155633UL, 206115203UL, 3577092599UL, 627103363UL, 1113276084UL, 2586882739UL, 1492461846UL, 583522272UL, 189323282UL, 1490604990UL, 3501549884UL, 3552211807UL, 2757269706UL, 2392210091UL, 3545407532UL, 740675778UL, 810640644UL, 2632631469UL, 3085332665UL, 755862267UL, 3643289881UL, 922608790UL, 4043427793UL, 1803743084UL, 1954166630UL, 2213337398UL, 1785093944UL, 2613871529UL, 3810037031UL, 
3042935707UL, 3162182177UL, 2791346436UL, 1901925289UL, 863100941UL, 3367519168UL, 1972623238UL, 3664303070UL, 604922059UL, 3026817982UL, 1436412310UL, 4096180631UL, 1597561857UL, 4206212303UL, 4127914332UL, 3228677359UL, 3985733659UL, 3597290113UL, 4251197894UL, 3451370603UL, 609679338UL, 3360835257UL, 1372239885UL, 638572328UL, 3806422284UL, 3974147336UL, 1804280837UL, 4209089291UL, 2021797469UL, 3557188838UL, 409727186UL, 2114649178UL, 
687702120UL, 2542445992UL, 1235991799UL, 460479179UL, 2008348175UL, 887884478UL, 3942327811UL, 2999928223UL, 4171339789UL, 2286339235UL, 1293442231UL, 1575942850UL, 76122475UL, 1440527701UL, 2006558403UL, 1544148172UL, 895899367UL, 681826913UL, 4094701935UL, 3995413790UL, 1027509154UL, 2264990896UL, 1938238113UL, 213430250UL, 222469320UL, 609726517UL, 3581538106UL, 492802663UL, 120480843UL, 1720004062UL, 1132674507UL, 911082758UL, 
2909148131UL, 566658805UL, 3964114445UL, 3483602509UL, 1793438750UL, 165562604UL, 3641830063UL, 2394205521UL, 3404874822UL, 1672998096UL, 916151953UL, 1141264477UL, 3171661340UL, 3803396219UL, 3018337382UL, 1863902683UL, 2474641928UL, 3250365071UL, 3897886220UL, 1219701051UL, 51332576UL, 1358614881UL, 1707407492UL, 3670647816UL, 923357625UL, 343687395UL, 3991339686UL, 3913575403UL, 1267727936UL, 4001357856UL, 3820224848UL, 2942896724UL, 
3505936742UL, 1403285299UL, 1992762049UL, 567748449UL, 2202721585UL, 2781324216UL, 1724850068UL, 2408314541UL, 3073975813UL, 3992810029UL, 2475242354UL, 540562053UL, 2185198943UL, 3759352041UL, 3373885614UL, 1132999410UL, 1097554565UL, 4089342358UL, 3239542922UL, 2451748646UL, 407290679UL, 3188103200UL, 1708016248UL, 26848241UL, 2796711130UL, 3090711568UL, 4068389322UL, 3420916085UL, 3137567033UL, 2877819818UL, 22133454UL, 4629160UL, 
3703695249UL, 1920151708UL, 1175452162UL, 130015299UL, 3331834713UL, 1099225384UL, 689254331UL, 1851083761UL, 2654970209UL, 3259297936UL, 3742819314UL, 3524284766UL, 2291819083UL, 3494031861UL, 16242889UL, 3545082774UL, 1997878108UL, 777447699UL, 4244916543UL, 3508640253UL, 3782278393UL, 2107258964UL, 2139074576UL, 1383217899UL, 2337934322UL, 3181899620UL, 1285955765UL, 2989610020UL, 3326862146UL, 1168587380UL, 801203532UL, 3020809957UL, 
},
{
3810471203UL, 1017064446UL, 1595207573UL, 441087832UL, 3326746890UL, 3294064431UL, 167972517UL, 3625210015UL, 1011845006UL, 2980240819UL, 1778354660UL, 3041730987UL, 1598611350UL, 2015169745UL, 2321724978UL, 3390812967UL, 2432904511UL, 113261909UL, 3957193232UL, 3806115908UL, 2965828929UL, 2035392295UL, 3500116619UL, 2881232416UL, 1672212265UL, 1607201428UL, 425148945UL, 1262591961UL, 2221781268UL, 4215047456UL, 2148245850UL, 2787488981UL, 
1077262192UL, 2085467561UL, 3053954888UL, 3584435116UL, 3013084787UL, 287099941UL, 1290407232UL, 4078552287UL, 2658945475UL, 4251530898UL, 2403086478UL, 2884923598UL, 3545110453UL, 4105390090UL, 343200643UL, 3189888821UL, 4086304363UL, 3466483195UL, 259435633UL, 2846377387UL, 497258846UL, 272775541UL, 985737911UL, 2957688879UL, 2180784344UL, 3434619542UL, 3643384838UL, 2228652440UL, 3107480718UL, 2208729807UL, 596436263UL, 3255120711UL, 
3248886970UL, 519242965UL, 602979109UL, 1619614UL, 1391563565UL, 56262588UL, 1584463910UL, 1849038201UL, 728022295UL, 848624947UL, 1813827408UL, 428214945UL, 1246345586UL, 4213351865UL, 168985863UL, 456608054UL, 4277869380UL, 3886828599UL, 2264054549UL, 3110967170UL, 3138175314UL, 2649164828UL, 3369378320UL, 3648350039UL, 3524848759UL, 1468470706UL, 3558859222UL, 2669673235UL, 831851874UL, 4285651092UL, 4224147373UL, 1088456706UL, 
231954609UL, 3118005852UL, 225508069UL, 883105389UL, 856371341UL, 2001356578UL, 639336670UL, 2363501707UL, 3622399552UL, 4024065226UL, 1093546838UL, 4263608561UL, 1852072422UL, 425195042UL, 2441102396UL, 296426333UL, 384641750UL, 3559334435UL, 1757327033UL, 1016016207UL, 3595686646UL, 24777793UL, 623926105UL, 2169195923UL, 1779396793UL, 646997837UL, 1459728476UL, 2644865980UL, 1994581089UL, 3956278544UL, 919592580UL, 2153558858UL, 
2029633394UL, 3837501009UL, 4016560170UL, 484838096UL, 3652199054UL, 1971790561UL, 605295089UL, 637470291UL, 278970544UL, 3574824693UL, 295866521UL, 1755035156UL, 2542341803UL, 1588716357UL, 1502596918UL, 4124554133UL, 3547049843UL, 1768033045UL, 1531734630UL, 101448323UL, 3233017580UL, 1793222944UL, 3187853500UL, 186000900UL, 803444571UL, 2820254958UL, 2009384608UL, 2384668855UL, 2222812920UL, 633608665UL, 2028480056UL, 1258028235UL, 
545095949UL, 3810471203UL, 1017064446UL, 1595207573UL, 441087832UL, 899068662UL, 3294064431UL, 167972517UL, 3625210015UL, 1011845006UL, 3951305793UL, 1778354660UL, 3041730987UL, 1598611350UL, 2015169745UL, 1885149424UL, 3390812967UL, 2432904511UL, 113261909UL, 3957193232UL, 3953443155UL, 2965828929UL, 2035392295UL, 3500116619UL, 2881232416UL, 329153573UL, 1607201428UL, 425148945UL, 1262591961UL, 2221781268UL, 78028761UL, 2148245850UL, 
2787488981UL, 1077262192UL, 2085467561UL, 647235899UL, 3584435116UL, 3013084787UL, 287099941UL, 1290407232UL, 1467385694UL, 2658945475UL, 4251530898UL, 2403086478UL, 2884923598UL, 3489351040UL, 4105390090UL, 343200643UL, 3189888821UL, 4086304363UL, 3521512280UL, 259435633UL, 2846377387UL, 497258846UL, 272775541UL, 1367093111UL, 2957688879UL, 2180784344UL, 3434619542UL, 3643384838UL, 411877686UL, 3107480718UL, 2208729807UL, 596436263UL, 
3255120711UL, 584605030UL, 519242965UL, 602979109UL, 1619614UL, 1391563565UL, 3902518209UL, 1584463910UL, 1849038201UL, 728022295UL, 848624947UL, 1932969318UL, 428214945UL, 1246345586UL, 4213351865UL, 168985863UL, 2770345237UL, 4277869380UL, 3886828599UL, 2264054549UL, 3110967170UL, 2953581033UL, 2649164828UL, 3369378320UL, 3648350039UL, 3524848759UL, 2380353977UL, 3558859222UL, 2669673235UL, 831851874UL, 4285651092UL, 1214052447UL, 
1088456706UL, 231954609UL, 3118005852UL, 225508069UL, 1766983646UL, 856371341UL, 2001356578UL, 639336670UL, 2363501707UL, 1782816591UL, 4024065226UL, 1093546838UL, 4263608561UL, 1852072422UL, 1149716600UL, 2441102396UL, 296426333UL, 384641750UL, 3559334435UL, 2391309970UL, 1016016207UL, 3595686646UL, 24777793UL, 623926105UL, 362098678UL, 1779396793UL, 646997837UL, 1459728476UL, 2644865980UL, 3238673748UL, 3956278544UL, 919592580UL, 
2153558858UL, 2029633394UL, 115778559UL, 4016560170UL, 484838096UL, 3652199054UL, 1971790561UL, 737357475UL, 637470291UL, 278970544UL, 3574824693UL, 295866521UL, 3989745853UL, 2542341803UL, 1588716357UL, 1502596918UL, 4124554133UL, 3016849744UL, 1768033045UL, 1531734630UL, 101448323UL, 3233017580UL, 4157527581UL, 3187853500UL, 186000900UL, 803444571UL, 2820254958UL, 1980528062UL, 2384668855UL, 2222812920UL, 633608665UL, 2028480056UL, 
3166710281UL, 545095949UL, 3810471203UL, 1017064446UL, 1595207573UL, 693962828UL, 899068662UL, 3294064431UL, 167972517UL, 3625210015UL, 1486040398UL, 3951305793UL, 1778354660UL, 3041730987UL, 1598611350UL, 2859363132UL, 1885149424UL, 3390812967UL, 2432904511UL, 113261909UL, 664880478UL, 3953443155UL, 2965828929UL, 2035392295UL, 3500116619UL, 558081801UL, 329153573UL, 1607201428UL, 425148945UL, 1262591961UL, 3716247699UL, 78028761UL, 
2148245850UL, 2787488981UL, 1077262192UL, 4206362947UL, 647235899UL, 3584435116UL, 3013084787UL, 287099941UL, 2536781098UL, 1467385694UL, 2658945475UL, 4251530898UL, 2403086478UL, 3075072413UL, 3489351040UL, 4105390090UL, 343200643UL, 3189888821UL, 2540485172UL, 3521512280UL, 259435633UL, 2846377387UL, 497258846UL, 2442427327UL, 1367093111UL, 2957688879UL, 2180784344UL, 3434619542UL, 1593967423UL, 411877686UL, 3107480718UL, 2208729807UL, 
596436263UL, 1048686529UL, 584605030UL, 519242965UL, 602979109UL, 1619614UL, 2072745381UL, 3902518209UL, 1584463910UL, 1849038201UL, 728022295UL, 846033949UL, 1932969318UL, 428214945UL, 1246345586UL, 4213351865UL, 1066373275UL, 2770345237UL, 4277869380UL, 3886828599UL, 2264054549UL, 1877859690UL, 2953581033UL, 2649164828UL, 3369378320UL, 3648350039UL, 2537763389UL, 2380353977UL, 3558859222UL, 2669673235UL, 831851874UL, 522748140UL, 
1214052447UL, 1088456706UL, 231954609UL, 3118005852UL, 1381269315UL, 1766983646UL, 856371341UL, 2001356578UL, 639336670UL, 667275675UL, 1782816591UL, 4024065226UL, 1093546838UL, 4263608561UL, 2057337961UL, 1149716600UL, 2441102396UL, 296426333UL, 384641750UL, 340523210UL, 2391309970UL, 1016016207UL, 3595686646UL, 24777793UL, 3094832341UL, 362098678UL, 1779396793UL, 646997837UL, 1459728476UL, 1169681568UL, 3238673748UL, 3956278544UL, 
919592580UL, 2153558858UL, 388335108UL, 115778559UL, 4016560170UL, 484838096UL, 3652199054UL, 1764858181UL, 737357475UL, 637470291UL, 278970544UL, 3574824693UL, 3671458900UL, 3989745853UL, 2542341803UL, 1588716357UL, 1502596918UL, 2102871406UL, 3016849744UL, 1768033045UL, 1531734630UL, 101448323UL, 3964942332UL, 4157527581UL, 3187853500UL, 186000900UL, 803444571UL, 3425652083UL, 1980528062UL, 2384668855UL, 2222812920UL, 633608665UL, 
3035373876UL, 3166710281UL, 545095949UL, 3810471203UL, 1017064446UL, 669282349UL, 693962828UL, 899068662UL, 3294064431UL, 167972517UL, 2007256988UL, 1486040398UL, 3951305793UL, 1778354660UL, 3041730987UL, 2827768941UL, 2859363132UL, 1885149424UL, 3390812967UL, 2432904511UL, 3700915653UL, 664880478UL, 3953443155UL, 2965828929UL, 2035392295UL, 1461208330UL, 558081801UL, 329153573UL, 1607201428UL, 425148945UL, 1700881129UL, 3716247699UL, 
78028761UL, 2148245850UL, 2787488981UL, 2706775080UL, 4206362947UL, 647235899UL, 3584435116UL, 3013084787UL, 2958545221UL, 2536781098UL, 1467385694UL, 2658945475UL, 4251530898UL, 2241012567UL, 3075072413UL, 3489351040UL, 4105390090UL, 343200643UL, 490164649UL, 2540485172UL, 3521512280UL, 259435633UL, 2846377387UL, 4073611831UL, 2442427327UL, 1367093111UL, 2957688879UL, 2180784344UL, 1835510773UL, 1593967423UL, 411877686UL, 3107480718UL, 
2208729807UL, 3306732468UL, 1048686529UL, 584605030UL, 519242965UL, 602979109UL, 2978864605UL, 2072745381UL, 3902518209UL, 1584463910UL, 1849038201UL, 3284115169UL, 846033949UL, 1932969318UL, 428214945UL, 1246345586UL, 194166002UL, 1066373275UL, 2770345237UL, 4277869380UL, 3886828599UL, 1874087886UL, 1877859690UL, 2953581033UL, 2649164828UL, 3369378320UL, 4145454028UL, 2537763389UL, 2380353977UL, 3558859222UL, 2669673235UL, 739345884UL, 
522748140UL, 1214052447UL, 1088456706UL, 231954609UL, 3605603781UL, 1381269315UL, 1766983646UL, 856371341UL, 2001356578UL, 2049940324UL, 667275675UL, 1782816591UL, 4024065226UL, 1093546838UL, 152524382UL, 2057337961UL, 1149716600UL, 2441102396UL, 296426333UL, 3195130788UL, 340523210UL, 2391309970UL, 1016016207UL, 3595686646UL, 180492441UL, 3094832341UL, 362098678UL, 1779396793UL, 646997837UL, 2458167607UL, 1169681568UL, 3238673748UL, 
3956278544UL, 919592580UL, 3421005218UL, 388335108UL, 115778559UL, 4016560170UL, 484838096UL, 2649676374UL, 1764858181UL, 737357475UL, 637470291UL, 278970544UL, 2236401278UL, 3671458900UL, 3989745853UL, 2542341803UL, 1588716357UL, 1241570134UL, 2102871406UL, 3016849744UL, 1768033045UL, 1531734630UL, 1765654724UL, 3964942332UL, 4157527581UL, 3187853500UL, 186000900UL, 2189716659UL, 3425652083UL, 1980528062UL, 2384668855UL, 2222812920UL, 
3955466207UL, 2426547616UL, 3846752458UL, 3015538636UL, 2342593365UL, 3613176865UL, 3484860981UL, 4278370194UL, 1979143878UL, 1159739458UL, 3714038404UL, 396530346UL, 3276617756UL, 3293940597UL, 4050183149UL, 1418571985UL, 402563753UL, 2702853013UL, 2289900621UL, 2267058511UL, 3482161995UL, 3375026019UL, 1988640267UL, 3674438074UL, 4124612310UL, 1057883705UL, 434730475UL, 3210959778UL, 4102029739UL, 2140938750UL, 3176753074UL, 2356971512UL, 
3969685288UL, 1556275580UL, 2648433428UL, 3959375381UL, 478841344UL, 1496991528UL, 3309714981UL, 569990368UL, 3660587501UL, 2550379574UL, 1177519842UL, 2652707373UL, 543943404UL, 1912551128UL, 2278132032UL, 1484596780UL, 3570913985UL, 2982401320UL, 1413776035UL, 3177275459UL, 3036211597UL, 1091740466UL, 3448424311UL, 1445187645UL, 3205024875UL, 3135795254UL, 823738729UL, 3742134467UL, 4066657438UL, 1226311678UL, 2403605393UL, 537573634UL, 
3457409768UL, 1940233423UL, 1761431281UL, 1129427309UL, 2443661283UL, 3200814257UL, 4094866249UL, 2666869754UL, 604785127UL, 2213464116UL, 3002782918UL, 468024929UL, 2490681314UL, 3666681384UL, 1583346053UL, 3049668798UL, 3592153237UL, 2573082448UL, 3082970021UL, 1461796708UL, 832526980UL, 3728763274UL, 355291229UL, 4029588456UL, 832358279UL, 2125298737UL, 3681181038UL, 3245535160UL, 1333342738UL, 1868897492UL, 446790068UL, 1278093154UL, 
2090118615UL, 4158925515UL, 4062165914UL, 822726809UL, 1154960183UL, 286518382UL, 1170424276UL, 2554691236UL, 3674133415UL, 2765714969UL, 2330865375UL, 1908307334UL, 3537287082UL, 410252600UL, 3977128218UL, 424210327UL, 2919071615UL, 2715518134UL, 64568844UL, 480972649UL, 2488797168UL, 1302817038UL, 2213995265UL, 4229997295UL, 2200797852UL, 109368057UL, 3033807022UL, 1907400078UL, 645977948UL, 1410909090UL, 3700787906UL, 3375062371UL, 
629087832UL, 1344281719UL, 4249981139UL, 3457543297UL, 1218556849UL, 864222854UL, 1458445945UL, 914545469UL, 3451164212UL, 1088025757UL, 1129933985UL, 953788883UL, 2406172924UL, 170364546UL, 3505490646UL, 1027553899UL, 2864067776UL, 436854871UL, 1342782209UL, 761167471UL, 2660173631UL, 4159507498UL, 4172028400UL, 2442254644UL, 2110123720UL, 2315991253UL, 873066601UL, 1725470559UL, 3831299052UL, 678672031UL, 1585431329UL, 3495750550UL, 
},
{
1998393432UL, 2665389278UL, 3989307699UL, 3267631636UL, 3861682977UL, 3243522970UL, 1243992413UL, 2200497260UL, 3821883021UL, 4187123083UL, 3451270040UL, 3044132745UL, 2101287249UL, 2340839784UL, 227040990UL, 1724350416UL, 3228881240UL, 3123386528UL, 4279362126UL, 3098224464UL, 2635534069UL, 3622906431UL, 206207480UL, 1894245533UL, 2152374527UL, 1011223653UL, 7271757UL, 2972858087UL, 207942127UL, 3355362797UL, 2593296740UL, 174093751UL, 
3713822176UL, 4212355586UL, 3335605224UL, 1171716408UL, 2867257989UL, 1522213957UL, 2016192462UL, 4229688395UL, 2174928148UL, 1468226225UL, 3938290338UL, 493240317UL, 3229423344UL, 2585475729UL, 3112454413UL, 1881171707UL, 2555908056UL, 1997546352UL, 380428329UL, 3341885423UL, 3307510279UL, 3519476676UL, 3613100811UL, 2555826262UL, 109341943UL, 2382715395UL, 3883409616UL, 1593551879UL, 2163678014UL, 3379783137UL, 2810374300UL, 1516064864UL, 
561144874UL, 316017838UL, 1899237567UL, 70857401UL, 3435185465UL, 4234661323UL, 2580352177UL, 32879620UL, 4171670150UL, 1986234067UL, 3589478191UL, 2073132526UL, 2603712175UL, 377997975UL, 2474419397UL, 3110698341UL, 812664089UL, 1778922726UL, 1686111212UL, 972784138UL, 3936486236UL, 2711468739UL, 423435866UL, 1661961159UL, 802312780UL, 1868728136UL, 1760295704UL, 3357409828UL, 215039860UL, 683184627UL, 4019111064UL, 3609261689UL, 
2167554309UL, 1831085281UL, 3389357802UL, 4193421575UL, 628277197UL, 2900207619UL, 993609502UL, 3429627083UL, 2636466084UL, 3652352199UL, 1780133580UL, 1670387713UL, 4086070210UL, 4004540729UL, 783029246UL, 2165667566UL, 1739001057UL, 377639972UL, 1102689625UL, 1945278055UL, 3941185940UL, 3685368326UL, 1881761572UL, 2201338934UL, 801752UL, 2729497735UL, 492844690UL, 2998826141UL, 3844964457UL, 3679088359UL, 2196391660UL, 4222269404UL, 
357321611UL, 3727170055UL, 1819614072UL, 2348798457UL, 4294366646UL, 1952884323UL, 3574345216UL, 2040734807UL, 232392443UL, 4183498179UL, 2614866055UL, 112120292UL, 3624018350UL, 3340709877UL, 3097507723UL, 1268833488UL, 3570501956UL, 3338260086UL, 293812421UL, 3683058169UL, 1147960351UL, 283731890UL, 2171233479UL, 1830154455UL, 4036602681UL, 1996981699UL, 132803834UL, 40256165UL, 2158110401UL, 3575159090UL, 3196553513UL, 3559872992UL, 
3402884675UL, 1998393432UL, 2665389278UL, 3989307699UL, 3267631636UL, 3617519767UL, 3243522970UL, 1243992413UL, 2200497260UL, 3821883021UL, 3715729085UL, 3451270040UL, 3044132745UL, 2101287249UL, 2340839784UL, 3173635549UL, 1724350416UL, 3228881240UL, 3123386528UL, 4279362126UL, 2287520039UL, 2635534069UL, 3622906431UL, 206207480UL, 1894245533UL, 96723416UL, 1011223653UL, 7271757UL, 2972858087UL, 207942127UL, 1668335352UL, 2593296740UL, 
174093751UL, 3713822176UL, 4212355586UL, 49226793UL, 1171716408UL, 2867257989UL, 1522213957UL, 2016192462UL, 118712412UL, 2174928148UL, 1468226225UL, 3938290338UL, 493240317UL, 3788174304UL, 2585475729UL, 3112454413UL, 1881171707UL, 2555908056UL, 3351139844UL, 380428329UL, 3341885423UL, 3307510279UL, 3519476676UL, 1368994724UL, 2555826262UL, 109341943UL, 2382715395UL, 3883409616UL, 1561509458UL, 2163678014UL, 3379783137UL, 2810374300UL, 
1516064864UL, 2313252274UL, 316017838UL, 1899237567UL, 70857401UL, 3435185465UL, 2585770746UL, 2580352177UL, 32879620UL, 4171670150UL, 1986234067UL, 3317983509UL, 2073132526UL, 2603712175UL, 377997975UL, 2474419397UL, 908728599UL, 812664089UL, 1778922726UL, 1686111212UL, 972784138UL, 1992540005UL, 2711468739UL, 423435866UL, 1661961159UL, 802312780UL, 907108769UL, 1760295704UL, 3357409828UL, 215039860UL, 683184627UL, 2806826652UL, 
3609261689UL, 2167554309UL, 1831085281UL, 3389357802UL, 2755692689UL, 628277197UL, 2900207619UL, 993609502UL, 3429627083UL, 3605915742UL, 3652352199UL, 1780133580UL, 1670387713UL, 4086070210UL, 3717326627UL, 783029246UL, 2165667566UL, 1739001057UL, 377639972UL, 2355216626UL, 1945278055UL, 3941185940UL, 3685368326UL, 1881761572UL, 4024097818UL, 801752UL, 2729497735UL, 492844690UL, 2998826141UL, 2719601647UL, 3679088359UL, 2196391660UL, 
4222269404UL, 357321611UL, 1319821972UL, 1819614072UL, 2348798457UL, 4294366646UL, 1952884323UL, 3573866689UL, 2040734807UL, 232392443UL, 4183498179UL, 2614866055UL, 440744432UL, 3624018350UL, 3340709877UL, 3097507723UL, 1268833488UL, 224895395UL, 3338260086UL, 293812421UL, 3683058169UL, 1147960351UL, 3433425235UL, 2171233479UL, 1830154455UL, 4036602681UL, 1996981699UL, 2875889721UL, 40256165UL, 2158110401UL, 3575159090UL, 3196553513UL, 
1094082574UL, 3402884675UL, 1998393432UL, 2665389278UL, 3989307699UL, 4068940467UL, 3617519767UL, 3243522970UL, 1243992413UL, 2200497260UL, 441678457UL, 3715729085UL, 3451270040UL, 3044132745UL, 2101287249UL, 2181502237UL, 3173635549UL, 1724350416UL, 3228881240UL, 3123386528UL, 1968352124UL, 2287520039UL, 2635534069UL, 3622906431UL, 206207480UL, 2065093599UL, 96723416UL, 1011223653UL, 7271757UL, 2972858087UL, 1094044749UL, 1668335352UL, 
2593296740UL, 174093751UL, 3713822176UL, 2887397643UL, 49226793UL, 1171716408UL, 2867257989UL, 1522213957UL, 984348433UL, 118712412UL, 2174928148UL, 1468226225UL, 3938290338UL, 2279430036UL, 3788174304UL, 2585475729UL, 3112454413UL, 1881171707UL, 4247636500UL, 3351139844UL, 380428329UL, 3341885423UL, 3307510279UL, 2887754196UL, 1368994724UL, 2555826262UL, 109341943UL, 2382715395UL, 2836761616UL, 1561509458UL, 2163678014UL, 3379783137UL, 
2810374300UL, 1635278016UL, 2313252274UL, 316017838UL, 1899237567UL, 70857401UL, 3481535811UL, 2585770746UL, 2580352177UL, 32879620UL, 4171670150UL, 2248003250UL, 3317983509UL, 2073132526UL, 2603712175UL, 377997975UL, 3286162818UL, 908728599UL, 812664089UL, 1778922726UL, 1686111212UL, 4024815755UL, 1992540005UL, 2711468739UL, 423435866UL, 1661961159UL, 2257259057UL, 907108769UL, 1760295704UL, 3357409828UL, 215039860UL, 3917391198UL, 
2806826652UL, 3609261689UL, 2167554309UL, 1831085281UL, 4238043113UL, 2755692689UL, 628277197UL, 2900207619UL, 993609502UL, 2036092353UL, 3605915742UL, 3652352199UL, 1780133580UL, 1670387713UL, 118446953UL, 3717326627UL, 783029246UL, 2165667566UL, 1739001057UL, 203160626UL, 2355216626UL, 1945278055UL, 3941185940UL, 3685368326UL, 546361979UL, 4024097818UL, 801752UL, 2729497735UL, 492844690UL, 1023017124UL, 2719601647UL, 3679088359UL, 
2196391660UL, 4222269404UL, 621859651UL, 1319821972UL, 1819614072UL, 2348798457UL, 4294366646UL, 1114888560UL, 3573866689UL, 2040734807UL, 232392443UL, 4183498179UL, 3959504609UL, 440744432UL, 3624018350UL, 3340709877UL, 3097507723UL, 3613295037UL, 224895395UL, 3338260086UL, 293812421UL, 3683058169UL, 1655305863UL, 3433425235UL, 2171233479UL, 1830154455UL, 4036602681UL, 3731384097UL, 2875889721UL, 40256165UL, 2158110401UL, 3575159090UL, 
1847744924UL, 1094082574UL, 3402884675UL, 1998393432UL, 2665389278UL, 3781866777UL, 4068940467UL, 3617519767UL, 3243522970UL, 1243992413UL, 2723708256UL, 441678457UL, 3715729085UL, 3451270040UL, 3044132745UL, 4013832842UL, 2181502237UL, 3173635549UL, 1724350416UL, 3228881240UL, 2092292494UL, 1968352124UL, 2287520039UL, 2635534069UL, 3622906431UL, 3186333458UL, 2065093599UL, 96723416UL, 1011223653UL, 7271757UL, 649658033UL, 1094044749UL, 
1668335352UL, 2593296740UL, 174093751UL, 4159420309UL, 2887397643UL, 49226793UL, 1171716408UL, 2867257989UL, 2590077953UL, 984348433UL, 118712412UL, 2174928148UL, 1468226225UL, 1065322711UL, 2279430036UL, 3788174304UL, 2585475729UL, 3112454413UL, 3932517386UL, 4247636500UL, 3351139844UL, 380428329UL, 3341885423UL, 1285273904UL, 2887754196UL, 1368994724UL, 2555826262UL, 109341943UL, 2318470582UL, 2836761616UL, 1561509458UL, 2163678014UL, 
3379783137UL, 674658583UL, 1635278016UL, 2313252274UL, 316017838UL, 1899237567UL, 2192372173UL, 3481535811UL, 2585770746UL, 2580352177UL, 32879620UL, 300323274UL, 2248003250UL, 3317983509UL, 2073132526UL, 2603712175UL, 3086543917UL, 3286162818UL, 908728599UL, 812664089UL, 1778922726UL, 2263290659UL, 4024815755UL, 1992540005UL, 2711468739UL, 423435866UL, 819027349UL, 2257259057UL, 907108769UL, 1760295704UL, 3357409828UL, 1142221093UL, 
3917391198UL, 2806826652UL, 3609261689UL, 2167554309UL, 4108155875UL, 4238043113UL, 2755692689UL, 628277197UL, 2900207619UL, 3041719497UL, 2036092353UL, 3605915742UL, 3652352199UL, 1780133580UL, 2397410862UL, 118446953UL, 3717326627UL, 783029246UL, 2165667566UL, 2721690354UL, 203160626UL, 2355216626UL, 1945278055UL, 3941185940UL, 2768842108UL, 546361979UL, 4024097818UL, 801752UL, 2729497735UL, 4045063232UL, 1023017124UL, 2719601647UL, 
3679088359UL, 2196391660UL, 2666107451UL, 621859651UL, 1319821972UL, 1819614072UL, 2348798457UL, 3555102623UL, 1114888560UL, 3573866689UL, 2040734807UL, 232392443UL, 3359040541UL, 3959504609UL, 440744432UL, 3624018350UL, 3340709877UL, 1477919696UL, 3613295037UL, 224895395UL, 3338260086UL, 293812421UL, 4210187101UL, 1655305863UL, 3433425235UL, 2171233479UL, 1830154455UL, 4150241150UL, 3731384097UL, 2875889721UL, 40256165UL, 2158110401UL, 
3350246687UL, 455561037UL, 2250400255UL, 3192153445UL, 3258870230UL, 1500391873UL, 4142878334UL, 1155955691UL, 1483275844UL, 4189436981UL, 323745948UL, 1976017426UL, 2804626790UL, 2717553615UL, 2315409034UL, 954508235UL, 3845175920UL, 3999878682UL, 1247696432UL, 1743319509UL, 2998248398UL, 3694350012UL, 4072006361UL, 191306987UL, 2816321878UL, 1324077734UL, 1083060006UL, 3406855480UL, 1619622379UL, 2160350UL, 3302238190UL, 3368021261UL, 
3685228564UL, 3863934685UL, 771728612UL, 854205233UL, 2304696695UL, 421449207UL, 1265752117UL, 3852292419UL, 305345788UL, 1540622105UL, 1904883477UL, 833469256UL, 134406680UL, 3012455058UL, 4035477953UL, 2925192459UL, 1559200592UL, 3851612860UL, 718484562UL, 1377960276UL, 1586892849UL, 1361298269UL, 3417917896UL, 1281324499UL, 1012538763UL, 1350578667UL, 3946475598UL, 2982283954UL, 3548792804UL, 284542749UL, 1194648577UL, 3087899716UL, 
3966595444UL, 2088330116UL, 3641652062UL, 327128507UL, 593906557UL, 1092448919UL, 2459189516UL, 4053392241UL, 3356198248UL, 2352376508UL, 470648997UL, 1017041256UL, 3234172340UL, 3928191489UL, 3266226858UL, 4219289150UL, 1229098319UL, 4275351308UL, 2720777751UL, 3566728718UL, 638322822UL, 2369792461UL, 2869492261UL, 3120083828UL, 1890399556UL, 3309991008UL, 3785452464UL, 4128660314UL, 3726791982UL, 167177896UL, 461294981UL, 3988638998UL, 
2937794823UL, 3981029822UL, 1111681402UL, 2015965721UL, 7261806UL, 2669786265UL, 1083582734UL, 3270228881UL, 3892235938UL, 2695872715UL, 4246051290UL, 3214293333UL, 343604199UL, 3215604888UL, 661024127UL, 2931754053UL, 3787840039UL, 2053363765UL, 363432336UL, 112334132UL, 2871797223UL, 138911320UL, 3981126938UL, 2027332192UL, 1804730644UL, 590150270UL, 641538574UL, 6802174UL, 3551446076UL, 3908480472UL, 1004531022UL, 2097228524UL, 
1919074232UL, 154482247UL, 121437972UL, 1215661323UL, 1178068273UL, 1097220699UL, 2823681422UL, 262636065UL, 2943371149UL, 1768780720UL, 3866040605UL, 1855991583UL, 3988248086UL, 629223947UL, 3380612330UL, 3552916762UL, 197596340UL, 573801686UL, 2049230598UL, 2910471867UL, 2686314264UL, 1726228846UL, 3516983332UL, 726840185UL, 1241204222UL, 2237574317UL, 70568042UL, 1932610099UL, 2221862221UL, 1510378092UL, 4050391637UL, 4077539568UL, 
},
{
3872117793UL, 803220151UL, 70843412UL, 1661103032UL, 1976811457UL, 2186373604UL, 564259972UL, 1475436923UL, 2260980893UL, 4245534505UL, 1075107552UL, 3692990573UL, 370098873UL, 4045905424UL, 2420395420UL, 2332395402UL, 207483321UL, 622317750UL, 3004242500UL, 833623111UL, 3151161301UL, 1629139881UL, 352228793UL, 2439953368UL, 3183333619UL, 2703537080UL, 3218957129UL, 3164695888UL, 1741641842UL, 963394141UL, 4241612717UL, 1034476784UL, 
2035880432UL, 3977821313UL, 1543311495UL, 3010014356UL, 1638490901UL, 2364265378UL, 3420329129UL, 333361555UL, 1133565821UL, 1450937015UL, 616059115UL, 3216393887UL, 3041978455UL, 3990855695UL, 1238628750UL, 512746184UL, 3256670217UL, 1616316512UL, 2791405051UL, 93474487UL, 2865892488UL, 1901471398UL, 2930857966UL, 2178431077UL, 2325598341UL, 3189256113UL, 1302432091UL, 808592927UL, 2945846737UL, 3487931071UL, 2018175258UL, 752981057UL, 
1097082589UL, 1307115286UL, 175147508UL, 3611190164UL, 850238914UL, 3318706185UL, 199743319UL, 328621708UL, 3183670050UL, 3609998315UL, 4075306371UL, 3554549067UL, 2119566187UL, 1498503842UL, 1261870696UL, 2216745780UL, 950288337UL, 1117344941UL, 2150569143UL, 2899286760UL, 1594966374UL, 888858617UL, 35840654UL, 2829539211UL, 2511395669UL, 3607190544UL, 3278412778UL, 2249895907UL, 1320858068UL, 3576889788UL, 266766189UL, 1522426851UL, 
1903494122UL, 1928370573UL, 2628132591UL, 3322025904UL, 220280169UL, 433606853UL, 1428961479UL, 986074592UL, 2128892987UL, 467697583UL, 1616913929UL, 325674890UL, 444442578UL, 649166208UL, 1689709565UL, 1493452467UL, 2222122038UL, 121114616UL, 2134348225UL, 3512035688UL, 1283058921UL, 4230441398UL, 3701238559UL, 337534132UL, 1418548715UL, 1190006478UL, 500654385UL, 1766924757UL, 1944680746UL, 940574010UL, 922744002UL, 186142284UL, 
3131162902UL, 1693891092UL, 3031823448UL, 2143051534UL, 1429025284UL, 1487843160UL, 3606456133UL, 2079235652UL, 2447285474UL, 2669283767UL, 3232117829UL, 2490054343UL, 3225501736UL, 2911340385UL, 382319031UL, 1516937595UL, 622543191UL, 1388990570UL, 1749179860UL, 1924483707UL, 2593474505UL, 472539197UL, 122872799UL, 2586347240UL, 880588515UL, 4046335279UL, 1712182607UL, 4270737941UL, 1336703451UL, 3390078162UL, 382216945UL, 3733326081UL, 
460422073UL, 3872117793UL, 803220151UL, 70843412UL, 1661103032UL, 250339760UL, 2186373604UL, 564259972UL, 1475436923UL, 2260980893UL, 657986735UL, 1075107552UL, 3692990573UL, 370098873UL, 4045905424UL, 3201950123UL, 2332395402UL, 207483321UL, 622317750UL, 3004242500UL, 3732213278UL, 3151161301UL, 1629139881UL, 352228793UL, 2439953368UL, 3572618926UL, 2703537080UL, 3218957129UL, 3164695888UL, 1741641842UL, 685933373UL, 4241612717UL, 
1034476784UL, 2035880432UL, 3977821313UL, 3855995181UL, 3010014356UL, 1638490901UL, 2364265378UL, 3420329129UL, 2355603679UL, 1133565821UL, 1450937015UL, 616059115UL, 3216393887UL, 1733804102UL, 3990855695UL, 1238628750UL, 512746184UL, 3256670217UL, 2651059231UL, 2791405051UL, 93474487UL, 2865892488UL, 1901471398UL, 2113461797UL, 2178431077UL, 2325598341UL, 3189256113UL, 1302432091UL, 2986990416UL, 2945846737UL, 3487931071UL, 2018175258UL, 
752981057UL, 2428033310UL, 1307115286UL, 175147508UL, 3611190164UL, 850238914UL, 1033628405UL, 199743319UL, 328621708UL, 3183670050UL, 3609998315UL, 4024297327UL, 3554549067UL, 2119566187UL, 1498503842UL, 1261870696UL, 290361143UL, 950288337UL, 1117344941UL, 2150569143UL, 2899286760UL, 168826051UL, 888858617UL, 35840654UL, 2829539211UL, 2511395669UL, 2890882060UL, 3278412778UL, 2249895907UL, 1320858068UL, 3576889788UL, 1794920145UL, 
1522426851UL, 1903494122UL, 1928370573UL, 2628132591UL, 1251697758UL, 220280169UL, 433606853UL, 1428961479UL, 986074592UL, 2707115661UL, 467697583UL, 1616913929UL, 325674890UL, 444442578UL, 122781510UL, 1689709565UL, 1493452467UL, 2222122038UL, 121114616UL, 3425723636UL, 3512035688UL, 1283058921UL, 4230441398UL, 3701238559UL, 1646155473UL, 1418548715UL, 1190006478UL, 500654385UL, 1766924757UL, 3920475367UL, 940574010UL, 922744002UL, 
186142284UL, 3131162902UL, 54639113UL, 3031823448UL, 2143051534UL, 1429025284UL, 1487843160UL, 4152687885UL, 2079235652UL, 2447285474UL, 2669283767UL, 3232117829UL, 1601035152UL, 3225501736UL, 2911340385UL, 382319031UL, 1516937595UL, 3508441679UL, 1388990570UL, 1749179860UL, 1924483707UL, 2593474505UL, 2835403456UL, 122872799UL, 2586347240UL, 880588515UL, 4046335279UL, 2958058367UL, 4270737941UL, 1336703451UL, 3390078162UL, 382216945UL, 
450517882UL, 460422073UL, 3872117793UL, 803220151UL, 70843412UL, 2066343874UL, 250339760UL, 2186373604UL, 564259972UL, 1475436923UL, 1683787449UL, 657986735UL, 1075107552UL, 3692990573UL, 370098873UL, 2615082840UL, 3201950123UL, 2332395402UL, 207483321UL, 622317750UL, 2655424371UL, 3732213278UL, 3151161301UL, 1629139881UL, 352228793UL, 3236724760UL, 3572618926UL, 2703537080UL, 3218957129UL, 3164695888UL, 9775065UL, 685933373UL, 
4241612717UL, 1034476784UL, 2035880432UL, 1621920075UL, 3855995181UL, 3010014356UL, 1638490901UL, 2364265378UL, 1509475888UL, 2355603679UL, 1133565821UL, 1450937015UL, 616059115UL, 3666188236UL, 1733804102UL, 3990855695UL, 1238628750UL, 512746184UL, 3900473826UL, 2651059231UL, 2791405051UL, 93474487UL, 2865892488UL, 222759186UL, 2113461797UL, 2178431077UL, 2325598341UL, 3189256113UL, 2505499508UL, 2986990416UL, 2945846737UL, 3487931071UL, 
2018175258UL, 2766733928UL, 2428033310UL, 1307115286UL, 175147508UL, 3611190164UL, 1909211603UL, 1033628405UL, 199743319UL, 328621708UL, 3183670050UL, 1680331218UL, 4024297327UL, 3554549067UL, 2119566187UL, 1498503842UL, 3516256046UL, 290361143UL, 950288337UL, 1117344941UL, 2150569143UL, 3182619063UL, 168826051UL, 888858617UL, 35840654UL, 2829539211UL, 645798943UL, 2890882060UL, 3278412778UL, 2249895907UL, 1320858068UL, 1436708568UL, 
1794920145UL, 1522426851UL, 1903494122UL, 1928370573UL, 3693049252UL, 1251697758UL, 220280169UL, 433606853UL, 1428961479UL, 3724415861UL, 2707115661UL, 467697583UL, 1616913929UL, 325674890UL, 1448052253UL, 122781510UL, 1689709565UL, 1493452467UL, 2222122038UL, 2177448198UL, 3425723636UL, 3512035688UL, 1283058921UL, 4230441398UL, 3050940272UL, 1646155473UL, 1418548715UL, 1190006478UL, 500654385UL, 1106232UL, 3920475367UL, 940574010UL, 
922744002UL, 186142284UL, 4144806511UL, 54639113UL, 3031823448UL, 2143051534UL, 1429025284UL, 2067453848UL, 4152687885UL, 2079235652UL, 2447285474UL, 2669283767UL, 428527087UL, 1601035152UL, 3225501736UL, 2911340385UL, 382319031UL, 2565464472UL, 3508441679UL, 1388990570UL, 1749179860UL, 1924483707UL, 1737735237UL, 2835403456UL, 122872799UL, 2586347240UL, 880588515UL, 597822462UL, 2958058367UL, 4270737941UL, 1336703451UL, 3390078162UL, 
2532634475UL, 450517882UL, 460422073UL, 3872117793UL, 803220151UL, 801648827UL, 2066343874UL, 250339760UL, 2186373604UL, 564259972UL, 3417948976UL, 1683787449UL, 657986735UL, 1075107552UL, 3692990573UL, 2235306692UL, 2615082840UL, 3201950123UL, 2332395402UL, 207483321UL, 699310933UL, 2655424371UL, 3732213278UL, 3151161301UL, 1629139881UL, 1152704006UL, 3236724760UL, 3572618926UL, 2703537080UL, 3218957129UL, 2726926336UL, 9775065UL, 
685933373UL, 4241612717UL, 1034476784UL, 2398119652UL, 1621920075UL, 3855995181UL, 3010014356UL, 1638490901UL, 252854480UL, 1509475888UL, 2355603679UL, 1133565821UL, 1450937015UL, 2655911639UL, 3666188236UL, 1733804102UL, 3990855695UL, 1238628750UL, 1115900497UL, 3900473826UL, 2651059231UL, 2791405051UL, 93474487UL, 1862985957UL, 222759186UL, 2113461797UL, 2178431077UL, 2325598341UL, 4179075132UL, 2505499508UL, 2986990416UL, 2945846737UL, 
3487931071UL, 564667776UL, 2766733928UL, 2428033310UL, 1307115286UL, 175147508UL, 1759077815UL, 1909211603UL, 1033628405UL, 199743319UL, 328621708UL, 2552816198UL, 1680331218UL, 4024297327UL, 3554549067UL, 2119566187UL, 2267805778UL, 3516256046UL, 290361143UL, 950288337UL, 1117344941UL, 2897506172UL, 3182619063UL, 168826051UL, 888858617UL, 35840654UL, 2035476068UL, 645798943UL, 2890882060UL, 3278412778UL, 2249895907UL, 3278449102UL, 
1436708568UL, 1794920145UL, 1522426851UL, 1903494122UL, 1500763736UL, 3693049252UL, 1251697758UL, 220280169UL, 433606853UL, 3914497854UL, 3724415861UL, 2707115661UL, 467697583UL, 1616913929UL, 918435305UL, 1448052253UL, 122781510UL, 1689709565UL, 1493452467UL, 609575172UL, 2177448198UL, 3425723636UL, 3512035688UL, 1283058921UL, 3661181550UL, 3050940272UL, 1646155473UL, 1418548715UL, 1190006478UL, 1047301661UL, 1106232UL, 3920475367UL, 
940574010UL, 922744002UL, 2510633517UL, 4144806511UL, 54639113UL, 3031823448UL, 2143051534UL, 3242814908UL, 2067453848UL, 4152687885UL, 2079235652UL, 2447285474UL, 736638210UL, 428527087UL, 1601035152UL, 3225501736UL, 2911340385UL, 1849570436UL, 2565464472UL, 3508441679UL, 1388990570UL, 1749179860UL, 84517579UL, 1737735237UL, 2835403456UL, 122872799UL, 2586347240UL, 4002124614UL, 597822462UL, 2958058367UL, 4270737941UL, 1336703451UL, 
3078170472UL, 1186434751UL, 700631413UL, 1497890797UL, 1195347450UL, 2560167391UL, 1116697259UL, 1254138573UL, 747913260UL, 240954704UL, 3107512667UL, 360584144UL, 3422778960UL, 3516528389UL, 3301260366UL, 1254513537UL, 122269053UL, 1579582456UL, 873334104UL, 3918835024UL, 1731872444UL, 1974410416UL, 1811172641UL, 4172523062UL, 4092675777UL, 4124987343UL, 1936078756UL, 1757348689UL, 2694415512UL, 128641660UL, 1744777659UL, 3173116729UL, 
983733754UL, 1430789547UL, 701906842UL, 3367232568UL, 3266433501UL, 3572590347UL, 1453272962UL, 2106553114UL, 993786201UL, 2149441250UL, 1295181065UL, 2962229026UL, 3709052556UL, 3255608941UL, 3677730029UL, 483873127UL, 102227292UL, 2626265293UL, 2018984578UL, 2266388762UL, 1191709548UL, 2152725916UL, 583672623UL, 2230473473UL, 1995194269UL, 1740347812UL, 2558095372UL, 3070195183UL, 3023333227UL, 2497183195UL, 1908755188UL, 773027539UL, 
3646876518UL, 2272586839UL, 493318726UL, 2107067517UL, 2000805278UL, 2530829636UL, 3183628745UL, 677565332UL, 1497629423UL, 82094920UL, 2214054433UL, 2635367545UL, 470855467UL, 2184853389UL, 2942188934UL, 188335670UL, 3656661644UL, 1883526235UL, 3990873975UL, 1490784356UL, 4047548172UL, 3149642641UL, 3289988179UL, 2590918909UL, 2893039564UL, 2350687346UL, 4252624874UL, 15372456UL, 1614496594UL, 2364847678UL, 2604511825UL, 422365460UL, 
4195174772UL, 3266964836UL, 2008671995UL, 54038434UL, 781948549UL, 1276017666UL, 2756376612UL, 2436825273UL, 1711863836UL, 3541493950UL, 3821378841UL, 1007557618UL, 345375815UL, 2081905201UL, 2227278118UL, 1185927141UL, 1082173792UL, 3567361925UL, 1940465859UL, 541632942UL, 1830210248UL, 3757851982UL, 775883450UL, 1666577465UL, 1004944607UL, 878440834UL, 2146344131UL, 4195798476UL, 370164841UL, 3649112729UL, 37066142UL, 2311278904UL, 
1935745497UL, 2304799402UL, 4107299626UL, 1348526232UL, 2473609635UL, 3284032699UL, 2374292786UL, 1762329186UL, 857978496UL, 1039346432UL, 2621413355UL, 29961014UL, 3582263091UL, 4268542513UL, 3890612190UL, 3096173646UL, 2026544230UL, 3856142618UL, 2347115934UL, 319800326UL, 3255916105UL, 2430273059UL, 823505311UL, 874255188UL, 1401925393UL, 4203707857UL, 4259159566UL, 2606881118UL, 1978288664UL, 1447576038UL, 3860341401UL, 412510348UL, 
},
{
4052471963UL, 683640040UL, 3043876021UL, 3466644483UL, 4222418025UL, 3035140128UL, 1466027937UL, 18198088UL, 3410320851UL, 3040963721UL, 488404231UL, 3157371815UL, 769336092UL, 3240417718UL, 808582581UL, 2075839263UL, 835026995UL, 3123726486UL, 3284240985UL, 1898453053UL, 3606056482UL, 512836002UL, 2715428547UL, 4182302879UL, 1644882480UL, 3160187826UL, 390292489UL, 980889545UL, 2776206633UL, 2482799995UL, 617042280UL, 3501667414UL, 
689451808UL, 497018701UL, 238525753UL, 3890163301UL, 896679896UL, 1544533015UL, 3412477225UL, 3116575138UL, 4250402651UL, 3990990746UL, 819056741UL, 1459334146UL, 158377590UL, 3444755752UL, 8230450UL, 1378706455UL, 684191332UL, 3217423797UL, 2842520097UL, 1631477948UL, 2591254230UL, 959644473UL, 1020694107UL, 1748401915UL, 3452514983UL, 3892766171UL, 1227786994UL, 2086180800UL, 2394613217UL, 2091953150UL, 870094953UL, 2306851481UL, 
571550601UL, 488878212UL, 873197214UL, 2630100528UL, 2067476907UL, 2162307009UL, 2026119728UL, 115875280UL, 2905867426UL, 248774881UL, 3110900450UL, 2236032812UL, 1888510348UL, 708001855UL, 996960491UL, 3514196956UL, 1407967546UL, 1826568876UL, 3659618284UL, 2614104317UL, 2230066308UL, 1055135881UL, 2537437343UL, 1858044413UL, 2608594891UL, 2750681169UL, 3241939420UL, 3966440877UL, 2375002886UL, 2417753441UL, 1405878685UL, 1081133199UL, 
1496940727UL, 382467042UL, 2745477587UL, 1209424459UL, 811187075UL, 1385604734UL, 2623887355UL, 3443875720UL, 394141555UL, 4142998949UL, 4195414618UL, 1489846841UL, 2253433808UL, 1171450286UL, 84131191UL, 4387588UL, 2641405140UL, 3525405389UL, 3273000909UL, 423660319UL, 2366546732UL, 3698878607UL, 2161119729UL, 4263629085UL, 3029102089UL, 2692507376UL, 3266869596UL, 1658012061UL, 1960169440UL, 1002311379UL, 3724446882UL, 2004188516UL, 
999513506UL, 2200093802UL, 4141037460UL, 351865836UL, 412875013UL, 1535823315UL, 3880657632UL, 3109944987UL, 3207577548UL, 3462087941UL, 584875517UL, 2635241084UL, 3834145971UL, 1693380373UL, 3524443732UL, 934775214UL, 1960588847UL, 2226778032UL, 1044609478UL, 12199016UL, 1120582000UL, 226430296UL, 665553142UL, 2570993348UL, 1685535237UL, 3325420136UL, 3925248326UL, 2855346376UL, 1205558328UL, 808835317UL, 3295908896UL, 4170076136UL, 
2438272365UL, 4052471963UL, 683640040UL, 3043876021UL, 3466644483UL, 1385549869UL, 3035140128UL, 1466027937UL, 18198088UL, 3410320851UL, 2171386836UL, 488404231UL, 3157371815UL, 769336092UL, 3240417718UL, 2921774554UL, 2075839263UL, 835026995UL, 3123726486UL, 3284240985UL, 72352110UL, 3606056482UL, 512836002UL, 2715428547UL, 4182302879UL, 3869483469UL, 3160187826UL, 390292489UL, 980889545UL, 2776206633UL, 1385691983UL, 617042280UL, 
3501667414UL, 689451808UL, 497018701UL, 2600411809UL, 3890163301UL, 896679896UL, 1544533015UL, 3412477225UL, 356556378UL, 4250402651UL, 3990990746UL, 819056741UL, 1459334146UL, 199003993UL, 3444755752UL, 8230450UL, 1378706455UL, 684191332UL, 1750733272UL, 2842520097UL, 1631477948UL, 2591254230UL, 959644473UL, 2113375576UL, 1748401915UL, 3452514983UL, 3892766171UL, 1227786994UL, 275473920UL, 2394613217UL, 2091953150UL, 870094953UL, 
2306851481UL, 897057645UL, 488878212UL, 873197214UL, 2630100528UL, 2067476907UL, 944114068UL, 2026119728UL, 115875280UL, 2905867426UL, 248774881UL, 989201307UL, 2236032812UL, 1888510348UL, 708001855UL, 996960491UL, 2121706374UL, 1407967546UL, 1826568876UL, 3659618284UL, 2614104317UL, 2931815032UL, 1055135881UL, 2537437343UL, 1858044413UL, 2608594891UL, 1423973935UL, 3241939420UL, 3966440877UL, 2375002886UL, 2417753441UL, 2514473440UL, 
1081133199UL, 1496940727UL, 382467042UL, 2745477587UL, 81977310UL, 811187075UL, 1385604734UL, 2623887355UL, 3443875720UL, 2100629879UL, 4142998949UL, 4195414618UL, 1489846841UL, 2253433808UL, 337182869UL, 84131191UL, 4387588UL, 2641405140UL, 3525405389UL, 661876463UL, 423660319UL, 2366546732UL, 3698878607UL, 2161119729UL, 309510684UL, 3029102089UL, 2692507376UL, 3266869596UL, 1658012061UL, 11119541UL, 1002311379UL, 3724446882UL, 
2004188516UL, 999513506UL, 3486722046UL, 4141037460UL, 351865836UL, 412875013UL, 1535823315UL, 2818130700UL, 3109944987UL, 3207577548UL, 3462087941UL, 584875517UL, 322875622UL, 3834145971UL, 1693380373UL, 3524443732UL, 934775214UL, 3879414752UL, 2226778032UL, 1044609478UL, 12199016UL, 1120582000UL, 4207259464UL, 665553142UL, 2570993348UL, 1685535237UL, 3325420136UL, 553869152UL, 2855346376UL, 1205558328UL, 808835317UL, 3295908896UL, 
470585896UL, 2438272365UL, 4052471963UL, 683640040UL, 3043876021UL, 1588419572UL, 1385549869UL, 3035140128UL, 1466027937UL, 18198088UL, 363815288UL, 2171386836UL, 488404231UL, 3157371815UL, 769336092UL, 2464768302UL, 2921774554UL, 2075839263UL, 835026995UL, 3123726486UL, 4229246330UL, 72352110UL, 3606056482UL, 512836002UL, 2715428547UL, 319830805UL, 3869483469UL, 3160187826UL, 390292489UL, 980889545UL, 2966401462UL, 1385691983UL, 
617042280UL, 3501667414UL, 689451808UL, 4047377762UL, 2600411809UL, 3890163301UL, 896679896UL, 1544533015UL, 764316452UL, 356556378UL, 4250402651UL, 3990990746UL, 819056741UL, 965331966UL, 199003993UL, 3444755752UL, 8230450UL, 1378706455UL, 51902971UL, 1750733272UL, 2842520097UL, 1631477948UL, 2591254230UL, 426039404UL, 2113375576UL, 1748401915UL, 3452514983UL, 3892766171UL, 2833368447UL, 275473920UL, 2394613217UL, 2091953150UL, 
870094953UL, 3524323828UL, 897057645UL, 488878212UL, 873197214UL, 2630100528UL, 3939852929UL, 944114068UL, 2026119728UL, 115875280UL, 2905867426UL, 3192643919UL, 989201307UL, 2236032812UL, 1888510348UL, 708001855UL, 2166012172UL, 2121706374UL, 1407967546UL, 1826568876UL, 3659618284UL, 135277096UL, 2931815032UL, 1055135881UL, 2537437343UL, 1858044413UL, 2588429924UL, 1423973935UL, 3241939420UL, 3966440877UL, 2375002886UL, 2477142003UL, 
2514473440UL, 1081133199UL, 1496940727UL, 382467042UL, 1760129281UL, 81977310UL, 811187075UL, 1385604734UL, 2623887355UL, 4070531513UL, 2100629879UL, 4142998949UL, 4195414618UL, 1489846841UL, 2688068550UL, 337182869UL, 84131191UL, 4387588UL, 2641405140UL, 1837403234UL, 661876463UL, 423660319UL, 2366546732UL, 3698878607UL, 2916121190UL, 309510684UL, 3029102089UL, 2692507376UL, 3266869596UL, 303422295UL, 11119541UL, 1002311379UL, 
3724446882UL, 2004188516UL, 2652711421UL, 3486722046UL, 4141037460UL, 351865836UL, 412875013UL, 113149471UL, 2818130700UL, 3109944987UL, 3207577548UL, 3462087941UL, 1443140792UL, 322875622UL, 3834145971UL, 1693380373UL, 3524443732UL, 901891935UL, 3879414752UL, 2226778032UL, 1044609478UL, 12199016UL, 2213168758UL, 4207259464UL, 665553142UL, 2570993348UL, 1685535237UL, 1114492412UL, 553869152UL, 2855346376UL, 1205558328UL, 808835317UL, 
3266626294UL, 470585896UL, 2438272365UL, 4052471963UL, 683640040UL, 3581539398UL, 1588419572UL, 1385549869UL, 3035140128UL, 1466027937UL, 4075470388UL, 363815288UL, 2171386836UL, 488404231UL, 3157371815UL, 2759472233UL, 2464768302UL, 2921774554UL, 2075839263UL, 835026995UL, 1030654310UL, 4229246330UL, 72352110UL, 3606056482UL, 512836002UL, 961858496UL, 319830805UL, 3869483469UL, 3160187826UL, 390292489UL, 2366221117UL, 2966401462UL, 
1385691983UL, 617042280UL, 3501667414UL, 295865937UL, 4047377762UL, 2600411809UL, 3890163301UL, 896679896UL, 21714884UL, 764316452UL, 356556378UL, 4250402651UL, 3990990746UL, 1012967081UL, 965331966UL, 199003993UL, 3444755752UL, 8230450UL, 1255302023UL, 51902971UL, 1750733272UL, 2842520097UL, 1631477948UL, 2321320272UL, 426039404UL, 2113375576UL, 1748401915UL, 3452514983UL, 2847013518UL, 2833368447UL, 275473920UL, 2394613217UL, 
2091953150UL, 1250695522UL, 3524323828UL, 897057645UL, 488878212UL, 873197214UL, 1452317325UL, 3939852929UL, 944114068UL, 2026119728UL, 115875280UL, 4061820350UL, 3192643919UL, 989201307UL, 2236032812UL, 1888510348UL, 3986446165UL, 2166012172UL, 2121706374UL, 1407967546UL, 1826568876UL, 2910745432UL, 135277096UL, 2931815032UL, 1055135881UL, 2537437343UL, 2976455307UL, 2588429924UL, 1423973935UL, 3241939420UL, 3966440877UL, 2418897705UL, 
2477142003UL, 2514473440UL, 1081133199UL, 1496940727UL, 1321648771UL, 1760129281UL, 81977310UL, 811187075UL, 1385604734UL, 17644628UL, 4070531513UL, 2100629879UL, 4142998949UL, 4195414618UL, 2697310527UL, 2688068550UL, 337182869UL, 84131191UL, 4387588UL, 1724191700UL, 1837403234UL, 661876463UL, 423660319UL, 2366546732UL, 693430992UL, 2916121190UL, 309510684UL, 3029102089UL, 2692507376UL, 3917396098UL, 303422295UL, 11119541UL, 
1002311379UL, 3724446882UL, 841468294UL, 2652711421UL, 3486722046UL, 4141037460UL, 351865836UL, 1733384185UL, 113149471UL, 2818130700UL, 3109944987UL, 3207577548UL, 2326233100UL, 1443140792UL, 322875622UL, 3834145971UL, 1693380373UL, 1580706359UL, 901891935UL, 3879414752UL, 2226778032UL, 1044609478UL, 3805470822UL, 2213168758UL, 4207259464UL, 665553142UL, 2570993348UL, 3406548636UL, 1114492412UL, 553869152UL, 2855346376UL, 1205558328UL, 
4287831475UL, 1329654114UL, 2347235746UL, 2477803138UL, 2962371859UL, 3610024283UL, 4197266903UL, 1162294689UL, 1746713323UL, 2815058477UL, 2152552186UL, 4214791071UL, 2382522482UL, 3713914466UL, 3974765132UL, 348354997UL, 1670276150UL, 2173074887UL, 381736894UL, 3866219357UL, 1919366695UL, 3635118824UL, 2298653261UL, 3534332682UL, 1627699897UL, 4168636618UL, 3787938690UL, 2144231271UL, 2067679462UL, 217001062UL, 2308928337UL, 1620415125UL, 
3526559172UL, 749451561UL, 2456947371UL, 3543607786UL, 1893824735UL, 962598819UL, 2332807164UL, 1691114891UL, 2543992233UL, 2914780639UL, 1610287145UL, 1700599697UL, 3185174208UL, 552323208UL, 2367242224UL, 3797136972UL, 3415066418UL, 2468049249UL, 1677937401UL, 40445671UL, 2886682530UL, 2585715434UL, 194932329UL, 2994003812UL, 3099556382UL, 680852222UL, 135838738UL, 1371063256UL, 995454898UL, 3754526418UL, 803635682UL, 634588682UL, 
3869250783UL, 2442285521UL, 1455637058UL, 570621479UL, 2512681851UL, 1220136924UL, 750260121UL, 2909903038UL, 1582019728UL, 955115170UL, 1608265445UL, 2157390890UL, 2303678604UL, 1568394164UL, 831914289UL, 1971271392UL, 1294799854UL, 1489945167UL, 442427880UL, 1305083700UL, 1211218668UL, 2380073713UL, 2798736785UL, 2193524273UL, 3227386915UL, 1636588977UL, 3612937642UL, 435113647UL, 1591761830UL, 536210039UL, 2475747073UL, 4223795480UL, 
1786737271UL, 1444661534UL, 3249410301UL, 3333695212UL, 4169107188UL, 3280638635UL, 702659930UL, 1444127970UL, 225340755UL, 2255629368UL, 746584456UL, 3965677674UL, 2671132955UL, 2080717656UL, 2145343886UL, 3712441197UL, 368422910UL, 1297685674UL, 4076123901UL, 26214470UL, 2948764826UL, 40503299UL, 1198194334UL, 2100063637UL, 1966331612UL, 2189582064UL, 2064696934UL, 1797550642UL, 3469793941UL, 2868963812UL, 851437659UL, 240918534UL, 
365060070UL, 3530600064UL, 39695324UL, 1753898837UL, 1286976449UL, 3131971360UL, 2406485219UL, 3365373704UL, 3224113403UL, 1651742834UL, 587601940UL, 1574206085UL, 3739575036UL, 1413669616UL, 38172232UL, 293127854UL, 4126190109UL, 1891744061UL, 787878666UL, 456643669UL, 4228710325UL, 2025132037UL, 1492133135UL, 3122840937UL, 969442079UL, 3272420439UL, 3836126369UL, 1877655562UL, 2766212758UL, 3867984746UL, 3348077578UL, 1841216706UL, 
},
{
1676507466UL, 1017841240UL, 2992644565UL, 476936158UL, 2468072723UL, 3113105154UL, 1154120402UL, 460889625UL, 1942263502UL, 1761593999UL, 3020908939UL, 3078194866UL, 310971889UL, 1644896012UL, 3756044556UL, 3549937583UL, 3710822994UL, 3554313733UL, 2174654326UL, 4251063242UL, 2340485150UL, 950951909UL, 4288936895UL, 3744348848UL, 706644559UL, 1085927825UL, 1595992020UL, 3288724966UL, 1367247946UL, 2950094970UL, 3925419886UL, 2628739022UL, 
2528254629UL, 3582224789UL, 3907345559UL, 3373329273UL, 4255542251UL, 1185418446UL, 4018656113UL, 2854344020UL, 1381160022UL, 3642438773UL, 4284399225UL, 935780030UL, 4142412144UL, 1263328494UL, 1154237693UL, 2684443667UL, 3067549398UL, 4253090033UL, 1251034970UL, 1874233020UL, 3222830495UL, 3866931656UL, 286048055UL, 3146635362UL, 1436483376UL, 2821876495UL, 3927829532UL, 2648886905UL, 2142862852UL, 1368937545UL, 2647327844UL, 1072219385UL, 
2621337706UL, 3543274652UL, 911792564UL, 1204178178UL, 4127214323UL, 2821691380UL, 3101998294UL, 730811902UL, 1989156224UL, 2872353003UL, 278290276UL, 1390223786UL, 2657819643UL, 552729795UL, 1736270535UL, 2759207116UL, 1897013739UL, 3657020278UL, 1387364861UL, 1966588302UL, 1049203087UL, 486446521UL, 3675999281UL, 714737345UL, 686837530UL, 85509025UL, 3609089773UL, 2117061768UL, 3935682560UL, 3859508784UL, 4105287041UL, 1808988481UL, 
83680601UL, 1464326680UL, 1657693523UL, 3318062731UL, 1391154023UL, 234460119UL, 3551348221UL, 2245244809UL, 3635923821UL, 2814385745UL, 3497626257UL, 916790795UL, 245338628UL, 2514528380UL, 3711787525UL, 2239286063UL, 1054058916UL, 3963706010UL, 3176203796UL, 2230543409UL, 2173597546UL, 3786733892UL, 1396036965UL, 1038764273UL, 2032556038UL, 3216540537UL, 3298170974UL, 1008892557UL, 141155464UL, 1863766055UL, 3931110690UL, 191299053UL, 
2019139711UL, 2409528317UL, 739418419UL, 1377144055UL, 2876702705UL, 3911939673UL, 1197696462UL, 2814009721UL, 600813233UL, 1535885024UL, 1486280357UL, 3084650548UL, 2324695947UL, 2293284974UL, 2036339249UL, 3465600153UL, 1624446108UL, 327866771UL, 3356772175UL, 1826625240UL, 1947102360UL, 3661848193UL, 1421374867UL, 3228945021UL, 1358646008UL, 1067180174UL, 2190741258UL, 643362354UL, 109899594UL, 2064362635UL, 3249674888UL, 2165543887UL, 
4180291913UL, 1676507466UL, 1017841240UL, 2992644565UL, 476936158UL, 3608467942UL, 3113105154UL, 1154120402UL, 460889625UL, 1942263502UL, 1862994005UL, 3020908939UL, 3078194866UL, 310971889UL, 1644896012UL, 693774191UL, 3549937583UL, 3710822994UL, 3554313733UL, 2174654326UL, 37658897UL, 2340485150UL, 950951909UL, 4288936895UL, 3744348848UL, 2258231402UL, 1085927825UL, 1595992020UL, 3288724966UL, 1367247946UL, 3850509554UL, 3925419886UL, 
2628739022UL, 2528254629UL, 3582224789UL, 3124287811UL, 3373329273UL, 4255542251UL, 1185418446UL, 4018656113UL, 1989726178UL, 1381160022UL, 3642438773UL, 4284399225UL, 935780030UL, 3622052196UL, 1263328494UL, 1154237693UL, 2684443667UL, 3067549398UL, 2786224913UL, 1251034970UL, 1874233020UL, 3222830495UL, 3866931656UL, 1529490307UL, 3146635362UL, 1436483376UL, 2821876495UL, 3927829532UL, 979247444UL, 2142862852UL, 1368937545UL, 2647327844UL, 
1072219385UL, 294065371UL, 3543274652UL, 911792564UL, 1204178178UL, 4127214323UL, 103582737UL, 3101998294UL, 730811902UL, 1989156224UL, 2872353003UL, 1885087777UL, 1390223786UL, 2657819643UL, 552729795UL, 1736270535UL, 3325206451UL, 1897013739UL, 3657020278UL, 1387364861UL, 1966588302UL, 2117065739UL, 486446521UL, 3675999281UL, 714737345UL, 686837530UL, 3946214694UL, 3609089773UL, 2117061768UL, 3935682560UL, 3859508784UL, 2916136885UL, 
1808988481UL, 83680601UL, 1464326680UL, 1657693523UL, 3438751781UL, 1391154023UL, 234460119UL, 3551348221UL, 2245244809UL, 3948410079UL, 2814385745UL, 3497626257UL, 916790795UL, 245338628UL, 1767303496UL, 3711787525UL, 2239286063UL, 1054058916UL, 3963706010UL, 4140631909UL, 2230543409UL, 2173597546UL, 3786733892UL, 1396036965UL, 1116033475UL, 2032556038UL, 3216540537UL, 3298170974UL, 1008892557UL, 667272562UL, 1863766055UL, 3931110690UL, 
191299053UL, 2019139711UL, 272901326UL, 739418419UL, 1377144055UL, 2876702705UL, 3911939673UL, 3839312742UL, 2814009721UL, 600813233UL, 1535885024UL, 1486280357UL, 4256065219UL, 2324695947UL, 2293284974UL, 2036339249UL, 3465600153UL, 1215859603UL, 327866771UL, 3356772175UL, 1826625240UL, 1947102360UL, 4240407984UL, 1421374867UL, 3228945021UL, 1358646008UL, 1067180174UL, 4100357988UL, 643362354UL, 109899594UL, 2064362635UL, 3249674888UL, 
2898852084UL, 4180291913UL, 1676507466UL, 1017841240UL, 2992644565UL, 1569683812UL, 3608467942UL, 3113105154UL, 1154120402UL, 460889625UL, 966040649UL, 1862994005UL, 3020908939UL, 3078194866UL, 310971889UL, 786634113UL, 693774191UL, 3549937583UL, 3710822994UL, 3554313733UL, 1578429713UL, 37658897UL, 2340485150UL, 950951909UL, 4288936895UL, 2528123823UL, 2258231402UL, 1085927825UL, 1595992020UL, 3288724966UL, 3544041088UL, 3850509554UL, 
3925419886UL, 2628739022UL, 2528254629UL, 2562145937UL, 3124287811UL, 3373329273UL, 4255542251UL, 1185418446UL, 3693565710UL, 1989726178UL, 1381160022UL, 3642438773UL, 4284399225UL, 3271478204UL, 3622052196UL, 1263328494UL, 1154237693UL, 2684443667UL, 3615401444UL, 2786224913UL, 1251034970UL, 1874233020UL, 3222830495UL, 2572413057UL, 1529490307UL, 3146635362UL, 1436483376UL, 2821876495UL, 3993894153UL, 979247444UL, 2142862852UL, 1368937545UL, 
2647327844UL, 1353904396UL, 294065371UL, 3543274652UL, 911792564UL, 1204178178UL, 3165709748UL, 103582737UL, 3101998294UL, 730811902UL, 1989156224UL, 893293786UL, 1885087777UL, 1390223786UL, 2657819643UL, 552729795UL, 3388458110UL, 3325206451UL, 1897013739UL, 3657020278UL, 1387364861UL, 3025318046UL, 2117065739UL, 486446521UL, 3675999281UL, 714737345UL, 2085926890UL, 3946214694UL, 3609089773UL, 2117061768UL, 3935682560UL, 868009118UL, 
2916136885UL, 1808988481UL, 83680601UL, 1464326680UL, 797410789UL, 3438751781UL, 1391154023UL, 234460119UL, 3551348221UL, 4068940987UL, 3948410079UL, 2814385745UL, 3497626257UL, 916790795UL, 3722456098UL, 1767303496UL, 3711787525UL, 2239286063UL, 1054058916UL, 2030352819UL, 4140631909UL, 2230543409UL, 2173597546UL, 3786733892UL, 3211336683UL, 1116033475UL, 2032556038UL, 3216540537UL, 3298170974UL, 2589589144UL, 667272562UL, 1863766055UL, 
3931110690UL, 191299053UL, 1139480458UL, 272901326UL, 739418419UL, 1377144055UL, 2876702705UL, 1954361769UL, 3839312742UL, 2814009721UL, 600813233UL, 1535885024UL, 3587775605UL, 4256065219UL, 2324695947UL, 2293284974UL, 2036339249UL, 1534849280UL, 1215859603UL, 327866771UL, 3356772175UL, 1826625240UL, 720372669UL, 4240407984UL, 1421374867UL, 3228945021UL, 1358646008UL, 3409069246UL, 4100357988UL, 643362354UL, 109899594UL, 2064362635UL, 
4243434294UL, 2898852084UL, 4180291913UL, 1676507466UL, 1017841240UL, 3243922356UL, 1569683812UL, 3608467942UL, 3113105154UL, 1154120402UL, 1479311403UL, 966040649UL, 1862994005UL, 3020908939UL, 3078194866UL, 1556392996UL, 786634113UL, 693774191UL, 3549937583UL, 3710822994UL, 920664071UL, 1578429713UL, 37658897UL, 2340485150UL, 950951909UL, 740197415UL, 2528123823UL, 2258231402UL, 1085927825UL, 1595992020UL, 2580760267UL, 3544041088UL, 
3850509554UL, 3925419886UL, 2628739022UL, 3867556156UL, 2562145937UL, 3124287811UL, 3373329273UL, 4255542251UL, 3185271749UL, 3693565710UL, 1989726178UL, 1381160022UL, 3642438773UL, 3042165367UL, 3271478204UL, 3622052196UL, 1263328494UL, 1154237693UL, 1016814036UL, 3615401444UL, 2786224913UL, 1251034970UL, 1874233020UL, 2956086971UL, 2572413057UL, 1529490307UL, 3146635362UL, 1436483376UL, 1513970396UL, 3993894153UL, 979247444UL, 2142862852UL, 
1368937545UL, 3275665128UL, 1353904396UL, 294065371UL, 3543274652UL, 911792564UL, 2209636872UL, 3165709748UL, 103582737UL, 3101998294UL, 730811902UL, 965151434UL, 893293786UL, 1885087777UL, 1390223786UL, 2657819643UL, 3278634059UL, 3388458110UL, 3325206451UL, 1897013739UL, 3657020278UL, 4293473749UL, 3025318046UL, 2117065739UL, 486446521UL, 3675999281UL, 620561205UL, 2085926890UL, 3946214694UL, 3609089773UL, 2117061768UL, 163384588UL, 
868009118UL, 2916136885UL, 1808988481UL, 83680601UL, 10243015UL, 797410789UL, 3438751781UL, 1391154023UL, 234460119UL, 1278218413UL, 4068940987UL, 3948410079UL, 2814385745UL, 3497626257UL, 1233272798UL, 3722456098UL, 1767303496UL, 3711787525UL, 2239286063UL, 3968895688UL, 2030352819UL, 4140631909UL, 2230543409UL, 2173597546UL, 2866251044UL, 3211336683UL, 1116033475UL, 2032556038UL, 3216540537UL, 4233849723UL, 2589589144UL, 667272562UL, 
1863766055UL, 3931110690UL, 2468422423UL, 1139480458UL, 272901326UL, 739418419UL, 1377144055UL, 4240143411UL, 1954361769UL, 3839312742UL, 2814009721UL, 600813233UL, 3976840004UL, 3587775605UL, 4256065219UL, 2324695947UL, 2293284974UL, 437604123UL, 1534849280UL, 1215859603UL, 327866771UL, 3356772175UL, 2757237699UL, 720372669UL, 4240407984UL, 1421374867UL, 3228945021UL, 3284801305UL, 3409069246UL, 4100357988UL, 643362354UL, 109899594UL, 
1301585321UL, 2528806870UL, 1838904064UL, 448772403UL, 1097849740UL, 1899994097UL, 618309123UL, 1911948510UL, 2309256224UL, 1861398151UL, 905306403UL, 1067595802UL, 36868624UL, 3780886191UL, 835126206UL, 3190251977UL, 2672497726UL, 2085944002UL, 2912993968UL, 2493776706UL, 667136329UL, 1474890786UL, 2383346554UL, 943528949UL, 3376706013UL, 2495573574UL, 144956345UL, 793159960UL, 1591274917UL, 477107637UL, 1383815442UL, 67384899UL, 
2355242218UL, 1687409818UL, 3801093871UL, 2108217811UL, 3455908733UL, 4172160797UL, 3935534685UL, 631067839UL, 1187677548UL, 2280856137UL, 3020767646UL, 2063176246UL, 3736904984UL, 2952933848UL, 2975164686UL, 4144473303UL, 34670977UL, 1250976509UL, 3484166554UL, 1532744745UL, 225700994UL, 1878713627UL, 2122358980UL, 1456610194UL, 2917522161UL, 2818947075UL, 102678939UL, 53743858UL, 2095250656UL, 4023979225UL, 3094092874UL, 4128760696UL, 
3411610028UL, 3020200609UL, 2225866341UL, 586320946UL, 63813522UL, 1238216159UL, 2825692263UL, 2169937231UL, 3298517640UL, 1542128261UL, 2205544184UL, 1258655704UL, 2629012083UL, 4113650203UL, 3198617867UL, 2742310794UL, 3372657381UL, 3115904410UL, 1948638822UL, 1123521744UL, 1080429281UL, 4086706732UL, 4142693211UL, 817377147UL, 2570194641UL, 26001503UL, 2861456160UL, 4185725555UL, 2573003804UL, 1618628779UL, 2588489212UL, 3996192609UL, 
1555844274UL, 1003123505UL, 1326350123UL, 1130583849UL, 3017128756UL, 74119042UL, 4041266437UL, 1938014170UL, 3528465794UL, 4203969698UL, 1913054398UL, 3617979809UL, 2218810167UL, 2453899816UL, 1997423206UL, 477446533UL, 303090065UL, 757937082UL, 1523238256UL, 3140505311UL, 1422588701UL, 3642014639UL, 1740624195UL, 1276017154UL, 3072526193UL, 3675105122UL, 1335122682UL, 4080595263UL, 2308519420UL, 3299182769UL, 1461978532UL, 3098694217UL, 
2982399822UL, 3088698511UL, 586759229UL, 3548750902UL, 1449857891UL, 2866451663UL, 2525162286UL, 57294602UL, 4107991297UL, 1214672265UL, 2940391280UL, 4285346034UL, 3338216759UL, 737207923UL, 4264163846UL, 59219141UL, 2300024654UL, 1876616814UL, 1976543605UL, 783571061UL, 1724699622UL, 1967524469UL, 1650309916UL, 3322257631UL, 3975521122UL, 273342162UL, 1156754241UL, 185315896UL, 3368133921UL, 66314655UL, 4153777915UL, 3519901897UL, 
},
{
3672467167UL, 68684525UL, 1738833632UL, 3081329135UL, 2583806115UL, 2291130512UL, 503032614UL, 3658059597UL, 571493931UL, 685537959UL, 3498787788UL, 422428426UL, 3879256913UL, 1173158320UL, 4000800121UL, 298972869UL, 1718342816UL, 2541691685UL, 2490502642UL, 2321452806UL, 4223212804UL, 1812334632UL, 3717655725UL, 4238191852UL, 3001307165UL, 2621896355UL, 2572404999UL, 3590094954UL, 760765206UL, 2293618001UL, 1392353032UL, 1733137169UL, 
2674005018UL, 4067961151UL, 1505710487UL, 451078217UL, 2591688848UL, 12635611UL, 507045428UL, 694822241UL, 1789383090UL, 1140183890UL, 1720695967UL, 1994318191UL, 3340349873UL, 2793804971UL, 1054433135UL, 2345087879UL, 3179939285UL, 1651968615UL, 1793223686UL, 1055357758UL, 914271617UL, 483007580UL, 2127727816UL, 2754998083UL, 3179053982UL, 598442002UL, 1950227301UL, 213053613UL, 3566888111UL, 2832258993UL, 4260365359UL, 443662829UL, 
1706542890UL, 3852730296UL, 3643260763UL, 2163607277UL, 1812905006UL, 171529637UL, 215187467UL, 2369406909UL, 1929000706UL, 2572441025UL, 2133955541UL, 810692262UL, 1337974799UL, 4030350704UL, 2159178715UL, 3769451556UL, 1026825278UL, 593628480UL, 1817383139UL, 878832429UL, 2253876350UL, 203612980UL, 2102950440UL, 3407143936UL, 1912362251UL, 1595387637UL, 2827580539UL, 305467658UL, 3292706746UL, 44135525UL, 4001933553UL, 3697343089UL, 
760470915UL, 587414402UL, 1419378814UL, 2852774010UL, 3891626781UL, 2757016765UL, 1090707384UL, 3997074427UL, 1047182100UL, 2855539022UL, 36229159UL, 1591415533UL, 3471572739UL, 1237952140UL, 2614469314UL, 213338525UL, 886212578UL, 2620301943UL, 713590207UL, 2430496777UL, 1198164420UL, 2644841698UL, 3654164701UL, 36283572UL, 1461695896UL, 1770331341UL, 1641501876UL, 3470919184UL, 3181021559UL, 3053795110UL, 3533531372UL, 3134337355UL, 
668308383UL, 388340999UL, 3221275220UL, 1589659138UL, 294382235UL, 1447443579UL, 690177534UL, 1799726917UL, 2838977761UL, 4172949119UL, 2360858031UL, 159385920UL, 2248389027UL, 1790015671UL, 3925738275UL, 1049918544UL, 4107349511UL, 1619955951UL, 4188275966UL, 1672572975UL, 2672697497UL, 1863413666UL, 747724021UL, 4037561738UL, 1605940213UL, 445253292UL, 3362434828UL, 610898209UL, 1473244091UL, 735444769UL, 1540599852UL, 2449351720UL, 
1032410949UL, 3672467167UL, 68684525UL, 1738833632UL, 3081329135UL, 519684794UL, 2291130512UL, 503032614UL, 3658059597UL, 571493931UL, 2400186105UL, 3498787788UL, 422428426UL, 3879256913UL, 1173158320UL, 4120704752UL, 298972869UL, 1718342816UL, 2541691685UL, 2490502642UL, 1686027891UL, 4223212804UL, 1812334632UL, 3717655725UL, 4238191852UL, 642431972UL, 2621896355UL, 2572404999UL, 3590094954UL, 760765206UL, 2949609717UL, 1392353032UL, 
1733137169UL, 2674005018UL, 4067961151UL, 1526077846UL, 451078217UL, 2591688848UL, 12635611UL, 507045428UL, 2417951415UL, 1789383090UL, 1140183890UL, 1720695967UL, 1994318191UL, 3465605863UL, 2793804971UL, 1054433135UL, 2345087879UL, 3179939285UL, 3079297626UL, 1793223686UL, 1055357758UL, 914271617UL, 483007580UL, 306802527UL, 2754998083UL, 3179053982UL, 598442002UL, 1950227301UL, 2473418737UL, 3566888111UL, 2832258993UL, 4260365359UL, 
443662829UL, 2097776414UL, 3852730296UL, 3643260763UL, 2163607277UL, 1812905006UL, 3957721904UL, 215187467UL, 2369406909UL, 1929000706UL, 2572441025UL, 3779486126UL, 810692262UL, 1337974799UL, 4030350704UL, 2159178715UL, 1127012865UL, 1026825278UL, 593628480UL, 1817383139UL, 878832429UL, 361018423UL, 203612980UL, 2102950440UL, 3407143936UL, 1912362251UL, 1475218277UL, 2827580539UL, 305467658UL, 3292706746UL, 44135525UL, 1900092336UL, 
3697343089UL, 760470915UL, 587414402UL, 1419378814UL, 343303227UL, 3891626781UL, 2757016765UL, 1090707384UL, 3997074427UL, 745490961UL, 2855539022UL, 36229159UL, 1591415533UL, 3471572739UL, 3920625546UL, 2614469314UL, 213338525UL, 886212578UL, 2620301943UL, 827771411UL, 2430496777UL, 1198164420UL, 2644841698UL, 3654164701UL, 2747674190UL, 1461695896UL, 1770331341UL, 1641501876UL, 3470919184UL, 919857376UL, 3053795110UL, 3533531372UL, 
3134337355UL, 668308383UL, 201138876UL, 3221275220UL, 1589659138UL, 294382235UL, 1447443579UL, 4211579707UL, 1799726917UL, 2838977761UL, 4172949119UL, 2360858031UL, 416103844UL, 2248389027UL, 1790015671UL, 3925738275UL, 1049918544UL, 3481887924UL, 1619955951UL, 4188275966UL, 1672572975UL, 2672697497UL, 564854400UL, 747724021UL, 4037561738UL, 1605940213UL, 445253292UL, 604900912UL, 610898209UL, 1473244091UL, 735444769UL, 1540599852UL, 
3036173307UL, 1032410949UL, 3672467167UL, 68684525UL, 1738833632UL, 973022696UL, 519684794UL, 2291130512UL, 503032614UL, 3658059597UL, 1500301452UL, 2400186105UL, 3498787788UL, 422428426UL, 3879256913UL, 3923611748UL, 4120704752UL, 298972869UL, 1718342816UL, 2541691685UL, 2323881484UL, 1686027891UL, 4223212804UL, 1812334632UL, 3717655725UL, 2109094458UL, 642431972UL, 2621896355UL, 2572404999UL, 3590094954UL, 1837882537UL, 2949609717UL, 
1392353032UL, 1733137169UL, 2674005018UL, 3252348987UL, 1526077846UL, 451078217UL, 2591688848UL, 12635611UL, 3971261781UL, 2417951415UL, 1789383090UL, 1140183890UL, 1720695967UL, 2906966040UL, 3465605863UL, 2793804971UL, 1054433135UL, 2345087879UL, 915518921UL, 3079297626UL, 1793223686UL, 1055357758UL, 914271617UL, 791633499UL, 306802527UL, 2754998083UL, 3179053982UL, 598442002UL, 324402573UL, 2473418737UL, 3566888111UL, 2832258993UL, 
4260365359UL, 2168046398UL, 2097776414UL, 3852730296UL, 3643260763UL, 2163607277UL, 2595175979UL, 3957721904UL, 215187467UL, 2369406909UL, 1929000706UL, 657446369UL, 3779486126UL, 810692262UL, 1337974799UL, 4030350704UL, 1865557469UL, 1127012865UL, 1026825278UL, 593628480UL, 1817383139UL, 3414354529UL, 361018423UL, 203612980UL, 2102950440UL, 3407143936UL, 1739372987UL, 1475218277UL, 2827580539UL, 305467658UL, 3292706746UL, 825045562UL, 
1900092336UL, 3697343089UL, 760470915UL, 587414402UL, 2000637694UL, 343303227UL, 3891626781UL, 2757016765UL, 1090707384UL, 4015377800UL, 745490961UL, 2855539022UL, 36229159UL, 1591415533UL, 2208656873UL, 3920625546UL, 2614469314UL, 213338525UL, 886212578UL, 2729976209UL, 827771411UL, 2430496777UL, 1198164420UL, 2644841698UL, 1922667440UL, 2747674190UL, 1461695896UL, 1770331341UL, 1641501876UL, 357535311UL, 919857376UL, 3053795110UL, 
3533531372UL, 3134337355UL, 1004072597UL, 201138876UL, 3221275220UL, 1589659138UL, 294382235UL, 1148950143UL, 4211579707UL, 1799726917UL, 2838977761UL, 4172949119UL, 892664404UL, 416103844UL, 2248389027UL, 1790015671UL, 3925738275UL, 2612357890UL, 3481887924UL, 1619955951UL, 4188275966UL, 1672572975UL, 2005534713UL, 564854400UL, 747724021UL, 4037561738UL, 1605940213UL, 2620990454UL, 604900912UL, 610898209UL, 1473244091UL, 735444769UL, 
3571225334UL, 3036173307UL, 1032410949UL, 3672467167UL, 68684525UL, 3327351604UL, 973022696UL, 519684794UL, 2291130512UL, 503032614UL, 3814902238UL, 1500301452UL, 2400186105UL, 3498787788UL, 422428426UL, 1756753750UL, 3923611748UL, 4120704752UL, 298972869UL, 1718342816UL, 652903081UL, 2323881484UL, 1686027891UL, 4223212804UL, 1812334632UL, 1599640566UL, 2109094458UL, 642431972UL, 2621896355UL, 2572404999UL, 1668409355UL, 1837882537UL, 
2949609717UL, 1392353032UL, 1733137169UL, 3691709793UL, 3252348987UL, 1526077846UL, 451078217UL, 2591688848UL, 3353622601UL, 3971261781UL, 2417951415UL, 1789383090UL, 1140183890UL, 4113853791UL, 2906966040UL, 3465605863UL, 2793804971UL, 1054433135UL, 2195882948UL, 915518921UL, 3079297626UL, 1793223686UL, 1055357758UL, 898713552UL, 791633499UL, 306802527UL, 2754998083UL, 3179053982UL, 2469350088UL, 324402573UL, 2473418737UL, 3566888111UL, 
2832258993UL, 1377718274UL, 2168046398UL, 2097776414UL, 3852730296UL, 3643260763UL, 3492388484UL, 2595175979UL, 3957721904UL, 215187467UL, 2369406909UL, 4243449339UL, 657446369UL, 3779486126UL, 810692262UL, 1337974799UL, 3960230785UL, 1865557469UL, 1127012865UL, 1026825278UL, 593628480UL, 732793312UL, 3414354529UL, 361018423UL, 203612980UL, 2102950440UL, 2401792405UL, 1739372987UL, 1475218277UL, 2827580539UL, 305467658UL, 2454275289UL, 
825045562UL, 1900092336UL, 3697343089UL, 760470915UL, 2146882409UL, 2000637694UL, 343303227UL, 3891626781UL, 2757016765UL, 3997473261UL, 4015377800UL, 745490961UL, 2855539022UL, 36229159UL, 2375394427UL, 2208656873UL, 3920625546UL, 2614469314UL, 213338525UL, 2055366274UL, 2729976209UL, 827771411UL, 2430496777UL, 1198164420UL, 1789631187UL, 1922667440UL, 2747674190UL, 1461695896UL, 1770331341UL, 4284442852UL, 357535311UL, 919857376UL, 
3053795110UL, 3533531372UL, 2124270060UL, 1004072597UL, 201138876UL, 3221275220UL, 1589659138UL, 1418386120UL, 1148950143UL, 4211579707UL, 1799726917UL, 2838977761UL, 3540708069UL, 892664404UL, 416103844UL, 2248389027UL, 1790015671UL, 3936883UL, 2612357890UL, 3481887924UL, 1619955951UL, 4188275966UL, 2963623483UL, 2005534713UL, 564854400UL, 747724021UL, 4037561738UL, 3431155922UL, 2620990454UL, 604900912UL, 610898209UL, 1473244091UL, 
3880001339UL, 2879060316UL, 3300897679UL, 3960972039UL, 3201086624UL, 3814462934UL, 3426650044UL, 1930881632UL, 1981178788UL, 2956279691UL, 4272406256UL, 372705521UL, 1359389771UL, 1590302979UL, 3940206208UL, 3817999127UL, 2527835456UL, 2739078164UL, 716997849UL, 3235607043UL, 2550297745UL, 3688700200UL, 354502605UL, 2285793656UL, 2339138034UL, 3912354142UL, 2262255668UL, 469322622UL, 1319943359UL, 1916101235UL, 200441823UL, 509436982UL, 
2160284593UL, 1687919695UL, 4153615582UL, 495735041UL, 3694469424UL, 2086893117UL, 4223008799UL, 105344742UL, 1698033424UL, 1149223145UL, 4183918790UL, 4176151950UL, 415739351UL, 817762972UL, 3768072560UL, 1931430949UL, 2698979439UL, 3481477932UL, 1994322914UL, 4078299950UL, 1268233995UL, 3254069145UL, 91029129UL, 498234704UL, 1636613942UL, 3710087092UL, 3876816560UL, 3510446387UL, 3870169008UL, 1370156410UL, 2442498047UL, 2324396523UL, 
1258730334UL, 621954739UL, 1053015373UL, 491820717UL, 3386515432UL, 2203703266UL, 120167176UL, 2383669740UL, 1038666440UL, 2927342870UL, 3583197824UL, 1236241846UL, 2474675929UL, 679052891UL, 2451259584UL, 2177706146UL, 606842882UL, 3546980104UL, 2289281509UL, 353873434UL, 2041926837UL, 1238346748UL, 2729109726UL, 2843938395UL, 2938124210UL, 2554443866UL, 1494477920UL, 693378319UL, 2020963566UL, 2000385949UL, 3744098787UL, 650307220UL, 
2631327075UL, 1529128757UL, 595871428UL, 3206666562UL, 458062987UL, 875238192UL, 3729317374UL, 1368843921UL, 3478430230UL, 3234384578UL, 3232435428UL, 321359326UL, 994274524UL, 361184397UL, 4285497594UL, 915263578UL, 1486882838UL, 9988613UL, 829077170UL, 677216046UL, 4141828204UL, 165804609UL, 1086678519UL, 2933434608UL, 1351662802UL, 2640085040UL, 2611502932UL, 2033698714UL, 2008873254UL, 3995557835UL, 1020873906UL, 67873555UL, 
2230337823UL, 1263800417UL, 1148712155UL, 3985159589UL, 2979503513UL, 2854714997UL, 1539343345UL, 2751484352UL, 1569100732UL, 2020758949UL, 2126757134UL, 3426641899UL, 2808587825UL, 1953320148UL, 1096398464UL, 1502907172UL, 3751230087UL, 765557661UL, 765290990UL, 3056075500UL, 2040620632UL, 422573751UL, 3613558930UL, 1741145769UL, 273531216UL, 837238736UL, 494297893UL, 2903251124UL, 1636782182UL, 4256592784UL, 3652746656UL, 4258393217UL, 
},

};

static unsigned int precalc_xorwow_matrix_host[8][800] = {
{
850664906UL, 2293210629UL, 1517805917UL, 1215500405UL, 1612415445UL, 645388200UL, 824349799UL, 3517232886UL, 4075591755UL, 3089899292UL, 4249786064UL, 3811424903UL, 1100783479UL, 53649761UL, 2817264826UL, 3159462529UL, 1654848550UL, 950025444UL, 3095510002UL, 4080567211UL, 4111078399UL, 3241719305UL, 2788212779UL, 4256963770UL, 2426893717UL, 4190211142UL, 1420776905UL, 3780537969UL, 1102912875UL, 1657948873UL, 3354905256UL, 2519610308UL, 
515777663UL, 3396785394UL, 1832603711UL, 1154211550UL, 1915690212UL, 1933919046UL, 789578337UL, 337961173UL, 1359089498UL, 2249086205UL, 3417955173UL, 862571348UL, 528120760UL, 1265685672UL, 1970052076UL, 3585976752UL, 3645339918UL, 312171257UL, 1360991400UL, 1994321680UL, 2327168468UL, 2540437053UL, 1180483641UL, 2217962701UL, 182726833UL, 590204372UL, 1904496495UL, 2545607041UL, 3697978033UL, 1084030545UL, 3397906968UL, 2192325323UL, 
2704204176UL, 1069092002UL, 2364406907UL, 1578647245UL, 3561974633UL, 3437665426UL, 1464127305UL, 1616628807UL, 2243114101UL, 3639967880UL, 1702613633UL, 2437350057UL, 39991274UL, 2024323584UL, 3795072940UL, 3604530798UL, 443099203UL, 643536212UL, 1919517328UL, 3931285769UL, 427935569UL, 276421624UL, 2492081750UL, 262729512UL, 3088549877UL, 2922650665UL, 1816283755UL, 4246096489UL, 842575914UL, 1460435650UL, 3050522190UL, 2640849794UL, 
3697925816UL, 3465779075UL, 3856929655UL, 1365559780UL, 2897029415UL, 2747033756UL, 3611830629UL, 1891542518UL, 1897590206UL, 437451803UL, 677924906UL, 123809117UL, 3940574372UL, 687640291UL, 3488484529UL, 470218446UL, 1092571016UL, 1537938503UL, 1073323937UL, 611300083UL, 3809285994UL, 3975678726UL, 925845389UL, 2514775760UL, 2859302390UL, 2761919483UL, 993285307UL, 164095287UL, 3736193671UL, 2078946336UL, 1418537059UL, 1202525920UL, 
4234029440UL, 1313593624UL, 2484428922UL, 1833969372UL, 661495122UL, 2217907395UL, 2795045321UL, 2950835531UL, 1402379354UL, 351314168UL, 1902476749UL, 1914974334UL, 2873973176UL, 1321203603UL, 3316118265UL, 3282193947UL, 1342191737UL, 793441242UL, 3281524559UL, 296088733UL, 487851702UL, 712098215UL, 1388727135UL, 1705533557UL, 3557800292UL, 399729516UL, 1355829467UL, 291276309UL, 421164833UL, 1318404599UL, 2064519128UL, 1161612642UL, 
2076623594UL, 850664906UL, 2293210629UL, 1517805917UL, 1215500405UL, 3847487204UL, 645388200UL, 824349799UL, 3517232886UL, 4075591755UL, 2755872609UL, 4249786064UL, 3811424903UL, 1100783479UL, 53649761UL, 1417544262UL, 3159462529UL, 1654848550UL, 950025444UL, 3095510002UL, 1908900347UL, 4111078399UL, 3241719305UL, 2788212779UL, 4256963770UL, 3750258343UL, 4190211142UL, 1420776905UL, 3780537969UL, 1102912875UL, 1690550UL, 3354905256UL, 
2519610308UL, 515777663UL, 3396785394UL, 2658162202UL, 1154211550UL, 1915690212UL, 1933919046UL, 789578337UL, 189880016UL, 1359089498UL, 2249086205UL, 3417955173UL, 862571348UL, 998719835UL, 1265685672UL, 1970052076UL, 3585976752UL, 3645339918UL, 2973042959UL, 1360991400UL, 1994321680UL, 2327168468UL, 2540437053UL, 2283905032UL, 2217962701UL, 182726833UL, 590204372UL, 1904496495UL, 110719262UL, 3697978033UL, 1084030545UL, 3397906968UL, 
2192325323UL, 4133333579UL, 1069092002UL, 2364406907UL, 1578647245UL, 3561974633UL, 3629845331UL, 1464127305UL, 1616628807UL, 2243114101UL, 3639967880UL, 3256744141UL, 2437350057UL, 39991274UL, 2024323584UL, 3795072940UL, 1024703328UL, 443099203UL, 643536212UL, 1919517328UL, 3931285769UL, 2755167056UL, 276421624UL, 2492081750UL, 262729512UL, 3088549877UL, 2817867653UL, 1816283755UL, 4246096489UL, 842575914UL, 1460435650UL, 2276077438UL, 
2640849794UL, 3697925816UL, 3465779075UL, 3856929655UL, 130551477UL, 2897029415UL, 2747033756UL, 3611830629UL, 1891542518UL, 804565809UL, 437451803UL, 677924906UL, 123809117UL, 3940574372UL, 2446610749UL, 3488484529UL, 470218446UL, 1092571016UL, 1537938503UL, 1502147484UL, 611300083UL, 3809285994UL, 3975678726UL, 925845389UL, 872826112UL, 2859302390UL, 2761919483UL, 993285307UL, 164095287UL, 3901654538UL, 2078946336UL, 1418537059UL, 
1202525920UL, 4234029440UL, 704759480UL, 2484428922UL, 1833969372UL, 661495122UL, 2217907395UL, 3287413716UL, 2950835531UL, 1402379354UL, 351314168UL, 1902476749UL, 2033316109UL, 2873973176UL, 1321203603UL, 3316118265UL, 3282193947UL, 1316780684UL, 793441242UL, 3281524559UL, 296088733UL, 487851702UL, 314311643UL, 1388727135UL, 1705533557UL, 3557800292UL, 399729516UL, 1660074989UL, 291276309UL, 421164833UL, 1318404599UL, 2064519128UL, 
3156334112UL, 2076623594UL, 850664906UL, 2293210629UL, 1517805917UL, 335452425UL, 3847487204UL, 645388200UL, 824349799UL, 3517232886UL, 954487767UL, 2755872609UL, 4249786064UL, 3811424903UL, 1100783479UL, 3408594583UL, 1417544262UL, 3159462529UL, 1654848550UL, 950025444UL, 324339737UL, 1908900347UL, 4111078399UL, 3241719305UL, 2788212779UL, 1890540205UL, 3750258343UL, 4190211142UL, 1420776905UL, 3780537969UL, 3716648585UL, 1690550UL, 
3354905256UL, 2519610308UL, 515777663UL, 3758156132UL, 2658162202UL, 1154211550UL, 1915690212UL, 1933919046UL, 844149171UL, 189880016UL, 1359089498UL, 2249086205UL, 3417955173UL, 1031812215UL, 998719835UL, 1265685672UL, 1970052076UL, 3585976752UL, 3174204115UL, 2973042959UL, 1360991400UL, 1994321680UL, 2327168468UL, 714016907UL, 2283905032UL, 2217962701UL, 182726833UL, 590204372UL, 2151450260UL, 110719262UL, 3697978033UL, 1084030545UL, 
3397906968UL, 767772303UL, 4133333579UL, 1069092002UL, 2364406907UL, 1578647245UL, 42955292UL, 3629845331UL, 1464127305UL, 1616628807UL, 2243114101UL, 3222189776UL, 3256744141UL, 2437350057UL, 39991274UL, 2024323584UL, 3142424684UL, 1024703328UL, 443099203UL, 643536212UL, 1919517328UL, 918511196UL, 2755167056UL, 276421624UL, 2492081750UL, 262729512UL, 4246877536UL, 2817867653UL, 1816283755UL, 4246096489UL, 842575914UL, 1425765936UL, 
2276077438UL, 2640849794UL, 3697925816UL, 3465779075UL, 1491702526UL, 130551477UL, 2897029415UL, 2747033756UL, 3611830629UL, 1844578694UL, 804565809UL, 437451803UL, 677924906UL, 123809117UL, 3419189841UL, 2446610749UL, 3488484529UL, 470218446UL, 1092571016UL, 3272535988UL, 1502147484UL, 611300083UL, 3809285994UL, 3975678726UL, 2853681168UL, 872826112UL, 2859302390UL, 2761919483UL, 993285307UL, 1434560128UL, 3901654538UL, 2078946336UL, 
1418537059UL, 1202525920UL, 2530097881UL, 704759480UL, 2484428922UL, 1833969372UL, 661495122UL, 503878844UL, 3287413716UL, 2950835531UL, 1402379354UL, 351314168UL, 4131886119UL, 2033316109UL, 2873973176UL, 1321203603UL, 3316118265UL, 237900321UL, 1316780684UL, 793441242UL, 3281524559UL, 296088733UL, 1730738847UL, 314311643UL, 1388727135UL, 1705533557UL, 3557800292UL, 1553835665UL, 1660074989UL, 291276309UL, 421164833UL, 1318404599UL, 
964731488UL, 3156334112UL, 2076623594UL, 850664906UL, 2293210629UL, 1105350579UL, 335452425UL, 3847487204UL, 645388200UL, 824349799UL, 2789953706UL, 954487767UL, 2755872609UL, 4249786064UL, 3811424903UL, 3937839949UL, 3408594583UL, 1417544262UL, 3159462529UL, 1654848550UL, 624060530UL, 324339737UL, 1908900347UL, 4111078399UL, 3241719305UL, 2294919498UL, 1890540205UL, 3750258343UL, 4190211142UL, 1420776905UL, 2279133729UL, 3716648585UL, 
1690550UL, 3354905256UL, 2519610308UL, 3563975602UL, 3758156132UL, 2658162202UL, 1154211550UL, 1915690212UL, 3505586122UL, 844149171UL, 189880016UL, 1359089498UL, 2249086205UL, 2389487504UL, 1031812215UL, 998719835UL, 1265685672UL, 1970052076UL, 2798611919UL, 3174204115UL, 2973042959UL, 1360991400UL, 1994321680UL, 1684134678UL, 714016907UL, 2283905032UL, 2217962701UL, 182726833UL, 1734988742UL, 2151450260UL, 110719262UL, 3697978033UL, 
1084030545UL, 159906818UL, 767772303UL, 4133333579UL, 1069092002UL, 2364406907UL, 1290801202UL, 42955292UL, 3629845331UL, 1464127305UL, 1616628807UL, 987794861UL, 3222189776UL, 3256744141UL, 2437350057UL, 39991274UL, 3644076751UL, 3142424684UL, 1024703328UL, 443099203UL, 643536212UL, 1487589384UL, 918511196UL, 2755167056UL, 276421624UL, 2492081750UL, 137688638UL, 4246877536UL, 2817867653UL, 1816283755UL, 4246096489UL, 1518475380UL, 
1425765936UL, 2276077438UL, 2640849794UL, 3697925816UL, 4226506771UL, 1491702526UL, 130551477UL, 2897029415UL, 2747033756UL, 2033599579UL, 1844578694UL, 804565809UL, 437451803UL, 677924906UL, 2749065512UL, 3419189841UL, 2446610749UL, 3488484529UL, 470218446UL, 290444026UL, 3272535988UL, 1502147484UL, 611300083UL, 3809285994UL, 2546040767UL, 2853681168UL, 872826112UL, 2859302390UL, 2761919483UL, 4097961150UL, 1434560128UL, 3901654538UL, 
2078946336UL, 1418537059UL, 2725734455UL, 2530097881UL, 704759480UL, 2484428922UL, 1833969372UL, 3999408333UL, 503878844UL, 3287413716UL, 2950835531UL, 1402379354UL, 3861442503UL, 4131886119UL, 2033316109UL, 2873973176UL, 1321203603UL, 1267331405UL, 237900321UL, 1316780684UL, 793441242UL, 3281524559UL, 1273427916UL, 1730738847UL, 314311643UL, 1388727135UL, 1705533557UL, 1474310231UL, 1553835665UL, 1660074989UL, 291276309UL, 421164833UL, 
3884815658UL, 3088049345UL, 3307042227UL, 3228948601UL, 1717605083UL, 1864502063UL, 3799516572UL, 2372822470UL, 2691586476UL, 1172840854UL, 1577099080UL, 870101866UL, 2139291021UL, 406996656UL, 255568268UL, 897760202UL, 674745664UL, 885214361UL, 3753233375UL, 3015215223UL, 1711461259UL, 3241363282UL, 2125360928UL, 2493601640UL, 2350228245UL, 3434627328UL, 2095642963UL, 3360932494UL, 3287396242UL, 4070512427UL, 3415702664UL, 1958354224UL, 
3280206940UL, 3929504236UL, 3390499817UL, 4144225735UL, 3621750606UL, 3205006592UL, 3495743785UL, 269239326UL, 2181299371UL, 2898796651UL, 2613623219UL, 3988711298UL, 2162437858UL, 949553433UL, 3289670000UL, 3559525307UL, 3366925567UL, 2112148665UL, 955626393UL, 1790865381UL, 699223558UL, 3889584301UL, 1020750250UL, 4105283899UL, 2295851818UL, 4045668915UL, 2224770025UL, 766386910UL, 4265157386UL, 89139307UL, 2099710177UL, 1012450874UL, 
1875492446UL, 1927399417UL, 767450812UL, 654474783UL, 4265293038UL, 4041215389UL, 4102336947UL, 4263617328UL, 2135826340UL, 2317231535UL, 3773895729UL, 403151111UL, 1400693138UL, 4255050194UL, 755369466UL, 2325764302UL, 2617301159UL, 4165707294UL, 1206304709UL, 2415645397UL, 4276004841UL, 1457022279UL, 662660652UL, 795140282UL, 828519889UL, 805830562UL, 1179976369UL, 2212548232UL, 755708248UL, 1034682071UL, 899950902UL, 1906046264UL, 
1861009040UL, 310711525UL, 920739741UL, 2322414272UL, 3179236470UL, 81822135UL, 4111390320UL, 1800166783UL, 112253014UL, 688771939UL, 1050990794UL, 3124647483UL, 287052171UL, 1363630156UL, 3447798279UL, 1405733552UL, 3075862538UL, 1682808202UL, 1595154222UL, 1173705692UL, 680713285UL, 2748212230UL, 568610527UL, 3434965538UL, 1114942930UL, 2835858745UL, 2575992250UL, 3243355150UL, 2127580225UL, 1855934450UL, 3915941751UL, 2228679809UL, 
1514780124UL, 1506688039UL, 1033083295UL, 793807083UL, 1120681149UL, 4105670165UL, 3999570340UL, 2083020131UL, 1213356023UL, 3684882757UL, 3375797774UL, 3577986103UL, 2092046164UL, 2593847443UL, 1826450612UL, 367828409UL, 3198272513UL, 1941316667UL, 943707510UL, 907134807UL, 2020457947UL, 1462193665UL, 2964617539UL, 4216491663UL, 2625270800UL, 2395371467UL, 3691003028UL, 3659016793UL, 2381847054UL, 3513105567UL, 3013019506UL, 2731245927UL, 
},
{
1680024716UL, 2112340059UL, 3387475367UL, 2080916186UL, 1431532386UL, 3907378472UL, 2636491350UL, 2176128529UL, 2236616671UL, 3736851460UL, 2604001339UL, 3893075234UL, 3495918635UL, 4116370522UL, 1384310379UL, 3660102574UL, 2030233939UL, 2759207091UL, 49347923UL, 97526506UL, 2566932710UL, 1566181275UL, 3127827248UL, 578401670UL, 1499229308UL, 2581732444UL, 279715551UL, 809690877UL, 1438444015UL, 878935323UL, 1495277039UL, 3417305339UL, 
2858903785UL, 3074075088UL, 603749086UL, 2370669734UL, 391683868UL, 3933465331UL, 2884128106UL, 1478317876UL, 1864988335UL, 2925823809UL, 4133578805UL, 218104493UL, 368652174UL, 1998600344UL, 1109346044UL, 1716435313UL, 415435111UL, 91393686UL, 2536620737UL, 1440068573UL, 481874870UL, 142128108UL, 988825519UL, 2077118779UL, 2858045339UL, 4068162251UL, 115593872UL, 1364244587UL, 3550167006UL, 3728768059UL, 1772423685UL, 2504624145UL, 
248732306UL, 1412607307UL, 4081166331UL, 154438218UL, 1652901877UL, 3932533490UL, 3142799969UL, 3154073676UL, 3112018078UL, 2757873595UL, 2364830126UL, 2855791484UL, 793851407UL, 507785167UL, 263713916UL, 4060700051UL, 3291978358UL, 1584226715UL, 2546417990UL, 450747961UL, 2951067700UL, 2706009093UL, 1788578194UL, 4030171132UL, 2610979903UL, 573420740UL, 4269115622UL, 2180305819UL, 2646894726UL, 716649335UL, 3875715683UL, 853428184UL, 
2436760738UL, 4190071217UL, 2754423535UL, 540698101UL, 4082489821UL, 741976046UL, 267559495UL, 1591532642UL, 2500610323UL, 3203248679UL, 147312102UL, 2772368222UL, 1412987047UL, 2295185573UL, 1932341300UL, 898396308UL, 1837129999UL, 3113914292UL, 2613354524UL, 3141601915UL, 276087167UL, 1887389351UL, 757801450UL, 3752353732UL, 2745818074UL, 1442953464UL, 3802648347UL, 223728071UL, 2169947402UL, 1338125300UL, 3642174036UL, 2794462634UL, 
2326349851UL, 862746036UL, 3577092599UL, 627103363UL, 552173564UL, 4142604459UL, 2310329406UL, 583522272UL, 189323282UL, 1217612313UL, 73550248UL, 2434692829UL, 2757269706UL, 2392210091UL, 3032922600UL, 3573904125UL, 2897178037UL, 2632631469UL, 3085332665UL, 3775619904UL, 2563291734UL, 1351375865UL, 4043427793UL, 1803743084UL, 3112116579UL, 522940594UL, 2690374983UL, 2613871529UL, 3810037031UL, 1765642390UL, 534554747UL, 1930852049UL, 
2264349344UL, 1680024716UL, 2112340059UL, 3387475367UL, 2080916186UL, 75966494UL, 3907378472UL, 2636491350UL, 2176128529UL, 2236616671UL, 2372987046UL, 2604001339UL, 3893075234UL, 3495918635UL, 4116370522UL, 534929913UL, 3660102574UL, 2030233939UL, 2759207091UL, 49347923UL, 987575186UL, 2566932710UL, 1566181275UL, 3127827248UL, 578401670UL, 3731513754UL, 2581732444UL, 279715551UL, 809690877UL, 1438444015UL, 2185866850UL, 1495277039UL, 
3417305339UL, 2858903785UL, 3074075088UL, 4198538376UL, 2370669734UL, 391683868UL, 3933465331UL, 2884128106UL, 1400216510UL, 1864988335UL, 2925823809UL, 4133578805UL, 218104493UL, 2798390374UL, 1998600344UL, 1109346044UL, 1716435313UL, 415435111UL, 1892535124UL, 2536620737UL, 1440068573UL, 481874870UL, 142128108UL, 329082740UL, 2077118779UL, 2858045339UL, 4068162251UL, 115593872UL, 2644000449UL, 3550167006UL, 3728768059UL, 1772423685UL, 
2504624145UL, 2140118619UL, 1412607307UL, 4081166331UL, 154438218UL, 1652901877UL, 3804911318UL, 3142799969UL, 3154073676UL, 3112018078UL, 2757873595UL, 50297646UL, 2855791484UL, 793851407UL, 507785167UL, 263713916UL, 3324588195UL, 3291978358UL, 1584226715UL, 2546417990UL, 450747961UL, 3455625012UL, 2706009093UL, 1788578194UL, 4030171132UL, 2610979903UL, 3835380965UL, 4269115622UL, 2180305819UL, 2646894726UL, 716649335UL, 2607142354UL, 
853428184UL, 2436760738UL, 4190071217UL, 2754423535UL, 456808691UL, 4082489821UL, 741976046UL, 267559495UL, 1591532642UL, 2722205042UL, 3203248679UL, 147312102UL, 2772368222UL, 1412987047UL, 1950543946UL, 1932341300UL, 898396308UL, 1837129999UL, 3113914292UL, 428616392UL, 3141601915UL, 276087167UL, 1887389351UL, 757801450UL, 963534966UL, 2745818074UL, 1442953464UL, 3802648347UL, 223728071UL, 229039300UL, 1338125300UL, 3642174036UL, 
2794462634UL, 2326349851UL, 206115203UL, 3577092599UL, 627103363UL, 552173564UL, 4142604459UL, 1492461846UL, 583522272UL, 189323282UL, 1217612313UL, 73550248UL, 3552211807UL, 2757269706UL, 2392210091UL, 3032922600UL, 3573904125UL, 810640644UL, 2632631469UL, 3085332665UL, 3775619904UL, 2563291734UL, 922608790UL, 4043427793UL, 1803743084UL, 3112116579UL, 522940594UL, 1785093944UL, 2613871529UL, 3810037031UL, 1765642390UL, 534554747UL, 
3528050076UL, 2264349344UL, 1680024716UL, 2112340059UL, 3387475367UL, 3295682653UL, 75966494UL, 3907378472UL, 2636491350UL, 2176128529UL, 3574915532UL, 2372987046UL, 2604001339UL, 3893075234UL, 3495918635UL, 1280296085UL, 534929913UL, 3660102574UL, 2030233939UL, 2759207091UL, 299776535UL, 987575186UL, 2566932710UL, 1566181275UL, 3127827248UL, 3874691533UL, 3731513754UL, 2581732444UL, 279715551UL, 809690877UL, 3100791084UL, 2185866850UL, 
1495277039UL, 3417305339UL, 2858903785UL, 1310351481UL, 4198538376UL, 2370669734UL, 391683868UL, 3933465331UL, 2749085130UL, 1400216510UL, 1864988335UL, 2925823809UL, 4133578805UL, 3352814594UL, 2798390374UL, 1998600344UL, 1109346044UL, 1716435313UL, 1571752941UL, 1892535124UL, 2536620737UL, 1440068573UL, 481874870UL, 2485033697UL, 329082740UL, 2077118779UL, 2858045339UL, 4068162251UL, 3837440666UL, 2644000449UL, 3550167006UL, 3728768059UL, 
1772423685UL, 1176559812UL, 2140118619UL, 1412607307UL, 4081166331UL, 154438218UL, 2902622972UL, 3804911318UL, 3142799969UL, 3154073676UL, 3112018078UL, 2403391233UL, 50297646UL, 2855791484UL, 793851407UL, 507785167UL, 2351826747UL, 3324588195UL, 3291978358UL, 1584226715UL, 2546417990UL, 746876926UL, 3455625012UL, 2706009093UL, 1788578194UL, 4030171132UL, 3779307353UL, 3835380965UL, 4269115622UL, 2180305819UL, 2646894726UL, 2602235234UL, 
2607142354UL, 853428184UL, 2436760738UL, 4190071217UL, 2066757692UL, 456808691UL, 4082489821UL, 741976046UL, 267559495UL, 3001080633UL, 2722205042UL, 3203248679UL, 147312102UL, 2772368222UL, 89950260UL, 1950543946UL, 1932341300UL, 898396308UL, 1837129999UL, 947911286UL, 428616392UL, 3141601915UL, 276087167UL, 1887389351UL, 2583987247UL, 963534966UL, 2745818074UL, 1442953464UL, 3802648347UL, 4229124441UL, 229039300UL, 1338125300UL, 
3642174036UL, 2794462634UL, 2472155633UL, 206115203UL, 3577092599UL, 627103363UL, 552173564UL, 2586882739UL, 1492461846UL, 583522272UL, 189323282UL, 1217612313UL, 3501549884UL, 3552211807UL, 2757269706UL, 2392210091UL, 3032922600UL, 740675778UL, 810640644UL, 2632631469UL, 3085332665UL, 3775619904UL, 3643289881UL, 922608790UL, 4043427793UL, 1803743084UL, 3112116579UL, 2213337398UL, 1785093944UL, 2613871529UL, 3810037031UL, 1765642390UL, 
762472016UL, 3528050076UL, 2264349344UL, 1680024716UL, 2112340059UL, 1372272974UL, 3295682653UL, 75966494UL, 3907378472UL, 2636491350UL, 3117471955UL, 3574915532UL, 2372987046UL, 2604001339UL, 3893075234UL, 915576383UL, 1280296085UL, 534929913UL, 3660102574UL, 2030233939UL, 346368350UL, 299776535UL, 987575186UL, 2566932710UL, 1566181275UL, 3535223896UL, 3874691533UL, 3731513754UL, 2581732444UL, 279715551UL, 2456894951UL, 3100791084UL, 
2185866850UL, 1495277039UL, 3417305339UL, 1618871086UL, 1310351481UL, 4198538376UL, 2370669734UL, 391683868UL, 2009676005UL, 2749085130UL, 1400216510UL, 1864988335UL, 2925823809UL, 58955107UL, 3352814594UL, 2798390374UL, 1998600344UL, 1109346044UL, 3273979614UL, 1571752941UL, 1892535124UL, 2536620737UL, 1440068573UL, 1174168447UL, 2485033697UL, 329082740UL, 2077118779UL, 2858045339UL, 4062921629UL, 3837440666UL, 2644000449UL, 3550167006UL, 
3728768059UL, 2642133401UL, 1176559812UL, 2140118619UL, 1412607307UL, 4081166331UL, 3124905304UL, 2902622972UL, 3804911318UL, 3142799969UL, 3154073676UL, 1449454613UL, 2403391233UL, 50297646UL, 2855791484UL, 793851407UL, 3514201526UL, 2351826747UL, 3324588195UL, 3291978358UL, 1584226715UL, 3636681672UL, 746876926UL, 3455625012UL, 2706009093UL, 1788578194UL, 3451519459UL, 3779307353UL, 3835380965UL, 4269115622UL, 2180305819UL, 3987989524UL, 
2602235234UL, 2607142354UL, 853428184UL, 2436760738UL, 2151617107UL, 2066757692UL, 456808691UL, 4082489821UL, 741976046UL, 3590081269UL, 3001080633UL, 2722205042UL, 3203248679UL, 147312102UL, 3432947806UL, 89950260UL, 1950543946UL, 1932341300UL, 898396308UL, 3828432864UL, 947911286UL, 428616392UL, 3141601915UL, 276087167UL, 2517666433UL, 2583987247UL, 963534966UL, 2745818074UL, 1442953464UL, 2223986807UL, 4229124441UL, 229039300UL, 
1338125300UL, 3642174036UL, 1053796945UL, 2472155633UL, 206115203UL, 3577092599UL, 627103363UL, 1113276084UL, 2586882739UL, 1492461846UL, 583522272UL, 189323282UL, 1490604990UL, 3501549884UL, 3552211807UL, 2757269706UL, 2392210091UL, 3545407532UL, 740675778UL, 810640644UL, 2632631469UL, 3085332665UL, 755862267UL, 3643289881UL, 922608790UL, 4043427793UL, 1803743084UL, 1954166630UL, 2213337398UL, 1785093944UL, 2613871529UL, 3810037031UL, 
3042935707UL, 3162182177UL, 2791346436UL, 1901925289UL, 863100941UL, 3367519168UL, 1972623238UL, 3664303070UL, 604922059UL, 3026817982UL, 1436412310UL, 4096180631UL, 1597561857UL, 4206212303UL, 4127914332UL, 3228677359UL, 3985733659UL, 3597290113UL, 4251197894UL, 3451370603UL, 609679338UL, 3360835257UL, 1372239885UL, 638572328UL, 3806422284UL, 3974147336UL, 1804280837UL, 4209089291UL, 2021797469UL, 3557188838UL, 409727186UL, 2114649178UL, 
687702120UL, 2542445992UL, 1235991799UL, 460479179UL, 2008348175UL, 887884478UL, 3942327811UL, 2999928223UL, 4171339789UL, 2286339235UL, 1293442231UL, 1575942850UL, 76122475UL, 1440527701UL, 2006558403UL, 1544148172UL, 895899367UL, 681826913UL, 4094701935UL, 3995413790UL, 1027509154UL, 2264990896UL, 1938238113UL, 213430250UL, 222469320UL, 609726517UL, 3581538106UL, 492802663UL, 120480843UL, 1720004062UL, 1132674507UL, 911082758UL, 
2909148131UL, 566658805UL, 3964114445UL, 3483602509UL, 1793438750UL, 165562604UL, 3641830063UL, 2394205521UL, 3404874822UL, 1672998096UL, 916151953UL, 1141264477UL, 3171661340UL, 3803396219UL, 3018337382UL, 1863902683UL, 2474641928UL, 3250365071UL, 3897886220UL, 1219701051UL, 51332576UL, 1358614881UL, 1707407492UL, 3670647816UL, 923357625UL, 343687395UL, 3991339686UL, 3913575403UL, 1267727936UL, 4001357856UL, 3820224848UL, 2942896724UL, 
3505936742UL, 1403285299UL, 1992762049UL, 567748449UL, 2202721585UL, 2781324216UL, 1724850068UL, 2408314541UL, 3073975813UL, 3992810029UL, 2475242354UL, 540562053UL, 2185198943UL, 3759352041UL, 3373885614UL, 1132999410UL, 1097554565UL, 4089342358UL, 3239542922UL, 2451748646UL, 407290679UL, 3188103200UL, 1708016248UL, 26848241UL, 2796711130UL, 3090711568UL, 4068389322UL, 3420916085UL, 3137567033UL, 2877819818UL, 22133454UL, 4629160UL, 
3703695249UL, 1920151708UL, 1175452162UL, 130015299UL, 3331834713UL, 1099225384UL, 689254331UL, 1851083761UL, 2654970209UL, 3259297936UL, 3742819314UL, 3524284766UL, 2291819083UL, 3494031861UL, 16242889UL, 3545082774UL, 1997878108UL, 777447699UL, 4244916543UL, 3508640253UL, 3782278393UL, 2107258964UL, 2139074576UL, 1383217899UL, 2337934322UL, 3181899620UL, 1285955765UL, 2989610020UL, 3326862146UL, 1168587380UL, 801203532UL, 3020809957UL, 
},
{
3810471203UL, 1017064446UL, 1595207573UL, 441087832UL, 3326746890UL, 3294064431UL, 167972517UL, 3625210015UL, 1011845006UL, 2980240819UL, 1778354660UL, 3041730987UL, 1598611350UL, 2015169745UL, 2321724978UL, 3390812967UL, 2432904511UL, 113261909UL, 3957193232UL, 3806115908UL, 2965828929UL, 2035392295UL, 3500116619UL, 2881232416UL, 1672212265UL, 1607201428UL, 425148945UL, 1262591961UL, 2221781268UL, 4215047456UL, 2148245850UL, 2787488981UL, 
1077262192UL, 2085467561UL, 3053954888UL, 3584435116UL, 3013084787UL, 287099941UL, 1290407232UL, 4078552287UL, 2658945475UL, 4251530898UL, 2403086478UL, 2884923598UL, 3545110453UL, 4105390090UL, 343200643UL, 3189888821UL, 4086304363UL, 3466483195UL, 259435633UL, 2846377387UL, 497258846UL, 272775541UL, 985737911UL, 2957688879UL, 2180784344UL, 3434619542UL, 3643384838UL, 2228652440UL, 3107480718UL, 2208729807UL, 596436263UL, 3255120711UL, 
3248886970UL, 519242965UL, 602979109UL, 1619614UL, 1391563565UL, 56262588UL, 1584463910UL, 1849038201UL, 728022295UL, 848624947UL, 1813827408UL, 428214945UL, 1246345586UL, 4213351865UL, 168985863UL, 456608054UL, 4277869380UL, 3886828599UL, 2264054549UL, 3110967170UL, 3138175314UL, 2649164828UL, 3369378320UL, 3648350039UL, 3524848759UL, 1468470706UL, 3558859222UL, 2669673235UL, 831851874UL, 4285651092UL, 4224147373UL, 1088456706UL, 
231954609UL, 3118005852UL, 225508069UL, 883105389UL, 856371341UL, 2001356578UL, 639336670UL, 2363501707UL, 3622399552UL, 4024065226UL, 1093546838UL, 4263608561UL, 1852072422UL, 425195042UL, 2441102396UL, 296426333UL, 384641750UL, 3559334435UL, 1757327033UL, 1016016207UL, 3595686646UL, 24777793UL, 623926105UL, 2169195923UL, 1779396793UL, 646997837UL, 1459728476UL, 2644865980UL, 1994581089UL, 3956278544UL, 919592580UL, 2153558858UL, 
2029633394UL, 3837501009UL, 4016560170UL, 484838096UL, 3652199054UL, 1971790561UL, 605295089UL, 637470291UL, 278970544UL, 3574824693UL, 295866521UL, 1755035156UL, 2542341803UL, 1588716357UL, 1502596918UL, 4124554133UL, 3547049843UL, 1768033045UL, 1531734630UL, 101448323UL, 3233017580UL, 1793222944UL, 3187853500UL, 186000900UL, 803444571UL, 2820254958UL, 2009384608UL, 2384668855UL, 2222812920UL, 633608665UL, 2028480056UL, 1258028235UL, 
545095949UL, 3810471203UL, 1017064446UL, 1595207573UL, 441087832UL, 899068662UL, 3294064431UL, 167972517UL, 3625210015UL, 1011845006UL, 3951305793UL, 1778354660UL, 3041730987UL, 1598611350UL, 2015169745UL, 1885149424UL, 3390812967UL, 2432904511UL, 113261909UL, 3957193232UL, 3953443155UL, 2965828929UL, 2035392295UL, 3500116619UL, 2881232416UL, 329153573UL, 1607201428UL, 425148945UL, 1262591961UL, 2221781268UL, 78028761UL, 2148245850UL, 
2787488981UL, 1077262192UL, 2085467561UL, 647235899UL, 3584435116UL, 3013084787UL, 287099941UL, 1290407232UL, 1467385694UL, 2658945475UL, 4251530898UL, 2403086478UL, 2884923598UL, 3489351040UL, 4105390090UL, 343200643UL, 3189888821UL, 4086304363UL, 3521512280UL, 259435633UL, 2846377387UL, 497258846UL, 272775541UL, 1367093111UL, 2957688879UL, 2180784344UL, 3434619542UL, 3643384838UL, 411877686UL, 3107480718UL, 2208729807UL, 596436263UL, 
3255120711UL, 584605030UL, 519242965UL, 602979109UL, 1619614UL, 1391563565UL, 3902518209UL, 1584463910UL, 1849038201UL, 728022295UL, 848624947UL, 1932969318UL, 428214945UL, 1246345586UL, 4213351865UL, 168985863UL, 2770345237UL, 4277869380UL, 3886828599UL, 2264054549UL, 3110967170UL, 2953581033UL, 2649164828UL, 3369378320UL, 3648350039UL, 3524848759UL, 2380353977UL, 3558859222UL, 2669673235UL, 831851874UL, 4285651092UL, 1214052447UL, 
1088456706UL, 231954609UL, 3118005852UL, 225508069UL, 1766983646UL, 856371341UL, 2001356578UL, 639336670UL, 2363501707UL, 1782816591UL, 4024065226UL, 1093546838UL, 4263608561UL, 1852072422UL, 1149716600UL, 2441102396UL, 296426333UL, 384641750UL, 3559334435UL, 2391309970UL, 1016016207UL, 3595686646UL, 24777793UL, 623926105UL, 362098678UL, 1779396793UL, 646997837UL, 1459728476UL, 2644865980UL, 3238673748UL, 3956278544UL, 919592580UL, 
2153558858UL, 2029633394UL, 115778559UL, 4016560170UL, 484838096UL, 3652199054UL, 1971790561UL, 737357475UL, 637470291UL, 278970544UL, 3574824693UL, 295866521UL, 3989745853UL, 2542341803UL, 1588716357UL, 1502596918UL, 4124554133UL, 3016849744UL, 1768033045UL, 1531734630UL, 101448323UL, 3233017580UL, 4157527581UL, 3187853500UL, 186000900UL, 803444571UL, 2820254958UL, 1980528062UL, 2384668855UL, 2222812920UL, 633608665UL, 2028480056UL, 
3166710281UL, 545095949UL, 3810471203UL, 1017064446UL, 1595207573UL, 693962828UL, 899068662UL, 3294064431UL, 167972517UL, 3625210015UL, 1486040398UL, 3951305793UL, 1778354660UL, 3041730987UL, 1598611350UL, 2859363132UL, 1885149424UL, 3390812967UL, 2432904511UL, 113261909UL, 664880478UL, 3953443155UL, 2965828929UL, 2035392295UL, 3500116619UL, 558081801UL, 329153573UL, 1607201428UL, 425148945UL, 1262591961UL, 3716247699UL, 78028761UL, 
2148245850UL, 2787488981UL, 1077262192UL, 4206362947UL, 647235899UL, 3584435116UL, 3013084787UL, 287099941UL, 2536781098UL, 1467385694UL, 2658945475UL, 4251530898UL, 2403086478UL, 3075072413UL, 3489351040UL, 4105390090UL, 343200643UL, 3189888821UL, 2540485172UL, 3521512280UL, 259435633UL, 2846377387UL, 497258846UL, 2442427327UL, 1367093111UL, 2957688879UL, 2180784344UL, 3434619542UL, 1593967423UL, 411877686UL, 3107480718UL, 2208729807UL, 
596436263UL, 1048686529UL, 584605030UL, 519242965UL, 602979109UL, 1619614UL, 2072745381UL, 3902518209UL, 1584463910UL, 1849038201UL, 728022295UL, 846033949UL, 1932969318UL, 428214945UL, 1246345586UL, 4213351865UL, 1066373275UL, 2770345237UL, 4277869380UL, 3886828599UL, 2264054549UL, 1877859690UL, 2953581033UL, 2649164828UL, 3369378320UL, 3648350039UL, 2537763389UL, 2380353977UL, 3558859222UL, 2669673235UL, 831851874UL, 522748140UL, 
1214052447UL, 1088456706UL, 231954609UL, 3118005852UL, 1381269315UL, 1766983646UL, 856371341UL, 2001356578UL, 639336670UL, 667275675UL, 1782816591UL, 4024065226UL, 1093546838UL, 4263608561UL, 2057337961UL, 1149716600UL, 2441102396UL, 296426333UL, 384641750UL, 340523210UL, 2391309970UL, 1016016207UL, 3595686646UL, 24777793UL, 3094832341UL, 362098678UL, 1779396793UL, 646997837UL, 1459728476UL, 1169681568UL, 3238673748UL, 3956278544UL, 
919592580UL, 2153558858UL, 388335108UL, 115778559UL, 4016560170UL, 484838096UL, 3652199054UL, 1764858181UL, 737357475UL, 637470291UL, 278970544UL, 3574824693UL, 3671458900UL, 3989745853UL, 2542341803UL, 1588716357UL, 1502596918UL, 2102871406UL, 3016849744UL, 1768033045UL, 1531734630UL, 101448323UL, 3964942332UL, 4157527581UL, 3187853500UL, 186000900UL, 803444571UL, 3425652083UL, 1980528062UL, 2384668855UL, 2222812920UL, 633608665UL, 
3035373876UL, 3166710281UL, 545095949UL, 3810471203UL, 1017064446UL, 669282349UL, 693962828UL, 899068662UL, 3294064431UL, 167972517UL, 2007256988UL, 1486040398UL, 3951305793UL, 1778354660UL, 3041730987UL, 2827768941UL, 2859363132UL, 1885149424UL, 3390812967UL, 2432904511UL, 3700915653UL, 664880478UL, 3953443155UL, 2965828929UL, 2035392295UL, 1461208330UL, 558081801UL, 329153573UL, 1607201428UL, 425148945UL, 1700881129UL, 3716247699UL, 
78028761UL, 2148245850UL, 2787488981UL, 2706775080UL, 4206362947UL, 647235899UL, 3584435116UL, 3013084787UL, 2958545221UL, 2536781098UL, 1467385694UL, 2658945475UL, 4251530898UL, 2241012567UL, 3075072413UL, 3489351040UL, 4105390090UL, 343200643UL, 490164649UL, 2540485172UL, 3521512280UL, 259435633UL, 2846377387UL, 4073611831UL, 2442427327UL, 1367093111UL, 2957688879UL, 2180784344UL, 1835510773UL, 1593967423UL, 411877686UL, 3107480718UL, 
2208729807UL, 3306732468UL, 1048686529UL, 584605030UL, 519242965UL, 602979109UL, 2978864605UL, 2072745381UL, 3902518209UL, 1584463910UL, 1849038201UL, 3284115169UL, 846033949UL, 1932969318UL, 428214945UL, 1246345586UL, 194166002UL, 1066373275UL, 2770345237UL, 4277869380UL, 3886828599UL, 1874087886UL, 1877859690UL, 2953581033UL, 2649164828UL, 3369378320UL, 4145454028UL, 2537763389UL, 2380353977UL, 3558859222UL, 2669673235UL, 739345884UL, 
522748140UL, 1214052447UL, 1088456706UL, 231954609UL, 3605603781UL, 1381269315UL, 1766983646UL, 856371341UL, 2001356578UL, 2049940324UL, 667275675UL, 1782816591UL, 4024065226UL, 1093546838UL, 152524382UL, 2057337961UL, 1149716600UL, 2441102396UL, 296426333UL, 3195130788UL, 340523210UL, 2391309970UL, 1016016207UL, 3595686646UL, 180492441UL, 3094832341UL, 362098678UL, 1779396793UL, 646997837UL, 2458167607UL, 1169681568UL, 3238673748UL, 
3956278544UL, 919592580UL, 3421005218UL, 388335108UL, 115778559UL, 4016560170UL, 484838096UL, 2649676374UL, 1764858181UL, 737357475UL, 637470291UL, 278970544UL, 2236401278UL, 3671458900UL, 3989745853UL, 2542341803UL, 1588716357UL, 1241570134UL, 2102871406UL, 3016849744UL, 1768033045UL, 1531734630UL, 1765654724UL, 3964942332UL, 4157527581UL, 3187853500UL, 186000900UL, 2189716659UL, 3425652083UL, 1980528062UL, 2384668855UL, 2222812920UL, 
3955466207UL, 2426547616UL, 3846752458UL, 3015538636UL, 2342593365UL, 3613176865UL, 3484860981UL, 4278370194UL, 1979143878UL, 1159739458UL, 3714038404UL, 396530346UL, 3276617756UL, 3293940597UL, 4050183149UL, 1418571985UL, 402563753UL, 2702853013UL, 2289900621UL, 2267058511UL, 3482161995UL, 3375026019UL, 1988640267UL, 3674438074UL, 4124612310UL, 1057883705UL, 434730475UL, 3210959778UL, 4102029739UL, 2140938750UL, 3176753074UL, 2356971512UL, 
3969685288UL, 1556275580UL, 2648433428UL, 3959375381UL, 478841344UL, 1496991528UL, 3309714981UL, 569990368UL, 3660587501UL, 2550379574UL, 1177519842UL, 2652707373UL, 543943404UL, 1912551128UL, 2278132032UL, 1484596780UL, 3570913985UL, 2982401320UL, 1413776035UL, 3177275459UL, 3036211597UL, 1091740466UL, 3448424311UL, 1445187645UL, 3205024875UL, 3135795254UL, 823738729UL, 3742134467UL, 4066657438UL, 1226311678UL, 2403605393UL, 537573634UL, 
3457409768UL, 1940233423UL, 1761431281UL, 1129427309UL, 2443661283UL, 3200814257UL, 4094866249UL, 2666869754UL, 604785127UL, 2213464116UL, 3002782918UL, 468024929UL, 2490681314UL, 3666681384UL, 1583346053UL, 3049668798UL, 3592153237UL, 2573082448UL, 3082970021UL, 1461796708UL, 832526980UL, 3728763274UL, 355291229UL, 4029588456UL, 832358279UL, 2125298737UL, 3681181038UL, 3245535160UL, 1333342738UL, 1868897492UL, 446790068UL, 1278093154UL, 
2090118615UL, 4158925515UL, 4062165914UL, 822726809UL, 1154960183UL, 286518382UL, 1170424276UL, 2554691236UL, 3674133415UL, 2765714969UL, 2330865375UL, 1908307334UL, 3537287082UL, 410252600UL, 3977128218UL, 424210327UL, 2919071615UL, 2715518134UL, 64568844UL, 480972649UL, 2488797168UL, 1302817038UL, 2213995265UL, 4229997295UL, 2200797852UL, 109368057UL, 3033807022UL, 1907400078UL, 645977948UL, 1410909090UL, 3700787906UL, 3375062371UL, 
629087832UL, 1344281719UL, 4249981139UL, 3457543297UL, 1218556849UL, 864222854UL, 1458445945UL, 914545469UL, 3451164212UL, 1088025757UL, 1129933985UL, 953788883UL, 2406172924UL, 170364546UL, 3505490646UL, 1027553899UL, 2864067776UL, 436854871UL, 1342782209UL, 761167471UL, 2660173631UL, 4159507498UL, 4172028400UL, 2442254644UL, 2110123720UL, 2315991253UL, 873066601UL, 1725470559UL, 3831299052UL, 678672031UL, 1585431329UL, 3495750550UL, 
},
{
1998393432UL, 2665389278UL, 3989307699UL, 3267631636UL, 3861682977UL, 3243522970UL, 1243992413UL, 2200497260UL, 3821883021UL, 4187123083UL, 3451270040UL, 3044132745UL, 2101287249UL, 2340839784UL, 227040990UL, 1724350416UL, 3228881240UL, 3123386528UL, 4279362126UL, 3098224464UL, 2635534069UL, 3622906431UL, 206207480UL, 1894245533UL, 2152374527UL, 1011223653UL, 7271757UL, 2972858087UL, 207942127UL, 3355362797UL, 2593296740UL, 174093751UL, 
3713822176UL, 4212355586UL, 3335605224UL, 1171716408UL, 2867257989UL, 1522213957UL, 2016192462UL, 4229688395UL, 2174928148UL, 1468226225UL, 3938290338UL, 493240317UL, 3229423344UL, 2585475729UL, 3112454413UL, 1881171707UL, 2555908056UL, 1997546352UL, 380428329UL, 3341885423UL, 3307510279UL, 3519476676UL, 3613100811UL, 2555826262UL, 109341943UL, 2382715395UL, 3883409616UL, 1593551879UL, 2163678014UL, 3379783137UL, 2810374300UL, 1516064864UL, 
561144874UL, 316017838UL, 1899237567UL, 70857401UL, 3435185465UL, 4234661323UL, 2580352177UL, 32879620UL, 4171670150UL, 1986234067UL, 3589478191UL, 2073132526UL, 2603712175UL, 377997975UL, 2474419397UL, 3110698341UL, 812664089UL, 1778922726UL, 1686111212UL, 972784138UL, 3936486236UL, 2711468739UL, 423435866UL, 1661961159UL, 802312780UL, 1868728136UL, 1760295704UL, 3357409828UL, 215039860UL, 683184627UL, 4019111064UL, 3609261689UL, 
2167554309UL, 1831085281UL, 3389357802UL, 4193421575UL, 628277197UL, 2900207619UL, 993609502UL, 3429627083UL, 2636466084UL, 3652352199UL, 1780133580UL, 1670387713UL, 4086070210UL, 4004540729UL, 783029246UL, 2165667566UL, 1739001057UL, 377639972UL, 1102689625UL, 1945278055UL, 3941185940UL, 3685368326UL, 1881761572UL, 2201338934UL, 801752UL, 2729497735UL, 492844690UL, 2998826141UL, 3844964457UL, 3679088359UL, 2196391660UL, 4222269404UL, 
357321611UL, 3727170055UL, 1819614072UL, 2348798457UL, 4294366646UL, 1952884323UL, 3574345216UL, 2040734807UL, 232392443UL, 4183498179UL, 2614866055UL, 112120292UL, 3624018350UL, 3340709877UL, 3097507723UL, 1268833488UL, 3570501956UL, 3338260086UL, 293812421UL, 3683058169UL, 1147960351UL, 283731890UL, 2171233479UL, 1830154455UL, 4036602681UL, 1996981699UL, 132803834UL, 40256165UL, 2158110401UL, 3575159090UL, 3196553513UL, 3559872992UL, 
3402884675UL, 1998393432UL, 2665389278UL, 3989307699UL, 3267631636UL, 3617519767UL, 3243522970UL, 1243992413UL, 2200497260UL, 3821883021UL, 3715729085UL, 3451270040UL, 3044132745UL, 2101287249UL, 2340839784UL, 3173635549UL, 1724350416UL, 3228881240UL, 3123386528UL, 4279362126UL, 2287520039UL, 2635534069UL, 3622906431UL, 206207480UL, 1894245533UL, 96723416UL, 1011223653UL, 7271757UL, 2972858087UL, 207942127UL, 1668335352UL, 2593296740UL, 
174093751UL, 3713822176UL, 4212355586UL, 49226793UL, 1171716408UL, 2867257989UL, 1522213957UL, 2016192462UL, 118712412UL, 2174928148UL, 1468226225UL, 3938290338UL, 493240317UL, 3788174304UL, 2585475729UL, 3112454413UL, 1881171707UL, 2555908056UL, 3351139844UL, 380428329UL, 3341885423UL, 3307510279UL, 3519476676UL, 1368994724UL, 2555826262UL, 109341943UL, 2382715395UL, 3883409616UL, 1561509458UL, 2163678014UL, 3379783137UL, 2810374300UL, 
1516064864UL, 2313252274UL, 316017838UL, 1899237567UL, 70857401UL, 3435185465UL, 2585770746UL, 2580352177UL, 32879620UL, 4171670150UL, 1986234067UL, 3317983509UL, 2073132526UL, 2603712175UL, 377997975UL, 2474419397UL, 908728599UL, 812664089UL, 1778922726UL, 1686111212UL, 972784138UL, 1992540005UL, 2711468739UL, 423435866UL, 1661961159UL, 802312780UL, 907108769UL, 1760295704UL, 3357409828UL, 215039860UL, 683184627UL, 2806826652UL, 
3609261689UL, 2167554309UL, 1831085281UL, 3389357802UL, 2755692689UL, 628277197UL, 2900207619UL, 993609502UL, 3429627083UL, 3605915742UL, 3652352199UL, 1780133580UL, 1670387713UL, 4086070210UL, 3717326627UL, 783029246UL, 2165667566UL, 1739001057UL, 377639972UL, 2355216626UL, 1945278055UL, 3941185940UL, 3685368326UL, 1881761572UL, 4024097818UL, 801752UL, 2729497735UL, 492844690UL, 2998826141UL, 2719601647UL, 3679088359UL, 2196391660UL, 
4222269404UL, 357321611UL, 1319821972UL, 1819614072UL, 2348798457UL, 4294366646UL, 1952884323UL, 3573866689UL, 2040734807UL, 232392443UL, 4183498179UL, 2614866055UL, 440744432UL, 3624018350UL, 3340709877UL, 3097507723UL, 1268833488UL, 224895395UL, 3338260086UL, 293812421UL, 3683058169UL, 1147960351UL, 3433425235UL, 2171233479UL, 1830154455UL, 4036602681UL, 1996981699UL, 2875889721UL, 40256165UL, 2158110401UL, 3575159090UL, 3196553513UL, 
1094082574UL, 3402884675UL, 1998393432UL, 2665389278UL, 3989307699UL, 4068940467UL, 3617519767UL, 3243522970UL, 1243992413UL, 2200497260UL, 441678457UL, 3715729085UL, 3451270040UL, 3044132745UL, 2101287249UL, 2181502237UL, 3173635549UL, 1724350416UL, 3228881240UL, 3123386528UL, 1968352124UL, 2287520039UL, 2635534069UL, 3622906431UL, 206207480UL, 2065093599UL, 96723416UL, 1011223653UL, 7271757UL, 2972858087UL, 1094044749UL, 1668335352UL, 
2593296740UL, 174093751UL, 3713822176UL, 2887397643UL, 49226793UL, 1171716408UL, 2867257989UL, 1522213957UL, 984348433UL, 118712412UL, 2174928148UL, 1468226225UL, 3938290338UL, 2279430036UL, 3788174304UL, 2585475729UL, 3112454413UL, 1881171707UL, 4247636500UL, 3351139844UL, 380428329UL, 3341885423UL, 3307510279UL, 2887754196UL, 1368994724UL, 2555826262UL, 109341943UL, 2382715395UL, 2836761616UL, 1561509458UL, 2163678014UL, 3379783137UL, 
2810374300UL, 1635278016UL, 2313252274UL, 316017838UL, 1899237567UL, 70857401UL, 3481535811UL, 2585770746UL, 2580352177UL, 32879620UL, 4171670150UL, 2248003250UL, 3317983509UL, 2073132526UL, 2603712175UL, 377997975UL, 3286162818UL, 908728599UL, 812664089UL, 1778922726UL, 1686111212UL, 4024815755UL, 1992540005UL, 2711468739UL, 423435866UL, 1661961159UL, 2257259057UL, 907108769UL, 1760295704UL, 3357409828UL, 215039860UL, 3917391198UL, 
2806826652UL, 3609261689UL, 2167554309UL, 1831085281UL, 4238043113UL, 2755692689UL, 628277197UL, 2900207619UL, 993609502UL, 2036092353UL, 3605915742UL, 3652352199UL, 1780133580UL, 1670387713UL, 118446953UL, 3717326627UL, 783029246UL, 2165667566UL, 1739001057UL, 203160626UL, 2355216626UL, 1945278055UL, 3941185940UL, 3685368326UL, 546361979UL, 4024097818UL, 801752UL, 2729497735UL, 492844690UL, 1023017124UL, 2719601647UL, 3679088359UL, 
2196391660UL, 4222269404UL, 621859651UL, 1319821972UL, 1819614072UL, 2348798457UL, 4294366646UL, 1114888560UL, 3573866689UL, 2040734807UL, 232392443UL, 4183498179UL, 3959504609UL, 440744432UL, 3624018350UL, 3340709877UL, 3097507723UL, 3613295037UL, 224895395UL, 3338260086UL, 293812421UL, 3683058169UL, 1655305863UL, 3433425235UL, 2171233479UL, 1830154455UL, 4036602681UL, 3731384097UL, 2875889721UL, 40256165UL, 2158110401UL, 3575159090UL, 
1847744924UL, 1094082574UL, 3402884675UL, 1998393432UL, 2665389278UL, 3781866777UL, 4068940467UL, 3617519767UL, 3243522970UL, 1243992413UL, 2723708256UL, 441678457UL, 3715729085UL, 3451270040UL, 3044132745UL, 4013832842UL, 2181502237UL, 3173635549UL, 1724350416UL, 3228881240UL, 2092292494UL, 1968352124UL, 2287520039UL, 2635534069UL, 3622906431UL, 3186333458UL, 2065093599UL, 96723416UL, 1011223653UL, 7271757UL, 649658033UL, 1094044749UL, 
1668335352UL, 2593296740UL, 174093751UL, 4159420309UL, 2887397643UL, 49226793UL, 1171716408UL, 2867257989UL, 2590077953UL, 984348433UL, 118712412UL, 2174928148UL, 1468226225UL, 1065322711UL, 2279430036UL, 3788174304UL, 2585475729UL, 3112454413UL, 3932517386UL, 4247636500UL, 3351139844UL, 380428329UL, 3341885423UL, 1285273904UL, 2887754196UL, 1368994724UL, 2555826262UL, 109341943UL, 2318470582UL, 2836761616UL, 1561509458UL, 2163678014UL, 
3379783137UL, 674658583UL, 1635278016UL, 2313252274UL, 316017838UL, 1899237567UL, 2192372173UL, 3481535811UL, 2585770746UL, 2580352177UL, 32879620UL, 300323274UL, 2248003250UL, 3317983509UL, 2073132526UL, 2603712175UL, 3086543917UL, 3286162818UL, 908728599UL, 812664089UL, 1778922726UL, 2263290659UL, 4024815755UL, 1992540005UL, 2711468739UL, 423435866UL, 819027349UL, 2257259057UL, 907108769UL, 1760295704UL, 3357409828UL, 1142221093UL, 
3917391198UL, 2806826652UL, 3609261689UL, 2167554309UL, 4108155875UL, 4238043113UL, 2755692689UL, 628277197UL, 2900207619UL, 3041719497UL, 2036092353UL, 3605915742UL, 3652352199UL, 1780133580UL, 2397410862UL, 118446953UL, 3717326627UL, 783029246UL, 2165667566UL, 2721690354UL, 203160626UL, 2355216626UL, 1945278055UL, 3941185940UL, 2768842108UL, 546361979UL, 4024097818UL, 801752UL, 2729497735UL, 4045063232UL, 1023017124UL, 2719601647UL, 
3679088359UL, 2196391660UL, 2666107451UL, 621859651UL, 1319821972UL, 1819614072UL, 2348798457UL, 3555102623UL, 1114888560UL, 3573866689UL, 2040734807UL, 232392443UL, 3359040541UL, 3959504609UL, 440744432UL, 3624018350UL, 3340709877UL, 1477919696UL, 3613295037UL, 224895395UL, 3338260086UL, 293812421UL, 4210187101UL, 1655305863UL, 3433425235UL, 2171233479UL, 1830154455UL, 4150241150UL, 3731384097UL, 2875889721UL, 40256165UL, 2158110401UL, 
3350246687UL, 455561037UL, 2250400255UL, 3192153445UL, 3258870230UL, 1500391873UL, 4142878334UL, 1155955691UL, 1483275844UL, 4189436981UL, 323745948UL, 1976017426UL, 2804626790UL, 2717553615UL, 2315409034UL, 954508235UL, 3845175920UL, 3999878682UL, 1247696432UL, 1743319509UL, 2998248398UL, 3694350012UL, 4072006361UL, 191306987UL, 2816321878UL, 1324077734UL, 1083060006UL, 3406855480UL, 1619622379UL, 2160350UL, 3302238190UL, 3368021261UL, 
3685228564UL, 3863934685UL, 771728612UL, 854205233UL, 2304696695UL, 421449207UL, 1265752117UL, 3852292419UL, 305345788UL, 1540622105UL, 1904883477UL, 833469256UL, 134406680UL, 3012455058UL, 4035477953UL, 2925192459UL, 1559200592UL, 3851612860UL, 718484562UL, 1377960276UL, 1586892849UL, 1361298269UL, 3417917896UL, 1281324499UL, 1012538763UL, 1350578667UL, 3946475598UL, 2982283954UL, 3548792804UL, 284542749UL, 1194648577UL, 3087899716UL, 
3966595444UL, 2088330116UL, 3641652062UL, 327128507UL, 593906557UL, 1092448919UL, 2459189516UL, 4053392241UL, 3356198248UL, 2352376508UL, 470648997UL, 1017041256UL, 3234172340UL, 3928191489UL, 3266226858UL, 4219289150UL, 1229098319UL, 4275351308UL, 2720777751UL, 3566728718UL, 638322822UL, 2369792461UL, 2869492261UL, 3120083828UL, 1890399556UL, 3309991008UL, 3785452464UL, 4128660314UL, 3726791982UL, 167177896UL, 461294981UL, 3988638998UL, 
2937794823UL, 3981029822UL, 1111681402UL, 2015965721UL, 7261806UL, 2669786265UL, 1083582734UL, 3270228881UL, 3892235938UL, 2695872715UL, 4246051290UL, 3214293333UL, 343604199UL, 3215604888UL, 661024127UL, 2931754053UL, 3787840039UL, 2053363765UL, 363432336UL, 112334132UL, 2871797223UL, 138911320UL, 3981126938UL, 2027332192UL, 1804730644UL, 590150270UL, 641538574UL, 6802174UL, 3551446076UL, 3908480472UL, 1004531022UL, 2097228524UL, 
1919074232UL, 154482247UL, 121437972UL, 1215661323UL, 1178068273UL, 1097220699UL, 2823681422UL, 262636065UL, 2943371149UL, 1768780720UL, 3866040605UL, 1855991583UL, 3988248086UL, 629223947UL, 3380612330UL, 3552916762UL, 197596340UL, 573801686UL, 2049230598UL, 2910471867UL, 2686314264UL, 1726228846UL, 3516983332UL, 726840185UL, 1241204222UL, 2237574317UL, 70568042UL, 1932610099UL, 2221862221UL, 1510378092UL, 4050391637UL, 4077539568UL, 
},
{
3872117793UL, 803220151UL, 70843412UL, 1661103032UL, 1976811457UL, 2186373604UL, 564259972UL, 1475436923UL, 2260980893UL, 4245534505UL, 1075107552UL, 3692990573UL, 370098873UL, 4045905424UL, 2420395420UL, 2332395402UL, 207483321UL, 622317750UL, 3004242500UL, 833623111UL, 3151161301UL, 1629139881UL, 352228793UL, 2439953368UL, 3183333619UL, 2703537080UL, 3218957129UL, 3164695888UL, 1741641842UL, 963394141UL, 4241612717UL, 1034476784UL, 
2035880432UL, 3977821313UL, 1543311495UL, 3010014356UL, 1638490901UL, 2364265378UL, 3420329129UL, 333361555UL, 1133565821UL, 1450937015UL, 616059115UL, 3216393887UL, 3041978455UL, 3990855695UL, 1238628750UL, 512746184UL, 3256670217UL, 1616316512UL, 2791405051UL, 93474487UL, 2865892488UL, 1901471398UL, 2930857966UL, 2178431077UL, 2325598341UL, 3189256113UL, 1302432091UL, 808592927UL, 2945846737UL, 3487931071UL, 2018175258UL, 752981057UL, 
1097082589UL, 1307115286UL, 175147508UL, 3611190164UL, 850238914UL, 3318706185UL, 199743319UL, 328621708UL, 3183670050UL, 3609998315UL, 4075306371UL, 3554549067UL, 2119566187UL, 1498503842UL, 1261870696UL, 2216745780UL, 950288337UL, 1117344941UL, 2150569143UL, 2899286760UL, 1594966374UL, 888858617UL, 35840654UL, 2829539211UL, 2511395669UL, 3607190544UL, 3278412778UL, 2249895907UL, 1320858068UL, 3576889788UL, 266766189UL, 1522426851UL, 
1903494122UL, 1928370573UL, 2628132591UL, 3322025904UL, 220280169UL, 433606853UL, 1428961479UL, 986074592UL, 2128892987UL, 467697583UL, 1616913929UL, 325674890UL, 444442578UL, 649166208UL, 1689709565UL, 1493452467UL, 2222122038UL, 121114616UL, 2134348225UL, 3512035688UL, 1283058921UL, 4230441398UL, 3701238559UL, 337534132UL, 1418548715UL, 1190006478UL, 500654385UL, 1766924757UL, 1944680746UL, 940574010UL, 922744002UL, 186142284UL, 
3131162902UL, 1693891092UL, 3031823448UL, 2143051534UL, 1429025284UL, 1487843160UL, 3606456133UL, 2079235652UL, 2447285474UL, 2669283767UL, 3232117829UL, 2490054343UL, 3225501736UL, 2911340385UL, 382319031UL, 1516937595UL, 622543191UL, 1388990570UL, 1749179860UL, 1924483707UL, 2593474505UL, 472539197UL, 122872799UL, 2586347240UL, 880588515UL, 4046335279UL, 1712182607UL, 4270737941UL, 1336703451UL, 3390078162UL, 382216945UL, 3733326081UL, 
460422073UL, 3872117793UL, 803220151UL, 70843412UL, 1661103032UL, 250339760UL, 2186373604UL, 564259972UL, 1475436923UL, 2260980893UL, 657986735UL, 1075107552UL, 3692990573UL, 370098873UL, 4045905424UL, 3201950123UL, 2332395402UL, 207483321UL, 622317750UL, 3004242500UL, 3732213278UL, 3151161301UL, 1629139881UL, 352228793UL, 2439953368UL, 3572618926UL, 2703537080UL, 3218957129UL, 3164695888UL, 1741641842UL, 685933373UL, 4241612717UL, 
1034476784UL, 2035880432UL, 3977821313UL, 3855995181UL, 3010014356UL, 1638490901UL, 2364265378UL, 3420329129UL, 2355603679UL, 1133565821UL, 1450937015UL, 616059115UL, 3216393887UL, 1733804102UL, 3990855695UL, 1238628750UL, 512746184UL, 3256670217UL, 2651059231UL, 2791405051UL, 93474487UL, 2865892488UL, 1901471398UL, 2113461797UL, 2178431077UL, 2325598341UL, 3189256113UL, 1302432091UL, 2986990416UL, 2945846737UL, 3487931071UL, 2018175258UL, 
752981057UL, 2428033310UL, 1307115286UL, 175147508UL, 3611190164UL, 850238914UL, 1033628405UL, 199743319UL, 328621708UL, 3183670050UL, 3609998315UL, 4024297327UL, 3554549067UL, 2119566187UL, 1498503842UL, 1261870696UL, 290361143UL, 950288337UL, 1117344941UL, 2150569143UL, 2899286760UL, 168826051UL, 888858617UL, 35840654UL, 2829539211UL, 2511395669UL, 2890882060UL, 3278412778UL, 2249895907UL, 1320858068UL, 3576889788UL, 1794920145UL, 
1522426851UL, 1903494122UL, 1928370573UL, 2628132591UL, 1251697758UL, 220280169UL, 433606853UL, 1428961479UL, 986074592UL, 2707115661UL, 467697583UL, 1616913929UL, 325674890UL, 444442578UL, 122781510UL, 1689709565UL, 1493452467UL, 2222122038UL, 121114616UL, 3425723636UL, 3512035688UL, 1283058921UL, 4230441398UL, 3701238559UL, 1646155473UL, 1418548715UL, 1190006478UL, 500654385UL, 1766924757UL, 3920475367UL, 940574010UL, 922744002UL, 
186142284UL, 3131162902UL, 54639113UL, 3031823448UL, 2143051534UL, 1429025284UL, 1487843160UL, 4152687885UL, 2079235652UL, 2447285474UL, 2669283767UL, 3232117829UL, 1601035152UL, 3225501736UL, 2911340385UL, 382319031UL, 1516937595UL, 3508441679UL, 1388990570UL, 1749179860UL, 1924483707UL, 2593474505UL, 2835403456UL, 122872799UL, 2586347240UL, 880588515UL, 4046335279UL, 2958058367UL, 4270737941UL, 1336703451UL, 3390078162UL, 382216945UL, 
450517882UL, 460422073UL, 3872117793UL, 803220151UL, 70843412UL, 2066343874UL, 250339760UL, 2186373604UL, 564259972UL, 1475436923UL, 1683787449UL, 657986735UL, 1075107552UL, 3692990573UL, 370098873UL, 2615082840UL, 3201950123UL, 2332395402UL, 207483321UL, 622317750UL, 2655424371UL, 3732213278UL, 3151161301UL, 1629139881UL, 352228793UL, 3236724760UL, 3572618926UL, 2703537080UL, 3218957129UL, 3164695888UL, 9775065UL, 685933373UL, 
4241612717UL, 1034476784UL, 2035880432UL, 1621920075UL, 3855995181UL, 3010014356UL, 1638490901UL, 2364265378UL, 1509475888UL, 2355603679UL, 1133565821UL, 1450937015UL, 616059115UL, 3666188236UL, 1733804102UL, 3990855695UL, 1238628750UL, 512746184UL, 3900473826UL, 2651059231UL, 2791405051UL, 93474487UL, 2865892488UL, 222759186UL, 2113461797UL, 2178431077UL, 2325598341UL, 3189256113UL, 2505499508UL, 2986990416UL, 2945846737UL, 3487931071UL, 
2018175258UL, 2766733928UL, 2428033310UL, 1307115286UL, 175147508UL, 3611190164UL, 1909211603UL, 1033628405UL, 199743319UL, 328621708UL, 3183670050UL, 1680331218UL, 4024297327UL, 3554549067UL, 2119566187UL, 1498503842UL, 3516256046UL, 290361143UL, 950288337UL, 1117344941UL, 2150569143UL, 3182619063UL, 168826051UL, 888858617UL, 35840654UL, 2829539211UL, 645798943UL, 2890882060UL, 3278412778UL, 2249895907UL, 1320858068UL, 1436708568UL, 
1794920145UL, 1522426851UL, 1903494122UL, 1928370573UL, 3693049252UL, 1251697758UL, 220280169UL, 433606853UL, 1428961479UL, 3724415861UL, 2707115661UL, 467697583UL, 1616913929UL, 325674890UL, 1448052253UL, 122781510UL, 1689709565UL, 1493452467UL, 2222122038UL, 2177448198UL, 3425723636UL, 3512035688UL, 1283058921UL, 4230441398UL, 3050940272UL, 1646155473UL, 1418548715UL, 1190006478UL, 500654385UL, 1106232UL, 3920475367UL, 940574010UL, 
922744002UL, 186142284UL, 4144806511UL, 54639113UL, 3031823448UL, 2143051534UL, 1429025284UL, 2067453848UL, 4152687885UL, 2079235652UL, 2447285474UL, 2669283767UL, 428527087UL, 1601035152UL, 3225501736UL, 2911340385UL, 382319031UL, 2565464472UL, 3508441679UL, 1388990570UL, 1749179860UL, 1924483707UL, 1737735237UL, 2835403456UL, 122872799UL, 2586347240UL, 880588515UL, 597822462UL, 2958058367UL, 4270737941UL, 1336703451UL, 3390078162UL, 
2532634475UL, 450517882UL, 460422073UL, 3872117793UL, 803220151UL, 801648827UL, 2066343874UL, 250339760UL, 2186373604UL, 564259972UL, 3417948976UL, 1683787449UL, 657986735UL, 1075107552UL, 3692990573UL, 2235306692UL, 2615082840UL, 3201950123UL, 2332395402UL, 207483321UL, 699310933UL, 2655424371UL, 3732213278UL, 3151161301UL, 1629139881UL, 1152704006UL, 3236724760UL, 3572618926UL, 2703537080UL, 3218957129UL, 2726926336UL, 9775065UL, 
685933373UL, 4241612717UL, 1034476784UL, 2398119652UL, 1621920075UL, 3855995181UL, 3010014356UL, 1638490901UL, 252854480UL, 1509475888UL, 2355603679UL, 1133565821UL, 1450937015UL, 2655911639UL, 3666188236UL, 1733804102UL, 3990855695UL, 1238628750UL, 1115900497UL, 3900473826UL, 2651059231UL, 2791405051UL, 93474487UL, 1862985957UL, 222759186UL, 2113461797UL, 2178431077UL, 2325598341UL, 4179075132UL, 2505499508UL, 2986990416UL, 2945846737UL, 
3487931071UL, 564667776UL, 2766733928UL, 2428033310UL, 1307115286UL, 175147508UL, 1759077815UL, 1909211603UL, 1033628405UL, 199743319UL, 328621708UL, 2552816198UL, 1680331218UL, 4024297327UL, 3554549067UL, 2119566187UL, 2267805778UL, 3516256046UL, 290361143UL, 950288337UL, 1117344941UL, 2897506172UL, 3182619063UL, 168826051UL, 888858617UL, 35840654UL, 2035476068UL, 645798943UL, 2890882060UL, 3278412778UL, 2249895907UL, 3278449102UL, 
1436708568UL, 1794920145UL, 1522426851UL, 1903494122UL, 1500763736UL, 3693049252UL, 1251697758UL, 220280169UL, 433606853UL, 3914497854UL, 3724415861UL, 2707115661UL, 467697583UL, 1616913929UL, 918435305UL, 1448052253UL, 122781510UL, 1689709565UL, 1493452467UL, 609575172UL, 2177448198UL, 3425723636UL, 3512035688UL, 1283058921UL, 3661181550UL, 3050940272UL, 1646155473UL, 1418548715UL, 1190006478UL, 1047301661UL, 1106232UL, 3920475367UL, 
940574010UL, 922744002UL, 2510633517UL, 4144806511UL, 54639113UL, 3031823448UL, 2143051534UL, 3242814908UL, 2067453848UL, 4152687885UL, 2079235652UL, 2447285474UL, 736638210UL, 428527087UL, 1601035152UL, 3225501736UL, 2911340385UL, 1849570436UL, 2565464472UL, 3508441679UL, 1388990570UL, 1749179860UL, 84517579UL, 1737735237UL, 2835403456UL, 122872799UL, 2586347240UL, 4002124614UL, 597822462UL, 2958058367UL, 4270737941UL, 1336703451UL, 
3078170472UL, 1186434751UL, 700631413UL, 1497890797UL, 1195347450UL, 2560167391UL, 1116697259UL, 1254138573UL, 747913260UL, 240954704UL, 3107512667UL, 360584144UL, 3422778960UL, 3516528389UL, 3301260366UL, 1254513537UL, 122269053UL, 1579582456UL, 873334104UL, 3918835024UL, 1731872444UL, 1974410416UL, 1811172641UL, 4172523062UL, 4092675777UL, 4124987343UL, 1936078756UL, 1757348689UL, 2694415512UL, 128641660UL, 1744777659UL, 3173116729UL, 
983733754UL, 1430789547UL, 701906842UL, 3367232568UL, 3266433501UL, 3572590347UL, 1453272962UL, 2106553114UL, 993786201UL, 2149441250UL, 1295181065UL, 2962229026UL, 3709052556UL, 3255608941UL, 3677730029UL, 483873127UL, 102227292UL, 2626265293UL, 2018984578UL, 2266388762UL, 1191709548UL, 2152725916UL, 583672623UL, 2230473473UL, 1995194269UL, 1740347812UL, 2558095372UL, 3070195183UL, 3023333227UL, 2497183195UL, 1908755188UL, 773027539UL, 
3646876518UL, 2272586839UL, 493318726UL, 2107067517UL, 2000805278UL, 2530829636UL, 3183628745UL, 677565332UL, 1497629423UL, 82094920UL, 2214054433UL, 2635367545UL, 470855467UL, 2184853389UL, 2942188934UL, 188335670UL, 3656661644UL, 1883526235UL, 3990873975UL, 1490784356UL, 4047548172UL, 3149642641UL, 3289988179UL, 2590918909UL, 2893039564UL, 2350687346UL, 4252624874UL, 15372456UL, 1614496594UL, 2364847678UL, 2604511825UL, 422365460UL, 
4195174772UL, 3266964836UL, 2008671995UL, 54038434UL, 781948549UL, 1276017666UL, 2756376612UL, 2436825273UL, 1711863836UL, 3541493950UL, 3821378841UL, 1007557618UL, 345375815UL, 2081905201UL, 2227278118UL, 1185927141UL, 1082173792UL, 3567361925UL, 1940465859UL, 541632942UL, 1830210248UL, 3757851982UL, 775883450UL, 1666577465UL, 1004944607UL, 878440834UL, 2146344131UL, 4195798476UL, 370164841UL, 3649112729UL, 37066142UL, 2311278904UL, 
1935745497UL, 2304799402UL, 4107299626UL, 1348526232UL, 2473609635UL, 3284032699UL, 2374292786UL, 1762329186UL, 857978496UL, 1039346432UL, 2621413355UL, 29961014UL, 3582263091UL, 4268542513UL, 3890612190UL, 3096173646UL, 2026544230UL, 3856142618UL, 2347115934UL, 319800326UL, 3255916105UL, 2430273059UL, 823505311UL, 874255188UL, 1401925393UL, 4203707857UL, 4259159566UL, 2606881118UL, 1978288664UL, 1447576038UL, 3860341401UL, 412510348UL, 
},
{
4052471963UL, 683640040UL, 3043876021UL, 3466644483UL, 4222418025UL, 3035140128UL, 1466027937UL, 18198088UL, 3410320851UL, 3040963721UL, 488404231UL, 3157371815UL, 769336092UL, 3240417718UL, 808582581UL, 2075839263UL, 835026995UL, 3123726486UL, 3284240985UL, 1898453053UL, 3606056482UL, 512836002UL, 2715428547UL, 4182302879UL, 1644882480UL, 3160187826UL, 390292489UL, 980889545UL, 2776206633UL, 2482799995UL, 617042280UL, 3501667414UL, 
689451808UL, 497018701UL, 238525753UL, 3890163301UL, 896679896UL, 1544533015UL, 3412477225UL, 3116575138UL, 4250402651UL, 3990990746UL, 819056741UL, 1459334146UL, 158377590UL, 3444755752UL, 8230450UL, 1378706455UL, 684191332UL, 3217423797UL, 2842520097UL, 1631477948UL, 2591254230UL, 959644473UL, 1020694107UL, 1748401915UL, 3452514983UL, 3892766171UL, 1227786994UL, 2086180800UL, 2394613217UL, 2091953150UL, 870094953UL, 2306851481UL, 
571550601UL, 488878212UL, 873197214UL, 2630100528UL, 2067476907UL, 2162307009UL, 2026119728UL, 115875280UL, 2905867426UL, 248774881UL, 3110900450UL, 2236032812UL, 1888510348UL, 708001855UL, 996960491UL, 3514196956UL, 1407967546UL, 1826568876UL, 3659618284UL, 2614104317UL, 2230066308UL, 1055135881UL, 2537437343UL, 1858044413UL, 2608594891UL, 2750681169UL, 3241939420UL, 3966440877UL, 2375002886UL, 2417753441UL, 1405878685UL, 1081133199UL, 
1496940727UL, 382467042UL, 2745477587UL, 1209424459UL, 811187075UL, 1385604734UL, 2623887355UL, 3443875720UL, 394141555UL, 4142998949UL, 4195414618UL, 1489846841UL, 2253433808UL, 1171450286UL, 84131191UL, 4387588UL, 2641405140UL, 3525405389UL, 3273000909UL, 423660319UL, 2366546732UL, 3698878607UL, 2161119729UL, 4263629085UL, 3029102089UL, 2692507376UL, 3266869596UL, 1658012061UL, 1960169440UL, 1002311379UL, 3724446882UL, 2004188516UL, 
999513506UL, 2200093802UL, 4141037460UL, 351865836UL, 412875013UL, 1535823315UL, 3880657632UL, 3109944987UL, 3207577548UL, 3462087941UL, 584875517UL, 2635241084UL, 3834145971UL, 1693380373UL, 3524443732UL, 934775214UL, 1960588847UL, 2226778032UL, 1044609478UL, 12199016UL, 1120582000UL, 226430296UL, 665553142UL, 2570993348UL, 1685535237UL, 3325420136UL, 3925248326UL, 2855346376UL, 1205558328UL, 808835317UL, 3295908896UL, 4170076136UL, 
2438272365UL, 4052471963UL, 683640040UL, 3043876021UL, 3466644483UL, 1385549869UL, 3035140128UL, 1466027937UL, 18198088UL, 3410320851UL, 2171386836UL, 488404231UL, 3157371815UL, 769336092UL, 3240417718UL, 2921774554UL, 2075839263UL, 835026995UL, 3123726486UL, 3284240985UL, 72352110UL, 3606056482UL, 512836002UL, 2715428547UL, 4182302879UL, 3869483469UL, 3160187826UL, 390292489UL, 980889545UL, 2776206633UL, 1385691983UL, 617042280UL, 
3501667414UL, 689451808UL, 497018701UL, 2600411809UL, 3890163301UL, 896679896UL, 1544533015UL, 3412477225UL, 356556378UL, 4250402651UL, 3990990746UL, 819056741UL, 1459334146UL, 199003993UL, 3444755752UL, 8230450UL, 1378706455UL, 684191332UL, 1750733272UL, 2842520097UL, 1631477948UL, 2591254230UL, 959644473UL, 2113375576UL, 1748401915UL, 3452514983UL, 3892766171UL, 1227786994UL, 275473920UL, 2394613217UL, 2091953150UL, 870094953UL, 
2306851481UL, 897057645UL, 488878212UL, 873197214UL, 2630100528UL, 2067476907UL, 944114068UL, 2026119728UL, 115875280UL, 2905867426UL, 248774881UL, 989201307UL, 2236032812UL, 1888510348UL, 708001855UL, 996960491UL, 2121706374UL, 1407967546UL, 1826568876UL, 3659618284UL, 2614104317UL, 2931815032UL, 1055135881UL, 2537437343UL, 1858044413UL, 2608594891UL, 1423973935UL, 3241939420UL, 3966440877UL, 2375002886UL, 2417753441UL, 2514473440UL, 
1081133199UL, 1496940727UL, 382467042UL, 2745477587UL, 81977310UL, 811187075UL, 1385604734UL, 2623887355UL, 3443875720UL, 2100629879UL, 4142998949UL, 4195414618UL, 1489846841UL, 2253433808UL, 337182869UL, 84131191UL, 4387588UL, 2641405140UL, 3525405389UL, 661876463UL, 423660319UL, 2366546732UL, 3698878607UL, 2161119729UL, 309510684UL, 3029102089UL, 2692507376UL, 3266869596UL, 1658012061UL, 11119541UL, 1002311379UL, 3724446882UL, 
2004188516UL, 999513506UL, 3486722046UL, 4141037460UL, 351865836UL, 412875013UL, 1535823315UL, 2818130700UL, 3109944987UL, 3207577548UL, 3462087941UL, 584875517UL, 322875622UL, 3834145971UL, 1693380373UL, 3524443732UL, 934775214UL, 3879414752UL, 2226778032UL, 1044609478UL, 12199016UL, 1120582000UL, 4207259464UL, 665553142UL, 2570993348UL, 1685535237UL, 3325420136UL, 553869152UL, 2855346376UL, 1205558328UL, 808835317UL, 3295908896UL, 
470585896UL, 2438272365UL, 4052471963UL, 683640040UL, 3043876021UL, 1588419572UL, 1385549869UL, 3035140128UL, 1466027937UL, 18198088UL, 363815288UL, 2171386836UL, 488404231UL, 3157371815UL, 769336092UL, 2464768302UL, 2921774554UL, 2075839263UL, 835026995UL, 3123726486UL, 4229246330UL, 72352110UL, 3606056482UL, 512836002UL, 2715428547UL, 319830805UL, 3869483469UL, 3160187826UL, 390292489UL, 980889545UL, 2966401462UL, 1385691983UL, 
617042280UL, 3501667414UL, 689451808UL, 4047377762UL, 2600411809UL, 3890163301UL, 896679896UL, 1544533015UL, 764316452UL, 356556378UL, 4250402651UL, 3990990746UL, 819056741UL, 965331966UL, 199003993UL, 3444755752UL, 8230450UL, 1378706455UL, 51902971UL, 1750733272UL, 2842520097UL, 1631477948UL, 2591254230UL, 426039404UL, 2113375576UL, 1748401915UL, 3452514983UL, 3892766171UL, 2833368447UL, 275473920UL, 2394613217UL, 2091953150UL, 
870094953UL, 3524323828UL, 897057645UL, 488878212UL, 873197214UL, 2630100528UL, 3939852929UL, 944114068UL, 2026119728UL, 115875280UL, 2905867426UL, 3192643919UL, 989201307UL, 2236032812UL, 1888510348UL, 708001855UL, 2166012172UL, 2121706374UL, 1407967546UL, 1826568876UL, 3659618284UL, 135277096UL, 2931815032UL, 1055135881UL, 2537437343UL, 1858044413UL, 2588429924UL, 1423973935UL, 3241939420UL, 3966440877UL, 2375002886UL, 2477142003UL, 
2514473440UL, 1081133199UL, 1496940727UL, 382467042UL, 1760129281UL, 81977310UL, 811187075UL, 1385604734UL, 2623887355UL, 4070531513UL, 2100629879UL, 4142998949UL, 4195414618UL, 1489846841UL, 2688068550UL, 337182869UL, 84131191UL, 4387588UL, 2641405140UL, 1837403234UL, 661876463UL, 423660319UL, 2366546732UL, 3698878607UL, 2916121190UL, 309510684UL, 3029102089UL, 2692507376UL, 3266869596UL, 303422295UL, 11119541UL, 1002311379UL, 
3724446882UL, 2004188516UL, 2652711421UL, 3486722046UL, 4141037460UL, 351865836UL, 412875013UL, 113149471UL, 2818130700UL, 3109944987UL, 3207577548UL, 3462087941UL, 1443140792UL, 322875622UL, 3834145971UL, 1693380373UL, 3524443732UL, 901891935UL, 3879414752UL, 2226778032UL, 1044609478UL, 12199016UL, 2213168758UL, 4207259464UL, 665553142UL, 2570993348UL, 1685535237UL, 1114492412UL, 553869152UL, 2855346376UL, 1205558328UL, 808835317UL, 
3266626294UL, 470585896UL, 2438272365UL, 4052471963UL, 683640040UL, 3581539398UL, 1588419572UL, 1385549869UL, 3035140128UL, 1466027937UL, 4075470388UL, 363815288UL, 2171386836UL, 488404231UL, 3157371815UL, 2759472233UL, 2464768302UL, 2921774554UL, 2075839263UL, 835026995UL, 1030654310UL, 4229246330UL, 72352110UL, 3606056482UL, 512836002UL, 961858496UL, 319830805UL, 3869483469UL, 3160187826UL, 390292489UL, 2366221117UL, 2966401462UL, 
1385691983UL, 617042280UL, 3501667414UL, 295865937UL, 4047377762UL, 2600411809UL, 3890163301UL, 896679896UL, 21714884UL, 764316452UL, 356556378UL, 4250402651UL, 3990990746UL, 1012967081UL, 965331966UL, 199003993UL, 3444755752UL, 8230450UL, 1255302023UL, 51902971UL, 1750733272UL, 2842520097UL, 1631477948UL, 2321320272UL, 426039404UL, 2113375576UL, 1748401915UL, 3452514983UL, 2847013518UL, 2833368447UL, 275473920UL, 2394613217UL, 
2091953150UL, 1250695522UL, 3524323828UL, 897057645UL, 488878212UL, 873197214UL, 1452317325UL, 3939852929UL, 944114068UL, 2026119728UL, 115875280UL, 4061820350UL, 3192643919UL, 989201307UL, 2236032812UL, 1888510348UL, 3986446165UL, 2166012172UL, 2121706374UL, 1407967546UL, 1826568876UL, 2910745432UL, 135277096UL, 2931815032UL, 1055135881UL, 2537437343UL, 2976455307UL, 2588429924UL, 1423973935UL, 3241939420UL, 3966440877UL, 2418897705UL, 
2477142003UL, 2514473440UL, 1081133199UL, 1496940727UL, 1321648771UL, 1760129281UL, 81977310UL, 811187075UL, 1385604734UL, 17644628UL, 4070531513UL, 2100629879UL, 4142998949UL, 4195414618UL, 2697310527UL, 2688068550UL, 337182869UL, 84131191UL, 4387588UL, 1724191700UL, 1837403234UL, 661876463UL, 423660319UL, 2366546732UL, 693430992UL, 2916121190UL, 309510684UL, 3029102089UL, 2692507376UL, 3917396098UL, 303422295UL, 11119541UL, 
1002311379UL, 3724446882UL, 841468294UL, 2652711421UL, 3486722046UL, 4141037460UL, 351865836UL, 1733384185UL, 113149471UL, 2818130700UL, 3109944987UL, 3207577548UL, 2326233100UL, 1443140792UL, 322875622UL, 3834145971UL, 1693380373UL, 1580706359UL, 901891935UL, 3879414752UL, 2226778032UL, 1044609478UL, 3805470822UL, 2213168758UL, 4207259464UL, 665553142UL, 2570993348UL, 3406548636UL, 1114492412UL, 553869152UL, 2855346376UL, 1205558328UL, 
4287831475UL, 1329654114UL, 2347235746UL, 2477803138UL, 2962371859UL, 3610024283UL, 4197266903UL, 1162294689UL, 1746713323UL, 2815058477UL, 2152552186UL, 4214791071UL, 2382522482UL, 3713914466UL, 3974765132UL, 348354997UL, 1670276150UL, 2173074887UL, 381736894UL, 3866219357UL, 1919366695UL, 3635118824UL, 2298653261UL, 3534332682UL, 1627699897UL, 4168636618UL, 3787938690UL, 2144231271UL, 2067679462UL, 217001062UL, 2308928337UL, 1620415125UL, 
3526559172UL, 749451561UL, 2456947371UL, 3543607786UL, 1893824735UL, 962598819UL, 2332807164UL, 1691114891UL, 2543992233UL, 2914780639UL, 1610287145UL, 1700599697UL, 3185174208UL, 552323208UL, 2367242224UL, 3797136972UL, 3415066418UL, 2468049249UL, 1677937401UL, 40445671UL, 2886682530UL, 2585715434UL, 194932329UL, 2994003812UL, 3099556382UL, 680852222UL, 135838738UL, 1371063256UL, 995454898UL, 3754526418UL, 803635682UL, 634588682UL, 
3869250783UL, 2442285521UL, 1455637058UL, 570621479UL, 2512681851UL, 1220136924UL, 750260121UL, 2909903038UL, 1582019728UL, 955115170UL, 1608265445UL, 2157390890UL, 2303678604UL, 1568394164UL, 831914289UL, 1971271392UL, 1294799854UL, 1489945167UL, 442427880UL, 1305083700UL, 1211218668UL, 2380073713UL, 2798736785UL, 2193524273UL, 3227386915UL, 1636588977UL, 3612937642UL, 435113647UL, 1591761830UL, 536210039UL, 2475747073UL, 4223795480UL, 
1786737271UL, 1444661534UL, 3249410301UL, 3333695212UL, 4169107188UL, 3280638635UL, 702659930UL, 1444127970UL, 225340755UL, 2255629368UL, 746584456UL, 3965677674UL, 2671132955UL, 2080717656UL, 2145343886UL, 3712441197UL, 368422910UL, 1297685674UL, 4076123901UL, 26214470UL, 2948764826UL, 40503299UL, 1198194334UL, 2100063637UL, 1966331612UL, 2189582064UL, 2064696934UL, 1797550642UL, 3469793941UL, 2868963812UL, 851437659UL, 240918534UL, 
365060070UL, 3530600064UL, 39695324UL, 1753898837UL, 1286976449UL, 3131971360UL, 2406485219UL, 3365373704UL, 3224113403UL, 1651742834UL, 587601940UL, 1574206085UL, 3739575036UL, 1413669616UL, 38172232UL, 293127854UL, 4126190109UL, 1891744061UL, 787878666UL, 456643669UL, 4228710325UL, 2025132037UL, 1492133135UL, 3122840937UL, 969442079UL, 3272420439UL, 3836126369UL, 1877655562UL, 2766212758UL, 3867984746UL, 3348077578UL, 1841216706UL, 
},
{
1676507466UL, 1017841240UL, 2992644565UL, 476936158UL, 2468072723UL, 3113105154UL, 1154120402UL, 460889625UL, 1942263502UL, 1761593999UL, 3020908939UL, 3078194866UL, 310971889UL, 1644896012UL, 3756044556UL, 3549937583UL, 3710822994UL, 3554313733UL, 2174654326UL, 4251063242UL, 2340485150UL, 950951909UL, 4288936895UL, 3744348848UL, 706644559UL, 1085927825UL, 1595992020UL, 3288724966UL, 1367247946UL, 2950094970UL, 3925419886UL, 2628739022UL, 
2528254629UL, 3582224789UL, 3907345559UL, 3373329273UL, 4255542251UL, 1185418446UL, 4018656113UL, 2854344020UL, 1381160022UL, 3642438773UL, 4284399225UL, 935780030UL, 4142412144UL, 1263328494UL, 1154237693UL, 2684443667UL, 3067549398UL, 4253090033UL, 1251034970UL, 1874233020UL, 3222830495UL, 3866931656UL, 286048055UL, 3146635362UL, 1436483376UL, 2821876495UL, 3927829532UL, 2648886905UL, 2142862852UL, 1368937545UL, 2647327844UL, 1072219385UL, 
2621337706UL, 3543274652UL, 911792564UL, 1204178178UL, 4127214323UL, 2821691380UL, 3101998294UL, 730811902UL, 1989156224UL, 2872353003UL, 278290276UL, 1390223786UL, 2657819643UL, 552729795UL, 1736270535UL, 2759207116UL, 1897013739UL, 3657020278UL, 1387364861UL, 1966588302UL, 1049203087UL, 486446521UL, 3675999281UL, 714737345UL, 686837530UL, 85509025UL, 3609089773UL, 2117061768UL, 3935682560UL, 3859508784UL, 4105287041UL, 1808988481UL, 
83680601UL, 1464326680UL, 1657693523UL, 3318062731UL, 1391154023UL, 234460119UL, 3551348221UL, 2245244809UL, 3635923821UL, 2814385745UL, 3497626257UL, 916790795UL, 245338628UL, 2514528380UL, 3711787525UL, 2239286063UL, 1054058916UL, 3963706010UL, 3176203796UL, 2230543409UL, 2173597546UL, 3786733892UL, 1396036965UL, 1038764273UL, 2032556038UL, 3216540537UL, 3298170974UL, 1008892557UL, 141155464UL, 1863766055UL, 3931110690UL, 191299053UL, 
2019139711UL, 2409528317UL, 739418419UL, 1377144055UL, 2876702705UL, 3911939673UL, 1197696462UL, 2814009721UL, 600813233UL, 1535885024UL, 1486280357UL, 3084650548UL, 2324695947UL, 2293284974UL, 2036339249UL, 3465600153UL, 1624446108UL, 327866771UL, 3356772175UL, 1826625240UL, 1947102360UL, 3661848193UL, 1421374867UL, 3228945021UL, 1358646008UL, 1067180174UL, 2190741258UL, 643362354UL, 109899594UL, 2064362635UL, 3249674888UL, 2165543887UL, 
4180291913UL, 1676507466UL, 1017841240UL, 2992644565UL, 476936158UL, 3608467942UL, 3113105154UL, 1154120402UL, 460889625UL, 1942263502UL, 1862994005UL, 3020908939UL, 3078194866UL, 310971889UL, 1644896012UL, 693774191UL, 3549937583UL, 3710822994UL, 3554313733UL, 2174654326UL, 37658897UL, 2340485150UL, 950951909UL, 4288936895UL, 3744348848UL, 2258231402UL, 1085927825UL, 1595992020UL, 3288724966UL, 1367247946UL, 3850509554UL, 3925419886UL, 
2628739022UL, 2528254629UL, 3582224789UL, 3124287811UL, 3373329273UL, 4255542251UL, 1185418446UL, 4018656113UL, 1989726178UL, 1381160022UL, 3642438773UL, 4284399225UL, 935780030UL, 3622052196UL, 1263328494UL, 1154237693UL, 2684443667UL, 3067549398UL, 2786224913UL, 1251034970UL, 1874233020UL, 3222830495UL, 3866931656UL, 1529490307UL, 3146635362UL, 1436483376UL, 2821876495UL, 3927829532UL, 979247444UL, 2142862852UL, 1368937545UL, 2647327844UL, 
1072219385UL, 294065371UL, 3543274652UL, 911792564UL, 1204178178UL, 4127214323UL, 103582737UL, 3101998294UL, 730811902UL, 1989156224UL, 2872353003UL, 1885087777UL, 1390223786UL, 2657819643UL, 552729795UL, 1736270535UL, 3325206451UL, 1897013739UL, 3657020278UL, 1387364861UL, 1966588302UL, 2117065739UL, 486446521UL, 3675999281UL, 714737345UL, 686837530UL, 3946214694UL, 3609089773UL, 2117061768UL, 3935682560UL, 3859508784UL, 2916136885UL, 
1808988481UL, 83680601UL, 1464326680UL, 1657693523UL, 3438751781UL, 1391154023UL, 234460119UL, 3551348221UL, 2245244809UL, 3948410079UL, 2814385745UL, 3497626257UL, 916790795UL, 245338628UL, 1767303496UL, 3711787525UL, 2239286063UL, 1054058916UL, 3963706010UL, 4140631909UL, 2230543409UL, 2173597546UL, 3786733892UL, 1396036965UL, 1116033475UL, 2032556038UL, 3216540537UL, 3298170974UL, 1008892557UL, 667272562UL, 1863766055UL, 3931110690UL, 
191299053UL, 2019139711UL, 272901326UL, 739418419UL, 1377144055UL, 2876702705UL, 3911939673UL, 3839312742UL, 2814009721UL, 600813233UL, 1535885024UL, 1486280357UL, 4256065219UL, 2324695947UL, 2293284974UL, 2036339249UL, 3465600153UL, 1215859603UL, 327866771UL, 3356772175UL, 1826625240UL, 1947102360UL, 4240407984UL, 1421374867UL, 3228945021UL, 1358646008UL, 1067180174UL, 4100357988UL, 643362354UL, 109899594UL, 2064362635UL, 3249674888UL, 
2898852084UL, 4180291913UL, 1676507466UL, 1017841240UL, 2992644565UL, 1569683812UL, 3608467942UL, 3113105154UL, 1154120402UL, 460889625UL, 966040649UL, 1862994005UL, 3020908939UL, 3078194866UL, 310971889UL, 786634113UL, 693774191UL, 3549937583UL, 3710822994UL, 3554313733UL, 1578429713UL, 37658897UL, 2340485150UL, 950951909UL, 4288936895UL, 2528123823UL, 2258231402UL, 1085927825UL, 1595992020UL, 3288724966UL, 3544041088UL, 3850509554UL, 
3925419886UL, 2628739022UL, 2528254629UL, 2562145937UL, 3124287811UL, 3373329273UL, 4255542251UL, 1185418446UL, 3693565710UL, 1989726178UL, 1381160022UL, 3642438773UL, 4284399225UL, 3271478204UL, 3622052196UL, 1263328494UL, 1154237693UL, 2684443667UL, 3615401444UL, 2786224913UL, 1251034970UL, 1874233020UL, 3222830495UL, 2572413057UL, 1529490307UL, 3146635362UL, 1436483376UL, 2821876495UL, 3993894153UL, 979247444UL, 2142862852UL, 1368937545UL, 
2647327844UL, 1353904396UL, 294065371UL, 3543274652UL, 911792564UL, 1204178178UL, 3165709748UL, 103582737UL, 3101998294UL, 730811902UL, 1989156224UL, 893293786UL, 1885087777UL, 1390223786UL, 2657819643UL, 552729795UL, 3388458110UL, 3325206451UL, 1897013739UL, 3657020278UL, 1387364861UL, 3025318046UL, 2117065739UL, 486446521UL, 3675999281UL, 714737345UL, 2085926890UL, 3946214694UL, 3609089773UL, 2117061768UL, 3935682560UL, 868009118UL, 
2916136885UL, 1808988481UL, 83680601UL, 1464326680UL, 797410789UL, 3438751781UL, 1391154023UL, 234460119UL, 3551348221UL, 4068940987UL, 3948410079UL, 2814385745UL, 3497626257UL, 916790795UL, 3722456098UL, 1767303496UL, 3711787525UL, 2239286063UL, 1054058916UL, 2030352819UL, 4140631909UL, 2230543409UL, 2173597546UL, 3786733892UL, 3211336683UL, 1116033475UL, 2032556038UL, 3216540537UL, 3298170974UL, 2589589144UL, 667272562UL, 1863766055UL, 
3931110690UL, 191299053UL, 1139480458UL, 272901326UL, 739418419UL, 1377144055UL, 2876702705UL, 1954361769UL, 3839312742UL, 2814009721UL, 600813233UL, 1535885024UL, 3587775605UL, 4256065219UL, 2324695947UL, 2293284974UL, 2036339249UL, 1534849280UL, 1215859603UL, 327866771UL, 3356772175UL, 1826625240UL, 720372669UL, 4240407984UL, 1421374867UL, 3228945021UL, 1358646008UL, 3409069246UL, 4100357988UL, 643362354UL, 109899594UL, 2064362635UL, 
4243434294UL, 2898852084UL, 4180291913UL, 1676507466UL, 1017841240UL, 3243922356UL, 1569683812UL, 3608467942UL, 3113105154UL, 1154120402UL, 1479311403UL, 966040649UL, 1862994005UL, 3020908939UL, 3078194866UL, 1556392996UL, 786634113UL, 693774191UL, 3549937583UL, 3710822994UL, 920664071UL, 1578429713UL, 37658897UL, 2340485150UL, 950951909UL, 740197415UL, 2528123823UL, 2258231402UL, 1085927825UL, 1595992020UL, 2580760267UL, 3544041088UL, 
3850509554UL, 3925419886UL, 2628739022UL, 3867556156UL, 2562145937UL, 3124287811UL, 3373329273UL, 4255542251UL, 3185271749UL, 3693565710UL, 1989726178UL, 1381160022UL, 3642438773UL, 3042165367UL, 3271478204UL, 3622052196UL, 1263328494UL, 1154237693UL, 1016814036UL, 3615401444UL, 2786224913UL, 1251034970UL, 1874233020UL, 2956086971UL, 2572413057UL, 1529490307UL, 3146635362UL, 1436483376UL, 1513970396UL, 3993894153UL, 979247444UL, 2142862852UL, 
1368937545UL, 3275665128UL, 1353904396UL, 294065371UL, 3543274652UL, 911792564UL, 2209636872UL, 3165709748UL, 103582737UL, 3101998294UL, 730811902UL, 965151434UL, 893293786UL, 1885087777UL, 1390223786UL, 2657819643UL, 3278634059UL, 3388458110UL, 3325206451UL, 1897013739UL, 3657020278UL, 4293473749UL, 3025318046UL, 2117065739UL, 486446521UL, 3675999281UL, 620561205UL, 2085926890UL, 3946214694UL, 3609089773UL, 2117061768UL, 163384588UL, 
868009118UL, 2916136885UL, 1808988481UL, 83680601UL, 10243015UL, 797410789UL, 3438751781UL, 1391154023UL, 234460119UL, 1278218413UL, 4068940987UL, 3948410079UL, 2814385745UL, 3497626257UL, 1233272798UL, 3722456098UL, 1767303496UL, 3711787525UL, 2239286063UL, 3968895688UL, 2030352819UL, 4140631909UL, 2230543409UL, 2173597546UL, 2866251044UL, 3211336683UL, 1116033475UL, 2032556038UL, 3216540537UL, 4233849723UL, 2589589144UL, 667272562UL, 
1863766055UL, 3931110690UL, 2468422423UL, 1139480458UL, 272901326UL, 739418419UL, 1377144055UL, 4240143411UL, 1954361769UL, 3839312742UL, 2814009721UL, 600813233UL, 3976840004UL, 3587775605UL, 4256065219UL, 2324695947UL, 2293284974UL, 437604123UL, 1534849280UL, 1215859603UL, 327866771UL, 3356772175UL, 2757237699UL, 720372669UL, 4240407984UL, 1421374867UL, 3228945021UL, 3284801305UL, 3409069246UL, 4100357988UL, 643362354UL, 109899594UL, 
1301585321UL, 2528806870UL, 1838904064UL, 448772403UL, 1097849740UL, 1899994097UL, 618309123UL, 1911948510UL, 2309256224UL, 1861398151UL, 905306403UL, 1067595802UL, 36868624UL, 3780886191UL, 835126206UL, 3190251977UL, 2672497726UL, 2085944002UL, 2912993968UL, 2493776706UL, 667136329UL, 1474890786UL, 2383346554UL, 943528949UL, 3376706013UL, 2495573574UL, 144956345UL, 793159960UL, 1591274917UL, 477107637UL, 1383815442UL, 67384899UL, 
2355242218UL, 1687409818UL, 3801093871UL, 2108217811UL, 3455908733UL, 4172160797UL, 3935534685UL, 631067839UL, 1187677548UL, 2280856137UL, 3020767646UL, 2063176246UL, 3736904984UL, 2952933848UL, 2975164686UL, 4144473303UL, 34670977UL, 1250976509UL, 3484166554UL, 1532744745UL, 225700994UL, 1878713627UL, 2122358980UL, 1456610194UL, 2917522161UL, 2818947075UL, 102678939UL, 53743858UL, 2095250656UL, 4023979225UL, 3094092874UL, 4128760696UL, 
3411610028UL, 3020200609UL, 2225866341UL, 586320946UL, 63813522UL, 1238216159UL, 2825692263UL, 2169937231UL, 3298517640UL, 1542128261UL, 2205544184UL, 1258655704UL, 2629012083UL, 4113650203UL, 3198617867UL, 2742310794UL, 3372657381UL, 3115904410UL, 1948638822UL, 1123521744UL, 1080429281UL, 4086706732UL, 4142693211UL, 817377147UL, 2570194641UL, 26001503UL, 2861456160UL, 4185725555UL, 2573003804UL, 1618628779UL, 2588489212UL, 3996192609UL, 
1555844274UL, 1003123505UL, 1326350123UL, 1130583849UL, 3017128756UL, 74119042UL, 4041266437UL, 1938014170UL, 3528465794UL, 4203969698UL, 1913054398UL, 3617979809UL, 2218810167UL, 2453899816UL, 1997423206UL, 477446533UL, 303090065UL, 757937082UL, 1523238256UL, 3140505311UL, 1422588701UL, 3642014639UL, 1740624195UL, 1276017154UL, 3072526193UL, 3675105122UL, 1335122682UL, 4080595263UL, 2308519420UL, 3299182769UL, 1461978532UL, 3098694217UL, 
2982399822UL, 3088698511UL, 586759229UL, 3548750902UL, 1449857891UL, 2866451663UL, 2525162286UL, 57294602UL, 4107991297UL, 1214672265UL, 2940391280UL, 4285346034UL, 3338216759UL, 737207923UL, 4264163846UL, 59219141UL, 2300024654UL, 1876616814UL, 1976543605UL, 783571061UL, 1724699622UL, 1967524469UL, 1650309916UL, 3322257631UL, 3975521122UL, 273342162UL, 1156754241UL, 185315896UL, 3368133921UL, 66314655UL, 4153777915UL, 3519901897UL, 
},
{
3672467167UL, 68684525UL, 1738833632UL, 3081329135UL, 2583806115UL, 2291130512UL, 503032614UL, 3658059597UL, 571493931UL, 685537959UL, 3498787788UL, 422428426UL, 3879256913UL, 1173158320UL, 4000800121UL, 298972869UL, 1718342816UL, 2541691685UL, 2490502642UL, 2321452806UL, 4223212804UL, 1812334632UL, 3717655725UL, 4238191852UL, 3001307165UL, 2621896355UL, 2572404999UL, 3590094954UL, 760765206UL, 2293618001UL, 1392353032UL, 1733137169UL, 
2674005018UL, 4067961151UL, 1505710487UL, 451078217UL, 2591688848UL, 12635611UL, 507045428UL, 694822241UL, 1789383090UL, 1140183890UL, 1720695967UL, 1994318191UL, 3340349873UL, 2793804971UL, 1054433135UL, 2345087879UL, 3179939285UL, 1651968615UL, 1793223686UL, 1055357758UL, 914271617UL, 483007580UL, 2127727816UL, 2754998083UL, 3179053982UL, 598442002UL, 1950227301UL, 213053613UL, 3566888111UL, 2832258993UL, 4260365359UL, 443662829UL, 
1706542890UL, 3852730296UL, 3643260763UL, 2163607277UL, 1812905006UL, 171529637UL, 215187467UL, 2369406909UL, 1929000706UL, 2572441025UL, 2133955541UL, 810692262UL, 1337974799UL, 4030350704UL, 2159178715UL, 3769451556UL, 1026825278UL, 593628480UL, 1817383139UL, 878832429UL, 2253876350UL, 203612980UL, 2102950440UL, 3407143936UL, 1912362251UL, 1595387637UL, 2827580539UL, 305467658UL, 3292706746UL, 44135525UL, 4001933553UL, 3697343089UL, 
760470915UL, 587414402UL, 1419378814UL, 2852774010UL, 3891626781UL, 2757016765UL, 1090707384UL, 3997074427UL, 1047182100UL, 2855539022UL, 36229159UL, 1591415533UL, 3471572739UL, 1237952140UL, 2614469314UL, 213338525UL, 886212578UL, 2620301943UL, 713590207UL, 2430496777UL, 1198164420UL, 2644841698UL, 3654164701UL, 36283572UL, 1461695896UL, 1770331341UL, 1641501876UL, 3470919184UL, 3181021559UL, 3053795110UL, 3533531372UL, 3134337355UL, 
668308383UL, 388340999UL, 3221275220UL, 1589659138UL, 294382235UL, 1447443579UL, 690177534UL, 1799726917UL, 2838977761UL, 4172949119UL, 2360858031UL, 159385920UL, 2248389027UL, 1790015671UL, 3925738275UL, 1049918544UL, 4107349511UL, 1619955951UL, 4188275966UL, 1672572975UL, 2672697497UL, 1863413666UL, 747724021UL, 4037561738UL, 1605940213UL, 445253292UL, 3362434828UL, 610898209UL, 1473244091UL, 735444769UL, 1540599852UL, 2449351720UL, 
1032410949UL, 3672467167UL, 68684525UL, 1738833632UL, 3081329135UL, 519684794UL, 2291130512UL, 503032614UL, 3658059597UL, 571493931UL, 2400186105UL, 3498787788UL, 422428426UL, 3879256913UL, 1173158320UL, 4120704752UL, 298972869UL, 1718342816UL, 2541691685UL, 2490502642UL, 1686027891UL, 4223212804UL, 1812334632UL, 3717655725UL, 4238191852UL, 642431972UL, 2621896355UL, 2572404999UL, 3590094954UL, 760765206UL, 2949609717UL, 1392353032UL, 
1733137169UL, 2674005018UL, 4067961151UL, 1526077846UL, 451078217UL, 2591688848UL, 12635611UL, 507045428UL, 2417951415UL, 1789383090UL, 1140183890UL, 1720695967UL, 1994318191UL, 3465605863UL, 2793804971UL, 1054433135UL, 2345087879UL, 3179939285UL, 3079297626UL, 1793223686UL, 1055357758UL, 914271617UL, 483007580UL, 306802527UL, 2754998083UL, 3179053982UL, 598442002UL, 1950227301UL, 2473418737UL, 3566888111UL, 2832258993UL, 4260365359UL, 
443662829UL, 2097776414UL, 3852730296UL, 3643260763UL, 2163607277UL, 1812905006UL, 3957721904UL, 215187467UL, 2369406909UL, 1929000706UL, 2572441025UL, 3779486126UL, 810692262UL, 1337974799UL, 4030350704UL, 2159178715UL, 1127012865UL, 1026825278UL, 593628480UL, 1817383139UL, 878832429UL, 361018423UL, 203612980UL, 2102950440UL, 3407143936UL, 1912362251UL, 1475218277UL, 2827580539UL, 305467658UL, 3292706746UL, 44135525UL, 1900092336UL, 
3697343089UL, 760470915UL, 587414402UL, 1419378814UL, 343303227UL, 3891626781UL, 2757016765UL, 1090707384UL, 3997074427UL, 745490961UL, 2855539022UL, 36229159UL, 1591415533UL, 3471572739UL, 3920625546UL, 2614469314UL, 213338525UL, 886212578UL, 2620301943UL, 827771411UL, 2430496777UL, 1198164420UL, 2644841698UL, 3654164701UL, 2747674190UL, 1461695896UL, 1770331341UL, 1641501876UL, 3470919184UL, 919857376UL, 3053795110UL, 3533531372UL, 
3134337355UL, 668308383UL, 201138876UL, 3221275220UL, 1589659138UL, 294382235UL, 1447443579UL, 4211579707UL, 1799726917UL, 2838977761UL, 4172949119UL, 2360858031UL, 416103844UL, 2248389027UL, 1790015671UL, 3925738275UL, 1049918544UL, 3481887924UL, 1619955951UL, 4188275966UL, 1672572975UL, 2672697497UL, 564854400UL, 747724021UL, 4037561738UL, 1605940213UL, 445253292UL, 604900912UL, 610898209UL, 1473244091UL, 735444769UL, 1540599852UL, 
3036173307UL, 1032410949UL, 3672467167UL, 68684525UL, 1738833632UL, 973022696UL, 519684794UL, 2291130512UL, 503032614UL, 3658059597UL, 1500301452UL, 2400186105UL, 3498787788UL, 422428426UL, 3879256913UL, 3923611748UL, 4120704752UL, 298972869UL, 1718342816UL, 2541691685UL, 2323881484UL, 1686027891UL, 4223212804UL, 1812334632UL, 3717655725UL, 2109094458UL, 642431972UL, 2621896355UL, 2572404999UL, 3590094954UL, 1837882537UL, 2949609717UL, 
1392353032UL, 1733137169UL, 2674005018UL, 3252348987UL, 1526077846UL, 451078217UL, 2591688848UL, 12635611UL, 3971261781UL, 2417951415UL, 1789383090UL, 1140183890UL, 1720695967UL, 2906966040UL, 3465605863UL, 2793804971UL, 1054433135UL, 2345087879UL, 915518921UL, 3079297626UL, 1793223686UL, 1055357758UL, 914271617UL, 791633499UL, 306802527UL, 2754998083UL, 3179053982UL, 598442002UL, 324402573UL, 2473418737UL, 3566888111UL, 2832258993UL, 
4260365359UL, 2168046398UL, 2097776414UL, 3852730296UL, 3643260763UL, 2163607277UL, 2595175979UL, 3957721904UL, 215187467UL, 2369406909UL, 1929000706UL, 657446369UL, 3779486126UL, 810692262UL, 1337974799UL, 4030350704UL, 1865557469UL, 1127012865UL, 1026825278UL, 593628480UL, 1817383139UL, 3414354529UL, 361018423UL, 203612980UL, 2102950440UL, 3407143936UL, 1739372987UL, 1475218277UL, 2827580539UL, 305467658UL, 3292706746UL, 825045562UL, 
1900092336UL, 3697343089UL, 760470915UL, 587414402UL, 2000637694UL, 343303227UL, 3891626781UL, 2757016765UL, 1090707384UL, 4015377800UL, 745490961UL, 2855539022UL, 36229159UL, 1591415533UL, 2208656873UL, 3920625546UL, 2614469314UL, 213338525UL, 886212578UL, 2729976209UL, 827771411UL, 2430496777UL, 1198164420UL, 2644841698UL, 1922667440UL, 2747674190UL, 1461695896UL, 1770331341UL, 1641501876UL, 357535311UL, 919857376UL, 3053795110UL, 
3533531372UL, 3134337355UL, 1004072597UL, 201138876UL, 3221275220UL, 1589659138UL, 294382235UL, 1148950143UL, 4211579707UL, 1799726917UL, 2838977761UL, 4172949119UL, 892664404UL, 416103844UL, 2248389027UL, 1790015671UL, 3925738275UL, 2612357890UL, 3481887924UL, 1619955951UL, 4188275966UL, 1672572975UL, 2005534713UL, 564854400UL, 747724021UL, 4037561738UL, 1605940213UL, 2620990454UL, 604900912UL, 610898209UL, 1473244091UL, 735444769UL, 
3571225334UL, 3036173307UL, 1032410949UL, 3672467167UL, 68684525UL, 3327351604UL, 973022696UL, 519684794UL, 2291130512UL, 503032614UL, 3814902238UL, 1500301452UL, 2400186105UL, 3498787788UL, 422428426UL, 1756753750UL, 3923611748UL, 4120704752UL, 298972869UL, 1718342816UL, 652903081UL, 2323881484UL, 1686027891UL, 4223212804UL, 1812334632UL, 1599640566UL, 2109094458UL, 642431972UL, 2621896355UL, 2572404999UL, 1668409355UL, 1837882537UL, 
2949609717UL, 1392353032UL, 1733137169UL, 3691709793UL, 3252348987UL, 1526077846UL, 451078217UL, 2591688848UL, 3353622601UL, 3971261781UL, 2417951415UL, 1789383090UL, 1140183890UL, 4113853791UL, 2906966040UL, 3465605863UL, 2793804971UL, 1054433135UL, 2195882948UL, 915518921UL, 3079297626UL, 1793223686UL, 1055357758UL, 898713552UL, 791633499UL, 306802527UL, 2754998083UL, 3179053982UL, 2469350088UL, 324402573UL, 2473418737UL, 3566888111UL, 
2832258993UL, 1377718274UL, 2168046398UL, 2097776414UL, 3852730296UL, 3643260763UL, 3492388484UL, 2595175979UL, 3957721904UL, 215187467UL, 2369406909UL, 4243449339UL, 657446369UL, 3779486126UL, 810692262UL, 1337974799UL, 3960230785UL, 1865557469UL, 1127012865UL, 1026825278UL, 593628480UL, 732793312UL, 3414354529UL, 361018423UL, 203612980UL, 2102950440UL, 2401792405UL, 1739372987UL, 1475218277UL, 2827580539UL, 305467658UL, 2454275289UL, 
825045562UL, 1900092336UL, 3697343089UL, 760470915UL, 2146882409UL, 2000637694UL, 343303227UL, 3891626781UL, 2757016765UL, 3997473261UL, 4015377800UL, 745490961UL, 2855539022UL, 36229159UL, 2375394427UL, 2208656873UL, 3920625546UL, 2614469314UL, 213338525UL, 2055366274UL, 2729976209UL, 827771411UL, 2430496777UL, 1198164420UL, 1789631187UL, 1922667440UL, 2747674190UL, 1461695896UL, 1770331341UL, 4284442852UL, 357535311UL, 919857376UL, 
3053795110UL, 3533531372UL, 2124270060UL, 1004072597UL, 201138876UL, 3221275220UL, 1589659138UL, 1418386120UL, 1148950143UL, 4211579707UL, 1799726917UL, 2838977761UL, 3540708069UL, 892664404UL, 416103844UL, 2248389027UL, 1790015671UL, 3936883UL, 2612357890UL, 3481887924UL, 1619955951UL, 4188275966UL, 2963623483UL, 2005534713UL, 564854400UL, 747724021UL, 4037561738UL, 3431155922UL, 2620990454UL, 604900912UL, 610898209UL, 1473244091UL, 
3880001339UL, 2879060316UL, 3300897679UL, 3960972039UL, 3201086624UL, 3814462934UL, 3426650044UL, 1930881632UL, 1981178788UL, 2956279691UL, 4272406256UL, 372705521UL, 1359389771UL, 1590302979UL, 3940206208UL, 3817999127UL, 2527835456UL, 2739078164UL, 716997849UL, 3235607043UL, 2550297745UL, 3688700200UL, 354502605UL, 2285793656UL, 2339138034UL, 3912354142UL, 2262255668UL, 469322622UL, 1319943359UL, 1916101235UL, 200441823UL, 509436982UL, 
2160284593UL, 1687919695UL, 4153615582UL, 495735041UL, 3694469424UL, 2086893117UL, 4223008799UL, 105344742UL, 1698033424UL, 1149223145UL, 4183918790UL, 4176151950UL, 415739351UL, 817762972UL, 3768072560UL, 1931430949UL, 2698979439UL, 3481477932UL, 1994322914UL, 4078299950UL, 1268233995UL, 3254069145UL, 91029129UL, 498234704UL, 1636613942UL, 3710087092UL, 3876816560UL, 3510446387UL, 3870169008UL, 1370156410UL, 2442498047UL, 2324396523UL, 
1258730334UL, 621954739UL, 1053015373UL, 491820717UL, 3386515432UL, 2203703266UL, 120167176UL, 2383669740UL, 1038666440UL, 2927342870UL, 3583197824UL, 1236241846UL, 2474675929UL, 679052891UL, 2451259584UL, 2177706146UL, 606842882UL, 3546980104UL, 2289281509UL, 353873434UL, 2041926837UL, 1238346748UL, 2729109726UL, 2843938395UL, 2938124210UL, 2554443866UL, 1494477920UL, 693378319UL, 2020963566UL, 2000385949UL, 3744098787UL, 650307220UL, 
2631327075UL, 1529128757UL, 595871428UL, 3206666562UL, 458062987UL, 875238192UL, 3729317374UL, 1368843921UL, 3478430230UL, 3234384578UL, 3232435428UL, 321359326UL, 994274524UL, 361184397UL, 4285497594UL, 915263578UL, 1486882838UL, 9988613UL, 829077170UL, 677216046UL, 4141828204UL, 165804609UL, 1086678519UL, 2933434608UL, 1351662802UL, 2640085040UL, 2611502932UL, 2033698714UL, 2008873254UL, 3995557835UL, 1020873906UL, 67873555UL, 
2230337823UL, 1263800417UL, 1148712155UL, 3985159589UL, 2979503513UL, 2854714997UL, 1539343345UL, 2751484352UL, 1569100732UL, 2020758949UL, 2126757134UL, 3426641899UL, 2808587825UL, 1953320148UL, 1096398464UL, 1502907172UL, 3751230087UL, 765557661UL, 765290990UL, 3056075500UL, 2040620632UL, 422573751UL, 3613558930UL, 1741145769UL, 273531216UL, 837238736UL, 494297893UL, 2903251124UL, 1636782182UL, 4256592784UL, 3652746656UL, 4258393217UL, 
},

};

static __device__ unsigned int precalc_xorwow_offset_matrix[8][800] = {
{
0UL, 0UL, 0UL, 0UL, 3UL, 0UL, 0UL, 0UL, 0UL, 6UL, 0UL, 0UL, 0UL, 0UL, 15UL, 0UL, 0UL, 0UL, 0UL, 30UL, 0UL, 0UL, 0UL, 0UL, 60UL, 0UL, 0UL, 0UL, 0UL, 120UL, 0UL, 0UL, 
0UL, 0UL, 240UL, 0UL, 0UL, 0UL, 0UL, 480UL, 0UL, 0UL, 0UL, 0UL, 960UL, 0UL, 0UL, 0UL, 0UL, 1920UL, 0UL, 0UL, 0UL, 0UL, 3840UL, 0UL, 0UL, 0UL, 0UL, 7680UL, 0UL, 0UL, 0UL, 0UL, 
15360UL, 0UL, 0UL, 0UL, 0UL, 30720UL, 0UL, 0UL, 0UL, 0UL, 61440UL, 0UL, 0UL, 0UL, 0UL, 122880UL, 0UL, 0UL, 0UL, 0UL, 245760UL, 0UL, 0UL, 0UL, 0UL, 491520UL, 0UL, 0UL, 0UL, 0UL, 983040UL, 0UL, 
0UL, 0UL, 0UL, 1966080UL, 0UL, 0UL, 0UL, 0UL, 3932160UL, 0UL, 0UL, 0UL, 0UL, 7864320UL, 0UL, 0UL, 0UL, 0UL, 15728640UL, 0UL, 0UL, 0UL, 0UL, 31457280UL, 0UL, 0UL, 0UL, 0UL, 62914560UL, 0UL, 0UL, 0UL, 
0UL, 125829120UL, 0UL, 0UL, 0UL, 0UL, 251658240UL, 0UL, 0UL, 0UL, 0UL, 503316480UL, 0UL, 0UL, 0UL, 0UL, 1006632960UL, 0UL, 0UL, 0UL, 0UL, 2013265920UL, 0UL, 0UL, 0UL, 0UL, 4026531840UL, 0UL, 0UL, 0UL, 0UL, 3758096384UL, 
1UL, 0UL, 0UL, 0UL, 0UL, 2UL, 0UL, 0UL, 0UL, 0UL, 4UL, 0UL, 0UL, 0UL, 0UL, 8UL, 0UL, 0UL, 0UL, 0UL, 16UL, 0UL, 0UL, 0UL, 0UL, 32UL, 0UL, 0UL, 0UL, 0UL, 64UL, 0UL, 
0UL, 0UL, 0UL, 128UL, 0UL, 0UL, 0UL, 0UL, 256UL, 0UL, 0UL, 0UL, 0UL, 512UL, 0UL, 0UL, 0UL, 0UL, 1024UL, 0UL, 0UL, 0UL, 0UL, 2048UL, 0UL, 0UL, 0UL, 0UL, 4096UL, 0UL, 0UL, 0UL, 
0UL, 8192UL, 0UL, 0UL, 0UL, 0UL, 16384UL, 0UL, 0UL, 0UL, 0UL, 32768UL, 0UL, 0UL, 0UL, 0UL, 65536UL, 0UL, 0UL, 0UL, 0UL, 131072UL, 0UL, 0UL, 0UL, 0UL, 262144UL, 0UL, 0UL, 0UL, 0UL, 524288UL, 
0UL, 0UL, 0UL, 0UL, 1048576UL, 0UL, 0UL, 0UL, 0UL, 2097152UL, 0UL, 0UL, 0UL, 0UL, 4194304UL, 0UL, 0UL, 0UL, 0UL, 8388608UL, 0UL, 0UL, 0UL, 0UL, 16777216UL, 0UL, 0UL, 0UL, 0UL, 33554432UL, 0UL, 0UL, 
0UL, 0UL, 67108864UL, 0UL, 0UL, 0UL, 0UL, 134217728UL, 0UL, 0UL, 0UL, 0UL, 268435456UL, 0UL, 0UL, 0UL, 0UL, 536870912UL, 0UL, 0UL, 0UL, 0UL, 1073741824UL, 0UL, 0UL, 0UL, 0UL, 2147483648UL, 0UL, 0UL, 0UL, 0UL, 
0UL, 1UL, 0UL, 0UL, 0UL, 0UL, 2UL, 0UL, 0UL, 0UL, 0UL, 4UL, 0UL, 0UL, 0UL, 0UL, 8UL, 0UL, 0UL, 0UL, 0UL, 16UL, 0UL, 0UL, 0UL, 0UL, 32UL, 0UL, 0UL, 0UL, 0UL, 64UL, 
0UL, 0UL, 0UL, 0UL, 128UL, 0UL, 0UL, 0UL, 0UL, 256UL, 0UL, 0UL, 0UL, 0UL, 512UL, 0UL, 0UL, 0UL, 0UL, 1024UL, 0UL, 0UL, 0UL, 0UL, 2048UL, 0UL, 0UL, 0UL, 0UL, 4096UL, 0UL, 0UL, 
0UL, 0UL, 8192UL, 0UL, 0UL, 0UL, 0UL, 16384UL, 0UL, 0UL, 0UL, 0UL, 32768UL, 0UL, 0UL, 0UL, 0UL, 65536UL, 0UL, 0UL, 0UL, 0UL, 131072UL, 0UL, 0UL, 0UL, 0UL, 262144UL, 0UL, 0UL, 0UL, 0UL, 
524288UL, 0UL, 0UL, 0UL, 0UL, 1048576UL, 0UL, 0UL, 0UL, 0UL, 2097152UL, 0UL, 0UL, 0UL, 0UL, 4194304UL, 0UL, 0UL, 0UL, 0UL, 8388608UL, 0UL, 0UL, 0UL, 0UL, 16777216UL, 0UL, 0UL, 0UL, 0UL, 33554432UL, 0UL, 
0UL, 0UL, 0UL, 67108864UL, 0UL, 0UL, 0UL, 0UL, 134217728UL, 0UL, 0UL, 0UL, 0UL, 268435456UL, 0UL, 0UL, 0UL, 0UL, 536870912UL, 0UL, 0UL, 0UL, 0UL, 1073741824UL, 0UL, 0UL, 0UL, 0UL, 2147483648UL, 0UL, 0UL, 0UL, 
0UL, 0UL, 1UL, 0UL, 0UL, 0UL, 0UL, 2UL, 0UL, 0UL, 0UL, 0UL, 4UL, 0UL, 0UL, 0UL, 0UL, 8UL, 0UL, 0UL, 0UL, 0UL, 16UL, 0UL, 0UL, 0UL, 0UL, 32UL, 0UL, 0UL, 0UL, 0UL, 
64UL, 0UL, 0UL, 0UL, 0UL, 128UL, 0UL, 0UL, 0UL, 0UL, 256UL, 0UL, 0UL, 0UL, 0UL, 512UL, 0UL, 0UL, 0UL, 0UL, 1024UL, 0UL, 0UL, 0UL, 0UL, 2048UL, 0UL, 0UL, 0UL, 0UL, 4096UL, 0UL, 
0UL, 0UL, 0UL, 8192UL, 0UL, 0UL, 0UL, 0UL, 16384UL, 0UL, 0UL, 0UL, 0UL, 32768UL, 0UL, 0UL, 0UL, 0UL, 65536UL, 0UL, 0UL, 0UL, 0UL, 131072UL, 0UL, 0UL, 0UL, 0UL, 262144UL, 0UL, 0UL, 0UL, 
0UL, 524288UL, 0UL, 0UL, 0UL, 0UL, 1048576UL, 0UL, 0UL, 0UL, 0UL, 2097152UL, 0UL, 0UL, 0UL, 0UL, 4194304UL, 0UL, 0UL, 0UL, 0UL, 8388608UL, 0UL, 0UL, 0UL, 0UL, 16777216UL, 0UL, 0UL, 0UL, 0UL, 33554432UL, 
0UL, 0UL, 0UL, 0UL, 67108864UL, 0UL, 0UL, 0UL, 0UL, 134217728UL, 0UL, 0UL, 0UL, 0UL, 268435456UL, 0UL, 0UL, 0UL, 0UL, 536870912UL, 0UL, 0UL, 0UL, 0UL, 1073741824UL, 0UL, 0UL, 0UL, 0UL, 2147483648UL, 0UL, 0UL, 
0UL, 0UL, 0UL, 1UL, 17UL, 0UL, 0UL, 0UL, 2UL, 34UL, 0UL, 0UL, 0UL, 4UL, 68UL, 0UL, 0UL, 0UL, 8UL, 136UL, 0UL, 0UL, 0UL, 16UL, 272UL, 0UL, 0UL, 0UL, 32UL, 544UL, 0UL, 0UL, 
0UL, 64UL, 1088UL, 0UL, 0UL, 0UL, 128UL, 2176UL, 0UL, 0UL, 0UL, 256UL, 4352UL, 0UL, 0UL, 0UL, 512UL, 8704UL, 0UL, 0UL, 0UL, 1024UL, 17408UL, 0UL, 0UL, 0UL, 2048UL, 34816UL, 0UL, 0UL, 0UL, 4096UL, 
69632UL, 0UL, 0UL, 0UL, 8192UL, 139264UL, 0UL, 0UL, 0UL, 16384UL, 278528UL, 0UL, 0UL, 0UL, 32768UL, 557056UL, 0UL, 0UL, 0UL, 65536UL, 1114112UL, 0UL, 0UL, 0UL, 131072UL, 2228224UL, 0UL, 0UL, 0UL, 262144UL, 4456448UL, 0UL, 
0UL, 0UL, 524288UL, 8912896UL, 0UL, 0UL, 0UL, 1048576UL, 17825792UL, 0UL, 0UL, 0UL, 2097152UL, 35651584UL, 0UL, 0UL, 0UL, 4194304UL, 71303168UL, 0UL, 0UL, 0UL, 8388608UL, 142606336UL, 0UL, 0UL, 0UL, 16777216UL, 285212672UL, 0UL, 0UL, 0UL, 
33554432UL, 570425344UL, 0UL, 0UL, 0UL, 67108864UL, 1140850688UL, 0UL, 0UL, 0UL, 134217728UL, 2281701376UL, 0UL, 0UL, 0UL, 268435456UL, 268435456UL, 0UL, 0UL, 0UL, 536870912UL, 536870912UL, 0UL, 0UL, 0UL, 1073741824UL, 1073741824UL, 0UL, 0UL, 0UL, 2147483648UL, 2147483648UL, 
},
{
0UL, 3UL, 51UL, 771UL, 13107UL, 0UL, 6UL, 102UL, 1542UL, 26214UL, 0UL, 15UL, 255UL, 3855UL, 65535UL, 0UL, 30UL, 510UL, 7710UL, 131070UL, 0UL, 60UL, 1020UL, 15420UL, 262140UL, 0UL, 120UL, 2040UL, 30840UL, 524280UL, 0UL, 240UL, 
4080UL, 61680UL, 1048560UL, 0UL, 480UL, 8160UL, 123360UL, 2097120UL, 0UL, 960UL, 16320UL, 246720UL, 4194240UL, 0UL, 1920UL, 32640UL, 493440UL, 8388480UL, 0UL, 3840UL, 65280UL, 986880UL, 16776960UL, 0UL, 7680UL, 130560UL, 1973760UL, 33553920UL, 0UL, 15360UL, 261120UL, 3947520UL, 
67107840UL, 0UL, 30720UL, 522240UL, 7895040UL, 134215680UL, 0UL, 61440UL, 1044480UL, 15790080UL, 268431360UL, 0UL, 122880UL, 2088960UL, 31580160UL, 536862720UL, 0UL, 245760UL, 4177920UL, 63160320UL, 1073725440UL, 0UL, 491520UL, 8355840UL, 126320640UL, 2147450880UL, 0UL, 983040UL, 16711680UL, 252641280UL, 4294901760UL, 0UL, 
1966080UL, 33423360UL, 505282560UL, 4294836224UL, 0UL, 3932160UL, 66846720UL, 1010565120UL, 4294705152UL, 0UL, 7864320UL, 133693440UL, 2021130240UL, 4294443008UL, 0UL, 15728640UL, 267386880UL, 4042260480UL, 4293918720UL, 0UL, 31457280UL, 534773760UL, 3789553664UL, 4292870144UL, 0UL, 62914560UL, 1069547520UL, 3284140032UL, 4290772992UL, 0UL, 125829120UL, 2139095040UL, 
2273312768UL, 4286578688UL, 0UL, 251658240UL, 4278190080UL, 251658240UL, 4278190080UL, 0UL, 503316480UL, 4261412864UL, 503316480UL, 4261412864UL, 0UL, 1006632960UL, 4227858432UL, 1006632960UL, 4227858432UL, 0UL, 2013265920UL, 4160749568UL, 2013265920UL, 4160749568UL, 0UL, 4026531840UL, 4026531840UL, 4026531840UL, 4026531840UL, 0UL, 3758096384UL, 3758096384UL, 3758096384UL, 3758096384UL, 
0UL, 0UL, 3UL, 51UL, 771UL, 0UL, 0UL, 6UL, 102UL, 1542UL, 0UL, 0UL, 15UL, 255UL, 3855UL, 0UL, 0UL, 30UL, 510UL, 7710UL, 0UL, 0UL, 60UL, 1020UL, 15420UL, 0UL, 0UL, 120UL, 2040UL, 30840UL, 0UL, 0UL, 
240UL, 4080UL, 61680UL, 0UL, 0UL, 480UL, 8160UL, 123360UL, 0UL, 0UL, 960UL, 16320UL, 246720UL, 0UL, 0UL, 1920UL, 32640UL, 493440UL, 0UL, 0UL, 3840UL, 65280UL, 986880UL, 0UL, 0UL, 7680UL, 130560UL, 1973760UL, 0UL, 0UL, 15360UL, 261120UL, 
3947520UL, 0UL, 0UL, 30720UL, 522240UL, 7895040UL, 0UL, 0UL, 61440UL, 1044480UL, 15790080UL, 0UL, 0UL, 122880UL, 2088960UL, 31580160UL, 0UL, 0UL, 245760UL, 4177920UL, 63160320UL, 0UL, 0UL, 491520UL, 8355840UL, 126320640UL, 0UL, 0UL, 983040UL, 16711680UL, 252641280UL, 0UL, 
0UL, 1966080UL, 33423360UL, 505282560UL, 0UL, 0UL, 3932160UL, 66846720UL, 1010565120UL, 0UL, 0UL, 7864320UL, 133693440UL, 2021130240UL, 0UL, 0UL, 15728640UL, 267386880UL, 4042260480UL, 0UL, 0UL, 31457280UL, 534773760UL, 3789553664UL, 0UL, 0UL, 62914560UL, 1069547520UL, 3284140032UL, 0UL, 0UL, 125829120UL, 
2139095040UL, 2273312768UL, 0UL, 0UL, 251658240UL, 4278190080UL, 251658240UL, 0UL, 0UL, 503316480UL, 4261412864UL, 503316480UL, 0UL, 0UL, 1006632960UL, 4227858432UL, 1006632960UL, 0UL, 0UL, 2013265920UL, 4160749568UL, 2013265920UL, 0UL, 0UL, 4026531840UL, 4026531840UL, 4026531840UL, 0UL, 0UL, 3758096384UL, 3758096384UL, 3758096384UL, 
0UL, 0UL, 0UL, 3UL, 51UL, 0UL, 0UL, 0UL, 6UL, 102UL, 0UL, 0UL, 0UL, 15UL, 255UL, 0UL, 0UL, 0UL, 30UL, 510UL, 0UL, 0UL, 0UL, 60UL, 1020UL, 0UL, 0UL, 0UL, 120UL, 2040UL, 0UL, 0UL, 
0UL, 240UL, 4080UL, 0UL, 0UL, 0UL, 480UL, 8160UL, 0UL, 0UL, 0UL, 960UL, 16320UL, 0UL, 0UL, 0UL, 1920UL, 32640UL, 0UL, 0UL, 0UL, 3840UL, 65280UL, 0UL, 0UL, 0UL, 7680UL, 130560UL, 0UL, 0UL, 0UL, 15360UL, 
261120UL, 0UL, 0UL, 0UL, 30720UL, 522240UL, 0UL, 0UL, 0UL, 61440UL, 1044480UL, 0UL, 0UL, 0UL, 122880UL, 2088960UL, 0UL, 0UL, 0UL, 245760UL, 4177920UL, 0UL, 0UL, 0UL, 491520UL, 8355840UL, 0UL, 0UL, 0UL, 983040UL, 16711680UL, 0UL, 
0UL, 0UL, 1966080UL, 33423360UL, 0UL, 0UL, 0UL, 3932160UL, 66846720UL, 0UL, 0UL, 0UL, 7864320UL, 133693440UL, 0UL, 0UL, 0UL, 15728640UL, 267386880UL, 0UL, 0UL, 0UL, 31457280UL, 534773760UL, 0UL, 0UL, 0UL, 62914560UL, 1069547520UL, 0UL, 0UL, 0UL, 
125829120UL, 2139095040UL, 0UL, 0UL, 0UL, 251658240UL, 4278190080UL, 0UL, 0UL, 0UL, 503316480UL, 4261412864UL, 0UL, 0UL, 0UL, 1006632960UL, 4227858432UL, 0UL, 0UL, 0UL, 2013265920UL, 4160749568UL, 0UL, 0UL, 0UL, 4026531840UL, 4026531840UL, 0UL, 0UL, 0UL, 3758096384UL, 3758096384UL, 
0UL, 0UL, 0UL, 0UL, 3UL, 0UL, 0UL, 0UL, 0UL, 6UL, 0UL, 0UL, 0UL, 0UL, 15UL, 0UL, 0UL, 0UL, 0UL, 30UL, 0UL, 0UL, 0UL, 0UL, 60UL, 0UL, 0UL, 0UL, 0UL, 120UL, 0UL, 0UL, 
0UL, 0UL, 240UL, 0UL, 0UL, 0UL, 0UL, 480UL, 0UL, 0UL, 0UL, 0UL, 960UL, 0UL, 0UL, 0UL, 0UL, 1920UL, 0UL, 0UL, 0UL, 0UL, 3840UL, 0UL, 0UL, 0UL, 0UL, 7680UL, 0UL, 0UL, 0UL, 0UL, 
15360UL, 0UL, 0UL, 0UL, 0UL, 30720UL, 0UL, 0UL, 0UL, 0UL, 61440UL, 0UL, 0UL, 0UL, 0UL, 122880UL, 0UL, 0UL, 0UL, 0UL, 245760UL, 0UL, 0UL, 0UL, 0UL, 491520UL, 0UL, 0UL, 0UL, 0UL, 983040UL, 0UL, 
0UL, 0UL, 0UL, 1966080UL, 0UL, 0UL, 0UL, 0UL, 3932160UL, 0UL, 0UL, 0UL, 0UL, 7864320UL, 0UL, 0UL, 0UL, 0UL, 15728640UL, 0UL, 0UL, 0UL, 0UL, 31457280UL, 0UL, 0UL, 0UL, 0UL, 62914560UL, 0UL, 0UL, 0UL, 
0UL, 125829120UL, 0UL, 0UL, 0UL, 0UL, 251658240UL, 0UL, 0UL, 0UL, 0UL, 503316480UL, 0UL, 0UL, 0UL, 0UL, 1006632960UL, 0UL, 0UL, 0UL, 0UL, 2013265920UL, 0UL, 0UL, 0UL, 0UL, 4026531840UL, 0UL, 0UL, 0UL, 0UL, 3758096384UL, 
1UL, 17UL, 257UL, 4369UL, 65537UL, 2UL, 34UL, 514UL, 8738UL, 131074UL, 4UL, 68UL, 1028UL, 17476UL, 262148UL, 8UL, 136UL, 2056UL, 34952UL, 524296UL, 16UL, 272UL, 4112UL, 69904UL, 1048592UL, 32UL, 544UL, 8224UL, 139808UL, 2097184UL, 64UL, 1088UL, 
16448UL, 279616UL, 4194368UL, 128UL, 2176UL, 32896UL, 559232UL, 8388736UL, 256UL, 4352UL, 65792UL, 1118464UL, 16777472UL, 512UL, 8704UL, 131584UL, 2236928UL, 33554944UL, 1024UL, 17408UL, 263168UL, 4473856UL, 67109888UL, 2048UL, 34816UL, 526336UL, 8947712UL, 134219776UL, 4096UL, 69632UL, 1052672UL, 17895424UL, 
268439552UL, 8192UL, 139264UL, 2105344UL, 35790848UL, 536879104UL, 16384UL, 278528UL, 4210688UL, 71581696UL, 1073758208UL, 32768UL, 557056UL, 8421376UL, 143163392UL, 2147516416UL, 65536UL, 1114112UL, 16842752UL, 286326784UL, 65536UL, 131072UL, 2228224UL, 33685504UL, 572653568UL, 131072UL, 262144UL, 4456448UL, 67371008UL, 1145307136UL, 262144UL, 524288UL, 
8912896UL, 134742016UL, 2290614272UL, 524288UL, 1048576UL, 17825792UL, 269484032UL, 286261248UL, 1048576UL, 2097152UL, 35651584UL, 538968064UL, 572522496UL, 2097152UL, 4194304UL, 71303168UL, 1077936128UL, 1145044992UL, 4194304UL, 8388608UL, 142606336UL, 2155872256UL, 2290089984UL, 8388608UL, 16777216UL, 285212672UL, 16777216UL, 285212672UL, 16777216UL, 33554432UL, 570425344UL, 33554432UL, 
570425344UL, 33554432UL, 67108864UL, 1140850688UL, 67108864UL, 1140850688UL, 67108864UL, 134217728UL, 2281701376UL, 134217728UL, 2281701376UL, 134217728UL, 268435456UL, 268435456UL, 268435456UL, 268435456UL, 268435456UL, 536870912UL, 536870912UL, 536870912UL, 536870912UL, 536870912UL, 1073741824UL, 1073741824UL, 1073741824UL, 1073741824UL, 1073741824UL, 2147483648UL, 2147483648UL, 2147483648UL, 2147483648UL, 2147483648UL, 
},
{
85009117UL, 335741939UL, 1412632518UL, 386859243UL, 1741437244UL, 152139416UL, 403047142UL, 2556825231UL, 505087203UL, 4287193174UL, 335609039UL, 336528191UL, 1425998811UL, 456920088UL, 2832198590UL, 724748988UL, 3625845630UL, 1509824181UL, 3330088197UL, 2710488401UL, 1431742057UL, 1077674236UL, 1140592489UL, 2096905276UL, 3007294393UL, 2863484114UL, 1081606648UL, 1207443154UL, 972585080UL, 2793363314UL, 1432000919UL, 1089470704UL, 
1341132452UL, 3019109363UL, 2362285522UL, 1790260014UL, 2178941408UL, 2682264904UL, 1743251430UL, 429603751UL, 359294556UL, 62915520UL, 1069562512UL, 3486502860UL, 859207501UL, 3939814584UL, 125831040UL, 2139125024UL, 2678038424UL, 1718415002UL, 363436400UL, 251662080UL, 4278250048UL, 1061109552UL, 3436830004UL, 3948098272UL, 503324160UL, 4261532800UL, 2122219104UL, 2310257256UL, 380003776UL, 1006648320UL, 4228098304UL, 4244438208UL, 
3278337232UL, 3981233024UL, 2013296640UL, 4161229312UL, 4193909120UL, 2530142624UL, 446273280UL, 4026593280UL, 4027491328UL, 871625472UL, 4254978880UL, 4113772032UL, 3758219264UL, 3760015360UL, 2011686400UL, 3946555008UL, 711351296UL, 3221471232UL, 3225063424UL, 4291808256UL, 108481792UL, 2496444416UL, 2147975168UL, 2155159552UL, 4020213760UL, 485399040UL, 3919147008UL, 983040UL, 15351808UL, 255799296UL, 3923588096UL, 322101248UL, 
1966080UL, 299139072UL, 511598592UL, 3283773440UL, 3865427968UL, 3932160UL, 4087939072UL, 1023197184UL, 1467273216UL, 214663168UL, 7864320UL, 4149346304UL, 2046394368UL, 3202981888UL, 3650551808UL, 3236954112UL, 1050935296UL, 871563264UL, 2916302848UL, 1932394496UL, 2447376384UL, 1833435136UL, 2011561984UL, 2342944768UL, 643563520UL, 868220928UL, 177209344UL, 4291559424UL, 122486784UL, 2360868864UL, 2004877312UL, 85983232UL, 
4019716096UL, 3734634496UL, 3647995904UL, 1056964608UL, 3661627392UL, 254803968UL, 2905866240UL, 1658847232UL, 2113929216UL, 3028287488UL, 3730833408UL, 2322071552UL, 3586129920UL, 4227858432UL, 1761607680UL, 2092957696UL, 80740352UL, 2071986176UL, 4160749568UL, 3523215360UL, 964689920UL, 429916160UL, 3875536896UL, 4026531840UL, 2751463424UL, 1929379840UL, 4081057792UL, 503316480UL, 3758096384UL, 2281701376UL, 4127195136UL, 3397386240UL, 
1316635UL, 85009117UL, 335741939UL, 1412632518UL, 386859243UL, 1580547UL, 152139416UL, 403047142UL, 2556825231UL, 505087203UL, 1317672UL, 335609039UL, 336528191UL, 1425998811UL, 456920088UL, 1574501UL, 724748988UL, 3625845630UL, 1509824181UL, 3330088197UL, 15612UL, 1431742057UL, 1077674236UL, 1140592489UL, 2096905276UL, 31224UL, 2863484114UL, 1081606648UL, 1207443154UL, 972585080UL, 62451UL, 1432000919UL, 
1089470704UL, 1341132452UL, 3019109363UL, 124902UL, 1790260014UL, 2178941408UL, 2682264904UL, 1743251430UL, 249804UL, 359294556UL, 62915520UL, 1069562512UL, 3486502860UL, 499608UL, 3939814584UL, 125831040UL, 2139125024UL, 2678038424UL, 999216UL, 363436400UL, 251662080UL, 4278250048UL, 1061109552UL, 3223223904UL, 3948098272UL, 503324160UL, 4261532800UL, 2122219104UL, 1077738688UL, 380003776UL, 1006648320UL, 4228098304UL, 
4244438208UL, 1081735552UL, 3981233024UL, 2013296640UL, 4161229312UL, 4193909120UL, 1089729280UL, 446273280UL, 4026593280UL, 4027491328UL, 871625472UL, 2179458560UL, 4113772032UL, 3758219264UL, 3760015360UL, 2011686400UL, 63949824UL, 711351296UL, 3221471232UL, 3225063424UL, 4291808256UL, 127899648UL, 2496444416UL, 2147975168UL, 2155159552UL, 4020213760UL, 255799296UL, 3919147008UL, 983040UL, 15351808UL, 255799296UL, 3732824064UL, 
322101248UL, 1966080UL, 299139072UL, 511598592UL, 2096939008UL, 3865427968UL, 3932160UL, 4087939072UL, 1023197184UL, 972652544UL, 214663168UL, 7864320UL, 4149346304UL, 2046394368UL, 3019046912UL, 3650551808UL, 3236954112UL, 1050935296UL, 871563264UL, 1743126528UL, 1932394496UL, 2447376384UL, 1833435136UL, 2011561984UL, 3486253056UL, 643563520UL, 868220928UL, 177209344UL, 4291559424UL, 2677538816UL, 2360868864UL, 2004877312UL, 
85983232UL, 4019716096UL, 1060110336UL, 3647995904UL, 1056964608UL, 3661627392UL, 254803968UL, 3193962496UL, 1658847232UL, 2113929216UL, 3028287488UL, 3730833408UL, 3166699520UL, 3586129920UL, 4227858432UL, 1761607680UL, 2092957696UL, 3112173568UL, 2071986176UL, 4160749568UL, 3523215360UL, 964689920UL, 1929379840UL, 3875536896UL, 4026531840UL, 2751463424UL, 1929379840UL, 4127195136UL, 503316480UL, 3758096384UL, 2281701376UL, 4127195136UL, 
332854UL, 1316635UL, 85009117UL, 335741939UL, 1412632518UL, 596079UL, 1580547UL, 152139416UL, 403047142UL, 2556825231UL, 1316075UL, 1317672UL, 335609039UL, 336528191UL, 1425998811UL, 2824661UL, 1574501UL, 724748988UL, 3625845630UL, 1509824181UL, 5571497UL, 15612UL, 1431742057UL, 1077674236UL, 1140592489UL, 11142994UL, 31224UL, 2863484114UL, 1081606648UL, 1207443154UL, 22285988UL, 62451UL, 
1432000919UL, 1089470704UL, 1341132452UL, 44571976UL, 124902UL, 1790260014UL, 2178941408UL, 2682264904UL, 89143952UL, 249804UL, 359294556UL, 62915520UL, 1069562512UL, 178287904UL, 499608UL, 3939814584UL, 125831040UL, 2139125024UL, 356575808UL, 999216UL, 363436400UL, 251662080UL, 4278250048UL, 713151616UL, 3223223904UL, 3948098272UL, 503324160UL, 4261532800UL, 1426303232UL, 1077738688UL, 380003776UL, 1006648320UL, 
4228098304UL, 2852606464UL, 1081735552UL, 3981233024UL, 2013296640UL, 4161229312UL, 1410245632UL, 1089729280UL, 446273280UL, 4026593280UL, 4027491328UL, 1746749440UL, 2179458560UL, 4113772032UL, 3758219264UL, 3760015360UL, 272273408UL, 63949824UL, 711351296UL, 3221471232UL, 3225063424UL, 3765772288UL, 127899648UL, 2496444416UL, 2147975168UL, 2155159552UL, 15351808UL, 255799296UL, 3919147008UL, 983040UL, 15351808UL, 3251929088UL, 
3732824064UL, 322101248UL, 1966080UL, 299139072UL, 1135149056UL, 2096939008UL, 3865427968UL, 3932160UL, 4087939072UL, 1196556288UL, 972652544UL, 214663168UL, 7864320UL, 4149346304UL, 1319370752UL, 3019046912UL, 3650551808UL, 3236954112UL, 1050935296UL, 2638741504UL, 1743126528UL, 1932394496UL, 2447376384UL, 1833435136UL, 982515712UL, 3486253056UL, 643563520UL, 868220928UL, 177209344UL, 1965031424UL, 2677538816UL, 2360868864UL, 
2004877312UL, 85983232UL, 3930062848UL, 1060110336UL, 3647995904UL, 1056964608UL, 3661627392UL, 3565158400UL, 3193962496UL, 1658847232UL, 2113929216UL, 3028287488UL, 2835349504UL, 3166699520UL, 3586129920UL, 4227858432UL, 1761607680UL, 1375731712UL, 3112173568UL, 2071986176UL, 4160749568UL, 3523215360UL, 2751463424UL, 1929379840UL, 3875536896UL, 4026531840UL, 2751463424UL, 2281701376UL, 4127195136UL, 503316480UL, 3758096384UL, 2281701376UL, 
5123UL, 332854UL, 1316635UL, 85009117UL, 335741939UL, 6150UL, 596079UL, 1580547UL, 152139416UL, 403047142UL, 5135UL, 1316075UL, 1317672UL, 335609039UL, 336528191UL, 6174UL, 2824661UL, 1574501UL, 724748988UL, 3625845630UL, 60UL, 5571497UL, 15612UL, 1431742057UL, 1077674236UL, 120UL, 11142994UL, 31224UL, 2863484114UL, 1081606648UL, 240UL, 22285988UL, 
62451UL, 1432000919UL, 1089470704UL, 480UL, 44571976UL, 124902UL, 1790260014UL, 2178941408UL, 960UL, 89143952UL, 249804UL, 359294556UL, 62915520UL, 1920UL, 178287904UL, 499608UL, 3939814584UL, 125831040UL, 3840UL, 356575808UL, 999216UL, 363436400UL, 251662080UL, 7680UL, 713151616UL, 3223223904UL, 3948098272UL, 503324160UL, 15360UL, 1426303232UL, 1077738688UL, 380003776UL, 
1006648320UL, 30720UL, 2852606464UL, 1081735552UL, 3981233024UL, 2013296640UL, 61440UL, 1410245632UL, 1089729280UL, 446273280UL, 4026593280UL, 122880UL, 1746749440UL, 2179458560UL, 4113772032UL, 3758219264UL, 245760UL, 272273408UL, 63949824UL, 711351296UL, 3221471232UL, 491520UL, 3765772288UL, 127899648UL, 2496444416UL, 2147975168UL, 983040UL, 15351808UL, 255799296UL, 3919147008UL, 983040UL, 3223191552UL, 
3251929088UL, 3732824064UL, 322101248UL, 1966080UL, 1077673984UL, 1135149056UL, 2096939008UL, 3865427968UL, 3932160UL, 1081606144UL, 1196556288UL, 972652544UL, 214663168UL, 7864320UL, 1089470464UL, 1319370752UL, 3019046912UL, 3650551808UL, 3236954112UL, 2178940928UL, 2638741504UL, 1743126528UL, 1932394496UL, 2447376384UL, 62914560UL, 982515712UL, 3486253056UL, 643563520UL, 868220928UL, 125829120UL, 1965031424UL, 2677538816UL, 
2360868864UL, 2004877312UL, 251658240UL, 3930062848UL, 1060110336UL, 3647995904UL, 1056964608UL, 503316480UL, 3565158400UL, 3193962496UL, 1658847232UL, 2113929216UL, 1006632960UL, 2835349504UL, 3166699520UL, 3586129920UL, 4227858432UL, 2013265920UL, 1375731712UL, 3112173568UL, 2071986176UL, 4160749568UL, 4026531840UL, 2751463424UL, 1929379840UL, 3875536896UL, 4026531840UL, 3758096384UL, 2281701376UL, 4127195136UL, 503316480UL, 3758096384UL, 
201392209UL, 3423671362UL, 218366296UL, 3713336838UL, 206572594UL, 402785186UL, 2552372100UL, 436928947UL, 3130605370UL, 463476848UL, 262468UL, 4461835UL, 68158800UL, 1158700908UL, 20971524UL, 524680UL, 8919318UL, 136513955UL, 2316537326UL, 25165852UL, 3222274064UL, 3239051564UL, 3494187077UL, 3558090985UL, 3221225500UL, 2149580832UL, 2183135832UL, 2693406858UL, 2821214674UL, 2147483704UL, 4194368UL, 71304368UL, 
1091846420UL, 1347462055UL, 64UL, 8388736UL, 142608736UL, 2183692840UL, 2694924110UL, 3221225600UL, 16777472UL, 285217472UL, 72418384UL, 1094880924UL, 1342177536UL, 33554944UL, 570434944UL, 144836768UL, 2189761848UL, 2684355072UL, 67109888UL, 1140869888UL, 289673536UL, 84556400UL, 1073742848UL, 134219776UL, 2281739776UL, 579347072UL, 169112800UL, 2147485696UL, 268439552UL, 268512256UL, 1158694144UL, 69790144UL, 
4096UL, 536879104UL, 537024512UL, 2317388288UL, 3360805760UL, 8192UL, 1073758208UL, 1074049024UL, 339809280UL, 1352902400UL, 16384UL, 2147516416UL, 2148098048UL, 3900844032UL, 1632062976UL, 32768UL, 65536UL, 1228800UL, 17059840UL, 311335936UL, 65536UL, 131072UL, 2457600UL, 34119680UL, 622671872UL, 131072UL, 262144UL, 4915200UL, 68239360UL, 1245343744UL, 262144UL, 524288UL, 
9830400UL, 136478720UL, 2490687488UL, 524288UL, 1048576UL, 288096256UL, 272957440UL, 954843136UL, 3222274048UL, 2097152UL, 3797417984UL, 545914880UL, 2983428096UL, 2149580800UL, 4194304UL, 78643200UL, 1091829760UL, 2745630720UL, 4194304UL, 3229614080UL, 3378511872UL, 1109917696UL, 2270035968UL, 8388608UL, 1358954496UL, 1119879168UL, 1414529024UL, 513540096UL, 16777216UL, 2717908992UL, 2239758336UL, 2829058048UL, 
1027080192UL, 33554432UL, 1140850688UL, 184549376UL, 1363148800UL, 2054160384UL, 3288334336UL, 2281701376UL, 369098752UL, 2726297600UL, 4108320768UL, 2281701376UL, 268435456UL, 738197504UL, 2231369728UL, 968884224UL, 3959422976UL, 536870912UL, 1476395008UL, 167772160UL, 3011510272UL, 3355443200UL, 1073741824UL, 2952790016UL, 335544320UL, 1728053248UL, 2147483648UL, 2147483648UL, 1610612736UL, 3892314112UL, 503316480UL, 0UL, 
},
{
1939838472UL, 1412147404UL, 166205219UL, 1757484276UL, 2905930693UL, 2345662040UL, 2845657161UL, 253454719UL, 2661974169UL, 303781080UL, 4075331504UL, 31014156UL, 244538930UL, 3752264221UL, 992575155UL, 219309525UL, 246620060UL, 215640989UL, 4125020723UL, 2016731730UL, 3236558869UL, 297169276UL, 3293566751UL, 1867504216UL, 210423272UL, 2531663658UL, 499723753UL, 1730625896UL, 189236880UL, 3388575408UL, 2433358422UL, 1368961148UL, 
3134096848UL, 2827836415UL, 3888822753UL, 4172043647UL, 3379360748UL, 2651760955UL, 1345081091UL, 627692776UL, 189423917UL, 1927379456UL, 4004336944UL, 2995932065UL, 1882016234UL, 2551113616UL, 1576396048UL, 1299792730UL, 2151240795UL, 2154814108UL, 4292139924UL, 3555849728UL, 943986992UL, 3169912733UL, 2631635779UL, 3478094562UL, 1285558544UL, 3716074330UL, 2780749859UL, 3911106510UL, 4175656994UL, 1731832828UL, 1275401375UL, 937322456UL, 
3802094750UL, 1145506936UL, 1008905193UL, 1718801768UL, 645739137UL, 1356219146UL, 827886816UL, 1722154800UL, 2242776733UL, 754630810UL, 772070504UL, 249481170UL, 2608123425UL, 2087201889UL, 3200968096UL, 3292110026UL, 841433255UL, 477543427UL, 1878882709UL, 705347364UL, 4003860146UL, 3194913138UL, 2616490007UL, 357561212UL, 2446098297UL, 2955680594UL, 2512991743UL, 637464579UL, 1209132455UL, 1341312804UL, 612108672UL, 2455017713UL, 
1749147666UL, 4020226825UL, 2873924220UL, 499405095UL, 1837614076UL, 1227604028UL, 714577577UL, 165950208UL, 442290261UL, 489077752UL, 216760440UL, 42151250UL, 426862080UL, 2810242474UL, 4112075489UL, 3514761468UL, 4101921371UL, 982512636UL, 500792667UL, 4286077681UL, 198050301UL, 1858712743UL, 2913642493UL, 3547545255UL, 3981929169UL, 2944140287UL, 2286578015UL, 3422343167UL, 1239123295UL, 2026367394UL, 3269986302UL, 3028402878UL, 
2709637886UL, 1096011710UL, 294584132UL, 3086749695UL, 3324400975UL, 1164394495UL, 4290155855UL, 543687304UL, 4008517630UL, 836370334UL, 1876426750UL, 2362048414UL, 3578325264UL, 3221487612UL, 2671154748UL, 3395518460UL, 2018383420UL, 2131029536UL, 2165829624UL, 697661816UL, 1336049656UL, 3309365624UL, 4259639360UL, 3423548400UL, 2416417776UL, 1633698800UL, 1630071792UL, 41950336UL, 3423478496UL, 2885608160UL, 3943744224UL, 677380832UL, 
4179285363UL, 1939838472UL, 1412147404UL, 166205219UL, 1757484276UL, 3838244595UL, 2345662040UL, 2845657161UL, 253454719UL, 2661974169UL, 138737288UL, 4075331504UL, 31014156UL, 244538930UL, 3752264221UL, 1503392345UL, 219309525UL, 246620060UL, 215640989UL, 4125020723UL, 1759481152UL, 3236558869UL, 297169276UL, 3293566751UL, 1867504216UL, 3898070400UL, 2531663658UL, 499723753UL, 1730625896UL, 189236880UL, 2610231010UL, 2433358422UL, 
1368961148UL, 3134096848UL, 2827836415UL, 3903474593UL, 4172043647UL, 3379360748UL, 2651760955UL, 1345081091UL, 1267864331UL, 189423917UL, 1927379456UL, 4004336944UL, 2995932065UL, 3452816347UL, 2551113616UL, 1576396048UL, 1299792730UL, 2151240795UL, 1222520631UL, 4292139924UL, 3555849728UL, 943986992UL, 3169912733UL, 3260130211UL, 3478094562UL, 1285558544UL, 3716074330UL, 2780749859UL, 3039362306UL, 4175656994UL, 1731832828UL, 1275401375UL, 
937322456UL, 3236754932UL, 1145506936UL, 1008905193UL, 1718801768UL, 645739137UL, 1358079399UL, 827886816UL, 1722154800UL, 2242776733UL, 754630810UL, 1748663943UL, 249481170UL, 2608123425UL, 2087201889UL, 3200968096UL, 698076610UL, 841433255UL, 477543427UL, 1878882709UL, 705347364UL, 3692794996UL, 3194913138UL, 2616490007UL, 357561212UL, 2446098297UL, 2771068186UL, 2512991743UL, 637464579UL, 1209132455UL, 1341312804UL, 27937268UL, 
2455017713UL, 1749147666UL, 4020226825UL, 2873924220UL, 1673040956UL, 1837614076UL, 1227604028UL, 714577577UL, 165950208UL, 528340088UL, 489077752UL, 216760440UL, 42151250UL, 426862080UL, 1646215396UL, 4112075489UL, 3514761468UL, 4101921371UL, 982512636UL, 2095821304UL, 4286077681UL, 198050301UL, 1858712743UL, 2913642493UL, 277300160UL, 3981929169UL, 2944140287UL, 2286578015UL, 3422343167UL, 1178044288UL, 2026367394UL, 3269986302UL, 
3028402878UL, 2709637886UL, 2234191616UL, 294584132UL, 3086749695UL, 3324400975UL, 1164394495UL, 136978944UL, 543687304UL, 4008517630UL, 836370334UL, 1876426750UL, 3275253760UL, 3578325264UL, 3221487612UL, 2671154748UL, 3395518460UL, 3942394880UL, 2131029536UL, 2165829624UL, 697661816UL, 1336049656UL, 3265045504UL, 4259639360UL, 3423548400UL, 2416417776UL, 1633698800UL, 3943712768UL, 41950336UL, 3423478496UL, 2885608160UL, 3943744224UL, 
2293593009UL, 4179285363UL, 1939838472UL, 1412147404UL, 166205219UL, 715714152UL, 3838244595UL, 2345662040UL, 2845657161UL, 253454719UL, 3758048260UL, 138737288UL, 4075331504UL, 31014156UL, 244538930UL, 370671650UL, 1503392345UL, 219309525UL, 246620060UL, 215640989UL, 2219162331UL, 1759481152UL, 3236558869UL, 297169276UL, 3293566751UL, 135243402UL, 3898070400UL, 2531663658UL, 499723753UL, 1730625896UL, 3142293713UL, 2610231010UL, 
2433358422UL, 1368961148UL, 3134096848UL, 486949791UL, 3903474593UL, 4172043647UL, 3379360748UL, 2651760955UL, 3172880550UL, 1267864331UL, 189423917UL, 1927379456UL, 4004336944UL, 191463910UL, 3452816347UL, 2551113616UL, 1576396048UL, 1299792730UL, 4411574UL, 1222520631UL, 4292139924UL, 3555849728UL, 943986992UL, 3073348038UL, 3260130211UL, 3478094562UL, 1285558544UL, 3716074330UL, 3098363790UL, 3039362306UL, 4175656994UL, 1731832828UL, 
1275401375UL, 468159532UL, 3236754932UL, 1145506936UL, 1008905193UL, 1718801768UL, 1092964081UL, 1358079399UL, 827886816UL, 1722154800UL, 2242776733UL, 53128947UL, 1748663943UL, 249481170UL, 2608123425UL, 2087201889UL, 1960144614UL, 698076610UL, 841433255UL, 477543427UL, 1878882709UL, 1505419004UL, 3692794996UL, 3194913138UL, 2616490007UL, 357561212UL, 2823143358UL, 2771068186UL, 2512991743UL, 637464579UL, 1209132455UL, 1991737212UL, 
27937268UL, 2455017713UL, 1749147666UL, 4020226825UL, 2907896812UL, 1673040956UL, 1837614076UL, 1227604028UL, 714577577UL, 3633969112UL, 528340088UL, 489077752UL, 216760440UL, 42151250UL, 2886728356UL, 1646215396UL, 4112075489UL, 3514761468UL, 4101921371UL, 3507686008UL, 2095821304UL, 4286077681UL, 198050301UL, 1858712743UL, 1463806912UL, 277300160UL, 3981929169UL, 2944140287UL, 2286578015UL, 4137888640UL, 1178044288UL, 2026367394UL, 
3269986302UL, 3028402878UL, 1276820224UL, 2234191616UL, 294584132UL, 3086749695UL, 3324400975UL, 4274031104UL, 136978944UL, 543687304UL, 4008517630UL, 836370334UL, 2978609152UL, 3275253760UL, 3578325264UL, 3221487612UL, 2671154748UL, 2296777728UL, 3942394880UL, 2131029536UL, 2165829624UL, 697661816UL, 1086645248UL, 3265045504UL, 4259639360UL, 3423548400UL, 2416417776UL, 2295121920UL, 3943712768UL, 41950336UL, 3423478496UL, 2885608160UL, 
3290486993UL, 2293593009UL, 4179285363UL, 1939838472UL, 1412147404UL, 3718742914UL, 715714152UL, 3838244595UL, 2345662040UL, 2845657161UL, 3251034248UL, 3758048260UL, 138737288UL, 4075331504UL, 31014156UL, 2257801369UL, 370671650UL, 1503392345UL, 219309525UL, 246620060UL, 1375177854UL, 2219162331UL, 1759481152UL, 3236558869UL, 297169276UL, 2981812236UL, 135243402UL, 3898070400UL, 2531663658UL, 499723753UL, 1103465850UL, 3142293713UL, 
2610231010UL, 2433358422UL, 1368961148UL, 2570001060UL, 486949791UL, 3903474593UL, 4172043647UL, 3379360748UL, 1922171925UL, 3172880550UL, 1267864331UL, 189423917UL, 1927379456UL, 1359812359UL, 191463910UL, 3452816347UL, 2551113616UL, 1576396048UL, 2518549525UL, 4411574UL, 1222520631UL, 4292139924UL, 3555849728UL, 949028615UL, 3073348038UL, 3260130211UL, 3478094562UL, 1285558544UL, 4113039486UL, 3098363790UL, 3039362306UL, 4175656994UL, 
1731832828UL, 1827471372UL, 468159532UL, 3236754932UL, 1145506936UL, 1008905193UL, 1626341859UL, 1092964081UL, 1358079399UL, 827886816UL, 1722154800UL, 1069547583UL, 53128947UL, 1748663943UL, 249481170UL, 2608123425UL, 3162506114UL, 1960144614UL, 698076610UL, 841433255UL, 477543427UL, 3641706484UL, 1505419004UL, 3692794996UL, 3194913138UL, 2616490007UL, 3623882586UL, 2823143358UL, 2771068186UL, 2512991743UL, 637464579UL, 16785012UL, 
1991737212UL, 27937268UL, 2455017713UL, 1749147666UL, 2348825660UL, 2907896812UL, 1673040956UL, 1837614076UL, 1227604028UL, 2579527800UL, 3633969112UL, 528340088UL, 489077752UL, 216760440UL, 3628134628UL, 2886728356UL, 1646215396UL, 4112075489UL, 3514761468UL, 1602085368UL, 3507686008UL, 2095821304UL, 4286077681UL, 198050301UL, 2501362624UL, 1463806912UL, 277300160UL, 3981929169UL, 2944140287UL, 4112467840UL, 4137888640UL, 1178044288UL, 
2026367394UL, 3269986302UL, 3356184320UL, 1276820224UL, 2234191616UL, 294584132UL, 3086749695UL, 366387712UL, 4274031104UL, 136978944UL, 543687304UL, 4008517630UL, 1006135296UL, 2978609152UL, 3275253760UL, 3578325264UL, 3221487612UL, 3104844800UL, 2296777728UL, 3942394880UL, 2131029536UL, 2165829624UL, 1874371584UL, 1086645248UL, 3265045504UL, 4259639360UL, 3423548400UL, 2975352832UL, 2295121920UL, 3943712768UL, 41950336UL, 3423478496UL, 
989898496UL, 3410688577UL, 2331788830UL, 3546482013UL, 813828841UL, 1865093068UL, 3265457506UL, 3795669738UL, 2119696024UL, 4285651426UL, 3333834629UL, 3451487261UL, 2090324595UL, 1816963648UL, 932961512UL, 2470761029UL, 3401764108UL, 3421619354UL, 4199624502UL, 589386372UL, 879396240UL, 3372470254UL, 2693109296UL, 2424215996UL, 38442268UL, 1882087724UL, 171397600UL, 2024561281UL, 183095586UL, 3282207272UL, 3402177296UL, 1859195498UL, 
413109947UL, 2839537944UL, 1632143648UL, 3742715856UL, 388696500UL, 1748703733UL, 3563198567UL, 3826785440UL, 2896086528UL, 3989037829UL, 1478787788UL, 1390277813UL, 2123320736UL, 3416516800UL, 2056564203UL, 2584895011UL, 1605192736UL, 2475623616UL, 3856499712UL, 3439657984UL, 708088129UL, 1501395566UL, 1302184960UL, 1360092352UL, 1645630430UL, 1425230387UL, 3369488824UL, 2979863936UL, 869212432UL, 150548847UL, 1097557362UL, 655939640UL, 
316553344UL, 3761918508UL, 3958338094UL, 141744600UL, 1412214640UL, 1859689984UL, 3200680981UL, 3883058679UL, 999801880UL, 3946079738UL, 1876072704UL, 194381849UL, 2177533995UL, 1584707624UL, 3053768410UL, 2593051904UL, 3458076673UL, 4047442835UL, 3545972808UL, 3441793178UL, 194975744UL, 1731731470UL, 4168755162UL, 2628944732UL, 2125675784UL, 3119906816UL, 960774145UL, 2646626078UL, 2152793157UL, 3049156634UL, 672464896UL, 3046932493UL, 
3700727536UL, 2152335477UL, 575986696UL, 671940608UL, 2208366608UL, 1454456125UL, 937760016UL, 4103979069UL, 2737668096UL, 1179779104UL, 1030912634UL, 1041902112UL, 2032909434UL, 2274230272UL, 2089025605UL, 3050632421UL, 2428784965UL, 140658149UL, 4254138368UL, 1745354889UL, 711584249UL, 2746523017UL, 2551006457UL, 1100808192UL, 1494221073UL, 3422999489UL, 2696954129UL, 976716737UL, 2653421568UL, 3806331426UL, 3690047362UL, 1481392674UL, 
3817015170UL, 2353004544UL, 286262340UL, 2300534532UL, 4206449732UL, 15339268UL, 2894069760UL, 488376456UL, 1489927688UL, 1196583048UL, 652746248UL, 2214592512UL, 69904UL, 1006205200UL, 2322628880UL, 1229515024UL, 2617245696UL, 3423527456UL, 1964953120UL, 4260938272UL, 386199072UL, 1744830464UL, 1342444608UL, 1069330496UL, 2138592320UL, 3185897536UL, 1073741824UL, 1342493824UL, 3780942976UL, 1771066496UL, 2189433984UL, 2147483648UL, 
},
{
1804684571UL, 2106089606UL, 1533056158UL, 2870216110UL, 3618155659UL, 3789871366UL, 4246691682UL, 3667072763UL, 1212241769UL, 3152390668UL, 2973497449UL, 2958641966UL, 2088805328UL, 717518631UL, 2401090860UL, 3606967204UL, 952637656UL, 59827581UL, 1291486682UL, 1499453515UL, 2053994857UL, 563998083UL, 4094000396UL, 1163546899UL, 1003843565UL, 654565639UL, 1070907026UL, 4217851863UL, 426034251UL, 1721352737UL, 278404469UL, 3899800390UL, 
1063362170UL, 1162348262UL, 3153545093UL, 3249996223UL, 186674553UL, 2616406148UL, 3137968354UL, 1282784965UL, 1495068058UL, 3033760361UL, 2278144523UL, 3192245769UL, 719586342UL, 2602548287UL, 3386583150UL, 355354345UL, 3252815848UL, 2178056037UL, 2283016801UL, 3005955037UL, 3340254490UL, 802791670UL, 251122316UL, 3705188626UL, 1252262272UL, 3989036796UL, 3527490452UL, 2047131255UL, 1447170583UL, 3373930285UL, 2895037457UL, 209341805UL, 
1820357643UL, 3712392731UL, 685796521UL, 1322920440UL, 814388470UL, 1357857147UL, 434430265UL, 2650681935UL, 1371566728UL, 58783716UL, 2273435933UL, 3498513198UL, 792571900UL, 1447808772UL, 3513385860UL, 99175889UL, 1105434360UL, 1484146625UL, 3327194068UL, 242672513UL, 3552105593UL, 1425844616UL, 2871928454UL, 1124633561UL, 607610433UL, 2130018608UL, 1610235673UL, 2844230432UL, 2748082340UL, 994392866UL, 450823250UL, 2912535126UL, 
2574390988UL, 3974009252UL, 78696582UL, 649682891UL, 3980917176UL, 3221419689UL, 960695436UL, 729221508UL, 358358845UL, 3392407691UL, 472711005UL, 295914899UL, 3005191796UL, 3078521977UL, 3370011868UL, 509135340UL, 1965939519UL, 2086465877UL, 2457949822UL, 1324152522UL, 762289386UL, 3618693997UL, 233730715UL, 2873984650UL, 31168606UL, 3367142977UL, 2851851305UL, 3251660053UL, 4209768406UL, 3298190175UL, 901235185UL, 1564391510UL, 
2352686527UL, 1008150482UL, 578573310UL, 3462447127UL, 2482873876UL, 1790221257UL, 2255375608UL, 2335345651UL, 1381450613UL, 2866805101UL, 1495073163UL, 519905259UL, 3184556473UL, 1076378339UL, 2692926127UL, 970097715UL, 4013407916UL, 4014350363UL, 2476927059UL, 1989070516UL, 2640060069UL, 1987784589UL, 1880989003UL, 3861138803UL, 451743296UL, 1987067871UL, 1975657871UL, 3397816882UL, 2309900530UL, 4108425851UL, 4063867233UL, 3319482186UL, 
2621772886UL, 1804684571UL, 2106089606UL, 1533056158UL, 2870216110UL, 611557097UL, 3789871366UL, 4246691682UL, 3667072763UL, 1212241769UL, 3389551988UL, 2973497449UL, 2958641966UL, 2088805328UL, 717518631UL, 2460955430UL, 3606967204UL, 952637656UL, 59827581UL, 1291486682UL, 3531087304UL, 2053994857UL, 563998083UL, 4094000396UL, 1163546899UL, 1242934125UL, 654565639UL, 1070907026UL, 4217851863UL, 426034251UL, 3034416129UL, 278404469UL, 
3899800390UL, 1063362170UL, 1162348262UL, 4258714417UL, 3249996223UL, 186674553UL, 2616406148UL, 3137968354UL, 639885806UL, 1495068058UL, 3033760361UL, 2278144523UL, 3192245769UL, 4159910300UL, 2602548287UL, 3386583150UL, 355354345UL, 3252815848UL, 1555885880UL, 2283016801UL, 3005955037UL, 3340254490UL, 802791670UL, 2948774612UL, 3705188626UL, 1252262272UL, 3989036796UL, 3527490452UL, 2107826711UL, 1447170583UL, 3373930285UL, 2895037457UL, 
209341805UL, 3763367196UL, 3712392731UL, 685796521UL, 1322920440UL, 814388470UL, 1986168339UL, 434430265UL, 2650681935UL, 1371566728UL, 58783716UL, 1423189187UL, 3498513198UL, 792571900UL, 1447808772UL, 3513385860UL, 315969823UL, 1105434360UL, 1484146625UL, 3327194068UL, 242672513UL, 3336228275UL, 1425844616UL, 2871928454UL, 1124633561UL, 607610433UL, 1762052458UL, 1610235673UL, 2844230432UL, 2748082340UL, 994392866UL, 3771702243UL, 
2912535126UL, 2574390988UL, 3974009252UL, 78696582UL, 1626628844UL, 3980917176UL, 3221419689UL, 960695436UL, 729221508UL, 382092233UL, 3392407691UL, 472711005UL, 295914899UL, 3005191796UL, 514297204UL, 3370011868UL, 509135340UL, 1965939519UL, 2086465877UL, 3975975091UL, 1324152522UL, 762289386UL, 3618693997UL, 233730715UL, 455322516UL, 31168606UL, 3367142977UL, 2851851305UL, 3251660053UL, 3952189603UL, 3298190175UL, 901235185UL, 
1564391510UL, 2352686527UL, 826181452UL, 578573310UL, 3462447127UL, 2482873876UL, 1790221257UL, 1529242773UL, 2335345651UL, 1381450613UL, 2866805101UL, 1495073163UL, 877718651UL, 3184556473UL, 1076378339UL, 2692926127UL, 970097715UL, 299344245UL, 4014350363UL, 2476927059UL, 1989070516UL, 2640060069UL, 3844531327UL, 1880989003UL, 3861138803UL, 451743296UL, 1987067871UL, 3272848161UL, 3397816882UL, 2309900530UL, 4108425851UL, 4063867233UL, 
834288064UL, 2621772886UL, 1804684571UL, 2106089606UL, 1533056158UL, 304865970UL, 611557097UL, 3789871366UL, 4246691682UL, 3667072763UL, 2728206193UL, 3389551988UL, 2973497449UL, 2958641966UL, 2088805328UL, 3895037582UL, 2460955430UL, 3606967204UL, 952637656UL, 59827581UL, 2349212526UL, 3531087304UL, 2053994857UL, 563998083UL, 4094000396UL, 4028900485UL, 1242934125UL, 654565639UL, 1070907026UL, 4217851863UL, 1663452176UL, 3034416129UL, 
278404469UL, 3899800390UL, 1063362170UL, 2721441405UL, 4258714417UL, 3249996223UL, 186674553UL, 2616406148UL, 4228837490UL, 639885806UL, 1495068058UL, 3033760361UL, 2278144523UL, 2820661772UL, 4159910300UL, 2602548287UL, 3386583150UL, 355354345UL, 1815256314UL, 1555885880UL, 2283016801UL, 3005955037UL, 3340254490UL, 2166514144UL, 2948774612UL, 3705188626UL, 1252262272UL, 3989036796UL, 751187322UL, 2107826711UL, 1447170583UL, 3373930285UL, 
2895037457UL, 2809311944UL, 3763367196UL, 3712392731UL, 685796521UL, 1322920440UL, 936300677UL, 1986168339UL, 434430265UL, 2650681935UL, 1371566728UL, 1308015359UL, 1423189187UL, 3498513198UL, 792571900UL, 1447808772UL, 3065349526UL, 315969823UL, 1105434360UL, 1484146625UL, 3327194068UL, 1038676789UL, 3336228275UL, 1425844616UL, 2871928454UL, 1124633561UL, 2956422231UL, 1762052458UL, 1610235673UL, 2844230432UL, 2748082340UL, 3603862093UL, 
3771702243UL, 2912535126UL, 2574390988UL, 3974009252UL, 1691332448UL, 1626628844UL, 3980917176UL, 3221419689UL, 960695436UL, 3120142427UL, 382092233UL, 3392407691UL, 472711005UL, 295914899UL, 4101686983UL, 514297204UL, 3370011868UL, 509135340UL, 1965939519UL, 3015736706UL, 3975975091UL, 1324152522UL, 762289386UL, 3618693997UL, 2395097989UL, 455322516UL, 31168606UL, 3367142977UL, 2851851305UL, 30511955UL, 3952189603UL, 3298190175UL, 
901235185UL, 1564391510UL, 2606298633UL, 826181452UL, 578573310UL, 3462447127UL, 2482873876UL, 4159642946UL, 1529242773UL, 2335345651UL, 1381450613UL, 2866805101UL, 1782913669UL, 877718651UL, 3184556473UL, 1076378339UL, 2692926127UL, 1730328819UL, 299344245UL, 4014350363UL, 2476927059UL, 1989070516UL, 1425685614UL, 3844531327UL, 1880989003UL, 3861138803UL, 451743296UL, 889237383UL, 3272848161UL, 3397816882UL, 2309900530UL, 4108425851UL, 
1155723231UL, 834288064UL, 2621772886UL, 1804684571UL, 2106089606UL, 2387009004UL, 304865970UL, 611557097UL, 3789871366UL, 4246691682UL, 1405709661UL, 2728206193UL, 3389551988UL, 2973497449UL, 2958641966UL, 3183906006UL, 3895037582UL, 2460955430UL, 3606967204UL, 952637656UL, 1345432763UL, 2349212526UL, 3531087304UL, 2053994857UL, 563998083UL, 3749011414UL, 4028900485UL, 1242934125UL, 654565639UL, 1070907026UL, 1072342672UL, 1663452176UL, 
3034416129UL, 278404469UL, 3899800390UL, 3566652188UL, 2721441405UL, 4258714417UL, 3249996223UL, 186674553UL, 4001263143UL, 4228837490UL, 639885806UL, 1495068058UL, 3033760361UL, 4278332644UL, 2820661772UL, 4159910300UL, 2602548287UL, 3386583150UL, 838831089UL, 1815256314UL, 1555885880UL, 2283016801UL, 3005955037UL, 3377397178UL, 2166514144UL, 2948774612UL, 3705188626UL, 1252262272UL, 2414422575UL, 751187322UL, 2107826711UL, 1447170583UL, 
3373930285UL, 1253755033UL, 2809311944UL, 3763367196UL, 3712392731UL, 685796521UL, 3238624475UL, 936300677UL, 1986168339UL, 434430265UL, 2650681935UL, 1642290570UL, 1308015359UL, 1423189187UL, 3498513198UL, 792571900UL, 173318140UL, 3065349526UL, 315969823UL, 1105434360UL, 1484146625UL, 4103797777UL, 1038676789UL, 3336228275UL, 1425844616UL, 2871928454UL, 1797745765UL, 2956422231UL, 1762052458UL, 1610235673UL, 2844230432UL, 2180656608UL, 
3603862093UL, 3771702243UL, 2912535126UL, 2574390988UL, 1183098390UL, 1691332448UL, 1626628844UL, 3980917176UL, 3221419689UL, 2645203959UL, 3120142427UL, 382092233UL, 3392407691UL, 472711005UL, 1659659070UL, 4101686983UL, 514297204UL, 3370011868UL, 509135340UL, 483888155UL, 3015736706UL, 3975975091UL, 1324152522UL, 762289386UL, 1259948064UL, 2395097989UL, 455322516UL, 31168606UL, 3367142977UL, 339990414UL, 30511955UL, 3952189603UL, 
3298190175UL, 901235185UL, 3097920065UL, 2606298633UL, 826181452UL, 578573310UL, 3462447127UL, 1548039839UL, 4159642946UL, 1529242773UL, 2335345651UL, 1381450613UL, 2173079994UL, 1782913669UL, 877718651UL, 3184556473UL, 1076378339UL, 1570275057UL, 1730328819UL, 299344245UL, 4014350363UL, 2476927059UL, 1845882881UL, 1425685614UL, 3844531327UL, 1880989003UL, 3861138803UL, 1322409081UL, 889237383UL, 3272848161UL, 3397816882UL, 2309900530UL, 
3505447982UL, 3430136873UL, 1319796589UL, 4202423979UL, 3184732284UL, 2910356648UL, 2534615223UL, 3854465731UL, 768821792UL, 2205052576UL, 1348983754UL, 1300250188UL, 2919181738UL, 2520178732UL, 3967243685UL, 2646012002UL, 1784678658UL, 741302051UL, 3464753547UL, 194213376UL, 1482799064UL, 3009673860UL, 680824208UL, 741966796UL, 2381283369UL, 3022877171UL, 1619439814UL, 3961433610UL, 1331297670UL, 1100110820UL, 1311672539UL, 1122110615UL, 
4056004850UL, 3413790176UL, 3148768822UL, 1242592694UL, 2925975727UL, 1879285134UL, 334328879UL, 1318235222UL, 3140739559UL, 401691770UL, 3604288404UL, 3686496908UL, 770670945UL, 199139043UL, 2092710473UL, 3914528993UL, 700991333UL, 2375775811UL, 858137308UL, 3490050165UL, 2389078291UL, 1615607459UL, 3027969809UL, 820012549UL, 2085659484UL, 2654485136UL, 2630408646UL, 196481396UL, 1119673274UL, 1026209692UL, 726501622UL, 2940737143UL, 
3559571163UL, 2288027726UL, 1039212708UL, 929664536UL, 1061981465UL, 186058675UL, 3537656152UL, 844176796UL, 2996217992UL, 1545798611UL, 3031020656UL, 2248030435UL, 1665857580UL, 2905758082UL, 1269201312UL, 3031275084UL, 4034872841UL, 983632400UL, 4188503190UL, 757119675UL, 2105920865UL, 4281032819UL, 2917801076UL, 3900010013UL, 3910997169UL, 1729751422UL, 562313247UL, 3070846353UL, 2564238664UL, 4050540186UL, 4258833501UL, 2270666053UL, 
2207128401UL, 2990540001UL, 797768898UL, 2288390225UL, 3230323685UL, 1974727440UL, 3327301426UL, 289857826UL, 3565889868UL, 2791014422UL, 2021097820UL, 3350378271UL, 3673707591UL, 2610067927UL, 4255789547UL, 2682856590UL, 12563128UL, 1397542366UL, 237149400UL, 2233707508UL, 3875573245UL, 2097374144UL, 175320773UL, 4103445984UL, 4089284323UL, 3610168130UL, 3084915964UL, 680145366UL, 2571684685UL, 1132894909UL, 104640024UL, 193765521UL, 
2338202907UL, 895271448UL, 11499099UL, 1798066417UL, 1297412626UL, 2511347162UL, 3140535007UL, 2129963538UL, 700683199UL, 2609700278UL, 2953463279UL, 2290844145UL, 1871316353UL, 3993801787UL, 2219413182UL, 2954453701UL, 231283580UL, 1375331115UL, 207723994UL, 1799562537UL, 2056553564UL, 2513609799UL, 3542459627UL, 3173012714UL, 3923404932UL, 217877755UL, 2095124912UL, 192024370UL, 1168134987UL, 1889598668UL, 3014873069UL, 2033573343UL, 
},
{
3465348660UL, 3623545008UL, 3505902593UL, 838034830UL, 1338018789UL, 2595329276UL, 3367746385UL, 3197935201UL, 1439351946UL, 3585085571UL, 4165798087UL, 3634792639UL, 2359485974UL, 2772582925UL, 1110186203UL, 3771562484UL, 1508694157UL, 1564641206UL, 2801985736UL, 2446107936UL, 3849126897UL, 1842973671UL, 944408104UL, 2624631280UL, 2729080685UL, 3737368614UL, 858809173UL, 2289802345UL, 2428186575UL, 3114742765UL, 716011303UL, 3443810690UL, 
814132610UL, 517432787UL, 614445393UL, 2930433345UL, 291178098UL, 2117644502UL, 2749446703UL, 311745701UL, 365684723UL, 1705418876UL, 2213749318UL, 4011417220UL, 1842575651UL, 988348831UL, 94258998UL, 2771150272UL, 498058526UL, 1344827813UL, 2961955291UL, 262703473UL, 1404034822UL, 1566595865UL, 2522381203UL, 1706522206UL, 1203054806UL, 1273801539UL, 2070583465UL, 3913449936UL, 3231505231UL, 619636751UL, 3746997351UL, 4103027837UL, 
1205468203UL, 3355878253UL, 3433356888UL, 107785753UL, 2779092609UL, 1869691566UL, 2555219983UL, 903319808UL, 3273374169UL, 2538926990UL, 979533870UL, 1356500860UL, 1661983738UL, 1380761625UL, 2919458459UL, 1041142798UL, 1430817627UL, 517007606UL, 1421570516UL, 2371447300UL, 2985632691UL, 3684889351UL, 3873926653UL, 788770697UL, 1854750277UL, 209332297UL, 1137299679UL, 848527832UL, 3850486924UL, 4179307312UL, 2764470693UL, 1353191605UL, 
4166891919UL, 2074703841UL, 3373997532UL, 2013528640UL, 701389744UL, 841917592UL, 2065742268UL, 2721848192UL, 2566956680UL, 3122896007UL, 1090761479UL, 921859028UL, 4086736376UL, 1837462309UL, 2579826431UL, 2436217134UL, 839037727UL, 1072086642UL, 614518622UL, 3764758228UL, 1501128342UL, 3669108708UL, 1601407381UL, 2899014005UL, 3268308948UL, 3337564231UL, 1986911578UL, 3379194930UL, 1950365753UL, 2098537451UL, 51515980UL, 1176526086UL, 
3213391582UL, 1059745735UL, 2273586703UL, 376085505UL, 1493749800UL, 3970342143UL, 1620925244UL, 2165301314UL, 2332030190UL, 1864098798UL, 276747442UL, 2776569227UL, 2992780663UL, 3027279789UL, 1074555384UL, 3481518659UL, 2499703783UL, 661805703UL, 3782305562UL, 9186074UL, 2357407210UL, 2355922343UL, 2024733363UL, 485434612UL, 862379913UL, 1029706268UL, 1512726310UL, 3834948354UL, 1435892840UL, 3297980694UL, 2831553800UL, 2111416471UL, 
711321697UL, 3465348660UL, 3623545008UL, 3505902593UL, 838034830UL, 1553436793UL, 2595329276UL, 3367746385UL, 3197935201UL, 1439351946UL, 3198044157UL, 4165798087UL, 3634792639UL, 2359485974UL, 2772582925UL, 836042976UL, 3771562484UL, 1508694157UL, 1564641206UL, 2801985736UL, 1190371491UL, 3849126897UL, 1842973671UL, 944408104UL, 2624631280UL, 410746791UL, 3737368614UL, 858809173UL, 2289802345UL, 2428186575UL, 1542325976UL, 716011303UL, 
3443810690UL, 814132610UL, 517432787UL, 1649301063UL, 2930433345UL, 291178098UL, 2117644502UL, 2749446703UL, 3955511579UL, 365684723UL, 1705418876UL, 2213749318UL, 4011417220UL, 2753632862UL, 988348831UL, 94258998UL, 2771150272UL, 498058526UL, 3314106168UL, 2961955291UL, 262703473UL, 1404034822UL, 1566595865UL, 3590367097UL, 1706522206UL, 1203054806UL, 1273801539UL, 2070583465UL, 2340683261UL, 3231505231UL, 619636751UL, 3746997351UL, 
4103027837UL, 2785398766UL, 3355878253UL, 3433356888UL, 107785753UL, 2779092609UL, 1608451840UL, 2555219983UL, 903319808UL, 3273374169UL, 2538926990UL, 645164419UL, 1356500860UL, 1661983738UL, 1380761625UL, 2919458459UL, 2260224548UL, 1430817627UL, 517007606UL, 1421570516UL, 2371447300UL, 1636004496UL, 3684889351UL, 3873926653UL, 788770697UL, 1854750277UL, 1345251011UL, 1137299679UL, 848527832UL, 3850486924UL, 4179307312UL, 3576574608UL, 
1353191605UL, 4166891919UL, 2074703841UL, 3373997532UL, 183447754UL, 701389744UL, 841917592UL, 2065742268UL, 2721848192UL, 2109289891UL, 3122896007UL, 1090761479UL, 921859028UL, 4086736376UL, 2212730874UL, 2579826431UL, 2436217134UL, 839037727UL, 1072086642UL, 55934784UL, 3764758228UL, 1501128342UL, 3669108708UL, 1601407381UL, 516550987UL, 3268308948UL, 3337564231UL, 1986911578UL, 3379194930UL, 3973484473UL, 2098537451UL, 51515980UL, 
1176526086UL, 3213391582UL, 4251661633UL, 2273586703UL, 376085505UL, 1493749800UL, 3970342143UL, 3190791788UL, 2165301314UL, 2332030190UL, 1864098798UL, 276747442UL, 2991976613UL, 2992780663UL, 3027279789UL, 1074555384UL, 3481518659UL, 1399789494UL, 661805703UL, 3782305562UL, 9186074UL, 2357407210UL, 1942736967UL, 2024733363UL, 485434612UL, 862379913UL, 1029706268UL, 4122704494UL, 3834948354UL, 1435892840UL, 3297980694UL, 2831553800UL, 
1210092654UL, 711321697UL, 3465348660UL, 3623545008UL, 3505902593UL, 3443231198UL, 1553436793UL, 2595329276UL, 3367746385UL, 3197935201UL, 1304974987UL, 3198044157UL, 4165798087UL, 3634792639UL, 2359485974UL, 3518323362UL, 836042976UL, 3771562484UL, 1508694157UL, 1564641206UL, 3577633375UL, 1190371491UL, 3849126897UL, 1842973671UL, 944408104UL, 1854555112UL, 410746791UL, 3737368614UL, 858809173UL, 2289802345UL, 3622671731UL, 1542325976UL, 
716011303UL, 3443810690UL, 814132610UL, 296197011UL, 1649301063UL, 2930433345UL, 291178098UL, 2117644502UL, 1056271538UL, 3955511579UL, 365684723UL, 1705418876UL, 2213749318UL, 1258535671UL, 2753632862UL, 988348831UL, 94258998UL, 2771150272UL, 3669902097UL, 3314106168UL, 2961955291UL, 262703473UL, 1404034822UL, 1654433938UL, 3590367097UL, 1706522206UL, 1203054806UL, 1273801539UL, 2448138887UL, 2340683261UL, 3231505231UL, 619636751UL, 
3746997351UL, 1454088394UL, 2785398766UL, 3355878253UL, 3433356888UL, 107785753UL, 689323470UL, 1608451840UL, 2555219983UL, 903319808UL, 3273374169UL, 1603842392UL, 645164419UL, 1356500860UL, 1661983738UL, 1380761625UL, 2814639423UL, 2260224548UL, 1430817627UL, 517007606UL, 1421570516UL, 1938805701UL, 1636004496UL, 3684889351UL, 3873926653UL, 788770697UL, 4238900666UL, 1345251011UL, 1137299679UL, 848527832UL, 3850486924UL, 108793827UL, 
3576574608UL, 1353191605UL, 4166891919UL, 2074703841UL, 3780897861UL, 183447754UL, 701389744UL, 841917592UL, 2065742268UL, 3036602746UL, 2109289891UL, 3122896007UL, 1090761479UL, 921859028UL, 3499985398UL, 2212730874UL, 2579826431UL, 2436217134UL, 839037727UL, 3520354700UL, 55934784UL, 3764758228UL, 1501128342UL, 3669108708UL, 1601010847UL, 516550987UL, 3268308948UL, 3337564231UL, 1986911578UL, 2704241781UL, 3973484473UL, 2098537451UL, 
51515980UL, 1176526086UL, 3602010532UL, 4251661633UL, 2273586703UL, 376085505UL, 1493749800UL, 2922957328UL, 3190791788UL, 2165301314UL, 2332030190UL, 1864098798UL, 1649666443UL, 2991976613UL, 2992780663UL, 3027279789UL, 1074555384UL, 2848531519UL, 1399789494UL, 661805703UL, 3782305562UL, 9186074UL, 320781315UL, 1942736967UL, 2024733363UL, 485434612UL, 862379913UL, 3598892066UL, 4122704494UL, 3834948354UL, 1435892840UL, 3297980694UL, 
545184652UL, 1210092654UL, 711321697UL, 3465348660UL, 3623545008UL, 1173753045UL, 3443231198UL, 1553436793UL, 2595329276UL, 3367746385UL, 2444634476UL, 1304974987UL, 3198044157UL, 4165798087UL, 3634792639UL, 1837035806UL, 3518323362UL, 836042976UL, 3771562484UL, 1508694157UL, 2899021294UL, 3577633375UL, 1190371491UL, 3849126897UL, 1842973671UL, 1614215215UL, 1854555112UL, 410746791UL, 3737368614UL, 858809173UL, 525745365UL, 3622671731UL, 
1542325976UL, 716011303UL, 3443810690UL, 566299749UL, 296197011UL, 1649301063UL, 2930433345UL, 291178098UL, 1987532525UL, 1056271538UL, 3955511579UL, 365684723UL, 1705418876UL, 2321222760UL, 1258535671UL, 2753632862UL, 988348831UL, 94258998UL, 2986060366UL, 3669902097UL, 3314106168UL, 2961955291UL, 262703473UL, 604452796UL, 1654433938UL, 3590367097UL, 1706522206UL, 1203054806UL, 1894894069UL, 2448138887UL, 2340683261UL, 3231505231UL, 
619636751UL, 6680729UL, 1454088394UL, 2785398766UL, 3355878253UL, 3433356888UL, 2025591660UL, 689323470UL, 1608451840UL, 2555219983UL, 903319808UL, 3430384385UL, 1603842392UL, 645164419UL, 1356500860UL, 1661983738UL, 2108736152UL, 2814639423UL, 2260224548UL, 1430817627UL, 517007606UL, 2973658959UL, 1938805701UL, 1636004496UL, 3684889351UL, 3873926653UL, 2283691941UL, 4238900666UL, 1345251011UL, 1137299679UL, 848527832UL, 45551112UL, 
108793827UL, 3576574608UL, 1353191605UL, 4166891919UL, 3776615962UL, 3780897861UL, 183447754UL, 701389744UL, 841917592UL, 3830639316UL, 3036602746UL, 2109289891UL, 3122896007UL, 1090761479UL, 1931255897UL, 3499985398UL, 2212730874UL, 2579826431UL, 2436217134UL, 3272166055UL, 3520354700UL, 55934784UL, 3764758228UL, 1501128342UL, 1567864246UL, 1601010847UL, 516550987UL, 3268308948UL, 3337564231UL, 3918802424UL, 2704241781UL, 3973484473UL, 
2098537451UL, 51515980UL, 3551394489UL, 3602010532UL, 4251661633UL, 2273586703UL, 376085505UL, 885459498UL, 2922957328UL, 3190791788UL, 2165301314UL, 2332030190UL, 3197056515UL, 1649666443UL, 2991976613UL, 2992780663UL, 3027279789UL, 2385348906UL, 2848531519UL, 1399789494UL, 661805703UL, 3782305562UL, 2163075465UL, 320781315UL, 1942736967UL, 2024733363UL, 485434612UL, 2680597981UL, 3598892066UL, 4122704494UL, 3834948354UL, 1435892840UL, 
2499644163UL, 2704575422UL, 2579557838UL, 673530532UL, 493730767UL, 1124557747UL, 1908629439UL, 2821949504UL, 1743112513UL, 2849457841UL, 2344409314UL, 3479159262UL, 4260973770UL, 2991970754UL, 3812641863UL, 2229319917UL, 2466968521UL, 1766353737UL, 3216591612UL, 2113272648UL, 364370737UL, 1893001758UL, 2608875275UL, 4224057183UL, 3546705413UL, 1999778009UL, 348872225UL, 2470564216UL, 1417878284UL, 2709790112UL, 3579129936UL, 2137971615UL, 
4046639861UL, 2841156930UL, 391544737UL, 2056567354UL, 737657378UL, 3877904725UL, 578930752UL, 1759172471UL, 3383278785UL, 1047197514UL, 649468151UL, 3452867243UL, 1792089520UL, 63936215UL, 3909143729UL, 3753489875UL, 734314122UL, 2490530916UL, 3043874586UL, 1504812057UL, 59001199UL, 2493748676UL, 2552438622UL, 1889694845UL, 3715397860UL, 2817245010UL, 3841049206UL, 816106718UL, 2176130406UL, 640254735UL, 12376903UL, 3000264936UL, 
3304116079UL, 1620334094UL, 2109391765UL, 1348210951UL, 2237645681UL, 1207768272UL, 1562894669UL, 2156631655UL, 1387193235UL, 3154858817UL, 633510901UL, 2312190757UL, 402878244UL, 2501565021UL, 2984409334UL, 4167491216UL, 3614267292UL, 3078552271UL, 971722322UL, 3065543880UL, 2307584190UL, 491480322UL, 2068673112UL, 1929780632UL, 178549964UL, 983979983UL, 2769314886UL, 4214442042UL, 2977609682UL, 25450683UL, 3075212658UL, 1571149568UL, 
3531670561UL, 42782504UL, 425601306UL, 428715214UL, 497250251UL, 693520802UL, 166426814UL, 1786382125UL, 2712003995UL, 3610802197UL, 2076490757UL, 404822980UL, 3953184772UL, 1655231947UL, 3594351577UL, 3068232274UL, 3771730346UL, 4110519574UL, 3534704897UL, 2375277865UL, 3597780202UL, 3472676002UL, 1350276449UL, 3218248239UL, 3589255283UL, 3253132633UL, 1769885529UL, 3792812294UL, 120332643UL, 1219374788UL, 3608889019UL, 2386099811UL, 
858495304UL, 1284785543UL, 331370962UL, 2259419662UL, 2519864134UL, 3194739432UL, 2669074511UL, 2565559140UL, 3378072004UL, 2647801475UL, 265068954UL, 1464416963UL, 1232787612UL, 4160089759UL, 2510685972UL, 670300081UL, 2509357766UL, 1981891975UL, 4161588397UL, 1371924626UL, 44760868UL, 634955171UL, 1187096933UL, 3324788972UL, 3576888559UL, 2801347752UL, 3730298395UL, 1702170762UL, 4206083415UL, 741409141UL, 3649731355UL, 1025429529UL, 
},
{
91444490UL, 628576944UL, 4069219862UL, 2253058925UL, 492354082UL, 1191182242UL, 1565180119UL, 2257613723UL, 456055162UL, 605712223UL, 953365104UL, 3104638527UL, 1133984729UL, 2662828416UL, 2134948274UL, 1921384447UL, 843719355UL, 588432962UL, 1734575434UL, 2924140067UL, 483396548UL, 3848838894UL, 3155476556UL, 1760928304UL, 4168059840UL, 3279827269UL, 2644461735UL, 4168565656UL, 3951563569UL, 1276805504UL, 1708974143UL, 1878547888UL, 
3465220024UL, 3062086782UL, 2801401651UL, 1510428126UL, 716404149UL, 1646021208UL, 3534932385UL, 1186585561UL, 651997355UL, 282914223UL, 352224857UL, 3764407517UL, 1059868753UL, 1971798134UL, 978904005UL, 976413661UL, 4039544152UL, 498989693UL, 2565125471UL, 2782642813UL, 3537961025UL, 1194967362UL, 169217024UL, 3491609UL, 1319592872UL, 1630206561UL, 2497130840UL, 1685008996UL, 2828944016UL, 3301346775UL, 2893072371UL, 2606559798UL, 
4026138031UL, 2664450619UL, 691091062UL, 1079640113UL, 1417637732UL, 4081852209UL, 2197910648UL, 2310382370UL, 1000957047UL, 959936499UL, 2844551811UL, 2272766890UL, 31122394UL, 2742925483UL, 1121884686UL, 57929089UL, 2468361281UL, 2982007782UL, 2371576893UL, 177782593UL, 3603584577UL, 672057044UL, 2108452841UL, 1671338057UL, 3386908223UL, 1243029765UL, 805157552UL, 1271858417UL, 1621249501UL, 1804851492UL, 1321010403UL, 751773221UL, 
1517221627UL, 822709871UL, 104533154UL, 3578182264UL, 640541709UL, 421086624UL, 4233576392UL, 3729339369UL, 197460644UL, 773140636UL, 2158026018UL, 1756785611UL, 4011575991UL, 3569445500UL, 736117181UL, 2456162322UL, 1168189787UL, 3651312675UL, 1070291988UL, 268231205UL, 541474497UL, 3316168972UL, 3546990856UL, 830417208UL, 725960194UL, 2044207227UL, 3188997938UL, 2383298579UL, 3350316374UL, 3575011225UL, 1553111865UL, 1285013027UL, 
749371711UL, 766611716UL, 598195098UL, 2139882719UL, 2062405428UL, 3634702446UL, 3015263295UL, 223311969UL, 2622859522UL, 3888492701UL, 2955257225UL, 582625650UL, 3563756446UL, 2886083960UL, 1907546514UL, 454650902UL, 3287277541UL, 625828138UL, 2991888140UL, 1935326370UL, 4031152256UL, 702881509UL, 1427632724UL, 1345475301UL, 2577560804UL, 2858595147UL, 2533191188UL, 185662179UL, 536505093UL, 3747894147UL, 111551030UL, 370373207UL, 
2293908590UL, 91444490UL, 628576944UL, 4069219862UL, 2253058925UL, 1671484924UL, 1191182242UL, 1565180119UL, 2257613723UL, 456055162UL, 3411094744UL, 953365104UL, 3104638527UL, 1133984729UL, 2662828416UL, 2000630022UL, 1921384447UL, 843719355UL, 588432962UL, 1734575434UL, 3293926122UL, 483396548UL, 3848838894UL, 3155476556UL, 1760928304UL, 146876953UL, 3279827269UL, 2644461735UL, 4168565656UL, 3951563569UL, 3976156700UL, 1708974143UL, 
1878547888UL, 3465220024UL, 3062086782UL, 1999154400UL, 1510428126UL, 716404149UL, 1646021208UL, 3534932385UL, 2479551429UL, 651997355UL, 282914223UL, 352224857UL, 3764407517UL, 1275979651UL, 1971798134UL, 978904005UL, 976413661UL, 4039544152UL, 300654823UL, 2565125471UL, 2782642813UL, 3537961025UL, 1194967362UL, 3123973648UL, 3491609UL, 1319592872UL, 1630206561UL, 2497130840UL, 1437913158UL, 2828944016UL, 3301346775UL, 2893072371UL, 
2606559798UL, 2153172585UL, 2664450619UL, 691091062UL, 1079640113UL, 1417637732UL, 17137237UL, 2197910648UL, 2310382370UL, 1000957047UL, 959936499UL, 802137134UL, 2272766890UL, 31122394UL, 2742925483UL, 1121884686UL, 3909775167UL, 2468361281UL, 2982007782UL, 2371576893UL, 177782593UL, 3319492525UL, 672057044UL, 2108452841UL, 1671338057UL, 3386908223UL, 1878151473UL, 805157552UL, 1271858417UL, 1621249501UL, 1804851492UL, 3215921223UL, 
751773221UL, 1517221627UL, 822709871UL, 104533154UL, 361845001UL, 640541709UL, 421086624UL, 4233576392UL, 3729339369UL, 2655936801UL, 773140636UL, 2158026018UL, 1756785611UL, 4011575991UL, 587202971UL, 736117181UL, 2456162322UL, 1168189787UL, 3651312675UL, 2517883370UL, 268231205UL, 541474497UL, 3316168972UL, 3546990856UL, 2037251305UL, 725960194UL, 2044207227UL, 3188997938UL, 2383298579UL, 2665008587UL, 3575011225UL, 1553111865UL, 
1285013027UL, 749371711UL, 2163964019UL, 598195098UL, 2139882719UL, 2062405428UL, 3634702446UL, 2788202059UL, 223311969UL, 2622859522UL, 3888492701UL, 2955257225UL, 740986174UL, 3563756446UL, 2886083960UL, 1907546514UL, 454650902UL, 2426323587UL, 625828138UL, 2991888140UL, 1935326370UL, 4031152256UL, 1831149435UL, 1427632724UL, 1345475301UL, 2577560804UL, 2858595147UL, 3977153945UL, 185662179UL, 536505093UL, 3747894147UL, 111551030UL, 
4131587422UL, 2293908590UL, 91444490UL, 628576944UL, 4069219862UL, 2408189350UL, 1671484924UL, 1191182242UL, 1565180119UL, 2257613723UL, 1338069254UL, 3411094744UL, 953365104UL, 3104638527UL, 1133984729UL, 631497759UL, 2000630022UL, 1921384447UL, 843719355UL, 588432962UL, 3280318959UL, 3293926122UL, 483396548UL, 3848838894UL, 3155476556UL, 1777918163UL, 146876953UL, 3279827269UL, 2644461735UL, 4168565656UL, 2786264663UL, 3976156700UL, 
1708974143UL, 1878547888UL, 3465220024UL, 2793923820UL, 1999154400UL, 1510428126UL, 716404149UL, 1646021208UL, 3102243824UL, 2479551429UL, 651997355UL, 282914223UL, 352224857UL, 3767702588UL, 1275979651UL, 1971798134UL, 978904005UL, 976413661UL, 1951622548UL, 300654823UL, 2565125471UL, 2782642813UL, 3537961025UL, 2186817324UL, 3123973648UL, 3491609UL, 1319592872UL, 1630206561UL, 1075424534UL, 1437913158UL, 2828944016UL, 3301346775UL, 
2893072371UL, 207992406UL, 2153172585UL, 2664450619UL, 691091062UL, 1079640113UL, 3114255216UL, 17137237UL, 2197910648UL, 2310382370UL, 1000957047UL, 2548008553UL, 802137134UL, 2272766890UL, 31122394UL, 2742925483UL, 4069482373UL, 3909775167UL, 2468361281UL, 2982007782UL, 2371576893UL, 2807823912UL, 3319492525UL, 672057044UL, 2108452841UL, 1671338057UL, 12831353UL, 1878151473UL, 805157552UL, 1271858417UL, 1621249501UL, 461887094UL, 
3215921223UL, 751773221UL, 1517221627UL, 822709871UL, 1317394918UL, 361845001UL, 640541709UL, 421086624UL, 4233576392UL, 3385587450UL, 2655936801UL, 773140636UL, 2158026018UL, 1756785611UL, 1475601973UL, 587202971UL, 736117181UL, 2456162322UL, 1168189787UL, 911455077UL, 2517883370UL, 268231205UL, 541474497UL, 3316168972UL, 1500275507UL, 2037251305UL, 725960194UL, 2044207227UL, 3188997938UL, 2036633808UL, 2665008587UL, 3575011225UL, 
1553111865UL, 1285013027UL, 87868216UL, 2163964019UL, 598195098UL, 2139882719UL, 2062405428UL, 517907301UL, 2788202059UL, 223311969UL, 2622859522UL, 3888492701UL, 3926046234UL, 740986174UL, 3563756446UL, 2886083960UL, 1907546514UL, 1911066215UL, 2426323587UL, 625828138UL, 2991888140UL, 1935326370UL, 2031853435UL, 1831149435UL, 1427632724UL, 1345475301UL, 2577560804UL, 3509674153UL, 3977153945UL, 185662179UL, 536505093UL, 3747894147UL, 
1711714600UL, 4131587422UL, 2293908590UL, 91444490UL, 628576944UL, 3370678255UL, 2408189350UL, 1671484924UL, 1191182242UL, 1565180119UL, 3786239592UL, 1338069254UL, 3411094744UL, 953365104UL, 3104638527UL, 3659647225UL, 631497759UL, 2000630022UL, 1921384447UL, 843719355UL, 3364831282UL, 3280318959UL, 3293926122UL, 483396548UL, 3848838894UL, 3131266478UL, 1777918163UL, 146876953UL, 3279827269UL, 2644461735UL, 4156372383UL, 2786264663UL, 
3976156700UL, 1708974143UL, 1878547888UL, 2168041590UL, 2793923820UL, 1999154400UL, 1510428126UL, 716404149UL, 3392113666UL, 3102243824UL, 2479551429UL, 651997355UL, 282914223UL, 2085613514UL, 3767702588UL, 1275979651UL, 1971798134UL, 978904005UL, 503506384UL, 1951622548UL, 300654823UL, 2565125471UL, 2782642813UL, 1458431750UL, 2186817324UL, 3123973648UL, 3491609UL, 1319592872UL, 452433679UL, 1075424534UL, 1437913158UL, 2828944016UL, 
3301346775UL, 2333281307UL, 207992406UL, 2153172585UL, 2664450619UL, 691091062UL, 3553502652UL, 3114255216UL, 17137237UL, 2197910648UL, 2310382370UL, 3153689868UL, 2548008553UL, 802137134UL, 2272766890UL, 31122394UL, 468580641UL, 4069482373UL, 3909775167UL, 2468361281UL, 2982007782UL, 1445286890UL, 2807823912UL, 3319492525UL, 672057044UL, 2108452841UL, 1755577669UL, 12831353UL, 1878151473UL, 805157552UL, 1271858417UL, 2623540912UL, 
461887094UL, 3215921223UL, 751773221UL, 1517221627UL, 3922191946UL, 1317394918UL, 361845001UL, 640541709UL, 421086624UL, 2173849516UL, 3385587450UL, 2655936801UL, 773140636UL, 2158026018UL, 1085377158UL, 1475601973UL, 587202971UL, 736117181UL, 2456162322UL, 2158960374UL, 911455077UL, 2517883370UL, 268231205UL, 541474497UL, 943191315UL, 1500275507UL, 2037251305UL, 725960194UL, 2044207227UL, 2481150802UL, 2036633808UL, 2665008587UL, 
3575011225UL, 1553111865UL, 2301231777UL, 87868216UL, 2163964019UL, 598195098UL, 2139882719UL, 2007840238UL, 517907301UL, 2788202059UL, 223311969UL, 2622859522UL, 151920263UL, 3926046234UL, 740986174UL, 3563756446UL, 2886083960UL, 1338937928UL, 1911066215UL, 2426323587UL, 625828138UL, 2991888140UL, 2652286195UL, 2031853435UL, 1831149435UL, 1427632724UL, 1345475301UL, 289801789UL, 3509674153UL, 3977153945UL, 185662179UL, 536505093UL, 
2727322952UL, 3980498348UL, 2529622213UL, 1903052964UL, 3564714651UL, 2281240568UL, 533384122UL, 277613480UL, 1815540358UL, 282763841UL, 3669112623UL, 2572859425UL, 195220178UL, 1210883545UL, 2359703600UL, 1187537824UL, 675732974UL, 325036095UL, 708091465UL, 2556854604UL, 701006284UL, 2378459191UL, 1863513103UL, 2690918197UL, 4237307694UL, 1356483501UL, 2160905652UL, 521809106UL, 974368613UL, 3136010957UL, 2722488678UL, 3711515637UL, 
2296341459UL, 4233729945UL, 1196247571UL, 3031398071UL, 515543502UL, 1314129776UL, 3235373306UL, 1303165859UL, 1820568009UL, 559099351UL, 186876368UL, 1076102111UL, 1218809551UL, 1790301111UL, 4130210229UL, 768125358UL, 1132864749UL, 4262563773UL, 2294411020UL, 4092943985UL, 2558108246UL, 3737664949UL, 2219923393UL, 724326159UL, 4134105682UL, 4188752746UL, 3615233671UL, 1526018731UL, 2281637916UL, 2459490295UL, 3637342666UL, 777862587UL, 
39962002UL, 3772005832UL, 997473319UL, 574843584UL, 3356551974UL, 1265234427UL, 1698059437UL, 534747571UL, 1465532164UL, 3263029035UL, 534512444UL, 2343092827UL, 2375685652UL, 2497926141UL, 2377933621UL, 2212335180UL, 261114084UL, 172755755UL, 2737085495UL, 2225257145UL, 148605658UL, 1353911796UL, 357753009UL, 1778732943UL, 497635558UL, 4136467976UL, 2837964962UL, 4045039047UL, 2485296762UL, 1587587183UL, 4042904168UL, 3184240963UL, 
2393293696UL, 915444966UL, 2299938515UL, 3351580749UL, 506575598UL, 1541916825UL, 3465300401UL, 525927458UL, 681152801UL, 331660975UL, 3624685846UL, 2994172100UL, 3274369082UL, 3638287602UL, 815689760UL, 1710961092UL, 2775607076UL, 2175058103UL, 3252688367UL, 2936890483UL, 2746319120UL, 2736754UL, 1646031035UL, 2448701214UL, 2886833213UL, 3689830606UL, 3292798106UL, 300773646UL, 3125160783UL, 1247453205UL, 2746275624UL, 4011063775UL, 
904135764UL, 876847374UL, 366267234UL, 2541269205UL, 131376648UL, 1805948133UL, 3383589530UL, 2350119829UL, 2513170439UL, 4096158499UL, 4229211520UL, 2992048272UL, 1338522080UL, 1187391335UL, 2898563453UL, 2163088451UL, 1417971677UL, 2047421551UL, 902282791UL, 1143943232UL, 3568431811UL, 4059861993UL, 193362198UL, 2509297125UL, 3968551582UL, 2175686117UL, 3568936881UL, 1853177468UL, 2134063169UL, 2919389416UL, 1124914545UL, 1209806738UL, 
},
{
1199972651UL, 1035834631UL, 3177798370UL, 860834162UL, 3741677748UL, 3780327829UL, 1693730265UL, 1643429511UL, 559568669UL, 2758650294UL, 647308222UL, 3901603996UL, 1778653821UL, 3618523672UL, 2154201067UL, 4261179460UL, 3285764480UL, 3334002738UL, 3215795953UL, 91368462UL, 1883994950UL, 1506873376UL, 1527780962UL, 4046354597UL, 4081676034UL, 2389066602UL, 1574939945UL, 427845396UL, 2714836263UL, 1259019491UL, 2493238133UL, 2584034689UL, 
3151382431UL, 2171033919UL, 176883719UL, 2031844862UL, 1272380790UL, 1298975901UL, 4087222847UL, 1524000054UL, 311436877UL, 3627785554UL, 1889491722UL, 2938069193UL, 2771940687UL, 2756955968UL, 4289348777UL, 263514583UL, 887207028UL, 3522902525UL, 2273246349UL, 835377715UL, 2897243319UL, 204645450UL, 1775911983UL, 639470242UL, 2856296318UL, 3032942383UL, 2845501282UL, 1979082575UL, 202834023UL, 1876303820UL, 1434703409UL, 4240524132UL, 
848853780UL, 4188621628UL, 928095314UL, 876412914UL, 3446576392UL, 3235688990UL, 4021419931UL, 2483628986UL, 3155781890UL, 399997246UL, 1642535200UL, 3872575068UL, 1577956550UL, 3606228634UL, 609914462UL, 653194726UL, 4048067248UL, 2500767965UL, 1125167825UL, 3707628088UL, 1819135158UL, 1875618971UL, 3865851141UL, 328215079UL, 1695889194UL, 2040280471UL, 3384684457UL, 2540504961UL, 293050253UL, 525570078UL, 2655676443UL, 1392199429UL, 
3370444585UL, 1937915855UL, 2229636250UL, 247937142UL, 2534538765UL, 365841057UL, 2449431033UL, 2456532429UL, 101910696UL, 1247069485UL, 1523958293UL, 2473285670UL, 473709728UL, 3026667113UL, 2071968844UL, 324025193UL, 423064436UL, 3870800061UL, 3977393138UL, 3632553233UL, 352757977UL, 1584833348UL, 3173248650UL, 1159857686UL, 1501841977UL, 1751860798UL, 617281070UL, 1958012761UL, 4031667102UL, 3232142321UL, 3087428595UL, 2380824676UL, 
1194087757UL, 1542961747UL, 4163350364UL, 1721646249UL, 1672791861UL, 2900511710UL, 24973500UL, 1705444176UL, 713642505UL, 3017719513UL, 2090715200UL, 3521434070UL, 37117223UL, 1948295454UL, 3055840561UL, 3476120789UL, 3994249388UL, 527899063UL, 4285770666UL, 1075524023UL, 2594223535UL, 392943522UL, 171012646UL, 3515750082UL, 3414659054UL, 3501852926UL, 1493283737UL, 2662104279UL, 2033464928UL, 90134967UL, 363058647UL, 3289266998UL, 
2470752727UL, 1199972651UL, 1035834631UL, 3177798370UL, 860834162UL, 1791097822UL, 3780327829UL, 1693730265UL, 1643429511UL, 559568669UL, 3503319486UL, 647308222UL, 3901603996UL, 1778653821UL, 3618523672UL, 4294594427UL, 4261179460UL, 3285764480UL, 3334002738UL, 3215795953UL, 212518363UL, 1883994950UL, 1506873376UL, 1527780962UL, 4046354597UL, 2398655600UL, 2389066602UL, 1574939945UL, 427845396UL, 2714836263UL, 2744363872UL, 2493238133UL, 
2584034689UL, 3151382431UL, 2171033919UL, 2787053497UL, 2031844862UL, 1272380790UL, 1298975901UL, 4087222847UL, 2342953154UL, 311436877UL, 3627785554UL, 1889491722UL, 2938069193UL, 2026656505UL, 2756955968UL, 4289348777UL, 263514583UL, 887207028UL, 2097276163UL, 2273246349UL, 835377715UL, 2897243319UL, 204645450UL, 4233399907UL, 639470242UL, 2856296318UL, 3032942383UL, 2845501282UL, 28260330UL, 202834023UL, 1876303820UL, 1434703409UL, 
4240524132UL, 2455670466UL, 4188621628UL, 928095314UL, 876412914UL, 3446576392UL, 117581687UL, 4021419931UL, 2483628986UL, 3155781890UL, 399997246UL, 4254101087UL, 3872575068UL, 1577956550UL, 3606228634UL, 609914462UL, 4003279048UL, 4048067248UL, 2500767965UL, 1125167825UL, 3707628088UL, 922020515UL, 1875618971UL, 3865851141UL, 328215079UL, 1695889194UL, 625773097UL, 3384684457UL, 2540504961UL, 293050253UL, 525570078UL, 2592805114UL, 
1392199429UL, 3370444585UL, 1937915855UL, 2229636250UL, 3190958614UL, 2534538765UL, 365841057UL, 2449431033UL, 2456532429UL, 3778669305UL, 1247069485UL, 1523958293UL, 2473285670UL, 473709728UL, 720895889UL, 2071968844UL, 324025193UL, 423064436UL, 3870800061UL, 3535536111UL, 3632553233UL, 352757977UL, 1584833348UL, 3173248650UL, 2649344603UL, 1501841977UL, 1751860798UL, 617281070UL, 1958012761UL, 778965559UL, 3232142321UL, 3087428595UL, 
2380824676UL, 1194087757UL, 3880222002UL, 4163350364UL, 1721646249UL, 1672791861UL, 2900511710UL, 702936770UL, 1705444176UL, 713642505UL, 3017719513UL, 2090715200UL, 1477858694UL, 37117223UL, 1948295454UL, 3055840561UL, 3476120789UL, 464173532UL, 527899063UL, 4285770666UL, 1075524023UL, 2594223535UL, 2872629966UL, 171012646UL, 3515750082UL, 3414659054UL, 3501852926UL, 1631555059UL, 2662104279UL, 2033464928UL, 90134967UL, 363058647UL, 
4112991722UL, 2470752727UL, 1199972651UL, 1035834631UL, 3177798370UL, 4152098951UL, 1791097822UL, 3780327829UL, 1693730265UL, 1643429511UL, 153020604UL, 3503319486UL, 647308222UL, 3901603996UL, 1778653821UL, 221887019UL, 4294594427UL, 4261179460UL, 3285764480UL, 3334002738UL, 3340918862UL, 212518363UL, 1883994950UL, 1506873376UL, 1527780962UL, 430180116UL, 2398655600UL, 2389066602UL, 1574939945UL, 427845396UL, 1683639957UL, 2744363872UL, 
2493238133UL, 2584034689UL, 3151382431UL, 752704472UL, 2787053497UL, 2031844862UL, 1272380790UL, 1298975901UL, 1528220628UL, 2342953154UL, 311436877UL, 3627785554UL, 1889491722UL, 2576495467UL, 2026656505UL, 2756955968UL, 4289348777UL, 263514583UL, 3778019638UL, 2097276163UL, 2273246349UL, 835377715UL, 2897243319UL, 1060067446UL, 4233399907UL, 639470242UL, 2856296318UL, 3032942383UL, 2351047932UL, 28260330UL, 202834023UL, 1876303820UL, 
1434703409UL, 3094305336UL, 2455670466UL, 4188621628UL, 928095314UL, 876412914UL, 3785385583UL, 117581687UL, 4021419931UL, 2483628986UL, 3155781890UL, 1867816730UL, 4254101087UL, 3872575068UL, 1577956550UL, 3606228634UL, 3081878598UL, 4003279048UL, 4048067248UL, 2500767965UL, 1125167825UL, 928465955UL, 922020515UL, 1875618971UL, 3865851141UL, 328215079UL, 173810260UL, 625773097UL, 3384684457UL, 2540504961UL, 293050253UL, 2645143254UL, 
2592805114UL, 1392199429UL, 3370444585UL, 1937915855UL, 162781360UL, 3190958614UL, 2534538765UL, 365841057UL, 2449431033UL, 3105377832UL, 3778669305UL, 1247069485UL, 1523958293UL, 2473285670UL, 800971948UL, 720895889UL, 2071968844UL, 324025193UL, 423064436UL, 52577992UL, 3535536111UL, 3632553233UL, 352757977UL, 1584833348UL, 3305908059UL, 2649344603UL, 1501841977UL, 1751860798UL, 617281070UL, 264880505UL, 778965559UL, 3232142321UL, 
3087428595UL, 2380824676UL, 1127761012UL, 3880222002UL, 4163350364UL, 1721646249UL, 1672791861UL, 2368512339UL, 702936770UL, 1705444176UL, 713642505UL, 3017719513UL, 197200752UL, 1477858694UL, 37117223UL, 1948295454UL, 3055840561UL, 1588372042UL, 464173532UL, 527899063UL, 4285770666UL, 1075524023UL, 2124039914UL, 2872629966UL, 171012646UL, 3515750082UL, 3414659054UL, 818571456UL, 1631555059UL, 2662104279UL, 2033464928UL, 90134967UL, 
952712086UL, 4112991722UL, 2470752727UL, 1199972651UL, 1035834631UL, 888975816UL, 4152098951UL, 1791097822UL, 3780327829UL, 1693730265UL, 3406785510UL, 153020604UL, 3503319486UL, 647308222UL, 3901603996UL, 3753248472UL, 221887019UL, 4294594427UL, 4261179460UL, 3285764480UL, 1861431346UL, 3340918862UL, 212518363UL, 1883994950UL, 1506873376UL, 2695939612UL, 430180116UL, 2398655600UL, 2389066602UL, 1574939945UL, 2852159074UL, 1683639957UL, 
2744363872UL, 2493238133UL, 2584034689UL, 1952065633UL, 752704472UL, 2787053497UL, 2031844862UL, 1272380790UL, 3530505866UL, 1528220628UL, 2342953154UL, 311436877UL, 3627785554UL, 3410473245UL, 2576495467UL, 2026656505UL, 2756955968UL, 4289348777UL, 2856163034UL, 3778019638UL, 2097276163UL, 2273246349UL, 835377715UL, 3127280755UL, 1060067446UL, 4233399907UL, 639470242UL, 2856296318UL, 2615775011UL, 2351047932UL, 28260330UL, 202834023UL, 
1876303820UL, 619308202UL, 3094305336UL, 2455670466UL, 4188621628UL, 928095314UL, 3764894047UL, 3785385583UL, 117581687UL, 4021419931UL, 2483628986UL, 3759839215UL, 1867816730UL, 4254101087UL, 3872575068UL, 1577956550UL, 1687107439UL, 3081878598UL, 4003279048UL, 4048067248UL, 2500767965UL, 2804044146UL, 928465955UL, 922020515UL, 1875618971UL, 3865851141UL, 2359176389UL, 173810260UL, 625773097UL, 3384684457UL, 2540504961UL, 3665420733UL, 
2645143254UL, 2592805114UL, 1392199429UL, 3370444585UL, 1604709429UL, 162781360UL, 3190958614UL, 2534538765UL, 365841057UL, 3843585067UL, 3105377832UL, 3778669305UL, 1247069485UL, 1523958293UL, 293374051UL, 800971948UL, 720895889UL, 2071968844UL, 324025193UL, 3342361801UL, 52577992UL, 3535536111UL, 3632553233UL, 352757977UL, 1386594581UL, 3305908059UL, 2649344603UL, 1501841977UL, 1751860798UL, 3160423601UL, 264880505UL, 778965559UL, 
3232142321UL, 3087428595UL, 3814775120UL, 1127761012UL, 3880222002UL, 4163350364UL, 1721646249UL, 3640773034UL, 2368512339UL, 702936770UL, 1705444176UL, 713642505UL, 1717761787UL, 197200752UL, 1477858694UL, 37117223UL, 1948295454UL, 896215772UL, 1588372042UL, 464173532UL, 527899063UL, 4285770666UL, 3441409029UL, 2124039914UL, 2872629966UL, 171012646UL, 3515750082UL, 2216687886UL, 818571456UL, 1631555059UL, 2662104279UL, 2033464928UL, 
369438400UL, 329003658UL, 1503365029UL, 4215790910UL, 3264377550UL, 733526983UL, 2935318632UL, 1792331479UL, 608347530UL, 392723097UL, 1330445854UL, 3473004271UL, 1267636682UL, 2150566972UL, 2664910943UL, 2591861637UL, 409769584UL, 2943326880UL, 3746302819UL, 3162268832UL, 1028663260UL, 3206607045UL, 832105292UL, 2119405275UL, 538318455UL, 2981192295UL, 861775416UL, 609718403UL, 3531204230UL, 1904759571UL, 1262633751UL, 2375133081UL, 
460454984UL, 946700253UL, 3763898311UL, 1571175213UL, 3124410107UL, 2413420216UL, 2664177543UL, 3241803820UL, 3968067371UL, 1234860999UL, 1130471500UL, 772727786UL, 247203117UL, 576455235UL, 246297007UL, 2027348597UL, 764933887UL, 3812479771UL, 1825807084UL, 4072281412UL, 2156865781UL, 1286484847UL, 1966749063UL, 2479269303UL, 423506843UL, 3070938758UL, 653091413UL, 2267423132UL, 2004263526UL, 1374490719UL, 3871990628UL, 841138314UL, 
1260317857UL, 3887432433UL, 4025147569UL, 764233331UL, 1794763428UL, 3005903468UL, 877926770UL, 2466593927UL, 2971729561UL, 3203070565UL, 4198500026UL, 815665759UL, 2434508139UL, 1840456368UL, 2279000427UL, 17077200UL, 3178380570UL, 990304199UL, 3578008580UL, 1965763660UL, 1640352477UL, 750159594UL, 2047409402UL, 3576308245UL, 544920564UL, 1730124869UL, 1194761386UL, 3280315505UL, 147334027UL, 2870674244UL, 2076860776UL, 1100947675UL, 
2482772161UL, 401966468UL, 1610650855UL, 193868446UL, 3808157106UL, 1509130117UL, 1324484736UL, 3852893217UL, 1059179497UL, 4053543778UL, 2557844172UL, 3282312002UL, 682550058UL, 4281899173UL, 137171998UL, 3239159214UL, 2258610918UL, 426724741UL, 3502660993UL, 135977383UL, 429929363UL, 3984458137UL, 964026748UL, 2182019070UL, 3836562946UL, 515026869UL, 359030455UL, 1301694917UL, 2300414803UL, 2364654981UL, 3804876710UL, 171119249UL, 
2646785698UL, 4283509387UL, 3628087763UL, 1748227044UL, 3037141234UL, 3000413256UL, 23007314UL, 3598880509UL, 4160517314UL, 112205578UL, 1677675411UL, 734881643UL, 2830770338UL, 3470317145UL, 3306806569UL, 2635040943UL, 2671367560UL, 3528996498UL, 3878886478UL, 3114253828UL, 2721384408UL, 3175226991UL, 1393767271UL, 2651623266UL, 3767978376UL, 1269699398UL, 1100964192UL, 4169085845UL, 2086718107UL, 1286251099UL, 764751784UL, 3006878591UL, 
},

};

static unsigned int precalc_xorwow_offset_matrix_host[8][800] = {
{
0UL, 0UL, 0UL, 0UL, 3UL, 0UL, 0UL, 0UL, 0UL, 6UL, 0UL, 0UL, 0UL, 0UL, 15UL, 0UL, 0UL, 0UL, 0UL, 30UL, 0UL, 0UL, 0UL, 0UL, 60UL, 0UL, 0UL, 0UL, 0UL, 120UL, 0UL, 0UL, 
0UL, 0UL, 240UL, 0UL, 0UL, 0UL, 0UL, 480UL, 0UL, 0UL, 0UL, 0UL, 960UL, 0UL, 0UL, 0UL, 0UL, 1920UL, 0UL, 0UL, 0UL, 0UL, 3840UL, 0UL, 0UL, 0UL, 0UL, 7680UL, 0UL, 0UL, 0UL, 0UL, 
15360UL, 0UL, 0UL, 0UL, 0UL, 30720UL, 0UL, 0UL, 0UL, 0UL, 61440UL, 0UL, 0UL, 0UL, 0UL, 122880UL, 0UL, 0UL, 0UL, 0UL, 245760UL, 0UL, 0UL, 0UL, 0UL, 491520UL, 0UL, 0UL, 0UL, 0UL, 983040UL, 0UL, 
0UL, 0UL, 0UL, 1966080UL, 0UL, 0UL, 0UL, 0UL, 3932160UL, 0UL, 0UL, 0UL, 0UL, 7864320UL, 0UL, 0UL, 0UL, 0UL, 15728640UL, 0UL, 0UL, 0UL, 0UL, 31457280UL, 0UL, 0UL, 0UL, 0UL, 62914560UL, 0UL, 0UL, 0UL, 
0UL, 125829120UL, 0UL, 0UL, 0UL, 0UL, 251658240UL, 0UL, 0UL, 0UL, 0UL, 503316480UL, 0UL, 0UL, 0UL, 0UL, 1006632960UL, 0UL, 0UL, 0UL, 0UL, 2013265920UL, 0UL, 0UL, 0UL, 0UL, 4026531840UL, 0UL, 0UL, 0UL, 0UL, 3758096384UL, 
1UL, 0UL, 0UL, 0UL, 0UL, 2UL, 0UL, 0UL, 0UL, 0UL, 4UL, 0UL, 0UL, 0UL, 0UL, 8UL, 0UL, 0UL, 0UL, 0UL, 16UL, 0UL, 0UL, 0UL, 0UL, 32UL, 0UL, 0UL, 0UL, 0UL, 64UL, 0UL, 
0UL, 0UL, 0UL, 128UL, 0UL, 0UL, 0UL, 0UL, 256UL, 0UL, 0UL, 0UL, 0UL, 512UL, 0UL, 0UL, 0UL, 0UL, 1024UL, 0UL, 0UL, 0UL, 0UL, 2048UL, 0UL, 0UL, 0UL, 0UL, 4096UL, 0UL, 0UL, 0UL, 
0UL, 8192UL, 0UL, 0UL, 0UL, 0UL, 16384UL, 0UL, 0UL, 0UL, 0UL, 32768UL, 0UL, 0UL, 0UL, 0UL, 65536UL, 0UL, 0UL, 0UL, 0UL, 131072UL, 0UL, 0UL, 0UL, 0UL, 262144UL, 0UL, 0UL, 0UL, 0UL, 524288UL, 
0UL, 0UL, 0UL, 0UL, 1048576UL, 0UL, 0UL, 0UL, 0UL, 2097152UL, 0UL, 0UL, 0UL, 0UL, 4194304UL, 0UL, 0UL, 0UL, 0UL, 8388608UL, 0UL, 0UL, 0UL, 0UL, 16777216UL, 0UL, 0UL, 0UL, 0UL, 33554432UL, 0UL, 0UL, 
0UL, 0UL, 67108864UL, 0UL, 0UL, 0UL, 0UL, 134217728UL, 0UL, 0UL, 0UL, 0UL, 268435456UL, 0UL, 0UL, 0UL, 0UL, 536870912UL, 0UL, 0UL, 0UL, 0UL, 1073741824UL, 0UL, 0UL, 0UL, 0UL, 2147483648UL, 0UL, 0UL, 0UL, 0UL, 
0UL, 1UL, 0UL, 0UL, 0UL, 0UL, 2UL, 0UL, 0UL, 0UL, 0UL, 4UL, 0UL, 0UL, 0UL, 0UL, 8UL, 0UL, 0UL, 0UL, 0UL, 16UL, 0UL, 0UL, 0UL, 0UL, 32UL, 0UL, 0UL, 0UL, 0UL, 64UL, 
0UL, 0UL, 0UL, 0UL, 128UL, 0UL, 0UL, 0UL, 0UL, 256UL, 0UL, 0UL, 0UL, 0UL, 512UL, 0UL, 0UL, 0UL, 0UL, 1024UL, 0UL, 0UL, 0UL, 0UL, 2048UL, 0UL, 0UL, 0UL, 0UL, 4096UL, 0UL, 0UL, 
0UL, 0UL, 8192UL, 0UL, 0UL, 0UL, 0UL, 16384UL, 0UL, 0UL, 0UL, 0UL, 32768UL, 0UL, 0UL, 0UL, 0UL, 65536UL, 0UL, 0UL, 0UL, 0UL, 131072UL, 0UL, 0UL, 0UL, 0UL, 262144UL, 0UL, 0UL, 0UL, 0UL, 
524288UL, 0UL, 0UL, 0UL, 0UL, 1048576UL, 0UL, 0UL, 0UL, 0UL, 2097152UL, 0UL, 0UL, 0UL, 0UL, 4194304UL, 0UL, 0UL, 0UL, 0UL, 8388608UL, 0UL, 0UL, 0UL, 0UL, 16777216UL, 0UL, 0UL, 0UL, 0UL, 33554432UL, 0UL, 
0UL, 0UL, 0UL, 67108864UL, 0UL, 0UL, 0UL, 0UL, 134217728UL, 0UL, 0UL, 0UL, 0UL, 268435456UL, 0UL, 0UL, 0UL, 0UL, 536870912UL, 0UL, 0UL, 0UL, 0UL, 1073741824UL, 0UL, 0UL, 0UL, 0UL, 2147483648UL, 0UL, 0UL, 0UL, 
0UL, 0UL, 1UL, 0UL, 0UL, 0UL, 0UL, 2UL, 0UL, 0UL, 0UL, 0UL, 4UL, 0UL, 0UL, 0UL, 0UL, 8UL, 0UL, 0UL, 0UL, 0UL, 16UL, 0UL, 0UL, 0UL, 0UL, 32UL, 0UL, 0UL, 0UL, 0UL, 
64UL, 0UL, 0UL, 0UL, 0UL, 128UL, 0UL, 0UL, 0UL, 0UL, 256UL, 0UL, 0UL, 0UL, 0UL, 512UL, 0UL, 0UL, 0UL, 0UL, 1024UL, 0UL, 0UL, 0UL, 0UL, 2048UL, 0UL, 0UL, 0UL, 0UL, 4096UL, 0UL, 
0UL, 0UL, 0UL, 8192UL, 0UL, 0UL, 0UL, 0UL, 16384UL, 0UL, 0UL, 0UL, 0UL, 32768UL, 0UL, 0UL, 0UL, 0UL, 65536UL, 0UL, 0UL, 0UL, 0UL, 131072UL, 0UL, 0UL, 0UL, 0UL, 262144UL, 0UL, 0UL, 0UL, 
0UL, 524288UL, 0UL, 0UL, 0UL, 0UL, 1048576UL, 0UL, 0UL, 0UL, 0UL, 2097152UL, 0UL, 0UL, 0UL, 0UL, 4194304UL, 0UL, 0UL, 0UL, 0UL, 8388608UL, 0UL, 0UL, 0UL, 0UL, 16777216UL, 0UL, 0UL, 0UL, 0UL, 33554432UL, 
0UL, 0UL, 0UL, 0UL, 67108864UL, 0UL, 0UL, 0UL, 0UL, 134217728UL, 0UL, 0UL, 0UL, 0UL, 268435456UL, 0UL, 0UL, 0UL, 0UL, 536870912UL, 0UL, 0UL, 0UL, 0UL, 1073741824UL, 0UL, 0UL, 0UL, 0UL, 2147483648UL, 0UL, 0UL, 
0UL, 0UL, 0UL, 1UL, 17UL, 0UL, 0UL, 0UL, 2UL, 34UL, 0UL, 0UL, 0UL, 4UL, 68UL, 0UL, 0UL, 0UL, 8UL, 136UL, 0UL, 0UL, 0UL, 16UL, 272UL, 0UL, 0UL, 0UL, 32UL, 544UL, 0UL, 0UL, 
0UL, 64UL, 1088UL, 0UL, 0UL, 0UL, 128UL, 2176UL, 0UL, 0UL, 0UL, 256UL, 4352UL, 0UL, 0UL, 0UL, 512UL, 8704UL, 0UL, 0UL, 0UL, 1024UL, 17408UL, 0UL, 0UL, 0UL, 2048UL, 34816UL, 0UL, 0UL, 0UL, 4096UL, 
69632UL, 0UL, 0UL, 0UL, 8192UL, 139264UL, 0UL, 0UL, 0UL, 16384UL, 278528UL, 0UL, 0UL, 0UL, 32768UL, 557056UL, 0UL, 0UL, 0UL, 65536UL, 1114112UL, 0UL, 0UL, 0UL, 131072UL, 2228224UL, 0UL, 0UL, 0UL, 262144UL, 4456448UL, 0UL, 
0UL, 0UL, 524288UL, 8912896UL, 0UL, 0UL, 0UL, 1048576UL, 17825792UL, 0UL, 0UL, 0UL, 2097152UL, 35651584UL, 0UL, 0UL, 0UL, 4194304UL, 71303168UL, 0UL, 0UL, 0UL, 8388608UL, 142606336UL, 0UL, 0UL, 0UL, 16777216UL, 285212672UL, 0UL, 0UL, 0UL, 
33554432UL, 570425344UL, 0UL, 0UL, 0UL, 67108864UL, 1140850688UL, 0UL, 0UL, 0UL, 134217728UL, 2281701376UL, 0UL, 0UL, 0UL, 268435456UL, 268435456UL, 0UL, 0UL, 0UL, 536870912UL, 536870912UL, 0UL, 0UL, 0UL, 1073741824UL, 1073741824UL, 0UL, 0UL, 0UL, 2147483648UL, 2147483648UL, 
},
{
0UL, 3UL, 51UL, 771UL, 13107UL, 0UL, 6UL, 102UL, 1542UL, 26214UL, 0UL, 15UL, 255UL, 3855UL, 65535UL, 0UL, 30UL, 510UL, 7710UL, 131070UL, 0UL, 60UL, 1020UL, 15420UL, 262140UL, 0UL, 120UL, 2040UL, 30840UL, 524280UL, 0UL, 240UL, 
4080UL, 61680UL, 1048560UL, 0UL, 480UL, 8160UL, 123360UL, 2097120UL, 0UL, 960UL, 16320UL, 246720UL, 4194240UL, 0UL, 1920UL, 32640UL, 493440UL, 8388480UL, 0UL, 3840UL, 65280UL, 986880UL, 16776960UL, 0UL, 7680UL, 130560UL, 1973760UL, 33553920UL, 0UL, 15360UL, 261120UL, 3947520UL, 
67107840UL, 0UL, 30720UL, 522240UL, 7895040UL, 134215680UL, 0UL, 61440UL, 1044480UL, 15790080UL, 268431360UL, 0UL, 122880UL, 2088960UL, 31580160UL, 536862720UL, 0UL, 245760UL, 4177920UL, 63160320UL, 1073725440UL, 0UL, 491520UL, 8355840UL, 126320640UL, 2147450880UL, 0UL, 983040UL, 16711680UL, 252641280UL, 4294901760UL, 0UL, 
1966080UL, 33423360UL, 505282560UL, 4294836224UL, 0UL, 3932160UL, 66846720UL, 1010565120UL, 4294705152UL, 0UL, 7864320UL, 133693440UL, 2021130240UL, 4294443008UL, 0UL, 15728640UL, 267386880UL, 4042260480UL, 4293918720UL, 0UL, 31457280UL, 534773760UL, 3789553664UL, 4292870144UL, 0UL, 62914560UL, 1069547520UL, 3284140032UL, 4290772992UL, 0UL, 125829120UL, 2139095040UL, 
2273312768UL, 4286578688UL, 0UL, 251658240UL, 4278190080UL, 251658240UL, 4278190080UL, 0UL, 503316480UL, 4261412864UL, 503316480UL, 4261412864UL, 0UL, 1006632960UL, 4227858432UL, 1006632960UL, 4227858432UL, 0UL, 2013265920UL, 4160749568UL, 2013265920UL, 4160749568UL, 0UL, 4026531840UL, 4026531840UL, 4026531840UL, 4026531840UL, 0UL, 3758096384UL, 3758096384UL, 3758096384UL, 3758096384UL, 
0UL, 0UL, 3UL, 51UL, 771UL, 0UL, 0UL, 6UL, 102UL, 1542UL, 0UL, 0UL, 15UL, 255UL, 3855UL, 0UL, 0UL, 30UL, 510UL, 7710UL, 0UL, 0UL, 60UL, 1020UL, 15420UL, 0UL, 0UL, 120UL, 2040UL, 30840UL, 0UL, 0UL, 
240UL, 4080UL, 61680UL, 0UL, 0UL, 480UL, 8160UL, 123360UL, 0UL, 0UL, 960UL, 16320UL, 246720UL, 0UL, 0UL, 1920UL, 32640UL, 493440UL, 0UL, 0UL, 3840UL, 65280UL, 986880UL, 0UL, 0UL, 7680UL, 130560UL, 1973760UL, 0UL, 0UL, 15360UL, 261120UL, 
3947520UL, 0UL, 0UL, 30720UL, 522240UL, 7895040UL, 0UL, 0UL, 61440UL, 1044480UL, 15790080UL, 0UL, 0UL, 122880UL, 2088960UL, 31580160UL, 0UL, 0UL, 245760UL, 4177920UL, 63160320UL, 0UL, 0UL, 491520UL, 8355840UL, 126320640UL, 0UL, 0UL, 983040UL, 16711680UL, 252641280UL, 0UL, 
0UL, 1966080UL, 33423360UL, 505282560UL, 0UL, 0UL, 3932160UL, 66846720UL, 1010565120UL, 0UL, 0UL, 7864320UL, 133693440UL, 2021130240UL, 0UL, 0UL, 15728640UL, 267386880UL, 4042260480UL, 0UL, 0UL, 31457280UL, 534773760UL, 3789553664UL, 0UL, 0UL, 62914560UL, 1069547520UL, 3284140032UL, 0UL, 0UL, 125829120UL, 
2139095040UL, 2273312768UL, 0UL, 0UL, 251658240UL, 4278190080UL, 251658240UL, 0UL, 0UL, 503316480UL, 4261412864UL, 503316480UL, 0UL, 0UL, 1006632960UL, 4227858432UL, 1006632960UL, 0UL, 0UL, 2013265920UL, 4160749568UL, 2013265920UL, 0UL, 0UL, 4026531840UL, 4026531840UL, 4026531840UL, 0UL, 0UL, 3758096384UL, 3758096384UL, 3758096384UL, 
0UL, 0UL, 0UL, 3UL, 51UL, 0UL, 0UL, 0UL, 6UL, 102UL, 0UL, 0UL, 0UL, 15UL, 255UL, 0UL, 0UL, 0UL, 30UL, 510UL, 0UL, 0UL, 0UL, 60UL, 1020UL, 0UL, 0UL, 0UL, 120UL, 2040UL, 0UL, 0UL, 
0UL, 240UL, 4080UL, 0UL, 0UL, 0UL, 480UL, 8160UL, 0UL, 0UL, 0UL, 960UL, 16320UL, 0UL, 0UL, 0UL, 1920UL, 32640UL, 0UL, 0UL, 0UL, 3840UL, 65280UL, 0UL, 0UL, 0UL, 7680UL, 130560UL, 0UL, 0UL, 0UL, 15360UL, 
261120UL, 0UL, 0UL, 0UL, 30720UL, 522240UL, 0UL, 0UL, 0UL, 61440UL, 1044480UL, 0UL, 0UL, 0UL, 122880UL, 2088960UL, 0UL, 0UL, 0UL, 245760UL, 4177920UL, 0UL, 0UL, 0UL, 491520UL, 8355840UL, 0UL, 0UL, 0UL, 983040UL, 16711680UL, 0UL, 
0UL, 0UL, 1966080UL, 33423360UL, 0UL, 0UL, 0UL, 3932160UL, 66846720UL, 0UL, 0UL, 0UL, 7864320UL, 133693440UL, 0UL, 0UL, 0UL, 15728640UL, 267386880UL, 0UL, 0UL, 0UL, 31457280UL, 534773760UL, 0UL, 0UL, 0UL, 62914560UL, 1069547520UL, 0UL, 0UL, 0UL, 
125829120UL, 2139095040UL, 0UL, 0UL, 0UL, 251658240UL, 4278190080UL, 0UL, 0UL, 0UL, 503316480UL, 4261412864UL, 0UL, 0UL, 0UL, 1006632960UL, 4227858432UL, 0UL, 0UL, 0UL, 2013265920UL, 4160749568UL, 0UL, 0UL, 0UL, 4026531840UL, 4026531840UL, 0UL, 0UL, 0UL, 3758096384UL, 3758096384UL, 
0UL, 0UL, 0UL, 0UL, 3UL, 0UL, 0UL, 0UL, 0UL, 6UL, 0UL, 0UL, 0UL, 0UL, 15UL, 0UL, 0UL, 0UL, 0UL, 30UL, 0UL, 0UL, 0UL, 0UL, 60UL, 0UL, 0UL, 0UL, 0UL, 120UL, 0UL, 0UL, 
0UL, 0UL, 240UL, 0UL, 0UL, 0UL, 0UL, 480UL, 0UL, 0UL, 0UL, 0UL, 960UL, 0UL, 0UL, 0UL, 0UL, 1920UL, 0UL, 0UL, 0UL, 0UL, 3840UL, 0UL, 0UL, 0UL, 0UL, 7680UL, 0UL, 0UL, 0UL, 0UL, 
15360UL, 0UL, 0UL, 0UL, 0UL, 30720UL, 0UL, 0UL, 0UL, 0UL, 61440UL, 0UL, 0UL, 0UL, 0UL, 122880UL, 0UL, 0UL, 0UL, 0UL, 245760UL, 0UL, 0UL, 0UL, 0UL, 491520UL, 0UL, 0UL, 0UL, 0UL, 983040UL, 0UL, 
0UL, 0UL, 0UL, 1966080UL, 0UL, 0UL, 0UL, 0UL, 3932160UL, 0UL, 0UL, 0UL, 0UL, 7864320UL, 0UL, 0UL, 0UL, 0UL, 15728640UL, 0UL, 0UL, 0UL, 0UL, 31457280UL, 0UL, 0UL, 0UL, 0UL, 62914560UL, 0UL, 0UL, 0UL, 
0UL, 125829120UL, 0UL, 0UL, 0UL, 0UL, 251658240UL, 0UL, 0UL, 0UL, 0UL, 503316480UL, 0UL, 0UL, 0UL, 0UL, 1006632960UL, 0UL, 0UL, 0UL, 0UL, 2013265920UL, 0UL, 0UL, 0UL, 0UL, 4026531840UL, 0UL, 0UL, 0UL, 0UL, 3758096384UL, 
1UL, 17UL, 257UL, 4369UL, 65537UL, 2UL, 34UL, 514UL, 8738UL, 131074UL, 4UL, 68UL, 1028UL, 17476UL, 262148UL, 8UL, 136UL, 2056UL, 34952UL, 524296UL, 16UL, 272UL, 4112UL, 69904UL, 1048592UL, 32UL, 544UL, 8224UL, 139808UL, 2097184UL, 64UL, 1088UL, 
16448UL, 279616UL, 4194368UL, 128UL, 2176UL, 32896UL, 559232UL, 8388736UL, 256UL, 4352UL, 65792UL, 1118464UL, 16777472UL, 512UL, 8704UL, 131584UL, 2236928UL, 33554944UL, 1024UL, 17408UL, 263168UL, 4473856UL, 67109888UL, 2048UL, 34816UL, 526336UL, 8947712UL, 134219776UL, 4096UL, 69632UL, 1052672UL, 17895424UL, 
268439552UL, 8192UL, 139264UL, 2105344UL, 35790848UL, 536879104UL, 16384UL, 278528UL, 4210688UL, 71581696UL, 1073758208UL, 32768UL, 557056UL, 8421376UL, 143163392UL, 2147516416UL, 65536UL, 1114112UL, 16842752UL, 286326784UL, 65536UL, 131072UL, 2228224UL, 33685504UL, 572653568UL, 131072UL, 262144UL, 4456448UL, 67371008UL, 1145307136UL, 262144UL, 524288UL, 
8912896UL, 134742016UL, 2290614272UL, 524288UL, 1048576UL, 17825792UL, 269484032UL, 286261248UL, 1048576UL, 2097152UL, 35651584UL, 538968064UL, 572522496UL, 2097152UL, 4194304UL, 71303168UL, 1077936128UL, 1145044992UL, 4194304UL, 8388608UL, 142606336UL, 2155872256UL, 2290089984UL, 8388608UL, 16777216UL, 285212672UL, 16777216UL, 285212672UL, 16777216UL, 33554432UL, 570425344UL, 33554432UL, 
570425344UL, 33554432UL, 67108864UL, 1140850688UL, 67108864UL, 1140850688UL, 67108864UL, 134217728UL, 2281701376UL, 134217728UL, 2281701376UL, 134217728UL, 268435456UL, 268435456UL, 268435456UL, 268435456UL, 268435456UL, 536870912UL, 536870912UL, 536870912UL, 536870912UL, 536870912UL, 1073741824UL, 1073741824UL, 1073741824UL, 1073741824UL, 1073741824UL, 2147483648UL, 2147483648UL, 2147483648UL, 2147483648UL, 2147483648UL, 
},
{
85009117UL, 335741939UL, 1412632518UL, 386859243UL, 1741437244UL, 152139416UL, 403047142UL, 2556825231UL, 505087203UL, 4287193174UL, 335609039UL, 336528191UL, 1425998811UL, 456920088UL, 2832198590UL, 724748988UL, 3625845630UL, 1509824181UL, 3330088197UL, 2710488401UL, 1431742057UL, 1077674236UL, 1140592489UL, 2096905276UL, 3007294393UL, 2863484114UL, 1081606648UL, 1207443154UL, 972585080UL, 2793363314UL, 1432000919UL, 1089470704UL, 
1341132452UL, 3019109363UL, 2362285522UL, 1790260014UL, 2178941408UL, 2682264904UL, 1743251430UL, 429603751UL, 359294556UL, 62915520UL, 1069562512UL, 3486502860UL, 859207501UL, 3939814584UL, 125831040UL, 2139125024UL, 2678038424UL, 1718415002UL, 363436400UL, 251662080UL, 4278250048UL, 1061109552UL, 3436830004UL, 3948098272UL, 503324160UL, 4261532800UL, 2122219104UL, 2310257256UL, 380003776UL, 1006648320UL, 4228098304UL, 4244438208UL, 
3278337232UL, 3981233024UL, 2013296640UL, 4161229312UL, 4193909120UL, 2530142624UL, 446273280UL, 4026593280UL, 4027491328UL, 871625472UL, 4254978880UL, 4113772032UL, 3758219264UL, 3760015360UL, 2011686400UL, 3946555008UL, 711351296UL, 3221471232UL, 3225063424UL, 4291808256UL, 108481792UL, 2496444416UL, 2147975168UL, 2155159552UL, 4020213760UL, 485399040UL, 3919147008UL, 983040UL, 15351808UL, 255799296UL, 3923588096UL, 322101248UL, 
1966080UL, 299139072UL, 511598592UL, 3283773440UL, 3865427968UL, 3932160UL, 4087939072UL, 1023197184UL, 1467273216UL, 214663168UL, 7864320UL, 4149346304UL, 2046394368UL, 3202981888UL, 3650551808UL, 3236954112UL, 1050935296UL, 871563264UL, 2916302848UL, 1932394496UL, 2447376384UL, 1833435136UL, 2011561984UL, 2342944768UL, 643563520UL, 868220928UL, 177209344UL, 4291559424UL, 122486784UL, 2360868864UL, 2004877312UL, 85983232UL, 
4019716096UL, 3734634496UL, 3647995904UL, 1056964608UL, 3661627392UL, 254803968UL, 2905866240UL, 1658847232UL, 2113929216UL, 3028287488UL, 3730833408UL, 2322071552UL, 3586129920UL, 4227858432UL, 1761607680UL, 2092957696UL, 80740352UL, 2071986176UL, 4160749568UL, 3523215360UL, 964689920UL, 429916160UL, 3875536896UL, 4026531840UL, 2751463424UL, 1929379840UL, 4081057792UL, 503316480UL, 3758096384UL, 2281701376UL, 4127195136UL, 3397386240UL, 
1316635UL, 85009117UL, 335741939UL, 1412632518UL, 386859243UL, 1580547UL, 152139416UL, 403047142UL, 2556825231UL, 505087203UL, 1317672UL, 335609039UL, 336528191UL, 1425998811UL, 456920088UL, 1574501UL, 724748988UL, 3625845630UL, 1509824181UL, 3330088197UL, 15612UL, 1431742057UL, 1077674236UL, 1140592489UL, 2096905276UL, 31224UL, 2863484114UL, 1081606648UL, 1207443154UL, 972585080UL, 62451UL, 1432000919UL, 
1089470704UL, 1341132452UL, 3019109363UL, 124902UL, 1790260014UL, 2178941408UL, 2682264904UL, 1743251430UL, 249804UL, 359294556UL, 62915520UL, 1069562512UL, 3486502860UL, 499608UL, 3939814584UL, 125831040UL, 2139125024UL, 2678038424UL, 999216UL, 363436400UL, 251662080UL, 4278250048UL, 1061109552UL, 3223223904UL, 3948098272UL, 503324160UL, 4261532800UL, 2122219104UL, 1077738688UL, 380003776UL, 1006648320UL, 4228098304UL, 
4244438208UL, 1081735552UL, 3981233024UL, 2013296640UL, 4161229312UL, 4193909120UL, 1089729280UL, 446273280UL, 4026593280UL, 4027491328UL, 871625472UL, 2179458560UL, 4113772032UL, 3758219264UL, 3760015360UL, 2011686400UL, 63949824UL, 711351296UL, 3221471232UL, 3225063424UL, 4291808256UL, 127899648UL, 2496444416UL, 2147975168UL, 2155159552UL, 4020213760UL, 255799296UL, 3919147008UL, 983040UL, 15351808UL, 255799296UL, 3732824064UL, 
322101248UL, 1966080UL, 299139072UL, 511598592UL, 2096939008UL, 3865427968UL, 3932160UL, 4087939072UL, 1023197184UL, 972652544UL, 214663168UL, 7864320UL, 4149346304UL, 2046394368UL, 3019046912UL, 3650551808UL, 3236954112UL, 1050935296UL, 871563264UL, 1743126528UL, 1932394496UL, 2447376384UL, 1833435136UL, 2011561984UL, 3486253056UL, 643563520UL, 868220928UL, 177209344UL, 4291559424UL, 2677538816UL, 2360868864UL, 2004877312UL, 
85983232UL, 4019716096UL, 1060110336UL, 3647995904UL, 1056964608UL, 3661627392UL, 254803968UL, 3193962496UL, 1658847232UL, 2113929216UL, 3028287488UL, 3730833408UL, 3166699520UL, 3586129920UL, 4227858432UL, 1761607680UL, 2092957696UL, 3112173568UL, 2071986176UL, 4160749568UL, 3523215360UL, 964689920UL, 1929379840UL, 3875536896UL, 4026531840UL, 2751463424UL, 1929379840UL, 4127195136UL, 503316480UL, 3758096384UL, 2281701376UL, 4127195136UL, 
332854UL, 1316635UL, 85009117UL, 335741939UL, 1412632518UL, 596079UL, 1580547UL, 152139416UL, 403047142UL, 2556825231UL, 1316075UL, 1317672UL, 335609039UL, 336528191UL, 1425998811UL, 2824661UL, 1574501UL, 724748988UL, 3625845630UL, 1509824181UL, 5571497UL, 15612UL, 1431742057UL, 1077674236UL, 1140592489UL, 11142994UL, 31224UL, 2863484114UL, 1081606648UL, 1207443154UL, 22285988UL, 62451UL, 
1432000919UL, 1089470704UL, 1341132452UL, 44571976UL, 124902UL, 1790260014UL, 2178941408UL, 2682264904UL, 89143952UL, 249804UL, 359294556UL, 62915520UL, 1069562512UL, 178287904UL, 499608UL, 3939814584UL, 125831040UL, 2139125024UL, 356575808UL, 999216UL, 363436400UL, 251662080UL, 4278250048UL, 713151616UL, 3223223904UL, 3948098272UL, 503324160UL, 4261532800UL, 1426303232UL, 1077738688UL, 380003776UL, 1006648320UL, 
4228098304UL, 2852606464UL, 1081735552UL, 3981233024UL, 2013296640UL, 4161229312UL, 1410245632UL, 1089729280UL, 446273280UL, 4026593280UL, 4027491328UL, 1746749440UL, 2179458560UL, 4113772032UL, 3758219264UL, 3760015360UL, 272273408UL, 63949824UL, 711351296UL, 3221471232UL, 3225063424UL, 3765772288UL, 127899648UL, 2496444416UL, 2147975168UL, 2155159552UL, 15351808UL, 255799296UL, 3919147008UL, 983040UL, 15351808UL, 3251929088UL, 
3732824064UL, 322101248UL, 1966080UL, 299139072UL, 1135149056UL, 2096939008UL, 3865427968UL, 3932160UL, 4087939072UL, 1196556288UL, 972652544UL, 214663168UL, 7864320UL, 4149346304UL, 1319370752UL, 3019046912UL, 3650551808UL, 3236954112UL, 1050935296UL, 2638741504UL, 1743126528UL, 1932394496UL, 2447376384UL, 1833435136UL, 982515712UL, 3486253056UL, 643563520UL, 868220928UL, 177209344UL, 1965031424UL, 2677538816UL, 2360868864UL, 
2004877312UL, 85983232UL, 3930062848UL, 1060110336UL, 3647995904UL, 1056964608UL, 3661627392UL, 3565158400UL, 3193962496UL, 1658847232UL, 2113929216UL, 3028287488UL, 2835349504UL, 3166699520UL, 3586129920UL, 4227858432UL, 1761607680UL, 1375731712UL, 3112173568UL, 2071986176UL, 4160749568UL, 3523215360UL, 2751463424UL, 1929379840UL, 3875536896UL, 4026531840UL, 2751463424UL, 2281701376UL, 4127195136UL, 503316480UL, 3758096384UL, 2281701376UL, 
5123UL, 332854UL, 1316635UL, 85009117UL, 335741939UL, 6150UL, 596079UL, 1580547UL, 152139416UL, 403047142UL, 5135UL, 1316075UL, 1317672UL, 335609039UL, 336528191UL, 6174UL, 2824661UL, 1574501UL, 724748988UL, 3625845630UL, 60UL, 5571497UL, 15612UL, 1431742057UL, 1077674236UL, 120UL, 11142994UL, 31224UL, 2863484114UL, 1081606648UL, 240UL, 22285988UL, 
62451UL, 1432000919UL, 1089470704UL, 480UL, 44571976UL, 124902UL, 1790260014UL, 2178941408UL, 960UL, 89143952UL, 249804UL, 359294556UL, 62915520UL, 1920UL, 178287904UL, 499608UL, 3939814584UL, 125831040UL, 3840UL, 356575808UL, 999216UL, 363436400UL, 251662080UL, 7680UL, 713151616UL, 3223223904UL, 3948098272UL, 503324160UL, 15360UL, 1426303232UL, 1077738688UL, 380003776UL, 
1006648320UL, 30720UL, 2852606464UL, 1081735552UL, 3981233024UL, 2013296640UL, 61440UL, 1410245632UL, 1089729280UL, 446273280UL, 4026593280UL, 122880UL, 1746749440UL, 2179458560UL, 4113772032UL, 3758219264UL, 245760UL, 272273408UL, 63949824UL, 711351296UL, 3221471232UL, 491520UL, 3765772288UL, 127899648UL, 2496444416UL, 2147975168UL, 983040UL, 15351808UL, 255799296UL, 3919147008UL, 983040UL, 3223191552UL, 
3251929088UL, 3732824064UL, 322101248UL, 1966080UL, 1077673984UL, 1135149056UL, 2096939008UL, 3865427968UL, 3932160UL, 1081606144UL, 1196556288UL, 972652544UL, 214663168UL, 7864320UL, 1089470464UL, 1319370752UL, 3019046912UL, 3650551808UL, 3236954112UL, 2178940928UL, 2638741504UL, 1743126528UL, 1932394496UL, 2447376384UL, 62914560UL, 982515712UL, 3486253056UL, 643563520UL, 868220928UL, 125829120UL, 1965031424UL, 2677538816UL, 
2360868864UL, 2004877312UL, 251658240UL, 3930062848UL, 1060110336UL, 3647995904UL, 1056964608UL, 503316480UL, 3565158400UL, 3193962496UL, 1658847232UL, 2113929216UL, 1006632960UL, 2835349504UL, 3166699520UL, 3586129920UL, 4227858432UL, 2013265920UL, 1375731712UL, 3112173568UL, 2071986176UL, 4160749568UL, 4026531840UL, 2751463424UL, 1929379840UL, 3875536896UL, 4026531840UL, 3758096384UL, 2281701376UL, 4127195136UL, 503316480UL, 3758096384UL, 
201392209UL, 3423671362UL, 218366296UL, 3713336838UL, 206572594UL, 402785186UL, 2552372100UL, 436928947UL, 3130605370UL, 463476848UL, 262468UL, 4461835UL, 68158800UL, 1158700908UL, 20971524UL, 524680UL, 8919318UL, 136513955UL, 2316537326UL, 25165852UL, 3222274064UL, 3239051564UL, 3494187077UL, 3558090985UL, 3221225500UL, 2149580832UL, 2183135832UL, 2693406858UL, 2821214674UL, 2147483704UL, 4194368UL, 71304368UL, 
1091846420UL, 1347462055UL, 64UL, 8388736UL, 142608736UL, 2183692840UL, 2694924110UL, 3221225600UL, 16777472UL, 285217472UL, 72418384UL, 1094880924UL, 1342177536UL, 33554944UL, 570434944UL, 144836768UL, 2189761848UL, 2684355072UL, 67109888UL, 1140869888UL, 289673536UL, 84556400UL, 1073742848UL, 134219776UL, 2281739776UL, 579347072UL, 169112800UL, 2147485696UL, 268439552UL, 268512256UL, 1158694144UL, 69790144UL, 
4096UL, 536879104UL, 537024512UL, 2317388288UL, 3360805760UL, 8192UL, 1073758208UL, 1074049024UL, 339809280UL, 1352902400UL, 16384UL, 2147516416UL, 2148098048UL, 3900844032UL, 1632062976UL, 32768UL, 65536UL, 1228800UL, 17059840UL, 311335936UL, 65536UL, 131072UL, 2457600UL, 34119680UL, 622671872UL, 131072UL, 262144UL, 4915200UL, 68239360UL, 1245343744UL, 262144UL, 524288UL, 
9830400UL, 136478720UL, 2490687488UL, 524288UL, 1048576UL, 288096256UL, 272957440UL, 954843136UL, 3222274048UL, 2097152UL, 3797417984UL, 545914880UL, 2983428096UL, 2149580800UL, 4194304UL, 78643200UL, 1091829760UL, 2745630720UL, 4194304UL, 3229614080UL, 3378511872UL, 1109917696UL, 2270035968UL, 8388608UL, 1358954496UL, 1119879168UL, 1414529024UL, 513540096UL, 16777216UL, 2717908992UL, 2239758336UL, 2829058048UL, 
1027080192UL, 33554432UL, 1140850688UL, 184549376UL, 1363148800UL, 2054160384UL, 3288334336UL, 2281701376UL, 369098752UL, 2726297600UL, 4108320768UL, 2281701376UL, 268435456UL, 738197504UL, 2231369728UL, 968884224UL, 3959422976UL, 536870912UL, 1476395008UL, 167772160UL, 3011510272UL, 3355443200UL, 1073741824UL, 2952790016UL, 335544320UL, 1728053248UL, 2147483648UL, 2147483648UL, 1610612736UL, 3892314112UL, 503316480UL, 0UL, 
},
{
1939838472UL, 1412147404UL, 166205219UL, 1757484276UL, 2905930693UL, 2345662040UL, 2845657161UL, 253454719UL, 2661974169UL, 303781080UL, 4075331504UL, 31014156UL, 244538930UL, 3752264221UL, 992575155UL, 219309525UL, 246620060UL, 215640989UL, 4125020723UL, 2016731730UL, 3236558869UL, 297169276UL, 3293566751UL, 1867504216UL, 210423272UL, 2531663658UL, 499723753UL, 1730625896UL, 189236880UL, 3388575408UL, 2433358422UL, 1368961148UL, 
3134096848UL, 2827836415UL, 3888822753UL, 4172043647UL, 3379360748UL, 2651760955UL, 1345081091UL, 627692776UL, 189423917UL, 1927379456UL, 4004336944UL, 2995932065UL, 1882016234UL, 2551113616UL, 1576396048UL, 1299792730UL, 2151240795UL, 2154814108UL, 4292139924UL, 3555849728UL, 943986992UL, 3169912733UL, 2631635779UL, 3478094562UL, 1285558544UL, 3716074330UL, 2780749859UL, 3911106510UL, 4175656994UL, 1731832828UL, 1275401375UL, 937322456UL, 
3802094750UL, 1145506936UL, 1008905193UL, 1718801768UL, 645739137UL, 1356219146UL, 827886816UL, 1722154800UL, 2242776733UL, 754630810UL, 772070504UL, 249481170UL, 2608123425UL, 2087201889UL, 3200968096UL, 3292110026UL, 841433255UL, 477543427UL, 1878882709UL, 705347364UL, 4003860146UL, 3194913138UL, 2616490007UL, 357561212UL, 2446098297UL, 2955680594UL, 2512991743UL, 637464579UL, 1209132455UL, 1341312804UL, 612108672UL, 2455017713UL, 
1749147666UL, 4020226825UL, 2873924220UL, 499405095UL, 1837614076UL, 1227604028UL, 714577577UL, 165950208UL, 442290261UL, 489077752UL, 216760440UL, 42151250UL, 426862080UL, 2810242474UL, 4112075489UL, 3514761468UL, 4101921371UL, 982512636UL, 500792667UL, 4286077681UL, 198050301UL, 1858712743UL, 2913642493UL, 3547545255UL, 3981929169UL, 2944140287UL, 2286578015UL, 3422343167UL, 1239123295UL, 2026367394UL, 3269986302UL, 3028402878UL, 
2709637886UL, 1096011710UL, 294584132UL, 3086749695UL, 3324400975UL, 1164394495UL, 4290155855UL, 543687304UL, 4008517630UL, 836370334UL, 1876426750UL, 2362048414UL, 3578325264UL, 3221487612UL, 2671154748UL, 3395518460UL, 2018383420UL, 2131029536UL, 2165829624UL, 697661816UL, 1336049656UL, 3309365624UL, 4259639360UL, 3423548400UL, 2416417776UL, 1633698800UL, 1630071792UL, 41950336UL, 3423478496UL, 2885608160UL, 3943744224UL, 677380832UL, 
4179285363UL, 1939838472UL, 1412147404UL, 166205219UL, 1757484276UL, 3838244595UL, 2345662040UL, 2845657161UL, 253454719UL, 2661974169UL, 138737288UL, 4075331504UL, 31014156UL, 244538930UL, 3752264221UL, 1503392345UL, 219309525UL, 246620060UL, 215640989UL, 4125020723UL, 1759481152UL, 3236558869UL, 297169276UL, 3293566751UL, 1867504216UL, 3898070400UL, 2531663658UL, 499723753UL, 1730625896UL, 189236880UL, 2610231010UL, 2433358422UL, 
1368961148UL, 3134096848UL, 2827836415UL, 3903474593UL, 4172043647UL, 3379360748UL, 2651760955UL, 1345081091UL, 1267864331UL, 189423917UL, 1927379456UL, 4004336944UL, 2995932065UL, 3452816347UL, 2551113616UL, 1576396048UL, 1299792730UL, 2151240795UL, 1222520631UL, 4292139924UL, 3555849728UL, 943986992UL, 3169912733UL, 3260130211UL, 3478094562UL, 1285558544UL, 3716074330UL, 2780749859UL, 3039362306UL, 4175656994UL, 1731832828UL, 1275401375UL, 
937322456UL, 3236754932UL, 1145506936UL, 1008905193UL, 1718801768UL, 645739137UL, 1358079399UL, 827886816UL, 1722154800UL, 2242776733UL, 754630810UL, 1748663943UL, 249481170UL, 2608123425UL, 2087201889UL, 3200968096UL, 698076610UL, 841433255UL, 477543427UL, 1878882709UL, 705347364UL, 3692794996UL, 3194913138UL, 2616490007UL, 357561212UL, 2446098297UL, 2771068186UL, 2512991743UL, 637464579UL, 1209132455UL, 1341312804UL, 27937268UL, 
2455017713UL, 1749147666UL, 4020226825UL, 2873924220UL, 1673040956UL, 1837614076UL, 1227604028UL, 714577577UL, 165950208UL, 528340088UL, 489077752UL, 216760440UL, 42151250UL, 426862080UL, 1646215396UL, 4112075489UL, 3514761468UL, 4101921371UL, 982512636UL, 2095821304UL, 4286077681UL, 198050301UL, 1858712743UL, 2913642493UL, 277300160UL, 3981929169UL, 2944140287UL, 2286578015UL, 3422343167UL, 1178044288UL, 2026367394UL, 3269986302UL, 
3028402878UL, 2709637886UL, 2234191616UL, 294584132UL, 3086749695UL, 3324400975UL, 1164394495UL, 136978944UL, 543687304UL, 4008517630UL, 836370334UL, 1876426750UL, 3275253760UL, 3578325264UL, 3221487612UL, 2671154748UL, 3395518460UL, 3942394880UL, 2131029536UL, 2165829624UL, 697661816UL, 1336049656UL, 3265045504UL, 4259639360UL, 3423548400UL, 2416417776UL, 1633698800UL, 3943712768UL, 41950336UL, 3423478496UL, 2885608160UL, 3943744224UL, 
2293593009UL, 4179285363UL, 1939838472UL, 1412147404UL, 166205219UL, 715714152UL, 3838244595UL, 2345662040UL, 2845657161UL, 253454719UL, 3758048260UL, 138737288UL, 4075331504UL, 31014156UL, 244538930UL, 370671650UL, 1503392345UL, 219309525UL, 246620060UL, 215640989UL, 2219162331UL, 1759481152UL, 3236558869UL, 297169276UL, 3293566751UL, 135243402UL, 3898070400UL, 2531663658UL, 499723753UL, 1730625896UL, 3142293713UL, 2610231010UL, 
2433358422UL, 1368961148UL, 3134096848UL, 486949791UL, 3903474593UL, 4172043647UL, 3379360748UL, 2651760955UL, 3172880550UL, 1267864331UL, 189423917UL, 1927379456UL, 4004336944UL, 191463910UL, 3452816347UL, 2551113616UL, 1576396048UL, 1299792730UL, 4411574UL, 1222520631UL, 4292139924UL, 3555849728UL, 943986992UL, 3073348038UL, 3260130211UL, 3478094562UL, 1285558544UL, 3716074330UL, 3098363790UL, 3039362306UL, 4175656994UL, 1731832828UL, 
1275401375UL, 468159532UL, 3236754932UL, 1145506936UL, 1008905193UL, 1718801768UL, 1092964081UL, 1358079399UL, 827886816UL, 1722154800UL, 2242776733UL, 53128947UL, 1748663943UL, 249481170UL, 2608123425UL, 2087201889UL, 1960144614UL, 698076610UL, 841433255UL, 477543427UL, 1878882709UL, 1505419004UL, 3692794996UL, 3194913138UL, 2616490007UL, 357561212UL, 2823143358UL, 2771068186UL, 2512991743UL, 637464579UL, 1209132455UL, 1991737212UL, 
27937268UL, 2455017713UL, 1749147666UL, 4020226825UL, 2907896812UL, 1673040956UL, 1837614076UL, 1227604028UL, 714577577UL, 3633969112UL, 528340088UL, 489077752UL, 216760440UL, 42151250UL, 2886728356UL, 1646215396UL, 4112075489UL, 3514761468UL, 4101921371UL, 3507686008UL, 2095821304UL, 4286077681UL, 198050301UL, 1858712743UL, 1463806912UL, 277300160UL, 3981929169UL, 2944140287UL, 2286578015UL, 4137888640UL, 1178044288UL, 2026367394UL, 
3269986302UL, 3028402878UL, 1276820224UL, 2234191616UL, 294584132UL, 3086749695UL, 3324400975UL, 4274031104UL, 136978944UL, 543687304UL, 4008517630UL, 836370334UL, 2978609152UL, 3275253760UL, 3578325264UL, 3221487612UL, 2671154748UL, 2296777728UL, 3942394880UL, 2131029536UL, 2165829624UL, 697661816UL, 1086645248UL, 3265045504UL, 4259639360UL, 3423548400UL, 2416417776UL, 2295121920UL, 3943712768UL, 41950336UL, 3423478496UL, 2885608160UL, 
3290486993UL, 2293593009UL, 4179285363UL, 1939838472UL, 1412147404UL, 3718742914UL, 715714152UL, 3838244595UL, 2345662040UL, 2845657161UL, 3251034248UL, 3758048260UL, 138737288UL, 4075331504UL, 31014156UL, 2257801369UL, 370671650UL, 1503392345UL, 219309525UL, 246620060UL, 1375177854UL, 2219162331UL, 1759481152UL, 3236558869UL, 297169276UL, 2981812236UL, 135243402UL, 3898070400UL, 2531663658UL, 499723753UL, 1103465850UL, 3142293713UL, 
2610231010UL, 2433358422UL, 1368961148UL, 2570001060UL, 486949791UL, 3903474593UL, 4172043647UL, 3379360748UL, 1922171925UL, 3172880550UL, 1267864331UL, 189423917UL, 1927379456UL, 1359812359UL, 191463910UL, 3452816347UL, 2551113616UL, 1576396048UL, 2518549525UL, 4411574UL, 1222520631UL, 4292139924UL, 3555849728UL, 949028615UL, 3073348038UL, 3260130211UL, 3478094562UL, 1285558544UL, 4113039486UL, 3098363790UL, 3039362306UL, 4175656994UL, 
1731832828UL, 1827471372UL, 468159532UL, 3236754932UL, 1145506936UL, 1008905193UL, 1626341859UL, 1092964081UL, 1358079399UL, 827886816UL, 1722154800UL, 1069547583UL, 53128947UL, 1748663943UL, 249481170UL, 2608123425UL, 3162506114UL, 1960144614UL, 698076610UL, 841433255UL, 477543427UL, 3641706484UL, 1505419004UL, 3692794996UL, 3194913138UL, 2616490007UL, 3623882586UL, 2823143358UL, 2771068186UL, 2512991743UL, 637464579UL, 16785012UL, 
1991737212UL, 27937268UL, 2455017713UL, 1749147666UL, 2348825660UL, 2907896812UL, 1673040956UL, 1837614076UL, 1227604028UL, 2579527800UL, 3633969112UL, 528340088UL, 489077752UL, 216760440UL, 3628134628UL, 2886728356UL, 1646215396UL, 4112075489UL, 3514761468UL, 1602085368UL, 3507686008UL, 2095821304UL, 4286077681UL, 198050301UL, 2501362624UL, 1463806912UL, 277300160UL, 3981929169UL, 2944140287UL, 4112467840UL, 4137888640UL, 1178044288UL, 
2026367394UL, 3269986302UL, 3356184320UL, 1276820224UL, 2234191616UL, 294584132UL, 3086749695UL, 366387712UL, 4274031104UL, 136978944UL, 543687304UL, 4008517630UL, 1006135296UL, 2978609152UL, 3275253760UL, 3578325264UL, 3221487612UL, 3104844800UL, 2296777728UL, 3942394880UL, 2131029536UL, 2165829624UL, 1874371584UL, 1086645248UL, 3265045504UL, 4259639360UL, 3423548400UL, 2975352832UL, 2295121920UL, 3943712768UL, 41950336UL, 3423478496UL, 
989898496UL, 3410688577UL, 2331788830UL, 3546482013UL, 813828841UL, 1865093068UL, 3265457506UL, 3795669738UL, 2119696024UL, 4285651426UL, 3333834629UL, 3451487261UL, 2090324595UL, 1816963648UL, 932961512UL, 2470761029UL, 3401764108UL, 3421619354UL, 4199624502UL, 589386372UL, 879396240UL, 3372470254UL, 2693109296UL, 2424215996UL, 38442268UL, 1882087724UL, 171397600UL, 2024561281UL, 183095586UL, 3282207272UL, 3402177296UL, 1859195498UL, 
413109947UL, 2839537944UL, 1632143648UL, 3742715856UL, 388696500UL, 1748703733UL, 3563198567UL, 3826785440UL, 2896086528UL, 3989037829UL, 1478787788UL, 1390277813UL, 2123320736UL, 3416516800UL, 2056564203UL, 2584895011UL, 1605192736UL, 2475623616UL, 3856499712UL, 3439657984UL, 708088129UL, 1501395566UL, 1302184960UL, 1360092352UL, 1645630430UL, 1425230387UL, 3369488824UL, 2979863936UL, 869212432UL, 150548847UL, 1097557362UL, 655939640UL, 
316553344UL, 3761918508UL, 3958338094UL, 141744600UL, 1412214640UL, 1859689984UL, 3200680981UL, 3883058679UL, 999801880UL, 3946079738UL, 1876072704UL, 194381849UL, 2177533995UL, 1584707624UL, 3053768410UL, 2593051904UL, 3458076673UL, 4047442835UL, 3545972808UL, 3441793178UL, 194975744UL, 1731731470UL, 4168755162UL, 2628944732UL, 2125675784UL, 3119906816UL, 960774145UL, 2646626078UL, 2152793157UL, 3049156634UL, 672464896UL, 3046932493UL, 
3700727536UL, 2152335477UL, 575986696UL, 671940608UL, 2208366608UL, 1454456125UL, 937760016UL, 4103979069UL, 2737668096UL, 1179779104UL, 1030912634UL, 1041902112UL, 2032909434UL, 2274230272UL, 2089025605UL, 3050632421UL, 2428784965UL, 140658149UL, 4254138368UL, 1745354889UL, 711584249UL, 2746523017UL, 2551006457UL, 1100808192UL, 1494221073UL, 3422999489UL, 2696954129UL, 976716737UL, 2653421568UL, 3806331426UL, 3690047362UL, 1481392674UL, 
3817015170UL, 2353004544UL, 286262340UL, 2300534532UL, 4206449732UL, 15339268UL, 2894069760UL, 488376456UL, 1489927688UL, 1196583048UL, 652746248UL, 2214592512UL, 69904UL, 1006205200UL, 2322628880UL, 1229515024UL, 2617245696UL, 3423527456UL, 1964953120UL, 4260938272UL, 386199072UL, 1744830464UL, 1342444608UL, 1069330496UL, 2138592320UL, 3185897536UL, 1073741824UL, 1342493824UL, 3780942976UL, 1771066496UL, 2189433984UL, 2147483648UL, 
},
{
1804684571UL, 2106089606UL, 1533056158UL, 2870216110UL, 3618155659UL, 3789871366UL, 4246691682UL, 3667072763UL, 1212241769UL, 3152390668UL, 2973497449UL, 2958641966UL, 2088805328UL, 717518631UL, 2401090860UL, 3606967204UL, 952637656UL, 59827581UL, 1291486682UL, 1499453515UL, 2053994857UL, 563998083UL, 4094000396UL, 1163546899UL, 1003843565UL, 654565639UL, 1070907026UL, 4217851863UL, 426034251UL, 1721352737UL, 278404469UL, 3899800390UL, 
1063362170UL, 1162348262UL, 3153545093UL, 3249996223UL, 186674553UL, 2616406148UL, 3137968354UL, 1282784965UL, 1495068058UL, 3033760361UL, 2278144523UL, 3192245769UL, 719586342UL, 2602548287UL, 3386583150UL, 355354345UL, 3252815848UL, 2178056037UL, 2283016801UL, 3005955037UL, 3340254490UL, 802791670UL, 251122316UL, 3705188626UL, 1252262272UL, 3989036796UL, 3527490452UL, 2047131255UL, 1447170583UL, 3373930285UL, 2895037457UL, 209341805UL, 
1820357643UL, 3712392731UL, 685796521UL, 1322920440UL, 814388470UL, 1357857147UL, 434430265UL, 2650681935UL, 1371566728UL, 58783716UL, 2273435933UL, 3498513198UL, 792571900UL, 1447808772UL, 3513385860UL, 99175889UL, 1105434360UL, 1484146625UL, 3327194068UL, 242672513UL, 3552105593UL, 1425844616UL, 2871928454UL, 1124633561UL, 607610433UL, 2130018608UL, 1610235673UL, 2844230432UL, 2748082340UL, 994392866UL, 450823250UL, 2912535126UL, 
2574390988UL, 3974009252UL, 78696582UL, 649682891UL, 3980917176UL, 3221419689UL, 960695436UL, 729221508UL, 358358845UL, 3392407691UL, 472711005UL, 295914899UL, 3005191796UL, 3078521977UL, 3370011868UL, 509135340UL, 1965939519UL, 2086465877UL, 2457949822UL, 1324152522UL, 762289386UL, 3618693997UL, 233730715UL, 2873984650UL, 31168606UL, 3367142977UL, 2851851305UL, 3251660053UL, 4209768406UL, 3298190175UL, 901235185UL, 1564391510UL, 
2352686527UL, 1008150482UL, 578573310UL, 3462447127UL, 2482873876UL, 1790221257UL, 2255375608UL, 2335345651UL, 1381450613UL, 2866805101UL, 1495073163UL, 519905259UL, 3184556473UL, 1076378339UL, 2692926127UL, 970097715UL, 4013407916UL, 4014350363UL, 2476927059UL, 1989070516UL, 2640060069UL, 1987784589UL, 1880989003UL, 3861138803UL, 451743296UL, 1987067871UL, 1975657871UL, 3397816882UL, 2309900530UL, 4108425851UL, 4063867233UL, 3319482186UL, 
2621772886UL, 1804684571UL, 2106089606UL, 1533056158UL, 2870216110UL, 611557097UL, 3789871366UL, 4246691682UL, 3667072763UL, 1212241769UL, 3389551988UL, 2973497449UL, 2958641966UL, 2088805328UL, 717518631UL, 2460955430UL, 3606967204UL, 952637656UL, 59827581UL, 1291486682UL, 3531087304UL, 2053994857UL, 563998083UL, 4094000396UL, 1163546899UL, 1242934125UL, 654565639UL, 1070907026UL, 4217851863UL, 426034251UL, 3034416129UL, 278404469UL, 
3899800390UL, 1063362170UL, 1162348262UL, 4258714417UL, 3249996223UL, 186674553UL, 2616406148UL, 3137968354UL, 639885806UL, 1495068058UL, 3033760361UL, 2278144523UL, 3192245769UL, 4159910300UL, 2602548287UL, 3386583150UL, 355354345UL, 3252815848UL, 1555885880UL, 2283016801UL, 3005955037UL, 3340254490UL, 802791670UL, 2948774612UL, 3705188626UL, 1252262272UL, 3989036796UL, 3527490452UL, 2107826711UL, 1447170583UL, 3373930285UL, 2895037457UL, 
209341805UL, 3763367196UL, 3712392731UL, 685796521UL, 1322920440UL, 814388470UL, 1986168339UL, 434430265UL, 2650681935UL, 1371566728UL, 58783716UL, 1423189187UL, 3498513198UL, 792571900UL, 1447808772UL, 3513385860UL, 315969823UL, 1105434360UL, 1484146625UL, 3327194068UL, 242672513UL, 3336228275UL, 1425844616UL, 2871928454UL, 1124633561UL, 607610433UL, 1762052458UL, 1610235673UL, 2844230432UL, 2748082340UL, 994392866UL, 3771702243UL, 
2912535126UL, 2574390988UL, 3974009252UL, 78696582UL, 1626628844UL, 3980917176UL, 3221419689UL, 960695436UL, 729221508UL, 382092233UL, 3392407691UL, 472711005UL, 295914899UL, 3005191796UL, 514297204UL, 3370011868UL, 509135340UL, 1965939519UL, 2086465877UL, 3975975091UL, 1324152522UL, 762289386UL, 3618693997UL, 233730715UL, 455322516UL, 31168606UL, 3367142977UL, 2851851305UL, 3251660053UL, 3952189603UL, 3298190175UL, 901235185UL, 
1564391510UL, 2352686527UL, 826181452UL, 578573310UL, 3462447127UL, 2482873876UL, 1790221257UL, 1529242773UL, 2335345651UL, 1381450613UL, 2866805101UL, 1495073163UL, 877718651UL, 3184556473UL, 1076378339UL, 2692926127UL, 970097715UL, 299344245UL, 4014350363UL, 2476927059UL, 1989070516UL, 2640060069UL, 3844531327UL, 1880989003UL, 3861138803UL, 451743296UL, 1987067871UL, 3272848161UL, 3397816882UL, 2309900530UL, 4108425851UL, 4063867233UL, 
834288064UL, 2621772886UL, 1804684571UL, 2106089606UL, 1533056158UL, 304865970UL, 611557097UL, 3789871366UL, 4246691682UL, 3667072763UL, 2728206193UL, 3389551988UL, 2973497449UL, 2958641966UL, 2088805328UL, 3895037582UL, 2460955430UL, 3606967204UL, 952637656UL, 59827581UL, 2349212526UL, 3531087304UL, 2053994857UL, 563998083UL, 4094000396UL, 4028900485UL, 1242934125UL, 654565639UL, 1070907026UL, 4217851863UL, 1663452176UL, 3034416129UL, 
278404469UL, 3899800390UL, 1063362170UL, 2721441405UL, 4258714417UL, 3249996223UL, 186674553UL, 2616406148UL, 4228837490UL, 639885806UL, 1495068058UL, 3033760361UL, 2278144523UL, 2820661772UL, 4159910300UL, 2602548287UL, 3386583150UL, 355354345UL, 1815256314UL, 1555885880UL, 2283016801UL, 3005955037UL, 3340254490UL, 2166514144UL, 2948774612UL, 3705188626UL, 1252262272UL, 3989036796UL, 751187322UL, 2107826711UL, 1447170583UL, 3373930285UL, 
2895037457UL, 2809311944UL, 3763367196UL, 3712392731UL, 685796521UL, 1322920440UL, 936300677UL, 1986168339UL, 434430265UL, 2650681935UL, 1371566728UL, 1308015359UL, 1423189187UL, 3498513198UL, 792571900UL, 1447808772UL, 3065349526UL, 315969823UL, 1105434360UL, 1484146625UL, 3327194068UL, 1038676789UL, 3336228275UL, 1425844616UL, 2871928454UL, 1124633561UL, 2956422231UL, 1762052458UL, 1610235673UL, 2844230432UL, 2748082340UL, 3603862093UL, 
3771702243UL, 2912535126UL, 2574390988UL, 3974009252UL, 1691332448UL, 1626628844UL, 3980917176UL, 3221419689UL, 960695436UL, 3120142427UL, 382092233UL, 3392407691UL, 472711005UL, 295914899UL, 4101686983UL, 514297204UL, 3370011868UL, 509135340UL, 1965939519UL, 3015736706UL, 3975975091UL, 1324152522UL, 762289386UL, 3618693997UL, 2395097989UL, 455322516UL, 31168606UL, 3367142977UL, 2851851305UL, 30511955UL, 3952189603UL, 3298190175UL, 
901235185UL, 1564391510UL, 2606298633UL, 826181452UL, 578573310UL, 3462447127UL, 2482873876UL, 4159642946UL, 1529242773UL, 2335345651UL, 1381450613UL, 2866805101UL, 1782913669UL, 877718651UL, 3184556473UL, 1076378339UL, 2692926127UL, 1730328819UL, 299344245UL, 4014350363UL, 2476927059UL, 1989070516UL, 1425685614UL, 3844531327UL, 1880989003UL, 3861138803UL, 451743296UL, 889237383UL, 3272848161UL, 3397816882UL, 2309900530UL, 4108425851UL, 
1155723231UL, 834288064UL, 2621772886UL, 1804684571UL, 2106089606UL, 2387009004UL, 304865970UL, 611557097UL, 3789871366UL, 4246691682UL, 1405709661UL, 2728206193UL, 3389551988UL, 2973497449UL, 2958641966UL, 3183906006UL, 3895037582UL, 2460955430UL, 3606967204UL, 952637656UL, 1345432763UL, 2349212526UL, 3531087304UL, 2053994857UL, 563998083UL, 3749011414UL, 4028900485UL, 1242934125UL, 654565639UL, 1070907026UL, 1072342672UL, 1663452176UL, 
3034416129UL, 278404469UL, 3899800390UL, 3566652188UL, 2721441405UL, 4258714417UL, 3249996223UL, 186674553UL, 4001263143UL, 4228837490UL, 639885806UL, 1495068058UL, 3033760361UL, 4278332644UL, 2820661772UL, 4159910300UL, 2602548287UL, 3386583150UL, 838831089UL, 1815256314UL, 1555885880UL, 2283016801UL, 3005955037UL, 3377397178UL, 2166514144UL, 2948774612UL, 3705188626UL, 1252262272UL, 2414422575UL, 751187322UL, 2107826711UL, 1447170583UL, 
3373930285UL, 1253755033UL, 2809311944UL, 3763367196UL, 3712392731UL, 685796521UL, 3238624475UL, 936300677UL, 1986168339UL, 434430265UL, 2650681935UL, 1642290570UL, 1308015359UL, 1423189187UL, 3498513198UL, 792571900UL, 173318140UL, 3065349526UL, 315969823UL, 1105434360UL, 1484146625UL, 4103797777UL, 1038676789UL, 3336228275UL, 1425844616UL, 2871928454UL, 1797745765UL, 2956422231UL, 1762052458UL, 1610235673UL, 2844230432UL, 2180656608UL, 
3603862093UL, 3771702243UL, 2912535126UL, 2574390988UL, 1183098390UL, 1691332448UL, 1626628844UL, 3980917176UL, 3221419689UL, 2645203959UL, 3120142427UL, 382092233UL, 3392407691UL, 472711005UL, 1659659070UL, 4101686983UL, 514297204UL, 3370011868UL, 509135340UL, 483888155UL, 3015736706UL, 3975975091UL, 1324152522UL, 762289386UL, 1259948064UL, 2395097989UL, 455322516UL, 31168606UL, 3367142977UL, 339990414UL, 30511955UL, 3952189603UL, 
3298190175UL, 901235185UL, 3097920065UL, 2606298633UL, 826181452UL, 578573310UL, 3462447127UL, 1548039839UL, 4159642946UL, 1529242773UL, 2335345651UL, 1381450613UL, 2173079994UL, 1782913669UL, 877718651UL, 3184556473UL, 1076378339UL, 1570275057UL, 1730328819UL, 299344245UL, 4014350363UL, 2476927059UL, 1845882881UL, 1425685614UL, 3844531327UL, 1880989003UL, 3861138803UL, 1322409081UL, 889237383UL, 3272848161UL, 3397816882UL, 2309900530UL, 
3505447982UL, 3430136873UL, 1319796589UL, 4202423979UL, 3184732284UL, 2910356648UL, 2534615223UL, 3854465731UL, 768821792UL, 2205052576UL, 1348983754UL, 1300250188UL, 2919181738UL, 2520178732UL, 3967243685UL, 2646012002UL, 1784678658UL, 741302051UL, 3464753547UL, 194213376UL, 1482799064UL, 3009673860UL, 680824208UL, 741966796UL, 2381283369UL, 3022877171UL, 1619439814UL, 3961433610UL, 1331297670UL, 1100110820UL, 1311672539UL, 1122110615UL, 
4056004850UL, 3413790176UL, 3148768822UL, 1242592694UL, 2925975727UL, 1879285134UL, 334328879UL, 1318235222UL, 3140739559UL, 401691770UL, 3604288404UL, 3686496908UL, 770670945UL, 199139043UL, 2092710473UL, 3914528993UL, 700991333UL, 2375775811UL, 858137308UL, 3490050165UL, 2389078291UL, 1615607459UL, 3027969809UL, 820012549UL, 2085659484UL, 2654485136UL, 2630408646UL, 196481396UL, 1119673274UL, 1026209692UL, 726501622UL, 2940737143UL, 
3559571163UL, 2288027726UL, 1039212708UL, 929664536UL, 1061981465UL, 186058675UL, 3537656152UL, 844176796UL, 2996217992UL, 1545798611UL, 3031020656UL, 2248030435UL, 1665857580UL, 2905758082UL, 1269201312UL, 3031275084UL, 4034872841UL, 983632400UL, 4188503190UL, 757119675UL, 2105920865UL, 4281032819UL, 2917801076UL, 3900010013UL, 3910997169UL, 1729751422UL, 562313247UL, 3070846353UL, 2564238664UL, 4050540186UL, 4258833501UL, 2270666053UL, 
2207128401UL, 2990540001UL, 797768898UL, 2288390225UL, 3230323685UL, 1974727440UL, 3327301426UL, 289857826UL, 3565889868UL, 2791014422UL, 2021097820UL, 3350378271UL, 3673707591UL, 2610067927UL, 4255789547UL, 2682856590UL, 12563128UL, 1397542366UL, 237149400UL, 2233707508UL, 3875573245UL, 2097374144UL, 175320773UL, 4103445984UL, 4089284323UL, 3610168130UL, 3084915964UL, 680145366UL, 2571684685UL, 1132894909UL, 104640024UL, 193765521UL, 
2338202907UL, 895271448UL, 11499099UL, 1798066417UL, 1297412626UL, 2511347162UL, 3140535007UL, 2129963538UL, 700683199UL, 2609700278UL, 2953463279UL, 2290844145UL, 1871316353UL, 3993801787UL, 2219413182UL, 2954453701UL, 231283580UL, 1375331115UL, 207723994UL, 1799562537UL, 2056553564UL, 2513609799UL, 3542459627UL, 3173012714UL, 3923404932UL, 217877755UL, 2095124912UL, 192024370UL, 1168134987UL, 1889598668UL, 3014873069UL, 2033573343UL, 
},
{
3465348660UL, 3623545008UL, 3505902593UL, 838034830UL, 1338018789UL, 2595329276UL, 3367746385UL, 3197935201UL, 1439351946UL, 3585085571UL, 4165798087UL, 3634792639UL, 2359485974UL, 2772582925UL, 1110186203UL, 3771562484UL, 1508694157UL, 1564641206UL, 2801985736UL, 2446107936UL, 3849126897UL, 1842973671UL, 944408104UL, 2624631280UL, 2729080685UL, 3737368614UL, 858809173UL, 2289802345UL, 2428186575UL, 3114742765UL, 716011303UL, 3443810690UL, 
814132610UL, 517432787UL, 614445393UL, 2930433345UL, 291178098UL, 2117644502UL, 2749446703UL, 311745701UL, 365684723UL, 1705418876UL, 2213749318UL, 4011417220UL, 1842575651UL, 988348831UL, 94258998UL, 2771150272UL, 498058526UL, 1344827813UL, 2961955291UL, 262703473UL, 1404034822UL, 1566595865UL, 2522381203UL, 1706522206UL, 1203054806UL, 1273801539UL, 2070583465UL, 3913449936UL, 3231505231UL, 619636751UL, 3746997351UL, 4103027837UL, 
1205468203UL, 3355878253UL, 3433356888UL, 107785753UL, 2779092609UL, 1869691566UL, 2555219983UL, 903319808UL, 3273374169UL, 2538926990UL, 979533870UL, 1356500860UL, 1661983738UL, 1380761625UL, 2919458459UL, 1041142798UL, 1430817627UL, 517007606UL, 1421570516UL, 2371447300UL, 2985632691UL, 3684889351UL, 3873926653UL, 788770697UL, 1854750277UL, 209332297UL, 1137299679UL, 848527832UL, 3850486924UL, 4179307312UL, 2764470693UL, 1353191605UL, 
4166891919UL, 2074703841UL, 3373997532UL, 2013528640UL, 701389744UL, 841917592UL, 2065742268UL, 2721848192UL, 2566956680UL, 3122896007UL, 1090761479UL, 921859028UL, 4086736376UL, 1837462309UL, 2579826431UL, 2436217134UL, 839037727UL, 1072086642UL, 614518622UL, 3764758228UL, 1501128342UL, 3669108708UL, 1601407381UL, 2899014005UL, 3268308948UL, 3337564231UL, 1986911578UL, 3379194930UL, 1950365753UL, 2098537451UL, 51515980UL, 1176526086UL, 
3213391582UL, 1059745735UL, 2273586703UL, 376085505UL, 1493749800UL, 3970342143UL, 1620925244UL, 2165301314UL, 2332030190UL, 1864098798UL, 276747442UL, 2776569227UL, 2992780663UL, 3027279789UL, 1074555384UL, 3481518659UL, 2499703783UL, 661805703UL, 3782305562UL, 9186074UL, 2357407210UL, 2355922343UL, 2024733363UL, 485434612UL, 862379913UL, 1029706268UL, 1512726310UL, 3834948354UL, 1435892840UL, 3297980694UL, 2831553800UL, 2111416471UL, 
711321697UL, 3465348660UL, 3623545008UL, 3505902593UL, 838034830UL, 1553436793UL, 2595329276UL, 3367746385UL, 3197935201UL, 1439351946UL, 3198044157UL, 4165798087UL, 3634792639UL, 2359485974UL, 2772582925UL, 836042976UL, 3771562484UL, 1508694157UL, 1564641206UL, 2801985736UL, 1190371491UL, 3849126897UL, 1842973671UL, 944408104UL, 2624631280UL, 410746791UL, 3737368614UL, 858809173UL, 2289802345UL, 2428186575UL, 1542325976UL, 716011303UL, 
3443810690UL, 814132610UL, 517432787UL, 1649301063UL, 2930433345UL, 291178098UL, 2117644502UL, 2749446703UL, 3955511579UL, 365684723UL, 1705418876UL, 2213749318UL, 4011417220UL, 2753632862UL, 988348831UL, 94258998UL, 2771150272UL, 498058526UL, 3314106168UL, 2961955291UL, 262703473UL, 1404034822UL, 1566595865UL, 3590367097UL, 1706522206UL, 1203054806UL, 1273801539UL, 2070583465UL, 2340683261UL, 3231505231UL, 619636751UL, 3746997351UL, 
4103027837UL, 2785398766UL, 3355878253UL, 3433356888UL, 107785753UL, 2779092609UL, 1608451840UL, 2555219983UL, 903319808UL, 3273374169UL, 2538926990UL, 645164419UL, 1356500860UL, 1661983738UL, 1380761625UL, 2919458459UL, 2260224548UL, 1430817627UL, 517007606UL, 1421570516UL, 2371447300UL, 1636004496UL, 3684889351UL, 3873926653UL, 788770697UL, 1854750277UL, 1345251011UL, 1137299679UL, 848527832UL, 3850486924UL, 4179307312UL, 3576574608UL, 
1353191605UL, 4166891919UL, 2074703841UL, 3373997532UL, 183447754UL, 701389744UL, 841917592UL, 2065742268UL, 2721848192UL, 2109289891UL, 3122896007UL, 1090761479UL, 921859028UL, 4086736376UL, 2212730874UL, 2579826431UL, 2436217134UL, 839037727UL, 1072086642UL, 55934784UL, 3764758228UL, 1501128342UL, 3669108708UL, 1601407381UL, 516550987UL, 3268308948UL, 3337564231UL, 1986911578UL, 3379194930UL, 3973484473UL, 2098537451UL, 51515980UL, 
1176526086UL, 3213391582UL, 4251661633UL, 2273586703UL, 376085505UL, 1493749800UL, 3970342143UL, 3190791788UL, 2165301314UL, 2332030190UL, 1864098798UL, 276747442UL, 2991976613UL, 2992780663UL, 3027279789UL, 1074555384UL, 3481518659UL, 1399789494UL, 661805703UL, 3782305562UL, 9186074UL, 2357407210UL, 1942736967UL, 2024733363UL, 485434612UL, 862379913UL, 1029706268UL, 4122704494UL, 3834948354UL, 1435892840UL, 3297980694UL, 2831553800UL, 
1210092654UL, 711321697UL, 3465348660UL, 3623545008UL, 3505902593UL, 3443231198UL, 1553436793UL, 2595329276UL, 3367746385UL, 3197935201UL, 1304974987UL, 3198044157UL, 4165798087UL, 3634792639UL, 2359485974UL, 3518323362UL, 836042976UL, 3771562484UL, 1508694157UL, 1564641206UL, 3577633375UL, 1190371491UL, 3849126897UL, 1842973671UL, 944408104UL, 1854555112UL, 410746791UL, 3737368614UL, 858809173UL, 2289802345UL, 3622671731UL, 1542325976UL, 
716011303UL, 3443810690UL, 814132610UL, 296197011UL, 1649301063UL, 2930433345UL, 291178098UL, 2117644502UL, 1056271538UL, 3955511579UL, 365684723UL, 1705418876UL, 2213749318UL, 1258535671UL, 2753632862UL, 988348831UL, 94258998UL, 2771150272UL, 3669902097UL, 3314106168UL, 2961955291UL, 262703473UL, 1404034822UL, 1654433938UL, 3590367097UL, 1706522206UL, 1203054806UL, 1273801539UL, 2448138887UL, 2340683261UL, 3231505231UL, 619636751UL, 
3746997351UL, 1454088394UL, 2785398766UL, 3355878253UL, 3433356888UL, 107785753UL, 689323470UL, 1608451840UL, 2555219983UL, 903319808UL, 3273374169UL, 1603842392UL, 645164419UL, 1356500860UL, 1661983738UL, 1380761625UL, 2814639423UL, 2260224548UL, 1430817627UL, 517007606UL, 1421570516UL, 1938805701UL, 1636004496UL, 3684889351UL, 3873926653UL, 788770697UL, 4238900666UL, 1345251011UL, 1137299679UL, 848527832UL, 3850486924UL, 108793827UL, 
3576574608UL, 1353191605UL, 4166891919UL, 2074703841UL, 3780897861UL, 183447754UL, 701389744UL, 841917592UL, 2065742268UL, 3036602746UL, 2109289891UL, 3122896007UL, 1090761479UL, 921859028UL, 3499985398UL, 2212730874UL, 2579826431UL, 2436217134UL, 839037727UL, 3520354700UL, 55934784UL, 3764758228UL, 1501128342UL, 3669108708UL, 1601010847UL, 516550987UL, 3268308948UL, 3337564231UL, 1986911578UL, 2704241781UL, 3973484473UL, 2098537451UL, 
51515980UL, 1176526086UL, 3602010532UL, 4251661633UL, 2273586703UL, 376085505UL, 1493749800UL, 2922957328UL, 3190791788UL, 2165301314UL, 2332030190UL, 1864098798UL, 1649666443UL, 2991976613UL, 2992780663UL, 3027279789UL, 1074555384UL, 2848531519UL, 1399789494UL, 661805703UL, 3782305562UL, 9186074UL, 320781315UL, 1942736967UL, 2024733363UL, 485434612UL, 862379913UL, 3598892066UL, 4122704494UL, 3834948354UL, 1435892840UL, 3297980694UL, 
545184652UL, 1210092654UL, 711321697UL, 3465348660UL, 3623545008UL, 1173753045UL, 3443231198UL, 1553436793UL, 2595329276UL, 3367746385UL, 2444634476UL, 1304974987UL, 3198044157UL, 4165798087UL, 3634792639UL, 1837035806UL, 3518323362UL, 836042976UL, 3771562484UL, 1508694157UL, 2899021294UL, 3577633375UL, 1190371491UL, 3849126897UL, 1842973671UL, 1614215215UL, 1854555112UL, 410746791UL, 3737368614UL, 858809173UL, 525745365UL, 3622671731UL, 
1542325976UL, 716011303UL, 3443810690UL, 566299749UL, 296197011UL, 1649301063UL, 2930433345UL, 291178098UL, 1987532525UL, 1056271538UL, 3955511579UL, 365684723UL, 1705418876UL, 2321222760UL, 1258535671UL, 2753632862UL, 988348831UL, 94258998UL, 2986060366UL, 3669902097UL, 3314106168UL, 2961955291UL, 262703473UL, 604452796UL, 1654433938UL, 3590367097UL, 1706522206UL, 1203054806UL, 1894894069UL, 2448138887UL, 2340683261UL, 3231505231UL, 
619636751UL, 6680729UL, 1454088394UL, 2785398766UL, 3355878253UL, 3433356888UL, 2025591660UL, 689323470UL, 1608451840UL, 2555219983UL, 903319808UL, 3430384385UL, 1603842392UL, 645164419UL, 1356500860UL, 1661983738UL, 2108736152UL, 2814639423UL, 2260224548UL, 1430817627UL, 517007606UL, 2973658959UL, 1938805701UL, 1636004496UL, 3684889351UL, 3873926653UL, 2283691941UL, 4238900666UL, 1345251011UL, 1137299679UL, 848527832UL, 45551112UL, 
108793827UL, 3576574608UL, 1353191605UL, 4166891919UL, 3776615962UL, 3780897861UL, 183447754UL, 701389744UL, 841917592UL, 3830639316UL, 3036602746UL, 2109289891UL, 3122896007UL, 1090761479UL, 1931255897UL, 3499985398UL, 2212730874UL, 2579826431UL, 2436217134UL, 3272166055UL, 3520354700UL, 55934784UL, 3764758228UL, 1501128342UL, 1567864246UL, 1601010847UL, 516550987UL, 3268308948UL, 3337564231UL, 3918802424UL, 2704241781UL, 3973484473UL, 
2098537451UL, 51515980UL, 3551394489UL, 3602010532UL, 4251661633UL, 2273586703UL, 376085505UL, 885459498UL, 2922957328UL, 3190791788UL, 2165301314UL, 2332030190UL, 3197056515UL, 1649666443UL, 2991976613UL, 2992780663UL, 3027279789UL, 2385348906UL, 2848531519UL, 1399789494UL, 661805703UL, 3782305562UL, 2163075465UL, 320781315UL, 1942736967UL, 2024733363UL, 485434612UL, 2680597981UL, 3598892066UL, 4122704494UL, 3834948354UL, 1435892840UL, 
2499644163UL, 2704575422UL, 2579557838UL, 673530532UL, 493730767UL, 1124557747UL, 1908629439UL, 2821949504UL, 1743112513UL, 2849457841UL, 2344409314UL, 3479159262UL, 4260973770UL, 2991970754UL, 3812641863UL, 2229319917UL, 2466968521UL, 1766353737UL, 3216591612UL, 2113272648UL, 364370737UL, 1893001758UL, 2608875275UL, 4224057183UL, 3546705413UL, 1999778009UL, 348872225UL, 2470564216UL, 1417878284UL, 2709790112UL, 3579129936UL, 2137971615UL, 
4046639861UL, 2841156930UL, 391544737UL, 2056567354UL, 737657378UL, 3877904725UL, 578930752UL, 1759172471UL, 3383278785UL, 1047197514UL, 649468151UL, 3452867243UL, 1792089520UL, 63936215UL, 3909143729UL, 3753489875UL, 734314122UL, 2490530916UL, 3043874586UL, 1504812057UL, 59001199UL, 2493748676UL, 2552438622UL, 1889694845UL, 3715397860UL, 2817245010UL, 3841049206UL, 816106718UL, 2176130406UL, 640254735UL, 12376903UL, 3000264936UL, 
3304116079UL, 1620334094UL, 2109391765UL, 1348210951UL, 2237645681UL, 1207768272UL, 1562894669UL, 2156631655UL, 1387193235UL, 3154858817UL, 633510901UL, 2312190757UL, 402878244UL, 2501565021UL, 2984409334UL, 4167491216UL, 3614267292UL, 3078552271UL, 971722322UL, 3065543880UL, 2307584190UL, 491480322UL, 2068673112UL, 1929780632UL, 178549964UL, 983979983UL, 2769314886UL, 4214442042UL, 2977609682UL, 25450683UL, 3075212658UL, 1571149568UL, 
3531670561UL, 42782504UL, 425601306UL, 428715214UL, 497250251UL, 693520802UL, 166426814UL, 1786382125UL, 2712003995UL, 3610802197UL, 2076490757UL, 404822980UL, 3953184772UL, 1655231947UL, 3594351577UL, 3068232274UL, 3771730346UL, 4110519574UL, 3534704897UL, 2375277865UL, 3597780202UL, 3472676002UL, 1350276449UL, 3218248239UL, 3589255283UL, 3253132633UL, 1769885529UL, 3792812294UL, 120332643UL, 1219374788UL, 3608889019UL, 2386099811UL, 
858495304UL, 1284785543UL, 331370962UL, 2259419662UL, 2519864134UL, 3194739432UL, 2669074511UL, 2565559140UL, 3378072004UL, 2647801475UL, 265068954UL, 1464416963UL, 1232787612UL, 4160089759UL, 2510685972UL, 670300081UL, 2509357766UL, 1981891975UL, 4161588397UL, 1371924626UL, 44760868UL, 634955171UL, 1187096933UL, 3324788972UL, 3576888559UL, 2801347752UL, 3730298395UL, 1702170762UL, 4206083415UL, 741409141UL, 3649731355UL, 1025429529UL, 
},
{
91444490UL, 628576944UL, 4069219862UL, 2253058925UL, 492354082UL, 1191182242UL, 1565180119UL, 2257613723UL, 456055162UL, 605712223UL, 953365104UL, 3104638527UL, 1133984729UL, 2662828416UL, 2134948274UL, 1921384447UL, 843719355UL, 588432962UL, 1734575434UL, 2924140067UL, 483396548UL, 3848838894UL, 3155476556UL, 1760928304UL, 4168059840UL, 3279827269UL, 2644461735UL, 4168565656UL, 3951563569UL, 1276805504UL, 1708974143UL, 1878547888UL, 
3465220024UL, 3062086782UL, 2801401651UL, 1510428126UL, 716404149UL, 1646021208UL, 3534932385UL, 1186585561UL, 651997355UL, 282914223UL, 352224857UL, 3764407517UL, 1059868753UL, 1971798134UL, 978904005UL, 976413661UL, 4039544152UL, 498989693UL, 2565125471UL, 2782642813UL, 3537961025UL, 1194967362UL, 169217024UL, 3491609UL, 1319592872UL, 1630206561UL, 2497130840UL, 1685008996UL, 2828944016UL, 3301346775UL, 2893072371UL, 2606559798UL, 
4026138031UL, 2664450619UL, 691091062UL, 1079640113UL, 1417637732UL, 4081852209UL, 2197910648UL, 2310382370UL, 1000957047UL, 959936499UL, 2844551811UL, 2272766890UL, 31122394UL, 2742925483UL, 1121884686UL, 57929089UL, 2468361281UL, 2982007782UL, 2371576893UL, 177782593UL, 3603584577UL, 672057044UL, 2108452841UL, 1671338057UL, 3386908223UL, 1243029765UL, 805157552UL, 1271858417UL, 1621249501UL, 1804851492UL, 1321010403UL, 751773221UL, 
1517221627UL, 822709871UL, 104533154UL, 3578182264UL, 640541709UL, 421086624UL, 4233576392UL, 3729339369UL, 197460644UL, 773140636UL, 2158026018UL, 1756785611UL, 4011575991UL, 3569445500UL, 736117181UL, 2456162322UL, 1168189787UL, 3651312675UL, 1070291988UL, 268231205UL, 541474497UL, 3316168972UL, 3546990856UL, 830417208UL, 725960194UL, 2044207227UL, 3188997938UL, 2383298579UL, 3350316374UL, 3575011225UL, 1553111865UL, 1285013027UL, 
749371711UL, 766611716UL, 598195098UL, 2139882719UL, 2062405428UL, 3634702446UL, 3015263295UL, 223311969UL, 2622859522UL, 3888492701UL, 2955257225UL, 582625650UL, 3563756446UL, 2886083960UL, 1907546514UL, 454650902UL, 3287277541UL, 625828138UL, 2991888140UL, 1935326370UL, 4031152256UL, 702881509UL, 1427632724UL, 1345475301UL, 2577560804UL, 2858595147UL, 2533191188UL, 185662179UL, 536505093UL, 3747894147UL, 111551030UL, 370373207UL, 
2293908590UL, 91444490UL, 628576944UL, 4069219862UL, 2253058925UL, 1671484924UL, 1191182242UL, 1565180119UL, 2257613723UL, 456055162UL, 3411094744UL, 953365104UL, 3104638527UL, 1133984729UL, 2662828416UL, 2000630022UL, 1921384447UL, 843719355UL, 588432962UL, 1734575434UL, 3293926122UL, 483396548UL, 3848838894UL, 3155476556UL, 1760928304UL, 146876953UL, 3279827269UL, 2644461735UL, 4168565656UL, 3951563569UL, 3976156700UL, 1708974143UL, 
1878547888UL, 3465220024UL, 3062086782UL, 1999154400UL, 1510428126UL, 716404149UL, 1646021208UL, 3534932385UL, 2479551429UL, 651997355UL, 282914223UL, 352224857UL, 3764407517UL, 1275979651UL, 1971798134UL, 978904005UL, 976413661UL, 4039544152UL, 300654823UL, 2565125471UL, 2782642813UL, 3537961025UL, 1194967362UL, 3123973648UL, 3491609UL, 1319592872UL, 1630206561UL, 2497130840UL, 1437913158UL, 2828944016UL, 3301346775UL, 2893072371UL, 
2606559798UL, 2153172585UL, 2664450619UL, 691091062UL, 1079640113UL, 1417637732UL, 17137237UL, 2197910648UL, 2310382370UL, 1000957047UL, 959936499UL, 802137134UL, 2272766890UL, 31122394UL, 2742925483UL, 1121884686UL, 3909775167UL, 2468361281UL, 2982007782UL, 2371576893UL, 177782593UL, 3319492525UL, 672057044UL, 2108452841UL, 1671338057UL, 3386908223UL, 1878151473UL, 805157552UL, 1271858417UL, 1621249501UL, 1804851492UL, 3215921223UL, 
751773221UL, 1517221627UL, 822709871UL, 104533154UL, 361845001UL, 640541709UL, 421086624UL, 4233576392UL, 3729339369UL, 2655936801UL, 773140636UL, 2158026018UL, 1756785611UL, 4011575991UL, 587202971UL, 736117181UL, 2456162322UL, 1168189787UL, 3651312675UL, 2517883370UL, 268231205UL, 541474497UL, 3316168972UL, 3546990856UL, 2037251305UL, 725960194UL, 2044207227UL, 3188997938UL, 2383298579UL, 2665008587UL, 3575011225UL, 1553111865UL, 
1285013027UL, 749371711UL, 2163964019UL, 598195098UL, 2139882719UL, 2062405428UL, 3634702446UL, 2788202059UL, 223311969UL, 2622859522UL, 3888492701UL, 2955257225UL, 740986174UL, 3563756446UL, 2886083960UL, 1907546514UL, 454650902UL, 2426323587UL, 625828138UL, 2991888140UL, 1935326370UL, 4031152256UL, 1831149435UL, 1427632724UL, 1345475301UL, 2577560804UL, 2858595147UL, 3977153945UL, 185662179UL, 536505093UL, 3747894147UL, 111551030UL, 
4131587422UL, 2293908590UL, 91444490UL, 628576944UL, 4069219862UL, 2408189350UL, 1671484924UL, 1191182242UL, 1565180119UL, 2257613723UL, 1338069254UL, 3411094744UL, 953365104UL, 3104638527UL, 1133984729UL, 631497759UL, 2000630022UL, 1921384447UL, 843719355UL, 588432962UL, 3280318959UL, 3293926122UL, 483396548UL, 3848838894UL, 3155476556UL, 1777918163UL, 146876953UL, 3279827269UL, 2644461735UL, 4168565656UL, 2786264663UL, 3976156700UL, 
1708974143UL, 1878547888UL, 3465220024UL, 2793923820UL, 1999154400UL, 1510428126UL, 716404149UL, 1646021208UL, 3102243824UL, 2479551429UL, 651997355UL, 282914223UL, 352224857UL, 3767702588UL, 1275979651UL, 1971798134UL, 978904005UL, 976413661UL, 1951622548UL, 300654823UL, 2565125471UL, 2782642813UL, 3537961025UL, 2186817324UL, 3123973648UL, 3491609UL, 1319592872UL, 1630206561UL, 1075424534UL, 1437913158UL, 2828944016UL, 3301346775UL, 
2893072371UL, 207992406UL, 2153172585UL, 2664450619UL, 691091062UL, 1079640113UL, 3114255216UL, 17137237UL, 2197910648UL, 2310382370UL, 1000957047UL, 2548008553UL, 802137134UL, 2272766890UL, 31122394UL, 2742925483UL, 4069482373UL, 3909775167UL, 2468361281UL, 2982007782UL, 2371576893UL, 2807823912UL, 3319492525UL, 672057044UL, 2108452841UL, 1671338057UL, 12831353UL, 1878151473UL, 805157552UL, 1271858417UL, 1621249501UL, 461887094UL, 
3215921223UL, 751773221UL, 1517221627UL, 822709871UL, 1317394918UL, 361845001UL, 640541709UL, 421086624UL, 4233576392UL, 3385587450UL, 2655936801UL, 773140636UL, 2158026018UL, 1756785611UL, 1475601973UL, 587202971UL, 736117181UL, 2456162322UL, 1168189787UL, 911455077UL, 2517883370UL, 268231205UL, 541474497UL, 3316168972UL, 1500275507UL, 2037251305UL, 725960194UL, 2044207227UL, 3188997938UL, 2036633808UL, 2665008587UL, 3575011225UL, 
1553111865UL, 1285013027UL, 87868216UL, 2163964019UL, 598195098UL, 2139882719UL, 2062405428UL, 517907301UL, 2788202059UL, 223311969UL, 2622859522UL, 3888492701UL, 3926046234UL, 740986174UL, 3563756446UL, 2886083960UL, 1907546514UL, 1911066215UL, 2426323587UL, 625828138UL, 2991888140UL, 1935326370UL, 2031853435UL, 1831149435UL, 1427632724UL, 1345475301UL, 2577560804UL, 3509674153UL, 3977153945UL, 185662179UL, 536505093UL, 3747894147UL, 
1711714600UL, 4131587422UL, 2293908590UL, 91444490UL, 628576944UL, 3370678255UL, 2408189350UL, 1671484924UL, 1191182242UL, 1565180119UL, 3786239592UL, 1338069254UL, 3411094744UL, 953365104UL, 3104638527UL, 3659647225UL, 631497759UL, 2000630022UL, 1921384447UL, 843719355UL, 3364831282UL, 3280318959UL, 3293926122UL, 483396548UL, 3848838894UL, 3131266478UL, 1777918163UL, 146876953UL, 3279827269UL, 2644461735UL, 4156372383UL, 2786264663UL, 
3976156700UL, 1708974143UL, 1878547888UL, 2168041590UL, 2793923820UL, 1999154400UL, 1510428126UL, 716404149UL, 3392113666UL, 3102243824UL, 2479551429UL, 651997355UL, 282914223UL, 2085613514UL, 3767702588UL, 1275979651UL, 1971798134UL, 978904005UL, 503506384UL, 1951622548UL, 300654823UL, 2565125471UL, 2782642813UL, 1458431750UL, 2186817324UL, 3123973648UL, 3491609UL, 1319592872UL, 452433679UL, 1075424534UL, 1437913158UL, 2828944016UL, 
3301346775UL, 2333281307UL, 207992406UL, 2153172585UL, 2664450619UL, 691091062UL, 3553502652UL, 3114255216UL, 17137237UL, 2197910648UL, 2310382370UL, 3153689868UL, 2548008553UL, 802137134UL, 2272766890UL, 31122394UL, 468580641UL, 4069482373UL, 3909775167UL, 2468361281UL, 2982007782UL, 1445286890UL, 2807823912UL, 3319492525UL, 672057044UL, 2108452841UL, 1755577669UL, 12831353UL, 1878151473UL, 805157552UL, 1271858417UL, 2623540912UL, 
461887094UL, 3215921223UL, 751773221UL, 1517221627UL, 3922191946UL, 1317394918UL, 361845001UL, 640541709UL, 421086624UL, 2173849516UL, 3385587450UL, 2655936801UL, 773140636UL, 2158026018UL, 1085377158UL, 1475601973UL, 587202971UL, 736117181UL, 2456162322UL, 2158960374UL, 911455077UL, 2517883370UL, 268231205UL, 541474497UL, 943191315UL, 1500275507UL, 2037251305UL, 725960194UL, 2044207227UL, 2481150802UL, 2036633808UL, 2665008587UL, 
3575011225UL, 1553111865UL, 2301231777UL, 87868216UL, 2163964019UL, 598195098UL, 2139882719UL, 2007840238UL, 517907301UL, 2788202059UL, 223311969UL, 2622859522UL, 151920263UL, 3926046234UL, 740986174UL, 3563756446UL, 2886083960UL, 1338937928UL, 1911066215UL, 2426323587UL, 625828138UL, 2991888140UL, 2652286195UL, 2031853435UL, 1831149435UL, 1427632724UL, 1345475301UL, 289801789UL, 3509674153UL, 3977153945UL, 185662179UL, 536505093UL, 
2727322952UL, 3980498348UL, 2529622213UL, 1903052964UL, 3564714651UL, 2281240568UL, 533384122UL, 277613480UL, 1815540358UL, 282763841UL, 3669112623UL, 2572859425UL, 195220178UL, 1210883545UL, 2359703600UL, 1187537824UL, 675732974UL, 325036095UL, 708091465UL, 2556854604UL, 701006284UL, 2378459191UL, 1863513103UL, 2690918197UL, 4237307694UL, 1356483501UL, 2160905652UL, 521809106UL, 974368613UL, 3136010957UL, 2722488678UL, 3711515637UL, 
2296341459UL, 4233729945UL, 1196247571UL, 3031398071UL, 515543502UL, 1314129776UL, 3235373306UL, 1303165859UL, 1820568009UL, 559099351UL, 186876368UL, 1076102111UL, 1218809551UL, 1790301111UL, 4130210229UL, 768125358UL, 1132864749UL, 4262563773UL, 2294411020UL, 4092943985UL, 2558108246UL, 3737664949UL, 2219923393UL, 724326159UL, 4134105682UL, 4188752746UL, 3615233671UL, 1526018731UL, 2281637916UL, 2459490295UL, 3637342666UL, 777862587UL, 
39962002UL, 3772005832UL, 997473319UL, 574843584UL, 3356551974UL, 1265234427UL, 1698059437UL, 534747571UL, 1465532164UL, 3263029035UL, 534512444UL, 2343092827UL, 2375685652UL, 2497926141UL, 2377933621UL, 2212335180UL, 261114084UL, 172755755UL, 2737085495UL, 2225257145UL, 148605658UL, 1353911796UL, 357753009UL, 1778732943UL, 497635558UL, 4136467976UL, 2837964962UL, 4045039047UL, 2485296762UL, 1587587183UL, 4042904168UL, 3184240963UL, 
2393293696UL, 915444966UL, 2299938515UL, 3351580749UL, 506575598UL, 1541916825UL, 3465300401UL, 525927458UL, 681152801UL, 331660975UL, 3624685846UL, 2994172100UL, 3274369082UL, 3638287602UL, 815689760UL, 1710961092UL, 2775607076UL, 2175058103UL, 3252688367UL, 2936890483UL, 2746319120UL, 2736754UL, 1646031035UL, 2448701214UL, 2886833213UL, 3689830606UL, 3292798106UL, 300773646UL, 3125160783UL, 1247453205UL, 2746275624UL, 4011063775UL, 
904135764UL, 876847374UL, 366267234UL, 2541269205UL, 131376648UL, 1805948133UL, 3383589530UL, 2350119829UL, 2513170439UL, 4096158499UL, 4229211520UL, 2992048272UL, 1338522080UL, 1187391335UL, 2898563453UL, 2163088451UL, 1417971677UL, 2047421551UL, 902282791UL, 1143943232UL, 3568431811UL, 4059861993UL, 193362198UL, 2509297125UL, 3968551582UL, 2175686117UL, 3568936881UL, 1853177468UL, 2134063169UL, 2919389416UL, 1124914545UL, 1209806738UL, 
},
{
1199972651UL, 1035834631UL, 3177798370UL, 860834162UL, 3741677748UL, 3780327829UL, 1693730265UL, 1643429511UL, 559568669UL, 2758650294UL, 647308222UL, 3901603996UL, 1778653821UL, 3618523672UL, 2154201067UL, 4261179460UL, 3285764480UL, 3334002738UL, 3215795953UL, 91368462UL, 1883994950UL, 1506873376UL, 1527780962UL, 4046354597UL, 4081676034UL, 2389066602UL, 1574939945UL, 427845396UL, 2714836263UL, 1259019491UL, 2493238133UL, 2584034689UL, 
3151382431UL, 2171033919UL, 176883719UL, 2031844862UL, 1272380790UL, 1298975901UL, 4087222847UL, 1524000054UL, 311436877UL, 3627785554UL, 1889491722UL, 2938069193UL, 2771940687UL, 2756955968UL, 4289348777UL, 263514583UL, 887207028UL, 3522902525UL, 2273246349UL, 835377715UL, 2897243319UL, 204645450UL, 1775911983UL, 639470242UL, 2856296318UL, 3032942383UL, 2845501282UL, 1979082575UL, 202834023UL, 1876303820UL, 1434703409UL, 4240524132UL, 
848853780UL, 4188621628UL, 928095314UL, 876412914UL, 3446576392UL, 3235688990UL, 4021419931UL, 2483628986UL, 3155781890UL, 399997246UL, 1642535200UL, 3872575068UL, 1577956550UL, 3606228634UL, 609914462UL, 653194726UL, 4048067248UL, 2500767965UL, 1125167825UL, 3707628088UL, 1819135158UL, 1875618971UL, 3865851141UL, 328215079UL, 1695889194UL, 2040280471UL, 3384684457UL, 2540504961UL, 293050253UL, 525570078UL, 2655676443UL, 1392199429UL, 
3370444585UL, 1937915855UL, 2229636250UL, 247937142UL, 2534538765UL, 365841057UL, 2449431033UL, 2456532429UL, 101910696UL, 1247069485UL, 1523958293UL, 2473285670UL, 473709728UL, 3026667113UL, 2071968844UL, 324025193UL, 423064436UL, 3870800061UL, 3977393138UL, 3632553233UL, 352757977UL, 1584833348UL, 3173248650UL, 1159857686UL, 1501841977UL, 1751860798UL, 617281070UL, 1958012761UL, 4031667102UL, 3232142321UL, 3087428595UL, 2380824676UL, 
1194087757UL, 1542961747UL, 4163350364UL, 1721646249UL, 1672791861UL, 2900511710UL, 24973500UL, 1705444176UL, 713642505UL, 3017719513UL, 2090715200UL, 3521434070UL, 37117223UL, 1948295454UL, 3055840561UL, 3476120789UL, 3994249388UL, 527899063UL, 4285770666UL, 1075524023UL, 2594223535UL, 392943522UL, 171012646UL, 3515750082UL, 3414659054UL, 3501852926UL, 1493283737UL, 2662104279UL, 2033464928UL, 90134967UL, 363058647UL, 3289266998UL, 
2470752727UL, 1199972651UL, 1035834631UL, 3177798370UL, 860834162UL, 1791097822UL, 3780327829UL, 1693730265UL, 1643429511UL, 559568669UL, 3503319486UL, 647308222UL, 3901603996UL, 1778653821UL, 3618523672UL, 4294594427UL, 4261179460UL, 3285764480UL, 3334002738UL, 3215795953UL, 212518363UL, 1883994950UL, 1506873376UL, 1527780962UL, 4046354597UL, 2398655600UL, 2389066602UL, 1574939945UL, 427845396UL, 2714836263UL, 2744363872UL, 2493238133UL, 
2584034689UL, 3151382431UL, 2171033919UL, 2787053497UL, 2031844862UL, 1272380790UL, 1298975901UL, 4087222847UL, 2342953154UL, 311436877UL, 3627785554UL, 1889491722UL, 2938069193UL, 2026656505UL, 2756955968UL, 4289348777UL, 263514583UL, 887207028UL, 2097276163UL, 2273246349UL, 835377715UL, 2897243319UL, 204645450UL, 4233399907UL, 639470242UL, 2856296318UL, 3032942383UL, 2845501282UL, 28260330UL, 202834023UL, 1876303820UL, 1434703409UL, 
4240524132UL, 2455670466UL, 4188621628UL, 928095314UL, 876412914UL, 3446576392UL, 117581687UL, 4021419931UL, 2483628986UL, 3155781890UL, 399997246UL, 4254101087UL, 3872575068UL, 1577956550UL, 3606228634UL, 609914462UL, 4003279048UL, 4048067248UL, 2500767965UL, 1125167825UL, 3707628088UL, 922020515UL, 1875618971UL, 3865851141UL, 328215079UL, 1695889194UL, 625773097UL, 3384684457UL, 2540504961UL, 293050253UL, 525570078UL, 2592805114UL, 
1392199429UL, 3370444585UL, 1937915855UL, 2229636250UL, 3190958614UL, 2534538765UL, 365841057UL, 2449431033UL, 2456532429UL, 3778669305UL, 1247069485UL, 1523958293UL, 2473285670UL, 473709728UL, 720895889UL, 2071968844UL, 324025193UL, 423064436UL, 3870800061UL, 3535536111UL, 3632553233UL, 352757977UL, 1584833348UL, 3173248650UL, 2649344603UL, 1501841977UL, 1751860798UL, 617281070UL, 1958012761UL, 778965559UL, 3232142321UL, 3087428595UL, 
2380824676UL, 1194087757UL, 3880222002UL, 4163350364UL, 1721646249UL, 1672791861UL, 2900511710UL, 702936770UL, 1705444176UL, 713642505UL, 3017719513UL, 2090715200UL, 1477858694UL, 37117223UL, 1948295454UL, 3055840561UL, 3476120789UL, 464173532UL, 527899063UL, 4285770666UL, 1075524023UL, 2594223535UL, 2872629966UL, 171012646UL, 3515750082UL, 3414659054UL, 3501852926UL, 1631555059UL, 2662104279UL, 2033464928UL, 90134967UL, 363058647UL, 
4112991722UL, 2470752727UL, 1199972651UL, 1035834631UL, 3177798370UL, 4152098951UL, 1791097822UL, 3780327829UL, 1693730265UL, 1643429511UL, 153020604UL, 3503319486UL, 647308222UL, 3901603996UL, 1778653821UL, 221887019UL, 4294594427UL, 4261179460UL, 3285764480UL, 3334002738UL, 3340918862UL, 212518363UL, 1883994950UL, 1506873376UL, 1527780962UL, 430180116UL, 2398655600UL, 2389066602UL, 1574939945UL, 427845396UL, 1683639957UL, 2744363872UL, 
2493238133UL, 2584034689UL, 3151382431UL, 752704472UL, 2787053497UL, 2031844862UL, 1272380790UL, 1298975901UL, 1528220628UL, 2342953154UL, 311436877UL, 3627785554UL, 1889491722UL, 2576495467UL, 2026656505UL, 2756955968UL, 4289348777UL, 263514583UL, 3778019638UL, 2097276163UL, 2273246349UL, 835377715UL, 2897243319UL, 1060067446UL, 4233399907UL, 639470242UL, 2856296318UL, 3032942383UL, 2351047932UL, 28260330UL, 202834023UL, 1876303820UL, 
1434703409UL, 3094305336UL, 2455670466UL, 4188621628UL, 928095314UL, 876412914UL, 3785385583UL, 117581687UL, 4021419931UL, 2483628986UL, 3155781890UL, 1867816730UL, 4254101087UL, 3872575068UL, 1577956550UL, 3606228634UL, 3081878598UL, 4003279048UL, 4048067248UL, 2500767965UL, 1125167825UL, 928465955UL, 922020515UL, 1875618971UL, 3865851141UL, 328215079UL, 173810260UL, 625773097UL, 3384684457UL, 2540504961UL, 293050253UL, 2645143254UL, 
2592805114UL, 1392199429UL, 3370444585UL, 1937915855UL, 162781360UL, 3190958614UL, 2534538765UL, 365841057UL, 2449431033UL, 3105377832UL, 3778669305UL, 1247069485UL, 1523958293UL, 2473285670UL, 800971948UL, 720895889UL, 2071968844UL, 324025193UL, 423064436UL, 52577992UL, 3535536111UL, 3632553233UL, 352757977UL, 1584833348UL, 3305908059UL, 2649344603UL, 1501841977UL, 1751860798UL, 617281070UL, 264880505UL, 778965559UL, 3232142321UL, 
3087428595UL, 2380824676UL, 1127761012UL, 3880222002UL, 4163350364UL, 1721646249UL, 1672791861UL, 2368512339UL, 702936770UL, 1705444176UL, 713642505UL, 3017719513UL, 197200752UL, 1477858694UL, 37117223UL, 1948295454UL, 3055840561UL, 1588372042UL, 464173532UL, 527899063UL, 4285770666UL, 1075524023UL, 2124039914UL, 2872629966UL, 171012646UL, 3515750082UL, 3414659054UL, 818571456UL, 1631555059UL, 2662104279UL, 2033464928UL, 90134967UL, 
952712086UL, 4112991722UL, 2470752727UL, 1199972651UL, 1035834631UL, 888975816UL, 4152098951UL, 1791097822UL, 3780327829UL, 1693730265UL, 3406785510UL, 153020604UL, 3503319486UL, 647308222UL, 3901603996UL, 3753248472UL, 221887019UL, 4294594427UL, 4261179460UL, 3285764480UL, 1861431346UL, 3340918862UL, 212518363UL, 1883994950UL, 1506873376UL, 2695939612UL, 430180116UL, 2398655600UL, 2389066602UL, 1574939945UL, 2852159074UL, 1683639957UL, 
2744363872UL, 2493238133UL, 2584034689UL, 1952065633UL, 752704472UL, 2787053497UL, 2031844862UL, 1272380790UL, 3530505866UL, 1528220628UL, 2342953154UL, 311436877UL, 3627785554UL, 3410473245UL, 2576495467UL, 2026656505UL, 2756955968UL, 4289348777UL, 2856163034UL, 3778019638UL, 2097276163UL, 2273246349UL, 835377715UL, 3127280755UL, 1060067446UL, 4233399907UL, 639470242UL, 2856296318UL, 2615775011UL, 2351047932UL, 28260330UL, 202834023UL, 
1876303820UL, 619308202UL, 3094305336UL, 2455670466UL, 4188621628UL, 928095314UL, 3764894047UL, 3785385583UL, 117581687UL, 4021419931UL, 2483628986UL, 3759839215UL, 1867816730UL, 4254101087UL, 3872575068UL, 1577956550UL, 1687107439UL, 3081878598UL, 4003279048UL, 4048067248UL, 2500767965UL, 2804044146UL, 928465955UL, 922020515UL, 1875618971UL, 3865851141UL, 2359176389UL, 173810260UL, 625773097UL, 3384684457UL, 2540504961UL, 3665420733UL, 
2645143254UL, 2592805114UL, 1392199429UL, 3370444585UL, 1604709429UL, 162781360UL, 3190958614UL, 2534538765UL, 365841057UL, 3843585067UL, 3105377832UL, 3778669305UL, 1247069485UL, 1523958293UL, 293374051UL, 800971948UL, 720895889UL, 2071968844UL, 324025193UL, 3342361801UL, 52577992UL, 3535536111UL, 3632553233UL, 352757977UL, 1386594581UL, 3305908059UL, 2649344603UL, 1501841977UL, 1751860798UL, 3160423601UL, 264880505UL, 778965559UL, 
3232142321UL, 3087428595UL, 3814775120UL, 1127761012UL, 3880222002UL, 4163350364UL, 1721646249UL, 3640773034UL, 2368512339UL, 702936770UL, 1705444176UL, 713642505UL, 1717761787UL, 197200752UL, 1477858694UL, 37117223UL, 1948295454UL, 896215772UL, 1588372042UL, 464173532UL, 527899063UL, 4285770666UL, 3441409029UL, 2124039914UL, 2872629966UL, 171012646UL, 3515750082UL, 2216687886UL, 818571456UL, 1631555059UL, 2662104279UL, 2033464928UL, 
369438400UL, 329003658UL, 1503365029UL, 4215790910UL, 3264377550UL, 733526983UL, 2935318632UL, 1792331479UL, 608347530UL, 392723097UL, 1330445854UL, 3473004271UL, 1267636682UL, 2150566972UL, 2664910943UL, 2591861637UL, 409769584UL, 2943326880UL, 3746302819UL, 3162268832UL, 1028663260UL, 3206607045UL, 832105292UL, 2119405275UL, 538318455UL, 2981192295UL, 861775416UL, 609718403UL, 3531204230UL, 1904759571UL, 1262633751UL, 2375133081UL, 
460454984UL, 946700253UL, 3763898311UL, 1571175213UL, 3124410107UL, 2413420216UL, 2664177543UL, 3241803820UL, 3968067371UL, 1234860999UL, 1130471500UL, 772727786UL, 247203117UL, 576455235UL, 246297007UL, 2027348597UL, 764933887UL, 3812479771UL, 1825807084UL, 4072281412UL, 2156865781UL, 1286484847UL, 1966749063UL, 2479269303UL, 423506843UL, 3070938758UL, 653091413UL, 2267423132UL, 2004263526UL, 1374490719UL, 3871990628UL, 841138314UL, 
1260317857UL, 3887432433UL, 4025147569UL, 764233331UL, 1794763428UL, 3005903468UL, 877926770UL, 2466593927UL, 2971729561UL, 3203070565UL, 4198500026UL, 815665759UL, 2434508139UL, 1840456368UL, 2279000427UL, 17077200UL, 3178380570UL, 990304199UL, 3578008580UL, 1965763660UL, 1640352477UL, 750159594UL, 2047409402UL, 3576308245UL, 544920564UL, 1730124869UL, 1194761386UL, 3280315505UL, 147334027UL, 2870674244UL, 2076860776UL, 1100947675UL, 
2482772161UL, 401966468UL, 1610650855UL, 193868446UL, 3808157106UL, 1509130117UL, 1324484736UL, 3852893217UL, 1059179497UL, 4053543778UL, 2557844172UL, 3282312002UL, 682550058UL, 4281899173UL, 137171998UL, 3239159214UL, 2258610918UL, 426724741UL, 3502660993UL, 135977383UL, 429929363UL, 3984458137UL, 964026748UL, 2182019070UL, 3836562946UL, 515026869UL, 359030455UL, 1301694917UL, 2300414803UL, 2364654981UL, 3804876710UL, 171119249UL, 
2646785698UL, 4283509387UL, 3628087763UL, 1748227044UL, 3037141234UL, 3000413256UL, 23007314UL, 3598880509UL, 4160517314UL, 112205578UL, 1677675411UL, 734881643UL, 2830770338UL, 3470317145UL, 3306806569UL, 2635040943UL, 2671367560UL, 3528996498UL, 3878886478UL, 3114253828UL, 2721384408UL, 3175226991UL, 1393767271UL, 2651623266UL, 3767978376UL, 1269699398UL, 1100964192UL, 4169085845UL, 2086718107UL, 1286251099UL, 764751784UL, 3006878591UL, 
},

};

#endif // CURAND_XORWOW_PRECALCULATED_H_
