/*###############################################################################
# Linux Management Providers (LMP), EthernetPort provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_REGISTEREDETHERNETPORTPROFILEACCESS_H_
#define OPENDRIM_REGISTEREDETHERNETPORTPROFILEACCESS_H_

#include "EthernetPort_Common.h"

#include "OpenDRIM_RegisteredEthernetPortProfile.h"

int EthernetPort_OpenDRIM_RegisteredEthernetPortProfile_load(const CMPIBroker* broker, string& errorMessage);

int EthernetPort_OpenDRIM_RegisteredEthernetPortProfile_unload(string& errorMessage);

int EthernetPort_OpenDRIM_RegisteredEthernetPortProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredEthernetPortProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_RegisteredEthernetPortProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredEthernetPortProfile& instance, const char** properties, string& errorMessage);

int EthernetPort_OpenDRIM_RegisteredEthernetPortProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredEthernetPortProfile& newInstance, const OpenDRIM_RegisteredEthernetPortProfile& oldInstance, const char** properties, string& errorMessage);

int EthernetPort_OpenDRIM_RegisteredEthernetPortProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredEthernetPortProfile& instance, string& errorMessage);

int EthernetPort_OpenDRIM_RegisteredEthernetPortProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredEthernetPortProfile& instance, string& errorMessage);

int EthernetPort_OpenDRIM_RegisteredEthernetPortProfile_populate(OpenDRIM_RegisteredEthernetPortProfile& instance, string& errorMessage);

#endif /*OPENDRIM_REGISTEREDETHERNETPORTPROFILEACCESS_H_*/
