/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "cmpiOpenDRIM_RecordLog.h"
#include "OpenDRIM_RecordLogAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProviderSetInstance OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProviderModifyInstance
#endif

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_init(const CMPIBroker* broker);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_RecordLog> instances;
	string errorMessage;
	
	int errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_RecordLog> instances;
	string errorMessage;
	
	int errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_RecordLog instance;
	OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_RecordLog newInstance, oldInstance;
	OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCPP(_broker, ci, newInstance);
	OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_RecordLog instance;
	OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_RecordLog instance;
	OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

//CMPIAcessor - example implementation
static CMPIData accessor(const char* propertyName, void* param) {
	CMPIInstance* inst = (CMPIInstance*) param;	
	return CMGetProperty(inst, propertyName, NULL);
}

CMPIStatus OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	string errorMessage;
	CMPISelectExp* selectExp;
	CMPISelectCond* cond;
	CMPIString* str;
	int errorCode;
	CMPICount cond_count;
	vector<OpenDRIM_RecordLog> instances;
	
	selectExp = CMNewSelectExp(_broker, query, lang, NULL, &rc);
	if (selectExp == NULL || rc.rc != CMPI_RC_OK) goto EXIT;
	
	errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_retrieve(_broker, ctx, instances, NULL, errorMessage, "ei");
	if (errorCode != OK) {
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		goto EXIT;
	}
	
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCMPIInstance(_broker, instances[i]);
		//if you want to use a CMPIAccessor, modify here.
		if (selectExp->ft->evaluate(selectExp, ci, &rc))
		//if (selectExp->ft->evaluateUsingAccessor(selectExp, accessor, (void*)ci, &rc))
			CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
EXIT:
	if (rc.rc != CMPI_RC_OK) {
		errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ":" + (string) CMGetCharPtr(rc.msg);
		CMSetStatusWithChars(_broker, &rc, rc.rc, errorMessage.c_str());
	}	
	_L_;
	return rc;
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                        Method Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProviderMethodCleanup(CMPIMethodMI * mi, const CMPIContext * ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProviderInvokeMethod(CMPIMethodMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* methodName, const CMPIArgs* in, CMPIArgs* out) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_RecordLog instance;
	OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCPP(_broker, ref, instance);
	string errorMessage;

	const char* properties[] = {"InstanceID"};
	int errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}

	if ((string) methodName =="RequestStateChange") {
		unsigned int returnValue;
		OpenDRIM_RecordLog_RequestStateChange_In inArgs;
		OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCPP(_broker, in, inArgs);
		OpenDRIM_RecordLog_RequestStateChange_Out outArgs;
		
		errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_RequestStateChange(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="ClearLog") {
		unsigned int returnValue;
		
		errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_ClearLog(_broker, ctx, instance, returnValue, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else {
		errorMessage = (string) OpenDRIM_RecordLog_classnames[0] + ": " + "The requested method (" + (string) methodName +") was not found.";
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) NOT_SUPPORTED, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	CMReturn(CMPI_RC_OK);
}

/* ---------------------------------------------------------------------------*/
/*                    End of Method Provider Interface                        */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_init FAILED: " + (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_unload FAILED: " + (string) OpenDRIM_RecordLog_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_INIT if (OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_init(_broker) < 0) return NULL

CMInstanceMIStub(OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProvider, OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProvider, _broker, OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_INIT);
CMMethodMIStub(OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProvider, OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogProvider, _broker, OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
