/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.accept.AbstractMappingContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterContentNegotiationStrategy
extends AbstractMappingContentNegotiationStrategy {
    private static final Log logger = LogFactory.getLog(ParameterContentNegotiationStrategy.class);
    private String parameterName = "format";

    public ParameterContentNegotiationStrategy(Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
        Assert.notEmpty(mediaTypes, (String)"Cannot look up media types without any mappings");
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    @Override
    protected String getMediaTypeKey(NativeWebRequest webRequest) {
        return webRequest.getParameter(this.parameterName);
    }

    @Override
    protected void handleMatch(String mediaTypeKey, MediaType mediaType) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requested media type is '" + mediaType + "' (based on parameter '" + this.parameterName + "'='" + mediaTypeKey + "')"));
        }
    }
}

