# ./play.it adventure games collection

## Description

./play.it is a free software building native packages from installers for Windows or Linux, mainly those sold by stores focusing on DRM-free games distribution. The goal is that a game installed via ./play.it is indistinguishable from a game installed via the official repositories of your favourite distribution.

This specific collection includes only adventure games. These games usually focus on the narrative and should require no fast action from the player. Aside from the narrative, the main drives for the player should be exploration and problem solving.

## Installation

### Distributions providing ./play.it

The following distributions provide installation instructions in their official documentation:

- [Debian]
- [Gentoo]
- [Ubuntu] (French article)

[Debian]: https://wiki.debian.org/Games/PlayIt#Installation
[Gentoo]: https://wiki.gentoo.org/wiki/Play.it#Installation
[Ubuntu]: https://doc.ubuntu-fr.org/play.it#installation

In most cases, these instructions should work in the same way for derivatives of these distributions.

### Installation from git

If your distribution does not already have a package for ./play.it, you can install it from this git repository.

```
git clone --branch main --depth 1 https://git.dotslashplay.it/games-adventure play.it-adventure.git
cd play.it-adventure.git
make install
```

## Usage

Usage instructions are provided on the main ./play.it repository: [./play.it: Installer for DRM-free commercial games — Usage]

[./play.it: Installer for DRM-free commercial games — Usage]: https://git.dotslashplay.it/scripts/about/#usage

## Supported games

- A Bird Story
- A Mortician's Tale
- A New Beginning
- A Space Adventure
- A Vampyre Story
- A Year of Springs
- Agatha Christie: The ABC Murders
- Agent A: A puzzle in disguise
- Amerzone: The Explorer's Legacy
- Anna's Quest
- Astrologaster
- Bad End Theater
- Bear With Me
- Before Your Eyes
- Behind the Frame: The Finest Scenery
- Botanicula
- Broken Age
- Broken Minds
- Broken Sword series:
    - Broken Sword: Shadow of the Templars
    - Broken Sword 2: The Smoking Mirror
    - Broken Sword 3: The Sleeping Dragon
    - Broken Sword 4: The Angel of Death
- Catie in MeowmeowLand
- Chook & Sosig: Walk the Plank
- Citizen Sleeper
- Coffee Talk
- Dagon: by H. P. Lovecraft
- Dead Synchronicity: Tomorrow Comes Today
- Demetrios - The Big Cynical Adventure
- Deponia series:
    - Deponia
    - Deponia 2: Chaos on Deponia
    - Deponia 3: Goodbye Deponia
- Detective Gallo
- Detective Grimoire
- Dream Daddy
- Dropsy
- Edna & Harvey series:
    - Edna & Harvey: The Breakout
    - Edna & Harvey: Harvey's New Eyes
- Finding Paradise
- Fire!
- Firewatch
- Fran Bow
- Gemini Rue
- Goetia
- Gomo
- Gone Home
- Grim Fandango
- Hamilton: The Dating Sim
- Harry Potter setting:
    - Harry Potter and the Mysterious Thief - Part 1
    - Harry Potter and the Mysterious Thief - Part 2
    - Harry Potter and the Transformency Spell
- Hatoful Boyfriend
- Higurashi When They Cry Hou - Ch.1 Onikakushi
- I Have No Mouth And I Must Scream
- Indiana Jones games:
    - Indiana Jones and the Last Crusade
    - Indiana Jones and the Fate of Atlantis
- Inspector Waffles
- Irony Curtain
- Jenny LeClue - Detectivú
- J.U.L.I.A Among the Stars
- Kentucky Route Zero
- Lamplight City
- Later Daters
- Leisure Suit Larry series:
    - Leisure Suit Larry 1: In the Land of the Lounge Lizards
    - Leisure Suit Larry 2: Looking For Love (In Several Wrong Places)
    - Leisure Suit Larry 3: Passionate Patti in Pursuit of the Pulsating Pectorals!
    - Leisure Suit Larry 5: Passionate Patti Does a Little Undercover Work!
    - Leisure Suit Larry 6: Shape Up Or Slip Out
    - Leisure Suit Larry 7: Love for Sail!
- Letters - a written adventure
- Liar Liar series:
    - Liar Liar
    - Lair Liar 2: Pants on Fire
- Life is Strange
- Lilly Looking Through
- Little Misfortune
- Loom
- Lost Phone series:
    - A Normal Lost Phone
    - Another Lost Phone: Laura's Story
- MechaNika
- Memoranda
- Nine Noir Lives
- Old Man's Journey
- One-Eyed Lee series:
    - One-Eyed Lee: Prologue
    - One-Eyed Lee and the Dinner Party
- Oxenfree
- Rakuen
- Resonance
- Return to Mysterious Island series:
    - Return to Mysterious Island
    - Return to Mysterious Island 2
- Sherlock Holmes series (by Frogwares):
    - Sherlock Holmes: The Case of the Silver Earring
    - Sherlock Holmes: The Awakened
    - Sherlock Holmes: Nemesis
    - Sherlock Holmes Versus Jack the Ripper
    - The Testament of Sherlock Holmes
    - Sherlock Holmes: Crimes and Punishments
    - Sherlock Holmes: The Devil's Daughter
- Silence
- Strangeland
- Syberia series:
    - Syberia
    - Syberia 2 
    - Syberia 3
    - Syberia: The World Before
- Technobabylon
- The Book of Unwritten Tales series:
    - The Book of Unwritten Tales
    - The Critter Chronicles
    - The Book of Unwritten Tales 2
- The Dark Eye series:
    - The Dark Eye: Chains of Satinav
    - The Dark Eye: Memoria
- The Dream Machine
- The Excavation of Hob's Barrow
- The First Tree
- The Inner World series:
    - The Inner World
    - The Inner World: The Last Wind Monk
- The Interactive Adventures of Dog Mendonça and Pizzaboy
- The Lion's Song
- The Longest Journey series:
    - The Longest Journey
    - Dreamfall Chapters
- The Night of the Rabbit
- The Pillars of the Earth
- The Shivah
- The Suicide of Rachel Foster
- The Tail Makes the Fox
- The Whispered World
- To The Moon
- Torin's Passage
- Tormentum: Dark Sorrow
- True Fear series:
    - True Fear: Forsaken Souls Part 1
    - True Fear: Forsaken Souls Part 2
- Tsioque
- Voodoo Detective
- Wallace and Gromit's Grand Adventures series:
    - Wallace and Gromit's Grand Adventures - Episode 1: Fright of the Bumblebees
    - Wallace and Gromit's Grand Adventures - Episode 2: The Last Resort
    - Wallace and Gromit's Grand Adventures - Episode 3: Muzzled
    - Wallace and Gromit's Grand Adventures - Episode 4: The Bogey Man
- Warm
- When The Past Was Around
- Whispers of a Machine
- Zork series:
    - Zork 1: The Great Underground Empire
    - Zork 2: The Wizard of Frobozz
    - Zork 3: The Dungeon Master
    - Beyond Zork: The Coconut of Quendor

## Contact informations

### IRC channel

Some ./play.it developers and users can be reached on IRC, channel is `#play.it` on network `irc.oftc.net`. The main language on this IRC channel is English, but most of us can speak French too.

### E-mail

A contact e-mail for feedback can usually be found in each ./play.it game script, as well as in the library. Open one of these files with any text editor to see the contact e-mail.

### Fediverse

./play.it has an account on the Fediverse, you can follow it for news about the development or use it to contact us: [@playit@fediverse.dotslashplay.it]

[@playit@fediverse.dotslashplay.it]: https://fediverse.dotslashplay.it/snac/playit
