#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
set -o errexit

###
# Sherlock Holmes: The Case of the Silver Earring
# send your bug reports to contact@dotslashplay.it
###

script_version=20230128.4

GAME_ID='sherlock-holmes-2-the-case-of-the-silver-earring'
GAME_NAME='Sherlock Holmes: The Case of the Silver Earring'

ARCHIVE_BASE_0='setup_sherlock_holmes_secret_of_the_silver_earring_2.1.0.9.exe'
ARCHIVE_BASE_0_MD5='877e21a4e439793df05acb06bcd27817'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1500000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.1.0.9'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/sherlock_holmes_secret_of_the_silver_earring'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
binkw32.dll
game.exe
setup.ini'
CONTENT_GAME_DATA_FILES='
characters
fonts
graphics
movies
scenes
script
sound.0000
text
textures.0000'
CONTENT_DOC_DATA_FILES='
manual.pdf'

USER_PERSISTENT_DIRECTORIES='
save'

APP_MAIN_EXE='game.exe'
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=101 --language=1049'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

target_version='2.20'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icon

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
