#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Syberia 3
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220509.1

# Set game-specific variables

GAME_ID='syberia-3'
GAME_NAME='Syberia 3'

ARCHIVE_BASE_0='setup_syberia3_1.5.07_(16263).exe'
ARCHIVE_BASE_0_MD5='0acae86c6b8731b59813f7e52b65dadd'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_syberia3_1.5.07_(16263)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='233220fefc9729dc0929807b303796b6'
ARCHIVE_BASE_0_PART1_TYPE='data'
ARCHIVE_BASE_0_PART2='setup_syberia3_1.5.07_(16263)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='74b45a17b099e37118b60c949138a641'
ARCHIVE_BASE_0_PART2_TYPE='data'
ARCHIVE_BASE_0_PART3='setup_syberia3_1.5.07_(16263)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='0f835206b87821446fd93c2c739a285a'
ARCHIVE_BASE_0_PART3_TYPE='data'
ARCHIVE_BASE_0_PART4='setup_syberia3_1.5.07_(16263)-4.bin'
ARCHIVE_BASE_0_PART4_MD5='150ed8843be777abd765b79df2aaf314'
ARCHIVE_BASE_0_PART4_TYPE='data'
ARCHIVE_BASE_0_PART5='setup_syberia3_1.5.07_(16263)-5.bin'
ARCHIVE_BASE_0_PART5_MD5='67c6e4d76b778f7d5fd02f5df561bb11'
ARCHIVE_BASE_0_PART5_TYPE='data'
ARCHIVE_BASE_0_SIZE='40000000'
ARCHIVE_BASE_0_VERSION='1.5.07-gog16263'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/syberia_3_the_complete_journey'

UNITY3D_NAME='syberia3'

CONTENT_PATH_DEFAULT='app'
ARCHIVE_GAME_BIN_FILES="
${UNITY3D_NAME}.exe
${UNITY3D_NAME}_data/plugins
${UNITY3D_NAME}_data/mono"
ARCHIVE_GAME_DATA_SHAREDASSETS_1_FILES="
${UNITY3D_NAME}_data/sharedassets?.*
${UNITY3D_NAME}_data/sharedassets1?.*
${UNITY3D_NAME}_data/sharedassets2?.*
${UNITY3D_NAME}_data/sharedassets3?.*
${UNITY3D_NAME}_data/sharedassets4?.*"
ARCHIVE_GAME_DATA_SHAREDASSETS_2_FILES="
${UNITY3D_NAME}_data/sharedassets5?.*
${UNITY3D_NAME}_data/sharedassets6?.*
${UNITY3D_NAME}_data/sharedassets7?.*
${UNITY3D_NAME}_data/sharedassets8?.*"
ARCHIVE_GAME_DATA_SHAREDASSETS_3_FILES="
${UNITY3D_NAME}_data/sharedassets9?.*
${UNITY3D_NAME}_data/sharedassets10?.*
${UNITY3D_NAME}_data/sharedassets11?.*
${UNITY3D_NAME}_data/sharedassets12?.*"
ARCHIVE_GAME_DATA_SHAREDASSETS_4_FILES="
${UNITY3D_NAME}_data/sharedassets*"
ARCHIVE_GAME_DATA_STREAMINGASSETS_FILES="
${UNITY3D_NAME}_data/streamingassets"
ARCHIVE_GAME_DATA_FILES="
${UNITY3D_NAME}_data
syberia3.dat"

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"
APP_MAIN_ICON="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA_SHAREDASSETS_1 PKG_DATA_SHAREDASSETS_2 PKG_DATA_SHAREDASSETS_3 PKG_DATA_SHAREDASSETS_4 PKG_DATA_STREAMINGASSETS PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_DATA_SHAREDASSETS_1_ID="${PKG_DATA_ID}-sharedassets-1"
PKG_DATA_SHAREDASSETS_1_DESCRIPTION="$PKG_DATA_DESCRIPTION - shared assets - 1"
PKG_DATA_DEPS="$PKG_DATA_DEPS $PKG_DATA_SHAREDASSETS_1_ID"

PKG_DATA_SHAREDASSETS_2_ID="${PKG_DATA_ID}-sharedassets-2"
PKG_DATA_SHAREDASSETS_2_DESCRIPTION="$PKG_DATA_DESCRIPTION - shared assets - 2"
PKG_DATA_DEPS="$PKG_DATA_DEPS $PKG_DATA_SHAREDASSETS_2_ID"

PKG_DATA_SHAREDASSETS_3_ID="${PKG_DATA_ID}-sharedassets-3"
PKG_DATA_SHAREDASSETS_3_DESCRIPTION="$PKG_DATA_DESCRIPTION - shared assets - 3"
PKG_DATA_DEPS="$PKG_DATA_DEPS $PKG_DATA_SHAREDASSETS_3_ID"

PKG_DATA_SHAREDASSETS_4_ID="${PKG_DATA_ID}-sharedassets-4"
PKG_DATA_SHAREDASSETS_4_DESCRIPTION="$PKG_DATA_DESCRIPTION - shared assets - 4"
PKG_DATA_DEPS="$PKG_DATA_DEPS $PKG_DATA_SHAREDASSETS_4_ID"

PKG_DATA_STREAMINGASSETS_ID="${PKG_DATA_ID}-streamingassets"
PKG_DATA_STREAMINGASSETS_DESCRIPTION="$PKG_DATA_DESCRIPTION - streaming assets"
PKG_DATA_DEPS="$PKG_DATA_DEPS $PKG_DATA_STREAMINGASSETS_ID"

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

APP_WINE_LINK_DIRS="$APP_WINE_LINK_DIRS"'
userdata:users/${USER}/AppData/LocalLow/Microids/Syberia3'
DATA_DIRS="$DATA_DIRS ./userdata"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
