/* 2000-04-19T13:26:05Z
 *
 * construct some tables to be included directly in emerald mine source.
 * i made this because dynamically building the tables every time sucks and i
 * need to be able to easily modify tile.h.
 *
 * this is key data which almost everything depends on.
 *
 * this is supposed to be fairly easy to read and modify. the tab values
 * are still hard coded constants but that should be less of a problem to
 * modify.
 */

#include "main_em.h"


/* ------------------------------------------------------------------------- */

/* 0=stop 1=blank */
int tile_blank[] =
{
  Xblank, 1,
  Yacid_splash_eB, 1,
  Yacid_splash_wB, 1,
  TILE_MAX
};

/* 0=stop 1=acid */
int tile_acid[] =
{
  Xblank, 1,
  Yacid_splash_eB, 1,
  Yacid_splash_wB, 1,
  Xacid_1, 1,
  Xacid_2, 1,
  Xacid_3, 1,
  Xacid_4, 1,
  Xacid_5, 1,
  Xacid_6, 1,
  Xacid_7, 1,
  Xacid_8, 1,
  TILE_MAX
};

/* 0=stop 1=amoeba */
int tile_amoeba[] =
{
  Xdripper, 1,
  XdripperB, 1,
  Xamoeba_1, 1,
  Xamoeba_2, 1,
  Xamoeba_3, 1,
  Xamoeba_4, 1,
  Xamoeba_5, 1,
  Xamoeba_6, 1,
  Xamoeba_7, 1,
  Xamoeba_8, 1,
  TILE_MAX
};

/* 0=stop 1=move */
int tile_android_move[] =
{
  Xblank, 1,
  Yacid_splash_eB, 1,
  Yacid_splash_wB, 1,
  Xplant, 1,
  TILE_MAX
};


/* ------------------------------------------------------------------------- */

/* explosions: special format */
/* everything is initially filled with Xboom_1 */
int tile_explode[] =
{
  ZBORDER,
  Znormal,
  Zdynamite,
  Xboom_bug,
  Xboom_bomb,
  Xboom_android,
  Xandroid,
  Xandroid_1_n,
  Xandroid_2_n,
  Xandroid_1_e,
  Xandroid_2_e,
  Xandroid_1_s,
  Xandroid_2_s,
  Xandroid_1_w,
  Xandroid_2_w,
  Xacid_ne,
  Xacid_nw,
  Xacid_s,
  Xacid_se,
  Xacid_sw,
  Xacid_1,
  Xacid_2,
  Xacid_3,
  Xacid_4,
  Xacid_5,
  Xacid_6,
  Xacid_7,
  Xacid_8,
  Xdoor_1,
  Xdoor_2,
  Xdoor_3,
  Xdoor_4,
  Xdoor_5,
  Xdoor_6,
  Xdoor_7,
  Xdoor_8,
  Xplant,
  Yplant,
  Xfake_door_1,
  Xfake_door_2,
  Xfake_door_3,
  Xfake_door_4,
  Xfake_door_5,
  Xfake_door_6,
  Xfake_door_7,
  Xfake_door_8,
  Xsteel_1,
  Xsteel_2,
  Xsteel_3,
  Xsteel_4,
  TILE_MAX, 			/* up till here are indestructable */

  Xbug_n, Xboom_bug,
  Xbug_e, Xboom_bug,
  Xbug_s, Xboom_bug,
  Xbug_w, Xboom_bug,
  Xbug_gon, Xboom_bug,
  Xbug_goe, Xboom_bug,
  Xbug_gos, Xboom_bug,
  Xbug_gow, Xboom_bug,
  Xbomb, Xboom_bomb,
  Xbomb_pause, Xboom_bomb,
  Xbomb_fall, Xboom_bomb,
  TILE_MAX, 			/* up till here are special explosions */

  Xandroid, Xboom_android,
  Xandroid_1_n, Xboom_android,
  Xandroid_2_n, Xboom_android,
  Xandroid_1_e, Xboom_android,
  Xandroid_2_e, Xboom_android,
  Xandroid_1_s, Xboom_android,
  Xandroid_2_s, Xboom_android,
  Xandroid_1_w, Xboom_android,
  Xandroid_2_w, Xboom_android,
  TILE_MAX			/* up until here are dynamite explosions */
};


/* ------------------------------------------------------------------------- */

/* map the graphics file to internal tiles and animations
 *
 * one graphics icon maps to many tiles and animations
 */

int obj_map[] =
{
  /* special */

  Ystone_sB, 7,
  Xsand_stonein_4, 7,
  -1,
  Xsand_stonein_4, 5,
  Xsand_stonein_4, 6,
  -1,
  Ystone_sB, 6,
  Xsand_stonein_4, 3,
  Xsand_stonein_4, 4,
  -1,
  Xsand_stonein_4, 1,
  Xsand_stonein_4, 2,
  -1,
  Ystone_sB, 5,
  Xsand_stonein_3, 7,
  Xsand_stonein_4, 0,
  -1,
  Xsand_stonein_3, 5,
  Xsand_stonein_3, 6,
  -1,
  Ystone_sB, 4,
  Xsand_stonein_3, 3,
  Xsand_stonein_3, 4,
  -1,
  Xsand_stonein_3, 1,
  Xsand_stonein_3, 2,
  -1,
  Ystone_sB, 3,
  Xsand_stonein_2, 7,
  Xsand_stonein_3, 0,
  -1,
  Xsand_stonein_2, 5,
  Xsand_stonein_2, 6,
  -1,
  Ystone_sB, 2,
  Xsand_stonein_2, 3,
  Xsand_stonein_2, 4,
  -1,
  Xsand_stonein_2, 1,
  Xsand_stonein_2, 2,
  -1,
  Ystone_sB, 1,
  Xsand_stonein_1, 7,
  Xsand_stonein_2, 0,
  -1,
  Xsand_stonein_1, 5,
  Xsand_stonein_1, 6,
  -1,
  Ystone_sB, 0,
  Xsand_stonein_1, 3,
  Xsand_stonein_1, 4,
  -1,
  Xsand_stonein_1, 1,
  Xsand_stonein_1, 2,
  -1,
  Xstone, 0,
  Xstone, 1,
  Xstone, 2,
  Xstone, 3,
  Xstone, 4,
  Xstone, 5,
  Xstone, 6,
  Xstone, 7,
  Xstone_pause, 0,
  Xstone_pause, 1,
  Xstone_pause, 2,
  Xstone_pause, 3,
  Xstone_pause, 4,
  Xstone_pause, 5,
  Xstone_pause, 6,
  Xstone_pause, 7,
  Xstone_fall, 0,
  Xstone_fall, 1,
  Xstone_fall, 2,
  Xstone_fall, 3,
  Xstone_fall, 4,
  Xstone_fall, 5,
  Xstone_fall, 6,
  Xstone_fall, 7,

#ifdef BAD_ROLL
  Xstone_force_e, 0,
  Xstone_force_e, 1,
  Xstone_force_e, 2,
  Xstone_force_e, 3,
  Xstone_force_e, 4,
  Xstone_force_e, 5,
  Xstone_force_e, 6,
  Xstone_force_e, 7,
  Xstone_force_w, 0,
  Xstone_force_w, 1,
  Xstone_force_w, 2,
  Xstone_force_w, 3,
  Xstone_force_w, 4,
  Xstone_force_w, 5,
  Xstone_force_w, 6,
  Xstone_force_w, 7,
#endif

  Ystone_s, 7,
  Xsand_stoneout_2, 7,
  Xsand_stonein_1, 0,
  Ystone_e, 7,
  Ystone_w, 7,
  Ydiamond_stone, 7,
  -1,
  -1,
  Ystone_s, 6,
  Xsand_stoneout_2, 6,
  -1,
  -1,
  Ystone_s, 5,
  Xsand_stoneout_2, 5,
  -1,
  -1,
  Ystone_s, 4,
  Xsand_stoneout_2, 4,
  -1,
  Xsand_stoneout_2, 3,
  -1,
  Ystone_s, 3,
  Xsand_stoneout_2, 2,
  -1,
  Xsand_stoneout_2, 1,
  -1,
  Ystone_s, 2,
  Xsand_stoneout_2, 0,
  -1,
  Xsand_stoneout_1, 7,
  Xsand_stoneout_1, 6,
  -1,
  Ystone_s, 1,
  Xsand_stoneout_1, 5,
  -1,
  Xsand_stoneout_1, 4,
  Xsand_stoneout_1, 3,
  -1,
  Ystone_s, 0,
  Xsand_stoneout_1, 2,
  -1,
  Xsand_stoneout_1, 1,
  Xsand_stoneout_1, 0,
  -1,

#if 0
  /* use normal "Xblank" instead of explicit x==0, y==2 empty space graphic */
  Ynut_sB, 7,
#endif

  -1,
  -1,
  Ynut_sB, 6,
  -1,
  -1,
  Ynut_sB, 5,
  -1,
  -1,
  Ynut_sB, 4,
  -1,
  -1,
  Ynut_sB, 3,
  -1,
  -1,
  Ynut_sB, 2,
  -1,
  -1,
  Ynut_sB, 1,
  -1,
  -1,
  Ynut_sB, 0,
  -1,
  -1,
  Ynut_s, 7,
  Ynut_e, 7,
  Ynut_w, 7,
  Xnut, 0,
  Xnut, 1,
  Xnut, 2,
  Xnut, 3,
  Xnut, 4,
  Xnut, 5,
  Xnut, 6,
  Xnut, 7,
  Xnut_pause, 0,
  Xnut_pause, 1,
  Xnut_pause, 2,
  Xnut_pause, 3,
  Xnut_pause, 4,
  Xnut_pause, 5,
  Xnut_pause, 6,
  Xnut_pause, 7,
  Xnut_fall, 0,
  Xnut_fall, 1,
  Xnut_fall, 2,
  Xnut_fall, 3,
  Xnut_fall, 4,
  Xnut_fall, 5,
  Xnut_fall, 6,
  Xnut_fall, 7,

#ifdef BAD_ROLL
  Xnut_force_e, 0,
  Xnut_force_e, 1,
  Xnut_force_e, 2,
  Xnut_force_e, 3,
  Xnut_force_e, 4,
  Xnut_force_e, 5,
  Xnut_force_e, 6,
  Xnut_force_e, 7,
  Xnut_force_w, 0,
  Xnut_force_w, 1,
  Xnut_force_w, 2,
  Xnut_force_w, 3,
  Xnut_force_w, 4,
  Xnut_force_w, 5,
  Xnut_force_w, 6,
  Xnut_force_w, 7,
#endif

  -1,
  -1,
  Ynut_s, 6,
  -1,
  -1,
  Ynut_s, 5,
  -1,
  -1,
  Ynut_s, 4,
  -1,
  -1,
  Ynut_s, 3,
  -1,
  -1,
  Ynut_s, 2,
  -1,
  -1,
  Ynut_s, 1,
  -1,
  -1,
  Ynut_s, 0,
  -1,
  -1,

/* normal */

  Xblank, 0,
  Xblank, 1,
  Xblank, 2,
  Xblank, 3,
  Xblank, 4,
  Xblank, 5,
  Xblank, 6,
  Xblank, 7,
  Xfake_blank, 0,
  Xfake_blank, 1,
  Xfake_blank, 2,
  Xfake_blank, 3,
  Xfake_blank, 4,
  Xfake_blank, 5,
  Xfake_blank, 6,
  Xfake_blank, 7,
  Xdripper, 0,
  Xdripper, 1,
  Xdripper, 2,
  Xdripper, 3,
  Xdripper, 4,
  Xdripper, 5,
  Xdripper, 6,
  Xdripper, 7,
  Zplayer, 0,
  Zplayer, 1,
  Zplayer, 2,
  Zplayer, 3,
  Zplayer, 4,
  Zplayer, 5,
  Zplayer, 6,
  Zplayer, 7,
  Ydynamite_eat, 3,
  Ydynamite_eat, 4,
  Ydynamite_eat, 5,
  Ydynamite_eat, 6,
  Ydynamite_eat, 7,
  -1,
  -1,
  -1,
  -1,
  -1,

  Ystone_eB, 6,
  Ystone_w, 0,
  -1,
  Ystone_e, 6,
  Ystone_wB, 0,
  -1,
  Ystone_eB, 5,
  Ystone_w, 1,
  -1,
  Ystone_e, 5,
  Ystone_wB, 1,
  -1,
  Ystone_eB, 4,
  Ystone_w, 2,
  -1,
  Ystone_e, 4,
  Ystone_wB, 2,
  -1,
  Ystone_eB, 3,
  Ystone_w, 3,
  -1,
  Ystone_e, 3,
  Ystone_wB, 3,
  -1,
  Ystone_eB, 2,
  Ystone_w, 4,
  -1,
  Ystone_e, 2,
  Ystone_wB, 4,
  -1,
  Ystone_eB, 1,
  Ystone_w, 5,
  -1,
  Ystone_e, 1,
  Ystone_wB, 5,
  -1,
  Ystone_eB, 0,
  Ystone_w, 6,
  -1,
  Ystone_e, 0,
  Ystone_wB, 6,
  -1,

  Ynut_eB, 6,
  Ynut_w, 0,
  -1,
  Ynut_e, 6,
  Ynut_wB, 0,
  -1,
  Ynut_eB, 5,
  Ynut_w, 1,
  -1,
  Ynut_e, 5,
  Ynut_wB, 1,
  -1,
  Ynut_eB, 4,
  Ynut_w, 2,
  -1,
  Ynut_e, 4,
  Ynut_wB, 2,
  -1,
  Ynut_eB, 3,
  Ynut_w, 3,
  -1,
  Ynut_e, 3,
  Ynut_wB, 3,
  -1,
  Ynut_eB, 2,
  Ynut_w, 4,
  -1,
  Ynut_e, 2,
  Ynut_wB, 4,
  -1,
  Ynut_eB, 1,
  Ynut_w, 5,
  -1,
  Ynut_e, 1,
  Ynut_wB, 5,
  -1,
  Ynut_eB, 0,
  Ynut_w, 6,
  -1,
  Ynut_e, 0,
  Ynut_wB, 6,
  -1,

  Ybug_w_n, 7,
  Ybug_e_n, 7,
  Ybug_n, 7,
  Xbug_n, 0,
  Xbug_n, 1,
  Xbug_n, 2,
  Xbug_n, 3,
  Xbug_n, 4,
  Xbug_n, 5,
  Xbug_n, 6,
  Xbug_n, 7,
  Xbug_gon, 0,
  Xbug_gon, 1,
  Xbug_gon, 2,
  Xbug_gon, 3,
  Xbug_gon, 4,
  Xbug_gon, 5,
  Xbug_gon, 6,
  Xbug_gon, 7,
  -1,
  Ybug_n_e, 7,
  Ybug_s_e, 7,
  Ybug_e, 7,
  Xbug_e, 0,
  Xbug_e, 1,
  Xbug_e, 2,
  Xbug_e, 3,
  Xbug_e, 4,
  Xbug_e, 5,
  Xbug_e, 6,
  Xbug_e, 7,
  Xbug_goe, 0,
  Xbug_goe, 1,
  Xbug_goe, 2,
  Xbug_goe, 3,
  Xbug_goe, 4,
  Xbug_goe, 5,
  Xbug_goe, 6,
  Xbug_goe, 7,
  -1,
  Ybug_e_s, 7,
  Ybug_w_s, 7,
  Ybug_s, 7,
  Xbug_s, 0,
  Xbug_s, 1,
  Xbug_s, 2,
  Xbug_s, 3,
  Xbug_s, 4,
  Xbug_s, 5,
  Xbug_s, 6,
  Xbug_s, 7,
  Xbug_gos, 0,
  Xbug_gos, 1,
  Xbug_gos, 2,
  Xbug_gos, 3,
  Xbug_gos, 4,
  Xbug_gos, 5,
  Xbug_gos, 6,
  Xbug_gos, 7,
  -1,
  Ybug_n_w, 7,
  Ybug_s_w, 7,
  Ybug_w, 7,
  Xbug_w, 0,
  Xbug_w, 1,
  Xbug_w, 2,
  Xbug_w, 3,
  Xbug_w, 4,
  Xbug_w, 5,
  Xbug_w, 6,
  Xbug_w, 7,
  Xbug_gow, 0,
  Xbug_gow, 1,
  Xbug_gow, 2,
  Xbug_gow, 3,
  Xbug_gow, 4,
  Xbug_gow, 5,
  Xbug_gow, 6,
  Xbug_gow, 7,
  -1,
  Ybug_n, 0,
  -1,
  Ybug_nB, 0,
  -1,
  Ybug_n, 1,
  -1,
  Ybug_nB, 1,
  -1,
  Ybug_n, 2,
  -1,
  Ybug_nB, 2,
  -1,
  Ybug_n, 3,
  -1,
  Ybug_nB, 3,
  -1,
  Ybug_n, 4,
  -1,
  Ybug_nB, 4,
  -1,
  Ybug_n, 5,
  -1,
  Ybug_nB, 5,
  -1,
  Ybug_n, 6,
  -1,
  Ybug_nB, 6,
  -1,
  Ybug_eB, 6,
  -1,
  Ybug_e, 6,
  -1,
  Ybug_eB, 5,
  -1,
  Ybug_e, 5,
  -1,
  Ybug_eB, 4,
  -1,
  Ybug_e, 4,
  -1,
  Ybug_eB, 3,
  -1,
  Ybug_e, 3,
  -1,
  Ybug_eB, 2,
  -1,
  Ybug_e, 2,
  -1,
  Ybug_eB, 1,
  -1,
  Ybug_e, 1,
  -1,
  Ybug_eB, 0,
  -1,
  Ybug_e, 0,
  -1,
  Ybug_sB, 6,
  -1,
  Ybug_s, 6,
  -1,
  Ybug_sB, 5,
  -1,
  Ybug_s, 5,
  -1,
  Ybug_sB, 4,
  -1,
  Ybug_s, 4,
  -1,
  Ybug_sB, 3,
  -1,
  Ybug_s, 3,
  -1,
  Ybug_sB, 2,
  -1,
  Ybug_s, 2,
  -1,
  Ybug_sB, 1,
  -1,
  Ybug_s, 1,
  -1,
  Ybug_sB, 0,
  -1,
  Ybug_s, 0,
  -1,
  Ybug_w, 0,
  -1,
  Ybug_wB, 0,
  -1,
  Ybug_w, 1,
  -1,
  Ybug_wB, 1,
  -1,
  Ybug_w, 2,
  -1,
  Ybug_wB, 2,
  -1,
  Ybug_w, 3,
  -1,
  Ybug_wB, 3,
  -1,
  Ybug_w, 4,
  -1,
  Ybug_wB, 4,
  -1,
  Ybug_w, 5,
  -1,
  Ybug_wB, 5,
  -1,
  Ybug_w, 6,
  -1,
  Ybug_wB, 6,
  -1,
  Ybug_n_e, 0,
  Ybug_e_n, 6,
  -1,
  Ybug_n_e, 1,
  Ybug_e_n, 5,
  -1,
  Ybug_n_e, 2,
  Ybug_e_n, 4,
  -1,
  Ybug_n_e, 3,
  Ybug_e_n, 3,
  -1,
  Ybug_n_e, 4,
  Ybug_e_n, 2,
  -1,
  Ybug_n_e, 5,
  Ybug_e_n, 1,
  -1,
  Ybug_n_e, 6,
  Ybug_e_n, 0,
  -1,
  Ybug_e_s, 0,
  Ybug_s_e, 6,
  -1,
  Ybug_e_s, 1,
  Ybug_s_e, 5,
  -1,
  Ybug_e_s, 2,
  Ybug_s_e, 4,
  -1,
  Ybug_e_s, 3,
  Ybug_s_e, 3,
  -1,
  Ybug_e_s, 4,
  Ybug_s_e, 2,
  -1,
  Ybug_e_s, 5,
  Ybug_s_e, 1,
  -1,
  Ybug_e_s, 6,
  Ybug_s_e, 0,
  -1,
  Ybug_s_w, 0,
  Ybug_w_s, 6,
  -1,
  Ybug_s_w, 1,
  Ybug_w_s, 5,
  -1,
  Ybug_s_w, 2,
  Ybug_w_s, 4,
  -1,
  Ybug_s_w, 3,
  Ybug_w_s, 3,
  -1,
  Ybug_s_w, 4,
  Ybug_w_s, 2,
  -1,
  Ybug_s_w, 5,
  Ybug_w_s, 1,
  -1,
  Ybug_s_w, 6,
  Ybug_w_s, 0,
  -1,
  Ybug_n_w, 6,
  Ybug_w_n, 0,
  -1,
  Ybug_n_w, 5,
  Ybug_w_n, 1,
  -1,
  Ybug_n_w, 4,
  Ybug_w_n, 2,
  -1,
  Ybug_n_w, 3,
  Ybug_w_n, 3,
  -1,
  Ybug_n_w, 2,
  Ybug_w_n, 4,
  -1,
  Ybug_n_w, 1,
  Ybug_w_n, 5,
  -1,
  Ybug_n_w, 0,
  Ybug_w_n, 6,
  -1,
  Ybug_stone, 0,
  -1,
  Ybug_stone, 1,
  -1,
  Ybug_stone, 2,
  -1,
  Ybug_stone, 3,
  -1,
  Ybug_stone, 4,
  -1,
  Ybug_stone, 5,
  -1,
  Ybug_stone, 6,
  -1,
  Ybug_spring, 0,
  -1,
  Ybug_spring, 1,
  -1,
  Ybug_spring, 2,
  -1,
  Ybug_spring, 3,
  -1,
  Ybug_spring, 4,
  -1,
  Ybug_spring, 5,
  -1,
  Ybug_spring, 6,
  -1,

  Ytank_w_n, 7,
  Ytank_e_n, 7,
  Ytank_n, 7,
  Xtank_n, 0,
  Xtank_n, 1,
  Xtank_n, 2,
  Xtank_n, 3,
  Xtank_n, 4,
  Xtank_n, 5,
  Xtank_n, 6,
  Xtank_n, 7,
  Xtank_gon, 0,
  Xtank_gon, 1,
  Xtank_gon, 2,
  Xtank_gon, 3,
  Xtank_gon, 4,
  Xtank_gon, 5,
  Xtank_gon, 6,
  Xtank_gon, 7,
  -1,
  Ytank_n_e, 7,
  Ytank_s_e, 7,
  Ytank_e, 7,
  Xtank_e, 0,
  Xtank_e, 1,
  Xtank_e, 2,
  Xtank_e, 3,
  Xtank_e, 4,
  Xtank_e, 5,
  Xtank_e, 6,
  Xtank_e, 7,
  Xtank_goe, 0,
  Xtank_goe, 1,
  Xtank_goe, 2,
  Xtank_goe, 3,
  Xtank_goe, 4,
  Xtank_goe, 5,
  Xtank_goe, 6,
  Xtank_goe, 7,
  -1,
  Ytank_e_s, 7,
  Ytank_w_s, 7,
  Ytank_s, 7,
  Xtank_s, 0,
  Xtank_s, 1,
  Xtank_s, 2,
  Xtank_s, 3,
  Xtank_s, 4,
  Xtank_s, 5,
  Xtank_s, 6,
  Xtank_s, 7,
  Xtank_gos, 0,
  Xtank_gos, 1,
  Xtank_gos, 2,
  Xtank_gos, 3,
  Xtank_gos, 4,
  Xtank_gos, 5,
  Xtank_gos, 6,
  Xtank_gos, 7,
  -1,
  Ytank_n_w, 7,
  Ytank_s_w, 7,
  Ytank_w, 7,
  Xtank_w, 0,
  Xtank_w, 1,
  Xtank_w, 2,
  Xtank_w, 3,
  Xtank_w, 4,
  Xtank_w, 5,
  Xtank_w, 6,
  Xtank_w, 7,
  Xtank_gow, 0,
  Xtank_gow, 1,
  Xtank_gow, 2,
  Xtank_gow, 3,
  Xtank_gow, 4,
  Xtank_gow, 5,
  Xtank_gow, 6,
  Xtank_gow, 7,
  -1,
  Ytank_n, 0,
  -1,
  Ytank_nB, 0,
  -1,
  Ytank_n, 1,
  -1,
  Ytank_nB, 1,
  -1,
  Ytank_n, 2,
  -1,
  Ytank_nB, 2,
  -1,
  Ytank_n, 3,
  -1,
  Ytank_nB, 3,
  -1,
  Ytank_n, 4,
  -1,
  Ytank_nB, 4,
  -1,
  Ytank_n, 5,
  -1,
  Ytank_nB, 5,
  -1,
  Ytank_n, 6,
  -1,
  Ytank_nB, 6,
  -1,
  Ytank_eB, 6,
  -1,
  Ytank_e, 6,
  -1,
  Ytank_eB, 5,
  -1,
  Ytank_e, 5,
  -1,
  Ytank_eB, 4,
  -1,
  Ytank_e, 4,
  -1,
  Ytank_eB, 3,
  -1,
  Ytank_e, 3,
  -1,
  Ytank_eB, 2,
  -1,
  Ytank_e, 2,
  -1,
  Ytank_eB, 1,
  -1,
  Ytank_e, 1,
  -1,
  Ytank_eB, 0,
  -1,
  Ytank_e, 0,
  -1,
  Ytank_sB, 6,
  -1,
  Ytank_s, 6,
  -1,
  Ytank_sB, 5,
  -1,
  Ytank_s, 5,
  -1,
  Ytank_sB, 4,
  -1,
  Ytank_s, 4,
  -1,
  Ytank_sB, 3,
  -1,
  Ytank_s, 3,
  -1,
  Ytank_sB, 2,
  -1,
  Ytank_s, 2,
  -1,
  Ytank_sB, 1,
  -1,
  Ytank_s, 1,
  -1,
  Ytank_sB, 0,
  -1,
  Ytank_s, 0,
  -1,
  Ytank_w, 0,
  -1,
  Ytank_wB, 0,
  -1,
  Ytank_w, 1,
  -1,
  Ytank_wB, 1,
  -1,
  Ytank_w, 2,
  -1,
  Ytank_wB, 2,
  -1,
  Ytank_w, 3,
  -1,
  Ytank_wB, 3,
  -1,
  Ytank_w, 4,
  -1,
  Ytank_wB, 4,
  -1,
  Ytank_w, 5,
  -1,
  Ytank_wB, 5,
  -1,
  Ytank_w, 6,
  -1,
  Ytank_wB, 6,
  -1,
  Ytank_n_e, 0,
  Ytank_e_n, 6,
  -1,
  Ytank_n_e, 1,
  Ytank_e_n, 5,
  -1,
  Ytank_n_e, 2,
  Ytank_e_n, 4,
  -1,
  Ytank_n_e, 3,
  Ytank_e_n, 3,
  -1,
  Ytank_n_e, 4,
  Ytank_e_n, 2,
  -1,
  Ytank_n_e, 5,
  Ytank_e_n, 1,
  -1,
  Ytank_n_e, 6,
  Ytank_e_n, 0,
  -1,
  Ytank_e_s, 0,
  Ytank_s_e, 6,
  -1,
  Ytank_e_s, 1,
  Ytank_s_e, 5,
  -1,
  Ytank_e_s, 2,
  Ytank_s_e, 4,
  -1,
  Ytank_e_s, 3,
  Ytank_s_e, 3,
  -1,
  Ytank_e_s, 4,
  Ytank_s_e, 2,
  -1,
  Ytank_e_s, 5,
  Ytank_s_e, 1,
  -1,
  Ytank_e_s, 6,
  Ytank_s_e, 0,
  -1,
  Ytank_s_w, 0,
  Ytank_w_s, 6,
  -1,
  Ytank_s_w, 1,
  Ytank_w_s, 5,
  -1,
  Ytank_s_w, 2,
  Ytank_w_s, 4,
  -1,
  Ytank_s_w, 3,
  Ytank_w_s, 3,
  -1,
  Ytank_s_w, 4,
  Ytank_w_s, 2,
  -1,
  Ytank_s_w, 5,
  Ytank_w_s, 1,
  -1,
  Ytank_s_w, 6,
  Ytank_w_s, 0,
  -1,
  Ytank_n_w, 6,
  Ytank_w_n, 0,
  -1,
  Ytank_n_w, 5,
  Ytank_w_n, 1,
  -1,
  Ytank_n_w, 4,
  Ytank_w_n, 2,
  -1,
  Ytank_n_w, 3,
  Ytank_w_n, 3,
  -1,
  Ytank_n_w, 2,
  Ytank_w_n, 4,
  -1,
  Ytank_n_w, 1,
  Ytank_w_n, 5,
  -1,
  Ytank_n_w, 0,
  Ytank_w_n, 6,
  -1,
  Ytank_stone, 0,
  -1,
  Ytank_stone, 1,
  -1,
  Ytank_stone, 2,
  -1,
  Ytank_stone, 3,
  -1,
  Ytank_stone, 4,
  -1,
  Ytank_stone, 5,
  -1,
  Ytank_stone, 6,
  -1,
  Ytank_spring, 0,
  -1,
  Ytank_spring, 1,
  -1,
  Ytank_spring, 2,
  -1,
  Ytank_spring, 3,
  -1,
  Ytank_spring, 4,
  -1,
  Ytank_spring, 5,
  -1,
  Ytank_spring, 6,
  -1,

  Yandroid_n, 7,
  Yandroid_ne, 7,
  Yandroid_e, 7,
  Yandroid_se, 7,
  Yandroid_s, 7,
  Yandroid_sw, 7,
  Yandroid_w, 7,
  Yandroid_nw, 7,
  Xandroid, 7,
  Xandroid_1_n, 7,
  Xandroid_2_n, 7,
  Xandroid_1_e, 7,
  Xandroid_2_e, 7,
  Xandroid_1_w, 7,
  Xandroid_2_w, 7,
  Xandroid_1_s, 7,
  Xandroid_2_s, 7,
  -1,
  Xandroid, 0,
  Xandroid_1_n, 0,
  Xandroid_2_n, 0,
  Xandroid_1_e, 0,
  Xandroid_2_e, 0,
  Xandroid_1_w, 0,
  Xandroid_2_w, 0,
  Xandroid_1_s, 0,
  Xandroid_2_s, 0,
  -1,
  Xandroid, 1,
  Xandroid_1_n, 1,
  Xandroid_2_n, 1,
  Xandroid_1_e, 1,
  Xandroid_2_e, 1,
  Xandroid_1_w, 1,
  Xandroid_2_w, 1,
  Xandroid_1_s, 1,
  Xandroid_2_s, 1,
  -1,
  Xandroid, 2,
  Xandroid_1_n, 2,
  Xandroid_2_n, 2,
  Xandroid_1_e, 2,
  Xandroid_2_e, 2,
  Xandroid_1_w, 2,
  Xandroid_2_w, 2,
  Xandroid_1_s, 2,
  Xandroid_2_s, 2,
  -1,
  Xandroid, 3,
  Xandroid_1_n, 3,
  Xandroid_2_n, 3,
  Xandroid_1_e, 3,
  Xandroid_2_e, 3,
  Xandroid_1_w, 3,
  Xandroid_2_w, 3,
  Xandroid_1_s, 3,
  Xandroid_2_s, 3,
  -1,
  Xandroid, 4,
  Xandroid_1_n, 4,
  Xandroid_2_n, 4,
  Xandroid_1_e, 4,
  Xandroid_2_e, 4,
  Xandroid_1_w, 4,
  Xandroid_2_w, 4,
  Xandroid_1_s, 4,
  Xandroid_2_s, 4,
  -1,
  Xandroid, 5,
  Xandroid_1_n, 5,
  Xandroid_2_n, 5,
  Xandroid_1_e, 5,
  Xandroid_2_e, 5,
  Xandroid_1_w, 5,
  Xandroid_2_w, 5,
  Xandroid_1_s, 5,
  Xandroid_2_s, 5,
  -1,
  Xandroid, 6,
  Xandroid_1_n, 6,
  Xandroid_2_n, 6,
  Xandroid_1_e, 6,
  Xandroid_2_e, 6,
  Xandroid_1_w, 6,
  Xandroid_2_w, 6,
  Xandroid_1_s, 6,
  Xandroid_2_s, 6,
  -1,
  Yandroid_n, 0,
  Yandroid_sB, 6,
  -1,
  Yandroid_nB, 0,
  Yandroid_s, 6,
  -1,
  Yandroid_n, 1,
  Yandroid_sB, 5,
  -1,
  Yandroid_nB, 1,
  Yandroid_s, 5,
  -1,
  Yandroid_n, 2,
  Yandroid_sB, 4,
  Xboom_android, 0,
  -1,
  Yandroid_nB, 2,
  Yandroid_s, 4,
  Xboom_android, 1,
  -1,
  Yandroid_n, 3,
  Yandroid_sB, 3,
  Xboom_android, 2,
  -1,
  Yandroid_nB, 3,
  Yandroid_s, 3,
  Xboom_android, 3,
  -1,
  Yandroid_n, 4,
  Yandroid_sB, 2,
  Xboom_android, 4,
  -1,
  Yandroid_nB, 4,
  Yandroid_s, 2,
  Xboom_android, 5,
  -1,
  Yandroid_n, 5,
  Yandroid_sB, 1,
  Xboom_android, 6,
  -1,
  Yandroid_nB, 5,
  Yandroid_s, 1,
  -1,
  Yandroid_n, 6,
  Yandroid_sB, 0,
  -1,
  Yandroid_nB, 6,
  Yandroid_s, 0,
  -1,
  Yandroid_eB, 6,
  Yandroid_w, 0,
  -1,
  Yandroid_e, 6,
  Yandroid_wB, 0,
  -1,
  Yandroid_eB, 5,
  Yandroid_w, 1,
  -1,
  Yandroid_e, 5,
  Yandroid_wB, 1,
  -1,
  Yandroid_eB, 4,
  Yandroid_w, 2,
  -1,
  Yandroid_e, 4,
  Yandroid_wB, 2,
  -1,
  Yandroid_eB, 3,
  Yandroid_w, 3,
  -1,
  Yandroid_e, 3,
  Yandroid_wB, 3,
  -1,
  Yandroid_eB, 2,
  Yandroid_w, 4,
  -1,
  Yandroid_e, 2,
  Yandroid_wB, 4,
  -1,
  Yandroid_eB, 1,
  Yandroid_w, 5,
  -1,
  Yandroid_e, 1,
  Yandroid_wB, 5,
  -1,
  Yandroid_eB, 0,
  Yandroid_w, 6,
  -1,
  Yandroid_e, 0,
  Yandroid_wB, 6,
  -1,
  Yandroid_neB, 6,
  Yandroid_sw, 0,
  -1,
  Yandroid_ne, 6,
  Yandroid_swB, 0,
  -1,
  Yandroid_neB, 5,
  Yandroid_sw, 1,
  -1,
  Yandroid_ne, 5,
  Yandroid_swB, 1,
  -1,
  Yandroid_neB, 4,
  Yandroid_sw, 2,
  -1,
  Yandroid_ne, 4,
  Yandroid_swB, 2,
  -1,
  Yandroid_neB, 3,
  Yandroid_sw, 3,
  -1,
  Yandroid_ne, 3,
  Yandroid_swB, 3,
  -1,
  Yandroid_neB, 2,
  Yandroid_sw, 4,
  -1,
  Yandroid_ne, 2,
  Yandroid_swB, 4,
  -1,
  Yandroid_neB, 1,
  Yandroid_sw, 5,
  -1,
  Yandroid_ne, 1,
  Yandroid_swB, 5,
  -1,
  Yandroid_neB, 0,
  Yandroid_sw, 6,
  -1,
  Yandroid_ne, 0,
  Yandroid_swB, 6,
  -1,
  Yandroid_nw, 0,
  Yandroid_seB, 6,
  -1,
  Yandroid_nwB, 0,
  Yandroid_se, 6,
  -1,
  Yandroid_nw, 1,
  Yandroid_seB, 5,
  -1,
  Yandroid_nwB, 1,
  Yandroid_se, 5,
  -1,
  Yandroid_nw, 2,
  Yandroid_seB, 4,
  -1,
  Yandroid_nwB, 2,
  Yandroid_se, 4,
  -1,
  Yandroid_nw, 3,
  Yandroid_seB, 3,
  -1,
  Yandroid_nwB, 3,
  Yandroid_se, 3,
  -1,
  Yandroid_nw, 4,
  Yandroid_seB, 2,
  -1,
  Yandroid_nwB, 4,
  Yandroid_se, 2,
  -1,
  Yandroid_nw, 5,
  Yandroid_seB, 1,
  -1,
  Yandroid_nwB, 5,
  Yandroid_se, 1,
  -1,
  Yandroid_nw, 6,
  Yandroid_seB, 0,
  -1,
  Yandroid_nwB, 6,
  Yandroid_se, 0,
  -1,

  Yspring_e, 7,
  Yspring_w, 7,
  Yspring_kill_e, 7,
  Yspring_kill_w, 7,
  Yspring_s, 7,
  Xspring, 0,
  Xspring, 1,
  Xspring, 2,
  Xspring, 3,
  Xspring, 4,
  Xspring, 5,
  Xspring, 6,
  Xspring, 7,
  Xspring_pause, 0,
  Xspring_pause, 1,
  Xspring_pause, 2,
  Xspring_pause, 3,
  Xspring_pause, 4,
  Xspring_pause, 5,
  Xspring_pause, 6,
  Xspring_pause, 7,
  Xspring_e, 0,
  Xspring_e, 1,
  Xspring_e, 2,
  Xspring_e, 3,
  Xspring_e, 4,
  Xspring_e, 5,
  Xspring_e, 6,
  Xspring_e, 7,
  Xspring_w, 0,
  Xspring_w, 1,
  Xspring_w, 2,
  Xspring_w, 3,
  Xspring_w, 4,
  Xspring_w, 5,
  Xspring_w, 6,
  Xspring_w, 7,
  Xspring_fall, 0,
  Xspring_fall, 1,
  Xspring_fall, 2,
  Xspring_fall, 3,
  Xspring_fall, 4,
  Xspring_fall, 5,
  Xspring_fall, 6,
  Xspring_fall, 7,

#ifdef BAD_ROLL
  Xspring_force_e, 0,
  Xspring_force_e, 1,
  Xspring_force_e, 2,
  Xspring_force_e, 3,
  Xspring_force_e, 4,
  Xspring_force_e, 5,
  Xspring_force_e, 6,
  Xspring_force_e, 7,
  Xspring_force_w, 0,
  Xspring_force_w, 1,
  Xspring_force_w, 2,
  Xspring_force_w, 3,
  Xspring_force_w, 4,
  Xspring_force_w, 5,
  Xspring_force_w, 6,
  Xspring_force_w, 7,
#endif

  -1,
  Yspring_sB, 6,
  -1,
  Yspring_s, 6,
  -1,
  Yspring_sB, 5,
  -1,
  Yspring_s, 5,
  -1,
  Yspring_sB, 4,
  -1,
  Yspring_s, 4,
  -1,
  Yspring_sB, 3,
  -1,
  Yspring_s, 3,
  -1,
  Yspring_sB, 2,
  -1,
  Yspring_s, 2,
  -1,
  Yspring_sB, 1,
  -1,
  Yspring_s, 1,
  -1,
  Yspring_sB, 0,
  -1,
  Yspring_s, 0,
  -1,
  Yspring_eB, 6,
  Yspring_w, 0,
  -1,
  Yspring_e, 6,
  Yspring_wB, 0,
  -1,
  Yspring_eB, 5,
  Yspring_w, 1,
  -1,
  Yspring_e, 5,
  Yspring_wB, 1,
  -1,
  Yspring_eB, 4,
  Yspring_w, 2,
  -1,
  Yspring_e, 4,
  Yspring_wB, 2,
  -1,
  Yspring_eB, 3,
  Yspring_w, 3,
  -1,
  Yspring_e, 3,
  Yspring_wB, 3,
  -1,
  Yspring_eB, 2,
  Yspring_w, 4,
  -1,
  Yspring_e, 2,
  Yspring_wB, 4,
  -1,
  Yspring_eB, 1,
  Yspring_w, 5,
  -1,
  Yspring_e, 1,
  Yspring_wB, 5,
  -1,
  Yspring_eB, 0,
  Yspring_w, 6,
  -1,
  Yspring_e, 0,
  Yspring_wB, 6,
  -1,
  Yspring_kill_eB, 6,
  -1,
  Yspring_kill_e, 6,
  -1,
  Yspring_kill_eB, 5,
  -1,
  Yspring_kill_e, 5,
  -1,
  Yspring_kill_eB, 4,
  -1,
  Yspring_kill_e, 4,
  -1,
  Yspring_kill_eB, 3,
  -1,
  Yspring_kill_e, 3,
  -1,
  Yspring_kill_eB, 2,
  -1,
  Yspring_kill_e, 2,
  -1,
  Yspring_kill_eB, 1,
  -1,
  Yspring_kill_e, 1,
  -1,
  Yspring_kill_eB, 0,
  -1,
  Yspring_kill_e, 0,
  -1,
  Yspring_kill_w, 0,
  -1,
  Yspring_kill_wB, 0,
  -1,
  Yspring_kill_w, 1,
  -1,
  Yspring_kill_wB, 1,
  -1,
  Yspring_kill_w, 2,
  -1,
  Yspring_kill_wB, 2,
  -1,
  Yspring_kill_w, 3,
  -1,
  Yspring_kill_wB, 3,
  -1,
  Yspring_kill_w, 4,
  -1,
  Yspring_kill_wB, 4,
  -1,
  Yspring_kill_w, 5,
  -1,
  Yspring_kill_wB, 5,
  -1,
  Yspring_kill_w, 6,
  -1,
  Yspring_kill_wB, 6,
  -1,

  Xeater_n, 0,
  Xeater_e, 0,
  Xeater_w, 0,
  Xeater_s, 0,
  Xeater_n, 7,
  Xeater_e, 7,
  Xeater_s, 7,
  Xeater_w, 7,
  Yeater_n, 7,
  Yeater_e, 7,
  Yeater_s, 7,
  Yeater_w, 7,
  -1,
  Xeater_n, 1,
  Xeater_e, 1,
  Xeater_w, 1,
  Xeater_s, 1,
  Xeater_n, 6,
  Xeater_e, 6,
  Xeater_w, 6,
  Xeater_s, 6,
  -1,
  Xeater_n, 2,
  Xeater_e, 2,
  Xeater_w, 2,
  Xeater_s, 2,
  Xeater_n, 5,
  Xeater_e, 5,
  Xeater_w, 5,
  Xeater_s, 5,
  -1,
  Xeater_n, 3,
  Xeater_e, 3,
  Xeater_w, 3,
  Xeater_s, 3,
  Xeater_n, 4,
  Xeater_e, 4,
  Xeater_w, 4,
  Xeater_s, 4,
  -1,
  Yeater_n, 0,
  Yeater_sB, 6,
  -1,
  Yeater_nB, 0,
  Yeater_s, 6,
  -1,
  Yeater_n, 1,
  Yeater_sB, 5,
  -1,
  Yeater_nB, 1,
  Yeater_s, 5,
  -1,
  Yeater_n, 2,
  Yeater_sB, 4,
  -1,
  Yeater_nB, 2,
  Yeater_s, 4,
  -1,
  Yeater_n, 3,
  Yeater_sB, 3,
  -1,
  Yeater_nB, 3,
  Yeater_s, 3,
  -1,
  Yeater_n, 4,
  Yeater_sB, 2,
  -1,
  Yeater_nB, 4,
  Yeater_s, 2,
  -1,
  Yeater_n, 5,
  Yeater_sB, 1,
  -1,
  Yeater_nB, 5,
  Yeater_s, 1,
  -1,
  Yeater_n, 6,
  Yeater_sB, 0,
  -1,
  Yeater_nB, 6,
  Yeater_s, 0,
  -1,
  Yeater_eB, 6,
  Yeater_w, 0,
  -1,
  Yeater_e, 6,
  Yeater_wB, 0,
  -1,
  Yeater_eB, 5,
  Yeater_w, 1,
  -1,
  Yeater_e, 5,
  Yeater_wB, 1,
  -1,
  Yeater_eB, 4,
  Yeater_w, 2,
  -1,
  Yeater_e, 4,
  Yeater_wB, 2,
  -1,
  Yeater_eB, 3,
  Yeater_w, 3,
  -1,
  Yeater_e, 3,
  Yeater_wB, 3,
  -1,
  Yeater_eB, 2,
  Yeater_w, 4,
  -1,
  Yeater_e, 2,
  Yeater_wB, 4,
  -1,
  Yeater_eB, 1,
  Yeater_w, 5,
  -1,
  Yeater_e, 1,
  Yeater_wB, 5,
  -1,
  Yeater_eB, 0,
  Yeater_w, 6,
  -1,
  Yeater_e, 0,
  Yeater_wB, 6,
  -1,
  Yeater_stone, 0,
  -1,
  Yeater_stone, 1,
  -1,
  Yeater_stone, 2,
  -1,
  Yeater_stone, 3,
  -1,
  Yeater_stone, 4,
  -1,
  Yeater_stone, 5,
  -1,
  Yeater_stone, 6,
  -1,
  Yeater_spring, 0,
  -1,
  Yeater_spring, 1,
  -1,
  Yeater_spring, 2,
  -1,
  Yeater_spring, 3,
  -1,
  Yeater_spring, 4,
  -1,
  Yeater_spring, 5,
  -1,
  Yeater_spring, 6,
  -1,

  Xalien, 0,
  Xalien_pause, 0,
  Xalien, 7,
  Xalien_pause, 7,
  Yalien_n, 7,
  Yalien_e, 7,
  Yalien_s, 7,
  Yalien_w, 7,
  -1,
  Xalien, 1,
  Xalien_pause, 1,
  Xalien, 6,
  Xalien_pause, 6,
  -1,
  Xalien, 2,
  Xalien_pause, 2,
  Xalien, 5,
  Xalien_pause, 5,
  -1,
  Xalien, 3,
  Xalien_pause, 3,
  Xalien, 4,
  Xalien_pause, 4,
  -1,
  Yalien_n, 0,
  Yalien_sB, 6,
  -1,
  Yalien_nB, 0,
  Yalien_s, 6,
  -1,
  Yalien_n, 1,
  Yalien_sB, 5,
  -1,
  Yalien_nB, 1,
  Yalien_s, 5,
  -1,
  Yalien_n, 2,
  Yalien_sB, 4,
  -1,
  Yalien_nB, 2,
  Yalien_s, 4,
  -1,
  Yalien_n, 3,
  Yalien_sB, 3,
  -1,
  Yalien_nB, 3,
  Yalien_s, 3,
  -1,
  Yalien_n, 4,
  Yalien_sB, 2,
  -1,
  Yalien_nB, 4,
  Yalien_s, 2,
  -1,
  Yalien_n, 5,
  Yalien_sB, 1,
  -1,
  Yalien_nB, 5,
  Yalien_s, 1,
  -1,
  Yalien_n, 6,
  Yalien_sB, 0,
  -1,
  Yalien_nB, 6,
  Yalien_s, 0,
  -1,
  Yalien_eB, 6,
  Yalien_w, 0,
  -1,
  Yalien_e, 6,
  Yalien_wB, 0,
  -1,
  Yalien_eB, 5,
  Yalien_w, 1,
  -1,
  Yalien_e, 5,
  Yalien_wB, 1,
  -1,
  Yalien_eB, 4,
  Yalien_w, 2,
  -1,
  Yalien_e, 4,
  Yalien_wB, 2,
  -1,
  Yalien_eB, 3,
  Yalien_w, 3,
  -1,
  Yalien_e, 3,
  Yalien_wB, 3,
  -1,
  Yalien_eB, 2,
  Yalien_w, 4,
  -1,
  Yalien_e, 2,
  Yalien_wB, 4,
  -1,
  Yalien_eB, 1,
  Yalien_w, 5,
  -1,
  Yalien_e, 1,
  Yalien_wB, 5,
  -1,
  Yalien_eB, 0,
  Yalien_w, 6,
  -1,
  Yalien_e, 0,
  Yalien_wB, 6,
  -1,
  Yalien_stone, 0,
  -1,
  Yalien_stone, 1,
  -1,
  Yalien_stone, 2,
  -1,
  Yalien_stone, 3,
  -1,
  Yalien_stone, 4,
  -1,
  Yalien_stone, 5,
  -1,
  Yalien_stone, 6,
  -1,
  Yalien_spring, 0,
  -1,
  Yalien_spring, 1,
  -1,
  Yalien_spring, 2,
  -1,
  Yalien_spring, 3,
  -1,
  Yalien_spring, 4,
  -1,
  Yalien_spring, 5,
  -1,
  Yalien_spring, 6,
  -1,

  Xemerald, 0,
  Xemerald, 1,
  Xemerald, 2,
  Xemerald, 3,
  Xemerald, 4,
  Xemerald, 5,
  Xemerald, 6,
  Xemerald, 7,
  Xemerald_pause, 0,
  Xemerald_pause, 1,
  Xemerald_pause, 2,
  Xemerald_pause, 3,
  Xemerald_pause, 4,
  Xemerald_pause, 5,
  Xemerald_pause, 6,
  Xemerald_pause, 7,
  Xemerald_fall, 0,
  Xemerald_fall, 1,
  Xemerald_fall, 2,
  Xemerald_fall, 3,
  Xemerald_fall, 4,
  Xemerald_fall, 5,
  Xemerald_fall, 6,
  Xemerald_fall, 7,

#ifdef BAD_ROLL
  Xemerald_force_e, 0,
  Xemerald_force_e, 1,
  Xemerald_force_e, 2,
  Xemerald_force_e, 3,
  Xemerald_force_e, 4,
  Xemerald_force_e, 5,
  Xemerald_force_e, 6,
  Xemerald_force_e, 7,
  Xemerald_force_w, 0,
  Xemerald_force_w, 1,
  Xemerald_force_w, 2,
  Xemerald_force_w, 3,
  Xemerald_force_w, 4,
  Xemerald_force_w, 5,
  Xemerald_force_w, 6,
  Xemerald_force_w, 7,
#endif

  Xemerald_shine, 0,
  Xemerald_shine, 7,
  Yemerald_stone, 7,
  Yemerald_s, 7,
  Yemerald_e, 7,
  Yemerald_w, 7,
  -1,
  Xemerald_shine, 1,
  Xemerald_shine, 6,
  -1,
  Xemerald_shine, 2,
  Xemerald_shine, 5,
  -1,
  Xemerald_shine, 3,
  Xemerald_shine, 4,
  -1,
  Yemerald_sB, 6,
  -1,
  Yemerald_s, 6,
  -1,
  Yemerald_sB, 5,
  -1,
  Yemerald_s, 5,
  -1,
  Yemerald_sB, 4,
  -1,
  Yemerald_s, 4,
  -1,
  Yemerald_sB, 3,
  -1,
  Yemerald_s, 3,
  -1,
  Yemerald_sB, 2,
  -1,
  Yemerald_s, 2,
  -1,
  Yemerald_sB, 1,
  -1,
  Yemerald_s, 1,
  -1,
  Yemerald_sB, 0,
  -1,
  Yemerald_s, 0,
  -1,
  Yemerald_eB, 6,
  Yemerald_w, 0,
  -1,
  Yemerald_e, 6,
  Yemerald_wB, 0,
  -1,
  Yemerald_eB, 5,
  Yemerald_w, 1,
  -1,
  Yemerald_e, 5,
  Yemerald_wB, 1,
  -1,
  Yemerald_eB, 4,
  Yemerald_w, 2,
  -1,
  Yemerald_e, 4,
  Yemerald_wB, 2,
  -1,
  Yemerald_eB, 3,
  Yemerald_w, 3,
  -1,
  Yemerald_e, 3,
  Yemerald_wB, 3,
  -1,
  Yemerald_eB, 2,
  Yemerald_w, 4,
  -1,
  Yemerald_e, 2,
  Yemerald_wB, 4,
  -1,
  Yemerald_eB, 1,
  Yemerald_w, 5,
  -1,
  Yemerald_e, 1,
  Yemerald_wB, 5,
  -1,
  Yemerald_eB, 0,
  Yemerald_w, 6,
  -1,
  Yemerald_e, 0,
  Yemerald_wB, 6,
  -1,
  Yemerald_eat, 6,
  -1,
  Yemerald_eat, 5,
  -1,
  Yemerald_eat, 4,
  -1,
  Yemerald_eat, 3,
  -1,
  Yemerald_eat, 2,
  -1,
  Yemerald_eat, 1,
  -1,
  Yemerald_eat, 0,
  -1,
  Yemerald_stone, 0,
  -1,
  Yemerald_stone, 1,
  -1,
  Yemerald_stone, 2,
  -1,
  Yemerald_stone, 3,
  -1,
  Yemerald_stone, 4,
  -1,
  Yemerald_stone, 5,
  -1,
  Yemerald_stone, 6,
  -1,

  Xdiamond, 0,
  Xdiamond, 1,
  Xdiamond, 2,
  Xdiamond, 3,
  Xdiamond, 4,
  Xdiamond, 5,
  Xdiamond, 6,
  Xdiamond, 7,
  Xdiamond_pause, 0,
  Xdiamond_pause, 1,
  Xdiamond_pause, 2,
  Xdiamond_pause, 3,
  Xdiamond_pause, 4,
  Xdiamond_pause, 5,
  Xdiamond_pause, 6,
  Xdiamond_pause, 7,
  Xdiamond_fall, 0,
  Xdiamond_fall, 1,
  Xdiamond_fall, 2,
  Xdiamond_fall, 3,
  Xdiamond_fall, 4,
  Xdiamond_fall, 5,
  Xdiamond_fall, 6,
  Xdiamond_fall, 7,

#ifdef BAD_ROLL
  Xdiamond_force_e, 0,
  Xdiamond_force_e, 1,
  Xdiamond_force_e, 2,
  Xdiamond_force_e, 3,
  Xdiamond_force_e, 4,
  Xdiamond_force_e, 5,
  Xdiamond_force_e, 6,
  Xdiamond_force_e, 7,
  Xdiamond_force_w, 0,
  Xdiamond_force_w, 1,
  Xdiamond_force_w, 2,
  Xdiamond_force_w, 3,
  Xdiamond_force_w, 4,
  Xdiamond_force_w, 5,
  Xdiamond_force_w, 6,
  Xdiamond_force_w, 7,
#endif

  Xdiamond_shine, 0,
  Xdiamond_shine, 7,
  Ydiamond_s, 7,
  Ydiamond_e, 7,
  Ydiamond_w, 7,
  -1,
  Xdiamond_shine, 1,
  Xdiamond_shine, 6,
  -1,
  Xdiamond_shine, 2,
  Xdiamond_shine, 5,
  -1,
  Xdiamond_shine, 3,
  Xdiamond_shine, 4,
  -1,
  Ydiamond_sB, 6,
  -1,
  Ydiamond_s, 6,
  -1,
  Ydiamond_sB, 5,
  -1,
  Ydiamond_s, 5,
  -1,
  Ydiamond_sB, 4,
  -1,
  Ydiamond_s, 4,
  -1,
  Ydiamond_sB, 3,
  -1,
  Ydiamond_s, 3,
  -1,
  Ydiamond_sB, 2,
  -1,
  Ydiamond_s, 2,
  -1,
  Ydiamond_sB, 1,
  -1,
  Ydiamond_s, 1,
  -1,
  Ydiamond_sB, 0,
  -1,
  Ydiamond_s, 0,
  -1,
  Ydiamond_eB, 6,
  Ydiamond_w, 0,
  -1,
  Ydiamond_e, 6,
  Ydiamond_wB, 0,
  -1,
  Ydiamond_eB, 5,
  Ydiamond_w, 1,
  -1,
  Ydiamond_e, 5,
  Ydiamond_wB, 1,
  -1,
  Ydiamond_eB, 4,
  Ydiamond_w, 2,
  -1,
  Ydiamond_e, 4,
  Ydiamond_wB, 2,
  -1,
  Ydiamond_eB, 3,
  Ydiamond_w, 3,
  -1,
  Ydiamond_e, 3,
  Ydiamond_wB, 3,
  -1,
  Ydiamond_eB, 2,
  Ydiamond_w, 4,
  -1,
  Ydiamond_e, 2,
  Ydiamond_wB, 4,
  -1,
  Ydiamond_eB, 1,
  Ydiamond_w, 5,
  -1,
  Ydiamond_e, 1,
  Ydiamond_wB, 5,
  -1,
  Ydiamond_eB, 0,
  Ydiamond_w, 6,
  -1,
  Ydiamond_e, 0,
  Ydiamond_wB, 6,
  -1,
  Ydiamond_eat, 6,
  -1,
  Ydiamond_eat, 5,
  -1,
  Ydiamond_eat, 4,
  -1,
  Ydiamond_eat, 3,
  -1,
  Ydiamond_eat, 2,
  -1,
  Ydiamond_eat, 1,
  -1,
  Ydiamond_eat, 0,
  -1,
  Ydiamond_stone, 0,
  -1,
  Ydiamond_stone, 1,
  -1,
  Ydiamond_stone, 2,
  -1,
  Ydiamond_stone, 3,
  -1,
  Ydiamond_stone, 4,
  -1,
  Ydiamond_stone, 5,
  -1,
  Ydiamond_stone, 6,
  -1,

  Xdrip_fall, 0,
  Xdrip_fall, 1,
  Xdrip_fall, 2,
  Xdrip_fall, 3,
  Xdrip_fall, 4,
  Xdrip_fall, 5,
  Xdrip_fall, 6,
  Xdrip_fall, 7,
  Xdrip_eat, 7,
  Ydrip_s2, 7,
  -1,
  Ydrip_s2B, 6,
  -1,
  Ydrip_s2, 6,
  -1,
  Ydrip_s2B, 5,
  -1,
  Ydrip_s2, 5,
  -1,
  Ydrip_s2B, 4,
  -1,
  Ydrip_s2, 4,
  -1,
  Ydrip_s2B, 3,
  -1,
  Ydrip_s2, 3,
  -1,
  Ydrip_s2B, 2,
  -1,
  Ydrip_s2, 2,
  -1,
  Ydrip_s2B, 1,
  -1,
  Ydrip_s2, 1,
  -1,
  Ydrip_s2B, 0,
  -1,
  Ydrip_s2, 0,
  -1,
  Xdrip_stretchB, 0,
  Xdrip_stretchB, 1,
  Xdrip_stretchB, 2,
  Xdrip_stretchB, 3,
  Xdrip_stretchB, 4,
  Xdrip_stretchB, 5,
  Xdrip_stretchB, 6,
  Xdrip_stretchB, 7,
  Ydrip_s1B, 7,
  -1,
  Xdrip_stretch, 0,
  Xdrip_stretch, 1,
  Xdrip_stretch, 2,
  Xdrip_stretch, 3,
  Xdrip_stretch, 4,
  Xdrip_stretch, 5,
  Xdrip_stretch, 6,
  Xdrip_stretch, 7,
  Ydrip_s1, 7,
  -1,
  Ydrip_s1B, 6,
  -1,
  Ydrip_s1, 6,
  -1,
  Ydrip_s1B, 5,
  -1,
  Ydrip_s1, 5,
  -1,
  Ydrip_s1B, 4,
  -1,
  Ydrip_s1, 4,
  -1,
  Ydrip_s1B, 3,
  -1,
  Ydrip_s1, 3,
  -1,
  Ydrip_s1B, 2,
  -1,
  Ydrip_s1, 2,
  -1,
  Ydrip_s1B, 1,
  -1,
  Ydrip_s1, 1,
  -1,
  Ydrip_s1B, 0,
  -1,
  Ydrip_s1, 0,
  -1,
  Xdrip_eat, 0,
  -1,
  Xdrip_eat, 1,
  -1,
  Xdrip_eat, 2,
  -1,
  Xdrip_eat, 3,
  -1,
  Xdrip_eat, 4,
  -1,
  Xdrip_eat, 5,
  -1,
  Xdrip_eat, 6,
  -1,

  Xbomb, 0,
  Xbomb, 1,
  Xbomb, 2,
  Xbomb, 3,
  Xbomb, 4,
  Xbomb, 5,
  Xbomb, 6,
  Xbomb, 7,
  Xbomb_pause, 0,
  Xbomb_pause, 1,
  Xbomb_pause, 2,
  Xbomb_pause, 3,
  Xbomb_pause, 4,
  Xbomb_pause, 5,
  Xbomb_pause, 6,
  Xbomb_pause, 7,
  Xbomb_fall, 0,
  Xbomb_fall, 1,
  Xbomb_fall, 2,
  Xbomb_fall, 3,
  Xbomb_fall, 4,
  Xbomb_fall, 5,
  Xbomb_fall, 6,
  Xbomb_fall, 7,

#ifdef BAD_ROLL
  Xbomb_force_e, 0,
  Xbomb_force_e, 1,
  Xbomb_force_e, 2,
  Xbomb_force_e, 3,
  Xbomb_force_e, 4,
  Xbomb_force_e, 5,
  Xbomb_force_e, 6,
  Xbomb_force_e, 7,
  Xbomb_force_w, 0,
  Xbomb_force_w, 1,
  Xbomb_force_w, 2,
  Xbomb_force_w, 3,
  Xbomb_force_w, 4,
  Xbomb_force_w, 5,
  Xbomb_force_w, 6,
  Xbomb_force_w, 7,
#endif

  Ybomb_s, 7,
  Ybomb_e, 7,
  Ybomb_w, 7,
  -1,
  Ybomb_sB, 6,
  -1,
  Ybomb_s, 6,
  -1,
  Ybomb_sB, 5,
  -1,
  Ybomb_s, 5,
  -1,
  Ybomb_sB, 4,
  -1,
  Ybomb_s, 4,
  -1,
  Ybomb_sB, 3,
  -1,
  Ybomb_s, 3,
  -1,
  Ybomb_sB, 2,
  -1,
  Ybomb_s, 2,
  -1,
  Ybomb_sB, 1,
  -1,
  Ybomb_s, 1,
  -1,
  Ybomb_sB, 0,
  -1,
  Ybomb_s, 0,
  -1,
  Ybomb_eB, 6,
  Ybomb_w, 0,
  -1,
  Ybomb_e, 6,
  Ybomb_wB, 0,
  -1,
  Ybomb_eB, 5,
  Ybomb_w, 1,
  -1,
  Ybomb_e, 5,
  Ybomb_wB, 1,
  -1,
  Ybomb_eB, 4,
  Ybomb_w, 2,
  -1,
  Ybomb_e, 4,
  Ybomb_wB, 2,
  -1,
  Ybomb_eB, 3,
  Ybomb_w, 3,
  -1,
  Ybomb_e, 3,
  Ybomb_wB, 3,
  -1,
  Ybomb_eB, 2,
  Ybomb_w, 4,
  -1,
  Ybomb_e, 2,
  Ybomb_wB, 4,
  -1,
  Ybomb_eB, 1,
  Ybomb_w, 5,
  -1,
  Ybomb_e, 1,
  Ybomb_wB, 5,
  -1,
  Ybomb_eB, 0,
  Ybomb_w, 6,
  -1,
  Ybomb_e, 0,
  Ybomb_wB, 6,
  -1,
  Ybomb_eat, 6,
  -1,
  Ybomb_eat, 5,
  -1,
  Ybomb_eat, 4,
  -1,
  Ybomb_eat, 3,
  -1,
  Ybomb_eat, 2,
  -1,
  Ybomb_eat, 1,
  -1,
  Ybomb_eat, 0,
  -1,

  Yballoon_n, 7,
  Yballoon_e, 7,
  Yballoon_s, 7,
  Yballoon_w, 7,
  Xballoon, 0,
  Xballoon, 1,
  Xballoon, 2,
  Xballoon, 3,
  Xballoon, 4,
  Xballoon, 5,
  Xballoon, 6,
  Xballoon, 7,
  -1,
  Yballoon_n, 0,
  Yballoon_sB, 6,
  -1,
  Yballoon_nB, 0,
  Yballoon_s, 6,
  -1,
  Yballoon_n, 1,
  Yballoon_sB, 5,
  -1,
  Yballoon_nB, 1,
  Yballoon_s, 5,
  -1,
  Yballoon_n, 2,
  Yballoon_sB, 4,
  -1,
  Yballoon_nB, 2,
  Yballoon_s, 4,
  -1,
  Yballoon_n, 3,
  Yballoon_sB, 3,
  -1,
  Yballoon_nB, 3,
  Yballoon_s, 3,
  -1,
  Yballoon_n, 4,
  Yballoon_sB, 2,
  -1,
  Yballoon_nB, 4,
  Yballoon_s, 2,
  -1,
  Yballoon_n, 5,
  Yballoon_sB, 1,
  -1,
  Yballoon_nB, 5,
  Yballoon_s, 1,
  -1,
  Yballoon_n, 6,
  Yballoon_sB, 0,
  -1,
  Yballoon_nB, 6,
  Yballoon_s, 0,
  -1,
  Yballoon_eB, 6,
  Yballoon_w, 0,
  -1,
  Yballoon_e, 6,
  Yballoon_wB, 0,
  -1,
  Yballoon_eB, 5,
  Yballoon_w, 1,
  -1,
  Yballoon_e, 5,
  Yballoon_wB, 1,
  -1,
  Yballoon_eB, 4,
  Yballoon_w, 2,
  -1,
  Yballoon_e, 4,
  Yballoon_wB, 2,
  -1,
  Yballoon_eB, 3,
  Yballoon_w, 3,
  -1,
  Yballoon_e, 3,
  Yballoon_wB, 3,
  -1,
  Yballoon_eB, 2,
  Yballoon_w, 4,
  -1,
  Yballoon_e, 2,
  Yballoon_wB, 4,
  -1,
  Yballoon_eB, 1,
  Yballoon_w, 5,
  -1,
  Yballoon_e, 1,
  Yballoon_wB, 5,
  -1,
  Yballoon_eB, 0,
  Yballoon_w, 6,
  -1,
  Yballoon_e, 0,
  Yballoon_wB, 6,
  -1,

  Xgrass, 0,
  Xgrass, 1,
  Xgrass, 2,
  Xgrass, 3,
  Xgrass, 4,
  Xgrass, 5,
  Xgrass, 6,
  Xgrass, 7,
  Xfake_grass, 0,
  Xfake_grass, 1,
  Xfake_grass, 2,
  Xfake_grass, 3,
  Xfake_grass, 4,
  Xfake_grass, 5,
  Xfake_grass, 6,
  Xfake_grass, 7,
  -1,
  Ygrass_nB, 6,
  -1,
  Ygrass_nB, 5,
  -1,
  Ygrass_nB, 4,
  -1,
  Ygrass_nB, 3,
  -1,
  Ygrass_nB, 2,
  -1,
  Ygrass_nB, 1,
  -1,
  Ygrass_nB, 0,
  -1,
  Ygrass_eB, 6,
  -1,
  Ygrass_eB, 5,
  -1,
  Ygrass_eB, 4,
  -1,
  Ygrass_eB, 3,
  -1,
  Ygrass_eB, 2,
  -1,
  Ygrass_eB, 1,
  -1,
  Ygrass_eB, 0,
  -1,
  Ygrass_sB, 6,
  -1,
  Ygrass_sB, 5,
  -1,
  Ygrass_sB, 4,
  -1,
  Ygrass_sB, 3,
  -1,
  Ygrass_sB, 2,
  -1,
  Ygrass_sB, 1,
  -1,
  Ygrass_sB, 0,
  -1,
  Ygrass_wB, 6,
  -1,
  Ygrass_wB, 5,
  -1,
  Ygrass_wB, 4,
  -1,
  Ygrass_wB, 3,
  -1,
  Ygrass_wB, 2,
  -1,
  Ygrass_wB, 1,
  -1,
  Ygrass_wB, 0,
  -1,

  Xdirt, 0,
  Xdirt, 1,
  Xdirt, 2,
  Xdirt, 3,
  Xdirt, 4,
  Xdirt, 5,
  Xdirt, 6,
  Xdirt, 7,
  -1,
  Ydirt_nB, 6,
  -1,
  Ydirt_nB, 5,
  -1,
  Ydirt_nB, 4,
  -1,
  Ydirt_nB, 3,
  -1,
  Ydirt_nB, 2,
  -1,
  Ydirt_nB, 1,
  -1,
  Ydirt_nB, 0,
  -1,
  Ydirt_eB, 6,
  -1,
  Ydirt_eB, 5,
  -1,
  Ydirt_eB, 4,
  -1,
  Ydirt_eB, 3,
  -1,
  Ydirt_eB, 2,
  -1,
  Ydirt_eB, 1,
  -1,
  Ydirt_eB, 0,
  -1,
  Ydirt_sB, 6,
  -1,
  Ydirt_sB, 5,
  -1,
  Ydirt_sB, 4,
  -1,
  Ydirt_sB, 3,
  -1,
  Ydirt_sB, 2,
  -1,
  Ydirt_sB, 1,
  -1,
  Ydirt_sB, 0,
  -1,
  Ydirt_wB, 6,
  -1,
  Ydirt_wB, 5,
  -1,
  Ydirt_wB, 4,
  -1,
  Ydirt_wB, 3,
  -1,
  Ydirt_wB, 2,
  -1,
  Ydirt_wB, 1,
  -1,
  Ydirt_wB, 0,
  -1,

  Xacid_nw, 0,
  Xacid_nw, 1,
  Xacid_nw, 2,
  Xacid_nw, 3,
  Xacid_nw, 4,
  Xacid_nw, 5,
  Xacid_nw, 6,
  Xacid_nw, 7,
  -1,
  Xacid_ne, 0,
  Xacid_ne, 1,
  Xacid_ne, 2,
  Xacid_ne, 3,
  Xacid_ne, 4,
  Xacid_ne, 5,
  Xacid_ne, 6,
  Xacid_ne, 7,
  -1,
  Xacid_sw, 0,
  Xacid_sw, 1,
  Xacid_sw, 2,
  Xacid_sw, 3,
  Xacid_sw, 4,
  Xacid_sw, 5,
  Xacid_sw, 6,
  Xacid_sw, 7,
  -1,
  Xacid_s, 0,
  Xacid_s, 1,
  Xacid_s, 2,
  Xacid_s, 3,
  Xacid_s, 4,
  Xacid_s, 5,
  Xacid_s, 6,
  Xacid_s, 7,
  -1,
  Xacid_se, 0,
  Xacid_se, 1,
  Xacid_se, 2,
  Xacid_se, 3,
  Xacid_se, 4,
  Xacid_se, 5,
  Xacid_se, 6,
  Xacid_se, 7,
  -1,
  Xacid_1, 0,
  Xacid_1, 1,
  Xacid_1, 2,
  Xacid_1, 3,
  Xacid_1, 4,
  Xacid_1, 5,
  Xacid_1, 6,
  Xacid_1, 7,
  -1,
  Xacid_2, 0,
  Xacid_2, 1,
  Xacid_2, 2,
  Xacid_2, 3,
  Xacid_2, 4,
  Xacid_2, 5,
  Xacid_2, 6,
  Xacid_2, 7,
  -1,
  Xacid_3, 0,
  Xacid_3, 1,
  Xacid_3, 2,
  Xacid_3, 3,
  Xacid_3, 4,
  Xacid_3, 5,
  Xacid_3, 6,
  Xacid_3, 7,
  -1,
  Xacid_4, 0,
  Xacid_4, 1,
  Xacid_4, 2,
  Xacid_4, 3,
  Xacid_4, 4,
  Xacid_4, 5,
  Xacid_4, 6,
  Xacid_4, 7,
  -1,
  Xacid_5, 0,
  Xacid_5, 1,
  Xacid_5, 2,
  Xacid_5, 3,
  Xacid_5, 4,
  Xacid_5, 5,
  Xacid_5, 6,
  Xacid_5, 7,
  -1,
  Xacid_6, 0,
  Xacid_6, 1,
  Xacid_6, 2,
  Xacid_6, 3,
  Xacid_6, 4,
  Xacid_6, 5,
  Xacid_6, 6,
  Xacid_6, 7,
  -1,
  Xacid_7, 0,
  Xacid_7, 1,
  Xacid_7, 2,
  Xacid_7, 3,
  Xacid_7, 4,
  Xacid_7, 5,
  Xacid_7, 6,
  Xacid_7, 7,
  -1,
  Xacid_8, 0,
  Xacid_8, 1,
  Xacid_8, 2,
  Xacid_8, 3,
  Xacid_8, 4,
  Xacid_8, 5,
  Xacid_8, 6,
  Xacid_8, 7,
  -1,
  Yacid_splash_wB, 4,
  Yacid_splash_wB, 5,
  -1,
  Yacid_splash_wB, 2,
  Yacid_splash_wB, 3,
  -1,
  Yacid_splash_wB, 0,
  Yacid_splash_wB, 1,
  -1,
  Yacid_splash_eB, 4,
  Yacid_splash_eB, 5,
  -1,
  Yacid_splash_eB, 2,
  Yacid_splash_eB, 3,
  -1,
  Yacid_splash_eB, 0,
  Yacid_splash_eB, 1,
  -1,

  Xball_2B, 7,
  Xball_1, 0,
  Xball_1, 1,
  Xball_1, 2,
  Xball_1, 3,
  Xball_1, 4,
  Xball_1, 5,
  Xball_1, 6,
  Xball_1, 7,
  -1,
  Xball_1B, 0,
  -1,
  Xball_1B, 1,
  -1,
  Xball_1B, 2,
  -1,
  Xball_1B, 3,
  -1,
  Xball_1B, 4,
  -1,
  Xball_1B, 5,
  -1,
  Xball_1B, 6,
  -1,
  Xball_1B, 7,
  Xball_2, 0,
  Xball_2, 1,
  Xball_2, 2,
  Xball_2, 3,
  Xball_2, 4,
  Xball_2, 5,
  Xball_2, 6,
  Xball_2, 7,
  -1,
  Xball_2B, 0,
  -1,
  Xball_2B, 1,
  -1,
  Xball_2B, 2,
  -1,
  Xball_2B, 3,
  -1,
  Xball_2B, 4,
  -1,
  Xball_2B, 5,
  -1,
  Xball_2B, 6,
  -1,

  Ygrow_ew_eat, 7,
  Xgrow_ew, 0,
  Xgrow_ew, 1,
  Xgrow_ew, 2,
  Xgrow_ew, 3,
  Xgrow_ew, 4,
  Xgrow_ew, 5,
  Xgrow_ew, 6,
  Xgrow_ew, 7,
  -1,
  Ygrow_ew_eat, 0,
  -1,
  Ygrow_ew_eat, 1,
  -1,
  Ygrow_ew_eat, 2,
  -1,
  Ygrow_ew_eat, 3,
  -1,
  Ygrow_ew_eat, 4,
  -1,
  Ygrow_ew_eat, 5,
  -1,
  Ygrow_ew_eat, 6,
  -1,
  Ygrow_ns_eat, 7,
  Xgrow_ns, 0,
  Xgrow_ns, 1,
  Xgrow_ns, 2,
  Xgrow_ns, 3,
  Xgrow_ns, 4,
  Xgrow_ns, 5,
  Xgrow_ns, 6,
  Xgrow_ns, 7,
  -1,
  Ygrow_ns_eat, 0,
  -1,
  Ygrow_ns_eat, 1,
  -1,
  Ygrow_ns_eat, 2,
  -1,
  Ygrow_ns_eat, 3,
  -1,
  Ygrow_ns_eat, 4,
  -1,
  Ygrow_ns_eat, 5,
  -1,
  Ygrow_ns_eat, 6,
  -1,

  XwonderwallB, 7,
  Xwonderwall, 0,
  Xwonderwall, 1,
  Xwonderwall, 2,
  Xwonderwall, 3,
  Xwonderwall, 4,
  Xwonderwall, 5,
  Xwonderwall, 6,
  Xwonderwall, 7,
  -1,
  XwonderwallB, 0,
  -1,
  XwonderwallB, 1,
  -1,
  XwonderwallB, 2,
  -1,
  XwonderwallB, 3,
  -1,
  XwonderwallB, 4,
  -1,
  XwonderwallB, 5,
  -1,
  XwonderwallB, 6,
  -1,

  Xamoeba_1, 0,
  Xamoeba_1, 1,
  Xamoeba_1, 2,
  Xamoeba_1, 3,
  Xamoeba_1, 4,
  Xamoeba_1, 5,
  Xamoeba_1, 6,
  Xamoeba_1, 7,
  -1,
  Xamoeba_2, 0,
  Xamoeba_2, 1,
  Xamoeba_2, 2,
  Xamoeba_2, 3,
  Xamoeba_2, 4,
  Xamoeba_2, 5,
  Xamoeba_2, 6,
  Xamoeba_2, 7,
  -1,
  Xamoeba_3, 0,
  Xamoeba_3, 1,
  Xamoeba_3, 2,
  Xamoeba_3, 3,
  Xamoeba_3, 4,
  Xamoeba_3, 5,
  Xamoeba_3, 6,
  Xamoeba_3, 7,
  -1,
  Xamoeba_4, 0,
  Xamoeba_4, 1,
  Xamoeba_4, 2,
  Xamoeba_4, 3,
  Xamoeba_4, 4,
  Xamoeba_4, 5,
  Xamoeba_4, 6,
  Xamoeba_4, 7,
  -1,
  Xamoeba_5, 0,
  Xamoeba_5, 1,
  Xamoeba_5, 2,
  Xamoeba_5, 3,
  Xamoeba_5, 4,
  Xamoeba_5, 5,
  Xamoeba_5, 6,
  Xamoeba_5, 7,
  -1,
  Xamoeba_6, 0,
  Xamoeba_6, 1,
  Xamoeba_6, 2,
  Xamoeba_6, 3,
  Xamoeba_6, 4,
  Xamoeba_6, 5,
  Xamoeba_6, 6,
  Xamoeba_6, 7,
  -1,
  Xamoeba_7, 0,
  Xamoeba_7, 1,
  Xamoeba_7, 2,
  Xamoeba_7, 3,
  Xamoeba_7, 4,
  Xamoeba_7, 5,
  Xamoeba_7, 6,
  Xamoeba_7, 7,
  -1,
  Xamoeba_8, 0,
  Xamoeba_8, 1,
  Xamoeba_8, 2,
  Xamoeba_8, 3,
  Xamoeba_8, 4,
  Xamoeba_8, 5,
  Xamoeba_8, 6,
  Xamoeba_8, 7,
  -1,

  Xdoor_1, 0,
  Xdoor_1, 1,
  Xdoor_1, 2,
  Xdoor_1, 3,
  Xdoor_1, 4,
  Xdoor_1, 5,
  Xdoor_1, 6,
  Xdoor_1, 7,
  -1,
  Xdoor_2, 0,
  Xdoor_2, 1,
  Xdoor_2, 2,
  Xdoor_2, 3,
  Xdoor_2, 4,
  Xdoor_2, 5,
  Xdoor_2, 6,
  Xdoor_2, 7,
  -1,
  Xdoor_3, 0,
  Xdoor_3, 1,
  Xdoor_3, 2,
  Xdoor_3, 3,
  Xdoor_3, 4,
  Xdoor_3, 5,
  Xdoor_3, 6,
  Xdoor_3, 7,
  -1,
  Xdoor_4, 0,
  Xdoor_4, 1,
  Xdoor_4, 2,
  Xdoor_4, 3,
  Xdoor_4, 4,
  Xdoor_4, 5,
  Xdoor_4, 6,
  Xdoor_4, 7,
  -1,
  Xdoor_5, 0,
  Xdoor_5, 1,
  Xdoor_5, 2,
  Xdoor_5, 3,
  Xdoor_5, 4,
  Xdoor_5, 5,
  Xdoor_5, 6,
  Xdoor_5, 7,
  -1,
  Xdoor_6, 0,
  Xdoor_6, 1,
  Xdoor_6, 2,
  Xdoor_6, 3,
  Xdoor_6, 4,
  Xdoor_6, 5,
  Xdoor_6, 6,
  Xdoor_6, 7,
  -1,
  Xdoor_7, 0,
  Xdoor_7, 1,
  Xdoor_7, 2,
  Xdoor_7, 3,
  Xdoor_7, 4,
  Xdoor_7, 5,
  Xdoor_7, 6,
  Xdoor_7, 7,
  -1,
  Xdoor_8, 0,
  Xdoor_8, 1,
  Xdoor_8, 2,
  Xdoor_8, 3,
  Xdoor_8, 4,
  Xdoor_8, 5,
  Xdoor_8, 6,
  Xdoor_8, 7,
  -1,
  Xkey_1, 0,
  Xkey_1, 1,
  Xkey_1, 2,
  Xkey_1, 3,
  Xkey_1, 4,
  Xkey_1, 5,
  Xkey_1, 6,
  Xkey_1, 7,
  -1,
  Xkey_2, 0,
  Xkey_2, 1,
  Xkey_2, 2,
  Xkey_2, 3,
  Xkey_2, 4,
  Xkey_2, 5,
  Xkey_2, 6,
  Xkey_2, 7,
  -1,
  Xkey_3, 0,
  Xkey_3, 1,
  Xkey_3, 2,
  Xkey_3, 3,
  Xkey_3, 4,
  Xkey_3, 5,
  Xkey_3, 6,
  Xkey_3, 7,
  -1,
  Xkey_4, 0,
  Xkey_4, 1,
  Xkey_4, 2,
  Xkey_4, 3,
  Xkey_4, 4,
  Xkey_4, 5,
  Xkey_4, 6,
  Xkey_4, 7,
  -1,
  Xkey_5, 0,
  Xkey_5, 1,
  Xkey_5, 2,
  Xkey_5, 3,
  Xkey_5, 4,
  Xkey_5, 5,
  Xkey_5, 6,
  Xkey_5, 7,
  -1,
  Xkey_6, 0,
  Xkey_6, 1,
  Xkey_6, 2,
  Xkey_6, 3,
  Xkey_6, 4,
  Xkey_6, 5,
  Xkey_6, 6,
  Xkey_6, 7,
  -1,
  Xkey_7, 0,
  Xkey_7, 1,
  Xkey_7, 2,
  Xkey_7, 3,
  Xkey_7, 4,
  Xkey_7, 5,
  Xkey_7, 6,
  Xkey_7, 7,
  -1,
  Xkey_8, 0,
  Xkey_8, 1,
  Xkey_8, 2,
  Xkey_8, 3,
  Xkey_8, 4,
  Xkey_8, 5,
  Xkey_8, 6,
  Xkey_8, 7,
  -1,

  Xwind_n, 0,
  Xwind_n, 1,
  Xwind_n, 2,
  Xwind_n, 3,
  Xwind_n, 4,
  Xwind_n, 5,
  Xwind_n, 6,
  Xwind_n, 7,
  -1,
  Xwind_e, 0,
  Xwind_e, 1,
  Xwind_e, 2,
  Xwind_e, 3,
  Xwind_e, 4,
  Xwind_e, 5,
  Xwind_e, 6,
  Xwind_e, 7,
  -1,
  Xwind_s, 0,
  Xwind_s, 1,
  Xwind_s, 2,
  Xwind_s, 3,
  Xwind_s, 4,
  Xwind_s, 5,
  Xwind_s, 6,
  Xwind_s, 7,
  -1,
  Xwind_w, 0,
  Xwind_w, 1,
  Xwind_w, 2,
  Xwind_w, 3,
  Xwind_w, 4,
  Xwind_w, 5,
  Xwind_w, 6,
  Xwind_w, 7,
  -1,
  Xwind_nesw, 0,
  Xwind_nesw, 1,
  Xwind_nesw, 2,
  Xwind_nesw, 3,
  Xwind_nesw, 4,
  Xwind_nesw, 5,
  Xwind_nesw, 6,
  Xwind_nesw, 7,
  -1,
  Xwind_stop, 0,
  Xwind_stop, 1,
  Xwind_stop, 2,
  Xwind_stop, 3,
  Xwind_stop, 4,
  Xwind_stop, 5,
  Xwind_stop, 6,
  Xwind_stop, 7,
  -1,

  Xexit, 0,
  Xexit, 1,
  Xexit, 2,
  Xexit, 3,
  Xexit, 4,
  Xexit, 5,
  Xexit, 6,
  Xexit, 7,
  -1,
  Xexit_1, 0,
  Xexit_1, 1,
  Xexit_1, 2,
  -1,
  Xexit_1, 3,
  Xexit_1, 4,
  Xexit_1, 5,
  Xexit_3, 7,
  Xexit_3, 6,
  Xexit_3, 5,
  -1,
  Xexit_1, 6,
  Xexit_1, 7,
  Xexit_2, 0,
  Xexit_3, 4,
  Xexit_3, 3,
  Xexit_3, 2,
  -1,
  Xexit_2, 1,
  Xexit_2, 2,
  Xexit_2, 3,
  Xexit_3, 1,
  Xexit_3, 0,
  Xexit_2, 7,
  -1,
  Xexit_2, 4,
  Xexit_2, 5,
  Xexit_2, 6,
  -1,

  Ydynamite_eat, 0,
  Ydynamite_eat, 1,
  Ydynamite_eat, 2,
  Xdynamite, 0,
  Xdynamite, 1,
  Xdynamite, 2,
  Xdynamite, 3,
  Xdynamite, 4,
  Xdynamite, 5,
  Xdynamite, 6,
  Xdynamite, 7,
  -1,
  Xdynamite_4, 0,
  Xdynamite_4, 1,
  Xdynamite_4, 2,
  Xdynamite_4, 3,
  Xdynamite_4, 4,
  Xdynamite_4, 5,
  Xdynamite_4, 6,
  Xdynamite_4, 7,
  -1,
  Xdynamite_3, 0,
  Xdynamite_3, 1,
  Xdynamite_3, 2,
  Xdynamite_3, 3,
  Xdynamite_3, 4,
  Xdynamite_3, 5,
  Xdynamite_3, 6,
  Xdynamite_3, 7,
  -1,
  Xdynamite_2, 0,
  Xdynamite_2, 1,
  Xdynamite_2, 2,
  Xdynamite_2, 3,
  Xdynamite_2, 4,
  Xdynamite_2, 5,
  Xdynamite_2, 6,
  Xdynamite_2, 7,
  -1,
  Xdynamite_1, 0,
  Xdynamite_1, 1,
  Xdynamite_1, 2,
  Xdynamite_1, 3,
  Xdynamite_1, 4,
  Xdynamite_1, 5,
  Xdynamite_1, 6,
  Xdynamite_1, 7,
  -1,

  Xbumper, 0,
  Xbumper, 1,
  Xbumper, 2,
  Xbumper, 3,
  Xbumper, 4,
  Xbumper, 5,
  Xbumper, 6,
  Xbumper, 7,
  XbumperB, 0,
  XbumperB, 7,
  -1,
  XbumperB, 1,
  XbumperB, 6,
  -1,
  XbumperB, 2,
  XbumperB, 5,
  -1,
  XbumperB, 3,
  XbumperB, 4,
  -1,

  Xwheel, 0,
  Xwheel, 1,
  Xwheel, 2,
  Xwheel, 3,
  Xwheel, 4,
  Xwheel, 5,
  Xwheel, 6,
  Xwheel, 7,
  XwheelB, 7,
  XwheelB, 6,
  XwheelB, 5,
  XwheelB, 4,
  -1,
  XwheelB, 3,
  XwheelB, 2,
  XwheelB, 1,
  XwheelB, 0,
  -1,

  XswitchB, 0,
  XswitchB, 1,
  XswitchB, 2,
  XswitchB, 3,
  XswitchB, 4,
  XswitchB, 5,
  XswitchB, 6,
  XswitchB, 7,
  -1,
  Xswitch, 0,
  Xswitch, 1,
  Xswitch, 2,
  Xswitch, 3,
  Xswitch, 4,
  Xswitch, 5,
  Xswitch, 6,
  Xswitch, 7,
  -1,

  Xsand, 0,
  Xsand, 1,
  Xsand, 2,
  Xsand, 3,
  Xsand, 4,
  Xsand, 5,
  Xsand, 6,
  Xsand, 7,
  Xsand_stone, 0,
  Xsand_stone, 1,
  Xsand_stone, 2,
  Xsand_stone, 3,
  Xsand_stone, 4,
  Xsand_stone, 5,
  Xsand_stone, 6,
  Xsand_stone, 7,
  Xsand_stonesand_1, 0,
  Xsand_stonesand_1, 1,
  Xsand_stonesand_1, 2,
  Xsand_stonesand_1, 3,
  Xsand_stonesand_1, 4,
  Xsand_stonesand_1, 5,
  Xsand_stonesand_1, 6,
  Xsand_stonesand_1, 7,
  Xsand_stonesand_2, 0,
  Xsand_stonesand_2, 1,
  Xsand_stonesand_2, 2,
  Xsand_stonesand_2, 3,
  Xsand_stonesand_2, 4,
  Xsand_stonesand_2, 5,
  Xsand_stonesand_2, 6,
  Xsand_stonesand_2, 7,
  Xsand_stonesand_3, 0,
  Xsand_stonesand_3, 1,
  Xsand_stonesand_3, 2,
  Xsand_stonesand_3, 3,
  Xsand_stonesand_3, 4,
  Xsand_stonesand_3, 5,
  Xsand_stonesand_3, 6,
  Xsand_stonesand_3, 7,
  Xsand_stonesand_4, 0,
  Xsand_stonesand_4, 1,
  Xsand_stonesand_4, 2,
  Xsand_stonesand_4, 3,
  Xsand_stonesand_4, 4,
  Xsand_stonesand_4, 5,
  Xsand_stonesand_4, 6,
  Xsand_stonesand_4, 7,
  Xsand_sandstone_1, 0,
  Xsand_sandstone_1, 1,
  Xsand_sandstone_1, 2,
  Xsand_sandstone_1, 3,
  Xsand_sandstone_1, 4,
  Xsand_sandstone_1, 5,
  Xsand_sandstone_1, 6,
  Xsand_sandstone_1, 7,
  Xsand_sandstone_2, 0,
  Xsand_sandstone_2, 1,
  Xsand_sandstone_2, 2,
  Xsand_sandstone_2, 3,
  Xsand_sandstone_2, 4,
  Xsand_sandstone_2, 5,
  Xsand_sandstone_2, 6,
  Xsand_sandstone_2, 7,
  Xsand_sandstone_3, 0,
  Xsand_sandstone_3, 1,
  Xsand_sandstone_3, 2,
  Xsand_sandstone_3, 3,
  Xsand_sandstone_3, 4,
  Xsand_sandstone_3, 5,
  Xsand_sandstone_3, 6,
  Xsand_sandstone_3, 7,
  Xsand_sandstone_4, 0,
  Xsand_sandstone_4, 1,
  Xsand_sandstone_4, 2,
  Xsand_sandstone_4, 3,
  Xsand_sandstone_4, 4,
  Xsand_sandstone_4, 5,
  Xsand_sandstone_4, 6,
  Xsand_sandstone_4, 7,
  -1,

  Xplant, 0,
  Xplant, 1,
  Xplant, 2,
  Xplant, 3,
  Xplant, 4,
  Xplant, 5,
  Xplant, 6,
  Xplant, 7,
  Yplant, 0,
  Yplant, 1,
  Yplant, 2,
  Yplant, 3,
  Yplant, 4,
  Yplant, 5,
  Yplant, 6,
  Yplant, 7,
  -1,

  Xlenses, 0,
  Xlenses, 1,
  Xlenses, 2,
  Xlenses, 3,
  Xlenses, 4,
  Xlenses, 5,
  Xlenses, 6,
  Xlenses, 7,
  -1,

  Xmagnify, 0,
  Xmagnify, 1,
  Xmagnify, 2,
  Xmagnify, 3,
  Xmagnify, 4,
  Xmagnify, 5,
  Xmagnify, 6,
  Xmagnify, 7,
  -1,

  XdripperB, 0,
  XdripperB, 1,
  XdripperB, 2,
  XdripperB, 3,
  XdripperB, 4,
  XdripperB, 5,
  XdripperB, 6,
  XdripperB, 7,
  -1,

  Xfake_blankB, 0,
  Xfake_blankB, 1,
  Xfake_blankB, 2,
  Xfake_blankB, 3,
  Xfake_blankB, 4,
  Xfake_blankB, 5,
  Xfake_blankB, 6,
  Xfake_blankB, 7,
  -1,

  Xfake_grassB, 0,
  Xfake_grassB, 1,
  Xfake_grassB, 2,
  Xfake_grassB, 3,
  Xfake_grassB, 4,
  Xfake_grassB, 5,
  Xfake_grassB, 6,
  Xfake_grassB, 7,
  -1,

  Xfake_door_1, 0,
  Xfake_door_1, 1,
  Xfake_door_1, 2,
  Xfake_door_1, 3,
  Xfake_door_1, 4,
  Xfake_door_1, 5,
  Xfake_door_1, 6,
  Xfake_door_1, 7,
  Xfake_door_2, 0,
  Xfake_door_2, 1,
  Xfake_door_2, 2,
  Xfake_door_2, 3,
  Xfake_door_2, 4,
  Xfake_door_2, 5,
  Xfake_door_2, 6,
  Xfake_door_2, 7,
  Xfake_door_3, 0,
  Xfake_door_3, 1,
  Xfake_door_3, 2,
  Xfake_door_3, 3,
  Xfake_door_3, 4,
  Xfake_door_3, 5,
  Xfake_door_3, 6,
  Xfake_door_3, 7,
  Xfake_door_4, 0,
  Xfake_door_4, 1,
  Xfake_door_4, 2,
  Xfake_door_4, 3,
  Xfake_door_4, 4,
  Xfake_door_4, 5,
  Xfake_door_4, 6,
  Xfake_door_4, 7,
  Xfake_door_5, 0,
  Xfake_door_5, 1,
  Xfake_door_5, 2,
  Xfake_door_5, 3,
  Xfake_door_5, 4,
  Xfake_door_5, 5,
  Xfake_door_5, 6,
  Xfake_door_5, 7,
  Xfake_door_6, 0,
  Xfake_door_6, 1,
  Xfake_door_6, 2,
  Xfake_door_6, 3,
  Xfake_door_6, 4,
  Xfake_door_6, 5,
  Xfake_door_6, 6,
  Xfake_door_6, 7,
  Xfake_door_7, 0,
  Xfake_door_7, 1,
  Xfake_door_7, 2,
  Xfake_door_7, 3,
  Xfake_door_7, 4,
  Xfake_door_7, 5,
  Xfake_door_7, 6,
  Xfake_door_7, 7,
  Xfake_door_8, 0,
  Xfake_door_8, 1,
  Xfake_door_8, 2,
  Xfake_door_8, 3,
  Xfake_door_8, 4,
  Xfake_door_8, 5,
  Xfake_door_8, 6,
  Xfake_door_8, 7,
  -1,

  Xsteel_1, 0,
  Xsteel_1, 1,
  Xsteel_1, 2,
  Xsteel_1, 3,
  Xsteel_1, 4,
  Xsteel_1, 5,
  Xsteel_1, 6,
  Xsteel_1, 7,
  -1,
  Xsteel_2, 0,
  Xsteel_2, 1,
  Xsteel_2, 2,
  Xsteel_2, 3,
  Xsteel_2, 4,
  Xsteel_2, 5,
  Xsteel_2, 6,
  Xsteel_2, 7,
  -1,
  Xsteel_3, 0,
  Xsteel_3, 1,
  Xsteel_3, 2,
  Xsteel_3, 3,
  Xsteel_3, 4,
  Xsteel_3, 5,
  Xsteel_3, 6,
  Xsteel_3, 7,
  -1,
  Xsteel_4, 0,
  Xsteel_4, 1,
  Xsteel_4, 2,
  Xsteel_4, 3,
  Xsteel_4, 4,
  Xsteel_4, 5,
  Xsteel_4, 6,
  Xsteel_4, 7,
  -1,
  Xwall_1, 0,
  Xwall_1, 1,
  Xwall_1, 2,
  Xwall_1, 3,
  Xwall_1, 4,
  Xwall_1, 5,
  Xwall_1, 6,
  Xwall_1, 7,
  -1,
  Xwall_2, 0,
  Xwall_2, 1,
  Xwall_2, 2,
  Xwall_2, 3,
  Xwall_2, 4,
  Xwall_2, 5,
  Xwall_2, 6,
  Xwall_2, 7,
  -1,
  Xwall_3, 0,
  Xwall_3, 1,
  Xwall_3, 2,
  Xwall_3, 3,
  Xwall_3, 4,
  Xwall_3, 5,
  Xwall_3, 6,
  Xwall_3, 7,
  -1,
  Xwall_4, 0,
  Xwall_4, 1,
  Xwall_4, 2,
  Xwall_4, 3,
  Xwall_4, 4,
  Xwall_4, 5,
  Xwall_4, 6,
  Xwall_4, 7,
  -1,
  Xround_wall_1, 0,
  Xround_wall_1, 1,
  Xround_wall_1, 2,
  Xround_wall_1, 3,
  Xround_wall_1, 4,
  Xround_wall_1, 5,
  Xround_wall_1, 6,
  Xround_wall_1, 7,
  -1,
  Xround_wall_2, 0,
  Xround_wall_2, 1,
  Xround_wall_2, 2,
  Xround_wall_2, 3,
  Xround_wall_2, 4,
  Xround_wall_2, 5,
  Xround_wall_2, 6,
  Xround_wall_2, 7,
  -1,
  Xround_wall_3, 0,
  Xround_wall_3, 1,
  Xround_wall_3, 2,
  Xround_wall_3, 3,
  Xround_wall_3, 4,
  Xround_wall_3, 5,
  Xround_wall_3, 6,
  Xround_wall_3, 7,
  -1,
  Xround_wall_4, 0,
  Xround_wall_4, 1,
  Xround_wall_4, 2,
  Xround_wall_4, 3,
  Xround_wall_4, 4,
  Xround_wall_4, 5,
  Xround_wall_4, 6,
  Xround_wall_4, 7,
  -1,
  Xdecor_1, 0,
  Xdecor_1, 1,
  Xdecor_1, 2,
  Xdecor_1, 3,
  Xdecor_1, 4,
  Xdecor_1, 5,
  Xdecor_1, 6,
  Xdecor_1, 7,
  -1,
  Xdecor_2, 0,
  Xdecor_2, 1,
  Xdecor_2, 2,
  Xdecor_2, 3,
  Xdecor_2, 4,
  Xdecor_2, 5,
  Xdecor_2, 6,
  Xdecor_2, 7,
  -1,
  Xdecor_3, 0,
  Xdecor_3, 1,
  Xdecor_3, 2,
  Xdecor_3, 3,
  Xdecor_3, 4,
  Xdecor_3, 5,
  Xdecor_3, 6,
  Xdecor_3, 7,
  -1,
  Xdecor_4, 0,
  Xdecor_4, 1,
  Xdecor_4, 2,
  Xdecor_4, 3,
  Xdecor_4, 4,
  Xdecor_4, 5,
  Xdecor_4, 6,
  Xdecor_4, 7,
  -1,
  Xdecor_5, 0,
  Xdecor_5, 1,
  Xdecor_5, 2,
  Xdecor_5, 3,
  Xdecor_5, 4,
  Xdecor_5, 5,
  Xdecor_5, 6,
  Xdecor_5, 7,
  -1,
  Xdecor_6, 0,
  Xdecor_6, 1,
  Xdecor_6, 2,
  Xdecor_6, 3,
  Xdecor_6, 4,
  Xdecor_6, 5,
  Xdecor_6, 6,
  Xdecor_6, 7,
  -1,
  Xdecor_7, 0,
  Xdecor_7, 1,
  Xdecor_7, 2,
  Xdecor_7, 3,
  Xdecor_7, 4,
  Xdecor_7, 5,
  Xdecor_7, 6,
  Xdecor_7, 7,
  -1,
  Xdecor_8, 0,
  Xdecor_8, 1,
  Xdecor_8, 2,
  Xdecor_8, 3,
  Xdecor_8, 4,
  Xdecor_8, 5,
  Xdecor_8, 6,
  Xdecor_8, 7,
  -1,
  Xdecor_9, 0,
  Xdecor_9, 1,
  Xdecor_9, 2,
  Xdecor_9, 3,
  Xdecor_9, 4,
  Xdecor_9, 5,
  Xdecor_9, 6,
  Xdecor_9, 7,
  -1,
  Xdecor_10, 0,
  Xdecor_10, 1,
  Xdecor_10, 2,
  Xdecor_10, 3,
  Xdecor_10, 4,
  Xdecor_10, 5,
  Xdecor_10, 6,
  Xdecor_10, 7,
  -1,
  Xdecor_11, 0,
  Xdecor_11, 1,
  Xdecor_11, 2,
  Xdecor_11, 3,
  Xdecor_11, 4,
  Xdecor_11, 5,
  Xdecor_11, 6,
  Xdecor_11, 7,
  -1,
  Xdecor_12, 0,
  Xdecor_12, 1,
  Xdecor_12, 2,
  Xdecor_12, 3,
  Xdecor_12, 4,
  Xdecor_12, 5,
  Xdecor_12, 6,
  Xdecor_12, 7,
  -1,
  Xalpha_excla, 0,
  Xalpha_excla, 1,
  Xalpha_excla, 2,
  Xalpha_excla, 3,
  Xalpha_excla, 4,
  Xalpha_excla, 5,
  Xalpha_excla, 6,
  Xalpha_excla, 7,
  -1,
  Xalpha_quote, 0,
  Xalpha_quote, 1,
  Xalpha_quote, 2,
  Xalpha_quote, 3,
  Xalpha_quote, 4,
  Xalpha_quote, 5,
  Xalpha_quote, 6,
  Xalpha_quote, 7,
  -1,
  Xalpha_comma, 0,
  Xalpha_comma, 1,
  Xalpha_comma, 2,
  Xalpha_comma, 3,
  Xalpha_comma, 4,
  Xalpha_comma, 5,
  Xalpha_comma, 6,
  Xalpha_comma, 7,
  -1,
  Xalpha_minus, 0,
  Xalpha_minus, 1,
  Xalpha_minus, 2,
  Xalpha_minus, 3,
  Xalpha_minus, 4,
  Xalpha_minus, 5,
  Xalpha_minus, 6,
  Xalpha_minus, 7,
  -1,
  Xalpha_perio, 0,
  Xalpha_perio, 1,
  Xalpha_perio, 2,
  Xalpha_perio, 3,
  Xalpha_perio, 4,
  Xalpha_perio, 5,
  Xalpha_perio, 6,
  Xalpha_perio, 7,
  -1,
  Xalpha_0, 0,
  Xalpha_0, 1,
  Xalpha_0, 2,
  Xalpha_0, 3,
  Xalpha_0, 4,
  Xalpha_0, 5,
  Xalpha_0, 6,
  Xalpha_0, 7,
  -1,
  Xalpha_1, 0,
  Xalpha_1, 1,
  Xalpha_1, 2,
  Xalpha_1, 3,
  Xalpha_1, 4,
  Xalpha_1, 5,
  Xalpha_1, 6,
  Xalpha_1, 7,
  -1,
  Xalpha_2, 0,
  Xalpha_2, 1,
  Xalpha_2, 2,
  Xalpha_2, 3,
  Xalpha_2, 4,
  Xalpha_2, 5,
  Xalpha_2, 6,
  Xalpha_2, 7,
  -1,
  Xalpha_3, 0,
  Xalpha_3, 1,
  Xalpha_3, 2,
  Xalpha_3, 3,
  Xalpha_3, 4,
  Xalpha_3, 5,
  Xalpha_3, 6,
  Xalpha_3, 7,
  -1,
  Xalpha_4, 0,
  Xalpha_4, 1,
  Xalpha_4, 2,
  Xalpha_4, 3,
  Xalpha_4, 4,
  Xalpha_4, 5,
  Xalpha_4, 6,
  Xalpha_4, 7,
  -1,
  Xalpha_5, 0,
  Xalpha_5, 1,
  Xalpha_5, 2,
  Xalpha_5, 3,
  Xalpha_5, 4,
  Xalpha_5, 5,
  Xalpha_5, 6,
  Xalpha_5, 7,
  -1,
  Xalpha_6, 0,
  Xalpha_6, 1,
  Xalpha_6, 2,
  Xalpha_6, 3,
  Xalpha_6, 4,
  Xalpha_6, 5,
  Xalpha_6, 6,
  Xalpha_6, 7,
  -1,
  Xalpha_7, 0,
  Xalpha_7, 1,
  Xalpha_7, 2,
  Xalpha_7, 3,
  Xalpha_7, 4,
  Xalpha_7, 5,
  Xalpha_7, 6,
  Xalpha_7, 7,
  -1,
  Xalpha_8, 0,
  Xalpha_8, 1,
  Xalpha_8, 2,
  Xalpha_8, 3,
  Xalpha_8, 4,
  Xalpha_8, 5,
  Xalpha_8, 6,
  Xalpha_8, 7,
  -1,
  Xalpha_9, 0,
  Xalpha_9, 1,
  Xalpha_9, 2,
  Xalpha_9, 3,
  Xalpha_9, 4,
  Xalpha_9, 5,
  Xalpha_9, 6,
  Xalpha_9, 7,
  -1,
  Xalpha_colon, 0,
  Xalpha_colon, 1,
  Xalpha_colon, 2,
  Xalpha_colon, 3,
  Xalpha_colon, 4,
  Xalpha_colon, 5,
  Xalpha_colon, 6,
  Xalpha_colon, 7,
  -1,
  Xalpha_arrow_w, 0,
  Xalpha_arrow_w, 1,
  Xalpha_arrow_w, 2,
  Xalpha_arrow_w, 3,
  Xalpha_arrow_w, 4,
  Xalpha_arrow_w, 5,
  Xalpha_arrow_w, 6,
  Xalpha_arrow_w, 7,
  -1,
  Xalpha_arrow_e, 0,
  Xalpha_arrow_e, 1,
  Xalpha_arrow_e, 2,
  Xalpha_arrow_e, 3,
  Xalpha_arrow_e, 4,
  Xalpha_arrow_e, 5,
  Xalpha_arrow_e, 6,
  Xalpha_arrow_e, 7,
  -1,
  Xalpha_quest, 0,
  Xalpha_quest, 1,
  Xalpha_quest, 2,
  Xalpha_quest, 3,
  Xalpha_quest, 4,
  Xalpha_quest, 5,
  Xalpha_quest, 6,
  Xalpha_quest, 7,
  -1,
  Xalpha_a, 0,
  Xalpha_a, 1,
  Xalpha_a, 2,
  Xalpha_a, 3,
  Xalpha_a, 4,
  Xalpha_a, 5,
  Xalpha_a, 6,
  Xalpha_a, 7,
  -1,
  Xalpha_b, 0,
  Xalpha_b, 1,
  Xalpha_b, 2,
  Xalpha_b, 3,
  Xalpha_b, 4,
  Xalpha_b, 5,
  Xalpha_b, 6,
  Xalpha_b, 7,
  -1,
  Xalpha_c, 0,
  Xalpha_c, 1,
  Xalpha_c, 2,
  Xalpha_c, 3,
  Xalpha_c, 4,
  Xalpha_c, 5,
  Xalpha_c, 6,
  Xalpha_c, 7,
  -1,
  Xalpha_d, 0,
  Xalpha_d, 1,
  Xalpha_d, 2,
  Xalpha_d, 3,
  Xalpha_d, 4,
  Xalpha_d, 5,
  Xalpha_d, 6,
  Xalpha_d, 7,
  -1,
  Xalpha_e, 0,
  Xalpha_e, 1,
  Xalpha_e, 2,
  Xalpha_e, 3,
  Xalpha_e, 4,
  Xalpha_e, 5,
  Xalpha_e, 6,
  Xalpha_e, 7,
  -1,
  Xalpha_f, 0,
  Xalpha_f, 1,
  Xalpha_f, 2,
  Xalpha_f, 3,
  Xalpha_f, 4,
  Xalpha_f, 5,
  Xalpha_f, 6,
  Xalpha_f, 7,
  -1,
  Xalpha_g, 0,
  Xalpha_g, 1,
  Xalpha_g, 2,
  Xalpha_g, 3,
  Xalpha_g, 4,
  Xalpha_g, 5,
  Xalpha_g, 6,
  Xalpha_g, 7,
  -1,
  Xalpha_h, 0,
  Xalpha_h, 1,
  Xalpha_h, 2,
  Xalpha_h, 3,
  Xalpha_h, 4,
  Xalpha_h, 5,
  Xalpha_h, 6,
  Xalpha_h, 7,
  -1,
  Xalpha_i, 0,
  Xalpha_i, 1,
  Xalpha_i, 2,
  Xalpha_i, 3,
  Xalpha_i, 4,
  Xalpha_i, 5,
  Xalpha_i, 6,
  Xalpha_i, 7,
  -1,
  Xalpha_j, 0,
  Xalpha_j, 1,
  Xalpha_j, 2,
  Xalpha_j, 3,
  Xalpha_j, 4,
  Xalpha_j, 5,
  Xalpha_j, 6,
  Xalpha_j, 7,
  -1,
  Xalpha_k, 0,
  Xalpha_k, 1,
  Xalpha_k, 2,
  Xalpha_k, 3,
  Xalpha_k, 4,
  Xalpha_k, 5,
  Xalpha_k, 6,
  Xalpha_k, 7,
  -1,
  Xalpha_l, 0,
  Xalpha_l, 1,
  Xalpha_l, 2,
  Xalpha_l, 3,
  Xalpha_l, 4,
  Xalpha_l, 5,
  Xalpha_l, 6,
  Xalpha_l, 7,
  -1,
  Xalpha_m, 0,
  Xalpha_m, 1,
  Xalpha_m, 2,
  Xalpha_m, 3,
  Xalpha_m, 4,
  Xalpha_m, 5,
  Xalpha_m, 6,
  Xalpha_m, 7,
  -1,
  Xalpha_n, 0,
  Xalpha_n, 1,
  Xalpha_n, 2,
  Xalpha_n, 3,
  Xalpha_n, 4,
  Xalpha_n, 5,
  Xalpha_n, 6,
  Xalpha_n, 7,
  -1,
  Xalpha_o, 0,
  Xalpha_o, 1,
  Xalpha_o, 2,
  Xalpha_o, 3,
  Xalpha_o, 4,
  Xalpha_o, 5,
  Xalpha_o, 6,
  Xalpha_o, 7,
  -1,
  Xalpha_p, 0,
  Xalpha_p, 1,
  Xalpha_p, 2,
  Xalpha_p, 3,
  Xalpha_p, 4,
  Xalpha_p, 5,
  Xalpha_p, 6,
  Xalpha_p, 7,
  -1,
  Xalpha_q, 0,
  Xalpha_q, 1,
  Xalpha_q, 2,
  Xalpha_q, 3,
  Xalpha_q, 4,
  Xalpha_q, 5,
  Xalpha_q, 6,
  Xalpha_q, 7,
  -1,
  Xalpha_r, 0,
  Xalpha_r, 1,
  Xalpha_r, 2,
  Xalpha_r, 3,
  Xalpha_r, 4,
  Xalpha_r, 5,
  Xalpha_r, 6,
  Xalpha_r, 7,
  -1,
  Xalpha_s, 0,
  Xalpha_s, 1,
  Xalpha_s, 2,
  Xalpha_s, 3,
  Xalpha_s, 4,
  Xalpha_s, 5,
  Xalpha_s, 6,
  Xalpha_s, 7,
  -1,
  Xalpha_t, 0,
  Xalpha_t, 1,
  Xalpha_t, 2,
  Xalpha_t, 3,
  Xalpha_t, 4,
  Xalpha_t, 5,
  Xalpha_t, 6,
  Xalpha_t, 7,
  -1,
  Xalpha_u, 0,
  Xalpha_u, 1,
  Xalpha_u, 2,
  Xalpha_u, 3,
  Xalpha_u, 4,
  Xalpha_u, 5,
  Xalpha_u, 6,
  Xalpha_u, 7,
  -1,
  Xalpha_v, 0,
  Xalpha_v, 1,
  Xalpha_v, 2,
  Xalpha_v, 3,
  Xalpha_v, 4,
  Xalpha_v, 5,
  Xalpha_v, 6,
  Xalpha_v, 7,
  -1,
  Xalpha_w, 0,
  Xalpha_w, 1,
  Xalpha_w, 2,
  Xalpha_w, 3,
  Xalpha_w, 4,
  Xalpha_w, 5,
  Xalpha_w, 6,
  Xalpha_w, 7,
  -1,
  Xalpha_x, 0,
  Xalpha_x, 1,
  Xalpha_x, 2,
  Xalpha_x, 3,
  Xalpha_x, 4,
  Xalpha_x, 5,
  Xalpha_x, 6,
  Xalpha_x, 7,
  -1,
  Xalpha_y, 0,
  Xalpha_y, 1,
  Xalpha_y, 2,
  Xalpha_y, 3,
  Xalpha_y, 4,
  Xalpha_y, 5,
  Xalpha_y, 6,
  Xalpha_y, 7,
  -1,
  Xalpha_z, 0,
  Xalpha_z, 1,
  Xalpha_z, 2,
  Xalpha_z, 3,
  Xalpha_z, 4,
  Xalpha_z, 5,
  Xalpha_z, 6,
  Xalpha_z, 7,
  -1,
  Xalpha_copyr, 0,
  Xalpha_copyr, 1,
  Xalpha_copyr, 2,
  Xalpha_copyr, 3,
  Xalpha_copyr, 4,
  Xalpha_copyr, 5,
  Xalpha_copyr, 6,
  Xalpha_copyr, 7,
  -1,

  Yball_eat, 7,
  Yball_eat, 6,
  Yball_eat, 5,
  Ykey_1_eat, 7,
  Ykey_1_eat, 6,
  Ykey_1_eat, 5,
  Ykey_2_eat, 7,
  Ykey_2_eat, 6,
  Ykey_2_eat, 5,
  Ykey_3_eat, 7,
  Ykey_3_eat, 6,
  Ykey_3_eat, 5,
  Ykey_4_eat, 7,
  Ykey_4_eat, 6,
  Ykey_4_eat, 5,
  Ykey_5_eat, 7,
  Ykey_5_eat, 6,
  Ykey_5_eat, 5,
  Ykey_6_eat, 7,
  Ykey_6_eat, 6,
  Ykey_6_eat, 5,
  Ykey_7_eat, 7,
  Ykey_7_eat, 6,
  Ykey_7_eat, 5,
  Ykey_8_eat, 7,
  Ykey_8_eat, 6,
  Ykey_8_eat, 5,
  Ylenses_eat, 7,
  Ylenses_eat, 6,
  Ylenses_eat, 5,
  Ymagnify_eat, 7,
  Ymagnify_eat, 6,
  Ymagnify_eat, 5,
  Ygrass_eat, 7,
  Ygrass_eat, 6,
  Ygrass_eat, 5,
  Ydirt_eat, 7,
  Ydirt_eat, 6,
  Ydirt_eat, 5,
  Xboom_2, 7,
  Xboom_2, 6,
  Xboom_2, 5,
  -1,
  Yball_eat, 4,
  Yball_eat, 3,
  Yball_eat, 2,
  Ykey_1_eat, 4,
  Ykey_1_eat, 3,
  Ykey_1_eat, 2,
  Ykey_2_eat, 4,
  Ykey_2_eat, 3,
  Ykey_2_eat, 2,
  Ykey_3_eat, 4,
  Ykey_3_eat, 3,
  Ykey_3_eat, 2,
  Ykey_4_eat, 4,
  Ykey_4_eat, 3,
  Ykey_4_eat, 2,
  Ykey_5_eat, 4,
  Ykey_5_eat, 3,
  Ykey_5_eat, 2,
  Ykey_6_eat, 4,
  Ykey_6_eat, 3,
  Ykey_6_eat, 2,
  Ykey_7_eat, 4,
  Ykey_7_eat, 3,
  Ykey_7_eat, 2,
  Ykey_8_eat, 4,
  Ykey_8_eat, 3,
  Ykey_8_eat, 2,
  Ylenses_eat, 4,
  Ylenses_eat, 3,
  Ylenses_eat, 2,
  Ymagnify_eat, 4,
  Ymagnify_eat, 3,
  Ymagnify_eat, 2,
  Ygrass_eat, 4,
  Ygrass_eat, 3,
  Ygrass_eat, 2,
  Ydirt_eat, 4,
  Ydirt_eat, 3,
  Ydirt_eat, 2,
  Xboom_2, 4,
  Xboom_2, 3,
  Xboom_2, 2,
  -1,
  Yball_eat, 1,
  Yball_eat, 0,
  Ykey_1_eat, 1,
  Ykey_1_eat, 0,
  Ykey_2_eat, 1,
  Ykey_2_eat, 0,
  Ykey_3_eat, 1,
  Ykey_3_eat, 0,
  Ykey_4_eat, 1,
  Ykey_4_eat, 0,
  Ykey_5_eat, 1,
  Ykey_5_eat, 0,
  Ykey_6_eat, 1,
  Ykey_6_eat, 0,
  Ykey_7_eat, 1,
  Ykey_7_eat, 0,
  Ykey_8_eat, 1,
  Ykey_8_eat, 0,
  Ylenses_eat, 1,
  Ylenses_eat, 0,
  Ymagnify_eat, 1,
  Ymagnify_eat, 0,
  Ygrass_eat, 1,
  Ygrass_eat, 0,
  Ydirt_eat, 1,
  Ydirt_eat, 0,
  Xboom_2, 1,
  Xboom_2, 0,
  Xboom_1, 7,
  -1,
  Xboom_1, 6,
  Xboom_1, 5,
  Xboom_android, 7,
  -1,
  Xboom_1, 4,
  Xboom_1, 3,
  Xboom_bug, 4,
  Xboom_bomb, 4,
  Xboom_bug, 3,
  Xboom_bomb, 3,
  -1,
  Xboom_1, 2,
  Xboom_1, 1,
  Xboom_bug, 6,
  Xboom_bomb, 6,
  Xboom_bug, 5,
  Xboom_bomb, 5,
  Xboom_bug, 2,
  Xboom_bomb, 2,
  Xboom_bug, 1,
  Xboom_bomb, 1,
  -1,
  Xboom_bug, 0,
  Xboom_bug, 7,
  Xboom_bomb, 0,
  Xboom_bomb, 7,
  Xboom_1, 0,
  Ybug_stone, 7,
  Ybug_spring, 7,
  Ytank_stone, 7,
  Ytank_spring, 7,
  Yeater_stone, 7,
  Yeater_spring, 7,
  Yalien_stone, 7,
  Yalien_spring, 7,
  Ybomb_eat, 7,
  -1
};

int spr_map[] =
{
  SPR_walk + 0,		0,	0, 1, 2, 3, 4, 5, 6, 7,
  SPR_walk + 1,		0,	8, 9, 10, 11, 12, 13, 14, 15,
  SPR_walk + 2,		0,	16, 17, 18, 19, 20, 21, 22, 23,
  SPR_walk + 3,		0,	24, 25, 26, 27, 28, 29, 30, 31,

  SPR_push + 0,		0,	32, 33, 34, 35, 36, 35, 34, 33,
  SPR_push + 1,		0,	37, 38, 39, 40, 41, 40, 39, 38,
  SPR_push + 2,		0,	42, 43, 44, 45, 46, 45, 44, 43,
  SPR_push + 3,		0,	47, 48, 49, 50, 51, 50, 49, 48,

  SPR_spray + 0,	0,	52, 52, 52, 52, 52, 52, 52, 52,
  SPR_spray + 1,	0,	53, 53, 53, 53, 53, 53, 53, 53,
  SPR_spray + 2,	0,	54, 54, 54, 54, 54, 54, 54, 54,
  SPR_spray + 3,	0,	55, 55, 55, 55, 55, 55, 55, 55,

  SPR_walk + 0,		1,	56, 57, 58, 59, 60, 61, 62, 63,
  SPR_walk + 1,		1,	64, 65, 66, 67, 68, 69, 70, 71,
  SPR_walk + 2,		1,	72, 73, 74, 75, 76, 77, 78, 79,
  SPR_walk + 3,		1,	80, 81, 82, 83, 84, 85, 86, 87,

  SPR_push + 0,		1,	88, 89, 90, 91, 92, 91, 90, 89,
  SPR_push + 1,		1,	93, 94, 95, 96, 97, 96, 95, 94,
  SPR_push + 2,		1,	98, 99, 100, 101, 102, 101, 100, 99,
  SPR_push + 3,		1,	103, 104, 105, 106, 107, 106, 105, 104,

  SPR_spray + 0,	1,	108, 108, 108, 108, 108, 108, 108, 108,
  SPR_spray + 1,	1,	109, 109, 109, 109, 109, 109, 109, 109,
  SPR_spray + 2,	1,	110, 110, 110, 110, 110, 110, 110, 110,
  SPR_spray + 3,	1,	111, 111, 111, 111, 111, 111, 111, 111,

  SPR_still,		0,	112,112, 112, 112, 112, 112, 112, 112,
  SPR_still,		1,	113,113, 113, 113, 113, 113, 113, 113,

  SPR_MAX
};


/* 0=stop 1=blank */
unsigned char tab_blank[TILE_MAX];

/* 0=stop 1=acid */
unsigned char tab_acid[TILE_MAX];

/* 0=stop 1=amoeba */
unsigned char tab_amoeba[TILE_MAX];

/* 0=stop 1=move */
unsigned char tab_android_move[TILE_MAX];

/* normal explosion */
unsigned short tab_explode_normal[TILE_MAX];

/* dynamite explosion */
unsigned short tab_explode_dynamite[TILE_MAX];

/* map tiles to coords */
unsigned short map_obj[8][TILE_MAX];

/* map sprites to coords */
unsigned short map_spr[2][8][13];

/* map ascii to coords */
unsigned short map_ttl[128];

/* map tiles and frames to graphic info */
struct GraphicInfo_EM graphic_info_em_object[TILE_MAX][8];

/* map player number, frames and action to graphic info */
struct GraphicInfo_EM graphic_info_em_player[MAX_PLAYERS][SPR_MAX][8];

void create_tab(int *invert, unsigned char *array)
{
  int i;
  int buffer[TILE_MAX];

  for (i = 0; i < TILE_MAX; i++)
    buffer[i] = 0;

  for (;invert[0] < TILE_MAX; invert += 2)
    buffer[invert[0]] = invert[1];

  for (i = 0; i < TILE_MAX; i++)
    array[i] = buffer[i];
}

void create_explode()
{
  int i;
  int *tile = tile_explode;
  int buffer[TILE_MAX];

  for (i = 0; i < TILE_MAX; i++)
    buffer[i] = Xboom_1;
  while ((i = *tile++) < TILE_MAX)
    buffer[i] = i;			/* these tiles are indestructable */
  while ((i = *tile++) < TILE_MAX)
    buffer[i] = *tile++;		/* these tiles are special */

  for (i = 0; i < TILE_MAX; i++)
    tab_explode_normal[i] = buffer[i];

  while ((i = *tile++) < TILE_MAX)
    buffer[i] = *tile++;		/* these tiles for dynamite */

  for (i = 0; i < TILE_MAX; i++)
    tab_explode_dynamite[i] = buffer[i];
}

void create_obj()
{
  int i, j;
  int *map = obj_map;
  int buffer[8][TILE_MAX];

  for (i = 0; i < 8; i++)
    for (j = 0; j < TILE_MAX; j++)
      buffer[i][j] = Xblank;

  /* special case for first 64 entries */
  for (i = 0; i < 64; i++)
  {
    for (;*map != -1; map += 2)
      buffer[map[1]][map[0]] = i;
    map++;
  }

  /* now regular entries */
  for (i = 0; i < 896 * 16; i += 16)
  {
    for (;*map != -1; map += 2)
      buffer[map[1]][map[0]] = i;
    map++;
  }

  for (i = 0; i < 8; i++)
    for (j = 0; j < TILE_MAX; j++)
      map_obj[i][j] = buffer[7 - i][j];
}

void create_obj_graphics_info_em()
{
  int i, j;

  for (i = 0; i < TILE_MAX; i++)
  {
    for (j = 0; j < 8; j++)
    {
      struct GraphicInfo_EM *g = &graphic_info_em_object[i][j];
      int obj = map_obj[j][i];

      g->bitmap = objBitmap;
      g->src_x = (obj / 512) * TILEX;
      g->src_y = (obj % 512) * TILEY / 16;
      g->src_offset_x = 0;
      g->src_offset_y = 0;
      g->dst_offset_x = 0;
      g->dst_offset_y = 0;
      g->width = TILEX;
      g->height = TILEY;

      g->crumbled_bitmap = NULL;
      g->crumbled_src_x = 0;
      g->crumbled_src_y = 0;
      g->crumbled_border_size = 0;
      g->crumbled_tile_size = 0;

      g->has_crumbled_graphics = FALSE;
      g->preserve_background = FALSE;

      /* create unique graphic identifier to decide if tile must be redrawn */
      g->unique_identifier = obj;
    }
  }
}

void create_spr()
{
  int i, j, k;
  int *map = spr_map;
  int buffer[2][8][SPR_MAX];

  while (*map < SPR_MAX)
  {
    i = *map++;
    j = *map++;

    for (k = 0; k < 8; k++)
      buffer[j][k][i] = *map++;
  }

  for (i = 0; i < 2; i++)
    for (j = 0; j < 8; j++)
      for (k = 0; k < SPR_MAX; k++)
	map_spr[i][j][k] = buffer[i][7 - j][k];
}

void create_spr_graphics_info_em()
{
  int i, j, k;

  for (i = 0; i < MAX_PLAYERS; i++)
  {
    for (j = 0; j < SPR_MAX; j++)
    {
      for (k = 0; k < 8; k++)
      {
	struct GraphicInfo_EM *g = &graphic_info_em_player[i][j][k];
	int spr = map_spr[i % 2][k][j];

	g->bitmap = sprBitmap;
	g->src_x = (spr / 8) * TILEX;
	g->src_y = (spr % 8) * TILEY;
	g->src_offset_x = 0;
	g->src_offset_y = 0;
	g->dst_offset_x = 0;
	g->dst_offset_y = 0;
	g->width = TILEX;
	g->height = TILEY;

	g->has_crumbled_graphics = FALSE;
	g->crumbled_bitmap = NULL;
	g->crumbled_src_x = 0;
	g->crumbled_src_y = 0;
	g->crumbled_border_size = 0;

	g->unique_identifier = 0;
      }
    }
  }
}

void tab_generate()
{
  create_tab(tile_blank, tab_blank);
  create_tab(tile_acid, tab_acid);
  create_tab(tile_amoeba, tab_amoeba);
  create_tab(tile_android_move, tab_android_move);
  create_explode();
  create_obj();
  create_spr();
}

void tab_generate_graphics_info_em()
{
  create_obj_graphics_info_em();
  create_spr_graphics_info_em();

  InitGraphicInfo_EM();
}
