/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef _effects_h
#define _effects_h

#include "pm.h"

#ifdef effects_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Add a new "explosion craft" to the list of aircraft.
 * @param loc Location of the explosion (geocentric, m).
 * @param vel Initial velocity of the explosion (NED, ft/s).
 * @param s_meters Overall radius of the explosion (m).
 * @param dur1 Dust duration (s).
 * @param dur2 Flame duration (s).
 */
EXTERN void effects_new_explosion(VPoint * loc, VPoint *vel, double s_meters,
	double dur1, double dur2);

#undef EXTERN
#endif
