/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.util.DebugUtils;
import android.support.v4.util.SparseArrayCompat;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoaderManagerImpl
extends LoaderManager {
    static final String TAG = "LoaderManager";
    static boolean DEBUG = false;
    final SparseArrayCompat<LoaderInfo> mLoaders = new SparseArrayCompat();
    final SparseArrayCompat<LoaderInfo> mInactiveLoaders = new SparseArrayCompat();
    FragmentActivity mActivity;
    boolean mStarted;
    boolean mRetaining;
    boolean mRetainingStarted;
    boolean mCreatingLoader;

    LoaderManagerImpl(FragmentActivity activity, boolean started) {
        this.mActivity = activity;
        this.mStarted = started;
    }

    void updateActivity(FragmentActivity activity) {
        this.mActivity = activity;
    }

    private LoaderInfo createLoader(int id, Bundle args, LoaderManager.LoaderCallbacks<Object> callback) {
        LoaderInfo info = new LoaderInfo(id, args, callback);
        Loader<Object> loader = callback.onCreateLoader(id, args);
        info.mLoader = loader;
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoaderInfo createAndInstallLoader(int id, Bundle args, LoaderManager.LoaderCallbacks<Object> callback) {
        try {
            this.mCreatingLoader = true;
            LoaderInfo info = this.createLoader(id, args, callback);
            this.installLoader(info);
            LoaderInfo loaderInfo = info;
            return loaderInfo;
        }
        finally {
            this.mCreatingLoader = false;
        }
    }

    void installLoader(LoaderInfo info) {
        this.mLoaders.put(info.mId, info);
        if (this.mStarted) {
            info.start();
        }
    }

    @Override
    public <D> Loader<D> initLoader(int id, Bundle args, LoaderManager.LoaderCallbacks<D> callback) {
        if (this.mCreatingLoader) {
            throw new IllegalStateException("Called while creating a loader");
        }
        LoaderInfo info = this.mLoaders.get(id);
        if (DEBUG) {
            Log.v((String)TAG, (String)("initLoader in " + this + ": args=" + args));
        }
        if (info == null) {
            info = this.createAndInstallLoader(id, args, callback);
            if (DEBUG) {
                Log.v((String)TAG, (String)("  Created new loader " + info));
            }
        } else {
            if (DEBUG) {
                Log.v((String)TAG, (String)("  Re-using existing loader " + info));
            }
            info.mCallbacks = callback;
        }
        if (info.mHaveData && this.mStarted) {
            info.callOnLoadFinished(info.mLoader, info.mData);
        }
        return info.mLoader;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public <D> Loader<D> restartLoader(int id, Bundle args, LoaderManager.LoaderCallbacks<D> callback) {
        LoaderInfo info;
        block12: {
            block13: {
                if (this.mCreatingLoader) {
                    throw new IllegalStateException("Called while creating a loader");
                }
                info = this.mLoaders.get(id);
                if (DEBUG) {
                    Log.v((String)TAG, (String)("restartLoader in " + this + ": args=" + args));
                }
                if (info == null) break block12;
                LoaderInfo inactive = this.mInactiveLoaders.get(id);
                if (inactive == null) break block13;
                if (info.mHaveData) {
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("  Removing last inactive loader: " + info));
                    }
                    inactive.mDeliveredData = false;
                    inactive.destroy();
                    info.mLoader.abandon();
                    this.mInactiveLoaders.put(id, info);
                    break block12;
                } else if (!info.mStarted) {
                    if (DEBUG) {
                        Log.v((String)TAG, (String)"  Current loader is stopped; replacing");
                    }
                    this.mLoaders.put(id, null);
                    info.destroy();
                    break block12;
                } else {
                    if (info.mPendingLoader != null) {
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("  Removing pending loader: " + info.mPendingLoader));
                        }
                        info.mPendingLoader.destroy();
                        info.mPendingLoader = null;
                    }
                    if (DEBUG) {
                        Log.v((String)TAG, (String)"  Enqueuing as new pending loader");
                    }
                    info.mPendingLoader = this.createLoader(id, args, callback);
                    return info.mPendingLoader.mLoader;
                }
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("  Making last loader inactive: " + info));
            }
            info.mLoader.abandon();
            this.mInactiveLoaders.put(id, info);
        }
        info = this.createAndInstallLoader(id, args, callback);
        return info.mLoader;
    }

    @Override
    public void destroyLoader(int id) {
        LoaderInfo info;
        int idx;
        if (this.mCreatingLoader) {
            throw new IllegalStateException("Called while creating a loader");
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("destroyLoader in " + this + " of " + id));
        }
        if ((idx = this.mLoaders.indexOfKey(id)) >= 0) {
            info = this.mLoaders.valueAt(idx);
            this.mLoaders.removeAt(idx);
            info.destroy();
        }
        if ((idx = this.mInactiveLoaders.indexOfKey(id)) >= 0) {
            info = this.mInactiveLoaders.valueAt(idx);
            this.mInactiveLoaders.removeAt(idx);
            info.destroy();
        }
        if (this.mActivity != null && !this.hasRunningLoaders()) {
            this.mActivity.mFragments.startPendingDeferredFragments();
        }
    }

    @Override
    public <D> Loader<D> getLoader(int id) {
        if (this.mCreatingLoader) {
            throw new IllegalStateException("Called while creating a loader");
        }
        LoaderInfo loaderInfo = this.mLoaders.get(id);
        if (loaderInfo != null) {
            if (loaderInfo.mPendingLoader != null) {
                return loaderInfo.mPendingLoader.mLoader;
            }
            return loaderInfo.mLoader;
        }
        return null;
    }

    void doStart() {
        if (DEBUG) {
            Log.v((String)TAG, (String)("Starting in " + this));
        }
        if (this.mStarted) {
            RuntimeException e = new RuntimeException("here");
            e.fillInStackTrace();
            Log.w((String)TAG, (String)("Called doStart when already started: " + this), (Throwable)e);
            return;
        }
        this.mStarted = true;
        for (int i = this.mLoaders.size() - 1; i >= 0; --i) {
            this.mLoaders.valueAt(i).start();
        }
    }

    void doStop() {
        if (DEBUG) {
            Log.v((String)TAG, (String)("Stopping in " + this));
        }
        if (!this.mStarted) {
            RuntimeException e = new RuntimeException("here");
            e.fillInStackTrace();
            Log.w((String)TAG, (String)("Called doStop when not started: " + this), (Throwable)e);
            return;
        }
        for (int i = this.mLoaders.size() - 1; i >= 0; --i) {
            this.mLoaders.valueAt(i).stop();
        }
        this.mStarted = false;
    }

    void doRetain() {
        if (DEBUG) {
            Log.v((String)TAG, (String)("Retaining in " + this));
        }
        if (!this.mStarted) {
            RuntimeException e = new RuntimeException("here");
            e.fillInStackTrace();
            Log.w((String)TAG, (String)("Called doRetain when not started: " + this), (Throwable)e);
            return;
        }
        this.mRetaining = true;
        this.mStarted = false;
        for (int i = this.mLoaders.size() - 1; i >= 0; --i) {
            this.mLoaders.valueAt(i).retain();
        }
    }

    void finishRetain() {
        if (this.mRetaining) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Finished Retaining in " + this));
            }
            this.mRetaining = false;
            for (int i = this.mLoaders.size() - 1; i >= 0; --i) {
                this.mLoaders.valueAt(i).finishRetain();
            }
        }
    }

    void doReportNextStart() {
        for (int i = this.mLoaders.size() - 1; i >= 0; --i) {
            this.mLoaders.valueAt((int)i).mReportNextStart = true;
        }
    }

    void doReportStart() {
        for (int i = this.mLoaders.size() - 1; i >= 0; --i) {
            this.mLoaders.valueAt(i).reportStart();
        }
    }

    void doDestroy() {
        int i;
        if (!this.mRetaining) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Destroying Active in " + this));
            }
            for (i = this.mLoaders.size() - 1; i >= 0; --i) {
                this.mLoaders.valueAt(i).destroy();
            }
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("Destroying Inactive in " + this));
        }
        for (i = this.mInactiveLoaders.size() - 1; i >= 0; --i) {
            this.mInactiveLoaders.valueAt(i).destroy();
        }
        this.mInactiveLoaders.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("LoaderManager{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" in ");
        DebugUtils.buildShortClassTag((Object)this.mActivity, sb);
        sb.append("}}");
        return sb.toString();
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        LoaderInfo li;
        int i;
        String innerPrefix;
        if (this.mLoaders.size() > 0) {
            writer.print(prefix);
            writer.println("Active Loaders:");
            innerPrefix = prefix + "    ";
            for (i = 0; i < this.mLoaders.size(); ++i) {
                li = this.mLoaders.valueAt(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(this.mLoaders.keyAt(i));
                writer.print(": ");
                writer.println(li.toString());
                li.dump(innerPrefix, fd, writer, args);
            }
        }
        if (this.mInactiveLoaders.size() > 0) {
            writer.print(prefix);
            writer.println("Inactive Loaders:");
            innerPrefix = prefix + "    ";
            for (i = 0; i < this.mInactiveLoaders.size(); ++i) {
                li = this.mInactiveLoaders.valueAt(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(this.mInactiveLoaders.keyAt(i));
                writer.print(": ");
                writer.println(li.toString());
                li.dump(innerPrefix, fd, writer, args);
            }
        }
    }

    @Override
    public boolean hasRunningLoaders() {
        boolean loadersRunning = false;
        int count = this.mLoaders.size();
        for (int i = 0; i < count; ++i) {
            LoaderInfo li = this.mLoaders.valueAt(i);
            loadersRunning |= li.mStarted && !li.mDeliveredData;
        }
        return loadersRunning;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class LoaderInfo
    implements Loader.OnLoadCompleteListener<Object> {
        final int mId;
        final Bundle mArgs;
        LoaderManager.LoaderCallbacks<Object> mCallbacks;
        Loader<Object> mLoader;
        boolean mHaveData;
        boolean mDeliveredData;
        Object mData;
        boolean mStarted;
        boolean mRetaining;
        boolean mRetainingStarted;
        boolean mReportNextStart;
        boolean mDestroyed;
        boolean mListenerRegistered;
        LoaderInfo mPendingLoader;

        public LoaderInfo(int id, Bundle args, LoaderManager.LoaderCallbacks<Object> callbacks) {
            this.mId = id;
            this.mArgs = args;
            this.mCallbacks = callbacks;
        }

        void start() {
            if (this.mRetaining && this.mRetainingStarted) {
                this.mStarted = true;
                return;
            }
            if (this.mStarted) {
                return;
            }
            this.mStarted = true;
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("  Starting: " + this));
            }
            if (this.mLoader == null && this.mCallbacks != null) {
                this.mLoader = this.mCallbacks.onCreateLoader(this.mId, this.mArgs);
            }
            if (this.mLoader != null) {
                if (this.mLoader.getClass().isMemberClass() && !Modifier.isStatic(this.mLoader.getClass().getModifiers())) {
                    throw new IllegalArgumentException("Object returned from onCreateLoader must not be a non-static inner member class: " + this.mLoader);
                }
                if (!this.mListenerRegistered) {
                    this.mLoader.registerListener(this.mId, this);
                    this.mListenerRegistered = true;
                }
                this.mLoader.startLoading();
            }
        }

        void retain() {
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("  Retaining: " + this));
            }
            this.mRetaining = true;
            this.mRetainingStarted = this.mStarted;
            this.mStarted = false;
            this.mCallbacks = null;
        }

        void finishRetain() {
            if (this.mRetaining) {
                if (DEBUG) {
                    Log.v((String)LoaderManagerImpl.TAG, (String)("  Finished Retaining: " + this));
                }
                this.mRetaining = false;
                if (this.mStarted != this.mRetainingStarted && !this.mStarted) {
                    this.stop();
                }
            }
            if (this.mStarted && this.mHaveData && !this.mReportNextStart) {
                this.callOnLoadFinished(this.mLoader, this.mData);
            }
        }

        void reportStart() {
            if (this.mStarted && this.mReportNextStart) {
                this.mReportNextStart = false;
                if (this.mHaveData) {
                    this.callOnLoadFinished(this.mLoader, this.mData);
                }
            }
        }

        void stop() {
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("  Stopping: " + this));
            }
            this.mStarted = false;
            if (!this.mRetaining && this.mLoader != null && this.mListenerRegistered) {
                this.mListenerRegistered = false;
                this.mLoader.unregisterListener(this);
                this.mLoader.stopLoading();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() {
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("  Destroying: " + this));
            }
            this.mDestroyed = true;
            boolean needReset = this.mDeliveredData;
            this.mDeliveredData = false;
            if (this.mCallbacks != null && this.mLoader != null && this.mHaveData && needReset) {
                if (DEBUG) {
                    Log.v((String)LoaderManagerImpl.TAG, (String)("  Reseting: " + this));
                }
                String lastBecause = null;
                if (LoaderManagerImpl.this.mActivity != null) {
                    lastBecause = LoaderManagerImpl.this.mActivity.mFragments.mNoTransactionsBecause;
                    LoaderManagerImpl.this.mActivity.mFragments.mNoTransactionsBecause = "onLoaderReset";
                }
                try {
                    this.mCallbacks.onLoaderReset(this.mLoader);
                }
                finally {
                    if (LoaderManagerImpl.this.mActivity != null) {
                        LoaderManagerImpl.this.mActivity.mFragments.mNoTransactionsBecause = lastBecause;
                    }
                }
            }
            this.mCallbacks = null;
            this.mData = null;
            this.mHaveData = false;
            if (this.mLoader != null) {
                if (this.mListenerRegistered) {
                    this.mListenerRegistered = false;
                    this.mLoader.unregisterListener(this);
                }
                this.mLoader.reset();
            }
            if (this.mPendingLoader != null) {
                this.mPendingLoader.destroy();
            }
        }

        @Override
        public void onLoadComplete(Loader<Object> loader, Object data) {
            LoaderInfo info;
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("onLoadComplete: " + this));
            }
            if (this.mDestroyed) {
                if (DEBUG) {
                    Log.v((String)LoaderManagerImpl.TAG, (String)"  Ignoring load complete -- destroyed");
                }
                return;
            }
            if (LoaderManagerImpl.this.mLoaders.get(this.mId) != this) {
                if (DEBUG) {
                    Log.v((String)LoaderManagerImpl.TAG, (String)"  Ignoring load complete -- not active");
                }
                return;
            }
            LoaderInfo pending = this.mPendingLoader;
            if (pending != null) {
                if (DEBUG) {
                    Log.v((String)LoaderManagerImpl.TAG, (String)("  Switching to pending loader: " + pending));
                }
                this.mPendingLoader = null;
                LoaderManagerImpl.this.mLoaders.put(this.mId, null);
                this.destroy();
                LoaderManagerImpl.this.installLoader(pending);
                return;
            }
            if (this.mData != data || !this.mHaveData) {
                this.mData = data;
                this.mHaveData = true;
                if (this.mStarted) {
                    this.callOnLoadFinished(loader, data);
                }
            }
            if ((info = LoaderManagerImpl.this.mInactiveLoaders.get(this.mId)) != null && info != this) {
                info.mDeliveredData = false;
                info.destroy();
                LoaderManagerImpl.this.mInactiveLoaders.remove(this.mId);
            }
            if (LoaderManagerImpl.this.mActivity != null && !LoaderManagerImpl.this.hasRunningLoaders()) {
                LoaderManagerImpl.this.mActivity.mFragments.startPendingDeferredFragments();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void callOnLoadFinished(Loader<Object> loader, Object data) {
            if (this.mCallbacks != null) {
                String lastBecause = null;
                if (LoaderManagerImpl.this.mActivity != null) {
                    lastBecause = LoaderManagerImpl.this.mActivity.mFragments.mNoTransactionsBecause;
                    LoaderManagerImpl.this.mActivity.mFragments.mNoTransactionsBecause = "onLoadFinished";
                }
                try {
                    if (DEBUG) {
                        Log.v((String)LoaderManagerImpl.TAG, (String)("  onLoadFinished in " + loader + ": " + loader.dataToString(data)));
                    }
                    this.mCallbacks.onLoadFinished(loader, data);
                }
                finally {
                    if (LoaderManagerImpl.this.mActivity != null) {
                        LoaderManagerImpl.this.mActivity.mFragments.mNoTransactionsBecause = lastBecause;
                    }
                }
                this.mDeliveredData = true;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append("LoaderInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" #");
            sb.append(this.mId);
            sb.append(" : ");
            DebugUtils.buildShortClassTag(this.mLoader, sb);
            sb.append("}}");
            return sb.toString();
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.print(prefix);
            writer.print("mId=");
            writer.print(this.mId);
            writer.print(" mArgs=");
            writer.println(this.mArgs);
            writer.print(prefix);
            writer.print("mCallbacks=");
            writer.println(this.mCallbacks);
            writer.print(prefix);
            writer.print("mLoader=");
            writer.println(this.mLoader);
            if (this.mLoader != null) {
                this.mLoader.dump(prefix + "  ", fd, writer, args);
            }
            if (this.mHaveData || this.mDeliveredData) {
                writer.print(prefix);
                writer.print("mHaveData=");
                writer.print(this.mHaveData);
                writer.print("  mDeliveredData=");
                writer.println(this.mDeliveredData);
                writer.print(prefix);
                writer.print("mData=");
                writer.println(this.mData);
            }
            writer.print(prefix);
            writer.print("mStarted=");
            writer.print(this.mStarted);
            writer.print(" mReportNextStart=");
            writer.print(this.mReportNextStart);
            writer.print(" mDestroyed=");
            writer.println(this.mDestroyed);
            writer.print(prefix);
            writer.print("mRetaining=");
            writer.print(this.mRetaining);
            writer.print(" mRetainingStarted=");
            writer.print(this.mRetainingStarted);
            writer.print(" mListenerRegistered=");
            writer.println(this.mListenerRegistered);
            if (this.mPendingLoader != null) {
                writer.print(prefix);
                writer.println("Pending Loader ");
                writer.print(this.mPendingLoader);
                writer.println(":");
                this.mPendingLoader.dump(prefix + "  ", fd, writer, args);
            }
        }
    }
}

