/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file.attribute;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.attribute.Attribute;
import net.sf.jiapi.file.attribute.LineNumberTableAttribute;
import net.sf.jiapi.file.attribute.LocalVariableTableAttribute;
import net.sf.jiapi.file.attribute.LocalVariableTypeTableAttribute;
import net.sf.jiapi.file.attribute.StackMapTableAttribute;

public class CodeAttribute
extends Attribute {
    public static final String ATTRIBUTE_NAME = "Code";
    private short max_stack;
    private short max_locals;
    private byte[] code;
    private List<ExceptionTableEntry> exceptionTable = new LinkedList<ExceptionTableEntry>();
    private List<Attribute> attributes = new LinkedList<Attribute>();

    public CodeAttribute(ConstantPool cp, short max_stack, short max_locals) {
        super(cp.addUtf8Info(ATTRIBUTE_NAME).getEntryIndex());
        this.setConstantPool(cp);
        this.max_stack = max_stack;
        this.max_locals = max_locals;
        this.code = new byte[0];
    }

    CodeAttribute(ConstantPool cp, short nameIndex, int attributeLength, DataInputStream dis) throws IOException {
        super(nameIndex, attributeLength, dis);
        this.setConstantPool(cp);
        dis = this.getDataInputStream();
        this.max_stack = dis.readShort();
        this.max_locals = dis.readShort();
        int codeLength = dis.readInt();
        this.code = new byte[codeLength];
        for (int i = 0; i < codeLength; ++i) {
            this.code[i] = dis.readByte();
        }
        int exceptionTableLength = dis.readShort();
        for (int i = 0; i < exceptionTableLength; ++i) {
            short start_pc = dis.readShort();
            short end_pc = dis.readShort();
            short handler_pc = dis.readShort();
            short catch_type = dis.readShort();
            this.exceptionTable.add(new ExceptionTableEntry(start_pc, end_pc, handler_pc, catch_type));
        }
        int attrCount = dis.readShort();
        for (int i = 0; i < attrCount; ++i) {
            Attribute a = Attribute.readAttribute(cp, dis);
            if (config.stripAttribute(a.getName())) continue;
            this.attributes.add(a);
        }
    }

    public short getMaxStack() {
        return this.max_stack;
    }

    public void setMaxStack(short maxStack) {
        this.max_stack = maxStack;
    }

    public short getMaxLocals() {
        return this.max_locals;
    }

    public void setMaxLocals(short maxLocals) {
        this.max_locals = maxLocals;
    }

    public byte[] getByteCode() {
        return this.code;
    }

    public void setByteCode(byte[] byteCode) {
        this.code = byteCode;
    }

    @Override
    public byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeShort(this.max_stack);
            dos.writeShort(this.max_locals);
            dos.writeInt(this.code.length);
            for (int i = 0; i < this.code.length; ++i) {
                dos.writeByte(this.code[i]);
            }
            dos.writeShort(this.exceptionTable.size());
            for (ExceptionTableEntry ete : this.exceptionTable) {
                dos.writeShort(ete.getStartPc());
                dos.writeShort(ete.getEndPc());
                dos.writeShort(ete.getHandlerPc());
                dos.writeShort(ete.getCatchType());
            }
            dos.writeShort(this.attributes.size());
            for (Attribute a : this.attributes) {
                dos.writeShort(a.getAttributeNameIndex());
                byte[] bytes = a.getBytes();
                dos.writeInt(bytes.length);
                for (int j = 0; j < bytes.length; ++j) {
                    dos.writeByte(bytes[j]);
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return baos.toByteArray();
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String name) {
        for (Attribute a : this.attributes) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public List<ExceptionTableEntry> getExceptionTable() {
        return this.exceptionTable;
    }

    public StackMapTableAttribute getStackMapTable() {
        StackMapTableAttribute smt = (StackMapTableAttribute)this.getAttribute("StackMapTable");
        if (smt == null) {
            // empty if block
        }
        return smt;
    }

    public LineNumberTableAttribute getLineNumberTable() {
        return (LineNumberTableAttribute)this.getAttribute("LineNumberTable");
    }

    public LocalVariableTableAttribute getLocalVariableTable() {
        return (LocalVariableTableAttribute)this.getAttribute("LocalVariableTable");
    }

    public LocalVariableTypeTableAttribute getLocalVariableTypeTable() {
        return (LocalVariableTypeTableAttribute)this.getAttribute("LocalVariableTypeTable");
    }

    public class ExceptionTableEntry {
        private short start_pc;
        private short end_pc;
        private short handler_pc;
        private short catch_type;

        ExceptionTableEntry(short start_pc, short end_pc, short handler_pc, short catch_type) {
            this.start_pc = start_pc;
            this.end_pc = end_pc;
            this.handler_pc = handler_pc;
            this.catch_type = catch_type;
        }

        public short getStartPc() {
            return this.start_pc;
        }

        public void setStartPc(short start_pc) {
            this.start_pc = start_pc;
        }

        public short getEndPc() {
            return this.end_pc;
        }

        public void setEndPc(short end_pc) {
            this.end_pc = end_pc;
        }

        public short getHandlerPc() {
            return this.handler_pc;
        }

        public void setHandlerPc(short handler_pc) {
            this.handler_pc = handler_pc;
        }

        public short getCatchType() {
            return this.catch_type;
        }
    }
}

