//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_16.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot16(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[16] = {3.796291457531356e-02,3.422001560109479e-01,9.535531553908649e-01,1.877931507696073e+00,3.124601050702144e+00,
    4.706726707667587e+00,6.642215179741441e+00,8.955001337723402e+00,1.167703367397597e+01,1.485143134180125e+01,1.853774317860670e+01,2.282130069352524e+01,
    2.783143821132866e+01,3.378197048822615e+01,4.108166652549124e+01,5.077722387753705e+01};
  constexpr double aw[16] = {3.752383525928021e-01,2.774581423025299e-01,1.512697340766425e-01,6.045813095591287e-02,1.755342883157343e-02,
    3.654890326654414e-03,5.362683655279714e-04,5.416584061819941e-05,3.650585129562365e-06,1.574167792545599e-07,4.098832164770895e-09,5.933291463396627e-11,
    4.215010211326526e-13,1.197344017092839e-15,9.231736536518329e-19,7.310676427384286e-23};
  constexpr double x[6144] = {  4.528762093298874e-03, -6.846711148975946e-05,  7.745664694601187e-07, -7.766208948540965e-09,  7.272421585141476e-11,
 -6.507899924577577e-13,  5.630966140888772e-15, -4.742309608121141e-17,  3.901989162694675e-19, -3.143347320128412e-21,  2.481232111457460e-23, -1.918963285777795e-25,
  4.052708998532357e-02, -6.019704814112580e-04,  6.569739787519514e-06, -6.193910974862438e-08,  5.265115471814889e-10, -4.070740339606129e-12,  2.825678680470423e-14,
 -1.682145150807782e-16,  7.352964823986329e-19, -3.168489292281945e-22, -4.225753800670852e-23,  6.510227937825918e-25,  1.112941168521492e-01, -1.595095779912797e-03,
  1.615387311301631e-05, -1.327704948190986e-07,  8.799315075270930e-10, -4.058005463976455e-12,  9.568933626840279e-16,  2.456783351548764e-16, -3.425667496388769e-18,
  3.038679897442242e-20, -1.794660672565024e-22,  2.879250852337215e-25,  2.144017566704653e-01, -2.909603695880526e-03,  2.612042404397053e-05, -1.661984743928415e-07,
  5.307684439244524e-10,  3.629087617973904e-12, -7.720674742269384e-14,  6.789263871340496e-16, -2.650753568791085e-18, -1.942390151510540e-20,  4.612306468764388e-22,
 -4.350500202611966e-24,  3.462862772869696e-01, -4.360931896593936e-03,  3.270524492148243e-05, -1.227031689723626e-07, -5.779577076140309e-10,  1.320567343132375e-11,
 -9.100312896230159e-14, -6.886336015116219e-17,  8.029804503033989e-18, -7.986377987330481e-20,  1.661958894316355e-22,  5.320019613109050e-24,  5.023435668004893e-01,
 -5.742765055826347e-03,  3.296896234899003e-05, -2.058770451002789e-09, -1.788327327990061e-09,  1.339139021613701e-11,  2.942913892806037e-14, -1.308735355854333e-15,
  8.116112798047158e-18,  4.930703793029180e-20, -1.160835635324171e-21,  5.179202885639306e-24,  6.770577738292840e-01, -6.855310050089386e-03,  2.576864591013170e-05,
  1.521306491314885e-07, -2.170882297529823e-09,  1.949184030324381e-13,  1.665988481728323e-13, -8.927584483471353e-16, -9.956120568553297e-18,  1.372330762705245e-19,
  1.917113041758069e-22, -1.462633452772359e-23,  8.641639531660991e-01, -7.533786327113088e-03,  1.221023220960477e-05,  2.719824915052127e-07, -1.267394464615344e-09,
 -1.640395273952874e-11,  1.373804648455197e-13,  1.084619700566786e-15, -1.506985542162224e-17, -6.629354622660344e-20,  1.645847008437097e-21,  2.586348827122721e-24,
  1.056844521115172e+00, -7.673284790605053e-03, -4.590877994058447e-06,  2.999555726987025e-07,  4.674536434911412e-10, -2.099570306830440e-11, -5.218370753586070e-14,
  1.777571047711970e-15,  6.088734748785013e-18, -1.658151077044750e-19, -7.298728662236387e-22,  1.637972787411053e-23,  1.247957820199584e+00, -7.246220786020698e-03,
 -2.041041159734925e-05,  2.203597287823049e-07,  1.932618228317119e-09, -8.711927767761417e-12, -1.853799002583136e-13,  4.739003313867954e-17,  1.706148286806788e-17,
  6.252276895065673e-20, -1.433520946767294e-21, -1.212905732583897e-23,  1.430294830525527e+00, -6.309224058425225e-03, -3.122854739349291e-05,  6.970399995936915e-08,
  2.197050088453232e-09,  8.974770526017751e-12, -1.119088555296608e-13, -1.503889729236764e-15, -3.484890331910165e-19,  1.374536656372525e-19,  1.005612049377432e-21,
 -6.431639330828405e-24,  1.596857084203608e+00, -4.997534074515934e-03, -3.454466954619051e-05, -8.156562377019017e-08,  1.217403493056741e-09,  1.606545545952621e-11,
  5.536799452901624e-14, -7.773054029569644e-16, -1.216104205620492e-17, -4.893410663571538e-20,  6.413141185467940e-22,  1.105889331040852e-23,  1.741145374726106e+00,
 -3.506757711438419e-03, -3.024123619737959e-05, -1.671538188819501e-07, -1.581935849399109e-10,  8.725214549616345e-12,  1.093598611921375e-13,  6.052772368331883e-16,
 -1.617301985437258e-18, -7.031189420481950e-20, -7.191208662250543e-22, -2.611095918570636e-24,  1.857445434032616e+00, -2.063994414719612e-03, -2.066208299281245e-05,
 -1.613809546725744e-07, -9.249594446315847e-10, -2.233066262197833e-12,  3.075938126771003e-14,  5.635874289145939e-16,  5.373320460574906e-18,  3.071754420707053e-20,
  1.338325642805127e-24, -2.500603721034022e-24,  1.941094662919006e+00, -8.924572532942629e-04, -9.828271852864316e-06, -9.200172253611048e-08, -7.575224705604717e-10,
 -5.436239780005299e-12, -3.199774270165604e-14, -1.194257055661998e-16,  3.578188167435238e-19,  1.346724983466845e-20,  1.768691619566780e-22,  1.706295829522613e-24,
  1.988724114142204e+00, -1.751617277525588e-04, -2.029188473293259e-06, -2.073551092222442e-08, -1.967050444831106e-10, -1.769665877385981e-12, -1.524832454514618e-14,
 -1.263516642231127e-16, -1.007161690238967e-18, -7.698909512642434e-21, -5.602118866008186e-23, -3.823587326898317e-25,  4.266723158365084e-03, -6.262452041490192e-05,
  6.879465753514638e-07, -6.699832471884017e-09,  6.095916431603037e-11, -5.302681053855025e-13,  4.462192483940350e-15, -3.657111231276253e-17,  2.930414864160239e-19,
 -2.301046975783858e-21,  1.772376832318763e-23, -1.339432442030883e-25,  3.821981083870123e-02, -5.522483851290207e-04,  5.874443986160022e-06, -5.413095040397781e-08,
  4.515105168907302e-10, -3.446459619323097e-12,  2.387245003332168e-14, -1.451431838275929e-16,  6.995497521507143e-19, -1.522226409649998e-21, -1.995539556654729e-23,
  3.832606842254345e-25,  1.051624349294998e-01, -1.472004586701329e-03,  1.464243223959895e-05, -1.193374953222127e-07,  7.994983434915444e-10, -3.963917317512179e-12,
  6.455941676638780e-15,  1.522060437953176e-16, -2.456873340652196e-18,  2.357012286540592e-20, -1.592595676248691e-22,  5.802861568065475e-25,  2.031688478896790e-01,
 -2.708468567801994e-03,  2.417908242783221e-05, -1.572199190343261e-07,  5.863085374675265e-10,  1.994132026383712e-12, -5.946617339045272e-14,  5.861162308637671e-16,
 -3.061630896177131e-18, -4.533251101702787e-21,  2.903202982523441e-22, -3.392508341641921e-24,  3.293563117341399e-01, -4.105317593433839e-03,  3.118565369420520e-05,
 -1.299564193067967e-07, -3.357021839837288e-10,  1.102489552262963e-11, -8.975467032062844e-14,  1.437698101499482e-16,  5.321743343392577e-18, -6.951380987532481e-20,
  3.287825512101989e-22,  2.231367865213078e-24,  4.798991938681393e-01, -5.479578058460482e-03,  3.278150757421000e-05, -2.850292287285357e-08, -1.516247236749903e-09,
  1.368863406485559e-11, -3.373645674228239e-15, -1.029085357735519e-15,  9.117589659324208e-18,  8.197211729661285e-21, -8.802501860130798e-22,  7.167791588978025e-24,
  6.500595623882403e-01, -6.642447428555400e-03,  2.738661670536595e-05,  1.176358761888003e-07, -2.129191575265399e-09,  3.861910368657384e-12,  1.378875355945505e-13,
 -1.132024990064495e-15, -5.023195257119523e-18,  1.331157993730021e-19, -3.669830517184297e-22, -1.045659095114739e-23,  8.342443242131515e-01, -7.423417764061986e-03,
  1.534213172582515e-05,  2.492680131986023e-07, -1.560331609355526e-09, -1.279863010219679e-11,  1.607308915464775e-13,  5.769805343572500e-16, -1.626628894938388e-17,
 -6.149334778375193e-22,  1.580467644884426e-21, -5.289562107492048e-24,  1.026100861502337e+00, -7.695519069872869e-03, -9.605661257934397e-07,  3.040247172037689e-07,
  3.913678623714695e-11, -2.163451233828671e-11, -6.130519242022814e-16,  1.872737885562869e-15, -2.234137394985553e-19, -1.796708791814269e-19,  5.163234145665357e-23,
  1.836585301843877e-23,  1.218663840505841e+00, -7.398415945500555e-03, -1.758709246447394e-05,  2.496475602642601e-07,  1.714322128731753e-09, -1.308176801363176e-11,
 -1.761555403413699e-13,  6.173567691765280e-16,  1.816661208434438e-17, -3.782061077762183e-21, -1.832512265410880e-21, -5.394581852242297e-24,  1.404564435409381e+00,
 -6.555096425352070e-03, -3.017577098064687e-05,  1.061325569656792e-07,  2.346290401413939e-09,  5.787224661114757e-12, -1.533784770219129e-13, -1.428786271389011e-15,
  5.236172680082340e-18,  1.698705019063901e-19,  5.616861200383349e-22, -1.374674614711148e-23,  1.576308534425704e+00, -5.277450598524758e-03, -3.539577138649664e-05,
 -5.945270515576582e-08,  1.550004541986658e-09,  1.708771190543806e-11,  2.793145687370444e-14, -1.188705902171833e-15, -1.333831690917863e-17, -1.299242930616973e-20,
  1.165680831218064e-21,  1.239240422855256e-23,  1.726621738351285e+00, -3.756739796085737e-03, -3.225603260864998e-05, -1.681406515717039e-07,  4.388895335869893e-11,
  1.154483390003510e-11,  1.251618237326349e-13,  5.072810695884946e-16, -4.688736138840634e-18, -1.007711480491146e-19, -7.854180935329229e-22, -7.031671328606057e-26,
  1.848846238796290e+00, -2.237292059020054e-03, -2.268877892165493e-05, -1.764917581932485e-07, -9.608555670523047e-10, -1.285029575127995e-12,  4.911198787463286e-14,
  7.529893570381034e-16,  6.448549663324226e-18,  2.800449087436024e-20, -1.524722787267103e-22, -4.628179622125010e-24,  1.937360287294192e+00, -9.757140966087431e-04,
 -1.100874079411077e-05, -1.050347128942804e-07, -8.741888038917518e-10, -6.242518129995985e-12, -3.509783302946511e-14, -9.869454013003400e-17,  9.898508010160515e-19,
  2.224068232628266e-20,  2.670045492805799e-22,  2.420425981085458e-24,  1.987989345065302e+00, -1.924468691610950e-04, -2.298134128898077e-06, -2.418709381755015e-08,
 -2.360644931304232e-10, -2.181994134445196e-12, -1.928233037070654e-14, -1.634829067475184e-16, -1.329035258259493e-18, -1.031217372139781e-20, -7.559074504808733e-23,
 -5.126867092563370e-25,  4.026745425906358e-03, -5.742672873620617e-05,  6.130686293730989e-07, -5.803840067954064e-09,  5.134695361386229e-11, -4.344756623265856e-13,
  3.557943306241511e-15, -2.839310081982029e-17,  2.216629905315011e-19, -1.697183784201429e-21,  1.275809116623842e-23, -9.421223009728528e-26,  3.610086116968601e-02,
 -5.077333510473743e-04,  5.266040097391713e-06, -4.742842294767532e-08,  3.879943684706408e-10, -2.919814746785542e-12,  2.011267668241221e-14, -1.237588710372862e-16,
  6.339349817563592e-19, -2.038054748906877e-21, -7.043216107962454e-24,  2.169425047791224e-25,  9.949992498949323e-02, -1.360381828891855e-03,  1.328454881665451e-05,
 -1.071700312626283e-07,  7.220718834840790e-10, -3.765976183237038e-12,  9.736127451674270e-15,  8.598505058472543e-17, -1.716557393133540e-18,  1.774139668590581e-20,
 -1.317136110134196e-22,  6.456735328585521e-25,  1.927101187603747e-01, -2.522420434398743e-03,  2.234980872488628e-05, -1.475920857512404e-07,  6.131910218304230e-10,
  7.527304952132750e-13, -4.443668846086032e-14,  4.874998539161742e-16, -3.049089310891264e-18,  4.387756859785409e-21,  1.628530283293488e-22, -2.417059784175951e-24,
  3.134240273678759e-01, -3.862145577460169e-03,  2.960085107057941e-05, -1.336790248466704e-07, -1.363293405439932e-10,  8.936115914721470e-12, -8.370218508211141e-14,
  2.767135005535724e-16,  3.073268872682929e-18, -5.508319238018829e-20,  3.776384665350880e-22,  1.548693319469654e-25,  4.585026646339949e-01, -5.219085825495291e-03,
  3.230290767556887e-05, -5.058629895413081e-08, -1.245447484490836e-09,  1.329490825907598e-11, -2.810382385314699e-14, -7.387712083716501e-16,  8.856031004897768e-18,
 -2.060802763078646e-20, -5.607204967165849e-22,  7.084798299749950e-24,  6.239360904025446e-01, -6.418280129314619e-03,  2.859694601472919e-05,  8.435547387026007e-08,
 -2.021503311299768e-09,  6.776992988194569e-12,  1.046358946818669e-13, -1.219736140088447e-15, -5.924930983824855e-19,  1.107381574293629e-19, -7.142247940924457e-22,
 -5.308695992721104e-24,  8.048144485611977e-01, -7.289158325040825e-03,  1.817580034999233e-05,  2.224689582674346e-07, -1.776722730605791e-09, -8.805639767088742e-12,
  1.696795140316396e-13,  6.773838579405889e-17, -1.522346910781128e-17,  5.613744183638680e-20,  1.217945117163709e-21, -1.065757000135288e-23,  9.953264938173036e-01,
 -7.688632568710795e-03,  2.677254756951216e-06,  3.012063222281071e-07, -3.894825832326904e-10, -2.102671705512637e-11,  5.076303738849168e-14,  1.764055304384579e-15,
 -6.463403723290510e-18, -1.619235594956841e-19,  8.155263903693073e-22,  1.560804670623410e-23,  1.188808386704154e+00, -7.526684649424004e-03, -1.443610597479122e-05,
  2.747609770516977e-07,  1.412146696969671e-09, -1.703701886011573e-11, -1.508541611098253e-13,  1.182055417083950e-15,  1.667787668537310e-17, -7.916194139645381e-20,
 -1.867154267674736e-21,  4.079301904603345e-24,  1.377870214302475e+00, -6.790762608205812e-03, -2.867380090596162e-05,  1.443859660389612e-07,  2.422105868396465e-09,
  1.650777089386266e-12, -1.900958802658312e-13, -1.160350534325163e-15,  1.159202313550516e-17,  1.782804761166250e-19, -1.854382279439934e-22, -1.977671184795689e-23,
  1.554628510954726e+00, -5.563022747987653e-03, -3.594904055481813e-05, -3.189436234463792e-08,  1.895516500770753e-09,  1.731034615431613e-11, -1.132789613702220e-14,
 -1.612960232786833e-15, -1.283719717799755e-17,  4.428335032720421e-20,  1.684789667128532e-21,  1.053876644836759e-23,  1.711065945308194e+00, -4.022828239335027e-03,
 -3.426134645093835e-05, -1.654235646400607e-07,  3.058723486888984e-10,  1.469864193701077e-11,  1.366768461648248e-13,  2.931988170200286e-16, -8.871740482478475e-18,
 -1.310057100677828e-19, -6.909654996114349e-22,  4.787762325360148e-24,  1.839520265749694e+00, -2.427536747335886e-03, -2.489954220319644e-05, -1.919994105575473e-07,
 -9.729372256699295e-10,  1.708592386041207e-13,  7.322526859725034e-14,  9.738504479946465e-16,  7.290528156843026e-18,  1.701595593909088e-20, -4.187142965149612e-22,
 -7.613690039110884e-24,  1.933272959838465e+00, -1.069073258879501e-03, -1.235735017923415e-05, -1.200671691671959e-07, -1.007664562107431e-09, -7.113629251790579e-12,
 -3.728148628753108e-14, -5.192445223352358e-17,  2.010664999094506e-18,  3.529896025205055e-20,  3.923048651501207e-22,  3.296960282819543e-24,  1.987180853986345e+00,
 -2.120606203225817e-04, -2.612567481413941e-06, -2.834003635374870e-08, -2.847292866244448e-10, -2.704871141365649e-12, -2.451549834609645e-14, -2.125822366874388e-16,
 -1.760549853759974e-18, -1.383298686627273e-20, -1.016518568969602e-22, -6.776742635211123e-25,  3.806425400128300e-03, -5.278742919902509e-05,  5.480794255618396e-07,
 -5.047421929797066e-09,  4.345086628574808e-11, -3.578766958869957e-13,  2.853714273357781e-15, -2.218653635551023e-17,  1.688327906044144e-19, -1.260953811079234e-21,
  9.252810428386733e-24, -6.677267750594899e-26,  3.415072319314571e-02, -4.677803335102284e-04,  4.732301237742921e-06, -4.166259430831108e-08,  3.341559844072717e-10,
 -2.476470492915179e-12,  1.692011133395071e-14, -1.046846606852482e-16,  5.574815625392395e-19, -2.162449637829951e-21,  8.856805314112810e-26,  1.156646182079788e-25,
  9.426307536955221e-02, -1.259058834470600e-03,  1.206538490704981e-05, -9.620602728889528e-08,  6.492543418003095e-10, -3.509070053167240e-12,  1.146377822403228e-14,
  4.031261891528598e-17, -1.165919005493026e-18,  1.303277473720000e-20, -1.040607715019211e-22,  5.995725209402980e-25,  1.829670534906009e-01, -2.350538806831753e-03,
  2.063789134375242e-05, -1.377140930558160e-07,  6.186302621031925e-10, -1.607895411921944e-13, -3.212110236937326e-14,  3.935211617025033e-16, -2.797146102645690e-18,
  9.031500705437198e-21,  7.535072616221388e-23, -1.591665820954896e-24,  2.984388637503369e-01, -3.631779556085322e-03,  2.798916706422473e-05, -1.345368515939541e-07,
  2.298207674657630e-11,  7.029623947450876e-12, -7.485475592590770e-14,  3.462336722995192e-16,  1.360052006244008e-18, -4.024278374487388e-20,  3.559398150795801e-22,
 -1.008197569560382e-24,  4.381388713475100e-01, -4.963409530603517e-03,  3.158494720651289e-05, -6.842938791568722e-08, -9.878076934904501e-10,  1.240338727814519e-11,
 -4.496086325338509e-14, -4.709853930298118e-16,  7.782742715089384e-18, -3.712350166673446e-20, -2.745531880814325e-22,  5.792865228146295e-24,  5.987261704077398e-01,
 -6.185994217495405e-03,  2.942003045901021e-05,  5.322057970113898e-08, -1.863613389194856e-09,  8.879757430767689e-12,  7.077563339187425e-14, -1.180794320466356e-15,
  2.836722290645937e-18,  7.893109749719155e-20, -8.424829202303682e-22, -7.026516603392417e-25,  7.759648376094777e-01, -7.133568628602468e-03,  2.066976690747644e-05,
  1.928534358206445e-07, -1.912234235931816e-09, -4.763439630182280e-12,  1.651213413761372e-13, -3.786462236663440e-16, -1.244654244634616e-17,  9.465590021711678e-20,
  6.940042334564624e-22, -1.258181469068534e-23,  9.646375002413071e-01, -7.652894015560086e-03,  6.240721814295449e-06,  2.916928279740887e-07, -7.939756406862055e-10,
 -1.924418288124167e-11,  9.643684324126886e-14,  1.471499813076576e-15, -1.155510802947967e-17, -1.172751910100940e-19,  1.369213695334464e-21,  9.098611698961631e-24,
  1.158492058830555e+00, -7.628627980584523e-03, -1.101525653181034e-05,  2.944449868308764e-07,  1.038180885361669e-09, -2.020317755996883e-11, -1.108132172483745e-13,
  1.656262059048795e-15,  1.255353286592618e-17, -1.473538458746063e-19, -1.472813595319487e-21,  1.358726595813576e-23,  1.350260287693764e+00, -7.012562829116996e-03,
 -2.670838880579625e-05,  1.831456819358004e-07,  2.407108195113596e-09, -3.253649321123322e-12, -2.164480076801243e-13, -6.899148385934489e-16,  1.765741567396974e-17,
  1.524887097792528e-19, -1.118997961280264e-21, -2.177914871172753e-23,  1.531799573692845e+00, -5.851604285121114e-03, -3.613847025547728e-05,  1.172618555942127e-09,
  2.235114645829121e-09,  1.645206170100074e-11, -6.190461186790336e-14, -1.984415148887446e-15, -9.931604492338767e-18,  1.194050561652050e-19,  2.023970463246934e-21,
  4.034193400615339e-24,  1.694414027000277e+00, -4.304752633590260e-03, -3.620678094256283e-05, -1.579974412368848e-07,  6.331276625695765e-10,  1.804078467472569e-11,
  1.401677950483302e-13, -7.096165926716379e-17, -1.401670269017473e-17, -1.524215225139875e-19, -3.255787135680507e-22,  1.222476060361272e-23,  1.829396761704302e+00,
 -2.636212767547347e-03, -2.729648854609343e-05, -2.074338316128959e-07, -9.495991127870193e-10,  2.282275075575499e-12,  1.038241838437160e-13,  1.212998921388644e-15,
  7.511429845349603e-18, -7.479923750839289e-21, -8.329337878634229e-22, -1.128931928026695e-23,  1.928789422496154e+00, -1.173980499626712e-03, -1.389974548020777e-05,
 -1.373769452561533e-07, -1.158959492672367e-09, -8.017271178627194e-12, -3.762023775941284e-14,  3.607793535375802e-17,  3.601368010592173e-18,  5.416911395898548e-20,
  5.580000607269275e-22,  4.225425136292811e-24,  1.986288541551523e+00, -2.344032579182975e-04, -2.981876516437347e-06, -3.336259702958037e-08, -3.452275263417228e-10,
 -3.371526583445343e-12, -3.133734033750945e-14, -2.777340116749720e-16, -2.339417710724773e-18, -1.855126235407516e-20, -1.356916404682367e-22, -8.736442834385929e-25,
  3.603677347249534e-03, -4.863377221324915e-05,  4.914569492381366e-07, -4.405947842568244e-09,  3.693089074823964e-11, -2.962712559413903e-13,  2.301781918116207e-15,
 -1.744413491685215e-17,  1.294490895397818e-19, -9.434800774659454e-22,  6.759619929837969e-24, -4.768200449604145e-26,  3.235227584950258e-02, -4.318344633990030e-04,
  4.262863442813384e-06, -3.669123126109882e-08,  2.884600902456117e-10, -2.103617697881314e-12,  1.422704571293755e-14, -8.808143462403633e-17,  4.807362316801928e-19,
 -2.077219109854971e-21,  3.735678058907810e-24,  5.538341239780295e-26,  8.941281693791912e-02, -1.166982282392720e-03,  1.097097431074597e-05, -8.636414705575934e-08,
  5.818956269279041e-10, -3.224204247183407e-12,  1.213529747945442e-14,  9.756884314532275e-18, -7.655291489720382e-19,  9.372953278095000e-21, -7.959569458096485e-23,
  5.087583617491860e-25,  1.738848751645184e-01, -2.191878183772963e-03,  1.904447873858845e-05, -1.278800527296784e-07,  6.085469799692128e-10, -8.092693111931180e-13,
 -2.230333863428238e-14,  3.096715429355623e-16, -2.432800132346746e-18,  1.084380135806853e-20,  1.982494908203777e-23, -9.652450451623455e-25,  2.843493695322501e-01,
 -3.414307669797179e-03,  2.638126367350442e-05, -1.331386407094849e-07,  1.464147585909518e-10,  5.353119499968964e-12, -6.474967448143408e-14,  3.692247823672009e-16,
  1.551530072240465e-19, -2.707567194323042e-20,  2.989095569616851e-22, -1.493632918035802e-24,  4.187850367805682e-01, -4.714264795285020e-03,  3.067695026559804e-05,
 -8.231239194391301e-08, -7.514587840789904e-10,  1.119291901189751e-11, -5.487506671936156e-14, -2.449713584449421e-16,  6.305522447171621e-18, -4.350779153726180e-20,
 -5.736250324536883e-23,  4.057223376071893e-24,  5.744562616449429e-01, -5.948572246946754e-03,  2.988589992443968e-05,  2.490479281081889e-08, -1.671646823906387e-09,
  1.019427609406971e-11,  3.936502431877083e-14, -1.051053638339057e-15,  5.074068237698404e-18,  4.567481538945202e-20, -7.968942668708171e-22,  2.512704954358082e-24,
  7.477751941194413e-01, -6.959479518695351e-03,  2.279797554588633e-05,  1.617064834916381e-07, -1.968951304574893e-09, -9.694458246235057e-13,  1.494874221963791e-13,
 -7.181333095709194e-16, -8.671569827410135e-18,  1.115047204166110e-19,  1.574148430578961e-22, -1.136812430352026e-23,  9.341476020411849e-01, -7.589211314488315e-03,
  9.652556642751285e-06,  2.760491129425390e-07, -1.152608158970318e-09, -1.648056427926454e-11,  1.319066695853012e-13,  1.045399804114021e-15, -1.471597754492518e-17,
 -5.684643336410630e-20,  1.593224117960001e-21,  1.038672515356780e-24,  1.127824037713526e+00, -7.702365854541000e-03, -7.396008592975714e-06,  3.076953899322666e-07,
  6.114909853189925e-10, -2.226607368567974e-11, -5.968498115828495e-14,  1.963036563415640e-15,  6.353112925076006e-18, -1.920976907078143e-19, -7.172451111995105e-22,
  2.002185059155841e-23,  1.321797536693575e+00, -7.216791020423028e-03, -2.428263496658536e-05,  2.208512232594163e-07,  2.288873193707537e-09, -8.611645992557302e-12,
 -2.271021196227544e-13, -4.752239039978658e-17,  2.211621721898670e-17,  8.929764175683070e-20, -2.010393891238045e-21, -1.763347313295311e-23,  1.507815920623338e+00,
 -6.140023423834474e-03, -3.589928400296876e-05,  3.946657780311437e-08,  2.544631425332808e-09,  1.426821078142956e-11, -1.211588177473776e-13, -2.217652393873713e-15,
 -4.160081241350528e-18,  2.008706297523876e-19,  1.965615312880805e-21, -7.427676917475013e-24,  1.676603980927164e+00, -4.601789945376894e-03, -3.802947517919148e-05,
 -1.447997472970413e-07,  1.027138991489633e-09,  2.132515315361580e-11,  1.310654211658143e-13, -6.085957320125847e-16, -1.958472834631146e-17, -1.520398643678072e-19,
  4.122302454952037e-22,  2.146222774259832e-23,  1.818399042954047e+00, -2.864795382838261e-03, -2.987487846838034e-05, -2.221148358987808e-07, -8.761463262234371e-10,
  5.208280448570098e-12,  1.410609908014011e-13,  1.441587387482452e-15,  6.512569436065353e-18, -5.184088144725024e-20, -1.411512115649331e-21, -1.488558422431385e-23,
  1.923860202416895e+00, -1.292100296051721e-03, -1.566497768542709e-05, -1.572515149037111e-07, -1.328176409186344e-09, -8.893046983054343e-12, -3.467058933041083e-14,
  1.872089503673506e-16,  6.000181604910835e-18,  8.043855469387145e-20,  7.603441275098089e-22,  4.883195752887141e-24,  1.985300543263097e+00, -2.599589805783235e-04,
 -3.417734708598331e-06, -3.946935010288471e-08, -4.208554006816872e-10, -4.226057184187332e-12, -4.027027312229732e-14, -3.644072828272176e-16, -3.114780067652394e-18,
 -2.480859331507605e-20, -1.786646017771176e-22, -1.077155646753880e-24,  3.416684328881235e-03, -4.490398853673533e-05,  4.419446900113233e-07, -3.859613499027867e-09,
  3.152062244028104e-11, -2.464512462316471e-13,  1.866582803082915e-15, -1.379686469672963e-17,  9.988474888799483e-20, -7.107727964687342e-22,  4.972980671689825e-24,
 -3.430371943887230e-26,  3.069046197734318e-02, -3.994173548189523e-04,  3.848930325907973e-06, -3.239470471563100e-08,  2.496111534471895e-10, -1.790093581853531e-12,
  1.196512305421253e-14, -7.386147786686528e-17,  4.091240103269484e-19, -1.890759449623405e-21,  5.334626394934057e-24,  2.053614262497591e-26,  8.491407683860434e-02,
 -1.083206489063003e-03,  9.988389953158052e-06, -7.755381840770960e-08,  5.203330822212252e-10, -2.932156083476886e-12,  1.211212358923518e-14, -9.913685716029015e-18,
 -4.802855485773129e-19,  6.607312014633149e-21, -5.941640814485324e-23,  4.087786252100317e-25,  1.654125870445798e-01, -2.045496476650277e-03,  1.756771797320279e-05,
 -1.182990732307248e-07,  5.876672078101859e-10, -1.248932518779778e-12, -1.466308996816886e-14,  2.381466778897789e-16, -2.037071068832175e-18,  1.092915243148644e-20,
 -1.236407521797028e-23, -5.262062640847340e-25,  2.711041868163362e-01, -3.209600784712103e-03,  2.480092496304750e-05, -1.300204246638677e-07,  2.387739961649923e-10,
  3.922926488335020e-12, -5.447271296218232e-14,  3.607702435222423e-16, -6.206031575548189e-19, -1.647357428533700e-20,  2.308152238340513e-22, -1.549031037549478e-24,
  4.004122863344893e-01, -4.472988046404451e-03,  2.962421162792585e-05, -9.261836307455610e-08, -5.412143501362804e-10,  9.814952806693284e-12, -5.914614036590207e-14,
 -6.837937872820296e-17,  4.736325896234279e-18, -4.273837758563531e-20,  8.370233266243209e-23,  2.395720372549129e-24,  5.511414186983494e-01, -5.708728524907450e-03,
  3.003114733598653e-05, -1.687987916981257e-10, -1.460596996073487e-09,  1.080553593136145e-11,  1.241347631533625e-14, -8.682729195841221e-16,  6.176834340884894e-18,
  1.660249840468216e-20, -6.448122130919279e-22,  4.152518611560934e-24,  7.203135768774818e-01, -6.769869601042922e-03,  2.454940568922673e-05,  1.302357298596584e-07,
 -1.954238198093642e-09,  2.349332313872860e-12,  1.261015233828743e-13, -9.311112835071060e-16, -4.657067983937441e-18,  1.086474829905259e-19, -2.766130966625380e-22,
 -8.141361498018073e-24,  9.039657032567584e-01, -7.499077900838153e-03,  1.284420046031418e-05,  2.551514733563107e-07, -1.448472312282594e-09, -1.301821437571675e-11,
  1.543649872832599e-13,  5.539973347077960e-16, -1.562497992578498e-17,  5.550677397762548e-21,  1.474297380457712e-21, -6.117792350378946e-24,  1.096919812676663e+00,
 -7.746632474933037e-03, -3.659856621597883e-06,  3.138578626765927e-07,  1.563883139131252e-10, -2.302250426886518e-11, -2.942617700183578e-15,  2.051927655418680e-15,
 -8.588146164620606e-19, -2.024047148917948e-19,  2.103841725581574e-22,  2.118241558801159e-23,  1.292559494395667e+00, -7.399843677929384e-03, -2.141932912766693e-05,
  2.558002085285227e-07,  2.062451763100369e-09, -1.399571148360471e-11, -2.181601104144160e-13,  6.947457985021334e-16,  2.372004013304431e-17, -3.961465164441307e-21,
 -2.575885440112341e-21, -7.145706160343463e-24,  1.482685442154080e+00, -6.424610604754083e-03, -3.517255334809821e-05,  8.228431128798154e-08,  2.795840411239371e-09,
  1.060742902444745e-11, -1.839264135917938e-13, -2.220785127268331e-15,  4.369997724537387e-18,  2.687854476972037e-19,  1.323775030256791e-21, -2.195648177964410e-23,
  1.657577783276219e+00, -4.912663262416008e-03, -3.965385761844449e-05, -1.247897208241687e-07,  1.483330570351043e-09,  2.419052181227603e-11,  1.044621357046249e-13,
 -1.317689161700624e-15, -2.450907651466958e-17, -1.139792069441122e-19,  1.553212816763094e-21,  2.995611127768880e-23,  1.806444658227298e+00, -3.114685053087426e-03,
 -3.262029477767298e-05, -2.351017872875212e-07, -7.347436937175256e-10,  9.099520394378641e-12,  1.839771593056229e-13,  1.607904016768325e-15,  3.465189351333899e-18,
 -1.221278600301061e-19, -2.115560915639398e-21, -1.658048139311607e-23,  1.918428682275998e+00, -1.425343254835175e-03, -1.768551077067719e-05, -1.799682264293501e-07,
 -1.513809416606368e-09, -9.637646230344693e-12, -2.626102672298782e-14,  4.318398093142879e-16,  9.495443683247254e-18,  1.151573934781166e-19,  9.732180225018615e-22,
  4.533897702342749e-24,  1.984202853385557e+00, -2.893166425823224e-04, -3.934738318512115e-06, -4.693540096306712e-08, -5.159297836846388e-10, -5.327124530939538e-12,
 -5.201374878016458e-14, -4.798451164438843e-16, -4.148418185647594e-18, -3.295310964454932e-20, -2.296075235659798e-22, -1.218248843165053e-24,  3.243857788334572e-03,
 -4.154547827421472e-05,  3.985001905245451e-07, -3.392406853324472e-09,  2.701005718905778e-11, -2.059501624438978e-13,  1.521429787789677e-15, -1.097433334567519e-17,
  7.754163355844544e-20, -5.390236417542995e-22,  3.683090440535278e-24, -2.486437093243772e-26,  2.915200583261960e-02, -3.701155867636659e-04,  3.483023760026318e-06,
 -2.867241604912046e-08,  2.165207778094447e-10, -1.526330078501519e-12,  1.007035825028420e-14, -6.181604729184603e-17,  3.450539282399612e-19, -1.665868672729060e-21,
  5.769760802970900e-24,  1.195781033932979e-27,  8.073536509181582e-02, -1.006884776972436e-03,  9.105811719492944e-06, -6.968196281970804e-08,  4.645662860488234e-10,
 -2.646328602341770e-12,  1.165205637945769e-14, -2.190221879297364e-17, -2.811241808045151e-19,  4.562343691305988e-21, -4.350481171078174e-23,  3.164957265870760e-25,
  1.575029169139492e-01, -1.910475254768754e-03,  1.620366479975692e-05, -1.091132085312469e-07,  5.596729907178157e-10, -1.527836320530393e-12, -8.849356160480928e-15,
  1.791206872997820e-16, -1.657228398645456e-18,  1.006569446074666e-20, -2.872228683843696e-23, -2.390843211068423e-25,  2.586528159146176e-01, -3.017363900644270e-03,
  2.326597048251753e-05, -1.256400171642332e-07,  3.049636000459235e-10,  2.734068544602127e-12, -4.472638915547435e-14,  3.330728997617617e-16, -1.063547652586727e-18,
 -8.564005940445879e-21,  1.659470224099539e-22, -1.374947735138564e-24,  3.829870937484475e-01, -4.240572829512606e-03,  2.846706165283049e-05, -9.978488758243005e-08,
 -3.591828732498720e-10,  8.388202602304006e-12, -5.916451442241098e-14,  5.939250843361143e-17,  3.279551486676739e-18, -3.770076256512718e-20,  1.585262097586551e-22,
  1.071474745947056e-24,  5.287864509968392e-01, -5.468868240749469e-03,  2.989606692097298e-05, -2.180113652767719e-08, -1.243359128832575e-09,  1.083443847683857e-11,
 -9.074448976666662e-15, -6.656594895042412e-16,  6.356058294607113e-18, -5.358474569518234e-21, -4.509042579895485e-22,  4.480275077698346e-24,  6.936360424512189e-01,
 -6.567749999048852e-03,  2.592668594253815e-05,  9.949912650230060e-08, -1.879170971945909e-09,  5.049597129120318e-12,  9.851309130782182e-14, -1.020324725040974e-15,
 -1.020896261023604e-18,  9.155898368731062e-20, -5.493152149740484e-22, -4.246404484002364e-24,  8.741937097452966e-01, -7.384489468733360e-03,  1.575903679141634e-05,
  2.300985578030893e-07, -1.670822318402182e-09, -9.183234814064034e-12,  1.629845747856280e-13,  6.795310824581145e-17, -1.444305252262919e-17,  5.758823400371873e-20,
  1.094846267336105e-21, -1.060298077423160e-23,  1.065898592270791e+00, -7.760838535553870e-03,  1.062967801099758e-07,  3.126920310210741e-07, -3.001584934017759e-10,
 -2.241341528374133e-11,  5.305310488094587e-14,  1.911259451005109e-15, -7.777077288377152e-18, -1.762796262798718e-19,  1.063435107543999e-21,  1.675736843594538e-23,
  1.262637612887084e+00, -7.558381996719376e-03, -1.816186816542299e-05,  2.862837904684728e-07,  1.732194885798991e-09, -1.891320143727884e-11, -1.882462503727587e-13,
  1.431245232599242e-15,  2.168388169196992e-17, -1.091991357228624e-19, -2.580689673650508e-21,  7.237520021561183e-24,  1.456431585260165e+00, -6.701266454338311e-03,
 -3.391057376149354e-05,  1.284543665761518e-07,  2.958930685160525e-09,  5.472067957769387e-12, -2.426353062549572e-13, -1.918048313944785e-15,  1.472827002221502e-17,
  2.982561480752430e-19,  5.357810413705288e-23, -3.506089947708778e-23,  1.637283803593620e+00, -5.235442978361173e-03, -4.099256575166243e-05, -9.706391227427103e-08,
  1.988751058297240e-09,  2.616294774522863e-11,  5.607084203314359e-14, -2.152962821595980e-15, -2.716175166288234e-17, -2.398775291466485e-20,  2.969750319972681e-21,
  3.306964989992302e-23,  1.793445863713454e+00, -3.387116680745436e-03, -3.550522657490193e-05, -2.451463822678887e-07, -5.049067624299505e-10,  1.406307670650925e-11,
  2.297653084180012e-13,  1.630706611664546e-15, -2.626668592552691e-18, -2.208347023843456e-19, -2.794953092085874e-21, -1.309588631648415e-23,  1.912430062630281e+00,
 -1.575892420638006e-03, -1.999691413230986e-05, -2.057606642527375e-07, -1.711690861032951e-09, -1.008436882584181e-11, -9.236639744723096e-15,  8.098976671582518e-16,
  1.438502156782479e-17,  1.574956439730828e-19,  1.123456596448655e-21,  1.714775805323087e-24,  1.982978854534957e+00, -3.231963429938440e-04, -4.551241160905834e-06,
 -5.611529604124824e-08, -6.361262791001843e-10, -6.752845272780407e-12, -6.749949276926567e-14, -6.334532624180530e-16, -5.512994686173893e-18, -4.320814422625408e-20,
 -2.825008416214533e-22, -1.124057717122790e-24,  3.083804030130837e-03, -3.851326619708736e-05,  3.602544993845392e-07, -2.991313670999353e-09,  2.323268385156168e-11,
 -1.728597970453646e-13,  1.246160883275302e-15, -8.777053772409092e-18,  6.054472940015552e-20, -4.114419331185398e-22,  2.744689835136793e-24, -1.816593305959628e-26,
  2.772517295133300e-02, -3.435710165408138e-04,  3.158774366009985e-06, -2.543973140454587e-08,  1.882770824405038e-10, -1.304217779929529e-12,  8.485394476113086e-15,
 -5.168943578241863e-17,  2.892168452982153e-19, -1.437512696175289e-21,  5.574844007598417e-24, -8.915718411245194e-27,  7.684839635548266e-02, -9.372605802083455e-04,
  8.312528560792409e-06, -6.265734550488792e-08,  4.143818820167369e-10, -2.374914538429342e-12,  1.093529805794758e-14, -2.858036575822826e-17, -1.450687486889487e-19,
  3.076543001369621e-21, -3.135508938672406e-23,  2.382605701779226e-25,  1.501121936958445e-01, -1.785933528566941e-03,  1.494699356178517e-05, -1.004128324286138e-07,
  5.273690847829990e-10, -1.685702398943931e-12, -4.523621730305546e-15,  1.316485346400767e-16, -1.317535105546842e-18,  8.764701179834455e-21, -3.505979848213977e-23,
 -6.449973805134136e-26,  2.469461893250787e-01, -2.837180115196602e-03,  2.178919083335756e-05, -1.203783733652405e-07,  3.496451200424751e-10,  1.768459991095341e-12,
 -3.591469582007339e-14,  2.952736914121237e-16, -1.266274823956474e-18, -3.061172765688610e-21,  1.111349408019561e-22, -1.109849186669954e-24,  3.664725700221071e-01,
 -4.017711456190047e-03,  2.724044977318652e-05, -1.042660885088514e-07, -2.054274701905937e-10,  6.998860611324661e-12, -5.622715369757258e-14,  1.439201043399370e-16,
  2.045052364982298e-18, -3.071551253729355e-20,  1.840758945245615e-22,  1.562340254232381e-25,  5.073872023472916e-01, -5.231067991944086e-03,  2.952218687816460e-05,
 -3.997913252229391e-08, -1.030240339894751e-09,  1.041568037475480e-11, -2.491701134195785e-14, -4.684531111391164e-16,  5.885097097471245e-18, -1.956220111379689e-20,
 -2.632052354781802e-22,  3.948864633660097e-24,  6.677867208738221e-01, -6.356063226313816e-03,  2.694399728209173e-05,  7.035904510809554e-08, -1.756856716098318e-09,
  7.070276826283016e-12,  6.995012778571951e-14, -1.004795905531382e-15,  1.844629073037081e-18,  6.693086109732418e-20, -6.566894019739835e-22, -7.683431452227260e-25,
  8.449247256893024e-01, -7.247839485520290e-03,  1.835444761923082e-05,  2.021083496453474e-07, -1.815477356477882e-09, -5.298804423489598e-12,  1.587832142642031e-13,
 -3.535540493060196e-16, -1.169982900823603e-17,  9.145966972350563e-20,  5.898814206919151e-22, -1.182624984356326e-23,  1.034880543967656e+00, -7.745094117832047e-03,
  3.815265519388654e-06,  3.043901472283654e-07, -7.315283612903738e-10, -2.053161641672044e-11,  1.021964614777619e-13,  1.570377061540099e-15, -1.319993543537707e-17,
 -1.212530340157403e-19,  1.626887205719513e-21,  8.428887006182609e-24,  1.232135877918535e+00, -7.689494432786699e-03, -1.457340932580145e-05,  3.107423060641792e-07,
  1.312385104985270e-09, -2.287612860430910e-11, -1.391851499235432e-13,  2.043189198249405e-15,  1.601050438215381e-17, -2.017929367778819e-19, -1.948374860336137e-21,
  2.097230168809450e-23,  1.429094857295102e+00, -6.965574230073979e-03, -3.208252465276947e-05,  1.763392169049057e-07,  3.006106584095312e-09, -9.325279418520513e-13,
 -2.881435482716633e-13, -1.277708959647413e-15,  2.510918368039943e-17,  2.671449341822550e-19, -1.650625849347171e-21, -4.067145096332652e-23,  1.615679590347537e+00,
 -5.567461498106743e-03, -4.194896847023948e-05, -6.100697218455130e-08,  2.520076320111894e-09,  2.668712673057212e-11, -1.633075717686608e-14, -3.010247727434840e-15,
 -2.554731549219244e-17,  1.225195475502913e-19,  4.296979141928299e-21,  2.494218815946922e-23,  1.779310519083226e+00, -3.683039455855694e-03, -3.848516026641767e-05,
 -2.506599326366927e-07, -1.648862620102815e-10,  2.010772123441687e-11,  2.728936181410125e-13,  1.396913577847033e-15, -1.270186970755868e-17, -3.411298520333783e-19,
 -3.123648235690582e-21,  1.835520152641776e-25,  1.905790226965668e+00, -1.746225189665790e-03, -2.263703565252412e-05, -2.347645454071674e-07, -1.913465988559599e-09,
 -9.976355454740703e-12,  2.079955378877679e-14,  1.369655215613160e-15,  2.086602928451056e-17,  2.021090348780534e-19,  1.050359535387702e-21, -6.154623079479845e-24,
  1.981608725978045e+00, -3.624837004820779e-04, -5.290452214447235e-06, -6.746819940783019e-08, -7.889291520621951e-10, -8.607125895513317e-12, -8.795592120466261e-14,
 -8.370269879924102e-16, -7.282580519784807e-18, -5.535109436476944e-20, -3.194865908235624e-22, -4.029067404815208e-25,  2.935296285244783e-03, -3.576874655705638e-05,
  3.264800301048169e-07, -2.645703089995639e-09,  2.005573618643983e-11, -1.456950617862824e-13,  1.025443167710936e-15, -7.056893946157593e-18,  4.753043902378858e-20,
 -3.161188371461009e-22,  2.056105080229289e-24, -1.340156138232416e-26,  2.639956562785225e-02, -3.194726302452058e-04,  2.870745947083026e-06, -2.262538184146530e-08,
  1.641171973832893e-10, -1.116936454585314e-12,  7.160181456831682e-15, -4.322034191870035e-17,  2.413696062500208e-19, -1.224077481986671e-21,  5.061660133380831e-24,
 -1.379821126913143e-26,  7.322774701169144e-02, -8.736587110454335e-04,  7.598899059055731e-06, -5.639324238325971e-08,  3.694409357927271e-10, -2.122500787238149e-12,
  1.008509432964133e-14, -3.167323196073217e-17, -5.454359770052072e-20,  2.012306754671541e-21, -2.231862779703065e-23,  1.748025804021982e-25,  1.432001791937929e-01,
 -1.671036546343147e-03,  1.379153855947984e-05, -9.224936704023663e-08,  4.928445259890759e-10, -1.754517845931645e-12, -1.382235463030388e-15,  9.426173676797659e-17,
 -1.027623699135014e-18,  7.338540187388268e-21, -3.555149167757598e-23,  3.156624688674122e-26,  2.359370846023022e-01, -2.668547249571161e-03,  2.037923924449562e-05,
 -1.145452030036144e-07,  3.770404817099989e-10,  1.001066974719252e-12, -2.822530291658087e-14,  2.537570046595114e-16, -1.307484376591327e-18,  4.891108710458439e-22,
  6.836726686968419e-23, -8.375809061239254e-25,  3.508295817213886e-01, -3.804838337314540e-03,  2.597392145482241e-05, -1.065049399650101e-07, -7.858429632663603e-11,
  5.704190188015136e-12, -5.143728770359098e-14,  1.930925982173854e-16,  1.071755699258944e-18, -2.340011479608442e-20,  1.777155494785018e-22, -3.915345734932373e-25,
  4.869318719251308e-01, -4.997074120531997e-03,  2.895029203160613e-05, -5.483304667806022e-08, -8.288622856751495e-10,  9.680837141506507e-12, -3.551563841496651e-14,
 -2.931051791548511e-16,  5.030878264725023e-18, -2.687694600773296e-20, -1.094641292431682e-22,  3.002363532054650e-24,  6.427982594376569e-01, -6.137600586390075e-03,
  2.762458364144212e-05,  4.346237798285568e-08, -1.600898768541822e-09,  8.420183081763718e-12,  4.296818628747671e-14, -9.123014542173533e-16,  3.780674565874953e-18,
  4.079446757553428e-20, -6.322276224498259e-22,  1.687665925630027e-24,  8.162416930522379e-01, -7.091803242257745e-03,  2.060262453707621e-05,  1.724158699286541e-07,
 -1.884352558056695e-09, -1.645927877521444e-12,  1.441637914132052e-13, -6.717181309186873e-16, -8.105694661168890e-18,  1.049323429548562e-19,  9.503076091809945e-23,
 -1.029695753778891e-23,  1.003984024520372e+00, -7.700190514003873e-03,  7.384640052297078e-06,  2.895479431381170e-07, -1.114334035419869e-09, -1.760255505523479e-11,
  1.396901531967197e-13,  1.091255651316154e-15, -1.632967901553192e-17, -5.154664882265332e-20,  1.789827948523001e-21, -9.443847008764726e-25,  1.201168798802583e+00,
 -7.790844958359826e-03, -1.073414338864331e-05,  3.279191916066677e-07,  8.263609658714956e-10, -2.547936863190864e-11, -7.599110273270217e-14,  2.426243113555225e-15,
  7.593398233756924e-18, -2.583090077442522e-19, -8.170003775158843e-22,  2.921987766497517e-23,  1.400733791096626e+00, -7.212956395863711e-03, -2.967972947004990e-05,
  2.239015569541446e-07,  2.915908742503159e-09, -8.178143836347973e-12, -3.113356395189885e-13, -3.365408282462167e-16,  3.311418899605928e-17,  1.663485023057245e-19,
 -3.339202685541294e-21, -3.379338063049992e-23,  1.592734945164475e+00, -5.905255842504343e-03, -4.242166245254161e-05, -1.646736143700438e-08,  3.042616571185292e-09,
  2.519667509187188e-11, -1.111524363220183e-13, -3.722194852151136e-15, -1.782889728992798e-17,  3.105584610833841e-19,  4.932226056844604e-21,  1.241356887951130e-24,
  1.763943528508418e+00, -4.002964325989200e-03, -4.149445072739333e-05, -2.497127056048823e-07,  3.056421879057252e-10,  2.706839908414298e-11,  3.043006463119101e-13,
  7.702594771909952e-16, -2.716820784409047e-17, -4.589503398908443e-19, -2.567081734878706e-21,  2.770153007694289e-23,  1.898424537075379e+00, -1.939125553104576e-03,
 -2.564436038093916e-05, -2.669346100874007e-07, -2.104475352020858e-09, -8.934514901563281e-12,  6.964530798549830e-14,  2.161128110803423e-15,  2.879650080156938e-17,
  2.345549342124430e-19,  4.496285327643200e-22, -2.302773572202714e-23,  1.980068695170766e+00, -4.082742500626154e-04, -6.181883001312194e-06, -8.159136722683941e-08,
 -9.842237008088553e-10, -1.102757264239309e-11, -1.149724886018271e-13, -1.104425834104586e-15, -9.505255020192420e-18, -6.799016670905683e-20, -2.967035423330999e-22,
  1.787774343126341e-24,  2.797251326044456e-03, -3.327865799466422e-05,  2.965649400265858e-07, -2.346849561810868e-09,  1.737278188067819e-11, -1.232936472556450e-13,
  8.475397543861656e-16, -5.703218360635028e-18,  3.749841775620236e-20, -2.445907728099190e-22,  1.544719525942017e-24, -1.004360463417526e-26,  2.516594836966451e-02,
 -2.975496801823589e-04,  2.614288594922767e-06, -2.016927590254092e-08,  1.434032310255237e-10, -9.587806930221425e-13,  6.051792223773212e-15, -3.616374508143771e-17,
  2.007933783604517e-19, -1.034554569487062e-21,  4.397542446757220e-24, -1.615771984609139e-26,  6.985054638365022e-02, -8.154770485417396e-04,  6.956287398539674e-06,
 -5.080894085148851e-08,  3.293387512486175e-10, -1.891236827038990e-12,  9.183552879769501e-15, -3.241775510677642e-17,  3.538386978417306e-21,  1.257595131762190e-21,
 -1.578793205722310e-23,  1.237985757030099e-25,  1.367298724000913e-01, -1.565000828157360e-03,  1.273069770678271e-05, -8.464554636561440e-08,  4.576180143623929e-10,
 -1.759501057605176e-12,  8.344979605545170e-16,  6.533404658739871e-17, -7.885489010486928e-19,  5.960043702499923e-21, -3.306421542874108e-23,  7.425238921311687e-26,
  2.255804044991779e-01, -2.510907656201952e-03,  1.904144057198772e-05, -1.083868592882961e-07,  3.908389673759878e-10,  4.042276317206279e-13, -2.169984549401774e-14,
  2.126593612790260e-16, -1.248865358120301e-18,  2.559442713837980e-21,  3.685910186864748e-23, -6.031638637225153e-25,  3.360176974572846e-01, -3.602172333754174e-03,
  2.469187074698882e-05, -1.069147940279127e-07,  2.360939391281514e-11,  4.537719583933847e-12, -4.566763406467846e-14,  2.152424612684368e-16,  3.522442900085143e-19,
 -1.673266034251045e-20,  1.536855669973731e-22, -6.639186861328194e-25,  4.674023135268611e-01, -4.768314819642046e-03,  2.821895716463102e-05, -6.659469646894933e-08,
 -6.443439258044792e-10,  8.747251947755346e-12, -4.161882623362534e-14, -1.482031669066898e-16,  4.013546136891633e-18, -2.891925293189333e-20, -1.918625333257944e-25,
  1.969942854831891e-24,  6.186925561072416e-01, -5.914940046940485e-03,  2.799816160973742e-05,  1.924283403736183e-08, -1.424176052570336e-09,  9.159743820401857e-12,
  1.930445668353823e-14, -7.725285764270818e-16,  4.816317109763948e-18,  1.745188341519329e-20, -5.255399516785396e-22,  2.975842818849087e-24,  7.882165002895327e-01,
 -6.919220142289202e-03,  2.249022112171036e-05,  1.421839928333577e-07, -1.884331902358998e-09,  1.562491282149566e-12,  1.222925637060372e-13, -8.707626614967970e-16,
 -4.361306485808744e-18,  1.005223207661908e-19, -2.925587399721335e-22, -7.163273708633398e-24,  9.733229607175367e-01, -7.627543716400322e-03,  1.074123745760995e-05,
  2.690936549890966e-07, -1.430695192631043e-09, -1.394360305327811e-11,  1.627479436141005e-13,  5.526010655082372e-16, -1.692933729196134e-17,  1.676493718324559e-20,
  1.569903298536185e-21, -8.585210313469870e-24,  1.169858860126221e+00, -7.860792470233628e-03, -6.736855749402905e-06,  3.369886557589425e-07,  3.041432738612824e-10,
 -2.646923431176759e-11, -6.082570995698509e-15,  2.516701490497681e-15, -1.977548762184880e-18, -2.646804053134640e-19,  4.971046894637894e-22,  2.904317589972925e-23,
  1.371425206348632e+00, -7.438868905066193e-03, -2.671969963677432e-05,  2.688406238330124e-07,  2.677500782896126e-09, -1.563899114007712e-11, -3.052226085647390e-13,
  7.905273375817996e-16,  3.638448365257948e-17,  8.085053863258000e-21, -4.427494499061646e-21, -1.377218984491639e-23,  1.568435141128906e+00, -6.244554806639524e-03,
 -4.231111859955274e-05,  3.606457938001393e-08,  3.511147135787523e-09,  2.122557330766917e-11, -2.214113380999359e-13, -4.076255478172127e-15, -3.176942500412700e-18,
  4.986060020567662e-19,  4.193583029942957e-21, -3.655906433387588e-23,  1.747248956721397e+00, -4.346779256472908e-03, -4.444249569375196e-05, -2.400893152078200e-07,
  9.212144152328384e-10,  3.451627769775851e-11,  3.110884938488607e-13, -3.802432584803569e-16, -4.514202462374431e-17, -5.257573724615884e-19, -4.651956981636014e-22,
  6.985459031655925e-23,  1.890236612920454e+00, -2.157678595057539e-03, -2.905514698911637e-05, -3.019223726010464e-07, -2.260977809384577e-09, -6.424891179757779e-12,
  1.443382247978282e-13,  3.218759251743958e-15,  3.725032663861362e-17,  2.244026803264078e-19, -1.180245812732498e-21, -5.370427221390388e-23,  1.978330085763689e+00,
 -4.619311993180901e-04, -7.263259006732780e-06, -9.926444442493599e-08, -1.235060902487133e-09, -1.419470890204919e-11, -1.505378289813271e-13, -1.449822544242188e-15,
 -1.213652665879223e-17, -7.701563660383850e-20, -1.156052672191297e-22,  7.190404524111074e-24,  2.668709805334959e-03, -3.101424234273263e-05,  2.699925958473114e-07,
 -2.087558798756606e-09,  1.509805130865138e-11, -1.047411105013573e-13,  7.034054473387808e-16, -4.633046776687636e-18,  2.970570645130057e-20, -1.909011852785765e-22,
  1.156251170599400e-24, -7.776696261891939e-27,  2.401609860949151e-02, -2.775658987210142e-04,  2.385415851599897e-06, -1.802066922507598e-08,  1.256016386257773e-10,
 -8.249958638299447e-13,  5.123797615373650e-15, -3.030173392627747e-17,  1.665394323029619e-19, -8.734108608058484e-22,  3.645622224705673e-24, -1.811058404455563e-26,
  6.669620008053892e-02, -7.621787967803927e-04,  6.376986361853320e-06, -4.583045126277045e-08,  2.936447725100695e-10, -1.681673404605862e-12,  8.283435894526156e-15,
 -3.169216851062158e-17,  3.863789902038046e-20,  7.220044654529904e-22, -1.130247044945594e-23,  8.103612347879867e-26,  1.306672994009569e-01, -1.467096425112334e-03,
  1.175772631533432e-05, -7.760351698873301e-08,  4.227625225226123e-10, -1.720182967065248e-12,  2.341055696946770e-15,  4.328487849751774e-17, -5.969669363126508e-19,
  4.706647855973760e-21, -2.957091569867840e-23,  7.913457322910164e-26,  2.158333501947382e-01, -2.363671952362632e-03,  1.777849927016141e-05, -1.020951115363463e-07,
  3.941749241062970e-10, -4.953692205429440e-14, -1.628927821524071e-14,  1.744060009837055e-16, -1.136063284209674e-18,  3.559159705209420e-21,  1.439772602902179e-23,
 -4.288027156573764e-25,  3.219959702145931e-01, -3.409756335456125e-03,  2.341396735462209e-05, -1.058684938860554e-07,  1.038960939292742e-10,  3.514775909118611e-12,
 -3.956548155077304e-14,  2.180030713210409e-16, -1.468878204484546e-19, -1.120815788317505e-20,  1.218177886027369e-22, -7.645068193401622e-25,  4.487752660159359e-01,
 -4.545922032061995e-03,  2.736355792515444e-05, -7.556007199746813e-08, -4.796525945068356e-10,  7.712158691452047e-12, -4.412607095032544e-14, -3.627639016298679e-17,
  2.990588400972139e-18, -2.747867144187692e-20,  6.542107823582783e-23,  1.037283181246936e-24,  5.954817005961820e-01, -5.690404422775720e-03,  2.809846236279449e-05,
 -2.060285860714288e-09, -1.238008237857175e-09,  9.381338986192688e-12, -1.015750267675174e-16, -6.121451563012662e-16,  5.099201719418241e-18, -8.048193993518446e-22,
 -3.853045587081357e-22,  3.253946493874325e-24,  7.609095500432861e-01, -6.732982711049614e-03,  2.401705773946599e-05,  1.124356190305290e-07, -1.825774405823494e-09,
  4.192414982296569e-12,  9.648200341569992e-14, -9.552364115038385e-16, -1.019633706241456e-18,  8.355586879778791e-20, -5.302260183626870e-22, -3.672373943819460e-24,
  9.430045212025145e-01, -7.529106264185979e-03,  1.382451099514979e-05,  2.441879493828997e-07, -1.669566943210372e-09, -9.912224072833005e-12,  1.708088103823455e-13,
  3.180342226079617e-17, -1.530083656501611e-17,  7.048494917819720e-20,  1.085174796580122e-21, -1.282839946462914e-23,  1.138333575516851e+00, -7.898469300509189e-03,
 -2.681224601138965e-06,  3.376356583967140e-07, -2.210669743194769e-10, -2.578536221511571e-11,  6.210801364309197e-14,  2.307196028109638e-15, -1.085679307874921e-17,
 -2.211711818153095e-19,  1.617486249427970e-21,  2.074036365293947e-23,  1.341263641040982e+00, -7.639020182164140e-03, -2.324815682580842e-05,  3.087902716150406e-07,
  2.293937024243160e-09, -2.256812416789000e-11, -2.669921140641951e-13,  1.924587953597564e-15,  3.341299139890541e-17, -1.732377984684757e-19, -4.435830227756728e-21,
  1.390471543984821e-23,  1.542784073131429e+00, -6.580327429258593e-03, -4.152830592900343e-05,  9.531151532665758e-08,  3.873289868146096e-09,  1.454824292902780e-11,
 -3.340623843835675e-13, -3.862238955193115e-15,  1.729112392997029e-17,  6.217443362326788e-19,  1.661393010134061e-21, -7.770038623229774e-23,  1.729132939176329e+00,
 -4.713537869226334e-03, -4.721105356071644e-05, -2.194284013619910e-07,  1.684421045391512e-09,  4.167395351155271e-11,  2.773860244977027e-13, -2.124358602684055e-15,
 -6.353492348149657e-17, -4.687846339615812e-19,  3.658662904752136e-21,  1.167918792009424e-22,  1.881117190735071e+00, -2.405235411527061e-03, -3.289881031318535e-05,
 -3.389046257477756e-07, -2.346808097261128e-09, -1.737562620906039e-12,  2.522707622108219e-13,  4.525552331095110e-15,  4.379559503628900e-17,  1.171761793155553e-19,
 -4.526802972612107e-21, -1.010968583372056e-22,  1.976358100320910e+00, -5.251608244296250e-04, -8.583042251566751e-06, -1.215074984640579e-07, -1.558610094100123e-09,
 -1.834121838147826e-11, -1.969888282687201e-13, -1.882663764871485e-15, -1.489072786353316e-17, -7.241184846771325e-20,  4.330410102157901e-22,  1.927026439624475e-23,
  2.548819658028166e-03, -2.895055118697626e-05,  2.463250292054802e-07, -1.861873567184338e-09,  1.316206795974985e-11, -8.931471468075645e-14,  5.860150434807312e-16,
 -3.784137502762244e-18,  2.358760872359866e-20, -1.510333243406266e-22,  8.470820411103747e-25, -6.407355330825781e-27,  2.294267872809528e-02, -2.593146123596532e-04,
  2.180701960938103e-06, -1.613663891380900e-08,  1.102657009838791e-10, -7.116319834186971e-13,  4.345423234913886e-15, -2.544901736022565e-17,  1.375222965534928e-19,
 -7.443301207965715e-22,  2.785694832059084e-24, -2.122358469813085e-26,  6.374614303701794e-02, -7.132853836210735e-04,  5.854135111933409e-06, -4.139069996452817e-08,
  2.619282643320752e-10, -1.493358740211034e-12,  7.416687300598715e-15, -3.012086276092104e-17,  5.724519319459569e-20,  3.295686211514298e-22, -8.603045192104835e-24,
  4.208532689632758e-26,  1.249812983751221e-01, -1.376647184948868e-03,  1.086594491814568e-05, -7.111111800450428e-08,  3.890083657113884e-10, -1.651463979644521e-12,
  3.309474035817322e-15,  2.667121156946900e-17, -4.480239276170631e-19,  3.588205021759310e-21, -2.652648574922740e-23,  5.527955359343612e-26,  2.066555102448930e-01,
 -2.226237513326295e-03,  1.659110158626651e-05, -9.581589189130969e-08,  3.896495950031253e-10, -3.858656932031813e-13, -1.189501443270985e-14,  1.401785571361118e-16,
 -1.001776233965128e-18,  3.793872733424391e-21, -1.889009638101533e-24, -3.224310670129003e-25,  3.087235688748741e-01, -3.227493007078240e-03,  2.215567771842605e-05,
 -1.036933242499328e-07,  1.651861175331529e-10,  2.637581390610254e-12, -3.358153926522571e-14,  2.077207742543954e-16, -4.708697346046046e-19, -7.017335916801705e-21,
  8.759121570175884e-23, -7.833770133465638e-25,  4.310234830454777e-01, -4.330759569941684e-03,  2.641569354789422e-05, -8.205827082389647e-08, -3.360298711265834e-10,
  6.650864036240467e-12, -4.394669455324587e-14,  4.417455551849587e-17,  2.057268957172204e-18, -2.418699696946479e-20,  9.359589719294429e-23,  2.732820671638454e-25,
  5.731690450914358e-01, -5.466038124650002e-03,  2.796106626901339e-05, -2.037303310316403e-08, -1.051699366256098e-09,  9.191532867574569e-12, -1.498115850703658e-14,
 -4.521332189176840e-16,  4.826586669826154e-18, -1.344198882983730e-20, -2.497970204998849e-22,  2.814163475618692e-24,  7.343697455086194e-01, -6.535938805491055e-03,
  2.519416042612901e-05,  8.401070138600170e-08, -1.720944717182267e-09,  6.185962910567874e-12,  6.970005557358357e-14, -9.440897613583054e-16,  1.576147012503184e-18,
  6.003392360780401e-20, -6.246998851696320e-22, -7.724493529852148e-25,  9.131271874480688e-01, -7.407256898778221e-03,  1.658866589180736e-05,  2.161109972323685e-07,
 -1.827020171731061e-09, -5.854838314326283e-12,  1.652791725120366e-13, -4.099811245648993e-16, -1.212244863299522e-17,  1.021723968381471e-19,  4.946267889358930e-22,
 -1.347117604831484e-23,  1.106722323259647e+00, -7.903811277638171e-03,  1.332482993636512e-06,  3.300750863980905e-07, -7.168679292563917e-10, -2.356568051520235e-11,
  1.207469950074691e-13,  1.846440836547134e-15, -1.746747494640440e-17, -1.418971309261220e-19,  2.249650781219294e-21,  7.558948596405223e-24,  1.310359890780785e+00,
 -7.809596018868759e-03, -1.933842323838272e-05,  3.415546166877186e-07,  1.783457030356039e-09, -2.821540021516912e-11, -1.993070123316106e-13,  2.861456818832562e-15,
  2.420352902202292e-17, -3.304575073972110e-19, -3.240359775831681e-21,  3.910744731602605e-23,  1.515807066911519e+00, -6.906906283003658e-03, -4.000463832904922e-05,
  1.591408790907997e-07,  4.075732199778832e-09,  5.316521611425344e-12, -4.310440115326268e-13, -2.945252116978740e-15,  3.995785799395627e-17,  6.104448548573710e-19,
 -2.415160348774472e-21, -1.032987850406283e-22,  1.709507467433332e+00, -5.101235121880469e-03, -4.965387908964402e-05, -1.854726656503400e-07,  2.578405720470497e-09,
  4.737336904540631e-11,  1.871662015408163e-13, -4.388531921739714e-15, -7.643942124814795e-17, -2.092361189813875e-19,  9.514634552536278e-21,  1.430484689887939e-22,
  1.870943209682964e+00, -2.685331926129821e-03, -3.719091594098597e-05, -3.763566360034638e-07, -2.309920719673497e-09,  5.998300642841541e-12,  3.989363636751545e-13,
  5.949857591200831e-15,  4.352997117260356e-17, -1.697086294451541e-19, -1.024214519946206e-20, -1.589795254535857e-22,  1.974110256299645e+00, -6.001111048746367e-04,
 -1.020374745523235e-05, -1.496556493407228e-07, -1.977269575611231e-09, -2.375761203881709e-11, -2.567312321920969e-13, -2.395527119196244e-15, -1.692723870565135e-17,
 -3.195370824866788e-20,  1.772958678728928e-21,  4.458937348193272e-23,  2.436822032646893e-03, -2.706587176855702e-05,  2.251895376642976e-07, -1.664841223185070e-09,
  1.150825514706700e-11, -7.644133456832921e-14,  4.898525590495286e-16, -3.110325101195446e-18,  1.869478045473166e-20, -1.225278585647384e-22,  5.841695727890559e-25,
 -5.567976177094499e-27,  2.193912608634267e-02, -2.426146091030984e-04,  1.997195838105324e-06, -1.448081602141296e-08,  9.702071212137634e-11, -6.154194519824476e-13,
  3.690574838106140e-15, -2.145742600747804e-17,  1.124969364821857e-19, -6.526747674758738e-22,  1.772911193350358e-24, -2.439646096617907e-26,  6.098361963632342e-02,
 -6.683700203152043e-04,  5.381636762775296e-06, -3.742939668216427e-08,  2.337738882882478e-10, -1.325263190285066e-12,  6.600276906430020e-15, -2.816262184756702e-17,
  6.326456134908394e-20,  1.193704298950798e-23, -7.520664740671254e-24,  9.229811976173135e-27,  1.196433064154481e-01, -1.293029630032527e-03,  1.004888094499162e-05,
 -6.514667661488341e-08,  3.568259577013513e-10, -1.564582987651475e-12,  3.873537003704330e-15,  1.420058411817891e-17, -3.374592853432023e-19,  2.565016736970558e-21,
 -2.489712228924010e-23,  1.991801100947191e-26,  1.980088845421802e-01, -2.098002559681228e-03,  1.547841582173786e-05, -8.965747704690813e-08,  3.793772129290556e-10,
 -6.277434541533341e-13, -8.398536983802762e-15,  1.102658330074480e-16, -8.697998227617661e-19,  3.453461140791165e-21, -1.471205723123051e-23, -2.632863213114287e-25,
  2.961602753680242e-01, -3.055176199966344e-03,  2.092881997342677e-05, -1.006701795704832e-07,  2.103395791596882e-10,  1.899505047532664e-12, -2.800985386569446e-14,
  1.892198908261341e-16, -6.687085135269983e-19, -4.199457749692451e-21,  5.348824991381683e-23, -7.563307390707869e-25,  4.141167432609080e-01, -4.123454479089663e-03,
  2.540294081909018e-05, -8.642737267317996e-08, -2.134244817527517e-10,  5.617646752310825e-12, -4.191381819183133e-14,  9.681034132032176e-17,  1.255140125689203e-18,
 -2.038438374041863e-20,  9.246388067826500e-23, -2.831030498620448e-25,  5.517503356854568e-01, -5.243599738221061e-03,  2.762161884511075e-05, -3.575310980219801e-08,
 -8.724015557184219e-10,  8.697010917949321e-12, -2.556373559687740e-14, -3.071243260591565e-16,  4.190655502929647e-18, -2.118098146047372e-20, -1.430273467994673e-22,
  2.015846944646002e-24,  7.086348339107031e-01, -6.330811156337408e-03,  2.604143104002298e-05,  5.754736752606632e-08, -1.582601343122598e-09,  7.549073069140782e-12,
  4.426198595848207e-14, -8.639234441123808e-16,  3.285274743500430e-18,  3.499742370818255e-20, -6.133407630517558e-22,  1.125227285963586e-24,  8.837792913707752e-01,
 -7.264678714798031e-03,  1.900342540241413e-05,  1.861527773779736e-07, -1.905591489975191e-09, -2.066219712486996e-12,  1.489424245664954e-13, -7.363648610546971e-16,
 -8.227078205244567e-18,  1.105627262796887e-19, -5.957610718944825e-23, -1.135432162344947e-23,  1.075153162469955e+00, -7.877537512020825e-03,  5.209566570012859e-06,
  3.150085322269696e-07, -1.155358694813143e-09, -2.011459850720098e-11,  1.639803364883901e-13,  1.223520006242769e-15, -2.091330243788581e-17, -4.935038402580027e-20,
  2.279535243806668e-21, -5.844236020167628e-24,  1.278838676433107e+00, -7.947468117675133e-03, -1.508794210112121e-05,  3.653442355937182e-07,  1.178207825511924e-09,
 -3.196159643904267e-11, -1.102887575064804e-13,  3.424291123062322e-15,  1.043532091062795e-17, -4.207526168480236e-19, -1.181044638370356e-21,  5.185408413304620e-23,
  1.487553033252281e+00, -7.218191726741070e-03, -3.770205911760587e-05,  2.246159687987455e-07,  4.072761995043988e-09, -5.854234545534353e-12, -4.924910972252332e-13,
 -1.342597119435353e-15,  5.909108436329098e-17,  4.225643792391986e-19, -6.915662986077168e-21, -9.449706618787322e-23,  1.688295055722057e+00, -5.506594150840557e-03,
 -5.160009337812853e-05, -1.364411829602456e-07,  3.559392306516627e-09,  5.011037545460480e-11,  2.950451728762481e-14, -6.869484085475210e-15, -7.563090874602820e-17,
  2.933123132165528e-19,  1.538233931702577e-20,  1.108824897075177e-22,  1.859577353843702e+00, -3.001539881044231e-03, -4.192314261073660e-05, -4.117760547180281e-07,
 -2.079937607457289e-09,  1.772050166879606e-11,  5.834677850556902e-13,  7.151391713876409e-15,  2.822276845580066e-17, -7.339239102731817e-19, -1.826258909893481e-20,
 -1.982584624206394e-22,  1.971534368326499e+00, -6.895007773317604e-04, -1.220626256508009e-05, -1.854518726121591e-07, -2.519789089464080e-09, -3.078573351264357e-11,
 -3.314391155346931e-13, -2.937376448243280e-15, -1.621888143047410e-17,  9.063084620019642e-20,  4.719146944807601e-21,  9.470063088343038e-23,  2.332039321278009e-03,
 -2.534124978359679e-05,  2.062677752476715e-07, -1.492329431419062e-09,  1.009027147496987e-11, -6.566626813179156e-14,  4.105050620283400e-16, -2.578619262761233e-18,
  1.464823630564055e-20, -1.037215756508437e-22,  3.675550406136783e-25, -3.948229009353030e-27,  2.099955830215872e-02, -2.273066370899957e-04,  1.832348905231308e-06,
 -1.302233645994080e-08,  8.555140742944115e-11, -5.336698351509306e-13,  3.136718741402204e-15, -1.822185998037924e-17,  9.002235710946206e-20, -6.025681776391127e-22,
  7.809646146563245e-25, -1.726596944002801e-26,  5.839348829129987e-02, -6.270519105530414e-04,  4.954078779040863e-06, -3.389271382651393e-08,  2.087899945719330e-10,
 -1.176092086046220e-12,  5.839719688835139e-15, -2.618885322875694e-17,  5.833437964849348e-20, -2.847676331103400e-22, -7.314306719380597e-24,  1.055844307731354e-26,
  1.146271527708134e-01, -1.215670911053546e-03,  9.300360173386674e-06, -5.968262921609907e-08,  3.264901844743003e-10, -1.467988468728315e-12,  4.132491556091524e-15,
  4.688567660264905e-18, -2.628688231406851e-19,  1.584013826413989e-21, -2.404220173961435e-23,  3.780973291115129e-26,  1.898578593276569e-01, -1.978376621739354e-03,
  1.443849925865550e-05, -8.369783771289376e-08,  3.650409940055169e-10, -7.952939412286272e-13, -5.683008704485194e-15,  8.428648294176047e-17, -7.586547787526653e-19,
  2.657525475194588e-21, -2.423475075945698e-23, -1.419796744756280e-25,  2.842668650428590e-01, -2.892517937723799e-03,  1.974211059151609e-05, -9.703559413251163e-08,
  2.420234249507854e-10,  1.288301878757319e-12, -2.303143056959922e-14,  1.657519263274277e-16, -7.891112271466918e-19, -2.690640289894793e-21,  2.329271688045920e-23,
 -5.657535894052014e-25,  3.980227327787297e-01, -3.924429329277241e-03,  2.434885689599165e-05, -8.899700166969129e-08, -1.108906278804034e-10,  4.648128712032868e-12,
 -3.874622843430197e-14,  1.259168715955397e-16,  5.840014708508970e-19, -1.702358911161441e-20,  7.436371250425453e-23, -4.402161926368238e-25,  5.312148475351263e-01,
 -5.024567240514322e-03,  2.711445567108152e-05, -4.835600863268429e-08, -7.052179974075538e-10,  7.994700899197401e-12, -3.240736961894634e-14, -1.861679110575803e-16,
  3.344495876855987e-18, -2.534590668230071e-20, -6.968802691377742e-23,  1.418890871103509e-24,  6.837320336150177e-01, -6.120136092280344e-03,  2.658521714359813e-05,
  3.348331780131405e-08, -1.422890655690468e-09,  8.333959712882142e-12,  2.170025758382408e-14, -7.432507968146548e-16,  4.119046348519510e-18,  1.183732703285758e-20,
 -5.356856182665876e-22,  2.380787152085864e-24,  8.550380445859478e-01, -7.104236214778239e-03,  2.105356703506862e-05,  1.555194406455217e-07, -1.912978053524504e-09,
  1.234868990112782e-12,  1.252281996205857e-13, -9.373235572516510e-16, -4.400723116456763e-18,  9.924385194536392e-20, -4.771189851606019e-22, -7.333643692867624e-24,
  1.043749823981915e+00, -7.821083960178932e-03,  8.866200057327180e-06,  2.935285601128168e-07, -1.515915994192373e-09, -1.584461875271676e-11,  1.887242362938965e-13,
  5.427684276648626e-16, -2.113983813139171e-17,  3.356123704394691e-20,  1.799511954530196e-21, -1.491557597538596e-23,  1.246835550454337e+00, -8.050364010667398e-03,
 -1.061217352515868e-05,  3.789709854034110e-07,  5.204076816711542e-10, -3.343444139735459e-11, -1.204969416957380e-14,  3.511238869630351e-15, -5.009708091714870e-18,
 -4.223132931106002e-19,  1.075438611628623e-21,  4.816146395355752e-23,  1.458095651107784e+00, -7.507931960017330e-03, -3.462165173503998e-05,  2.881924972584320e-07,
  3.835590805226797e-09, -1.789950250780919e-11, -5.017486891957330e-13,  7.308486252328848e-16,  6.842526542394747e-17,  7.469093259190545e-20, -1.011109289064074e-20,
 -4.430995311667269e-23,  1.665434175218459e+00, -5.924899846303207e-03, -5.286267861073545e-05, -7.150492150141490e-08,  4.551745065135427e-09,  4.825106651438459e-11,
 -1.942419403080628e-13, -8.994007290199554e-15, -5.306811945704270e-17,  9.776979567728285e-19,  1.796837249717661e-20, -8.117365655468977e-24,  1.846868372519746e+00,
 -3.357223793071508e-03, -4.704977952527382e-05, -4.413893823560637e-07, -1.568871837609928e-09,  3.419877401484633e-11,  7.912748875402585e-13,  7.473838670024578e-15,
 -1.342387004031832e-17, -1.634357646691687e-18, -2.642040869037022e-20, -1.499097085404518e-22,  1.968565937668907e+00, -7.967876955765546e-04, -1.469538220562101e-05,
 -2.311553778173390e-07, -3.221995958959987e-09, -3.978133504920592e-11, -4.201477893156931e-13, -3.358257857727297e-15, -8.346670525084229e-18,  3.862279488255429e-19,
  1.073424217064267e-20,  1.875389007977517e-22,  2.233864936816580e-03, -2.376009129356714e-05,  1.892868174931088e-07, -1.340880030868058e-09,  8.869878469723774e-12,
 -5.663095069760823e-14,  3.443233678452040e-16, -2.167055639374744e-18,  1.114752752600586e-20, -9.125945326948773e-23,  2.971491173493806e-25,  1.858614290842922e-27,
  2.011869145342983e-02, -2.132504334576081e-04,  1.683954369788817e-06, -1.173497870388237e-08,  7.559109401841328e-11, -4.642054660236682e-13,  2.663612286803241e-15,
 -1.568318771371836e-17,  6.878844856597156e-20, -5.770424580954346e-22,  8.334869822655730e-25,  3.001859845222333e-26,  5.596204794260097e-02, -5.889910791145875e-04,
  4.566657826407757e-06, -3.073287931637131e-08,  1.866113319868479e-10, -1.044538781125212e-12,  5.130632305007748e-15, -2.454062764965634e-17,  4.310969252832241e-20,
 -5.459230106244102e-22, -4.897611341323329e-24,  1.290882973106649e-25,  1.099088614842269e-01, -1.144046186716360e-03,  8.614560345892493e-06, -5.468824750601154e-08,
  2.981281340522639e-10, -1.368137670597146e-12,  4.153285565897441e-15, -2.990829339796741e-18, -2.223695699733265e-19,  7.021182881352142e-22, -1.831777710136030e-23,
  2.808578709913076e-25,  1.821691463191185e-01, -1.866788085936211e-03,  1.346862231847861e-05, -7.799108536584488e-08,  3.479485271504608e-10, -9.060276864403792e-13,
 -3.649861384068341e-15,  6.134626585432829e-17, -6.810906860838013e-19,  1.663320538222554e-21, -2.204665394710378e-23,  3.371662007664172e-25,  2.730053876385341e-01,
 -2.739171160420086e-03,  1.860167489076601e-05, -9.298559848790511e-08,  2.626227378141999e-10,  7.883026405113520e-13, -1.875741866525837e-14,  1.390904121658825e-16,
 -8.738121689561670e-19, -2.092859348191605e-21,  1.216654373291873e-23,  2.117175499947930e-25,  3.827077997265900e-01, -3.733933749461604e-03,  2.327315482793585e-05,
 -9.007684653958580e-08, -2.693298611812085e-11,  3.762092474276585e-12, -3.504715005775509e-14,  1.353423835013124e-16,  2.117219787418531e-20, -1.429225456507247e-20,
  6.822360246541160e-23,  4.045434052721838e-25,  5.115464796692468e-01, -4.810152633418587e-03,  2.647161791087750e-05, -5.840416935861307e-08, -5.534651130716755e-10,
  7.165605988726194e-12, -3.626203572727387e-14, -9.415821938500316e-17,  2.397196603420189e-18, -2.682901647849170e-20,  2.518633472066904e-25,  2.094827743157429e-24,
  6.596788679536537e-01, -5.906221364699562e-03,  2.685599284935926e-05,  1.207199385569685e-08, -1.252610965538184e-09,  8.620179546626837e-12,  2.770461311906641e-15,
 -6.085272656673073e-16,  4.188865611883878e-18, -7.020864891915619e-21, -3.924883982744079e-22,  4.446163794035212e-24,  8.269690454491924e-01, -6.928860182764870e-03,
  2.273747342571985e-05,  1.252634996585582e-07, -1.860420512475688e-09,  3.912647694177163e-12,  9.751926665229882e-14, -1.025202371354462e-15, -1.234656942152329e-18,
  7.534536299318315e-20, -6.720496116804456e-22, -1.013579570164515e-24,  1.012629043687100e+00, -7.736499782802407e-03,  1.223336541440907e-05,  2.669886724034232e-07,
 -1.786672175368063e-09, -1.120772866777019e-11,  1.947239881596900e-13, -1.018363076583272e-16, -1.880395772644039e-17,  9.147689646657471e-20,  1.091032790708153e-21,
 -1.557103363593023e-23,  1.214493234335544e+00, -8.116979999098462e-03, -6.036590027572794e-06,  3.819652097638364e-07, -1.433614164219476e-10, -3.257562524811018e-11,
  8.181721465029660e-14,  3.119902302253314e-15, -1.896219550534435e-17, -3.407721671587993e-19,  2.895215978703572e-21,  3.379516713375081e-23,  1.427533311175008e+00,
 -7.770060058741680e-03, -3.080902836897016e-05,  3.460551624297053e-07,  3.360117509339205e-09, -2.944885721168348e-11, -4.507984707617160e-13,  2.882901942094547e-15,
  6.356318847378113e-17, -3.465682145500221e-19, -1.036355415427113e-20,  3.607176932396794e-23,  1.640885180560603e+00, -6.349924178278985e-03, -5.325298617325137e-05,
  8.701268029898492e-09,  5.448914036832575e-09,  4.041278783341773e-11, -4.635873039748917e-13, -9.994063369948444e-15, -5.487790185274419e-18,  1.637216419391912e-18,
  1.364346963401939e-20, -1.937960399243120e-22,  1.832652610237438e+00, -3.755176419898417e-03, -5.247095963493281e-05, -4.599181978540199e-07, -6.785487238838219e-10,
  5.559011432592172e-11,  9.841682771757286e-13,  5.888922653368941e-15, -9.241143486456218e-17, -2.768977692673707e-18, -2.852374301558847e-20,  9.726635126664634e-23,
  1.965124771315163e+00, -9.263867816384190e-04, -1.780667697476633e-05, -2.896525160341913e-07, -4.126163921622413e-09, -5.100718579997159e-11, -5.151323459356626e-13,
 -3.301527674837885e-15,  1.563782062171994e-17,  1.021492721037370e-18,  2.216824033784197e-20,  3.441157495922515e-22,  2.141754549937848e-03, -2.230782964970844e-05,
  1.740117887434545e-07, -1.207593872964836e-09,  7.815177946947019e-12, -4.905795715503583e-14,  2.881642681591436e-16, -1.860242446218158e-18,  8.127818792627820e-21,
 -7.405808522106103e-23,  6.759158224933419e-25,  1.744765042100662e-26,  1.929176925538979e-02, -2.003222004496161e-04,  1.550095848149870e-06, -1.059646579542482e-08,
  6.691188737713372e-11, -4.053184524190070e-13,  2.252246657526662e-15, -1.380354328969585e-17,  4.921190634305203e-20, -4.851510259535902e-22,  4.757520343166861e-24,
  1.674994777262478e-25,  5.367688407138532e-02, -5.538837818097805e-04,  4.215109606548650e-06, -2.790776493037141e-08,  1.668969747543779e-10, -9.295125236865008e-13,
  4.459671036875787e-15, -2.349749344740014e-17,  2.205088257323215e-20, -5.412673358301554e-22,  7.854807210483120e-24,  5.050346627280597e-25,  1.054664651796236e-01,
 -1.077675693558881e-03,  7.986036137246239e-06, -5.013172618794890e-08,  2.717513134454416e-10, -1.270248756076518e-12,  3.972898464857747e-15, -9.809886607196179e-18,
 -2.057944683730042e-19,  3.910719190002925e-22,  8.223566771619218e-24,  1.034093650519494e-24,  1.749116963709090e-01, -1.762689442848457e-03,  1.256552044792236e-05,
 -7.257309241657541e-08,  3.290786276211687e-10, -9.754245698035263e-13, -2.229255233556359e-15,  4.038548054840320e-17, -6.308043718155573e-19,  1.389874075341497e-21,
  1.799823412825732e-23,  1.665199499280351e-24,  2.623393651240689e-01, -2.594748590989421e-03,  1.751150401945471e-05, -8.868069949215953e-08,  2.741858570716580e-10,
  3.816339480447437e-13, -1.526477405147375e-14,  1.100625859152658e-16, -9.338343402209234e-19, -9.230747916238498e-22,  6.159643548992945e-23,  2.319107236377733e-24,
  3.681375861963792e-01, -3.552074097401284e-03,  2.219198555561249e-05, -8.995025706099221e-08,  4.020295532312168e-11,  2.966057393752473e-12, -3.132129598369457e-14,
  1.283856017598305e-16, -4.341766968336964e-19, -1.053958353573685e-20,  1.404911129440382e-22,  3.313825637391619e-24,  4.927247777428390e-01, -4.601323052118907e-03,
  2.572220925814341e-05, -6.616115172669161e-08, -4.190284042202415e-10,  6.271461066686526e-12, -3.796846068747218e-14, -3.267689263625020e-17,  1.460473723111397e-18,
 -2.418659780979451e-20,  1.579330136088922e-22,  5.696004859557564e-24,  6.364841321200067e-01, -5.691121577906046e-03,  2.688629196234660e-05, -6.592464824028218e-09,
 -1.080845673725413e-09,  8.497021221631871e-12, -1.244874249962019e-14, -4.811060657793155e-16,  3.711492810573952e-18, -1.755899225045102e-20, -9.559460490621059e-23,
  9.813082825529832e-24,  7.996262187397685e-01, -6.741447057022595e-03,  2.406500252673850e-05,  9.624015024290789e-08, -1.761101205654143e-09,  5.906499061940946e-12,
  6.863151288049434e-14, -1.026430357794100e-15,  1.007566969868244e-18,  5.033005341982985e-20, -5.003262118296143e-22,  9.789766618854588e-24,  9.818983630657023e-01,
 -7.626318773727245e-03,  1.525912886434332e-05,  2.368604499758673e-07, -1.964661456187440e-09, -6.633252059635580e-12,  1.839963532380566e-13, -6.436639256472467e-16,
 -1.487012857375608e-17,  1.238286200549114e-19,  6.108080416659277e-22, -3.966606613742971e-24,  1.181957638968741e+00, -8.147026063380757e-03, -1.487846637824332e-06,
  3.745943477900920e-07, -7.685611905742846e-10, -2.964276128303550e-11,  1.590101046846920e-13,  2.341835507824817e-15, -2.882458513764566e-17, -1.992088588703476e-19,
  4.103355899847286e-21,  2.312669950468447e-23,  1.395987653322598e+00, -7.999056114906625e-03, -2.635505099025199e-05,  3.945487896920302e-07,  2.670616016593105e-09,
 -3.908380393207685e-11, -3.440212867935539e-13,  4.641960851149868e-15,  4.424512759400222e-17, -7.032854001600500e-19, -6.831838626909038e-21,  1.236499381913514e-22,
  1.614636265213184e+00, -6.773991273537661e-03, -5.260102019735785e-05,  1.016506510785679e-07,  6.123383058499896e-09,  2.596659581576634e-11, -7.363807288809776e-13,
 -9.141232077740759e-15,  6.073262269502827e-17,  1.959965487168366e-18,  1.355200863069437e-21, -3.476088742442738e-22,  1.816757277068837e+00, -4.197111651293733e-03,
 -5.801413609969014e-05, -4.605484074042487e-07,  6.806645830238618e-10,  8.075503836820267e-11,  1.091188278640020e-12,  1.132775867316452e-15, -2.103897810089194e-16,
 -3.686877826912556e-18, -1.340033897098350e-20,  6.417404881684945e-22,  1.961110611419609e+00, -1.083947880114037e-03, -2.171454191294118e-05, -3.645339328222477e-07,
 -5.276965998309021e-09, -6.438223214874771e-11, -5.936317196773001e-13, -2.008363630340555e-15,  7.257764535761002e-17,  2.272983397026740e-18,  4.204460164923969e-20,
  5.680281339393277e-22,  2.055218548511271e-03, -2.097164632990676e-05,  1.602397111246798e-07, -1.090041742868294e-09,  6.899101459275923e-12, -4.273989784591951e-14,
  2.393659529507430e-16, -1.635654955043930e-18,  6.200701455866694e-21, -2.409125794248001e-23,  2.032527019171786e-24,  4.614705397411192e-26,  1.851450156092304e-02,
 -1.884124616323224e-04,  1.429103451334628e-06, -9.587918018830204e-09,  5.931560841637782e-11, -3.557389705839507e-13,  1.885532981621173e-15, -1.245317520507448e-17,
  3.755006691339200e-20, -7.964138931023640e-23,  1.740286206695956e-23,  4.249564694035301e-25,  5.152673197965708e-02, -5.214584578790872e-04,  3.895643288140166e-06,
 -2.538054238813902e-08,  1.493241006258452e-10, -8.303104059633933e-13,  3.809427162279249e-15, -2.298873476861840e-17,  1.524744203480978e-20,  4.057217372145082e-22,
  4.474437083601378e-23,  1.222050548684355e-24,  1.012798308210891e-01, -1.016121708597717e-03,  7.409721679468093e-06, -4.598187088357291e-08,  2.472738109436346e-10,
 -1.178921595135126e-12,  3.609215155697626e-15, -1.599596713445846e-17, -1.714852999513115e-19,  2.006918180087615e-21,  8.307447641025041e-23,  2.469040660964067e-24,
  1.680565957614416e-01, -1.665560778101555e-03,  1.172558264375481e-05, -6.746646514903904e-08,  3.091151484390950e-10, -1.017582736809062e-12, -1.371537732729427e-15,
  2.131999069424579e-17, -5.443613698662780e-19,  4.227474982194835e-21,  1.420176085940609e-22,  4.142651548568474e-24,  2.522339209865672e-01, -2.458838198141320e-03,
  1.647384758409522e-05, -8.425158274853884e-08,  2.783871113387442e-10,  4.887595970963190e-14, -1.260154233981503e-14,  8.038230133348634e-17, -8.889969632709571e-19,
  4.609376861783339e-21,  2.435722897209668e-22,  6.219054934377268e-24,  3.542775464110256e-01, -3.378840641099204e-03,  2.111827051398153e-05, -8.887209362082926e-08,
  9.228873747718380e-11,  2.255610645605975e-12, -2.796825598005883e-14,  1.098754316286739e-16, -6.642226332558277e-19, -5.280221208680271e-22,  4.013391924801378e-22,
  8.949198898723488e-24,  4.747258638893999e-01, -4.398825879303313e-03,  2.489202685345771e-05, -7.191190913387034e-08, -3.027616417214076e-10,  5.353772843495823e-12,
 -3.834794683217208e-14,  1.947780216734809e-18,  7.811747309204049e-19, -1.089956745188265e-20,  5.618014246436203e-22,  1.326077665277932e-23,  6.141489272763032e-01,
 -5.476628882320188e-03,  2.670896470051631e-05, -2.254705159833541e-08, -9.149172348469828e-10,  8.049433766741984e-12, -2.435161020856962e-14, -3.721905752427831e-16,
  3.138641793789474e-18, -1.003295869921087e-20,  5.481504346978459e-22,  2.023353106799047e-23,  7.730521210509695e-01, -6.544777017976297e-03,  2.505498030551419e-05,
  6.908738050841892e-08, -1.628802093269691e-09,  7.213979917092340e-12,  4.059387743773954e-14, -9.679518354807284e-16,  2.604070408898712e-18,  4.353028004290798e-20,
  2.852095593304039e-22,  2.686645652644133e-23,  9.516544696258458e-01, -7.493419387018595e-03,  1.790922706514521e-05,  2.045974369035392e-07, -2.054887010014972e-09,
 -2.483095156958962e-12,  1.600155542726223e-13, -1.043436012128169e-15, -9.956758411821503e-18,  1.513075221478572e-19,  9.478977440892070e-22,  2.127592455570412e-23,
  1.149373845630400e+00, -8.141200963488190e-03,  2.914667337233319e-06,  3.577822218189848e-07, -1.318505218726645e-09, -2.514933652796864e-11,  2.108273319344442e-13,
  1.338378521478401e-15, -3.279377723418782e-17, -1.412252336602334e-20,  5.204943530455692e-21,  3.052719683018515e-23,  1.363600677556498e+00, -8.190293865300836e-03,
 -2.139120784397654e-05,  4.306233875997470e-07,  1.817624434671657e-09, -4.564561551835000e-11, -1.983381596977898e-13,  5.612024007583595e-15,  1.553207485138231e-17,
 -8.446683435301057e-19,  2.921305370318493e-22,  1.960200157889816e-22,  1.586708804298538e+00, -7.188221826172340e-03, -5.077956658205107e-05,  2.027369539744121e-07,
  6.446661833606420e-09,  5.506423294760658e-12, -9.546233519734180e-13, -6.089235606207539e-15,  1.284576333859114e-16,  1.697925857304031e-18, -1.429458818354820e-20,
 -3.238651149940772e-22,  1.799006037453240e+00, -4.683013938261426e-03, -6.341747264457679e-05, -4.353185560384509e-07,  2.555759105023141e-09,  1.064386649350656e-10,
  1.008343399223645e-12, -7.758660113598259e-15, -3.439845803691640e-16, -3.439047089880425e-18,  3.143036375031620e-20,  1.408459729832642e-21,  1.956397520848917e+00,
 -1.276700141188940e-03, -2.664057612933688e-05, -4.600539473733972e-07, -6.709913654399989e-09, -7.895326069577648e-11, -6.024316033329910e-13,  2.001054061285984e-15,
  1.913384769399317e-16,  4.523758612780414e-18,  7.205371538544544e-20,  7.773127898605362e-22,  1.973815521463570e-03, -1.974023710139209e-05,  1.477942851143046e-07,
 -9.861975419178048e-10,  6.098156535615262e-12, -3.752240436648710e-14,  1.963529384669992e-16, -1.430853782591607e-18,  7.375956723320764e-21,  1.075930499267817e-22,
  4.778069284348549e-24,  7.655529245592772e-26,  1.778301077155502e-02, -1.774242455686767e-04,  1.319515592271910e-06, -8.693443874760208e-09,  5.262582431158019e-11,
 -3.145315063141302e-13,  1.554431447447685e-15, -1.112118721218057e-17,  5.252771055509396e-20,  1.078454448052631e-21,  4.254138048290557e-23,  6.988636540140285e-25,
  4.950135523537746e-02, -4.914721923330525e-04,  3.604879384364146e-06, -2.311945649431806e-08,  1.335804129616532e-10, -7.465245079280671e-13,  3.177914590028376e-15,
 -2.180159628087522e-17,  7.728930927155664e-20,  3.517136187590033e-21,  1.165348608480265e-22,  1.988616804272895e-24,  9.733049753951334e-02, -9.589855686689179e-04,
  6.880914231250461e-06, -4.220957325945245e-08,  2.245224924665403e-10, -1.098199664866368e-12,  3.101314462240945e-15, -1.944379115414612e-17, -8.711455427994180e-21,
  7.995917991146019e-21,  2.278177776243354e-22,  4.005625903910951e-24,  1.615769511673946e-01, -1.574911985432237e-03,  1.094498319240983e-05, -6.268505468273563e-08,
  2.884732760677306e-10, -1.045114934828509e-12, -9.854377767793319e-16,  7.839814584609059e-18, -2.381935080586080e-19,  1.440295639608801e-20,  3.864735836138910e-22,
  6.791269559542896e-24,  2.426558535035366e-01, -2.331015801041551e-03,  1.548953474053433e-05, -7.980529108124378e-08,  2.765068964005158e-10, -2.295319101704684e-13,
 -1.070725765600675e-14,  5.708598722101058e-17, -4.694675736600453e-19,  2.116210426238348e-20,  6.151649547171907e-22,  1.039837318015079e-23,  3.410933615625055e-01,
 -3.214132038342781e-03,  2.006203843051557e-05, -8.707004289296413e-08,  1.309257501551427e-10,  1.619003287796816e-12, -2.516503999197045e-14,  9.230307841545172e-17,
 -2.814215146732142e-19,  2.535745234395139e-20,  9.386011352225798e-22,  1.508584647176684e-23,  4.575232615563339e-01, -4.203215974142038e-03,  2.400339050099795e-05,
 -7.594943098313693e-08, -2.048715499684991e-10,  4.436725058692109e-12, -3.796410119802616e-14,  2.630783926299051e-17,  9.585175912092038e-19,  2.592715135889960e-20,
  1.342430433051292e-21,  2.170789200475927e-23,  5.926677061288030e-01, -5.264276268619363e-03,  2.635576859635652e-05, -3.593291393947393e-08, -7.605591336103938e-10,
  7.351153190260460e-12, -3.337978675505676e-14, -2.713383513176331e-16,  3.420290210273339e-18,  3.336456232678936e-20,  1.707499409059083e-21,  3.175241613038333e-23,
  7.472785326800180e-01, -6.341452751269375e-03,  2.573257183836481e-05,  4.422469254072427e-08, -1.476919979978974e-09,  7.874007808368423e-12,  1.492421888751822e-14,
 -8.546902100049116e-16,  4.713524228680612e-18,  8.426067556748601e-20,  1.883816747325622e-21,  4.470835590675686e-23,  9.219820967079805e-01, -7.340886293160349e-03,
  2.016613566341298e-05,  1.715200959949995e-07, -2.068675278714250e-09,  9.760301411749691e-13,  1.272230551761509e-13, -1.265204311251872e-15, -3.518588414276666e-18,
  2.170349607727773e-19,  2.556454328548935e-21,  5.068926158965011e-23,  1.116882313514222e+00, -8.101105097808739e-03,  7.065799165126986e-06,  3.329477798938008e-07,
 -1.768467330246699e-09, -1.975732926169146e-11,  2.338373376242819e-13,  3.240135127977517e-16, -2.917515002973830e-17,  2.271864296454562e-19,  7.026265514338022e-21,
  5.262246311611020e-23,  1.330530574851400e+00, -8.340330005146179e-03, -1.608005149848025e-05,  4.521975284227005e-07,  8.700117594064005e-10, -4.849150893286614e-11,
 -3.869618761975014e-14,  5.642542570797506e-15, -1.245469369851743e-17, -6.466339825637263e-19,  9.860232206734154e-21,  2.296816537402146e-22,  1.557161327994568e+00,
 -7.582973462303991e-03, -4.772837847296489e-05,  3.054708091105860e-07,  6.316494179457540e-09, -1.893411248548363e-11, -1.059315450371651e-12, -1.135357915570298e-15,
  1.764030151522098e-16,  9.045979747566448e-19, -2.337906614350385e-20, -5.271329390142964e-23,  1.779227422842427e+00, -5.210383976530193e-03, -6.832169234813082e-05,
 -3.761789393939846e-07,  4.902066300148705e-09,  1.266856619893458e-10,  6.208773319664793e-13, -2.037082328886487e-14, -4.283814265333091e-16, -7.470732638352959e-19,
  1.069801113937296e-19,  1.916048523990793e-21,  1.950826765891780e+00, -1.513857396500349e-03, -3.285994239028325e-05, -5.807970249446457e-07, -8.424731936206751e-09,
 -9.187533969034690e-11, -4.318409795027342e-13,  1.135368037910735e-14,  4.144188087895670e-16,  8.093743096231007e-18,  1.054796910388633e-19,  6.305892003225003e-22,
  1.897146599119432e-03, -1.860361703994082e-05,  1.365213663110708e-07, -8.943876595857039e-10,  5.391746348518281e-12, -3.325896387449265e-14,  1.604780214620995e-16,
 -1.089167521723989e-18,  1.552780222544446e-20,  3.681047404197704e-22,  8.175200178423498e-24,  6.529774240423778e-26,  1.709378493098440e-02, -1.672715573407923e-04,
  1.220045040233060e-06, -7.899830617849013e-09,  4.668421643098441e-11, -2.807227852935966e-13,  1.275107119916843e-15, -8.428690497832464e-18,  1.296298126539259e-19,
  3.413109958515568e-21,  7.352966002399731e-23,  5.959615450324732e-25,  4.759143728903489e-02, -4.637076660952379e-04,  3.339789792385872e-06, -2.109767048217018e-08,
  1.193652482665337e-10, -6.771469072973229e-13,  2.628563685220683e-15, -1.622649963929146e-17,  3.095592441514578e-19,  9.978431085656124e-21,  2.046511713189234e-22,
  1.696717896166517e-24,  9.360152601280514e-02, -9.059048881139395e-04,  6.395241301261819e-06, -3.878906279107666e-08,  2.032599391837912e-10, -1.029995114124602e-12,
  2.610851887523538e-15, -1.300298476045936e-17,  4.869809048008216e-19,  2.073490681820383e-20,  4.054104053966078e-22,  3.426674219926539e-24,  1.554477675618053e-01,
 -1.490284134377500e-03,  1.021976221472584e-05, -5.823791922654146e-08,  2.673502710182569e-10, -1.066391932960629e-12, -7.699287137798725e-16,  1.210015308056172e-17,
  6.329541403875597e-19,  3.602098965149432e-20,  6.883521851553678e-22,  5.841171706151009e-24,  2.335736632606803e-01, -2.210855404202731e-03,  1.455822062587448e-05,
 -7.543134432936225e-08,  2.694708928203251e-10, -4.681262702075183e-13, -9.165439125895824e-15,  5.992629850870714e-17,  8.494360415512733e-19,  5.522652623567530e-20,
  1.079229393082851e-21,  9.006355610782593e-24,  3.285512619574565e-01, -3.057777229132369e-03,  1.903073141897327e-05, -8.474813155219619e-08,  1.574749198022166e-10,
  1.046174202036843e-12, -2.250997398064077e-14,  1.064928151239776e-16,  1.473084975836745e-18,  7.664818094070696e-20,  1.613620584212728e-21,  1.313026952593009e-23,
  4.410886095682722e-01, -4.014883724145343e-03,  2.307509840516669e-05, -7.856667709463583e-08, -1.251656919092986e-10,  3.539172607082430e-12, -3.657270761887332e-14,
  8.420803473898583e-17,  3.096676171853449e-18,  9.936654280626913e-20,  2.311745092712381e-21,  1.888907311649379e-23,  5.720292847566968e-01, -5.055350892698346e-03,
  2.585626423612938e-05, -4.697154405031643e-08, -6.220920462477682e-10,  6.472886960143969e-12, -3.915414567192278e-14, -1.266734697585491e-16,  6.198270828403092e-18,
  1.304514943644657e-19,  3.121388834608536e-21,  2.773658754613767e-23,  7.223272526548918e-01, -6.133859057633286e-03,  2.612672231191021e-05,  2.186548705972817e-08,
 -1.317694258929487e-09,  7.965478297898750e-12, -6.312704218878163e-15, -6.367903126468375e-16,  9.596353897251833e-18,  2.005749164640026e-19,  3.907287923956121e-21,
  4.061618005562011e-23,  8.929534541020162e-01, -7.171884421904786e-03,  2.202693231459470e-05,  1.387311818534992e-07, -2.021522809997708e-09,  3.599590674601061e-12,
  9.156312114766777e-14, -1.228389254139011e-15,  6.714824802964877e-18,  3.678726093455988e-19,  4.995393693347671e-21,  5.104635222411725e-23,  1.084615533761233e+00,
 -8.029106276234446e-03,  1.087935166231164e-05,  3.017973571496379e-07, -2.107263809801493e-09, -1.413224858577470e-11,  2.314829615739893e-13, -4.197279445715070e-16,
 -1.534809310879234e-17,  5.572782479128699e-19,  9.444527833158201e-21,  4.651780162113365e-23,  1.296946577833807e+00, -8.447102064965259e-03, -1.060218359372901e-05,
  4.583612771787581e-07, -9.662076892193643e-11, -4.758766176744400e-11,  1.108717720940528e-13,  4.967146542330070e-15, -2.624929934819215e-17, -5.728823169924980e-20,
  1.921251979788681e-20,  1.738607324816463e-22,  1.526091372147433e+00, -7.948457565112185e-03, -4.347331757900138e-05,  4.021249000305452e-07,  5.684402032102379e-09,
 -4.407764259282878e-11, -1.008461717300974e-12,  4.852199817175655e-15,  1.925865959675224e-16,  3.378799743450339e-20, -1.749208893963032e-20,  3.068600841934302e-22,
  1.757266291848104e+00, -5.773483996215844e-03, -7.227960315556990e-05, -2.768883437987987e-07,  7.530598643760606e-09,  1.332018236631066e-10, -1.386304200027379e-13,
 -3.352113333751359e-14, -3.584510417788768e-16,  5.139304883664603e-18,  1.824757878209781e-19,  1.233373186198225e-21,  1.944198013629383e+00, -1.807049369973543e-03,
 -4.070037442378858e-05, -7.307171206061995e-07, -1.033113362266601e-08, -9.662670699173274e-11,  1.215774085545976e-13,  3.013130051418012e-14,  7.861033895069003e-16,
  1.258811184020548e-17,  1.089703175874455e-19, -8.095817313425311e-22,  1.824850504793605e-03, -1.755295940292079e-05,  1.262850234776037e-07, -8.132410676750926e-10,
  4.762962304531558e-12, -2.970268725537548e-14,  1.394058124775235e-16, -3.129290241584397e-19,  3.513091420002988e-20,  7.254508762955480e-22,  8.734736211708806e-24,
 -6.758382094583674e-26,  1.644363641247824e-02, -1.578781070360744e-04,  1.129548671256219e-06, -7.196206206968596e-09,  4.135965184015308e-11, -2.523486353786342e-13,
  1.119933356930315e-15, -1.708448767698465e-18,  3.097022351296862e-19,  6.632796585839720e-21,  7.877579564079184e-23, -6.086550086681231e-25,  4.578848434486193e-02,
 -4.379705762544649e-04,  3.097640633366649e-06, -1.929287187557981e-08,  1.064237728508670e-10, -6.180027151317768e-13,  2.378846856242303e-15,  1.116829514900257e-18,
  8.283180029544406e-19,  1.896464067119345e-20,  2.202102303281723e-22, -1.696808864439307e-24,  9.007735836741051e-02, -8.565510899394838e-04,  5.948616493014791e-06,
 -3.569838055737523e-08,  1.832696056360318e-10, -9.691350676339979e-13,  2.600834354068790e-15,  1.787628145137439e-17,  1.550063970856187e-18,  3.858139453742628e-20,
  4.380107631605871e-22, -3.361238120232380e-24,  1.496458216560730e-01, -1.411250364148984e-03,  9.545866190461250e-06, -5.413176792026151e-08,  2.458827318673451e-10,
 -1.077117273435881e-12,  8.760643512768417e-17,  5.879743792846288e-17,  2.467601408377476e-18,  6.634723014579368e-20,  7.449561091798176e-22, -5.680533627135338e-24,
  2.249575428364252e-01, -2.097937833694317e-03,  1.367856777080826e-05, -7.120600963849271e-08,  2.580693821187012e-10, -6.627391284620430e-13, -6.745067025751326e-15,
  1.278374508858381e-16,  3.679851074634951e-18,  1.027018208291343e-19,  1.166305778068329e-21, -8.794429079446751e-24,  3.166182662190571e-01, -2.909555049886670e-03,
  1.802946990672968e-05, -8.208935110823586e-08,  1.732775828694770e-10,  5.500613528255871e-13, -1.835934597642983e-14,  2.110944091214579e-16,  5.489364580510946e-18,
  1.474754644225667e-19,  1.740614248142919e-21, -1.284921368473157e-23,  4.253922638233076e-01, -3.834083107809018e-03,  2.212246652534679e-05, -8.004969937007270e-08,
 -6.289437443979104e-11,  2.704896091292832e-12, -3.215496976657475e-14,  2.596226874880983e-16,  8.476361738116510e-18,  2.010140083804447e-19,  2.506375728529722e-21,
 -1.779997276677399e-23,  5.522177852417055e-01, -4.850915119015155e-03,  2.523698940416928e-05, -5.594115013943840e-08, -5.021810484348728e-10,  5.518288865067517e-12,
 -3.903507729119197e-14,  1.727593991632606e-16,  1.334967815965962e-17,  2.693911142545793e-19,  3.459353364977590e-21, -2.311373843803183e-23,  6.982110156259255e-01,
 -5.924142121782283e-03,  2.626782520626095e-05,  2.043282374727057e-09, -1.161132162083239e-09,  7.642536859306404e-12, -1.852623355601665e-14, -1.812334220406448e-16,
  1.994520139053283e-17,  3.787322286984953e-19,  4.504142638164830e-21, -2.832136832949103e-23,  8.646281227592411e-01, -6.989553529458796e-03,  2.350037226907156e-05,
  1.070710633016746e-07, -1.930159091210915e-09,  5.422356983849640e-12,  6.246362881166505e-14, -7.595483525871157e-16,  2.395221743728894e-17,  5.951814402221162e-19,
  5.725867952432605e-21, -3.848755967440634e-23,  1.052695279814135e+00, -7.928177908431096e-03,  1.429026037173352e-05,  2.661170995505001e-07, -2.335503222363430e-09,
 -8.751962567754038e-12,  2.164078738866436e-13, -5.141860821538812e-16,  1.180840472239136e-17,  9.520133196549672e-19,  9.414692874769294e-21, -7.558396532267258e-23,
  1.263023239086774e+00, -8.510015639286118e-03, -5.141938244463272e-06,  4.493915056046154e-07, -1.010977565793367e-09, -4.334897927063451e-11,  2.390122807050988e-13,
  4.254525871494609e-15, -1.309935062100810e-17,  8.099586900612170e-19,  2.237936855431649e-20, -7.112531063080478e-23,  1.493634614354678e+00, -8.275471214753791e-03,
 -3.813531084744658e-05,  4.847665701925435e-07,  4.575411729824506e-09, -6.595696721083343e-11, -7.869290226649209e-13,  1.092955102731173e-14,  1.849939751420440e-16,
 -3.443714057360082e-19, -1.069063008320479e-21,  3.471452685867883e-22,  1.732997993871732e+00, -6.362763516716438e-03, -7.479292046247618e-05, -1.356069877449717e-07,
  1.007955470618877e-08,  1.175387613206591e-10, -1.199503709064941e-12, -4.055138566642689e-14, -3.446496985829824e-17,  1.289073214269010e-17,  1.856591300662125e-19,
 -1.427470571354052e-21,  1.936258918166053e+00, -2.170681046766135e-03, -5.052310963549312e-05, -9.109733664297710e-07, -1.214958273065832e-08, -8.029610909178967e-11,
  1.390875703225958e-12,  6.325187713050701e-14,  1.300147624329903e-15,  1.518976106483608e-17, -1.216190372881694e-20, -5.418070295834125e-21,  1.756599192171842e-03,
 -1.658046323200575e-05,  1.169643582042687e-07, -7.416046781607832e-10,  4.202423237677813e-12, -2.630874280623520e-14,  1.507334095868943e-16,  1.286125890384844e-18,
  6.609993030118684e-20,  9.332263989345240e-22, -7.742150223161229e-25, -4.008058701622225e-25,  1.582966523976496e-02, -1.491762598089916e-04,  1.047002914479201e-06,
 -6.573360258662338e-09,  3.658438519916688e-11, -2.246840591568849e-13,  1.250570839361496e-15,  1.253650027570645e-17,  5.922256291574958e-19,  8.503750610731012e-21,
 -7.235801824254585e-24, -3.628713048722004e-24,  4.408473768571329e-02, -4.140874806804370e-04,  2.875945197039551e-06, -1.768579677557667e-08,  9.465553496870299e-11,
 -5.568540409956593e-13,  2.894547659820912e-15,  3.998294028340427e-17,  1.633232599912766e-18,  2.418278076920885e-20, -2.129820155547160e-23, -1.020424825880200e-23,
  8.674368725734453e-02, -8.106272806654125e-04,  5.537201911105058e-06, -3.291744842858988e-08,  1.645864665688664e-10, -8.937106945336800e-13,  4.025897037213663e-15,
  9.255782400226100e-17,  3.181949526930150e-18,  4.894644257619397e-20, -4.386386646894611e-23, -2.039207138616241e-23,  1.441495323098090e-01, -1.337416512323406e-03,
  8.919181171703232e-06, -5.036911831164226e-08,  2.245509335187134e-10, -1.043942619127135e-12,  3.234728963057118e-15,  1.808383524152151e-16,  5.269710438860769e-18,
  8.400867438390109e-20, -7.299426326391102e-23, -3.465113087896670e-23,  2.167793346364904e-01, -1.991858042450665e-03,  1.284840841989301e-05, -6.719023025328609e-08,
  2.435700647855666e-10, -7.646526739099261e-13, -9.044076135642425e-16,  3.123755205804742e-16,  8.026740714360867e-18,  1.305557500069396e-19, -1.008504480025743e-22,
 -5.370202197533101e-23,  3.052623462064789e-01, -2.769211755771063e-03,  1.706132432869441e-05, -7.925040660003654e-08,  1.804763458793169e-10,  2.055567355932148e-13,
 -9.106312068156981e-15,  4.831239910746268e-16,  1.177375668423155e-17,  1.896103781360433e-19, -1.129358464014976e-22, -7.859292133094705e-23,  4.104037880233353e-01,
 -3.660959014592981e-03,  2.115748996231146e-05, -8.066204104775076e-08, -1.573570954535561e-11,  2.058377991576595e-12, -1.987734795188654e-14,  6.631851395843099e-16,
  1.712845955946698e-17,  2.627376154034293e-19, -9.733808077151478e-23, -1.107277664119404e-22,  5.332134828878963e-01, -4.651832903021139e-03,  2.452097026107563e-05,
 -6.314138575400810e-08, -4.005011395107217e-10,  4.697601386970366e-12, -2.658890771101947e-14,  7.780584682984487e-16,  2.501595331920586e-17,  3.557419043802637e-19,
 -8.006519687363717e-23, -1.518767775585549e-22,  6.749344568712600e-01, -5.714205813524169e-03,  2.618584051137485e-05, -1.533643953401090e-08, -1.012708354450641e-09,
  7.222872163199828e-12, -1.239355832899781e-14,  7.050667224228085e-16,  3.614262825298168e-17,  4.906127439202327e-19, -1.958398660622383e-22, -2.047697913628234e-22,
  8.370533223152850e-01, -6.796927401010536e-03,  2.460375693439114e-05,  7.713214289840280e-08, -1.807906380996519e-09,  6.774125083007546e-12,  5.542818516772048e-14,
  3.873677730533256e-16,  4.858199545096303e-17,  7.318676154216872e-19, -6.349628491209060e-22, -2.777470746075649e-22,  1.021230525159069e+00, -7.801728950830309e-03,
  1.725458447606825e-05,  2.276272322790134e-07, -2.459406984962744e-09, -3.654215280242043e-12,  2.129121531673304e-13,  4.737633879178640e-16,  5.136122381032800e-17,
  1.182342292052008e-18, -2.820020999304120e-22, -4.027856004324975e-22,  1.228934586978813e+00, -8.529919005402665e-03,  1.262147268186272e-07,  4.266317543627563e-07,
 -1.811053798748895e-09, -3.619770066155432e-11,  3.578133252276316e-13,  4.460888721558057e-15,  3.022926306530396e-17,  1.507505682749112e-18,  8.589195067118609e-21,
 -6.073702376949447e-22,  1.459961023851089e+00, -8.556146750676830e-03, -3.192541511094088e-05,  5.465098274248956e-07,  3.095607150118492e-09, -8.051313253545558e-11,
 -3.998083467332727e-13,  1.666529228990625e-14,  1.743239409795029e-16, -2.234015848106919e-19,  2.115574255672633e-21, -3.396921230219335e-22,  1.706344037918204e+00,
 -6.964707785410851e-03, -7.538110546543356e-05,  4.252560743325185e-08,  1.205182724374049e-08,  7.547653922312841e-11, -2.271442811539894e-12, -3.298666000550715e-14,
  5.377312823089040e-16,  1.790595207774322e-17,  3.531013520475916e-20, -5.473558256394977e-21,  1.926693782818831e+00, -2.622004243368068e-03, -6.266640757395081e-05,
 -1.115707295581775e-06, -1.325185493922817e-08, -2.047328953150293e-11,  3.822549872894824e-12,  1.129049153228869e-13,  1.758870045435017e-15,  7.449090288530919e-18,
 -4.466149707235055e-19, -1.524547573219892e-20,  1.692093969732454e-03, -1.567924096447163e-05,  1.084518522800976e-07, -6.783618170335981e-10,  3.716704371323818e-12,
 -2.199016122802963e-14,  2.211255489016416e-16,  3.890122543706563e-18,  9.361962070871453e-20,  4.084714542000379e-22, -2.913912684216347e-23, -9.002234154251414e-25,
  1.524922628418720e-02, -1.411061369963902e-04,  9.714921098674390e-07, -6.022167392571384e-09,  3.243150551129707e-11, -1.880448361772621e-13,  1.910359250436923e-15,
  3.594278673252362e-17,  8.431717014770485e-19,  3.742410632725045e-21, -2.641459360771234e-22, -8.155353110042560e-24,  4.247309403112833e-02, -3.919039105829926e-04,
  2.672448587799839e-06, -1.625613343692576e-08,  8.433765963936830e-11, -4.672719217204089e-13,  4.869345771770425e-15,  1.049219218762480e-16,  2.347872558929460e-18,
  1.074876357113372e-20, -7.442697907526063e-22, -2.295863313250128e-23,  8.358733309876847e-02, -7.678662544286715e-04,  5.157422937538524e-06, -3.042070041246518e-08,
  1.479545559768309e-10, -7.529189322260868e-13,  8.293284282783823e-15,  2.200569791058682e-16,  4.631321312480200e-18,  2.203288938474440e-20, -1.489820316880768e-21,
 -4.593836632427107e-23,  1.389388292885098e-01, -1.268421252101517e-03,  8.335638908634324e-06, -4.693701678240057e-08,  2.049685467544725e-10, -8.838048234465490e-13,
  1.108888442044440e-14,  3.935928312909912e-16,  7.763590370219129e-18,  3.831612563044988e-20, -2.531742736509101e-21, -7.814870492950512e-23,  2.090124625535422e-01,
 -1.892230807945681e-03,  1.206500939352248e-05, -6.341308268738242e-08,  2.289363244105926e-10, -6.481954327480559e-13,  1.210688392464581e-14,  6.379146363615495e-16,
  1.191333287672015e-17,  6.021005052786327e-20, -3.913303065456213e-21, -1.212204070603613e-22,  2.944525269912867e-01, -2.636475829573767e-03,  1.612775696476467e-05,
 -7.633632638160209e-08,  1.837437437524586e-10,  1.979874992908521e-13,  1.066859445855321e-14,  9.598280719934310e-16,  1.743391946888946e-17,  8.800665885517107e-20,
 -5.695733842023438e-21, -1.775892265445847e-22,  3.960923394036359e-01, -3.495572156391279e-03,  2.018932958209964e-05, -8.060285463810525e-08,  2.252159371023792e-11,
  1.874523004684976e-12,  7.715472919238850e-15,  1.350037892155431e-15,  2.498760658109764e-17,  1.219026932809386e-19, -7.975317900506554e-21, -2.508302187124915e-22,
  5.149935434457774e-01, -4.458797904763863e-03,  2.372783810930638e-05, -6.882327676743819e-08, -3.106493928415317e-10,  4.422782052615888e-12,  8.233380503876296e-15,
  1.766580049263629e-15,  3.566219300495802e-17,  1.641287729683188e-19, -1.093030231037134e-20, -3.461926720009969e-22,  6.524950670111317e-01, -5.505719777847884e-03,
  2.590932242815149e-05, -3.039100684717282e-08, -8.688834234234711e-10,  7.308769886003612e-12,  2.606105333568622e-14,  2.120684927606285e-15,  5.081622929140517e-17,
  2.273741176547999e-19, -1.493113925837608e-20, -4.718677676041149e-22,  8.102644548347171e-01, -6.596875954745639e-03,  2.536050703911068e-05,  4.936893210037891e-08,
 -1.657234220888458e-09,  8.433697444439371e-12,  9.179729302238222e-14,  2.328719645031076e-15,  7.060208446606073e-17,  3.591413421967931e-19, -2.069533229410728e-20,
 -6.439384511816506e-22,  9.903160329593522e-01, -7.653438839498069e-03,  1.974851720183958e-05,  1.879780302207826e-07, -2.479194632308591e-09,  1.838825278254140e-12,
  2.553294712635234e-13,  2.753226746841871e-15,  8.817915357365504e-17,  6.749829517612244e-19, -2.879964865482241e-20, -9.075908646341165e-22,  1.194848590509122e+00,
 -8.508975338024652e-03,  5.049677732627071e-06,  3.923749379745307e-07, -2.438233817632395e-09, -2.595102579797829e-11,  5.045268099111176e-13,  6.297749044604522e-15,
  8.227521194920929e-17,  1.098099907905969e-18, -3.471735142036639e-20, -1.376800799959973e-21,  1.425268189066362e+00, -8.784600528447506e-03, -2.512448576681168e-05,
  5.828059872122135e-07,  1.430412280522381e-09, -8.388659869482390e-11,  1.435508697647044e-13,  2.208065506580966e-14,  1.608952276911363e-16, -8.087094450296880e-19,
 -4.145166401229946e-20, -1.707776356615422e-21,  1.677287094250147e+00, -7.562343212763064e-03, -7.367436000493035e-05,  2.441977007670927e-07,  1.295396897605277e-08,
  1.241530562611683e-11, -2.858368405886924e-12, -5.729201846456033e-15,  1.139980803974856e-15,  1.346495236855695e-17, -2.783205923426954e-19, -8.295854520199187e-21,
  1.915113227690327e+00, -3.180486885843619e-03, -7.732122283351217e-05, -1.324837137922865e-06, -1.245448483739615e-08,  1.156519143771725e-10,  7.778889000194287e-12,
  1.684942373783044e-13,  1.509522738868151e-15, -2.759116894039649e-17, -1.395627542669603e-18, -2.732308114050674e-20,  1.631062065772989e-03, -1.484320791261190e-05,
  1.006548506644615e-07, -6.220814218736218e-10,  3.340565377099552e-12, -1.503406534017759e-14,  3.721082468699518e-16,  6.810704264999744e-18,  7.659783482987016e-20,
 -1.675354188338603e-21, -7.732624270441167e-23, -1.196374312538061e-24,  1.469990002482116e-02, -1.336147105018578e-04,  9.022245541996627e-07, -5.530461609588048e-09,
  2.922657311610148e-11, -1.270377175498241e-13,  3.295781888805612e-15,  6.226542962886933e-17,  6.903483178096702e-19, -1.514320493285554e-20, -7.007657014244333e-22,
 -1.084230454650713e-23,  4.094703360806867e-02, -3.712823398543910e-04,  2.485186672596390e-06, -1.497399101528437e-08,  7.644330414404045e-11, -3.065646731621894e-13,
  8.863736920705024e-15,  1.783165451427454e-16,  1.924808042471041e-18, -4.244893323556842e-20, -1.973852943353629e-21, -3.054476715334712e-23,  8.059613028318756e-02,
 -7.280278834425823e-04,  4.806122734497042e-06, -2.816067934527373e-08,  1.354734789920804e-10, -4.629781605284022e-13,  1.654198404143399e-14,  3.650803320466336e-16,
  3.803164712555179e-18, -8.444981981909906e-20, -3.951292899740686e-21, -6.117977656363038e-23,  1.339950243696443e-01, -1.203934594945697e-03,  7.791546689091705e-06,
 -4.378020877645417e-08,  1.909938248924594e-10, -4.569554288185044e-13,  2.561310655652047e-14,  6.371197217147879e-16,  6.386490149266837e-18, -1.427499953156031e-19,
 -6.721513130327159e-21, -1.042093208647508e-22,  2.016318468601079e-01, -1.798693139425036e-03,  1.132567210851691e-05, -5.983116455003503e-08,  2.205511667065585e-10,
 -9.956871261367883e-14,  3.535022162079906e-14,  1.012079157560574e-15,  9.814695493091174e-18, -2.201489874958900e-19, -1.041657281763618e-20, -1.618921442793504e-22,
  2.841589373527240e-01, -2.511067497852463e-03,  1.522956392544053e-05, -7.334054603809800e-08,  1.927720399360808e-10,  8.405233996920023e-13,  4.542038818045651e-14,
  1.507534376298212e-15,  1.437821933860254e-17, -3.213218489421467e-19, -1.523091225886867e-20, -2.376290857979176e-22,  3.824269668073830e-01, -3.337917345730974e-03,
  1.922556626639753e-05, -7.991802073500029e-08,  6.539996284569982e-11,  2.604938078365689e-12,  5.679528679836714e-14,  2.134407746811169e-15,  2.063365432107784e-17,
 -4.536548142290703e-19, -2.145896095624731e-20, -3.365229631162329e-22,  4.975326564423667e-01, -4.272356328373867e-03,  2.287514187862054e-05, -7.305611366602671e-08,
 -2.155350549174021e-10,  5.344553218399799e-12,  7.377246827945318e-14,  2.884942282187583e-15,  2.955621038789217e-17, -6.276122966155750e-19, -2.957611976638029e-20,
 -4.663250817247152e-22,  6.308841087541434e-01, -5.300128859075155e-03,  2.546621464247733e-05, -4.306621213182163e-08, -7.106804029737307e-10,  8.832890245217700e-12,
  1.083574746382867e-13,  3.717490121240983e-15,  4.259330846290178e-17, -8.540609486135960e-19, -4.042056470431076e-20, -6.393097861105393e-22,  7.842858528268304e-01,
 -6.392059231426338e-03,  2.579986556143649e-05,  2.434912759698986e-08, -1.459902839148966e-09,  1.167932678152798e-11,  1.890845125224802e-13,  4.573589204085338e-15,
  6.089886118868295e-17, -1.130628315568728e-18, -5.557651093238117e-20, -8.775067852410461e-22,  9.600315947932530e-01, -7.487096985064815e-03,  2.176862888174820e-05,
  1.489702181888710e-07, -2.373187211748373e-09,  9.223083249811310e-12,  3.734976096264593e-13,  5.654890477336244e-15,  8.086682474091581e-17, -1.407824519686725e-18,
 -7.782603080075033e-20, -1.233290230937943e-21,  1.160922321982979e+00, -8.450441969282817e-03,  9.509287472212649e-06,  3.499345916652579e-07, -2.820237086493235e-09,
 -1.140505747640086e-11,  7.210063629907304e-13,  9.164013919140292e-15,  8.034625811021295e-17, -1.698932736413316e-18, -1.088361316044293e-19, -1.863098102790666e-21,
  1.389772472458029e+00, -8.957357862020107e-03, -1.804765461687544e-05,  5.926781044865089e-07, -1.599506586544753e-10, -7.248292795537078e-11,  8.262574316797086e-13,
  2.627165115981449e-14,  8.010639621645067e-17, -4.366844239895493e-18, -1.445787992957572e-19, -2.785877529660882e-21,  1.645882459412504e+00, -8.136498420780968e-03,
 -6.950424598925244e-05,  4.497448022147978e-07,  1.252614031877677e-08, -5.363510270359770e-11, -2.454683253580320e-12,  3.563988572200907e-14,  1.336268881320563e-15,
 -4.901741144805556e-18, -6.284299890673243e-19, -6.674215634229670e-21,  1.901048995341710e+00, -3.865786468557827e-03, -9.430112564821029e-05, -1.493774659239419e-06,
 -7.869648955113616e-09,  3.630547169419086e-10,  1.293278801352581e-11,  1.876999952623917e-13, -7.881991859104408e-16, -1.081013372562958e-16, -2.583754638788021e-18,
 -2.013929543082067e-20,  1.573253690577958e-03, -1.406693974208007e-05,  9.350240431835117e-08, -5.704837190147774e-10,  3.145745995536694e-12, -3.617627612445324e-15,
  5.832294232185154e-16,  7.602598007498304e-18, -5.107386501744559e-20, -5.686878984162209e-21, -1.166443544702122e-22, -2.614054061605738e-25,  1.417946746796349e-02,
 -1.266545886765249e-04,  8.385965519057637e-07, -5.078235625144803e-09,  2.762801137964426e-11, -2.524093186901715e-14,  5.222786556640584e-15,  6.934249658362763e-17,
 -4.652655221789622e-19, -5.149980783818613e-20, -1.057266347792013e-21, -2.378096195626372e-24,  3.950055805734978e-02, -3.520991874924802e-04,  2.312677333948322e-06,
 -1.378659132468714e-08,  7.287152052686172e-11, -2.898024269774510e-14,  1.436594835958658e-14,  1.977371275003916e-16, -1.322995360124242e-18, -1.448712992939241e-19,
 -2.979188130231029e-21, -6.752156792556691e-24,  7.775882779413022e-02, -6.908943108726624e-04,  4.480974334134419e-06, -2.604193414656508e-08,  1.310667671127506e-10,
  6.642294101654272e-14,  2.776429367597547e-14,  4.026559892799816e-16, -2.680109252924757e-18, -2.895459054801179e-19, -5.968070834421872e-21, -1.368987305245424e-23,
  1.293006961786604e-01, -1.143652167183612e-03,  7.284343590347289e-06, -4.075762083832854e-08,  1.895385982230814e-10,  3.881065295562407e-13,  4.512126926616413e-14,
  6.988882795096405e-16, -4.611630021864513e-18, -4.918339902032536e-19, -1.016424114351722e-20, -2.371837092428244e-23,  1.946138228179291e-01, -1.710899470387135e-03,
  1.062898224646986e-05, -5.626203136710203e-08,  2.294800312163382e-10,  1.113853255874462e-12,  6.624319880449351e-14,  1.105735750076791e-15, -7.196234895098534e-18,
 -7.616293444939019e-19, -1.578044384382795e-20, -3.768292975834961e-23,  2.743528427869038e-01, -2.392697161828943e-03,  1.436877116624958e-05, -7.004737642564513e-08,
  2.241089350750862e-10,  2.473753319445946e-12,  9.138171798463534e-14,  1.645590835415481e-15, -1.048609641942322e-17, -1.114124278137567e-18, -2.313354709721078e-20,
 -5.690653638927607e-23,  3.693768637836281e-01, -3.187926545662655e-03,  1.827484577839427e-05, -7.835936523643439e-08,  1.362681751520045e-10,  4.738089106948412e-12,
  1.220050146897393e-13,  2.340232798796575e-15, -1.445420136441562e-17, -1.572614894073219e-18, -3.270329027868042e-20, -8.344364528066467e-23,  4.808036100407671e-01,
 -4.092911620647811e-03,  2.198169508140068e-05, -7.552431448018037e-08, -8.396464463672476e-11,  8.161304126369047e-12,  1.625437404262289e-13,  3.202763444473728e-15,
 -1.892319795316503e-17, -2.172894207216683e-18, -4.524885080074975e-20, -1.204844376922835e-22,  6.100875259019543e-01, -5.098645095862004e-03,  2.488758452243227e-05,
 -5.284486046722004e-08, -4.989550232662851e-10,  1.279567432373926e-11,  2.243747748856739e-13,  4.224090974232646e-15, -2.356545166507495e-17, -2.969374859340593e-18,
 -6.205899356447894e-20, -1.730818655379506e-22,  7.591317293845762e-01, -6.184869057801259e-03,  2.596053859151999e-05,  3.152796291618234e-09, -1.169646391020681e-09,
  1.791952303967506e-11,  3.348272333063869e-13,  5.369975119789260e-15, -2.850518147919385e-17, -4.040878909471798e-18, -8.551792895044233e-20, -2.501938388197678e-22,
  9.304419381648804e-01, -7.306425421249824e-03,  2.333626840271198e-05,  1.130202213710234e-07, -2.085034828706222e-09,  2.030861231638842e-11,  5.555653123379099e-13,
  6.729383766311985e-15, -3.809238226103089e-17, -5.490947949289467e-18, -1.202881111370551e-19, -3.747652172336726e-22,  1.127298200151461e+00, -8.358348690063288e-03,
  1.343352672869571e-05,  3.040176002094469e-07, -2.853372970415809e-09,  9.178306479732273e-12,  9.975079379664508e-13,  9.762417255305775e-15, -7.775955795420502e-17,
 -7.529162171316619e-18, -1.740598812566537e-19, -6.384546556659695e-22,  1.353699125743086e+00, -9.073435975445202e-03, -1.099453026322912e-05,  5.798520837333402e-07,
 -1.351007076162189e-09, -4.372686859046854e-11,  1.564787221036979e-12,  2.496831927492028e-14, -2.097551365584434e-16, -1.243988726981630e-17, -2.477773064750857e-19,
 -1.168164188007617e-21,  1.612263257214412e+00, -8.667637824663182e-03, -6.294943849309571e-05,  6.388028559494182e-07,  1.096875352442009e-08, -9.608946159901696e-11,
 -9.220694793365392e-13,  7.025407678034526e-14,  6.528149234259824e-16, -3.402385092557682e-17, -7.674852786057651e-19,  1.635694835965573e-21,  1.883961358574809e+00,
 -4.693367311226466e-03, -1.126830197544044e-04, -1.543053610120743e-06,  2.888332788167557e-09,  7.293204943035012e-10,  1.710174479991215e-11,  7.932873203049460e-14,
 -6.625263015766603e-15, -2.138257128601242e-16, -2.160042954566881e-18,  5.490390839045372e-20,  1.518439820668171e-03, -1.334544830436423e-05,  8.695885106886688e-08,
 -5.199037560957785e-10,  3.228737282836504e-12,  1.252856140525838e-14,  7.361138756398454e-16,  1.815681015549589e-18, -3.352799466151775e-19, -9.737781152307582e-21,
 -5.916054183551043e-23,  3.409312320076141e-24,  1.368589133024219e-02, -1.201820478015240e-04,  7.803170927524424e-07, -4.632810402510256e-09,  2.851690798396033e-11,
  1.197200187163600e-13,  6.619841347736741e-15,  1.684075130688999e-17, -3.039786430680833e-18, -8.822945525675423e-20, -5.369467322787025e-22,  3.087964698592806e-23,
  3.812814445238368e-02, -3.342396177355193e-04,  2.154280244219432e-06, -1.260482401747437e-08,  7.614005601709188e-11,  3.718233016091592e-13,  1.836412525704641e-14,
  4.954961631216264e-17, -8.569453084460519e-18, -2.484389296474822e-19, -1.517091531255582e-21,  8.688764161766092e-23,  7.506501773384555e-02, -6.562605248513163e-04,
  4.181224401909950e-06, -2.389451411656124e-08,  1.398749491579774e-10,  8.471007037986680e-13,  3.594688583312739e-14,  1.052110473967617e-16, -1.717495926473964e-17,
 -4.972350384659706e-19, -3.051584100738900e-21,  1.736830450204895e-22,  1.248396135081877e-01, -1.087281226571986e-03,  6.813911532743481e-06, -3.759795169284971e-08,
  2.095491269334426e-10,  1.670021875449892e-12,  5.941016166749823e-14,  1.915008671538454e-16, -2.925706718818495e-17, -8.460634832323378e-19, -5.226249610940896e-21,
  2.949548793342577e-22,  1.879361038573734e-01, -1.628503467981991e-03,  9.976909748561426e-06, -5.231606191487145e-08,  2.699054727691227e-10,  3.019533939538535e-12,
  8.900017117742156e-14,  3.178665377527303e-16, -4.540050041765177e-17, -1.312637357813435e-18, -8.172579710867495e-21,  4.562947885400767e-22,  2.650067229574869e-01,
 -2.281043701481575e-03,  1.355177578108645e-05, -6.593222456481598e-08,  2.988713969525796e-10,  5.138507939164828e-12,  1.254723933616359e-13,  4.938352172273029e-16,
 -6.642826097178513e-17, -1.923850953027414e-18, -1.208898685205494e-20,  6.660005593011704e-22,  3.569116630731092e-01, -3.045443624312303e-03,  1.735131459787114e-05,
 -7.524130546399640e-08,  2.650939017893499e-10,  8.338969590031605e-12,  1.707642511653424e-13,  7.249238431291813e-16, -9.349184415682742e-17, -2.720795531543440e-18,
 -1.728046074814355e-20,  9.364963191598876e-22,  4.647779168535058e-01, -3.920692140440815e-03,  2.107349382610852e-05, -7.532177216164382e-08,  1.248300228042460e-10,
  1.298533921909800e-11,  2.295168726298122e-13,  1.003421563273431e-15, -1.282408805587800e-16, -3.767514682403703e-18, -2.423810120897818e-20,  1.286969601943836e-21,
  5.900869673300906e-01, -4.902195149916191e-03,  2.421504250450360e-05, -5.845100129787530e-08, -1.805332557954980e-10,  1.939889874847907e-11,  3.126334391742096e-13,
  1.289420219385856e-15, -1.732204632023083e-16, -5.166483015511096e-18, -3.381363225947478e-20,  1.748606488728186e-21,  7.348074520158355e-01, -5.977321244755921e-03,
  2.589945828266973e-05, -1.221049352207607e-08, -7.199074352262554e-10,  2.749863028332911e-11,  4.458699473425574e-13,  1.480868128542524e-15, -2.330860106227489e-16,
 -7.085926994360647e-18, -4.763484468980975e-20,  2.375716663273265e-21,  9.015974526504070e-01, -7.114841558178007e-03,  2.450826142110375e-05,  8.369241850603945e-08,
 -1.531872846698068e-09,  3.554964631853189e-11,  6.906115614544641e-13,  1.431410282450035e-15, -3.192795403992998e-16, -9.808500305868666e-18, -6.909207714254455e-20,
  3.270045245665805e-21,  1.094101781023447e+00, -8.237040918700299e-03,  1.681831908494460e-05,  2.612171089948722e-07, -2.410955839156087e-09,  3.581876661194402e-11,
  1.185679570604427e-12,  1.602792568424597e-15, -4.707385696079913e-16, -1.386792820649087e-17, -1.046136117711384e-19,  4.628230428866055e-21,  1.317272949748539e+00,
 -9.133978895245497e-03, -4.187648321476443e-06,  5.534982270308523e-07, -1.799295473453279e-09,  9.759176434263129e-13,  2.088845128297397e-12,  9.173856774539058e-15,
 -8.330575985601880e-16, -2.158494768686761e-17, -1.506617272694063e-19,  6.933578098016016e-21,  1.576638077702525e+00, -9.137737725947189e-03, -5.429622378852803e-05,
  7.984209914668844e-07,  8.991653771927782e-09, -9.358878975883444e-11,  1.113155068838877e-12,  6.601310802670161e-14, -1.068219748064323e-15, -5.883844829559671e-17,
 -3.432595124996180e-19,  1.951666580347780e-20,  1.863270444229675e+00, -5.666857295302133e-03, -1.303679762314380e-04, -1.357619859022090e-06,  2.160341745025573e-08,
  1.134912375737201e-09,  1.511800390532455e-11, -2.653407956473653e-13, -1.491709162026682e-14, -2.094148242662202e-16,  3.523343654164389e-18,  2.085101642730932e-19,
  1.466411129162566e-03, -1.267382939728757e-05,  8.104132844593073e-08, -4.652882630914043e-10,  3.652422709719046e-12,  2.926180846360591e-14,  5.829705126486629e-16,
 -1.458729215216503e-17, -6.772544353965621e-19, -7.444245871618791e-21,  2.151150738644439e-22,  8.929614125720727e-24,  1.321730737984729e-02, -1.141538914427316e-04,
  7.275678467346964e-07, -4.148828242633810e-09,  3.246872307044852e-11,  2.702618765481232e-13,  5.242255600175098e-15, -1.318496411028232e-16, -6.138970444828942e-18,
 -6.748745928925847e-20,  1.948332007389025e-21,  8.093612961511668e-23,  3.682472667734422e-02, -3.175889767850389e-04,  2.010654485722858e-06, -1.130333853080444e-08,
  8.790028101413308e-11,  7.897721308448352e-13,  1.453993425603553e-14, -3.694981126373257e-16, -1.730026856246653e-17, -1.902539170486674e-19,  5.481873800904482e-21,
  2.280602429206812e-22,  7.250511503477972e-02, -6.239180285096278e-04,  3.908628728429302e-06, -2.147443635351236e-08,  1.652900733971335e-10,  1.666152093766458e-12,
  2.845059064232197e-14, -7.343766812864802e-16, -3.466143683491080e-17, -3.814612041565849e-19,  1.095764276984228e-20,  4.568932236203320e-22,  1.205967381900536e-01,
 -1.034514596831663e-03,  6.384205587125735e-06, -3.390094013881985e-08,  2.569733711544878e-10,  3.025615910579907e-12,  4.698740652536798e-14, -1.238450573017880e-15,
 -5.903933695218590e-17, -6.506691871171815e-19,  1.860946281301445e-20,  7.783330165689177e-22,  1.815778551671020e-01, -1.551120601934056e-03,  9.377396670774536e-06,
 -4.739889219726606e-08,  3.513390078370641e-10,  5.053469731696282e-12,  7.029976620632712e-14, -1.901534163943841e-15, -9.166315334118609e-17, -1.012746134976164e-18,
  2.879381624322594e-20,  1.209081264040732e-21,  2.560944921223962e-01, -2.175704072580979e-03,  1.279320276429982e-05, -6.016496389857380e-08,  4.313554328778326e-10,
  8.010014644169408e-12,  9.889023177149452e-14, -2.756465206364774e-15, -1.343358950492081e-16, -1.490422762362746e-18,  4.204246269391814e-20,  1.774246080388893e-21,
  3.450019116075369e-01, -2.910158457261599e-03,  1.648009460205766e-05, -6.944325897423300e-08,  4.723601385070741e-10,  1.225004755992575e-11,  1.341039212591645e-13,
 -3.859103461486901e-15, -1.897107770229750e-16, -2.118760669246451e-18,  5.915306074035788e-20,  2.511937008273925e-21,  4.494266761558775e-01, -3.755663991113305e-03,
  2.019115847720983e-05, -7.094798205744063e-08,  4.389547538916401e-10,  1.823860702156810e-11,  1.792661870875469e-13, -5.308313186812542e-15, -2.617908836724398e-16,
 -2.953147032147672e-18,  8.135018015888450e-20,  3.481748049412453e-21,  5.708611580321565e-01, -4.711297420689997e-03,  2.351042462499864e-05, -5.782928598991119e-08,
  2.814155410032187e-10,  2.653248148861469e-11,  2.424419428172370e-13, -7.287275650971709e-15, -3.569254706609972e-16, -4.083964058585691e-18,  1.105857722232243e-19,
  4.781498737665295e-21,  7.113114137924649e-01, -5.770861924027096e-03,  2.570384895784436e-05, -1.875198180980021e-08, -6.495128310547741e-11,  3.761177879754561e-11,
  3.434804296105168e-13, -1.014989883726244e-14, -4.861279759425400e-16, -5.663839678767650e-18,  1.501432581285273e-19,  6.583282122414351e-21,  8.735360695614781e-01,
 -6.915115045431660e-03,  2.539186842153878e-05,  6.575951167101426e-08, -6.592795337368988e-10,  5.111425225650779e-11,  5.328953780055142e-13, -1.458517882849783e-14,
 -6.718029203861463e-16, -7.957136371230240e-18,  2.060436182802073e-19,  9.219762469011264e-21,  1.061441721501337e+00, -8.090547304941523e-03,  1.975007601414795e-05,
  2.298974834554231e-07, -1.417202481294400e-09,  6.263382702083946e-11,  9.418902023857378e-13, -2.170895595352201e-14, -9.733276238033580e-16, -1.143425161110858e-17,
  2.918090391116382e-19,  1.341622892372063e-20,  1.280711431206588e+00, -9.141382214533970e-03,  2.291152972627910e-06,  5.276131819524590e-07, -1.276354410051864e-09,
  5.043776143698327e-11,  1.851998895767050e-12, -3.024744492580047e-14, -1.608795697968664e-15, -1.746950341251320e-17,  4.615523537344501e-19,  2.104288557304788e-20,
  1.539282347700783e+00, -9.531467654277429e-03, -4.390754578144349e-05,  9.292981380064135e-07,  7.508297061855612e-09, -5.055761314702120e-11,  2.157523444610024e-12,
 -2.588901522121834e-15, -3.158863256676015e-15, -4.789624568441627e-17,  1.079714072389287e-18,  4.492501586026232e-20,  1.838424659438646e+00, -6.767254335100304e-03,
 -1.437819922814032e-04, -8.142376759833418e-07,  4.702495642196225e-08,  1.349141393142363e-09,  1.806835897209216e-13, -8.161029879479960e-13, -1.741544021594798e-14,
  1.432803349091374e-16,  1.425974541178108e-17,  2.207283599977145e-19,  1.416978577249144e-03, -1.204679060769381e-05,  7.582978617568497e-08, -4.015927778334178e-10,
  4.331061038886442e-12,  3.573459193348282e-14, -1.526294631138422e-16, -3.807112737397937e-17, -6.894947141678151e-19,  9.522337842227388e-21,  6.215356592309872e-22,
  7.063047086789110e-24,  1.277203064459584e-02, -1.085232136549529e-04,  6.810949808950802e-07, -3.580927496926497e-09,  3.871135705916131e-11,  3.280503923645060e-13,
 -1.415170862256336e-15, -3.447356419242734e-16, -6.251279234062994e-18,  8.625723504518900e-20,  5.633601417042529e-21,  6.409052352139670e-23,  3.558571765283289e-02,
 -3.020210908963984e-04,  1.884023056594297e-06, -9.756315689336419e-09,  1.060042766517929e-10,  9.477174684612561e-13, -4.164316288013631e-15, -9.695352709721125e-16,
 -1.762474185980362e-17,  2.427566521765000e-19,  1.587508567575111e-20,  1.810083570805506e-22,  7.007041598346861e-02, -5.936320834619060e-04,  3.667998364596761e-06,
 -1.853548220433935e-08,  2.030883995714909e-10,  1.968240755565893e-12, -8.860836118630625e-15, -1.936905048091447e-15, -3.533719668594506e-17,  4.853974316960849e-19,
  3.180686581093000e-20,  3.639112151685607e-22,  1.165583557723959e-01, -9.849933783951713e-04,  6.004217192656451e-06, -2.925983997687061e-08,  3.247830060109504e-10,
  3.508948092764766e-12, -1.622553915193732e-14, -3.287631269217112e-15, -6.025438375400674e-17,  8.246083441058979e-19,  5.419194559900439e-20,  6.229552076650225e-22,
  1.755199544420571e-01, -1.478272849624164e-03,  8.845906183869986e-06, -4.090163986608745e-08,  4.631493767423768e-10,  5.747270490120324e-12, -2.726637270944277e-14,
 -5.085108425665182e-15, -9.368911839710143e-17,  1.276129523845195e-18,  8.420153800319790e-20,  9.738704164561973e-22,  2.475919770838010e-01, -2.076116194582232e-03,
  1.211824380549683e-05, -5.188819223863362e-08,  6.063719374091717e-10,  8.937465513563167e-12, -4.328818693862629e-14, -7.426498942771239e-15, -1.375859402879222e-16,
  1.863170256797699e-18,  1.235991350341390e-19,  1.440610509016533e-21,  3.336198886859989e-01, -2.781502973762356e-03,  1.570064189863255e-05, -5.980039589126142e-08,
  7.370268064181406e-10,  1.343739131276768e-11, -6.582382653912725e-14, -1.046301279989030e-14, -1.948384481706217e-16,  2.620178048029823e-18,  1.750639680356837e-19,
  2.060064522718992e-21,  4.347218933100074e-01, -3.597391912904208e-03,  1.939453578762871e-05, -6.084130777787955e-08,  8.295092862195702e-10,  1.974283394467051e-11,
 -9.630958602237318e-14, -1.443843279098215e-14, -2.698597995416096e-16,  3.599814654628968e-18,  2.427829988101218e-19,  2.890804187871871e-21,  5.523879034017707e-01,
 -4.525871344676704e-03,  2.286177611208295e-05, -4.885924613629812e-08,  8.466228030759001e-10,  2.851738959258185e-11, -1.349826871223760e-13, -1.976684236004280e-14,
 -3.696912138423590e-16,  4.887156734304024e-18,  3.336031649056530e-19,  4.030390083812420e-21,  6.886378558816723e-01, -5.566089429355215e-03,  2.549852011445267e-05,
 -1.345556056892821e-08,  7.370140942192241e-10,  4.055503659536124e-11, -1.773889863332591e-13, -2.720080491016501e-14, -5.064360352479885e-16,  6.632924000555859e-18,
  4.594709338406223e-19,  5.652591712233467e-21,  8.462867308910883e-01, -6.708921633653072e-03,  2.615318752334094e-05,  6.389899243932549e-08,  4.444175661976576e-10,
  5.638697775979638e-11, -2.032617531603745e-13, -3.822038020379439e-14, -7.037233287694525e-16,  9.147446563407756e-18,  6.432446348055066e-19,  8.096159235683513e-21,
  1.029412595497582e+00, -7.921795210655037e-03,  2.241738554204269e-05,  2.181980506426899e-07, -7.120513997291520e-12,  7.415615860587252e-11, -1.406462630112750e-13,
 -5.593863554183706e-14, -1.019450386754031e-15,  1.323397833175246e-17,  9.354275964255884e-19,  1.210169120726275e-20,  1.244222287846106e+00, -9.097984246567914e-03,
  8.540041148298105e-06,  5.172781289725967e-07,  7.636643404530188e-11,  7.849958993850262e-11,  2.265186961782720e-13, -8.625538443276667e-14, -1.659825612262343e-15,
  2.157041302001906e-17,  1.484751889400426e-18,  1.947901409602131e-20,  1.500527386691161e+00, -9.836139038886541e-03, -3.206002542160031e-05,  1.043908250682387e-06,
  6.944694299465525e-09, -1.226371524841995e-11,  4.937730866857432e-13, -1.188130017248352e-13, -3.596437080753415e-15,  3.761565882576638e-17,  3.148654716578218e-18,
  3.685080730888312e-20,  1.809013959237974e+00, -7.941793502316542e-03, -1.481709907524583e-04,  1.454603776025522e-07,  7.191056905736711e-08,  1.025369567897114e-09,
 -2.882829327253995e-11, -1.167374873262866e-12, -5.529655010860729e-16,  7.998148015507887e-16,  1.478719841682573e-17, -2.928208011111678e-19,  1.369975901068739e-03,
 -1.145819966156804e-05,  7.144830896498657e-08, -3.271787571181110e-10,  4.911895759218811e-12,  1.728523568066179e-14, -1.439473744999883e-15, -4.950137004091194e-17,
  1.347209276314191e-19,  3.579313150592359e-20,  5.359565047743870e-22, -1.408350433620988e-23,  1.234857864502595e-02, -1.032353399596742e-04,  6.420408431079693e-07,
 -2.914538838782867e-09,  4.405220178791838e-11,  1.601705753475030e-13, -1.307058821117762e-14, -4.484176394446416e-16,  1.218328727597601e-18,  3.244440337673274e-19,
  4.861063356053637e-21, -1.276208865822210e-22,  3.440707867775269e-02, -2.873870211659464e-04,  1.777703919593029e-06, -7.924270555943787e-09,  1.214820520658124e-10,
  4.710068657277047e-13, -3.696063151323040e-14, -1.262134507489125e-15,  3.417670772504587e-18,  9.143397821466495e-19,  1.371612514453663e-20, -3.594444895817964e-22,
  6.775324864097337e-02, -5.651197428756074e-04,  3.466275392594124e-06, -1.500314441510224e-08,  2.353756632881566e-10,  1.002472764880921e-12, -7.442874171617128e-14,
 -2.524388796265116e-15,  6.802015154409293e-18,  1.832160444091991e-18,  2.753651948170032e-20, -7.196187746104989e-22,  1.127123573550744e-01, -9.382707456696572e-04,
  5.686431774840612e-06, -2.355775030734316e-08,  3.826594899375258e-10,  1.840335907900540e-12, -1.276235275515951e-13, -4.291201951890896e-15,  1.148943614478262e-17,
  3.122009620609413e-18,  4.704574826632609e-20, -1.224795260354905e-21,  1.697454777743303e-01, -1.409334659857858e-03,  8.403081595806369e-06, -3.266096282970495e-08,
  5.585366973599080e-10,  3.112661253904020e-12, -1.997608235899068e-13, -6.648980603301194e-15,  1.766923060218007e-17,  4.851447094969646e-18,  7.335993117254318e-20,
 -1.900522476768047e-21,  2.394777105325185e-01, -1.981483109508615e-03,  1.155930080145129e-05, -4.089119834919480e-08,  7.557121736073942e-10,  5.004009759180810e-12,
 -2.955058590906717e-13, -9.728765214479608e-15,  2.564392053633834e-17,  7.121944658883493e-18,  1.081695417030916e-19, -2.785279386554880e-21,  3.227408508176692e-01,
 -2.658548459702684e-03,  1.506208312753607e-05, -4.605448461698432e-08,  9.631620546636462e-10,  7.776127282654767e-12, -4.215743941693903e-13, -1.373171829050279e-14,
  3.590983372107584e-17,  1.008726665297524e-17,  1.540593031439732e-19, -3.937636805733372e-21,  4.206383704517623e-01, -3.444901935943058e-03,  1.875628335688422e-05,
 -4.468867423379099e-08,  1.164229244509374e-09,  1.179546362212359e-11, -5.876688777091575e-13, -1.897680051271897e-14,  4.931851457366266e-17,  1.398723726530055e-17,
  2.150936329383629e-19, -5.449581657693890e-21,  5.346468727060851e-01, -4.345050917113857e-03,  2.237442665589862e-05, -3.113570856648884e-08,  1.333880861061995e-09,
  1.756020965169891e-11, -8.079022153320890e-13, -2.599587506172038e-14,  6.741667151991570e-17,  1.921414780621226e-17,  2.979521046821947e-19, -7.473127779574141e-21,
  6.667808125454523e-01, -5.362487932274428e-03,  2.543304573750877e-05,  4.306402505448548e-09,  1.435813444111235e-09,  2.568321503046059e-11, -1.102777108979027e-12,
 -3.573962443803533e-14,  9.319373353749013e-17,  2.645642170470389e-17,  4.143074593281814e-19, -1.027893576725624e-20,  8.198746307654295e-01, -6.496426087268020e-03,
  2.699790417875957e-05,  7.936264471960658e-08,  1.425519764833765e-09,  3.661653369002708e-11, -1.500992219247714e-12, -5.006930775882037e-14,  1.327158026430370e-16,
  3.705382998846744e-17,  5.863336484951464e-19, -1.440443943081389e-20,  9.981008167373959e-01, -7.731875916274391e-03,  2.508183055661177e-05,  2.291751825674372e-07,
  1.299199895721504e-09,  4.901654440552746e-11, -2.036302325609382e-12, -7.305604089093860e-14,  1.977193646400734e-16,  5.406215959137787e-17,  8.614102530232428e-19,
 -2.111366469520736e-20,  1.208006488271105e+00, -9.004697027389904e-03,  1.480500147796188e-05,  5.304396478474909e-07,  1.478717721902555e-09,  5.011062483158313e-11,
 -2.726943531658102e-12, -1.144160484807358e-13,  2.943237948992412e-16,  8.646475571143758e-17,  1.363186885031817e-18, -3.441763140537590e-20,  1.460751846730687e+00,
 -1.004064362958933e-02, -1.887604480455897e-05,  1.152365006164488e-06,  6.489909218331572e-09, -5.116329258146093e-11, -4.055258065855760e-12, -1.860853176289633e-13,
  2.022651833083018e-16,  1.707946031459308e-16,  2.668237199252104e-18, -7.738038368369959e-20,  1.774916399265005e+00, -9.099359358649408e-03, -1.389967186275789e-04,
  1.411721324047886e-06,  8.296625557499672e-08, -3.093357707860829e-11, -5.683207414980181e-11, -6.487858594121703e-13,  3.377148627262647e-14,  9.178235897318387e-16,
 -1.336887238911817e-17, -8.772497597505617e-19,  1.325263312481633e-03, -1.090096990360596e-05,  6.799780290706385e-08, -2.481459485982601e-10,  4.807842967496393e-12,
 -3.210808446821853e-14, -2.551396096044890e-15, -2.213795640133165e-17,  1.586444611340541e-18,  3.701828729481025e-20, -6.302044930392060e-22, -3.437188521299077e-23,
  1.194570550640366e-02, -9.822681651362805e-05,  6.113347405294758e-07, -2.205161367151455e-09,  4.317399302446004e-11, -2.880076266798014e-13, -2.314268772404646e-14,
 -2.004526268651034e-16,  1.437932328196161e-17,  3.356375105549808e-19, -5.712654548653295e-21, -3.117442302404550e-22,  3.328541873982993e-02, -2.735123661812430e-04,
  1.694398308094224e-06, -5.964767431471574e-09,  1.193726834174479e-10, -7.945678472219694e-13, -6.530733790003543e-14, -5.637035169592807e-16,  4.051883792242929e-17,
  9.463866569022907e-19, -1.610069141795280e-20, -8.796025155829418e-22,  6.554718129572883e-02, -5.380448899035423e-04,  3.309118194433284e-06, -1.119654309517833e-08,
  2.322440025835867e-10, -1.540875916955887e-12, -1.311167667780714e-13, -1.125957095187040e-15,  8.118000207214369e-17,  1.897908381154421e-18, -3.226819017191858e-20,
 -1.765831582971251e-21,  1.090486159211323e-01, -8.938044588613299e-04,  5.441042909666195e-06, -1.734583920163887e-08,  3.797960429182769e-10, -2.509508486156202e-12,
 -2.239684446172180e-13, -1.910581572819767e-15,  1.383105225090304e-16,  3.237600826784406e-18, -5.500189497502892e-20, -3.016813003001346e-21,  1.642403244226223e-01,
 -1.343523074360197e-03,  8.065814781061686e-06, -2.354676179083594e-08,  5.588394616235514e-10, -3.675447488231401e-12, -3.490036719245560e-13, -2.953648748669619e-15,
  2.149058750440643e-16,  5.038157051545436e-18, -8.551494525379516e-20, -4.704210004121340e-21,  2.317339157046761e-01, -1.890761266099681e-03,  1.114296727247911e-05,
 -2.847218359250358e-08,  7.643748357353293e-10, -5.005303123964737e-12, -5.138061922273098e-13, -4.309937870526711e-15,  3.154890323071570e-16,  7.408863789986305e-18,
 -1.256466955973765e-19, -6.936838364083373e-21,  3.123445303452182e-01, -2.539992805270699e-03,  1.460490288037173e-05, -3.007320376207333e-08,  9.885782411413710e-10,
 -6.458646332057498e-12, -7.295689495993332e-13, -6.063721486765096e-15,  4.469594440478397e-16,  1.051535097905725e-17, -1.782212208346816e-19, -9.881748367341891e-21,
  4.071559302807740e-01, -3.296667966431085e-03,  1.833661602678784e-05, -2.511107843195303e-08,  1.219122593894278e-09, -7.997147608727734e-12, -1.013087449773406e-12,
 -8.349043151146787e-15,  6.201615451923936e-16,  1.461551769906125e-17, -2.477232109427487e-19, -1.380331814129766e-20,  5.176228308879148e-01, -4.167168535679797e-03,
  2.213638142043456e-05, -8.271748650402248e-09,  1.436435059701500e-09, -9.619992266154965e-12, -1.390291316757732e-12, -1.139038897249120e-14,  8.529744240545632e-16,
  2.012902128922030e-17, -3.416703430621629e-19, -1.914058298147945e-20,  6.457387059061281e-01, -5.158398244598746e-03,  2.563396483248080e-05,  2.962870361807113e-08,
  1.609554654309268e-09, -1.148968884819641e-11, -1.902787789645721e-12, -1.559116042287454e-14,  1.176939754655320e-15,  2.778353511969670e-17, -4.736980770700875e-19,
 -2.667413345668611e-20,  7.943275264297606e-01, -6.276205037310869e-03,  2.810368798675022e-05,  1.056213483600497e-07,  1.692226036024167e-09, -1.439728890125197e-11,
 -2.620584018987025e-12, -2.174496686503870e-14,  1.653148132178162e-15,  3.896052480687573e-17, -6.715303504863192e-19, -3.793114687872896e-20,  9.675926110179124e-01,
 -7.519813541813154e-03,  2.797859025900528e-05,  2.544919644113567e-07,  1.637129189485973e-09, -2.171092810465644e-11, -3.667910980366358e-12, -3.158245534553820e-14,
  2.416217370089817e-15,  5.666126806982152e-17, -1.002060255967781e-18, -5.634393671305373e-20,  1.172265526404899e+00, -8.860345828441861e-03,  2.133094489759940e-05,
  5.575305819413793e-07,  1.585733686510463e-09, -4.956174260388481e-11, -5.279614788950394e-12, -4.898554825291276e-14,  3.820452205838523e-15,  8.898327558004038e-17,
 -1.676881941840318e-18, -9.151633020964978e-20,  1.420377171207569e+00, -1.013469380789478e-02, -4.480169114206994e-06,  1.241049336034171e-06,  4.101229424757478e-09,
 -2.040811830293311e-10, -8.155973127165908e-12, -7.002883529580615e-14,  7.043098802193908e-15,  1.661020749111732e-16, -3.731569025216554e-18, -1.841753910274643e-19,
  1.736433470333254e+00, -1.012155269669202e-02, -1.143626118206815e-04,  2.656483815369417e-06,  6.797777960714802e-08, -1.465758059314672e-09, -5.605902725551451e-11,
  7.856512004287449e-13,  4.861359531145433e-14, -2.832485936604793e-16, -4.085286961056696e-17, -8.801095680099916e-20,  1.282730292539353e-03, -1.036766175147019e-05,
  6.544933850775714e-08, -1.797788250972536e-10,  3.537147317790657e-12, -9.405667318066200e-14, -2.311258285424252e-15,  4.230473248714551e-17,  2.133309597172436e-18,
 -1.395245848200760e-20, -1.691807246599769e-21, -3.680482089253306e-24,  1.156242775207893e-02, -9.343088208504206e-05,  5.887269765012664e-07, -1.591487247649163e-09,
  3.171324419301258e-11, -8.498423780289465e-13, -2.095998008690602e-14,  3.836871614411338e-16,  1.933729683140470e-17, -1.265563541389241e-19, -1.534261562317238e-20,
 -3.339195502103443e-23,  3.221806985723484e-02, -2.602127949200473e-04,  1.633473050358655e-06, -4.269481551218574e-09,  8.739783501889343e-11, -2.379606370773591e-12,
 -5.912228141019052e-14,  1.082537914726787e-15,  5.449647605411160e-17, -3.571593884822949e-19, -4.328048219530965e-20, -9.426999334374899e-23,  6.344718134796729e-02,
 -5.120496903074021e-04,  3.195469244025848e-06, -7.902901369947170e-09,  1.691455591034180e-10, -4.721863295834410e-12, -1.186215217866988e-13,  2.172950550101579e-15,
  1.092030394647744e-16, -7.172934950745548e-19, -8.685722996001090e-20, -1.893615277475637e-22,  1.055592748491865e-01, -8.510111728145306e-04,  5.266725518343679e-06,
 -1.197068909973504e-08,  2.744865703908636e-10, -7.940274675601630e-12, -2.024460083766373e-13,  3.711318416040067e-15,  1.860909207808607e-16, -1.226313845523264e-18,
 -1.483182868351772e-19, -3.235932006374468e-22,  1.589936990169630e-01, -1.279983416068860e-03,  7.832963135770243e-06, -1.566080367011375e-08,  3.994807035811158e-10,
 -1.213256766707429e-11, -3.151129126521275e-13,  5.784071514896735e-15,  2.891983695522566e-16, -1.914532535058069e-18, -2.311262006374851e-19, -5.042346591866641e-22,
  2.243472720987022e-01, -1.802788354542623e-03,  1.086915051787232e-05, -1.773084289810092e-08,  5.379493651055607e-10, -1.744651126401321e-11, -4.632756210154062e-13,
  8.521021864714615e-15,  4.245950560423617e-16, -2.828857462257645e-18, -3.405249493026593e-19, -7.415515082843386e-22,  3.024163106987170e-01, -2.424344355642399e-03,
  1.433150430040237e-05, -1.626550896423832e-08,  6.801481303942201e-10, -2.410929069142518e-11, -6.567350990941579e-13,  1.211863944639033e-14,  6.014795266104572e-16,
 -4.043179310627796e-18, -4.845383360475819e-19, -1.049575026221392e-21,  3.942611768706321e-01, -3.150869718979218e-03,  1.814265320352755e-05, -8.239537232717436e-09,
  8.104143548251296e-10, -3.248470063072721e-11, -9.101597725994674e-13,  1.688227725023825e-14,  8.341774356995938e-16, -5.678534959559004e-18, -6.758130260562335e-19,
 -1.446541620590369e-21,  5.013082273127006e-01, -3.990110505748493e-03,  2.216264995817227e-05,  1.131346118888751e-08,  9.028421149986363e-10, -4.319403740358032e-11,
 -1.246107920653468e-12,  2.330757682510803e-14,  1.146004930633386e-15, -7.945302766554967e-18, -9.352451399931882e-19, -1.953083045469570e-21,  6.255180823972289e-01,
 -4.951500523998472e-03,  2.612820711671423e-05,  5.100024312686639e-08,  9.129928460997240e-10, -5.740103863267219e-11, -1.700536065872208e-12,  3.225120768053955e-14,
  1.577363013331810e-15, -1.124074598606189e-17, -1.299760522432137e-18, -2.580233173881618e-21,  7.696809848320514e-01, -6.045890049276571e-03,  2.951275093479573e-05,
  1.268908429662354e-07,  7.614871950631929e-10, -7.758750436562322e-11, -2.333076626724668e-12,  4.533371869987411e-14,  2.204574407525095e-15, -1.640629284693813e-17,
 -1.841063212917990e-18, -3.271872263623939e-21,  9.379809007140180e-01, -7.283388762781111e-03,  3.115943807451108e-05,  2.723063437402857e-07,  3.027514460418271e-10,
 -1.101234138938429e-10, -3.245153012725431e-12,  6.607384939800543e-14,  3.190160694851821e-15, -2.554071163280311e-17, -2.718735955956485e-18, -3.615622345667238e-21,
  1.137208262300767e+00, -8.662626736690887e-03,  2.811792527518100e-05,  5.679018842353644e-07, -7.020451400316983e-10, -1.766074112657198e-10, -4.593764757029393e-12,
  1.042259537859885e-13,  4.942013136519761e-15, -4.535875745305014e-17, -4.370975514013851e-18, -1.027744009938733e-21,  1.379862110293065e+00, -1.011022980134127e-02,
  1.063640632509733e-05,  1.263229830122016e-06, -1.946535340849769e-09, -3.937596562390854e-10, -6.352816170035793e-12,  2.079250027143901e-13,  8.654029723531517e-15,
 -1.098093597822625e-16, -8.490385568627775e-18,  2.739837705311678e-20,  1.694341978036800e+00, -1.089310607292786e-02, -7.713556656117285e-05,  3.446918641964629e-06,
  2.781866678867075e-08, -2.391772867625574e-09, -1.596848025880198e-11,  1.883363427989884e-12,  1.233585389631171e-14, -1.532288337627424e-15, -1.135968197394151e-17,
  1.258836868972358e-18,  1.242294319936609e-03, -9.851894341471314e-06,  6.356113100640518e-08, -1.407163508275089e-10,  1.233488189456432e-12, -1.285176755185558e-13,
 -3.362267004615837e-16,  9.022212883762942e-17,  5.355745616306457e-19, -6.726157237440905e-20, -5.728605299700480e-22,  4.928647042516643e-23,  1.119801318127506e-02,
 -8.879027806142170e-05,  5.720369783825887e-07, -1.242566095197349e-09,  1.088458285485023e-11, -1.162376507574747e-12, -3.052125102686596e-15,  8.179336217909562e-16,
  4.847434686771696e-18, -6.099439025624481e-19, -5.190530778969843e-21,  4.471506262172799e-22,  3.120305800533693e-02, -2.473302266264687e-04,  1.588845318981514e-06,
 -3.315365263857251e-09,  2.899688480316001e-11, -3.261272449017188e-12, -8.624686675868836e-15,  2.305761863770369e-15,  1.361917493558648e-17, -1.720405517852816e-18,
 -1.461525083151826e-20,  1.262435577672962e-21,  6.144956385498156e-02, -4.868273204423531e-04,  3.113327403156111e-06, -6.079499629955577e-09,  5.302125435779961e-11,
 -6.491014445674606e-12, -1.734322653706920e-14,  4.622316500654927e-15,  2.715977949045875e-17, -3.451961046902458e-18, -2.924499542810913e-20,  2.536802781425075e-21,
  1.022386755927343e-01, -8.093908641911220e-04,  5.143455987859980e-06, -9.066817732590292e-09,  7.866960259730564e-11, -1.095975708596848e-11, -2.966039268124523e-14,
  7.880882357520158e-15,  4.596696226319413e-17, -5.893145472300012e-18, -4.972822165036689e-20,  4.339761384853332e-21,  1.539980286845658e-01, -1.217983536890126e-03,
  7.674237825877559e-06, -1.154878448796430e-08,  9.922690694217336e-11, -1.683193298881931e-11, -4.621088713187649e-14,  1.225464521700952e-14,  7.077375746272318e-17,
 -9.180434818774373e-18, -7.703620351518944e-20,  6.779174580631709e-21,  2.173088448268481e-01, -1.716569844261330e-03,  1.069483564394909e-05, -1.241257751327430e-08,
  1.043584545775850e-10, -2.435239103019680e-11, -6.782412243104934e-14,  1.800284678639742e-14,  1.026203793001396e-16, -1.352042320486850e-17, -1.125798022171691e-19,
  1.001975396424664e-20,  2.929472078953507e-01, -2.310329553627390e-03,  1.418332928471153e-05, -9.945523840240400e-09,  7.802308731719279e-11, -3.388886373519597e-11,
 -9.550019894436606e-14,  2.551614313337425e-14,  1.429597243620563e-16, -1.922902786338597e-17, -1.583938770847088e-19,  1.431615420050698e-20,  3.819475918466200e-01,
 -3.005959641678720e-03,  1.809685497218772e-05, -1.446542046566542e-09, -5.307343003590377e-12, -4.601017978007385e-11, -1.302564177032772e-13,  3.539824047373440e-14,
  1.938016247986544e-16, -2.680377142813094e-17, -2.174244706672303e-19,  2.007489784470662e-20,  4.857034960250172e-01, -3.812095513886712e-03,  2.235208603049426e-05,
  1.751352917192456e-08, -1.878688680541184e-10, -6.164072207450021e-11, -1.725533114579327e-13,  4.862147348456855e-14,  2.578710424740730e-16, -3.706571968910852e-17,
 -2.939579089194742e-19,  2.797815730874503e-20,  6.061342273657836e-01, -4.739878264070275e-03,  2.678385808960513e-05,  5.460786190903533e-08, -5.433982566553031e-10,
 -8.239618845330087e-11, -2.203172199149945e-13,  6.684721417690448e-14,  3.385991827398686e-16, -5.146286531998756e-17, -3.941567287369979e-19,  3.925412907467989e-20,
  7.459793876409359e-01, -5.803625169870064e-03,  3.104898047013048e-05,  1.241814198401777e-07, -1.210308512817236e-09, -1.114157457414331e-10, -2.618235744054238e-13,
  9.315791106422213e-14,  4.389682474659295e-16, -7.279605597378854e-17, -5.260912934028932e-19,  5.634188249229139e-20,  9.093664576320800e-01, -7.021151180005579e-03,
  3.437196935287071e-05,  2.561174206031247e-07, -2.475344110178124e-09, -1.558442886341354e-10, -2.465005277241255e-13,  1.339883023997737e-13,  5.535412342831809e-16,
 -1.072451453699529e-16, -6.947249254534129e-19,  8.481627690369417e-20,  1.103050137611148e+00, -8.410916232630732e-03,  3.473280625024178e-05,  5.237046364419537e-07,
 -5.018594866135125e-09, -2.366284578090804e-10,  6.702893864965068e-14,  2.054569900340893e-13,  6.110756970509559e-16, -1.714141785766710e-16, -8.549739182743274e-19,
  1.404599882150049e-19,  1.339685789130392e+00, -9.965673428207127e-03,  2.532819880683319e-05,  1.163273541205044e-06, -1.073661152411608e-08, -4.508931492528277e-10,
  2.328883563792362e-12,  3.646168293925273e-13, -1.925070855949617e-16, -3.262188305126479e-16, -3.493125466413768e-19,  2.867232881295337e-19,  1.649803179060556e+00,
 -1.134085264114914e-02, -3.469849537910491e-05,  3.506581100568105e-06, -1.956609947257532e-08, -2.148965514546222e-09,  3.401340513253910e-11,  1.417546134531697e-12,
 -3.766425132984047e-14, -9.160708589957299e-16,  3.681217870313218e-17,  5.549789631235193e-19,  1.203893243994679e-03, -9.350018061036450e-06,  6.190707448046212e-08,
 -1.411173903754913e-10, -1.212644923852586e-12, -1.066218332172264e-13,  2.060016145682330e-15,  6.861811227652456e-17, -1.756169496240179e-18, -4.601224822169309e-20,
  1.486993490490436e-21,  2.965636218040742e-23,  1.085191209094593e-02, -8.427241845517445e-05,  5.574124991675377e-07, -1.250536945138560e-09, -1.123791267086434e-11,
 -9.640017924054451e-13,  1.866752739511380e-14,  6.217748531781287e-16, -1.592978716800870e-17, -4.169544841686275e-19,  1.349218290657655e-20,  2.687868740378695e-22,
  3.023891129746030e-02, -2.347756346864445e-04,  1.549716239171552e-06, -3.362378749721611e-09, -3.306301737394663e-11, -2.702738907407220e-12,  5.257927858890507e-14,
  1.751048099108411e-15, -4.495681171374546e-17, -1.174350270029993e-18,  3.810072906327000e-20,  7.572965761027991e-22,  5.955161320558001e-02, -4.622078882773689e-04,
  3.041227324883619e-06, -6.248071308692008e-09, -7.046896230170973e-11, -5.373207058401185e-12,  1.052764654958946e-13,  3.504847410981996e-15, -9.028298820181170e-17,
 -2.350938076241369e-18,  7.658760636471449e-20,  1.516805267477244e-21,  9.908272674105532e-02, -7.686735598215573e-04,  5.035054321385008e-06, -9.524894981557547e-09,
 -1.297619886536083e-10, -9.057531978197505e-12,  1.792223015996426e-13,  5.962535063741857e-15, -1.543136596281464e-16, -4.000480986148380e-18,  1.310819362196351e-19,
  2.582778400849365e-21,  1.492480092256049e-01, -1.157142378256786e-03,  7.534195044855922e-06, -1.259725439251291e-08, -2.207110927933813e-10, -1.387910891380062e-11,
  2.782229847457674e-13,  9.244169682914854e-15, -2.407663766574101e-16, -6.204505907206231e-18,  2.048917261925451e-19,  4.008887240591713e-21,  2.106127310576884e-01,
 -1.631615310037721e-03,  1.054001556643394e-05, -1.455549325574238e-08, -3.581690412482585e-10, -2.001872662261042e-11,  4.080624474215224e-13,  1.352688349096944e-14,
 -3.552876304304880e-16, -9.083663959845966e-18,  3.030761652303946e-19,  5.874273703496513e-21,  2.839320295994166e-01, -2.197370187689350e-03,  1.404937101809425e-05,
 -1.400006058710161e-08, -5.649033530953487e-10, -2.774212007767763e-11,  5.776379438113639e-13,  1.907245185813219e-14, -5.065475285358216e-16, -1.281691695218232e-17,
  4.334709664079977e-19,  8.295596258274275e-21,  3.702130994433049e-01, -2.861325034773165e-03,  1.804899572768469e-05, -8.724999361508926e-09, -8.767264758347296e-10,
 -3.744889927582740e-11,  8.010877820793275e-13,  2.627496268648679e-14, -7.082678917843018e-16, -1.767481523978079e-17,  6.086090667469407e-19,  1.144731776303157e-20,
  4.708138836807266e-01, -3.632582122131705e-03,  2.250407121243790e-05,  4.883657641981960e-09, -1.352331897971972e-09, -4.976496308582305e-11,  1.102061581960780e-12,
  3.574680092145699e-14, -9.832284591104762e-16, -2.407964285333886e-17,  8.495628034434977e-19,  1.559661200908455e-20,  5.876070339664835e-01, -4.523257963684722e-03,
  2.733341724894851e-05,  3.307891348953623e-08, -2.093642640981503e-09, -6.573284919012474e-11,  1.523125325240667e-12,  4.848228718802764e-14, -1.371895690030304e-15,
 -3.271970926966732e-17,  1.194335971184269e-18,  2.116394739523481e-20,  7.232704229858239e-01, -5.549768982414626e-03,  3.235075082564337e-05,  8.753251098101678e-08,
 -3.292381201135116e-09, -8.725408234224611e-11,  2.149245005253393e-12,  6.618830329624351e-14, -1.953298278642117e-15, -4.477748340607771e-17,  1.718466771158489e-18,
  2.882177054779990e-20,  8.818500115790417e-01, -6.734787735678742e-03,  3.710731818257222e-05,  1.925208702456127e-07, -5.352400124552108e-09, -1.183127814112576e-10,
  3.177693339944630e-12,  9.198346531141350e-14, -2.904414420953150e-15, -6.238718087190025e-17,  2.594397023372256e-18,  3.958042040168478e-20,  1.069999610239790e+00,
 -8.109630507333935e-03,  4.038486568500993e-05,  4.075567380098863e-07, -9.281761220011754e-09, -1.694124381732914e-10,  5.189191438670924e-12,  1.317255297071642e-13,
 -4.715792222231368e-15, -8.922390463829506e-17,  4.307200737665149e-18,  5.399729425701488e-20,  1.300311774192241e+00, -9.710779983702662e-03,  3.797817240306762e-05,
  9.257051798482973e-07, -1.841666399893597e-08, -2.835389003487047e-10,  1.080472991001178e-11,  1.912227724540275e-13, -9.393775661579131e-15, -1.225256030885748e-16,
  8.779266669587334e-18,  5.660495869870388e-20,  1.604139704453321e+00, -1.145836894269916e-02,  4.257823290429704e-06,  2.904802548559528e-06, -5.196113695184905e-08,
 -1.012211165174755e-09,  5.403272471971107e-11, -1.246594501787857e-14, -4.263553526509180e-14,  5.719557543056236e-16,  2.733640259818529e-17, -8.058700472158450e-19,
  };
  constexpr double w[6144] = {  1.897754325036586e-01, -1.636718442580110e-03,  1.549818144551287e-05, -1.540646544283416e-07,  1.558284450423197e-09,
 -1.577383732941935e-11,  1.585882732737436e-13, -1.579242805916153e-15,  1.556510652443644e-17, -1.518811302750803e-19,  1.468024781131584e-21, -1.406364682193309e-23,
  1.848882153418306e-01, -3.136040135641431e-03,  5.757692430722057e-05, -9.795445999485795e-07,  1.556576755715502e-08, -2.346068248215513e-10,  3.388703177507772e-12,
 -4.723461932059342e-14,  6.385054141894570e-16, -8.401472447423508e-18,  1.079161388277186e-19, -1.356112063420470e-21,  1.756239953884898e-01, -5.860675035412515e-03,
  1.675455933585444e-04, -4.089264770417242e-06,  8.964542036339085e-08, -1.812616832499901e-09,  3.435333060880680e-11, -6.169179962364750e-13,  1.057934859328192e-14,
 -1.742569938685837e-16,  2.769332289102688e-18, -4.260588693112479e-20,  1.628912411702790e-01, -9.333376448259087e-03,  3.818418914822960e-04, -1.266527254793517e-05,
  3.648148212933518e-07, -9.453239973821442e-09,  2.251654907804703e-10, -5.001523602397412e-12,  1.046746436653659e-13, -2.079881584958502e-15,  3.946849975937598e-17,
 -7.184099341551084e-19,  1.478107510446555e-01, -1.298895151601087e-02,  7.251507965991050e-04, -3.142859141011185e-05,  1.148529682540645e-06, -3.694510356051731e-08,
  1.073839107410942e-09, -2.869957788105266e-11,  7.140933119176325e-13, -1.669493768155992e-14,  3.693600354432210e-16, -7.773603077879595e-18,  1.315140613121173e-01,
 -1.629450125641962e-02,  1.192014953414495e-03, -6.531510077921892e-05,  2.943563151959463e-06, -1.145973284545357e-07,  3.971112443344561e-09, -1.249598472514434e-10,
  3.621821147498186e-12, -9.771940816746566e-14,  2.474437327664360e-15, -5.915723944792688e-17,  1.149799056242905e-01, -1.883957860597628e-02,  1.740594592032894e-03,
 -1.171148998321422e-04,  6.349879964568033e-06, -2.926980075733976e-07,  1.185324420703687e-08, -4.311107242622466e-10,  1.430558055589427e-11, -4.382142021221894e-13,
  1.250462392227745e-14, -3.345966728740802e-16,  9.893923442043751e-02, -2.037856778288081e-02,  2.300066223918717e-03, -1.850768243721026e-04,  1.180393084714915e-05,
 -6.315231199243686e-07,  2.935288682117516e-08, -1.213600874926160e-09,  4.539652552038592e-11, -1.555978575301341e-12,  4.935032485815341e-14, -1.458698052539992e-15,
  8.385131123483029e-02, -2.082726869346179e-02,  2.787079431513180e-03, -2.617512422712746e-04,  1.923108983254204e-05, -1.172241090811234e-06,  6.149208596290255e-08,
 -2.845769373237565e-09,  1.182851402028508e-10, -4.475656363034611e-12,  1.557845581274601e-13, -5.025633974770857e-15,  6.993300486317817e-02, -2.022885072150803e-02,
  3.124136804791843e-03, -3.348065073833094e-04,  2.778466636026818e-05, -1.895973471480981e-06,  1.104668662787687e-07, -5.638664119840770e-09,  2.568927217803600e-10,
 -1.059417162387233e-11,  3.998412873259439e-13, -1.391887681842186e-14,  5.721573425636743e-02, -1.870790957187616e-02,  3.253936672146830e-03, -3.896251086793561e-04,
  3.584656326786099e-05, -2.692615460758610e-06,  1.715876092127642e-07, -9.524080177703536e-09,  4.693594060801863e-10, -2.083734082477903e-11,  8.428933793856765e-13,
 -3.131730142362583e-14,  4.560755295295150e-02, -1.642752667678690e-02,  3.146871630106188e-03, -4.127570464523573e-04,  4.135625710881578e-05, -3.364410211577096e-06,
  2.310141540581065e-07, -1.375157282841508e-08,  7.236634179478927e-10, -3.417034611469912e-11,  1.464746750791988e-12, -5.746875751398458e-14,  3.494610941521280e-02,
 -1.355741102970618e-02,  2.801944203513764e-03, -3.951107101305697e-04,  4.238083917411517e-05, -3.675566572925412e-06,  2.679936835685024e-07, -1.687754538788826e-08,
  9.364389459243029e-10, -4.647294456512470e-11,  2.087571159620412e-12, -8.558612438077905e-14,  2.503668882036629e-02, -1.025508862911703e-02,  2.243146956499700e-03,
 -3.340425783889329e-04,  3.772745698657005e-05, -3.434849601461041e-06,  2.621456503895697e-07, -1.723344880136491e-08,  9.955718697215089e-10, -5.131948203396432e-11,
  2.389130598986509e-12, -1.012917103504420e-13,  1.567586567581853e-02, -6.658527288120588e-03,  1.513758098827940e-03, -2.339992624535182e-04,  2.738185724379766e-05,
 -2.577747286315647e-06,  2.030282789469400e-07, -1.374868395120439e-08,  8.167254711289221e-10, -4.322012827069301e-11,  2.062406616152250e-12, -8.949215993821387e-14,
  6.672887195957555e-03, -2.890953499986207e-03,  6.713208838306994e-04, -1.059339522481733e-04,  1.264145873078218e-05, -1.212332830130618e-06,  9.716833097007829e-08,
 -6.689201142742436e-09,  4.035668625728105e-10, -2.166991335542948e-11,  1.048349807197018e-12, -4.608019121492225e-14,  1.834653890992782e-01, -1.519726944472892e-03,
  1.378922126859698e-05, -1.314632008215903e-07,  1.277557993338828e-09, -1.244673593188411e-11,  1.205949678927379e-13, -1.158416099560697e-15,  1.102083612911943e-17,
 -1.038599073484461e-19,  9.699108312308171e-22, -8.980782328561416e-24,  1.731963809306227e-01, -2.718538961875852e-03,  4.717504023816754e-05, -7.640219849164586e-07,
  1.159063804784831e-08, -1.670922759170502e-10,  2.312042509825684e-12, -3.091257356546763e-14,  4.012721567549900e-16, -5.075234888291251e-18,  6.271807938653648e-20,
 -7.588477122290613e-22,  1.545823660913324e-01, -4.694702178863760e-03,  1.260146192521760e-04, -2.905412192052281e-06,  6.041434010993186e-08, -1.162280346277560e-09,
  2.100965131057474e-11, -3.605634709181769e-13,  5.918943027619795e-15, -9.346247206260426e-17,  1.425747916412161e-18, -2.107985905040508e-20,  1.308279339183589e-01,
 -6.800017606356836e-03,  2.594773589950281e-04, -8.088732823262679e-06,  2.201441122962549e-07, -5.410923923321132e-09,  1.226210619720909e-10, -2.597862753610304e-12,
  5.196600408323947e-14, -9.887203715887552e-16,  1.799469538899213e-17, -3.146049269512415e-19,  1.054457870953200e-01, -8.432166199786812e-03,  4.377702527742965e-04,
 -1.779603874961745e-05,  6.135709530326032e-07, -1.870167890147737e-08,  5.168289694682230e-10, -1.317014488850513e-11,  3.131975964538013e-13, -7.012984989001159e-15,
  1.488763471431504e-16, -3.011547494502941e-18,  8.138119217460826e-02, -9.238477654771052e-03,  6.291933117734993e-04, -3.236512846633800e-05,  1.377300076957063e-06,
 -5.085614819795166e-08,  1.677411762396392e-09, -5.039008142255910e-11,  1.397824935596581e-12, -3.617623643371762e-14,  8.804277654779142e-16, -2.026686693645484e-17,
  6.052765697586933e-02, -9.170804676763804e-03,  7.923696601358455e-04, -5.022306446034864e-05,  2.579029183053093e-06, -1.130703942180717e-07,  4.370320313493854e-09,
 -1.521553360158834e-10,  4.845393247301015e-12, -1.427596604352013e-13,  3.926004759348723e-15, -1.014286010792381e-16,  4.368262466633113e-02, -8.409611045717221e-03,
  8.938274648123426e-04, -6.813177721632192e-05,  4.135607527273132e-06, -2.113845722810966e-07,  9.416653871131484e-09, -3.741769376439672e-10,  1.348410147715159e-11,
 -4.461958088534421e-13,  1.368872122875433e-14, -3.920639563881512e-16,  3.080093845439634e-02, -7.233462746531646e-03,  9.193671842757173e-04, -8.237929251471237e-05,
  5.796791040081387e-06, -3.395203655128901e-07,  1.716113315290695e-08, -7.671180051472152e-10,  3.086477534419108e-11, -1.132648043110256e-12,  3.830191484354727e-14,
 -1.202393061503150e-15,  2.134788022860680e-02, -5.906583605133498e-03,  8.745779215581168e-04, -9.015192185633424e-05,  7.217528188939564e-06, -4.763797225714158e-07,
  2.690855630742175e-08, -1.334314250436941e-09,  5.916285887926692e-11, -2.378443641177913e-12,  8.763719128102303e-14, -2.982543621243715e-15,  1.460518434351704e-02,
 -4.618440438688957e-03,  7.775343326177933e-04, -9.031146069216142e-05,  8.077343441775044e-06, -5.909896984288920e-07,  3.674940357171524e-08, -1.993624332917146e-09,
  9.616379091585733e-11, -4.184135767231425e-12,  1.660790214152420e-13, -6.061746853212358e-15,  9.869194303945021e-03, -3.472129779727464e-03,  6.496333090263466e-04,
 -8.333626017406005e-05,  8.178391638719131e-06, -6.525703824978302e-07,  4.400533065243009e-08, -2.575584248619606e-09,  1.334076693425553e-10, -6.206385285465056e-12,
  2.623530786008587e-13, -1.015921014990109e-14,  6.545247327120206e-03, -2.501019111526528e-03,  5.089135580436039e-04, -7.070887976437688e-05,  7.479766881661863e-06,
 -6.403131245995003e-07,  4.612165924744775e-08, -2.871689920954141e-09,  1.576394368402388e-10, -7.745107972431666e-12,  3.446456809378990e-13, -1.400523888218409e-14,
  4.170549037637132e-03, -1.693627148782210e-03,  3.671311878286195e-04, -5.420098770421288e-05,  6.071768350449363e-06, -5.485695897917929e-07,  4.156593946374319e-08,
 -2.714123873334734e-09,  1.558011321221421e-10, -7.983359856531263e-12,  3.695740805563193e-13, -1.558622825135360e-14,  2.399064763553341e-03, -1.014958081335062e-03,
  2.297570943463416e-04, -3.536929927186615e-05,  4.122519086237455e-06, -3.866526719641741e-07,  3.034650924189251e-08, -2.048192378390264e-09,  1.212896176293662e-10,
 -6.399508216457149e-12,  3.045214092754360e-13, -1.317891767534333e-14,  9.729698709719381e-04, -4.209227011974624e-04,  9.759084761429138e-05, -1.537590465332233e-05,
  1.832109993809520e-06, -1.754488687590259e-07,  1.404279610629018e-08, -9.654466765295382e-10,  5.817262477652335e-11, -3.119838851265966e-12,  1.507559605770692e-13,
 -6.619077264671189e-15,  1.775975845209586e-01, -1.415393861532932e-03,  1.232657447523240e-05, -1.128668477485145e-07,  1.055130993053060e-09, -9.905038190707146e-12,
  9.258378864723423e-14, -8.587934517508639e-16,  7.894646006896694e-18, -7.192777977257119e-20,  6.496334169359165e-22, -5.819762576919090e-24,  1.630230990187910e-01,
 -2.374894796385035e-03,  3.901821718363840e-05, -6.025618234446816e-07,  8.740413803782259e-09, -1.206918795887699e-10,  1.601901179895656e-12, -2.056944250182817e-14,
  2.567028240166614e-16, -3.124298900815604e-18,  3.718347392256875e-20, -4.336088541381704e-22,  1.376200550023404e-01, -3.811216587097820e-03,  9.626255759666188e-05,
 -2.100434800491401e-06,  4.149201300950829e-08, -7.605511860613372e-10,  1.312883918344306e-11, -2.155720377497327e-13,  3.391136504766508e-15, -5.138364320664517e-17,
  7.530860301000705e-19, -1.070938765964626e-20,  1.072396230766012e-01, -5.059874852523380e-03,  1.804328741957500e-04, -5.294005189104518e-06,  1.363104588230273e-07,
 -3.181509703724236e-09,  6.866381816636400e-11, -1.388709148609738e-12,  2.657168167197731e-14, -4.844340343441892e-16,  8.461287969351678e-18, -1.421667904813222e-19,
  7.757192472433644e-02, -5.641919707142304e-03,  2.726612518872219e-04, -1.040486109271769e-05,  3.387008856117111e-07, -9.788233736942013e-09,  2.573269785653842e-10,
 -6.255049887873247e-12,  1.422225331999199e-13, -3.050977180867886e-15,  6.216179491489731e-17, -1.208807845855786e-18,  5.247697411328855e-02, -5.448981402130012e-03,
  3.454316780574482e-04, -1.668006955577458e-05,  6.702508647145787e-07, -2.347233213594370e-08,  7.368636761281814e-10, -2.112998257456822e-11,  5.609194008299543e-13,
 -1.392237846937293e-14,  3.255877572181688e-16, -7.214661399802786e-18,  3.350833501508987e-02, -4.681994292083196e-03,  3.778003324518942e-04, -2.253592539091033e-05,
  1.095156808137225e-06, -4.563414775274422e-08,  1.682290828022081e-09, -5.602806315343341e-11,  1.711135796695296e-12, -4.845840625680139e-14,  1.283475251644669e-15,
 -3.199376601050475e-17,  2.041437549104164e-02, -3.660643051009931e-03,  3.655544184834817e-04, -2.634787737328662e-05,  1.519765867089866e-06, -7.411027523957729e-08,
  3.160143599295655e-09, -1.205367131875164e-10,  4.179885781899725e-12, -1.333864500157009e-13,  3.954005319527215e-15, -1.096225362829370e-16,  1.200869791008345e-02,
 -2.656194583313383e-03,  3.197158307885835e-04, -2.726670517515637e-05,  1.833754043743147e-06, -1.030059072398412e-07,  5.008029577934340e-09, -2.158833743557471e-10,
  8.395259113887172e-12, -2.983668675538185e-13,  9.789121600452680e-15, -2.986519878205404e-16,  6.905578080650225e-03, -1.820556590024662e-03,  2.576334812189692e-04,
 -2.547509020310676e-05,  1.962867691094787e-06, -1.250417176246641e-07,  6.833937212651331e-09, -3.286011439911000e-10,  1.415588186454970e-11, -5.538818394586019e-13,
  1.989464289776695e-14, -6.609990758150821e-16,  3.927274860913503e-03, -1.196911740586594e-03,  1.944564531050302e-04, -2.185139234320063e-05,  1.895384545878050e-06,
 -1.347897431590924e-07,  8.162609511395825e-09, -4.320041524037360e-10,  2.036148164016577e-11, -8.669189597432134e-13,  3.371536280261970e-14, -1.207212818824668e-15,
  2.228473990502742e-03, -7.636607384266278e-04,  1.391986812363929e-04, -1.742429832925376e-05,  1.671375020408940e-06, -1.305576615680985e-07,  8.631262413506780e-09,
 -4.959143220651137e-10,  2.524583439774660e-11, -1.155569723206248e-12,  4.810854670717205e-14, -1.836464719019772e-15,  1.264527399663017e-03, -4.749909363569249e-04,
  9.498213713342120e-05, -1.298056711323533e-05,  1.352029220824264e-06, -1.140807523563391e-07,  8.107006152600570e-09, -4.984362956758906e-10,  2.703977940944556e-11,
 -1.313871130750139e-12,  5.786021655063215e-14, -2.328418951470857e-15,  7.083065124928596e-04, -2.848418137277485e-04,  6.112073496881032e-05, -8.936064893874624e-06,
  9.919120539937706e-07, -8.884993088102274e-08,  6.678307891312532e-09, -4.327948034890503e-10,  2.466892645867800e-11, -1.255685280201118e-12,  5.776780411625085e-14,
 -2.422042069883398e-15,  3.707074005054686e-04, -1.561230399421273e-04,  3.517171954356830e-05, -5.389233766714022e-06,  6.253789551512550e-07, -5.841040921966939e-08,
  4.566376745608938e-09, -3.070624414342497e-10,  1.812029196518597e-11, -9.529277418121604e-13,  4.520464618926378e-14, -1.950628713331190e-15,  1.423725879720819e-04,
 -6.149506556601267e-05,  1.423299325748962e-05, -2.238662684975516e-06,  2.663093670079337e-07, -2.546254399478313e-08,  2.034935535675841e-09, -1.397010748422128e-10,
  8.406044414125645e-12, -4.502279364433433e-13,  2.172832474937449e-14, -9.528508865758066e-16,  1.721250426475335e-01, -1.321926188686496e-03,  1.106729746023469e-05,
 -9.745651980340585e-08,  8.774405923514268e-10, -7.945259767115116e-12,  7.171815593376653e-14, -6.430403907901628e-16,  5.717346612769874e-18, -5.041008618544845e-20,
  4.407383205305526e-22, -3.823786541302710e-24,  1.541051470477281e-01, -2.089465422939611e-03,  3.255316725258887e-05, -4.801173822466325e-07,  6.668771858373246e-09,
 -8.832386262199851e-11,  1.125900309809673e-12, -1.390100378861443e-14,  1.669714649415149e-16, -1.957621926786141e-18,  2.246080467493932e-20, -2.526844266943073e-22,
  1.237702939909935e-01, -3.131705342545201e-03,  7.458894532307695e-05, -1.542982423238179e-06,  2.899980342214105e-08, -5.071509818055771e-10,  8.370630293299434e-12,
 -1.316489776770022e-13,  1.986615550814375e-15, -2.891348997922602e-17,  4.074983907945084e-19, -5.578346740318504e-21,  8.953133307175096e-02, -3.837761106178417e-03,
  1.281484855143738e-04, -3.544219268974743e-06,  8.644580378971250e-08, -1.918150588813435e-09,  3.946567361249445e-11, -7.626588950787213e-13,  1.397005920114522e-14,
 -2.442281437004148e-16,  4.096540339612546e-18, -6.618797411066738e-20,  5.868892770339938e-02, -3.880896536350274e-03,  1.748019541102516e-04, -6.267655169382538e-06,
  1.927905251690831e-07, -5.286401384854311e-09,  1.322900775392336e-10, -3.069076751859351e-12,  6.675046246778865e-14, -1.372395354015753e-15,  2.684516051066079e-17,
 -5.019765146802036e-19,  3.515740901923679e-02, -3.334167003762979e-03,  1.967625422747697e-04, -8.920581364731083e-06,  3.385297912741687e-07, -1.124554277299591e-08,
  3.360365776514409e-10, -9.198657460850385e-12,  2.336779970075281e-13, -5.562266354803915e-15,  1.249829191846563e-16, -2.665601539068276e-18,  1.945671178500199e-02,
 -2.500803319098364e-03,  1.882633841057998e-04, -1.056087734925996e-05,  4.853898790073644e-07, -1.921284093217100e-08,  6.751885118602684e-10, -2.149996000556913e-11,
  6.294034306228060e-13, -1.712354289863455e-14,  4.365680308441686e-16, -1.049443194946368e-17,  1.008120337501547e-02, -1.678166086514298e-03,  1.571268539337208e-04,
 -1.069172557846172e-05,  5.852366228754965e-07, -2.719405233798681e-08,  1.108714940959383e-09, -4.055123172437437e-11,  1.351786351575739e-12, -4.155971380165104e-14,
  1.189243810040176e-15, -3.188565535103294e-17,  4.968049192773178e-03, -1.030987311326872e-03,  1.171929432153999e-04, -9.491027106961786e-06,  6.088323739249308e-07,
 -3.274074840352284e-08,  1.528655621126193e-09, -6.345107234319343e-11,  2.381484352676111e-12, -8.185791823537810e-14,  2.602316985131655e-15, -7.706183823311226e-17,
  2.370186453935553e-03, -5.930309921315443e-04,  7.995203167750954e-05, -7.563196512793360e-06,  5.595117318039375e-07, -3.432753570235812e-08,  1.811707747615885e-09,
 -8.432017018480039e-11,  3.523256691769537e-12, -1.339597101120069e-13,  4.683482317731465e-15, -1.517003717174969e-16,  1.115321136683482e-03, -3.263981211243462e-04,
  5.101187505844244e-05, -5.530450795557717e-06,  4.640881105137886e-07, -3.200662311788392e-08,  1.883775161887971e-09, -9.708200635385361e-11,  4.463315931082015e-12,
 -1.856509892473834e-13,  7.063624523780600e-15, -2.477638227461181e-16,  5.267857831480387e-04, -1.752980195650548e-04,  3.104359473696714e-05, -3.782421067992949e-06,
  3.538359142917118e-07, -2.700328383039535e-08,  1.746927583805723e-09, -9.836170340604426e-11,  4.913606428741181e-12, -2.209622046947072e-13,  9.047517083439600e-15,
 -3.400346508537728e-16,  2.527906567392988e-04, -9.313701584257302e-05,  1.826394442686907e-05, -2.450378762344179e-06,  2.508668751232376e-07, -2.083036234538819e-08,
  1.458289470313582e-09, -8.841454168024493e-11,  4.734159473313881e-12, -2.272372053828584e-13,  9.892925309380984e-15, -3.938570879041357e-16,  1.229302588256990e-04,
 -4.888950382985585e-05,  1.037059785151871e-05, -1.499673848753851e-06,  1.647591557959452e-07, -1.461667118900797e-08,  1.088793825479938e-09, -6.996844256992275e-11,
  3.956806720014522e-12, -1.999239233073227e-13,  9.133919360511339e-15, -3.804782965789594e-16,  5.790590710232423e-05, -2.426159916232572e-05,  5.435965123793499e-06,
 -8.285660589014181e-07,  9.567174614085220e-08, -8.894022133600674e-09,  6.922605155442798e-10, -4.635849383110654e-11,  2.725082031817505e-12, -1.427859014295485e-13,
  6.750116771841440e-15, -2.903317407404024e-16,  2.091474509614142e-05, -9.017842210600192e-06,  2.083190922045768e-06, -3.270445703458318e-07,  3.883478028904065e-08,
 -3.706691097860535e-09,  2.957463610284541e-10, -2.027147383563186e-11,  1.217937681182579e-12, -6.513926174993667e-14,  3.139359716004146e-15, -1.374901440906508e-16,
  1.670073297015664e-01, -1.237838556265835e-03,  9.977096709547134e-06, -8.460096155171923e-08,  7.343894871093615e-10, -6.420974528738394e-12,  5.602405714831620e-14,
 -4.860222700747000e-16,  4.183245882016629e-18, -3.572805030414530e-20,  3.026447684771335e-22, -2.545308683306208e-24,  1.462340421821635e-01, -1.850397142587014e-03,
  2.737808566900968e-05, -3.862029286673112e-07,  5.143848197597862e-09, -6.542864065899537e-11,  8.020017325652012e-13, -9.531708701278041e-15,  1.103108451369888e-16,
 -1.247127796102006e-18,  1.380791558984870e-20, -1.499995937539111e-22,  1.123298309986388e-01, -2.601874680267061e-03,  5.855463711594254e-05, -1.150349780655373e-06,
  2.060057416658624e-08, -3.441664408601796e-10,  5.437910851312726e-12, -8.200945474443759e-14,  1.188361426971252e-15, -1.662863665145614e-17,  2.255666723335198e-19,
 -2.974925680397143e-21,  7.599103619843191e-02, -2.961796409522800e-03,  9.279951801160742e-05, -2.422972900866391e-06,  5.605514765072581e-08, -1.183831900704446e-09,
  2.324436011919932e-11, -4.295958594500737e-13,  7.539699182116819e-15, -1.264926693152612e-16,  2.038958084937357e-18, -3.169887412733621e-20,  4.555052242383382e-02,
 -2.737933147157626e-03,  1.150972280651112e-04, -3.881719348980684e-06,  1.129290668074458e-07, -2.940466165247023e-09,  7.009295245691620e-11, -1.552943080300250e-12,
  3.232524932421617e-14, -6.372663520232580e-16,  1.197240612254546e-17, -2.153413556730753e-19,  2.440155786641616e-02, -2.110801121066641e-03,  1.160045425826754e-04,
 -4.939639763624804e-06,  1.770965018340074e-07, -5.581899400856888e-09,  1.588041066765538e-10, -4.150483898224642e-12,  1.009098305462163e-13, -2.303644227233179e-15,
  4.973530392171857e-17, -1.020921030848628e-18,  1.181711171689470e-02, -1.393947661581763e-03,  9.782728982613942e-05, -5.158248171056838e-06,  2.241378868450882e-07,
 -8.424618065021875e-09,  2.821334123890986e-10, -8.586566355914910e-12,  2.408579318487385e-13, -6.292664495164193e-15,  1.543666569964530e-16, -3.576852441178891e-18,
  5.250089865350086e-03, -8.087240366157322e-04,  7.086785947874620e-05, -4.546277239837642e-06,  2.358808731438927e-07, -1.043347572442491e-08,  4.063287200612212e-10,
 -1.423765853330780e-11,  4.558483333977130e-13, -1.349057123751820e-14,  3.723373520655292e-16, -9.646339006993006e-18,  2.179333926967924e-03, -4.226982099255015e-04,
  4.525515209375903e-05, -3.472916791700796e-06,  2.121077916341431e-07, -1.090193075321694e-08,  4.880745423225231e-10, -1.947968146539937e-11,  7.047061329510049e-13,
 -2.339745470263614e-14,  7.198607990497175e-16, -2.066704952583308e-17,  8.639414807393359e-04, -2.043098823664157e-04,  2.615866337841060e-05, -2.361000441322646e-06,
  1.673077668830254e-07, -9.865310976960344e-09,  5.018296133082564e-10, -2.256720256332134e-11,  9.131020602322401e-13, -3.368415049202411e-14,  1.144614799488845e-15,
 -3.609323762323806e-17,  3.353206216150419e-04, -9.385860896142466e-05,  1.406469143324731e-05, -1.466940891522841e-06,  1.187887344780872e-07, -7.926908929818021e-09,
  4.524870190136635e-10, -2.266387197372631e-11,  1.014561387063089e-12, -4.115933301195676e-14,  1.529695188933735e-15, -5.248502243752330e-17,  1.307946216088266e-04,
 -4.212301145248268e-05,  7.225590850765581e-06, -8.546587438384680e-07,  7.778581964666115e-08, -5.787100661510753e-09,  3.656344809570567e-10, -2.013854723477394e-11,
  9.855188878510125e-13, -4.347280996628019e-14,  1.748175424436963e-15, -6.459889879814134e-17,  5.246622502210944e-05, -1.891275330328266e-05,  3.628443718014798e-06,
 -4.768902001846591e-07,  4.789662105252333e-08, -3.906785391183260e-09,  2.690077276333475e-10, -1.605951238339530e-11,  8.475876084995819e-13, -4.013842079601032e-14,
  1.725503388942854e-15, -6.788778751248812e-17,  2.185882005926938e-05, -8.583835026124595e-06,  1.797254047684741e-06, -2.566996594506752e-07,  2.787683030760983e-08,
 -2.446496146732440e-09,  1.804096108969156e-10, -1.148485903169783e-11,  6.437918979839216e-13, -3.226178369500627e-14,  1.462612854038175e-15, -6.048753870724775e-17,
  9.156327827760355e-06, -3.813846035695756e-06,  8.492395629197540e-07, -1.286759140714378e-07,  1.477463881492395e-08, -1.366293240467560e-09,  1.058207167882094e-10,
 -7.053740546420099e-12,  4.128408345246461e-13, -2.154347667879413e-14,  1.014553336532573e-15, -4.348035010151961e-17,  3.085744291747998e-06, -1.327881351902014e-06,
  3.061012302685086e-07, -4.795584359451067e-08,  5.683165152310124e-09, -5.414150344682344e-10,  4.311983267279334e-11, -2.950491017009858e-12,  1.769786354480060e-13,
 -9.450585928171444e-15,  4.547873017294886e-16, -1.988937316641661e-17,  1.622094490598443e-01, -1.161892181965457e-03,  9.028373345197035e-06, -7.380939953974471e-08,
  6.183868926716185e-10, -5.225684059370472e-12,  4.411163913514874e-14, -3.706036978366725e-16,  3.090458678167163e-18, -2.559193731302397e-20,  2.101872174128782e-22,
 -1.715352868323621e-24,  1.392430037209693e-01, -1.648604151174553e-03,  2.319743295275162e-05, -3.134081914734132e-07,  4.008036252388083e-09, -4.902233895393013e-11,
  5.784750486282496e-13, -6.625183942341604e-15,  7.395037673950098e-17, -8.069808186057303e-19,  8.629905042099245e-21, -9.060789634412944e-23,  1.027790544532246e-01,
 -2.183531664622792e-03,  4.652195331495195e-05, -8.694261278654369e-07,  1.485641529771542e-08, -2.374113110808878e-10,  3.595114553736652e-12, -5.204563168009928e-14,
  7.249236306695028e-16, -9.761764632083230e-18,  1.275618638997151e-19, -1.622188796826758e-21,  6.546387516225266e-02, -2.322076946727440e-03,  6.841189124666507e-05,
 -1.688841097583507e-06,  3.710773105969713e-08, -7.467536116921067e-10,  1.400708058680248e-11, -2.478169084644161e-13,  4.170837079945583e-15, -6.720294506038751e-17,
  1.041750042619165e-18, -1.559396899066779e-20,  3.618347458482749e-02, -1.976702536650728e-03,  7.767728524370421e-05, -2.466851042748694e-06,  6.794482615249908e-08,
 -1.681436635718384e-09,  3.820863957560395e-11, -8.089759247381553e-13,  1.612571313657888e-14, -3.049847544931967e-16,  5.505668410438409e-18, -9.529190847978483e-20,
  1.749731611310413e-02, -1.379008885144043e-03,  7.062280643989199e-05, -2.825928863026071e-06,  9.576262569732337e-08, -2.865074979106048e-09,  7.763164822889656e-11,
 -1.937742410250616e-12,  4.509900307805569e-14, -9.875687386712547e-16,  2.048874200009639e-17, -4.048108045457814e-19,  7.486299110804173e-03, -8.087253123315938e-04,
  5.288629160206172e-05, -2.620469322561087e-06,  1.076298708246646e-07, -3.840828388005471e-09,  1.225512209613797e-10, -3.564042378656601e-12,  9.577023580554102e-14,
 -2.402136092568961e-15,  5.668258107285651e-17, -1.265604167373613e-18,  2.876870919662238e-03, -4.088290941292991e-04,  3.347759868307971e-05, -2.022453135637463e-06,
  9.937120169459236e-08, -4.180476682838949e-09,  1.553945497969224e-10, -5.212502413405039e-12,  1.601718654143636e-13, -4.559597561330581e-15,  1.212908275528248e-16,
 -3.034192670353097e-18,  1.012556950810201e-03, -1.828636298206080e-04,  1.839412168588732e-05, -1.334968865501715e-06,  7.749738543901580e-08, -3.801399941136756e-09,
  1.629650891621594e-10, -6.245990960017650e-12,  2.175296813763285e-13, -6.968238050571789e-15,  2.072517322654581e-16, -5.762474837786390e-18,  3.345737841910237e-04,
 -7.447181105221855e-05,  9.026767045608424e-06, -7.753404488072335e-07,  5.251115834859164e-08, -2.969840245823656e-09,  1.453383606238707e-10, -6.304354973217456e-12,
  2.466150926690608e-13, -8.813544865522755e-15,  2.906736244989817e-16, -8.911123161671355e-18,  1.069460257030809e-04, -2.851254996750794e-05,  4.082706355515310e-06,
 -4.084690493729410e-07,  3.183682357641617e-08, -2.050904969297049e-09,  1.133046312185346e-10, -5.504946821771346e-12,  2.395203255472617e-13, -9.461372043835597e-15,
  3.429361483374883e-16, -1.149265455903490e-17,  3.422039156468400e-05, -1.062668990828190e-05,  1.759998133591362e-06, -2.015215969065833e-07,  1.779939970547296e-08,
 -1.288008597734500e-09,  7.930992096391966e-11, -4.264886318402081e-12,  2.040983836098334e-13, -8.816896113741794e-15,  3.476770550417235e-16, -1.261373864310759e-17,
  1.134571628603881e-05, -3.990130718964492e-06,  7.469767605017895e-07, -9.594857204090214e-08,  9.433550527074507e-09, -7.544152663188730e-10,  5.100198690861455e-11,
 -2.993225568753696e-12,  1.554812021090329e-13, -7.254296697826905e-15,  3.075443358274904e-16, -1.194352175030910e-17,  3.993741402708772e-06, -1.545779236249679e-06,
  3.188997870564336e-07, -4.491527989234767e-08,  4.814384753683395e-09, -4.174106960131019e-10,  3.043449459556962e-11, -1.917146824876859e-12,  1.064157194852096e-13,
 -5.283968942433929e-15,  2.375035930478467e-16, -9.743613568746535e-18,  1.468000315356629e-06, -6.073532662631243e-07,  1.342897863053076e-07, -2.021048578487125e-08,
  2.305886067126180e-09, -2.119740581923191e-10,  1.632656234006235e-11, -1.082641301387333e-12,  6.305691160245257e-14, -3.275542958442041e-15,  1.535966907506625e-16,
 -6.556263357453568e-18,  4.574665284897567e-07, -1.964293451921053e-07,  4.517368955077932e-08, -7.060898850676695e-09,  8.349293626897024e-10, -7.937380273241526e-11,
  6.308948125713871e-12, -4.308743310292108e-13,  2.579849931920156e-14, -1.375269531922641e-15,  6.607369205905096e-17, -2.885145010088098e-18,  1.577009522297681e-01,
 -1.093047431208805e-03,  8.198753889652533e-06, -6.469713458358615e-08,  5.236738178292153e-10, -4.281149191375948e-12,  3.499152538518759e-14, -2.849640210939853e-16,
  2.303937886876681e-18, -1.851683750116889e-20,  1.475296636142692e-22, -1.169812275114538e-24,  1.329973736797373e-01, -1.477048002717505e-03,  1.979123341134405e-05,
 -2.564274368672624e-07,  3.152673734826888e-09, -3.712223599278411e-11,  4.221657067882708e-13, -4.664044108195160e-15,  5.026023817951448e-17, -5.298885611172135e-19,
  5.478243778560493e-21, -5.563845552346259e-23,  9.472846733319915e-02, -1.849380236468089e-03,  3.737230123930419e-05, -6.654734155777665e-07,  1.086526445269866e-08,
 -1.662872453568509e-10,  2.416060611781804e-12, -3.361036540919766e-14,  4.504316569001392e-16, -5.842389632799530e-18,  7.360909642671644e-20, -9.033237860164853e-22,
  5.715469499295736e-02, -1.846779986388671e-03,  5.126859851390733e-05, -1.198446671713566e-06,  2.504171743460966e-08, -4.807463450841098e-10,  8.623449093284561e-12,
 -1.461893966721173e-13,  2.361468185295950e-15, -3.657172298418003e-17,  5.455942797747489e-19, -7.868858402221032e-21,  2.935510727034288e-02, -1.457478576623329e-03,
  5.363064727726136e-05, -1.605708460320655e-06,  4.191466173761270e-08, -9.867408820607907e-10,  2.139243092925083e-11, -4.331518694257420e-13,  8.273683776534854e-15,
 -1.502054381186532e-16,  2.606805588132022e-18, -4.343583165733270e-20,  1.292823558400593e-02, -9.274017816603354e-04,  4.429767930388844e-05, -1.666791833746208e-06,
  5.341945739573297e-08, -1.517871341684512e-09,  3.918815982028045e-11, -9.345346516694705e-13,  2.082750773747967e-14, -4.375878274539162e-16,  8.725639625600896e-18,
 -1.659611814416332e-19,  4.933184624166238e-03, -4.870882715829744e-04,  2.967616818357787e-05, -1.381705005409316e-06,  5.364239153083528e-08, -1.817403012700022e-09,
  5.524771387821434e-11, -1.535206564198652e-12,  3.951412277731969e-14, -9.513691120339016e-16,  2.159014925163024e-17, -4.644205499759502e-19,  1.654672024218749e-03,
 -2.163048202909680e-04,  1.653090399333784e-05, -9.396169956769230e-07,  4.368801173318200e-08, -1.746921976972189e-09,  6.194092830609691e-11, -1.987821591659073e-12,
  5.858920593481763e-14, -1.603356068178882e-15,  4.108342589763918e-17, -9.917631719365684e-19,  4.975290101299695e-04, -8.335392333572781e-05,  7.859776290824893e-06,
 -5.385290758010254e-07,  2.967133810059036e-08, -1.387176141640698e-09,  5.687542978860912e-11, -2.090970797384549e-12,  7.003008897799232e-14, -2.162117419253425e-15,
  6.210263888733236e-17, -1.670602946919866e-18,  1.376540735311805e-04, -2.871763010775854e-05,  3.285352279828054e-06, -2.678835170257442e-07,  1.730279863329166e-08,
 -9.368202372269077e-10,  4.403000286909455e-11, -1.839274815290097e-12,  6.945527355470355e-14, -2.401258837479065e-15,  7.675799551243933e-17, -2.284784495197763e-18,
  3.624445859963079e-05, -9.163768776986237e-06,  1.249498991877588e-06, -1.195641995466509e-07,  8.946705583801035e-09, -5.550926876902688e-10,  2.961805057863014e-11,
 -1.393158075482571e-12,  5.881055208827863e-14, -2.258186948640444e-15,  7.969965958779601e-17, -2.604916067373632e-18,  9.464063306115627e-06, -2.822470952289979e-06,
  4.497934518941699e-07, -4.970646167225792e-08,  4.249312015133947e-09, -2.983635897634109e-10,  1.786618893753917e-11, -9.361462960775619e-13,  4.372910865712497e-14,
 -1.846831710050836e-15,  7.129980562579385e-17, -2.535929065078049e-18,  2.565917518951130e-06, -8.775823427342718e-07,  1.598450065487426e-07, -2.001406462119611e-08,
  1.921800703561063e-09, -1.503651733401408e-10,  9.961406581877298e-12, -5.737120518145193e-13,  2.928306046710645e-14, -1.344087835314384e-15,  5.611732916220913e-17,
 -2.148395834079672e-18,  7.521729371668255e-07, -2.863432682677930e-07,  5.808973423123432e-08, -8.053176142060772e-09,  8.505898680628494e-10, -7.274587236852510e-11,
  5.237212560382817e-12, -3.260363445459973e-13,  1.789969640926024e-14, -8.797327926415705e-16,  3.916559597917559e-17, -1.592488172073824e-18,  2.390826552801819e-07,
 -9.815145109249649e-08,  2.152744766907162e-08, -3.215027148428336e-09,  3.641777263444120e-10, -3.325329331610011e-11,  2.545188662687751e-12, -1.677897208647306e-13,
  9.719335883994623e-15, -5.023011077192299e-16,  2.344125083732470e-17, -9.961116926119525e-19,  6.818619846007115e-08, -2.920597642602171e-08,  6.698851193019574e-09,
 -1.044372696441620e-09,  1.231905477418456e-10, -1.168400131311876e-11,  9.266407143875900e-13, -6.315321979158103e-14,  3.773783711747951e-15, -2.007946264462566e-16,
  9.629760705608590e-18, -4.197757372659470e-19,  1.534552184539633e-01, -1.030426647057741e-03,  7.469976138784949e-06, -5.696027889957812e-08,  4.458430845853817e-10,
 -3.529347035676389e-12,  2.795205667524293e-14, -2.208582079262135e-16,  1.732237923302227e-18, -1.352763160579039e-20,  1.045644278684084e-22, -8.072083350121344e-25,
  1.273874934035070e-01, -1.330222182254234e-03,  1.699392948535146e-05, -2.114150545299332e-07,  2.501840347425692e-09, -2.839186146309829e-11,  3.114972318206308e-13,
 -3.322997314563839e-15,  3.460324954649297e-17, -3.527814605788324e-19,  3.528967723244544e-21, -3.469918273045674e-23,  8.788219022894525e-02, -1.579622963940904e-03,
  3.032933271018035e-05, -5.153775715517182e-07,  8.050807008927492e-09, -1.181419062897632e-10,  1.648787037015895e-12, -2.206298274421038e-14,  2.847610648542827e-16,
 -3.560863400948312e-18,  4.329233680672728e-20, -5.130969931959551e-22,  5.050552756923186e-02, -1.488009303452887e-03,  3.900691208488484e-05, -8.647059492052412e-07,
  1.720432856176128e-08, -3.154452722232875e-10,  5.416677143005168e-12, -8.807019301755724e-14,  1.366612114010573e-15, -2.035885027853043e-17,  2.925142853795393e-19,
 -4.067555918900052e-21,  2.427557298121309e-02, -1.095443714939160e-03,  3.781496784513454e-05, -1.068699627920927e-06,  2.646740619239384e-08, -5.933036305738070e-10,
  1.228228201566832e-11, -2.380096742817662e-13,  4.359371489591526e-15, -7.601561664077365e-17,  1.268978439762682e-18, -2.036569035576929e-20,  9.818556631646365e-03,
 -6.405106742816601e-04,  2.856676964625939e-05, -1.011545672910086e-06,  3.068287544260537e-08, -8.285062069725742e-10,  2.039223833175384e-11, -4.648233824077360e-13,
  9.923628400666242e-15, -2.001099948929409e-16,  3.836218406429287e-18, -7.025549969629242e-20,  3.372109345778027e-03, -3.037677977910852e-04,  1.724473281659860e-05,
 -7.545664818235609e-07,  2.769497941104910e-08, -8.909510436494794e-10,  2.580643568951573e-11, -6.852189924649025e-13,  1.689333193115474e-14, -3.904145995170648e-16,
  8.520291921562158e-18, -1.765501766625759e-19,  9.963741530758026e-04, -1.194871679285922e-04,  8.514393534327868e-06, -4.550442161209954e-07,  2.001099642886709e-08,
 -7.601913824331213e-10,  2.569959787425415e-11, -7.887164413846412e-13,  2.228764007905381e-14, -5.860660065015534e-16,  1.445808652167593e-17, -3.366386805855702e-19,
  2.580606910400268e-04, -3.996424098193600e-05,  3.525441325240596e-06, -2.276976243072031e-07,  1.189173938032523e-08, -5.292799280629333e-10,  2.073317515828142e-11,
 -7.304250700103414e-13,  2.350277929799628e-14, -6.987209464382217e-16,  1.936419226387729e-17, -5.035365960342215e-19,  6.013913689759009e-05, -1.170939312507547e-05,
  1.260658678758026e-06, -9.735411387968255e-08,  5.985084755211991e-09, -3.096689329828165e-10,  1.395503568482156e-11, -5.605464691336098e-13,  2.040487085300052e-14,
 -6.815312864725625e-16,  2.108830743951349e-17, -6.087262325390870e-19,  1.306864536273062e-05, -3.119262999831531e-06,  4.035949353260155e-07, -3.682971471317762e-08,
  2.639058501234821e-09, -1.573448183673480e-10,  8.091622957099143e-12, -3.677831019769146e-13,  1.503639050341969e-14, -5.603003782273483e-16,  1.922544278975460e-17,
 -6.119301840207278e-19,  2.774841639464696e-06, -7.913041507154407e-07,  1.208989625845826e-07, -1.285449995779502e-08,  1.060680715661811e-09, -7.208588983417228e-11,
  4.188290644226783e-12, -2.133953079638762e-13,  9.711349726630048e-15, -4.002661849358135e-16,  1.510408015807245e-17, -5.258403107947956e-19,  6.092491756778990e-07,
 -2.019153972535277e-07,  3.566804799012293e-08, -4.340971576962375e-09,  4.060638266001270e-10, -3.101297406201277e-11,  2.009145612083528e-12, -1.133394922991853e-13,
  5.674539195269276e-15, -2.558215384543002e-16,  1.050308348351245e-17, -3.958469447516055e-19,  1.465518822295062e-07, -5.474001698137312e-08,  1.089490279972053e-08,
 -1.483589912336652e-09,  1.541189050589130e-10, -1.297984521108874e-11,  9.212516385533019e-13, -5.659880971001382e-14,  3.069409602989268e-15, -1.491403904498320e-16,
  6.569296722405332e-18, -2.644691702125224e-19,  3.963948132090459e-08, -1.612825988261280e-08,  3.504768445808565e-09, -5.188380893707613e-10,  5.828981673890852e-11,
 -5.281948080390932e-12,  4.014133617368837e-13, -2.628835466461688e-14,  1.513410102927658e-15, -7.776517171392590e-17,  3.609661105635435e-18, -1.526208078852461e-19,
  1.022490850220885e-08, -4.367383683027549e-09,  9.987421730291941e-10, -1.552572811486980e-10,  1.826328787296172e-11, -1.727678598002219e-12,  1.366831772366494e-13,
 -9.293738127672278e-15,  5.541382073992340e-16, -2.942322645008789e-17,  1.408309338812594e-18, -6.127597674423435e-20,  1.494488669197884e-01, -9.732847998134434e-04,
  6.827036942843157e-06, -5.035703096013160e-08,  3.814942934461138e-10, -2.926865012907174e-12,  2.247623478049211e-14, -1.724758950919904e-16,  1.312698934716748e-18,
 -9.976785882723651e-21,  7.474332363962082e-23, -5.641969788375096e-25,  1.223233469546157e-01, -1.203778833448895e-03,  1.467962131169430e-05, -1.755516394755694e-07,
  2.001826087655763e-09, -2.191815958362687e-11,  2.322245441527818e-13, -2.394376900668251e-15,  2.411519644645316e-17, -2.379508924763973e-19,  2.304971078748724e-21,
 -2.196010053519264e-23,  8.201267016278131e-02, -1.359703185840170e-03,  2.484613774711727e-05, -4.035102680025075e-07,  6.038498150828946e-09, -8.506199076700010e-11,
  1.141474770804407e-12, -1.470707499443002e-14,  1.829805316740463e-16, -2.207848546961285e-18,  2.592375744647408e-20, -2.969609554467354e-22,  4.511791073497894e-02,
 -1.213217731037584e-03,  3.009464809297313e-05, -6.336020543415059e-07,  1.201861631360953e-08, -2.106993016347083e-10,  3.467050758819730e-12, -5.411571215403317e-14,
  8.073547769305140e-16, -1.157878658655571e-17,  1.603422231738058e-19, -2.151180106099937e-21,  2.042670954945593e-02, -8.378303861709128e-04,  2.718617054322943e-05,
 -7.261451208083064e-07,  1.708116199863553e-08, -3.649539165667411e-10,  7.220475992583243e-12, -1.340165240574401e-13,  2.355407848539070e-15, -3.947438240741317e-17,
  6.342299292516354e-19, -9.808976405896962e-21,  7.647020321672381e-03, -4.532911484077856e-04,  1.890239636541698e-05, -6.304446293348405e-07,  1.811329940595589e-08,
 -4.651194749641026e-10,  1.092061576231945e-11, -2.380579172777326e-13,  4.870854906433074e-15, -9.430739912954751e-17,  1.738720908434542e-18, -3.066890311589938e-20,
  2.384696860721822e-03, -1.956601426453775e-04,  1.035413203443793e-05, -4.259175444974046e-07,  1.478351312568496e-08, -4.517072573270925e-10,  1.246913414003095e-11,
 -3.164152775555497e-13,  7.472961798191507e-15, -1.657852805020028e-16,  3.479409419586314e-18, -6.944930173205401e-20,  6.264681464646365e-04, -6.874106537950167e-05,
  4.564246386970965e-06, -2.292607437240434e-07,  9.532566816817977e-09, -3.439386076935531e-10,  1.108301104713381e-11, -3.251743348770959e-13,  8.806913601014244e-15,
 -2.224481219529159e-16,  5.281581933646801e-18, -1.185666929065744e-19,  1.409970338447062e-04, -2.011370427288779e-05,  1.657052117506400e-06, -1.007557391695892e-07,
  4.982584521052058e-09, -2.109260024913180e-10,  7.887094256582577e-12, -2.660421975623324e-13,  8.217680555199238e-15, -2.350603638311396e-16,  6.280589985817617e-18,
 -1.577480160261865e-19,  2.787292184542391e-05, -5.043608448196017e-06,  5.096215632003868e-07, -3.719335638917687e-08,  2.172378949122935e-09, -1.072375213374322e-10,
  4.626763537219514e-12, -1.784598894597077e-13,  6.254024429112442e-15, -2.015529738813200e-16,  6.029726657526197e-18, -1.685915747646783e-19,  5.017207171294941e-06,
 -1.125221950270850e-06,  1.376750195301679e-07, -1.194688055904438e-08,  8.177514195660144e-10, -4.674873402825195e-11,  2.312468458236709e-12, -1.013776109179628e-13,
  4.007220047026179e-15, -1.446741413178125e-16,  4.818830681808138e-18, -1.491508488567812e-19,  8.647895096652572e-07, -2.347184199236425e-07,  3.425134199369862e-08,
 -3.492543468493114e-09,  2.773739299458503e-10, -1.819993246286536e-11,  1.023667728112922e-12, -5.060911669272857e-14,  2.239475765841471e-15, -8.991721272553707e-17,
  3.310845035908895e-18, -1.126475435322502e-19,  1.524756743655343e-07, -4.877094986010020e-08,  8.326171410182552e-09, -9.819443923221356e-10,  8.923603359722458e-11,
 -6.636393541092671e-12,  4.194955633132392e-13, -2.313187901783539e-14,  1.133905163848515e-15, -5.012232824293175e-17,  2.020363165262048e-18, -7.484991893441838e-20,
  2.965573551873829e-08, -1.083777537042873e-08,  2.110681248644043e-09, -2.816499673566844e-10,  2.871567723754244e-11, -2.376986688265577e-12,  1.660347775397594e-13,
 -1.005091617981685e-14,  5.376438276813131e-16, -2.579265927903018e-17,  1.122693799934679e-18, -4.470090300166839e-20,  6.707464648621771e-09, -2.700884041518150e-09,
  5.806872743585684e-10, -8.510102665701718e-11,  9.471514178060662e-12, -8.508252470262005e-13,  6.414050269177286e-14, -4.169172011457800e-15,  2.383516597738663e-16,
 -1.216831921584190e-17,  5.614176371105083e-19, -2.360409318834989e-20,  1.543788669891696e-09, -6.573059738533784e-10,  1.498063049420248e-10, -2.321187238111520e-11,
  2.722031928520171e-12, -2.567499026150018e-13,  2.025673282988829e-14, -1.373791964604014e-15,  8.171259939906497e-17, -4.328734270846873e-18,  2.067393532342207e-19,
 -8.976825537829700e-21,  1.456612740359614e-01, -9.209861415443553e-04,  6.257534942451805e-06, -4.469367228517587e-08,  3.279833090765595e-10, -2.440952938972739e-12,
  1.818485324418219e-14, -1.356844403326015e-16,  1.001856523585483e-18, -7.430780373988660e-21,  5.374004953438094e-23, -4.013917289080822e-25,  1.177304907619408e-01,
 -1.094255300280690e-03,  1.275163315836919e-05, -1.467478279024768e-07,  1.614185591382297e-09, -1.706940340175402e-11,  1.748145250223239e-13, -1.743685265861379e-15,
  1.699977671039315e-17, -1.624871812306901e-19,  1.525297851265707e-21, -1.409281895843013e-23,  7.694288855028658e-02, -1.178780378715826e-03,  2.053203520509452e-05,
 -3.191447153706653e-07,  4.580988684294743e-09, -6.201338726903483e-11,  8.009945978917797e-13, -9.946288275065237e-15,  1.193966658770916e-16, -1.391266956157910e-18,
  1.578932063464649e-20, -1.749452669291945e-22,  4.070262744845689e-02, -9.998976316558711e-04,  2.351950271877656e-05, -4.709622374043222e-07,  8.527589042081593e-09,
 -1.430986519079555e-10,  2.258700087136725e-12, -3.387579022245126e-14,  4.863252105085263e-16, -6.719847736328493e-18,  8.975461629658843e-20, -1.162587241530841e-21,
  1.746107751448040e-02, -6.510492350377349e-04,  1.989869966958434e-05, -5.029615078445980e-07,  1.125007050987001e-08, -2.293317445671826e-10,  4.340164932803597e-12,
 -7.721923832474587e-14,  1.303254226276658e-15, -2.100567889470845e-17,  3.250204277326090e-19, -4.846831474196466e-21,  6.094507894995654e-03, -3.280310554550975e-04,
  1.280957877488580e-05, -4.027958373015537e-07,  1.097121534035486e-08, -2.681143834462321e-10,  6.009066584518762e-12, -1.253459824534252e-13,  2.459220752542940e-15,
 -4.573798467747569e-17,  8.113016015208386e-19, -1.378764616051580e-20,  1.740241245888399e-03, -1.298441694407467e-04,  6.409684224122134e-06, -2.479831027736939e-07,
  8.143657850343967e-09, -2.364254089843450e-10,  6.221850914448954e-12, -1.509299775495209e-13,  3.415473282073697e-15, -7.274694722559404e-17,  1.468429130362410e-18,
 -2.823525070327121e-20,  4.101812310690056e-04, -4.108097565345274e-05,  2.540798535414355e-06, -1.199225430508749e-07,  4.714001984481051e-09, -1.615191137720597e-10,
  4.960367684591386e-12, -1.391122279375617e-13,  3.610388693979256e-15, -8.757617478306130e-17,  2.000711467233821e-18, -4.329207132774401e-20,  8.095930055843752e-05,
 -1.060279310677979e-05,  8.145933332689069e-07, -4.658132877963720e-08,  2.179353560338460e-09, -8.768222744540550e-11,  3.127511697383134e-12, -1.009394487038829e-13,
  2.991059903808027e-15, -8.226468814772688e-17,  2.117741823148143e-18, -5.134287919773901e-20,  1.368578759281877e-05, -2.291870478418524e-06,  2.167946018741315e-07,
 -1.492404484492821e-08,  8.268061058582891e-10, -3.888399400974435e-11,  1.604068953950199e-12, -5.933761415518145e-14,  1.999557981134814e-15, -6.210843646095040e-17,
  1.794476135315408e-18, -4.854826658360066e-20,  2.051374267344127e-06, -4.302233552129491e-07,  4.960859169276774e-08, -4.082326965970708e-09,  2.662961427124620e-10,
 -1.456620818585045e-11,  6.917443388699337e-13, -2.919814776031549e-14,  1.114010568671491e-15, -3.890741412359580e-17,  1.256141082613551e-18, -3.775472624759372e-20,
  2.871261868587028e-07, -7.380578113845579e-08,  1.024648255196333e-08, -9.987180037037643e-10,  7.612310903436135e-11, -4.810045701849747e-12,  2.612974651212858e-13,
 -1.250847585865242e-14,  5.371455721014412e-16, -2.097111882876065e-17,  7.521858397329318e-19, -2.497085449725389e-20,  4.037977751724334e-08, -1.241010277488902e-08,
  2.039757729995560e-09, -2.323363659819746e-10,  2.045254902287273e-11, -1.477222785128100e-12,  9.089520092894289e-14, -4.888789448467921e-15,  2.341660814095953e-16,
 -1.013056359931269e-17,  4.002357930069722e-19, -1.455283153917029e-20,  6.259388680030527e-09, -2.230804497759409e-09,  4.238459100738133e-10, -5.527556027694506e-11,
  5.517914612362867e-12, -4.479679460192188e-13,  3.073566419900777e-14, -1.830053004248361e-15,  9.640467035608203e-17, -4.559562994109727e-18,  1.958594631192216e-19,
 -7.703000927832702e-21,  1.161737319973025e-09, -4.621663960436036e-10,  9.814681310400826e-11, -1.421773258204611e-11,  1.565469778703022e-12, -1.392352220056231e-13,
  1.040041373632383e-14, -6.703078756932829e-16,  3.802051964909502e-17, -1.926858580666416e-18,  8.829706180586120e-20, -3.688899751957224e-21,  2.349009928497098e-10,
 -9.965048818910909e-11,  2.262382451976386e-11, -3.492492539889892e-12,  4.081300778383624e-13, -3.836967430589810e-14,  3.017918850680465e-15, -2.040803747339803e-16,
  1.210561517064746e-17, -6.396549065389525e-19,  3.047605481441009e-20, -1.320293597366013e-21,  1.420741745502427e-01, -8.729855091595991e-04,  5.751159677429659e-06,
 -3.981400832704593e-08,  2.832386079424256e-10, -2.046716879657940e-12,  1.479707370398469e-14, -1.075226792221278e-16,  7.691083226714334e-19, -5.599599839669945e-21,
  3.859072498507691e-23, -2.952280966588763e-25,  1.135469302668268e-01, -9.988716148870286e-04,  1.113505081302990e-05, -1.234395641019561e-07,  1.311094528935099e-09,
 -1.340327398877935e-11,  1.328052815869622e-13, -1.282622394556199e-15,  1.211405032331765e-17, -1.122599100463964e-19,  1.021824634752835e-21, -9.165557691906193e-24,
  7.253366743546510e-02, -1.028684929303385e-03,  1.710428686317163e-05, -2.548140152879567e-07,  3.512451110738763e-09, -4.574199786201137e-11,  5.692477998466697e-13,
 -6.818665508933390e-15,  7.904313117317666e-17, -8.901939764777235e-19,  9.772641569638357e-21, -1.048067549101412e-22,  3.704656595450968e-02, -8.322281491857968e-04,
  1.860088925101399e-05, -3.547647489332646e-07,  6.139096486804857e-09, -9.871458680416492e-11,  1.496099833607321e-12, -2.158003212006208e-14,  2.983689512922608e-16,
 -3.975194855876990e-18,  5.124953245555742e-20, -6.413445306228649e-22,  1.514093738522248e-02, -5.132569192004538e-04,  1.480831982840602e-05, -3.546523692502207e-07,
  7.551628450700046e-09, -1.470192449259584e-10,  2.663935752577929e-12, -4.546995407712750e-14,  7.374761898425746e-16, -1.143954666336359e-17,  1.705675694611373e-19,
 -2.453921245562571e-21,  4.960457701861412e-03, -2.422664160560344e-04,  8.874778349829527e-06, -2.633696745479463e-07,  6.807050829346570e-09, -1.584442181186219e-10,
  3.392188771722187e-12, -6.775285682888355e-14,  1.275335842112150e-15, -2.279608511280357e-17,  3.892057526807532e-19, -6.375222328828362e-21,  1.307284830460727e-03,
 -8.856779254614970e-05,  4.082466955095874e-06, -1.486414447285984e-07,  4.620947756488195e-09, -1.275306408089180e-10,  3.200875708840685e-12, -7.425286668751605e-14,
  1.610483455468997e-15, -3.294082216251745e-17,  6.396362400615425e-19, -1.184974255318810e-20,  2.789284051895151e-04, -2.543788160680934e-05,  1.465497302082372e-06,
 -6.499525568808235e-08,  2.415460214003554e-09, -7.859782146279255e-11,  2.300456026943047e-12, -6.166562642801998e-14,  1.533493166694141e-15, -3.571857189771017e-17,
  7.850441857541036e-19, -1.637067925071364e-20,  4.873097286964034e-05, -5.840033570192435e-06,  4.179521085016918e-07, -2.245897572480419e-08,  9.934889857562743e-10,
 -3.796738706520102e-11,  1.291119372722220e-12, -3.985005009978929e-14,  1.132218732145857e-15, -2.992583329108920e-17,  7.418397337434070e-19, -1.735089732087899e-20,
  7.106597190143330e-06, -1.096845777056294e-06,  9.691197831669399e-08, -6.281995039136637e-09,  3.296448023211483e-10, -1.475107406563355e-11,  5.811595461272265e-13,
 -2.059555147447286e-14,  6.666691689082250e-16, -1.993780848489040e-17,  5.558001559683049e-19, -1.453573978320500e-20,  8.930214080560729e-07, -1.742883011997939e-07,
  1.887795025194262e-08, -1.469354380989764e-09,  9.114038924995492e-11, -4.760704391493039e-12,  2.166634660166062e-13, -8.790597507853234e-15,  3.232285965932992e-16,
 -1.090458706386054e-17,  3.407707401454544e-19, -9.932578317832641e-21,  1.017425624478178e-07, -2.463951965280072e-08,  3.241466951289853e-09, -3.010091591552915e-10,
  2.195643646632607e-11, -1.332659324186756e-12,  6.975929994776731e-14, -3.226662517427166e-15,  1.342028125045679e-16, -5.085478671700599e-18,  1.773778897556819e-19,
 -5.736315020588098e-21,  1.135893475963468e-08, -3.337841911952102e-09,  5.260273769504401e-10, -5.766558990753720e-11,  4.902113224144583e-12, -3.429198867712724e-13,
  2.048837843052068e-14, -1.072410309838685e-15,  5.008845872193299e-17, -2.116748573520060e-18,  8.182073593860328e-20, -2.915055501402670e-21,  1.384421517645972e-09,
 -4.793543400374360e-10,  8.855107085099128e-11, -1.125269229738816e-11,  1.096921624877359e-12, -8.713206934095620e-14,  5.859565487952832e-15, -3.424967765800684e-16,
  1.773646397338808e-17, -8.256808851606417e-19,  3.494972642815220e-20, -1.355894323135922e-21,  2.066559587178478e-10, -8.105636422866668e-11,  1.696875043433636e-11,
 -2.425445778740216e-12,  2.637794683375146e-13, -2.319555750432517e-14,  1.714563406878958e-15, -1.094397859432786e-16,  6.152241933408134e-18, -3.092184257079571e-19,
  1.406113576357052e-20, -5.832725294788783e-22,  3.606052421924244e-11, -1.523335336720678e-11,  3.443167326826765e-12, -5.292824505920549e-13,  6.160580148322623e-14,
 -5.770236907273644e-15,  4.522731605344263e-16, -3.048452801849263e-17,  1.802765751344650e-18, -9.498478643231290e-20,  4.513336397635815e-21, -1.950345442027386e-22,
  1.386713300177656e-01, -8.288132537740667e-04,  5.299291472130877e-06, -3.559134578307132e-08,  2.456253261189709e-10, -1.725109853073749e-12,  1.210267767484517e-14,
 -8.586273746742647e-17,  5.923769283363365e-19, -4.294419333428779e-21,  2.712737466817804e-23, -2.320105319832452e-25,  1.097207011605600e-01, -9.153789951770962e-04,
  9.771324361785878e-06, -1.044448650641578e-07,  1.072204838051270e-09, -1.060657447496915e-11,  1.017633850879387e-13, -9.524714804085282e-16,  8.720724980360618e-18,
 -7.842952205587696e-20,  6.923874103993967e-22, -6.039306427961902e-24,  6.867449326262798e-02, -9.031913282328065e-04,  1.435576300479762e-05, -2.052513439121467e-07,
  2.720126544673724e-09, -3.411242374367084e-11,  4.094086280773668e-13, -4.734761445931579e-15,  5.304851686517183e-17, -5.778543596938429e-19,  6.141690316877265e-21,
 -6.378952986139800e-23,  3.399047986403148e-02, -6.989182267062209e-04,  1.487371537751136e-05, -2.705702206987889e-07,  4.479987436518624e-09, -6.909951941672336e-11,
  1.006545199738788e-12, -1.397552879991857e-14,  1.862513174080609e-16, -2.394441419117544e-18,  2.981922162082984e-20, -3.607523243996322e-22,  1.330052046712788e-02,
 -4.099625016057384e-04,  1.119059044674724e-05, -2.542649669326414e-07,  5.159785504839018e-09, -9.603416769790917e-11,  1.667548532741061e-12, -2.732858745935838e-14,
  4.262744683961360e-16, -6.367977936593098e-18,  9.155488782309361e-20, -1.271491786955102e-21,  4.115701443187112e-03, -1.822734084844787e-04,  6.275992645065963e-06,
 -1.759553155686708e-07,  4.319595578961596e-09, -9.584806911993287e-11,  1.961703295806655e-12, -3.754203876116389e-14,  6.784019489913067e-16, -1.166038620597878e-17,
  1.917148104942780e-19, -3.028071357049133e-21,  1.008585589889047e-03, -6.195580513403428e-05,  2.670024157689715e-06, -9.155183681446767e-08,  2.696156728832717e-09,
 -7.077660559424318e-11,  1.695083986569639e-12, -3.761936695384907e-14,  7.823157515568367e-16, -1.537125141964577e-17,  2.871973204811900e-19, -5.127243096582421e-21,
  1.964766467223281e-04, -1.627920593422733e-05,  8.738877061661489e-07, -3.642437796730128e-08,  1.280061492910030e-09, -3.956329880545536e-11,  1.103736258230443e-12,
 -2.828188266488263e-14,  6.739284692022930e-16, -1.507317170650378e-17,  3.187039075910257e-19, -6.404320694467429e-21,  3.066839612832860e-05, -3.352613772168261e-06,
  2.233310339999541e-07, -1.127102500112559e-08,  4.712065955468084e-10, -1.709849695543157e-11,  5.541425433851110e-13, -1.635014845592168e-14,  4.452380574896250e-16,
 -1.130474400856738e-17,  2.697406512153165e-19, -6.083761956601455e-21,  3.894591573693101e-06, -5.517431482858018e-07,  4.544581935551785e-08, -2.769917250671000e-09,
  1.375082829646670e-10, -5.848666985763740e-12,  2.198483675211144e-13, -7.457084177604589e-15,  2.316594634478112e-16, -6.664819446330756e-18,  1.791066278737148e-19,
 -4.524234648793288e-21,  4.135931466141910e-07, -7.474800956116526e-08,  7.581707641884951e-09, -5.568156392921471e-10,  3.277460029872459e-11, -1.631894704753991e-12,
  7.105701211821925e-14, -2.766930032377486e-15,  9.790868804777396e-17, -3.186268817489123e-18,  9.625284300268378e-20, -2.717269870973859e-21,  3.852524130292843e-08,
 -8.742043518244799e-09,  1.085454582414989e-09, -9.572004933629325e-11,  6.663087990359249e-12, -3.875047880050114e-13,  1.950198400482751e-14, -8.697889749018350e-16,
  3.497103107403355e-17, -1.283923624882993e-18,  4.347473937021876e-20, -1.367421143401753e-21,  3.406210841416565e-09, -9.518774666872915e-10,  1.432091277252014e-10,
 -1.505377692003364e-11,  1.231828510493430e-12, -8.321989891228439e-14,  4.815498195365851e-15, -2.447184077849198e-16,  1.112141315402433e-17, -4.581921666917621e-19,
  1.729616290876703e-20, -6.027493696382080e-22,  3.224406898091012e-10, -1.079967958662089e-10,  1.932320577212513e-11, -2.384674868934519e-12,  2.263318635459691e-13,
 -1.754436272511251e-14,  1.153695403060535e-15, -6.605782103146659e-17,  3.356344523086536e-18, -1.535182051283920e-19,  6.392832713479544e-21, -2.442817492000584e-22,
  3.790362457267562e-11, -1.462153436557091e-11,  3.010405000876818e-12, -4.236857091249556e-13,  4.542721799578580e-14, -3.942876084082148e-15,  2.879766290283318e-16,
 -1.817981948614045e-17,  1.011651778515981e-18, -5.037108217617373e-20,  2.270682512481583e-21, -9.343481757240501e-23,  5.592535026090337e-12, -2.350934385977521e-12,
  5.286627606343222e-13, -8.087083958282924e-14,  9.370161217261647e-15, -8.739281270529299e-16,  6.822857586808697e-17, -4.581891246360346e-18,  2.700291089548663e-19,
 -1.418169051177508e-20,  6.718346688111616e-22, -2.895013461122314e-23,  1.354382517113397e-01, -7.880630200468337e-04,  4.894685758706930e-06, -3.192235688529867e-08,
  2.138435248831967e-10, -1.461489276743227e-12,  9.942045508155576e-15, -6.919008704937596e-17,  4.549566785556528e-19, -3.402012930832751e-21,  1.774113840906083e-23,
 -1.973669597437085e-25,  1.062079800647200e-01, -8.419454167677646e-04,  8.614323675587854e-06, -8.886247194183238e-08,  8.824889145155489e-10, -8.455179393613660e-12,
  7.861190747313105e-14, -7.137176746219910e-16,  6.337828899777453e-18, -5.539317836828379e-20,  4.740140082881650e-22, -4.030347985491053e-24,  6.527680133501977e-02,
 -7.975060072306487e-04,  1.213297881015323e-05, -1.666952924870251e-07,  2.126313268042030e-09, -2.570332614456461e-11,  2.977824366885263e-13, -3.327625693911774e-15,
  3.606678891818660e-17, -3.802277279640302e-19,  3.916448104608052e-21, -3.940723682339046e-23,  3.141381489736123e-02, -5.917944361559273e-04,  1.201526105030139e-05,
 -2.087556850578558e-07,  3.311041748864235e-09, -4.903685334904512e-11,  6.871898735248156e-13, -9.192274438853601e-15,  1.181823415911662e-16, -1.467109749751130e-18,
  1.766291646237226e-20, -2.066976299419448e-22,  1.182220102052763e-02, -3.313720669997692e-04,  8.577761855805489e-06, -1.851343033357896e-07,  3.584483919008366e-09,
 -6.384301975541507e-11,  1.063325302537944e-12, -1.674546084972593e-14,  2.513920728140014e-16, -3.619189572164495e-18,  5.020784770728445e-20, -6.734754293400167e-22,
  3.475136699383592e-03, -1.394670729260146e-04,  4.523356361449997e-06, -1.199371769313114e-07,  2.799503518786473e-09, -5.926897183197889e-11,  1.160558266622247e-12,
 -2.129576657866801e-14,  3.696676586185507e-16, -6.113275290073100e-18,  9.684245094076177e-20, -1.475605533123129e-21,  7.974344480176734e-04, -4.435155702277234e-05,
  1.789811729808631e-06, -5.784028680456433e-08,  1.614831311475569e-09, -4.034758477968544e-11,  9.226038674718587e-13, -1.959869995716972e-14,  3.909428801274590e-16,
 -7.381607305400862e-18,  1.327496719278802e-19, -2.284447039777517e-21,  1.429963701161598e-04, -1.074026164624288e-05,  5.375888981267463e-07, -2.106530451260173e-08,
  7.002969875253637e-10, -2.056479905892308e-11,  5.469815445476931e-13, -1.340021406469758e-14,  3.060161183972342e-16, -6.572843723903045e-18,  1.337024529903308e-19,
 -2.589049149142646e-21,  2.012641193191772e-05, -2.000771405536271e-06,  1.240054772998999e-07, -5.875740745867517e-09,  2.321082008366726e-10, -7.995526633724555e-12,
  2.469029971146239e-13, -6.962477743833626e-15,  1.816740256781365e-16, -4.429883122258826e-18,  1.017108730735031e-19, -2.211380764968204e-21,  2.247300123858136e-06,
 -2.910575936940777e-07,  2.231308912824811e-08, -1.277230236001860e-09,  5.992760262785148e-11, -2.420661852024880e-12,  8.674589545024906e-14, -2.814040241345195e-15,
  8.383608824083653e-17, -2.318571874791400e-18,  6.002165781478989e-20, -1.463318696106894e-21,  2.035305063780749e-07, -3.389422688094048e-08,  3.210224720740725e-09,
 -2.219744184786780e-10,  1.237585667404686e-11, -5.864362082579549e-13,  2.439455248989955e-14, -9.104211556918848e-16,  3.096198281485239e-17, -9.707522131969215e-19,
  2.831357309568425e-20, -7.732629366709836e-22,  1.559881197536431e-08, -3.297859597848932e-09,  3.849522427240285e-10, -3.213481784623045e-11,  2.128948951458810e-12,
 -1.183511065915103e-13,  5.714154069789495e-15, -2.452476344585899e-16,  9.514366556539482e-18, -3.378429016617258e-19,  1.108736981428573e-20, -3.386477040807665e-22,
  1.092340380029115e-09, -2.886119552906870e-10,  4.126337232793620e-11, -4.143297634274893e-12,  3.252756934114563e-13, -2.116030997785587e-14,  1.182735566837392e-15,
 -5.821561993659296e-17,  2.568553218929218e-18, -1.029540126048706e-19,  3.788144753592851e-21, -1.288978396154231e-22,  7.948758495570868e-11, -2.562559118763405e-11,
  4.421997112983773e-12, -5.280233983268244e-13,  4.863641965506134e-14, -3.668554864761242e-15,  2.352858359169667e-16, -1.316617827515256e-17,  6.549593959854894e-19,
 -2.937755894007621e-20,  1.201379074516659e-21, -4.514237731010740e-23,  7.200590233827688e-12, -2.723682546179340e-12,  5.499881579485313e-13, -7.602905739011033e-14,
  8.019115939428096e-15, -6.856661651688503e-16,  4.939666920368120e-17, -3.079377420202675e-18,  1.693856129288473e-19, -8.344336033800405e-21,  3.724642532863946e-22,
 -1.518733085113514e-23,  8.776405397442075e-13, -3.668141456417469e-13,  8.199609249182275e-14, -1.247256593515362e-14,  1.437576421279148e-15, -1.334276470495358e-16,
  1.036994765720027e-17, -6.934823846965640e-19,  4.071071976034349e-20, -2.130339824188316e-21,  1.005797054085504e-22, -4.320400171118100e-24,  1.323619677935090e-01,
 -7.503817820584839e-04,  4.531222135155003e-06, -2.872236484051859e-08,  1.868509456770026e-10, -1.244591608557008e-12,  8.191012843392110e-15, -5.647048070335945e-17,
  3.432551481624584e-19, -2.855666557846011e-21,  9.905349510791109e-24, -1.504734923835263e-25,  1.029715967598716e-01, -7.770684070409191e-04,  7.627426964677629e-06,
 -7.599937274145268e-08,  7.307445452703642e-10, -6.787105025796153e-12,  6.119158334699424e-14, -5.394747523843129e-16,  4.646185691569277e-18, -3.955270768493666e-20,
  3.275594484630177e-22, -2.714769149451900e-24,  6.226900411654625e-02, -7.079018881021640e-04,  1.032097376867541e-05, -1.364279887112551e-07,  1.676791502512424e-09,
 -1.955585760662658e-11,  2.189064660001401e-13, -2.365353650589492e-15,  2.482590750407348e-17, -2.533796742853628e-19,  2.532652919831666e-21, -2.469735387051526e-23,
  2.922419590638901e-02, -5.048611366965496e-04,  9.798369329597167e-06, -1.628092203866885e-07,  2.476400108942511e-09, -3.524988646098796e-11,  4.756900153809928e-13,
 -6.135115658356248e-15,  7.616270764436737e-17, -9.135018726254981e-19,  1.064165729892447e-20, -1.205307888421934e-22,  1.062114569160267e-02, -2.707502019896155e-04,
  6.662216441922708e-06, -1.367553460751934e-07,  2.529076248895905e-09, -4.314849435352623e-11,  6.899497936347391e-13, -1.044928306561619e-14,  1.511008380961971e-16,
 -2.097768656960348e-18,  2.809961084040010e-20, -3.642699640714074e-22,  2.981494383092504e-03, -1.083569153153904e-04,  3.318146002864602e-06, -8.329583942666260e-08,
  1.850492808362514e-09, -3.741369265791287e-11,  7.014784916650935e-13, -1.235078371944765e-14,  2.060874344609470e-16, -3.280986506785189e-18,  5.010541214393405e-20,
 -7.368771361451547e-22,  6.448174123649775e-04, -3.242450780267456e-05,  1.227564986918336e-06, -3.741949024215242e-08,  9.912379843798617e-10, -2.358984678990553e-11,
  5.153404096148265e-13, -1.048424708179958e-14,  2.007016974511743e-16, -3.643199926423729e-18,  6.308688834233188e-20, -1.046815401283537e-21,  1.072686360990442e-04,
 -7.287389984705327e-06,  3.404653413559368e-07, -1.254779545334193e-08,  3.947944970226352e-10, -1.101974966000124e-11,  2.795413187835247e-13, -6.549444486697314e-15,
  1.433717498322662e-16, -2.957789854814276e-18,  5.789127003849664e-20, -1.080353438869505e-21,  1.373624820213416e-05, -1.237978028274718e-06,  7.138856463381806e-08,
 -3.175440724405190e-09,  1.185222041471135e-10, -3.875683974879922e-12,  1.140289897024319e-13, -3.072896583924540e-15,  7.682082323616646e-17, -1.798615812719690e-18,
  3.972996847777673e-20, -8.325035374194596e-22,  1.361957308086896e-06, -1.606179645012616e-07,  1.144621601823860e-08, -6.147601619705916e-10,  2.724221347829237e-11,
 -1.044348321942809e-12,  3.565669861280141e-14, -1.105597179991541e-15,  3.156877866238845e-17, -8.387605055166283e-19,  2.090386528784605e-20, -4.915733314706557e-22,
  1.062404127658030e-07, -1.622176326341757e-08,  1.431006492489075e-09, -9.298104017414890e-11,  4.902510300525515e-12, -2.207700776440426e-13,  8.762049208760557e-15,
 -3.130285055017562e-16,  1.021948085298307e-17, -3.083476923221656e-19,  8.673825398176194e-21, -2.289268294481948e-22,  6.754050017987518e-09, -1.322621277777131e-09,
  1.445862962034471e-10, -1.139108151421366e-11,  7.164116291861235e-13, -3.798359025594832e-14,  1.755761542492229e-15, -7.237968262793887e-17,  2.704622463839394e-18,
 -9.273085245931073e-20,  2.944893847265363e-21, -8.721503970149203e-23,  3.756437397669404e-10, -9.325068632447184e-11,  1.260981343266598e-11, -1.204774876725066e-12,
  9.043946216818961e-14, -5.648545996136150e-15,  3.041564283310214e-16, -1.446506376624352e-17,  6.182354276725112e-19, -2.405886325504803e-20,  8.611920244101936e-22,
 -2.856048298641747e-23,  2.084883034512828e-11, -6.432993785692504e-12,  1.065566173861845e-12, -1.226161041419242e-13,  1.092248641312333e-14, -7.991832619940954e-16,
  4.985242790567017e-17, -2.719509605667052e-18,  1.321497357996302e-19, -5.800554592087181e-21,  2.325052989942594e-22, -8.575872239931132e-24,  1.424152944782850e-12,
 -5.263275501099023e-13,  1.038942362670365e-13, -1.406600329668370e-14,  1.455752996505096e-15, -1.223447115024995e-16,  8.676407844125390e-18, -5.331608426890650e-19,
  2.894292302919716e-20, -1.408604289830650e-21,  6.217633171158473e-23, -2.509257260527993e-24,  1.396407655530715e-13, -5.796657465266383e-14,  1.286714561384859e-14,
 -1.944401963139350e-15,  2.227493271173353e-16, -2.055851852433541e-17,  1.589539425178691e-18, -1.057910925975002e-19,  6.182934242758822e-21, -3.222143604058430e-22,
  1.515447672174474e-23, -6.486427602494393e-25,  1.294308266605745e-01, -7.154616799998256e-04,  4.203703198471556e-06, -2.592171974647966e-08,  1.638029022132465e-10,
 -1.065832716118490e-12,  6.748641913322452e-15, -4.706578788204142e-17,  2.462863184759198e-19, -2.556538295759423e-21,  6.266744974105369e-24,  1.984390737083655e-26,
  9.997985363870428e-02, -7.195080210093798e-04,  6.781351611806164e-06, -6.531845253942002e-08,  6.085464524286453e-10, -5.484200660984034e-12,  4.797048556610536e-14,
 -4.112663350431743e-16,  3.432010960270751e-18, -2.855104734029366e-20,  2.290882536611407e-22, -1.810168365919740e-24,  5.959277052254140e-02, -6.314545300418649e-04,
  8.832769821165637e-06, -1.124638124196500e-07,  1.333277847018753e-09, -1.501486933153926e-11,  1.625552790750387e-13, -1.699260786500888e-15,  1.729344273162008e-17,
 -1.708451117383327e-19,  1.659070437633286e-21, -1.573969830300901e-23,  2.735003681046577e-02, -4.336652647057541e-04,  8.060989031330640e-06, -1.282603143783562e-07,
  1.872957849527227e-09, -2.564700770419893e-11,  3.336145281826189e-13, -4.151280743197667e-15,  4.981393531795732e-17, -5.774740059324758e-19,  6.514798570202774e-21,
 -7.153159831027778e-23,  9.635238441209318e-03, -2.233890156215698e-04,  5.238129999942786e-06, -1.023846610322285e-07,  1.810548935804755e-09, -2.961701273254742e-11,
  4.550922952458962e-13, -6.633306006427403e-15,  9.247089525185734e-17, -1.238746271121095e-18,  1.603271526350232e-20, -2.010267650416562e-22,  2.595469020265691e-03,
 -8.535807319543671e-05,  2.474221455621951e-06, -5.886486297044765e-08,  1.245996190089873e-09, -2.407959081789980e-11,  4.326567062525288e-13, -7.314574293005553e-15,
  1.174061089007731e-16, -1.800481016377323e-18,  2.652189851852134e-20, -3.766700019086830e-22,  5.322548538959735e-04, -2.416244472208270e-05,  8.600530920842326e-07,
 -2.475020441456914e-08,  6.226378457513341e-10, -1.412441752950535e-11,  2.949911584954845e-13, -5.750955919417611e-15,  1.057099913590743e-16, -1.845626851268908e-18,
  3.078613247995954e-20, -4.927558320358316e-22,  8.274505297037171e-05, -5.073234692378116e-06,  2.215494398546049e-07, -7.683864666916239e-09,  2.289486649694224e-10,
 -6.077382629039449e-12,  1.470981862162724e-13, -3.297190959120688e-15,  6.920928709902215e-17, -1.371740889722525e-18,  2.583841111309936e-20, -4.647706768362502e-22,
  9.724026497815254e-06, -7.921049196320836e-07,  4.251573440050465e-08, -1.775428480211592e-09,  6.262278679929937e-11, -1.944106710153087e-12,  5.450116628844517e-14,
 -1.403607009500302e-15,  3.361805133866521e-17, -7.557327130950599e-19,  1.605878281944509e-20, -3.242620508069421e-22,  8.645967361399721e-07, -9.247717014963063e-08,
  6.121196317930038e-09, -3.082636540174363e-10,  1.289499611958790e-11, -4.689455553518334e-13,  1.524784766158165e-14, -4.516969248543069e-16,  1.235584035704483e-17,
 -3.152399414010484e-19,  7.560013352604437e-21, -1.713953632119780e-22,  5.870126664754925e-08, -8.177145436897937e-09,  6.703899739092369e-10, -4.086477114425957e-11,
  2.034879726049908e-12, -8.697948921029210e-14,  3.290001388411798e-15, -1.123954594390199e-16,  3.518966907273308e-18, -1.020785287879202e-19,  2.766764737768334e-21,
 -7.050216604083164e-23,  3.125486915849484e-09, -5.635217657622465e-10,  5.748432144188225e-11, -4.262239728550283e-12,  2.538752039653723e-13, -1.281081383293208e-14,
  5.658682519034899e-16, -2.236682437966204e-17,  8.037028466121640e-19, -2.656560485256888e-20,  8.151773615895058e-22, -2.337535190861088e-23,  1.388162629860403e-10,
 -3.216073748160688e-11,  4.093544140541372e-12, -3.706985660463221e-13,  2.652009829010652e-14, -1.585581474801825e-15,  8.203460125935904e-17, -3.760492844071014e-18,
  1.553447104599669e-19, -5.857139795479137e-21,  2.035689902575453e-22, -6.568019621964674e-24,  5.848425795631113e-12, -1.716138652528162e-12,  2.714535094639684e-13,
 -2.997116197208413e-14,  2.572215183299119e-15, -1.819625006533983e-16,  1.100710533313563e-17, -5.837886760329253e-19,  2.764367474168120e-20, -1.184770675276480e-21,
  4.645240087395484e-23, -1.678710908589805e-24,  2.949826186199217e-13, -1.060518249104287e-13,  2.038484479581083e-14, -2.693857057435745e-15,  2.727601071574387e-16,
 -2.247301446665446e-17,  1.565253728699280e-18, -9.461548949908277e-20,  5.059582914063649e-21, -2.428675298413510e-22,  1.058508303938280e-23, -4.222253670252649e-25,
  2.258123595395791e-14, -9.297551533886302e-15,  2.046776381164141e-15, -3.069116341427847e-16,  3.491031015242459e-17, -3.201067397800499e-18,  2.460208607542551e-19,
 -1.628378318588691e-20,  9.468743808982559e-22, -4.911346174073669e-23,  2.299872231462088e-24, -9.804242836916714e-26,  1.266343299748180e-01, -6.830333076248894e-04,
  3.907691508751599e-06, -2.346303943153113e-08,  1.440034252283222e-10, -9.188720005928383e-13,  5.527685199245394e-15, -4.060080282045300e-17,  1.599654447485247e-19,
 -2.173648059277384e-21,  1.648231497275189e-23,  5.183595367104372e-25,  9.720558215883450e-02, -6.682349173525338e-04,  6.052523509935492e-06, -5.640033144665470e-08,
  5.095029295284532e-10, -4.459574450335679e-12,  3.784982208911957e-14, -3.162615364262665e-16,  2.551899119909037e-18, -2.076532304435356e-20,  1.652820345040922e-22,
 -1.109823244453887e-24,  5.720021300068504e-02, -5.658495043117310e-04,  7.601933922064073e-06, -9.333689433294894e-08,  1.068440433737570e-09, -1.162721768423502e-11,
  1.218828503510374e-13, -1.232712167972422e-15,  1.218740413402875e-17, -1.165350425215361e-19,  1.095693662891357e-21, -1.033011184854704e-23,  2.573527494728686e-02,
 -3.748607439277152e-04,  6.686050689770502e-06, -1.019979856550161e-07,  1.431525576389296e-09, -1.887251449044786e-11,  2.368958626718413e-13, -2.845133527614023e-15,
  3.304507693080783e-17, -3.703947498467226e-19,  4.043477714565699e-21, -4.334420085707586e-23,  8.818351624334567e-03, -1.859474231515818e-04,  4.165542712986470e-06,
 -7.761878044923076e-08,  1.313954572703907e-09, -2.062638740400414e-11,  3.048741137482510e-13, -4.279417312622264e-15,  5.756680667076212e-17, -7.445407002358407e-19,
  9.313436247178490e-21, -1.131832139714609e-22,  2.289584978045142e-03, -6.808415667590411e-05,  1.873220326226994e-06, -4.228017189189117e-08,  8.536167553791943e-10,
 -1.578228626841973e-11,  2.719937945912053e-13, -4.418424666171061e-15,  6.827194340649214e-17, -1.009122965988757e-18,  1.434518859664891e-20, -1.969119136755535e-22,
  4.476985435873382e-04, -1.831988863272574e-05,  6.146131985784577e-07, -1.671181966122409e-08,  3.996470697749201e-10, -8.648542269209967e-12,  1.728109824616213e-13,
 -3.230404435826975e-15,  5.704940315067000e-17, -9.585003465613527e-19,  1.540801481512935e-20, -2.379965082983321e-22,  6.549006816863173e-05, -3.615521434083250e-06,
  1.478563305844327e-07, -4.828659432023635e-09,  1.363494119662644e-10, -3.443998171427866e-12,  7.957861177020034e-14, -1.707260465681408e-15,  3.437537267560959e-17,
 -6.547829751402312e-19,  1.187281001833900e-20, -2.058953648883578e-22,  7.121587315142177e-06, -5.227179782586854e-07,  2.613761279666141e-08, -1.024910047910871e-09,
  3.417329899549233e-11, -1.007439042262318e-12,  2.691589260914632e-14, -6.625461301987550e-16,  1.520475860552794e-17, -3.281943698204101e-19,  6.708739234611159e-21,
 -1.305341236585089e-22,  5.733511687780338e-07, -5.539892885635782e-08,  3.404783819975096e-09, -1.607045060571810e-10,  6.344098085973076e-12, -2.188032342879740e-13,
  6.773506616829325e-15, -1.916505216273571e-16,  5.020708978275526e-18, -1.229639336290153e-19,  2.836587655442885e-21, -6.197566756706023e-23,  3.424987554075853e-08,
 -4.330896804500422e-09,  3.293973969606277e-10, -1.881135147462427e-11,  8.836949774328167e-13, -3.581912800441889e-14,  1.290076113984521e-15, -4.210814616307527e-17,
  1.263244178420050e-18, -3.520083034045458e-20,  9.185464069358732e-22, -2.257977456830288e-23,  1.543997433611638e-09, -2.547373384162055e-10,  2.416772951118965e-11,
 -1.682167329823323e-12,  9.469248650527762e-14, -4.539229603432571e-15,  1.912708308592623e-16, -7.237447890859069e-18,  2.497043611374861e-19, -7.945763466737261e-21,
  2.352657924892028e-22, -6.523398195442713e-24,  5.520226442462213e-11, -1.185146744339869e-11,  1.413120858151689e-12, -1.208276867212169e-13,  8.211395322461219e-15,
 -4.686275393406681e-16,  2.323643968976222e-17, -1.024285160048458e-18,  4.080803573024580e-20, -1.487717886558454e-21,  5.010942119568632e-23, -1.570067403340590e-24,
  1.763233725905368e-12, -4.885365842169728e-13,  7.338240395967691e-14, -7.738039891101286e-15,  6.372917180578600e-16, -4.343564949022754e-17,  2.540012362561934e-18,
 -1.306097359904480e-19,  6.011303467416199e-21, -2.509714288509610e-22,  9.604419670863058e-24, -3.393870933438328e-25,  6.440897081625911e-14, -2.240856348995060e-14,
  4.175198817078476e-15, -5.364523842935330e-16,  5.296037832223011e-17, -4.265019656241254e-18,  2.909842420014576e-19, -1.726186677820355e-20,  9.073948245162141e-22,
 -4.287833491816979e-23,  1.842082397539980e-24, -7.251314464259604e-26,  3.722421873819891e-15, -1.517623563968818e-15,  3.307970800601679e-16, -4.914978892154177e-17,
  5.544022779325940e-18, -5.044872637547804e-19,  3.850342783658728e-20, -2.532274432033136e-21,  1.463871502269012e-22, -7.552107584562103e-24,  3.518911410318202e-25,
 -1.493212593297855e-26,  1.239629901300559e-01, -6.528601842505621e-04,  3.639375224849806e-06, -2.129917303021911e-08,  1.268632505488246e-10, -7.993373753442999e-13,
  4.452000435273816e-15, -3.654733811964682e-17,  1.013658286502606e-19, -7.991898554071366e-22,  5.962184314906041e-23,  1.529223565509693e-24,  9.462538353900679e-02,
 -6.223898325780607e-04,  5.421840526939779e-06, -4.891531352721912e-08,  4.287230345332562e-10, -3.648862202883217e-12,  3.003396767905112e-14, -2.453697839099442e-16,
  1.913304784697429e-18, -1.494198750583006e-20,  1.304918787196070e-22, -4.771446480006152e-25,  5.505174053573907e-02, -5.092402840511916e-04,  6.577272081866035e-06,
 -7.795425638280161e-08,  8.625645156270392e-10, -9.075745687340993e-12,  9.225166376399911e-14, -9.022039293331262e-16,  8.681343063557405e-18, -8.074462344289126e-20,
  7.164662396213345e-22, -7.208628931388247e-24,  2.433557119498277e-02, -3.259056722622823e-04,  5.587976949762264e-06, -8.182934995728210e-08,  1.105046579371985e-09,
 -1.403477841218580e-11,  1.702343758142302e-13, -1.973213734221526e-15,  2.221335541637605e-17, -2.413560399630129e-19,  2.526240739230920e-21, -2.709529955967030e-23,
  8.135777834993493e-03, -1.560203445625781e-04,  3.347828413711039e-06, -5.953546213251370e-08,  9.658702465098576e-10, -1.456154917353954e-11,  2.072721532201254e-13,
 -2.802959601242641e-15,  3.642079635656411e-17, -4.553560321071905e-19,  5.493750561225119e-21, -6.512983352389315e-23,  2.044305412568409e-03, -5.491753547986757e-05,
  1.438432959187484e-06, -3.083080569214113e-08,  5.943751532863050e-10, -1.052214489671975e-11,  1.741036119085622e-13, -2.719202228178440e-15,  4.047903670413372e-17,
 -5.771426616323041e-19,  7.916779753682646e-21, -1.052267143197348e-22,  3.831205092261432e-04, -1.410826702378272e-05,  4.473834882909493e-07, -1.150330008149212e-08,
  2.617691453807729e-10, -5.408291803237239e-12,  1.034730144480470e-13, -1.855804990409036e-15,  3.150773177776987e-17, -5.097120093539448e-19,  7.898829287012123e-21,
 -1.178257761584039e-22,  5.307292266196789e-05, -2.631992578022877e-06,  1.010254865887794e-07, -3.108604752135555e-09,  8.325689093128374e-11, -2.002344156269568e-12,
  4.419527100743576e-14, -9.079381258932069e-16,  1.754383015639794e-17, -3.212816001180838e-19,  5.609577773003043e-21, -9.381775873948355e-23,  5.382381017909230e-06,
 -3.548486295444881e-07,  1.655298672611248e-08, -6.096710744734347e-10,  1.922544384622754e-11, -5.384026884004751e-13,  1.371315325880639e-14, -3.227123717944702e-16,
  7.097373291599609e-18, -1.471179280727149e-19,  2.893187878111017e-21, -5.424785495560613e-23,  3.960787364214375e-07, -3.443196832249288e-08,  1.965264816760454e-09,
 -8.691831105250236e-11,  3.237959131235606e-12, -1.059005943808220e-13,  3.120939797064295e-15, -8.432909979053794e-17,  2.115369303002494e-18, -4.972239606437831e-20,
  1.103068229233925e-21, -2.321976074457634e-23,  2.104622639070219e-08, -2.403514849378018e-09,  1.693787327767778e-10, -9.052560916339365e-12,  4.008572452950779e-13,
 -1.539618529472602e-14,  5.276300777247254e-16, -1.644297688312433e-17,  4.723466545869220e-19, -1.263504726840718e-20,  3.172031657783803e-22, -7.516977825011311e-24,
  8.128432095493249e-10, -1.219485273097296e-10,  1.072880041662211e-11, -6.994450924275939e-13,  3.714160037354908e-14, -1.688599160804650e-15,  6.777505094594545e-17,
 -2.451564937175199e-18,  8.110585957048891e-20, -2.481351912294282e-21,  7.080465755673405e-23, -1.896096454784485e-24,  2.363708709907925e-11, -4.667663142470237e-12,
  5.189343367812561e-13, -4.174226223447509e-14,  2.686491012664291e-15, -1.459545544547730e-16,  6.918804077710645e-18, -2.926243891683689e-19,  1.122022174968229e-20,
 -3.947403170088387e-22,  1.286116582531310e-23, -3.906559470738445e-25,  5.739026318679605e-13, -1.489530403782005e-13,  2.112150948089667e-14, -2.116883324522467e-15,
  1.666169743053412e-16, -1.090169184113254e-17,  6.143050678504512e-19, -3.053643895563647e-20,  1.362426802346470e-21, -5.527499876727179e-23,  2.060025521107428e-24,
 -7.103122975765744e-26,  1.493337950145417e-14, -4.996165705484993e-15,  8.975599781852061e-16, -1.116211394850271e-16,  1.070273251314760e-17, -8.396227997585557e-19,
  5.594512102014482e-20, -3.248404659817520e-21,  1.674576371056620e-22, -7.773333476333281e-24,  3.285398533125628e-25, -1.274077648702686e-26,  6.278683040198219e-16,
 -2.529161126891928e-16,  5.447337731464958e-17, -8.005435303102245e-18,  8.940769304681893e-19, -8.062937311659635e-20,  6.103739201651720e-21, -3.984538354914277e-22,
  2.287810865538204e-23, -1.172956091350982e-24,  5.434213638613739e-26, -2.293847999705796e-27,  1.214082078185538e-01, -6.247342149297266e-04,  3.395454327964251e-06,
 -1.939179107941408e-08,  1.118639469501443e-10, -7.044091809423917e-13,  3.473917559085882e-15, -3.314921998544609e-17,  1.352245199347338e-19,  3.315135283439652e-21,
  1.555676632642560e-22,  2.809462391676402e-24,  9.221901371758214e-02, -5.812517336819036e-04,  4.873726694243098e-06, -4.260261610010931e-08,  3.624312192057663e-10,
 -3.004034549443912e-12,  2.394690490752572e-14, -1.917736897846274e-16,  1.465890583527910e-18, -9.967793094370190e-21,  1.222973439543546e-22,  7.847366092951868e-26,
  5.311440520145232e-02, -4.601423481936025e-04,  5.719004697713569e-06, -6.549310405403697e-08,  7.012953147219055e-10, -7.135957359594350e-12,  7.047822636159146e-14,
 -6.659629880220256e-16,  6.219354985484258e-18, -5.785195698968190e-20,  4.405646830866242e-22, -5.490874337355439e-24,  2.311553502834134e-02, -2.848490711603218e-04,
  4.703517278304355e-06, -6.618961989491210e-08,  8.611154310266015e-10, -1.053921498441739e-11,  1.237562641358575e-13, -1.384041462580380e-15,  1.508535587405874e-17,
 -1.610164587347533e-19,  1.558780777045379e-21, -1.770034529579286e-23,  7.561080790261873e-03, -1.318532037604795e-04,  2.717323704854668e-06, -4.616559807595243e-08,
  7.186489292331850e-10, -1.041087317273560e-11,  1.429141194439415e-13, -1.862410732765237e-15,  2.337690091013923e-17, -2.839268522282920e-19,  3.271104301578182e-21,
 -3.842447151931782e-23,  1.845515923573693e-03, -4.474291771045914e-05,  1.119249214669860e-06, -2.280079477124525e-08,  4.202322688056663e-10, -7.128155861255840e-12,
  1.133654445550314e-13, -1.703222293751618e-15,  2.443898523743474e-17, -3.367634992224455e-19,  4.447568844316405e-21, -5.747880476906315e-23,  3.330620136840149e-04,
 -1.101758037575107e-05,  3.312975496979742e-07, -8.061206690714381e-09,  1.747519361863949e-10, -3.449559932668355e-12,  6.324973327232746e-14, -1.089041968261496e-15,
  1.778526587630022e-17, -2.772927529931762e-19,  4.141659520468559e-21, -5.973799797784646e-23,  4.395348846083969e-05, -1.953063690218347e-06,  7.055888423135602e-08,
 -2.046864275251183e-09,  5.204523428822418e-11, -1.192603940452103e-12,  2.516142454751824e-14, -4.952453325824073e-16,  9.187802055766054e-18, -1.618499762652129e-19,
  2.721679408719444e-21, -4.392014835748241e-23,  4.187932648604489e-06, -2.471753942867719e-07,  1.077774961456632e-08, -3.729926035082426e-10,  1.113107986709773e-11,
 -2.962515335462747e-13,  7.196383222832395e-15, -1.619587240256789e-16,  3.414449954881681e-18, -6.798448370200765e-20,  1.286413126769374e-21, -2.324736796371254e-23,
  2.842494955324103e-07, -2.213922435834773e-08,  1.174474474316320e-09, -4.866909175172822e-11,  1.711195984602511e-12, -5.307604425445923e-14,  1.489128972699546e-15,
 -3.842517910920886e-17,  9.229018208879893e-19, -2.081788030080042e-20,  4.440779456135457e-22, -9.004784862823239e-24,  1.358211993837030e-08, -1.393575597444337e-09,
  9.093355850199060e-11, -4.544647633960894e-12,  1.895897603367811e-13, -6.896373672713730e-15,  2.247681466467956e-16, -6.684439154667739e-18,  1.837719328045117e-19,
 -4.716442317636532e-21,  1.138541831864743e-22, -2.599538912614057e-24,  4.550343155333516e-10, -6.167905700042954e-11,  5.019818513574394e-12, -3.059320498989861e-13,
  1.530096326564947e-14, -6.588450482767060e-16,  2.515643574470034e-17, -8.688294180482084e-19,  2.753003078901218e-20, -8.088712600358900e-22,  2.221899254412312e-23,
 -5.740322876510288e-25,  1.089601582959452e-11, -1.963685489010717e-12,  2.026634200018814e-13, -1.528377314068375e-14,  9.288796174306389e-16, -4.792063068256194e-17,
  2.166805044114216e-18, -8.774364726685465e-20,  3.231618402977545e-21, -1.095117917102542e-22,  3.445372080029782e-24, -1.012831219456404e-25,  2.024307940964396e-13,
 -4.878853650380827e-14,  6.490865579330827e-15, -6.152669113019231e-16,  4.608780868320106e-17, -2.884301442637339e-18,  1.561044991083913e-19, -7.479324618684259e-21,
  3.226165702011031e-22, -1.268768250977076e-23,  4.594336382942375e-25, -1.542488969480103e-26,  3.705348184773767e-15, -1.183175783801580e-15,  2.036907969432382e-16,
 -2.439248296947140e-17,  2.261678370438483e-18, -1.721824749970555e-19,  1.116722331787930e-20, -6.327831550175219e-22,  3.190544800209830e-23, -1.451418939863491e-24,
  6.022099706847080e-26, -2.296196075404372e-27,  1.088704665854860e-16, -4.320715368934128e-17,  9.171627513402116e-18, -1.330185915033253e-18,  1.468072946262525e-19,
 -1.309876812565728e-20,  9.820907927832026e-22, -6.355473046674952e-23,  3.620342427657794e-24, -1.842780771345875e-25,  8.481202452228794e-27, -3.558410774286677e-28,
  1.189621660312931e-01, -5.984720020798757e-04,  3.173040700612961e-06, -1.771044830877095e-08,  9.853749269703865e-11, -6.315248253684323e-13,  2.634302453534886e-15,
 -2.545444863616468e-17,  3.985576165104215e-19,  1.222523824648013e-20,  2.917258697107755e-22,  3.007601924134322e-24,  8.996888200959635e-02, -5.442126363538805e-04,
  4.395402419568050e-06, -3.725486958996195e-08,  3.076889540656775e-10, -2.488741649323872e-12,  1.918681874497894e-14, -1.496491153961053e-16,  1.196903639370717e-18,
 -4.908123340783157e-21,  1.320976687098035e-22,  2.614157152055545e-25,  5.136061812050016e-02, -4.173535067595503e-04,  4.995983366874586e-06, -5.532818749117147e-08,
  5.740890053314892e-10, -5.647568374769334e-12,  5.432606159880015e-14, -4.973151980098338e-16,  4.399095604172699e-18, -4.468427475794104e-20,  2.273673990461405e-22,
 -4.156027741732406e-24,  2.204667540222498e-02, -2.501788440909629e-04,  3.985442004603061e-06, -5.394892856259739e-08,  6.771542671838529e-10, -7.984515265670140e-12,
  9.096747560274866e-14, -9.834276872845160e-16,  1.024104918462017e-17, -1.123356227268850e-19,  9.185178324002911e-22, -1.171400885563829e-23,  7.073893091582908e-03,
 -1.121497863224591e-04,  2.226014286843786e-06, -3.616291694418980e-08,  5.409067382851033e-10, -7.530791030306015e-12,  9.986532675961510e-14, -1.255627709198244e-15,
  1.515091118838438e-17, -1.817891898161668e-19,  1.947003649826646e-21, -2.306256301621764e-23,  1.682867582954036e-03, -3.677900783774300e-05,  8.817154806315066e-07,
 -1.708451195340214e-08,  3.014272356930937e-10, -4.901383323474925e-12,  7.502015887552390e-14, -1.085220614258264e-15,  1.498915363672761e-17, -2.007990899497107e-19,
  2.534892652495488e-21, -3.201655138443232e-23,  2.937406104834411e-04, -8.711360003933926e-06,  2.493039328402823e-07, -5.743946123081722e-09,  1.187677435809546e-10,
 -2.241369132974472e-12,  3.942494325480592e-14, -6.521765712386996e-16,  1.024447770199832e-17, -1.542690634945225e-19,  2.217362926341779e-21, -3.097509360821299e-23,
  3.713245216964198e-05, -1.474306586784235e-06,  5.030043836300641e-08, -1.376325923333885e-09,  3.325999901205195e-11, -7.266256485900441e-13,  1.466519692522270e-14,
 -2.767227740397798e-16,  4.930528548063347e-18, -8.362396190036985e-20,  1.354230455349408e-21, -2.109893074668730e-23,  3.347076707532402e-06, -1.762255667762589e-07,
  7.201558565033501e-09, -2.342570341012954e-10,  6.621221597320587e-12, -1.675601185334744e-13,  3.883973101032916e-15, -8.362959129118737e-17,  1.690571868294073e-18,
 -3.234583630202416e-20,  5.889829475807194e-22, -1.026093330317807e-23,  2.113500091634980e-07, -1.468375913163057e-08,  7.251079129409817e-10, -2.815386722417912e-11,
  9.346179907562914e-13, -2.749730181535569e-14,  7.346016359903059e-16, -1.810416538543852e-17,  4.163604110198264e-19, -9.013282900189833e-21,  1.848656744743291e-22,
 -3.610784867338307e-24,  9.178407500241918e-09, -8.415335744377785e-10,  5.084728643783418e-11, -2.374953389579931e-12,  9.331376392423040e-14, -3.213627003547738e-15,
  9.958000964368376e-17, -2.825113773460773e-18,  7.430623651444619e-20, -1.828997755918866e-21,  4.243655456951272e-23, -9.331209554789256e-25,  2.701654351241908e-10,
 -3.286653114188792e-11,  2.470014315764644e-12, -1.405009098295384e-13,  6.610351873364270e-15, -2.692781599370069e-16,  9.770951900308038e-18, -3.218838222732585e-19,
  9.759108648322356e-21, -2.751073236059375e-22,  7.267840056897940e-24, -1.809756405989033e-25,  5.401901242039631e-12, -8.812570065108549e-13,  8.409350455105760e-14,
 -5.927346498861842e-15,  3.393082003929065e-16, -1.658458559689163e-17,  7.138235030773614e-19, -2.762302699276302e-20,  9.754515260306939e-22, -3.178577031669135e-23,
  9.640561715189760e-25, -2.738457570337262e-26,  7.760590647510312e-14, -1.720399821634280e-14,  2.134110990587720e-15, -1.903831167021909e-16,  1.351616349093397e-17,
 -8.061532458018595e-19,  4.177081787708515e-20, -1.923346822219384e-21,  7.999094995695085e-23, -3.041819988304893e-24,  1.067733191179930e-25, -3.482917379382120e-27,
  9.920059389421514e-16, -2.996361158257391e-16,  4.908787154869955e-17, -5.628149454647493e-18,  5.021738818325183e-19, -3.694483033135794e-20,  2.323726674617018e-21,
 -1.280780627637771e-22,  6.297795236651793e-24, -2.800259073593669e-25,  1.137871810686260e-26, -4.256666749565493e-28,  1.952134742797852e-17, -7.604571031499864e-18,
  1.585634574431983e-18, -2.263091431780068e-19,  2.462247023784569e-20, -2.169083682646372e-21,  1.607812571163592e-22, -1.029831675406073e-23,  5.812090507857353e-25,
 -2.933556635876706e-26,  1.339809399767970e-27, -5.582140704703435e-29,  1.166177372797291e-01, -5.739119144728158e-04,  2.969568654462461e-06, -1.623166761949223e-08,
  8.649098423982339e-11, -5.749200720487471e-13,  2.183688919275163e-15, -3.182621921102503e-18,  1.074898247952906e-18,  2.584076893679454e-20,  3.618901036173843e-22,
 -7.842648058452799e-25,  8.785963989443199e-02, -5.107575864416502e-04,  3.976316890650966e-06, -3.270637390017558e-08,  2.622013625664758e-10, -2.074338459896191e-12,
  1.551366246252055e-14, -1.131399824900286e-16,  1.116922581340901e-18,  4.585852159729125e-22,  1.301229987185550e-22, -5.923982180457056e-25,  4.976714456994977e-02,
 -3.798933870754284e-04,  4.383647451994165e-06, -4.697999990041497e-08,  4.731240862795182e-10, -4.496365574854996e-12,  4.214079787066157e-14, -3.808524369473664e-16,
  2.915135736562821e-18, -3.866955354184796e-20,  9.088722870587861e-23, -1.722005496616602e-24,  2.110587192279945e-02, -2.207120803852206e-04,  3.398152061183077e-06,
 -4.428210268426033e-08,  5.372421177726617e-10, -6.098202379373272e-12,  6.745670363510371e-14, -7.142433941138552e-16,  6.748304892635943e-18, -8.433336148782190e-20,
  5.217900793966111e-22, -6.151220774411498e-24,  6.658355407546779e-03, -9.594102174827195e-05,  1.839407391759938e-06, -2.859415175976500e-08,  4.116701215136722e-10,
 -5.506683548843703e-12,  7.060814859798863e-14, -8.622681924981813e-16,  9.793104059380656e-18, -1.210389485775131e-19,  1.162332571225581e-21, -1.314251212585416e-23,
  1.548667244534787e-03, -3.047021449921162e-05,  7.026942688611651e-07, -1.295750656740322e-08,  2.191972449067745e-10, -3.417375240292904e-12,  5.038743081615756e-14,
 -7.041179904671986e-16,  9.290303512355729e-18, -1.228354294846984e-19,  1.465732332336510e-21, -1.786358199154759e-23,  2.624889947305322e-04, -6.963434330784649e-06,
  1.904500178138966e-07, -4.156473610364971e-09,  8.209491733339546e-11, -1.481837440541595e-12,  2.502679485698431e-14, -3.984447416898876e-16,  6.005884223392345e-18,
 -8.781614774270433e-20,  1.211050401782919e-21, -1.634480734143252e-23,  3.194688972534780e-05, -1.129912121630523e-06,  3.655336313980061e-08, -9.436485467807124e-10,
  2.170109329813222e-11, -4.522593584764621e-13,  8.738461740356354e-15, -1.582380773750215e-16,  2.706575385929394e-18, -4.428166169380456e-20,  6.902423710534622e-22,
 -1.038067434295312e-23,  2.741839712537481e-06, -1.282817993901028e-07,  4.929989887643061e-09, -1.507609188621163e-10,  4.040057106394440e-12, -9.726405229956014e-14,
  2.152599575871555e-15, -4.437218545792982e-17,  8.601698191570128e-19, -1.582645121135751e-20,  2.773380736483720e-22, -4.658490164466673e-24,  1.623877073187832e-07,
 -1.001639533860259e-08,  4.615263785366346e-10, -1.679028543761772e-11,  5.265885424544469e-13, -1.469985853840801e-14,  3.740547559921528e-16, -8.806905147364819e-18,
  1.939550270083956e-19, -4.030284498559451e-21,  7.948154558617618e-23, -1.495351982898865e-24,  6.475646176685470e-09, -5.275290599181206e-10,  2.954225440143820e-11,
 -1.289000287271845e-12,  4.770056410657482e-14, -1.555102600057733e-15,  4.580799808685832e-17, -1.239562700671542e-18,  3.118401439123970e-20, -7.359891381786818e-22,
  1.640828763873618e-23, -3.473535612875889e-25,  1.696285916959524e-10, -1.839195716337945e-11,  1.275080498951356e-12, -6.760807890693400e-14,  2.989561875024669e-15,
 -1.151128419700543e-16,  3.966243791650425e-18, -1.245305470483394e-19,  3.609791593382819e-21, -9.755543345932901e-23,  2.476665069314418e-24, -5.939313557824585e-26,
  2.875235525205615e-12, -4.209788243680862e-13,  3.701749499402170e-14, -2.431960599893865e-15,  1.308371607910069e-16, -6.046851242332462e-18,  2.472961860621834e-19,
 -9.129449728170776e-21,  3.086081100247007e-22, -9.654899426764785e-24,  2.818787277024343e-25, -7.725725225261744e-27,  3.239693992814776e-14, -6.538098337843058e-15,
  7.516026625864297e-16, -6.280220468477207e-17,  4.208916219097331e-18, -2.384128149464752e-19,  1.178982119184598e-20, -5.202237150262676e-22,  2.080599180053225e-23,
 -7.631566387048488e-25,  2.590809367096939e-26, -8.193342609885167e-28,  2.889290261553057e-16, -8.168863385225550e-17,  1.263590215508499e-17, -1.378367375792862e-18,
  1.177239910202478e-19, -8.331465275425980e-21,  5.061598820798829e-22, -2.704040058732485e-23,  1.292552060392348e-24, -5.601354652126913e-26,  2.223303557509121e-27,
 -8.140743835340112e-29,  3.646673779460731e-18, -1.387498054123197e-18,  2.829661932112036e-19, -3.960079400496217e-20,  4.234580480388589e-21, -3.673637545305880e-22,
  2.686157777845476e-23, -1.699671248662320e-24,  9.487914606177683e-26, -4.741721314109064e-27,  2.146298106022172e-28, -8.869780780312801e-30,  1.143684011974752e-01,
 -5.509118149386558e-04,  2.782721665668596e-06, -1.493689996455324e-08,  7.553353596455217e-11, -5.187389432977079e-13,  2.734789322625787e-15,  4.867533953766787e-17,
  2.233972241068907e-18,  3.692925624158290e-20,  1.099865820092634e-22, -1.214037654106441e-23,  8.587784162224324e-02, -4.804486651063507e-04,  3.607705434015453e-06,
 -2.882382033309464e-08,  2.242023335832342e-10, -1.735937524346861e-12,  1.285530283881910e-14, -7.621610804744248e-17,  1.215285943128630e-18,  4.502676936858733e-21,
  5.243695643002583e-23, -3.294417400347027e-24,  4.831431199844927e-02, -3.469570524489796e-04,  3.862508281228887e-06, -4.007793372716302e-08,  3.924958958433678e-10,
 -3.603675305556354e-12,  3.257812411248012e-14, -3.092160513189379e-16,  1.581471855924647e-18, -3.526639797141132e-20,  1.169920253141905e-22,  3.468227749160429e-24,
  2.027422335532708e-02, -1.955150048387025e-04,  2.914584598040986e-06, -3.658037282012712e-08,  4.299624717490090e-10, -4.697497593143020e-12,  5.005094983023758e-14,
 -5.432558099227265e-16,  4.041113758883064e-18, -6.681767241359152e-20,  4.103954956589596e-22,  1.611566737604596e-24,  6.301996435940221e-03, -8.249411792915338e-05,
  1.532440737782883e-06, -2.280404646725138e-08,  3.166937962160228e-10, -4.070128930140703e-12,  5.025503713877278e-14, -6.106177008061807e-16,  6.155583599739455e-18,
 -8.366548066317878e-20,  7.657218442687419e-22, -4.960204802146822e-24,  1.437122547541814e-03, -2.541579753616819e-05,  5.661875271150780e-07, -9.937572926732791e-09,
  1.615034223821123e-10, -2.414783059558678e-12,  3.424202898816817e-14, -4.676297134327346e-16,  5.760200447862358e-18, -7.712171880833303e-20,  8.822091440510121e-22,
 -9.271034783585737e-24,  2.373953664154893e-04, -5.619072835815273e-06,  1.475716477443613e-07, -3.050850841340948e-09,  5.766188302391003e-11, -9.959731071092195e-13,
  1.614504399185805e-14, -2.487315574221076e-16,  3.567695674993272e-18, -5.113463332372286e-20,  6.789184227257273e-22, -8.618117979742599e-24,  2.794788956991661e-05,
 -8.774978754525026e-07,  2.704757570352840e-08, -6.587450992549016e-10,  1.443921169343144e-11, -2.872197461900014e-13,  5.314069890824223e-15, -9.258540373400265e-17,
  1.516205695604812e-18, -2.401192565163443e-20,  3.606271339663989e-22, -5.204263791065677e-24,  2.297511649057662e-06, -9.511100465297963e-08,  3.452569816521490e-09,
 -9.924778977222271e-11,  2.524854596954253e-12, -5.785911697547152e-14,  1.223102382208866e-15, -2.416695981301210e-17,  4.489845713896856e-19, -7.954261686807368e-21,
  1.341996694991388e-22, -2.171118369622629e-24,  1.286067768949056e-07, -7.006431092670534e-09,  3.022714881565407e-10, -1.030182677449159e-11,  3.055169126256349e-13,
 -8.095261585871188e-15,  1.962689705978724e-16, -4.417222872322743e-18,  9.315146322315497e-20, -1.858797219517437e-21,  3.525215313188957e-23, -6.387497861923870e-25,
  4.755868677573213e-09, -3.421154706305079e-10,  1.779266608666300e-11, -7.249202629397194e-13,  2.527437253233471e-14, -7.800395648759962e-16,  2.184270449973647e-17,
 -5.637905358251980e-19,  1.356405528738078e-20, -3.069372631013707e-22,  6.574068900506030e-24, -1.339518486327665e-25,  1.122772810364110e-10, -1.076976795827057e-11,
  6.888076347306167e-13, -3.400758081759971e-14,  1.412593029040108e-15, -5.138207320792882e-17,  1.680098910183319e-18, -5.024803079105715e-20,  1.391725354830219e-21,
 -3.603588874259431e-23,  8.785903919439905e-25, -2.027787512927805e-26,  1.639090421002044e-12, -2.134436051803889e-13,  1.725119856223698e-14, -1.053885205187435e-15,
  5.318816655586935e-17, -2.320484514815251e-18,  9.003276209503338e-20, -3.166225113523523e-21,  1.023109278366707e-22, -3.068909886523998e-24,  8.613225975033289e-26,
 -2.274835097953090e-27,  1.473693980866029e-14, -2.677499496956690e-15,  2.836160913684016e-16, -2.209723623945080e-17,  1.392796528996390e-18, -7.468333519562980e-20,
  3.514348884978137e-21, -1.482012577723956e-22,  5.685565047964421e-24, -2.006820821576093e-25,  6.574439529442566e-27, -2.011487581073110e-28,  9.227336606486020e-17,
 -2.412191914497001e-17,  3.493211158816465e-18, -3.600942992711424e-19,  2.927381212136303e-20, -1.983286271512539e-21,  1.158877742733625e-22, -5.977976722035707e-24,
  2.768430834127422e-25, -1.165678577523701e-26,  4.506933855387683e-28, -1.611123091586138e-29,  7.163757885273268e-19, -2.644633862083144e-19,  5.246021393363084e-20,
 -7.166146725696151e-21,  7.502704376739717e-22, -6.389300694836508e-23,  4.595990891083034e-24, -2.866131441496768e-25,  1.579279213796397e-26, -7.801131428941897e-28,
  3.494153770963997e-29, -1.430329374829037e-30,  1.122081702780561e-01, -5.293472300580903e-04,  2.610400920075945e-06, -1.380717094390835e-08,  6.597247458296725e-11,
 -4.274436936451904e-13,  5.296893059990966e-15,  1.409321643724940e-16,  3.466728616160585e-18,  2.536411414345737e-20, -8.310353765988756e-22, -3.159697463720079e-23,
  8.401166238648380e-02, -4.529121149646364e-04,  3.282249808217475e-06, -2.549821420459088e-08,  1.924193707376819e-10, -1.448468490780866e-12,  1.129095691251628e-14,
 -3.468515714055723e-17,  1.368942185347837e-18,  2.439671794184029e-21, -1.897129642510844e-22, -7.944613352178358e-24,  4.698538182514024e-02, -3.178791839669448e-04,
  3.417004039133544e-06, -3.433496105336893e-08,  3.275645623671719e-10, -2.921109338011459e-12,  2.444652319863433e-14, -2.775888087609298e-16,  4.532045856518384e-19,
 -2.526451838778313e-20,  4.439071656262934e-22,  1.175695062591317e-23,  1.953617277700654e-02, -1.738439770261915e-04,  2.513994030202104e-06, -3.039224264889842e-08,
  3.468591652044713e-10, -3.666298786723457e-12,  3.631283925776053e-14, -4.489443237331763e-16,  1.975246259182272e-18, -4.598023126733362e-20,  7.103049387845234e-22,
  1.236895830883379e-23,  5.994919865306700e-03, -7.124883373152434e-05,  1.286705783698256e-06, -1.832808004382659e-08,  2.460715145842206e-10, -3.049496627961371e-12,
  3.550302160706102e-14, -4.562026638364167e-16,  3.664146555185485e-18, -5.500577730540230e-20,  7.266355043513757e-22,  3.167498417841435e-24,  1.343820620545379e-03,
 -2.132277294793890e-05,  4.609805330175552e-07, -7.699339557002418e-09,  1.204628538471124e-10, -1.731608540874692e-12,  2.335609128193164e-14, -3.215971110524982e-16,
  3.538101344741201e-18, -4.810978086070530e-20,  6.113548688682358e-22, -3.360652952352121e-24,  2.170686620104369e-04, -4.570644444188529e-06,  1.159018774760510e-07,
 -2.268719174927728e-09,  4.111319165519337e-11, -6.806952915245806e-13,  1.053566708824255e-14, -1.594291943922581e-16,  2.137766841230758e-18, -3.011813658070801e-20,
  4.030969838387975e-22, -4.312078957995908e-24,  2.482561553531921e-05, -6.892051303392341e-07,  2.035948904690101e-08, -4.675354318171078e-10,  9.785485144282291e-12,
 -1.860173950945442e-13,  3.288519482091333e-15, -5.550563588575820e-17,  8.645808208334233e-19, -1.327821778228818e-20,  1.947036113741687e-22, -2.624343810986964e-24,
  1.965631298813208e-06, -7.164619766311453e-08,  2.470396706659203e-09, -6.671656805337590e-11,  1.613795392622020e-12, -3.523292864132248e-14,  7.109542363860513e-16,
 -1.350669170523625e-17,  2.399893605904475e-19, -4.098057396032306e-21,  6.680746005197914e-23, -1.034679991152385e-24,  1.047374194941969e-07, -5.010474928235537e-09,
  2.033634915441575e-10, -6.489561253714224e-12,  1.822079114552536e-13, -4.585465028637424e-15,  1.059213681114554e-16, -2.281724036396034e-18,  4.605224011878121e-20,
 -8.829061303691138e-22,  1.611740805358025e-23, -2.809346841015328e-25,  3.625342077495664e-09, -2.287197624546576e-10,  1.108460583234267e-11, -4.214535696235569e-13,
  1.385310653767888e-14, -4.048456878423661e-16,  1.077661331976248e-17, -2.654306566417994e-19,  6.105962960213638e-21, -1.324835602688685e-22,  2.726289717740018e-24,
 -5.345049959948909e-26,  7.808943826021117e-11, -6.573366497792063e-12,  3.883917963048928e-13, -1.783746837067150e-14,  6.958963598381075e-16, -2.390393538923242e-17,
  7.414535813618018e-19, -2.111643124586153e-20,  5.585732092390116e-22, -1.385111303703193e-23,  3.241668467072656e-25, -7.196742099972517e-27,  9.978198497516525e-13,
 -1.144442404621945e-13,  8.490635964609677e-15, -4.813431037321628e-16,  2.275732636232498e-17, -9.359950350759727e-19,  3.440987023788723e-20, -1.151385319386235e-21,
  3.552247041269723e-23, -1.020430180348899e-24,  2.750002474969949e-26, -6.990805728815650e-28,  7.301036547479977e-15, -1.179895432749400e-15,  1.145906001685786e-16,
 -8.290669987336360e-18,  4.898277386715434e-19, -2.478970058248612e-20,  1.107053334326159e-21, -4.450603637783382e-23,  1.633990945814470e-24, -5.537775544444115e-26,
  1.747036588522635e-27, -5.160875480913293e-29,  3.253926631277846e-17, -7.754613314887981e-18,  1.041959652627057e-18, -1.007915680762422e-19,  7.753924333083222e-21,
 -5.003804443024492e-22,  2.799772700554191e-23, -1.389056950500379e-24,  6.210135802151320e-26, -2.532470694625219e-27,  9.509613207344057e-29, -3.309933913450250e-30,
  1.497400602964423e-19, -5.315654329482986e-20,  1.018277339059098e-20, -1.349883902587333e-21,  1.377181432633479e-22, -1.146710061163888e-23,  8.087475069937395e-25,
 -4.956418829108325e-26,  2.689144581848219e-27, -1.310128930823743e-28,  5.795814148855747e-30, -2.346203888293171e-31,  1.101315229701602e-01, -5.091094196227814e-04,
  2.450792714336615e-06, -1.281152001324021e-08,  5.908178350643365e-11, -2.398891750345865e-13,  1.087006154547741e-14,  2.569773915203307e-16,  3.391618127726042e-18,
 -4.156713052831461e-20, -2.640062804427405e-21, -4.813137783636981e-23,  8.225066316451525e-02, -4.278278000030124e-04,  2.993834514265341e-06, -2.263677658813927e-08,
  1.661068417959311e-10, -1.184179415033113e-12,  1.093142737070627e-14,  8.290506722803500e-18,  1.222797494073258e-18, -1.355045060837654e-20, -6.396897961843349e-22,
 -1.191367854029913e-23,  4.576604787274752e-02, -2.921063782320496e-04,  3.034598864116110e-06, -2.953204978723151e-08,  2.743854083058188e-10, -2.426713792274967e-12,
  1.677139251763067e-14, -2.730466040495691e-16,  1.098198663092520e-20,  5.308426476361259e-21,  1.137066002888568e-21,  1.871283340920748e-23,  1.887883717180823e-02,
 -1.551017926290959e-04,  2.180307819483827e-06, -2.538591474727059e-08,  2.812612976464986e-10, -2.939796915839382e-12,  2.442468039966020e-14, -4.054799201293047e-16,
  9.915420948359220e-19, -3.569129872928044e-21,  1.476481346388230e-21,  2.119640973524747e-23,  5.729207622768988e-03, -6.177235897436625e-05,  1.088517645618256e-06,
 -1.483668539876545e-08,  1.926291101623558e-10, -2.339078572991381e-12,  2.411542364292540e-14, -3.646184130887465e-16,  2.260624342762953e-18, -2.101404569272073e-20,
  1.018763234615351e-21,  9.320773235141537e-24,  1.265363086825955e-03, -1.797417958985822e-05,  3.791008340330855e-07, -6.021385233348113e-09,  9.076668768791968e-11,
 -1.267762419441337e-12,  1.570845032827903e-14, -2.315770361363305e-16,  2.222926981820400e-18, -2.530055648068085e-20,  5.573339299846848e-22,  4.809036332308607e-25,
  2.004826188409258e-04, -3.742097567156203e-06,  9.221551933789128e-08, -1.707471340879810e-09,  2.970233818518636e-11, -4.745761330053973e-13,  6.886663888463689e-15,
 -1.055762076508006e-16,  1.305750200756674e-18, -1.696211647668349e-20,  2.723550677560690e-22, -1.884926346212916e-24,  2.236243114031155e-05, -5.463665659651145e-07,
  1.557826989478638e-08, -3.369195604211609e-10,  6.742957397982035e-12, -1.230094985216628e-13,  2.059382305238795e-15, -3.418157745161138e-17,  5.031717583266094e-19,
 -7.346607949233228e-21,  1.114028338231227e-22, -1.308107222288206e-24,  1.714058364827336e-06, -5.469457830281096e-08,  1.804154358704221e-09, -4.572057769806604e-11,
  1.053099821038149e-12, -2.196033423377540e-14,  4.213234573729491e-16, -7.749035473976690e-18,  1.313417754621340e-19, -2.150026852042478e-21,  3.444362690850159e-23,
 -5.014031765802104e-25,  8.751791955027321e-08, -3.651674785669313e-09,  1.403488400076128e-10, -4.188850391750412e-12,  1.114952523221504e-13, -2.668939658424573e-15,
  5.865065147037030e-17, -1.212879663325968e-18,  2.340989733790892e-20, -4.307075041546649e-22,  7.601753288454352e-24, -1.269249636824516e-25,  2.860395957676110e-09,
 -1.570398158559051e-10,  7.129325544851056e-12, -2.527060010373352e-13,  7.838404896098128e-15, -2.170670009734362e-16,  5.490080283101982e-18, -1.291754461143842e-19,
  2.840596453210194e-21, -5.908512523798486e-23,  1.169270508335651e-24, -2.203773145227741e-26,  5.688076444011493e-11, -4.164067758050091e-12,  2.280304160075991e-13,
 -9.730720357350038e-15,  3.566404407789329e-16, -1.156890265709767e-17,  3.402711270169602e-19, -9.228591043163152e-21,  2.330588729624075e-22, -5.532838713419278e-24,
  1.242741080686707e-25, -2.652494775200400e-27,  6.464845705150257e-13, -6.461116513723880e-14,  4.401607991896915e-15, -2.311353168281963e-16,  1.022776487317656e-17,
 -3.961918811469340e-19,  1.378680880300283e-20, -4.385408737618474e-22,  1.290548795487523e-23, -3.546972584470715e-25,  9.169900885843055e-27, -2.241508934545294e-28,
  3.932910765191764e-15, -5.579323800427715e-16,  4.949586943299845e-17, -3.313177816908127e-18,  1.829633008916567e-19, -8.716983043035764e-21,  3.685601117999352e-22,
 -1.409421559415737e-23,  4.941567513017621e-25, -1.604820520908647e-26,  4.865967666349039e-28, -1.385295401960710e-29,  1.274140216625784e-17, -2.723578812424482e-18,
  3.365190084300036e-19, -3.033205116014758e-20,  2.195393169793327e-21, -1.342720305658568e-22,  7.162283908767132e-24, -3.404069970579026e-25,  1.463892272705550e-26,
 -5.762524751237647e-28,  2.095198837599161e-29, -7.080625169785612e-31,  3.378950500640957e-20, -1.139463843413603e-20,  2.088590490633532e-21, -2.667514919461244e-22,
  2.636388181452056e-23, -2.135912344623120e-24,  1.470948930322622e-25, -8.828307404561361e-27,  4.702267406186298e-28, -2.253635660988523e-29,  9.824726455124837e-31,
 -3.925297326056729e-32,  1.081333466380254e-01, -4.901022202078269e-04,  2.302621074704322e-06, -1.188777779068500e-08,  5.753017018566234e-11,  1.173869698666390e-13,
  1.919070631645050e-14,  3.170820705394415e-16, -5.054888146739954e-19, -1.875495838146489e-19, -4.498280148157514e-21, -2.492733423060142e-23,  8.058559445113465e-02,
 -4.049202147568168e-04,  2.737404458630027e-06, -2.015413047600531e-08,  1.450858129838068e-10, -9.152705781048951e-13,  1.159691501758725e-14,  3.366056414361331e-17,
  1.505981488597663e-19, -4.914670692274146e-20, -1.101250420259364e-21, -6.297223430870964e-24,  4.464403216999736e-02, -2.691760522797536e-04,  2.705017388111237e-06,
 -2.551088059499775e-08,  2.292592232041886e-10, -2.115374012659031e-12,  9.231624669708875e-15, -2.592618168940528e-16,  1.215377299596383e-18,  6.650595022722610e-20,
  1.858807155344763e-21,  9.473953496698440e-24,  1.829148794748205e-02, -1.388056313681750e-04,  1.900830444354241e-06, -2.132804453070885e-08,  2.274273107443464e-10,
 -2.485926279236499e-12,  1.358798377547709e-14, -3.625902129191821e-16,  2.147690232503482e-18,  7.339728052368527e-20,  2.299456774414735e-21,  1.071953180205717e-23,
  5.498476400208117e-03, -5.372735134236793e-05,  9.275187430166184e-07, -1.210075582608917e-08,  1.508486555450938e-10, -1.875043306950358e-12,  1.486595509648061e-14,
 -2.957011883041656e-16,  2.337414322062049e-18,  2.782393001012062e-20,  1.390425396502386e-21,  4.538884256930151e-24,  1.199106825301216e-03, -1.520751517732849e-05,
  3.147817464431025e-07, -4.753545652610232e-09,  6.869478660858013e-11, -9.612175764299659e-13,  1.011429568329512e-14, -1.706454931804677e-16,  1.722143287825063e-18,
 -2.262119310173562e-21,  5.917986735086433e-22,  7.640853249754720e-27,  1.868704315011076e-04, -3.078920680607317e-06,  7.429060064146872e-08, -1.300112556578448e-09,
  2.164643779053058e-11, -3.405408153067587e-13,  4.437880929849126e-15, -7.159764851645562e-17,  8.747873369004307e-19, -7.359738178230363e-21,  2.136171530166393e-22,
 -1.094896325428201e-24,  2.040297424717818e-05, -4.362494812612865e-07,  1.210925505182849e-08, -2.463238496282400e-10,  4.707965407374179e-12, -8.346601326150648e-14,
  1.293509320914224e-15, -2.155015875755951e-17,  3.071299082469714e-19, -3.819829466187865e-21,  6.935706296219518e-23, -6.992591899674711e-25,  1.521036226952760e-06,
 -4.219963273238891e-08,  1.343708034833722e-09, -3.190128483037361e-11,  6.996184700101385e-13, -1.404028994736251e-14,  2.532292981628353e-16, -4.556185111416191e-18,
  7.425334554094101e-20, -1.125397020173770e-21,  1.859736798246458e-23, -2.510252818062222e-25,  7.487647754510775e-08, -2.703233795763408e-09,  9.924417389532906e-11,
 -2.765664741090115e-12,  6.982534658617195e-14, -1.596671822762505e-15,  3.320942153265764e-17, -6.625618509170619e-19,  1.225871310259202e-20, -2.142805502652476e-22,
  3.709178317428114e-24, -5.900663505662965e-26,  2.329727139106507e-09, -1.102919167849954e-10,  4.726301855092111e-12, -1.559304671777583e-13,  4.567499399794974e-15,
 -1.201205336381895e-16,  2.880813133828955e-18, -6.488827356696613e-20,  1.364877096224659e-21, -2.714892978171745e-23,  5.185447805945768e-25, -9.380078510583329e-27,
  4.325037547883558e-11, -2.724976632510828e-12,  1.390929882514036e-13, -5.506538517271538e-15,  1.896803105981367e-16, -5.815117666488019e-18,  1.620493195827286e-19,
 -4.187746937154096e-21,  1.009600492004395e-22, -2.293062159228506e-24,  4.945523594861520e-26, -1.014182791993702e-27,  4.441582287019167e-13, -3.821402962049647e-14,
  2.396926309365601e-15, -1.163686745137831e-16,  4.817145782730746e-18, -1.756672569284930e-19,  5.781041114984102e-21, -1.747147889883178e-22,  4.900694522779949e-24,
 -1.287629610791381e-25,  3.191263038632052e-27, -7.494579267889424e-29,  2.297355390428842e-15, -2.819151732381039e-16,  2.280393007562165e-17, -1.407627581189465e-18,
  7.249037900498566e-20, -3.244463237247332e-21,  1.296117447886031e-22, -4.705897773878271e-24,  1.572748635650766e-25, -4.885640236872842e-27,  1.421314051374169e-28,
 -3.892932887895079e-30,  5.560698321506738e-18, -1.046560992791827e-18,  1.179237285775024e-19, -9.836701302556306e-21,  6.661372690105918e-22, -3.842668885810852e-23,
  1.945669745580085e-24, -8.824066973262749e-26,  3.637082297652718e-27, -1.377467927099824e-28,  4.834557156204549e-30, -1.581812868498823e-31,  8.376226455992950e-21,
 -2.639141239644486e-21,  4.575206279982925e-22, -5.579556769736830e-23,  5.303915353818895e-24, -4.156439677128101e-25,  2.781289238504019e-26, -1.627914213130850e-27,
  8.481760260016521e-29, -3.986502153103502e-30,  1.708023698272901e-31, -6.719305662759220e-33,  1.062088987726552e-01, -4.722358611888341e-04,  2.165657143808620e-06,
 -1.092059507456998e-08,  6.516228229612319e-11,  6.751682090869106e-13,  2.657456593880175e-14,  1.574862453886088e-16, -1.052481290945299e-17, -3.617671387783734e-19,
 -3.298193344248252e-21,  1.010207036057696e-22,  7.900823435393295e-02, -3.839502054231009e-04,  2.508928885072355e-06, -1.796377212398189e-08,  1.296347480714104e-10,
 -6.270359875203618e-13,  1.227886289187572e-14,  1.488482147830008e-18, -2.420902690674383e-18, -9.198754561406089e-20, -8.166505614386664e-22,  2.459500983512249e-23,
  4.360875329258936e-02, -2.487012259113039e-04,  2.419532072531734e-06, -2.217151047078901e-08,  1.886133314508080e-10, -1.973797104058856e-12,  2.980910897376197e-15,
 -1.674919086865121e-16,  4.953744778845132e-18,  1.380876607496156e-19,  1.353356289048278e-21, -4.104822985448705e-23,  1.776514025296571e-02, -1.245645536547325e-04,
  1.665134601780076e-06, -1.807251157091777e-08,  1.802003931460639e-10, -2.270792159557596e-12,  4.923424144236553e-15, -2.336126653530501e-16,  6.447855590073438e-18,
  1.617172717888568e-19,  1.681974147983140e-21, -4.914254555854017e-23,  5.297541947986189e-03, -4.684974427058601e-05,  7.956091170694990e-07, -9.970446417423120e-09,
  1.162939879159853e-10, -1.607851327594395e-12,  7.861110006687387e-15, -1.941204630708435e-16,  4.329621574737194e-18,  8.051840958950421e-20,  1.012163122188682e-21,
 -2.745043772744491e-23,  1.142976554232335e-03, -1.290012938636855e-05,  2.637380492942174e-07, -3.796546718527173e-09,  5.154329585382992e-11, -7.694978225862349e-13,
  6.127572622058600e-15, -1.123770716321729e-16,  2.049749497312560e-18,  1.937495793527887e-20,  4.188354671133755e-22, -9.811510424908726e-24,  1.756522631222618e-04,
 -2.541596633450222e-06,  6.055956555091603e-08, -1.003096361107205e-09,  1.575384529079477e-11, -2.551136254100821e-13,  2.796379388662277e-15, -4.630052388705992e-17,
  7.500212467339138e-19, -3.727501209780416e-23,  1.412051393942142e-22, -2.653699563956545e-24,  1.883465703623287e-05, -3.500352712729807e-07,  9.555194092949001e-09,
 -1.828508564992103e-10,  3.305477229068318e-12, -5.866139012763299e-14,  8.105158139293631e-16, -1.344294081372385e-17,  2.127049420057016e-19, -1.606426043248011e-21,
  4.167546920893357e-23, -6.489427903185276e-25,  1.371555505147318e-06, -3.281032703041411e-08,  1.019751200326558e-09, -2.266260190207687e-11,  4.705001725128237e-13,
 -9.257955406589733e-15,  1.537416729672907e-16, -2.703896958964396e-18,  4.482833282266504e-20, -5.644984548198123e-22,  1.016977165831109e-23, -1.510431749530651e-25,
  6.546519157162556e-08, -2.025213774090359e-09,  7.183040805895917e-11, -1.866213830132582e-12,  4.456168588640143e-14, -9.841559672578129e-16,  1.916802074186432e-17,
 -3.694767544085870e-19,  6.689827665117129e-21, -1.072217130202974e-22,  1.857961920531410e-24, -2.930606345498914e-26,  1.953870175674322e-09, -7.888472402479461e-11,
  3.225008393913724e-12, -9.885242811925018e-14,  2.731455390434569e-15, -6.862575636350381e-17,  1.552939645716278e-18, -3.353444493710724e-20,  6.791586756900192e-22,
 -1.278453211971814e-23,  2.373130865737327e-25, -4.149487990409123e-27,  3.422015983557429e-11, -1.832593908053849e-12,  8.797534351151579e-14, -3.224917466227704e-15,
  1.043785999734142e-16, -3.032459452910930e-18,  7.990078814250511e-20, -1.968970059556996e-21,  4.538726494669680e-23, -9.836289300058427e-25,  2.040607877812119e-26,
 -4.023037272147467e-28,  3.223596305609253e-13, -2.353921918146286e-14,  1.367545367189923e-15, -6.125440837304170e-17,  2.371165934486223e-18, -8.144493036334167e-20,
  2.531905215927234e-21, -7.268944214127357e-23,  1.942936656810675e-24, -4.875295569042494e-26,  1.158099838059884e-27, -2.611334115549359e-29,  1.450066485248016e-15,
 -1.513530612910049e-16,  1.117595745786179e-17, -6.342032051457165e-19,  3.040455752518711e-20, -1.276502652062405e-21,  4.809691743171205e-23, -1.655509508888243e-24,
  5.265996609765402e-26, -1.562288353293260e-27,  4.354327019548036e-29, -1.145688128882872e-30,  2.709057750195288e-18, -4.394479977572702e-19,  4.485775345655049e-20,
 -3.440883758144298e-21,  2.169191040198727e-22, -1.174988416017461e-23,  5.624500671096923e-25, -2.425121265114615e-26,  9.547756628826881e-28, -3.467871338409425e-29,
  1.171381060284277e-30, -3.700186203856306e-32,  2.327397617027941e-21, -6.699200894110914e-22,  1.082949504325015e-22, -1.247577434957744e-23,  1.130996438455766e-24,
 -8.513459177936919e-26,  5.503082831650161e-27, -3.125692393081072e-28,  1.586286210987890e-29, -7.284903468724707e-31,  3.057770313510891e-32, -1.181146438192569e-33,
  1.043538025410493e-01, -4.554158129604480e-04,  2.041425541912321e-06, -9.734664744781930e-09,  8.515054101868434e-11,  1.315153838187429e-12,  2.419802498927145e-14,
 -4.007558399735043e-16, -2.428312999622539e-17, -3.414209996657462e-19,  5.968155314384133e-21,  3.230876812252267e-22,  7.751125980108300e-02, -3.647066245320404e-04,
  2.305446148146201e-06, -1.597411447406154e-08,  1.199855011536226e-10, -3.438133218550435e-13,  1.070991968197925e-14, -1.322355564357989e-16, -5.918387143525893e-18,
 -8.724933029051351e-20,  1.467549869824188e-21,  8.026611882036945e-23,  4.265104436330502e-02, -2.303608803189159e-04,  2.170287265129018e-06, -1.946682822605133e-08,
  1.495860045204722e-10, -1.935767231269724e-12,  1.304578554160238e-15,  7.600580985895831e-17,  1.023714019344241e-17,  1.308352588553291e-19, -2.372277076478667e-21,
 -1.291957156941533e-22,  1.729221536877886e-02, -1.120653618689942e-04,  1.464080865039223e-06, -1.554794399404427e-08,  1.355809232998188e-10, -2.202101643672008e-12,
  2.205593177031699e-15,  7.285657121310773e-17,  1.268777596969053e-17,  1.554549064752409e-19, -2.786267943540443e-21, -1.554583892013413e-22,  5.122156471821668e-03,
 -4.093420603690962e-05,  6.860957142546969e-07, -8.358277829482138e-09,  8.567641859066025e-11, -1.465871463157759e-12,  4.838523913537663e-15, -4.702492372473469e-18,
  7.518164212910232e-18,  8.035755072402093e-20, -1.453269177151662e-21, -8.566472587135754e-23,  1.095325618075560e-03, -1.095956192010673e-05,  2.226430771562876e-07,
 -3.087910576825785e-09,  3.741046367696892e-11, -6.520492984921967e-13,  4.020819895063128e-15, -3.354473669007268e-17,  2.897187787627404e-18,  2.217423358242350e-20,
 -4.199425832513239e-22, -2.877770136751926e-23,  1.663841599543792e-04, -2.101349759438676e-06,  4.987712900955658e-08, -7.885982104899456e-10,  1.123182600353143e-11,
 -2.008144123199029e-13,  1.841933587820401e-15, -2.151896064719110e-17,  8.130197500770146e-19,  2.242666939885295e-21, -5.528315016566109e-23, -6.424600358159813e-24,
  1.757466207695284e-05, -2.815543496872317e-07,  7.642699076406644e-09, -1.384068526495507e-10,  2.300070081208264e-12, -4.300010499384971e-14,  5.226568759136797e-16,
 -7.300986443551175e-18,  1.771783992134067e-19, -6.054601115544725e-22,  5.474711973324722e-24, -1.035023069840024e-24,  1.255071475727300e-06, -2.562503257530096e-08,
  7.874433611449442e-10, -1.643843300269019e-11,  3.168739167737511e-13, -6.330846401312002e-15,  9.554797239740735e-17, -1.528461101450571e-18,  3.030751589051126e-20,
 -2.827525767765564e-22,  3.997591011451578e-24, -1.387076596832260e-25,  5.838711539491542e-08, -1.529377360421132e-09,  5.313653317916393e-11, -1.288820017840719e-12,
  2.875248474572935e-14, -6.271882101302604e-16,  1.132847474011490e-17, -2.050631621427941e-19,  3.897877560696181e-21, -5.437311869242846e-23,  8.684686859290671e-25,
 -1.759803191190798e-26,  1.683344816120707e-09, -5.717919485722707e-11,  2.261488946397700e-12, -6.438416099625845e-14,  1.666690000434340e-15, -4.053460127317199e-17,
  8.602905215090044e-19, -1.764055505923360e-20,  3.531633303667764e-22, -6.163295867990607e-24,  1.093629964438809e-25, -1.979133057788945e-27,  2.808705228320118e-11,
 -1.259211010728355e-12,  5.758783388984679e-14, -1.952024450746789e-15,  5.916738546829192e-17, -1.640134137210266e-18,  4.072979023610167e-20, -9.547515906176824e-22,
  2.121549110369318e-23, -4.357498016610978e-25,  8.679234832602407e-27, -1.667479655260786e-28,  2.461988246677693e-13, -1.499944257120460e-14,  8.154392576433878e-16,
 -3.362896161235852e-17,  1.215500058205939e-18, -3.942728748080850e-20,  1.155912980663338e-21, -3.150482031281011e-23,  8.037205481406070e-25, -1.922001361337140e-26,
  4.374977547517418e-28, -9.484810417830098e-30,  9.848194585566780e-16, -8.571625277402007e-17,  5.808963705492460e-18, -3.021512403210534e-19,  1.346367891581617e-20,
 -5.300196080604188e-22,  1.880448157449093e-23, -6.128862844290172e-25,  1.853710395893723e-26, -5.244206113832402e-28,  1.398723434494179e-29, -3.531310797750510e-31,
  1.472087463553735e-18, -2.007781628237470e-19,  1.850410817550923e-20, -1.297609203885920e-21,  7.582096270500591e-23, -3.841857796772864e-24,  1.732261703154082e-25,
 -7.077218281096304e-27,  2.653045084644720e-28, -9.213600348456513e-30,  2.986706913248935e-31, -9.083810107596481e-33,  7.406544767101744e-22, -1.890012813719895e-22,
  2.802994490754613e-23, -3.012830598558429e-24,  2.579512080553176e-25, -1.850253207914626e-26,  1.147605038287188e-27, -6.289363720858799e-29,  3.093769272450906e-30,
 -1.382340706128727e-31,  5.663180640731025e-33, -2.140987683911867e-34,  1.025640978237315e-01, -4.395263333435464e-04,  1.933739729730591e-06, -8.135795654852514e-09,
  1.158586104460383e-10,  1.664477332465199e-12,  7.537070821155007e-16, -1.297892970722151e-15, -2.847116850721650e-17,  2.177010561776043e-19,  2.208505584876650e-20,
  3.257885305931099e-22,  7.608815189873873e-02, -3.469976165738547e-04,  2.125089267548936e-06, -1.409706650065077e-08,  1.152588545406468e-10, -1.549194021655729e-13,
  4.008111056444946e-15, -3.529344260481353e-16, -7.051403676699911e-18,  5.171739920748455e-20,  5.525336412037474e-21,  8.367962646109456e-23,  4.176289954279135e-02,
 -2.138952274085033e-04,  1.949777171570860e-06, -1.738003719613478e-08,  1.115625858340037e-10, -1.838500824255530e-12,  8.526689163370144e-15,  4.484767068058964e-16,
  1.172262545012853e-17, -9.155545560753041e-20, -8.767868507016960e-21, -1.278331943483198e-22,  1.686624525342137e-02, -1.010654597628035e-04,  1.289081241236197e-06,
 -1.372653451027943e-08,  9.248857882347189e-11, -2.074763822972458e-12,  1.053347146415607e-14,  5.322167773731785e-16,  1.444634261572066e-17, -1.102193229175289e-19,
 -1.054830518161650e-20, -1.573268410812182e-22,  4.968791965974739e-03, -3.582551893863474e-05,  5.930753981694931e-07, -7.215212049262737e-09,  5.765932002223485e-11,
 -1.322066456163264e-12,  8.383432547381632e-15,  2.628404300798987e-16,  8.352803341423506e-18, -6.306858768310222e-20, -5.757891100428060e-21, -8.829574872994804e-23,
  1.054828079257592e-03, -9.317419207017966e-06,  1.887657846487733e-07, -2.588550974285838e-09,  2.531503347136731e-11, -5.557889445634243e-13,  4.460788495398784e-15,
  6.597185510211103e-17,  3.052897201329861e-18, -2.332818184661658e-20, -1.872447042362300e-21, -3.019518810434755e-23,  1.587207907814769e-04, -1.737420817548989e-06,
  4.136701773417371e-08, -6.387686976154852e-10,  7.624204384722414e-12, -1.608538694324431e-13,  1.609262464512728e-15,  4.757949329488181e-18,  7.784593982014680e-19,
 -6.336501820005882e-21, -3.778310556414890e-22, -6.788951648230472e-24,  1.656101120902653e-05, -2.264918983121264e-07,  6.176288472523397e-09, -1.078624438437643e-10,
  1.552170682444272e-12, -3.228974854719897e-14,  3.940828274758883e-16, -2.032882830136309e-18,  1.474908253503977e-19, -1.379744391714526e-21, -4.453228982650940e-23,
 -1.052848982840889e-24,  1.164031051539708e-06, -2.003721879415856e-08,  6.167920397299784e-10, -1.226948244241995e-11,  2.102514872731985e-13, -4.450265601936588e-15,
  6.494899827912042e-17, -7.026418105079807e-19,  2.152728498307899e-20, -2.451443561107508e-22, -2.013306179214883e-24, -1.216382408913946e-25,  5.303173445061455e-08,
 -1.159193867499741e-09,  4.006006875535451e-11, -9.160777588296976e-13,  1.852839767957763e-14, -4.117157852272681e-16,  7.078242673169818e-18, -1.063539912981960e-19,
  2.395043221782413e-21, -3.340151706608759e-23,  2.205246481519058e-25, -1.184575284779768e-26,  1.486485706967434e-09, -4.177945629715782e-11,  1.625353536454548e-12,
 -4.322816103032936e-14,  1.028286350004965e-15, -2.471647184111535e-17,  4.963526716957348e-19, -9.194709742407720e-21,  1.921217903936821e-22, -3.203230046794908e-24,
  4.540654632217911e-26, -1.034890831607755e-27,  2.384307881065113e-11, -8.783000253349756e-13,  3.891128862182046e-14, -1.222529788926184e-15,  3.431714216469005e-17,
 -9.191141018489564e-19,  2.154836357809418e-20, -4.720420633482988e-22,  1.032857350010041e-23, -2.016114915918016e-25,  3.700092459853341e-27, -7.310071425953240e-29,
  1.970907646811741e-13, -9.810941132108157e-15,  5.067309092865777e-16, -1.923679952600910e-17,  6.456099118732797e-19, -1.990086587599324e-20,  5.498789041932793e-22,
 -1.415548981458627e-23,  3.468909847951014e-25, -7.894212715359144e-27,  1.709203492831497e-28, -3.602000335788136e-30,  7.162126662010811e-16, -5.075674444436152e-17,
  3.191818883573243e-18, -1.518338940301759e-19,  6.270702481803483e-21, -2.318344380437721e-22,  7.733690134556543e-24, -2.382593158973300e-25,  6.855428699332882e-27,
 -1.846443372161860e-28,  4.704964879936607e-30, -1.140273310343334e-31,  8.893491527582972e-19, -9.905521070697957e-20,  8.257966315084054e-21, -5.266455614358579e-22,
  2.841230280281472e-23, -1.343038937111174e-24,  5.685528921991937e-26, -2.194515309184454e-27,  7.812293793106283e-29, -2.586852721871362e-30,  8.026544516976936e-32,
 -2.344725155863411e-33,  2.755286490066411e-22, -5.993728947797191e-23,  8.020404354184788e-24, -7.935294103675661e-25,  6.348992891006887e-26, -4.301824785130564e-27,
  2.541264744988009e-28, -1.335277825363901e-29,  6.331376475977676e-31, -2.739125439859358e-32,  1.090637474849645e-33, -4.020392949537350e-35,  1.008363617557826e-01,
 -4.244129521114795e-04,  1.848296459597348e-06, -6.028809633304882e-09,  1.459081306592063e-10,  1.157416404462479e-12, -4.582399326448568e-14, -1.893050922918660e-15,
 -2.569054446591632e-18,  1.233862954577933e-18,  2.340259649279578e-20, -3.979411445037887e-22,  7.473313545297668e-02, -3.306424311561675e-04,  1.966893798793367e-06,
 -1.227626582235455e-08,  1.122035153669486e-10, -1.994181574333313e-13, -8.416502204163307e-15, -5.008755502733706e-16, -6.378989984116288e-19,  3.088009519758944e-19,
  6.012666764851634e-21, -9.555014371202592e-23,  4.093723346103189e-02, -1.991036050005074e-04,  1.750762704759569e-06, -1.587310959027575e-08,  7.805273663473229e-11,
 -1.446465233571229e-12,  2.530926623259512e-14,  6.954162731561077e-16,  1.279804001603521e-18, -4.926955286523595e-19, -9.159361289214373e-21,  1.617097023375842e-22,
  1.648159700272147e-02, -9.138956228286957e-05,  1.131932821934912e-06, -1.255901506271124e-08,  5.497132235905814e-11, -1.597744942275275e-12,  3.067004617664030e-14,
  8.398704394247703e-16,  1.832776536470173e-18, -5.969487640973005e-19, -1.123811512168102e-20,  1.896077278482156e-22,  4.834450339305589e-03, -3.141348662809972e-05,
  5.111990486346992e-07, -6.490259659765561e-09,  3.396703833760812e-11, -1.006185813242961e-12,  1.879250050763463e-14,  4.438203221118502e-16,  1.334187537872384e-18,
 -3.311748742306779e-19, -6.254476095926621e-21,  1.013425153004048e-22,  1.020390584589139e-03, -7.925460821484629e-06,  1.597875992419068e-07, -2.265808588915725e-09,
  1.547117073742028e-11, -4.168698827539508e-13,  7.434487479201374e-15,  1.338439767252823e-16,  6.531755161903082e-19, -1.117985916203760e-19, -2.092982997391820e-21,
  3.222447134882979e-23,  1.523870563954194e-04, -1.435302236015070e-06,  3.433458848373505e-08, -5.403274519080532e-10,  4.817374773563804e-12, -1.181451451803669e-13,
  2.033415259564073e-15,  2.265687566997057e-17,  2.288754843196995e-19, -2.471218092790307e-20, -4.443758419673442e-22,  6.386573882227714e-24,  1.574620214249910e-05,
 -1.818825987277748e-07,  5.011269566346149e-09, -8.769067072584740e-11,  9.988554908917294e-13, -2.304158884134570e-14,  3.928842530385766e-16,  1.476718530700217e-18,
  5.767850939611501e-20, -3.716098476814907e-21, -5.898252051330691e-23,  7.652099362225287e-25,  1.092890845534502e-06, -1.564087129135460e-08,  4.870644142418647e-10,
 -9.538208061067138e-12,  1.356052716206333e-13, -3.058672788400096e-15,  5.342964759615621e-17, -1.791675432094358e-19,  1.025527386142203e-20, -3.977766160189295e-22,
 -4.395868053865079e-24,  4.589730176864374e-26,  4.897265810406696e-08, -8.782156088536261e-10,  3.060160631205922e-11, -6.771383860196567e-13,  1.179184083818737e-14,
 -2.699853056903476e-16,  4.999468119075822e-18, -4.812443823299203e-20,  1.248477716693390e-21, -3.237992446629769e-23, -8.765171442949311e-26, -5.847957391168518e-28,
  1.342438350719706e-09, -3.060563801053186e-11,  1.190902970809378e-12, -3.015926354279462e-14,  6.354053512876096e-16, -1.529472194010049e-17,  3.096775231079437e-19,
 -4.618465166379207e-21,  1.003380770029878e-22, -2.098500662429597e-24,  1.480289754078942e-26, -3.463683718947981e-28,  2.087108863288284e-11, -6.175912316576646e-13,
  2.700895123220571e-14, -7.963135869207708e-16,  2.020370612228726e-17, -5.290349446015234e-19,  1.203905768155393e-20, -2.344638998164679e-22,  5.096460754668106e-24,
 -1.033348449964885e-25,  1.522771134548686e-27, -3.014028384427527e-29,  1.647058802328635e-13, -6.531032887807787e-15,  3.267355890129946e-16, -1.148928433051341e-17,
  3.529772104834334e-19, -1.042777755963081e-20,  2.740769489546106e-22, -6.541388000540930e-24,  1.551413061816564e-25, -3.428822303557642e-27,  6.810101318951148e-29,
 -1.404908110123925e-30,  5.547294473055251e-16, -3.110114643875253e-17,  1.846182837940414e-18, -8.040126969262884e-20,  3.055828544113804e-21, -1.065428073666722e-22,
  3.345757360864518e-24, -9.688628862554672e-26,  2.658783945822759e-27, -6.830484558525875e-29,  1.650784547271844e-30, -3.851487444145330e-32,  5.939506245933292e-19,
 -5.218839910700447e-20,  3.972672047162812e-21, -2.295233926852672e-22,  1.138153699780083e-23, -5.014186041501498e-25,  1.987909597591421e-26, -7.226752925250492e-28,
  2.438885271185268e-29, -7.682083556592188e-31,  2.275110591049056e-32, -6.372173279855281e-34,  1.216598783807168e-22, -2.147689645109692e-23,  2.558561214980080e-24,
 -2.298037446430251e-25,  1.699728399727422e-26, -1.078222408271381e-27,  6.019186895416572e-29, -3.011670659909766e-30,  1.368324090394649e-31, -5.701462312862526e-33,
  2.196020684622581e-34, -7.860512666186842e-36,  9.916788225273704e-02, -4.098749933885821e-04,  1.790479872614129e-06, -3.586456407896497e-09,  1.539111807230755e-10,
 -5.414126711577425e-13, -9.230674114017126e-14, -1.137141279379789e-15,  5.161154070088444e-17,  1.510081034403790e-18, -1.629404034161112e-20, -1.278261301218059e-21,
  7.344114560114461e-02, -3.154664199300239e-04,  1.830170166286621e-06, -1.052855580168889e-08,  1.050960007641414e-10, -5.603767753662056e-13, -2.079608569362585e-14,
 -3.100594873140769e-16,  1.306388965852497e-17,  3.860991947758322e-19, -3.887886904054919e-21, -3.243303479285389e-22,  4.016765227116212e-02, -1.858401340748695e-04,
  1.566948479959918e-06, -1.481622438723640e-08,  5.672153943722932e-11, -6.191884095272011e-13,  4.230126906003324e-14,  4.032765049525904e-16, -2.020743373569754e-17,
 -5.949737737034408e-19,  6.657182512991601e-21,  5.045553094117387e-22,  1.613321347586423e-02, -8.292410975205290e-05,  9.855984521263219e-07, -1.188728497808322e-08,
  3.222254895807755e-11, -5.952249277795522e-13,  5.129789585909351e-14,  4.933818725792047e-16, -2.435759635567649e-17, -7.305048437775499e-19,  7.795129734599990e-21,
  6.145496085499752e-22,  4.716493570708041e-03, -2.762753706740125e-05,  4.360034811485673e-07, -6.079115080703502e-09,  1.933297604237614e-11, -4.136500527041634e-13,
  2.975618518483945e-14,  2.612760733509002e-16, -1.324881181176943e-17, -4.091012011547752e-19,  4.178424549861827e-21,  3.406112445873921e-22,  9.910783340090629e-04,
 -6.752275020927041e-06,  1.338428675818454e-07, -2.074010322815692e-09,  9.216243119958724e-12, -1.953050127363118e-13,  1.077895521694412e-14,  7.867104672077259e-17,
 -4.278685813898789e-18, -1.391793380313998e-19,  1.344550752383093e-21,  1.138651069488039e-22,  1.471557721215358e-04, -1.185412181966472e-06,  2.824434046395131e-08,
 -4.792821005626265e-10,  2.994283284299468e-12, -6.182710711930458e-14,  2.617140872478082e-15,  1.323444080324537e-17, -8.571142360635444e-19, -3.079467834482073e-20,
  2.769851723635284e-22,  2.439286403152626e-23,  1.509252924400469e-05, -1.457615213028737e-07,  4.041367442997121e-09, -7.486722892603929e-11,  6.361672382377185e-13,
 -1.304492463570062e-14,  4.373517497194270e-16,  8.445431167759502e-19, -1.025471779019768e-19, -4.540030061611492e-21,  3.755921811403208e-23,  3.373092824739340e-24,
  1.037441992403023e-06, -1.216950823748839e-08,  3.838275405930572e-10, -7.789457612330870e-12,  8.698023506770322e-14, -1.813737092263558e-15,  5.065908351633202e-17,
 -1.052946879805399e-19, -6.011186552521711e-21, -4.531594824127284e-22,  3.502759316702581e-24,  2.939554339458831e-25,  4.590199678539876e-08, -6.630680356315449e-10,
  2.344980302328160e-11, -5.255382041297392e-13,  7.501545419909693e-15, -1.627504894546038e-16,  4.032392203627237e-18, -2.725605490591018e-20,  5.842558024343351e-23,
 -3.147220497183145e-23,  2.506203080960824e-25,  1.504118259386859e-26,  1.236994553983012e-09, -2.237404779939237e-11,  8.810979834337882e-13, -2.207441221683340e-14,
  3.949509526792443e-16, -9.117656405832517e-18,  2.146618477729578e-19, -2.518718094738346e-21,  3.378159627992937e-23, -1.592114091506266e-24,  1.570181352097026e-26,
  3.502062052755889e-28,  1.877916153634073e-11, -4.349592807954458e-13,  1.908904457864062e-14, -5.439418262111976e-16,  1.206262628442092e-17, -3.035198913080472e-19,
  7.269470344481870e-21, -1.212021887169101e-22,  2.233441464209610e-24, -6.030463414258851e-26,  8.203902116900281e-28, -3.942086404372203e-30,  1.430535698908668e-13,
 -4.386425013794090e-15,  2.168766433846710e-16, -7.206175390361346e-18,  1.978395041149456e-19, -5.584707233507429e-21,  1.450159370304848e-22, -3.126342371359839e-24,
  6.891510687062670e-26, -1.615066635968342e-27,  2.922728821930403e-29, -4.837955690951169e-31,  4.547440711422919e-16, -1.949732485250102e-17,  1.116381983677799e-18,
 -4.496657874185558e-20,  1.549690868386490e-21, -5.107119851687282e-23,  1.529114430720996e-24, -4.111284650105575e-26,  1.069540144801735e-27, -2.676712426495070e-29,
  6.065653192197400e-31, -1.327543344936437e-32,  4.348587011825217e-19, -2.895079464655292e-20,  2.048465749405900e-21, -1.072915156949252e-22,  4.851615287279478e-24,
 -1.993579050216911e-25,  7.405856274317314e-27, -2.523224510212033e-28,  8.060516479630276e-30, -2.416901257252350e-31,  6.802135192085414e-33, -1.821165162014401e-34,
  6.409410741223740e-23, -8.657791671735930e-24,  9.140588492522587e-25, -7.358563953123400e-26,  4.977404519419121e-27, -2.932032536467259e-28,  1.534941572875124e-29,
 -7.261771129508633e-31,  3.142249181351470e-32, -1.254075711135665e-33,  4.648783578244120e-35, -1.608540072905584e-36,  9.755681437134217e-02, -3.956830835125967e-04,
  1.761450410329283e-06, -1.337761959522961e-09,  1.195027929973901e-10, -2.909207927752608e-12, -9.438079316847151e-14,  1.150424842308547e-15,  8.119199231968121e-17,
 -1.769351538806631e-19, -6.148072388606705e-20, -3.811836022252455e-22,  7.220780147262909e-02, -3.013028818019722e-04,  1.713453329291687e-06, -8.965751622222885e-09,
  8.848668122374345e-11, -1.105346858031010e-12, -2.191097775956699e-14,  2.727272393161890e-16,  2.081808950427335e-17, -3.587451572434184e-20, -1.562758122355308e-20,
 -1.078206077849211e-22,  3.944825788509492e-02, -1.740008666178366e-04,  1.394375896082645e-06, -1.395029137820784e-08,  5.495323104209168e-11,  4.415872682543382e-13,
  4.193490564025771e-14, -4.922334675951923e-16, -3.171205696492775e-17,  7.666453801279960e-20,  2.425468866115322e-20,  1.407809298341794e-22,  1.581639492613104e-02,
 -7.560160153133575e-05,  8.458766333980110e-07, -1.139723500824495e-08,  3.320228332795297e-11,  6.927824783791404e-13,  5.098000359554757e-14, -5.946567302271220e-16,
 -3.875915322160520e-17,  8.007148375161031e-20,  2.959504670533755e-20,  1.862408303357095e-22,  4.612504388099724e-03, -2.442641653290004e-05,  3.647671218841708e-07,
 -5.795701143693346e-09,  1.849524098054988e-11,  3.286513738679013e-13,  2.932164049719920e-14, -3.371010015092287e-16, -2.146216663167180e-17,  3.696506955471434e-20,
  1.644087520247448e-20,  1.104542642473496e-22,  9.660563606682528e-04, -5.778780903674805e-06,  1.097573899965301e-07, -1.943326588724919e-09,  7.978051884265672e-12,
  7.033729730351062e-14,  1.044255512837394e-14, -1.182866070210769e-16, -7.139504243882722e-18,  8.887558075371102e-21,  5.518851403640409e-21,  3.992000530070260e-23,
  1.428306616788035e-04, -9.817200019033133e-07,  2.275083906492374e-08, -4.377948718718403e-10,  2.395954338450446e-12,  1.436461261317757e-15,  2.464579355605749e-15,
 -2.768651631495813e-17, -1.510463736820753e-18,  7.760536503373768e-22,  1.192244539258077e-21,  9.379916337989478e-24,  1.456867795121875e-05, -1.168672877271449e-07,
  3.197272477623652e-09, -6.620583966980143e-11,  4.796527632003248e-13, -2.768836201283395e-15,  3.942690112590288e-16, -4.467408277756627e-18, -2.030538788049396e-19,
 -1.487531469164638e-22,  1.680398754549394e-22,  1.446735220286906e-24,  9.943434989476740e-07, -9.451458143378791e-09,  2.977169965385673e-10, -6.623484232029819e-12,
  6.245417072108354e-14, -6.684931631074022e-16,  4.290978910065604e-17, -5.054990494115341e-19, -1.660745715612057e-20, -5.413535853673123e-23,  1.536652635292691e-23,
  1.436398092555364e-25,  4.358757645938135e-08, -4.988695597709741e-10,  1.777238321927134e-11, -4.265634526312145e-13,  5.149503677428074e-15, -7.586352441858219e-17,
  3.146849169505052e-18, -4.019789591638765e-20, -7.240785311687109e-22, -7.525586163923225e-24,  9.017424590817419e-25,  8.699994480087237e-27,  1.160053818336212e-09,
 -1.628956160871467e-11,  6.489477986657619e-13, -1.695651239894634e-14,  2.588293333772791e-16, -4.737668459412250e-18,  1.517243398068177e-19, -2.197680563605313e-21,
 -7.738447510645305e-24, -5.869285520756202e-25,  3.409928053950641e-26,  2.791555349306054e-28,  1.730750454303706e-11, -3.054800816881630e-13,  1.354728332375919e-14,
 -3.910556433595823e-16,  7.496053700821387e-18, -1.634832405547505e-19,  4.594540752015510e-21, -7.821222433888170e-23,  6.489703584865507e-25, -2.719461674044593e-26,
  8.799872817253772e-28,  2.050252301583820e-30,  1.284963919920880e-13, -2.950887842661678e-15,  1.462498867873314e-16, -4.771090981237661e-18,  1.149451054576340e-19,
 -2.952096927307299e-21,  8.102351969173234e-23, -1.658490574754038e-24,  2.799009727456366e-26, -7.356517333573817e-28,  1.721059202362996e-29, -1.439547279205105e-31,
  3.917064026964262e-16, -1.236951810876747e-17,  6.973814783340080e-19, -2.668072165125071e-20,  8.187501375224919e-22, -2.506611974873141e-23,  7.400747056996586e-25,
 -1.855357960221722e-26,  4.331428697933343e-28, -1.090674969284183e-29,  2.491328138317196e-31, -4.537607121523715e-33,  3.452069937016494e-19, -1.664380836267236e-20,
  1.120935112631647e-21, -5.387060779760045e-23,  2.191883858820348e-24, -8.373923572080087e-26,  2.943715330028635e-27, -9.354228422586025e-29,  2.799203922113908e-30,
 -8.054982605160070e-32,  2.163010105475230e-33, -5.434044349861536e-35,  3.994916146497450e-23, -3.866759499233464e-24,  3.652605887712747e-25, -2.614391967592538e-26,
  1.598090513787058e-27, -8.683447834389630e-29,  4.237477022837822e-30, -1.881738637745490e-31,  7.706671161115113e-33, -2.931608834071504e-34,  1.040415400353256e-35,
 -3.461977612837351e-37,  9.600220271665640e-02, -3.816283345872154e-04,  1.754592928814312e-06,  1.727205364871104e-12,  4.270637122264428e-11, -4.517178277204565e-12,
 -3.013857440007500e-14,  3.177593976620472e-15,  3.237669569802963e-17, -2.326626305337990e-18, -3.045780199652261e-20,  1.676014160042468e-21,  7.102935535355061e-02,
 -2.880033904195599e-04,  1.613547184630382e-06, -7.751499704496799e-09,  6.210770771513153e-11, -1.469853883484080e-12, -6.008464970474397e-15,  7.980738940683106e-16,
  8.624082637615733e-18, -5.912492545149935e-19, -8.124448257756471e-21,  4.237557921219850e-22,  3.877352660735801e-02, -1.634995309981766e-04,  1.232698925158279e-06,
 -1.295235279510460e-08,  7.217569652193738e-11,  1.177230993635673e-12,  1.569132438818387e-14, -1.278632999563048e-15, -1.230589378631641e-17,  9.169443140266161e-19,
  1.168465906726117e-20, -6.630295105009670e-22,  1.552667099232226e-02, -6.937117777075548e-05,  7.129485085122013e-07, -1.069674278071828e-08,  5.726147011801827e-11,
  1.587235686633517e-12,  1.903028439261045e-14, -1.562787775363653e-15, -1.541412243093238e-17,  1.117313414367511e-18,  1.477061954251606e-20, -8.057676739083478e-22,
  4.520202570391717e-03, -2.178071595422470e-05,  2.973230115860035e-07, -5.413502165908145e-09,  3.096179080484861e-11,  8.473130309530056e-13,  1.137767733915324e-14,
 -8.764166046355789e-16, -8.690103620863005e-18,  6.190453144244461e-19,  8.459481005513790e-21, -4.458499865312580e-22,  9.445529694515820e-04, -4.991643465082206e-06,
  8.728973988707915e-08, -1.792378253394156e-09,  1.149620825154025e-11,  2.572391333016143e-13,  4.287014957351815e-15, -2.990239152219848e-16, -2.948465290044156e-18,
  2.067108033027261e-19,  2.946151648525608e-21, -1.488283039442865e-22,  1.392354698557169e-04, -8.200543767144771e-07,  1.773772131695027e-08, -3.963741664645224e-10,
  2.926495404064666e-12,  4.618327228779104e-14,  1.083561994315892e-15, -6.630150867227977e-17, -6.379216227610391e-19,  4.418187625756955e-20,  6.663424753130860e-22,
 -3.187676324686154e-23,  1.414751604179918e-05, -9.433765462828261e-08,  2.448539826054253e-09, -5.851561796441996e-11,  5.051262719284199e-13,  4.500970568244078e-15,
  1.868764961524117e-16, -9.732054100561016e-18, -8.791269898827499e-20,  6.087884391305043e-21,  9.940289482797853e-23, -4.429083290264988e-24,  9.608208198977857e-07,
 -7.371342686047411e-09,  2.239551180479084e-10, -5.681094895211731e-12,  5.793413459344187e-14,  1.340218602437373e-16,  2.189543107278637e-17, -9.463072128227407e-19,
 -7.384111822819184e-21,  5.291655893590831e-22,  9.733041464797395e-24, -3.945431128984353e-25,  4.184589394324576e-08, -3.758556218124890e-10,  1.311003558821363e-11,
 -3.526365308348301e-13,  4.282654259456705e-15, -1.645587564086192e-17,  1.707721978840266e-18, -6.049599825642324e-20, -3.313507991652319e-22,  2.746502240763111e-23,
  6.162129850090427e-25, -2.195138790003548e-26,  1.104081427356871e-09, -1.184751257615015e-11,  4.677725568178272e-13, -1.339700157325853e-14,  1.953133869180095e-16,
 -1.872484579027128e-18,  8.548627176719110e-20, -2.511807070634737e-21, -3.803470134182826e-24,  7.452691326531898e-25,  2.481360748709959e-26, -7.385632725643964e-28,
  1.627521607596796e-11, -2.140466870110829e-13,  9.483791888547164e-15, -2.919963730733675e-16,  5.160870167271314e-18, -7.780812672985244e-20,  2.596554548474147e-21,
 -6.636305629231878e-23,  2.896606440993119e-25,  5.650636220766162e-27,  6.333821345755901e-28, -1.489199155572220e-29,  1.187092356062137e-13, -1.982508746619198e-15,
  9.838603311621179e-17, -3.312887110349200e-18,  7.202294974470592e-20, -1.483585912949664e-21,  4.402288281353083e-23, -1.065511441589695e-24,  1.242832189077913e-26,
 -1.721355846108198e-28,  1.050086077897872e-29, -1.994709574555647e-31,  3.516298149710039e-16, -7.881048210021153e-18,  4.419715789175540e-19, -1.677873202600483e-20,
  4.597441447564089e-22, -1.227454306803049e-23,  3.673721155798716e-25, -9.377882267439225e-27,  1.811995766833352e-28, -3.961173345413503e-30,  1.146954269883761e-31,
 -2.191921129976942e-33,  2.931732094152344e-19, -9.772053782112810e-21,  6.400156059601316e-22, -2.909780626471765e-23,  1.054232087964534e-24, -3.657872950596367e-26,
  1.239270327038151e-27, -3.741534920235546e-29,  1.016900018275660e-30, -2.763907416306979e-32,  7.437428106443049e-34, -1.760328944023602e-35,  2.881538360453226e-23,
 -1.868209673685224e-24,  1.616257309740152e-25, -1.033395820954851e-26,  5.627516571721922e-28, -2.797243769029589e-29,  1.271086561074005e-30, -5.269464914137213e-32,
  2.024682859665991e-33, -7.308210404114147e-35,  2.477842985900629e-36, -7.880084238385871e-38,  9.450377021069788e-02, -3.675868584367673e-04,  1.755690277548121e-06,
 -4.570646125153776e-11, -4.740528701447178e-11, -4.137705264742816e-12,  5.997649100285185e-14,  2.795632720976548e-15, -5.384908355434751e-17, -1.933598559713493e-18,
  4.727839931885411e-20,  1.301653308491331e-21,  6.990259032012631e-02, -2.754524376362940e-04,  1.525517575334420e-06, -6.992895510003663e-09,  3.315131646992865e-11,
 -1.335648471197354e-12,  1.678497042440043e-14,  7.108814558580459e-16, -1.353634950622152e-17, -5.031667474717218e-19,  1.192150369483891e-20,  3.433440492532069e-22,
  3.813829745355695e-02, -1.542381606766381e-04,  1.085008517900140e-06, -1.160128603069906e-08,  9.649262728058670e-11,  1.111912049137007e-12, -2.037458914306010e-14,
 -1.115954770193202e-15,  2.146424511827747e-17,  7.518138548365904e-19, -1.872671683584674e-20, -5.025332634580408e-22,  1.525980578436065e-02, -6.416296061296213e-05,
  5.911706825412837e-07, -9.517165158983601e-09,  8.990760577104325e-11,  1.502517472053829e-12, -2.520936947657080e-14, -1.374137628697758e-15,  2.607272061263574e-17,
  9.319282956687012e-19, -2.270864080542357e-20, -6.296806774198970e-22,  4.437439105248509e-03, -1.965221680544400e-05,  2.359170516308860e-07, -4.776337226896666e-09,
  4.858116217516086e-11,  8.163744420540949e-13, -1.348165157045802e-14, -7.747429942047068e-16,  1.446606065086478e-17,  5.242234109028165e-19, -1.253542467493614e-20,
 -3.577803412987669e-22,  9.258517687022688e-04, -4.375819999488418e-06,  6.706468621861479e-08, -1.564635588505737e-09,  1.696761912560840e-11,  2.563372563621819e-13,
 -4.207084897725751e-15, -2.657227050825308e-16,  4.857212157780178e-18,  1.784051686803188e-19, -4.169310517067771e-21, -1.233490855053925e-22,  1.362101554020982e-04,
 -6.963064137932994e-07,  1.329545188108454e-08, -3.414006004109937e-10,  3.954589931626656e-12,  4.918374931680986e-14, -8.004490999583989e-16, -5.918154633939134e-17,
  1.051985090114494e-18,  3.910139629783696e-20, -8.876022734150443e-22, -2.751802097143263e-23,  1.380509927905703e-05, -7.741274023307411e-08,  1.798343670454824e-09,
 -4.956534286682570e-11,  6.172066375245463e-13,  5.617635367942192e-15, -8.905247808406783e-17, -8.701262517676830e-18,  1.492297960200143e-19,  5.576394878062095e-21,
 -1.219668468823888e-22, -4.025348693324281e-24,  9.345096609153151e-07, -5.836292833895919e-09,  1.614993565019870e-10, -4.713398393961480e-12,  6.366672363614098e-14,
  3.341989263577456e-16, -4.732125125213825e-18, -8.415334806757630e-19,  1.381459154432880e-20,  5.096414688245273e-22, -1.062380953078373e-23, -3.824798486701584e-25,
  4.052705789716788e-08, -2.867504559243772e-10,  9.284287175304132e-12, -2.851046563169991e-13,  4.224319431633804e-15,  4.035188582793395e-18,  3.537756050662576e-20,
 -5.272419119457339e-20,  8.248098826618871e-22,  2.873037201157498e-23, -5.615877057253424e-25, -2.302779813425031e-26,  1.063229581567894e-09, -8.697503344771131e-12,
  3.248187464871682e-13, -1.048390004497105e-14,  1.727369062059345e-16, -6.487067776308636e-19,  1.842145612826565e-20, -2.088109594215817e-21,  3.139154293179222e-23,
  9.283427383438333e-25, -1.649778008760445e-26, -8.456200946988928e-28,  1.555042811250014e-11, -1.508877386629005e-13,  6.433220740007228e-15, -2.190949362161054e-16,
  4.084100448670917e-18, -3.641509291637433e-20,  9.249478024524459e-22, -5.047055477356153e-23,  7.571920594814066e-25,  1.457241107222248e-26, -2.122940473356996e-28,
 -1.805708799581217e-29,  1.121266935433112e-13, -1.336778163347355e-15,  6.472649779353039e-17, -2.349871436677624e-18,  5.071718777333649e-20, -7.433955509633316e-22,
  1.929428671129388e-23, -7.048326195757703e-25,  1.142440602257645e-26,  4.790208586673870e-29,  3.495952141447090e-31, -2.158175346671636e-31,  3.260573585953231e-16,
 -5.041549606114670e-18,  2.779941310109995e-19, -1.098660078979637e-20,  2.840815937502305e-22, -6.057909674655411e-24,  1.698122122087617e-25, -5.152085565386118e-27,
  9.976638030075046e-29, -1.104454268999274e-30,  3.293342425443948e-32, -1.493724049695140e-33,  2.624566795613515e-19, -5.808508260918919e-21,  3.723048047259748e-22,
 -1.676674154023466e-23,  5.509684615048509e-25, -1.647724037323161e-26,  5.311173595851591e-28, -1.630391549549744e-29,  4.096047578196853e-31, -9.315613660795467e-33,
  2.491090763845472e-34, -6.790322444405149e-36,  2.331427429317055e-23, -9.519611715243083e-25,  7.743950426129204e-26, -4.543500954095740e-27,  2.184137640133688e-28,
 -9.734883079345340e-30,  4.122761082657208e-31, -1.606874095111913e-32,  5.738539936550815e-34, -1.935820095066170e-35,  6.276684971188242e-37, -1.922394789084812e-38,
  };
  int offset = -16;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 16;
    if (std::isnan(t)) {
      fill_n(rr+offset, 16, 0.5);
      fill_n(ww+offset, 16, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 16; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=16; ++j) {
        const int boxof = it*192+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
