var count = (function cmp(BigNumber) {
    var start = +new Date(),
        log,
        error,
        undefined,
        passed = 0,
        total = 0,
        n = 'null',
        N = 'NaN',
        I = 'Infinity';

    if (typeof window === 'undefined') {
        log = console.log;
        error = console.error;
    } else {
        log = function (str) { document.body.innerHTML += str.replace('\n', '<br>') };
        error = function (str) { document.body.innerHTML += '<div style="color: red">' +
          str.replace('\n', '<br>') + '</div>' };
    }

    if (!BigNumber && typeof require === 'function') BigNumber = require('../bignumber');

    function assert(expected, actual) {
        total++;
        if (expected !== actual) {
           error('\n Test number: ' + total + ' failed');
           error(' Expected: ' + expected);
           error(' Actual:   ' + actual);
           //process.exit();
        }
        else {
            passed++;
            //log('\n Expected and actual: ' + actual);
        }
    }

    function T(a, b, expected) {
        assert(String(expected), String(new BigNumber(a).cmp(b)));
        assert(String(expected), String(new BigNumber(a).cmp(new BigNumber(b))));
    }

    function isMinusZeroJS(n) {
        return n === 0 ? 1 / n === -Infinity : null
    }

    log('\n Testing cmp...');

    BigNumber.config({
        DECIMAL_PLACES : 20,
        ROUNDING_MODE : 4,
        ERRORS : false,
        RANGE : 1E9,
        EXPONENTIAL_AT : 1E9
    });

    T(1, 0, 1);
    T(1, -0, 1);
    T(-1, 0, -1);
    T(-1, -0, -1);
    T(1, N, n);
    T(-1, N, n);
    T(1, I, -1);
    T(1, -I, 1);
    T(-1, I, -1);
    T(-1, -I, 1);
    T(0, 1, -1);
    T(0, -1, 1);
    T(-0, 1, -1);
    T(-0, -1, 1);
    assert(false, isMinusZeroJS(new BigNumber(0).cmp(0)));
    assert(false, isMinusZeroJS(new BigNumber(0).cmp(-0)));
    assert(false, isMinusZeroJS(new BigNumber(-0).cmp(0)));
    assert(false, isMinusZeroJS(new BigNumber(-0).cmp(-0)));
    T(0, N, n);
    T(-0, N, n);
    T(0, I, -1);
    T(0, -I, 1);
    T(-0, I, -1);
    T(-0, -I, 1);
    T(N, 1, n);
    T(N, -1, n);
    T(N, 0, n);
    T(N, -0, n);
    T(N, N, n);
    T(N, I, n);
    T(N, -I, n);
    T(I, 1, 1);
    T(I, -1, 1);
    T(-I, 1, -1);
    T(-I, -1, -1);
    T(I, 0, 1);
    T(I, -0, 1);
    T(-I, 0, -1);
    T(-I, -0, -1);
    T(I, N, n);
    T(-I, N, n);
    assert(false, isMinusZeroJS(new BigNumber(I).cmp(I)));
    T(I, -I, 1);
    T(-I, I, -1);
    assert(false, isMinusZeroJS(new BigNumber(-I).cmp(-I)));

    T(0, '0.1', '-1');
    T(0, '-0.1', '1');
    T(-0, '0.1', '-1');
    T(-0, '-0.1', '1');
    T('0.1', 0, '1');
    T('0.1', -0, '1');
    T('-0.1', 0, '-1');
    T('-0.1', -0, '-1');
    T(0, '0.000000009', '-1');
    T(0, '-0.000000009', '1');
    T(-0, '0.000000009', '-1');
    T(-0, '-0.000000009', '1');
    T('0.000000009', 0, '1');
    T('0.000000009', -0, '1');
    T('-0.000000009', 0, '-1');
    T('-0.000000009', -0, '-1');
    T(0, '5.5', '-1');
    T(0, '-5.5', '1');
    T(-0, '5.5', '-1');
    T(-0, '-5.5', '1');
    T('5.5', 0, '1');
    T('5.5', -0, '1');
    T('-5.5', 0, '-1');
    T('-5.5', -0, '-1');

    T(1, '0', '1');
    T(1, '1', '0');
    T(1, '-45', '1');
    T(1, '22', '-1');
    T(1, 0144, '-1');
    T(1, '0144', '-1');
    T(1, '6.1915', '-1');
    T(1, '-1.02', '1');
    T(1, '0.09', '1');
    T(1, '-0.0001', '1');
    T(1, '8e5', '-1');
    T(1, '9E12', '-1');
    T(1, '1e-14', '1');
    T(1, '3.345E-9', '1');
    T(1, '-345.43e+4', '1');
    T(1, '-94.12E+0', '1');
    T(1, '', n);
    T(1, '    ', n);
    T(1, '\t\t', n);
    T(1, 'ertgrt546', n);
    T(1, 'qweqwdewee', n);
    T(1, true, n);
    T(1, false, n);
    T(1, 'e 4.3', n);
    T(1, '4 .3', n);
    T(1, '4.0 01e', n);
    T(1, ' 4.001', '-1');
    T(1, '4.001 ', '-1');
    T(1, ' 4.001 ', '-1');
    T(1, '    4.001', '-1');
    T(1, ' 4.0 01', n);
    T(1, '4. 001', n);
    T(1, '4. 001 ', n);
    T(1, '  4.001e ', n);
    T(1, ' 4 .001 e ', n);
    T(1, undefined, n);
    T(1, null, n);
    T(1, Number.POSITIVE_INFINITY, '-1');
    T(1, Number.NEGATIVE_INFINITY, '1');
    T(1, new Date(2012, 11, 4), n);
    T(1, new Object(), n);
    T(1, function () {}, n);
    T('0', 0, '0');
    T(0, '+0', '0');
    T('0', '0', '0');
    T(3, -0, '1');
    T(9.654, 0, '1');
    T(0, '111.1111111110000', '-1');
    T(N, '0', n);
    T(-1, 1, '-1');
    T(-0.01, 0.01, '-1');
    T(54, -54, '1');
    T(9.99, '-9.99', '1');
    T('0.0000023432495704937', '-0.0000023432495704937', '1');
    T(NaN, NaN, n);
    T(NaN, N, n);
    T(N, NaN, n);
    T(N, 4, n);
    T(N, '4534534.45435435', n);
    T(N, 99999.999, n);
    T(Infinity, '354.345341', '1');
    T(3, -I, '1');
    T(-Infinity, -I, '0');
    T(-I, -Infinity, '0');
    T(I, '-999e999', '1');
    T(1.21123e43, -I, '1');
    T('-999.0', I, '-1');
    T('657.342e-45', -I, '1');
    T(I, 123, '1');
    T(-0, I, '-1');
    T(100, 100, '0');
    T(-999.99, '0.01', '-1');
    T('10 ', 4, '1');
    T('03.333', -4, '1');
    T(-1, -0.1, '-1');
    T(43534.5435, '0.054645', '1');
    T('99999', '1', '1');
    T('3e', 8, n);
    T('-3..0', 13, n);
    T('0 0', -0.4, n);
    T(' +3e0', 4, '-1');
    T(9.9806, '+ 1', n);
    T(' +2 0', '1e1', n);
    T('e3', 4, n);
    T(' ', 0, n);
    T(323, null, n);
    T(undefined, undefined, n);
    T('undefined', undefined, n);
    T(null, null, n);

    T(0.04, 0.079393068, -1);
    T(0.023, 0.04840192819, -1);
    T(0.021879, 0.02, 1);

    T('0', '-7502', 1);
    T('-1', '-0.000000000000000000295176', -1);
    T('2.9', '3.23360', -1);
    T('1.14', '4289', -1);
    T('-3', '0', -1);
    T('0.00000000000000551', '-3958.43', 1);
    T('-13', '0', -1);
    T('-23.382', '-16.1', -1);
    T('-176.85', '0', -1);
    T('1.38497', '-0.0000000561', 1);
    T('3.90', '18.124', -1);
    T('-239.52', '-0.00000000000066862', -1);
    T('5.7', '2248.28', -1);
    T('-0.00000000012', '0', -1);
    T('29', '-5', 1);
    T('0', '-54', 1);
    T('3', '-1.1', 1);
    T('-461.9', '-13803', 1);
    T('-1', '0.00054428', -1);
    T('-0.000000000000000683', '7', -1);
    T('2', '1', 1);
    T('118.608', '-4.8', 1);
    T('3', '0', 1);
    T('83.5', '44.9', 1);
    T('-3', '-2.86', -1);
    T('1138.06', '47.08', 1);
    T('-2.3', '3', -1);
    T('-848', '0', -1);
    T('5', '2', 1);
    T('11.3', '-176.3', 1);
    T('-302142', '3.8', -1);
    T('-9', '-38', 1);
    T('0', '-1', 1);
    T('6161', '-3', 1);
    T('8', '0', 1);
    T('-1334', '-14', -1);
    T('3.593', '0.000000000000059975', 1);
    T('0.0000000000000000847', '-1186.11', 1);
    T('4.62', '14.47', -1);
    T('0', '-319', 1);
    T('23168', '8.3485', 1);
    T('-16', '-1.6', -1);
    T('64.3', '2108.4', -1);
    T('4', '-1', 1);
    T('-0.50346', '-319.6', 1);
    T('10910.0', '-0.00000000000000000314208', 1);
    T('1', '0', 1);
    T('-0.0000000000000552', '0.00000000015', -1);
    T('0', '16', -1);
    T('38.4', '35.83', 1);
    T('-1.1', '-0.000002850', -1);
    T('0.000000000000011', '1.2', -1);
    T('-50.66', '2.2', -1);
    T('-1187', '5', -1);
    T('174', '-1.8175', 1);
    T('651.1', '-11.332', 1);
    T('-1', '-0.000000000000000011', -1);
    T('7156', '4.84', 1);
    T('1', '3', -1);
    T('0', '77487', -1);
    T('51.7181', '17', 1);
    T('13.132', '0.000000000000029446', 1);
    T('5.4', '0.000000000000000006325', 1);
    T('4.1', '-2.42', 1);
    T('-5.2', '-44.1', 1);
    T('-6', '15.018', -1);
    T('-27.949', '-1170.9', 1);
    T('0', '0.0000000000000000120', -1);
    T('-3.7', '-52.1', 1);
    T('-17.43', '0', -1);
    T('-1.4', '-11737', 1);
    T('-7.17', '615.40', -1);
    T('-1', '-0.000000000000000389', -1);
    T('0', '-11.7', 1);
    T('0', '-0.0000039894', 1);
    T('-14.15', '-0.0000011139', -1);
    T('-16260', '-3.97', -1);
    T('-0.00000066', '-1.3', 1);
    T('-818', '0', -1);
    T('-3', '-30020.5', 1);
    T('-3.328', '-28.16', 1);
    T('-74', '2', -1);
    T('-30332', '-1.61', -1);
    T('-0.00000000000000494', '0', -1);
    T('-2.1', '11.6037', -1);
    T('-0.0000000000000013762', '-5273', 1);
    T('-0.00000000000000000002353', '1188', -1);
    T('-0.00000000000000033619', '-4', 1);
    T('3.2', '-597.81', 1);
    T('14265', '0', 1);
    T('-18.8703', '1', -1);
    T('-4.5', '-146.5', 1);
    T('-259.7', '0', -1);
    T('-72.57', '4.3', -1);
    T('0.0000015', '9.06', -1);
    T('490815', '0.0000000000000000000385', 1);
    T('0.614', '-0.000000000000000001154', 1);
    T('1.2', '0', 1);
    T('-1.8', '-436269', 1);
    T('0', '-7', 1);
    T('-3.18290', '-453.85', 1);
    T('5.645', '1', 1);
    T('8.426', '1.0', 1);
    T('-6702', '-0.000003053', -1);
    T('0', '-0.0000000472', 1);
    T('-13.789', '0.12167', -1);
    T('0', '-22472', 1);
    T('769.0', '0.00000019970', 1);
    T('0', '-145.1', 1);
    T('-307', '-1', -1);
    T('1', '-0.000015', 1);
    T('3', '-4', 1);
    T('7', '3.791', 1);
    T('-0.0000000000000021', '0.00000414', -1);
    T('203.0', '-14124', 1);
    T('-1', '8.4', -1);
    T('-0.000301', '-3665.9', 1);
    T('2212', '120841', -1);
    T('-10.4', '1.90210', -1);
    T('-4.709', '-3.2', -1);
    T('-0.00000000000062', '-2.20513', 1);
    T('3', '-41230', 1);
    T('-0.00000000931', '-348.5', 1);
    T('4.50', '0', 1);
    T('0', '104894', -1);
    T('0.00000072', '0', 1);
    T('-1', '-73.214', 1);
    T('9', '-1.898', 1);
    T('1', '-1', 1);
    T('0', '3.99', -1);
    T('-2', '0.0486', -1);
    T('-4', '-0.00268', -1);
    T('0.0000000000791', '-4.97', 1);
    T('-13795', '3', -1);
    T('-13.197', '0', -1);
    T('0', '-4.7', 1);
    T('0', '0', 0);
    T('3.7', '0', 1);
    T('10.3925', '7.312', 1);
    T('2.263', '7.388', -1);
    T('-6.0', '-2', -1);
    T('1', '-1', 1);
    T('1.987', '32454', -1);
    T('-0.361', '-200.6', 1);
    T('5.0', '-7', 1);
    T('-6.2', '-0.0056', -1);
    T('-3.8', '1', -1);
    T('-9.3', '-7.64', -1);
    T('38364', '-127.311', 1);
    T('-1.6', '-3.06', 1);
    T('1', '-2', 1);
    T('3.952', '5', -1);
    T('566', '125.359', 1);
    T('1078.97', '496', 1);
    T('0.000000000097586', '-0.000000000000000000027457', 1);
    T('-37.5', '-28572', 1);
    T('412', '-0.0000000000000001572', 1);
    T('0.00000024221', '-35.8881', 1);
    T('25.8', '0.0000000000000000000242', 1);
    T('0.30', '0', 1);
    T('-26.440', '-3.64', -1);
    T('1.15', '-3229', 1);
    T('-137.1', '2', -1);
    T('0.00000000077', '53558', -1);
    T('0', '2.6', -1);
    T('-3', '-6', 1);
    T('-0.0000000000000000139', '-0.0005289', 1);
    T('-0.00000000000000000697', '-1.309', 1);
    T('-0.0000045', '-8.3', 1);
    T('-2', '-1.3', -1);
    T('-1.42209', '-1.74', 1);
    T('-608.88', '25.3', -1);
    T('0', '-1', 1);
    T('5.6', '-4', 1);
    T('7.17', '-4', 1);
    T('56.6', '8218.4', -1);
    T('68.33', '0', 1);
    T('5.0', '1', 1);
    T('32.734', '-9', 1);
    T('0', '20837.0', -1);
    T('-0.0000000000000000013950', '-3364.72', 1);
    T('3.66', '-0.0000000000000000536', 1);
    T('-1471.14', '6', -1);
    T('0', '-0.0000013', 1);
    T('1', '-5', 1);
    T('-10449.8', '-58.424', -1);
    T('0', '0.0000000000000000017122', -1);
    T('0.000000000000026585', '4.1', -1);
    T('-7', '0.00000000000000000920', -1);
    T('0.00000000489', '0.00000000000000000036325', 1);
    T('0', '104674', -1);
    T('-1.30063', '0.000000004051', -1);
    T('0', '2', -1);
    T('-3', '0.00150', -1);
    T('-407.95', '495.290', -1);
    T('24533.8', '-2539', 1);
    T('1', '0', 1);
    T('-43.4', '0', -1);
    T('-1399', '16.89', -1);
    T('-232480', '0', -1);
    T('3', '-1', 1);
    T('6.2', '12.2', -1);
    T('-23.38', '0.0853', -1);
    T('-18.2', '1', -1);
    T('0.002118', '-16.9821', 1);
    T('8819.2', '28.744', 1);
    T('-2', '-5', 1);
    T('-2.10', '9.2620', -1);
    T('0', '-5', 1);
    T('23963.9', '0', 1);
    T('-0.00000045', '0', -1);
    T('2', '2', 0);
    T('-3.444', '3', -1);
    T('0.0000016140', '1.5132', -1);
    T('0', '-1', 1);
    T('-1', '-7', 1);
    T('1', '-869.7', 1);
    T('0.000000000000016', '-1609.8', 1);
    T('651.3', '2.923', 1);
    T('270.901', '5.2', 1);
    T('0', '-2.6', 1);
    T('0.000000000020617', '0.0000000096018', -1);
    T('4.32', '-7', 1);
    T('-1.5', '-23.7', 1);
    T('1.2497', '-58.42', 1);
    T('-6.4', '2.24', -1);
    T('0', '1002.3', -1);
    T('265.64', '26.7', 1);
    T('387.4', '757.85', -1);
    T('0', '6.525', -1);
    T('1120.24', '-0.000000000000000000232098', 1);
    T('67.22', '0', 1);
    T('67', '-3.1', 1);
    T('0', '0', 0);
    T('-1.01', '0.00059917', -1);
    T('-0.000000000000091884', '2.7', -1);
    T('171', '4', 1);
    T('0', '-367347', 1);
    T('95.1', '-0.000000114267', 1);
    T('0', '0', 0);
    T('62.4', '-5', 1);
    T('11627.8', '9.844', 1);
    T('-1', '2.33', -1);
    T('-14', '0', -1);
    T('-55', '7', -1);
    T('-22.460', '872.15', -1);
    T('-0.00000000027029', '2.05', -1);
    T('-0.0000000000000004846', '17.73', -1);
    T('3.6', '0', 1);
    T('-3.233', '0', -1);
    T('-3.878', '-383', 1);
    T('-0.0000000000174', '20.7', -1);
    T('0.0000000000000000000126', '-2.229', 1);
    T('-2.307', '14.8000', -1);
    T('-563.79', '0.000000000000000069934', -1);
    T('-315.71', '-0.00832', -1);
    T('7', '0', 1);
    T('188.9', '-2.883', 1);
    T('0', '14.5720', -1);
    T('2', '5389.3', -1);
    T('-2413.1', '-28', -1);
    T('0', '0', 0);
    T('0', '-98.587', 1);
    T('3', '0', 1);
    T('17930.7', '1880.31', 1);
    T('-1', '-0.00000000000000000272', -1);
    T('0.00000000000000000002288', '51.0841', -1);
    T('-1.004', '-14799', 1);
    T('-0.0024973', '-6', 1);
    T('-0.00000000000054', '6', -1);
    T('0.0009288', '-5.2', 1);
    T('-45.4', '-0.000042102', -1);
    T('-56.1', '1793.86', -1);
    T('-68.425', '0.0000000000000068415', -1);
    T('-2.20', '0', -1);
    T('136.51', '0', 1);
    T('-5.9773', '45', -1);
    T('-6996', '60.60', -1);
    T('0.00000000773', '-2.6', 1);
    T('-3827', '-42.150', -1);
    T('-4', '3277', -1);
    T('0.0000000000000201', '-0.00000000000000094', 1);
    T('7497.2', '-45738', 1);
    T('5.20', '2', 1);
    T('139673', '0.000013', 1);
    T('258285', '0.00000000000338', 1);
    T('20.6', '0', 1);
    T('5', '45.3', -1);
    T('0', '0.00000000000000000010937', -1);
    T('2', '-392.465', 1);
    T('0', '5.7', -1);
    T('-4.3', '-128.0', 1);
    T('-9.94', '10.6', -1);
    T('10.524', '-4.1', 1);
    T('4.3713', '-5.6', 1);
    T('-4.1', '6.2', -1);
    T('-95', '-0.0000000000000000000622', -1);
    T('-2113', '1253.8', -1);
    T('406.95', '-2548', 1);
    T('978', '771', 1);
    T('-4776.4', '-911.1', -1);
    T('1.039', '0', 1);
    T('-4', '0', -1);
    T('-1.06798', '0', -1);
    T('-5.2', '-1.0827', -1);
    T('1', '2', -1);
    T('0.5638', '0.0000000000000000000866', 1);
    T('7.3', '-9.5', 1);
    T('-2', '61406', -1);
    T('1.4', '6.60', -1);
    T('-3', '-1.4', -1);
    T('0', '9.825', -1);
    T('-0.000000000335941', '2912.92', -1);
    T('-557.81', '-64.4', -1);
    T('3', '0.000013480', 1);
    T('-25.4', '-163.15', 1);
    T('-151.0', '7', -1);
    T('-219.2', '272', -1);
    T('0', '-0.00000000000000000020763', 1);
    T('-1363.0', '294.3', -1);
    T('0.00000000000000000003537', '-3.62', 1);
    T('-0.00000017', '436.44', -1);
    T('1.6079', '-9.56', 1);
    T('76.1', '0.000067', 1);
    T('-1.68', '0.0000024', -1);
    T('0.0000000000000031', '-2.9629', 1);
    T('-1603', '228.1', -1);
    T('-51.66', '2.6', -1);
    T('0.0000000000000208093', '1', -1);
    T('-11215', '23.963', -1);
    T('29.34', '-39.5', 1);
    T('7', '0.00000000000000718', 1);
    T('-44.309', '4', -1);
    T('-11871.9', '-6.11', -1);
    T('8', '-5.3', 1);
    T('-1', '-0.0002202', -1);
    T('3416.2', '0', 1);
    T('-245.2', '-1.15', -1);
    T('-1.70169', '-4.73', 1);
    T('0', '1.1', -1);
    T('7715.4', '468500', -1);
    T('-0.00044', '2', -1);
    T('-1.8', '1.1', -1);
    T('-13.575', '-2.58', -1);
    T('-6', '-0.000000000000000044077', -1);
    T('35.2', '2', 1);
    T('0', '-5.43', 1);
    T('-2', '-629.9', 1);
    T('260.5', '-2394.9', 1);
    T('-110.50', '0', -1);
    T('-97.17', '2.6', -1);
    T('4.0764', '-71.47', 1);
    T('-0.000000000000016', '0.000000000000000000785', -1);
    T('1.5348', '0.018', 1);
    T('-2.2', '5229.1', -1);
    T('0.000000129738', '60', -1);
    T('14550.4', '-5092.49', 1);
    T('-134380', '3.51', -1);
    T('1.390', '1', 1);
    T('-0.000000044', '17.1', -1);
    T('34.398', '1', 1);
    T('-177.5', '0', -1);
    T('-5.3', '3.326', -1);
    T('-1.75', '-1938.43', 1);
    T('1', '-32.9851', 1);
    T('0.01082', '0.0000000000000000001008', 1);
    T('197.469', '-143177', 1);
    T('-61.5', '-11.6803', -1);
    T('7', '0', 1);
    T('43.44', '3', 1);
    T('-6.8', '-0.0000000000000000015', -1);
    T('0.0000005371', '0.000000000002723', 1);
    T('943', '49.02', 1);
    T('1', '-45.09', 1);
    T('0', '-55.76', 1);
    T('-760.2', '0.000000103078', -1);
    T('1', '-1861', 1);
    T('-2531.7', '-185.95', -1);
    T('1.2', '0', 1);
    T('6.4', '3', 1);
    T('0', '9', -1);
    T('-122', '43.423', -1);
    T('-3.91', '1', -1);
    T('1.4', '-1', 1);
    T('-8.51', '-3', -1);
    T('360.56', '56.278', 1);
    T('0', '0', 0);
    T('-2', '-0.000000000000007301', -1);
    T('-1.4', '6', -1);
    T('479.1', '-838', 1);
    T('-32.6', '3.8', -1);
    T('-0.0086188', '-4.6', 1);
    T('-8.2', '-0.0000414', -1);
    T('-5', '-0.1236', -1);
    T('-107', '-0.000000000000220', -1);
    T('-0.000000000000168', '-0.000000000000000089', -1);
    T('2', '1', 1);
    T('-0.0000000050600', '7', -1);
    T('1959.3', '5.1', 1);
    T('0.00008180', '16.364', -1);
    T('0', '1392.91', -1);
    T('-4.6', '1', -1);
    T('30.4', '-0.000000000000007179', 1);
    T('6.0', '8.90', -1);
    T('5', '0', 1);
    T('9', '9.05', -1);
    T('-0.00000029', '4846', -1);
    T('72', '-0.00000001422', 1);
    T('1.1613', '7', -1);
    T('-0.000000000000000409872', '35.6', -1);
    T('0.00000000000444', '-101.737', 1);
    T('0', '-2', 1);
    T('2.0', '1', 1);
    T('-1050', '-0.000000000323', -1);
    T('0', '20.06', -1);
    T('7.774', '-6.5', 1);
    T('71.84', '-6', 1);
    T('0.003160', '-1.42658', 1);
    T('0', '599.4', -1);
    T('-8.9', '127.37', -1);
    T('-5', '-16.295', 1);
    T('2.76521', '1.28', 1);
    T('-31601', '-1', -1);
    T('0', '1.69958', -1);
    T('76.4', '-0.00000000000000000011', 1);
    T('-228.0', '0', -1);
    T('4.39', '0.000015545', 1);
    T('0.391', '-164.55', 1);
    T('4.93', '41.50', -1);
    T('572.3', '431.86', 1);
    T('-1.21162', '-143876', 1);
    T('-0.0000000000002463', '-2', 1);
    T('-5', '84.4', -1);
    T('-1.3', '-5.06492', 1);
    T('-0.0000000000002969', '-1', 1);
    T('479.758', '0', 1);
    T('39.80', '0.003823', 1);
    T('1', '3', -1);
    T('0.000000000000670', '0', 1);
    T('-16', '-10963', 1);
    T('3', '-102.5', 1);
    T('-0.0000000000000000033174', '15.945', -1);
    T('18.14', '-1829.06', 1);
    T('10038', '0', 1);
    T('0', '-0.000000000000000000125', 1);
    T('353', '0.00000000000000017781', 1);
    T('-4.43154', '1165.4', -1);
    T('-501.963', '-83511', 1);
    T('0', '-7.0', 1);
    T('58578', '0.00000000000000000027', 1);
    T('135.2', '1', 1);
    T('-6.3', '10988', -1);
    T('2.6', '6.3', -1);
    T('-74', '67.08', -1);
    T('1', '-2.59572', 1);
    T('30.7', '17.0', 1);
    T('5', '-3262.2', 1);
    T('1', '-8.5', 1);
    T('-1', '-0.000000000000030694', -1);
    T('1', '-311', 1);
    T('1', '5.76', -1);
    T('1.9', '-15.55', 1);
    T('-2.5', '102.1', -1);
    T('-1', '-290.43', 1);
    T('-1.4', '0.00001613', -1);
    T('-0.00000114224', '44.99', -1);
    T('0.000000000000414', '7.3', -1);
    T('0.00000000000000079824', '0', 1);
    T('-856', '16.3', -1);
    T('0.000000003556', '1', -1);
    T('-1267', '-0.0024', -1);
    T('-3.30', '-6187', 1);
    T('-0.000000000000007860', '4', -1);
    T('0.000136', '-1.5', 1);
    T('-5', '0.00000035346', -1);
    T('0.0000025', '-3', 1);
    T('0.00000000000054261', '-12.2', 1);
    T('-0.00000039', '5', -1);
    T('-0.0000000000000248948', '2.22', -1);
    T('-12', '3.199', -1);
    T('-1424', '-14', -1);
    T('-30.99', '-2', -1);
    T('0', '2511', -1);
    T('0', '129.1', -1);
    T('-2', '-566.76', 1);
    T('2.51917', '-54', 1);
    T('-3100.0', '-6.4', -1);
    T('1358.86', '55.919', 1);
    T('0.54071', '4.66', -1);
    T('-14298.8', '3.4', -1);
    T('0.000000015', '40.9', -1);
    T('-1.781', '-580.96', 1);
    T('1', '296', -1);
    T('20.7', '-68.13', 1);
    T('915.0', '3', 1);
    T('-4794.2', '-1.5', -1);
    T('-2.9', '19401', -1);
    T('-1805', '-8.1', -1);
    T('0', '2608', -1);
    T('9.93', '1908.1', -1);

    T('0', '0', 0);
    T('-0.00000000000004475220262613', '390046.9220288808', -1);
    T('-52', '-7', -1);
    T('-7137400653786386', '-1220454', -1);
    T('19.76074721670306', '39433637.5', -1);
    T('495810.901671347', '-201199464.42718987', 1);
    T('2180987378927.828', '28150984.022786039', 1);
    T('364.263', '1334', -1);
    T('-4.541827796913', '0.000000000720283699415669', -1);
    T('0.000000000000533031300116917190', '-733584.206', 1);
    T('-0.0000000000000019761199', '-6724.9979821490', 1);
    T('0.00000000012335234299864', '56.021423640836509', -1);
    T('17752.992435030', '513735.52129558557', -1);
    T('-341665592090.67519', '895755.23903', -1);
    T('-0.01174948256069749', '38841.427732372', -1);
    T('2067269955.10633', '-215483633', 1);
    T('58373', '-0.000000000000000208432238083784077', 1);
    T('2821.0921360930698', '-0.0019370832810573843', 1);
    T('-1', '-6987341307332550', 1);
    T('-0.000000000000000135940520450', '-7', 1);
    T('368879186519841.03', '3.86407044811851', 1);
    T('54.8552188726690', '-17618.8325331', 1);
    T('0.00000000719285162', '3.0', -1);
    T('-24541949382.5', '12000388993272705.7', -1);
    T('-0.00000000000000016019271145', '-5010014644.83398', 1);
    T('0.00000342615147619', '38.8937553143', -1);
    T('0.000000000000030', '698637', -1);
    T('-940562183996', '-9538.76857523965', -1);
    T('0.7992283723', '-301.642', 1);
    T('-943394092028892', '0.00000000000249028944', -1);
    T('0.0000000065', '19.8', -1);
    T('-0.00000024892', '1.081095088', -1);
    T('4693767.27', '0', 1);
    T('241.51552', '-0.000000000029998424146', 1);
    T('4.70', '-3889836.808618', 1);
    T('-31', '22.1677904', -1);
    T('-8', '0.0000000000000018564862859', -1);
    T('-2.82', '-0.1308117625', -1);
    T('-0.000000000000000490813322', '9628302045.4', -1);
    T('14', '-1', 1);
    T('-21665490839.0', '-308.104922674', -1);
    T('-5', '-6.6', 1);
    T('20.356245251', '-2629.4181', 1);
    T('-1.39', '24102492360.03791', -1);
    T('26.56', '-81.84491435616642', 1);
    T('12733804882', '3.16734', 1);
    T('0.0000000000001331522614064615', '-62.298429591', 1);
    T('4.5417', '-0.0000000000000000000906964635852953', 1);
    T('5.0', '3.99206', 1);
    T('28282932454425', '20112043684.32', 1);
    T('-119.144720881', '-129.74436439545', 1);
    T('740279.3975', '18685368847070828', -1);
    T('-194303.7', '0.000000000000006199756267389375', -1);
    T('0.000000000000000002405090', '-0.00000000979604845', 1);
    T('-0.0001603124275271', '0.000000006060544102736781', -1);
    T('-179.52', '-76.6', -1);
    T('9736.4996007851800', '99.6', 1);
    T('-0.0000000000000000000126060214789203821', '6748323899.81', -1);
    T('-0.0000076569074016550', '0.000000000525779058', -1);
    T('0.0000000000000000047090003506832525', '0.00000000000000011759', -1);
    T('-286334697213252', '8557782748357', -1);
    T('-0.000000025274118612780187', '-127000540', 1);
    T('0.00000000610055019436568', '-87.3', 1);
    T('-1560822.78', '360857.435', -1);
    T('243209397988565176', '-2171.0', 1);
    T('1089364.8', '-7', 1);
    T('5', '-195.43311519499808', 1);
    T('0', '-12.6', 1);
    T('-8917436.7369', '-2412090', -1);
    T('0.0000000000258', '-0.000000000000000001137187844109', 1);
    T('65611', '-0.00000000000527362056737', 1);
    T('0.0000000000000000000113412508151534071', '-4.9964', 1);
    T('20156417.0', '0.0000000000000253800552009', 1);
    T('32.967316', '-176195213.7000883', 1);
    T('-542212737079077800', '-593.88569405080', -1);
    T('-0.000000000000000004199278271388794', '57186245414.80793', -1);
    T('0.00000004507194567013278', '1.0', -1);
    T('43551631176247', '-2195', 1);
    T('-4.6', '0.00008016', -1);
    T('-0.000013384535', '3437784.58', -1);
    T('0.00000000000000002007911523', '-1.34', 1);
    T('2.5', '-39.06', 1);
    T('0.0000000000000000051', '2', -1);
    T('0.00012813936789257785', '1021.0303931', -1);
    T('0.00000000000000000132229', '47.1', -1);
    T('-0.00002120044', '0.0000000000000000064902789323', -1);
    T('9', '379472788024622.729', -1);
    T('20.510820935587124', '0.0000000000028179781', 1);
    T('-0.0000000000000000000336381763977', '1.17539', -1);
    T('0', '-335.0', 1);
    T('2.4', '-0.00000000000023', 1);
    T('379.690496326', '-0.000000000000000003740124432080006', 1);
    T('9612.15057327', '7', 1);
    T('64.55819568', '103', -1);
    T('306554.22', '-21168.82471', 1);
    T('0', '0.00000000000000378671778', -1);
    T('-4869994212.02', '-82.3249644', -1);
    T('-28281314', '0.00023', -1);
    T('-272266413010184382', '-21443895.1', -1);
    T('0', '256.5', -1);
    T('-0.0000000000000000059504', '-393', 1);
    T('-85483356.741520', '-0.135106007572', -1);
    T('1256398743581', '-0.00000000000000113', 1);
    T('9265.8054085790753', '1101.60', 1);
    T('21755297.7418484298', '-1961304', 1);
    T('-4.24', '-20364.5241763', 1);
    T('-0.00000163743621', '-15716423.93', 1);
    T('0.0000000020933557160', '-8448055.64162653', 1);
    T('193', '1919.381696195', -1);
    T('-39007.0872890', '58659197064.3566', -1);
    T('1.224', '-82293358.63', 1);
    T('0.0000000000000001573421585953', '0.00000000159648', -1);
    T('0', '-91.479627934421', 1);
    T('-186.247902631', '-0.00000000000000008879', -1);
    T('34342532998345', '0.000000000000000001681734691290559', 1);
    T('-4020.8878086173', '1.08', -1);
    T('-0.1630447778870097', '8176.334', -1);
    T('-0.0000000000000000582491728505043', '0.00000000000000808314', -1);
    T('-0.00000031', '3137213.71057', -1);
    T('-28.21073575152', '8530334210.39291', -1);
    T('-0.00000041292', '-66921.7723433', 1);
    T('-261247.289569419', '-0.0000022547224', -1);
    T('-4.07', '-6.1', 1);
    T('688.144527235', '45986414948', -1);
    T('-1', '-0.0231932902995', -1);
    T('0.0000000000000016241364087636498', '3', -1);
    T('64634.877977', '-39803483', 1);
    T('93.85', '-27.012', 1);
    T('-1804.8479', '-2720034', 1);
    T('-31207.70845', '-0.05392720639355', -1);
    T('-7479301046098815', '37.3', -1);
    T('50515.653686861597', '-0.00000000000000204399360', 1);
    T('-0.0000000000000000055012280316826870', '149.91618262', -1);
    T('2216863.9954067', '0.000000000000000775121457372458', 1);
    T('-3.1', '2', -1);
    T('-4.67', '0.000000018732162086', -1);
    T('-0.00002189591', '-0.000000000255830068339', -1);
    T('410611332258005.0', '-2840.2819', 1);
    T('-7397921366979', '-0.00000000000053', -1);
    T('-0.12413104038561', '-0.00000000000255343979', -1);
    T('10521370.1', '-55871447.8', 1);
    T('129500.264553199', '-3811409369958.95', 1);
    T('0.00000240712277094094', '1354108422.5', -1);
    T('-0.000000000000000005719028368733990', '540474.19019760', -1);
    T('977162.7422', '-0.000000000001402550', 1);
    T('1.54339295432', '-0.000001596789', 1);
    T('53798507.25', '-0.00129745384800', 1);
    T('-0.00418268966509248', '0.0000324984627', -1);
    T('118092.9308827', '-0.0000000000091', 1);
    T('0', '-93.6', 1);
    T('0', '152.55335', -1);
    T('-3405109.0892217', '0', -1);
    T('445424.679402140', '85.3554', 1);
    T('5036.98', '22371.6657', -1);
    T('-1.9', '0.000000102345283335839', -1);
    T('-42.2659', '3.721', -1);
    T('0.0000016709189598', '6.170585', -1);
    T('-3', '0', -1);
    T('-0.0000000061', '5497334338493.62', -1);
    T('-124932073873228', '0.000000000370', -1);
    T('-0.007149648796120', '-0.00000001269559959', -1);
    T('1675530.7719', '-1065461.6469931248', 1);
    T('1053.3', '10097922.4048112434', -1);
    T('-92523142643508', '-4', -1);
    T('200.8', '-36.675816237421759', 1);
    T('2.0', '34282969.24101', -1);
    T('-0.120192312259366', '-99423384.4155', 1);
    T('0.00000000000000000746964', '-4.50907217', 1);
    T('2521.848164', '-16771705.710', 1);
    T('0.00002756245400', '0.0032449553261', -1);
    T('-0.00000001332527923', '574.55219962424', -1);
    T('-0.000000000000000179221403668', '57235.797', -1);
    T('0.000000057866988749115', '0.00000000014', 1);
    T('3', '1.2', 1);
    T('56.30058910190568', '-1680170716816089', 1);
    T('-2', '-24381767.5', 1);
    T('11799.81119', '-0.0000092161582', 1);
    T('1.13', '-1', 1);
    T('1', '-802.5013810814', 1);
    T('54624549209148.7', '-0.000002846161', 1);
    T('138301402', '-0.00011', 1);
    T('5', '-2.4', 1);
    T('-4604424', '1.28478944', -1);
    T('-146100841048.0', '92.57', -1);
    T('-0.0000000000000000020786339367465', '0.0000000517784775175150122', -1);
    T('94366206024220.8', '-147.3818299', 1);
    T('-3.30342757', '-2.8', -1);
    T('1458645603.7314952', '-0.00000000000000071', 1);
    T('-22352269.3857581', '1.133', -1);
    T('0.00000000000203016463277398240', '11.54042', -1);
    T('119.31', '0.0000000000005419744970291', 1);
    T('-479.458846', '-61007894', 1);
    T('-12.748', '-42.6', 1);
    T('-4', '-2102161', 1);
    T('-0.0000892951', '-0.00000000700082036664', -1);
    T('1440.2349309228', '2068244137965', -1);
    T('4.122', '3', 1);
    T('0.00000000006657906', '-5.9', 1);
    T('-0.817940036224482', '-3055637.756294', 1);
    T('-30364497819', '0.000000386', -1);
    T('-10441.7700601833655', '1.62504166598260', -1);
    T('0.000000000000000000013559973223809', '-0.0000000000000873509044373', 1);
    T('-46163.26048', '869724.9', -1);
    T('-0.0000000912', '0.0215663057542177284', -1);
    T('-7983637956', '1777.3345419909', -1);
    T('9901852112330', '0', 1);
    T('5', '-0.132564740', 1);
    T('-0.000000000001296', '-3398418.84', 1);
    T('2479240525029.33616', '-56491017716', 1);
    T('0.0000000000000000000125250462975224734', '3113453368428781', -1);
    T('18553.70674887', '-2036370511701.586', 1);
    T('1987104769376.1', '-3.2', 1);
    T('-15.9', '-0.0000000113232545789641887', -1);
    T('224.9148', '-18.1', 1);
    T('37574545.7', '-6.2', 1);
    T('8', '99053.70', -1);
    T('-359.3860', '-31.8', -1);
    T('1.85', '-41.0', 1);
    T('-2450069962976026', '0.000000061710947', -1);
    T('-724091.9920619242', '-3301857', 1);
    T('-59.1', '-7', -1);
    T('-11075495.60081', '8.5630713', -1);
    T('-58.7', '-0.00000000015983986', -1);
    T('0.00000000040731658521', '18001880087', -1);
    T('162453.79', '6668407464.1', -1);
    T('-0.00000472188389576600677', '14115', -1);
    T('126502', '10.69459', 1);
    T('1715058', '94.8763148', 1);
    T('-1', '2.2612173', -1);
    T('0.5133073103', '-11.97191154', 1);
    T('1.74', '-0.1674805636', 1);
    T('-7290144.463920', '2527.03', -1);
    T('-3', '-4.9427', 1);
    T('-926566116.423411', '26.01271418645', -1);
    T('-449.272959041948', '68532785212291439', -1);
    T('138258577757.4', '-1003304148227.7', 1);
    T('-0.000000000000000000010128915955897709', '-3304146563351', 1);
    T('-0.0000000051706766331953970', '6', -1);
    T('-0.0000000000000000007641943051494263', '-545257.46', 1);
    T('-113562.957375112', '-21965305.642892', 1);
    T('-11448.06', '210.2157232900', -1);
    T('-141.1', '161.66', -1);
    T('-29036932102', '37', -1);
    T('8', '868324216.74', -1);
    T('0.00000000000000472435319983650895', '-154.252', 1);
    T('46.1', '2.16', 1);
    T('1', '-28907.803', 1);
    T('88570165763.081', '3003599203227764', -1);
    T('-0.0000000000000000001073793607923634', '49309.7', -1);
    T('-1.6', '2392146.237692', -1);
    T('-2139.959367', '-0.000010270379848989', -1);
    T('-954.845', '21359245.6438920', -1);
    T('-0.0765243310465', '3.569', -1);
    T('35244', '6.818525', 1);
    T('1.0', '0.000000000000002694', 1);
    T('0', '0', 0);
    T('-16.37618647', '-0.000000000000255699967320', -1);
    T('4', '38.09', -1);
    T('-512214740.316205024', '0.00000000000000000048545', -1);
    T('-0.0000356092', '872.5', -1);
    T('0', '266836883083', -1);
    T('0.0000030666714898272657', '-5746982.6567787', 1);
    T('0.000115493195', '13.9259', -1);
    T('-9766.284811588', '-0.00441218036285053563', -1);
    T('251093071416.33', '-59740.56', 1);
    T('-0.0000000000139253216444', '-0.0000000000000097199551454897', -1);
    T('0.000000000000000005459644785124686', '398147250730851493', -1);
    T('38.0', '-8781', 1);
    T('-827469', '-9', -1);
    T('-172850535.5', '-74.381839485246', -1);
    T('-404166', '0.000000000000020', -1);
    T('-8325567260571.80', '-1308443.50003', -1);
    T('0.0000000000000001096141', '-329056750.0', 1);
    T('542.65133', '-0.00000000088698', 1);
    T('0.000000000000000000133704', '-651984.8', 1);
    T('0.000000825879483325', '-381653.3', 1);
    T('0', '-22991738843.86', 1);
    T('2', '-36.5624759', 1);
    T('-1690423000.05', '3376665391', -1);
    T('-1695.58', '0', -1);
    T('-47561102.1021', '0', -1);
    T('201.1', '1716645951967.8', -1);
    T('1935050', '0', 1);
    T('-5.4755', '157.79589', -1);
    T('-4.3', '-7', 1);
    T('25090265240.04625', '-607.8', 1);
    T('-2926462.61', '154865050635', -1);
    T('1503606.9361', '0.000000001129607342663', 1);
    T('-0.000000000000000000618066504819', '0.00005276', -1);
    T('-95112', '2.67584319409253', -1);
    T('45561', '0.00000000344217291134', 1);
    T('92088411.754', '-81.226353161780981', 1);
    T('107.0', '-0.0000000656279606187', 1);
    T('47.9', '-23853019975.85895', 1);
    T('-52.6663139391784', '16270104.474', -1);
    T('-0.000000000000198761', '-6696522145', 1);
    T('-3.7840523387703', '2470.12717031561720', -1);
    T('-0.00000000000000022920', '-145705.5690558090', 1);
    T('-1.0', '0.00000000000000527026187525810', -1);
    T('3.59714', '-2725.47934324', 1);
    T('151538195108874.210', '-76712263823045', 1);
    T('4673409.1540083779', '71941922241245290', -1);
    T('-0.00005452', '4996813423', -1);
    T('45.37478482310', '-9.9', 1);
    T('0.00000000004284806937', '-805754809.47164', 1);
    T('-65142.3', '32395696858721', -1);
    T('0', '-8105471469018314', 1);
    T('140547537', '1.390913', 1);
    T('-4', '-1', -1);
    T('-1.7', '-28584565633401.94', 1);
    T('-14414.40', '-0.0000000000000000065362929973320', -1);
    T('2668644862897', '-65.93', 1);
    T('187.5651870279', '0.00000000000004537', 1);
    T('-166316028', '304548094.9', -1);
    T('21.1', '-3.7459045000441289', 1);
    T('83796717308913', '392191976.2', 1);
    T('-245830.74', '-0.6276780', -1);
    T('0.00000024230706949', '102871132', -1);
    T('567804266.88', '0', 1);
    T('-127491067191278', '-54422.33919641', -1);
    T('-1336839.5677', '4.68601', -1);
    T('-32772435.641', '0.0000000000346', -1);
    T('0.00000000000000100', '-0.00000000000000000035706589', 1);
    T('514103.488', '-3.2441', 1);
    T('-80.073950', '128750504.46', -1);
    T('-230652915.7', '-3.03863', -1);
    T('-18888.4009', '7344873616474480', -1);
    T('7', '-8961195435475.363', 1);
    T('0.0000000089922', '-274867588598', 1);
    T('-556.4765', '-3', -1);
    T('1298.69', '2188624222909.504', -1);
    T('326246955888254', '0', 1);
    T('9924973.51090', '10.913818', 1);
    T('-64922057.22328', '0', -1);
    T('-0.000015121244906956671', '-13641070311', 1);
    T('-0.02954', '-1.951973916', 1);
    T('1083.674582984972', '1098', -1);
    T('-558.42815252', '-61.1907444466', -1);
    T('0.00000000025639686430', '577986', -1);
    T('-7035.93', '-0.00027214889', -1);
    T('3', '-90736572249838', 1);
    T('7.63915', '1232667.0', -1);
    T('-0.000135502278681995', '0.0000000000000244953080777', -1);
    T('0.00000000000799030040007', '1.68', -1);
    T('481721839972013.764', '-47070151004241360', 1);
    T('-24.978', '206335.932853155857', -1);
    T('-616.2698', '0.0314914227', -1);
    T('1207176666.0', '-1301439870', 1);
    T('-0.00000000016429476', '9.9', -1);
    T('-0.00505710206398253462', '0.0000001380667547928', -1);
    T('-1.165016965486953', '-138379.4231296172', 1);
    T('-79.6633131', '165.14223157', -1);
    T('-73825158.59', '-61', -1);
    T('0.000000000934', '-3.82200519751368', 1);
    T('0.000000964717', '-0.000000000000005927687371823458', 1);
    T('27.727966', '-25.61', 1);
    T('2', '-23910', 1);
    T('-12', '3883816315.70155728', -1);
    T('8.206177344', '153.790', -1);
    T('4.9785', '218608289854278.794', -1);
    T('21.262085653354', '-0.0000063961966310', 1);
    T('0.000000032951144241042674', '14189577.516', -1);
    T('7610.88052', '-1307222', 1);
    T('0.00000000000000000004157294626', '86', -1);
    T('-28.12923', '-177547.975', 1);
    T('309.88', '-816', 1);
    T('-2278580099.10', '6.352', -1);
    T('-19.72742783115382', '-1101.0', 1);
    T('-263181.91904236906', '-9.5', -1);
    T('31.3', '0.00000001853884573', 1);
    T('-167415.77', '-0.0000000000000067', -1);
    T('-4.4', '-8608589026778.48', 1);
    T('-0.000000000000000100148808054135', '-478.23174', 1);
    T('567.51927458', '63184.6562350967', -1);
    T('0.0000000000000000031', '0.000000000000000007929', -1);
    T('-2', '-28934796077245.37', 1);
    T('-49505821', '-1.7522', -1);
    T('26.41137', '0.00001060660706229', 1);
    T('-0.0000014187070', '2894.13734', -1);
    T('0.0000000000000000079', '-23597579.1', 1);
    T('-7.595684', '-3303819607.9377', 1);
    T('0', '-3.0774669892765', 1);
    T('0', '3', -1);
    T('-1108203.892', '774.9', -1);
    T('0', '213043362334', -1);
    T('13304398.0371608', '-42671595698923', 1);
    T('-59.334', '-14797425210.4', 1);
    T('-1580.918446457', '597.1509', -1);
    T('-1954585', '43.7', -1);
    T('8', '-0.0000000000031877466746', 1);
    T('15.24', '0.0000095965900328103', 1);
    T('108.38', '-1', 1);
    T('-1333901185', '-327.940', -1);
    T('0.0000000000000003002264302838337', '-0.0000000000020925378', 1);
    T('0.0026377197741282', '28815020.633', -1);
    T('749760.615164', '-216.05', 1);
    T('-160307.9', '12.94', -1);
    T('-106313763', '309.6', -1);
    T('362759', '1.1', 1);
    T('3661.3030316', '-16218702.35428', 1);
    T('-29.385677982085526', '211.7', -1);
    T('-0.0000000000000000023842', '-449178776092589', 1);
    T('-6.9471389224004', '-9.14525417', 1);
    T('-533061078.7187', '0.0000000000000000010672', -1);
    T('-0.0000000000000000000549612286887', '2489771', -1);
    T('-0.00000000000000219220742135136', '-438551392682022', 1);
    T('-7.39965327', '-11.7759', 1);
    T('0.0000000000000003275', '0', 1);
    T('3.5', '516.37962208', -1);
    T('46.4537129', '75.28061', -1);
    T('0.00061329308410045020', '-1895948346907524', 1);
    T('211758460425', '2', 1);
    T('51956.6527986101', '2568.075045980510', 1);
    T('-0.0000027761040', '0', -1);
    T('0.00000000000000007928801', '-225.8724', 1);
    T('-0.7498337810439', '81437603983.269', -1);
    T('-2917265829.6754396', '-40551534', -1);
    T('705475472886', '-94431.289335', 1);
    T('-0.000000000001041719221', '6.9032947055', -1);
    T('-141.60', '4893.455', -1);
    T('-0.00000000000000000276', '-2348', 1);
    T('-451846573.05392', '994.237', -1);
    T('58980583273.66404', '3', 1);
    T('3.0', '-24256.552994526', 1);
    T('0.000001359135157304725', '-74511.22739626557', 1);
    T('-1', '-7.56575', 1);
    T('129.886304994', '0.0000024937420', 1);
    T('-340542455', '0', -1);
    T('50949.95', '116146.9629904', -1);
    T('-621306274358.78773', '-460701161', -1);
    T('-0.0000000000001649894694', '0', -1);
    T('-123393904497', '8243467175', -1);
    T('-58.45', '0.0000000000000118', -1);
    T('1125.372', '-188514556292761', 1);
    T('0.00000000000000087318067062', '-3112845454279', 1);
    T('-1357676334012628.9', '0', -1);
    T('-0.00000000015751050088824', '-2741149.60746', 1);
    T('-1.832', '396956274241425.09', -1);
    T('547876802.49698993', '0.00000000000000203534', 1);
    T('-0.00000000000000138873470272124956', '2.7', -1);
    T('-2122998911772.16', '0', -1);
    T('0.00000000000028992', '26193061.4', -1);
    T('729909.717271101', '213.5069400843', 1);
    T('0.000000000000000831795441', '-3149.30209', 1);
    T('871.23', '-39.9', 1);
    T('-266.516025843669', '-3', -1);
    T('-0.0003377513144795643', '0', -1);
    T('5429444.983', '-8.04', 1);
    T('-16.86241', '0', -1);
    T('-3.81', '397.2', -1);
    T('-0.00000102639', '0.00000000003224208', -1);
    T('70237963596.634', '-5857585.97', 1);
    T('-0.00000000000000003645298330', '-27572.252', 1);
    T('-1340.246701091', '1643.0', -1);
    T('-0.0000000000000044091801675', '0.000000000000000028992762079', -1);
    T('7460313.2', '-16167.854578244', 1);
    T('-252.4', '218.3', -1);
    T('-1', '-174474956852', 1);
    T('2.68344', '-0.0000000000031997142239077', 1);
    T('0', '1973.7414', -1);
    T('1481958817.6', '53372066', 1);
    T('-0.456', '27047501201', -1);
    T('0.00008716', '-8953628973228.470', 1);
    T('0.00000000000000110677110109', '1022800068.0', -1);
    T('-58.061691', '7.580', -1);
    T('0.000000000000000000011890', '2.32355850059843026', -1);
    T('-0.000002164702426516', '163.9', -1);
    T('223.1', '299.35', -1);
    T('-129700523752699516', '-0.00000017', -1);
    T('-5.27', '-1820.169295', 1);
    T('83587.473', '-0.000000015648996536587', 1);
    T('-0.0000000000000050132780', '-0.0028014658786123', 1);
    T('-1', '169130711.41216', -1);
    T('-1097575518.9328', '-10.1053377424', -1);
    T('-0.01551135221651', '4', -1);
    T('1.06932', '42.19', -1);
    T('0', '1.4', -1);
    T('-67852.2727000', '-3.311704582173664', -1);
    T('-7.042326758390', '-0.0000000019748141455575', -1);
    T('-1.003281', '317.6026', -1);
    T('-782.20436144498144', '168447196048515', -1);
    T('-243917419.22', '-193.49', -1);
    T('201.75620', '-199.9', 1);
    T('-0.0000000005419064219935', '227564', -1);
    T('0', '-208129799136442.8', 1);
    T('849606586946.33', '-12.5', 1);
    T('32237710821138565', '-6', 1);
    T('0.0003909263003590', '-0.00168080', 1);
    T('-72141391104', '24.823064699', -1);
    T('17.70', '154171341', -1);
    T('-0.0000058731658540754', '-28607161539382', 1);
    T('0.0000000000778024752', '-1.5315774605115', 1);
    T('-0.0264455', '0.00000000000013642701952', -1);
    T('-44.04616', '5.10', -1);
    T('76789965', '0.000000002292', 1);
    T('-0.0001367934293', '0', -1);
    T('-9689.56490', '93.264005', -1);
    T('-78.8991377137', '20605.8864902063172', -1);
    T('0.000000000000000026641956701225', '-2.4', 1);
    T('-99702426', '31234686409', -1);

    T('-78249536473266824330849.66777355094653206196949807187125', '-0.0000000000000003657205364898565', -1);
    T('-794146002335392753453.706827563775514677616', '-0.000000000000002003697772718678199294529887857336117611280517515976', -1);
    T('-415', '392495171560354735.54', -1);
    T('-0.00000000003641527559883410541221', '118893973463454526683808886319100407749', -1);
    T('-246230199620.751986', '-60621558.218545419613692429476293547415222080017643997', -1);
    T('1135.2381823', '-7025657983677893287919132587754823076851573889.74685', 1);
    T('-1225393854304.583672953386', '3712805076014395323562.4542406246', -1);
    T('0.0000000000002805023524281798', '-1195739.55713460927706968721363067', 1);
    T('386896730804748668115534580.29201499', '737595739534741234.44386299', 1);
    T('-160941276095561769012497288743700757276588036', '194.232174807028239974132449968549146279604', -1);
    T('0.0000000000000009760', '-112424977227983.369213445871607530779963339', 1);
    T('-120493.3535480159461699138868088193226718499846079', '-963938726344338862591656029356573.2356831292145', 1);
    T('1.731842697869349182975403693663977472678249978539', '-0.0000000000018342058226450839410208095980857226', 1);
    T('0.000000000000000000186044372917454007190404393463337172211654339256226', '38603.328332936580263680889352090136846643070031691', -1);
    T('2.24833678840107152900324', '-0.000000000000535013632333188', 1);
    T('-0.000000000001014445297159531', '-182225871.4', 1);
    T('-110739', '39245367522721683497924493692756130948391370303714834', -1);
    T('0.000000000000000000011109996302235', '0.00000021747567330836261997878389805423396667433455', -1);
    T('913805.7272137617667300113969454560', '12015557861856523.82185', -1);
    T('4.44', '17327761911331833939511.3229350', -1);
    T('3343815205898708797845323710139050310101815211790183', '0.000002944097410246031171887416698431193651848888', 1);
    T('32760398270494573303330410.50750229445655494486793110334706', '-9510914125.45789497493920290055', 1);
    T('0.00000031352646', '2982438266661362962075700689156408.44636939397', -1);
    T('77053023622996.111620117040477945', '-594', 1);
    T('28.651584435', '0.0000000000000517018230', 1);
    T('69454425323857571.298955', '0.00000003183', 1);
    T('8.585707061691', '27579495297994019790817050261359', -1);
    T('0.0000245072088767920273', '597422085664.8946200175189947965015981804000953540032149', -1);
    T('6395952035600311.145296483306709937475', '-7839682836938441873082358214760503680131094656590381429', 1);
    T('-878403860673101771781740794629505317750999165.91704111', '23574346417573958371843475532943.5863825875041348813273', -1);
    T('0.0000767302828677966418632441811470540764577', '-1276636.42385918072718338162162974143519652320393232805716411', 1);
    T('-15930445184474597597265919925606183581356435.4578944', '-0.00000000000114252044623272018125497556095987129012517542089248', -1);
    T('-48665285374684448074343674590620067.7', '1', -1);
    T('105930.422', '11113072169.652252071060557105162', -1);
    T('26564763', '-3', 1);
    T('4811244033166.822319661770849918367233504118713435759512811', '4.7', 1);
    T('-56.8', '4443507757632459.195553180343008573591954189736210531834', -1);
    T('612.72379387256827500110', '-452.196955446440438357', 1);
    T('-494127587184494770597966464398', '0.000000000000000505582034979983270144354985077988823279257757358354', -1);
    T('151593171537726736029059210', '3280207153334176964', 1);
    T('-0.0000000727423791233275798', '-33.983207203823', 1);
    T('-0.00000000000000000014088202399161', '967411649025173.3', -1);
    T('2.4', '-0.000000000001348198764946041705529604570289570284', 1);
    T('-1458694234293.393', '-0.0000000277889669157893917', -1);
    T('-1', '0', -1);
    T('-295498271141109248639464345535.73829013835409617653972', '-239733948637940687.4210093379196529044279897', -1);
    T('-114.668973584958627612325023154590', '0.00000000000000000204', -1);
    T('11086296933075691303', '61846609604939708809351700530350279982', -1);
    T('-199290.9539286389610', '0', -1);
    T('-0.00008470578761402', '77227954881772040530.19249809987494428807714982', -1);
    T('1675393978448', '-218061932.345257837058901', 1);
    T('-148234164778648.90057404374761057399794220096395194121763477', '-1807153054383052.16291022958635252906429', 1);
    T('0.00000107324116068524713963632866732786846249794493141690777', '-8697413954500148992019717571067182408306067052176.48379', 1);
    T('-3504475807101437909894549201613284414285', '0.00000180507680656754700593791722943439535831913116826463442277', -1);
    T('137188855.912293557682373', '-84390113782876.78301756825303169680317158020741023212586877', 1);
    T('-8.04', '48917396714819601257978143.0', -1);
    T('19441.23908', '-3621875953293954379164.80898', 1);
    T('-488683915776821.54128571136', '-2764.655', -1);
    T('-497.39163093', '456272554.910083158313064', -1);
    T('3888553456.187038805', '1.79351971', 1);
    T('-0.09665505758418475963567867363097339048321797943170880174', '42.26560746275599', -1);
    T('18902797728391145440494082949463571569467603044', '-160840513303121014911814965287069764.329850142', 1);
    T('-0.00000000000363783296932', '-229510691003150718410894.798513190', 1);
    T('-0.019578513996', '-0.0000068012586581839285561', -1);
    T('-0.00000000000000003337257672564450192788237207780262977502390656214', '-576.230537914969490642', 1);
    T('0.0002071041857705517964418488527910814283948842252102023', '4965', -1);
    T('-762578569061554379901567768164.24708334695367', '-2902150555266343625933468.2', -1);
    T('366547461068.82113690', '473567955790856323671.7615303868255685632986068926885', -1);
    T('2212.60505074', '54.4399284220426917738', 1);
    T('24229481820388119475112679.2869744056638142529094915709331146', '-39663594276.8672343304', 1);
    T('204581808810007220059753337566285703.0558403249497', '0.14724245060761654341919', 1);
    T('186.26481926730311740748275435747257', '3169339033932711835137078410077027045.6405', -1);
    T('147438798802.4222641736117', '-30953.68649', 1);
    T('0.0000000000000000036665066712498278880448755082419497041867983779348', '49969977335002848872793397', -1);
    T('-15', '-1610335165763678418286838402407661955', 1);
    T('2689653843679875122027095562540366.2198041476017623', '1680374149507467199865152885259.7294203852546004613867', 1);
    T('-0.11', '-0.00000000000000000043896646420939540095966', -1);
    T('2080671699743.511238240714127', '-0.000036842318404340179848907', 1);
    T('568000304', '-90592884500253731464906623327632577358591186.946837858889', 1);
    T('-0.000000000000002107518141285', '-3224876873708851754101647.818256157564', 1);
    T('2265098771', '0.00303612511166914586857128974318819782', 1);
    T('-5664007822465.98050400197979616740857', '4318641.351415884425470426852575673963981647030782942', -1);
    T('-2548615100934958409898695557521334.971165846219072', '-554798.735556810907', -1);
    T('-0.000008820826897431443', '-1685288868236928715034057139645.0670918901230', 1);
    T('0.2773641914039966806939077833931526594995617517107827', '-155510002669979906258854608426737730.80732922', 1);
    T('0.00000028631297293946002594331990323448420', '12.530358985140', -1);
    T('65.74', '0.000000180226526307592', 1);
    T('35366830254177.323', '-195533735162357391160682221146179916675364691505329.522594', 1);
    T('623190599276699090316221455590041049805679995441489316.522', '6153742899048073987312064712008701512451.12942', 1);
    T('0.001389654081957090114281716350682554539119289983031175', '0.0000000000000000004172245036048453978505043356031', 1);
    T('-0.000000000000065125596165975329468700878377195017853327025922232', '5010.27', -1);
    T('99858764586308080.815938383', '6906.98277', 1);
    T('-0.0000002120213841110365850583078206489619527666932442761000523841', '1560226.624828', -1);
    T('-0.00000011209616970611', '437120468783339721.8270432960', -1);
    T('39633522.28696180408828', '404609951713', -1);
    T('0.00000439899975727851857364404628011452819', '-295058799.554060774457769229721869795967861', 1);
    T('-0.00000000000000042342244818730713908050671583102154', '549754666663906751820116493890514432554613796763091771', -1);
    T('271354103.271534143867908347243952035', '-3.4348029165', 1);
    T('-18391137696458176.709403414422273535748', '-135526005724.36', -1);
    T('-16789648705436253610328466585451657189', '87790015500203097.67217621', -1);
    T('-0.1934527980285924234435139814', '0.000000044283070912014290453388249787033315196663317475885890', -1);
    T('175727618.7', '-4712524302.9633361502507795469472010873256880899968244213838', 1);
    T('86148708.7', '0.000000000043067763982519792325233598208451198', 1);
    T('-1676718.814', '-126027512979.7359979901775996', 1);
    T('204654162545474.954541730442039127578542771572577634608702', '1278262396819307952614391540746000135708145121661', -1);
    T('20599411052765018472280152629960269.784440835643761573', '382871.68', 1);
    T('9.1', '-0.000009868296529724402614472149967657', 1);
    T('-51.7', '-0.00004138549340599259177969843213431710067044689658507', -1);
    T('-0.00000000065519676351299476540767970', '-159950069281804382298.104882147944419487737768', 1);
    T('132937997125408.196564521', '0.0000000000000416671095818013123525013575750', 1);
    T('-1313393782.747301', '135189314585073603701567044403904503', -1);
    T('0.26345218007386345905841', '-0.0000000000000000131698402541203188119609481297941368650', 1);
    T('24462716218.22576508876165308669350154', '-175901840085494768716509058673018943.44105360844073496986', 1);
    T('-639051.389850068275663978184079330600736417788030565545', '-233130008509087611163354733950079542005785536290.28', 1);
    T('-2.5', '0', -1);
    T('-48', '-1.30483838443', -1);
    T('-0.0000007957592304983915492296920988493287302223429001', '222281838853.55743543126434998666514248954378468481403010', -1);
    T('-256924767625.92102529834889997062393414595239208331582', '-138645955.7309701679', -1);
    T('5825.6936168480383901079880', '-15454778381.1635817748532891601', 1);
    T('322234158068890727047790331925494003913674775559', '0.0000000000000001440104086097707578083604', 1);
    T('-0.0000000000284163905693832757026', '735321.796040692391355698638806984647971670552494930079886', -1);
    T('13.51354661049663', '60174586.03966439546', -1);
    T('-0.0000000563225262474012816830760397217', '-19259915510222671.51018', 1);
    T('58260242951538386451799849576838755846723438641458498.45', '81583418293233481447477355060230.5984042555029388', 1);
    T('15676086441613294586793.0600578779086373855887', '553785093898805279609967970.6227004730416155843290795860965', -1);
    T('-529215908', '0.000000000000001261696290245850445593226', -1);
    T('0.2765770305056755810402655395163548457323921993', '2485048778003226295.0487979661044', -1);
    T('3.106357', '-196188865060.96789451729283131151802962', 1);
    T('-3812721623392532238628.52058836531583261604602809206126', '0.000000000129949612553432181149516674241', -1);
    T('-725747.78308445614294711222169380088709733492626141', '0', -1);
    T('0.00005978057030838911749503353205688236750513118711', '-2301374753039922.5', 1);
    T('-21135.6', '0.0000000000000677319833766662844296', -1);
    T('-18592472738146.165033667092366', '-0.245177658870876212432221320582908107465202878031116163978799', -1);
    T('2.0853471559342294701189635489971894524307297590789015254659', '1820710163171110437504131672398834715.796647407', -1);
    T('3017.7628349701943687591214', '-2123676032175089021.800850462329', 1);
    T('2245516696370652079582811421413778879168242699149', '-0.000026865223', 1);
    T('396591381033578245290535623.59522101830916124323912171677', '-399632909396.27251691705488670319', 1);
    T('25071395481877740931640606160951694567581843991.91250540', '0.000000129577260075209456379795979548520957596680350786352443111', 1);
    T('-10071840824462229810456841986062182478', '-0.000000000000036', -1);
    T('-378.382656390921442297', '2995.111135910', -1);
    T('-0.0000000000000011003920232607040692705', '0.00000000000000002355157685511431284976273511723771203290674587231328782173', -1);
    T('894.8158182999506884919347710660910', '-0.00000000000000000096323615121853367670285903274497581', 1);
    T('2319037.233322076813874258', '-32416.903557641', 1);
    T('23396460119.155847859729080972376305599746464844501598782869', '-23349855891702694333726330.5788991', 1);
    T('90907619612776583630058641475331.6', '834081.31401857878701092663973283388246447251015444', 1);
    T('-0.0000000000000000081501364451042879423837094013790187022253', '-0.00000001399490096609828204621353982853023593', 1);
    T('-420605.932784654921007625945921605929', '-0.001003986559391891122940439549512675', -1);
    T('29941819100256.1010903984648918366033290553065670117884535', '-1399273749558314.35414647141708136502314', 1);
    T('9.87428322502844153862497406397966790245714773688', '282378323960341447353633555973.60816609111820', -1);
    T('0.000000011571', '56.055239680', -1);
    T('57847056020509197.81010326363252948483107773', '-1.4444', 1);
    T('-51735520880178.3819992386025068250767281052153771374742233700', '-0.000000000000000001995850558903648471134005565207297729809954251013177868', -1);
    T('-252689605402394270719155.41734356951305987480624879', '-14.7', -1);
    T('-0.00000000001151229725364301025243181548204622943024492441630358', '26395005645801030069538169698242312.433651971508113804', -1);
    T('-0.00000000000091483130556462719', '2', -1);
    T('208.9827699741542594700570327748394160582183088044349', '-0.00000000000052759011609237039384483268124939035873403', 1);
    T('12412.9657547118', '4', 1);
    T('-2', '91580728825224739577263849484410121433204621.500780779690', -1);
    T('459526644.772925035397599290137226147632521530511862018', '-0.000000005846169451429981275734796656', 1);
    T('671926163021026323133951152902929830282.91041796493', '548498210972677.51442460018844632588617668956139310271612', 1);
    T('2422.5875291768881507425406922241585652688246', '19145241007530705409.9615104357443736565548963', -1);
    T('-0.00000078875216605898054012159', '-3150.0', 1);
    T('6244534680058004259589682789034535443037697', '-25351939981079.604012', 1);
    T('-180.203958489450', '39025034688578315815199.297787915576434930764', -1);
    T('-1361080637840651575481575485233.15286726682268248409468726', '-0.0000000000000039297884367828635174097881955958806085', -1);
    T('180278536333055.7355327506162313565598247413', '0.000000000005454620478830996984164588529474180472398020083723230733100', 1);
    T('-12521213.94690', '213.36136', -1);
    T('-0.0000000000000076966493627693824010017610386791', '-2.378265167488246191074961795033182605013037407884326', 1);
    T('-253.6948', '126006206', -1);
    T('144872743608071550764695060958473194286850377609005.9406', '-4115782212.903943924240904289', 1);
    T('646425925574255155103804057996228876', '-3385724693259876271747963.2083760845385', 1);
    T('3238426111230801661501493996824.60026008769586', '-1.3137106232306', 1);
    T('36812968817.09002256', '-377119042652372085.8701028046507452160688891148413096706', 1);
    T('-1057646134026674642687725155011813064632921643903628746215', '-61.1976960', -1);
    T('5932283884028162.993577517', '-262866296151760083503.5144635', 1);
    T('0.000001968962077757014929052005163485510124163782133996', '0.000000000000116476163076562297013796305385624375676724881414944662', 1);
    T('-344797534756.045056309614536498476108', '255603.7453533447251497046857105152628367804406158228236933', -1);
    T('-3426067344177324630963454.412', '15385507340701842778819629282390396905481417.2267114635', -1);
    T('-6482829869.2939768229599', '-316205.7593667305356109359299', -1);
    T('0.000000457660742', '-70087953797661233.02541392030217222494340078655370619', 1);
    T('-0.000000000000039160675421718532243743411756', '0.469130640793', -1);
    T('646.780847826', '-18577555.4140223083526099991256121668882164928438251290074', 1);
    T('-0.00000048407641016681417846220', '5.986261', -1);
    T('211851273349866038766', '603496683164932314765.83959539999713388808548959930160200', -1);
    T('1102.13614611471685523260263', '-10896812', 1);
    T('-1204978038923128204724255296214417.103288933531778085701527', '1716208377705472866612373037267.9534333794', -1);
    T('7.39', '71028207488403138793.76246511590301180890', -1);
    T('4434283.709', '63814910740714880857390949.18170', -1);
    T('-19123084314467.20872238837396740488879369139405423586', '0.0004154673731839293052318786962694250849938501580037', -1);
    T('12118.39981', '-26215', 1);
    T('1425476489753.2', '0', 1);
    T('6771847.279065', '-176720813115222.66664', 1);
    T('-915883195.783206257390', '-1162517435079017677181093168848300277', 1);
    T('940255279112483580064474520160.01836316454', '-21256974.01257889791261612212', 1);
    T('95730426094247272.25144832146486095143107940354301', '-46035913246450150341614859268398866836154116011239252918', 1);
    T('182340191187346850984880518.92122432870860784218323791323', '-45046691441.5894152', 1);
    T('-0.112180892367092832302160275033223995396405949810852290641240', '-5048973.374988', 1);
    T('12547796757213733598419046692214', '3054356083556184826827825111923516899788365822904', -1);
    T('-5.1917', '4788005123362165402614828953522.322744', -1);
    T('-172.673385473127', '7906028923470497913119471880236309806492091000269715326656', -1);
    T('39.36478', '-0.00000000000000000111733659477153687132091026586982038613149571288390834', 1);
    T('0.00280064326461873471', '-96485541594534.1717745476897400616', 1);
    T('-53804410326123080293766343804563197457587.358960227469', '0.6042327037044788643429', -1);
    T('0.783179986173131431415315377310009758807865743500314352155718', '-10150718377702833509077223188001629199784735482233', 1);
    T('320.1580863905990337350358843421238167150407', '78483581833243910660574051689573904282.53796879219263412', -1);
    T('0.00000000000000005913773611490029218785743338181834029896', '-16301992210.353', 1);
    T('-13791710467720660651705727', '9004174340.018826831004190863', -1);
    T('-0.0000000000000000052146576165363099836000375759397050145530205395264820', '-4744954283790', 1);
    T('0.000000000000000068266442751433', '-21855039931', 1);
    T('116.841', '756981691.979269', -1);
    T('-7473997292613406', '227497901856345041678511010728961877', -1);
    T('-83496362887321946609436668599.7903028365237141516', '1024015979814432311137570785885497044404075269867866.737', -1);
    T('-23818785789.2912426283539742079882608148628', '-245331580042569', 1);
    T('-0.000000002349831704133945491130166154185575859959455463468', '-185375716299893112855976.016352', 1);
    T('129364225959.09296952466', '108542305819621.75909260', -1);
    T('171091046088.5982271234876', '0', 1);
    T('2370407657610305710129669557444595465119919578698971423945.97', '-821.3', 1);
    T('-0.0000000000000000066502835859829587521962052035084744192744097555813815', '29.6874646919', -1);
    T('-170.82', '-30241959962614761470726121490564851402310663.74902149607', 1);
    T('-0.00000000000006469138000554640183555511490', '0.00000000461742314618775', -1);
    T('-0.00000022716576662893621400646809659283', '-0.0000000000000000097981111184009991288395382994924970037037274346', -1);
    T('-0.000000068298738368', '0.000000000001713927973365901946623917833165', -1);
    T('-0.0000000000000148999', '0.000000684685591706506458136016541069868975745133391', -1);
    T('81817616220.930513909829790979437990669', '0.0037959556025699242990945655226111160507570806789539', 1);
    T('187587490328.76177037442867202450382678451459221314035', '12011852709039268724852416629919418328793710229665', -1);
    T('-2454260049688515674651405402228.478820', '-142484538009893665821574115250696', 1);
    T('-188143100145.00617383871359559450074903986323218040691', '39179506.59', -1);
    T('8613', '-448853115.602892393', 1);
    T('324475356028412945643959548259053230909249689263109070219', '0.0000000000001203', 1);
    T('-8591717.842088230805549679866443799042204', '451637831192239', -1);
    T('-6070762221984493.7954950487', '0.0000008266057502127693017207185', -1);
    T('-0.000000000000000000021548786264742140151119863195875002281801', '0.00000000304649397231813005172496843293480', -1);
    T('-40.087', '6007129887259380790745', -1);
    T('-1366148121206.5632778067071941207265023330623', '80874576.1341452071', -1);
    T('-423812196741.21772334603760090003720411', '-8489477404172873113334318736868836015.8927', 1);
    T('-18748128368612368', '1033760369950876702413539809148.635494241886415', -1);
    T('-6156774.639', '2141734773.98', -1);
    T('482197977761340226097523001111567130628.3114748', '2405937830.20828', 1);
    T('1.500824259421505', '198242033184.774', -1);
    T('53413278633421327710558227', '-257151492007801487684343487000253.407786', 1);
    T('-1594411348210457.2057201773399545926098672210220093884228', '-5.810400317391331894', -1);
    T('-42.524', '80197685.59875442876939670048', -1);
    T('-60014077957342698615530961389', '-13.78', -1);
    T('-1387665403.2451221994775416780152578', '-50.1', -1);
    T('-0.000000000283761964988232221224443682313729383881', '-2822338883009.068928', 1);
    T('-28385595875309619596283558.250520032588078', '147387993300214796016282545977170456859842677532644', -1);
    T('34686252767892826', '-7397737915931657409753002235117.507122010962757', 1);
    T('665935851.03885464136023', '-4.27966623847647', 1);
    T('3106722949248488343.5712879936594346', '5207020105979502838849125845982284.134451754294609', -1);
    T('-0.00000000000000000001162533600824036331509919011567723975', '-0.0000000000004073637073187', 1);
    T('980601.882104', '-4736241802290.1', 1);
    T('-1.264380690744', '-0.0032883798709792788300566265810', -1);
    T('51319085247942607.3131099', '83544328154437955698662922791047991992', -1);
    T('-192623899359040.3945129', '10926.94113484257132806109226984967945807602047', -1);
    T('962893591125264662170537112845916056.381612', '368.90671614695431830669034995', 1);
    T('-3007190292.596872064173502838572330294928926267448', '331482510656348', -1);
    T('4.619', '12807796.2864949', -1);
    T('233052.5454017603326230828962755508957', '-32914.3881917757', 1);
    T('0.000000000005544400247160205560916422655780463306', '-117580.4643568059993825255748662006333620879934324449976194902', 1);
    T('-0.0000002279846534365632207677600216066596305', '2322126554056.4607607287069', -1);
    T('-87331990126', '743.4', -1);
    T('137842568133527537817773506836473835596.037638095', '23.4281795386520220571331254754387057268591122176624659', 1);
    T('-0.00000000000081272882678106791203475757923134527272965969323326949974', '-0.000000000000040624141216710146487026358979015670993522638121783791573', -1);
    T('1971.17747372189', '-0.0000000010768131828513761981866874629018005', 1);
    T('-10275311905140309547900985557569021235914044', '13182550904924724360875252856492836233318627808046410', -1);
    T('-9096.750964541599607962155', '13028.7', -1);
    T('-0.000000000000000000202605861249781459466292197187493310550840999997429021337', '58400.404430535722017', -1);
    T('-258981', '-0.00000000000000000146942477886148939377531194', -1);
    T('25.9', '0.00000000000000118094876087922', 1);
    T('162.19622926933', '-68764070962981173.301', 1);
    T('87010429441884304752446680474543109139856949178.585391743815', '-33889485558163904190.04059458582735001225610494', 1);
    T('-3588694.63698027859953463343148736989', '0.20617368370080438', -1);
    T('252827102036303.9936197231087853010909954787', '-13509465854837088717675412627', 1);
    T('-6887075662100868367.99298907317434', '1438247217765576380817821853526995547277570394769356704993', -1);
    T('-2614836293019955922452927776550298690576039936033493782765', '0.00000000000000052031132538502067428026543', -1);
    T('-12663020159532609144497566.74', '-42113540319.2', -1);
    T('-1080616543853692231052255789606862766.2316765544745171', '622138464929033724077.5684575767378639873400300078414586', -1);
    T('91651523225544121200570967593879', '-278740040380.50511089730555', 1);
    T('-8.77451376', '21181531848.7359185246892781251068262178642', -1);
    T('-0.00000000107896277359728052', '-0.00000000559014447680213165225303053399586003', 1);
    T('-0.0000000000000031412406939689928816768809909569850137504174813806298', '267542612', -1);
    T('-0.000294657579', '-26086393286300.330271', 1);
    T('-271.74195581137236680782195613069', '952766.7883292538644370363183485', -1);
    T('-900.09939007562756381827', '-9918431930401851036841237625432853804072200032740725352258', 1);
    T('-0.000000000000030671845618853580', '32357.482434378971190374026634088', -1);
    T('-139410983097962987.71179096685291702409075212713', '13047.63499478071424425', -1);
    T('-62537522199.9961', '-0.00000000004918255915', -1);
    T('-58114807161.758057205498543979965130', '-3584702124152.236114809148315', 1);
    T('-5632737338122610476176492162', '824643338386766980921.71811030291008509477931405498', -1);
    T('-0.01112514633044857786937097571424050679247016367295', '0.386883742497074382567205105882739261935576163102168809328', -1);
    T('-775467985328533.575386347563813', '-2875270027971383845747422189517733489695440299684.26529970', 1);
    T('-9206.12', '24465276.6921610401', -1);
    T('1054.43', '-0.00000000020318289531837407268676153244871958794890914093632739765787', 1);
    T('7300988032552205.76041147839581218453548563753012', '-0.007634', 1);
    T('-0.000000734659730075211305671182182069971692776321779245044', '-17392730340424661359.57036985935157689014069028076050', 1);
    T('3000.6213158910384652830168161716968199806', '196899.54954822827787', -1);
    T('-28853.3', '108559143247879763569410860170094.00407203', -1);
    T('-10952790675891711060669', '0.0000000000638895380906681108955511361930418302376174544368019503900677', -1);
    T('-7687531139650175', '0.004755312112866962666181173910352323', -1);
    T('7565776384737032915661040051027778572949', '-160701353.9737519084310852349548363386945597974151833', 1);
    T('-11.7', '822380840969.7330218', -1);
    T('245133982.2709135080741155484684942868990', '-593165059759410987863660881778696387234.47816', 1);
    T('628.75774650481071', '0.0461101478872120341063967140839333563803204295885288367372735', 1);
    T('0.0000000063833770468977856889029286', '-3446116885099565994798245412234997574310.71146429262', 1);
    T('-2182184538507532.123419582161659811958985', '-16.178', -1);
    T('-19295.5', '-111077.6', 1);
    T('-1388412775496356558574776724142668543270374', '0.000000000186737893798664765627225688620011182705421230108657158838', -1);
    T('-0.000000000000000000173967868179648', '18152994682673.375193707089884990', -1);
    T('0.0000863560035782461361163890887831825663', '-1610362290.97396641996627173340421008496869', 1);
    T('-11.483483415298114396405743398201182328386755342848', '1655.482227981052539355004148643429722825', -1);
    T('6566771449.687708654', '266171391084042797.33757142850317159949', -1);
    T('122068558041101739958985067462542912538', '0.000000000000000000268384176192613299035', 1);
    T('-4556.5265780925613192416', '4408701630592873935323494393972993090123128329706084', -1);
    T('3515021.1', '81864516617484548687.671', -1);
    T('-178949.59390232991893024115', '155518413686675002287489205632826353865420.12725', -1);
    T('-180770193582924974272749992870971104340648972754', '-1928.19874477272271032797979599489260880606368041405343', -1);
    T('625944002374826741962891505936997879124112785.78254', '2.2', 1);
    T('-74000022874026102397', '-124816237747723579623236426033.3292987585226390794593838', 1);
    T('-7131583.112143898464453392111748674238953953819160850767017', '84543374363987655628953718.746396432167424125377', -1);
    T('57930668326368128477331750490208537947030161601033587.572', '5.500178739041619245327', 1);
    T('-1.017', '138555579979990641891100613226981', -1);
    T('-143314297738305919766.85676159714631636157649174975230082', '29162684.00496065795882', -1);
    T('-0.0000000000002178299609737745152878826159216416', '508720821875640011430584245157711563400384026461605542067644', -1);
    T('0.0000000037127521912905404', '-7112417145444577.80607898479236664', 1);
    T('1.4535281', '-2755278119711443416368353764068870008385673657351.287327', 1);
    T('811983.91569425', '-2547.2614436343839512598907421054076705190588578245014517269', 1);
    T('-0.000000066783814084373165177389', '153634640417158153571843303.3824378304880', -1);
    T('5559062891501876147096510441935756175635', '842776596383.34976492066280841493046933', 1);
    T('-4251086773215699216620141628146909108378011971022709', '-1.07986603344764046828530', -1);
    T('-2.38', '19960804157.01707538429700', -1);
    T('140859852236163731572799808333907582182', '-483673686696369232470123.2999332082319758158129919566', 1);
    T('0.000000000000000000029622654937176905639567324602041176', '6.8015236772403026405177389845218159042412678456034', -1);
    T('25606.7', '1212600404583', -1);
    T('2.426990264', '-505156.72', 1);
    T('-3323.26420573', '-0.000021970500979289375257', -1);
    T('-255663089355037.16392040629597512015094', '-0.41027975468456748910575155470378618816162355136333', -1);
    T('566035648379804767146020274970786348003404586796', '-2605006926602834802308635359877490813262595', 1);
    T('-0.0000000289094988182444091497941385745066427', '1.9399', -1);
    T('3409063904163491.67712627300938046053186814787275', '-788683478416.8521908', 1);
    T('-552.503', '-2.65992687121', -1);
    T('0.0000000000000682450781086750734123964535', '3340023490622963858.05775701', -1);
    T('-28.423300541592258577722518374987247', '0.00000000018350659919154', -1);
    T('-0.0000000000338682164343183039173515869325510437060743440', '1815582615544197484260137.3218056141775424580', -1);
    T('3', '84909.6', -1);
    T('912649891343940306774308274', '735.6', 1);
    T('-26734270259188991826781396067266586047', '185532822.950201471152934184838760', -1);
    T('368826381.7105579623244756846366147277999', '5.5', 1);
    T('-22848732.37376986942615233017284932480', '-0.00000000000000000001612001293726629147004663156694479784423162610622655555766', -1);
    T('2778176016640.434269090024108', '1048566837961106', -1);
    T('-0.00000000005687373876856047135405145423769679122686973713754', '0', -1);
    T('-22919522347.89673645577646706445', '2', -1);
    T('333548957780868457725754851263954857512', '0.0000000002186930669230787434579292', 1);
    T('-4020857112014642672533241638057425567305408226516383316', '-610648130878189409.30664242328454522474430938', -1);
    T('-575928405847231664243702964453172201881707803819077958636', '17476059949547258392.9269270331051429', -1);
    T('-0.00000000000000236', '0.00000000795', -1);
    T('2', '8398410026740057242211865329491307671', -1);
    T('705216162396.944649', '1147259473068686282007211288799376369558792447024.1997172818', -1);
    T('-0.0000000000000192467050834', '6', -1);
    T('-949763984221042841274951349558.10112261647', '3', -1);
    T('0.00000000000000002489067290965425526486154888600759799385750417414529209', '0.0000000000823737490521166731893020565223077334833777', -1);
    T('-0.00000038', '-2632134659727565258235592973628916007.949', 1);
    T('-69592.16495307008', '-463465967056256671637919962390996488321070177494218933.43', 1);
    T('-6387758166555649.89131479869', '1002182649863740744720129461114521861386424106.91208215022267', -1);
    T('431.5946803602483', '0.000000000000000000816082696768067476521004613496804107266986784152470313', 1);
    T('-23812703844655313104347040675308650219032315064', '-71724306.2930848005664925', -1);
    T('-0.005366575257566691274487675050792258604517208', '-50270812932100741999189180430.012678', 1);
    T('-0.0000000000000000078075590970858480352604836633054432965570', '-27324956076689844461004586831.04188455331803393389628', 1);
    T('-24102905908901166081092826266887612015', '-459655866683957.36420', -1);
    T('18620863003604271884104610', '0.00000029683459505576831', 1);
    T('2.21', '11.74', -1);
    T('0.000004553511760142', '-0.0000000000000010330082103', 1);
    T('-13676169.2900328430847', '-659552074603595567395834543801367207404186168504233', 1);
    T('0.0000000000000001438969718407410316532098007489935388', '0.00000000081225083195136102279920779602035', -1);
    T('51597', '-3688953.37331140657540657', 1);
    T('5.0', '0.00000000000000000044951103341270485292979388', 1);
    T('61725.97', '-318781217745116634885912525386954947113588.846293794020809', 1);
    T('-504283888.0252594786037412363612838038962476794771680754', '-1144808847766934618876.2356421', 1);
    T('9701728689144729082229.639579', '-0.000000049089013163887977', 1);
    T('1734710425425226243190199621025858405083851', '-2022478.07568145447065678665660363516370892531', 1);
    T('-0.0203968042130858225550603184916550906', '3561783820164476692531301519095829484664197181.88', -1);
    T('57745178282004030498957972.6440468982032662924085898763', '0.0000000000000000005401742140193599', 1);
    T('-189888759.413694676', '962721078656113954807517895483569422587.81272690880505144016', -1);
    T('0', '1089893620428779572280086', -1);
    T('0.00000000000000005263900289846965180622155474', '4964254.08251899455', -1);
    T('-2429863004900274258713082377.2', '-5', -1);
    T('223562834248418274852', '-454450351567026707172759587', 1);
    T('-151149364443914860721418508987736982714845.09', '-32162477518638198637106030', -1);
    T('-479815101913558893748354066945159343011138914699444', '-8388616248281.177', -1);
    T('-896582450010216483769437258211841611193596983', '2151162154931974.5324307514844193735671829753537', -1);
    T('-4049.4959556373785645366161076408324898239699112274', '0.013169159788356096', -1);
    T('-0.0000000000000000000316327403661051020290330503045336299615133', '-11700.08420553103941618418917556638908321476907300', 1);
    T('-91734721044809355559.14146', '12', -1);
    T('3', '-291.2', 1);
    T('0.000000000208876005726', '1109144943822082911633590', -1);
    T('9144991639852325623127064299724.1037', '9195201.269557786877068732018', 1);
    T('78715642607677481.98025', '6700913191777637296013511988358756280.5878553149112009', -1);
    T('-42024992208847626581242632149881286185298896514143767366037', '2463231358853.71880752761233', -1);
    T('1424455191304023789401770179431438298242.5956172095628134529', '-84101775306.4342739228941346432384510922338362929028798837', 1);
    T('-2', '8298028707904306800597805656615422.563428', -1);
    T('0', '0.0000000000000000061793103234817538282147379532723959171618', -1);
    T('-5487921270.538719897462383104213699510', '-1', -1);
    T('268682329996669747137239620985539555535419363', '62924806289369.19580487653689872403580775', 1);
    T('-0.000387355252629095867081739966073411968600277129031410', '-20830255873882034860249701068781380943483', 1);
    T('-1629370894763750572049675488248', '991789483832341479415077040669482846.446', -1);
    T('490412212844.567042', '1193114358067372516507866.7675019818106066492829', -1);
    T('955981.687631958504371296000429391844', '0.0000000000000000001766202113828052550367604264198057743528417306', 1);
    T('6431932.913640551', '-126629077818549423618884827799639161238817.7318896474195', 1);
    T('173236', '3919.931871161121317101046368865876703331', 1);
    T('-1128657348139042005269644515367191', '7320475389227053819151783370434503694134148', -1);
    T('-0.000001531508743186704496242168865663427', '-41287316832998.086030726461470592703928425646406884861688', 1);
    T('9833276470.19', '-1340313090673.9396406089183', 1);
    T('-0.000000000000071266085262734127620', '-42269405460346073.44093606359227914216172743976226345709', 1);
    T('19273064566.607617709592384430851504568825219', '-0.0004352973090210742250757', 1);
    T('-0.005788', '699340993798990426136300929857470.932190', -1);
    T('-88.750431269011', '-185105834798384460867482551385762166627884659.971162492245', 1);
    T('0.000000000338337748871769299443110098647543052118', '1793651380297444523883109428377964622519697401107621959', -1);
    T('-0.000004410675006466359214215854792979430946366025336494150', '212402325929778260730054.72532540928129434351789341863557', -1);
    T('0.000000000000000001072224833476632886638952280133590418', '-65485.0633', 1);
    T('12502158597739959186.705468775503441', '16.66597304878086673769469360979630746', 1);
    T('0.000000000000000009677703', '0.0021843733224756870769', -1);
    T('-0.0000000000000041999607963521154604945381536827703934336876453', '93664.27886678243967349370590141313752374055497859', -1);
    T('-0.0000000000000000234261821391240556018', '-315.990655680030512945994935758', 1);
    T('3195453260014685333492830082716203563522.36872', '0.00009325368310030723757358157836689348934835351190017', 1);
    T('-33244315391121.22780712', '-1311031062177.74054460725962379', -1);
    T('-1707161.9454', '-12005804839001.54244657079130670097736', 1);
    T('68352491818706598.773651301473666770317477098618521912', '-0.0021074281045472626934633424986655940198794278022', 1);
    T('26.463440708', '-0.000000000000000000161495480948179406780882857906312583977592728907', 1);
    T('0.000743978231293810720', '-163654150785', 1);
    T('-10.1', '84118013336354653851057751102778.5255011398946', -1);
    T('160481384203.203261436811734467630350', '-0.00000112857893416261', 1);
    T('-3309055960935586978293.0524313', '21483182429538345732977842.5731059392', -1);
    T('-43958548371515045.020150030047077069164032471', '-69176275532496.255925921038380207105737351', -1);
    T('-0.04981670073679086136919289630392557877963', '-398950332875156202401821158696058677232947687447245.417278963', 1);
    T('0', '-435528753375555685177004', 1);
    T('0.0000032297790227357092301516546825411526485804661', '-723817273826.900', 1);
    T('-2702619562405304', '0.000021620337383638552928', -1);
    T('-0.000000000454', '1', -1);
    T('-3144143431608222864766150912095006063169199318202', '58.53291045364400226122849818452051713592021060811', -1);
    T('1115', '17.357031896358227163528', 1);
    T('626983028701766087311204001', '-2615488710736467295.69042919296588', 1);
    T('40365698821085373.12608667821372228818', '-49815765062.89597274348089400519601', 1);
    T('0.00022', '-3607024557794704402629081642923', 1);
    T('1364091171276057.97761244863798921737454557501095284', '0.000000000000000177865197456638064216228393652693903199280', 1);
    T('-2753914199438393', '1.968442310668164769128495107357994123999170779', -1);
    T('-775719502.7731', '-0.0000000000000000048612190810399950650839071400159174695292975458830', -1);
    T('-16116938624203335.4', '-0.000000000000000006412977', -1);
    T('272612865514273474320712548718.9402594608941366', '-0.0015869340307275449870331257080282841124099817091326', 1);
    T('606324260201754.1434994221817869056714199', '28395472736102159748126258009090', -1);
    T('-425.804232', '-180233.62994', 1);
    T('-0.0000000000000001323505962', '-4818224435323036527507513', 1);
    T('-0.00000000004875768812254650206225254505968862675405582488', '-0.00000000000250181', -1);
    T('0', '589543599579236108105278188597394.7', -1);
    T('6194660387650555532806365.67785490665673624067515', '-5562299925991551211.449094280', 1);
    T('21071748634936165958428873502220200671957884564', '-21877247994257440926313.112083', 1);
    T('29.6', '-1284653117475257.81055939276439345', 1);
    T('-0.000001070241', '9392743602622997628985533350323669657', -1);
    T('-770440255222043537495200.6997075447934779176467373', '0.00000000000000002163072792311046458436044183497750', -1);
    T('72924117389.35377926', '29103179425746323066349616562734447341721864', -1);
    T('-44.7154563464707697425999713876377', '6316419259432079567188243897453099488.27986', -1);
    T('231.36754477031773', '10395139401326885805822908081481', -1);
    T('-0.00000118333338184521046036822', '-320975156502906817', 1);
    T('-168714.6721140026', '30811271631788712886661929275491543882895', -1);
    T('658.039394580451534505618643867554797997792535540581487878067', '13102965065445154782', -1);
    T('-1765398404359286937871993026008756479663.1249', '-1893.842801467346249656722764607268566624', -1);
    T('-271426086204740642209831748805289909458935193844', '0.0000002849584520073597479884182004863626528356168604', -1);
    T('-1377816279284.24202090550539206', '-4482020235202103266487160771495221696.9569187528465', 1);
    T('-5.153338782077', '111841437759.8516773', -1);
    T('1935875317534881538626219754702496578459939396459924407.445', '-2.69502254630160152110', 1);
    T('170729241284179053792255', '-4451787575715904462656351072032905153914666075264.15', 1);
    T('1889745529039666589.126273', '60497049.8677', 1);
    T('-5033600800189.350388143929701198516318', '0.0000000000000000000560155992523696741221395', -1);
    T('10.5406982381', '0.000000000000000021', 1);
    T('-632940973989610.559', '1453966800.2947369036854268970989152864530', -1);
    T('6001088411976.9726351889534473754', '-1', 1);
    T('-0.0147896392703218629529334742030182', '446.69797286906823912856467855870955584367815853', -1);
    T('3.83283725770115471046394373426687880', '-0.000000048688749586070845947492557870516966863282338273', 1);
    T('311.472046824904240126119060726132453603437309216724993936', '141057050127502107523.987453975865', -1);
    T('8207155.53', '0.0000000000000000542558038634643663795', 1);
    T('-52.153', '4992402747992764459141957946.173249', -1);
    T('0.00000000000037087971513311066134109646107', '0.00000000000000011416409371', 1);
    T('-1.53294577434854835684', '116405244945444933601158446.489942', -1);
    T('-148112201957000169.55322721393', '-21184576168032173628662.173748989258024885915978002126587635', 1);
    T('142.834', '-183660432602724204651884604531246', 1);
    T('8893.1', '22902411.442310886381060', -1);
    T('-0.000000000000000000049301490', '-4268821956373353475835160', 1);
    T('-35267430686890946642526643.40527', '9442.78', -1);
    T('-388257.7548252', '-22789237273726383', 1);
    T('-0.00000000001035915929141861402608660878800813727', '-13364427.71449240284234717270638783796', 1);
    T('-657250878405514264850.36740512444031797888135499', '-194007658128943.2702175990', -1);
    T('40622.00027155142785667332283724715562664685', '0.00000001135895', 1);
    T('761530675604.544', '495276273239198618829474956470.233178493', -1);
    T('0.00000000000000012', '73036710782920745627417158215393112044826285848.66', -1);
    T('-2759374668072424884167545392056988395284630542193729', '0.000000000000000068039371483156100726644177048338315397952004369910331937248', -1);
    T('15.9120', '450286871.1411907943653435378050516223461628482', -1);
    T('-463242.889', '732474228336471210605174200838.347164418188057', -1);
    T('-37054664518639837.961401170232480179055753', '-0.213597333719034786247662894812723740483671041535079', -1);
    T('0.00000000000000000001373037051536737485136263054', '0.000000000000214231995904201121132614658821157329422560178904553441143', -1);
    T('50637443782578.4742028134098808129659944726779514644', '-23026666.00721461124457795917', 1);
    T('-6.49', '2475361689.75199634250718942163511668171643880656258831085', -1);
    T('-1002990.83923290495185295078283', '-88091991857.058', 1);

    T('47343984238976282156612318707707241507', '7014.1380688580943680749895193484951393023851901068954289', 1);
    T('-0.0684650131341203263401401552553627094627677222266117828967840329153916004', '75230922521264678531581542609391910658509316112860752792749246167142277738299159084963011895369670394282283243922357698845', -1);
    T('-295862313165400124619550237.656069', '-0.05242949757418000580437043689552606133616192399732961267572280016078297875290996591091471487276864075033912589320229097078489273', -1);
    T('-0.0000000002314229728313932834817367208574480091285711473641947850686', '0.000001669738346220713984568468088', -1);
    T('279047626684188128091435590947041377415469191572169057666439886858786324321493442931662682903818854501531', '1014941974886877047600692.608173634828307821277211443446841120485731400366934581079981241944892978588711090656843039207957131', 1);
    T('48308709872782035593925640996821550.5973961768548380479859429302524753667536555613596780627951424760211059088558463346485', '-0.00000078577667662550261964917332375091682757798693072266793892607597426884314985327535125926665884881508153537106316323804', 1);
    T('-40215116723353583608457914214243065135175415923039250335730569657501143689052902444197762903775444.171803001', '-0.000747392053570593271109057105058728438851585178963059266112875660536041822237424884', -1);
    T('2819145676011742129640869014892511895199224936983927037212297.32661697202141330300178285210', '-0.000075196819438137495966275363285091739887328834587350620047101366951164331460643462218485807470864914189909573221028130571976946299969026068777239788983', 1);
    T('0.0000000000000000010446946709023771', '14509.94652999103448344', -1);
    T('-169686607281341840589884752740664499041142720600502268735857463345287043', '9240364668978345118.8252917399138216489359074021558811', -1);
    T('-0.00648413653267434764253188982546409464526518238337229133733999', '2948.7980089962735491284253586450260337878935566878447899493407398914786100293772145150075', -1);
    T('1001973818132969045188552394268298635939543267204272678642391489560726393924', '-2059855354.02655908060090748170485280847537851682099516287881930015016266786206643', 1);
    T('3328359199438677474383438883220437819298385482514329045164155052810372940115672255269', '-17822566.777845868041139594', 1);
    T('-6542320880710197522834989015966.376007802981186176649420394764512', '-46908061275717031191255178167927.915776432317777604650368349154202614657273310196199200481525517060796473584147643855326183999949752634506182391510540', 1);
    T('604836.583993358823509315213191546460434278961276333727065449874496855101461036551875374733492090745310221170534047576583343077626', '-4618.54322501862329794473469782199104028963878464891188614915521', 1);
    T('-2986655693343577190483562333.92412719013779269947465010977392088784157099123429955850534813434978228194474081909354332', '-103384861271501400520575481696310128926061538534263361845524022957997389715640479561046089692194108884343449310.3422536845368577965862523217', 1);
    T('765724.8058196984567185549755236387342642542128601094827801684110', '-2871511540480306286230716009167755118386587513101483870025917810.88436946780861454715514628104283462503253', 1);
    T('24448714061097007787870390934284762281809018607186508400198524858281434628378799796164614395462', '136860921422568786599033843935978450.6', 1);
    T('31976050073630733902118874888120198698694428091108060659949876943761489391517922167985154033832205584536458188056791991838367292725618452216501378', '-0.000000000000008724016496', 1);
    T('227751527822451319233980036203061200794979589033503610838256022189246563024105758517686476756678884039664356839803154355514768438.25760233796425193', '12930579982912105586374957109272.9584159836524371', 1);
    T('1514317730700056941559141895152952074535483501882733867310806012120694202376730571677339176140545799', '-1160800067156081508973855089834407714656861906.51850431230507', 1);
    T('-0.000000000000000004528520707580758615957670805419571717242606879228', '3281046363579593520467268296573492611708885559390440995276756319312503600477686071166829762632', -1);
    T('-15142766.9262153859827204', '0.0000266963695358775794073681141921441505602549064236507947', -1);
    T('-1170502802005482729655202039369546711769196.3826548809416965101170', '-2.7922318280801312629836579611849652427387594471800', -1);
    T('915561706486714241282431129.3095438633737782096437500430272652', '0.00000002743295589722432883027847254714940643024630751707638612336', 1);
    T('281768416547033993113190996753004903757335724486313955505402513939651088167932178912956960256084911825899718067523864582.316462439983238790646058945', '-149073711831044726451905735929139231365157160963186101095501511510907692030494797397977970495144468856267403314717745696.2972152852646707723456012113066', 1);
    T('-0.0000000000019747673020255994583864712477644533161788381792300799696139839', '-31965855724497611653259696447953582263.2864030194503056', 1);
    T('-1174060959246006.755952234360360526196000440620268', '10622998243184628451912141.109071876810564703814335906300181', -1);
    T('0.000000000033846382113152238688078094044310425164545900148933', '-1111767780033233092141350626922156977507571423642452179209671272723.16734621884468521854782887743133173', 1);
    T('-165250590789141636082920277183.08120431640165768', '20582.14148', -1);
    T('-468339329.835642768092', '738514159142.27', -1);
    T('-0.000088399519151094279453456909123490568956224146530747517787318847682582696828096135575460415155822773423264653037725174685656', '50694235979171725.10284160699574514405961006184943457644973589154', -1);
    T('43870463394510215993877357948126367526973038358203', '-9722007431984300534876108771208960300602249500573036985', 1);
    T('472964469449264925748432818777986783251555850837785.155421757016608709428994296960752', '-9311662.297602125194', 1);
    T('149990356612051183091016.9779087859113196930497144865038810481689032713686587351635927000452', '0.00000058376621752446454994221296235106373116337068588954258416259841704699029370833659808532069056542382277544874169614425448766346261208', 1);
    T('-0.0004607678264613885284392068473867065453534101118751415631835372760188817535650199460853741749428132718940014704174405734985617847478329957027082025', '70752058498943698615424955949868075492906532507.0176757020599642777622407991179893486322582944963580901150580300804716044265973436522', -1);
    T('76888778535419856741284623506934651449268144461453.4100936081838029065930113909', '-0.00000000000000012226026014905656393255160074154788749706679568415031254318647732324163664724545113944076277226550929098290192398236321899151452', 1);
    T('3203156318209811351127849964590315886954164800424606142343745.1683686381578999431682489662239045', '-8269184657749537294840577216855405317480047874381981', 1);
    T('20111727365475687172481528350050313287788545571058937993235075289638298425.086714092681300133339985321', '-1.09', 1);
    T('8792.394469303535648526', '556845927626235935416153911457755895037951239.9178326008028011116088523904503228', -1);
    T('48136562376.5855982', '-4664620002491508667225096233.3353226241084544027216354820339730176405177528341220528660597322792739250720990838180005107732410742208527592663761347', 1);
    T('89763855544387950417149466000861904435721204626431782465991561650.90098406420', '-0.00000009765299607531302464539006851217800595264295701520065262877011318715659812090110386884067798529550037236942', 1);
    T('-30868393537038718005', '-0.00000307', -1);
    T('-5185223470716576655809195163610321.9031646', '-2615549017350666281371362184052090206474489835519628225335567276034298501607305275085823412253', 1);
    T('-6570190451631686560241.38001587541890402432848708439444609643933707639935590896259', '324626622468660389631964181439480620661269389440074118784879141638091676591242082.35149172529026676393528466386409586', -1);
    T('102286341466180974423299.520959571961131384673275163806585575115835', '2745527309114708070695269441663991101771080484480716171439709632411018440.9471846829949932144642406654855468308', -1);
    T('-0.00000000003977653756347008076395413408629675698295885109193277602695303170782568202351152991936286417399933347874102607', '597355470921919715241658157756484780639935506634657853524178238394469802448173406793521622383466470180001778292727.40733108770130813735753', -1);
    T('197887959303.601932', '0.000000000000000000103458894529722050736055678304440744297638258502459562179105262236341233794829198584326110727749506382519131830616987451966701', 1);
    T('-13307726476516464006118797585863798440642787931380742817511702537361080004023468421495571836042024747.479074717', '0.0000000376335065425310597483666155345223642007352033783310467188460822186122860392955355838387349761629994780', -1);
    T('-936013007953467845983397438772135456939667638978675074252173994774974753052079960592.47977338457210574236644512980713', '13576615292952511187779127518363704883999332503672973.3702971759282614976225115585', -1);
    T('9.23', '-12798427797276', 1);
    T('0.000167142048', '49719109889269472002178986135088991291890225419981596673500350553633201288202635.772926153589574093304933356854028686159563673920076130779451', -1);
    T('-41507234.121353293309393741599055024405018684', '-615662226549782365482025752065081146308129562731747780117504154.7257', 1);
    T('0.000000000341762255281442429237209572068507698445580331776282387508674913040101434213455495104', '-41949136443982932485075657535585958912363078315441820291608', 1);
    T('-265613151330300009209671564.4222473758380149118266958', '877381701435580606449.2823863360946489509927889990897436462984330011', -1);
    T('-7775.7801922935180522039801358877017608615817227', '-245677467624819356918999869496669189293253534311463142326275828.8385050566807262539312986315538671411353195745005372884107987569771605', 1);
    T('-56671611310047491548245067647344781122049835409812386627.47184833607976624521197067809553483420845430755397', '927756335187625067734782189305518713116277817764247.57605072238432753688349923151908068643686860012798840863564716094325436269552536311256667911776199', -1);
    T('740145597581078317830455002008118144162252296932312159216520649062910882', '203.1774262154445', 1);
    T('0', '0.0000000000000000009031734111110941301911861337773289644877967835', -1);
    T('-109614283766506080410697376197915899265557750362042034638637253839764519329034984', '0.0002771704787349519193621964400949845983482306593453116923699372132126053949806228372333859881841496151153670277673003333721', -1);
    T('5539849710.1733866507907276', '-3181810546381672360262045367009456644564406098.706843157492761', 1);
    T('7919.8414971201383271371184303738534957144878404477288669', '23.71850', 1);
    T('-75173119692055.941978185535165359347403243', '-1777369117489847081.5793755856264212166727373899851099330121210857826856', 1);
    T('853843518069945548394273175137114345101444889.9227331700075815923961371745037613601267987181194', '-128714814686121222464195889406689437357524546230.015234400775', 1);
    T('-12254994213398422679769049305686.002801989668924092053922987716790500288719964943524816679018713', '-103.138354211842234506715721756147981015254031181706983900640592115628103240710219474933960256729509150933435108751279275932464534793849351884639432456', -1);
    T('-59175298043142026219772.6138367', '0.000000000000000000070447947045776431902102876458194', -1);
    T('18408853293470113069702150408569784461075475098255264356830984000273938318454913474968562276768901135468209464837', '1547252236967174250.6109363062455217002510723246', 1);
    T('0.000109934251781192379417653296979431190196397725358849059626366415903680138562279946229803244271813742725286468939793394672457421', '201592.88634560', -1);
    T('4295549848243131726044253553835945417165130579767473284081170673527181.25870512635225264560732576630', '102151540455604787176154202447753962845.44365218', 1);
    T('-70018315186783814804204234064836070201850.45111825112808417052739', '328359595989649160.27671859944', -1);
    T('-187481575498617809778922382731003340929808335610196169', '191210658629716423428208663327712.22840812936979919141196164775880201034911336765', -1);
    T('3935126925246231555928598126054809026090453369989273776664805163851.40944096517984980', '867141118109779658944.2878631198762910032', 1);
    T('-3.3112', '70293088157175047259886071558256457067098.48990741414498249210048163949091759610703775633271629309548', -1);
    T('-425672404160144333420994274930650792419390010238350069166384976005003337185319653781910705867425126832871403392819177542518702296572117055960061', '839737903411111958962035888468571596712972008129364688.4039', -1);
    T('-1112579726844536917102467847.17653', '2663046929443819301686222.8815254170857930', -1);
    T('-8252839102489352083135451792859801342710108.002349758', '0.00000000000000000754813631507054088229552535842607509562669628676682863560861982957068071893164866381925307374227108742169408306216812315857923', -1);
    T('648977871365662014097820749365461557763157639862997561.9226938534796467778911346445390320354152128870864719689734', '4175599249314851119719173611802268614966549291562107396112171800916368481888650992052892917907331', -1);
    T('7.978771111691608901034895922046997520765316732991829020429708671577870', '-141461002304237680013302819529217200685047249677913497940481241136261081366014448461680075.314895392687287547792476133', 1);
    T('7645457264770121264.11519238056423560881225944703024802644929136702643335901338244883352676085052049326756123902513', '12248781443620567711948542737349180298557346901690131050556844819693354875119397097.3069688913965372036867997744', -1);
    T('-31463526490509734316426714529666961013007041330904474383539907327397930.69855820', '0.000000000000001084414212469851737741900907708478145214018350492547421106994594378', -1);
    T('162421846200240075972.621793667847764426048313662775180616649900013446891164416772769820233651942815777530072677881008330637209917194592673406865011676', '1636.3384899943980', 1);
    T('-9388.77817056401956890804476948', '46543968580057.279028606835157899512662680123283044326771', -1);
    T('0.000000000000000143303812564681790621876402521018890314183355148990', '-7628794548804927.34', 1);
    T('-1542550905995342000761716058753926543294062017039230714986137143389838208183333', '-53800959573.4262787634955806006145772222341066088520813', -1);
    T('0.000000000000001152730387533585619339997779185607646939273677780916', '81948301807320885956271993225479133739996835479108177281833065098631486001558755667729745414069819258092', -1);
    T('0.0000000000000001788799320895331948748150602283438995686077438726117754118635774342676674835559', '0.000000077520063644569438264401511693512958609441535842475827179071085391862921498640290404605863569208836853054800018312203', -1);
    T('2562546890284566201144784661620724384611158674150768124964079346239943289319722480037060276111920.222136554767961523266727357926098927614671062311740560', '138605604122306326.2813293437333129599840', 1);
    T('0.000000116108838430759441302782521474416259839111834957042904031702308600565811558707520', '-32773081443699450674814232178208000165745.1531323897041933349725844322275', 1);
    T('0.00000016962435025541763496758773163192785686185', '-489746511467818443870465628849334514883582042615007726260255295320662714496913671884730698683.29565342494', 1);
    T('2595681723.354258055254516439280643724110163289153337969294375601861106415452385', '-115227875945154401241354604360157180225326718208937244144045426579478908666999062245014983584623561102791559344419.3439990067153', 1);
    T('13988.2256045374464162730896958695884374', '888586900556332788670112482.37398292826916221274855412326388860996499123880558724209443328949082009286758571156655913796044564457627209', -1);
    T('-0.0000000000000470209539970879477', '-864491095896332104056.032991', 1);
    T('17234844171529654006262682431556684956259672.501251903404554782171218613148856041151461738989660504903649745731468011585476495243619320849285372', '77.057212', 1);
    T('132143152930296638008029506374047631241235811666497989329', '-1574290622065771830275216174898081456821450631640123172766526472178.36621512168173889629852301981351392061034796955081897041667393', 1);
    T('0', '-1316574314525845529636399894653083761113210297566939806282601610613495358962733006.0', 1);
    T('-109413572345091592273384912644432788116678901530150032030387206946515405272708194880210199360', '0.0000000000000000001151002167821514439222568523527362216245718047502081296141262348073695099576990022126977579292159436086696206194791236098302610981584', -1);
    T('1710704295541545612797844331135458249843431195009010270413420412760951540267443630154282121567740496794165882981618621038738605039191086840775989345074', '218797555950100963168190026470661147747154206564462260', 1);
    T('-0.01986463638088003519038677632588937621107015695', '-1028.291246864751944153983531204139834559', 1);
    T('-6129329794341331550700126780841411.10681976024490695157405556642104977194512590697213', '-102763039780830034728404554703096.812100908361472984162806', -1);
    T('-226.626', '0.00000000000000000023420336780091', -1);
    T('-0.000000010129241772248087133563483455888815190018826890577292551683993175479005119579601450564910', '-1790565914576279812291386964788431643050956024856703305009441744724322410099442946374063091238355862765866', 1);
    T('0.0068398345678559403526205622981764242038537974473365', '-0.000000000001407581522035574500483500', 1);
    T('13412104116279855792666084150933562672654470809264824', '-42.260038186873416278616781586145', 1);
    T('0.00000000000000001437216', '21380203762019351547345259799258194003013715652251954478030855132881874773077307627834740214867166409662357639227437420816938973889', -1);
    T('0.35484739402549358280548938093488455603603260', '114404993135858248063275522978544019274645376783367486741696148.0603461877153775553115699756', -1);
    T('-1392486513299304175902425517444632375062450839823901184672697507427515176395766963801250797985239359712769304501547503238', '3454044166627774642387359622402929225788813383864157201212.2114062265086063540445467889326266', -1);
    T('0.0000000004235328175528436975135029779349501289306568759092284453523973254966515714043412430621851', '395056597915705386266389285222273.34', -1);
    T('-204238872345600290518420', '-7070509208.5', -1);
    T('72981605063519176291637366098161261831841026794183175316952260221206391640795191543.8421968648832009685372935897352204397516972141864015416063525745', '-36262462150667.754518420039671271875550396516537776640666003', 1);
    T('-1141023.82684352', '3434872367397371325216431040190149263337567687305458524226443036', -1);
    T('-40333484548205874986507170870398476011.93898153865902627865880451768925350561994301059418337827757770353', '0.00000000000000049632092624546818538381130693253691731101933347881923687', -1);
    T('-230663466750273009979493177203432440.865302323651699785239168668412433309395152855727', '1670998446668363695655787373943065972222.36760305066767262349052811349705705205447571695947815663365442810397158464959419047231577852334892259862', -1);
    T('1495920643058959437383621501654941246766508238559437227184395050508514977010891589414393139195', '2', 1);
    T('0.000000000000000039324000814212786891918567188197481938283669634275484732259078', '-2299270960425972615800224709593358786239089449465769176018404837987624610630628831153594469455213474024413922975.3876555670185953786804983807034', 1);
    T('-8082406101601203880115291043102466270919070095098281953735730788166344088077537197510058.919123451989584674149285735070236244024421371', '-0.02226327405613293121833686639574431245399059620617834149317063960558350928186286512729307426425266342626060275759668774073177785043824298828768556', -1);
    T('-1260845046.64883107384', '-0.000000000000000000032951467370811927086119928603400891551133309876860179950981702630344524252699073518428054', -1);
    T('-41702237.44707624355', '-403554966566407328040246233531173350056173185174578248744654858876543716393251428956136570123.045148101168981528401974150078770666865217717450803901233', 1);
    T('24411533732401288279000256393511093097142208723735552385390279631903938583581112236833308264597448368803308517021849284586376379400244500274869616', '-540499000648432033602513088454810109729675397905099895623746885562670714393437069416769033407782176', 1);
    T('-12796310936083799962806258894032181490930481696661675693244680395898.81995123483878975', '-2414014872118737871549315707.978848004363088', -1);
    T('-314497255487.428261813176560336175', '-6306491139786796925149337414394236828901640814689977446346353525569212758359614726940791393359277514543960143.6', 1);
    T('-651088466302570543016523906430706603794205652090045214990130588847786.8819083644743982693765724621734749239800740209128895951504965', '147959.682405388376182159454226557702317868363038056542259510762433258825701331105581616424866472646181109750953466531685333313177399667105119076833', -1);
    T('-6703.994577459788708', '7536793319.4553806370980150922073737014018531259247', -1);
    T('0.0370921742946192583396225808399487629915725931871147443686211585371265633482', '0.0000000000000000062212476744078005281537', 1);
    T('453699458249145242', '-14728948.0513745626843613222', 1);
    T('-1.28905599285812487351350473737291244745697', '-563389218829763133702542103957052040974515855646', 1);
    T('-308', '516984036404958828482096090056459410969858910697997243496259251361079985076443709267317847242129290643438742396', -1);
    T('179805847183633847438194.99249873787321719770175', '-1044247574021452596915714111909132257910423096527567', 1);
    T('123554101588320649544216.106518', '0.00000000000000000004397994853294475245700390814883392112100677236773424756659144675174327699038110126243806258189173504', 1);
    T('-312827142310757997835070900727109666586292473761969938151984196401897529.7967077459640049698', '14093333248931096650.70140994553674013659186980319834246516116032507700519477099803787321480988634011220877', -1);
    T('9288004658713735991395448766.471082786309347191997997975323232039392966794167278477200470135442690910', '-0.000000000000000000036236', 1);
    T('-5003663162392390422998559930744815950712475533778862767546033634736239106865398.34200465736653393272456', '0.005995077716475462', -1);
    T('0.016952849058784222777545704550635491760401113492836107817192230098750165112382036526736941511441770759965884476270435716500782779545192104844146397', '-214821059260215160489474.303370805896558958575540934636712555791219049338778586728609565132509837009652696', 1);
    T('-29821131523003664342065669422390700671001522069654500533110790', '287183970895010462611112222181497807816953448196337091051099725372640836865215266901010504439100294010735018', -1);
    T('-128872.71209378812', '0.053283411554461586465632620143914891566173223703579219869905435200516553382946461331422076259227430115354178', -1);
    T('0.08775752449855547001537690223228539966158257927867747229093074060191733122415129411764', '1333896222140748443545958875369018385387665379713651837509817389114355723402401.0775181114677961790564570079869', -1);
    T('15629811629486124784855833358618453024981468519010609184558364167.768915691712343011342006201865733766347105695', '-3559856665.9588532621138851367041381438359281318430119518966199303131949113094567635577699151940255', 1);
    T('-76654490432007487677111411474359324103728780911984821055308809497501614199876134', '9830309069585260103024961490220561448272871874066193433860218963579073519151392.1834947306646', -1);
    T('-31109911419411460374391974256048150041603191.62921550390052930006782191882078004773451449319', '0.00001106636466858', -1);
    T('59412.47533', '-39255066756843933387643056770701779729.0077716008957107251561', 1);
    T('2662712418298080979.1948976333080', '20186609635162532310360175381112691215793931769846124087001563989679.289555957816471233930494954952811347559621424189186664143132', -1);
    T('-3.389322169362240007054202653154909275703397214107362913016717989765940692515391', '-0.000000000000000001020953040526246078334443', -1);
    T('-0.00000000000000000007374487372528988414726674382189607121675122700289699190268421814598374167900942667245468200111960006664208395924855208365497808516088', '-0.0000131144124959397624156431920723496903533632256118147633612272158310284', 1);
    T('877109316442565059709146872571994508553392', '-108721.3420464648885227659186804342432278945435989574916950', 1);
    T('-310820553664742286349911323220568418134747887975679788573390691884700762375565019784272806.28132846056923331782638419840233371336', '-0.000129907852986510765050318657102730436310787353175435003200188740238798817208048019233959261195408801763064829045531860468977152903483168', -1);
    T('-0.000000000000000941506813198339645372998762911530208153055218698117008973604076971894165172184740572845955636588', '0.0000000000000000035524983724808596360636883393862678354781', -1);
    T('-5.708582962403979536402415075748013664386587264597389537125177279692027025', '-5444494016350641630074.4592669873553751386488228125095493679780365124590363918476034336529', 1);
    T('1065934250.01120693', '0.0000000001118603899195807698300785911351272000758786456989627596648367020369673309737349439920244363853300300', 1);
    T('-5767260025207073188444945197413274423501738050189735884547730160156', '-330580305165737252114656677623101326542624691273133923639274155802687902056877140616096326912578282576033.707651495772456980156560968135871591663460', 1);
    T('-0.00846559920865320709178796883143043054766377718918477778902455012013929978343738333', '-0.00000000000000277568352085571198453362669761349413107250675031694958277194', -1);
    T('-6918667114.993', '-46052052220603902657877827218788263055315560133469865149768526595441710407900.57985786910904527268305318771593273453522505547552', 1);
    T('802546912863329952116633224748510353570844472458722557014878400044036716183048576512202373334873328024319243274271269741459325940236721', '25.780661731282395351556152740', 1);
    T('2184816382096491338787830715753.096367163048963598057691886397682046882303288589909079888897521056426702007482', '172169492388519739357027405423396243714.9004204282430309366098112447812547986135720071346255130203678718947804', -1);
    T('0.008529045730082055582061059599446072673840302070786925367152757187979559845183911839396122993813579990676569522462800526002564', '29369561465233302592528037897817257355792654406799947375029638', -1);
    T('-0.0000000000109017743105447531682', '263922392004884246723806322057980218525495312.37380641189784114661235018695096998668551216502665339669331921962931477127511', -1);
    T('18149660819867833.776611203308917195146919391529441', '722175581734659614727875382644495.420521458331848034289', -1);
    T('-0.0632388130646494', '-8022179644458769940432045379644096328530320362627149758199672304055490229348414207285963636896546168', 1);
    T('-240884.4266125433562152474546222714299798660415870584341961026', '4565819105565625429351609469953039462154313440532798419344406123', -1);
    T('-620288745832328944104633174104780618530.142289821594467', '-0.00000000042763677901729875137065795271947506429102070293254358849747074726025655222531640583579591035602665241003765385226723638432242517705', -1);
    T('-0.0005997232813686082699072690646851437237510751191877857078487507971064518280118066752636224982626066803761438054710648081819170217128106038864606666', '448789772975807181453965791618344036709371894261789527483851520640967.564734687953462805464508292237645', -1);
    T('-5944.46084192814621653509427362663260065275976732261237211575829369239376100996606356674502186726973297493942586399515155362001241057364039180', '-0.00000000000497735100370463438660391749047107856740436707685228398464338395009618984454240220388539', -1);
    T('14161446516382225835.7766', '3542370132472105378163771457970216052165648.7425781268389210107209726519645230419709021897835457608593367579978930689174492450922488019354946229559', -1);
    T('-82802195741411961169504411985695677333323242354.11983177229539369704405186974555282', '-0.000000000000002144832189233807282719629172', -1);
    T('-0.000006784625484274469162301558877626829276531242437512334202379799727636918702695926121552306634079565967137748099137484258', '7394871143261456851628981304387021212671141137347474914493372160821.849982460588305432064962', -1);
    T('-2', '-9577480957257851728668158925285617815497407658006869447421603583582482671861877265553874067890434541077880355621667743910295.7200699525124188760662', 1);
    T('-197708341652218617334936385971802975665.2650590102', '53802911630665345933342409174160976109848064320688374526798452717190686158796876613968866779882767043999203016678122719894918187.874065', -1);
    T('-38072823817863136627991695274477704.5643520430804929832270354210126212790225020895173826266131214755461222609225019501', '306508739886223696721899282220346649.830346314255', -1);
    T('0.000000000316191129355863756434416730315412182337261365809876435613199367647273178078857089451964614692088016490008532807028204058', '-157162422306489095125228614960816215001360390504615263163200492537376167.697035893421723100121710027972326561445029491994146118409598263141950351594406', 1);
    T('233976544105397.53972383', '1125648.85', 1);
    T('-4130737000.0498428402668398062658352051845468818656034782938669910130276648346395651', '-0.000000000006241094763704769356703784', -1);
    T('0.0000000000027889130336186175616581318491830441190499146641708159643961020619163561667', '45180.36604064032026790448358284110671357633387319964786520709792147034725656798271314354746304777783951768808251243116293584625182020126910111', -1);
    T('-0.001763577869', '9278.2276', -1);
    T('-5950168542955097743177295383964350692.905100936503492816358409770353723347472035487019625013276257808231', '-0.0000000000000000029645447547400994864011386152017637251837470928190914231982054201322347159873722936132649422634877469019375233796913', -1);
    T('0.0290875288731746531591535288830511501906464467111328224293851702688888742097645060905370035803256633571014353548442220', '-294026438922793701124734905079413788211.878160013300244423789767770679', 1);
    T('-0.0000000014982823513781007328958069947012871143374337994272660148270374805416396160092178212524736096877823992919501659712353985693297357433585031', '-9868101235517540617583414816531196163394846626.691831830894', 1);
    T('6182476112765412972256430874006641281681083766558867329491.954829670374057358958585899534', '880396637045385811179717244187902683321740830158884405014171018661178832737243379.99039995084170785275378504376555296739303042003359925', -1);
    T('-160751704157218639705860194646066334461390616893.68299259975682214519324547685814966600492784129638821897523841634', '105578911150318367.008309279644258340186264525150749881652252235290292605', -1);
    T('-143158723385187700800431662230078385359.73820852144937977467', '0.0000000000000000000124340639699407338232687471046541468558241476495226668073022571684081347728341350550106103160149578245741', -1);
    T('28458452063254242139803200671296001714734755842622926787079731950.0992735055675190876673437043110150852937949483', '-35838408218375548738650416610', 1);
    T('1405901407.569822238040634590968038695131224115356886126732238', '-157848156800682193772.423092237390517494814302283186221330', 1);
    T('1343.2952', '0.000000000000000127921933329444723698800231745313808252600125', 1);
    T('28853632715587493558858323118072822236165839078014960997892188442420732661028174535.246119951253066921883027355182179886399617487552776484774687', '58109.968599810577067693043679467231728516554760366582163143608751563852471056960486315505049057948977813649161', 1);
    T('3.0', '-5100498997359905798.17245204', 1);
    T('-0.004911663588685959180762975105547432899694263', '-195.4862', 1);
    T('0.0016800213659346405237529123816285', '8.54847928757376802233', -1);
    T('-279764958968647619773787889.6654810407333727462942344', '-32911490485080881220995744901356698586892447851187378752704802609678707535904977.2349682793537012076792399816515725811842024374', 1);
    T('-5785273759.646965191309783081376893326464784097386953277756864344482261946184327330852', '-7829585551142601892881228597972545207045593119', 1);
    T('1749468477458267264460735919943750511749548119353526653455735024376363076831020428466683780580.382746467817800979', '117808811280451.15173068945839587501615962470947002537366415063962231776', 1);
    T('0.000000000020999785770461916630781325078925976998406955207235955893836098174359617198083615378801786560', '0.000000016082556089324398313999563719442315635940079534503288230557353323864912025891052353', -1);
    T('480604730995226700516.8211623950807854777785418843', '5121637414014031413488780740025020869010447826688359.63388', -1);
    T('0.0000000000000000000414327897716676413497790718766565633611669986458582853310823990011501385441729741967983', '317915031341372776103058145461905010362702388394603209158188747796318349497254.0341816356079223623851060840433597178761519084935102204279867720861768', -1);
    T('-0.000000000000000412840046822276949148', '-8495.635054982676808368418113257375475710111078926720024154221406272685887058370083', 1);
    T('-2197955143857705392850268630353264994616393635646.698149405979940304022731', '-709379519152508448101054642505472310149794092278935824702792668825161997157315768209798490103622850132151927880856147597945372566812892535', 1);
    T('-0.00000000261844554473808606144849883800858347445837640490072295304861523742613457798612213017468212453275', '-4257455569092781990677425261987768564734341578600573323744310843721093.038484343063938561039832375679139', 1);
    T('0.001067310532886835735948587831914288689553303108', '0.000000000031462310921375409599725025289890661282700997505119039922194159851961328187903443704235399598322794989000459030891087074757277073644206020955', 1);
    T('-4063265657389255020751373462844579518406276172065432701779826406527190899149755.03517774122841922794975102464204365891', '-177420797464172487220237833839895154679.55011483488839278508767009813747588375752975369464460567647899844', -1);
    T('-0.000000000000000001869682149225241953308274214537693115192334192086388308300459785925708765364103340884259103064347330742062108169', '-26575432925732543046433777343805635906835756.77068203591990998282191321647366170089253841793502621205827556969126543988080649772889793884', 1);
    T('0.000000000033068235057345162857793510724468755088654739039376687590493852515005413160754215391838260423538076895754633488993574', '0.017513325024275361448809543357388556724448571616284966015444430', -1);
    T('-2026236793445834948507161660525890822744664756812527.8835718009664526661197600010011007494858846013632636703661400114', '-0.000000000000000002859595745866245904331020489118494794587721260255748716684271140711216699026430746445835646820788772706657822185638176542620892759210718', -1);
    T('277022415667279674349.93159166888354112279521767856918625662786507898346558797736030', '-735938929386893441493788058350316673108625777978459161969923997224585208026818400417362773709666810793480', 1);
    T('74232319.567499431', '-56621962153013901078899971001172502878975414000348449901.28271290391851422', 1);
    T('-3941963925114761115410393553297553624.53962931133021347646967837208017011194854908672954262275111689570', '0.0000000000000008697032', -1);
    T('884371959410985393786970216012521351503422236180303629436107407710398002848795.2898794903243646', '279245072377995673569.57825740047951807305399484447809098617257475260300', 1);
    T('100631006795618153033034251352672.397743863352629831700458457767', '44099488689948413571101738537602860137703950300410932440087945678445341219014875737401922780.17252689064335904983389027581416', -1);
    T('-1', '26868582.3096831844134023012215433466422117521756773917584228132667216484693295101611945772014129671', -1);
    T('-502223330837595.44379400944709999644635357228899069929988', '-244003493276454121687882461126734836.07592128039798251908581902930717022441921782407196457234418354328582', 1);
    T('33870893120776524224787.26155584027957777911183884255850768', '7332984218265663155549396746597908086330161269696624389865650149280363963921535236843118406711207250294131459763.292451119914782794', -1);
    T('-0.0002696984347940490398828397266594740044041722095889055402876873310427883943924936554247676452751022', '-0.0000000000198505049352941803865970937898774479162157842482374962457965176036173890229130068136812989525256546479161037', -1);
    T('11790148948260649482767435943377652438601227088883805365070340866280933972152574199547632878971', '233346516936414547946433708151846303258806202438283735709824656199864024559', 1);
    T('38681768069179772995891498403722822330048951280500540942361519429848268851021582215739737468318', '2282982623239', 1);
    T('-8718.002', '-2162383841139137785874392020678.222654167998464572757082745022919124895302054425608160992223227660036361141753054047144372425', 1);
    T('-488786545287184792041400596.429764766800072062963773425995630557595146308866924025002119736839163', '150349397895989857.625350343999955836341802520548691205621597531311186198090511440272682715306143508070716574615641968162130759726933914', -1);
    T('-931924244656227219809405990301731461381455026788834465108077474984655183700894292742532304542719883873737017900061725370877671670134030687081330954', '-22590847661040395922870788012795560463738.6042785284312011175278095893489415781880229608749971180', -1);
    T('150034078673021523537829708913856916052846430.677559', '2166077460871.389181941661', 1);
    T('-15221173714267229029000823.870941799216310763467302217336309', '-1673674035036687535894', -1);
    T('28462245616076323814547543516628503117353984931675274738003002529627.050280772564006057379343', '1684755069944063046468856794520.544285696374626', 1);
    T('0.000000000000000002149636302695318031277254419779385264', '294828031937806482188347305646408178392144292715768037206520083084', -1);
    T('-496433201256500626575612612181413775390243576650772463544387954585218643129869625320303924670', '-442160689638185654.4551347636803891464498055343558799035256967658204045507964302065922246141137529665782679', -1);
    T('-129579775113494026315929537570278930664181731133208782701.45426943069540180187934763841772148976875003178126761049589822456645625031071378426', '-50960835972632028101013868729008914820797471866095853076604833015003479026669241141140168832519272084406271817729840163461909', 1);
    T('-16747439551932269968419783516292565073527286.5978912153712873353897', '-188574355884266969.5316894208093252428', -1);
    T('-0.000000010491592994513761160780', '-1050932951471917437885324587810501317003548260421160.74485123595296963899543431', 1);
    T('1010839134920617276236285760745178410456.2249870989035696035968471032980500261', '-120594328581364716298488828.9424349293373529319017263005601621047414886', 1);
    T('-6745237811374494493983732995517490423110771468604331647114513524140869041111924.07143145225484722086621945039491878138053819409423194', '-78096848334747442570326820068097176668363000702119878505808158486202624573888559517499059469543996762065.34515372475365048555320336061286656', 1);
    T('31641216104195523119323298187454596691469623', '-0.000000000000000000258260225806808436156489946400669652403071801164964794360836676150308291521494089553214811075584197298817277602', 1);
    T('0.000136955496160497638501494207878559539838907773928113609973212720681874384188247121736519967860967190729707', '1131456362979085.096849571030916258593458603291865925658158837160864', -1);
    T('0.032374350209810222548593899', '983665612534486391903069992076771767376905372098300464420498293252673383701.36', -1);
    T('0.00000000000000697749637212917655601734843952168313079723929644561400713832738344957256670570318423980784737919478703314324358395035811505647250409924651706', '-502882856311579316783157003.0536395389', 1);
    T('-651635600158790804410143491638919845677600042415920405606770304907492557295578675862061924691925913075254252734942878', '-60351457742518762435343004631135543741539510674840042991014451995652190.6417249701705696670', -1);
    T('345509817388294075020401571707985302468577790452097230.67244674898512863573831730550161447995018107519203024', '0.0000000000000001056679949312910174815404770839634025694', 1);
    T('-0.0000005133332646768106615086635756288330738260842203558000626286730150325018694693726708199958605568678693224332247500950661171742', '422219598091.2132010626485059381682644362524778822675322', -1);
    T('6209045587577773276464516075468480344927865681108539547852034571272194268785056443405885354613045847441750653814344012192541949', '15400142567569326379407593600878161357.3158267836117765', 1);
    T('-0.0000000000005128844809243836111542045', '49208450703085595317554090353487521994302.58448330950634435909161638725929613848207952792171018392294484488157376401528860', -1);
    T('956820321617083079596327657581942071127140318928050899898356414048159721950191.8612258', '17278138380102047215838955529410627.32350998142532', 1);
    T('8582364', '774.20922956184858799', 1);
    T('23221742968467826352973222392797444267945245449112426217441284967014691005809044233558034646290606716623338692881049684653084513', '-716575979020985.279557138936348127028057421241051031841307264455042608637743866536141586489408312326413837112549345', 1);
    T('-64239880442', '-0.0005757706836762797690172810781616112054771449962376286638181876626306753967493356164897064584864421775', -1);
    T('99890913975286305568325542267993806860755562436873534002883032609372302026293419920260643846174424961790', '398563986970697552164623501292881320978723925743958528075037214399734729923685025233165645512491551109', 1);
    T('13099934563976711709606830808259471671138463230508665866920870667879022883291570961467719262054', '-109826842662920.8298299283611', 1);
    T('47185659575228280475715212180191382741276156908324186745372219490089540417870210622287493079401094749070195008965690189496257.6344290361', '-191311112886267605129186105214676155987804385676502850167374976.81421158641221691', 1);
    T('-97492338884677999782.8', '46090.6038891563729837049651434308627371886782595339529134134103138942512716921751', -1);
    T('7375598828163292955262802188069890697127023128.355980866541558240712761760425090656158086966127126201418096188025050710292147394218656199519', '-33736162847546417083662199915.96497427321380545945697607572725317230293032258054213443', 1);
    T('-218160598947993698294987185974447249912.89115498', '0.0000050015875427779244596032970734068655494267635032', -1);
    T('-0.0000000000000000020', '0.00000000000000000001471670935923077384861565636336852413366332241046663589863103491999420020658770322413837060604', -1);
    T('33129180170998410129893543070459417633301197982910425.64606409078111879170213981476306214296822988445339041520791973076369873', '948494610332137187926756645888688419826755038831255074436327001443802251577207818445858623129.161046', -1);
    T('-225952021109392177218450439017431752400942775732240194661463892287355070596511103556052608754481002242937280547960.167872771176417481374193116703938', '0.0000000062277239670560908419969666371220135218008079705746207056768105428331985213283124653402345973621907360434147807551859292787803296246381222933824613', -1);
    T('-183573578911405697023556086514609883893306795215626297396579687619875304342323017839805206126604229488822003279.59233204484561014983371', '2633566858032007647133550571239916327299194373140075907964398383480304297038434790716388124909149725536956762553458755051740197984938091354917', -1);
    T('0.0000004460397545970448393886895088191903634042039815', '-0.0000000000000000095347818761825827527731028387911543955632717901933911587359863970181690577102483822386465350730573340050175224061', 1);
    T('76836306086273960905931260788344443215614886.50168135779713336', '337185798150132901588999178764118776.92309780859993696138620', 1);
    T('-0.0000000000000006793099207949304687582058497331137904457143594', '289472321951375436507478434341358.5306354511464450479041413522186381', -1);
    T('511444049261329873.821317987544416845423877441515588846906090911', '9490010.05', 1);
    T('591713007334383637715463717.1291808137387981846811658128330485888980625856216328030564698865533394807126005192249912613', '4823684942063255528803421209.107961034983048341611839235146', -1);
    T('296954671497441320436.6897774425834586892939399251192320626790853969384028690679126272812703387657033030897290641153152475784706776362266597698', '13766678990.5234817', 1);
    T('-133060567480374920488783510341269926348673610429669534346754755488082205036746.875386348007223776953779852911928', '5927', -1);
    T('73932844006251372722325798853706639310834528653981099571578123750133433908285265618.76202624654621129232002', '-0.00000000000000186827495500328964616880687615273132151323886740951058615687142482475027687476', 1);
    T('-146141982259082027635792785584353187175763401213207391', '102024036100851932865259629376529498649159346459236183997.282137015883624412337321294996984015309550913896592804940099660111659498774210', -1);
    T('0.0000002414815', '-0.000029758446843941651956375917491305831593454765385140091979237320013919577077698799164529328687158159830988324', 1);
    T('-210151030793502383014434760169391310.18854098497872', '-43132900782065', -1);
    T('0.000000001881697195168801041002308195919736876762525914212692483270', '37220503866578932861716463156502243937410265932050985593845402005265927199299255.98344413682304736845548607869635917563352646023138638403944588', -1);
    T('31521072328186955772400060885593.59297383310829219344810143967971187389', '8299359200986653935603999653552082057380926282505088802016107969552627375549163347904875168992450289735997709999832779519890573966176799923577873', -1);
    T('-12805934102.27948320410636171184694060430874642071534941054923893481501134168009876861420438715119150275015992454925505523986465864594', '180018001880206592982896205731793655606255072617295111549612026292885879170444460136951078426.390401726986399145583973049833043477421044648', -1);
    T('0.0000000002936016400407713831598517736778340369883558829401128461721111534068980221676584362479994606', '-238280848623349322403710808897808837396452119.946711492325936626002256793789239512952', 1);
    T('-46459704414418529966558677894175211345197518419628.95858240822563998829696554747145974856949749820184367731693913940235039725731', '0.00000000047722733462292648206074425', -1);
    T('-541280.2703925225439019884062953901365125819982181630864435007257550343992637766901456996336131019366630269083091648294919635719143947548766', '-228034281', 1);
    T('-11760472974851709104383782.662777303052700', '-8856003943296025750571072176230995254098814451714178705187395377177217251293203.902574261722648560357498315885671879950820620988638695483994173', 1);
    T('0', '-23189877550335243259085364.53351434706336084256915879121464887999578773388400557820325828544547283691169421254622757350946740952577282739', 1);
    T('10223905995799236594685978417380096525435726347166557843.918727523', '-0.00000020607225637494236034677211524295904660928630761211510648083699692056857979868128566729857282938350504504013801371138876743028895', 1);
    T('-144846563553578036105235976816', '0.0000011270723657297532847257698465013496541743158648293535010828229786356244296523407610311043996299040', -1);
    T('113032464106654125041288367328368585073827742426563069634695010033138913322259705750701638755775233614410737200187834799536563007432367297372', '-144536245354049112745081024.13189635154492291842667978940', 1);
    T('7986309849142964591151981507150767', '3715212599762263522511060701411.354291876313760173927039871847384807384499566193464909380', 1);
    T('-0.262033701867790308', '1000', -1);
    T('0', '-1298585670825508993270154522126013719917570633453070690396116462598092540996979333.640039196743651565307879856426743091916875212069013890994736009036', 1);
    T('-58083440833403163271255364703914434694411113794265074103509.6210028470686978950076079624502733808613037706942237117077742320080970570', '26461831023083173643510121917518549069675457904421183614.08670353705231338613403357536480', -1);
    T('-87806.0709005423990183741480799', '187889864.61083754173871187582049463612826040389116069100443073768518896580280063099139409857625583395994', -1);
    T('4275109636212975292229007218589106.56555396510879605313848016743912486618038576223178889446864', '3214123466827664829603412.20512221377304305308306990229', 1);
    T('-288739473055433343953882.44471863361121224088386588796752', '459693332791964431347.9722370509420311935824189749201056454335904860013482391961613262946036613056710507279548844104287', -1);
    T('-0.01654798720757644256839268748011987903667764384686077', '100.2947610454173899008060779309430287884089908', -1);
    T('-0.000000077812076712634332162149408492721454465', '0.15399229905779332095662380969505220763061741414245660138302708596471155210747491437383447979118915119014137110102148592', -1);
    T('-0.00061444759912181780360634369163380074336309374788470888402669388105603516553991054356526066819440108624500372932833891457915', '-2586282129839.81183', 1);
    T('1498895191248177551510700.45606050', '74541212431266542382401488034545718935193952273089972827104963785323484723329', -1);
    T('-0.000000000150375415489340749507967', '-74471913380513166596942427426446874506626967565471102018090995766517502.392226389302441356759681527055387117306583255386245975', 1);
    T('4379864196478185231971341731472.903266369426998276391', '42212498773976611477583491576270132689125437393337911684067430376578.9984194168847407989', -1);
    T('0.000000000188630716195256390543790417086046414407832502506161382231731603289140796649753995735957193705662041873992884429720334656191370246778667100', '4277485611862341', -1);
    T('-46750737.49359475454665387075362911038', '-0.00000000000002083952762905039971040265943804257794973540394987926928714383260058014', -1);
    T('0.002544681009249525059932074042166748733358476604959321449600882225721113427484661673735862906019211485741647391857669673771533945502723', '-5', 1);
    T('-39295905377158687425.03568106089356864942579967692030891846534', '3835978607575268175581954653485493945307702695323573026257952124899312857138636697340444576247772132369597023211', -1);
    T('151889800427285114033292898375825876633959450.898086899995', '9713506827047238971234405766285157635347795138873922.72495033960', -1);
    T('355429208933168784293936130635740185914092143011019726030386568363136704968340935328170476421910883336592097125452.6140400243618816', '760.68473869704185430726326613766', 1);
    T('4349545620740369674416209302329779414513372709527226', '-512153241030873003118738632455693535388671982041905647243253860149370383998111505079497094180417460533664786733236996564989680995504.330957321847087', 1);
    T('-0.0012688202113', '0.0048010468030358831203945427786584092648853082093217561611591674776303185468226054026588077464821415670427004307009969250474179998', -1);
    T('0.00000000000000000002201374424729105772', '-0.000000000000000107033257309977239769384301947', 1);
    T('-668028580968216191486131.21', '-154531512790783399365338471682080.44013066134495453500823018524005204200450971051972740809812246188229676956238', 1);
    T('192599466.2', '-20366857500742765296701334.6', 1);
    T('58248290.75313561203877075178536778204022054792568075594303791595851558245836135032032800460252186270586976386928888004344135939', '-99168518734510294278378406838157005789369254297707094', 1);
    T('59335044381412481489178159118129258391790720120452482882085288454894585878242302678696', '-85648601004388619627800968402621796697943181866275450369784227.575017140', 1);
    T('827495050694857970699868331857360105273936056958', '-1304049.1408', 1);
    T('29433574477411346954729176312712201982215509.28557096414206818026607603358233255484946894686133047229727976564507069176749268741739111176858008', '-4633956465133.314261800679223973287025496806457718', 1);
    T('12686266978287967082649588107077967578421597532.105327951152521392921904301941867789915864450059477632284', '0.00000000000000000001680216625099082611964698924207784733377923277771980687646000893625476714140746', 1);
    T('-3567385737540210557638345348915.22162', '-0.41824899246496739428149857672095872056590112993464366988860723481961972054071505307907398495301014281825421217207829254327015496033753800645844684', -1);
    T('-20371368.63017582940071081998', '-6610141547540851.2618872155', 1);
    T('-2180877.248385369504597407913625892', '-0.0000613947546197329952823061843887350018748897219554852015448742989981', -1);
    T('-25661548932398513068206775462417323701105944198759768081271555328689916551910650501573584882621966781961436302774002', '-0.00000003995848665017188509548766348670502483977228426250447700812058736871198968592250144174490260078313382961664', -1);
    T('700915978647576932038.9889078885976161070216182950', '0.00000000000021269845796478757183434520508745974681450900418628307878284', 1);
    T('-1303382398497.931396748821703576829828779945840056689872555876833881376022696155060976', '-0.00000000606644551523073444005306613754631773003870840662806994136979597086670031977138946305205049690099933090', -1);
    T('405906568852917813232248628119090577947475734689.8857756127121', '-0.0000000000000000017866056928126257148339056150658060966796161201920608159514292519569333482177040033662644', 1);
    T('-0.00038993118656334050327105429584540674169988490158156132652011044524474264534283653197157270482671918112238649334367', '76860558547603845673402706122114999956168146955310350.1139970001390673843778536118055735735229745139379062', -1);
    T('-1291.525514189182260086081242332267177585013147', '7647914106851593261.11793036077055947', -1);
    T('-12612.41363549722', '400197529.089873841323983042909768373129595576', -1);
    T('-865231120.42305', '-6101.373', -1);
    T('2135123.616487587', '29874778328.687203196134017891857809472541023600394892', -1);
    T('-240496804491219672098', '-0.0000000000000025537337241596083729560310417637018287262621849603524145688120537226170023073025335809179309534705621002788486050424760426340206294822698773287401900', -1);
    T('0.0000000000000017704907457081494438152952475686979995935351712219723883521', '219880763814382422594281439908041083191286156495561036270640605626481755929973044677878194029641135689892298021934326005001841305991645975944158141', -1);
    T('5562146843300977194583992103.3541447154572529507300968518031922002848845481', '-5385385490941349985.1728987920292488505551505952939981174051495333139609581998031404277776446303204611433649401136931468794308049', 1);
    T('1752290198851473333381.229247979245303911113358', '0.0534488804706934281687362', 1);
    T('-92147522191432001037455421266530384324844131821397435747892093212737588941410897009039880039.78536641975123525885676036525963399053493', '-94653495796270236528544459336546136861980560329213238551234844', -1);
    T('815487408558261730721844283383258480879914323551992615511114634084667366.601583324800070891427050782659806100748059136244157137697115166387443377852094', '-0.00022352674800133403772480060128350715370257398919546352741164890695654568500835062253326191042712002', 1);
    T('5749689998455617772483267', '1840103850357796786136102.71620', 1);
    T('672157900280788714930056355200674066483401.81631034866806625951256911099862832274306021451656220978012049245', '-114154619396981089.1320525887956211286048722734182840690494935795064338674221730292522680013566926250582468937966455149652051562981', 1);
    T('-5494699992405395277727109066553255922407802868013721980441109672.2745818896946274305742059294626478254', '-0.00000000000014929679588889355091556', -1);
    T('-385449726074149547840530583797934937181715165939491867569145644860713885605.5264721791956556383239054663012165553', '116230758861245831282.35469658891878592281877915896', -1);
    T('-0.0000000010121528251165650737286665285385390272407652360958821083299180952068082201020218158477438177846198635084848930173', '0.014883196009565080385727336397121811890988734916589439190153212627665118520225526554901248590753739002351947839892439723714675499975034', -1);
    T('576494346991115932783888314153281740149238819119894206393647915824014580263476342693398091833799159.523480555625532', '-61995543200977083040575763967439592100731063156984228486.38535435929903297792354585158311732314673482333', 1);
    T('428873250.560664', '129875284926470970222879379103280436892522797190190796664400470658620567525600201123074551979893854516815261154373333287236970841329590591717797034121', -1);
    T('0.0000000000000026870297704737006603169618821643992478682185038681614', '7820302396851385.87642732170367565885193676356664350349738707893636875852', -1);
    T('-44.520760710306309879865713891315672271920022787764083922278701523625034485320733717004859', '0.01439428796926164016128066457640262141108921179147399710995842215316044506980299877008384374011689600039480155501049825404811115221757434056043236', -1);
    T('-0.00001201118968847844', '-70923798469593760582530476230041738134921398772057910273281889901965679.42358', 1);
    T('5843135287113736528157843820316744502939564526886546.0047195639475992647092375381054267129062468983623992352021878814209422214992623', '0.00000060757624666484634102563211416190889408777041958621929849193644313556211406046557886739314619795644390894145644323254283691165', 1);
    T('33939864110426158794412428792.47956843115029434531711836467014982826884747667863328480197253623707011712168926394003290273416608578508', '1064677018243359674559461311315576643719466298112018077397283377331298.0670918844184768217715685', -1);
    T('-18912', '-0.000000000000000096633006285663483174785933757971320277192376117523241919936331742434935280501727980661135723065936406743562787980', -1);
    T('-2804344532565505375601200736426512335574579247149602614364873466432310221288307433080611694637316033618692401292292895996797408039558038455193698965', '-893720293743137.926655354747113007920084052973512410160846993', -1);
    T('6764.231463798271135956814698363174738947427445137382091391208755942353390328768698827660861776845954371737556198135', '-0.000017597904259456024333678008', 1);
    T('1.76481649511603874803028298380964499606482173', '118286517946791234440962575129866748867383839052261404590790296018753.3551', -1);
    T('-0.151932239357399305076147843155550323032938508228686222300958284775879980694971306303640', '829380294.1737767149859532540', -1);
    T('0.0000000000001950221826994411075608100769821184304540479623634687640815964857394877326312992673017060046339509291259090179143500537', '-0.544207807833617254080709456086651220078670208155499221226255166753832289251475987493675', 1);
    T('725592788412654390.288037792170665708343668934945817652577358075211667306339285606349503938607834479670176', '0.00000000015727681596554688195', 1);
    T('-0.0000000000000000025828037795917808174174022628073029870391944907806479693726568881606935015683570702939052853748656921760835', '21479058581519114842906568693885000707.948701', -1);
    T('-52318803831972225224657668090895711041816508172.8', '-925177002627943141448550433420188042136738.349349239422830476016023577725025812189', -1);
    T('-11595020947248091113626696070928546894526698503484940942.1', '-41743727850266539324572111803709486.560814158883502040355649548872806865758563538962184415', -1);
    T('-7945674732961469879932607763620399739445214326825952225210024765118220584355530.0066649877944415388056', '119923.63269933110039577637236168360031988884136', -1);
    T('-667465135.521', '3600732041889309108089077145627379409284885679028550049780473370754192258840745952520332031.3349195', -1);
    T('-0.00155960825045823734495157128817221951179945771390542271382698231', '-0.00000000000000000001547806123481913844128531558529', -1);
    T('0.000003897178488116939077117755504046954668782', '16500182036173066151975330357363436305432978597893641854622839540840890764939718449396748745670289759248', -1);
    T('0.1066389596341454370563866669022345823619309097241060909463123947382090196267402259296965465474236522387304285231', '0.10554272066931320067690515900139997226174735430579374207101626812245423053687680829616012414687316642', 1);
    T('6311170580654312262766895923050966572616839302483216469449041222764.049350942968378224002193794621061821564299153542544', '-0.00000000000000077721943836572688797512479214783933404468328060', 1);
    T('-6473241763588535091671209.6136', '7109946613265111655504066906893421227308129623587629974790367852537008848978739884385313982886613060794958166034914293662450242266370.8', -1);
    T('-0.00000000000000000008039492192574383888482371', '6604383032.684474135999128100', -1);
    T('0.00000000481203569548875502622555282569420051010869127282373043112622263', '0.000079591821964258103100046810525409740211300100386397203145583898461821616', -1);
    T('85823943902986661.3551017490436085790271996332709765818729748512879602777843718155761693739465208300732899', '-353619674248164726117917.76326235745255122675778', 1);
    T('5705133585416934331.96', '-692026459205441284419325590512301015920380275971289655588744582196610452918836386452075288', 1);
    T('765287548279977385673120140382320109443772413316008156351512085669539136561234228', '3378412883764.772985170', 1);
    T('0.0000004444949779299910287084862350709993', '-34895239912483248998398456782819190020892134145899514996827417890581872655651586615097978930.28086971201242063913206088020792', 1);
    T('-1808406236.0007411517153424954283974901033587835316874236876462017822855632147931437015468125518156654752077876232166', '2013566681929922981330.04601046976892202943272046385', -1);
    T('-4048492393774402282450581898756603285777654317041291261832380799275797348666467089872455453070620263470013031356830428683981574', '40099412654259527050657495952587386178575394648007643060458676.1111791491498057728067622099748', -1);
    T('18628915136749176154223386824673062457919.8848077693485186034', '1513881720435328747255261588664662813128641748401.955878978503857272440117644', -1);
    T('-1102715066055607391570121246263589329875629472981.9918971388267193266893066174800566737394182297234831718246217036454304180215728533097249', '-507466746731417668276962401930968304387149385.36733202', -1);
    T('-0.00000000000000118867735895355706324644741565687516380934012845606449840941596028463353814792777039303066705142312804268503326549993460075345403972111834209', '0.000000003436556517', -1);
    T('-0.0000000000000003371984563895388548767205601272951518208249335621347968700193296778014696768556195', '-10274945223018984756966657952438916138616218197724933584616138553807445939342840685241904451258371', 1);
    T('-117433402658185448482194314232639429126502459349575210459884357.7406396969270334883393802839875697129920877876569071877681298097932152998', '139976394189242376947006070215378416965', -1);
    T('-0.00000000000410999246686291289919439285398573971906473918801526723286816999153997225640711464165501375618395618072', '16857754744323811301.760491652997818191680489759', -1);
    T('33433452292.54424975454908357494747405074701508', '8269909530911601430300956762711.49', -1);
    T('-283803212239.5587338007666372129716405064', '62180632632.44', -1);
    T('10816304647050009681046881227640567650727092915763836975846424094420491356952792053535937227598578243148.70549318016888506158632243072', '23601245638793.9051238958897803858851422315671924508733072717037856936727939646826421249728398919007381394104232', 1);
    T('42294808022511884510489816637065479125.12', '-363076851403252016896121227284974203057689376244997308943536424206680183580753707981871249845116125872661250598932697938367496845913845', 1);
    T('-68057065545315263763372804.6037879238251', '1849186991871166819', -1);
    T('-0.000035422370812676577438081958090968761523064683396142544733667226170582703', '-4886104.52695396941765119019781209957215550071392339312212', 1);
    T('-0.00000000101152922410408185', '-154628891267599656838.7544', 1);
    T('65053724814685425792643437308.22975034850682336796195307601162523736', '-53422542502015829097671319941538573640235158728608612260590736.22285239457330945763643215406922589852086651975032077423269936', 1);
    T('-679014.049691213095078512348789233953999083752383', '225334567529.305999982841966497994072752683700827916742714614297486', -1);
    T('161888828328851641417083878458443592052215516899370606619738.36510326324072641758387263980815868443516315712557912616842124441627523', '0.000000000000794258834390076366776294050001062371476872317912962468519864454127907974470307426421865511092144225939633222374776858411435618947559', 1);
    T('6162233670505318', '2.46634168', 1);
    T('-17546683536111282316342996627368376599858018325962648.6584700382630574850314398607683745', '-80802643256926373101335717601', -1);
    T('-2352353228663372948015045466172105999.8803110610547393595549', '-0.00413964594253429181906299898033064114461684408903594038085686221908651158875526470347', -1);
    T('-0.00000000000000000004356348734944267973648639107', '-229367364784425681697726599493823156989608369042481979275254.0884841218159995757788959686561159388268846646565860174004081151385', 1);
    T('0.03415457575710915160220105512218140806602929852687968668616994967273160715684956613423796070943115985374314105903537233', '-3196749067837621585326283843306992801307.802760498691831198070', 1);
    T('0.00000000000000247413037298398028929363025202778579193861821082044594455801367855787265239661476744458519065142081672257010', '44289.8', -1);
    T('58.3127511093589129668', '-2611133014902015509360439.7129643377015936731377925522222539911964440440574400407593', 1);
    T('2406843722253168117192934590291028781069300073383984975.8180911819738336792993187445407442782766628930100725', '89425216383828', 1);
    T('-1099207.26554285655755079330147354518979139456850179395304634417125044240102198026939759672286', '-57693881703804010298386947171610472014880394287849824344777180903601511889954253540830976322899406814539377606313895495643102769.83016248376', 1);
    T('-103994242142241963043476374672302180239375906114700919981156677510520442173528213340300295792463789876630187002413998412270858178265773895879435145193', '-0.000000000000031367951905170647781165822641814409694938292', -1);
    T('13601721526443719522926093787.934046503185812863872716', '336408896287174621976247324108743253861832261859751110841.29596909381766540334693808958727478573401402102365', -1);
    T('-0.00000000000000001469446157409381008342426261966534408211838683793750555946023', '1522608331828812962719302028703469509396748384370489182706462020400287150465785830318500446746747.6460778058447560089208164112108681301784', -1);
    T('-0.000000000000000000292119887858775237140722034722696650983806428229978415180240', '509639.198703', -1);
    T('-581568431970891620674020761220785883553826553712684204299194.373663495926444491785700217246', '-0.00000799487760788026644276369061232209772149143590654545891959237728077188021480038402000022139388923280596639559887', -1);
    T('10576907282617366683945326959370318422762465935099101961150731963334451359367980479.1711956', '93657934108538335658469446550891.33274514', 1);
    T('-50779400127432260917442015730665305.693827342498804536', '-278.45484183476521400133060414619839700534856688357221666606163711034752645600781353452713349748727451466275731553', -1);
    T('3582739', '1784.034', 1);
    T('0.000007142491492373590519731802287885445743376047761637981513279821695831401679304444193667604938367015426898382592976966546278775', '-857115157826.2112333616148328187721853506794021', 1);
    T('-77650157.77865724663131558543954559605879484270600244615464493178445559943273821677209941465159610044188242984064', '2', -1);
    T('13061793010825779761489046240048151130041423831782034351150825980261340689146749636490271350788971', '736646718813268852209165758615425625665840070879918346', 1);
    T('-0.00000000000000000027818072125795253670533401340761483641172537202336362918391508577676998124879659850611085', '-757589742121920450871623430335991255479320533949980775000891583727233254637570819240641737.1122814951925898', 1);
    T('-44805268190729632531865.6419780191402046529767672', '521251239499704005781275449094278641042506.3156115052302463420952777340591939364886084763948408205859384130509381650790892060575', -1);
    T('-9.16848439809259319052148', '31804088022084780543225640840236725226743771098722292010442082451771.032053418236761910351105445438902994094212892937018928', -1);
    T('-0.000000000000000000015946937934151918888138620979468427775546067982434246390130160312768937674401605951766202953', '-4384.37908930790756', 1);
    T('-92.0', '-259.1103140486780473992', 1);
    T('1829937784973143537783010100739888095502819577009050487909478.998339486027387102532064478083066161408101089244606741999372262029117753', '-0.003466165765516931483921623859725455065870694872586558033998887390346792964596358533056448297144859327570003882840488520157483345744424112', 1);
    T('-0.00805730350870332416474130775431753596509549127714076482362747443329333536910223003521268991503827851593840825424710029978467616431589134837782', '42859237293.971714652490950575144555590003616042479874429975572476902289269556706761', -1);
    T('14687687102617235468391945141416714260880851700178866765733538453531920743076697994482038.87810993130926761650695883946148734827', '0.0000000000043032139506511692634953935', 1);
    T('74855288934335940624584700729.917818635680622422883644107796356783278951273', '-0.0000000024412467395238501084489165324313850210206104', 1);
    T('31534804.882', '-107747802197986688050315269264964249408206715357274490951874', 1);
    T('0.00000000000005436941845644294932431141904956702081385801461562015917', '0.00000000000004007409174643597984346027883186426344264183588051770037027544931312637485537674353258405773358832901037004', 1);
    T('-0.00011401428096591141304086733093089782287404551974129345249206250034253148833654960406327854197854792917730041450409869184707008198528552235035954269', '-0.00000000000459090078596662894002343875075543959122946654955353856571293852319559157327916251', -1);
    T('0.00273909582639870092043322082487911991953970891824257601379839286759468486558682979434046468763206507018460313471628142789574554733', '-12174288565178653649738825844.058129335942051261437792772494997783050076234522869196457', 1);
    T('-9262163133525541289611786411236936499015108574335221070224302067951107010106083554045354391502928018000897936875310.50063711574683', '-3415896484698655068520389216070918253', -1);
    T('0.000000000000775402434179186062776610592070356150419892', '-10567486649730728013576719047602414874836411929687810999158959874142512326985312695510176030747379728213278021', 1);
    T('-0.000000000000000029154845261288138429108167871851762042605685339365274521502654014100103052239316462201294992571376102', '0.00000000007215519703698252394014310761077946308103265208763107160443064766528615271128170860242303974651987945813780869799910158572025', -1);
    T('-0.000000000000000000038919174519392355544992733520', '-88873239905390283257526586315278488079494343890098540.14371840801969124535809059283682022956915824484887795', 1);
    T('-2956006733486.050322519495910617171990967860491609473626923225257235851006044563856964764255650517769695833', '-63580.7607041571683406051338311837270934135009599731889857981100051635443210692920253491149463594177586818089', -1);
    T('32693297930914576641605085.456147160027786641825068409422582642333463646578713263684862420', '2046994.563394388211', 1);
    T('11585457218048617716818642470310899619712965.757545839437764987354930195688915926362652526394444871037', '-24619892752559156706974656.033638967580349721627125116986752963277069337398575115657062385861834385940136798596681542333424665238168009963257109112', 1);
    T('-376741557864930127185019858384127899674528918618.823922265376740844074653162948916457933603707043182097866', '-27589133853961983218044564074996941310096508288788452470863.709706352', 1);
    T('-0.00000000000000159347', '0.000000000537720125529707861865661334298939870145', -1);
    T('43035909785686641666336021702781351129892247747464104619212766477817619033880081924506', '2814152544538521977901831034701910821444771265677717331726406832990136388071257847595368675837635869488930703285050684920041246854650190323367418', -1);
    T('-11985135.8193427509854988143005112183287545730', '0.0000000000001803274435994955450298871518541291278942016627972113349919772137870618374138716105', -1);
    T('-0.00000000000000000231213881820372179648211424074545784084490603786969584496054481785651900550127851716747246826568016229452975976262745772409454', '0.00000000002542356646873251984661531567832365397400169898925001739523492396893368004710859653', -1);
    T('160250738049532782162433853489598402471976041469770348690123392.0031', '-294498471596460898486795650003243213547297862171486734029240994267080719706597441329.5505160068626877140129559069410890749408503304245', 1);
    T('-311499170316724006235994246932956222855452383.9355679763714275758718700623828461', '74109.22858001236432975439589074625834100371918658550933564518627770467991656925437210524238209898744184416226015049386723272030', -1);
    T('72262463926314177087592711082448174767989257408928002756189090888827037903900202019977026018923895141350914091904436927', '-0.000000000225167954917337837957771388', 1);
    T('783592959000310229426414265767534.3977599563867860198103276131050069803106200343268513507092805929256', '2213775192313849109306210671344446709142941975379549548840760877161562324284900199839612761050250.310478020973421299217241488', -1);
    T('-6547449797725.304570', '119824690766003830384751081.0046122063442368459687414526624230150574044341335791064835698117488656542711155304626640574856112236102910475124479214', -1);
    T('0.000000000000010204', '-149665073272.5623297479580213', 1);
    T('-0.000000000000000001372054475', '3261320307772433532065115421441455427066494965386813158814003180399968053382332347948302205942486750609906989182229631672314317782917588042', -1);
    T('16267269269026527605638552384753020375945217358682470573450643637648938800818442471696326897638.960256727665082740611435176610395516518637', '9397452437953662194.6', 1);
    T('0.0016003186542702358062119951504575476400770454525551608330060208480446269746952107326275127054026286275145379', '-10177150935819421368111549722330892202837757641685140152152703141782.0731751745579486199764500876128838', 1);
    T('-259.796667804953618306869', '5.152172124853561796', -1);
    T('11221563347439640500149258879687347315134035785708472989483023267.2300609027733075', '-26207420100355721202593.170521021779774357040235570161585294593', 1);
    T('-4086883920877948704292008316195463523825565880525701686248.2367', '19607520206368681093521348463825573467158671987138840203949280288889694329944104400821735075790097995474419621575623', -1);
    T('59250037050672269038935756873853022223815088087754056875033986973202160304564921006.3856374891863577365895067682971644381098324', '-1150048048247576308790181384139171657779505.0762328070146919', 1);
    T('-101.9883', '2427396663212685327845905010715508779301812460773274950351804533445926036597008', -1);
    T('-253869543570783673956384102166918285311284645640813929674091406323420328870905030279906889614764088874316164218.650577522882100114108252753', '1065.486621351936129492744089151898837668657292086320399673336494155243434093656438111857434011880854788399689183448380554', -1);
    T('417208985560.7855205554', '100923345912048408289435217840834510246434298689324763023522249789499602478530171790094650567004608931483845354824898446196430525102018126501735', -1);
    T('173069663315189207453082599256935631042012490932166775088288608134998421563.501634405769076052916216890728266291846276235969642472697992', '0.0047456362403909994510629032945180910020103403215993419', 1);
    T('2053482495939016050925647064247292586.8564263585178084561055184838104344', '-169017380666548364.127029030132409556736680020944511137856136807303318576835588339730940135466516396606957131997990393897794390319423272450917805926', 1);
    T('0.000000000000000000010910521060181975906059602362732892055045562230211476996524041744413599254422619291991952288398365621', '0.00000030305366252407729760726252843133109114557519273943871397042650558626022634485938707736986954106451995454302535124160648045134106263888189201243', -1);
    T('30640237540440782514115131028848069755044326052924.009093719671904737413172221325840495532222917009786084408779725171808758879846845062707492564014763', '-3587259353440149470021751420228565.933221993721894266387366123546111212496288309568577', 1);
    T('-3609844484927222015828.334942620349534873041743', '-0.0000000000156030127736053462961395524', -1);
    T('-0.000000000000001658158309268354898123357112970860020', '0.00000870156656843154695875521710025973209056456466507288725866658654130737892621348779455441496534083249326857675543779156635545016633454520', -1);
    T('7793690039.8772263749770060309947594436823579276762079330052673201071', '0.00000612582504229588881039048444365709157972604156531064474583010238471462911044732', 1);
    T('259361929252303788251189384988868.553981647414752277660626862473682638041582155222042965461036805740', '2581973829978432652835452792244347835027216577276451292110130046577998322535113805747137', -1);
    T('129390414845041424.1539', '-481050029407533910303222535233605013660232501391088458212583477453819542398563643833919611592686861686523', 1);
    T('-6536842573987360158150696168225611012842820808740490760317604719877598626292023302792453130948717075', '1808166007895107209370145108642559246571611053591602829484725216424576199434411727976513436930373936671801214293.1577146813', -1);
    T('-0.00000000000000001874341518823681577662776773255511371168611049285', '114237294927073342220706673330602767506662522210660715163883162244.823645258897119432630', -1);
    T('209836878319152205282576333546502150812644732572885749428543679539', '100955482773558958290888650903921036366095.20510847158797748', 1);
    T('0.034860367', '-2.9421730845742362', 1);
    T('2007681510503796232234969506243559879895607457288542877357020897246614400065889179294420464808957608804208.88977640850467103386663519609600376930', '131278041586300435030378871514179235174947880618231459980968177904236853202540068220693506990312468.7907728564640266180384190626761258847873972319', 1);
    T('-0.00003161209326226016404711305', '-1063414207851209583249490599634018820893.87666259230007659491410887957198569', 1);
    T('0.000000000009292700053546152515763409646834318801540357443458254443063793407983703255255220501557870090370022700786856368829747621804624', '15968290595293544207165427138659653635885728378308439140692.8375150', -1);
    T('23176176.07056103153928107006846727836935989686711695293078954554503341971026457151918796526632004382422212027532033604', '1393760072065023828023446698382962763', -1);
    T('231996316054324226009622737751152542708306575853606699680576.2979473704180673568018174937666939555099251408550275412841449934741053120999250311960', '-0.00000000002440470984493188283681881091476406696345434062764274153736555369694432713235258794821778157833124213579089653780125672309835719004532812124933848285', 1);
    T('-20648.33905752688067', '364742683268206384344442772254773451200307358841591165850201389171780849730182355714994995466053456220045', -1);
    T('-13296891.2', '0.0000006969337082421569919274143628120', -1);
    T('37172409606574175943929198111868146041321294172740261.9143767823011700625959830227158253292122411741', '-9229020573653817070250688951097965429045889891091810375887510258483.86432451', 1);
    T('1453535362884489285626691516310680832482298497424339784442566191993586458847756138332543022653963954995058698.15580', '-33143622616240901719883077121499909963666515277776.03911638745682103192726777541334139680165450417038099168410422389791894570097008374', 1);
    T('-553544731407.954683875078093295639829399072864963186386576846602046', '192999508939696196504970050808433364133176232370021073489176763241408536439.77594027675417445364740098352288673457747531121812928831142123844168252470', -1);
    T('53331368736012231282471303455408074592413207200872818.19673290825616228139358150102045346527811025445464013057081041192769618884910913', '29864250451413880308678527443574263718752000952673380.023619969863', 1);
    T('0.0000000000000553335708975466510638842756141122700181892189479338073653078191086392759442569036578848626338971871999378', '-2433.862079043560961248651748450179913978912939709492727668652481303092796187', 1);
    T('-131087743.6305459391', '1366119444020000948783203513489615222.675978339215788988998559226759468849819166123527857680522', -1);
    T('0.0000010414667170852575270156859553928180613463762435534732908049457814385044451504107590913084220195837233515638824516134017851098411421001695264', '-66115584400599354704187997780889126098693373365.7243', 1);
    T('-82580207676754903853225612109619332832646591973947655468920313639308916718.1330927060723276446644406371829999060475633907079169', '5123330295520469513903522349127462754600115573.1373461391379131781873', -1);
    T('-22881636298670205035641935440359796471601928206681810441710383670980611628185637243569.2507827277681252065670282330799224', '736623256360.52046053521393940948105264615756015326648432', -1);
    T('10.6557893608099767579084904', '-1549097478049581073829995395668214851867184047164638481948954196550730492470162977527257584557330.12691586584734276203352320', 1);
    T('-990750595009217072591203410182612405197518047760914771032204784294635251950209321008567583494561257290737', '305183437080190842418299140880536765514850999.697345630592391581619258378412681359059795654', -1);
    T('-1666770629345794574416820151105.98918396166031507208776276918495816721257656112225182497801163182679207902596802205860048306600841687864861095511', '-0.00000001067708997946', -1);
    T('-14840.8160635780542830749790687168810848087921446934163740720565540416857197820946', '34080400103214533424.02376392426614849386411125899538938586694', -1);
    T('0.0000000000000016877563085857940725171784798859373742', '0', 1);
    T('-33190786246688543666606637359744.217563683075', '1411442489270647265365237504971682227816451192966004619718073064881.0785117653978579470036133709733772486485584681564117735482334823573897932', -1);
    T('22250091784709109592.36289103127751407973011885', '-0.0000382591424878799273145128194620542054246216992721442791349175343470175713780048283294641587173331569078106987388529', 1);
    T('-366783961078432297345344407263954100597261322478589032766.73282236301460555020', '-96792806400556284879273453156295184.53428387344080543516219317', -1);
    T('-4428412434012469201409972157335263140259080336552387999530773415365566408064446887607002402436823395664644162540941981862539131750982436.53', '75696312592552260444421580586326708012624152846535337194315378288808695.3800482862544568581804928901090851775492837416229', -1);
    T('-5875606174326455206892.166531322577891655817791602124272', '-35009191320796020285350597114063011014625404863861820815440146042482080541906069341', 1);
    T('0.00000053938374247898490593751341139618225706260032227451912740608995112652267024567', '175852452557353643.3590476179170', -1);
    T('0.000085430888367277502429220363288215723771185373', '8256298205292814781230409657307281433998721428415657164206.36639', -1);
    T('-52206181136131234784399813236.07148184351942727', '187209867307553393739457212014673840096167129608946393051576008336453819741553745147502544430776215770796121630485677673.9724596115587907243111403', -1);
    T('-116404659080562114.92071212768286143841500510345567940661701355074747251796041', '-0.0000000000049745937887893457305924521492823436496769064269458995595186839321054906563207671851820946083323716587936229045653732369629477947990064968', -1);
    T('28632132796102343.642479895418482981865379537641435463355793', '3947054586925956430852945631879967537015686007064533778477126086105171929289441372934106340502853676944.8775856144613230825303', -1);
    T('-857090508200151475054556597610222124661175080017618336676970123774256255824922667023873121804008646192330290129442806', '-972101984776814063384288921892937781463259806047634752997185.4385721825546355179576429', -1);
    T('524360242934236610220749675664188585635590483292908774530668032546940050829944754444786102305373006086287153988223497918735', '-894112.62957', 1);
    T('-4210359748516193705490258816796808454697789142688778195029295009029687568303590578372169555384509849436838285', '31544435847506925886.4380471855572374745797509775141400719180063314074764017605405542023671969250480247374160173575823024192641879318726', -1);
    T('0.00000000000000000039648316584476924066746927696080890012966606658194662052', '93186692411262534487106225917322323273998860.702889752659967', -1);
    T('-355809833.80952792320528641233', '80686526919845500998309999431837058.761633435885737503460027358262242', -1);
    T('135973290.168739239202104579143727871073186846998465022695079917761494935246543420262539585973598640481769703017097113004230499019752720843814876125395', '-5247621701130676973811017481409509202617774437873284817094169357757993693424454590200078960274872983976142587199662655362147649', 1);
    T('1722959380210301975884294773508', '9285857700957558240758114686802782724351979408646270147.79', -1);
    T('-2.108499091120865886897591323930243793006036956873698734554284782307034333654312298978700143514443242015114382393092579020064541038144909798932', '0.6600963818550654763059005580259719939747091', -1);
    T('239620618436021.91', '-4353302761316014755083307438727860990450226754399292536680958540457321480743198864', 1);
    T('-247311515425879756100312067126621077462386243210235600848467077095397086040795417.16091213583', '-260.0692816252127916277315158672499008107826181646194964038208702225413806272325838419818326501439852500060857812695956426279373392731287', -1);
    T('0.00000000000000092678002317773819293673427756278593549636636017011488156614', '17608242495263943038945700454791334002001731748793496370046578764838341632679102710921093941418183970826750981020832871212156842541461372', -1);
    T('-33395325628320096104732838558355526.34337764550949233422721', '205332050719085679752333364390801841584322469575410029598277675558008298194.4403120686536479725405590603499717318334866527066993402595695782', -1);
    T('1704446749770125249947219847049678079826076962438747770032889527765979216824', '-81884993441.044414114132150', 1);
    T('4721008.67935983797016512145416126232413', '-0.03498350297025037393206835110018120336910941973578256042733733228736114655699947857927341334', 1);
    T('181391051825403456208156.71244213486959497601037', '-776380379297651015893862651994364337679290452023660979418305268365.4639038680782187382', 1);
    T('0.0000000847', '22156497747243948647802199255699537070266422639.5633433463683691278073207255994132556519453723419', -1);
    T('-6.21217206985247294651387216860807591050001764817572516334758', '886061238651128.7', -1);
    T('-1161719026145675243574235610276988347246026816878990032451997176103072809623554165635479395356340140107166377591092789264418175', '-0.000000018735947478220650520638945854023532902579986523026188004265750964790', -1);
    T('-0.00000000867192138', '2502507910601152855229403992937540857964041297324987261262589402205840', -1);
    T('932600538480920158326929132563.6421982462761565925070778172257671442090601464460086', '-20519384614533168439297510042006580413691480074684.20874560931252451163046908065695481258407657', 1);
    T('-423970839089252202458.4142517215652507527660399945359115489273265486900307489264302540041681142598257029618492805741704283129188858300', '-0.0000000000000000020864723406154143161822628597022504762643109363924577177440002989153679290543872240996459231393135479147340630', -1);
    T('49491330651043321769388801332639.740296423762', '0.5171693040591007989301158138415776204505193432948807746575263122468776152077', 1);
    T('0.001245962897188796973717486355827294945060225829760809691400850708544510', '2093451351363855302147446056836441599578148902408761562976800394573.65341921067439897924178668210176520923190465610921336906740229984', -1);
    T('2593248239529730040425963884470681420571770726127.898763080708', '7187960966847715724350587626703224781728201547468602127890467264952177647476374.8350740675946710455460463413291', -1);
    T('10876110728592679732.62028952680014147540924866973673791348307668059733003935578406', '14807.3566503507754041309056234009138430821972145065785727273499408126157754376928813995906375584967247205063511345989398044710766229497805904317', 1);
    T('930802811312871985657541282630.11555878286243010124609615', '-55898805297735194055894340167715838876998587195058346456322370995879163257917874310396332.8301127894058724494250937495', 1);
    T('4373687004743801710.4295871291', '-2399.751203123176895978605217344914876835764318218494324419569769709590467191', 1);
    T('19885418415499907740390897118745282009388.522241490773186707378554377', '-0.000000000000000000016311844734', 1);

    T('0.091650', '0', 1);
    T('-31.95', '-0.0000004826766', -1);
    T('8.66569234', '-5157749157', 1);
    T('131.57910', '-0.00000000143732', 1);
    T('-0.00000000000000069913178493', '-36.2938', 1);
    T('-71.52874', '-12.621', -1);
    T('0', '85409.76884', -1);
    T('-0.0000000000362430662837', '-801785981.0', 1);
    T('23.2', '-102599', 1);
    T('35.5', '-0.000000000000000012', 1);
    T('0.00000306', '-2.632', 1);
    T('0', '-0.0000000000000000007729361018', 1);
    T('314012.71462', '-53575.055', 1);
    T('-101465', '-6', -1);
    T('62740.249', '0.00000000000000000007443159314', 1);
    T('6.28898', '30', -1);
    T('-14.1', '20523313.15', -1);
    T('-121.9', '1.9', -1);
    T('9.68', '-1872.932', 1);
    T('-2553.3', '413.6', -1);
    T('13675.5', '-5', 1);
    T('-0.000000000000000001038840261', '2.08', -1);
    T('-3252618.447', '3.410', -1);
    T('-7530437220', '-66.6578547', -1);
    T('51.32', '-0.0002497237', 1);
    T('-0.00147259804905', '-15.0', 1);
    T('4517.34411456', '19.1775057', 1);
    T('-14.006', '0.0000000000000748001', -1);
    T('-1029.3', '2', -1);
    T('1473.3', '-1.01336820638', 1);
    T('5258.8', '2311.6', 1);
    T('4.9', '4', 1);
    T('8614797251', '5.47', 1);
    T('73.173', '-1.4031382', 1);
    T('502.36012', '-39996872', 1);
    T('-493652528', '2187946548', -1);
    T('-600552370.92', '0.011235396004', -1);
    T('35.61040429', '-54899.96', 1);
    T('1.447', '3.951143', -1);
    T('-2814441.354', '-0.030752704', -1);
    T('-0.00000000000000001062528419', '14428385.05', -1);
    T('-0.00000902457', '-906093.03', 1);
    T('-4.49514906109', '15640376291', -1);
    T('-14.005', '55.971', -1);
    T('-5.58', '5257.64', -1);
    T('0.00000000013353112755', '0.1701', -1);
    T('-2647318.81', '-115.6', -1);
    T('-22.4', '0.00000000000000000002689757418', -1);
    T('-1621301570', '-1.074', -1);
    T('-7', '-21400', 1);
    T('0.00000000000002041639', '1.3', -1);
    T('287938.5', '0.00000027218', 1);
    T('-0.00000055410455610', '2355408.35784', -1);
    T('-18.363786016', '-24.12699692', 1);
    T('368728547', '12', 1);
    T('0', '-16302264', 1);
    T('-6.7', '-127.83676', 1);
    T('-0.00000000000038760', '77458475215', -1);
    T('-0.0000000004193858594', '-0.000000000000000000874962299872', -1);
    T('-64715.0554', '-5106.6', -1);
    T('-2', '174636', -1);
    T('3.6', '-9.29', 1);
    T('0.0000000000000001025', '-1', 1);
    T('57.19', '4728633003.0', -1);
    T('-0.00000000001896809493', '27551629.4916', -1);
    T('-24936.227933', '-17253964', 1);
    T('0.0000000016330870', '162322.24', -1);
    T('780.4', '-0.00000000000000788606669264', 1);
    T('2.008', '-82.793645719', 1);
    T('0.000023', '-0.0151128375', 1);
    T('1.60', '-4935.4', 1);
    T('10320469', '-844.9', 1);
    T('4013.16757', '-4.73', 1);
    T('-22955362593.9', '-3800487406', -1);
    T('-0.000000000000000030708244506', '29', -1);
    T('1', '0.00000000006442170', 1);
    T('-13923', '0.0000000000000000019', -1);
    T('-839013', '-3.11884562268', -1);
    T('12.22605', '2.4', 1);
    T('-2', '-751739624.9', 1);
    T('-0.000000014', '-1.1', 1);
    T('-0.0000000000096284906554', '-0.0000000000000000000531', -1);
    T('-0.00000000000000477', '-0.000000000000010180391', 1);
    T('-2919850130', '1.5', -1);
    T('0', '-22.424', 1);
    T('-3.8812', '-450574', 1);
    T('-81939.3196', '-1.528956', -1);
    T('0.0000000000000000000662', '-0.00000005609645255', 1);
    T('4.43', '-0.00955682817', 1);
    T('-1', '3.68', -1);
    T('-2.2337', '-18398007347', 1);
    T('17.31058', '-742739604', 1);
    T('10', '63510.06483', -1);
    T('-1679', '0', -1);
    T('1', '0.00000191916669633', 1);
    T('677.105', '60922901809', -1);
    T('0.000000000000000014238616', '6311.5471', -1);
    T('-3', '-193.6', 1);
    T('-3.17', '0', -1);
    T('1896.17', '0.000000420065102', 1);
    T('-21.59982', '1.635168485', -1);
    T('-1.1865349', '-1', -1);
    T('1.2', '-0.000000000000061', 1);
    T('0', '1.52', -1);
    T('5.49', '20.789347414', -1);
    T('-0.000000000000000023', '0', -1);
    T('-4.3', '0.0000000000000001390542834', -1);
    T('-50.261594', '-0.000000006027', -1);
    T('98987.24', '-2', 1);
    T('0.00000000000000005238041903', '-0.000000000021', 1);
    T('66.97', '0.0000012729936969', 1);
    T('-1471', '83268824096', -1);
    T('76195', '-0.000000000000000000022355488306', 1);
    T('4.00', '-1.2', 1);
    T('2', '0.00000000124844398', 1);
    T('-56365405', '-1.4293', -1);
    T('-0.000000012648228056', '1016.22', -1);
    T('-902947', '-1415195', 1);
    T('90004.642', '48.208940', 1);
    T('20', '-1.9', 1);
    T('0.000000000001587', '-0.000000000000000000062640220', 1);
    T('-400040.6', '0.00000009705375', -1);
    T('6804221.367', '0', 1);
    T('5', '0.00000432', 1);
    T('0.00000000086378', '85674151.6', -1);
    T('498.115979', '15.68', 1);
    T('-7.168163', '-1079.98097073', 1);
    T('-920.494', '0.000000015113372', -1);
    T('-2.9', '-0.0000000000000013597214164', -1);
    T('0.00000278', '0.000000000000000004069', 1);
    T('452953568', '5', 1);
    T('6.3', '0.00000000000000000108', 1);
    T('-6.8363624', '-71489', 1);
    T('0.0011232588', '-303.3', 1);
    T('-14.0845', '-13.736', -1);
    T('-17.02168645', '-224637', 1);
    T('-4212280773', '-0.000187770', -1);
    T('0.00000003418', '-0.000039', 1);
    T('-43.737419409', '8835.871', -1);
    T('-97593198', '-0.000000000000000000318554271', -1);
    T('0.000000000000000000011383807583', '-6821.9588', 1);
    T('0.00000000002148347559', '7307610.12', -1);
    T('-192642.694', '0', -1);
    T('0.000000000007138411375', '-0.0001386', 1);
    T('-85.57', '-0.0000000000000000015380232', -1);
    T('553283624.5', '-0.0002938', 1);
    T('-0.08812', '4.83', -1);
    T('4.9', '-436', 1);
    T('-0.00024787', '0.0000000000000000804553', -1);
    T('505.177864', '-1058821.702', 1);
    T('0', '-9.2', 1);
    T('0.000000000139878568', '20.792', -1);
    T('194.1635', '26817.14', -1);
    T('123', '-0.0000000557024116689', 1);
    T('-21597132.5743', '74698648', -1);
    T('2.0', '-22574256851.6', 1);
    T('-99', '148.3755', -1);
    T('-3', '-0.0000000004324672314', -1);
    T('25.5594537708', '0.0000001987683', 1);
    T('12.204523', '127', -1);
    T('-16.1', '-0.00000000003079945018', -1);
    T('5', '-231057.18', 1);
    T('-0.00000000000566786', '-227438', 1);
    T('0.00000000004188', '-4437894.422', 1);
    T('3716202', '4.050', 1);
    T('878941437', '0.0000067945', 1);
    T('0.0000000000006517981381', '487.06', -1);
    T('-464400975604', '0.000223', -1);
    T('-0.000000000000000463803912', '-0.000000033', 1);
    T('-44', '875958', -1);
    T('173.04', '259.4491902', -1);
    T('-1.66', '35146200.24', -1);
    T('0.0000103750', '6.221887', -1);
    T('-6034.59820', '0.0068365419', -1);
    T('524.34546782', '44.572583393', 1);
    T('8711891602', '0.000000000000000000080236', 1);
    T('-1', '-0.00000000001045149282985', -1);
    T('1009', '2742992.1087', -1);
    T('-0.000000000443', '-26.86321244', 1);
    T('3089348.2545', '-1', 1);
    T('0.00000102676', '-908.53218525', 1);
    T('-3.48848', '5330516.1', -1);
    T('6.4616', '-1', 1);
    T('1', '-9.781657', 1);
    T('-3.4', '-521472970', 1);
    T('-586.97', '-113.11324', -1);
    T('10.2837600', '-2', 1);
    T('3.74102080', '-11175.7', 1);
    T('0.000000000042971203966', '-2084.4542', 1);
    T('-0.000000064891438', '-2043792860.5', 1);
    T('-33.47', '-1323.71284738', 1);
    T('422.5186', '0.00000000073882404523', 1);
    T('-218.3', '-121.56', -1);
    T('0', '-1754.876', 1);
    T('-248.5', '-1.1', -1);
    T('22.04', '135695140693', -1);
    T('-0.000000000000181', '-49.2', 1);
    T('-896738.71440', '-779277.279830', -1);
    T('1635.632', '-1.87', 1);
    T('-0.0000000000000000003432937', '-0.0000000000000000128', 1);
    T('8185.04579', '28.304207', 1);
    T('-57.80410102', '-0.000000000065900351', -1);
    T('1', '-0.000000000000014', 1);
    T('26.13562', '0.00000000000004472101', 1);
    T('-26', '-46846563.0', 1);
    T('0.0000008802852', '-38865.86', 1);
    T('6590981.4', '25733', 1);
    T('3.10', '-0.000095648629463', 1);
    T('2', '0.3926', 1);
    T('1071.137629', '8717.37', -1);
    T('188711', '0.00000000000000000003923', 1);
    T('2.64', '1912.289', -1);
    T('962.2', '37.5', 1);
    T('0', '-14.3056421', 1);
    T('6.434877', '41.7051341210', -1);
    T('1', '-4', 1);
    T('-573.491', '-7850309', 1);
    T('-8506.2', '-6', -1);
    T('-2436719080.97', '-487.145', -1);
    T('1', '-0.000000000000013193', 1);
    T('67.3', '331.473345666', -1);
    T('-0.00000000000000116355724', '0.000000001349568973', -1);
    T('-4380819.68', '-171', -1);
    T('-263582.40400', '0.0000000000001840687158', -1);
    T('31', '-0.0000000000000000073', 1);
    T('-3.234555', '1', -1);
    T('-0.0000009745557', '-12583.24883', 1);
    T('0.000000004423159', '21297.3', -1);
    T('-11954925140', '-244009.66219', -1);
    T('4122.60', '-0.000000000080630710245', 1);
    T('24458437758', '-29.81012', 1);
    T('-3', '5826.7', -1);
    T('0', '-40662', 1);
    T('-242.79', '-404.29025', 1);
    T('-4446.1504587', '3.763848', -1);
    T('6', '0', 1);
    T('6.3', '0.00000000121', 1);
    T('-1.0', '-0.00000000000000000006445409', -1);
    T('-9374.2957170', '58340751', -1);
    T('20347413.9', '-779599.59', 1);
    T('3051.205905', '17883.635', -1);
    T('-1345.0889662', '420448113', -1);
    T('-48.9', '0', -1);
    T('-0.0006551466', '-576096.0', 1);
    T('47.80', '1421535456.7', -1);
    T('22280251557', '1', 1);
    T('73.35790', '1788057733', -1);
    T('-80114.1', '0', -1);
    T('-0.000000000000707301', '9582641.8231', -1);
    T('-40590618', '0.0005028', -1);
    T('-26.1551', '-59129881', 1);
    T('126.31', '0', 1);
    T('-1', '-3.330', 1);
    T('-7', '-0.0000200526', -1);
    T('-3761.76241528', '-26.8', -1);
    T('-0.0000003162744266', '0.0000000000000000394784057113', -1);
    T('-130448.713110', '-169586.15212', 1);
    T('-40.8968', '0.00000000591143', -1);
    T('50781.5422696', '0', 1);
    T('-0.00000000000000120', '-0.0000000859583', 1);
    T('-26886.528', '-97.8', -1);
    T('6.812', '-74976701.51', 1);
    T('0', '-958435', 1);
    T('-78.09589', '-28195701701', 1);
    T('0.000000000000000042071654504', '-26576.9776', 1);
    T('6.1', '0.00000000000000000089253676', 1);
    T('-2744493.46', '-110.8907926', -1);
    T('3.82237319650', '24.69679', -1);
    T('642337.78548', '-0.0000000000000000000372333883166', 1);
    T('2017548', '-21455.8709783', 1);
    T('-115732.814', '-0.00000000029824235', -1);
    T('5309.7', '0', 1);
    T('16741188415.6', '-0.110485391', 1);
    T('-1', '-3', 1);
    T('-4', '6.970303371', -1);
    T('-186.5987098', '37519.7898', -1);
    T('-217.59', '-90791.13282', 1);
    T('0', '-264309561.7', 1);
    T('3303.44786015', '224832', -1);
    T('-1', '8628993', -1);
    T('-13840', '31.895590', -1);
    T('-422.075562', '0.0000000000003673', -1);
    T('-5.4', '-2.988', -1);
    T('-12.28195', '-8.1', -1);
    T('42.1', '8452.3', -1);
    T('40.4', '1', 1);
    T('-611.849', '-20937.2313506', 1);
    T('-8.530', '-88795904.7', 1);
    T('-5235577626', '0.778127928170', -1);
    T('370711545091', '0.000000000000000210166457', 1);
    T('-7.48128', '-43.9398904797', 1);
    T('0.002625414898', '6', -1);
    T('1', '-2', 1);
    T('-6.731', '26328856', -1);
    T('0.0000000000000000000284154564', '-1059603.41', 1);
    T('0.000000000443838495', '0.0000000000000017', 1);
    T('-3', '-18008.5115', 1);
    T('-5.44111', '-0.000000000000002315', -1);
    T('-0.00000000000005224', '2615.7', -1);
    T('-165.123', '715.4', -1);
    T('0.00000000000000000002503685', '103.89909', -1);
    T('-843660', '-61054040.1', 1);
    T('-0.000000000188978', '1.5162', -1);
    T('-13262813', '-3.8259288422', -1);
    T('-260760', '22527192335', -1);
    T('-0.0000000012743953613', '3', -1);
    T('-3.1', '0.0002826855', -1);
    T('-0.00000034032373868', '4', -1);
    T('-34.4487739299', '-3226659.36', 1);
    T('-613804.983', '-0.00000000000000000162', -1);
    T('1.64349914689', '-35.11364419', 1);
    T('0.00000000007506', '1.5', -1);
    T('-15402.36', '-25.57717', -1);
    T('-0.02114629039', '-29.30', 1);
    T('741.6', '272.88495', 1);
    T('268', '-3.19964', 1);
    T('-71.4', '21611474', -1);
    T('0.000000000000007218501', '937651.654', -1);
    T('199.3', '106.687430', 1);
    T('-347089643', '-1.23588', -1);
    T('1.1', '142.884', -1);
    T('-0.00000397691', '3080.547000', -1);
    T('862056251', '-0.00000000053632884', 1);
    T('1', '-51972744.2', 1);
    T('-0.0000000003410179', '-100.6', 1);
    T('-2.888005719', '530.1', -1);
    T('1', '7572161.50', -1);
    T('-347802.7', '-9442843753', 1);
    T('0.0023038', '780500', -1);
    T('8', '0.0000000086715315930', 1);
    T('25.2514', '-5.6679', 1);
    T('-273.01392594', '744.7', -1);
    T('1', '-0.000000000000000013732783740', 1);
    T('-12110.11', '404.59869', -1);
    T('-12.2', '1.409', -1);
    T('-21399326578', '3', -1);
    T('0.0000000000000011173', '-641.0', 1);
    T('-32312.03841', '-858381873.058', 1);
    T('2.914778', '-4083717632.78', 1);
    T('-1', '-145434.3590', 1);
    T('-0.000000000000029', '10.5027826', -1);
    T('-83110.21', '-159304.18856', 1);
    T('0.00000017124', '234078.4', -1);
    T('-3.3135862481', '-0.0252', -1);
    T('50816417030', '-0.0000000000000000000677050476', 1);
    T('-0.000000121283558', '0.0000014', -1);
    T('-2.6', '-51', 1);
    T('-0.00000000000006649625', '0.000000000000000000158653960', -1);
    T('0.10516268852', '65.301', -1);
    T('-1.275', '-47740', 1);
    T('-1.351', '403525711', -1);
    T('2', '-4297959683', 1);
    T('-164689.3', '-39864948.9721', 1);
    T('9.9', '-69.2411393', 1);
    T('8', '0.00000000000103945809296', 1);
    T('305178.471', '3', 1);
    T('0.000000000000032', '-20930.0799164', 1);
    T('-77.49', '395.9622', -1);
    T('-152.757430953', '-1398.02', 1);
    T('-2307.747', '0.00000000000019805243698', -1);
    T('-0.01218', '-7.812', 1);
    T('0.0000000000000000003810', '0.0000000000000000029679541', -1);
    T('10.688', '0.000000000008058682358', 1);
    T('-1', '2578212', -1);
    T('-3', '-56.08', 1);
    T('-1093', '251.7', -1);
    T('-4256.966707', '1.5', -1);
    T('0.05564369', '-359117.57', 1);
    T('-0.0000016653675', '21.04559509', -1);
    T('0.00000000000000000560706598', '0.00000035617423088', -1);
    T('-1613281026.0', '-12.8755773', -1);
    T('-10117916.33', '-43368489.9992', 1);
    T('0.0000000000000000023', '-0.00000000000000000072941926625', 1);
    T('0.000000000000000000114', '-39574.34967', 1);
    T('688605.3502', '790.091519', 1);
    T('93.997217', '-1193.847608', 1);
    T('70.4', '0', 1);
    T('-1', '-1', 0);
    T('2799.9505', '-879350400', 1);
    T('26.3519', '2.7329', 1);
    T('0.000000001075249872', '1', -1);
    T('-1576477620.9', '0', -1);
    T('-0.0000000000001887095', '0', -1);
    T('-8.5', '-1699611.01', 1);
    T('43.9', '269.320', -1);
    T('6.861', '-13208', 1);
    T('-0.00000000018976769', '4969.1', -1);
    T('-0.104', '63006.503', -1);
    T('4.699718', '0', 1);
    T('-2398.0397', '0.000000000000912', -1);
    T('-4898751.931', '1', -1);
    T('157885566', '-68580.02', 1);
    T('-11645818', '-3', -1);
    T('-16294097.923', '-1.2097447985', -1);
    T('-0.000000748731', '-454.222', 1);
    T('0.00000000000010244980', '134106823.540', -1);
    T('0.0000000000000015', '-170.73985', 1);
    T('53.927', '6', 1);
    T('1859944924', '2923512', 1);
    T('-8', '2.06', -1);
    T('-1173', '-2', -1);
    T('2530717.95510', '-161.959593549', 1);
    T('28.7750', '28975251191', -1);
    T('14.6', '9.60848', 1);
    T('-26625.8', '-181290682.303', 1);
    T('-3216.90', '-13439', 1);
    T('0.00000469235', '-1', 1);
    T('-1767948', '0.000000000000000000030839', -1);
    T('-0.0000732020', '133715', -1);
    T('1790223107', '0.0000000064', 1);
    T('-3', '-2', -1);
    T('-63662276937', '3719.7312891', -1);
    T('-0.0012587205', '-4217797.73', 1);
    T('63388492', '-2816203811.9', 1);
    T('0.000000000000030042105', '0', 1);
    T('-305040732.4', '0.00070', -1);
    T('13331390', '-0.00000016537084927', 1);
    T('-0.0000022895', '-16976.1986920', 1);
    T('876.4955249', '-243.2', 1);
    T('-197.5688', '-4.29794', -1);
    T('0.0000000000000000011', '6282.72', -1);
    T('0.0000000000050984036283', '7.7881', -1);
    T('-10495794506.9', '0', -1);
    T('124856173.18', '0.00522', 1);
    T('53.3', '-199', 1);
    T('-1199.8', '-727.8', -1);
    T('-43307.7', '-28360017461.6', 1);
    T('-1', '2756856880', -1);
    T('-689646263237', '464047', -1);
    T('47187.7', '0', 1);
    T('-0.00000000000000001510', '-3563.630', 1);
    T('-4.858', '15', -1);
    T('6199564.0', '4', 1);
    T('0.00000008126595122', '94923.9', -1);
    T('-4.55', '-0.00000050900013', -1);
    T('1', '2296100.7', -1);
    T('0', '1.503', -1);
    T('0.000000000110946', '0', 1);
    T('615423.7235', '184.8711374', 1);
    T('1.05514', '0.00000000000000164', 1);
    T('496.80639073', '-37990.30', 1);
    T('836.9842', '7.8', 1);
    T('-5860278130.33', '-0.0000000000000000150199', -1);
    T('-0.007816', '-1.811145', 1);
    T('0.00000000000000000006492937', '1.6', -1);
    T('0', '-4.8', 1);
    T('0', '3.8982', -1);
    T('23', '34.3741', -1);
    T('-3.0', '-0.00000000000104944', -1);
    T('-0.1919', '5', -1);
    T('99770.2091', '-5.7', 1);
    T('51124300393', '-0.00000000017998', 1);
    T('-70787232160', '-0.000133', -1);
    T('1.13', '-3424775', 1);
    T('-0.0000068139312402', '-0.0000000350208', -1);
    T('1572.7', '-205.1', 1);
    T('-0.000007355799843', '585', -1);
    T('0.00000000000153614', '-20.5512', 1);
    T('-0.00026', '2029254', -1);
    T('2227.1', '372.5', 1);
    T('6.7923522322', '7', -1);
    T('1.3', '5', -1);
    T('-8.54164', '-8', -1);
    T('29980.875417', '0.441135960', 1);
    T('299010.3', '0', 1);
    T('9.27543816', '-0.00078113', 1);
    T('-13.507', '5.73', -1);
    T('-2724', '79823.9184', -1);
    T('665153', '0.00000139621298365', 1);
    T('-221507.830', '-42.2728486', -1);
    T('-25748575.099', '-184839.8', -1);
    T('91089', '11.053483070', 1);
    T('-1.954', '-3.146', 1);
    T('-118', '-0.0000000000000000253942787', -1);
    T('5', '0.0000000000000000008808', 1);
    T('-0.113849830', '-13.23', 1);
    T('3419823', '9382356.3920', -1);
    T('-209675697.9', '-1718.23', -1);
    T('-0.000000000001298', '0.1258203689', -1);
    T('0.00000122345524', '0', 1);
    T('1227261.8715', '4', 1);
    T('-0.0022031', '2.041487544', -1);
    T('542.9563883', '-5854511410', 1);
    T('-11659798', '-2.444', -1);
    T('0.0000000000000000010320422', '633.8', -1);
    T('0', '-2.8', 1);
    T('-242.35223', '-2352762', 1);
    T('-189681.68721', '0.0000000000009222784269', -1);
    T('0.000000000000000007316', '575', -1);
    T('32152.149300', '-0.00000000003464314292', 1);
    T('1.02326029645', '-4', 1);
    T('3', '0.00000000007128', 1);
    T('-6654.74794838', '3880.34', -1);
    T('0.0002021', '-52.79057', 1);
    T('-0.04040990', '-0.16497', 1);
    T('291339', '-8', 1);
    T('-1.3669473', '0', -1);
    T('0', '-8.9', 1);
    T('-223743', '0', -1);
    T('0.00000000000270179', '2084', -1);

    T('-5.5239e+3', '-2.2807805e+1', -1);
    T('8.554e+2', '0e+0', 1);
    T('-2.1176736939e+5', '2.13526332e+2', -1);
    T('2.528e-2', '-1.5e-1', 1);
    T('-2.1536554e-2', '-3.93e-6', -1);
    T('4.853430802e-5', '-4.9e-11', 1);
    T('-6.9e-3', '1.9596e+1', -1);
    T('-9.93182949e+1', '-7.9983535342e-20', -1);
    T('1.629795e+5', '1.58117535423e+5', 1);
    T('-2.934333546e-15', '-2.093237829e-14', 1);
    T('2.2916931e+1', '7.88e+2', -1);
    T('7.656115e+0', '5.5885422e-10', 1);
    T('0e+0', '-3.3e+0', 1);
    T('-2.4327703616e+3', '1.1e+1', -1);
    T('1.61903621e+6', '-2.3444006423e+2', 1);
    T('4.5332e+4', '3.281123867e+1', 1);
    T('-7.9e-4', '0e+0', -1);
    T('-2.6e-19', '-5.4489933e+6', 1);
    T('5.877152e+1', '1.5125e-2', 1);
    T('6.293000381e-1', '7.2e+1', -1);
    T('1.072062222225e+10', '7.521052067e+0', 1);
    T('-2.9744557e+7', '0e+0', -1);
    T('-1.0235e-13', '-3.671886e+0', 1);
    T('-2.06364e-4', '6.2113337e-3', -1);
    T('-7.02e+0', '-1.1348644434e+3', 1);
    T('-3.57688146e+3', '3.81547e+2', -1);
    T('2.9527098536e+3', '1.32080504447e-4', 1);
    T('-2.6286e+1', '3.8e+0', -1);
    T('-3.45054603e+2', '-9.88229e-15', -1);
    T('-2.469e+0', '-3e+0', 1);
    T('-8.369800004e-4', '1.4e-17', -1);
    T('-1e+0', '4e+0', -1);
    T('-3.0829216081e+2', '-3.08e+1', -1);
    T('-1e+0', '-5.756e+1', 1);
    T('-8.511e+0', '3.126324e+6', -1);
    T('2.4474011949e+4', '1.12649e+2', 1);
    T('-2.57868e+4', '-1.03178e+1', -1);
    T('1e+0', '9.5177e+1', -1);
    T('-9.8069663157e-6', '1.4532689e+5', -1);
    T('3.721e+1', '-2e+0', 1);
    T('-9.7657879751e+10', '-5.67e+2', -1);
    T('-4.8657905e+6', '-2.17381281e+1', -1);
    T('-4.20131e+0', '-1.3179640655e-8', -1);
    T('1.6e+0', '0e+0', 1);
    T('5.16068325659e-4', '1.269e+1', -1);
    T('9.91969e+5', '0e+0', 1);
    T('2.32e+0', '3.69e+1', -1);
    T('5.685149e+2', '3.694e-13', 1);
    T('-9.0148e-5', '0e+0', -1);
    T('-3e+0', '-8.7855e-7', -1);
    T('1.3669489e+3', '1.33866e-4', 1);
    T('-2.6e+1', '1.36976797894e+3', -1);
    T('4.6e+0', '0e+0', 1);
    T('-7.2e-8', '1.971355e+2', -1);
    T('1.19755e-5', '7e+0', -1);
    T('-3.46e+0', '-3.7715361e-11', -1);
    T('3.25762245146e+6', '-4.02e+0', 1);
    T('1.3174225699e+7', '9.6222695655e+10', -1);
    T('6.6e-13', '-5.23193346205e+4', 1);
    T('-3.873e+3', '-1.23681175e+3', -1);
    T('-1.19869e+5', '-8e+2', -1);
    T('2.027381656e+3', '1.47629351439e+11', -1);
    T('-1.467418e-17', '9.0073930856e+5', -1);
    T('7.1e+0', '6.116301582e+2', -1);
    T('-1.7883916e+5', '3.533e-17', -1);
    T('8.8e-11', '-5.9707897e-1', 1);
    T('-5.337e+3', '4.6614e-13', -1);
    T('1e+0', '-3.1e+0', 1);
    T('-3.05920196e-6', '-4e+0', 1);
    T('-1.692375e-10', '2.29981330096e+6', -1);
    T('5.19341813e-1', '6.1e+0', -1);
    T('5.796e+3', '-9.386773281e-8', 1);
    T('9.117497e+0', '0e+0', 1);
    T('6.962934e-8', '1.413982e+2', -1);
    T('2e+0', '1.4e+1', -1);
    T('-2.04e+0', '-1.30300025e+9', 1);
    T('1.57647e+1', '3.0862783894e+0', 1);
    T('-4e+0', '7.1e+1', -1);
    T('1.21e-6', '-2.109584154e+10', 1);
    T('6.55669245e+3', '-8.15e-8', 1);
    T('-8.3307e+2', '-9.1476874e+7', 1);
    T('0e+0', '-3.64676e+5', 1);
    T('-1.2803e+2', '7.2908749e+3', -1);
    T('3.2263e+3', '-1.43355e+1', 1);
    T('4.92751482244e-18', '1.3747248256e+3', -1);
    T('8.20054755e-10', '6.2348e+2', -1);
    T('-1.06e+1', '-7.2569084631e+4', 1);
    T('1.86e+2', '3.76613527e-5', 1);
    T('3.33652e+3', '5.1e+1', 1);
    T('3.665307673e+8', '3.31344e+5', 1);
    T('-7.341261161e+2', '-2.98910916e+7', 1);
    T('6.24638573245e+5', '4.47893448327e+2', 1);
    T('1.23e-8', '-5e+0', 1);
    T('4.469176e+5', '-2.09863e+3', 1);
    T('-2.72624816161e+3', '0e+0', -1);
    T('-6.78251e-20', '-6.837e-1', 1);
    T('6.2456922e-6', '0e+0', 1);
    T('6.2e-4', '4.40516e+4', -1);
    T('-7.624e+2', '-3e+0', -1);
    T('-5.22549619458e+0', '-4.0866914233e+9', 1);
    T('-9.51999532e+7', '-2e+0', -1);
    T('-1.07321e+2', '-1.3e+0', -1);
    T('-5.405555671e-6', '8.0306e+1', -1);
    T('2.2e+0', '6.49e-17', 1);
    T('3e+0', '2.2e+0', 1);
    T('-1.12e+2', '3.4165375e+1', -1);
    T('-2.36978379e+4', '-4.2e+0', -1);
    T('-8e+0', '-6.42e+0', -1);
    T('-3.2e+1', '6.17231707e-19', -1);
    T('-4.8454741051e+1', '4.3339e-10', -1);
    T('4.29e+0', '3.28376306e+4', -1);
    T('-6.33089e+1', '-5.7065758354e-19', -1);
    T('0e+0', '-3.31e-7', 1);
    T('-2.18973e+2', '1.88333703659e+4', -1);
    T('-1.67e+2', '3e+0', -1);
    T('0e+0', '9.7605e-12', -1);
    T('1.294433816e+0', '-1.1e+1', 1);
    T('-1.4246177e+3', '-1.043532436e+8', 1);
    T('-1.0531e+1', '2.2268899e-6', -1);
    T('-1.5611e+3', '1.59757e+0', -1);
    T('3.3638160556e+11', '6.29136402e+6', 1);
    T('-7.7326244542e+2', '-9.6e+0', -1);
    T('-3.593606997e+8', '-4e+0', -1);
    T('9.4433e+2', '-1e+0', 1);
    T('-1.0131e-9', '-4.551632556e+9', 1);
    T('1.61735e+5', '-6.550194286e+9', 1);
    T('3e+0', '-8.14e+3', 1);
    T('-3.492e+0', '8.85393125e+2', -1);
    T('-9.3678169131e-19', '-1.98802069e+4', 1);
    T('-4.39338019e+7', '1.07850051e-15', -1);
    T('-1.1677e+0', '2.22825374e+8', -1);
    T('-3.476e+0', '6e+0', -1);
    T('1.453e+0', '-6.34599e-7', 1);
    T('1.789e-9', '0e+0', 1);
    T('-2.92933e+4', '5.802095e+4', -1);
    T('9e+0', '2.63702e-7', 1);
    T('-6.0696e+4', '9.46475e+5', -1);
    T('-1.508052e+6', '2.45600810354e+0', -1);
    T('6.83354e+1', '1.93e-12', 1);
    T('-1.6e+0', '-2e+0', 1);
    T('-7.4275644e+5', '-6.1587e-14', -1);
    T('0e+0', '3.540869872e-9', -1);
    T('-7.86e+0', '8.041734e+6', -1);
    T('-8e+0', '1.569e+1', -1);
    T('2.0839e-18', '1.2848955034e-14', -1);
    T('6.84909e+3', '2.19e+1', 1);
    T('5.556062e+3', '1.037e-12', 1);
    T('-1.011918e-9', '3.52315476249e+0', -1);
    T('-1.2e+2', '-5.8677085e+1', -1);
    T('1.5e+0', '-8.2951e-8', 1);
    T('5.254e+0', '-2.08338e+3', 1);
    T('8.272e+0', '0e+0', 1);
    T('-2.3496e+3', '-1.74217696625e-1', -1);
    T('2.33e+0', '-6e+0', 1);
    T('8.138135061e-6', '1.52e+1', -1);
    T('-2.691357e+5', '1e+0', -1);
    T('4.277011e-13', '2.1978e+4', -1);
    T('-4.164225e+0', '3.94601989492e-6', -1);
    T('-1.32e-18', '-3.94e-3', 1);
    T('-2.443211e-11', '2.02e-8', -1);
    T('-1.2e+0', '-3.2e+1', 1);
    T('4.7652754554e+7', '-2.1e-11', 1);
    T('2.02136500541e+9', '-2.77170882e+2', 1);
    T('-1.65e-2', '-2.4039e+3', 1);
    T('1.8172e+1', '-6.3e-5', 1);
    T('1.8703827209e-10', '-1.46184e+4', 1);
    T('-1.11606903e+6', '-2.8e-6', -1);
    T('-7.84180535e+0', '-6.9715e+2', 1);
    T('-1.6095371e-5', '-4.007e+2', 1);
    T('2e+0', '2.7730114619e+0', -1);
    T('1.3694403e+7', '-3.14014263471e-3', 1);
    T('3e+0', '2.4553237278e+3', -1);
    T('-3e+0', '-2.78756184842e+11', 1);
    T('-1.2522e+2', '-7.7e+1', -1);
    T('4.491e-18', '-1.196e+3', 1);
    T('-3e+0', '-2.78811358e+4', 1);
    T('-3.5481789e+3', '1.6004994927e+5', -1);
    T('1.9963146e+6', '-6.923e-1', 1);
    T('-1.37573e-12', '2.072e+2', -1);
    T('6.570067306e-1', '3.73554490286e-16', 1);
    T('3.0659071736e-15', '6.946525e+1', -1);
    T('-5.346e+0', '1e+0', -1);
    T('8.55e-9', '7.9e-11', 1);
    T('-7.5096624e+2', '3.40622424e+5', -1);
    T('2.219404561e-14', '5.47749e+0', -1);
    T('3.000476e+2', '-1.754092582e+1', 1);
    T('0e+0', '-1.69774e+3', 1);
    T('2.993e+0', '-1e+0', 1);
    T('2.7528038851e+1', '-3.945799123e+4', 1);
    T('-6.6266e+2', '-4.5e-19', -1);
    T('9.204609e-14', '1.25862e+5', -1);
    T('-7.0237408e+5', '-4.56413483775e+3', -1);
    T('4.8481576e+2', '-6.53713e+3', 1);
    T('1e+0', '1.103e+2', -1);
    T('6.57977e+2', '-3.852e-16', 1);
    T('3.861e+2', '-6.2072117462e+5', 1);
    T('-6e+0', '1.3494901111e+6', -1);
    T('-5.870696e-1', '-3.801808e+1', 1);
    T('-3.83761721e+8', '8.081107501e-5', -1);
    T('6.50057174e+5', '2.0206519e-12', 1);
    T('5.5207e+4', '-2.48e+2', 1);
    T('0e+0', '1.05116516384e+11', -1);
    T('-1.75279284e+4', '3.899762267e-1', -1);
    T('-1.6197e+0', '4.3274e+4', -1);
    T('1.256294e+6', '-5.58921e-15', 1);
    T('3e+0', '2.0586937916e-17', 1);
    T('-3.28553e-13', '-1.18e+1', 1);
    T('-2.81418e+5', '1.72529458e-12', -1);
    T('7.8666421e+3', '5.9153e+0', 1);
    T('4.84347589e-8', '2e+0', -1);
    T('3e+0', '-2.6655512e+2', 1);
    T('6.2696e-10', '-2.054382974e+1', 1);
    T('6.1413274e-2', '0e+0', 1);
    T('-2.9095e-18', '-6.9975956783e+8', 1);
    T('4.01e-20', '-7.5588e-6', 1);
    T('9.490622e-18', '-2.77e+0', 1);
    T('-1.0267e-14', '-8.790091e-9', 1);
    T('-4.077591e-14', '-3.0259558246e+0', 1);
    T('-2.8261e+2', '-4.99857e+0', -1);
    T('9.899113e+1', '1e+0', 1);
    T('5.5e+0', '-7.0265e+0', 1);
    T('5.286e-7', '-4.3972682e+2', 1);
    T('1.5520187e+6', '1.150018e+2', 1);
    T('-2.04e-10', '-4.0474e+2', 1);
    T('-2.32245517e+7', '-4.96976e+4', -1);
    T('-3.6487688611e-10', '-1.1763503e+2', 1);
    T('8.3414625e+0', '0e+0', 1);
    T('9.905071e+6', '-5.9541e-4', 1);
    T('1.984307e+4', '-2.4291e-7', 1);
    T('-1e+0', '-1e+0', 0);
    T('2.060415969e+9', '-2.03455e+2', 1);
    T('3.1982e-19', '-1.993945e+3', 1);
    T('3.093739e+1', '-1.99128676855e+0', 1);
    T('1.881e+1', '-1.09028754e+5', 1);
    T('0e+0', '-4.7092316e-14', 1);
    T('-9.455374693e-10', '-9.45812534991e+6', 1);
    T('-1.67881e+4', '-2.1683630866e+3', -1);
    T('6.3514013642e-17', '-4.5e+0', 1);
    T('1.20179765e-20', '4.9098e+3', -1);
    T('0e+0', '-7.476983768e+1', 1);
    T('-8.5797e+2', '2.1e+0', -1);
    T('-2.75e+1', '-1.749e-18', -1);
    T('-1e+0', '8.4e+1', -1);
    T('7.110682e+4', '8.5646556e+2', 1);
    T('-3.1875423048e+6', '7.216e+1', -1);
    T('-1.41969e+0', '0e+0', -1);
    T('-3.707432e+6', '1.5048071e+2', -1);
    T('-2.65447780189e+11', '2e+0', -1);
    T('3.808865e+6', '-7.22140745e-10', 1);
    T('2.972544e+3', '0e+0', 1);
    T('1.142002886e-2', '-3.063e+0', 1);
    T('-3.292e-15', '-2.2e-1', 1);
    T('-9.29480350675e-6', '9.4830355594e+4', -1);
    T('-2.49267401e-19', '3.3296905e+4', -1);
    T('3.5057e+4', '1.2204e+3', 1);
    T('2e+0', '9.51e+1', -1);
    T('3.87279e+5', '-3.916681548e-13', 1);
    T('7.775e+2', '1.814199961e+2', 1);
    T('2.35095e-7', '9e+1', -1);
    T('-8.077537e+2', '1.477341929e-7', -1);
    T('-4.05364541e+3', '-5.1772081e+8', 1);
    T('-8.0808881e+2', '-9.006e+1', -1);
    T('-1.408092e+5', '-3.86832e+2', -1);
    T('5e+0', '2e+0', 1);
    T('-2.7424908566e+0', '-1.5471519e+0', -1);
    T('7.31598e+0', '6.617089e+2', -1);
    T('4.634e-7', '-2.8214e+3', 1);
    T('-3.67e+2', '1.2e-18', -1);
    T('2.5658e-5', '6.99742e+3', -1);
    T('3.7635921e+2', '-2.01901e-17', 1);
    T('-4.8483140421e+9', '-3.02562e+1', -1);
    T('0e+0', '-2.9395143209e+8', 1);
    T('-2.8599503512e+7', '5.35e-1', -1);
    T('-1.7e+1', '-9.66381e+0', -1);
    T('1.72e+1', '1.0349e-1', 1);
    T('1.28429e+3', '2.0794611e+0', 1);
    T('1.01e+0', '-5.7758e-11', 1);
    T('2.227909e+5', '5.70358533e-7', 1);
    T('-1.46175e+2', '-1.17142e+3', 1);
    T('-9.231e+3', '1e+0', -1);
    T('-1.959219085e+3', '3.71e+1', -1);
    T('5.1e+0', '2.93e+2', -1);
    T('-1.72022209707e+1', '0e+0', -1);
    T('1.1e+0', '1e+0', 1);
    T('1.71906029185e+5', '-2.14019e+0', 1);
    T('2.3e+0', '-1.5055635614e+9', 1);
    T('2.7786e+1', '1.061015128e+9', -1);
    T('-1.56275984e+4', '1.09e+0', -1);
    T('2.19791673e+1', '-3.104e+2', 1);
    T('-4.3337886e+7', '4e+0', -1);
    T('1e+0', '-4.22059e-7', 1);
    T('3.365e+3', '-1.554e+2', 1);
    T('1.1204042327e+10', '-1.3423178346e+10', 1);
    T('2e+0', '-4.226459262e+1', 1);
    T('-2.15204e+5', '5.958e+0', -1);
    T('-9.99386226e+4', '0e+0', -1);
    T('-1e+0', '-1.66246413e+7', 1);
    T('4.9173e+2', '5.850707e-18', 1);
    T('4.9e+0', '-4.7875e-8', 1);
    T('-3e+0', '0e+0', -1);
    T('1e+0', '-8.0083e-2', 1);
    T('-7.83025222e+8', '-5e+0', -1);
    T('-4.974944e+4', '3.1477230359e+10', -1);
    T('7.180136071e+3', '-1.0544157071e-9', 1);
    T('1.6665814118e-3', '1.73898e+3', -1);
    T('-2.525921789e+1', '-3.93e+0', -1);
    T('-1.734618e-16', '-1.6371419e-20', -1);
    T('1.6444334e+6', '-2e+1', 1);
    T('-1e+0', '2.072822964e+9', -1);
    T('-6.473e-9', '-9.162534e-5', 1);
    T('-3.1e+0', '-3.24e+0', 1);
    T('1.6655834e+7', '-3.0374218803e+6', 1);
    T('2.391e+0', '-3.907e+1', 1);
    T('-1.7022720963e+3', '2e+0', -1);
    T('4.454083713e+9', '2.0091e+4', 1);
    T('-1.0366217734e-15', '-6.721993e+5', 1);
    T('-5.7809e+4', '3.784169e+1', -1);
    T('1.24172537e+5', '6.3e-9', 1);
    T('4.2774283e-9', '2.4637e+1', -1);
    T('1.6237405102e+10', '1.6962e-1', 1);
    T('1.918662e+2', '1.544681756e+8', -1);
    T('1.0276881e+4', '1.788601e+0', 1);
    T('1.029335e-8', '1.18168265e+6', -1);
    T('-2.55327e+2', '2.5825834e+6', -1);
    T('0e+0', '1e+0', -1);
    T('-8.909e+2', '-1.73e+2', -1);
    T('5.67e+2', '2.56525383318e+5', -1);
    T('-8.96e-20', '-8.32900609e+3', 1);
    T('1.592758866e+9', '-3.872e+0', 1);
    T('-5.639641852e+7', '8.2009e+4', -1);
    T('2.9e+0', '4.5e+0', -1);
    T('1.1865649388e+5', '1.78418807471e+3', 1);
    T('2.07011921e-13', '2.63e+0', -1);
    T('3e+0', '-2.21e+0', 1);
    T('-9.34727321093e+11', '-6.86793197512e+11', -1);
    T('3.9e+0', '4.2973482815e+4', -1);
    T('1.227147e+5', '-1.359464668e-2', 1);
    T('-5e+0', '-3.3986e+4', 1);
    T('6.31103133e+7', '1.94315936e+6', 1);
    T('-3.96418e+4', '-8.7168221121e+4', 1);
    T('-1.64e+1', '-3.33576978e+6', 1);
    T('4.952370705e-11', '-6.63267265e+2', 1);
    T('1.253e+1', '-6.14622e+2', 1);
    T('0e+0', '-1.442321328e+9', 1);
    T('-1.180943e-6', '-9.42e-1', 1);
    T('-1.037276289e+7', '-1.5944116485e-8', -1);
    T('1.55813448081e+11', '1.1285443e+3', 1);
    T('-2.28254e+1', '-4.9e+0', -1);
    T('-1e+0', '4.594e+0', -1);
    T('-1.07058028623e+0', '2.845e+3', -1);
    T('7.011e+1', '0e+0', 1);
    T('-4.5094e+2', '1.1459094e+3', -1);
    T('2.85e+0', '-1.45112e+4', 1);
    T('-1.09547404e+5', '-1.36411488349e+2', -1);
    T('-3.0552725e+2', '-2.837293625e+9', 1);
    T('-1.31e-5', '1.13782957e+2', -1);
    T('-2.8209016e-20', '1.18e+0', -1);
    T('-1.07667044e-19', '1e+0', -1);
    T('1.3162128667e-10', '1.2689615338e+9', -1);
    T('1.66716908e+6', '-1.2430993e-4', 1);
    T('1.11122e-2', '-3.77323705304e+7', 1);
    T('-7e+0', '5.5865954e+4', -1);
    T('-3.15283960233e-16', '-3.2047044e-8', 1);
    T('2.0846621548e+1', '3.92e-6', 1);
    T('-2.8674e+1', '-1.31313084e-17', -1);
    T('1.8332852e-17', '1.341e+1', -1);
    T('9e+0', '-9.3e-12', 1);
    T('-4.02592028644e+5', '-1.99028e+3', -1);
    T('-1.541408372e+6', '-9.28e+0', -1);
    T('1.5e+1', '9.783799e+2', -1);
    T('-8e+0', '2.047e-7', -1);
    T('1.81e+2', '1.43604e-20', 1);
    T('0e+0', '-4.9101e+4', 1);
    T('-1.78049643e+0', '-4.45673358e+0', 1);
    T('1.722535667e+1', '-8.19890866e-9', 1);
    T('-6.356e+3', '-2.77223e+2', -1);
    T('-8.13e+0', '-1.3129112e+7', 1);
    T('-6.2012143e-7', '-4.08330939e+4', 1);
    T('-2.11991e+0', '4.592978e+2', -1);
    T('-4.773043e+3', '-1.0842355e+2', -1);
    T('-9.894928e+0', '6.1e-4', -1);
    T('-8.7990384e-10', '-7.1295894e+6', 1);
    T('-9.44946188e-18', '2e+1', -1);
    T('7.76614e+0', '1.065670038e-20', 1);
    T('-4.9149e+2', '1.347155498e+9', -1);
    T('-2.869032e+1', '-5.892838e+4', 1);
    T('-5.6497e+4', '2.2954968e+8', -1);
    T('-7.75e+2', '-3.45480796e+0', -1);
    T('-3.3e+0', '-6.836e+1', 1);
    T('-4.6e+0', '-6.92355437e-8', -1);
    T('0e+0', '-9.3e-10', 1);
    T('-2.5751542e-13', '-7.26665e+5', 1);
    T('-9.1e-19', '-2.22e-1', 1);
    T('-3.0422594e+4', '-1.83546441e+8', 1);
    T('-2.15991727483e-12', '3.70254e+2', -1);
    T('-1.310483e+2', '-1.00310363e+0', -1);
    T('1.272382447e+3', '1.54639612e+8', -1);
    T('-8.6e-16', '1.800458e+6', -1);
    T('3.7121867683e-11', '1.041097e-12', 1);
    T('2.1025817638e+1', '1.7e+0', 1);
    T('-3.282377e-1', '0e+0', -1);
    T('1.6002692836e+7', '5.2967e+3', 1);
    T('-6.59716e+5', '-1.499e+1', -1);
    T('-1.489486e+3', '-2.496418887e+5', 1);
    T('1.191e-18', '1.12654e+1', -1);
    T('-1.28e+2', '1.3e+0', -1);
    T('3.319e+3', '-7.45877113531e+11', 1);
    T('-2.28982321e+8', '2.01314e-19', -1);
    T('-5.569624e+5', '-3.737525683e-9', -1);
    T('2.510676e-10', '2.3795e-11', 1);
    T('-1.26058e-7', '6.52e+1', -1);
    T('0e+0', '-1.21538e-11', 1);
    T('3.75822101026e+8', '-4.6e+1', 1);
    T('0e+0', '5.18418122608e+11', -1);
    T('-5.2e+0', '-1.522025e+1', 1);
    T('3.91627e+0', '-1e+0', 1);
    T('8.625694625e+0', '4.003945628e+5', -1);
    T('-1.5e+1', '1.0794745045e+8', -1);
    T('-6.683982e-9', '1.3286e-5', -1);
    T('2.148885316e+8', '-6.403e+3', 1);
    T('-3.393964981e+1', '1.17e+1', -1);
    T('-2.171e+0', '2.44e-19', -1);
    T('4.974e+2', '4.441821841e+1', 1);
    T('3.9772342e+7', '-1.2177e+1', 1);
    T('-5.6487205452e+10', '1.616928e+0', -1);
    T('2e+0', '-2.4219201896e+8', 1);
    T('4.1809266e+0', '3e+0', 1);
    T('3.5648124786e-6', '6.165789278e+0', -1);
    T('-6.0454e+4', '-3.3e+0', -1);
    T('-1.01e-7', '1.01747e-2', -1);
    T('-1e+0', '4.6e-9', -1);
    T('7.181192e-6', '4.81e+2', -1);
    T('-2.14830776492e+11', '1.56e+2', -1);
    T('-1.60213948e-3', '5.539e+3', -1);
    T('1.678951271e-7', '5.34118751e+7', -1);
    T('7.293818e+5', '2.373e-10', 1);
    T('9.65991e+0', '5.66e+0', 1);
    T('2.315503e-6', '-6.93e+0', 1);
    T('2.19017494955e-3', '-7.4e+1', 1);
    T('5.43469e+6', '0e+0', 1);
    T('-2.330431561e+3', '1.52623e+1', -1);
    T('8.463333e+6', '-2.4e+1', 1);
    T('-2.12e+2', '1.5278e+3', -1);
    T('-9.61324414111e+11', '1e+0', -1);
    T('5.1e+0', '-4.03e+1', 1);
    T('0e+0', '8.77053e+1', -1);
    T('2.7e+0', '-4.654243671e+4', 1);
    T('-2.61595754e+2', '3.4371351e-3', -1);
    T('1.9236e+4', '0e+0', 1);
    T('1.28744e+5', '1.588e+3', 1);
    T('-7.12124e+3', '2.63043e+5', -1);
    T('-2.87e+2', '-8.99490089e+8', 1);
    T('-9.1451e+1', '-5.621833e+6', 1);
    T('-1.458423128e+3', '2.45879369e+4', -1);
    T('-2.2e+0', '5e+0', -1);
    T('6.7158e+2', '2e+0', 1);
    T('-1.861834055e+1', '3.46e+0', -1);
    T('-1.42e-19', '-4.4399e+2', 1);
    T('-7.7995e-19', '-3.37524763e+8', 1);
    T('6.245562401e+3', '-1.9e+0', 1);
    T('-7.4396248258e+8', '1.3184e+1', -1);
    T('4.2194232e+0', '-9.5e+0', 1);
    T('-2.09763179071e+0', '-2.9462e+3', 1);
    T('8.7009653053e-4', '5.89164955e+7', -1);
    T('-7.256717176e+1', '1.1256e+3', -1);
    T('-2e+0', '1.74987486218e+6', -1);
    T('-2.8e-2', '-9.439e+0', 1);
    T('4.3e-18', '8.421e-3', -1);
    T('-3.635286e-8', '1.27536e+2', -1);
    T('9e+0', '-8.95518866e+6', 1);
    T('7.7059164e+7', '-1.8e+0', 1);
    T('1.75973e-16', '4.9e-4', -1);
    T('-5.956e+3', '1.1918794e+1', -1);
    T('2.07e+1', '0e+0', 1);
    T('4.152e+0', '1.850529e-20', 1);
    T('4.74e+0', '-5.322106e-18', 1);
    T('1.46e+0', '-4.00403e+1', 1);
    T('2.36505254e-2', '1.22e-13', 1);
    T('5.4446e+3', '-6.5681622266e+1', 1);
    T('-5.298322e+4', '-2.662708719e+8', 1);
    T('-1.7590457129e-9', '-3.93970854954e+8', 1);
    T('5.65218e+0', '-2.996191168e+7', 1);
    T('2.9632e-6', '2.19966262214e-20', 1);
    T('-4.416e+0', '-1.813776e+4', 1);
    T('-1.974e+0', '-6.8e+0', 1);
    T('-1.287908e+5', '-9.04795615e-3', -1);
    T('-1.2376068058e+2', '1e+0', -1);
    T('-2.8599877887e+0', '0e+0', -1);
    T('1.4818911e-14', '3.170254e+4', -1);
    T('2e-13', '-1.7343311e+6', 1);
    T('-1e+0', '2.697691e+3', -1);
    T('-1.69563735921e+7', '-1.18e+0', -1);
    T('-1.221141e-16', '1.56460805e+8', -1);
    T('3e+0', '3.23926451e+3', -1);
    T('1.3233e+1', '3.15e+0', 1);
    T('-1.78284e+6', '0e+0', -1);
    T('1.9075e-5', '-6.4991913129e+1', 1);
    T('5.55554e+5', '-6.18098e+6', 1);
    T('6.271294e+6', '0e+0', 1);
    T('2.6978874e+4', '1.3646501e-2', 1);

    T('24920', '2492', 1);
    T('52923623235884.48110534', '52923623235884.4811053', 1);
    T('-1018638522.07495421826817980', '-1018638522.0749542182681798', 0);
    T('0.00000364136900', '0.0000036413690', 0);
    T('-135859105.5', '-785094047.8293510', 1);
    T('-4.1657902332676', '-4.165790233267', -1);
    T('-19727509864588.3074', '-19727509864588.307', -1);
    T('-0.0000000004020750915', '-0.000000000402075091', -1);
    T('-1387043910095766779', '-138704391009576677', -1);
    T('7.140', '7.14', 0);
    T('-0.0000000083734544824491024997299767812', '-0.000000008373454482449102499729976781', -1);
    T('-0.000000000000000000739', '-0.00000000000000000073', -1);
    T('0.000000000000000673058992451447407822', '0.00000000000000067305899245144740782', 1);
    T('107795751025937925', '10779575102593792', 1);
    T('-0.000000140098925302534364687090608708', '-0.00000014009892530253436468709060870', -1);
    T('-96807628344097344020361511087', '-9680762834409734402036151108', -1);
    T('5236305598733477493821144', '523630559873347749382114', 1);
    T('0.000012299669952207', '0.00001229966995220', 1);
    T('-0.000000000026183583081', '-0.00000000002618358308', -1);
    T('18157090114632.3949228869562', '18157090114632.394922886956', 1);
    T('-8659730.88830', '-8659730.8883', 0);
    T('92367.0595855628821', '92367.059585562882', 1);
    T('-1191', '-119', -1);
    T('0.809', '0.80', 1);
    T('0.000000000000000000518579249419024975384099', '0.00000000000000000051857924941902497538409', 1);
    T('196.516', '196.51', 1);
    T('1902.90', '1902.9', 0);
    T('0.012', '0.01', 1);
    T('2521110', '252111', 1);
    T('-24795', '-2479', -1);
    T('3134.367349', '3134.36734', 1);
    T('69006142577114620504.8', '36.0', 1);
    T('-437609971173626.98792503', '-437609971173626.9879250', -1);
    T('-36.11385408453080506', '-36.1138540845308050', -1);
    T('1686.321277', '1686.32127', 1);
    T('-84595.85616391029195941', '-84595.8561639102919594', -1);
    T('-0.00000000000308289301068', '-0.0000000000030828930106', -1);
    T('5', '273372254047642077337', -1);
    T('52666073577.1290781606630097094', '52666073577.129078160663009709', 1);
    T('0.000000000000000043918', '0.00000000000000004391', 1);
    T('-139225776437585184717785093.38', '-139225776437585184717785093.3', -1);
    T('-5584.1138579', '-5584.113857', -1);
    T('-129253519658715.0', '112386803', -1);
    T('-2290.5184387881314043589', '-2290.518438788131404358', -1);
    T('-74094153218599401.874188', '-74094153218599401.87418', -1);
    T('15.351267988724923583838', '15.35126798872492358383', 1);
    T('135.603302', '135.60330', 1);
    T('-50.57278382', '-50.5727838', -1);
    T('216.98487', '216.9848', 1);
    T('-21134.0', '-1', -1);
    T('36667803450713332911.35544', '36667803450713332911.3554', 1);
    T('-9554701478470869.90', '-9554701478470869.9', 0);
    T('-5', '-0.000000022007149864827', -1);
    T('-156737758.9503928528394581', '-156737758.950392852839458', -1);
    T('1364938.01055262931', '1364938.0105526293', 1);
    T('-439149.168324', '-439149.16832', -1);
    T('15.521233412177260268175125', '15.52123341217726026817512', 1);
    T('229652.78244076556531565167292', '229652.7824407655653156516729', 1);
    T('-3121052385.065', '-3121052385.06', -1);
    T('-717120317616.005596758', '-717120317616.00559675', -1);
    T('50773299385872514328347782', '5077329938587251432834778', 1);
    T('0.000000000000000000130149421115895602435542', '0.00000000000000000013014942111589560243554', 1);
    T('0.00000000000000002742431130831653697264', '0.0000000000000000274243113083165369726', 1);
    T('19079804604.0447062', '19079804604.044706', 1);
    T('-269212379960084901007498.0473', '-269212379960084901007498.047', -1);
    T('-0.358400680', '-0.35840068', 0);
    T('-21574492412094843183898085', '-2157449241209484318389808', -1);
    T('-71845410882550730027450926946', '-7184541088255073002745092694', -1);
    T('1544.607426323', '1544.60742632', 1);
    T('127.8549399242576867890', '127.854939924257686789', 0);
    T('-95462566651371.86749077', '-95462566651371.8674907', -1);
    T('1854469.010632854371428790793', '1854469.01063285437142879079', 1);
    T('-0.0000000000511087722639524', '-0.000000000051108772263952', -1);
    T('0', '-312658443822318131.65429523', 1);
    T('-2343445339.96760', '-2343445339.9676', 0);
    T('0.00000000000000147', '0.0000000000000014', 1);
    T('1844372.33', '1844372.3', 1);
    T('22982.419674718', '22982.41967471', 1);
    T('108594857698581658410.0737', '108594857698581658410.073', 1);
    T('-3.033420', '-3.03342', 0);
    T('55810550.26594153069059591', '55810550.2659415306905959', 1);
    T('628859628.7558', '628859628.755', 1);
    T('-547.10', '-547.1', 0);
    T('-0.0000000000000000009984305906072622822830075391', '-0.000000000000000000998430590607262282283007539', -1);
    T('-41958933743619342422791223708', '-4195893374361934242279122370', -1);
    T('-2167382.31949', '-2167382.3194', -1);
    T('-0.000000242769356', '-0.00000024276935', -1);
    T('175535', '17553', 1);
    T('13196567561552073746181107', '1319656756155207374618110', 1);
    T('-836.283', '-836.28', -1);
    T('-151.6480011', '-151.648001', -1);
    T('0.00000000000002112201668247567119900', '0.0000000000000211220166824756711990', 0);
    T('-291644372.8176', '-291644372.817', -1);
    T('2281', '228', 1);
    T('0.000000324729973', '0.00000032472997', 1);
    T('-76.8', '0.0001732215889415949412350821', -1);
    T('0.0000001164790050629621890224', '0.000000116479005062962189022', 1);
    T('-14.262813961', '-14.26281396', -1);
    T('-4785353721725589457.76', '-4785353721725589457.7', -1);
    T('-0.000000000048', '-0.00000000004', -1);
    T('-5324145565493', '-532414556549', -1);
    T('46', '-0.000000000566010149624486839', 1);
    T('-5225949604210842406679429.93784', '-5225949604210842406679429.9378', -1);
    T('-1.222170392', '-1.22217039', -1);
    T('-0.00000000000000010679843092306603352830', '-0.0000000000000001067984309230660335283', 0);
    T('-844323207816052268597', '-84432320781605226859', -1);
    T('-273294.449058068769224', '-273294.44905806876922', -1);
    T('-0.000061510623375', '-0.00006151062337', -1);
    T('-12', '-1', -1);
    T('-1146774191544920686.21847', '-1146774191544920686.2184', -1);
    T('7308692', '730869', 1);
    T('14463865367.0965', '14463865367.096', 1);
    T('0.1790976', '0.179097', 1);
    T('-0.00000088251244578915638133974523907', '-0.0000008825124457891563813397452390', -1);
    T('611.7', '0', 1);
    T('-309574907706487960682.9', '0.67178678369791512733235574', -1);
    T('-2889196478.141321900', '-2889196478.14132190', 0);
    T('163.97', '163.9', 1);
    T('-2194652189.27', '-2194652189.2', -1);
    T('-1259.4915400', '-1259.491540', 0);
    T('-30128337', '-3012833', -1);
    T('-403904222820946941.150781058', '-403904222820946941.15078105', -1);
    T('-58.2030', '-58.203', 0);
    T('126.5713124708539037', '126.571312470853903', 1);
    T('-4', '220065464', -1);
    T('1450774048.18357046', '1450774048.1835704', 1);
    T('13694997566335', '1369499756633', 1);
    T('-24.57850991168163044469', '-24.5785099116816304446', -1);
    T('-3319659536.191', '-3319659536.19', -1);
    T('10865.96', '10865.9', 1);
    T('-188510157872663341831', '-18851015787266334183', -1);
    T('62342691016946', '6234269101694', 1);
    T('-20478.3157551016331897', '-20478.315755101633189', -1);
    T('-2575595857296977614.9440249', '-2575595857296977614.944024', -1);
    T('0.00026567201697160', '0.0002656720169716', 0);
    T('-0.000000010270578723943120849114', '-0.00000001027057872394312084911', -1);
    T('0.00000022383', '0.0000002238', 1);
    T('2376696496129402852542.91945204', '2376696496129402852542.9194520', 1);
    T('0.0000000000000000001100974033101769024', '0.000000000000000000110097403310176902', 1);
    T('24448082823953.92815', '24448082823953.9281', 1);
    T('49.832437916691637221', '49.83243791669163722', 1);
    T('-10536487297762435987902669715', '-1053648729776243598790266971', -1);
    T('-296549547862779403135.41', '-296549547862779403135.4', -1);
    T('-9.5', '2.21', -1);
    T('1.98179', '1.9817', 1);
    T('-1199981732936688041', '-119998173293668804', -1);
    T('0', '-0.0000000000000000000109460230704099637262', 1);
    T('-50936625.15944921283142', '-50936625.1594492128314', -1);
    T('-0.000000000003616130540960851987251', '-0.00000000000361613054096085198725', -1);
    T('-0.000000000980270326383637798406174532', '-0.00000000098027032638363779840617453', -1);
    T('-0.0000000000000000000300003812042071861', '-0.000000000000000000030000381204207186', -1);
    T('83049889282.1', '0.00000000000001025185302485201018151409355123', 1);
    T('233131790953874220450317498.14', '233131790953874220450317498.1', 1);
    T('-3.7412702321747291', '-3.741270232174729', -1);
    T('-0.0000009922266', '-0.000000992226', -1);
    T('-1', '0.0000002780803', -1);
    T('0.0000000000002146830950262', '0.000000000000214683095026', 1);
    T('1', '-1.5071', 1);
    T('-0.000000000465117016507026272818023', '-0.00000000046511701650702627281802', -1);
    T('35.39382', '35.3938', 1);
    T('-209.660', '-209.66', 0);
    T('-90', '-9', -1);
    T('0', '-0.00692', 1);
    T('-180091979.9605073632174693529', '-180091979.960507363217469352', -1);
    T('-122272534374617365', '-12227253437461736', -1);
    T('-8572377', '-857237', -1);
    T('-0.08864728209412867534496', '-0.0886472820941286753449', -1);
    T('0.00000000000000000006218601802455410039603451124', '0.0000000000000000000621860180245541003960345112', 1);
    T('8920721679663873214715343.144', '8920721679663873214715343.14', 1);
    T('0.274427890206313529182339245', '0.27442789020631352918233924', 1);
    T('-2011471992.5', '0', -1);
    T('1599651.4112339122', '1599651.411233912', 1);
    T('8257580447850.449229990', '8257580447850.44922999', 0);
    T('-834308419.89', '-834308419.8', -1);
    T('196710676681449226960408', '19671067668144922696040', 1);
    T('-41631749783269189618702.063072', '-41631749783269189618702.06307', -1);
    T('0.00000054256828175879255377', '0.0000005425682817587925537', 1);
    T('10420033248908625.057365906', '10420033248908625.05736590', 1);
    T('33958751985671992.081663881', '33958751985671992.08166388', 1);
    T('38573.3', '-73', 1);
    T('-220.99', '-220.9', -1);
    T('0.00000000000000000006632', '0.0000000000000000000663', 1);
    T('136.8915', '136.891', 1);
    T('-42909979.8482', '-42909979.848', -1);
    T('316479242.2412', '316479242.241', 1);
    T('-36.2228569144', '-36.222856914', -1);
    T('-0.000000000000000145887', '-0.00000000000000014588', -1);
    T('-0.034420', '-0.03442', 0);
    T('-7487.2940835', '-7487.294083', -1);
    T('0.0000000001322905', '0.000000000132290', 1);
    T('4540208843067942284033465362', '454020884306794228403346536', 1);
    T('-0.00001872', '-0.0000187', -1);
    T('1.679', '1.67', 1);
    T('-0.003693', '-0.00369', -1);
    T('-73534521830291117736646922', '-7353452183029111773664692', -1);
    T('-439971017251.505', '-439971017251.50', -1);
    T('-0.00000000070562052512643', '-0.0000000007056205251264', -1);
    T('0.00000000000036078093367389488954734882', '0.0000000000003607809336738948895473488', 1);
    T('183.3930', '183.393', 0);
    T('0.000000000000000000045738234226758', '0.00000000000000000004573823422675', 1);
    T('5184478988.786158717', '5184478988.78615871', 1);
    T('1228655406.4', '-0.000000000001861', 1);
    T('5.4', '29713477480117786223897387069', -1);
    T('-31065857257211', '-3106585725721', -1);
    T('-0.0000000080362523', '-0.000000008036252', -1);
    T('52', '-4818398178.32313312', 1);
    T('44618406226893376866220.0165600', '44618406226893376866220.016560', 0);
    T('60575775575555146660699.8158363', '60575775575555146660699.815836', 1);
    T('0.000000000000000000010650670229091', '0.00000000000000000001065067022909', 1);
    T('-1.27', '-1.2', -1);
    T('-110508.5720888844', '-110508.572088884', -1);
    T('584649.40290077882', '584649.4029007788', 1);
    T('-991707393.8949', '-991707393.894', -1);
    T('-0.000000000000000005615887181289922', '-0.00000000000000000561588718128992', -1);
    T('277763471701101937737505118889', '27776347170110193773750511888', 1);
    T('0.000000000006833349812829515208501351867', '0.00000000000683334981282951520850135186', 1);
    T('0.0000000000000000000825119426382375328', '0.000000000000000000082511942638237532', 1);
    T('164214635502117894.45016275', '164214635502117894.4501627', 1);
    T('156755613767148.4684291', '156755613767148.468429', 1);
    T('337131.847212007602363066', '337131.84721200760236306', 1);
    T('-743114207120.9575', '-743114207120.957', -1);
    T('0.00097637', '0.0009763', 1);
    T('0.000000000000000016965784141152262443', '0.00000000000000001696578414115226244', 1);
    T('-0.679736199868', '-0.67973619986', -1);
    T('31059776.87593', '31059776.8759', 1);
    T('-0.00000000000315991373636284335', '-0.0000000000031599137363628433', -1);
    T('-4717725826066274081763.901', '-4717725826066274081763.90', -1);
    T('-0.00000000000000000010531404316238', '-0.0000000000000000001053140431623', -1);
    T('-0.0000000000000092308522050', '-0.000000000000009230852205', 0);
    T('-31939210155282393', '-3193921015528239', -1);
    T('234.1354842403', '234.135484240', 1);
    T('0', '25500772861644.63741880315', -1);
    T('-2820.544', '-2820.54', -1);
    T('-0.0000000000000000000171940410392', '-0.000000000000000000017194041039', -1);
    T('-3953375698956251412.549803593', '-3953375698956251412.54980359', -1);
    T('-198189130.0782001207250', '-198189130.078200120725', 0);
    T('-61352644292414307', '-6135264429241430', -1);
    T('92629.915756020804289', '92629.91575602080428', 1);
    T('2.2482', '2.248', 1);
    T('72.5680804939448786575044940949', '72.568080493944878657504494094', 1);
    T('29840260084837.110', '29840260084837.11', 0);
    T('-154554841.4372781448', '-154554841.437278144', -1);
    T('-4715870743255944543754826804', '-471587074325594454375482680', -1);
    T('0', '-673196116754.92594558368787', 1);
    T('122070161359937463835761732151', '12207016135993746383576173215', 1);
    T('0.00000000000000001992532704', '0.0000000000000000199253270', 1);
    T('186651.580960498548', '186651.58096049854', 1);
    T('2493953119584326.98694', '2493953119584326.9869', 1);
    T('0.0000000000248988460997106039259', '0.000000000024898846099710603925', 1);
    T('0.00000000126179033507144813915', '0.0000000012617903350714481391', 1);
    T('8.5210960565733', '8.521096056573', 1);
    T('-0.115997983788', '-0.11599798378', -1);
    T('116478460414160856', '11647846041416085', 1);
    T('-0.0000000000410758577068834165', '-0.000000000041075857706883416', -1);
    T('-3.877785932990082724610869253', '-3.87778593299008272461086925', -1);
    T('-1104.347468121953607708416', '-1104.34746812195360770841', -1);
    T('1788566441339035', '178856644133903', 1);
    T('-30944694030711', '-3094469403071', -1);
    T('-1', '-59318.35091346', 1);
    T('22.928', '22.92', 1);
    T('-20.365598091573148941340533554', '-20.36559809157314894134053355', -1);
    T('164432', '16443', 1);
    T('-1505.1453', '-1505.145', -1);
    T('14849.5', '-1035048221058', 1);
    T('-21813.7768933', '-21813.776893', -1);
    T('-3', '-133', 1);
    T('-0.0000000000000011616', '-0.000000000000001161', -1);
    T('289100821.7784', '289100821.778', 1);
    T('6019702.0', '-354753899721763221.19223', 1);
    T('37105.701735589966456', '37105.70173558996645', 1);
    T('15977.362', '15977.36', 1);
    T('-24795509226542636447908722', '-2479550922654263644790872', -1);
    T('-13.2', '0', -1);
    T('-0.000000000000000037701155411491341477', '-0.00000000000000003770115541149134147', -1);
    T('2513229.7', '-0.0000000000000011002329726788604366137233', 1);
    T('10760725997292.38254893708', '10760725997292.3825489370', 1);
    T('504177973263.4841942', '504177973263.484194', 1);
    T('3200.062372584607515', '3200.06237258460751', 1);
    T('-10354064661931765.3820', '-10354064661931765.382', 0);
    T('13619513905.82', '13619513905.8', 1);
    T('2', '-20.2867031651859982183', 1);
    T('-0.000000001042392150476', '-0.00000000104239215047', -1);
    T('-15943439249924914', '-1594343924992491', -1);
    T('-1012088906865956056745.1886775', '-1012088906865956056745.188677', -1);
    T('0.0000206', '0.000020', 1);
    T('-186827747346939858.7304', '-186827747346939858.730', -1);
    T('-30132095587981544870.6', '1489083.55535518931', -1);
    T('7012', '701', 1);
    T('40130924927125476099322.48103', '40130924927125476099322.4810', 1);
    T('0.0000000000000000000981', '0.000000000000000000098', 1);
    T('-19372.3055662', '-19372.305566', -1);
    T('-19.83638584167', '-19.8363858416', -1);
    T('42.6', '5178793.40712651', -1);
    T('498949500082608940888', '49894950008260894088', 1);
    T('2790925312621021.3331276', '2790925312621021.333127', 1);
    T('0.00000000000844831740749858241', '0.0000000000084483174074985824', 1);
    T('6.50', '6.5', 0);
    T('0.000003462780', '0.00000346278', 0);
    T('-751629020.898865', '-751629020.89886', -1);
    T('0.00000007309247977705', '0.0000000730924797770', 1);
    T('-0.00220406121000', '-0.0022040612100', 0);
    T('1120182731416530221572473', '112018273141653022157247', 1);
    T('-0.8347609918057479', '-0.834760991805747', -1);
    T('-5807.666472', '-5807.66647', -1);
    T('-4167388.899763015', '-4167388.89976301', -1);
    T('-401150740402834660825.50243454', '-401150740402834660825.5024345', -1);
    T('-35794.29921122403049778953976', '-35794.2992112240304977895397', -1);
    T('84431862959.2121997678178446917', '84431862959.212199767817844691', 1);
    T('-2539996.17345032025783026803138', '-2539996.1734503202578302680313', -1);
    T('0.00000000000000099705053162571348', '0.0000000000000009970505316257134', 1);
    T('23401.12855330127', '23401.1285533012', 1);
    T('8164385.3895774781453', '8164385.389577478145', 1);
    T('-0.000000000000000005992633459836508190', '-0.00000000000000000599263345983650819', 0);
    T('0.00000001336378654', '0.0000000133637865', 1);
    T('0.50994808508176183', '0.5099480850817618', 1);
    T('-1600777113482754136', '-160077711348275413', -1);
    T('-4525072.832', '-4525072.83', -1);
    T('-21', '-2', -1);
    T('268678.963124964', '268678.96312496', 1);
    T('0.0002563283407958355682202564483', '0.000256328340795835568220256448', 1);
    T('-0.001692254617913891380920881908', '-0.00169225461791389138092088190', -1);
    T('-1322598467.8998', '-1322598467.899', -1);
    T('-12041123394.9989604', '-12041123394.998960', -1);
    T('0.0000000000000195012', '0.000000000000019501', 1);
    T('-4342560023646872240660', '-434256002364687224066', -1);
    T('-35117', '-3511', -1);
    T('0.00000000000000000069551761107698717501', '0.0000000000000000006955176110769871750', 1);
    T('1185010344.148941', '1185010344.14894', 1);
    T('-0.000000000030952985207690202030601829098', '-0.00000000003095298520769020203060182909', -1);
    T('0.000000000000000582651473217774254164326212239', '0.00000000000000058265147321777425416432621223', 1);
    T('504359.80087', '504359.8008', 1);
    T('-1023', '-102', -1);
    T('-0.00000000000044602178960376487', '-0.0000000000004460217896037648', -1);
    T('-27163960789.700', '-27163960789.70', 0);
    T('9.75', '9.7', 1);
    T('15749.6', '-64114895', 1);
    T('-1.78646', '-1.7864', -1);
    T('0', '-0.0000293962545673136560132940521', 1);
    T('1568482319330379083.46066570', '1568482319330379083.4606657', 0);
    T('1.5', '0.24059486639369', 1);
    T('72631883478316528107390894.761', '72631883478316528107390894.76', 1);
    T('34.435342', '34.43534', 1);
    T('-21658874', '-2165887', -1);
    T('4.39', '4.3', 1);
    T('0.0001793758139490056488536388', '0.000179375813949005648853638', 1);
    T('0.000014078039388936962', '0.00001407803938893696', 1);
    T('0.00000000000003559010620', '0.0000000000000355901062', 0);
    T('1114593033649166', '111459303364916', 1);
    T('-839727705223987847927.8', '0.0000000000000000009297088124606271555053', -1);
    T('0.000000001093460554010662', '0.00000000109346055401066', 1);
    T('-103.512', '-103.51', -1);
    T('67798048.163', '67798048.16', 1);
    T('52308232397211107247556311601', '5230823239721110724755631160', 1);
    T('0.000000000000000001692', '0.00000000000000000169', 1);
    T('0.001001742891829562912794', '0.00100174289182956291279', 1);
    T('44854731', '4485473', 1);
    T('-142442148181118926872.0291262', '-142442148181118926872.029126', -1);
    T('-212.25', '-212.2', -1);
    T('0.00064262226396649288736045009', '0.0006426222639664928873604500', 1);
    T('-1963634914900782.3083054837942', '-1963634914900782.308305483794', -1);
    T('-29235219.36', '-29235219.3', -1);
    T('13157328.110', '13157328.11', 0);
    T('-0.00000024923670350319764405595266619', '-0.0000002492367035031976440559526661', -1);
    T('211241733874.26', '211241733874.2', 1);
    T('-0.0000000000001031601613971119366688714', '-0.000000000000103160161397111936668871', -1);
    T('-41.38924804686835819982429', '-41.3892480468683581998242', -1);
    T('-6', '-0.00000000000947293362099347980476194676305', -1);
    T('0', '2025.61', -1);
    T('4509184573.49', '4509184573.4', 1);
    T('0.00000000000000001080', '0.0000000000000000108', 0);
    T('0.000000000000000025970809826510597', '0.00000000000000002597080982651059', 1);
    T('-10487551.18', '-10487551.1', -1);
    T('-1', '-232678585.74', 1);
    T('2144754227667106756.251334', '2144754227667106756.25133', 1);
    T('11696039.4573616732', '11696039.457361673', 1);
    T('1.8', '-1197.974427959', 1);
    T('15.0', '0.14094197085256646250149695458', 1);
    T('-9911214476849.9868926', '-9911214476849.986892', -1);
    T('746601322434.3', '-2026225456262211.028', 1);
    T('33327.320', '33327.32', 0);
    T('37.45616', '37.4561', 1);
    T('1613310.79', '1613310.7', 1);
    T('-324.19116', '-324.1911', -1);
    T('-8205973490351098524', '-820597349035109852', -1);
    T('-38010778199', '-3801077819', -1);
    T('465062636441606050103294707247', '46506263644160605010329470724', 1);
    T('-234531342243689027509422607.087', '-234531342243689027509422607.08', -1);
    T('-6519.701031489886865549', '-6519.70103148988686554', -1);
    T('-27758350575381', '-2775835057538', -1);
    T('11205680254917.29959', '11205680254917.2995', 1);
    T('2037540', '203754', 1);
    T('-0.000000000143432822908384760', '-0.00000000014343282290838476', 0);
    T('-1080471500378115463.91037', '-1080471500378115463.9103', -1);
    T('11310.5806', '11310.580', 1);
    T('268.4', '4405497532754453.71', -1);
    T('-0.03269186675484629883', '-0.0326918667548462988', -1);
    T('3.0', '-1246100744', 1);
    T('-0.000009472607806448155830419', '-0.00000947260780644815583041', -1);
    T('-68623184.5', '-1870260073', 1);
    T('0.00000000115796390522683677275464134000', '0.0000000011579639052268367727546413400', 0);
    T('-0.000000001712702962512851', '-0.00000000171270296251285', -1);
    T('6963.3801375810328365724139570', '6963.380137581032836572413957', 0);
    T('0.000000000000000136327583962505', '0.00000000000000013632758396250', 1);
    T('-179275.62567103827058669819082', '-179275.6256710382705866981908', -1);
    T('0.00000218570795745319276132718732', '0.0000021857079574531927613271873', 1);
    T('68.31423316364099583801307', '68.3142331636409958380130', 1);
    T('19.5833307957304445294855674', '19.583330795730444529485567', 1);
    T('4.02', '4.0', 1);
    T('-862843', '-86284', -1);
    T('-56544409662235409.368186', '-56544409662235409.36818', -1);
    T('-0.00000000000003660585469627', '-0.0000000000000366058546962', -1);
    T('-1.863', '-1.86', -1);
    T('52501888926', '5250188892', 1);
    T('-1', '-0.00000000000000000978061879517092', -1);
    T('-0.00000000140842797026112010675644120', '-0.0000000014084279702611201067564412', 0);
    T('-8681.34675166', '-8681.3467516', -1);
    T('70986248658313756946.175', '70986248658313756946.17', 1);
    T('9087.12275147312492852', '9087.1227514731249285', 1);
    T('-1946391549304989528206958429.3', '0.00000000000000000001852761384', -1);
    T('-24991110196476816.5973432', '-24991110196476816.597343', -1);
    T('0.000000000000000012941178189261090807423', '0.00000000000000001294117818926109080742', 1);
    T('12016926398.4701744866213809', '12016926398.470174486621380', 1);
    T('3012709140.5485148192204195', '3012709140.548514819220419', 1);
    T('-0.000000000000014627930', '-0.00000000000001462793', 0);
    T('332348006.1892716773566', '332348006.189271677356', 1);
    T('-0.000000019', '-0.00000001', -1);
    T('-0.0000024642005864', '-0.000002464200586', -1);
    T('-15853920353685720', '-1585392035368572', -1);
    T('-3', '0.00334', -1);
    T('-4368864535997.00731830', '-4368864535997.0073183', 0);
    T('0.0000000000000000010', '0.000000000000000001', 0);
    T('-307303170292.614', '-307303170292.61', -1);
    T('25.45464373426403840448612', '25.4546437342640384044861', 1);
    T('942241618172218308593287', '94224161817221830859328', 1);
    T('0.00000000000000005357021085236752029646', '0.0000000000000000535702108523675202964', 1);
    T('0.000000000357348983', '0.00000000035734898', 1);
    T('-1578782291785511380364', '-157878229178551138036', -1);
    T('-76812604459187.94', '-76812604459187.9', -1);
    T('0.000000000000000000024', '0.00000000000000000002', 1);
    T('80910090177', '8091009017', 1);
    T('26196262061157.296', '26196262061157.29', 1);
    T('-2.5419448086543270', '-2.541944808654327', 0);
    T('5510.149', '5510.14', 1);
    T('240282.7241338', '240282.724133', 1);
    T('361596169011252', '36159616901125', 1);
    T('-203941370720480263273.3', '7313.9912', -1);
    T('-6425057953.0172', '-6425057953.017', -1);
    T('3529900444.00198687592090253454', '3529900444.0019868759209025345', 1);
    T('-1913233401877.8263043645', '-1913233401877.826304364', -1);
    T('0.00000000231115060509654299602960266', '0.0000000023111506050965429960296026', 1);
    T('-18819022481403295095312', '-1881902248140329509531', -1);
    T('-13790408.0512', '-13790408.051', -1);
    T('2996.67', '2996.6', 1);
    T('5', '-2364783035602699164.1934942679', 1);
    T('-794688606062', '-79468860606', -1);
    T('-15183315947.8764211541', '-15183315947.876421154', -1);
    T('15976.600931534513375', '15976.60093153451337', 1);
    T('62985782290', '6298578229', 1);
    T('-0.000000000000000136844163154210', '-0.00000000000000013684416315421', 0);
    T('9311325062667667325773987', '931132506266766732577398', 1);
    T('-251.776', '-251.77', -1);
    T('69.947', '69.94', 1);
    T('494.518135609425364940472684', '494.51813560942536494047268', 1);
    T('-0.000000000000000000770311595488584', '-0.00000000000000000077031159548858', -1);
    T('-31883468122.462112645954460826', '-31883468122.46211264595446082', -1);
    T('45164896297917952.745283345624', '45164896297917952.74528334562', 1);
    T('9.9', '6607070556969953716001823', -1);
    T('0.00000000000015847318576697', '0.0000000000001584731857669', 1);
    T('8453134914884811', '845313491488481', 1);
    T('4363007389023360.0947505417', '4363007389023360.094750541', 1);
    T('0.00000651', '0.0000065', 1);
    T('63980', '6398', 1);
    T('184865087582523954342727244.41', '184865087582523954342727244.4', 1);
    T('210', '21', 1);
    T('160857383504.45305139461', '160857383504.4530513946', 1);
    T('-68212.03884', '-68212.0388', -1);
    T('0.000000000000000000027320749051653154055', '0.00000000000000000002732074905165315405', 1);
    T('0.0000000018738126472074437195860615988', '0.000000001873812647207443719586061598', 1);
    T('-1119289980974198379.09520', '-1119289980974198379.0952', 0);
    T('0.00000000000020615568', '0.0000000000002061556', 1);
    T('24740673.0', '-19.6', 1);
    T('-0.00000000000000000008590177716950083750561846', '-0.0000000000000000000859017771695008375056184', -1);
    T('3', '381552602624', -1);
    T('-194022.047372437749', '-194022.04737243774', -1);
    T('-19.840941985', '-19.84094198', -1);
    T('786400.65729', '786400.6572', 1);
    T('-0.0000037430397514518105', '-0.000003743039751451810', -1);
    T('279955180857166858.67063', '279955180857166858.6706', 1);
    T('7.74', '7.7', 1);
    T('0.21829393131', '0.2182939313', 1);
    T('124841568240942.234680', '124841568240942.23468', 0);
    T('0.000000000000000471099502548165170284259', '0.00000000000000047109950254816517028425', 1);
    T('-99.86772739', '-99.8677273', -1);
    T('10', '41950771951.66109', -1);
    T('-0.00000000000000209702', '-0.0000000000000020970', -1);
    T('-0.000002340625428766004404187457', '-0.00000234062542876600440418745', -1);
    T('-4763.9', '2.034660667930931', -1);
    T('4038', '403', 1);
    T('9602830359170510968473768.362', '9602830359170510968473768.36', 1);
    T('1673967.68004214151', '1673967.6800421415', 1);
    T('-40724652990901152.3', '-1', -1);
    T('5.3613955', '5.361395', 1);
    T('-50544224094691571.5806233861187', '-50544224094691571.580623386118', -1);
    T('971836.46599301', '971836.4659930', 1);
    T('0.0000000000000000492654484203', '0.000000000000000049265448420', 1);
    T('0.0000000000000273350022839', '0.000000000000027335002283', 1);
    T('-0.0000000000000111187728980548441', '-0.000000000000011118772898054844', -1);
    T('240.32166914346', '240.3216691434', 1);
    T('-301.469168', '-301.46916', -1);
    T('0', '361314256851430.8380', -1);
    T('4095.137770623652511', '4095.13777062365251', 1);
    T('0.0015377038155762591158011773', '0.001537703815576259115801177', 1);
    T('-122.105313489953435', '-122.10531348995343', -1);
    T('-12529067051281794', '-1252906705128179', -1);
    T('-0.0000064280', '-0.000006428', 0);
    T('728173692003587479', '72817369200358747', 1);
    T('0.00000000005148126849474197', '0.0000000000514812684947419', 1);
    T('155032124343881936061774467.7', '71403.71', 1);
    T('5336736899935835.270053', '5336736899935835.27005', 1);
    T('174556.818526489', '174556.81852648', 1);
    T('-0.00000000529718819', '-0.0000000052971881', -1);
    T('39710699.39476764508186780', '39710699.3947676450818678', 0);
    T('-504505.226304998729', '-504505.22630499872', -1);
    T('121.845727307', '121.84572730', 1);
    T('-0.0000000000014085632', '-0.000000000001408563', -1);
    T('-53304292.806841332223', '-53304292.80684133222', -1);
    T('0.00000000000000000029', '0.0000000000000000002', 1);
    T('0.000000000000162235692', '0.00000000000016223569', 1);
    T('1124.8204793587524', '1124.820479358752', 1);
    T('1676932756858', '167693275685', 1);
    T('-138785033434702745562559175', '-13878503343470274556255917', -1);
    T('-26787241126112270.786851', '-26787241126112270.78685', -1);
    T('3.01', '3.0', 1);
    T('0.00000000000000165985383', '0.0000000000000016598538', 1);
    T('0.000000002121', '0.00000000212', 1);
    T('100065.900759', '100065.90075', 1);
    T('3.0786', '3.078', 1);
    T('1829645.4450108032076981336', '1829645.445010803207698133', 1);
    T('-31.80223', '-31.8022', -1);
    T('530006.60', '530006.6', 0);
    T('0.001298918', '0.00129891', 1);
    T('0.36635660', '0.3663566', 0);
    T('77511746654159493674.79419', '77511746654159493674.7941', 1);
    T('339255.7', '-1473225.1695489201158451', 1);
    T('1.11', '1.1', 1);
    T('-0.000000000025234359435300648563442278', '-0.00000000002523435943530064856344227', -1);
    T('-527785722956482.1568788276023', '-527785722956482.156878827602', -1);
    T('15.829063161229710883887068159', '15.82906316122971088388706815', 1);
    T('0', '9.020934402455', -1);
    T('5.50898793', '5.5089879', 1);
    T('176437906524318811079.64601', '176437906524318811079.6460', 1);
    T('-397.5475158726300', '-397.547515872630', 0);
    T('-0.00000000001556055515635481323709942', '-0.0000000000155605551563548132370994', -1);
    T('22.4958236487616739001889', '22.495823648761673900188', 1);
    T('225949901218559.6254904852', '225949901218559.625490485', 1);
    T('34352062918', '3435206291', 1);
    T('0.00000000000127995729371224', '0.0000000000012799572937122', 1);
    T('-18289597669354.148272509794', '-18289597669354.14827250979', -1);
    T('62072.9263', '62072.926', 1);
    T('-0.00000000038775267220204260640135935', '-0.0000000003877526722020426064013593', -1);
    T('15', '49854', -1);
    T('-622727179956664623.584677020', '-622727179956664623.58467702', 0);
    T('124612619885534601636883847056', '12461261988553460163688384705', 1);
    T('-44704302', '-4470430', -1);
    T('-0.0000000000007320382329813686', '-0.000000000000732038232981368', -1);
    T('57035102.20300582807941489', '57035102.2030058280794148', 1);
    T('-0.00000000001794738068861544419872319', '-0.0000000000179473806886154441987231', -1);
    T('-1.2228', '-1.222', -1);
    T('43666858484365456517278', '4366685848436545651727', 1);
    T('-0.0000000000314085', '-0.000000000031408', -1);
    T('0', '0.00000000000063486', -1);
    T('63.6991829', '63.699182', 1);
    T('-0.0000000000199308483511083746', '-0.000000000019930848351108374', -1);
    T('3.1', '-3709905843220.155177257', 1);
    T('-39631940063', '-3963194006', -1);
    T('7073142.8', '3', 1);
    T('-1999449463', '-199944946', -1);
    T('290002.761327072634018931', '290002.76132707263401893', 1);
    T('12860083520871521.6822227', '12860083520871521.682222', 1);
    T('183820.026930161', '183820.02693016', 1);
    T('0.000000781790', '0.00000078179', 0);
    T('1.446', '1.44', 1);
    T('0.0000008551572300216445253650', '0.000000855157230021644525365', 0);
    T('0.4780426111531057579684661647', '0.478042611153105757968466164', 1);
    T('-1711959015605354291', '-171195901560535429', -1);
    T('863248002669318.08600609171', '863248002669318.0860060917', 1);
    T('-1028946422414.8414841087619794', '-1028946422414.841484108761979', -1);
    T('0.0000000000000000000419470', '0.000000000000000000041947', 0);
    T('-2914967412378208104.4188038431', '-2914967412378208104.418803843', -1);
    T('-0.002008', '-0.00200', -1);
    T('-0.00000000000002626730784814031567584', '-0.0000000000000262673078481403156758', -1);
    T('-19391200616386965', '-1939120061638696', -1);
    T('15805.555288168078384', '15805.55528816807838', 1);
    T('0.000000000000000065791655', '0.00000000000000006579165', 1);
    T('-0.00000000000028926319996', '-0.0000000000002892631999', -1);
    T('-10555951879654.4116', '-10555951879654.411', -1);
    T('77254637873210650.73', '77254637873210650.7', 1);
    T('1154.7950888803119206706', '1154.795088880311920670', 1);
    T('-0.00000002121424546283688', '-0.0000000212142454628368', -1);
    T('-6884545854992086.64462961512340', '-6884545854992086.6446296151234', 0);
    T('-0.0000002787346373194072109221861494', '-0.000000278734637319407210922186149', -1);
    T('1589425692.0903352784430490711', '1589425692.090335278443049071', 1);
    T('-0.000000069284383167241482592797', '-0.00000006928438316724148259279', -1);
    T('-1297741', '-129774', -1);
    T('-82630489346849562513.319012060', '-82630489346849562513.31901206', 0);
    T('-2788.926', '-2788.92', -1);
    T('0', '-4383482151.279035955215656', 1);
    T('20802679.3368961001940047753', '20802679.336896100194004775', 1);
    T('88377599.6874', '88377599.687', 1);
    T('-15439.11', '-15439.1', -1);
    T('644', '64', 1);
    T('289240770089054460230094', '28924077008905446023009', 1);
    T('2374.044', '2374.04', 1);
    T('206285132736.429455540', '206285132736.42945554', 0);
    T('-2.655584158995322', '-2.65558415899532', -1);
    T('6.66', '6.6', 1);
    T('-0.00147702317521839535481784', '-0.0014770231752183953548178', -1);
    T('0.00025983386631037', '0.0002598338663103', 1);
    T('125878687977.170727149556144', '125878687977.17072714955614', 1);
    T('0.00000000014242990543328642932285580466', '0.0000000001424299054332864293228558046', 1);
    T('531497192.9', '-2.8789608913347', 1);
    T('128572050211770604885888', '12857205021177060488588', 1);
    T('0.00000000000049823251747441545405900232', '0.0000000000004982325174744154540590023', 1);
    T('-3554', '-355', -1);
    T('0', '-131462.704889581898753', 1);
    T('-110360.109', '-110360.10', -1);
    T('46243539.17811357252990972', '46243539.1781135725299097', 1);
    T('-394476311386474662807.561867', '-394476311386474662807.56186', -1);
    T('52032.8849384149084108910', '52032.884938414908410891', 0);
    T('-3670157142977774795911.8817', '-3670157142977774795911.881', -1);
    T('-1268380.68072308126212968448547', '-1268380.6807230812621296844854', -1);
    T('-143400922253476294484942', '-14340092225347629448494', -1);
    T('1.4797498644139485849619679', '1.479749864413948584961967', 1);
    T('3220359.45542896240415069', '3220359.4554289624041506', 1);
    T('-34.67710018368', '-34.6771001836', -1);
    T('18.565971', '18.56597', 1);
    T('-0.0000000107587', '-0.000000010758', -1);
    T('-16558604266', '-1655860426', -1);
    T('6289.6556', '6289.655', 1);
    T('1061140593553797', '106114059355379', 1);
    T('-6946576.61799943', '-6946576.6179994', -1);
    T('-3549420020.8', '-0.000000000197268526037141123595658758051', -1);
    T('-0.00000000000000045', '-0.0000000000000004', -1);
    T('3.95', '3.9', 1);
    T('0.00000000017950293191', '0.0000000001795029319', 1);
    T('-0.0000000000000002653486566279708933590491', '-0.000000000000000265348656627970893359049', -1);
    T('5834654233963853186742787.19252', '5834654233963853186742787.1925', 1);
    T('0.00000000000000146193758453924734921291', '0.0000000000000014619375845392473492129', 1);
    T('21.2', '-5466882.34678998616', 1);
    T('-226.313', '-226.31', -1);
    T('-0.00060919', '-0.0006091', -1);
    T('2862921800133731.00223602', '2862921800133731.0022360', 1);
    T('0.000001450407700996599075301', '0.00000145040770099659907530', 1);
    T('272534713642655203877194515', '27253471364265520387719451', 1);
    T('400533357.2054', '400533357.205', 1);
    T('-52301.7548455317094', '-52301.754845531709', -1);
    T('-60434', '-6043', -1);
    T('-4713231.0582649012375636764', '-4713231.058264901237563676', -1);
    T('442933.48162982928258413695403', '442933.4816298292825841369540', 1);
    T('-143913.618851426974774247273449', '-143913.61885142697477424727344', -1);
    T('257.994941295', '257.99494129', 1);
    T('-567639505016552', '-56763950501655', -1);
    T('0.000000107', '0.00000010', 1);
    T('-70142602142.0685215078078', '-70142602142.068521507807', -1);
    T('9937222087105.4475', '9937222087105.447', 1);
    T('-502191309583350641', '-50219130958335064', -1);
    T('30437.61407', '30437.6140', 1);
    T('-104085888962140304973.61065995', '-104085888962140304973.6106599', -1);
    T('74681549.65066', '74681549.6506', 1);
    T('0', '34.0', -1);
    T('1283299494621733760436152524.7', '191981915098.416203175', 1);
    T('-2079057190454275.24388611959130', '-2079057190454275.2438861195913', 0);
    T('-71969837200476.48650', '-71969837200476.4865', 0);
    T('-130332745336076.430672680', '-130332745336076.43067268', 0);
    T('-262322534.7873', '-262322534.787', -1);
    T('-4622120040.36051', '-4622120040.3605', -1);
    T('393.81', '393.8', 1);
    T('-8778932.1977656', '-8778932.197765', -1);
    T('-0.000000004319221300856935220146173063', '-0.00000000431922130085693522014617306', -1);
    T('1.3', '-2901258187734.962', 1);
    T('-16.56973', '-16.5697', -1);
    T('-30104811614630.4940925402114444', '-30104811614630.494092540211444', -1);
    T('-0.238917470430091754', '-0.23891747043009175', -1);
    T('40.82242337', '40.8224233', 1);
    T('-30694613567562.20297241', '-30694613567562.2029724', -1);
    T('-0.000000001679207115467275', '-0.00000000167920711546727', -1);
    T('-1', '10591891.719', -1);
    T('1.85299397', '1.8529939', 1);
    T('3.1', '-0.0000000010927840471796860', 1);
    T('-0.5778526120297929752108974', '-0.577852612029792975210897', -1);
    T('-0.00000002031283434', '-0.0000000203128343', -1);
    T('-1609260013071237241578458.130', '-1609260013071237241578458.13', 0);
    T('142924542265794697.6840281240', '142924542265794697.684028124', 0);
    T('445463969.1', '-0.0000000000003547121196389709462', 1);
    T('0.0000000000000000000126560009292128566', '0.000000000000000000012656000929212856', 1);
    T('41537.281211574', '41537.28121157', 1);
    T('0.000008600441757756', '0.00000860044175775', 1);
    T('-4.0918630496265', '-4.091863049626', -1);
    T('515782766783.866833275741', '515782766783.86683327574', 1);
    T('0.00000392', '0.0000039', 1);
    T('7482300.41', '7482300.4', 1);
    T('70457460459564179796739', '7045746045956417979673', 1);
    T('-13615229017824905947.22', '-13615229017824905947.2', -1);
    T('8459428653.6932870235609249397', '8459428653.693287023560924939', 1);
    T('-27.974019', '-27.97401', -1);
    T('10877384546812', '1087738454681', 1);
    T('17.146861043222', '17.14686104322', 1);
    T('-0.0000000000012741539', '-0.000000000001274153', -1);
    T('-18976303359654085296749.6386', '-18976303359654085296749.638', -1);
    T('-14105745484762.813773506', '-14105745484762.81377350', -1);
    T('-1674391.840', '-1674391.84', 0);
    T('-84922688.1007771598494556708', '-84922688.100777159849455670', -1);
    T('-12.57', '-12.5', -1);
    T('-0.00000000048', '-0.0000000004', -1);
    T('-0.00000032914110816', '-0.0000003291411081', -1);
    T('0.000000000027615548', '0.00000000002761554', 1);
    T('0.000000000460044976036', '0.00000000046004497603', 1);
    T('0.000000000000000469322464666856288338391046819', '0.00000000000000046932246466685628833839104681', 1);
    T('112.86854732363', '112.8685473236', 1);
    T('118566.37', '118566.3', 1);
    T('5014945347.21114863', '5014945347.2111486', 1);
    T('655824.126216661', '655824.12621666', 1);
    T('-53.0', '-2828707252974182.26', 1);
    T('-107852322318138.23', '-107852322318138.2', -1);
    T('817.381', '817.38', 1);
    T('-8.10721735', '-8.1072173', -1);
    T('2', '109155.92', -1);
    T('-0.09059', '-0.0905', -1);
    T('0.000000038', '0.00000003', 1);
    T('135803.4375', '135803.437', 1);
    T('-0.104981688246294', '-0.10498168824629', -1);
    T('-319117053919238717943917700', '-31911705391923871794391770', -1);
    T('-0.00000004966732670', '-0.0000000496673267', 0);
    T('0.00000000000000017556177582070698', '0.0000000000000001755617758207069', 1);
    T('-6039943363.364348624747813', '-6039943363.36434862474781', -1);
    T('-0.0768825', '-0.076882', -1);
    T('-0.00000157341483784912166430698733808', '-0.0000015734148378491216643069873380', -1);
    T('-588017', '-58801', -1);
    T('-2129041.040892', '-2129041.04089', -1);
    T('-4859858157015921288139272.0', '-281.9', -1);
    T('0.000000000000028619814741904', '0.00000000000002861981474190', 1);
    T('398.5406', '398.540', 1);
    T('-117104803640', '-11710480364', -1);
    T('-78601667654180532972556760.3008', '-78601667654180532972556760.300', -1);
    T('2228270436870143.19', '2228270436870143.1', 1);
    T('-161233', '-16123', -1);
    T('136330282209580168399263.62462', '136330282209580168399263.6246', 1);
    T('-86.44928389', '-86.4492838', -1);
    T('338.24', '338.2', 1);
    T('-14549618702.664447503248196729', '-14549618702.66444750324819672', -1);
    T('-30.6085886720119612', '-30.608588672011961', -1);
    T('-1990373027501001721683307.30225', '-1990373027501001721683307.3022', -1);
    T('1876002848.466', '1876002848.46', 1);
    T('-810.41963070149375272', '-810.4196307014937527', -1);
    T('2414021.80458', '2414021.8045', 1);
    T('-1.3248', '-1.324', -1);
    T('0.00000000000000000003281908871647629993048189', '0.0000000000000000000328190887164762999304818', 1);
    T('8190932122089709410211260.1941', '8190932122089709410211260.194', 1);
    T('18558359008664.901', '18558359008664.90', 1);
    T('-1.836260852084759052811977', '-1.83626085208475905281197', -1);
    T('52848.0661641241616642195', '52848.066164124161664219', 1);
    T('1.795', '1.79', 1);
    T('3563.84130546918276031', '3563.8413054691827603', 1);
    T('33450019.5', '2459854832688517296246058802', -1);
    T('5536285180182881.87923167404513', '5536285180182881.8792316740451', 1);
    T('0', '0.000000000000000043296465733471525299', -1);
    T('70086.68252172', '70086.6825217', 1);
    T('292760.4240', '292760.424', 0);
    T('2028140262335.9131026003356', '2028140262335.913102600335', 1);
    T('0.0000000000087', '0.000000000008', 1);
    T('4', '-3470098.6074792982', 1);
    T('13358558600177683796925578', '1335855860017768379692557', 1);
    T('-83.8', '21363730.46561184451', -1);
    T('365324.84504266484131556038', '365324.8450426648413155603', 1);
    T('-3185507140.95393405534321', '-3185507140.9539340553432', -1);
    T('-0.0000000000000065472358345', '-0.000000000000006547235834', -1);
    T('-1.1306', '-1.130', -1);
    T('0.0000000000000000012657157731644007947139831', '0.000000000000000001265715773164400794713983', 1);
    T('-4595761438.2546337711', '-4595761438.254633771', -1);
    T('8.102560', '8.10256', 0);
    T('-4732877234851.04517', '-4732877234851.0451', -1);
    T('22849746934084811', '2284974693408481', 1);
    T('-21570598205187056339788.8827687', '-21570598205187056339788.882768', -1);
    T('-0.00411486610', '-0.0041148661', 0);
    T('0.0000000017473355067071', '0.000000001747335506707', 1);
    T('1672207932406612', '167220793240661', 1);
    T('-2170952508398772659.3116947863', '-2170952508398772659.311694786', -1);
    T('104296691.3651', '104296691.365', 1);
    T('6413348457044198.6357', '6413348457044198.635', 1);
    T('867588124512790019695847208.17', '867588124512790019695847208.1', 1);
    T('0.000000000000000006377653', '0.00000000000000000637765', 1);
    T('0.0000000000000005421562844800408', '0.000000000000000542156284480040', 1);
    T('0.0000000000001734898208084', '0.000000000000173489820808', 1);
    T('719191761181325213', '71919176118132521', 1);
    T('0.02250426125915164019127', '0.0225042612591516401912', 1);
    T('0.000000000000015950471472766126156', '0.00000000000001595047147276612615', 1);
    T('-8.165141564', '-8.16514156', -1);
    T('0.000016048771130', '0.00001604877113', 0);
    T('-2', '-88807525195548174559556063', 1);
    T('58675.118464', '58675.11846', 1);
    T('0.000000627412133283', '0.00000062741213328', 1);
    T('-1292498491535.25344', '-1292498491535.2534', -1);
    T('-820304961.0323010898698', '-820304961.032301089869', -1);
    T('-0.000611', '-0.00061', -1);
    T('-11144524535537715', '-1114452453553771', -1);
    T('-55716774643252100979.5446623', '-55716774643252100979.544662', -1);
    T('-0.000044176893810056', '-0.00004417689381005', -1);
    T('292752046.323027', '292752046.32302', 1);
    T('7380730', '738073', 1);
    T('86355898012532849.7700967309940', '86355898012532849.770096730994', 0);
    T('0.00000004315310515126045613636', '0.0000000431531051512604561363', 1);
    T('0.00000000000000000001737', '0.0000000000000000000173', 1);
    T('813314317.05965', '813314317.0596', 1);
    T('0.0000000000288347370619778500827429666573', '0.000000000028834737061977850082742966657', 1);
    T('1.227', '1.22', 1);
    T('-1.2630735', '-1.263073', -1);
    T('91944402440.06945779449085371', '91944402440.0694577944908537', 1);
    T('-4449792517039894', '-444979251703989', -1);
    T('9', '-2448498702.514138316389405792', 1);
    T('15', '-230.83', 1);
    T('31.144613239645410083514841201', '31.14461323964541008351484120', 1);
    T('-19284', '-1928', -1);
    T('0', '5426339861896942660314675307', -1);
    T('1129076194', '112907619', 1);
    T('1044840688537574338326', '104484068853757433832', 1);
    T('0.00000000000000043539078118147011', '0.0000000000000004353907811814701', 1);
    T('-5', '4', -1);
    T('-1377061.5292411334', '-1377061.529241133', -1);
    T('-4.0', '332202357', -1);
    T('-0.00000000000000000227', '-0.0000000000000000022', -1);
    T('1826995888603.5824430107', '1826995888603.582443010', 1);
    T('10390673669.135717884263351', '10390673669.13571788426335', 1);
    T('10', '-735770.95921507778597', 1);
    T('104.5944497667', '104.594449766', 1);
    T('75938579086.43324', '75938579086.4332', 1);
    T('133431773944', '13343177394', 1);
    T('-0.029773', '-0.02977', -1);
    T('-2.3', '0.000000000000004812124955862392552', -1);
    T('-0.000000000000000440816280', '-0.00000000000000044081628', 0);
    T('18420.11634', '18420.1163', 1);
    T('-9284054922651501226860235.867', '-9284054922651501226860235.86', -1);
    T('12396946801121416014189.43309695', '12396946801121416014189.4330969', 1);
    T('0.007718643213656733483266', '0.00771864321365673348326', 1);
    T('-0.000000037595591491984459', '-0.00000003759559149198445', -1);
    T('-715072321926440135536.7648', '-715072321926440135536.764', -1);
    T('103992420.52458', '103992420.5245', 1);
    T('0.000000991070083580408202601308047', '0.00000099107008358040820260130804', 1);
    T('1.86853500870534570128', '1.8685350087053457012', 1);
    T('58616551.73241771152', '58616551.7324177115', 1);
    T('-1.6', '18525081582051265136724.3660', -1);
    T('1993238064975', '199323806497', 1);
    T('-1784581450011.6549586151626', '-1784581450011.654958615162', -1);
    T('-4555209568014421116848941.3959', '-4555209568014421116848941.395', -1);
    T('-7048913007.5566', '-7048913007.556', -1);
    T('-0.000000000871843054424826674157106', '-0.00000000087184305442482667415710', -1);
    T('-14840053.072', '-14840053.07', -1);
    T('-501405456751853073076', '-50140545675185307307', -1);
    T('-199545.60412498', '-199545.6041249', -1);
    T('0.00000009216303215937061205', '0.0000000921630321593706120', 1);
    T('4.71041834808516', '4.7104183480851', 1);
    T('361.419249298421346667', '361.41924929842134666', 1);
    T('409136581.554547189131', '409136581.55454718913', 1);
    T('55122849429299788341942', '5512284942929978834194', 1);
    T('13003440939757220210.6', '-131681614', 1);
    T('-1609638422403038.78', '-1609638422403038.7', -1);
     T('28363.187944820474154448061814', '-28363.187944820474154448061814', 1);
    T('-2916651.5496', '311663.7', -1);
    T('-0.000000000000028', '-1.0051639273', 1);
    T('-15087.357', '-1.94820806', -1);
    T('-0.00000000000000003599985370238339034191676', '175367726221406968.13920', -1);
    T('313569.577740085324', '-313569.577740085324', 1);
    T('4.14321707846', '-4.14321707846', 1);
    T('2.025069', '-2.025069', 1);
    T('-204173696764981798', '-348359047110101', -1);
    T('-12752947190480205615461', '15.198090402942077', -1);
    T('-74.2', '4628073528657420.923843246681', -1);
    T('719.1719040512', '-719.1719040512', 1);
    T('393.313192', '-393.313192', 1);
    T('-494455879492.541426667665550', '-13002235405592907201044204', 1);
    T('0', '0', 0);
    T('-233021.97', '-7.4', -1);
    T('-240459748', '0.000000006517712156', -1);
    T('81179.0', '-81179.0', 1);
    T('-0.0000192016725715', '-1.21890405451046803716074614', 1);
    T('-178252184222.7107', '-35038911.288687', -1);
    T('36405716.36527673752', '-36405716.36527673752', 1);
    T('-8.776', '7.7701605830015406834539038', -1);
    T('6.1', '-6.1', 1);
    T('4820089993.340', '-4820089993.340', 1);
    T('-131045153934', '-141414703667118909', 1);
    T('-0.000000000000001331938110449733777894', '-308053367.910427914340992681501', 1);
    T('-0.004193089770215420540599206921', '-30.0', 1);
    T('1694294619094634.85763668135', '-1694294619094634.85763668135', 1);
    T('40.541819234520934594813', '-40.541819234520934594813', 1);
    T('-0.10021507', '-2049541544645617700923988306', 1);
    T('6609143733354158875894', '-6609143733354158875894', 1);

    log('\n ' + passed + ' of ' + total + ' tests passed in ' + (+new Date() - start) + ' ms \n');
    return [passed, total];;
})(this.BigNumber);
if (typeof module !== 'undefined' && module.exports) module.exports = count;