var count = (function div(BigNumber) {
    var start = +new Date(),
        log,
        error,
        undefined,
        passed = 0,
        total = 0,
        n = 'null',
        N = 'NaN',
        I = 'Infinity';

    if (typeof window === 'undefined') {
        log = console.log;
        error = console.error;
    } else {
        log = function (str) { document.body.innerHTML += str.replace('\n', '<br>') };
        error = function (str) { document.body.innerHTML += '<div style="color: red">' +
          str.replace('\n', '<br>') + '</div>' };
    }

    if (!BigNumber && typeof require === 'function') BigNumber = require('../bignumber');

    function assert(expected, actual) {
        total++;
        if (expected !== actual) {
           error('\n Test number: ' + total + ' failed');
           error(' Expected: ' + expected);
           error(' Actual:   ' + actual);
           //process.exit();
        }
        else {
            passed++;
            //log('\n Expected and actual: ' + actual);
        }
    }

    function T(dividend, divisor, expected) {
        assert(String(expected), String(new BigNumber(dividend).div(divisor)));
        //assert(String(expected), String(new BigNumber(dividend).div(new BigNumber(divisor))));
    }

    function isMinusZero(n) {
        return n.toString() === '0' && n.s == -1;
    }

    log('\n Testing div...');

    BigNumber.config({
        DECIMAL_PLACES : 40,
        ROUNDING_MODE : 4,
        EXPONENTIAL_AT : [-7, 21],
        RANGE : 1E9,
        ERRORS : false
    });

    T(1, 0, I);
    T(1, -0, -I);
    T(-1, 0, -I);
    T(-1, -0, I);
    T(1, N, N);
    T(-1, N, N);
    assert(false, isMinusZero(new BigNumber(1).div(I)));
    assert(true, isMinusZero(new BigNumber(1).div(-I)));
    assert(true, isMinusZero(new BigNumber(-1).div(I)));
    assert(false, isMinusZero(new BigNumber(-1).div(-I)));
    assert(false, isMinusZero(new BigNumber(0).div(1)));
    assert(true, isMinusZero(new BigNumber(0).div(-1)));
    assert(true, isMinusZero(new BigNumber(-0).div(1)));
    assert(false, isMinusZero(new BigNumber(-0).div(-1)));
    T(0, 0, N);
    T(0, -0, N);
    T(-0, 0, N);
    T(-0, -0, N);
    T(0, N, N);
    T(-0, N, N);
    assert(false, isMinusZero(new BigNumber(0).div(I)));
    assert(true, isMinusZero(new BigNumber(0).div(-I)));
    assert(true, isMinusZero(new BigNumber(-0).div(I)));
    assert(false, isMinusZero(new BigNumber(-0).div(-I)));
    T(N, 1, N);
    T(N, -1, N);
    T(N, 0, N);
    T(N, -0, N);
    T(N, N, N);
    T(N, I, N);
    T(N, -I, N);
    T(I, 1, I);
    T(I, -1, -I);
    T(-I, 1, -I);
    T(-I, -1, I);
    T(I, 0, I);
    T(I, -0, -I);
    T(-I, 0, -I);
    T(-I, -0, I);
    T(I, N, N);
    T(-I, N, N);
    T(I, I, N);
    T(I, -I, N);
    T(-I, I, N);
    T(-I, -I, N);

    T(1, '1', '1');
    T(1, '-45', '-0.0222222222222222222222222222222222222222');
    T(1, '22', '0.0454545454545454545454545454545454545455');
    T(1, 0144, '0.01');
    T(1, '0144', '0.0069444444444444444444444444444444444444');
    T(1, '6.1915', '0.1615117499798110312525236210934345473633');
    T(1, '-1.02', '-0.9803921568627450980392156862745098039216');
    T(1, '0.09', '11.1111111111111111111111111111111111111111');
    T(1, '-0.0001', '-10000');
    T(1, '8e5', '0.00000125');
    T(1, '9E12', '1.111111111111111111111111111e-13');
    T(1, '1e-14', '100000000000000');
    T(1, '3.345E-9', '298953662.1823617339312406576980568011958146487294');
    T(1, '-345.43e+4', '-2.894942535390672495150971253220624e-7');
    T(1, '-94.12E+0', '-0.0106247343816404589885252868678283042924');
    T(1, '', N);
    T(1, '    ', N);
    T(1, '\t\t', N);
    T(1, 'ertgrt546', N);
    T(1, 'qweqwdewee', N);
    T(1, true, N);
    T(1, false, N);
    T(1, 'e 4.3', N);
    T(1, '4 .3', N);
    T(1, '4.0 01e', N);
    T(1, ' 4.001', '0.2499375156210947263184203949012746813297');
    T(1, '4.001 ', '0.2499375156210947263184203949012746813297');
    T(1, ' 4.001 ', '0.2499375156210947263184203949012746813297');
    T(1, '    4.001', '0.2499375156210947263184203949012746813297');
    T(1, ' 4.0 01', N);
    T(1, '4. 001', N);
    T(1, '4. 001 ', N);
    T(1, '  4.001e ', N);
    T(1, ' 4 .001 e ', N);
    T(1, undefined, N);
    T(1, null, N);
    T(1, I, '0');
    T(1, -I, '0');
    T(1, Number.POSITIVE_INFINITY, '0');
    T(1, Number.NEGATIVE_INFINITY, '0');
    T(1, new Date(2012, 11, 4), N);
    T(1, new Object(), N);
    T(1, function () {}, N);
    T('0', 0, N);
    T(0, '+0', N);
    T('0', '0', N);
    T(3, -0, -I);
    T(9.654, 0, I);
    T(0, '0.001', '0');
    T(0, '111.1111111110000', '0');
    T(N, 0, N);
    T(0, N, N);
    T(N, '0', N);
    T(-1, 1, '-1');
    T(-0.01, 0.01, '-1');
    T(54, -54, '-1');
    T(9.99, '-9.99', '-1');
    T('0.0000023432495704937', '-0.0000023432495704937', '-1');
    T(NaN, NaN, N);
    T(NaN, N, N);
    T(N, NaN, N);
    T(N, 4, N);
    T(N, '4534534.45435435', N);
    T(N, 99999.999, N);
    T(Infinity, '354.345341', I);
    T(3, -I, '0');              // 78
    T(-Infinity, -I, N);
    T(-I, -Infinity, N);
    T(I, '-999e999', -I);
    T(1.21123e43, -I, '0');
    T('-999.0', I, '0');
    T('657.342e-45', -I, '0');
    T(I, 123, I);
    T(-0, I, '0');
    T(100, 100, '1');
    T(-999.99, '0.01', '-99999');
    T('10 ', 4, '2.5');
    T('03.333', -4, '-0.83325');
    T(-1, -0.1, '10');
    T(43534.5435, '0.054645', '796679.3576722481471314850398023606917375789185');
    T('99999', '1', '99999');
    T('3e', 8, N);
    T('-3..0', 13, N);
    T('0 0', -0.4, N);
    T(' +3e0', 4, '0.75');
    T(9.9806, '+ 1', N);
    T(' +2 0', '1e1', N);
    T('e3', 4, N);
    T(' ', 0, N);
    T(323, null, N);
    T(undefined, undefined, N);
    T('undefined', undefined, N);
    T(null, null, N);

    BigNumber.config({DECIMAL_PLACES : 0, ROUNDING_MODE : 0});
    T('999.5', 1, '1000');
    T('-999.5', 1, '-1000');

    BigNumber.config({ROUNDING_MODE : 1});
    T('999.5', 1, '999');
    T('-999.5', 1, '-999');

    BigNumber.config({ROUNDING_MODE : 2});
    T('999.5', 1, '1000');
    T('-999.5', 1, '-999');

    BigNumber.config({ROUNDING_MODE : 3});
    T('999.5', 1, '999');
    T('-999.5', 1, '-1000');

    BigNumber.config({ROUNDING_MODE : 4});
    T('999.5', 1, '1000');
    T('-999.5', 1, '-1000');

    BigNumber.config({ROUNDING_MODE : 5});
    T('999.5', 1, '999');
    T('-999.5', 1, '-999');

    BigNumber.config({ROUNDING_MODE : 6});
    T('999.5', 1, '1000');
    T('-999.5', 1, '-1000');
    T('999.4', 1, '999');
    T('-999.4', 1, '-999');
    T('999.500001', 1, '1000');
    T('-999.500001', 1, '-1000');

    BigNumber.config({ROUNDING_MODE : 7});
    T('999.5', 1, '1000');
    T('-999.5', 1, '-999');

    BigNumber.config({ROUNDING_MODE : 8});
    T('999.5', 1, '999');
    T('-999.5', 1, '-1000');

        BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 3 });
    T('-2.8', '3', '-1');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 0 });
    T('-3', '-0.0047', '638.297872341');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 0 });
    T('15', '-3', '-5');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 2 });
    T('3', '0.38', '7.894736842106');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 4 });
    T('-2.9', '-2.2', '1.3181818181818182');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 4 });
    T('-1.20', '0.00035', '-3428.571428571');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 1 });
    T('-6', '-1.0', '6');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 5 });
    T('1.1', '-1.5', '-0.7333333');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 2 });
    T('-1.05', '-2', '0.525');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 0 });
    T('-2', '-1', '2');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 6 });
    T('-5', '1', '-5');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 1 });
    T('0.000033', '-1', '-0.000033');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 6 });
    T('6', '-3', '-2');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 2 });
    T('-1.20', '1', '-1.2');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 1 });
    T('-1', '0.0019', '-526.315');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 1 });
    T('-7', '3', '-2.333333333333');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 0 });
    T('2', '4', '0.5');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 3 });
    T('33', '-2', '-16.5');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 1 });
    T('-2', '-1', '2');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 6 });
    T('-10.2', '12', '-0.85');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 0 });
    T('-1.0', '10', '-0.1');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 3 });
    T('1.3', '-3.0', '-0.434');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 5 });
    T('1.4', '6', '0.233333333333333333');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('55', '2', '27.5');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 5 });
    T('1', '7', '0.14285714285714286');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('-1.4', '2', '-0.7');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 4 });
    T('-5', '3', '-2');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 0 });
    T('-1', '2', '-0.5');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 2 });
    T('-8', '-3', '2.67');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 4 });
    T('-16', '7', '-2.285714285714');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 6 });
    T('1', '1', '1');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 4 });
    T('0.000019', '1', '0.000019');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 6 });
    T('26', '-7.7', '-3.376623');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 4 });
    T('-5.7', '-9.1', '1');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 0 });
    T('1', '6.9', '0.144927536232');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 2 });
    T('33', '-5.5', '-6');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 2 });
    T('1.9', '1', '1.9');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 0 });
    T('-5', '0.00014', '-35714.2857142857142858');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 4 });
    T('3.0', '3', '1');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 3 });
    T('-2', '3', '-0.666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 1 });
    T('5', '3', '1.66666666666666666');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 5 });
    T('-0.000059', '-4', '0.00001475');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 6 });
    T('1.0', '3', '0.333');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 4 });
    T('2', '4', '0.5');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 4 });
    T('-6.3', '5.2', '-1.211538');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 1 });
    T('3.5', '-1.7', '-2.0588235294117647058');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 2 });
    T('3', '3', '1');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 6 });
    T('3.5', '-6', '-0.5833333333');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 4 });
    T('1', '-5.4', '0');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 3 });
    T('-3.0', '-1.5', '2');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 1 });
    T('-3', '-3', '1');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 6 });
    T('11', '1', '11');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 3 });
    T('-3.0', '-1.1', '2.7272727272727272');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 6 });
    T('-1.2', '-7', '0.2');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 2 });
    T('3', '7', '0.42857142858');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 5 });
    T('1', '2', '0.5');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 1 });
    T('-2', '-0.51', '3.92156862745098');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 1 });
    T('8', '4', '2');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 5 });
    T('1.2', '0.000016', '75000');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 2 });
    T('37', '-2.5', '-14.8');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 6 });
    T('0.015', '26', '0.00058');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 1 });
    T('6', '-91', '-0.06593406');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 4 });
    T('-3', '2', '-1.5');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 4 });
    T('1', '-19', '-0.0526315789473684211');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 3 });
    T('1.8', '3', '0.6');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 4 });
    T('-1', '-8.7', '0.114943');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 1 });
    T('-0.0056', '1', '-0.0056');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 4 });
    T('7', '0.00119', '5882.35294117647059');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('1.2', '-1.0', '-1.2');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 2 });
    T('-0.000013', '-0.38', '0.0000342105263157895');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('1', '-3', '-0.333333333333333333');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 3 });
    T('5.8', '-2.1', '-2.761904761904762');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 6 });
    T('-9', '-6.3', '1.429');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('-12', '-0.00027', '44444.444444444444');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 1 });
    T('-9', '-2', '4.5');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 5 });
    T('1', '3', '0.3333333333333');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 2 });
    T('-1', '2', '-0.5');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 4 });
    T('1', '-0.014', '-71.42857142857143');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 6 });
    T('-4', '-7', '1');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 1 });
    T('1.1', '1.2', '0.9166666666666');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('-1', '-6.1', '0.16393442622951');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 4 });
    T('5', '2.8', '1.785714285714286');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 6 });
    T('-1', '7', '-0.142857142857');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 3 });
    T('-1', '0.000016', '-62500');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 2 });
    T('-3', '-1.4', '2.14285715');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 5 });
    T('6', '1', '6');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 5 });
    T('-0.60', '-7', '0.0857142857');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('1', '3', '0.3333');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 4 });
    T('-1', '-0.0061', '163.93442622950819672131');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 1 });
    T('1.9', '-5', '-0.38');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 5 });
    T('-9.5', '-3.1', '3.06451612903');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 2 });
    T('-9', '-3', '3');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 1 });
    T('-0.00090', '-5', '0.00018');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 2 });
    T('6', '-2', '-3');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 6 });
    T('4', '10.7', '0.373831775701');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 5 });
    T('-20', '5.2', '-3.8461538461538462');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 6 });
    T('-2', '1.22', '-1.639344262295082');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 6 });
    T('-2.3', '2.5', '-0.92');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 6 });
    T('0.000123', '-1.5', '-0.0001');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 6 });
    T('-8', '1', '-8');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 1 });
    T('-1.4', '-2.2', '0.6363636363636');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 6 });
    T('7', '-3', '-2.33333333333333');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 5 });
    T('7', '-0.076', '-92.105');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 5 });
    T('-2.9', '8.0', '-0.3625');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('2', '6.6', '0.30303030303');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 6 });
    T('-8', '10.0', '-0.8');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 0 });
    T('8', '-1.1', '-7.27272727272728');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('4', '1', '4');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 3 });
    T('-6', '9', '-0.67');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 0 });
    T('1', '0.000033', '30303.03030303030303030304');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 5 });
    T('2.0', '3', '0.66666666667');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 4 });
    T('-2', '-30', '0.06666666667');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('1.8', '-1', '-1.8');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 6 });
    T('2.6', '-0.00010', '-26000');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 6 });
    T('-6.4', '-3', '2');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('-1', '8', '-0.125');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 4 });
    T('-1.00', '3', '-0.33333333333333333');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 2 });
    T('-4.0', '4', '-1');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 5 });
    T('1', '2', '0.5');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 5 });
    T('-0.00012', '8', '0');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 0 });
    T('-2.9', '5.3', '-0.5471698113207548');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 5 });
    T('-2', '3', '-0.66666666667');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 1 });
    T('-5', '-6', '0.833333333333');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 5 });
    T('97', '0.032', '3031.25');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 1 });
    T('-8', '1.7', '-4');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 5 });
    T('-1.1', '-5.5', '0');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 5 });
    T('-15', '-3', '5');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 3 });
    T('-6.1', '4', '-1.53');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 5 });
    T('-2.7', '-6.7', '0.4029850746268656716');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 6 });
    T('-4.8', '-4', '1.2');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 2 });
    T('-8', '5', '-1.6');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 1 });
    T('2', '6.1', '0.3278688524590163');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 3 });
    T('5.6', '-15', '-0.373333333334');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 1 });
    T('-3', '-4', '0.75');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 1 });
    T('1.0', '0.00018', '5555.5555');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 2 });
    T('-14', '-0.00012', '116666.6666667');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 5 });
    T('-0.0000113', '-6', '0.00000188333');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 5 });
    T('-2.0', '-7.7', '0.26');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 0 });
    T('-3', '0.0073', '-410.958904109589041096');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 1 });
    T('4.4', '-1', '-4');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 1 });
    T('-3', '-1.4', '2.14285714285714');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 5 });
    T('-2.2', '-7.6', '0.2895');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('3.8', '9.4', '0.40425531914893617');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 4 });
    T('-1', '7', '-0.14285714285714');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 6 });
    T('-5', '-4.3', '1.1627906977');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 4 });
    T('3', '2', '2');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 2 });
    T('2.7', '1', '2.7');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 2 });
    T('4', '2', '2');

    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 2 });
    T('4', '-0.0025', '-1600');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 1 });
    T('205783.0120', '-6.58', '-31274.01398176291793313069908814');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 0 });
    T('2.6', '0.0000014140003', '1838754.9139841059439662070793054287187916438207262049378631673557637');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 1 });
    T('-43506731.7020', '0.0000000000000020852', '-2.0864536592173412622290427776712065988e+22');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 5 });
    T('85374685.72', '-4602612.194', '-18.54918079591738899390748887413215766');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 0 });
    T('-11.889579111', '-7', '1.698511301571428572');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 6 });
    T('21.6', '-3', '-7.2');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 3 });
    T('-180.72', '0.0000000001581', '-1143074003795.0664136622390891840607210626185958254269449715370018976');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 1 });
    T('-0.00119467686529', '20885766', '-5.72005290727665913713674662447142230742219366050543705220100617e-11');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 1 });
    T('-0.000000015740712', '-0.0000000000000000000266', '591756090225.56');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 5 });
    T('-10', '1197', '-0.00835');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 6 });
    T('-0.0000000000000000000759363178177', '3.916', '-1.939129668480592441266598569969356486210418794688457609806e-20');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 4 });
    T('-52073715', '157.5445101', '-330533.351920334544');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 5 });
    T('-325.0', '-90', '3.6111111111111111111111111111111111');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 6 });
    T('-0.00000000000000031', '-0.0000000000000032', '0.096875');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 2 });
    T('-0.00000000879', '-5.6', '1.5696428571428571428571428571428571428571428571428571428571428571428571428571429e-9');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 2 });
    T('-0.00000251681', '127.91', '-1.96764131029630208740520678602142131185990149323743256977562348526307560003127198811664e-8');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 4 });
    T('2961036591.4', '0.000013043', '227021129448746.45403664801042704899179636586674844744307291267');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 2 });
    T('4', '3.38', '1.1834319526627218934911242603550295857988165680473372781065088757396449704142011835');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 2 });
    T('-0.0000000000001136', '0.00000000000000144185989652', '-78.7871278438211');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('11.8853', '-3', '-3.961766666666666667');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 5 });
    T('-1.20', '-9568301.017', '1.25414114571433324713095196302601858245865008826571702745166676229370972349291e-7');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 3 });
    T('0', '-6988.9', '0');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 3 });
    T('5', '-3936814629.28', '-1.2700623399468e-9');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 2 });
    T('2102712', '0.00000000000000304964', '689495153526317860468.77664248894951535263178604687766424889495153526317860468776642488949515352631786046877665');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 0 });
    T('0.00000000000000000006318187', '89048', '1e-16');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 4 });
    T('-18.472', '-2304.31', '0.00801628253143023');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 5 });
    T('0.933711', '-41.4', '-0.022553405797101');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 6 });
    T('-0.00000000159747', '-54.285323180', '2.9427290958609339534561098287634805235030747771261587614997044952657496548775267e-11');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 2 });
    T('36.0', '0.15278', '235.6329362482000261814373609111140202');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 4 });
    T('3273788', '2.0', '1636894');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 4 });
    T('-144.7', '0.000484419582', '-298707.99071042');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 2 });
    T('-0.000136434', '5.30860461610', '0');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 6 });
    T('0.00000000000027963249176', '690.93615', '0');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 4 });
    T('0.000000000000000041166', '-954146.63778', '-4.31443117546170598004200620115714474e-23');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 1 });
    T('80606.45399', '29030.6863', '2.7765948471566102796543256368003948980014296113970960445396015319141');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 1 });
    T('-307761.1715', '3', '-102587.057166666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 4 });
    T('-1.09', '-1.1', '0.990909090909090909090909090909090909090909');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 1 });
    T('-0.000000122', '1489.273', '-8.1919164585673681051090028490411093197822024e-11');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 3 });
    T('1663.22977564', '10487', '0.158599196685420043863831410317535996948603032325736626299227615142557452083');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 4 });
    T('-98', '-4242.281285', '0.023100778429405819091036534132130279051027');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 4 });
    T('0.00880312', '32.53937', '0.000270537505796823970470233443364146263434110740312427683756630813688157');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 3 });
    T('5.82', '805.9', '0.0072217396699342350167514579972701327708152');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 2 });
    T('5', '20.1', '0.2487562189054726368159203980099502487563');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 6 });
    T('-0.000000190702099115', '-0.00000000000005357223', '3559719.2634131526725693516958319636871565734709942072599927238421846542509057');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 6 });
    T('35.8812641704', '2402312', '0.00001493613825781164145206784131286860324554');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 3 });
    T('-1425073364', '-10284292.72', '138.5679504462801793918600169910371');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 3 });
    T('138823.37071', '-25036.2', '-5.5449058047946573361772153921122215032632747781212803860010704499884167725135');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 3 });
    T('-1.0', '2.7', '-0.37037037037037037037037037037037037037037037037037037037037037037037037037037037037037037037038');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 5 });
    T('29638493.73', '41.59351', '712574.96013200136271259626802354501940326748091228655624399094954958117263967383373031032966441159');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 5 });
    T('-1392357420', '65060.9365', '-21400.8204447');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 6 });
    T('-1.11047040', '0.000000226215484', '-4908905.35150104932693289907599782161684387616897170487233314232371468');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 2 });
    T('-220.431900', '1674.3721017', '-0.1316504854423901203011');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 3 });
    T('5.6685641929', '-924503127242', '-6.131471085241861e-12');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 2 });
    T('-760.5', '-5.9896920', '126.968131249486618009740734582011896438080623');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('-0.00000065', '-32268321', '2e-14');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 6 });
    T('-1.11', '104938.6447517', '-0.0000105776094462285121510625524763430267264835898746917817157441798492755443580876965212689285842');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 6 });
    T('0.0000000000000000000389', '0.000000004345746504', '8.95128143443131675128191048301422047234994450564482e-12');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 0 });
    T('-30614604.60', '-178450189969', '0.000171558262870542789273504424217640996351681502199029');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 2 });
    T('5.09', '-261.708521', '-0.019449118357135952787719892391276018101069');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 0 });
    T('-17657942.918', '0.000000000000120', '-147149524316666666666.66666666666666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 2 });
    T('-5228', '799347.8', '-0.006540332005667620527635154559754840133418769651');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 2 });
    T('949309450.95', '-1', '-949309450.95');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 1 });
    T('-122597442444', '-0.0000000000088102620620', '1.391530031470702919937729316547088199429316816614801e+22');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('-429572333.64', '-153.40', '2800341.158');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 6 });
    T('-6', '0.0023', '-2608.6956521739130434782608695652173913043478260869565217391304347826086956522');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 6 });
    T('13023138.990', '0.0000912303', '142750149785.7619672411468558143511530708547489156563115543848919');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 0 });
    T('-1', '-356.9405623', '0.002801586890423296674455874806582608445675102249369656467312');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 3 });
    T('-0.1761', '-1', '0.1761');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 6 });
    T('-0.00000000000000001080427993', '0.00000000000000000542', '-1.993409581180811808118081180811808118081180811808118081180811808118081180811808118081180811808118081');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 1 });
    T('-3', '-0.00000000000028491', '10529640939243.9717805622828261556280930820259029167105401705801832157523428');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 1 });
    T('-2.11', '-1', '2.11');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 5 });
    T('-125.8754715', '54.73', '-2.29993552896035081308240453133564772519641878311712040928193');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 6 });
    T('-0.00000138983610179', '65323.63269', '-2.127616062605718506314134992421224454104988018234477033e-11');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 6 });
    T('0.0000000627720', '2089419.6460', '3.0042792083520018744956320756256543784790276639334327384801473241244712599969494113e-14');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 0 });
    T('-217', '13400814874', '-1.6193045127503341107643153014427650841973716232087e-8');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 2 });
    T('-209172.068', '-95.8169', '2183.03940119123035706645');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 5 });
    T('722260.251', '312846', '2.309');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 6 });
    T('0.000000000000000000043026447166', '999.3474', '4.30545445617810182925377101096e-23');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 5 });
    T('0.000001001769', '0.0000000000000545377150533', '18368371.300868872296239200828462479512442900146931227723210727885333446839709498');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 4 });
    T('-21639.9', '1', '-21639.9');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 2 });
    T('-4064.98760', '-1050752806.1', '0.00000386864310654349629150136228220537701973975247040741640708905074224574083676101638345175007951');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 4 });
    T('-0.00000000000000612', '-38134.257', '1.60485623202256176120069679081462108990349543194194133636850457057548020405904329e-19');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 4 });
    T('-265049816341', '-2', '132524908170.5');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 4 });
    T('18', '1', '18');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 5 });
    T('-0.0000000922', '-282.900786', '3.259093101283e-10');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 0 });
    T('-260074626.109', '-8.200', '31716417.8181707317073170731707317073170731707317073170731708');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 4 });
    T('-0.0000000000000003606626', '121920.32', '-2.9581828525384447809848268114781851e-21');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('0.051829', '-21845698', '-2.372503731e-9');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 4 });
    T('0', '-108765478', '0');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 0 });
    T('4.06', '-81.9529', '-0.049540650788440677511106989502506927759725403249915500244652721258186104457560379193414754085');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 4 });
    T('11', '8.168', '1.34671890303623898139079333986287952987267384916748285994123408423114593535749265426053');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 4 });
    T('3.0', '-187113.5', '-0.00001603304945928540699');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 3 });
    T('0', '29.1292', '0');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 2 });
    T('-539', '1.63309627', '-330.0479034221295478190027339906911');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 3 });
    T('4.6', '9576522.7', '4.8034136649621265973712984567978938743600534670063487e-7');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('888.495', '2', '444.2475');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 6 });
    T('0.0000000660515321', '0.000000000000000000157532', '419289617982.37818348');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 5 });
    T('1194135', '19.3', '61872.2797927461139896373056994818652849740932642487046632124352331606217616580310880829015544041450777202');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('-199941187483', '1605', '-124573948.587538940809968847');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 1 });
    T('0', '-0.000000000013210', '0');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 1 });
    T('-15579.9582254', '1.82', '-8560.41660736263736263736263736263736263736263736263736263736263736263736');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 5 });
    T('0.00021763543', '0.000000000000000006304245', '34522045066459.1874205');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 1 });
    T('-9.6', '-6245', '0.001537229783827061649319455564451561248999199359487590072057646');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 4 });
    T('-1558.3541291', '-0.0000000000905501700', '17209842114045.72735755217245864916653386735773108');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 1 });
    T('-2196.0533764', '-6.3', '348.5799');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 6 });
    T('134631.169', '-0.0051', '-26398268.43137254901960784313725490196078431373');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 0 });
    T('0', '3', '0');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 0 });
    T('-81.21601', '0.000000000000000331', '-245365589123867069.4864048338368580060422960725076');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 2 });
    T('-0.18606', '-2.1', '0.0886');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 4 });
    T('-0.000000000000000000461', '-19253159', '2.394412262424052073740210632447381751742662e-26');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 3 });
    T('-929', '-424621853.40', '0.000002187828988454978092279223234156793');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 6 });
    T('2.0', '-1186150187', '-1.68612712110123370068650505553560225506249488118151769932655e-9');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 5 });
    T('0.000000000000000000522', '128362.3152', '0');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 1 });
    T('-6.08', '-930214.3174', '0.0000065361281655972929233694893030249977100599720354293484668310696547444906054936625511027637511');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 5 });
    T('-13468.73594', '-17.44', '772.28990481651376146788990826');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 0 });
    T('-4.94229', '-2', '2.471145');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('-24.40246', '35.4837273223', '-0.687708474883474291');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 1 });
    T('1', '29.98403894', '0.0333510772848536061833169430909230269296068356826913859390818947489000292767095');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 2 });
    T('-430', '1689585.07', '-0.00025450035493033801488314524464873');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 1 });
    T('3083081101.8', '-1', '-3083081101.8');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 3 });
    T('2.4', '4.3', '0.558139534883720930232558139534883720930232558139534883720930232');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 1 });
    T('467216723', '1.1', '424742475.45454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 1 });
    T('0', '-16208070.9330', '0');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 4 });
    T('-14.01', '264360777.70', '-5.2995758757748578e-8');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 1 });
    T('1', '-1', '-1');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 6 });
    T('510', '1087.241548591', '0.46907699642359095636184954255459240447481123022295185773956042018');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 6 });
    T('-522.4', '-0.0000000430', '12148837209.302325581395348837209');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 6 });
    T('-0.0001750931579', '-1641610', '1.0665941234519770225571237991971296471147e-10');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 3 });
    T('-61755625405', '-5.209793', '11853757990.9');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 0 });
    T('0.0000052665303263', '0.00000029854211122', '17.64082897644887901654');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 4 });
    T('-17926303.14', '11.395', '-1573172.7');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 1 });
    T('0', '-3.40233', '0');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 0 });
    T('-0.0000000965828945324', '1.2', '-8.04857454436666666666666666666666666666666666666666666666666666666666666666666666666666666667e-8');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 6 });
    T('-22442925.654', '20806718.15', '-1.07863842304222302353');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('0', '0.0000000000005381', '0');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 2 });
    T('-95.4860600', '92963', '-0.00102714047524283854866990092832632337596678248335359228940546238826199');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 5 });
    T('-25.24782827', '96008.9585', '-0.00026297');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 3 });
    T('38', '14576527.63', '0.000002606930879875127022964384831341344632706602978531177');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 3 });
    T('546214273620', '-2', '-273107136810');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 4 });
    T('13', '3015907', '0.0000043104777435113218');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 0 });
    T('-1.271', '-6.28', '0.202388535031847133757961783439490445859872611464968152867');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 4 });
    T('-6', '6964.78469', '-0.00086147673863');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 4 });
    T('-142.72', '-26745.79', '0.005336166925710551081123421667484863972984159376111156185702497477173042934982');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 0 });
    T('-28.0', '2363923123', '-1.1845e-8');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 5 });
    T('-91504451.175', '-18397.6177841', '4973.71193645');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 2 });
    T('-1151830', '5.2289', '-220281.5123639771271204268584214653177532559429325479546367304786857656486067815410506989997896307062670925');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 6 });
    T('0.0000000129422662', '-776', '-1.6678178092783505154639175257731958762886597938144329896907216494845360824742268041237e-11');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 1 });
    T('30323', '-0.00000000000000071420145253', '-42457208526506439363.7659352409214288776209918638766283439');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 0 });
    T('-0.000000000000000000036513', '62054611', '-1e-8');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 5 });
    T('-0.000000000000302978047', '-0.00000000000030', '1');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 3 });
    T('36.98', '-0.61069704476', '-60.5537562647497361045');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 5 });
    T('-2209843.27987', '30200516.420', '-0.07317236729126104129049856823607256713261196611021395');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 2 });
    T('-11.0', '-2.17', '5.069124423963133640552995391705069124423963133640552995391705069124423963133640552995391705069124424');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 3 });
    T('-0.000000470683', '0.000029822775', '-0.01578266945312768513325805529498848');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 2 });
    T('-198.608', '-3.933769477', '50.4879610158203482344016367484769113225797699685593447396612662');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 0 });
    T('-38294.7981', '34.2598', '-1117.77646396067694499092230544253031249452711340988563856181297030338764382745958821');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 5 });
    T('0', '27.783', '0');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 4 });
    T('-7', '-251.5', '0.02783300198807157057654076');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 1 });
    T('54335.16', '-0.000000411', '-132202335766.42335766423357664233576642335766423357664233576642335766423357664233576642');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 4 });
    T('-40946555.55', '2.60', '-15748675.211538461538461538461538');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('-198237302872', '7', '-28319614696');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 1 });
    T('0.00000000000000000005371334', '8', '6.7141675e-21');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 2 });
    T('1.5258', '-1190852944', '-1.2812665137938307855415605371337940782720187e-9');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 3 });
    T('1', '-0.00000000000000000005562070', '-17978917920846015961.6833301270929707824604868331394606684202104612131815');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 4 });
    T('-5.2', '-23421458', '2.2201862924161254179820914650146886671188446082220842101290192950413249252032047e-7');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 0 });
    T('-1416968', '195116', '-7.2622');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 1 });
    T('-2235863915', '4049', '-552201.510249444307236354655470486539886391701654729562855025932328970116');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 1 });
    T('0.000000026', '-135677754', '0');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 1 });
    T('0.000000000000000000040315579', '-2031.1', '0');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 0 });
    T('19.54706', '26', '0.75181');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 5 });
    T('-7', '777276.6629', '-0.000009005802353415800720292');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 3 });
    T('-116803.539531', '6', '-19467.2565885');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 0 });
    T('1920.573', '-2543.47', '-0.75509952938308688523945633328');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 6 });
    T('-1', '29009.081658', '-0.000034472');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 4 });
    T('0.339269187032', '124035.423', '0.00000273526045081492566845198730043432834505671819251182785098414990691812');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 3 });
    T('537169.20', '-4.69236435329', '-114477.299620471646505593344002922087290682432367736916573868681887835934263932376920317895');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 5 });
    T('0', '1', '0');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 2 });
    T('-131935099', '99727829.3', '-1.322951676839515848160549504710817966234426');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 4 });
    T('0.0000000000000000242440379', '161792.78', '1.49846228614156948165424934289404014196430767800639806e-22');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 2 });
    T('-1212.57', '8355.383', '-0.1451244066250463922479675677344');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 2 });
    T('-9.5', '-2058275.01670', '0.0000046155153820169283114828179899366894939001277535158647490181');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 3 });
    T('-7.632', '2211501.37', '-0.0001');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 1 });
    T('-0.000000000000000042828921', '-95402.2642', '4.489298169088947052474672818090202098159427121856506210677544904e-22');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 2 });
    T('-0.00001354439488', '-136.072', '9.953844200129343288847080958e-8');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('-146339.03', '-225012.7', '0.6503589797375881450247030500945057767850436886451298082286022077864938290149844875422587258408081');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 4 });
    T('0.000000000000632992', '0.000048002', '1.3186783884004833131952835298529227948835465188950460397483438190075413524436481813258e-8');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 2 });
    T('-5', '1657832.833', '-0.0000030159856292338251693920939494386283517404556072029489115565127669');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 4 });
    T('37.5', '-119757494', '-3.1313280486647457736548829253224019534009287e-7');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('-318.60', '-0.00000000000001136', '28045774647887323.943661971830985915');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 0 });
    T('811.332688', '-34.233242365', '-23.7001414984139788186');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 6 });
    T('-133201997.7', '-16558085765', '0.0080445287933921992220095255679');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 1 });
    T('0.0000000000000033574327', '-25435.385', '-1.31e-19');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 3 });
    T('-340.749462705', '0.000000000000004888', '-69711428540302782.32405891980360065466448445171849427168576104746317512274959083469721767594108019639934533552');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 5 });
    T('-11047200.46', '0.27', '-40915557.2592592592592592592592592592592593');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 2 });
    T('0.00000462644', '-26293112', '-1.75956349328295e-13');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 0 });
    T('-4432656.421', '308.63692', '-14362.04204279902741383');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 4 });
    T('7', '0.000000000000000000157', '44585987261146496815.28662420382165605095541401273885350318471337579617834');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 4 });
    T('-562908.8975', '-41412.2282', '13.59281840091859630967647377158034688894136828889588703657341480601616');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 6 });
    T('51.0770', '-0.00000000049300', '-103604462474.645030425963488843813387423935091277890466531');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 1 });
    T('-46603.49', '-7', '6657.64142857142857142857142857142857142857142857142857142857142857142857');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 5 });
    T('82292411.5750', '0.00000000000000000001936', '4.25064109375e+27');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 4 });
    T('0', '435', '0');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 6 });
    T('-1.25603776', '35257646', '-3.562454963669440665437505385356696814075e-8');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 5 });
    T('0.0000137705283114', '2102089', '6.55087787025192558450189311679952656619201185106815e-12');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 0 });
    T('-1.452', '-0.00000000000003591683', '40426730309996.7342');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 2 });
    T('2', '-136175936.0', '-1.4686882710319685263628369699621524907308145838630402364188633151748632004996829983235804599e-8');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 3 });
    T('9.219390', '650720', '0.0000141679831571182689');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 6 });
    T('-999.439', '0.000000323', '-3094238390.0928792569659442724458204334365325077399380804953560371517027863777089783281733746130030959752322');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 1 });
    T('732035039.9', '-0.000000000000000035', '-2.09152868542857142857142857142857142857142857142857142857142857142e+25');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 0 });
    T('239310308', '3.1', '77196873.5483870967741935483870967741935483870967741935483870967742');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 1 });
    T('-2746.62', '0.00000053794792', '-5105735886.1058520311780367140372993727719962185186997284049355558433');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 4 });
    T('27804.01396', '-9810.75291', '-2.8340346775689002649644755959917453471');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 6 });
    T('27.71', '0.0000000000011523', '24047557059793.456565130608348520350603141543');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 3 });
    T('-283504594', '78447408821.3', '-0.0036139446574432038958112757577688127075463618032118161382991188901351');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 1 });
    T('2774774', '-79.4027727', '-34945.5554969555867914924839897939735295918702849025321253044857462515285691');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 5 });
    T('2.50', '29.54', '0.0846310088016249153689911983750846310088016249153689912');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 0 });
    T('-26269.730773', '-1.551888', '16927.5944997319394183085377295268730733145690926149309744002144484653531698163785016');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 6 });
    T('-7339052664.8', '-14235', '515563.94');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 4 });
    T('0.00000000000000233553653', '-0.108', '0');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 6 });
    T('-0.0000000000000000008666', '47471219.4', '-1.82552715298482515913632e-26');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 5 });
    T('-1069.7', '-1004', '1.06543824701195219123505976095617529880478087649402390438247011952191235059760956175298804780876494');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 5 });
    T('-370.147', '0.0000000000000000017022491', '-217445848554127595074.069946637069744962708454');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 1 });
    T('5720.76', '-1091.4373472', '-5.24149188652576099056178');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 0 });
    T('1.82075', '-1.83', '-0.99494535519125683061');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 3 });
    T('-0.0000202', '-120999', '1.6694352845891288357755022768783213084405656245092934652352498780981661005462855e-10');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 0 });
    T('-2.383099', '0.000007206', '-330710.38023868998057174576742');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 6 });
    T('3.507', '-4', '-0.87675');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 2 });
    T('-5.4058497', '0.0000252', '-214517.84523809523809523809523809523809523809523809523809523809523809523809523809523809523');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 4 });
    T('53.7606', '1.5', '35.8404');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 1 });
    T('-472.386625', '-2133245.7', '0.0002214403268221752421673696564816701611');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 4 });
    T('-21.439', '-0.000118', '181686.4406779661016949152542372881355932203389830508474576271');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 1 });
    T('0', '7.07557', '0');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 3 });
    T('3.282', '-1.4', '-2.344285714285714285714285714285714285714285714285714285714285714285714285714285714285714285715');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 0 });
    T('0.0000000000000000001520', '-393665.3', '-3.8611480361616835418310935711123129216621327813246430407e-25');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 6 });
    T('-1.49', '-50637.5', '0.000029424833374475438');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 5 });
    T('-27957', '-0.00000000000000088964279', '31424972263305815135.0835991151010171172184737202220230436532847076746');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 2 });
    T('-47', '-0.0000000000027870669', '16863606682710.05622434108058188341298875889918537656918102683505731419651246979396152996');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 2 });
    T('0.0000000000013548773', '-40894', '-3.31314447107155083875385142e-17');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 4 });
    T('-18409.7', '0.000000000000000003349', '-5.49707375335921170498656315318005374738727978501045088086e+21');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 0 });
    T('-0.000000576194', '6781238.273', '-8.496884739976751440717293314904877992922281732659595045025e-14');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 0 });
    T('-1175147973.37', '-227632.0', '5162.49021829092570464609545230898994868911225135306108105');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 4 });
    T('2.634685', '-21.564121', '-0.1221791048195286976918743870895549139239202');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 3 });
    T('-10.499', '6', '-1.749833333333333333333333333333333333333333333333333333333333333333334');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 2 });
    T('10164.877', '1', '10164.877');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 3 });
    T('-12826.3', '0.00000000003228296', '-397308673058480.38718');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 6 });
    T('-6', '-0.00000000018569207', '32311557515.6225034273138319800086239547009196461647500617554643017335096754535613717914825334221327');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 1 });
    T('-0.0000000000000025251098436', '-1196.32', '0');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 0 });
    T('-38919054533', '2048.5', '-18998806.21576763485477178423236514522821577');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 1 });
    T('-53882', '-0.00047938018', '112399306.95507686613159517775641037140918091357051933185890163');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 5 });
    T('6.743484', '-35154451448', '-1.9e-10');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 2 });
    T('135.562', '9.5', '14.2696842105263157894736842105263157894736842105263157894736842105263157894736843');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 6 });
    T('-0.000000000000027', '-3', '9e-15');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 6 });
    T('440895409.37', '-4.244', '-103886759.983506126295947219604147031102733270499528746465598492');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 3 });
    T('-56.521', '1468243.7', '-0.000038495653003653276360048403408781');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 2 });
    T('-1', '-9.113', '0.1097333479644464');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('-8.3', '-2599.30', '0.003193167391');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 1 });
    T('522007.492', '0.00000000000003658', '14270297758337889557.135046473482');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 6 });
    T('-199.8732', '15499', '-0.012895877153364733208594102845344860958771533647332085941028453448609588');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 0 });
    T('-6', '20461.253171', '-0.000293237171245399473680164650751928277384589524758585960805127657740372523930782655776');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 1 });
    T('-4.031987', '-718944.2373', '0.00000560820546408738840864202306333723776827329748735159657979777508955909117765453713');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 3 });
    T('-13.301223979', '-1088989.879', '0.00001221427695105327971555922972');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 5 });
    T('-120.71282', '-1.6332383817', '73.91010482765707587215956253570819447023775512830883651036597482626990604723675408589');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 5 });
    T('32618.98', '-0.05105766719', '-638865.4592975343494145252');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 3 });
    T('-0.3666', '0.0000000099345', '-36901706.175449192208968745281595');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 4 });
    T('-27', '277.0', '-0.097472924187725631768953068592057761732852');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 4 });
    T('39.944', '-1', '-39.944');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 4 });
    T('960310', '-1.3', '-738700');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 2 });
    T('1083.46', '5.7', '190.080701754385964912280701754385964912280701754385964912280701754385964912280702');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 3 });
    T('0.0000000011317252', '-0.0000000000242784677', '-46.6143586153915306607261709518842492683341790964839185464740017344669573195511016537505783366');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 1 });
    T('0.00000000000000000003202048434', '-37461279.158', '-8.54762172026950196221059857488382671526926186870065554209444969428504959e-28');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 6 });
    T('-105350.008', '8302.589', '-12.6888140555');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 3 });
    T('7205.714', '1068.943458', '6.74096');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 5 });
    T('0.0000000000000001024647', '2.42438', '4.2264290252e-17');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 5 });
    T('-3323840.9', '117167158', '-0.02836836667148656110614204707431753188');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 4 });
    T('-1289.2', '-1324714.0', '0.000973191194476694592');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 6 });
    T('1.703004195', '-1', '-1.703004195');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 0 });
    T('4.735795', '-115.173571', '-0.041118764998612398672608666444839154982873631659818900639974078775416280182');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('0.00000053', '-50426083392', '-1.05104335762091621934229636709676268327383326911704322753205032418314690276868053e-17');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 5 });
    T('2.5', '-0.000000000007057964178', '-354209788679.9447567272705418369721853241176935');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 2 });
    T('-1', '-6.8', '0.147058823529411764705882352941176470588235294117647058823529411764705882352941177');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 3 });
    T('-5', '-0.0007996', '6253.1265632816408204102051025512756');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('0.000000000000013077699', '-2.3', '-5.6859560869565217391304347826086956521739130434782608695652173913043478260869565217e-15');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 5 });
    T('72500883354', '0.0749', '967969070146.8624833110814419225634178905206942590120160213618157543391188251001335113484646194926568758344');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('-0.754', '-1024768.17707', '7.35776165645408862461994055098044302504855104243406011526606548002844102407955e-7');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 2 });
    T('0.0000097840146', '1.7', '0.0000057553027058823529411764706');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 4 });
    T('147.9', '2', '73.95');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 4 });
    T('87333.5', '-3756', '-23.251730564430245');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 1 });
    T('-1508.641', '-0.0000000000000000145261483022', '103856918476559596968.42478791638561659073463014971310830350197937413978111299417764800135');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 5 });
    T('-0.000000007182', '2.6', '0');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 0 });
    T('-6', '-1.1', '5.454545454545454545454545454545454545454545454545454545454545454545455');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 3 });
    T('2', '6577.20806', '0');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 1 });
    T('-0.00000000021318134', '4229870.2971', '0');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 4 });
    T('69960189968', '-598702452', '-116.8530206186628412204999621414612145266443639018201315133414552977311006569921313768061868569063');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 2 });
    T('1', '3', '0.33333333333333333333333333333333333333333333333333333333333333333333333333333333333334');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 5 });
    T('144.0', '-3.2702', '-44.034004036450370007950584062136872362546633233441379732126475444926915784967');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 2 });
    T('3', '1542.4268', '0.001944986951730869821504657465754614740874575052767496000458498257421357045922697919928');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 3 });
    T('-434863226.9', '0.00000000000000042892', '-1.01385625967546395598246759302434020330131493052317448475240138021076191365e+24');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 5 });
    T('-9', '5.6297132122', '-1.5986604753677935495031822750866200864270021687056053835551719260986336749084605528602738');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 4 });
    T('-8.408363', '-4.6268', '1.81731715224345119737183366473588657387395176');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 4 });
    T('-1.061', '-199699007.68', '5.3129958547423464092398037898953269350567060364072811601063635290268259e-9');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 4 });
    T('-10.70', '14.8787', '-0.719148850369992001989421118780538622325875244477004039331393199674703');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 5 });
    T('-316352', '-77.54', '4079.855558421459891668816094918751612071189063709053391797781790043848336342533');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 1 });
    T('984.409', '138.1693670', '7.12465448292891144243282232016015532589072366525');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 5 });
    T('20.7946994', '-4.1047432', '-5.06601713841684420111835498016051284280098204438221616397342469560581');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 0 });
    T('1', '-5760.0', '-0.0001736111111111111111111111111111111111111111112');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 2 });
    T('658.3', '-5.3', '-124.20754716981132075');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 3 });
    T('2.2', '0.000000000000017779128', '123740601901285.59735888059301896020997205262260331327835650882315488138675867567858221168');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 5 });
    T('37440.0', '-0.00000307068092966', '-12192735376.17128134113831086');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 0 });
    T('-1.5488', '1', '-1.5488');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('-7.4', '3', '-2.4667');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 6 });
    T('-46.88587390', '6.0', '-7.8');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 1 });
    T('-0.0000000056373', '42', '-1.34221428571428e-10');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 1 });
    T('7.8', '-42', '-0.18571428');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 3 });
    T('4.067698401', '-4.73189072461', '-0.8596348981273775315827220919851782113743168705');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 3 });
    T('-0.00000323175293', '-7279', '4.439830924577551861519439483445528231899986261849155103723038878966891056463799972e-10');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 3 });
    T('-1.043726', '-0.0000000000000029332638', '355824116467124.43660880415869858005952277459667964401974346800993487186525807873127538');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 1 });
    T('-535379', '-9.279', '57697.9200344864748356503933613535941372992779394331285698889966');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 5 });
    T('-623.1', '0.0012', '-519250');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 1 });
    T('14228125', '-2', '-7114062.5');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 2 });
    T('-1', '-1456807028', '6.8643271262417330952085439829440471370378369701275219273585217767085072025065e-10');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 5 });
    T('890.53', '-177.9', '-5.0057897695334458');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 6 });
    T('-3', '13.036', '-0.2');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 0 });
    T('-2.42526431019', '124099556443', '-1.9542892655736000808165273709623777756599439032855593040517987695705627269145163e-11');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 0 });
    T('0.01089604198', '-1.19', '-0.0091563378');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 3 });
    T('1', '-32436.94', '-0.00003082904860939411');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 1 });
    T('-25350502.180', '-0.0011028', '22987397696.771853463910047152702212549873050417120058034095030830612985128763148349655422560754443');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 1 });
    T('-7.31', '-10.6390251', '0.68709303073267493278120003683420203604933688895987283646882269316198906232489290771576429498225359');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 5 });
    T('-117.1', '-0.000000000050050339264', '2339644480376.7234659598410509587549955833202481606');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 4 });
    T('-0.0000000000000000057347087', '-78280.17115', '7.33e-23');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 5 });
    T('9752917.6', '0.00000021079938541', '46266347413825.697642957848128386533325804158946764929280160750920284194011');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 6 });
    T('94.919967', '-7', '-13.559995285714285714285714');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 3 });
    T('-4.2', '26059052', '-1.61172401820296455911e-7');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 3 });
    T('43.2', '99230.61840', '0.000435349498940540715203282457826545198674283380259575203856635443481222928668153');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 4 });
    T('-0.0515', '2437300.243', '-2.1129936760113801047e-8');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 0 });
    T('0', '1851.051', '0');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 6 });
    T('1.5', '254.258', '0.005899519385820701806826137230686940037284962518386835419141187297941');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 2 });
    T('-0.00000000000000021226', '1971.308560', '-1.0767467067661898652740593e-19');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 3 });
    T('237.83', '0.00015086', '1576494.7633567546069203234787219939016306509346413893676256131512660745061646559724247646824');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 2 });
    T('-1.1', '-49.9', '0.02204408817635270541083');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 1 });
    T('-0.0000036459608843', '-35.02', '1.041108190833809251856e-7');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 0 });
    T('-6', '7759857', '-7.732101248773012183085332629196646278404357193695708567825412247e-7');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 2 });
    T('-82.15846', '-8468.52', '0.009701631453902216680128286878935162224331996618063132637107782705832896422');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 5 });
    T('-6.3', '-0.00000000000000059361951', '10612858731681510.939557899638440117980623648976766279127180304434401086312');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('314.53458', '-2.69', '-116.9274');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 1 });
    T('-0.0000000000000000065388', '-0.0000029308929', '2.23099247331760229109702e-12');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 2 });
    T('-128.87', '-5770447', '0.00002233275862337874344916433683560389689048352753261575749677624627693487177');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 1 });
    T('2.76200', '203486645550', '1.357337230919820428481184916756322243083927037589322529377161871e-11');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 5 });
    T('862.947141', '38.87', '22.20085261126833033187548237715461795729354257782351427836377669153589');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 3 });
    T('-476024', '699486.3', '-0.680533700231155349289900316846806006064736364386264605897213426481690920895');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 4 });
    T('0.00002744058', '8354.10383', '3.284682661168217729e-9');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 6 });
    T('0', '-528.932', '0');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 1 });
    T('2.4', '5', '0.48');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 5 });
    T('-87.9458', '242.4', '-0.36281270627');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 0 });
    T('-2.1', '17429886.8', '-1.2048271019178392e-7');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 5 });
    T('-610022032', '-186142.5270', '3277.1771278252819679406200389661627404');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 1 });
    T('61.0', '1', '61');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 4 });
    T('-2.68', '-2.30906614401', '1.16064236918992025908292941365354439403337618554579882928834021816012412931');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 2 });
    T('6', '20.04948435', '0.299259566742922243783292112447769760223284744976496116220565044107979764577');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 5 });
    T('-562.5474', '-2', '281.2737');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 4 });
    T('-708276.119', '-437.0985', '1620.4039112465496907447634800851524313169686008988820597645610771942708565689426982705271');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 4 });
    T('3.1', '40741823.67', '7.6088886572906813623740765652378564722211e-8');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 1 });
    T('0.478356', '-3484.06', '-0.00013729843917728167712381531890954805600362795');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 2 });
    T('-0.000000000005449', '-2196.4', '2.48087780003642323802586049899836095428883627754507375706e-15');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 5 });
    T('-1599645.6', '0.0000048', '-333259500000');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 2 });
    T('124.7', '-0.00000006670188426', '-1869512404.08631898519623619400283490582159455175786963');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 6 });
    T('1.5', '154', '0.00974');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 6 });
    T('1.5188', '6', '0.2531333333333333');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 0 });
    T('71100982.8', '2.2', '32318628.5454545454545454545454545454545454545454545454545454545454545454545455');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 6 });
    T('6579.42', '0.00000000000000001643', '400451612903225806451.6129032258064516');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 1 });
    T('0', '-1788.49', '0');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 4 });
    T('1.764', '1412.9430637', '0');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 1 });
    T('3226472.9', '-6.057428', '-532647.338111158729414530391446666803138229624850679199158454710481');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 1 });
    T('451001810', '-1.2637722', '-356869545.001860303621174765515494010708575485360415429299679166862508923681024159259081660444817507459018');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 2 });
    T('-7', '-0.0000000000000000008861615', '7899237328635920201.9045061199341203606791765');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 5 });
    T('-350', '-0.00000000000056801180312', '616184378700415.622447814038304873596796394684045733884009646070539211086666969611545138343920264274384397408505739');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 6 });
    T('0', '161224.6', '0');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 0 });
    T('-18239292.2', '9.50', '-1919925.4947368421052631578947368421052631578948');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 4 });
    T('4556.782', '8.837', '515.648070612198709969446644789');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 3 });
    T('11.7', '-637.470651', '-0.018353786141599168304298922147554680129109190942188176126715518390194876595189321116');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 0 });
    T('-0.10117999', '9.6714', '-0.010461772856049796306636060963252476373637736005128523274810265318361354095580784581342929');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 6 });
    T('366.6', '-422196.5149', '-0.00086831602597864078');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 3 });
    T('0.0000000000000447155', '-0.00000000000000033', '-135.50151515151515151515151515151515151515151515151515151515151515151515151516');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 0 });
    T('-66.96560', '-2.5010587', '26.774901364770047180420035723271908812056270410607');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('-203481271278', '-5.0', '40696254255.6');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 4 });
    T('0.00000000000025348951382', '-30.8628936590', '-8.213407226839189622080277407859891430797869373561451e-15');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 2 });
    T('-9599430918.0', '3', '-3199810306');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 6 });
    T('-0.0000000051', '63575.8', '-8.02192e-14');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 1 });
    T('-0.000000000000000204846', '-0.0085956665', '2.38313108122563852378404862496701099327201e-14');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 4 });
    T('-4194153144.00', '0.000000000000000106309', '-3.9452474804579104309136573573262846983792529324892530265546661148162432155320810091337516e+25');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 0 });
    T('4.5', '-0.00000000000000000610', '-737704918032786885.2459017');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 3 });
    T('-0.000654724', '0.458008516280', '-0.001429501803411313633838267283495849148405708330642484532798740211232999739364585');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 4 });
    T('-2.59275', '2565235.42598', '-0.00000101072594497227815802799752975209378');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 6 });
    T('-33.5', '1115627188.1', '-3.0027952309994443026249155643000593882711955395379629687244621929450089564377837e-8');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 6 });
    T('-44943.972', '-4', '11235.993');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 2 });
    T('1', '-3.2', '-0.3125');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 4 });
    T('-667305176.87', '-33285.052326', '20048.193715734283625893795748272305119524');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 6 });
    T('-30', '1215.69862', '-0.024677168754209822167931719787590118346930425897826551781394635456606835664582724');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 6 });
    T('-68.0', '-19.9', '3.41708542713567839195979899497487437185929648241206030150753768844221105527638190954773869346733668');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 1 });
    T('-83', '48.2', '-1.7219917012448132780082');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 4 });
    T('476', '-0.00000000000000000329', '-144680851063829787234.04255319149');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 1 });
    T('-613857939.8', '-1.122', '547110463.279857397504456327985');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 4 });
    T('-17.46689', '-310.8342', '0.05619359131009393432254237146362916307150242798250642947268994209774857');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 0 });
    T('-1', '36.33648', '-0.027520552348493855211071628292008471926834960348388176290053411887997956875');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 2 });
    T('-9', '-577.05236390', '0.01559650486339511900230169042376571746');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 1 });
    T('-918904792', '-53.804758', '17078504.321123421835667395809121565048206331492095922074400929375056384418641934975341771818767403432982');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 0 });
    T('-356269745137', '-1.24', '287314310594.35483870967741935483870967741935483870967741935483870967741935483870967741935483870967742');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 2 });
    T('0.0000000000178448365', '1.1664', '1.5299071073388203017832647462277091906721536351165980796e-11');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 3 });
    T('-3659760', '13', '-281520');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 1 });
    T('-44616.5788', '0.00000003071474', '-1452611313004.76578997');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 2 });
    T('989.3', '-138.07', '-7.165206054899688563771999710291880929963');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 1 });
    T('353786', '-1', '-353786');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 6 });
    T('49133.4', '695.8696375', '70.60719041646647501558795917432164153016375858186512700088886979208084790163013830302374703');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 2 });
    T('102819', '18022', '5.70519365220286316724003995117079125513261569193208300965486627455332371546');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 3 });
    T('-0.000000000000000161022', '-49.609553207', '3.24578613574934387939124984589180398179351e-18');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 3 });
    T('5', '1.5252870117', '3.27807157711733106472895038289271495800805683868395586364');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 6 });
    T('2508047', '1', '2508047');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 0 });
    T('-6', '1.25901', '-4.765649200562346605666356899468630114137298353468201205709247742273691234');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 2 });
    T('-412715.83', '0.003302680365', '-124963903.3718602072471521173076038800987633570165364761236');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 5 });
    T('-0.000089', '1294.94310595', '0');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 5 });
    T('19.32290', '-0.002176792', '-8876.77830495518175369994009533294866941811620035354778959128846486021631832531541828525646915');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 0 });
    T('0.00000000000034', '-3.7', '-9.18918918918918918918918918918918918918918918918918918918918918918919e-14');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 5 });
    T('16.8', '-94145.0351', '-0.000178448071979103229417140022926179778969565650520427709734849310178864652629993018081098999983272');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 5 });
    T('0.0000000000000059', '1.1', '5.36363636363636363636363636363636363636363636363636363636e-15');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('-1', '32148056', '0');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('9231.60239', '-0.00000000002086', '-442550450143815.915627996165');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 5 });
    T('-7', '2', '-3.5');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 4 });
    T('-123714.68', '8.55', '-14469.55321637426900584795321637426900584795321637426900584795321637426900584795321637426900584795322');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 0 });
    T('562244347.5', '-5.1529', '-109112217.877311805003008014904228686758912457063013060606649');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 1 });
    T('-5655445.0353', '-0.00000000000000068487962242', '8.257575273325650774295087253736487071929080450563889329391036373477855825500529424848002911618005152327977771285257e+21');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 6 });
    T('-2065.04620', '2876.71929082', '-0.71784765603993461664702558251675610043142582662148826560355133649661309292113');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 1 });
    T('0.118710', '69.35180', '0.001711707554814727231304739026240126427864885987097667255932794822917357588411548078059978255');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 3 });
    T('-4949594439.5', '24.7', '-200388438.84615384615384615384615384615384615384615384615384615384615384615384615384615384615384615385');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 2 });
    T('-2', '9749.6070256', '-0.000205136473167431906425945496');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 1 });
    T('-366.794', '-6.9', '53.15855072463768115942');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 2 });
    T('15.6072462699', '-1042705.4842', '-0.0000149680293298489970673542564647422');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 0 });
    T('-2398.175827', '2703681898.73', '-8.87003692308068744785119619980849787608401428534425524e-7');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 0 });
    T('2.873749', '-215659509.56', '-1.3325398939574589283880035176316664530951277750834e-8');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 3 });
    T('12090808.8357', '0.0000002724963', '44370543143888.55922080409899143584701884025581264773136');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 0 });
    T('-0.0120', '0.00000006131063428', '-195724.6102722915754509790075523583377940548684860221282969248707633');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 1 });
    T('13133', '-7.63333495', '-1720.479984963845979272794782836039443022214032413185274936743081082797237922855723761997');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 0 });
    T('-16.79', '48320.907', '-0.1');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 2 });
    T('-3', '-1437919.8', '0.000002086347235777683845788895875833965148821234675257966403967731719112568030567490620827');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 5 });
    T('4', '-0.42', '-9.5238095238095238095238095238095238095');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 6 });
    T('-6.3', '-16188.078180', '0.00038917528874943943469390879850569142729455239139449226455366674044565307381039594163857689');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 0 });
    T('0.000000000000000007370776507', '93.3983', '7.8917673094692301680009165049042648527863997524580211846e-20');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 2 });
    T('-5653.9964743', '820039.02', '-0.006');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 4 });
    T('154710952.627', '-0.000594907', '-260059055662.4816988201517211933966149330903821941916971896447680057555215');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 3 });
    T('-1.522', '-1.7', '0.895294117647058823529411764705882352941176470588235');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 3 });
    T('0.00000000000000000125', '2.5', '5e-19');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 4 });
    T('0', '-128.316591', '0');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 2 });
    T('-1', '4512938.19', '-2.2158513099422e-7');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 6 });
    T('-0.0000000024299067', '1.8', '-1.34994816666666666666666666666666666667e-9');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 3 });
    T('12082101.169', '-0.0000000005771', '-20935888353838156.2987350545832611332524692427655518974181251083002');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 1 });
    T('-2665958.79092', '745824', '-3.5745146186231604239069807354013815591882267130046767065688419788046509632299309220405886643');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 1 });
    T('-306944.315', '-4781.65', '64.19213346857256386393818033523992764004057176915918145410057197829201217153074');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 3 });
    T('119308.0', '-4.129', '-28895.131993218697021070477113102446112860256720755630903366432550254299');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 1 });
    T('-53856.0273', '748.12415', '-71.9880882070175117325112416167824551580108729279759248515102740634692784613355951682618453100331');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 3 });
    T('-8085542.2278', '2.51254505002', '-3218068.558705301076621847627555001669501965732558690115964');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 2 });
    T('-0.00000000488258276861', '-380.24', '1.284079204873237954975804754891647380601725226172943404165790027351146645e-11');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 3 });
    T('-61.48', '-0.000000930247', '66089973.9531543772782927545049863100875358910052921428394824');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 0 });
    T('-1.8', '-2.64409', '0.7');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 1 });
    T('-1179.4999', '69.50', '-16.971221582733');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 5 });
    T('1240.137064', '-1419.8', '-0.8734589829553458233554021693196');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 6 });
    T('-1445877051', '294.7427', '-4905556.782');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 1 });
    T('4.5', '-0.000000001750598', '-2570550177.7107022857332180203564724739774637009753238607607229072');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 3 });
    T('131619545056', '-3141.2', '-41901039.429518');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 6 });
    T('8170', '-2571', '-3.1777518475301439128743679502139245429793854531310774017891870867366783352781019');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 1 });
    T('-67705880.846', '-0.00000000614547821', '11017186707427931.796376835579081810787186');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 0 });
    T('6.359090', '-5.6', '-1.1355517857142858');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 5 });
    T('-9744080.9', '6', '-1624013.4833333333333333333333333333333333333333333333333333333333333');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 3 });
    T('-1671665.19505', '-2', '835832.597525');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 3 });
    T('2240.3', '240', '9.334583333333333333333333333333333333333333333333333333333');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 1 });
    T('5586', '64.7872', '86.220734959992097204386051565741381013533537488886693667');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 4 });
    T('-804808.4', '-3.995009183', '201453.4543311461519611731015137443802967098211048092101469394795130812594179711551366414');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 6 });
    T('1.2', '505814736781', '2.372410119240076265539049927193109705807743251996028e-12');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 5 });
    T('0', '14', '0');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 2 });
    T('-199014.0', '-103205852.14', '0.00192832088368433871641497');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 4 });
    T('528', '7536.724615', '0');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 0 });
    T('89.62', '-0.0000000000000509219417901', '-1759948596803578.52');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 5 });
    T('-0.00000000308815', '74280356099', '0');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 3 });
    T('319', '3.5833458', '89.022946096913113995305727959606912623392361');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 0 });
    T('5.067968', '-72', '-0.070388444444445');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 0 });
    T('458459056', '55.4', '8275434.223826714801444043321299638989169675090252707581227436823104693140794223826714801445');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 2 });
    T('32.7', '34.79', '0.9399252658810002874389192296636964645012934751365334866340902558207');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('-861.001', '12043.6083098', '-0.071490285789134739566918624565712377017111948520635871601517334161816780874067081');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 1 });
    T('2695651.6', '-0.334', '-8070813.17365');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 4 });
    T('5', '-117770.96972', '-0.000042455284285146667297051784859838547315648272646319516099506224');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 3 });
    T('0.000000000000000000016437417353', '32.45148', '5.065228874923424139669438805256339618408775192995820221e-22');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 3 });
    T('0.0000000053734', '-94.1', '-5.7103081827843e-11');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 5 });
    T('-1186721.11639', '82957.90', '-14.3051007365181616217382551872696873956549044756436698614598489113');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 0 });
    T('-21133261.89', '20730.04723', '-1019.4507352311517140716133332224926146490019357278618221459787769137658641021823');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 2 });
    T('-2.1', '-0.000000000000041693733659', '50367281020578.36383801033672737310656882469053909202456729781931857090054905317636523351783614846255139023361');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 4 });
    T('0', '14298618731', '0');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 0 });
    T('126540726', '3211409575.2', '0.039403484057968315420622216');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 0 });
    T('9.06', '0.00000000000000000045431', '19942330127005788998.70132728753494310052607250555787898131231978164689309062094164777354669718915');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 0 });
    T('1197886', '-1.33', '-900666.165413533834586466165413533834586466165413533835');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 3 });
    T('-4', '-1', '4');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 4 });
    T('535', '236221.2', '0.0022648263576681517154260498210998843456895486095');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 6 });
    T('-0.0000058900204967', '7', '-8.414314995285714285714285714285714285714285714285714e-7');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 0 });
    T('-0.059141575', '1002077673', '-5.901895291504014978687186058081148366230488801640030153630615817542518982e-11');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 2 });
    T('-16440', '1478098', '-0.011122401897573773863438012905774853900079697016030060253');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 2 });
    T('-3.729', '76.0564', '-0.049029404494559300729458664885532315492187376736211');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 0 });
    T('1296.760949', '308.368135', '4.2052365397611526884903331532617661678953955472733913');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 6 });
    T('-0.00000000000000023', '-2.7651', '8.31796318397164659505985316986727424e-17');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 3 });
    T('52121221723', '2.2157', '23523591516.45078304824660378210046486437694633750056415579726497269485941237532156');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 4 });
    T('148.848', '-11638', '-0.012789826430658188692215157243512631036260526');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 3 });
    T('0.000000000000000035252', '1.49244280', '2.3620335734140028683176333458139e-17');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 2 });
    T('-12.3048', '-74515.7391134', '0.00016513021472247941673732625');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 1 });
    T('0.00000000019260', '-187496.8', '0');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 5 });
    T('-60916544144', '-208.0', '292868000.69230769230769230769230769230769230769230769230769230769230769230769230769230769230769231');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 3 });
    T('0.000000000000000000407', '6', '6.78333333333333333333333e-20');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 5 });
    T('-701.8', '-647126995.96', '0.0000010844857414098351564619217435003698559038553759178271323991');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 4 });
    T('-156.7', '35526492', '-0.000004410792937281845896859166393349503801275960486050804002826960793089281091980598591045803228');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 2 });
    T('6.38848', '0.0575', '111.104');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 2 });
    T('113.51390', '2', '56.75695');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 0 });
    T('-1.4', '-1.04962451', '1.33381031660550685882897303913');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 3 });
    T('-0.00000000000000000914', '-24', '3.808333333333333333333333e-19');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('6089.85229', '-1', '-6089.85229');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 6 });
    T('15588.7', '-1.9450218850', '-8014.6656036212158096102862102243132343983882731478879992139522892823388462798710360012221661969');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 6 });
    T('0', '-6', '0');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 6 });
    T('4', '-2', '-2');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 0 });
    T('1.048670', '-2', '-0.524335');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 2 });
    T('5199', '-254400.9', '-0.02043624845666819574930749065746229671357294726551674935112257857578334');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 4 });
    T('24786509', '-1425028.34387', '-17.3936954');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 5 });
    T('22279280.31', '-149.356', '-149168.967500468678861244275422480516350196845121722595677');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 4 });
    T('3231', '-918986.0554', '-0.00351583136764101110646732888391115841952088884764594655458794897400790310185592');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 0 });
    T('0.00024718', '-4', '-0.000061795');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 1 });
    T('-899.2063', '10.4', '-86.4621442307692307692307692307692307692307692');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 6 });
    T('-0.000000000551809177986', '-4', '1.379522944965e-10');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 3 });
    T('0', '452738786', '0');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 4 });
    T('4.5584794351', '24609.412535', '0.000185233167537698802691065538676012933926787049977826705565');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 4 });
    T('0', '0.000000000000000055428089', '0');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 4 });
    T('1133', '8082.63993', '0.140176973094482510245882003554746994649308843');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 3 });
    T('-29.8847017', '523280.841023', '-0.000057110253915614816403990719053878399996228405389080061266854519886506500326103761351');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 2 });
    T('15361.8', '-1', '-15361.8');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 4 });
    T('-544.88204', '-167354266.6', '0.000003255859865839835');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 1 });
    T('2.1586213', '-9', '-0.2398468111111111111111111111111111');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 3 });
    T('19.7', '-98.9', '-0.1991911021233569261880687563195146612740141557128412537917087967644084934278');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 3 });
    T('-2', '2', '-1');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 2 });
    T('-1836', '751541.921', '-0.0024429774955960174575544402665463554361061383826651500921397');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 4 });
    T('-132.571758', '6265.4', '-0.0211593446547706');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 1 });
    T('-9.0', '0.18807851', '-47.85235697581823675655448355051302777760202375061350709');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 6 });
    T('-300.347779', '285.54536', '-1.051839115858860392618531780730038828156759402');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 2 });
    T('1', '46872.2687', '0.1');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 3 });
    T('6.05281', '1', '6.05281');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 4 });
    T('237492.20101', '13.91', '17073.4867728253');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 1 });
    T('348.349', '0.00000000000241', '144543153526970.95435684647302904564315352697095435684647302904564315352697095435684647302904564');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 0 });
    T('0.0000000000000199530424', '-129346.4', '-0.01');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 1 });
    T('11730.2668', '305.6706', '38.375515342332563223286766866031603955368949450814046231466159977439766');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 6 });
    T('-0.000000000062959532237', '5', '-1e-11');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 2 });
    T('6', '0.009295308411', '645.486920358623483224627779378368384941154589948548615188062531946902606113001192381845758210637');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 4 });
    T('-0.00000000000043868779', '310573.82060', '-1.412507303907636573022858321368765104472556e-18');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 3 });
    T('3.84887407', '3.8156', '1.00872053412307369745256316175699758884579096341335569766');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 3 });
    T('0.0073521', '-18.0', '-0.00040845');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 2 });
    T('0', '-747006.3486', '0');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 2 });
    T('-4.64129872300', '3', '-1.547099574333333333333333333333333333333333');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 5 });
    T('-0.000251830', '-350.0261672', '7.194604963808546e-7');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 3 });
    T('0.939', '-113.4826537', '-0.0082743923356103189187229942262092166778436905728');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 1 });
    T('-0.0000000000000000002287625269', '-2572865.5574', '8.891351755323552375523747216843208381160942e-26');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 4 });
    T('-5.2', '-1.1', '4.72727273');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 3 });
    T('1.20', '11524063.4', '1.0412993736219812883014857415657744472318678843783521704e-7');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 6 });
    T('4.65133898', '7915.0870', '0.00058765481415428535403337954465945857575538967543881703384940683532600462888153');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 0 });
    T('-3610.654', '-7.6', '475.08605263157894736842105263157894736842105263157894736842105263157894736842105263157894737');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 4 });
    T('88.4', '-11.7', '-7.55555555555555555555555555555555555555555555555555555555555555556');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 2 });
    T('0.000000000340016366031', '-6', '-5.66693943385e-11');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 3 });
    T('-3.100003841', '-492', '0.0063008208150406504065040650406504065040650406504065040650406504');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 6 });
    T('-791.9', '-0.012153', '65160.865629886');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 5 });
    T('-9', '5', '-1.8');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 2 });
    T('553.7', '22399299.800', '0.000024719522705794580239512665480730786057874898393029232102');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('-0.0000002749949', '30.759829', '-0.00001');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 3 });
    T('3624426532', '-289449190.4', '-12.52180573381904335773882337312628392827593136014520357076113625225741864780147611012285');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 4 });
    T('-0.00000000000006713', '-6617623375', '1e-23');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 6 });
    T('0', '-14.1532', '0');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 0 });
    T('-48768176.4', '999478.49486', '-48.7936225249459791063262817624562091721081695550589547579092771436841158');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 5 });
    T('278.7307', '6.329298290', '44.038167776099552419735932527837931936053530509145904071460661083805547739479347559711868154029');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 5 });
    T('488540.330', '-9732', '-50.199376284422523633374434854089601315248664201');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 3 });
    T('1064.6514', '0.244140', '4360.8232981076431555664782501843204718604079626443843696239862374047677562');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 6 });
    T('0.82', '5.96631903', '0.1374381751758252860306734217663851609356531509512658427184');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 1 });
    T('7518.490', '7841504214', '9.5880711083170757574243139978244995431433941457293974234928594530498329207e-7');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 1 });
    T('34.8855774', '-1.6026335', '-21.7676576709522170851913428740881804854322588414631292806496307483900717163343958553218');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 0 });
    T('88.6', '30', '2.9533333333333333334');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 4 });
    T('0.0000000000000000000779', '1654403.81', '4.708644862223812214262248344314439169479e-26');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 2 });
    T('-0.00000000000000000022908', '27985.1293', '0');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 0 });
    T('-0.000000000261917837552', '116.30006027', '-3e-12');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 3 });
    T('-60.00570', '-2.342', '25.621562766865926558497011101622544833475661827497865072587532023911187');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 1 });
    T('3932', '-127472', '-0.0308459897075436174218651939249403');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 4 });
    T('-1110229465.54', '-0.4365', '2543481020.71019473081328751432');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 5 });
    T('-2', '0.671', '-2.98062593');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 1 });
    T('7', '108.5443', '0.06448979817457019852723726625902972334797865940450120365601878679949108336411953460476');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 4 });
    T('0.00028', '1', '0.00028');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 4 });
    T('0.00000006557969267', '1.5680', '4.18237835905612244897959183673469388e-8');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 1 });
    T('5006041.51764', '16388224716', '0.0003054657599826873157454');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 6 });
    T('30.9', '0.000000000000000000181748', '170015626031648216211.4576226423399432180821797213724497656');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 4 });
    T('-1320.44658751', '0.00000000000131', '-1007974494282442.74809160305343511450381679389312977099236641221374045801526718');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 2 });
    T('15.2', '110597411', '1.374354052465116023375990239048181697490188084059219071592914594e-7');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 0 });
    T('23.02209072', '12.7', '1.812763048819');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 3 });
    T('-1606170.4', '4000198.6443', '-0.40152265995306987110066');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 6 });
    T('399.1459', '57.99276455', '6.88268447102337700160562530037206167299365279181194');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 3 });
    T('1.45', '-9.142', '-0.158608619558083570334718879894990155328');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 4 });
    T('-0.000000000000712649', '-66196.4', '1.07656760790617012405508456653231897807131506e-17');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 6 });
    T('2167.8637', '3693.62', '0.586921150524417779847412565450696065106859937');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 6 });
    T('1.2', '2.3', '0.521739');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 2 });
    T('4194384.4', '-123.91', '-33850.249374546041481720603663949640868372205633120813493664756678234202243563877');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 6 });
    T('-2', '12477.22', '-0.000160292116352841418200528643399731670997225343465932315050948849');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 0 });
    T('-266654.50', '208840.1304', '-1.27683553677765755695007936080085879892746898');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 3 });
    T('-1.52428704063', '282318.753228', '-0.00000539917034629');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 3 });
    T('-413.229833', '9394258', '-0.0000439874903371825640726494843978098110569243467658648506353561931128568110436');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 1 });
    T('-6.19', '180017.0', '-0.0000343856413560941466639261847492181293');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 5 });
    T('-6', '-37.31569', '0.1607902734747769637919063000041001519736068125766936106501045538753269737207056870715777');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 4 });
    T('-2878081', '-0.00000000000000000001927', '1.49355526725480020757654385054488842760768033212247016087182148417228853139595225739491437467566165023352361183186299948105864e+26');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 4 });
    T('0.00002684173572', '486.39', '5.51856241287855424659224079442422747178190341084315055819404181829396164e-8');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 6 });
    T('-11800.21', '-0.0000000000000286822600', '411411443868091287.0882559463584808170625327292898');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 5 });
    T('1', '-4.5', '-0.222222');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 3 });
    T('0', '1', '0');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 0 });
    T('0.000008990064003', '0.000000000000963602', '9329644.39986633485609203799909091097777');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 1 });
    T('43641.85475', '3089.54530', '14.12565620902208490032497662358276475182286532584584534170772637643474591552355616860513422476763');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('-14.451799345', '2167.1652870', '-0.006668526591714461');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 6 });
    T('-46.697270', '0.0000000000014693303913', '-31781327247089.9309302267203');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 4 });
    T('0.000000000000000000219884', '-335817.508212', '-6.54772293352817905519097009170681577613920908334084735788028e-25');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 4 });
    T('-103885.126', '7124.95', '-14.6');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 0 });
    T('1.10', '166668008', '6.5999468836274805661e-9');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 5 });
    T('-1091.8', '-1.8585', '587.46300780199085283831046542910949690610707559860102232983588915792305622814097390368576809255');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 6 });
    T('39.33', '4192569.2612', '0.000009380882592442358576342080442670970561090942');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 5 });
    T('-4.730032885', '-22.21', '0.2129686125619090499774876181900045024763619990995');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 6 });
    T('0.00000000000398', '-13253058.2889', '-3.003080431128428129341704642e-19');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 1 });
    T('2084.0452', '19846.7649', '0.1050067963469451890368288687694385899638484658021015807971807032389444992115566401454');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 1 });
    T('0.000000000000000000598111', '16442.86', '3.637511965679936e-23');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 6 });
    T('-0.0000000000000000000124802906', '4649.0', '-2.684510776511077651107765110776511077651107765110777e-24');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 6 });
    T('0.003816', '0.000000058238', '65524.2281671760706068202891582815343933514200350286754352828050413819156');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 2 });
    T('382.2', '194.1072', '1.96901505971957763545092608620391206508568461138999480699324909122381859096417');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 4 });
    T('-1.919', '-1', '1.919');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('-284013947424', '13.19061586', '-21531515316.52594119286254463');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 5 });
    T('228766.33934', '-0.1852617', '-1234828.026192137932449070692971078209905231356508117975815');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 5 });
    T('1', '0.0000000392', '25510204.081632653061224489795918367346938775510204');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 6 });
    T('0.0000011513', '25070.6', '4.59223153813630308010179253787304651663701706381179548953754597018021108389907e-11');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 1 });
    T('-0.00000000000002764193', '-3.1', '8.916751612903225806451612903225806451612903225806451612903225806451e-15');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 6 });
    T('-0.000000000000010416', '7274678.41', '-1.4318158704695236143091581693712286039e-21');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 4 });
    T('-2', '-30146.8', '0.000066342032985258800270675494579855905104356017885812092825772553');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 1 });
    T('173618', '1.882', '92251.8597236981934112646121147715196599362380446333687566418703506907545164718384697130712');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 0 });
    T('0.00000000010005555', '38138588465', '2.62348e-21');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 3 });
    T('-169823368', '0.0000000000000000000871132', '-1.949456201815568708301382568887378721020465325576376484849597994333809342326995220012581330957880091650864e+27');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 5 });
    T('0', '-31042328.715', '0');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 1 });
    T('-0.000000000000018273631043', '-911.9377622', '2.003824361754234635640796145550819696059297587008070933e-17');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 2 });
    T('-409295.290', '-1011.729490', '404.550123373393020302294440384454939630158');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 2 });
    T('-452668878', '-3235.300506', '139915.5587434634425887855995037513217017992825671693570958814667832898982027359162');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 3 });
    T('2082.12', '163146746', '0.0000127622527');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 1 });
    T('-8.14', '-32.560', '0.25');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 2 });
    T('0', '1.9', '0');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 3 });
    T('0', '-3', '0');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 6 });
    T('9.18', '0.0037', '2481.081081081081081081081081081081081081081081081081081081081081081081081081081081081081081');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 1 });
    T('0.00000000000000095721408982', '73.85199', '1.296124978e-17');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 0 });
    T('0', '1', '0');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 2 });
    T('48086750', '6', '8014458.33333334');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 6 });
    T('28.094', '-10.8', '-2.601296296296296296296296296296296296296296');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 6 });
    T('-28.17324441', '-2', '14.086622205');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 1 });
    T('-2227168', '2500.06', '-890.84581970032719214738846');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 3 });
    T('519.344', '0.0578325140597', '8980.138741052925991755093307758001485580365939320088236568632175956463851725330634');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 3 });
    T('-0.00000000000000000101887', '-28.546850', '3.569115331463891812932074817361635346807090799e-20');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 5 });
    T('-0.000000000000000000078301', '-1441708004.6', '5.43113e-29');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 0 });
    T('-14.74038220', '-842882140.2', '1.748807039202703467129413023953879714676626149730346368538e-8');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 1 });
    T('-2415313', '-0.000000015', '161020866666666.66666666666666666666666666666666666666666666666666666666666666666666666666666666666');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 6 });
    T('-0.0000000000000000002200', '26498.8187', '-8.30225688513427958960298860416747558637396919131e-24');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 3 });
    T('-85.27', '16086959.782', '-0.00000530056649332897548982011870364480780673092379587823849263354');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 1 });
    T('1.31592063', '5629293355', '2.3376302264140931415360569710441036342118290618023760817133680893416505915954348056888e-10');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 1 });
    T('-0.000000000001025528', '3.7', '-2.771697297297297297297297297297297297297297297297297297297297297e-13');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 3 });
    T('0', '-4.919962890', '0');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 0 });
    T('28372.374', '968909.546', '0.02928278921096');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 2 });
    T('-0.000006032019416', '2079.86', '-2.9002045406902387660707932264671660592539882492090813804775321415864529e-9');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 3 });
    T('-978638556.295', '0.0000000121699875730', '-80414096598272672.697987150196081798414832284397765');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 2 });
    T('3.18', '1.5436526', '2.060049003253712');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 2 });
    T('-227.3', '-5', '45.46');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 5 });
    T('-194', '735', '-0.26394557823129251700680272108843537414965986394557823129251700680272109');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 6 });
    T('32.421', '-17148246.867', '-0.0000018906305846570712306272748271836504346727398906415568574051366320349346531249700838588');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 0 });
    T('6.11', '343.74', '0.01777506254727410252');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 6 });
    T('34882581', '3', '11627527');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 6 });
    T('2591.34', '-0.0016', '-1619587.5');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 1 });
    T('0.0000000000000000111931173', '-543.829', '0');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 0 });
    T('51757672566', '114261.91', '452973.9837711447323085');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 6 });
    T('1.177', '19.3', '0');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 1 });
    T('1', '6', '0.1666666666666666666666666666666666666666666666666666');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 4 });
    T('-7396187255', '0.0000001129387', '-65488510625675698.4098453408796099122798473862369586333117');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 0 });
    T('354.973', '341214610.926', '0.0000010403218052025');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 4 });
    T('0.0000000000001788646', '-0.0000000000008673', '-0.20623152311772166493716130520004612014297244321457396517929205580537299665629');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 2 });
    T('-3405900332', '0.0000002821190', '-12072566300036509.41623924655907613453897114338275692172452050375905203123504620390686199795121916638014454893147');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 0 });
    T('0.000000146660215100', '6', '2.44433691833333333333333333333333333333333333333333333333333333333333333333333333333334e-8');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 3 });
    T('42.6946', '-147', '-0.2904394557823129251700680272108843537414965986394557823129251700681');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 1 });
    T('-33383.045130', '-3771.65', '8.85104533294446727559556162422282');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 6 });
    T('-0.00000002620221', '-0.0194', '0');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 1 });
    T('-40998905.3742', '21.0', '-1952328.827342857142857142857142857142857142857142857142857142857');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 4 });
    T('759.18436065', '169.2597', '4.48532261755160856364509685412');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 4 });
    T('-7.910517857', '5.48', '-1.443525156386861313868613138686131386861313868613138686131386861313868613138686131');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 1 });
    T('315514.15', '0.0000000000000000001821015', '1.732627957485248611351361740567760287531953333717734340463972015606680889503930500297910780526244978761844356e+24');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 2 });
    T('-102.1', '-20933481932.7', '4.87735391217982360935950019733431654039206201664805567083460586e-9');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 5 });
    T('1.3', '353424', '0.00000367830141699488433156774865317578885418081398');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 4 });
    T('-6', '0.0000007385', '-8124576.844955991875423155');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 1 });
    T('-882563.951', '-3391251493.78', '0.0002602472723178266294366199720356264423507358482323050873711187871051023068603836514842931325595');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 3 });
    T('-0.000000000000063741', '2062.9', '-3.0898734790828446e-17');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 5 });
    T('-0.00000000000022392247', '-2', '1.11961235e-13');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 3 });
    T('-20368.0', '-0.00000093', '21901075268.817204301075268817204301075268817204301075268817204301075268817204301075268817204');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 6 });
    T('676.6', '-1', '-676.6');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 4 });
    T('-151.10', '152.2171096', '-0.992661077306384485440262229233657712286503698004787235823324292054485312602467');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 0 });
    T('5.4', '1', '5.4');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 6 });
    T('-664.94103', '-508795.875286', '0.001306891549830723405');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('4160277.46', '51.3855092', '80962.0752');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 6 });
    T('0.068041425273', '1.0', '0.068041425273');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 6 });
    T('0', '20.9954635648', '0');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 6 });
    T('-597760.09', '-296891', '2.013399159961');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 4 });
    T('-0.000000000000466465', '-1', '4.66465e-13');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 3 });
    T('-0.012274783756', '1777103227', '-6.9071866898365606310386830443811917066537407171114207874882e-12');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 3 });
    T('43.3085', '-5812.536', '-0.00745087858380576051485960689103688992205811714542499177639501932');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 6 });
    T('0.00000000000000000006065480716', '-0.0000000000000005628236', '-0.00010776877011');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 2 });
    T('15316689.77', '-4.476', '-3421959.28731009830205540661304736371760500446827524');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 2 });
    T('-4782', '7903.4519', '-0.605052078573414231824451288');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 0 });
    T('334.247', '-12.37', '-27.02077607113985448666127728375101050929668552950687147');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 0 });
    T('-0.000000000010968817327', '1577.163203', '-6.95477634e-15');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 3 });
    T('181.28266', '-0.000000000015', '-12085510666666.666666666666666666666666666666666666666666666666666666666666666666666666666666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 1 });
    T('-12944.4', '25199', '-0.51368705107345529584');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 1 });
    T('-0.233040', '0.00000000000048', '-485500000000');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 0 });
    T('2499418471.4', '0.0000000000212061576116', '117862864040621426727.904325767922700957');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 4 });
    T('2.051', '-0.210803', '-9.7294630531823550898231998595845410169684492156183735525585');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 5 });
    T('-3', '-0.00000000000035117', '8542870974172.05342141982515590739527863997494091180909530996383517954267164051598940683999202665375743941680667');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 6 });
    T('-29.5', '170.1809179', '-0.1733449341090902648139965168209966506473990524880110544990778898602');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 5 });
    T('-920.3951776', '0.0000000000000003848321529', '-2391679517067712249.36283124174471753189103134');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 2 });
    T('1.67', '-704.1', '-0.00237182218434');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 2 });
    T('-4019.527', '-0.000000000000001282423', '3134322294593905443.0558403896374285239737590483015354528108120331591059');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 2 });
    T('0.004972447', '-313000.2188', '-1.5886401035320937609517095966962947e-8');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 1 });
    T('-240823248', '-53004225588', '0.0045434726');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 6 });
    T('-0.004435905718', '3114765775', '-1.424153865309503087756253517971186774068107898097088857e-12');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 1 });
    T('7', '310.0', '0.02258064516129032258064516129');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 2 });
    T('485.18', '-2499.59190', '-0.1941036854856186723920812833486938407825693466201422720244852769766136624142525025785209');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 2 });
    T('-1803189.79', '-95.9631755078', '18790.434774');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 3 });
    T('3', '3.13', '0.9584664536741214057507987220447');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 0 });
    T('2705932.0278', '-240850308.662', '-0.011234912019969217738265785640050126');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 5 });
    T('-48.6894', '-0.0000000000000056217500046', '8660897400304152.96991166386595034397058361146178954725410558680679758094698823811870931732181920937779724');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 5 });
    T('0.00000000967966715067', '0.00000490602307318', '0.00197301704584030946968780069075231515440216586853537004220763341534383076987989340045682642632728');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 4 });
    T('1', '16.30642', '0.06132553926612953671008106009780197002162338514523727464');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 3 });
    T('-313225923', '-14.5', '21601787.7931034482758620689655172413793103');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 4 });
    T('164.1993451', '22.23', '7.386385294646873594242015294646873594242015294646873594242015294646873594242015294646873594242');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 4 });
    T('-2', '-2.1', '0.952380952380952380952380952380952380952380952380952');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 6 });
    T('0.0082502485', '-20143.76', '-4.09568447002942846817078837317362796220765140172440497702514327017398936444834529402653725025e-7');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 4 });
    T('-5.25629381', '3', '-1.75209793666666666666666666666666666666666666666666666666666666666666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 5 });
    T('1455.634', '0.0000000001833490847', '7939139714723.6481404698280449065148782823457421928433548378657381974920761630614');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 3 });
    T('0.0000456078822', '-19467.42', '-2.34277999858224664593459225721744329757102e-9');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 5 });
    T('-5', '-0.00000000000000410202', '1218911658158663.29271919688348667241992969317555740830127595672376048873481845529763384868918240281617349501');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 6 });
    T('-17274806.55', '-32647573.58', '0.529129875691055874174401661613469284966077408561889211002124342252573614');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 6 });
    T('6562.207011', '109008.582', '0.0601989943415647769824214390753197761989051467525740312813169150296808741168654042');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 0 });
    T('-3', '-2.5615783', '1.171152956753264188723022833227467613');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 3 });
    T('14.4897748', '-0.0000000091438787', '-1584642062.2355806185399200450898369856984213931009386640266783066577644');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 3 });
    T('-200.932', '243005.6', '-0.0008268616031893915201954193648212222269774852925200077693682779326896170294017915637');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('-3.4', '-4950', '0.000686868687');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 1 });
    T('-3915.2', '-4.4033', '889.15131832943474212522426362046646833057025412758612858537914745758862671178434356051');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 1 });
    T('-3.5', '70451.876', '-0.000049679301655501693098988591872273');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 0 });
    T('32.99649107', '-0.0000000000000252114', '-1308792493475173.929254226262722419223049890129068595952624606328882965642527');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 4 });
    T('-0.0000000002421731', '2.6696132', '-9.071467731729825129722912667647882e-11');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 1 });
    T('-2361092', '0.000224', '-10540589285.71428');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 2 });
    T('3.3', '48.72', '0.067733990147783252');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 3 });
    T('0.00000000086515675836', '-1.04', '-8.31881498423076923076923076923076923076923076923076923076923076923076923076923077e-10');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 5 });
    T('9.36', '0.000000000000000187263', '49983178737924736.86740039409814004902196');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 3 });
    T('-0.00000000000000000254409418513', '-207.4', '1.226660648567984570877531340405014464802314368370298939247e-20');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 6 });
    T('3', '-0.00000000000000001866618', '-160718475874549586.47136157478391400918666808098925436270302761464852476510994750934577937210505845330967557');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 3 });
    T('4.8', '3', '1.6');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 4 });
    T('-3.017', '-52.7192', '0.0572277272796248804989453557717112551025053');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 0 });
    T('88891546', '1.23', '72269549.59349593495934959349593495934959349593495934959349593495934959349593495935');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 3 });
    T('-0.00014', '-2.13121465', '0.00006569023913194290401485368918611740961897010233108147975615689391024034111252003640271523095');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 6 });
    T('0', '-0.0000000011147297', '0');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 3 });
    T('-108', '-158517876.371', '6.8e-7');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 4 });
    T('0.0174163902', '-0.003287849617', '-5.2971979345');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 2 });
    T('3447053', '-26.180', '-131667.4178762414056531703590527119938884644766997708174178762414');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 1 });
    T('0.0000000000000004912253', '996.32', '4.930396860446442909908463144371286333708045607836839569616e-19');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 3 });
    T('-5.8942', '-1696.19', '0.003474964479215182261421185');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 0 });
    T('4.35', '-7.700', '-0.564935064935064936');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 6 });
    T('-1.951064679', '12.39', '-0.1574709184019370460048426150121065375302663438256658595641646489104116222760290556900726392251815981');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 3 });
    T('79287223.425', '-115.6806', '-685397.7540313587585126633160616386844466574343494069014164864290122976541');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('0.00000000000179581623', '82.118', '2.1868728293431403589955917094912199517767115614116271706568596410044083e-14');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 6 });
    T('1.5', '7', '0.21428571428571');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 0 });
    T('0.00000000096155', '-0.000614553582', '-0.00000157');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 5 });
    T('0', '-64986', '0');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 0 });
    T('0.1502692', '110.97', '0.00135414256105253672163647832747589438587005497');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 2 });
    T('-24676310', '-1132905', '21.7814468115155286630388249676716052978846416954643151897114056341882152519408070403078811');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 3 });
    T('-0.0000000000000000036333', '1162397966', '-3.125693700671874713173749651932890598330589301805436916946566646006e-27');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 5 });
    T('-36.3', '80465', '-0.000451127819548872180451127819548872180451127819548872180451127819548872180451');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 4 });
    T('55895210725', '-7357125995.55', '-7.5974246952965791117');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 3 });
    T('-13.757', '2', '-6.8785');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 4 });
    T('-3486.72', '-699656', '0.004983477594703682952765358976');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 0 });
    T('954.556', '-0.00035661', '-2676750.51176355121841787947617845825972350747314993971004739071');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 2 });
    T('-1.94', '2.0', '-0.97');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 5 });
    T('4', '-1945.59', '-0.002055931619714328301440694082514815557234566378322257001732122389609321593963784764518732107');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 2 });
    T('-0.00000000027649996', '36.4', '-7.5961e-12');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 6 });
    T('-0.000195337037', '10.9367', '-0.000017860692622088929933160825477520641509779000978357274132050801430047454899558367697751606975');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 6 });
    T('35.30643', '504.6056', '0.069968367374440553176579887341717967');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 0 });
    T('-0.00001921615', '8.9', '-0.00000215911797752808988764044943820224719101123596');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 6 });
    T('1.14982', '-38016.754', '-0.0000302450861533312391689201029630251967329982985922469866838184');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 6 });
    T('-78517.1', '5.896466904', '-13315.9570431466632717659022071227757034486019392741');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 0 });
    T('569.7', '-5625972.0812', '-0.000101262500378154205050056870161348499938944204657');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 3 });
    T('-6', '4057.45596', '-0.0014787591188050750894656660672664454502175299026535829608856678754930959250633493012700500142951645');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 5 });
    T('19.5', '-1.15066407', '-17');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 1 });
    T('-5.4', '-307.105', '0.0175835626251607756304846876475472');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 1 });
    T('1', '-40.4', '-0.024752');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 5 });
    T('-12687.3498', '0.000000000000000001143', '-1.11000435695538057742782152230971128608923884514435695538057742782152230971128608924e+22');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('-1.0', '371.3', '-0.0027');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 5 });
    T('1.95110622', '3211.707', '0.0006074981995555634433651637587114889371913440422803200914653796');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 4 });
    T('-2.54012', '157.29832', '-0.0161484242171181484964365798693844918369121806259596415');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 1 });
    T('-7', '10.922426', '-0.6408832616');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 4 });
    T('-0.000000000000010173970450', '-1979.1', '5.140705598504370673538477085543934111464807235612146935e-18');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 6 });
    T('-31.3', '0.000000004292064', '-7292528722.777665943471485979705801218248376538653664065');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 3 });
    T('-1.3', '-41.81181', '0');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 6 });
    T('-56.8', '-237.603', '0.23905422069586663468053854538873667420024157944133702015546941747');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 1 });
    T('6828531.173', '2.6', '2626358.14346153846153846153846153846');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 1 });
    T('408927964.6', '-0.00000000000000106192518', '-3.8508171037059315233489425309606e+23');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 6 });
    T('0.00000000000000000009999762926', '-0.022865151', '-4.37336404469841463106891356195286005327495978487087183461e-18');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 4 });
    T('-174424', '-424', '411.37735849056603773584905660377358490566037735849056603773584905660377358490566');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 4 });
    T('-3.015', '-0.0000077', '391558.4415584416');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 5 });
    T('-7707.041590', '-1016', '7.5856708562992125984251968503937007874015748031496062992125984251968504');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 3 });
    T('1', '-9.89309', '-0.1010806532640459148759386602163732463770166853834342960591685711946419167317794541442562435');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 2 });
    T('-818075.66703', '-641.16', '1275.93060551188470896500093580385551188470896500093580385551188470896500093580385551188470896500093581');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 3 });
    T('-3.3', '0.05674113', '-58.15886994143401796897594390524122448743');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 6 });
    T('-16182136', '0.00000484', '-3343416528925.6198347107438016528925619834711');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 2 });
    T('-195748.38639', '1', '-195748.38639');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 3 });
    T('83', '-30943580134', '-2.682301131303218581e-9');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 2 });
    T('485298.09014', '-791982.15', '-0.6127639242121807922059859556');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 6 });
    T('-0.0000000000000000006453151', '8.7', '-7.41741494252873563218e-20');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 4 });
    T('1.5', '10.67319', '0.14053905158626427525');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 0 });
    T('-6.853998', '198.445', '-0.0345385270477966187104739348434074932601');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 5 });
    T('-4', '0.000000000002985501551', '-1339808381161.3467823651450516');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('-1972.820043', '-2978.3', '0.6624');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 2 });
    T('17.5470679', '-1.2', '-14.62255658333333333333333333333333333333333333333333333333333333333333333333333333333333333');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 4 });
    T('1.68', '-0.0000000000000773997', '-21705510486474.75377811541905201182950321512874080907290338334644707925224516374094473234392381365819247361423881');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 5 });
    T('3877.04631', '-5317.71941', '-0.7290806474');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 2 });
    T('120233739', '40.99694', '2932749.10273791165877258156340448823741479242109289132310850517136156991229101489037962345482370147626');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 4 });
    T('-22.151457', '2918.4174', '-0.007590229211215640367275770765346999370275136106301997788253318390988211624560626591659');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 3 });
    T('-37.28', '199844', '-0.000186545505494285542723324192870439');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 1 });
    T('-1.24', '28', '-0.044285714285714285714285714285714285714285714285714285714285714285714285');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 6 });
    T('127814', '3.31', '38614.5015105740181269');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 4 });
    T('-6.0817', '61.6', '-0.0987288961038961038961038961039');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 0 });
    T('-83950', '2899.1', '-28.957262599');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 5 });
    T('-2', '1.3', '-1.53846153846153846153846153846154');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 1 });
    T('63317.4', '-44382', '-1.426645937542246856833851561443828579153710963904');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 3 });
    T('-12376.1101', '-0.0000000000000000000476577', '2.596875237369826911495938746519450162303258445120096018062138961804703122475486647488233800624e+23');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 5 });
    T('0', '255407', '0');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 2 });
    T('-3243324.741', '447', '-7255.7600469798657718120805369127516778523489932885906040268456375838926174496644295302013422818791');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 0 });
    T('-20.5351', '1', '-20.5351');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 5 });
    T('24373177.7', '-0.03429773005', '-710635300.48397474047994614');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 6 });
    T('0', '-1.9528', '0');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 5 });
    T('2.5715743812', '333604.7', '0.00001');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 6 });
    T('7258484263', '878748.686', '8260.02289236993521945363');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 0 });
    T('-1.55', '4028.651', '-0.0003847441736701');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 2 });
    T('39876720.9679', '-0.000000000000000095693', '-4.16715130342867294368449102860188310534730858056e+23');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 2 });
    T('328.9', '-1.747153', '-188.2491115546262977541176989078804203180831901957');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 1 });
    T('-8430.0', '6.36', '-1325.4716981132075471698');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('-0.0000000000000000124', '0.0000000000022', '-0.00000563636364');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 4 });
    T('-204018', '-0.29422194903', '693415.29642031411160079894872824743451805690052191956958432904987815891500214089245237027923579');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 2 });
    T('0.000000009608', '1107603', '8.674588277568767870798472015695154310705189494791906487e-15');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 4 });
    T('0.00000000000000000324', '0.0000000000353302327762', '9.170616057142444364532751561033571427601773401756984940156302665962620077892902e-8');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 5 });
    T('-0.000000000000000000161', '-307', '5.24429967e-22');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 3 });
    T('-2113052.7', '55.1505', '-38314.298147795577555960508064296787880436260777327494764326706013544755');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 3 });
    T('0.06681', '3.1', '0.021551612903225806451612903225806451612903225806451612903225806451612903225806451612903');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 5 });
    T('-593781.5', '-5.5', '107960.27272727272727272727272727272727272727272727272727272727273');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 5 });
    T('264.178', '163429.93', '0.00161646');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 5 });
    T('-1444588.448', '8.56410', '-168679.53993998201795868801158323700096916196681496012423955815555633399890239488095655118459616');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 2 });
    T('0.0750627414', '-503.1171', '-0.00014');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 3 });
    T('-684826102', '-242.1', '2828691.045022717885171416769929781082197439074762494836844279223461379595208591');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 3 });
    T('9.9723088', '-7.28030', '-1.3697661909536694916418279466505501146930758347870280070876200156586953834320014286');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 2 });
    T('-10.8542689947', '-362382465', '2.99525226605542296313923467572e-8');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 3 });
    T('83184510942', '995417544', '83.567455128156752680260174317361639750243341099883206398459860779789511123987');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 0 });
    T('-5.2584', '4.3', '-1.22288372093023255813953488372093023255814');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 5 });
    T('171.7711052', '21.73462', '7.903110576582429322435818983722742794675039177128470615083217');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 2 });
    T('97.3120746', '297', '0.328');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 1 });
    T('17', '5.175316085', '3.2848235201077578240325006158536884805558692749874812718806140320992');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('0.0000000075223031425', '-0.0000000000000000003063', '-24558612936.6634');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 6 });
    T('0.000000000284782805877571308685061', '1.24044', '2.2958208851501991929078472155041759375705394859888426687304504853116636032375608655e-10');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 1 });
    T('-84292190777045518365167.53', '349338169.15546007599011690336', '-241291099054035.477498848257293223533254');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 4 });
    T('-53.485123', '-0.00000000000000085526923975258', '62536006808186693.121901065461235');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 1 });
    T('-6856519792.8354', '-134.87', '50837990.60454808333951212278490398161192259212575072291836583376584859494327871283458144880255');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 0 });
    T('-3437325217.6304210', '-0.0058928082634501029868', '583308511656.536837957106657941719405129449764251342894994497244');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 2 });
    T('86694.653049907973', '276.86811', '314');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 3 });
    T('0', '7.096', '0');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 3 });
    T('-840920065282020550638.16675056', '-544817290763.11054598', '1543490046.184413528395333281622062666508477839510087529697756635981129506986226793475391075218794203');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 2 });
    T('-0.0000000001115427500598203903347530296', '0.0000000000000095', '-11741.3421115600410878687399578947368421052631578947');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 1 });
    T('-0.0000000000000000213', '7771.784441655282162', '-2.74068332181680990957923803724e-21');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 6 });
    T('-5219548154409821711366036884', '-6403861732570.160', '815062593850692.094058492748177219666225497517519616292585346465537888171756816076114357577457239');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 4 });
    T('15551916902370673557.1333290108', '-0.06428889318052242422', '-241906745208710958468.15960770779005223663662075254467552461782847066116561447264673');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 0 });
    T('-54.39064538374', '0.326659783', '-166.50548434283384067514671679066167750438994199662466560813211585339233510726');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 2 });
    T('-10447694007.1229', '1058379152566659776344755.133', '-9.87140948665357e-15');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 2 });
    T('0.0000000000020938452', '3240378916002', '6.4617294899060738552899e-25');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 2 });
    T('967351926269', '-22.0795261933451129685', '-43812168694.11649935062312079317354092546372626572951823800772019323767497831806178');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 5 });
    T('101006.8704166269166570296717065', '13094210020176391', '7.7138575187804e-12');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 2 });
    T('-292.3', '515823027211.36173935', '-5.66667218367954385822955695056628604396993663929021069625557355703596272535737e-10');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 1 });
    T('-627958027100087658205.09', '-8', '78494753387510957275.63625');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 5 });
    T('0.000000000000000039913330066487843180', '0.0000000000030114338098911573487587', '0.00001325392905379196627854118842244752137640431316713004600325949087886');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 1 });
    T('-200.842293509', '-5.0712235735', '39.6043066526418054796494962696');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 2 });
    T('-1848.560227815723699279797', '0.0000000000000174', '-106239093552627798.8091837356321839080459770114942528735632183908045977011494252873');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 2 });
    T('0', '0.0000000000000001799287214643564056307642336', '0');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 5 });
    T('-0.00000000109284603', '-605755688.5436', '1.80410361911333678248513635920011348723615833110992485011324e-18');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 6 });
    T('-17.51', '0.0000000000000001106572088912592375729', '-158236414739203737');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 1 });
    T('-257713780238786025994484911880', '160744975929777785647.053', '-1603246252.3206');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 3 });
    T('-0.000000000000000031476825065154718639426657718', '-1479127042283890059221502.51', '0');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 6 });
    T('-0.001011298', '406.176', '-0.000002489802450169384700228472386354683683920271015520365555818167493894272');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 6 });
    T('1875610846688.7314242171152', '36953885.844016673120045591563', '50755.44300282071230784749159999461116882607517590500292489');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 2 });
    T('2.48', '23018825528599.058245083750', '1.0773790334866552714e-13');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 2 });
    T('-37644856116561190.7', '11750087617.41953', '-3203793.651781167');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 5 });
    T('27225239.0927654530532507312', '-44107483349801146865010.14182', '-6.17247619340498933213826538373174836183684847796124222440343623092216708649906e-16');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 6 });
    T('-3', '623420854802547.7395328963607', '-4.812158555315207709041269638943960261014145138167945466267018280432446e-15');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 0 });
    T('1297926420.969', '1984.469459560495780721378788', '654042.02353230179159722311951514776953828174');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 6 });
    T('9.5116', '-0.000000000000927738069901', '-10252462746316.9575566575367529211085824463253401492796438490216152723506753495226');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 3 });
    T('-104895021573748233134.79927065', '-281760209801594479975768', '0.0003722');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 0 });
    T('1801.699799792', '-0.0000645512712544182335729718690', '-27911143.57284918766656202322530814542242474992155368042065229882647438143751747966584995520735334412');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 6 });
    T('0.00000000000000000006333905001032218284869562345', '0.000061374114666884348377', '1.03201570164e-15');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 6 });
    T('-6403029110376.2', '0.0569350772698624979926156', '-112461937656235');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 1 });
    T('104.057972667266', '-2385710236.97709671', '-4.361718831332867232565124691108468632809332107733e-8');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 4 });
    T('61883558331.753531', '-11.27304021045', '-5489518104.8310345601815283907266673560612625269587707664948134834');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 2 });
    T('11229912272987228870975202743', '-0.0000115', '-9.765141106945416409543654559130434782608695652173913e+32');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 5 });
    T('-0.000000000000000000099738249', '-28909.3', '3e-24');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 5 });
    T('0.00000000616807049939585972341098818', '9633721886.43686961447465', '6.40258310558016696529879116138216691930162803193995828e-19');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 1 });
    T('1438380887105946.4988', '-92.050294038', '-15626032509055.94351991829755854016819083134714103584295603268760522109653448361970130831359811065984506029851');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 2 });
    T('23564842', '-0.0001500845176938138', '-157010478909.453151573339526987486151490294503777115844769550097564216584170372135812878426610459291382975');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 3 });
    T('106510201620140041204712613', '174', '6.12127595518046213820187431034482758e+23');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 6 });
    T('0.001994938909681532', '0.00000000610636188569105720740544007', '326698.441236547297677127656717647999474522122');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 5 });
    T('0', '-992965188415144990460', '0');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 6 });
    T('75.042978019471810179662566', '-20828.92196301', '-0.0036028258280836779532074590076790296057591125');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 6 });
    T('191.42', '-1125370.65655092338112856', '-0.00017009506946508710923505448696387180328');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 1 });
    T('24906102321.8', '-6749284', '-3690.1843694531153230476003084179');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 2 });
    T('-0.0000000004002', '4.29973341406068', '-9.3075537820855276e-11');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 4 });
    T('-37140.99', '-136171', '0.272752568461713580718361471972740157595963898333712758223116522608');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 1 });
    T('49.43436363755592884987', '2425.3765', '0.02038214010796094084768694674826774317307024');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 1 });
    T('0.00000155445336543701798594470695', '-1', '-0.00000155445336543701798594470695');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 0 });
    T('0.000000000000000001927823363427027547788', '-0.00084297395450372616', '-2.2869311123164791404649867246710586063142709924183025467353162662660376821183153e-15');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('-3538.75692804245271578524253541', '0.0058', '-610130.5048349056406526280233465517241379310344827586206896551724137931034482758620689655172413793103448');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 5 });
    T('-4761336477329468956921492815', '-0.0000000042', '1.133651542221302132600355432142857142857142857142857142857142857142857143e+36');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 3 });
    T('-0.0000190146484048071649632', '-0.000000000000000000028002986729751222355', '679022155326218.32213770008814117');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 4 });
    T('135.311547037', '1538152658057363639166.70980', '8.7970167543639e-20');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 5 });
    T('61273.682559', '4140445022016191223', '1.47988156e-14');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 6 });
    T('25719205020.698', '75895083.76', '338.8784061696119537954114249468218783081820002197201606988515694603');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 1 });
    T('-605282280.963', '-0.0000000000000000026582609673', '2.27698592579413374889379695553866247374289540846165213148596947387453744974529e+26');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('128.674096168', '-485', '-0.26531');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 3 });
    T('-284.31', '-61299436947911204745164', '0');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 2 });
    T('-27156117968975435649284.5062362', '-0.2140549424', '1.268651761295441858916148354077901450034446857042063794925951684075667481527864034967501e+23');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 5 });
    T('-0.0000000000220', '-83511', '0');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 2 });
    T('-0.0000002831893855', '-0.000000000000000000066075384352033402787278372', '4285853018897.87848847386430278968565272453378873459172661159371765293738317683359');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 3 });
    T('0', '358618735187.21952', '0');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 5 });
    T('-22.5', '26023716139474.0432', '-8.645959662106405118389466343739935401549502009592919388435931e-13');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 0 });
    T('2827855856', '-929954533', '-3.04085388656307565952797');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 4 });
    T('-0.00011271354', '0.00012965', '-0.869367836482838411106826070188970304666409564211338218279984573852680293096799074431161');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 2 });
    T('-46.929552978589019', '12836.0093', '-0.0036560859284036993491427277167834398499539884253589626177');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 4 });
    T('257018142', '-35258.20163', '-7289.59873498800454843278');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 0 });
    T('2.276215213739273117992982952', '0.000000000021024983352672653', '108262402664.396178117533515828712401635259526311697113483063175627111769126355709999130060314825174257');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 5 });
    T('1532964471.105', '0.000000000000000606585', '2.5272047134449417641385790944385370558124582704814659116199708202477806078290758920843739954004797349093696678948539776e+24');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 0 });
    T('0.000000000016313152031948', '-448338202', '-3.638581757962262604604012753747002803923454196303352262629629763291953425821e-20');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 2 });
    T('-1821467900801658117.0', '-237300948.35414499609', '7675771687.533764014843389674196771695447410998228097939296421430055693563019117');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 4 });
    T('0.0000000000157495', '-8.2', '-1.920670731707317073170731707317073170731707317073170731707317073170732e-12');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 4 });
    T('0.00000000000000001492782607274397', '0.07101109108235816', '2.102182327466392982546211e-16');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 2 });
    T('-66468973917463.27', '-0.00000000000000000297284353275010458135', '2.235871924815849751854275641050067610508414796931327584614931310634047270900177e+31');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 1 });
    T('0', '0.0113746976908751', '0');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 6 });
    T('-60504544572803.0828', '173.5', '-348729363532.00624092219020172910662824207492795389048991354467');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 6 });
    T('0.0000000000186102590', '7154.18', '2.6013126591726794685065234590127729523159886947211280677869441e-15');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 3 });
    T('18949862124.7312829930', '-0.00000000065813745923580420948429601', '-28793167534841278323.131970933871205340608343780765524418553425987');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 3 });
    T('146263360394541.66340850', '-0.0000000000000000000291369755255564556', '-5.019853905778655370286501102407539701468694254631132201471781980780954741005684575459066532134590172341544956728846419833634251e+33');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 3 });
    T('1509441.774', '-0.000000003373555732147098593804', '-447433477863226.58699906317');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 6 });
    T('30331911230457034530206902', '-2957.122237268398', '-1.025723957169783101652769031300142e+22');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 0 });
    T('-1.6', '-19.96058946599105182772', '0.0801579533874030967');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 6 });
    T('-2.29043873913', '2.96790', '-0.7717371674012');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 1 });
    T('11772568498.701289348100', '-7504.3638391070401237093495', '-1568763.0225698294210989777699927096257870906945103707762203285405938572993792606917235071621002759');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 6 });
    T('-0.0000000000148347123', '-3335.62734', '4.447353012761911227169639399825761111551508029071377020191949859722639160284613808208e-15');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 6 });
    T('416489358120.40', '-0.00000007008686246187412466064277', '-5942474002841288879.77683608851079051337076828663883240711678573463442');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 5 });
    T('0.000000246512839458083', '677119453035840597070.5162050', '3.64061080143e-28');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 4 });
    T('-0.00000000000067665303968572', '110049103753289780506640.8', '-6.148646527850457868998800682412162492283509753692942914693977e-36');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 0 });
    T('-259.30262051760', '-0.00000000014084763600931', '1841015070359.151428675425551331452862418678960652787235110730227954405294936895404');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 5 });
    T('-3.151376403158403871974624', '-139.0275', '0.02266728814916763857491952311593030155904407401413389437341533149916383449');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 2 });
    T('-0.00000000000000001080911612', '-1556.8799', '6.9428066480914809164149399064115350194963657761912142357e-21');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 3 });
    T('-283.731555', '0.030718518473446161287514838', '-9236.4986692071265067750541533842080035308332697354');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 1 });
    T('4.55747', '-6093895748449378.261959467', '-7.4787462538388036117112195183416415665502531749799195367174376685e-16');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 1 });
    T('-6209057913039233089.554638932', '0.00077770788', '-7.983791951599144256522949120690406274397013953362540186e+21');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 6 });
    T('-65413356684972913334784193', '-10749246466905288418818944221', '0.0060853899746709817665388011109517624593413536255210794771752430033562011174757753794349810049054864');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 1 });
    T('4.48141', '11142539383020069527.9939', '4.0218928970797681683108653744109241673829e-19');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 6 });
    T('-157010536651.8385557386023265', '31176833.11', '-5036.1284642947673571006367843369451195679829586129506660466580019486783595256574153050659224');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 5 });
    T('0.0000000000000311954391035431138869624', '24096242.8724', '1.29461838796763546050032301e-21');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 3 });
    T('-12073.3603645', '0.000000000000000003231096498355190416486576184', '-3.736613985576109687026022157020994949604856807112675513970122687511460575831414034729237467633748036752626463635751e+21');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 4 });
    T('-11229937324', '6', '-1871656220.666666666666666666666666666666666666666666666666666666666666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 3 });
    T('-36173.069316352495643', '-3847.08178', '9.4027294934064270510516675317466217211530138046610488223101927404309039669024140162676');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 3 });
    T('-2502682902.58827454', '-150084564633685530705.4', '1.6675151829880867049650894318382222851766631493251569e-11');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 4 });
    T('-0.07688246602306', '-6403753', '1.2005845013550647565575998949366098286426725078247084170797968004075110329833146281563327e-8');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 6 });
    T('-33960220.713826767270362074', '0.16733662760657090', '-202945530.8115294687');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 6 });
    T('2.8', '51255410606449547593.80', '5.4628379070046346857585963850812976524e-20');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 4 });
    T('9', '-40332245.1457930390012', '-2.231465163287288183909357572411828628922732061041e-7');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 2 });
    T('28.20588', '-0.000000196910070', '-143242445.6504433724491591516878745713715911024763741133198520522591861350717');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 1 });
    T('0.00000000000007527724346240', '-2548.46', '-2.9e-17');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 6 });
    T('182357.1162144822274482841', '-96.6', '-1887.754826236876060541243271221532091097308488612836438923395445134575569358');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 2 });
    T('1131000923219021023017192.4', '-0.000000014817218356012837761464311', '-7.633017858308472878065579194067412216888064519989e+31');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 0 });
    T('4453786.636962392155535677', '-250963.38370093135464105', '-17.7467587951790260682885114754120226687355539896097812099137476157310503575581592474');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 1 });
    T('0.02105880647636941373891522', '-3', '-0.007019602158789804579638406666666666666666666666666');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 4 });
    T('-7615.1336008111570321673', '0.00335325681', '-2270966.4163214379730633574706734137669581');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 2 });
    T('-7620249639404', '-0.0000000000000002537522482549', '3.003027437908366061360597250587446069936925235724720585e+28');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 1 });
    T('4036527.94508226109659', '273093013735095.5684', '1.4780780694001038799691151063431e-8');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 4 });
    T('3581132452.090', '7363910', '486.30855783001150204171425234691896017197385628015551520863237');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 6 });
    T('1772.045', '6242.573', '0.28386452188865072142528409359409974060375425325422706310362730239598319475');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 5 });
    T('-171.1', '25.4098814519375642105786397119', '-7');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 6 });
    T('0.00000000120698418896873172829603934', '21.2635246123591424034', '6e-11');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 6 });
    T('-0.001184391777561431496802559296412', '46745128538963675598448912367.2', '-2.53e-32');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 4 });
    T('382477039554', '24271.0171155624320604387966', '15758591.316255880898891009542620046581391');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 4 });
    T('0', '-3179701885690718286932', '0');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 5 });
    T('22521535008035260.265331029', '-2540337', '-8865569807.484306320512211175');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 6 });
    T('2170680047.145934907', '-16635439470', '-0.130485284206677763650328138881443088199941615368698161600175627942097282026298040444855166787');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 6 });
    T('0.0000000000000000766292', '-1.957255933', '0');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 5 });
    T('0', '4882483440602156078', '0');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 6 });
    T('7.8', '-187381241311437016433382.48235', '-4.16263652936102018237350522975003750680024e-23');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 0 });
    T('-27718.0722643084293', '0.289733680', '-95667.41520802286189165167128654148872164257879857115679475026859148718920078604599921');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 3 });
    T('11440284945540031728.983', '-5825677608914.4676', '-1963768.97479429291268951429185159439402414197554120618367860332859433241104754409651622089284');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 1 });
    T('78.672496610303544707', '-1480.9216470187259083', '-0.053124010151840767416622387121575177625203747374376939509920643');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 1 });
    T('-0.9359034339029049964', '-9.050', '0.103414744077669060375690607734806629834254143646408839779005524861878453');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('11675.6028651', '278671', '0.0418974448905698834826731163271384535886403680325545176929066892500475471075210552945947012785686');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 2 });
    T('-718522471082238904716566210', '159968809108512620.67494', '-4491641058.56935624444165047282107830437431356909913096346865381177604838282981');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 3 });
    T('-0.0000000000000007240115', '6894090690193', '-1.05019143573194176430303605992882e-28');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 6 });
    T('0.01403241861365534490176', '98.781', '0.0001420558469103911167305453477895546714');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 4 });
    T('-100163956276268.45400638712953', '-0.000003822500209599644154', '26203780453620770552.762045992882479543453412936816289906209431');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 4 });
    T('-108012944.1175122414', '-0.0000000000000052661', '2.051099373682843876872828089098194109492793528417614553464613281175822715102257837868631435027819448928049220486e+22');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 2 });
    T('-0.0000000095661227651529585795', '439.658', '-2.175810008041013373917908920115180435702295875430448212019342306974966906095e-11');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 0 });
    T('-2294287466562757501742320.27601', '-832584777918371.546177', '2755620241.219080420608405722438221977774013');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 2 });
    T('-0.0000002759', '-183126.762211952', '1.5066066623330111887480084015381767263333164079000147488698351688626521e-12');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 5 });
    T('1653901506.2955747033592190', '-322190268156088.641', '-0.0000051333068368605218558546015330570362016912647522618795650532856646842031492231821113536');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 3 });
    T('248330241832030242304149.24', '3330.8', '74555734908139258527.72584364');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 6 });
    T('-18342746626779219566723384.683', '-3', '6.114248875593073188907794894333333333333333333333333333333333333333333333333333333333333333333333e+24');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 6 });
    T('0.0002199161', '14860579112610491.754079911', '0');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 1 });
    T('-0.000000000568242490987', '348596.86613', '-1.6300849095272387267e-15');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 0 });
    T('0.000000002049503091568392', '2.22227599162281', '9.2225407613378789315422863796067e-10');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 6 });
    T('26041624909507628.488792197140', '-246901903760748416.0953516', '-0.1054735687042022440675400298081862682581');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 6 });
    T('-320580.6238', '0.0009850386145294971077', '-325449803.76543418');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 1 });
    T('-58275174168.25149350192684', '16653.838', '-3499203.857288121422937273678295657733670761058201719027169592979107878916');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 2 });
    T('46770480873406.409882', '0.0000070956746212439754972487', '6591407212131559214.2696047445573145755811032180453546396659194926912322518859416');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 6 });
    T('3.754240463072038', '-115117.4885688923668289', '-0.000032612251272536256054753760718128290585012986196327512602851762942681368');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 3 });
    T('4', '0.0056705434513331', '705.39976182699589005149617');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 4 });
    T('-9050', '-1110617973.258696', '0.000008148616552140008896135150388571481487341383070838106781751554751750807288566249');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 0 });
    T('0.000000000000000014', '-4770178679', '-2.934900544005387350396984993106586313e-27');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 1 });
    T('-2.1611115285091044', '1', '-2.1611115285091044');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 4 });
    T('-1.486211747365416', '-1386302473893.3388076342', '1.07206888493208023054074800312104610361989162636431378141145313364812e-12');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 2 });
    T('-0.00000000000000000014428', '-3', '4.80933333333333333333334e-20');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 2 });
    T('-32608018749047.9996725803', '332.159913589', '-98169638824.61663098063583714993775277959765');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 3 });
    T('-0.000000000000000000661438157030', '-33292.064829009268', '1.9867742070886854266568898631488887980727035276739897454831283052178e-23');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 3 });
    T('178992107258447203.67', '7', '25570301036921029.0957142857142857142857142857142857142857142857142857142857');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 4 });
    T('122641090582555142454291285', '-19338960887519151968841287700.2', '-0.0063416587528084004561775821574233856070818007325775576443265439169');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 5 });
    T('-7', '-4906.459444175730287072723974', '0');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 4 });
    T('-7691.6200805', '0.00000005979', '-128643921734.40374644589396220103696270279310921558789095166415788593410269275798628533199532');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 5 });
    T('-3547231646.3828711', '7.78154', '-455852138.05787428966502774515070281718014686039010273030788250140718');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 4 });
    T('127.6570', '-0.000251316107215474764266674', '-507953.9127611456689859414656378008562846463183737483733030129');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 3 });
    T('0.0000000000000000751948126794197435', '-9.471515838720393536', '-0.01');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 0 });
    T('1.4', '1771.9512519134307055', '0.000790089455614661281192204203464890374305788190624271762375083');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 0 });
    T('10.10', '80325048.161', '1.25739109172471374349282788225230454835680854762207952658609299828415947260000796901359e-7');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 2 });
    T('3857345278902280', '-2452638478359688.015970', '-1.572732921275');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 2 });
    T('-0.021', '0.00000002882977', '-728413.7195683489670573161006834');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 5 });
    T('-36206966.8939129954925798651759', '-22.7013433495627012494', '1594926.18284241116152432797478154892604082831306502511561248383742079121');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 2 });
    T('5.5110610412115985840905338', '-4901879566436940738.477642', '-1.1242750798990880390037343298118832909837831e-18');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 1 });
    T('-292125.918633265', '-2390686440.2576276060503', '0.00012219332226679824515550937357789383313825356191649299186874000273523091107167169375245388194');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 0 });
    T('0', '-102275090.1', '0');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 6 });
    T('2.666778067490', '216.21210', '0.0123340833722534492750405735849196229073210981254055624083943');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 6 });
    T('2363.828945', '-0.41511719893859553946529868', '-5694.365232382625093743741062342');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 1 });
    T('-16329.50', '21363731.3167546173519', '-0.000764');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 2 });
    T('1.1396176388245', '-5485.281', '-0.0002077592084752813939705185568433048370721572878399484000910801105722751487116156');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 5 });
    T('0', '-33143947602683866.435849148873', '0');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 3 });
    T('-0.000000000000000000055196335', '-72.89889049', '7.571628954705645205218266690247949204418680309602e-22');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 2 });
    T('-12.471836599', '0.000000000000000027069', '-460742421182902951.71598');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 1 });
    T('0.000000000004406', '-3.8', '-1.15947368421052631578947368421e-12');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 1 });
    T('-47.9653', '16753400954657', '-2.863e-12');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 2 });
    T('-48292622.6', '894.910689010519453168902686', '-53963.6225078459557881137025384011498164613577179194959550666717656710800958124435690706757022');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 5 });
    T('104.4', '16728461156682781', '6.2408609508169669877e-15');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 6 });
    T('0.00000000000242526901875700822786120839', '-0.000020180224165103702340737812', '-1.2018047960789563562387101610719677162023172609323952542918769865608172696005280649776e-7');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 4 });
    T('-1816974287.73852', '-2748150389.1808717035915', '0.66116261136643872080726488469');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 4 });
    T('-7.6', '5009220859436611651783', '-1.5172020186897437e-21');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 1 });
    T('-0.00000000000000000498398533825394', '25882849761072773.5995635665', '-1.9255937364940943765693045003752394728474718216467301581e-34');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 2 });
    T('-82059240599', '377376698042.4017333228', '-0.2174464958347266361200674350905444260783111107023398');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 5 });
    T('90627979', '174273716385155737169698170.541', '5.200324000648872237330439812746e-19');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 4 });
    T('1803768.648947634', '12779000526.591068884', '0.000141151');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 4 });
    T('-0.0000017977320993875685730', '0.000000002321196536', '-774.48508625017548837148531743285351861304001188');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 0 });
    T('21', '96592.00', '0.0002174093092595660096074209044228');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 0 });
    T('-9084159902.2773', '-0.0000000000000000003819750', '2.37820797232208914195955232672295307284508148439034e+28');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 6 });
    T('-475115003.43806', '-0.000000000000000001181287678509513467781749', '4.0220093046050820583944191642895006512408869334056873162428415838264772935e+26');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 3 });
    T('214.229235', '-96718.991049', '-0.00222');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 1 });
    T('-18918149257957412463884', '-12933208565390138378746.1679', '1.46275761055792844404673151942791058773622292664668166595152619195819218153');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 3 });
    T('1159.3', '-0.000973', '-1191469.6813977389517');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 6 });
    T('-15.0171621', '0.01112357298508184819314643', '-1350');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 6 });
    T('1257949.03', '0.000000000000022102066080572533260', '56915449687562150843.321252993243314644749883359919608357053897347202786399238773645987');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 2 });
    T('-12509289.1748544943125636400748', '0.00000000019570', '-63920741823477232.051934798542667347981604496678589678078691875319366377107818088911599386816555952989269289729177312');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 2 });
    T('5103106614703706.7', '-0.000006855059817629', '-744429188142190173489.2713016971254171088888271678386913354383444543485128480265142256148634497157227198749636248722828');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 3 });
    T('38002724.5614025131', '-1.71', '-22223815.532983925789473684210526315789473684210526315789473684210526315789473684210527');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 1 });
    T('-12309000072530.8782101', '0.000000000000000005004668128957057438', '-2.459503758363294183324008531673735403936497133985113056082719930636152213430809622794608640259961200476256210907e+30');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 5 });
    T('365159985032.3763673086467605', '0.0002248991250864720416537834309', '1623661207627975.73236893711916990791838169197927385941853797750513823629941899829442490537');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 3 });
    T('-0.000132733440397044287025245800804', '35.06', '-0.00000378589390750268930477027383924700513405590416428978893325727324586423274386765544780376498');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 0 });
    T('-9', '-15069582487318433', '5.97229552150751792890065332726072e-16');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 6 });
    T('-688440865278.1976957', '-191734448.78467510638', '3590.595584893261972185203469698709886249651463039636148228569063563654046627');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 6 });
    T('-6.884105', '198.528', '-0.03467573843');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 6 });
    T('98494481', '0.000000000090907', '1083464210676845567.448');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 4 });
    T('4.1', '0.42104952', '9.73757196065678925367258464040049255964');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 0 });
    T('18686.30172522661238', '-22626731230.8', '-8.258506955609394854491e-7');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 1 });
    T('-217561642539525707', '4687.6', '-46412160282346.127442614557556105469749978667');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 2 });
    T('-3', '0.00000000072', '-4166666666.66666666666666666666666666666666666666666666666666666666666666666');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 2 });
    T('10.3369964842', '421357.91', '0.00002453257964043');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 3 });
    T('-966.95', '166.35184', '-5.8126799198614214306255946');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 2 });
    T('88.312171688114496097823009', '-1', '-88.312171688114496097823009');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 1 });
    T('-0.08100046091599871990126157625', '836052437639404688.1260', '-9.6884426465765284782792330904408446819277826640674697982217950846e-20');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('1307029672025726.8946196', '3588333885571316791', '0.000364244162808062686280269617983867361116163528210105586323320774998223691317505');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 6 });
    T('-306094430745053063639434225', '-12.142338824106155973001689520', '2.5208852691325375368534545536856115462837e+25');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 1 });
    T('0.000000000000000162919', '0.002409301029588780599', '6.76208568373903066167611260640812687570871901190402134288403285417264259e-14');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 4 });
    T('1428742', '241634.827979485972105568060292', '5.913');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 6 });
    T('0.000000000000000002510050622', '1523.2', '1.6478798726365546218487394957983193277310924369747899159663865546218487394958e-21');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 4 });
    T('-0.000000000000000000035749559428282832870653983656', '-24286992018217719702.563900', '0');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 4 });
    T('-138402.4665046532', '0.000000000347385397352979926188763', '-398411872114537.407536113851520690910631203');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 1 });
    T('36438.4910796968134561', '-1', '-36438.4910796968134561');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 0 });
    T('-50687824864.112', '19163378634568526756727650.450', '-2.645036e-15');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 2 });
    T('488334449.2020317740855741', '78.13', '6250280.931806371100544913605529247');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 6 });
    T('0.000667304', '0.00000000000004928708049', '13539126143.52');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 6 });
    T('507.3946759', '120.660', '4.20516058262887452345433449361843195756671639');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 4 });
    T('-0.0000000000000209691683203167478229886865505', '1076.27788', '-1.948304309693398866748862901e-17');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 0 });
    T('-113.257633861192413018879', '0.0000000000023303326777400552', '-48601487222429.156054866043674');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 6 });
    T('-2077566313336500634596', '-38810801724.61887469', '53530620884.304922435225040116');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 1 });
    T('13917443811993', '-1164251924.0598120192232144558', '-11953.97965370079');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 4 });
    T('-1439867048.03', '-6', '239977841.3383333333333333333333333333333333333333333333333333333333333333333333333');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 5 });
    T('-14.1843451280640557', '9395.3328084', '-0.00150972247788629551108132302742026195917932779804177309147038474588667770603633192');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 3 });
    T('-3831836247.8565953325900323625', '3169.1996790786465189454871796', '-1209086.405363574724665960371338376916663187706990416314468');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 5 });
    T('-0.000000206244605375083882357269', '1445859182.857448', '-1.4264501537936e-16');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 0 });
    T('0', '1.21', '0');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 2 });
    T('83335008717067160822.171945907', '0.000000000000000000120693306315870', '6.90469183924489231374137123999663300649220373696042103284760306718607591350537867610533460388107985601192585e+38');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 3 });
    T('10846307850991.30628627477717', '-1.310684754730377', '-8275298703098.531994827629365416255194325218938141649862829575721253963');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 6 });
    T('-678310684269746238023205.639', '0.00000000000000087620', '-7.741505184544010933841653035836566993837023510614e+38');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 4 });
    T('273969047512527019958734', '250143298211591.665974', '1095248401.501372969143862693');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 2 });
    T('-37913913.68389085010', '4349730843058434231425100.95', '-8.71638155367617422094891802420120647e-18');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 5 });
    T('0.00098741424750804361', '73915637811812314022106790436', '0');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 5 });
    T('0.000000024440295818881073037', '-4', '-6.110073955e-9');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 2 });
    T('-99.1590286313793831503558794957', '16787996379118410.56015892', '-5.906543365396325479029718112268663527602296600354973223720357251e-15');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 0 });
    T('14723174275120', '265178680875168135247.4552', '5.55217117248233043623251282398647489648930220277513034207786907942086015047e-8');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 0 });
    T('-1.9457690461029591399869', '-0.099', '19.6542327889187791917868686868686869');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 1 });
    T('0.000250', '1395491087969', '1.7914840313588129521412774522257497935e-16');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 1 });
    T('503.15', '0.000055143785802', '9124328.202757369327995707928780047309382227895227961374562427617199890268');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 3 });
    T('0.000000000000025660757724442223488803162730', '-3790245.532665333', '-6.7702098724979855589219544271270126505188e-21');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 2 });
    T('14.463', '-0.000000002111666808880372710015801068', '-6849091882.8564768623016676014845618727081781903335062812202548971724');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 3 });
    T('-0.049977764242150', '-3554330936225373958.9794672159', '1.406108917230575984432591142761469848719374481586786332741084e-20');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 6 });
    T('5999976195382498.2106', '1645742458.4628816934', '3645756.45753616711261372450729345569328619981313857117469084254846554829522');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 4 });
    T('-0.0000000000000000234', '92.7', '-2.524271844660194174757281553398058252427184466e-19');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 1 });
    T('-261323770210', '-330138315587204.04966262', '0.00079155844042274');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 6 });
    T('-266747620889317710970', '16715859169459882384', '-15.957757132619870995789063025');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 3 });
    T('3.1999829102086268', '0.002585180334233347790', '1237.818061600566349853496904836550436749744609638869515041');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 4 });
    T('-171766371.918350352954', '216943045727495078.512735', '-7.917579074376427781751348437342336e-10');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 5 });
    T('15.52', '0.00000000000025530580488751', '60789843798648.64227787529457012617431943426961714858379045883500607718007');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 6 });
    T('-0.5622727159023', '-817.5', '0.000687795371134311926605504587155963302752293577981651376146788990825688073394495412844037');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 1 });
    T('38.73768595163933', '9365314625538049210738174', '4.1362930665464750235406947353030673158822890826879e-24');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 1 });
    T('0.0000009208543785903092638599', '-34569.1445969401454', '-2.66380435306408421772788564135897283463549176971345853940568337909378e-11');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 6 });
    T('-30396165240.0206', '-225.46', '134818438.92495609');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 5 });
    T('1940492058391889114.99304514', '95.6', '20298034083597166.4748226479079497907949790794979079497907949790794979079497907949790794979079497907949790795');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 4 });
    T('-1040764761.50', '15098783841.213396', '-0.06893037031626');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 5 });
    T('-63112243829712286.712176382', '4.53086863642258227476029', '-13929391667277191.1049048030718148987048324130822940316106043476213962789837629470215414269675882887');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 5 });
    T('112250343.6965919520', '-0.000007472612227381', '-15021566793642.3131422877563285057056713294011180360286844613050561843696715073443827925933925429718296877346761445');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 1 });
    T('-858308', '-797915.1043309205', '1.075688372536475592165307888197163680941989658239175669621943724756050703');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 5 });
    T('7702738480378783', '-27211551328852834116.7', '-0.0002830687007620711698741765472408358310483607997205237758794286665');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 5 });
    T('-10364330957928.845576', '-18586324921402.274691', '0.55763207636568597276102172540430891397353156072928592967369650601783246460086442630704');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 3 });
    T('-418215482375364', '12.1', '-34563263006228.429752066115702479338842975206611570248');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 2 });
    T('-0.00000000032235960011619131724', '-0.0000000001199449855652686582449445704134', '2.68756212356020288555782622224');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 5 });
    T('1731992042675229309286.24145774', '-0.00000000543884846850764546877', '-3.184482988823674786228835511596539162161550426544230885758694842325199901058255160684745968156272681580975692287458054e+29');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 4 });
    T('0.000000000004136224738967149777156268381', '-147.937118080566990703203', '-2.795934375789684904194318639235567496e-14');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 0 });
    T('-0.00000000000000000811468340227542368342231', '32479961852.044142528631352', '-2.49836605081010033691506373017657135694584426440346612866842162464e-28');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 3 });
    T('-1788.32930998675528964704109632', '-4402.9030009101454', '0.406');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 6 });
    T('-534035137285426204832193876', '-0.000000000006958343802621144', '7.67474491680419827675194262635906350252120322866880525282383045e+37');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 3 });
    T('43433765.655395', '52829486770946303169.008082', '8.2215005880544534379454896415484632e-13');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 2 });
    T('-256531.89844052843379160703785', '-43565278723435678939.0029', '5.8885e-15');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 5 });
    T('1382.605599', '496725559.747272963', '0.00000278343961140926681');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 0 });
    T('0.000000000000000009124024133', '-85809.060510899400', '-1.0632937918998744386039106970980125782e-22');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 3 });
    T('-28158922704444951.3318876655', '-3', '9386307568148317.110629221833333333333');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 0 });
    T('-31357452346869.9832', '-685465.0410716072806884188251', '45746245.932320593614463966989994270901457798084302915769968731');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('0.00006296856775186224879239176', '8361.092', '0.00001');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 4 });
    T('0.0000000000000000001083906851243582424', '-176733018789786191849', '-6.133018372377985414924780432053129391963905924345013316934e-40');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 5 });
    T('34646285.1404977758582763', '318004872839520750922158.9481', '0');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 5 });
    T('102.519957707', '-25322.3195', '-0.0040486005915453361213612362801124912747428212490565882007767890299306901960541173963151361391');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 4 });
    T('239446310.05585430497014', '-1062112156216.1340241041011', '-0.00022544352651880230281011078789940688440856622557785580563571076003266177694135980618363');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 0 });
    T('0.00000000000000032758850033', '-0.00000000102209384660285940028552883', '-3.2050726204722612547170391904987164753223354245592595297271256917659439684641850986207697359e-7');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 3 });
    T('0.000000000000000001751216', '0.000003645903', '4.8032435311636102222138109543781060549334417289763331608109157045593368775856e-13');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 2 });
    T('0.7321592', '-18.3014143396156', '-0.0400056075674519784435921655940016725753412040906758225360442708922820561490546102');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 3 });
    T('0.0000002141074381007', '624724950524740', '3.427e-22');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 4 });
    T('41477386487845172040', '32686.589605629763268149', '1268942003074598.1820532054446071416406551993937513639812513532');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 4 });
    T('73524957186494', '-0.00000000000092742192013327752873', '-7.92788649808146747219837992301661356413777463599126495012475971409076175396083145685072884002449e+25');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 0 });
    T('6.51927747', '3.248487618329', '2.0068654204547875474372132567239346142207846063341103567');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 6 });
    T('-248.8', '76427387571599.004618', '-3.255377527681660051014924449347117991757530529525972422912e-12');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 1 });
    T('-136982892001549.59241931', '-0.0000000061294841700339234293707', '2.23481924745376192219348229128691204934976563208655459056668279537751074405701910375123806e+22');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 6 });
    T('-566673274360829.4823', '-1616580392609110718613', '3.50538257764116733275e-7');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 0 });
    T('-7399.84843', '571', '-12.95945434325744308231173380035026269702276707530647985989492119089316987740805604203152364274');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 0 });
    T('-14347857328982549.68152091943', '0.000000000000000002193037540912918441895905604', '-6.54245860424706572344549418130099037034313425103219343931227823220414273319099409854830572833303708795e+33');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 0 });
    T('447725486095370.54', '-261084333206951673012381772353', '-1.71486921714477400876618519816379556942618938130370368557234921262e-15');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 2 });
    T('1778.78635', '4.6', '386.6926847826086956521739130434782608695652173913043478260869565217391304347826086956521739131');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 0 });
    T('6', '-0.00000000000000000008656623', '-69311092789878916986.4507210259705199129037');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 5 });
    T('8660818485', '-3639713019.9791331', '-2.3795333416285807841757890660196384859105526936081479610725605676155');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 2 });
    T('0.000000000000028486886133242758360857', '-90759541920385101577876.2228', '-3.13872079238033749299151843632992877736e-37');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 2 });
    T('-264065747359816523.15595967100', '-7', '37723678194259503.30799423871428571428571428571428571428571428571428571428571428571428572');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 4 });
    T('733652736.1234', '9128591006429.34', '0.00008');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 3 });
    T('-912789', '-27424659551921110017.6547018', '3.328351253629541266789534424994247149545228473927555683575e-14');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 1 });
    T('40880374.90874231446467', '-168.2', '-243046.224189906744736');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 1 });
    T('61496.883952847393249', '0.00000000000528222910', '11642222021920138.4599164773069');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 3 });
    T('-1719909488824413777944662563', '-246077321', '6989305157562300419.97516123397653536710926725344185618795809305807583950412073935086443825516127103805718040956728');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 3 });
    T('-293612812289214043747.58', '0.0000000000000000001354445823693525495644225', '-2.167770811892220004074067777411843143084716317536069982839371579007784821146737197752377313721918329436356512944e+39');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 6 });
    T('-252024.7609680', '8093.410735', '-31.139499676955416497838225678534032784387038772967945756926');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 3 });
    T('13815446674716621.06', '-128.60', '-107429600892042.1544324');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 0 });
    T('0.00522362886930946079174276', '3510421.9', '1e-7');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 6 });
    T('0.0000000000017192602049124017803', '9145.69189439399893224784', '2e-16');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 0 });
    T('1411430645669589892', '1.425722', '989976058214427421.3345939811548113867921');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 6 });
    T('-42753742073377897547.969800322', '0.00000000000000004474405195762283308535569936', '-9.55517889034056160615372279164249929677188173410104884054706502204169530968066421766387e+35');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 5 });
    T('260.52011203584432', '-3676.612144', '-0.0708587421876949335344413745699687815642486764304176219899903589068926276168009088749830338');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 1 });
    T('-7.55456238', '-0.000000000003719260', '2031200394702.171937428413178965708232282765926555282502433279738');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('-21222.41838531276', '-289985647', '0.000073184375');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 0 });
    T('5525891.1', '-10.91656063', '-506193.41450953');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 4 });
    T('32312.39417353723751', '-0.0021138482494108150925', '-15286051.9588118724318989155766929639454507451602078022076670388352');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 0 });
    T('2446253233428.940231', '-31.3104706187216162148542', '-78128919338.767159502811844194454831716599966285174816279870865962312');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 6 });
    T('146.08985841078', '-712729739', '-2.049723063552143991567047548159064539890063433988405526600314905619505796993269562447709229e-7');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 6 });
    T('-254679551.3351240205748', '-963077196919.166915969572427', '0');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 1 });
    T('-4015380412427088083628.66', '2039551492.85975991919183', '-1968756575396.3470364088815587613164748499818');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 1 });
    T('-19505548357651893634645.49', '0.0000259205709359478093574', '-7.52512296347636581817777703374439950046132124649587214448460528e+26');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 2 });
    T('751007.690', '-1728265.8743523486981728681294', '-0.434544071687715892515560844698898014769657263304930643624836329871222288884130814653288174932');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 1 });
    T('0.000000000000000390405721683', '-53757', '0');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 5 });
    T('0.0000015791374698', '3467564978984453', '4.554024162115290937032043e-22');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 3 });
    T('-0.0000000000000291746896274500185363981690735', '14754.92402', '-0.0001');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 5 });
    T('11384156820601', '-0.0000000000000062413', '-1.82400410501033438546456667681412526236521238e+27');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 5 });
    T('432.391547', '0.0018473682', '234058.130371628135636415090397247284');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 4 });
    T('13.68132091', '74.24170', '0.1842808140169204099582849');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 6 });
    T('8873.080150772034073915', '-42784423325262745958341254', '-2.0739043467562135419772762901090863875e-22');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 5 });
    T('-425055.3393', '-5158.9808434788878162409044364', '82.3913389477464651275793694820442509540900451341');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 2 });
    T('-17740546137492505779638198852', '-1499.49537', '1.18310109470311374016701357684085413348091898409796357023763267771877148243545426885846269735397715832893836e+25');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 3 });
    T('-120967541287515870777090.3056', '-36031769380240000848665141166', '0.0000033572467677331178762017280440971752536610800072303035796168388021794690621689726518441');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 0 });
    T('-380753599.97235919717688693', '341731.9117', '-1114.1880138680627559807927940725589544056619632342051');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 0 });
    T('3973.86864569059095517125776255', '3790.450615450233881655060', '1.04838950532496793358231611052252426985338442899310394506730907098751686558696776453');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 2 });
    T('819', '-0.000000000000001868873556286311654157', '-438231894953587272');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 5 });
    T('0', '-2.70218161827305518', '0');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 2 });
    T('2.7', '1525317024104608.786', '1.7701238216920533733865373e-15');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 5 });
    T('0.0000000013774085200391251247', '-427044616459807710', '-3.225444056543359111984888087221769479019208413821296679755113045e-27');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 6 });
    T('0', '381052750392378', '0');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 5 });
    T('-0.012', '14229.9130446715011177656231', '-8.432939795435707899418891005245670460221309831396126407817938984e-7');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 1 });
    T('-618727765534332776069474843103', '0.00000000000106194', '-5.826390996989780741562374927990281936832589411831176902649867224136956e+41');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 4 });
    T('1343044.4', '4.8', '279800.9166667');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 2 });
    T('-29698.6587975512709624472801340', '1.09369018', '-27154.54462391833029208260801427329264307740241390848');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 2 });
    T('-206050982842545845299.0294', '-10252.57709396842301448856240', '20097481926155459.46507056716149702202267712679553829986963187484665742387256996692');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 0 });
    T('450787174.91797094382', '34776465.949216', '12.962420494');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 5 });
    T('-8912.5034568999175', '0.000000000001027649820', '-8672704732143014.9231184607223499538004103382220219724263660163926268191');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 3 });
    T('-291963929613551.38551581848913', '5127.96119843765', '-56935674494.28143813');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 2 });
    T('353517668823.2', '-809912559.8', '-436.488685779237374903591413597436101891650155886371278');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 3 });
    T('-0.0000000000345575618967481574', '-8651.8104189', '3.994257874774588630231688258982315644045347356149059273049115794e-15');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 4 });
    T('0.00002262033686410', '0.00000000000000000016918722881770681', '133700025836303.5440032071856005751361649815034573256386641');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 4 });
    T('-9', '-0.00000000000000000309370135915883', '2909136647387024607.211131551769362614690719452830247');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 6 });
    T('-72.68302213970591', '24447071019007557295898.538296', '-3e-21');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 5 });
    T('145.61599228290', '214774372.717934495176385', '6.77995193e-7');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 0 });
    T('-0.0000000000127239336', '0.390324864377574104115012', '-3.259832e-11');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 4 });
    T('-393350.90682', '0.0000000000009567676207', '-411124810570212056.9264787202');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 3 });
    T('-0.0000000003668467144', '-0.0000000290881995629295142832857', '0.01261153044575215164761048554983138702158579139495482');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 0 });
    T('4.787447258776', '-0.0082432922249843941', '-580.76883945298487');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 4 });
    T('2696690009318863222773086253', '-0.000000001462', '-1.844521210204420809010318914500683994528043775649794801641586867305061559507523939808481532147742818057455540355677e+36');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 3 });
    T('76881164209637856397179639', '33.7', '2.28134018426225093166705160237388724035608308605341246290801186943e+24');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 1 });
    T('597716745962233128726', '-39.60', '-15093857221268513351.6666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 1 });
    T('-91356.9', '4.8', '-19032.6875');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 4 });
    T('6', '0.0000000000000052', '1153846153846153.84615384615384615384615384615384615384615384615384615384615384615384615384615');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 6 });
    T('-6595759.2090163406115', '0.000000000000107279', '-61482295780314326303.3771754024552801573467314199423931990417509484614882689063097157878056283149544645270742643014942347');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 0 });
    T('-8366642360683555547365541560', '-39.620862', '2.111676005606227231342301830788032829775384493149088982465853468811456e+26');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 0 });
    T('10769162802333.3620', '32525723925789', '0.3310967905558193239276674624674343930721042133996441026370693086124554971148047279865860532');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 3 });
    T('-722856872353934530.245543', '28233', '-25603261160837.83268676878121348');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 4 });
    T('-1', '-504284034426003', '1.98300943859593228789356646092126130439e-15');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 2 });
    T('-161.18599049116514632266705', '-10286701.34', '0.0000156693564987');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 3 });
    T('-9.497250', '95.217589970243492', '-0.09974260011168095598895157145158668001901445580253863');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 5 });
    T('98023548.73', '-3247574706953067067089963.0', '0');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 1 });
    T('0', '-150978667633376', '0');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 4 });
    T('13.945', '-0.000333489074233133', '-41815.462866562865851280031427636914');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 2 });
    T('-23264894.70087300543163', '2129233469499.5357015', '-0.00001');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 2 });
    T('-17520127173088.05', '-32144915.483903564124', '545035.720559327104969763059381957684855487085216377818567655');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 2 });
    T('-2507754348349292581124766.52', '9', '-2.78639372038810286791640724444444444444444444444444444444444444444444444444444444e+23');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 0 });
    T('10132.85840', '-0.00000000415470652290632786510493', '-2438886680475.2783550885887106154489894064656314634276650796020629292987020657942917264533220964319659');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 3 });
    T('-2408133581684757559117', '-143220715840651400750035', '0.016814142895110702260709558133521323305519171571563617498137562792145');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 4 });
    T('0.000000000000000003198370', '-542480.91706', '0');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 3 });
    T('-0.000000000008512648221547079532', '47947101838.0139888013', '-1.775424977782073370220761947962681790318209412034329729757695848925e-22');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 5 });
    T('0.00000000000000000011093', '22917.451210427999', '0');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 4 });
    T('-5452.9', '-117854011174594916759393320.1', '4.626825973637670289155725075691610989628825159024940840150731975804822e-23');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 3 });
    T('-2163', '-5618.908218854533', '0.38495022');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 4 });
    T('0.000000000336304373477542493153710230', '-4186031524', '-8.03396657548779828906300969366517365e-20');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 4 });
    T('11553.4617260458525853', '-402113198056590396003', '-2.8731864017106707904343853526999954587484204677438247997511e-17');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 2 });
    T('-181.366', '-26923110833809265.90276', '6.736442943742065990244083064716388108845247447476821880350726856024e-15');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 3 });
    T('176664198.97382887749', '-6.703640', '-26353473.4821423700392622515528876849');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 5 });
    T('-0.00000000000000001081719221524', '13557.51', '-7.978745518343707657232043347e-22');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 2 });
    T('-279668700083542629396.8738', '-8989194394.50111', '31111653370.6982896042912274454917770704503039799571441076351113468002914069592993132748827192761700465839897');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 5 });
    T('-10962559713.5256', '90423573495954484891232.735334', '-1.212356390008857658041919479438436425645429346797893680515762015192882468075426906336431e-13');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 1 });
    T('8417526.02327013', '2777508574.8209', '0.0030306030734');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 4 });
    T('123573743499355386610.311970', '-6801791452477806600081', '-0.01816782304525656027864123540300829519018882095471454248744787831024859664366597147763');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 5 });
    T('445.696', '4617891890.5', '9.6515035554836794202772382984178914701251e-8');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 2 });
    T('-11900.9568454100155485', '-3476642741.8436463943548629222', '0.0000034231175674665373261181070448471272');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 6 });
    T('11348547.8754874465167814538', '0.00004569466684935670458', '248356069930.44994350575754262658581065466587206841915638415295657073357911004031792129581118795515446');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 4 });
    T('11.57', '-17254134620', '0');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 1 });
    T('-0.000000000000000492', '7', '-7.02857142857142e-17');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 2 });
    T('244775175978.4297', '58.3', '4198545042.51166');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 6 });
    T('16084427.989905', '13774842831298.8', '0.00000116766689732084835945526952707448756700157');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 4 });
    T('-0.00000000000000000072736713853935309030799267119', '-164.42446530', '4.423716003650906142298962800336988536948582675427438352144058941330794767072902e-21');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 4 });
    T('-437.5396', '-1.77', '247.19751412429378531');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 0 });
    T('0.03983775', '3560454489296722751770', '1.11889507701217477177168362112653150044898592883858932108625090095410893684e-23');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 3 });
    T('109362613295.86670', '29.64', '3689696804.85380229419703103913');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 4 });
    T('-0.0000032765290989360868917898696', '23134769823577489.12274739', '-1.416279100212553826140199909818514674618878864071375130080526341123427e-22');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 2 });
    T('-370', '1895716488790', '-1.9517686436127588143580679436793115682e-10');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 0 });
    T('-0.119463366506755', '249.81', '-0.000478217');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 3 });
    T('-7086162368075.3800108071', '-0.00000004820534953852057358915222439', '146999501837713569169.304265988413248513013633283530691155318444527059289806808714865906466809802032523276035908798809');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 2 });
    T('0', '0.00000000000000000014803456360474978130174416', '0');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 4 });
    T('-1', '0.00000000000000019619313938607223639', '-5097018188960128.66621016506236792382745133518116907519744902661');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 0 });
    T('-0.0084827970779245676518357807346', '-1.5', '0.005655198051949711767890520489733333333333333333333333333333333333333333333333333333333334');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 2 });
    T('-0.000000000000000000050067235497272278048443611', '292.7081119936176', '0');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 0 });
    T('0', '4466725625238.749354', '0');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 1 });
    T('-16824641.958', '1.96', '-8584000.9989795918367346938775510204081');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 0 });
    T('-0.0000000000000106859863094897', '-2729188667932820575989818.84774', '1e-28');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 1 });
    T('-2.38', '-1873114498229', '1.2706110610164259521028e-12');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 3 });
    T('-4.68', '1082905.925', '-0.00000433');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 6 });
    T('-8113', '-5949.882', '1.363556453724628488430526857507426197696021534544718701984341874343054198');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 5 });
    T('-21706.47947', '310050075109339875387268468833', '-7.0009592683844e-26');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 2 });
    T('0.0000000000000000000208693317205862612', '-766835343696143996876', '-2.72148798202e-41');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 1 });
    T('0.0000000000000000001002743971335117', '0.0000250220203710886', '4.0074460673596356044798592209348131568198528485765879099969546704184e-15');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 6 });
    T('-1.33127239316243150282262', '-758441.1309619468855071', '0.00000175527452140412090223529987373882800883');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 3 });
    T('-0.457998904018211230990', '106823865246041', '-4.28742119528562117351521105182951354172417051826989560351852664958994121e-15');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 6 });
    T('827.7662', '0.00000000000058611', '1412305198682841.1049120472266298135162341539983962054904369486956373377011141253');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('0.00000000000766056111585', '-4326', '-1.771e-15');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 5 });
    T('-0.00000000015729606511275867583378', '-47360157670.0547277528812936', '3.32127410150526447699433470761724988139876005238577631e-21');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 3 });
    T('-0.00000000091092387', '-0.00000016666487527350474711378008', '0.005465601966251928706607718464');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 0 });
    T('0.000000007557770', '-0.00075816935781574087888658416', '-0.0000099684456013543837066710559181684089709649944');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 2 });
    T('0.0000020087', '-35211882697672804165890828224', '-5.7046083483992675229381e-35');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 0 });
    T('1', '-3979309282849145379656834.598', '-2.513e-25');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 4 });
    T('288.417899033564961844', '-0.00083', '-347491.4446187529660771084337349398');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 6 });
    T('-354425.55865449782', '0.000000000002663912762955191297607172533', '-133046983964038871.4593608883168');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 4 });
    T('34662.291247', '50631846734.64123571', '6.84594647093620534765634464165957567554562755943960923814340077924e-7');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 0 });
    T('166199629396.7152205', '340428867.221111275338763271634', '488.20662816695633016681543159573660494212645642258549253064269');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 2 });
    T('31.12250528447262923010751', '0.00000000087826137', '35436495726.17844871180832');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 3 });
    T('3210014362437665134887.25538', '-10.7036', '-299900441200873083344.5995160506745394073022160768339624051720916327217011099069471953361485856');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 6 });
    T('-0.2186034305808468153', '-0.00002470', '8850.3413190626241012145748987854');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 0 });
    T('12478396.1599469824217', '-0.00005802658288439887441', '-215046200201.1485876879095422103548422559818198858685');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 5 });
    T('-1695.7431718249008647067456', '-1894577221.3806', '8.950509658240235260983971505096809376850495951e-7');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 1 });
    T('-241284189093.86476', '7121957475722720030', '-3.38789145984587319969970007799531782077092e-8');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 4 });
    T('229.159577781024488884284523270', '15827811.765113481403465788789', '0.0000144782855129804781782160081696446522432203755884279917332806673499');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('-2', '-36690762702.360403462057', '5.451e-11');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 6 });
    T('28914.0854970944316513046232987', '588918251974184326.432567676575', '4.9096942402732497225323883923686358553855e-14');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 1 });
    T('985.3', '110692260427.6595868463953548', '0');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 2 });
    T('-11584428432173903', '5836', '-1984994590845.4254626456477039067854694996');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 0 });
    T('-285.080308', '0.000000000000001579060969526758', '-180537872508772162.1425399144383005516174655559047556185290795696279787560640447736969020751579144736');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('-7314926838', '-4.59806', '1590872419.672644550092865251867091773487079333458023601257921819202011283019360338925546861068');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 4 });
    T('-11150536667.220697', '-0.0000148263718447037736405151712457', '752074532057811.16038727959854897547701');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 5 });
    T('0.000034439', '-43.80', '-7.86278538812785388127853881278538813e-7');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 1 });
    T('-3325765.67', '-975143369337176063355701369091', '0');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 6 });
    T('-11714479722402747456', '13985398070045191101720', '-0.00083762218735078839171923');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 2 });
    T('-17.66', '-2011513929495288742', '1e-15');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 6 });
    T('-364544.23838', '-86661350.88886', '0.00420653768538');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 3 });
    T('-8212024.05936522', '-0.00000000031142169355553117630542302718', '26369466961687087.73998920742887087815127142165724721398021346806585408574886791929503494691927452789154395683');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 5 });
    T('355562161525907.6', '0.000000000000000000176', '2.020239554124475e+33');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 5 });
    T('45053830577655388757.9', '-28567382886349292167417518095', '-1.577107387011780519755115682384135459e-9');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 0 });
    T('450487189350.5587956', '-4158900812972.723005705813121', '-0.10831882');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 6 });
    T('0.000000000013200962', '982953804', '0');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 3 });
    T('-77306', '-0.000000000000000839093964', '92130325466147674493.341963785119');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 0 });
    T('1278794.9358822362652680550', '-516402.818101142', '-2.477');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 2 });
    T('0.00000000000000525450', '-4.00247921699212', '0');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 4 });
    T('0.0000000000000731186280459695', '-0.00000000000025477319298719825567', '-0.2869949824338211924404096');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 5 });
    T('0.00000000000000303133058001014485268638', '382508.56435663', '7.92486982640184371531271251696217534903553010456e-21');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 1 });
    T('-234982095594308.19612', '458878.61539585853455391812', '-512078984.9655498972330178178');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 2 });
    T('17317538.5', '29.5966544', '585118.11051184217632382124920173409870272364298040389321841728165059088570497346483864743847535');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 2 });
    T('1.13183693', '-10708432517497979855.1615193', '-1.05695854939603537631931016638241905193e-19');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 0 });
    T('6.8787514260155610450174866', '-0.214871', '-32.01340071957388872866737065495111021');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 2 });
    T('9', '-54745011062627.6303', '-1e-13');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 4 });
    T('244.7949772420', '212561.689969', '0.0011516420352025847324194690336955993342194615565994197');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 0 });
    T('0.000000031041', '-0.00000000000010832', '-286567.577548005908419497784342688330871491875923190546528803545051698670605612998522895125553914327917283');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 6 });
    T('-5', '-1', '5');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 0 });
    T('-3647714057342.344419212889', '66.08', '-55201483918.61901360794323547215496368038740920096852300242130750605326877');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 1 });
    T('-296586646905.87', '10.62697', '-27908862724.3579308118871136363422499545966536086956112607827066');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 5 });
    T('0.00000104208542089884', '-466141.347', '-2.2355567203070702929941977449170583874422965530238620947735837730781689e-12');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 4 });
    T('-51285337112', '2983965.1', '-17186.97618547884491008289607676711768512305991782544641691687345807094057500873586');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 2 });
    T('71220.93', '-0.01857651073264191243878809311', '-3833923.9820131231147816074654911721048995993360368248376218174400380729521529188040354');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 4 });
    T('-6', '28767.1596', '-0.000209');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 1 });
    T('-820.65708906', '-1070782820906061.717912385913', '7.6640853125154414557334549413445715745754921798313010156e-13');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 3 });
    T('116589557442731987886', '-5381447.7', '-21665091615167.4183');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 3 });
    T('-967636609359503330.8', '-0.0000000000000053167817155', '1.819966779035811877125764991357580589392545656786236e+32');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 4 });
    T('1378098.0860848883965', '3829.144881526811', '359.89708635297016136624615649284086100158');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 5 });
    T('0', '4353.34549', '0');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 6 });
    T('-35.0', '714.58398198933532', '-0.05');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 5 });
    T('-188.0', '4324', '-0.04347826086956521739130434782608695652173913');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 1 });
    T('-112.292782', '1353.2574746268109064176431', '-0.0829796133444354975314836744657495573860198495844430986');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 2 });
    T('-335.4292', '2', '-167.7146');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 0 });
    T('-3.01549', '-2884.17173068256673060268', '0.00104553066931501876');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 2 });
    T('-0.000000000000303585323552205201200045', '-521.9394865', '5.81648508e-16');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 3 });
    T('-0.0005968274879156986', '-114765522638442814.5', '5.20040752827783749460320576045391710563725197474603e-21');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 3 });
    T('-10104', '921.19008301', '-10.96842029278588727172841387099769273274951557709344646106993048837381014');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 2 });
    T('0.0000000000000000273049586458', '253618203.43011359797', '1.07661667327140760880141928555493830956376043549264221372598231047482040857e-25');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 4 });
    T('92922740.3', '2.31571', '40127105.855223667903148494414240125058837246460048969862374822408678115998980874116');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 6 });
    T('98.0', '9012340616560.8575896792', '1.08739787109152962034444607422571496238389650882032713766511857928951409622559135329911e-11');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 2 });
    T('-9.22766448843', '30584691562.115512085', '-3.017086005163470678943551372474647314661738810411606251930458348221431623446733989e-10');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 3 });
    T('-0.00000321', '0.0000000000029905245023738090', '-1073390.302420855083982977706400817540115916694852349782290443838748321172953000874847743245801381481218');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 5 });
    T('1', '-478284675.8535330846', '-2.09080501735797565380343933829251104375905448306653e-9');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 2 });
    T('-24889740.944', '-797087273.4207924200426425', '0.031225866694851106957198464945590008419112817133210984653981131991133256272684495');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 3 });
    T('13.1614510', '799327655434', '1.646565198955e-11');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 3 });
    T('-0.02997028136511', '164423.0141282', '-1.822754650498152611447305273290121442270888131882025599486482581e-7');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 3 });
    T('-83.962', '-0.0000093242194811805', '9004721.539370062771492551878267567604243603287981636648318973068259');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 5 });
    T('-2', '-9831.560685', '0.00020342650206608575696341745155998088618826442202853574717064364');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 4 });
    T('-2408978781037.3510487', '-2.0209735274300618771100862158', '1191989280582.358613546376064132210477642527787115330582198045845612173066304486493037517120331381');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 6 });
    T('156581443947360795736793.8', '153828658191028.8630776013', '1017895142.4832260054950889143026772449424156367352661475671925661398188827146377323678301');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 0 });
    T('-106669940.5101239779778850', '287.16715', '-371455.929099564410406569833');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 1 });
    T('-0.000000000005329131775399', '-2016075515213211958295433.2776', '2.643319526072123676104268301908366260560799e-36');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 4 });
    T('20917.248494281423675636484', '0.000000000000879328552700456560582', '23787750812871521.03901071061542842588654768064339450389481');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 5 });
    T('8.14215847559786034216', '53135.171299627387188786', '0.00015323482123892122654505696856');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 3 });
    T('120005559', '8', '15000694.875');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 3 });
    T('0.00082521538', '2962689307305357254627', '2.785359159886241279024189699621126135113985187557e-25');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 0 });
    T('-0.0000000018', '-959.7', '1.875586120662707095967489840575179743669896842763363551109722e-12');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 0 });
    T('-0.000001066091437051389158134313065', '-54550697597988.2164086050344167', '1e-16');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 2 });
    T('-881450466.662', '-12.73', '69241984.8124116260801256873527101335428122545168892380204241948153967007069913589945011784');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 4 });
    T('0.0031693408972666078125263', '-1', '-0.0031693408972666078125263');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 0 });
    T('-4.535', '506.69530', '-0.008950152093378407101861809256963701853954437706448036916861080021859291');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 0 });
    T('1834.4', '-0.000296642697475565684977543', '-6183870.412488743761227431114731471038972851587971972838707653417369269946548018381567775282756274');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 5 });
    T('26.460334800691560145438110', '55', '0.48109699637621018446251109090909090909090909090909090909090909090909090909090909090909');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 2 });
    T('0.00013879', '-1859.266086', '-7.46477338800875648306748063816402016596563683031649725901578134e-8');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 1 });
    T('-8860443753.946', '791167.32', '-11199.20341748443300211136122255403572533809915202260882059688714139507');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 0 });
    T('1659086344364514178134748909.31', '-0.00000000000019569851052023168146429', '-8.47776684632964899225070525498158826632514866528309592706027956562821436539535748195784066e+39');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 1 });
    T('-5840566934230352003627', '12181689.4', '-479454593073958.362756072240686090715791850677131859888005353346145896643859594712700522474329381604492394954676811');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 6 });
    T('-115.78', '-0.00029632151', '390724.250831470182505481967880090783824636962736859703502455829143149277283312979877836070692269');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 0 });
    T('-17678362127870710507151.66721', '2.8', '-6.313700759953825181125595432142857142857142857142857142857142857142857142857142857142857143e+21');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 2 });
    T('-1', '49.4', '-0.02024291497975708502024291497975708502024291497975708502024291497975');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 0 });
    T('0.000000000000002295093364019182289319365862', '3', '7.65031121339727429773121954e-16');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 4 });
    T('356272.49131846480991666', '-0.00000000000152684414', '-233339135269212750.1086391175460777549');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 3 });
    T('0.00000000000034718503647815561', '7634618013.74749176089', '4.547510246786244e-23');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 4 });
    T('4419292534230334167380586901', '-98750790116226', '-44751971392117.384988619855226602933570788116660146013546402');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 1 });
    T('-0.000000002640314227681740808806945', '-0.00000001727726621556096', '0.1');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 3 });
    T('224239562441972', '208159', '1077251343.64582842922957931196825503581396912936745468608131284258667653092107475535528129939133');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 4 });
    T('5.07573926', '-0.0000006299941666685128408282015638', '-8056803.5841365606359821934824012');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 2 });
    T('-333956334181076018958.8736898', '216131081.6161449', '-1545156447114.7754744584147365985158699131343315862971072549909074858');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 6 });
    T('-351329370559483', '0.0000249515526800', '-14080461246850270161.2234898401521039130780056930709612256482629440918624227275943614744');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 5 });
    T('563922094480019', '-0.00000003973759974770161962', '-1.41911463717089669561746511053964737252150859296e+22');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 5 });
    T('-169945484449570746983136.2', '-1257007944836', '135198417120.3812776146603667877407888246796159806670569777738337');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 4 });
    T('30369.73135366606', '7670136648490.82036957156012', '3.95947722256573126000846098351557e-9');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 2 });
    T('1.4444343508', '-0.000000000000000030201076', '-47827247969575653.52969543204354705772734719');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 4 });
    T('-1301765052865.662576', '-8034253087206065409336236.5863', '0');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 1 });
    T('-43294281189.9655444155109481', '-5416370820072684.408611244392', '0.0000079932269462644659624737902334378948915704774581638949755139014111418431575371608');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 3 });
    T('2.513163425', '-41516.26124951', '-0.0000605344351673686');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 1 });
    T('0', '-63301017633243.7', '0');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 5 });
    T('792995397863538032966206.36', '2000057.03848', '396486391441214770.533170799574005957026350136');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 0 });
    T('-0.00000000001223160894758355959512224993', '-259896322713293214', '1');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 6 });
    T('-1976.5', '5864021.5672288', '-0.0003370553769866245326081455571391585055073452007206643');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 5 });
    T('-1158971.274333232717401185', '-926364306311.6293418018796388', '0.000001251096643552406361650562');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 1 });
    T('-218013221', '-727851107224011227.52723485', '2.995299709462445366963421695946644e-10');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 1 });
    T('-986608546070844210107181.936', '672917810.5511805859535416', '-1466165006485297.99312049307790578350867921850442274');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 1 });
    T('-2.30', '-3574.267', '0.0006434885810153522386548067058224805253776');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 2 });
    T('-0.00096359384288029908705847', '-13117636.77133', '7.345788419651446874734e-11');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 1 });
    T('3268.604363654077832', '-34', '-96.13542246041405388235294117647058823529411764');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 5 });
    T('-26.01868784433545', '44235870867281485', '0');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 6 });
    T('74.5', '882526.6667', '0.0000844167126173933662961121716323543699668242557366793730222815033720498907163504071');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 1 });
    T('2346320493.483661205767414081', '18891988723810961.6890741589393', '1e-7');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 5 });
    T('-6643382332752.800366', '708198923.142517034076', '-9380.6727399045969877466366411125785225');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 2 });
    T('358420023453.511025368037013', '-0.0000000088425110441501727725645', '-40533737720421213147.897212111279513473931');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 3 });
    T('-13903.808110199', '-196395', '0.07079512263651824129942208304692074645484864685964510298123679319738282542834');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 2 });
    T('0.000000000000000010395', '-14.28', '-7.2794117647058823529411764705882352941176e-19');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('-9218614451113493670', '-0.00000000000000016185263657703762427', '5.69568383072071498871273113548441534234149560125375183394529211322856118223136764911798578479761381095302917255374908882905519623669e+34');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 4 });
    T('2523532.104758902674236', '1425317605896', '0.0000017705051101031829994014197506080252923384113662616153652501841038691');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 5 });
    T('-141.4', '119718482665189185033519.71586', '-1.1811041775015e-21');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 5 });
    T('12804.1563', '-719.1', '-17.80580767626199415936587400917813934');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 4 });
    T('582037664817572050755.6736884', '-0.0000117163', '-4.967759999467170102811243211594103940663861457968812679770917439806082124902913035685327279089815044e+25');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 4 });
    T('-2199756650967975683604832991', '0.000000000000001016247473465', '-2.16458757183196701804046535386679737451306727219918382855096114932607863474941e+42');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 6 });
    T('-23276.4098074440', '19.9177283480510', '-1168.62773709440893442');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 2 });
    T('2694302819292998.54846048', '148762428626556504299', '0.0000181114468496383624671273269368124102810066837334214790130527562697435433035728');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 4 });
    T('0', '0.0000000000000000250169442196', '0');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 4 });
    T('-15110061623729716511396098221', '1847662722830329', '-8177932821301.647568672180256');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 5 });
    T('134.34076196', '-163212229.78', '-8.2310475226692904997820562218410493429630295196130001674191942407270750051019859303585087e-7');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 6 });
    T('2', '0.000044476120196283495', '44967.9511426251522555540285522370682163173896901934503803808051');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 3 });
    T('138578679.416762928716', '-1580628094199.05509158679944901', '-0.0000876731724087090263704240893373141841606');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 1 });
    T('-117845035.56', '-11550621722901664817131.4', '0');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 4 });
    T('1', '793231057244556757901601', '1.2606667261286e-24');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 3 });
    T('-421328249052153697.5361', '1050100.2774141333085293229950', '-401226681026.76099441905787096642316278349483887468600450047044679974507');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 0 });
    T('-3.94', '-144029804399824449190817665', '2.735544921704276279115462111554858005441023992356721225944181878910114911e-26');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 2 });
    T('-14.478', '-19.64', '0.7371690427698574338085539714867617107942973523421588594704684318');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 0 });
    T('-1984442538', '155.66814357', '-12747903.92234392340804093524399959');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 2 });
    T('-803229', '-138327801322951487005370', '5.80670691153917331e-18');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 3 });
    T('0.00000000000000772350713715705705', '248.94', '3.10255769950873987707881417208966015907447577729573391178597252349e-17');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 6 });
    T('-87.75566506588633454483790799', '-628869755.12856397361489120', '1.3954505579290558769803e-7');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 1 });
    T('1', '0.000000000000049923605672579949133019843826', '20030604491158.381896360582775803425921567');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 2 });
    T('1384139740647242862.472516', '0.0000000000000020621146911147203403326', '6.7122345163983892089985173449973034403706234889005061761009869711932945762e+32');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 2 });
    T('0.0000000209', '683423294485412305.7719468', '3.05813398060081945804588598305083677e-26');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 0 });
    T('-0.274823236543517396592093', '-1', '0.274823236543517396592093');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 3 });
    T('-195781256144.5', '-0.0000000117909502309315138914787608320', '16604366256326128362.6867641014711305994021480467714341195589509594749613047046221518632201');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 6 });
    T('-845550065.67484199282', '-0.000000000000011583020213752768186815111', '7.299910127678981990504260833115313467866001228054e+22');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 5 });
    T('-1892049706.8', '-0.0000000026', '727711425692307692.30769230769230769230769230769230769230769230769230769230769230769230769230769230769231');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 2 });
    T('-3196321897906842652526.8238', '0.011866359391009549', '-2.6935994373544003968420629837142065656629591155372486394808649203789817375905652024750602543824104e+23');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 5 });
    T('-0.0000000000000072978357474268980751421', '2705850830.813896301', '-2.69705767380819467082224402367733736475401295543613580526331e-24');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 2 });
    T('0.493510204780969111410170', '-31.4747', '-0.0156795840716819893886254674389271');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 4 });
    T('-0.00000000000000000001149', '-1.3', '8.83846153846153846153846153846153846153846153846154e-21');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 4 });
    T('3.975', '2722413048.230589336001894463', '1.4601017294504665890474e-9');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 3 });
    T('-1', '-1164067380456083.3133', '0');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 4 });
    T('-0.00406774079216508895885', '-1191447019986923326048554451.230', '3.414118063100895806e-30');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 4 });
    T('133014612766098', '-4136121831945', '-32.159258883229810827917034044352936476180523568820718624394026197132984123578474447315752109');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 0 });
    T('2880602052.52426903109739740980', '-750.32658', '-3839131.03');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('35212520694460536686618361133', '0.00000000000000007896', '4.459539095043127746532213922619047619047619047619047619047619047619047619047619047619047619047619047619047619047619047619047619047619047619048e+44');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 3 });
    T('-5828.32331837104557852500935', '-0.00000000000000020286', '28730766629059674546.6085445627526372867987774820072956718919');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 2 });
    T('59023.32246338', '-2.3', '-25662.314114513');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 6 });
    T('-26.91186149360', '7.514915', '-3.581126532182998743166090368287598728661601628228662599643508941884239542296885593516360464489618312');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 1 });
    T('4', '-1548.43', '-0.0025832617554555259198026388018831978197270783955361236865728512105');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 0 });
    T('0.00000000000045058186273986975043', '-0.000552882519115919330', '-8.149685460491094720267563440652111891472395108327682983855341550524023695063e-10');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('20370364868298257638938931', '693.4', '2.9377509184162471356992978079030862417075281222959330833573694837034900490337467551197000288433804441881e+22');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 0 });
    T('35404', '-27851923.45390315508813', '-0.001271150987420888540308934579814363714714944137046733052073548329971');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 1 });
    T('1133.287750112481', '-0.000000000000009504538918', '-119236478475165627.1770341968733890348198793076897367910803897872997272733141119639529261802324075664329');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('49.33107184109863469290973', '-284326074250012.86', '-0.00001');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 5 });
    T('-0.000003132745516946287732321013676', '-4020613067.0389', '7.79e-16');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 2 });
    T('-0.0000000000000000000624856143521758410959879', '-6127645959575.9138624', '1.019732777715838962191676539977427242664581e-32');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 0 });
    T('7045', '-49228682.23', '-0.000143107629147683565772343445480848087');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 3 });
    T('0.001656631748068514997575', '1111754928456906141389839', '1.490105153271402275923753726417383852409982894833468785852753708390198627e-27');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 0 });
    T('-4921879.72798194704141569501', '-2', '2460939.863990973520707847505');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 5 });
    T('-3842875.81600287154215788709256', '1.074', '-3578096.66294495');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 6 });
    T('-0.000000050117920097154940536079551056', '-1397910398799177', '3.58520260956688483527691792989860753545766e-23');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 2 });
    T('0', '0.0080931215100', '0');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 3 });
    T('0', '-23751811450190359074914845183.1', '0');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 5 });
    T('-13915159.169438739755867165361', '32.9', '-422953.16624433859440325730580547112462006079027355623100303951367781155');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 4 });
    T('995743797116.35115542864', '-14201957555.706732240338', '-70.113137094698206269394712623561325492522134');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 1 });
    T('65802.5484', '249400', '0.26384341780272654370489174017642341619887730553');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 1 });
    T('170', '-10981.3', '-0.0154808629215120249879340333111744511123455328604081483977306876235054137');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 1 });
    T('201942537975663838827', '84508089664.467591327407', '2389623748.18150606');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 1 });
    T('23137876052.8', '-486750238185.362429540889', '-0.047535');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 4 });
    T('-0.00000000413170142764279266714159', '4.41397', '-9.36051089527747734384599351604111491469130963735594034395340249254072864110993052e-10');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 6 });
    T('2571974844.0088', '-2.56205', '-1003873790.13243301262660759938330633672');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('-2288.26338054', '-9', '254.25148672666667');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 5 });
    T('1943.0954931552832430914361473', '10715986.655209780472398', '0.00018132679291930719773879837496526569531146097023540738852483');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 2 });
    T('0.0000005591951101822447394', '327861916054130937525016856.154', '1e-31');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 4 });
    T('0.0000000000778429607078534448233979411', '0.00000000000750103048859169', '10.377636');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 3 });
    T('-24266547.905', '-1170740261.1', '0.02072752489283978550278627639143040657833578966852189004299375589313625254294246');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 3 });
    T('301.0', '-1089916139863550590', '-2.7616803622862486062850164540557338539790749327672777897590219388059732611421e-16');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 5 });
    T('-18403001013809.814080', '-282780.004832288', '65078862.364134692779334796303606');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 2 });
    T('-62444881822127582837603.59424', '-27.3651008519838850', '2.2819167435153275687231640005567034402782244595814686e+21');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 6 });
    T('-1', '2.040593173', '-0.49005358502196655148762472116728972316325592254639969826067824446259675886899578488396717');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 2 });
    T('55642.6031364', '-0.000000000000000862582262902', '-64507010553637696390.073458125613230811714588454907783871949338725796446379199');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 1 });
    T('-111.0747736416', '-25663.8', '0.0043280719784911042012484511257101442498772590185397330091412807144694082715731886938021649171');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 0 });
    T('0.000000000891240067824482', '-2', '-4.45620033912241e-10');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 6 });
    T('-1.1771580965', '-384394400500325112421125611', '3.06237056254674652913427814e-27');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 6 });
    T('-105012166625.1026618687564906', '-0.0000000000000003275', '3.206478370232142347137602766412213740458015267175572519083969465648854961832061068702290076e+26');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 0 });
    T('50808964142001.14', '-219110914192.4', '-231.88696158415042981934463247576107829874493853519991170237890107319026305334199');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 0 });
    T('6572664354129149393.4019651217', '9.026', '728192372493812252.7589148151672944826058054509195656990915135');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 0 });
    T('33.31', '-4.40618812712408', '-7.5598224676215640005099392658811743777115996670683109744');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 2 });
    T('18.4', '0.000000000000000009063796984004646283347', '2030054295398654285.716267915678865377862968128412680743328636');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 1 });
    T('-826206.5', '0.00000000001348675401954832170', '-61260589375505647.34524063429409961187895088582');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 0 });
    T('163649.52737', '90914229.30812336259', '0.0018000430583353974223210959');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 6 });
    T('361495398.724177091515', '9621300075383.51524', '0.0000375724066281933838311981786550364827931583670196281658447763588');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 0 });
    T('-4830845132049.060', '-0.000000000134', '3.605108307499298507462686567164179104477611940298507462686567164179104477612e+22');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 4 });
    T('2', '-55', '-0.0363636363636363636363636363636363636363636363636363636363636363636363636363636363636363636363636');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 3 });
    T('62932082345602320.61003434', '-0.0000000000000000000128306583754', '-4.904820976783304950188966278975096902493124109775290494872199712982469624424632235618240214096005335685792340778902786715996472419024e+36');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 6 });
    T('0', '-20042656659491873502.8780627967', '0');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 1 });
    T('422300.832', '0.0000000000000000058894360480', '7.17047996715083780123593932265753673398237739044042337141615566788136044634744287489035316883705e+22');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 3 });
    T('-23732871163291602553.19952', '-234088.2', '101384312251927.2');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 3 });
    T('0.00000000000016146202', '4151.9', '0');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 6 });
    T('0.0000000000000000042', '-0.0000000000000051003065', '-0.00082347992223604601017605511');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 4 });
    T('21099.156363620443872', '0.013005585', '1622315.05646385332701297173483545722856757308494773591499344320151688678363949026514378246');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 2 });
    T('-39719382.4097', '0.00000001206', '-3293481128499170.812603648424543946932006633499170812603648424543946932');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 1 });
    T('-25684646695530101.09663290', '1986420121012', '-12930.11');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 3 });
    T('-1', '-467714', '0.00000213805872819714611920960244936007902265059416652056');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 6 });
    T('0.000000000000000000033286877570123', '-916.5099', '0');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 0 });
    T('-1.043852662559036', '42240709131514578739126498.6', '-1e-7');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 5 });
    T('-7.1', '0.0000000000000096810955853', '-733388069298768.68674779946344013503105681395776477666217263849082719375430604653757358662');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 5 });
    T('0', '-178045896984030995126538.3213', '0');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 3 });
    T('-377840682286.889417008650', '10024.5862044', '-37691399.38375184600838106190987946490963690396');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 6 });
    T('-4.526', '0.000000000100219845842383081', '-45160716043.3881820432324');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 3 });
    T('-154', '-0.000000000000000000357470393647111044759003621989', '430804907866093922870.601661067205523043745373628598982920969630143060439226956593292728945988714384628');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 1 });
    T('45.2153662086445686333586366039', '2.0', '22.60768310432228431667931830195');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('-4859389835978.26', '-1108.719806029077', '4382883582.9878');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 4 });
    T('-1692359.9586057645036945384', '0.0000001662465868', '-10179817770585.137232390616515201742476');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 4 });
    T('-15.899462279', '308886629788805392480384693745', '0');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 2 });
    T('0.00000000000005787864', '-7.80284811', '-7.417629971013238139272199673767582796123401663908590423657497031555058682284153804962e-15');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 4 });
    T('-124433586765045.99829685196779', '4.3', '-28938043433731.627510895806462790697674418604651162790697674418604651162790697674418604651162790697674');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 3 });
    T('0.001131144301861439425560554607', '-50.0404909', '-0.000022604581');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 5 });
    T('9664584701747956.26', '-220.524899', '-43825367319397.14553502640987492301266171308846172513154625682426908174');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 3 });
    T('-70.094740430880', '0.000073254285972', '-956868.796150334825353555082222759529759627536786988423176163041831198316113183505074');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 2 });
    T('-10.183', '11933032273454430', '-8.53345550958790588136189212586e-16');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 4 });
    T('-29736253', '8700.333', '-3417.829294579874126656991174935488101432439425019709015735374726461619342615966538292269962540514');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('0.00000000048212885', '29110460.881250', '0.00001');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 5 });
    T('-18982193.25771004623685', '0.000000000918', '-20677770433235344.484586056644880174291938997821351');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 6 });
    T('-46898.939287762958868723', '-154.84896130729768720', '302.8689304198304373897050660480649147739932698320575588');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 6 });
    T('-736.040064754', '6785462.05675008', '-0.0001084730942');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 5 });
    T('0.14750193785287', '0.00000000000000000019221833596519455301', '767366636029866259.8568751222788549790355404');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 4 });
    T('97.7', '3', '32.566666666666666666666666666666666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 0 });
    T('25725.8309417978', '-802068.425741749136043585041290', '-0.032075');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 1 });
    T('246905186178997605977402', '755699748736449.29666038698706', '326723922.5523494590494444506845130782237605736040767460536008488');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 6 });
    T('1761946694.171', '-15994035825084456785', '-1.101627327486429467069944745236433100004619177818181e-10');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 6 });
    T('-0.0000000000034592824941049711', '155800958967233410222261.80', '0');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 0 });
    T('-165628.0818075039162', '-1660.013', '99.775171524261506506274348453897650199124946611863882993687398833623593');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 4 });
    T('6.1', '0.0000000115108583928302174187348', '529934414.2570213992514206144659067334355751837511402020097748572764397262506');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 1 });
    T('79.6765487483545', '-64638113.02', '-0.00000123265585930241160991119539337072064793391457825078693796312186961');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 2 });
    T('-1325.4526431089831', '0.00000000000000000316328834358410214940938364', '-419011009792172419912.147033054074431563097584718398200111548374447345258856');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 2 });
    T('-0.15736742596443911', '-0.000000000006199441964683651494199', '25384127613.568093276217026453299470655');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 1 });
    T('-7703543907102', '3.007202183901463022383421', '-2561698028932.537507540384252365699669732703188900300993841196283805');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 5 });
    T('15404621.4720', '0.0000000000000000038004912839753', '4.05332372079191356879942794920756510024545207139489987e+24');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 2 });
    T('-0.397391835935851010817', '-133797678838627077699', '2.97009514204759817547e-21');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 2 });
    T('-110', '-0.0000162146328953462154', '6783995.709922686856592619329903740238927539692022340187216');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 3 });
    T('81535305762924867262.3842', '4209656.737600', '19368635222597.648614128703679984342103855817243962262202288120357645000969449115304037325');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('0.0000000000000866345606234415543799', '7747124882046092', '0');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 1 });
    T('0.0000000000000000137029072682227285152819136219', '0.000000881683373', '1.55417553374035652992652200348344325644893385e-11');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 0 });
    T('-24.2536052715', '-0.000000000000000000210129343932237', '115422267150471659440.946101553035975211241209548721277513006464856778199802926435411352');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 2 });
    T('1669686.51135304', '0.00000000000000287487030352847584', '580786726032039799848.79613536481530428690282575927510569109');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 5 });
    T('-22067077.00922301', '-911395.20440', '24.2124129057168539123816350859877313614');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 2 });
    T('-6653', '-2008644586121049283021.103530', '3.312183771071116973243223e-18');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 4 });
    T('-93244887.6182', '48608417700077241.66115982087', '-1.918286832407050936334e-9');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 6 });
    T('-860835344594.186', '15989403620777', '-0.0538378644389');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 1 });
    T('-1.7825', '-2847048972405282.254', '6.26086877070500246829279599429901e-16');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 3 });
    T('13980.0140745', '422163', '0.0331152044932881375203416689762011355803327150887216549058065249678441');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 4 });
    T('27453298.7243917949', '-3967376.02404', '-6.919762220178');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 0 });
    T('3177824.7003906950471237', '-10425515321.383134386331312240', '-0.00030481224212225307571');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 1 });
    T('18582522299066378696330.2034149', '1343770.7', '13828640778569125.444043543600779507991951305382681732828376150782272600526265381437472925998460898127932');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 6 });
    T('5845735489', '-0.000394103143', '-14833009055702.96352597218439336323689253094842738');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 3 });
    T('0.13188581154124472618789', '-0.6528213060657947', '-0.20202436764211950142170611086000503933889563714424658073703470623916956321490786383609');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 6 });
    T('86791429156.659202979', '1491123.2804929570339922361', '58205.4015');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 5 });
    T('0.0000000000000000127782', '2113.149485585', '6.046992930300200288847233555284598510151547499992100517443810274167788460839e-21');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 4 });
    T('-2617586.6', '111536', '-23');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 5 });
    T('37030054236.0757694124', '-0.00000000000000000003975', '-9.315736914736042619471698113207547169811320754716981132075471698113e+29');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 4 });
    T('-0.000000000000000000541322608970996545', '0.000000000000000000052998971144844978', '-10.21383240613434202029666132622942');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 4 });
    T('0.0000000000000000000126149038', '-1.610067534458280489205530', '-7.835015320797944458056437926214003215e-21');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 4 });
    T('794375853290', '124881.67103676996495', '6361028.3774638570420370064288497');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 2 });
    T('1.145363030413104437791030', '-659980800709.9', '0');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 0 });
    T('10.534261958', '0.000000000000000047061071046', '223842375956621359.2120633522395843009390738718377786577670997275586');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 4 });
    T('-2.9049167569', '-34.0141849962616', '0.08540309747887');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 1 });
    T('-444.536278', '-737781.991', '0.000602530670879441403985150946846573271805437712290269226698974819514129343935151705268446976');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 4 });
    T('-336.064', '36023.656491885578', '-0.00932898080670127');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 0 });
    T('-6.1', '58264633665667035361818.929', '-1.0469472846e-22');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 1 });
    T('-1.41464728421911929360176', '-5.825', '0.24285790287023507186296309012875536480686695278969957081545');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 1 });
    T('-0.0000000000000000002694415597171509704', '0.152740958144576121156786735', '-1.76404261e-18');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 6 });
    T('-0.000342706198824227354729023378107', '-42567218609718459777456.2648', '8.050941781429538853063759206e-27');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 3 });
    T('12107227564675.217', '-4.648', '-2604825207546.30314113597246127366609294320137693631669535283993116');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 3 });
    T('0', '31.84853', '0');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 3 });
    T('0.084673856129762004577481829345', '-389.2532447720', '-0.000217528966725399062481477362098232061131300035630881916280084131121011417375828435705626251981234');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 5 });
    T('-15487575914223598308.2456153', '-7066', '2191844878888140.15118109472120011321822813473');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 1 });
    T('-218422676784436096400', '5056.70078975', '-43194700629149697.33799247084471021622601829');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 4 });
    T('-807346069698272071.114596', '4066662191536774681.039', '-0.198527940525391748518053704773212430736489129165543508955173628964823411161850001256383681063525766');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 1 });
    T('-1028.70188', '5', '-205.740376');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 2 });
    T('5952962.53716704950370407994371', '-2479', '-2401.3564086998989526841790817708753529649052037111738');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 2 });
    T('0.000000000000000019365709603030', '-6244211876.5', '-3.10138572906415e-27');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 6 });
    T('9.102028098037924220', '5930265240759.7093', '1.53484333811549539763766345e-12');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 6 });
    T('-2.09', '175217506055601', '-1.19280318904709755363024245374548870321951211092053728421809180676381661004e-14');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 6 });
    T('6530.35228348105626633386855', '4250507986361021.989', '1.5363698420131360200509150201873482089117026298378797097e-12');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 6 });
    T('-2001.714686985807', '1.6278003', '-1229.7053188808277034965529862600468');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 3 });
    T('-3999125495.505055323146302', '-1650754579.289701310', '2.4226045141282165250267914990506233922905');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 5 });
    T('-0.0000000003546152003', '87098.1809880', '-4.071442093e-15');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 4 });
    T('7686.41', '-0.12', '-64053.4166666666666666666666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 3 });
    T('17008982.901597', '12852.5038922', '1323.39838557991080691469809971694660818521000751025938677832443348808714084164407050402246911');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 6 });
    T('0.0000000006190975331411008971', '-1599829.22', '-3.8697726319881874460325208961991580576331766211896042e-16');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 4 });
    T('-163115836589544710.033', '29.71879', '-5488643265406993.69096117304910462370776199165578410157344898631471873518403676596523613511855631');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 6 });
    T('5257289988298610268609597984', '-816870426253', '-6435892179882063.140206566873');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 4 });
    T('306.600916918', '1151648641074631.3993', '2.662278285084443950868295801066532613014293687419597e-13');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 1 });
    T('-2045214.233517', '413457455140479.7471701', '-4.94661351026334979189093049432828253867506308947112481537775099643873515231581237375e-9');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 2 });
    T('-1', '-3661602.26438', '2.73104484813e-7');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 0 });
    T('-24275661716096386654.29800073', '245.785', '-98767873206649659.88281628549342');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 5 });
    T('-5552632008878974768445187975', '1', '-5.552632008878974768445187975e+27');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 1 });
    T('818159648.6768', '244115702596473698.05040388596', '3.35152405181090749628008186404258507666653773605447977668859045018011860933977e-9');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 6 });
    T('-15796333282922929455499903149', '-0.0000020', '7.8981666414614647277499515745e+33');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 1 });
    T('0.000000002082360', '19', '1.09597894e-10');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 0 });
    T('-99', '78208258243999', '-1.26585097562374586835550833861e-12');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 6 });
    T('-87591825036885332284936.419874', '-32.76607', '2.673247815099135547379848113429532440112592080771358908773618563349221e+21');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 6 });
    T('-13.99194714219043', '-175351498463913.6829', '7.9793712997952459641116235509868042e-14');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 6 });
    T('1384130089.28691', '526.0', '2631426.0252602851711026615969581749049429657794676806083650190114068441064638783269961977186311787');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 0 });
    T('-0.00000000000212499939513233', '0.00000000007240682698871396301175', '-0.029348052988');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 0 });
    T('0.000000000000555321932980958774807', '-1090.914228795737465940464197624', '-5.09042707779125620188873691494753470313655439031236863103412e-16');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 5 });
    T('-424555921771720.35307', '-228881328.337904694108', '1854917.2396663790355361642607437525602863521420340515962001637218134916730345661451066457');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 3 });
    T('909122084896', '40615.8', '22383458.7745655631552253064078511318255457235854027250478877678144958365956105751948749');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 0 });
    T('-275033147844970356791032348', '18663383.93413520', '-14736510207130049635.24362147911622458165648356299629041443063427770606019649246');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 2 });
    T('0.000000000000000000912924219932977059801557750', '-31362811384.8107', '-2.9108494411796090256457433013559775679e-29');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 3 });
    T('19195717211692613843523452327.2', '-0.00000000000009529771716949034797917020320', '-2.014289301133242718243099752615590254660068282237752019352055064398393473285901006691203161e+41');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 0 });
    T('22839435968756335976825925.7886', '-1400.9085784802758', '-1.63033022422725535268845225997557667897899183e+22');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 2 });
    T('-1', '480.136', '-0.002082743222753553159938017561690854257960244597364080177283103120782444973924054');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 1 });
    T('-3.1', '0.00000000003102547924589', '-99917876382.5433082369631082122258715714197495324277761342970442563578079746707084557250348277224401986293001');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 0 });
    T('-64842062381.1794872', '1', '-64842062381.1794872');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 5 });
    T('-0.00000000000029', '-405.209557011440027214', '7.156790726725446209851753467534831083526943237697522179267126899e-16');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 1 });
    T('-402440.646366', '-13820.8377666858638', '29.11839739093488649489320061497376');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 3 });
    T('-15766532924534.894137', '-44.667', '352979446225.0631145364586831441556406295475406899948507846956365997268677099');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 3 });
    T('-0.18545932128668082353226624341', '149853395295', '-1.237605066749320753401793941047987517338820934854681298464202408981526840619457317049e-12');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 4 });
    T('180176.7022950027042', '572424114259497094664651363', '0');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 5 });
    T('1189180.09948269121395358871663', '2396918591.035796963342618', '0.0004961286978748838588079275731640643086904538376747322163');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 5 });
    T('-162130238.50', '-541003.9284094244115796', '300');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 4 });
    T('23880963761.43070', '2036.1', '11728777.4477828692107460340847699032464');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 2 });
    T('4102911461', '-3676443725.1', '-1.11600007175096906802915991681528703620194031295278590690374878764');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 5 });
    T('-1650239242655225', '-0.0000000000000050625712483330699174451284', '3.2596859613552932393129153402861586036955044336911362958043e+29');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('-16182.764285316648602695', '5542940763.334796638593552', '-0.000002919526831742762543598887894075115469395923637093427826391782604223422627269491199365903503');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 4 });
    T('-2407603954205383635721882', '2143107365549', '-1123417329858.612809923082676425885742146282404083703459326');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 0 });
    T('-12339.440719898219344670280', '98703186807633789228.5882162235', '-1.25015626333798134296491858057012493610869357932089916422218620688080594916e-16');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 1 });
    T('-0.0002227041381338091297915124768', '178788347', '-1.2456300529128396147178008e-12');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 4 });
    T('-15846657355.062117827825383', '0.00000000100360520510159352655225199069', '-15789732132226220625.46707498843739636961');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 3 });
    T('-503475.661298', '-907234523646711946016951524', '5.5495646183e-22');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 3 });
    T('0.00000000000000017380472101435825', '807.54409555459', '2.15226291630546689744062968270283888865515459033941399292092451455048343022735791e-19');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('-163520122.133733234791861936', '-398865478.903', '0.409963084756');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 3 });
    T('1', '27', '0.037037037037037037037037037037037037037037037037037037');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 0 });
    T('2.0', '-6', '-0.333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333334');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 5 });
    T('-0.0000000000136948538993685388021127209', '-21662.0815699657428', '6.3220396687806380279671599940823081571e-16');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 5 });
    T('-1261219515900192.23821', '1616867.52132244271879742628786', '-780038871.007');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 6 });
    T('144', '939194785.95867158250614059106', '1.53322827333430905374910110906343649177622e-7');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 2 });
    T('307988608.8312845502416975', '45749.22883141104530', '6732.10492719435955626955333667896');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 1 });
    T('33316333.3281046085467801626', '-871263729.395801928', '-0.038239091338289261517183131434824955795926259835680146638135598');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 3 });
    T('-1157431127.9', '0.019931884955614253042634360160', '-58069326131.344346791615062099778998406644548');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 2 });
    T('-2232799206839243.258989787', '-7.404699948336398', '301538107204584.658047021668487234427606847211714');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 2 });
    T('-0.000000000000000000098180915239949553085671', '-21813.4373', '4.50093737587837901574874675986989e-24');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 2 });
    T('4242921222328373135613', '8.2', '517429417357118675074.7560975609756097560975609756097560975609756097561');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 6 });
    T('957.39281054', '40494.8188794629', '0.0236423531955972');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 2 });
    T('-8326808.497519433892', '0.0000000000000000000490705229500531361459202464', '-1.696906410798790393843617961526811289554079132589725760670291352160736862358530128911e+26');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 3 });
    T('896679849158361750330.3', '-137738441622013773066', '-6.51001883424134568586497747769574199893376');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 6 });
    T('-21050443445135200327662101', '-768532967305.3', '27390423496007.17132845013217685972688586659598916714817323805142988800752181030550845753599047354108117059851');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 3 });
    T('-0.00000000000004529233557356', '467.75', '-1e-15');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 0 });
    T('275310.274', '11028656591', '0.0000249631740482942017103558936990751025189845808301675860930793941700674');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 5 });
    T('541913418635146823954958', '10555.952', '51337237857385750139.34868214633791438233140885824414510410808991931755657850660935176666206894461058557295');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 0 });
    T('1977', '0.00000000000101254320724972684330834154', '1952509271549935.9654343768254088247606354930480506393749154718487737952702538576473345627569697789893884941849');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 3 });
    T('-0.00000000000997082', '-8', '1.2463525e-12');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 2 });
    T('-0.000013245144369', '-63328467267444968862608997.2325', '2.09149927994686876280205149202082357406793140080026504433216336e-31');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 0 });
    T('1709.084890702122', '7.79419809', '219.2765530163888867751371199753533592831741847608084079371916502060573110222298699621579671707');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 3 });
    T('-6.5', '1.5', '-4.333333333333333333333333333333333333333333333333333333333333334');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 3 });
    T('-4048995142031910647.396', '0.00012553', '-3.22551990921047609925595475185214689715605831275392336493268542e+22');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 4 });
    T('-12609.0384427562421280659598750', '-8.75296', '1440.5');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 0 });
    T('2.01', '-0.0000000000000595060042074436702083417336851', '-33778104021116.022665217883058809681921245023337809066415008588705222492653348391126863560929443112237651681');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 4 });
    T('-4445.9329936', '-1265484694121428880022659075467', '0');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('-507.372723086674', '97275886.743106276492', '0');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 0 });
    T('-1.4613460', '-2.61346193', '0.5591610052647677175079416595901972828814078037861450692721588640091650388035306104497186994');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 2 });
    T('28.1', '637.1296149', '0.04410405566285033786458824989081511301131640427847894094178606670822954395366311');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 1 });
    T('1614056018629639286992.0668255', '0.000000001995043946297100388', '8.090328143524891175220309357127449514597010377716670384132155189530961665299646362389627746812176231253071694777762390848e+29');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 3 });
    T('-0.00000000000000000336992256387394267526736', '0.00278761238', '-1.20889209276432567546114858336222484418726824566620700687231127881e-15');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 0 });
    T('14136588337891570845225315527', '-0.4708849', '-3.0021324399851366746364802793633858295307409517697424572332e+28');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 0 });
    T('520122.35441667105', '-0.00106639226761502159262351', '-487740177.9927763757352981916504');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 4 });
    T('-3.1416022', '6863044.0864', '-4.57756377556350939777055021541818198861453841527227290404602113733e-7');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 3 });
    T('-73888251352624360026', '1.019027898110', '-72508565751404401485.13531259242827482906938998131567061577668036745404703294988183569388');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 5 });
    T('-0.0000000001071532', '-34215005684429.9803651097097', '3.13176040327e-24');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 5 });
    T('0.0000000000000165091645065684622887738078', '-0.000000000000004445', '-3.71409775175893414820558105736782902137232845894263217097862767154105736782902137232845894263217098');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 0 });
    T('-497352.791066', '8.24', '-60358.34843033980582524271844660194174757281553398058252427184466019417475728155339805825242718446602');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 1 });
    T('-0.000000000000000000411700018405971704865', '3592139.1', '0');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 3 });
    T('10972491284.0775448', '-85621859.211271', '-128.1505842685');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 6 });
    T('-794448.75096', '27118343480723', '-2.929562240867447206618714738309475429809780153439e-8');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 1 });
    T('0.0000000000014196195975477079', '-0.0056327275608126093185', '-2.52030580606122107857192332768599843864183422831534835001654001071604463649295551424182e-10');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 2 });
    T('2388.932', '-174847412808.37863028', '-1.3662953e-8');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 0 });
    T('-904270784525.592260', '-1487101457806.47398128', '0.60807605276604524');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 4 });
    T('0.000000000006956553632', '-3809761.043588211608466', '-1.826e-18');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 3 });
    T('-222097736193251.4', '0.000853', '-260372492606390855.8030480656506447831184056271981243');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 4 });
    T('-8.020357521213419800', '-7461230.62753277', '0.0000010749376237771567387552680998629257106913482717513873708676896190549587473106921');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 1 });
    T('0.000000001487977619', '-14831757.761039625', '-1.003237541344324731681695588913489457056492e-16');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 4 });
    T('-1.3671417', '-30337609.555293895810840851705', '4.50642525907725825415613547e-8');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 1 });
    T('-0.00248871', '-5094.80', '4.8848041139985867943785820836931773573054879484965062416581612624636884666e-7');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 2 });
    T('-1631801844.1464211', '-5209700932.1295226557917', '0.3132237081178101556075382344313959958552079808832159382810898881498933311621493119008109764054131');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('5220265', '302.896899850306429208090', '17234.4616');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 4 });
    T('36129471206013106712004', '71316.2431811639', '506609288352918314.2438496347901928758057680753991964');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 4 });
    T('-0.04095799045794223557935162', '-0.000000000000000002045837039', '20020162738847664.1903987055539862087715384255490546918385321109635067077304977857525239575056887');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 1 });
    T('-0.000000450', '-13.2', '3.409090909090909090909090909090909090909090909090909090909e-8');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 2 });
    T('2416468777927017', '73368843.3148534680959960', '32935898.51971681121112106262843095746474481157602212900505');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 5 });
    T('-488930153.09447753670035', '0.0000000000002014703934348232568468356', '-2.426808945765269674922705980722179029088081494676722957929097356899777219475532993398117558416e+21');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 5 });
    T('-0.00013449517476975725317177', '-4009.66', '3.3542787859758e-8');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 3 });
    T('-2370941814.13', '3869939744', '-0.6127');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 1 });
    T('151634267.9959408', '-179885280374841901657094', '-8.4294983825228990180837395136e-16');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 1 });
    T('-5834723.5', '222042932132762145245.30724696', '-2.6277456543905430404066e-14');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 5 });
    T('-5182977179047885.6995271', '-1', '5182977179047885.6995271');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 3 });
    T('-275.960627353502935065449', '7', '-39.4229467647861335807784285714285714285714285714285714285714285714285714285714285714285714285714286');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 2 });
    T('435232.77562', '-0.00001546518685876415454550044', '-28142742767.66029');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 4 });
    T('17152565.5962872563', '9', '1905840.6');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 6 });
    T('-3', '-11463015244953733454402.43478205', '2.6171124576674228049372733594758776085978e-22');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 4 });
    T('96048852.6731', '-2147476359.33', '-0.045');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 2 });
    T('802308719785992.83478970621274', '-0.000000000000023838730872', '-3.365568092084767400824349609025612561141715464054675e+28');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 1 });
    T('-2469405771867598621970691794', '13208274832082.460244615114', '-186958993756663.37116178820599078371359019473821063140433284377352248576527');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 1 });
    T('63.875123211938', '150998.71801786282', '0.000423017652404053601423846679595081615559116');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 6 });
    T('5968.9052418179', '12.4', '481.36332595305645161290322580645161290322580645161290322580645161290322581');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 5 });
    T('-10092373627843.309', '125661719213560584', '-0.00008');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 2 });
    T('-9.640758704116', '-114294011941961818265', '1e-7');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 1 });
    T('-874445.630645176011', '121870243724375', '-7.175218526869000257915855129395306454293973034671008927176e-9');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 6 });
    T('95.70', '-18563880782489325261705682133', '0');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 3 });
    T('1.430642138666652442526502557', '-392019049568.976', '-0.001');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 2 });
    T('-113338383169.0552034434911870', '0.00003773', '-3003932763558314');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 4 });
    T('-274727599727.7349315563', '2.473802773', '-111054770706.14268066240056720964796169706613874832130766634887267142698768411478');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 2 });
    T('-0.000000000723177006176790642200537', '-0.0000043772648152855214738319769525', '0.00016521207573538569355249974275710762198470322975315');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 6 });
    T('0.0000000000000012036205956083601262', '70088335.8944243480092127517', '1.717290873365007784367132876526666300424035651543339613e-23');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 0 });
    T('0', '2694365.37496980120960923', '0');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 5 });
    T('-0.0000128808548871', '-113150287338.889039', '1.138384637815e-16');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 3 });
    T('64959579', '-2844.3362', '-22838.221093554271116051611620314082421058382620169865995447373626226041773824064820467');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 6 });
    T('8.3', '0.0002226690599953', '37275.0484516133167657984570860417');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 4 });
    T('-20396012735836189340289863', '0.0000000000000038055713585863487623676850269', '-5.3595139373270543140990778099093060551778324027594486634088540722918075417253512422242403145808377511038296551680862e+39');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 2 });
    T('-6499564679968251157540869.3', '396.03513', '-1.6411586214506402897997632937259e+22');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 6 });
    T('3049042776', '1223454.64540264', '2492.15840362971309031446140883774670563743674081366740871606642562100290557804812625322511');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 3 });
    T('-82746934.447', '-0.000014525734132830', '5696575036436.984038815209622');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 5 });
    T('0.000001758411398963638209852', '-1.243591206900', '-0.0000014139786363936843705034081');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 2 });
    T('-182.6601', '1.1', '-166.0546363636363636363636363636363636');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 6 });
    T('32957180677.86684', '-793.4', '-41539174.0331066801109150491555331484749180741114192084698764809679858835391983866901941013360222');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 3 });
    T('-2105395842137873185470341604', '914113.92100030522648107434', '-2.303209472878348370484730710269503799585183184090941166581925825770069246561308502688099882363764773e+21');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 6 });
    T('384433.68', '-837936819000580187.4041483', '0');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 3 });
    T('-44924.680363662327413', '1427815449.49888665769', '-0.0000314639265035473042299610791394');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 1 });
    T('4.2', '469161809505184788566', '8.952135307922127e-21');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 1 });
    T('-2.446', '0.000000000000001926000337', '-1269989393568834.0432517795556335876175913670154253976124823492177820942925411336519407888348671664848');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 1 });
    T('-1798391642460647981.97', '-85.801', '20960031263745737.019032412209647');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 1 });
    T('497190320699.5', '513392304.6658800203726', '968.4413190086197216716997847');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 5 });
    T('-214020470807', '558884.0577', '-382942.52243974859760971134961755055980728147365080941724632772612365035081586654462196158');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 1 });
    T('0.0000000000000005509', '-0.0119736313841', '-4.600943375721e-14');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 0 });
    T('223526700163168.46486200', '-1', '-223526700163168.464862');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 2 });
    T('-25286459726182070311791.909', '433.7360740475', '-58299185240038067511.28129774424559013541570090517247178984773028120836638467521748428037638736196547396310559');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 4 });
    T('-3.84', '-230672031462873433.0153', '1.66470116712786066303352770626517164690855571283072395514036e-17');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 6 });
    T('632950152864580.65806833710', '1011836402.79441682522548', '625545.93916224456910414210535241390621121167829557801534106250932338');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 1 });
    T('0.0000049339291', '-0.000224984438551534164275604594713', '-0.0219300905065478611457684694214449309434783552017018631671257490485809082');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 3 });
    T('-338.94738367925637130', '-0.00000000000000108308163937159066800236', '312947215942018297');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 2 });
    T('0.000000235260614812120582298055', '-0.0000001110910457371282365718838359', '-2.11772797034255549563416');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 1 });
    T('-0.0000000000000000107107322284477584466235196', '-2391721641165.67102534484', '0');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 2 });
    T('-0.0000000000000005398629480878534175959', '-0.000000000000000136008', '3.96934700964541363446194341509322981001117581318745956120229');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 1 });
    T('9252954275750', '779920382572.108232331', '11.8639728907129951645131952586665510691059605616223');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 2 });
    T('18551323.658736281693135', '0.000000000000000001083710261119958768495433103', '1.71183427197269901846890303728930083400789583517718237462254164308070293413156940798718e+25');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 3 });
    T('99120792392919606582512779054', '4537894940425.523', '21842901542278753.061995238086054191528706471608646417028260674251502929926905209213308388020971982838402146645258077');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 5 });
    T('-0.018317364097', '9108893695511350715.938', '-2.01093181118431183740457551868150570844544523605691148485e-21');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 6 });
    T('0', '3.99909', '0');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 3 });
    T('47249329.6203246', '0.0000000000000000931583884570847', '5.071935056292967267476182009888681080061574005814478713655830342537044378983434440124388626884310855e+23');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 5 });
    T('-6632917305.13784346', '64275', '-103195.913');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 2 });
    T('0', '-1.1479982', '0');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 3 });
    T('23.0967232', '384787.39531594', '0.0000600246356329728956379107568015799360998008653288367583039130337974343366992013749911280684891016');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 3 });
    T('-4415.59578', '-5372410.269367', '0.0008219021926112623725445542');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 0 });
    T('19316731927846138142235063', '159905027625861', '120801279450.9664076025188136923298399099407554218077763806134954509770172738601456973870831070721922');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 1 });
    T('46.5509916352', '-224.72783911451', '-0.207143858182518974872177506176201666620231893723310558999073');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 5 });
    T('-0.00000000190', '10283106', '-1.84769076580558442e-16');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 6 });
    T('6320896863', '-96.36193239591436266848', '-65595372.6314853240033007239640504363062001768345687037728328017566');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 3 });
    T('301.78', '27385431970323599.982109011039', '1.101972758096442823253204778745779442886349569482e-14');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 1 });
    T('0', '0.000000006392962922861835147', '0');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 6 });
    T('2679177081032425767', '-27531764737796501802392', '-0.000097312217598400597951764759122021435057787');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 0 });
    T('-22441668653796507212372.4', '19207705157', '-1168368030973.12908281291981516644435235069659185939366926320421547899336072675222604157553');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 1 });
    T('133549443521931581.906855', '146203567577896984.3', '0.9134485959159422766611615024730449619301718162748067575802409439785938547408037424');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 4 });
    T('-1973.3', '-7209198961380.383', '0');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 0 });
    T('-4358138915031470322954690950878.886329', '18029764583.0320924329653395024835', '-241719124781747737817.71414364474833657361287091699324842760959752');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 4 });
    T('-0.0000214327748810414114303341654806744', '-0.000000017085379167844184125664', '1254.45122818107041');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 2 });
    T('1540.1', '-1425597386989588797745164.9723', '-1.08031903962184199768125145492905743065463781105236977988615625182125023686e-21');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 6 });
    T('-0.00000000000000077789825931627563318456329252077008249901827', '-11488403098437.659253590452', '0');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 5 });
    T('-0.00000000000000615479882', '-1.4311', '4.30074685207183285584515407728320872056460066e-15');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 6 });
    T('185.078', '-21444991541014268320202.565818494950093203880961480246', '-8.630360130757435548395346186973954342934428993977502062613538763e-21');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 1 });
    T('-8403047783.120864544336509023524769', '-0.000000000000000078190', '1.07469596919310200081039890312377145415014707763141066632561708658396214349661081979792812380099757e+26');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 0 });
    T('4473003396718403421919082.611713344497', '-38417.45740577489', '-116431531360168154589.5997046763279826');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 0 });
    T('-277824796039913334543271479781483132162831479540.0755025060', '0.095719943083002968965774929987', '-2.90247556665385023432767761396065649281824544931592998896986675081931625237505184e+48');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 4 });
    T('0.00000000000480152428506069103957', '8069769.20434799655998859066255015933021758352308471341', '0');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 5 });
    T('-5340545366390612877073.2853', '-1040.695', '5131710411206561842.877389917314871311959796097800027865993398642253494059258476306698889');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 1 });
    T('128346487385118982217601527756330318.32681', '-79533315369210789756297.5093144498895602545561685358154358', '-1613744966990.3351');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 2 });
    T('0.000000006632234145795642791822618250723750481', '183815.968207832561239237830808792285843424648628102963133314', '3.6080837864406153478491135463736e-14');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 0 });
    T('119187872518674.60527655439323732477', '988901492413169302830866500425857795341646.4908639', '1.21e-28');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 4 });
    T('-2106863123095.357296277145943882664823531441361779337', '-0.000001780807017292321314224', '1183094576019133877.30319497876236979272050322057698912933377664141368828772347');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 0 });
    T('2', '-12532644992723.506915213853468150635', '-0.1');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 5 });
    T('-2045474499442314493533914694359611192421769290', '-79.7801143293890064538106805679656', '2.56389015813783140881031622900806078899721203732113311997893479064590200658081902329139876513933329019112731810687326191885e+43');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 0 });
    T('167818325272.44229267', '3604.93', '46552450.469896029234964340500370326192186810839600214151176305781249566565786298208286984768081488406154905');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 4 });
    T('-15043187989467552228909212', '-0.0000001256248795877713296556543872376', '1.197468848434374731008452641095000047995170305648878285566e+32');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 1 });
    T('7998870000070061263277', '-26543843297186440621735904979552147897363942278950', '-3.01345585509763575250102538326648638249839863370004343453062e-28');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 1 });
    T('186931322330723238889.9', '-8437975.1', '-22153575960507.7809354877096046419952104385802228783538363368718639617696904557113471453595543319391876');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 0 });
    T('0.000033260133387301381636134255123645581044625132783663', '0.00000000091', '36549.5971289026172');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 1 });
    T('1.7465938', '193', '0.00904970880829015544041450777202072538860103626');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 1 });
    T('-0.000000022616261038169584', '79255422813879639941760997747.1367068030864', '-2.853591620005704086326498760681941494986556861849305029108030768e-37');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 4 });
    T('63925969210016.171616618421', '-0.000000000000000001998952851878522909618298952831777425008911426', '-3.19797283612474997830213615498823898997462341033957771240421614362e+31');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 2 });
    T('-0.000000000000000000107951584872217583243487104532878733600748082262', '4.7584', '0');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 2 });
    T('287879454865962605748634828463.143352997052678922433', '0.0000011099839415495924789496834394776605568026699033157532725166', '2.593546123415701393690678024535080924566944608085602841986648129658557077697497509144729455581093725286069074168844031180128663e+35');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 0 });
    T('421290769878188.44965397506247576163716334347466036131', '-695290179.98023799179742953756', '-605920.79');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 2 });
    T('-50.588764102894', '-1469737395263449361661861746995530.7961293255083413748731405', '3.4420274170016610853e-32');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 1 });
    T('71825729291974748475', '-3487925170402093447966915709296985344.79514361227346', '-2.059268068635043752814904577559487216735436672e-17');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 5 });
    T('-195599191873495.035306732143', '94922439367019975.93898951447276490022725129864755659', '-0.002060621210093494209086288239396527883002832627329896345270729976350454248118360433421084167526');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 4 });
    T('-8298636455267829969272001790569', '12441338.5', '-6.670211935209246150863913710384939691175511380869510141533404946742668e+23');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 1 });
    T('193672718244911748316310.95', '32025627598640491403990244863864935493862070264684993094', '6.04742928607379673691357771393506072163e-33');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 2 });
    T('34211916252046207724173639367665.73', '2213017876522886287744383245.8137737', '15459.394438241176844242330642075713842374671533599');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 3 });
    T('-51102698466952108661987108352168504578549351669673607306504.8', '-426105160328610268743577', '1.1992978077886207989099912552560016492808203461057166111391637632e+35');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 4 });
    T('-0.000101118126658365675783246638377813', '48187783117573989816933123531631999309', '-2.0984183151079239767283259802182599811803883e-42');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 5 });
    T('-18339345307912384963.705031044423259760626683581224957714636', '1.25501030272431063608661224912151589098512453059762475047532', '-14612904187401724640.7077');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('11733626597810620260900194913480892214.83238408124932480450', '0.000000000000000000012593148030063312136', '9.31746896788572839054694954351994165865763815272869861443498428106859e+56');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 6 });
    T('647049772487082769486131722793669960.55', '0.0000000000000001061070889473924760124131290400487265681320705654955', '6.0980824081215514832347135028491060346583271458502108696485040787360284799746369844016534098242406e+51');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 6 });
    T('0.000000436698220827227894615051167309259870460497230915', '-0.0000000005841497117', '-747.5792799012827016260447592193168764693190396639204572597240913779945977503081938095562360610508541');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 6 });
    T('-37513654565218568136965757801.924083043009620922', '-15865721697985590918663290533489768.90', '0.000002364446778994083275827835226151');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 1 });
    T('-0.98347293041966760043529713', '1156.5', '-0.000850387315537974578845911915261565067012537829658452226545611759619541720709035884133');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 1 });
    T('125176113754065635.8920', '4', '31294028438516408.973');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 4 });
    T('7760475.985296', '613572764342975.528571424937', '1.26480124873307466949099359027788016239202160901478534560952858567398389820628355e-8');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 5 });
    T('342098206914085968453220098514855365282100070', '-5165030720317219514520097.3608', '-66233528015313605114.67568754858297559280470661979590349532852678391');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 4 });
    T('-139498.75765393143263357632022519885624816', '-5831567121073581992795421673.6', '2.3921315618545077972373650801742926030882156512774998442153565319318e-23');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 1 });
    T('-38429863125.34', '3781400327394870', '-0.000010162865551930489712339099696515327376718924337987713498883079662540061533572931830509691604');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 4 });
    T('444068824966018.962300196359416176247976643926867420059834210', '1891413422', '234781.4707249227516057017593777952200535055349033153153939128597343748785134718156821877517584836087729');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 0 });
    T('0', '0.000002513915127705055306056640528958850699699738670', '0');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 1 });
    T('0.0000838632325862484536350098267314013808462051735760', '337423.030731', '2.4854033349343543578311333157652438e-10');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 3 });
    T('0.0004131749462', '0.00313847736137418425513550014648', '0.13164821619713423520927479472893363477634355087719536919245876347954531603582571976295');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 1 });
    T('43858700.0293363960939216', '-2599614823572595448893772454340010230040671331440', '-1.687123e-41');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 2 });
    T('-904125891989.3', '-4990657690680025.468181105292963130180267545', '0.0001811636758172656972061239309710892703790054');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 3 });
    T('0.000000093168465371689914647', '-0.0000000000005411225', '-172176.2916376419658155038831318232008463887567048126810472674856432693151735512753581675129015');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 5 });
    T('0.000000000000000000028554140680060', '-101.2780662948661400', '0');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 2 });
    T('-246157.99057958574881562217581994144426', '-5.345', '46053.8803703621606764494248493809998615528531337698783910196445275958841');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 6 });
    T('-1886816427992533234539229418864549307215.4784746048900326', '122.037427', '-1.546096533150058329678836492402080311981240373582188054980870745496789275965315132381478347621996324127679289731337911606412351e+37');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 2 });
    T('-53819387.67776846439676506538154669384035465454678811', '5665364.9440479410496592303761', '-9.4997212376073610606159188035294123164780013803617164013005984101222925367506692183964840995107');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 6 });
    T('0.00005686363033975136662906365093969614774037009988694265', '-48200077251340376', '-1.179741477243588224057499806813833527192369820508921489528640410001657395306e-21');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 5 });
    T('0.0000000000122869862436239838756718951003949613429845', '7.6', '0');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 4 });
    T('-1347317275008.10206071427330257630227482457494766279', '69000.23', '-19526272.23138389626692944795367062218234018854231051113887591389188122996');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 6 });
    T('-9727252508944082022316065757779070333921212.85', '188085887081717930385302.7678711814739', '-51717078085278505960.5');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 4 });
    T('-0.0000000014742345745628408588118699794934331774364407395001734612', '-7481382.0977534045', '1.9705377366109144191110042861992342302928651539163664891404646115927920142340563e-16');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 6 });
    T('-104698165188516.36027213667980567646491', '-2172843537871425077764953721938488541.89', '4.8184862e-23');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 2 });
    T('0.0000000000002645228752463466030700107177183293746878390282', '-452775.4895417327493755177358', '-5.842252536993067001665276434092777724611662996157773525922966398679141919241e-19');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 1 });
    T('1602367518942292542112439723694.951758582993078837518540', '1638319886465.5249043202490238215560676918', '978055343269503244.018485844692995577857027');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 1 });
    T('-12949514164.3046335907044971050036463576514259298838238', '-212.231913361', '61015866.837509520363054731');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 5 });
    T('733141709040640273329828977521564929309588005225.7', '50303.79', '1.45742837476190218138599293914348189134374965628971494990735290521847359811258754062069677e+43');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 1 });
    T('12077750.6291575370577220', '0.000000000000000000252514056706', '4.78300130563407046138669704097973813017484016848774090044181510548497361876603267245915583108702662972e+25');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 6 });
    T('-1679818566679125024187586427946214017262.883222815', '349473839348.02797698', '-4.806707620269843131722151256967209072971614676290512684832283825e+27');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 0 });
    T('0.08029436596716315538113734732561036194186232269297000990', '0.000000000000000006851154249897162642328142839821636418768119346', '11719830416658388.88002685923929076');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 5 });
    T('-1026768618795574006.2846223162551677285190094', '-27738938919837948725957689635733986', '3.70154252029180503021913367026524596e-17');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 1 });
    T('-0.00000031340912183197', '0.00001876658699629442685518077130407260330656', '-0.0167003793440892836404270533895010391668087118954482824834223019831457212942');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 4 });
    T('-67756988833335965947898002.397023603751040399832629502236', '0.0136674856433809637223379039', '-4.95753137053047104805901743778895648014262824267606598269739554490371038184499242988205724609842894078111956417934304762162392e+27');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 4 });
    T('0.000000366237795258926865181761033018233240088862403534465', '199511031389040045529', '1.8356769182590963269880941397590613649631186609371410182487e-27');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 5 });
    T('-95114948561513352172', '1492872272.5581130', '-63712716961.732447911884465826');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 6 });
    T('1.9', '-13680157281285098755672610111559871101171', '-1.388872920780861164025823e-40');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 4 });
    T('-23438535109854009568518651705670252727680354016246612', '1', '-2.3438535109854009568518651705670252727680354016246612e+52');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 4 });
    T('-0.0000000000239', '-10701397.52331632160190', '0');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 0 });
    T('21975460381002361.83687232309627337826198946029615', '0.000000056642789', '3.8796571936107104183857053889548726603115288507686300545688172240247562668569e+23');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('16850767091655686029451426.7130603982866', '-30034629512168694102403019.8476595706860421725434916421523', '-0.561044613013405267938804354742942797338932661092870945282555616957947634505421502503');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 1 });
    T('-0.0000000000000960007504494707406733732011306869108413764', '10.407', '-9.2246325021111502520777554656e-15');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 6 });
    T('0.00000000000000000757362633437637', '209261111569596898740570182929.88161793119', '0');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 1 });
    T('-2612640565385626022001698972052921169.999233419551243289', '560104404385.626664333997', '-4.66455993726992250681589081531779854598501528974818146e+24');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 5 });
    T('157481998763563933.576298867885808342438534417952771481891', '-17365225068071338577270941492358476226826704', '0');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 4 });
    T('2546388402471796199060769918930023442003.845194', '-162325117491540253127.367180925181780016674989346', '-15686964789072177633.7308021600152706');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 5 });
    T('-6.7', '107334.87832289565536386490138297725435040159', '-0.000062421461734408280638263949652154880714318776');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 6 });
    T('-38.5560487133305685938268557071730315816087', '-222170.78', '0.0001735423925');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 2 });
    T('-7228207240915961811063423227702494933547823017955', '-210608526491.7123296', '3.432058217833074998553556902534721687588631411359151918877469887845134363144530332419641020364369812269208316728796232274038864052587e+37');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 5 });
    T('7087077732911514990421.718491155248900', '0.000000000054212903555214315260270041468711838687704671209666463489976', '1.3072676924034378532462856132938590938744655957106487796637555435091072405316658044229e+32');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 2 });
    T('-288036.80', '-3672.50405', '78.43062827936159798108323393135536501314409714537959461201955652029845957555853478228295');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 6 });
    T('2782501838850655112.13235120', '0.00000000000042475914269995684999136', '6.550775625837842096570379023636036657744290078928999172875994347834566697861822510732512112e+30');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 0 });
    T('2085966385769.6822146429426148124599816822567195055374861885', '-22668740650478182.1330389830836733875708845803617129', '-0.00009201951');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 2 });
    T('455749240058.432717871764', '213.285963473032811', '2136799030.9219583556592241253006390014049940692494738');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 6 });
    T('50.3693', '3241719836350468739346937.216525', '1.553783255270628371879735301438597473641575332591253120094778e-23');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 1 });
    T('0.0000003390997721026708632209297630764385534425751', '80609843.11345', '4.2066794699677e-15');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 0 });
    T('-2219589450028777558675949700.28245589983487', '1199614667413307000681332845525', '-0.0018502520103516335631572514110011223624779207645650784747900292773');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 3 });
    T('69265035793457102886394984752176.561556505', '749235603622.5025904992719110654932593467136994978363', '92447603208610777141');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 0 });
    T('986426', '18586275440565367354374527', '5.307281725993803316392399815614888085176102744474073229243384378909257740310466e-20');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 6 });
    T('0', '-290816038635.723038753', '0');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 0 });
    T('-0.00000000000000000132916584702643508382547848857588943508525233140219000', '20155284063.95184432', '-6.5946272094655146379665613405234206222864897459e-29');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 6 });
    T('952063481.98599187118379776', '-4232866339274352925.490937701343567028706315', '-2.249216974210448711950095436068575112528955438753532238294e-10');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 2 });
    T('285292430610904911895206', '77527243764697.175429459855502609228198', '3679899049.12388672411083524731437191683055664146980717875672125221546893380027765641035958262393785');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 0 });
    T('0.0000000049141233322', '-119732610266833732648839394753', '-1e-37');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 2 });
    T('-104156583', '333240.6552807296694373304883172766968807443129', '-312.55665042506915864071589114922215519462865919862581560781657669877652');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 3 });
    T('-775.5672039409328626401114303362741', '-0.00000016693416752333222447217245221195848', '4645946455.704058');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 4 });
    T('-1042543329667310875144385693.47870820', '-133302423882869890929240172948256058069482.13942800', '7.820888e-15');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 0 });
    T('-0.0000005594168136250496551943633409366356584941233836', '-155333163.57129', '1e-10');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 5 });
    T('677741.0', '0.000000000000048545611388960621791794106024302515629563001129689242', '13960911823104977636.4886632915329065906279945487485181517422914');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 4 });
    T('-14246783475672473094374', '-149283577.5840', '95434365294842.8731861493515746127832964917135851376288115043275931248129565860364757588485313212481351');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 3 });
    T('0', '0.0000000000000001207848168046516341108', '0');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 2 });
    T('-11.7', '-74647750.91858573128961021604743782694040686036489112681', '1.6e-7');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 4 });
    T('-7.34', '9698682311027857455398833030730471.224716275', '-7.568038383579257100616746e-34');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 6 });
    T('-37882578334427751786191262.1476669652295625176504114442012', '2720147194985163.7780019', '-13926664852.647568168691796876660485205133557051303933672373585206310547581627923');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 4 });
    T('1784297', '-60643972817184956177051299.216334', '-2.94224952144687939890351676962907764881403e-20');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 1 });
    T('0.0000000000000610073339077686555597847598696588553729496062', '0.0000048710639217445150719', '1.2524437143070704396881275046e-8');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 6 });
    T('-19575885010043762585.63479', '3734076.4363074380470778410612747870', '-5242497132544.508926971018355016520670701306627656808444557852280137119362113687811956');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 0 });
    T('301294982924.2953454775741211743365342540', '-19106697449406581306347.7847967800301', '-1.5769076980577457698713369968322206617602949168949e-11');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 3 });
    T('0', '-69919.3263764630460591434529218712320080435258723093898298', '0');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 4 });
    T('0.0000000000000230003592864206349802178664690183622903390185298', '2840738519640.265058610', '8.09661259823845717370098303790512562658009194223844875415776022496483e-27');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 4 });
    T('-44.02944567871767', '1636041557975908022265540917066623362361723537410', '0');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 2 });
    T('-6', '-18722872007463096014328377948433835478279841645621014', '3.2046365523453607822e-52');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 5 });
    T('-4593464186153780906583342.5527540561004903434686', '25781719737565225271673922242095', '-1.78167485835356404293325963720725819910427821e-7');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 2 });
    T('-3363720.8930635', '0.228577321666', '-14715899.4975827498416165644249692124660543400874306751620873636105386668495482448943430783335128');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 1 });
    T('38128866863866491251', '-0.00024252108819812315909452383049', '-1.572187686735011354247874527909662003073945e+23');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 0 });
    T('-33176721817409588820003', '0.00000000000000028786703467057093436292344521684978816952674271926', '-1.152501600448149311646257647082077178772297210692101489433777607983496766321758013882645200002485188315714675666279583461034e+38');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 5 });
    T('-883', '-12752496287481.24135354', '6.924134538794696151120500756281595757849e-11');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 3 });
    T('-29.1419953', '1889484740363126046982459976594.076085275754965390', '-1.542324988261055e-29');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 5 });
    T('-3341584032814423339321004883614949822747200.2985143717692', '0.001227', '-2.7233773698569057370179338904767317218803588414950055168704156479217603911980440097799511002444987775061124694376528117359413202933985330073e+45');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 2 });
    T('-3874880850169314237450658694725279481210339682732447536', '-2680406.51', '1.44563178596716444978737896541121274966995199647252294429026737440657835143073130351410764183e+48');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 4 });
    T('0.00000000060223997248190123283043885606751', '786.6994', '7.655e-13');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 3 });
    T('-0.00000000001441891961132955720389216634310873951090606763736348', '0.000267', '-5.4003444237189352823566166079058949479048942462035505618e-8');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('1313524088747.8', '5535335650070248.726249801889459975', '0.00024');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 6 });
    T('30060859029542.3848692854', '-55375941130.729183', '-542.850530676778540030474685565763103760275544100911084559401425971353455');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 0 });
    T('-0.000827100719268175671086830191340355899274', '154.278743238288983774258', '-0.000005361080223415414479471738');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 1 });
    T('0.4765257815828847644182356988704735378797', '0.0000016095806197307715196711016292844', '296055.864329797556126269465789748940552603559236172');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 2 });
    T('2383839881.66464', '1.676805832', '1421655290.1783084924289552447119589932342267759956121144979414646978637178308668955058835');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 0 });
    T('0.000000000000000050606645897867672442972574275031289410912', '2693549667313129709978520437039434348086562053.82187', '1e-53');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 4 });
    T('-0.7258504577695793943509193554861614365708806', '2.524314960434057069225409849542066825947300924443437', '-0.287543539196380268036218735171571647050319839346168576535269068687');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 5 });
    T('-0.000000000000028885584156185150', '77.5', '0');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 2 });
    T('-0.06711879785767251358135011891', '2385212433376839016587.586621319136168265', '-2.813e-23');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 5 });
    T('0.000000000000000000083432058951516992373882110712631865853005711342023601', '955440228312237.9699983760968458', '0');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 6 });
    T('-159860539866213251269608', '476291877008672', '-335635662.8843002896752642873393704929807001077300996436388197649030326733847717933186739168519148601668');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 0 });
    T('3.4055961543833163031955623902412873943633179220658580', '-5638173.314118741444977300', '-6.040247372061527821806277144762792364021425249203651092590971694125336372532672131595112108e-7');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 0 });
    T('-3493556180375848730.848130393358438160491', '718685222018.797305232950026805146', '-4861038.00849334051793473');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 0 });
    T('23.485', '-0.000000000000066598986405042017256663698275584502078182', '-352632994399776.9064690649941293302469561880937591761458806724536981375061501064450685308282170615944879');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 4 });
    T('-822.90', '76092.60', '-0.01081446');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 5 });
    T('0.000000000015084', '-0.000001912385433146559342084020', '-0.0000078875313200756892604204464311476238462');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 3 });
    T('9483186004328519.899267358722553159293541088', '-320.45595501616058746075866630772838', '-29592790696775.42118699025');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 3 });
    T('0.0000000534', '-38740477182.330224274977499027165728234634799426529061021', '-1.3784032589138080220562463869113934987094771722083508684729812045379072e-18');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 1 });
    T('-0.0001954657197300273066647138944844914845862509008372575236777', '168060.67886884789467094219584088427984858277529', '-1.163066e-9');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 6 });
    T('1150344439.958156697', '-0.0001115798448123750060997401563155120021006060102', '-10309607813960.45854166944088515213012733315983456349573700908178034971170409565162');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 6 });
    T('0.0059295', '-6327267465345.7543737378793777186620446106878506104333', '-9.371344000353526516217144486032579896762423824055952274964299224467874251e-16');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 3 });
    T('609963081962334114.937377417886308919172152824323657593', '-0.0000000034870603144043430699562858194', '-1.7492186167319779613825396256986094509717728289296461637619523489196444381147883e+26');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 0 });
    T('-0.0000031852353441801206076222381975926616222634740191', '2.9856013', '-0.0000010668656073334777177455804959');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 1 });
    T('-1488864252921831.25831536732717807799329136', '6474156.733', '-229970375.18922099569679468');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 2 });
    T('625084489642715799565494363.417748488859', '0.000230873', '2.707481990716609562683788764462490151983991198624351916421582428434680538651119879760734256495995633963261186886296795207754913e+30');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 4 });
    T('256770123819.9', '22412746815438521661854347587580733.8915585015437419311582674', '1.14564326244487630922539542203993e-23');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 6 });
    T('-0.049911992', '-62810718780308357014459144405688282702', '0');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 0 });
    T('443180719833539342827985492522430618.63430974702278297928', '-0.00000000000000525611979007928380995849101', '-8.431708894268834058898041333257166278406932019074937028707916277144897108740020410537475905778879362684282621457193747163618998932277384997601111814e+49');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 5 });
    T('-0.00000000000000003450293376086498436791378576700539008489930', '2033.857978436912', '-1.69642787877360271584343942176475323384052341883641062769887571758013322426814447e-20');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 6 });
    T('10723887443064792481210151761395366824', '-226.3479643498394316073', '-4.737788331283660546772318293399771486485754243656984350212254100827492754718091434214376133324e+34');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 5 });
    T('0.000000000000000372899189091300451367945878036123625876735470022169309329', '23254426481409060097', '1.60356218e-35');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 5 });
    T('57446960.7020586268901672397015', '13924561060097769201834626.56987437985184', '4.12558503310231250724824967455819889067e-18');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 2 });
    T('0.00000000000000545056475271835430103855248600970440971406246221470171825', '0.00000004298708852646016198291685535720397', '1.268e-7');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 1 });
    T('22261699938052229573323683185837366581633512', '0.000000000000014887331841', '1.4953451817835535257028387472374987937661241254520108738671058685914865810775e+57');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 1 });
    T('-12758219415.0261496467012388529078170409549623267451973', '6.0183243288', '-2119895625.095037773880704794379976991736989807066377406164093');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 6 });
    T('3298265783586490569932640', '-5219021966096084567874.4', '-631.9700903756970309117387678067401491846779965274936773895436458197783981034864011295595793733798');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 4 });
    T('-3.1', '-4507.08745151922', '0.0006878056024750688990088');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 6 });
    T('-42971.695', '0.000000000000000000017659192036373461', '-2.4333896427135056197903261465912904582316910976355800931381818188432390339e+24');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 6 });
    T('179160.757624028179', '-7163360.4386559665142872334563278482982880917873', '-0.02501071377858007321212');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 4 });
    T('1677504.411824', '-14646872.6189014099162', '-0.114529869650072875358731469381513318575548167143459977572541');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 5 });
    T('-0.00000000000000782882328973611235818109', '-4788.62', '1.6348808821197155669443576646298933722032652413430174e-18');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 5 });
    T('-398596073931934968473113250377', '-1127648875665298404515191860194593', '0.000353475343729464002040920603210655494527390322158152328576373824293514');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 3 });
    T('0.0000000000000000001826692980', '-1085386369186475721916.07909005', '-1e-10');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 6 });
    T('9.94377259201165', '-0.00000000000000000003785930736782844700997577207618252837298333870663517930597', '-262650673859435951327.9002827234361612178385404817872748226720771470032061529620073091462587522075');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 6 });
    T('0.00031338426831763587995996978365091836671439981903', '-1.9710177424701826837705881355', '-0.00015899616810393918561267830219250011019280978988464367850746121454599170133872951957');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 6 });
    T('365.622', '0.000030469303056299', '11999683.72510620954999349701386067517253866452');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 2 });
    T('15.5497', '3270.25410', '0.004754890453313704277597266830121855057073393776955');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 4 });
    T('-870200101503721383.51965', '-884576667833211780595521295660709623938837953807417017', '9.8374751804758078968275622511295837083002249e-37');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 6 });
    T('-8627201481634031472775639.02', '-35.88954583151', '2.40382018823419996015933836240912383462062392472807889733222073668766587140736811419758426482048485e+23');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 4 });
    T('27166159113573153158218.135032422640', '-0.0000000000000004254856686581243705034381532416', '-6.384741276774007537705363563056955219895020671530279717600122039908e+37');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 1 });
    T('1.15', '-22864397113383806966051253809220365902.8247924106561', '-5.0296537201361012708975757086664320480315e-38');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 2 });
    T('0.0000002333144399314152774599452', '11886.0084271', '1.96293348908839995365465846851990744875382286779903338135333939066e-11');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 2 });
    T('-1.4', '-526030357.89775934608923525372', '2.661443353944427117747712072585784816383e-9');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 4 });
    T('-78185011.374385749', '-1177.93747', '66374.5006552731097008061047586846863781');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 6 });
    T('0', '2', '0');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 2 });
    T('-0.000019691624801077', '789724640172607638117.14615891967744780537294852202576', '0');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 2 });
    T('-10398074866566369874729479404758795484097', '39097018415729345107193924086732344183', '-265.9556991');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 5 });
    T('13471.08', '342569337268989267429289.929240095140092421818', '0');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 3 });
    T('504855661348378460.56691121741008042', '2674583057855000818082.15776502', '0.0001887605097421313958154576626856770256389188979522609360577817944863888582115807348244806395');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 0 });
    T('1252955516184.1', '9179631108025347.69919', '0.000136493013873803284442700977622413');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 6 });
    T('100572331', '21381655.21', '4.7036737807353315749');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 5 });
    T('-0.680', '0.0001023962933734199876112', '-6640.8653828920167158084148');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 3 });
    T('1408586402592570871877536736630', '-71282669808626854262807002933.430075394538', '-19.76057304');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 1 });
    T('-0.0304672086581822723', '-2304150208926492958299207311692957050618117750642287631', '0');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 0 });
    T('-3257773.73321142551666', '-136126208859759763315457882399157905817562572941969190802199', '2.4e-53');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 3 });
    T('-3388911005216920030200707342267.687215707301269933121655158', '-2.24042737441029', '1.51261810310138977469895800853862078119029023683878514951826991960514629682667166245531906432205873462930761431097e+30');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 5 });
    T('0.000000138115063695530081270314206', '-2205711745203109613847465751461780.624840399490493415533725', '-6.2617005143984471794719823e-41');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 3 });
    T('23898689430389996578244006638947272744264', '92111697653220', '2.5945335977155944600896827812182218409815327692208641481173354255626639178513525332308175610201313823414824115e+26');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 6 });
    T('0.00053276620201795190372807960271', '-0.000000000000000794688709486483208304658286', '-670408671544.1295421');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 1 });
    T('1026342337656.16111542877485828326751384551678666163', '0.00000004973324483282952402954896455', '20636946998050285431.20023096195027233273768104632097760012933667433149392');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 2 });
    T('540050869173895773.424426904326491781543129896', '0.00000000000895989186388639422064025633565887849312514138243985430933', '6.02742619417781935328562300720637989e+28');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 4 });
    T('-5938.622', '-0.000000000000000441470800918077672', '13451902113684776033.876762578582838722193971530567149367030921794691694');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 1 });
    T('-643016680179.5574', '-41351.26558819809954910396212183376711', '15550108.83060077939716915940438899056254498339925880611745634521459682866865543956545201310119290772247');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 1 });
    T('377183841614474999303.1509', '-0.00000000000001682510837897453705285405430455679857552360', '-2.241791453098881851047931346403699546189986296210130328376566971094795027618e+34');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 4 });
    T('-0.00000000000000002874771492599091839043765095450703', '-0.0000000000000000000246053412697581', '1168.352619490960748177930651375650333524830229500802060304699');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 4 });
    T('-75466375201925192885078218', '328284.032518165', '-229881345806087593488.150042339594309939217861167079783424739050426');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 0 });
    T('-0.0000000000000001458387757541566650923346531455358076529363209321880949', '1039660724', '-1.5e-25');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 0 });
    T('0.00000000000000000007201433211365864812050676168861631569', '21.058', '3.419808724174121384770954586789643636147783e-21');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 4 });
    T('35406333.65425365444', '-47699.2054027416103', '-742.2835109160665875778372905140836839307704');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 3 });
    T('1.6467243', '3179202137271953.999867', '0');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 1 });
    T('12368559.7655645946606078', '-0.0000000000005370318077131559312937260277689894299333665170817913498754', '-23031335552047964835.06745434814525');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 1 });
    T('952970053130035362789358', '39364146300133649626004.62', '24.209087271042883694639401133946545862495050075765185744384807962419660137722883439104580538');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 1 });
    T('-1175.74452217080906238136', '0.000000000000008317103', '-141364670146661531.3506830443');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 4 });
    T('-281353421116', '-0.0000000000006597704686962552218738218482173745099707', '4.264413678168571358888074134658601474658911119122815649281448043676121e+23');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 6 });
    T('-7219523920097563556181232937078301106', '215954011203925463555412484', '-33430839648.91100857455429422938');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 1 });
    T('0.000000717658856646399090862400533683857748886352', '69542205782774637283441456525902695.499720262', '1.031975975694692007919534912528e-41');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 1 });
    T('-38203019.354', '0.0048211569639252', '-7924035587.27873807137229096192908092256676321999293319188756273871716857316078129027130891822842835');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 3 });
    T('10128234086168280925890886.599484735363522626588600146237', '-4119282794.3125357366762010270654', '-2458737258862698.433468855443166152443838');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 4 });
    T('14640184250369871388.37100702916569398015738844', '58551322848286248848067253369539620977', '2.50040196159263685407381621606e-19');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 6 });
    T('-1083681003608604033643548194.9', '119169682', '-9093596503921224138.565278666263454491722147920139620746827200562639749261057859');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 1 });
    T('592117874017678.813255527048431677933', '466.7', '1268733391938.4589956192994395364858217270194');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 4 });
    T('-23896667170068568476530969283941478707269695211', '-133610708633921647146034.10074', '1.788529333793353026151379363557258505368398116073368544502305595e+23');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 0 });
    T('282898292487160910703267277995106619021883676929.924460161023', '-11447661789031355856845201.0', '-2.4712320970053602157884087934365549564e+22');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 0 });
    T('-717.80255046097476806353285702027141354262687', '160415502.003776', '-0.00000447464578856025090122480400689234232245586');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 4 });
    T('-6430550635897275', '-1177462571585965733785194717063572810797712495968311.99218059', '0');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 2 });
    T('225', '-61761439784620984627142813719', '-3.64304978615518802502665622300028500429e-27');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 0 });
    T('-195.523689600', '-167064836731283986153984192206479814829949537.24391580755046', '1.1703461567708036255855243452084423e-42');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 6 });
    T('3.436', '-12508626406010003696850920561737979.2585', '-2.746904327040345120515529643732939778083475753e-34');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 5 });
    T('2590425', '0.0000000001145676379294', '22610442589348811.10849144035124033620032882004378247455089405529415837571660141344');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 5 });
    T('-55461828684169485010301146336919649775052817.0180', '46.0169344557709809833971869110406', '-1.2052482274210689062878457286003185728949114298659930715269275094725859608915e+42');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 2 });
    T('0.00017260', '-3404498403684126500.46767062597658852674782', '-5.069762988087276476469338e-23');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 1 });
    T('7409154644117.49516751325896622', '-1082845369464899121.7012509556893606955212655145085607', '-0.00000684230163700918514622437948547615875283398408647133872349516');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 4 });
    T('6636.7313333', '-12060593132402143291632525325373854980073972080517646055224', '0');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 3 });
    T('106818808701039.84547715905', '12221056300516916667535058613.36168150545', '8.7405545048116427685652075086113386323829650372286739937901999493e-15');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 3 });
    T('369.557916130845', '-419464295167825002212185870265208.5005939460325871225', '-8.81023534989997714325878006177572415183918733223705657924136e-31');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 4 });
    T('-0.0000000000645439495204991350846523292148771', '0.00000000000129208540625636', '-49.95331516629876957887408926096711789426284229436361094');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 0 });
    T('67393774679548074617110386542143925801365009043.0', '-1092320671375326.10154520928644392601845845626436644', '-6.169779300678571750101964970468279947291743116391085444593294149e+31');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 5 });
    T('-121027988050756830025641308.712901770', '0.00000000007126382432444039853374141746443519712', '-1.69830891336615348258214639706015061247339987062220111730020833449231165027849749453333526080981186093370789e+36');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 3 });
    T('-716900765010107.762871173192', '11385355.31333073338140850097242124430921', '-62966920.6872017890686108666849470147304940347940883377290971407447194424453008882402');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 5 });
    T('20886435275525736755660378681250732329264655953691.380', '-1.29409561', '-1.613979300611779121610680580336002556199433823416755119044102158726896538965926945691439290177330869702896218000461e+49');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 3 });
    T('-55753655909319131271843349202.87719779740851081114209443', '-0.595620028839275438430986238238468911051966405926660', '9.360607973168734289980188482140775761596e+28');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 2 });
    T('-264635918573859707596403359325208407', '0.00000000000000000354626821691974030', '-7.4623774172310156461112574889518111124548438729507108888796896579264628217596211584397426491359004312721032482e+52');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 2 });
    T('-14325912003785042.56288723129905052462976120195637437110865304', '-9245328333014.38783626694493499457870739360469', '1549.5298260666702253568344292668269177984299048155412204879714419131073');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 4 });
    T('-1129590318587195938445234016303521870520137985828073222338910', '-3061584375691766.89717249492522249842483359655', '3.689561285835750655025466114301838115877292367779690786e+44');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 1 });
    T('-0.2515867523530108605600496137267476237074174916179436763', '-33624.2135287940460156', '0.000007482308906275678793492493465395099190398868342150883');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 2 });
    T('0.0000865195295746708088866771125640918227', '-350793020221.171183114818319924648199147182195572787046780985', '-2.466398263001960150194250624144808e-16');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 0 });
    T('11728121459652509661793201047042821273705', '38.140', '3.0750187361438148038262194669750449065823282642894598846355532249606712113266911379129522811e+38');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 1 });
    T('-250471697245291579519203881749031751382007763935', '0.0067942570593290', '-3.686520763905687928813971718511538060840167627146529024295604290147707552102703598244620157839912540181483995022963667591995499351069442766e+49');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 5 });
    T('0.000000000000000000570863031266464054061282093562606904320', '-3701611.051635016263', '-1.54220155306244720675e-25');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 5 });
    T('-7646.952831750430', '191750.7388509', '-0.0398796524987');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 4 });
    T('0.88174753004373804938093158577997676', '1138199379359199839', '0');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 3 });
    T('1577.95001', '-131.311990094895031933441386427065', '-12.016800665801084250425314522453251647826917908228222400546877896536593396343582303');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 4 });
    T('-1577.76928710083314023631795412877045181025', '-33367026224254432.0', '4.72852832762769686802691755643196033870527710791847216953468737e-14');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 3 });
    T('-0.0005968434298289396315631121', '69959148634528.0708204079', '-8.5313135090722049543462336e-18');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 5 });
    T('-2', '-13666674315974256724.2733065', '0');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 0 });
    T('800659435665671863047228213619069079180548770985658357864820', '-404584339130828240814444028615465729390.83425', '-1.9789679387633612011626363783680693252755797440294456093699415572840030090901e+21');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 3 });
    T('-14164987398.154', '-10823347.03684348814847738', '1308.743713930202596887849021949283595813370541890702664984146957681092855895340482521234041212666913913');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 5 });
    T('-66639967214576506023448799662784.8120851681881705', '-754.9709298123252579', '8.82682558799214006575456582142314590967082981674293456802399068140421957405080507458976823739558557208552135632511198767926e+28');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 4 });
    T('28.538637614', '97', '0.294212758907216494845360824742268041237113402061855670103');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 0 });
    T('-3374783162858941545005351458815794090250914130.81', '-31524083082565114', '1.07054126015973420268121365922315423006570122477926323459308e+29');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 1 });
    T('-555139115732.219118946044638930', '-187131353148221858197483269569454572.4282311604652091469672', '2.966574581932873225848648e-24');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 3 });
    T('-3580670709933895504879211497822.62573263710180580083', '-16595562728719812263924018677556.884214647588798', '0.215');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 1 });
    T('-7800204268422.6630976051925', '-368074375459785921822.4', '2.1191924210097251919466525090900679934161001895850112367e-8');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 2 });
    T('-518296340.3117302473040625440596494724', '11318311159193499699635581642435247210015192537544895.6872939', '0');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 5 });
    T('-1642590470351481064495.9285537066231805276894804805113655417', '-0.000001970263561317', '8.336907318397089832301582143621967064206762358861678195376140345756393710412443238500950733156861452806046652283634865e+26');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 2 });
    T('1273137748195148939370227531002272006611943859', '1305.704918253306118685731152141683286137', '9.750577870980806367967702943834873454117411899323816774306697929812313456716692452636273616285899185762960612454e+41');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 2 });
    T('-17.88551460012634842908254237071', '515674786038.35182387039160670', '-3.468370974181422339678383601951010161757125234050160394413900135489260200473e-11');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 5 });
    T('356106374867687954731276514387594223575481513688128770487472', '-88625132888658790915827758922430992.3664431409', '-4.0181195024561513310161914962555e+24');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 3 });
    T('-1173401490784017510110594353623515417366834463178905259508', '-847245245690376328994.832121515569214422', '1.38496084428054043151887091880271091841030165137578406435475089911317967522337044269861929440531213953107883004374787689544e+36');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 0 });
    T('0.000000000000000000073121300058313275464', '-3580.489098392922289651469472184041861461942', '-2.042215408256186679e-23');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 4 });
    T('-33244142', '738.68547495917336', '-45004.461475078254309842614491013773999662579782180750564018294685172971');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 1 });
    T('-0.0000000000000000902384628927888', '0.0000001599435367663604175894053775880663491414991446307487060448', '-5.64189492849628538037347343e-10');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('-34177.885715656428595242211188483316451607937004', '-1809517072277078470860', '0.00001');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 5 });
    T('0.0000000000001879718896', '4517764177408901714386060344044.0591654085629581', '4.160728232e-44');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 2 });
    T('115.5', '6807122973315026560401587219858615', '1e-17');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 0 });
    T('376994297172407832139945598036890904929033426', '-10204965.7433858333140800676996804381461', '-3.6942240341840438564156278379508523898040066862017183222916327870947875811464180204029594420804792899910987594442175569245e+37');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 1 });
    T('148025607.8094158167800', '-3', '-49341869.26980527226');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 1 });
    T('0.00000000001546123044543608773', '-1.817180', '-8.508364854024e-12');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 2 });
    T('1074121926068050591788300835971345971788', '-1241.280697206', '-8.65333625573806747854467478207570701695396166666360710889818738200113442939310149245398367179674217040520941323e+35');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 5 });
    T('27481425', '-0.0000000000000007927277614420371368617342782703302176992806993667584', '-3.466691383433957558203400370807477727711306952957414523938106880283577564127713146679e+22');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 1 });
    T('-1.543237126110417', '-2306376.61505288494472138', '6.6911757431e-7');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 2 });
    T('-679730843323816689711820822622001556354.34', '0.000000000000001265121816937578415255', '-5.3728489559148505645776337439770904080651370050996160957e+53');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 0 });
    T('-1530724682451909893676509078079154.73796521841838721716', '-13062681299838756592125432251864.48745668', '117.18303825347135171318882550486022006997620174963871497285797580025764747');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 4 });
    T('0.0000000000000000002215783376893165306592038353870192152649', '-42051797263719797554394741006664.19360556448944', '0');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 3 });
    T('-0.0000000000000000056478638069700252282277439647000544', '30458350475672388144010698070285', '-1e-12');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 2 });
    T('-14776555475031', '-3007838302135524661203586405082215746332704522551', '1e-11');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('0.000000699367831101856240231002717990963392410922923601341', '337615.7416', '2.071491e-12');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 0 });
    T('3708413174148246392059623903.146227235281104189453143244294', '-0.0000000000000008364936396763804174385604833163', '-4.433283169472685579224523369601497080227942160571944829626681007102694489193316457249257447974620118e+42');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 5 });
    T('20964219130028366790348745', '-5140671536036869364980193050.55', '-0.004078109053081116657293014769115691847406069818077643317121119583764646360828077134385840930539901');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 0 });
    T('-35874739427124479026757362234424342.5147902', '12.231229356', '-2.933044453910613024625663166611323784483058302974398087151690232763876560242633389794477172585528940677318455e+33');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 2 });
    T('1247354405068407468295934441.96903978322639871', '44455128617130727159614005', '28.0587289671622058453323341248094867383557419293146599023247495460194952166');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 0 });
    T('-0.000000000000000041', '12641', '-3.24341428684439522189701e-21');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 6 });
    T('520036441848903948696.8384700224744368744720010219', '21186194968377.84', '24546004.727375615939845100895692057616489867939937362153778422978015915361795535164155540919289791292695');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 5 });
    T('7685267837631132.61807033', '18.95', '405555031009558.44950239208443271767810026385224274406332453825857519788918205805');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 5 });
    T('8487131435696960347200653554092310144755975718046565506850', '-20330', '-4.174683441070811779242820243036060081040814421075536402779144121987211018199704869650762420068863748155435317265125430398426e+53');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 5 });
    T('-48593426924187279257266827298265477.13166189800', '1298.04450401437', '-3.7435871246252220784764543701337077298448e+31');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 2 });
    T('25742557689900465549015734223240765339.6081311899470726150', '0.00000035176595320', '7.318092457704194195737682956418866218917553613300365481476619494509964985434525560559565831227807410214138939016e+43');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 3 });
    T('-80349767.383', '-76465355.365309107874047', '1.0507996333651144806823215162643809043930020540937357346717534770956776631114957608428');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 0 });
    T('-720918157553221.5534128617682451021902484', '886.1600033145472386747549', '-813530462734.4231341729303684657319385070909227361625790329315655024971349661169585714350764283432901044316');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 1 });
    T('-425033.0667115', '140765.1648264', '-3.01944779616232565360740871838743735719031853660839525144745445829071485');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 5 });
    T('-8135821509630428945348107453152546376154.882392', '-3112550578769.74862526932115118119930087124', '2.6138760812832007336319028765302859550106848231577886768202032565043118641039398178e+27');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 3 });
    T('-531742441771349578541245193675455292168000590280167.44', '-0.00764379118981424237664876316390882401565448382139252376814404', '6.9565275733843255185695016972840382847570250634685453690143785219241992913608419252525424964938194838191792911e+52');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 6 });
    T('0.000000000000000000074590513117417027422364725169776', '-46895045444034069521.111915218063471055105338207453369993829', '0');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 5 });
    T('0.006792814170816870077685', '-1697052154906429529139107604360', '0');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 2 });
    T('-523239316422658564260578461873', '2253.4675656873', '-2.32192965361395090311713280107388393931550533255997992805879404589752364696433161106599503406402106e+26');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 2 });
    T('0.0000000000000000008950208541030132360488918888049', '-630175132180377.8', '-1.4202732040635768535863976870227615952476933245990586e-33');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 4 });
    T('-8041797', '-347.1', '23168.530682800345721694036300777873811581676750216076');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 1 });
    T('283238368357281391325815972970092712804079971', '15751079791938020080106094367.62', '17982155642577162.80712894052764518565601791527146014173446447120250703284587996');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 2 });
    T('-0.000013912807863280215627728387074361954', '-4095279098.581868309703264', '1e-8');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 4 });
    T('0.003567219', '-81547060553.4545313968434', '-4.37443e-14');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 3 });
    T('0.000003592650064486776188', '-102623211740139453848094112274', '-3.51e-35');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 2 });
    T('0.000000000000000066660315006768198273280034892', '8134114032937925625529010132696268541', '1e-8');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 1 });
    T('-2.29306986997868829082421602792545127020056551566', '-189003.758266302914163168893013258129906795171402950623', '0.0000121324035617735911');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 2 });
    T('0.0000000000008282395016874', '177001696701294272338204603', '1e-12');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 3 });
    T('0.00000000000000000045143442524680428467594742039178125242589041162296749748826', '48.8838659', '9.23483478e-21');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 6 });
    T('-3733417243902664198.13023941405535293221232879525416', '-959.079', '3892710865218260.64185561295164981501233196514078001916421900594215909221242462821102328379622533702');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 4 });
    T('594177346114900.121022415301944560506449496999111928', '12525605832754558641574079217732126761911651638148', '4.743701454832002187217678631516e-35');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 6 });
    T('4992278162383072561186288289113199.716281380410535688', '4.2', '1.18863765771025537171102102121742850387651914536564e+33');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 4 });
    T('2822.14', '94329104.5496367223916', '0.000029918019613076763237578118406028698168774402148318896814669');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 3 });
    T('-0.0000000000000000001110503896009121755680689190900384427', '2328987821070715531750813', '-1e-12');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 6 });
    T('153752792737', '2483.2', '61917200.68339239690721649484536');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 4 });
    T('11.60161405461718555', '284550672.49642250544934058', '4.07716978942056307283464697962903921909474830617156492e-8');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 3 });
    T('189.688', '-24754517032224622831526449966562258743085549225563672714', '-1e-20');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 3 });
    T('-0.0007441266572355504', '3.34684614329', '-0.00022233667918300622134004329574327475866716300378990045760849570887894150933041769117684202718');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 1 });
    T('-13535294945545412124035063763.77', '154.5024977570741433787379018192789895664', '-8.76056707304958572975370146622824195219447623315167572318757036142049924888057525660130840269890650882880343977076154563e+25');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 6 });
    T('11983453407535022649614764881696589382224754704463.8684062208', '5802376340', '2.06526648830486280550612559572387015872616678711740859025714281745468443710081721448629786740099660615946879446981889492538500183e+39');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 3 });
    T('3178038020148431820455312016467389665739054.4576778458', '21054959864871703366821506201711538207350457986704613695', '1.509401129493816267960052581506929546499e-13');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 0 });
    T('-903599029877560268530347275265207.87', '-8225110328731212019948660254554280832763', '1.0985859079861698683e-7');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 5 });
    T('-0.000000176707618136247054976126963225805867552', '-59785395331783158900858443125.5141498726544387028', '0');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 0 });
    T('-304719819875', '-15834235671935165309709902051659343938622588678', '1');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 0 });
    T('851777284247449228622262256799930786281959157570022219812934', '-265201007359497920383609044818696905113.345687881993778', '-3.2118176802126827969944145846417028592839421242620132655414958e+21');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 4 });
    T('1094076851200232612485495', '45170230412955.87341467888498221131321290', '24221192612.876862966820444934376959326917921982087707316670750434');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 5 });
    T('-266009630563.5751817996772', '3', '-88669876854.525');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 6 });
    T('-9854650515088757094838236690274767247758517272568094336', '-0.00000000000000000022781292734166224423171119487999190', '4.32576440243413112255272208081733670067732321142244280276402802126595381401029065133890157642846933655514108837510716979328849339257369661938462709437434111231587e+73');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 4 });
    T('-6132.53', '9148419661.3', '-6.7033763502805478804013771877489723352e-7');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 0 });
    T('-1358616615337255527426604965418371026149417529691141', '-411131303075406997.6936', '3.304580811955510499674020126518173701108868436644291184112191274708277758126412610036977470571487191443315381609149755e+33');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 2 });
    T('-1666.62', '-41.9029412763736208', '39.7733416613334504072586922905645360163057171834688429688965737440585');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 4 });
    T('-0.45978697415761062736019244197731022477008535480011010689', '-564466415549217929918544.45405143594', '8.14551515363840256607739e-25');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 6 });
    T('-2929430205196483609917236829698354', '-0.00000012825995', '2.2839789078324789694033381657316676016168726091e+40');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 5 });
    T('-0.00000000000004940541829384556296990127644311117691929920190835131349', '1.83587', '-2.6911e-14');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 1 });
    T('1663533737152073150809636816464535', '-78.59384606968353399', '-2.1166208556292523684841659407900603043163901831451164886205587911132360575237341769309937351851240893561863173992069e+31');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 0 });
    T('-45109676317097561400.602', '-145051085.8603397643566869612956643715100627722122277', '310991648559.8096681714427995304888806425341985867939466056887318610557801235490219056919231184');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 3 });
    T('-0.144741146637846045233543788664754684233', '38.70763164', '-0.00373934390985245113367891367752');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 2 });
    T('-213267319781136840828.81841', '3597329340433289539097389.10090419', '-0.0000592849026593292991850793512666592236518565710292148200766842011917685');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 6 });
    T('12555.00260521758264', '259293850', '0.00004841997836');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 5 });
    T('0', '-247824935559712858127074692451936153866797521949546499987', '0');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 3 });
    T('-0.000000000017234737', '6363218480232.8367', '-2.70849367400148788714459129576630236022401201401e-24');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 4 });
    T('8780588588869959337251863409776071.80424', '-0.0000000000014222373755692', '-6.1737855717340015690565505752294571901679865271128752812921622101855544823960081829660763501280574499788473773e+45');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 6 });
    T('1202044426514841285067064.0', '145353362935017823272770950937196467165.223443222', '8.26980815746403762433534151431755002946643158949517393353190134e-15');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 0 });
    T('0.000015383640', '3.18383325016056515707686799850106296', '0.00000483179827311125089585459680057859870112712042013390296318998786813132002765219573826189');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 6 });
    T('45364.765582867720679', '2505216730726952225381.591530531927253863209', '1.810812e-17');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 1 });
    T('16706416155831105738957243800950347579146352.7664272078404', '-15801636784314764426537155863046169373', '-1057258.58554187599826669137387590751139542741145195067853557546643523667385366401064');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 2 });
    T('-924707.21688529226667444411037974980141732477682106', '-224402928790739496518320930648809901676927004.4', '4.1207448667e-39');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 0 });
    T('-0.0000000006242159873954031688369074037997865246112334124', '-10264.3', '6.081427738817095845180941747608570721931679826193700495893533899048157206e-14');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 6 });
    T('257245.160', '0.00000000001291022197451592060663879005489083638559539086089039557', '19925696127284877.2140183030202499640385557595126820061218721467');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 1 });
    T('-0.001204285809516927', '-16890909222793486497', '7.129786760630979e-23');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 4 });
    T('-167715187686647891294529344766156.262451454123628', '-2801176082730364487.3454119660', '59873132831825.557950786942831650585385474196');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 6 });
    T('-9402008294809.218468841889988', '772569013.18863540085189714799950812258588705943569080948', '-12169.797305232540922377133862643439160080727303691466952493558');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 1 });
    T('-0.0000000000000000000519557604552289148573453', '65086901.35412863036802', '-7.982521e-28');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 5 });
    T('71566340268678504341888350.28557064701580670', '-24.1035117', '-2.969125045321860894729640174612840626696179710610383797e+24');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 4 });
    T('455763207112884674.0643198', '-0.00000001156426434172901828270543736814', '-3.941134460825907916686687297851e+25');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 2 });
    T('-216340160216652.167517103015371520320504576122', '27153293.0739938991521690277527954349191', '-7967363.65004111527420646201345855398721703089346456189966028029972695571949603659856337560035292534');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 5 });
    T('72929941665984.598885280816971615', '-3288295196863.2055', '-22.17864799229535715800361709629244268816136234234377026368285173191990763390155503877219155599773926');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 5 });
    T('-208849615990706743659818282970.370397342055437315746876', '-0.00000000000000000005533218', '3.774469323108302323527073810762026678545024564652013999809875555237476636561e+48');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 6 });
    T('-8601734511522478.1611637791900687131738653313091', '0.000000001308739965094750507087269496807181975342111768527447736197871', '-6.5725313973274495964673955593556821550145738948627060769657084e+24');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 6 });
    T('4690.08177', '-153.7', '-30.5145202992843201040988939492517891997397527651268705270006506180871828');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 1 });
    T('0.000045534097599795625379088782042993008874734445184308', '-221381645', '-2.056814493351317602644464135361945154700356e-13');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 1 });
    T('-9257746648135675560285366734014321238513113635818328', '0.000000001688971424354875053059621839175', '-5.48129264630501027446190896008315133533114168046699834517239592613977291740331082888161684360902575877236308292547167194915292314747658072690018895e+60');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 1 });
    T('-71879677346223956249925412.237057479235032358135', '9592996.68319302', '-7492932575715107271.0488585740293462533529381937739815092394884015917462763001313062945993');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 0 });
    T('673013280310051', '2646188524609059034750626867043201451715480110745', '2.54333080977093353608292839140221555847523612798053459934e-34');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 1 });
    T('-37391146770901318922073915062043253418156240674231966776', '-0.377392359145418812898258331304876547646153600428657770920', '9.90776465521750671579002459833852973105457673647834347457894970963595573594856679877267498369712253e+55');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 4 });
    T('0', '-1057817.28862', '0');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 6 });
    T('-30053.49699', '62926872710082113.39973602372340789682800332318148184', '0');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 2 });
    T('-0.00000000000701586226100438349070826401693', '0.0000000018882719221498357441465404661', '-0.0037154936101664227048530258989385614409631');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 1 });
    T('-0.678525953823435944174324400605592707', '-357.1', '0.001900100682787555150306145059102751');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 5 });
    T('0.0000000000000000000182701198320864627982069694892636234489800419636', '0.000006393172701188154407', '2.8577547777946009287133771085218e-15');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 0 });
    T('-1201914011702159323537662546733.597189', '-467840137859313195848152555257.565526023266744467', '2.56906989041541697746110123591885306583844485308307293725182957185042538622400828');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 4 });
    T('139592236802245692289252849780094006877123.13881106202', '2585.280319726769945535609082460957', '5.39950100331861698546584074153230136879729906298113565752375135954626108427452520233190320530079426389174890693149e+37');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 1 });
    T('-895170083971138589203712544185399054442917192623318', '-0.000003502258111551637847481643025927160261055601386124983284', '2.5559797577984424918470954298386752245726802584457072713106972242e+56');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 2 });
    T('-40431597.91947608248641454794200778208342384', '622.71751234426812499766084332865810899688349864558797', '-64927.671244170109105137167388159585218336945661028432501409483756970130666640456046333483019400746287');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 2 });
    T('-934892.2', '402750149113355843063.43422390460', '-2.32127089725017179438360028145743823591884001301945711774186712e-15');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 5 });
    T('0.000000000125664321461616615334255735', '70176889041819143010970.595', '1.7906795695479166985e-33');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 5 });
    T('0.0000000203691205662848665373766215358980302867', '1477998213.71936537', '1.3781559664423552161765365475672187634849224776e-17');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 3 });
    T('-358.68', '-1021.561810787167533220092752870382468653', '0.35110944459015949765358525681071494213733010418104923396023358754079290260322039254304644');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 2 });
    T('-4018349366961177732739424469495558461051683311650730286763', '-78811777801.816737857103576753', '5.09866606113857811769781968152402700905594792768193148709782334248e+46');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 2 });
    T('-205165177654170172389930120190188.2', '-695951097838436.715746744416134608039318216994160606437072', '294798267136003209');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 6 });
    T('-2850331473521261308881655118.3443917118829', '-10.21794123974453070428905176282599189446170574143919', '2.78953598053038460036427044e+26');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 4 });
    T('256298451255.4030365797651583126559', '1585630833.04858776372324316577636838105', '161.638160606800839009380115889267188434054850962509811728493475273761907712360672665');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 1 });
    T('88177649804448.285235381356775207514183788131857377525288', '0.000000000000000054700486157782', '1.6120085212789947923120646579744342366e+30');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 3 });
    T('0', '-1226962614687715.42416', '0');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 4 });
    T('-0.000000009887749657448858208654042781460188', '5612199856791342.72760075529307883872859967029721', '-1.7618313513e-24');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 6 });
    T('-4.56750916876632', '15.1', '-0.302484050911676821192052980132450331125827814569536423841059602649007');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 6 });
    T('1437120172642436393061', '-442400520395.57', '-3248459498.5499638861626808');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 1 });
    T('55010429541901600090701044137.30499490824202', '7395954439610224303938.810922', '7437908.11464229570123270141116154029911783556110156028784363032923437377057701338835849933');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 5 });
    T('2903034043437699745091431259427608784719433889138614787', '111.58823605', '2.601559220039037210940329457271323884073023564152499914887e+52');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 6 });
    T('-0.000000000000037294965843016026197169517880341', '-0.00000000003048586785128866853988246544783596458432673705774418496903', '0.0012233526047197482089158865473243921886439502680292026576442563596556356293748369172');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 6 });
    T('564.485354582604471454113173530455452', '-149680535746472408203037263530852928547.25902816623', '-3.77126759847202086e-36');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 0 });
    T('-17594.033117785589933523841128115761783130970606611590731742', '-15658681997037879581936246931621466507046570872509317157848', '1.1235960421901293e-54');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 0 });
    T('200377596526456574076692.972653', '-134.5', '-1.489796256702279361165003514149e+21');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 5 });
    T('-5710158133006294602665096578072464239642825934.499206731193', '-9899685915451947007218189521838324652009113852873361284.1', '5.76801949251095073e-10');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 6 });
    T('54.87', '0.000000000068307861606255', '803275036134');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 3 });
    T('-0.000000000000803640804839014385575545425103776', '835249350518300716158.81198', '-1e-7');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 4 });
    T('-27336772967.54933294246518821832363091371263937122844912', '0.000000000047862010055429464271603859678895514941565034144690478771', '-571158063271691838284.862854228326127036693245640710336784243541044182');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('0.000000000000000002115895823295045763032853731145322', '-199597862.47', '-1.0600794002055355593272019127677194307781306171219339511396e-26');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 2 });
    T('-1922125922582145324357704373604380121775097229.4', '-16990531167665931.726252472819341581808', '1.13129242612501366569849895414679665469000630822922545993744661151457530778018934023458067301534794686e+29');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 5 });
    T('-132.7', '-287895268270367424616830747.09442', '4.6093150747923767680017946568686046974956967041646188609957e-25');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 0 });
    T('1416266269343299776.5', '93299724.865279602420587443098855770369720926599948666', '15179747543.6108884643590326209280626064215759779663643277777203988692050799');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 5 });
    T('-5339406761374017811732.88602378178403752697', '-4469140141720.249671766568242947740083901645002693987054', '1194727977.207442727694694005819478968302727811400860478354037090596908702789500682137');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 2 });
    T('-6253463320645931839729398669009255185.754728521636100793', '199410057481802.1825874081306302190884190828', '-3.13598190563513181927085047490496e+22');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 1 });
    T('-441350317401498959949158769', '-53783384178114902570547941319277531964', '0');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 6 });
    T('-12785562225540639653048.208552733869', '38158938422157746834376495468984.246171889621891362547016', '-3.35060742101684059309e-10');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 1 });
    T('0.0000025066276135990015625295257554586577026423831403', '0.00000888935644847151206', '0.281980774213414040251090628974510781472480770773981315600178785347302293772593658066861');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 4 });
    T('0.00000000033896123924390456808086427417238299552671988101458027', '-24979399853350728356760719683594094225', '0');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 5 });
    T('-2503641852531763566974549316971734178103665141733944323232', '169.462750272899828875916', '-1.477399516117815163317850508929472217352089090657168712935496345603131554460603439227889964028002932438517295526484687083036502252141876e+55');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 5 });
    T('-170847', '39094697925.3308', '0');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 0 });
    T('6270077.92756774838684263325366473390232', '206.78349109', '30321.9463725891599988009142072790115709231785753');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 1 });
    T('84703267403711289741402809502578155102366055.073857', '-1046146334785502790186313678991043560880897482200177', '-8.0966939889034235764686891744655459841256967972765598470867e-8');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 1 });
    T('3545.1407579067497', '0.3459', '10249.033703112893032668401272043943336224342295461115929459381324082104');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 3 });
    T('-3494.20', '-0.000000000480840756554490261421396556146719241216698163415392140095709', '7266854883596.01476020367444703');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 5 });
    T('-16650762529824305578738973542416', '0.000000000000000094', '-1.771357715938755912631805696001702127659574468085106382978723e+47');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 4 });
    T('-135.0', '4225705320433704.8397098115330815', '-3.194732944277910240197793697326411481943087817037607196e-14');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 2 });
    T('-2995506074584621266599631960111312877166732494844124', '82804233.3084102547261584', '-3.6175760041490220642358349515453623086913834013850308361387469586e+43');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 6 });
    T('-347688783540526823654.9899', '491590298897394420180889810517081629.2708', '-7.07273484282278380762870567598523e-16');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 4 });
    T('68.97874788835555463770500278854830624641240124220', '6732686000571465869842107.60409913862949426908699447', '0');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 1 });
    T('1060728314557064738109126481120466266837.162', '0.00000000000000000288998199547', '3.670363054924699191863531381976240623202494002767940365212921691005181091181007474458305920000929354440342526567553585e+56');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 2 });
    T('2214963945079.9484628235968014462503635218584005808416855', '0.0000000000000216336715767932185892098107689', '1.02385022219528158743570987586401555916180399907739137473573213383859451514006190585854291485826227631266698113764870495e+26');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 4 });
    T('-0.00101149645199419076694756', '-10063665763193914407065501.293496469025780457740', '1.0050974225451335469535999549511283458e-28');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 3 });
    T('-0.000000000000000000019185475868122708030208927', '15879740999105202756056360329717870685504695114554.8046794', '-1.208173097358e-69');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 6 });
    T('801572915782.4912832617616401', '-2849.6523834657892042113', '-281287963.55420954745');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 4 });
    T('1833387173877945422672', '-0.0000093322172642483', '-1.9645783225618277278491678904374735968217783e+26');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 1 });
    T('7350501756971752135823797362779270090656932', '0.00000005112', '1.4378915800022989311079415811383548690643450704225352112676056338028e+50');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 3 });
    T('-28190035525877869816543636286.9356251154376570729358300191', '-1810804.076774988385639', '1.5567689452126620516791203797362577944674444340957666224e+22');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 2 });
    T('1844473405308469535530560487879620652080615603320173696.775', '-0.00078849996389950871004348158085', '-2.3392181227081712107359969447747777792439216175540029824692e+57');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 2 });
    T('-231693111992827834475921395.7005408572831597652167', '-0.000000004116', '5.6290843535672457355666033940850548417e+34');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 3 });
    T('-3', '-11931468133051028511674830403083922434836101044', '2.5143594791e-46');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 5 });
    T('14659907264763.6879596805197248324', '5122294726480220154273.78922188259848198827666718053671', '2.86198043017279269220526604594116030762403468944452992719931176615831789682673637e-9');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 5 });
    T('-5', '-5510812943513', '9.07307152547375337530703852788484844697714007432e-13');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 0 });
    T('-0.000000000004786329685610511015691956495', '-69867798220438028219748793388549983833832.353842034', '1e-23');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 6 });
    T('-332231721', '-0.000000000000000000011894726310054691678991438851056154637779', '2.7931010124979698348379903328288146229762553558696709423192367676245866471114772369087445551509132881686983022776263e+28');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 2 });
    T('-0.000000000000002075858352050927127738375993195590601282117912490', '5863967368300060684657653.554829374819243602226788567474', '-3.54002371035142e-40');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 2 });
    T('-92.0002753297975338659777545', '-110761204179480957979884152503734.5112', '8.3062e-31');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 3 });
    T('739235053', '6945061467493074831466926760549620.8163260376607', '1.0644039026292996846558102516170156946325522444e-25');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 1 });
    T('233077970564414552492254389124', '-6.515', '-3.577559026314881849459008275118956254796623177283192632386799693e+28');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 0 });
    T('-97801384199.048951866736152086672526808991949760886076422217', '32622656062133512.2589818437558403820526385273270', '-1');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 2 });
    T('-232.0155758670362061964340213', '3073.895743315', '-0.0754793250134183938');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 6 });
    T('0.000000000000000020232521680689204838655364975887876983246569651572', '0.223057095793266', '9.070557297778650701453174445089199332424409847e-17');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 2 });
    T('0.00003846089235782156159638', '-0.0121713956386476574058', '-0.0031599');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 1 });
    T('-43168211675418986572265954868784979849387435.3022223821157', '0.00000000000000229608704789', '-1.88007731305695129798182639705239036242954603787717035880274202020075225920706589365891377490252735193307793473195819918257532974424203375e+58');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 4 });
    T('-6342771513789412966690370629471313.3491415', '-553339916.277586362091095605737495125123674158237', '1.1462703714668440334977516e+25');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 2 });
    T('1455694.8185707586702590872957830299613527235225093277', '-1444311.07240551629454597', '-1.00788178');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 2 });
    T('-180415510015366169187018315.93', '422', '-4.275249052496828653720813173696682464454976303317535545023696682464454976303e+23');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 2 });
    T('-89238.062538', '-0.000000000000000007569681094769494144933559664120779522', '1.17888800625513545335286163213398750962453703e+22');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 1 });
    T('49439.6679315611533062489413231', '-208785626399956', '0');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 3 });
    T('-624543459250761.7424759511364533556458', '4477531294244125365082.7698', '-1.39483884803577698495727079613753595389155245e-7');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 3 });
    T('-356908235519.71444083032467453390227880319955148184157', '1.5306788853374988708482675402655598', '-233169895357.2616012348273715319952073899926462999398380558436985');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 0 });
    T('44066683550405105669624884328870069022314879447', '-40770501792465902237453034227.3256094462036', '-1080847220736152781.3481128021472592814155077674569111667555300023690897393571703604');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 0 });
    T('-2786342133225766496.3702338301569', '-165650538939124201836345652088473601.4574844690271527', '1.682060409262981146172971109824e-17');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 5 });
    T('-27919.220476', '-4179806.6616764499018', '0.00667954829872491564251784270468808686308419116657243607');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 3 });
    T('4717013884021421661239642619803336709657446', '-4396945714.850835', '-1.072793295602796604728660784784714449361778834434e+33');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 0 });
    T('4857571399.040444595942662244', '235459.415989501', '20630.1853702764679928756592238265024244813146438562020490437565058468946493729797');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 6 });
    T('1896453874608071174280167452575.78153057727', '84295814589973288303632462340.69692148823798850938', '22.4976042266474303187971208456534528011604059650531484706610682');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 2 });
    T('1349.21861774471', '600801146756400414339331720940860929.19297368', '1e-32');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 6 });
    T('-380710280449994245527205.803445644072373925', '-6282699867838372405.6862362783503435232742435', '60596.604717484545128564924856036354467001617319065528212815689140862146569868287761955');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 0 });
    T('-16408382343680930801622921026173292010.95184', '10.28420', '-1.5954942867389715098522900202420501362237062678673e+36');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 4 });
    T('-572210837.06281547085212132889004786845500563257764747902', '11174933632587.888635200676212120616579965146776824585413', '-0.000051204853279321267251539617856120070847316696999394');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('51359578790378880398.04793830026219449183', '-455536654230074.23174939755093407387209616', '-112745.21669');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 5 });
    T('-56161288675323037889788006369690.5728858', '-1344804.735014362693770845939698743390913699834', '4.176166785635479476729192379832848688266908371343918271530172573425201796828236768822077194256e+25');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 3 });
    T('-0.06647', '2488734728502626956945778696723078815802336866604', '-2.67083507289e-50');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 6 });
    T('-15709.702083869748710483750', '0.17343238577', '-90581.1334724035302676200393250232343845822654394774978825455616633532285173730041343');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 5 });
    T('-0.000008986079351526333799928', '57158779759798.7587388', '-1.5721258202657563972830928281622437814997897501794197664807e-19');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 6 });
    T('-0.00000000001388422828798892162774186257473892', '-69686337968148273523849327314060722575577', '1.99238885164765353309613753258918e-52');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 6 });
    T('99883611200513084646975210060.60952323092198205344133', '6184477507904180826.367614', '16150695199.85400049006270290779814055968601439594063052012683068413');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 0 });
    T('-0.0000000000000000000150207809788679934221011249575790605', '-28817046896.758970', '5.212463661763124150056312253142344531e-31');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 5 });
    T('-527083357783510.481321402212159156076', '4756796954943078601565972017123.3001236870', '-1.10806360409347708706496e-16');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 2 });
    T('-11916867.623189151', '-7.4112922348688463778178290807622357293427', '1607933.845480057142567124343022113195564935260597336976958134855837379');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 5 });
    T('960299171557437856346556589204892.36952339465963106510841074', '23606941669264716370', '40678677696217.99646471');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 2 });
    T('1047.5896930595555356981255029478888260642', '-103799285857826471881446418054582493405323846656553543983', '-1.009245e-53');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 0 });
    T('-399488979125776633057389835971328054031.4924', '19142186348378884.30958', '-2.0869558568455196441280685191066041366482575030706546217893406693976412457e+22');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 5 });
    T('-832487933142277526.9', '-65167.578', '12774572244226.6847311710740577162465666592672816534627080969619585984920292725931904358943645258689834997397018499');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 4 });
    T('-0.00000004156549255089827512480694974', '-168623120040090001730204587.75804171', '0');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 6 });
    T('-0.0000007632302681012970461950055613', '-391242138.5231094072110969254393', '1.9507874867e-15');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 5 });
    T('-936321317324817171462176644.2', '55757247.767120980969192424103202722050525215437039061', '-16792818060810895262.02308790888001520822277412773933215635853015603');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 3 });
    T('65299.6202353082208802901933150582868420', '-0.00000000000000005406664881119624429', '-1.2077615622772948225517086563246e+21');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 3 });
    T('2.8', '0.0000898339717307499317300278617758244559235559513474777516251', '31168.609670205279151887942612009240993041965427036466080808192563385626');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 0 });
    T('-1298869866494.475594214516700374497540945560324132893', '-0.04110811957006315804911437246309620418497699', '31596431071986.395539936717651006392482754034827777746817636445878750215482');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 1 });
    T('1.3918628657223935652424680689538914172564804555523212063755', '-934909861878189027772780342196426148', '0');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 1 });
    T('31720163278713.406', '385.764105', '82226839842.22276460895707235384173444545857888981143022625186964971766878102875849478011957592581093049079');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 6 });
    T('1.7896331', '1387.88263921082', '0.0012894700527543337354754038117822982353769870061886577135541986');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 4 });
    T('-0.000005151738661445534791677035190155609582464704943', '6124729.17021146886074923028312971419', '-8.41137382286515115853084495840961e-13');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 2 });
    T('760605159957971964.526993692017563512354923347040', '-1981158411651079799305483187381.02492550046373', '-3e-13');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 5 });
    T('2', '2061430867494832196328135394348457', '0');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 1 });
    T('4057584984469066272218033679335984', '-1', '-4.057584984469066272218033679335984e+33');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 4 });
    T('-214768779586268.327071212443153527207616306729529743416124443', '1587502.626505197089431660056901151238655', '-135287196.380311139858555320270185719711243345481870709141810842');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 5 });
    T('34257185.91', '32478274032798474.1', '1.054772364917085061474363969e-9');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 2 });
    T('-759.891819055675897396308244822485318435449', '0.0000000000000001474661347453780982630566940489', '-5152992043683388943.4636');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 0 });
    T('-45.5', '-0.0000000000000014249435430510', '31931089636420433.55576127403712595722405163120316926606027532097875260074783441252582');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 3 });
    T('325882101178204344924705970016340527784218384', '-0.000000037', '-8.807624356167684997965026216657852102276172540540540540540540540540540540540540540540540540540540540540540540540540540540541e+51');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 5 });
    T('0.00000001296293682348577', '4826180903855555093518758503.18506167', '2.685961649951807003241893e-36');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 5 });
    T('652938', '40167425703568058483130738057612236723', '1.625541066083306e-32');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 0 });
    T('-0.2047789134812762376372728712574', '0.00122069219604562311', '-167.7563878467055174827544832568728645393736350593536991176006909249142121508');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 4 });
    T('-0.0000000000000000000735510585292195036412154236560427242', '806566752154265322458.0530216714607132789553', '0');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 5 });
    T('5.96738586777695317673351', '-0.0000000131103553092425065356339650240811875296230', '-455165838.5314759501070905001449000422673614835145139226419992986266304');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 2 });
    T('253439307973073.79909502258403781082034844541589896004090', '-0.00000000000000000003330', '-7.6107900292214354082589364575919165269803428197885898168168168168e+33');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 5 });
    T('1089680054292535889217177656211145', '0.0000213360854160840823096708397596', '5.1072164037695827703326822383250037106898722602484772580409e+37');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 4 });
    T('-185936.62007', '20370869194.97455053229846832075003348284556795690420198297', '-0.00000913');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 6 });
    T('1.37768166764465755636653', '0.20408', '6.7507');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 2 });
    T('0.0000000000000000009669444244397709515925799260593182719648592', '9.2', '1.051026548304098860426717310934041599961803478260869565217391304347826087e-19');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 0 });
    T('1.750', '2071244345460032170734902551.6508094475326625249707908886', '8.449027290458661764009243351093569120947924832533049268705e-28');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 6 });
    T('-3988397945262857491438843500707054899997', '-214129.9', '1.86260673790201998480307677755748024913708921547154320811806291414697340259347246694646567340665642677645672089698823004167096701582e+34');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 4 });
    T('295783124913117715560874760916674521', '-0.0000000000002618293341251230605645364205924110442350', '-1.1296790938320486652761249195950932668596773743409194389158746961537211233107766329625433757095606824354e+48');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 5 });
    T('-50710.475561047970', '132.1', '-383.87945163548803936412');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 6 });
    T('8611662468.1272', '949040009695874.96070863580584058121657006', '0.0000090740773625411789903522765473543117649192826');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 4 });
    T('2133393570885427035909375926083046680565861276', '70694057333404.94022299835665', '3.017783462086477634294527605965005751852951438132300383829730062196242995632168889854093270927747631448e+31');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 3 });
    T('2613005310836623', '-677508480', '-3856786.133269686897498316183437290703726689885859436032446413069250439492654025525997844336944682965444212');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 4 });
    T('-71368779920225744729992101649423801013.9826397267764457', '-83273287.6391659199300973471958', '8.57042899872958433994977444944486516265889892525299612767160815191262755920396329859133752045133245e+29');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 5 });
    T('211208409622743840484103493394505.246103663548399', '-767386956806589826985766327524128477304930268638194243742361', '-2.75230648305084820188844632852158236744385890645776827212232048e-28');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 0 });
    T('-100744.08431499', '-0.06551885488328366094728119464062698894646878061872889', '1537634.99826816460387156938259580438652967442179025881429425178830102616497580229');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 0 });
    T('-0.00000000000000000336004973090925295770216060', '0.00000000000000000001515260842039336040123784515497940557955604703549', '-221.747281899470240379958517263');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 6 });
    T('-17532870057814109047.600859829217332735092564821487411138', '23019.6449040', '-761648154475550.4212707754733494707749247114459957879434541949961262530168523576109808');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 2 });
    T('-0.000000000000000026988260097683516148610380', '-45420382420145149189834745476421586567446848185762.708375835', '5.942e-67');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 3 });
    T('-0.0000000000000000023799691081599249086032764017749602896732817654250', '991105482710213.567', '-1e-19');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 2 });
    T('601453', '2041.66764295913', '294.589083621990798160301139631085149923553179452222733024041143164011323620273068508');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 0 });
    T('-402521315714183175054571726943679054.7675', '3', '-1.34173771904727725018190575647893018255833333333333333333333333333334e+35');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 3 });
    T('2206957.4504253', '5483536757267773.0781508858951720347886184285', '4.02469710356229758887237979439122257676387502e-10');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 2 });
    T('-0.0000000000000005289549144694566634009672940013915898308679385505', '-18.89', '2.9e-17');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 5 });
    T('-2211019241730.118931085998956737464', '1883345', '-1173985.25');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('676660413361215098841.6447', '-0.00000000011016974787223439675745714624897538289345097697566', '-6.141980229871714946783543386659759345952836e+30');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 3 });
    T('-0.00000000000000000001122585876532469760883703742146468722976677', '-0.0000000000054744422221837600557', '2.05059407145349178334038027799621311225211509668637086903391590926456766746e-9');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 5 });
    T('-58.2', '-1364461667135886369603850.1784667971192', '4.265418472485667689287105862913268192243368105085866387266e-23');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 1 });
    T('-47225932306386643219733.96765155309', '-0.08091271579981112281034023212381984889369879198108909359', '5.8366514879107400140856446166707928594799801466940076002029905146259292256804324968441972873664122924704057077e+23');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 0 });
    T('0.0000010981334284061199519633859544035268395486390675316144836610', '-8233507251008518719.119447816686546693006964245267741540211', '-0.1');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 6 });
    T('-12629847025632238433603053865614665972.1494239645227896998674', '-2591992428721377159251056998048.128872', '4872640.40036664294743635414136385753534');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 5 });
    T('-4252.07', '3415694163747861025', '-1.2448626241567330165894468829708493576e-15');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 0 });
    T('67828346273094326856933', '-0.00000000000000000001981766141', '-3.42262110901077943368359324492061750287013305067865724525969686551426453097323353653966782551867203386638141175104474650523358599e+42');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 2 });
    T('-13.806931363138', '0.0000000000270109174387398904696405526860183322846580991144310044469', '-511161140470.3963666869121585635945898573137993');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 6 });
    T('9.63', '1171334609000199324775253397721344579658013052', '0');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 4 });
    T('0.0000000001168642599645515450579400931900955126185213013465768', '0.0000000000121793918568216690573762516759087773884128915423497231', '9.59525');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 1 });
    T('53506114651950883942285065699033', '65910628177729867715794374064.1138413', '811.79797752298971851967012659297691173513982414824506104066132362');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 2 });
    T('-0.00000000000000000406627260678849033336293998551088992', '-3303171.983301811542274853533900179067748154', '1.231020554589438136806289366857685e-24');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 0 });
    T('0.000001084617', '78817036436563311090367542.130181882621560', '0.01');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 2 });
    T('-5744.73419', '122155848887.064230599', '-4.7027909366101111765684860860155074448700724899701e-8');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 2 });
    T('426.344', '-127873488954305077741949807322665432845121236', '0');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 1 });
    T('40030987601502826523314779745936856', '570996.314388459918349916072985491785987', '7.01072609275529678246947361074571833074130496873796082431e+28');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 3 });
    T('470581.007268845392131980979824886', '183334837116430.861534072111318027730101341054073', '2.5667844402643043142954711637004e-9');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 3 });
    T('48323137770242813929658748393131737173669293941681.2', '-302.5177156686213980269795794973417845274346400597970242478', '-1.59736555141703139979090089819188708015873544578179904997943129115168986035033030299897874617620575984889131116122934e+47');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 1 });
    T('8.7', '0.000000000000000000166761710281741', '52170249305440090476.62082302362');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 5 });
    T('-3387155.337280447827589', '21.94263', '-154364.14583304');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 3 });
    T('1621091487090991767', '-625690863595514294116971833.8982', '-2.5908824651449069100905040391792376372343161e-9');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 5 });
    T('0', '0.015395', '0');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 1 });
    T('0.00000000000000178239599595974964583290109935985132141544888408370628', '-29516.521811036968024710638888599116696', '-6.0386383171111545590219859100069758779882121614779757e-20');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 2 });
    T('74.969990492713749079688', '0.00000000000000052282880601480435829451617959658965518187770782597', '143392999066296488.15598221416532487350857268505818468778132959087203234559315393563482665694193790662836704381101');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 4 });
    T('9596615571258.492610962809423', '-167633520.5824796874157222071297', '-57247.5930704');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 1 });
    T('-2232071124436735511943814137.0522431130665912245715784551', '3564396711.368', '-626212878414444584.725490318710279686312169391968867215929674014486509260688453315113231564206302732269601343632478');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 0 });
    T('-1382227618.75131191316862730899075392511410652', '754635905531929458984619.180888454231', '-1.831648359982293967304909354245656965e-15');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 4 });
    T('-71067330303000363858876867.973933654727826106685', '-11661754495838287260.07549715908674', '6094051.313493355982412064832079563681');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 0 });
    T('-1252371590193744774917140670', '-213356828779653985738.357', '5869845.3541749151279418641211276959015930731289804820486');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 6 });
    T('13352367841149988', '-0.000000000142031141374476971294', '-9.401014250772902375534890054877166473120970323e+25');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 6 });
    T('-10321.73245286387727432273304720136578247', '0.0000000012116081638922756022964368396', '-8519035081197.7404251464625469036910252');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 6 });
    T('-0.00000000000000039871298374', '-34669636664769580398726661099025.86943584', '1.150035079961372033160736089419637803806556114650312e-47');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 2 });
    T('-303137413399920257.30569152070980396', '4040056.76913163224875', '-75032958872.27754452352532363389769842427145464424631624396469616635312022963616794108317');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('3158137570873460228072670005805543345755314.88870', '0.0000000000083', '3.8049850251487472627381566335006546334401384201204819277109e+53');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 0 });
    T('-2432289038390.2', '-318696105128138999338893487.9', '1e-11');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('0.00000000001159', '-1319597700477306095503339987.9244', '-0.00001');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 0 });
    T('23648504.6466', '-270134.1', '-87.55');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 1 });
    T('-346539606072077.2439', '862203.062816695290396772865420408873422969589343', '-401923422.70274641808047258150883287943664547849847021654039885668554386812303515806801631981');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 4 });
    T('0.000000000000000000012', '21194406', '5.661871344731246537e-28');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 1 });
    T('0.000000000000000000111480007578139775', '40759282340479757739197.929065157327869698454301', '2.73508268980055839501863e-42');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 6 });
    T('-18128041192.156711945350321873109876', '-33986859592609750.47129863121', '5.333838256741600071709984030510568296793370390855043571400753611875916969218330361484e-7');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 0 });
    T('37278526076638974862118765.098259276278986122514405', '422484277198516023929200423121333952607119189697795', '8.82365e-26');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 6 });
    T('8768.0457926837864490653237778856176282232936793297952', '2911070376371882980749989481391259968018315772791348.594263', '0');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 3 });
    T('-15955789117760043118300438387.88821275514711148675', '990985099985142384569.56827257552943577101744765232273140', '-16100937.4590992989250162977644764748579171495897739589653639122908862455819077118275788475438161');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 1 });
    T('-212339967169681140.0656347177691098032583634264120432109692', '11427913738903003526979637293.05945166976', '-1.85808164133083e-11');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 4 });
    T('9531.020434', '-334535567052877548087656305116448', '0');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 5 });
    T('3841583091234025971151324407364910092214432429401407480438', '-22416824307585236203987598514653148538792.945067', '-171370531281459881.5845028347181699363');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 4 });
    T('3216714522.970', '244060566972964907041409673187177473756.579577073127866342', '0');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 5 });
    T('-0.0000149274144207078807596236297196457', '365070321314504.979770', '-4.088914806045830298008984522180321e-20');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 6 });
    T('27022766.473594173737137389937884830415185959525864', '-539299052785656617700079811116319917441', '0');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 0 });
    T('-28599579971171430131634037723710371659862', '-0.00000000000000003644973478672098783210762417899790764846187', '7.8463067395460310450266452407524485868916851065079313125316782921027252528619835701517998070723638e+56');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 2 });
    T('0.000000000000000107501465095829712656', '-36.9', '0');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 1 });
    T('3504221306553522426085327256227', '-25730.57184190476446062096107175383931', '-1.361890177989186277274384722436967581e+26');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 5 });
    T('-5613976985159967030036081584308829303811752101719', '5826360651980204533629650242959093732650762454761251564090', '-9.635477994744361231994675869384292734433202261344614e-10');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 4 });
    T('31450598647096365977207660693799877880.7722033791', '107521368334565489758', '292505565491262148.019571293699173528327044279742920906207753129416525762209451256122138367129671204843851546');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 5 });
    T('1500908.503777', '-1015794940302252137891895242750618498147131.9366486805297', '-1.47757036802172020799761083929871197843150569793966301441245e-36');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 1 });
    T('-73296034', '-5', '14659206.8');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 2 });
    T('162689268248656604911961.73925878415346621140', '16.8530012184832', '9.6534300413050659945667091905274e+21');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 1 });
    T('-0.0000000000000000006349044078849485', '309418015201986203793355024.150967286295740', '-2.051930969405536238876578741356000088614244e-45');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 2 });
    T('0.00087604094095', '1392643254462374770962.4', '6.290490677658813987746781212472635606387062383544e-25');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 6 });
    T('0.01471018444847', '-0.0000000000031444004384214340642523517788169191904279950', '-4678216002.2');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 5 });
    T('187743709993796.4707441185609022061433785613916665', '-148037593060997360064291511624701384112069161633.117310780564', '-1.268216444970424611070255845307078487869328514291e-33');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 5 });
    T('0.000011258', '0.00000002533815962089606530705098', '444.3100907263867470311330952968235026076982471394');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 2 });
    T('757411567322940237009357511826689969429965.236585820277', '732371310539520997815.583055808555097036195690159014046186', '1.0341906576938037911928068192477326e+21');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 2 });
    T('-568.38271', '-0.00000000000000000009831306318615957356693126102654593877784118926', '5.781354904218022750361120979397811789718111958564428281983974648837588268358968369893867421753377610560567601e+21');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 4 });
    T('4961441143214745081236647304879610502095528582', '152849955322703', '3.2459552459403407242938276150370472621615e+31');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 3 });
    T('3.07144121980414068036287438221', '-9172805577814.461', '-3.34842071354133190529054610280498225047720875195151670690172482e-13');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 6 });
    T('44314348083704254263362409818654768380209.012579280', '-9.417687525064823672162', '-4.705438353710852226448547042633572616984454390342684398583290673e+39');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('2085098969276295556177971788779802383262842.2573', '0.00000000000095273487', '2.18854062649800521752496766364791747704462864605763825984453e+54');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 4 });
    T('109753.2295760718524527484177', '-2410159320462121517944570628199834932322126563296852', '0');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 4 });
    T('0.000000000069254571', '0.000000199024731561379031663465058346103053493401562136877453001348', '0.00034796967420424309603498770442174869249118067854495112595546767');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 1 });
    T('0.05513850425913127663195321149816649956181', '1583707666489.2', '3.4816087227e-14');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 6 });
    T('-0.00000000000000000001911867896259825309', '0.0000000000000026470470353798680890064052204548929047195017581076193006', '-0.00000722264421714539010209156219178435935');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 1 });
    T('-6073252477791750891.3306202701', '0.00000000000000000318941067336920340144282050435242157283523553432927425299128', '-1.904192686285876887623788577946073103761642119860783779636402053198955991467191518914690989817783177670381359194515048092874262743002e+36');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 3 });
    T('378672312.587170', '-0.0000000000000000001053', '-3.59612832466448243114909781577e+27');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 0 });
    T('609789798178485116999338276095741737992.379075331', '17.0', '3.5869988128146183352902251535043631646610533843e+37');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 1 });
    T('-124.716', '5216585338728473.111922771500014302179232803666', '-2.39075931671423873e-14');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 4 });
    T('0.00008981163034929156059932182280362293647', '17.15462944126793230', '0.0000052354165187174924421618028002824702737088914242483722088492099572847282013733240288959490404');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 0 });
    T('51.131', '0.00000000000000000163392086120629508806283832967421051655309', '31293437285726849899.9548981381946366968329515395443936573946414878412107077307898590483457854490120470465228429287396');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 6 });
    T('0.000000000000000224443342970341249514955', '-195.075348122424284622226008810924357674021585884736420502', '0');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 4 });
    T('-0.0000000000000523354375249977172294108', '-59305406992817199156555859872622215551484.43155864914470', '0');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 2 });
    T('6', '0.0030', '2000');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 5 });
    T('0.000000000000000000034611171122223173101604291856002430473572402', '-0.00000000000000001306934614', '-0.0026482710574396932379054957');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 2 });
    T('1588463948.87932840027706', '0.0000000000022448099935370064122298031327392982562438924009101', '707616214046020578248.81130758203250848509051455636434814147439890491');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 1 });
    T('331.68', '-33750.2034498218032862327555741660509773034307606364769', '-0.009827496314003737584808993904721204561638977989420994442365465662925539835282246204506787');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 6 });
    T('0.327498818868821216689791032955550931752264897623', '21042718581930356317251390092870285676850.926244716344', '1.5563522250877247306423254201e-41');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 3 });
    T('3958539212848304459958011955905583053', '-21696668207847236', '-182449174911407951863.4531483205530341836363930866093940294762697819985445794');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 5 });
    T('1247355676807195054228866279313', '16.258834134091449785731551775353859635', '7.6718642094499587743177888766100455319156336611325707079731669e+28');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 0 });
    T('0.0000000000012350636190251876598396', '-951304829839431745267098098582', '-1.2982837680259132276449985e-42');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 5 });
    T('-104.734641992', '1733564860345817076999292.62701', '-6.0416e-23');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 4 });
    T('0.0000028957367658033897750603780262704357073704233855043345', '6356266743779871175690.8320757525027414064', '4.5557193908470029595714225575995705e-28');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 4 });
    T('-18558028455212231571697031', '-8', '2.319753556901528946462128875e+24');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 5 });
    T('-13821411732239834470835288846455021839518308', '43191343517856916199296009474.4583', '-320004209327860.943280120415530700855745713808556291320032098976026114433405693');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 5 });
    T('1105537642062114566378066835007', '-67031135832125199.608799899', '-16492897342972.91956535243888467391305299684032312977820150518076720770163876179182196342933551');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 4 });
    T('0.0000000000000000001255914148577465716438366888116166812811129178359847494921', '14253616998215507072480525.5466822973429', '8.811196124707861086162541630740460525710456e-45');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 6 });
    T('10307.48645', '-233.40', '-44.16232412167952013710368466152527849185946872322193658954584404455869751');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 2 });
    T('51547410618891864439338459879661143474.873695893', '0.000000000000000676829184531107024516', '7.6160147636959276036734477149740626732082461515375015431101882226904527697230136479333303806794331563205180614e+52');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('204708594426498174030950107.254', '4440698384508500810481273876415279950855610099962910', '0');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 3 });
    T('-6.13262', '23040527189197.48966', '-3e-13');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 3 });
    T('84389016596253.6582867036429852020414930676618', '-0.000000000000068476172931286069798457953929796189460178155', '-1.23238512001737718906979098515503064223947711793583508345578763371912048018025047351275887045048034847634525910066e+27');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 6 });
    T('-38248107466844304398754595001002', '0.0000035010431864427607738252', '-1.092477454004397498727080290040187638747725994106560343172688418173937260394324598159119517021792374783673726682471104291825439097915e+37');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 1 });
    T('-6.04', '-52596312949208048443865032.445961', '1.148369469516388467461983778327576939930189067065907333733000607931365766262e-25');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 0 });
    T('-813956145912449846600403054832', '10796.36780196', '-7.539166512692186931160646370173229289e+25');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 6 });
    T('-2421788107883639375.690813214146289140632086497030390', '1731175528149788838817994796202724767.68013543816827528061235', '-1.3989269536821316086138504672469213952044063942010898714620955200178235e-18');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 0 });
    T('6809195547555535.498930321150996302023166384162374', '11654400.3394158857916', '584259622.9105349102');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 2 });
    T('7650.2', '167313423904874555768.53143200344236', '4.572376693665353260468390163017986446812909378918e-17');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('0.0000000000215178880', '-415105913902008739133981.125527139819700224156205940189343', '-5.1837102964231878130039665575920669505879406859e-35');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 1 });
    T('22142223705380302372371177782.1735702866136041227753', '586007244566197651865789605.262', '37.784897560048902907217450655951502520247844259884569454602755728879103478107373423844615729');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 6 });
    T('-692051984878.44837389610506', '-0.000000000003543', '1.953293776117551154095695907423087778718600056449336720293536550945526390064916737228337567033587355348574654e+23');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 4 });
    T('-2098291.044481392971917438527834118527', '-5693120152498224716798827599', '0');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 1 });
    T('0.0000000146185660337188726116266948236882286', '20.7', '0');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('10704495556869164920.51', '90619.2588', '118126055086086.898346050034123651');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 3 });
    T('0.000000000000002487958710561768110187226959259', '4063693787689666341932152579391331936357.573517570229', '0');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 6 });
    T('51618848316969818775925143304056624489535103456.6', '5', '1.032376966339396375518502866081132489790702069132e+46');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 2 });
    T('2654107.13441542394', '-6123874494540609.39129700002676534532585907120017117261', '-4.3e-10');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 2 });
    T('-1714194716329674533705519065.5334413206217103223746696', '5.98522507452367335745', '-2.86404386633045136335500224142654677487187643840811577337806125077173786775401349379930631210035469203499993508952054e+26');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 5 });
    T('5702848846892587648420853565547712298213651451', '20315551290068.9958657451780294280', '2.80713467504096443336245665418400813749841454239681391965351719619477522552050607483391155099224061119513736999774116474859166959586e+32');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 4 });
    T('5822711428013.7278457962610451325840881631471620796996', '7317134960.07267345871391728', '795.763841966350301550416023965287902186366947585252329405753890743811409560180259233344579873');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('6998999857049233887139.178', '536565672053559187736681540252526377121.4733799', '1.3044069387186968841309942400771742644732909128490501807562862836e-17');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 3 });
    T('-736427.362', '26561785052330377.2389583235', '-2.7725070455512e-11');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 2 });
    T('1706905651154879542863', '88.56507646747069', '19272897616498006457.7522807926014250674708948336033069877118029704230360991538');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 6 });
    T('257245103.59464744281', '0.0000000029115137887165463109918224', '88354417070456755.53515');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 3 });
    T('-0.00731213642756679', '22000291.2308', '-3.3236543784156522957658811e-10');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 3 });
    T('-1.00153755', '-0.000000000004817370897527122943915648885377070823386522456337944', '207901274638.021808115928034265486');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 5 });
    T('-18876185760828306319586606769243165085658142.582', '110420998917509223452862481780135937729683.9442', '-170.947427988130159944154589178595087116373885300937');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 6 });
    T('10139455414077721510362752985718.349777032029', '-1592.15854283316275020881903273194474638353703333947', '-6.3683704488593777697061166680042965589526026607894963695742224646320751612955e+27');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 1 });
    T('64058.2040554083', '0.0005021239538086', '127574483.49063637011849827272068476023898087743836443210535013094588197053638633850291146474453448271');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 6 });
    T('-1428475428.20735903897201934602', '-0.0000000000242430554', '58923077336504335133.104523863770075780135');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 5 });
    T('-51554046121.3034', '-0.000018880638', '2730524578740580.694360010503882337026958516973844');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 3 });
    T('-2762810286803588.45192428', '-8640345932207758420293371601.59940312431169954302570739', '3.19756906549879589027267406125e-13');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 4 });
    T('0', '-0.000000000011202663303958747975051152590316', '0');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 0 });
    T('0.0000000000000000728863062144561648570757530722', '322752261571.8626880286', '1e-8');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 4 });
    T('-734510557070.068348834319420815381', '-246514712290287800069556.88175493105500884097', '2.97958101667024372312554181557200100600882497777415203837744586470161731601583448849e-12');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 5 });
    T('1377663375802999968849430.3093839', '566468290791214461291218484296464177560', '2.432022053482903606051085e-15');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 1 });
    T('42.717407896393966477614218353439273979669938970221536036678', '110923.68743842532496727427151897458876838975677629026416375', '0.0003851062');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 1 });
    T('0', '-32462950625688705502194075615292.71', '0');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 2 });
    T('-2179016107.7151039', '-8998016829991.427774977530562439090670', '0.000242166262731604582217366864917233636794614427746718291884330094957283');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('-20294295265203512774.769698852042811556484427715976', '0.000021624092225657109443305144', '-9.38503917455744803550043940290482273316338e+23');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 6 });
    T('0.0000000008493664', '-0.0847262743', '-1.00248288623261226063377e-8');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 5 });
    T('-21440281347750189310337', '-0.000000000000000000387132410079674043729097884456491866784968', '5.5382295022361103568950998795402234908365568150385575865160019717068179574792611353491e+40');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 2 });
    T('206821560851854169617748462848949473773944', '13211894344505757704466014.438', '15654194278193127.234892190339874212443694');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 3 });
    T('87335372170833177344.8303029843663', '37000975631892503811354619634411655865.6169807323644717989', '0');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 2 });
    T('-153953834712343763790686290606.3999', '32832548130942465220.147', '-4689061418.515142415435868663051072079842174369411856550042224630514916748907728876061295');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('8591618553304102854549436621158504457632.5171957714', '-1542797194645238675645482061085323571995441155624030', '-0.00001');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 3 });
    T('37700127.5951420458769322687632041', '-57762387264539495550418.0153494', '-6.526760644861067e-16');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 0 });
    T('0.010041502557250876166548957814077913236106', '-18220674406719803170800673691038472842823530', '-5.511048786178605911409e-46');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 2 });
    T('80.29', '-8524769191419139053935120.494218774674499753866', '-9.4184368e-24');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 2 });
    T('109702701616263639000350650001761093468367469818592253226', '-2021844707442628.03807051', '-5.425871789877639160770322751829476922008624495250501167900874909467126706972380441248639983205158035489570536069623734497094883214019663e+40');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 4 });
    T('-3005.5299969285543736815073486739041595222490', '11869355000843396498.275115952278894077', '-2.53217634548380388605943229997686131910154e-16');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 6 });
    T('-2.9854066005', '-2.07', '1.4422254108695652173913043478260869565217391304347826086956521739130434782608695652');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 3 });
    T('60997727678079129329650246720589441117', '-164345597279206048954528559846381714544641.400997176', '-0.000371155228298877666235893044021252300333269');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 1 });
    T('0', '0.000000000104418206', '0');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 0 });
    T('-272327.1', '694.45577474495', '-392.14462592');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 0 });
    T('6237855.72', '0.000000000000000056118290958004531753653601257', '1.111554827047036507995706512423927767064027042762859524443941584662214168498358135819148727524390167927840316489194652889418e+23');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 0 });
    T('0.000000000000006937403050062051741264875394222559344579302', '1509646995595711435.959', '1e-27');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 5 });
    T('-164471871725054325379243876510073498031765815264104734195', '-0.00402430947386126023272568404053794601387820869747399428664192', '4.0869588383630498731416861920107609850137223086980649346785688450001052069390464103e+58');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 6 });
    T('-133380508526066123553.924166134978708537056649683776', '332452693837394951885538.01', '-0.00040120146715160475560382614621874425251758726814333122');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 1 });
    T('-1002134.167299', '-251.640', '3982.4120461731044349');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 4 });
    T('3091342449638972957936252157062677150123597', '-16288785543666.3129808', '-1.89783482712804340336650119939870960656049694756418219750511012425980687183218750107631468549277698312382362559693096e+29');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 5 });
    T('-2121799566979', '-20804629779048036144946756642230281', '1.0198689375937973728019325041709023668770063207827995907217465870058272029e-22');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 4 });
    T('-2.95', '-1', '2.95');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 2 });
    T('-0.0000000000000000000128531295816420791177802740270342784459', '2133.1090', '0');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 3 });
    T('-22.4694657270600021059023860420', '-11079.1', '0.0020280948567176036055187141');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 3 });
    T('-0.0000000000000000014765999000906441441566319', '13980667685799243617101573702.2033564634481522785621111348', '-1e-25');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 6 });
    T('-36625617695236881.773942648961', '1311498943574337365145309982488.6557', '-2.792653236564417936966141384470842862580855171690821248973320554198267761643707277475e-14');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 2 });
    T('-2104684780739', '-45.6', '46155367998.6622807017543859649122807017543859649122807017544');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 4 });
    T('14570972898277952428626.0983801671394340', '114423093266432345.2524483', '127342.938233191046005191826845887793763656551737627592531031804176335098511683913206903');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 1 });
    T('81260582666910888471517.696291', '157183273101224011686.118', '516.9798354725703896250771557514765169801823622101619483914412');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 5 });
    T('-2.525060632104990744774590726583480995133091410643517095', '8737246559917825.103222789941919016', '0');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 3 });
    T('-6908481234802683425254138906190088906940533878.111', '15381.89870114390985717228404934058434081488126127180', '-4.4913058972940177512058867064538945149459323054127e+41');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 3 });
    T('417982.58607482343146733674248486', '116386843556506317108.22539086', '0');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 1 });
    T('-5780608294791.624458881861849817493', '682392959.70758196837', '-8471.084310818098502691272384981');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 0 });
    T('40159.97604002006812174866', '-313664.679534078486903276', '-0.12803475');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 0 });
    T('-4.047', '-1.81', '2.23591160220994475138121546961325966850828729281767955801104973');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 4 });
    T('5061613769913356854864601678.89379478', '921818732154416225536544128239745673153253611567047', '5.490899233609274193409593992073909981216429810581822729779521522e-24');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 0 });
    T('-25506.3998849214929', '0.000000000013985173677629659', '-1823817170445362.78619963707679912302299395613');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 5 });
    T('11.4581525319001337207', '0.00000000000000000009416824099681963524706645466971745', '121677461643221226049.4121814719193701493831141147430299424294358706877279967065063044082706631899843825377434102964830059');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 6 });
    T('-13.1', '71689907220027014271360598291.258402249236137629239531728', '-1.827314402820211048849800495e-28');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 3 });
    T('-1125106278543860.42641857171081224001205', '0.000000000305408269978069643760450306647132844200436249835', '-3.683941756471265763378768331539492008773195171551609918202663377907462939251038817895e+24');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 0 });
    T('-0.00000000000000000049608590807042330411', '27990', '-1.772368374672e-23');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 6 });
    T('-25928884865429476681995775592751670033286619073442', '-219192400010954.9422554036825930132777', '1.182928097148148648508822522228604781132162339640607517123442344178576719677e+35');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 6 });
    T('-4.46763325', '0.0000000000000179609090310047', '-248742045421410.882061859008635736643114865517174911865521227799944534457085');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 2 });
    T('-1287033681371878104057667.7055777252542186915675', '195707186672724900856206502221720418737', '-6.57632e-15');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 3 });
    T('0.00000000000000193175636808677074413', '1096214462030958100.02309399230397185919335500330064378', '1.7622066e-33');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 2 });
    T('4.1855102693159094752', '-1769.223', '-0.002365733584356471442661552557252534021997227031301311366628175193291');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 3 });
    T('-0.0000008679493116849', '0.00000000000001377', '-63031903.53557734205');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 3 });
    T('619020164695232324.022470822521', '-0.0000000000004062829882447739486123366057322303105417101432919615', '-1.5236182232722239291358561175494240320173964254115460755085158141082760696213303513827725096088371826207242532e+30');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 3 });
    T('42561960553952288419610167869608672152477976.7637409739', '264520977464840304990428792028340802894082649682880151.87', '1.609020235818898502867215862305232329970845e-10');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 4 });
    T('-8432160850933490778.69395', '-903254.8849', '9335306115578.905936669072754216997426392772559');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 6 });
    T('-68334918980853445275646478865113316249836762.819', '70067642250.1174035246005', '-9.75270706796744613698328349792670077865167e+32');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 2 });
    T('-125210874454495603116740976.379', '-77140850018624120914', '1623146.159580377099547403143409912506569866772423197071869436970879279367977438726091333988946827384');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 2 });
    T('-71924.8159', '11792', '-6.09945860753052917232');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 4 });
    T('26738605472616.34809488607216342324130569467943599370', '-17848616068000574690442.240120938', '-1.498077238635546584508183889182860823798452319e-9');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 3 });
    T('307728725034195445693818971152253110685320114730380.6360569', '-0.04791701101144421929437607982012423', '-6.42211854492967670147798513527529587291182927874576501544632945181254387470070916840287404357386e+51');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 4 });
    T('1063469210609337404733995767077620', '157322.98262357845381312530739737044008643142255', '6.759782918391938594011489608657438980256117690815000289918435942612008089111174784431469936177200692245e+27');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 5 });
    T('4721242310773063039516988216828059', '171400453736307845213676552.5264455791334235426375810', '27545098.0896263513314335');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 2 });
    T('-3554846810422675439500939761.48523775084025501057', '3315590942268820.06130581', '-1072160852264.283056864970073195051461622948996967853643073530490983');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 1 });
    T('-315298.27020265072220508757446517308919757747772180364', '24674904266140137236693349157364359', '-1.2778094974630368249191962362594215e-29');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 0 });
    T('0.00000753194455756794779974643789264996726', '5991522948863651', '1.257100176674855652252945e-21');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 6 });
    T('-3.3', '-776998301627358692703026', '4.24711353047802405395217647701160391118416266e-24');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 0 });
    T('10977918093.74255295043893514908080', '4088067972470992.747117265605094792327745422289731492', '0.00000268535605759682552653099970835593');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 2 });
    T('6856439', '-17246005.9309043907638765902', '-0.3975667773437002568945641473');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 3 });
    T('298153651523492269765657502906019847', '0.000000000000000000583575767236932787472350570065527', '5.109082115166741717506899313404018033667092958887247086907247281013218226491031783e+53');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 3 });
    T('112673834429924858801595684285086.239309381981428', '-267459587411.5959056', '-421274240046329341201.64843123511725546164313842329550287026178410911552652826352283112794653674395');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 0 });
    T('0.00304013112747436879592085927', '-466567742.705324788338', '-6.515947951837847345154447e-12');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 3 });
    T('408039980934080654190.10495', '7740827823125488053793915672307134647697764525', '5.271270596086294571867592375848040651671580781285931860265302318308353e-26');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 6 });
    T('-14.35994958840514231708055641', '-138375506625046841270057381331164746.7022255338810', '0');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 0 });
    T('-2.30545415622', '4.1764147639455207766144357157533380499118421354269', '-0.55201752855647971419990305582933793');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 1 });
    T('7', '1517830154233.256354618065521871308', '4.611846e-12');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 2 });
    T('-21565167379464493382078.1', '-0.00000000000000000015054398271503612276516', '1.43248285255512869987845415014282003732353935506369813229992050816e+41');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 6 });
    T('-131265273607.6', '8527358545951160003249799367499710', '-1.539342727296549809434811171262223366509053565931192709376536462468975683e-23');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 3 });
    T('-7400030128880533683116353483202129315391542218419503647458', '188653216.4064145408994610', '-3.92255709700633529926085692361021860510356981553906056412282862405749365644716719294480094765319042816975315928831243535386869738152e+49');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 5 });
    T('0.000000000000000002980505992129620520127442706896038555653286379104580', '207.911145544', '1.433547963160473961381177693472099296632254e-20');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 1 });
    T('54641030767.2', '-0.000000000403625437861745840964628129162180522645168390994640836', '-135375587467101709281.226161911575732696130284100795168990520198665934091307492071006553764178017574533458784');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 6 });
    T('851736532738029.60209470571380221276333463072', '-0.00000000000000000114929416269306152351105287227218987361', '-7.410953264934490688278940003920834703403777176356982558393641846764034783e+32');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 3 });
    T('-219483098', '-0.00000000000000000018804816235407398287255832650176', '1.16716427989728235020019911955583225548719003865002e+27');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 0 });
    T('217289940219309246936943195754200410.51455750668', '-63355238534381491744596342895551077252.71', '-0.003429707554512493626949130409168057711026740378896565331657739651625001466882133520579718359906689');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 2 });
    T('-176541.53078', '5636726158518564799096514888456095728041', '-3.1319870047829032e-35');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 1 });
    T('310106593797778297794006050555480612566516210.801605287605694', '-62617459184350755065823836651746823705452786558', '-0.00495239822626465799890522013613597052253609868931450749761349632061009409030943676');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 2 });
    T('-3.93331852', '0.00000000000000000017547329228603830', '-22415482542997560447.66801836373937215965155736854780121152633001674');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 3 });
    T('-3', '33.42273262067', '-0.08975926756343902112491292');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 3 });
    T('-1085841368229.94743889887943410676813741370545796101970', '149610498943278043790373953905696078398598966574.065396393', '-1e-33');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 4 });
    T('-6855.326', '-6.61', '1037.11437216338880484114977307');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 4 });
    T('482589.39032468525307515', '345620881.1', '0.00139629697369197885849365714148108512532809465139691758051015511979146');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 2 });
    T('0.00000000000000018873012642883182832958209507253635128', '-316826894495349657610523346282389288091344754546005352412', '0');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 2 });
    T('-0.003915504234894627513', '-2561178368548558.3', '1.5287901393269916111965312123266261603335417944432306248e-18');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 1 });
    T('-0.0000012845584111321936644262379417469638861846223574683905234', '951434782049434793413124934712308714591814021.8202740667', '-1.350127654956228395192441e-51');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 3 });
    T('8415663741.6', '-1168289085861655174422234758990445457837305401386032655', '-7.21e-45');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 3 });
    T('15858062669861942257032429298168.061284122274275', '-0.0000632521476327715811032330323136282408108535316', '-2.507118455792277110934258995900949920340359411372602248666188373364931628696825287100597787416097233309978475814394363763e+35');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('0', '-0.00000000000000000159599025962211', '0');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 0 });
    T('8012431158360693111.3422024194980884319325209488819277405', '2948627644398253137185410152161559.235676341420', '1');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 1 });
    T('-16692108859470873479799641256137360063087170548211631950768', '37848415114043098758799686016767986.0657242693524879935887', '-4.410253060577300514678904143e+23');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 5 });
    T('-4243226161', '-241235.3', '17589.5740009857595');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 2 });
    T('5671433914958075722313198736271285623794662361', '-1529262.981377059120344780400627536817216209608491794503', '-3.708606030501768874471207730787071653798986595411035303838097501627810686978706206155e+39');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 4 });
    T('15076573039121823.4228488681', '-161804219260400857597665.80520571234560198305156', '-9.317787328436859431009430461085894566148816536724215e-8');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 1 });
    T('294.8050', '-1.964', '-150.1043788187372708757637474541751527494908350305498981');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 4 });
    T('-84259403135132485171174.02638116507', '-114.25883199713512140486366465931939269178', '737443238849537430255.562897456860924998387708483089712271920400180306835801578116806671059372285530053918368188248465511');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 2 });
    T('0.00000000000000000046329876', '17951420713085087388514.79177201848797', '1e-23');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 1 });
    T('-0.0002610697214141198547803066285872786447209856526772883974', '-178463559138028170694183028.197759979905991059847', '0');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 0 });
    T('10467906625915426931.86040412', '-47739824225253084453503246028.8', '-1e-8');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 4 });
    T('0.00000016666446981689100983647498315835174605580766', '580387622169032702425477961127755252936733664151030131299360', '0');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 1 });
    T('-224.769', '-24801326309696', '9.062781449398827959722015515861155e-12');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 3 });
    T('-7', '0.000000012707354813051516957', '-550862087.58493263467522230046127695732435950160199797173188670287711444397512');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 1 });
    T('-4.3656189571419062523183949678080584000285054747999', '-3293692576993760246104014415046803314.10507195460869', '1.32544821809888565170762281523897677163949595277716403402859734e-36');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 3 });
    T('14.1957398777937590270133873552634805598', '-0.000000000000012563918029887170815634048090532307766027871798898663876504', '-1129881605724010.2');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 1 });
    T('16935191410004228.460802414832644503742366518153', '1643218550169899824827110750524231685.35', '1.030611016912705990838456e-20');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 1 });
    T('2050277235517443724707910505052.4731518708963', '-0.0000000000042732754158552556793926871242449077002300282150840251359349', '-4.79790567186529005222705249614533112509378367129076106364835811006606986e+41');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 4 });
    T('72300288767.4686', '-9079012869267363449548957.7441533', '-7.963452614127962619893834937e-15');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 6 });
    T('-192278.89137554', '683.9', '-281.15059420315835648486620851001608422283959643222693376224594238923819271823365989179704635180582');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 6 });
    T('-37071737652639279645773001054327733919457032661726466338296', '214460775018254857803.123699146008820945', '-1.72860224204093922691043082274757832113184495522998e+38');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 5 });
    T('3508739066826554438413966431669941507968277256138700398.3075', '26272394523500608871817279308.076254831783976099304629', '1.3355231338688956416143598722e+26');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 2 });
    T('-0.000000000000005888147537781712378940578659229857732339205517', '-0.0000000000357908539645432479549', '0.00016451542462817163');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 4 });
    T('8.9', '2351287825342227.207075229251', '0');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 1 });
    T('-64917.2734106506408', '-79744.96255', '0.8140611185308110825616');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 0 });
    T('1471910.39014886', '-0.00000000000000002292836897845593599690424193', '-6.41960355545526809487536529467727428238048655970053407194427902647011729951927080268452364187789104659194714727650982884e+22');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 2 });
    T('3358.2557686025', '-13824816.20862637369171939065', '-0.000242915039008404617');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 6 });
    T('0', '-176919225043114407825860493712084027468392984564250681392777', '0');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 3 });
    T('-94.74', '-329651568302571800500603522925.308423', '2.873943554639563322615843605e-28');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 5 });
    T('0.0000000000000000110731296084', '0.000000000000000295624180561344759822516282345296563007307492621010', '0.0374567790340216195083300376735558825475464199235127102791290477');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 6 });
    T('83646713.06305786000482933881370', '-0.06053394237208041753996944641', '-1381815057.5574862847330003528953448813081937401796458491197415668944330729137829413685834');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 1 });
    T('-38.86923', '110300320411935711291231863077329191512675361', '0');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 6 });
    T('-289778228389644.735858', '19872423685993.5061287641581109971172568923761866135070070', '-14.5819268433717224346668613163636009356892');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 5 });
    T('2349185036898629126357558810676316514842302299.0', '1207399206492272243854506147853098478', '1945657264.1980319963362423395380699788180442632737552157456700012');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 5 });
    T('-0.00000000002296696350413542311429801774342', '-214365998434669728.291424303429733970843831227714', '1.0713902238155014381665505340351475808957657678046297897617544e-28');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 0 });
    T('1.2', '0.00044989117011003817105772781526543396707216835596267685462', '2667.3117405404820335329558172000325992151689227771625583656817424662783');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 1 });
    T('9595745885499426.7169802725', '-0.000000000327743137731955836', '-2.92782511081812216573540637169470332617972314738093221280858903756193467761589986022579484529723405084138308540303e+25');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 5 });
    T('-688719.8', '0.000000044444185325676', '-15496285846016.33736365698488460633918072624981148372653014620199623652720088517243');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 1 });
    T('713224612262773653680241404914834356988249073', '380979.615840832555552739491029492', '1.87208076917361364947269850626183178839836232939369106393408135378988816660528694640277e+39');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 1 });
    T('-3275063595', '-0.000000000000000072', '4.5486994375e+25');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 5 });
    T('-2.6', '170162024025946751328594.69323995086202421', '-1.53e-23');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 4 });
    T('-0.0162866737821637854634366877470516190361196456175', '287.485', '-0.0000566522558817461274968665765067798982072791471468076595');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 6 });
    T('0.00000000000000685125450752007', '-25463715301672573', '-2.69059500012162339283072238861321781124021695474267719e-31');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 1 });
    T('-0.00000006417176012350484981296579048552883728704381828848778164396', '0.000000000052422588311249876007', '-1224.124221843002820600268753483592272');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 3 });
    T('-16621167342820978706536182564384834520748084784088309400267', '25771141077830118867510', '-6.44952712517627078574684074824441580996230842092e+35');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 5 });
    T('-7888.596835206861517863152770552325131999866', '-0.0000000000069530421297744953074562967729205968985', '1134553291634191.2930516886628897927997661960306833620003034495097750648');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 3 });
    T('1.2802', '0.000000000000000320733183354699837542267', '3991479729692399.14388544644270182793510362289414907');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 5 });
    T('-1143167591244810954376007417870910708549794020221806675.867', '-83.1001483252906', '1.375650482319176190320461611356383156139441669005066072939373e+52');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 5 });
    T('-361334608750433443027647', '0.113122', '-3.194202796542082380329617581018723148459185657962200102544155867116918e+24');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 0 });
    T('-0.00000000000000000002494217', '4.8', '-1e-11');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 3 });
    T('0.000000000000004645660102106500861269', '-0.4071388488567123873955', '-2e-14');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 3 });
    T('-0.0000000000000000140510767340573128875519317863769472177687242606399626', '-956282191.599509427461617089251166031', '1.469344180775238969387615485222865453266870409511e-26');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 4 });
    T('-2906876362334903297.024', '-19.60375223', '148281631405566040.304111719534827032447144941293');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 5 });
    T('-914878775966528731607.022587027744', '1671043826055263405', '-547.489396568509031642388212363936459110501972');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 3 });
    T('70450801694587804894143.61391892280709936158771890305892', '-108591331528118593575781087160101701786013931909', '-6.487700325909099293397426242451e-25');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 5 });
    T('-891918043949231447159022241220674070858767357271692794630', '4.0980', '-2.1764715567331172453856082021002295530960648054458096501464128843338213762811127379209370424597364568082e+56');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 0 });
    T('0.000000000000000005733565055241296218580315962162371319238205673524041', '-70690401.6714', '-1e-9');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 4 });
    T('1.5', '-253064781747908408661311723771677219591548.42553453449777', '-5.92733603482697001046428303053562006e-42');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 1 });
    T('-199265060704729205211360524527945335218.86764046022', '7109171105669220246688089204413433520955053246149', '-2.8029295925347042674352163178171548898777443107245580741e-11');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 2 });
    T('-0.0000000607986152676359078812147626961003363', '532.239727', '-1.142316369548940263176084988035858e-10');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 5 });
    T('-9344541484.76898', '-2373.199483667610410542181360631', '3937528.87149952439694531588665');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 1 });
    T('48', '-3550719.914288', '-0.000013518385329929660293949126688380820429236008649140673816900638235114992003924');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('-1.021086528836383939047778', '-0.000119076372102297630912420193554175995', '8575.0557');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 3 });
    T('-6705971596222771.022777582265649902', '1537909959592.9', '-4360.444871556660007578271067790611195272808960542501804095769354694463194903891490920167');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 3 });
    T('529745345068548744372662151971878714.04526189296', '-409.8616', '-1.2924981141647540154351179812206820888935725936755236401751225291659428450969790778155357808588e+33');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 5 });
    T('0.0000000000000000001302317170194506400686998546015573602071', '-24.78978867731652441155280376758014', '0');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 1 });
    T('-2146274113875.49496314', '9729696205365623186698890257059.75517088857939198406881714', '-2.205900439822460138471e-19');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 1 });
    T('-351.2', '-3', '117.0666666666666666666666666666666666666666666666666666666666666666');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 4 });
    T('-548554848.30501', '-27614851500', '0.019864486626155132501798896148328011107');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 0 });
    T('0.0000001111574933510049', '215750993474963291939983019990989913881.71402092789336', '5.1521196524132859469e-46');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 0 });
    T('-0.0000000001048421705472715553356589700382964723258539804228872585', '-29109', '1e-13');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 2 });
    T('-49680877924193', '417064263753223072731709638223877170625145.512441832', '-1.19120438363880478031774493e-28');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 6 });
    T('0.000000000000000035480345932478838641527', '9562537233485133001.244440733051688169050', '3.7103485263552569e-36');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 4 });
    T('-279.7217286066255', '-3147.195', '0.09');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 1 });
    T('111829376038647492442232803887249585787639546', '-785143155.00968401893972952268461155222573094239818435', '-1.42431829565231553100788064745240767226374600650422274265871991e+35');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 5 });
    T('-960689828.193588938349683105430160033541668181958553575', '9684405008594.22166376', '-0.000099199674873267376107866212657265407443705080626617764172227837998739700676364');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 0 });
    T('50376720', '-0.0000000000000000001570607389244761570', '-3.207467400508285297088827902284001067549518139205000192129304697371527353270951720777532405603810353446983929799951617047558699e+26');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 2 });
    T('404', '-6183.77113262816412790095', '-0.06533230149290728824615010987067121839540402798');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 5 });
    T('49337215720677521.3443833806616883904146777', '1571453293327845', '31.395916079819832887132998326286413259879389138684913919250570049327770165026557');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 0 });
    T('0.00000000000000003218259158136497095066393123', '0.0000000000000008461224058775031', '0.03803538513790897970897588277140181040692134848067786983140446');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 1 });
    T('0.00030', '11022951460.37551699698035372674421839175342441352404496550888', '0');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 6 });
    T('5719176664843253317578321046372.25184848', '20017755600840139934572319136465973644724390561613964532', '2.85705189876692318995459448300938593640135107e-25');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 3 });
    T('-53063085311888565757232761359792949.5308110327468742', '0.00006630772089294890911071543105161542606', '-8.00255001940976627814140218779213334551277226050833965949950813384147e+38');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 6 });
    T('0.000000214165487233603125515625830085104756776', '0.0000000000000000133131666', '16086742821.47142404990453811981176');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 6 });
    T('-1.3809', '-104175880995529544230786200013858153463.6469561', '0');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 5 });
    T('-80.67336', '-2.4', '33.6139');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 2 });
    T('0.0000000000007711074021569872054857920506375960354991911113', '-5035148688719256503890304372097300573538350546.1866353673298', '0');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 6 });
    T('0.00000000926040147909616485250107541245568393863', '-0.0026523052948041324107443300384238377', '-0.0000034914538297070464119113675');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 6 });
    T('-0.00000000000000000007299155404265500', '-14921050856070539136258836028715661812605', '4.8918507648513796522067331050373811e-60');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 6 });
    T('4185278545255683361119', '1291.04892', '3241766040326096520.896357669');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 3 });
    T('2739.863031800302191994479658708940460984249926450286934595', '0.000000000000000002501528355313917315261103710668929184662215159415032', '1.0952756245917013434979529e+21');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 2 });
    T('6.0', '0.000000000000000000446', '13452914798206278026.9058295964125560538116592');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 2 });
    T('-85532865547198467812607', '-0.0643871', '1.32841618192461638763986885571799321e+24');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 1 });
    T('-0.00000076', '567905990280637889298798417785362163', '-1.33824966280851596454298604e-42');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 0 });
    T('101398028158543389230299115547369007286824902001700116.2553', '-52.2912983373674988296405356', '-1.9390994559812658653832384200571004042037835706815005616110831197380767996466795759350907618753752320858682762688914411513987920202e+51');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 6 });
    T('209146073148637058825542155473422546.08331', '-6475219366.0774934458548879804017034412490751', '-3.2299457566536760101397850799376230370553508534555202198732360787918707517850145708654685805035127577e+25');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 5 });
    T('114628368289852.820180317085131197751245220', '0.0000000000438542841932421628941970348155178396469330199902031464', '2.613846523745490051969847204505399588223338833211389607553540441069773718251499138e+24');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 5 });
    T('517935605107341851096345074856072992.7156008827474683881', '127863800225.0482905517', '4.050682086687105904243568694437970615324e+24');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 5 });
    T('-27286.7821863357398984', '-248871877396', '1.096418867083063497845949282782980272286610399834378561244933632043150788431238808799716e-7');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 3 });
    T('0.00000000000000013', '10860.2671042', '1.197023965918158619058617241555118620007835884254365096244425387638340255e-20');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 2 });
    T('-34576748.1602107548', '-0.00000000000000000008931227430020711652680604102', '3.87144414708187212666840381667854701596189258690906315001487272148181857244354283721918201250906497585496589e+26');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 6 });
    T('0.000000000000115930341935456194307', '0.0000000981174908550652891749896427792341965557406130630062531', '0.000001181546133366814704555871801');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 3 });
    T('0.00000000000000504719252613475311161395980979664810884', '-0.000043082057015271834248968602242413955837904', '-1.17153006977953996190998594253150683389023987586146099e-10');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 3 });
    T('26641.49783545436873820701305448661911594248101355910145979', '-135.010709152353975219390385818328987', '-197.4');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 3 });
    T('0.0000000032140124045405954', '-0.005727093', '-0.1');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 5 });
    T('-0.000000099134380264803867304756248610297405939983585', '-0.00000011736539996855192079409890', '0.844664443621092260838038656775263676785023896530963481');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 6 });
    T('4.108835145', '2.16307342640344721563818985739931434776831645', '1.899535676803991');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 2 });
    T('4656898732572132613.4410483143447805', '-0.0000000009501781415852752916737394036430371199560948203715', '-4.901079627871224417824715320394975940766906006571005665754e+27');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 3 });
    T('-73.263441606903292174252398', '41834794533354231988607405203742026051715713499', '-1.751256159474895662739518935572654737e-45');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 4 });
    T('5904.9925', '-0.000000000000001969995137425189849707027492804513926489', '-2997465520507783916.33831653542548149707564847473062713070397506965140542636523575676815465298609254');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 1 });
    T('880022438074316975848739277453909252022061607980.53194460', '5242501764328018092315439.6288940', '1.678630695105007602278206462360343332224278913580415169255108606490213582659658913697707617099644772083987778310417840744e+23');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 6 });
    T('-709221917884584205726767929753430.745157457926918049', '2.076632660276337510040', '-3.415249752405454532590867318577044409344398629076630420528864457538549690273648046774419e+32');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 4 });
    T('146127526244109040849597787', '2.8374023987494239474733725457373001365241', '5.15004591201143277102110410621545875865437570800644910341093887982827771307526737146399470946988638685e+25');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 6 });
    T('904680341646808206060972295', '0.31148361458275280949052429518', '2.90442353720169443586293613e+27');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 1 });
    T('2203.4076345788', '724154063664.87046', '3.04273323196941940848187357605107963583858770536700794093631e-9');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 2 });
    T('1695969273341.94745291649760098', '15417764236218795258.43748711', '1.10000986353e-7');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 6 });
    T('-73659.540208377', '-7102156144000910331.562', '1.037143350763924834327534486604821120969035141662779199421366204045278117756e-14');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 4 });
    T('-2784953382351286.3086364024258778406', '4107211058684934182', '-0.000678');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 3 });
    T('0.000000000000000000019553789848042961164455254267', '33692178941832704881943898861492602275813376012710964549', '0');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 2 });
    T('0.0483051225529222178571395836923582375668787163795829', '-564324922583504501767854.4731149680171842712', '0');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 2 });
    T('-858453249829127994094226059212202311366908614011', '29034593154.1283532140920733437', '-2.95665672073337373881597003673065506153688282989555301421030066565454579780325802308201e+37');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 0 });
    T('257334687865074235664067782848438082936550966405972.9', '176273197.015992281231', '1.45986282782247206172160069403941119085726865919459578203280519328395117540850944210193286328940285732489888274735976297331e+42');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 4 });
    T('0.00000000000000000133217566057607597276199009470313325350804245', '-0.0000000000000101200408354784046322638106120605309413493311442431555996402', '-0.0001316373799506610430010703195442828939530157166299880802038865535054498692020690474160903264');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 4 });
    T('-1867285.33115732', '19603126380430.651403412416051145200210569', '-9.5254465788752341381720655515657815792150430965485531082566262974e-8');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 6 });
    T('2359244379735388.679109363378009469', '-32.80437753596009375903638080174562243194634612123402', '-71918583949632.626233');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 4 });
    T('0', '25.3', '0');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 4 });
    T('-0.000034397239481491218241448049401692260200746', '6242147450743749254584513236399823155746667146550', '0');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 5 });
    T('0.00000000008090115235821457237042557042', '0.000002260746735132616032831452512375486215969231', '0.000035785146164755552882292240073664970094847240235802197408557921086');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 0 });
    T('0.000000000000000000753854880082021663', '-0.0000000847084338839566150950878853790084567', '-0.0001');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 6 });
    T('316033663553049202534769174666', '-36485934550866303347893992823469.719631', '-0.00866179439949539297322773053625108376549649093');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 5 });
    T('10350911', '-1554504392304.57922084867', '-0.00000665865664403469343653105181196');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 5 });
    T('-0.000000000001772239', '-35562461.9776179842035639740470021156474995631481053688188', '0');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 6 });
    T('-0.0049554685787730540321344924794239555857558650835', '240110', '-2.06383265119031028784077817642911814824699724438798883845e-8');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 2 });
    T('-166.74225666994937800532899', '6131671721.783', '-2.7193604653946343511577077632404311198418677432590846226466038070643979e-8');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 0 });
    T('36259960930.792501556', '-120492187706.163067280', '-0.3009320489658420990850285700429899529669080813568870895438293314');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 3 });
    T('-570058350623765908', '-3.4747', '164059731954921549.486286585892307249546723458140271102541226580712003914006964630040003453535557026505885');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('-2609.47', '-1109610', '0.002351700146898459');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 0 });
    T('454946353192200382741.398543517963735540199082579799572681', '-9933180406199232073881.485077659037299291573620027', '-0.04580067355952494109598732785954730693081');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 3 });
    T('-250668891074943688181903895734299909.55191304408', '-3', '8.3556297024981229393967965244766636517304348026e+34');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 5 });
    T('8.89309', '-42069038047408448018408161.5775583', '-2.11392758493269976782067132153016897036258530108627831048883e-25');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 3 });
    T('0.0000000000000000000173745082126754244569538931516859447571118122', '0.123310867245083651940795939037593765653669051123530055393', '0');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 5 });
    T('0.0000000008775456040', '361131497699701998764610751966.50423036', '0');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('-5153091518.7406040817400744299613233833', '418492316246282598198213462451341163504999408.4406', '-1.2313467460912738294189675806054139004135565214069e-35');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 5 });
    T('0.0000219673332856121664698', '-254444683189579351762035.301650774', '-8.633441662148995949718645766516727344425906188881263491056e-29');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 1 });
    T('0.0000000000000124622659253523913966', '5850.420189065839038762899001934149661715', '0');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 0 });
    T('-688730416.557', '-0.0000000000003951648906503041270453814', '1.7428937460096442372912826654274612114e+21');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 1 });
    T('-9931679467.75', '-1502870206.88709372530814748081674179420111', '6.6084745191147023911621614637629767474400210980963073076390839554208942588543709811596179927');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 4 });
    T('-108428301296313798056110.5721', '-0.00000000000000000204108406597952289572874685216396019', '5.31228983183888130868233422038052762615048646618698180513643611e+40');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 5 });
    T('-365370146.51147866658932522008385261549678', '125512291743327891715725307.614734016887918162081', '-2.911030795761893012183859646040100496262923971339613128613262618010840457978133e-18');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 3 });
    T('55091794759768865373533577657924816002194789011.09983520679', '-73.60810429054803563072034723276752733800453478', '-7.484474065832335746328690987160521918973730100422535780658416323279822817020347204019596161981598133613537277e+44');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 4 });
    T('-380352779968328863604.7159023137659034062381486362120851020', '-8.31574', '45738897556721213458.419323152691871');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 6 });
    T('0.307701303956069746120229064754446779950609104168219710688', '56234631729368940685764364261340863038476403298.3879528464', '0');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 2 });
    T('-1', '19309036609717.9975597446909', '-5.17892228500262130489913347375e-14');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 6 });
    T('-44654585420706993.31742542473', '-0.0000000006027289838445011151208026441190957324081397995183071725019', '7.40873371243542049803459654582339018756502925344373225030046922681306937066090383255310952621481032745967895e+25');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 2 });
    T('-54925165836485672710857725560837377208296587799017133333', '-2825.605707071196726650040560595682826678276353136983797', '1.943836880674226514803730943918030498268112825893215789880695267023603689423771097277245357710607361173152416757068727241872149202600201e+52');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 3 });
    T('13374123411670978.062911770758751538931', '-787.9274745092872469065678639698824', '-16973800056915.43910091242974365104264145175506');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 0 });
    T('1', '-6449.1757131107317276427416', '-0.0001551');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 5 });
    T('15126486128137.793045187069', '-0.0000000000000000022510496179161314088799917337142144133422767760895', '-6.71974798233939632384744366781417676196601258305334434426205837476671258054663726653497745279e+30');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 5 });
    T('-6783497223986906248522.10842171360686239', '995239063638516604728939933320055232395', '-6.81594751635548551852626892275416128903090281787135e-18');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 3 });
    T('12991.8369610336087353450639391088888468', '8032379664056113843191371.0433152382963207479', '0');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 5 });
    T('207320924234.5712', '303336074981166.6737735336493520369939370482505115', '0.000683469396930263576853474725388888959253945256305');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 5 });
    T('-122.45739844454730332010332354973634641363705433251529879062', '9447912296854805543914573195864219175336', '-1.29613182888364839866e-38');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 2 });
    T('349590.7', '7207227.0', '0.04850557641656076601999631758511283188388543887961347686148916913537');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 1 });
    T('-0.0000000000000000001888860109365319078', '-0.000002321644201149817244536824228879826140826', '8.135872449490074464564492664223720373248532002695337135382540057507505e-14');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 4 });
    T('500826035582651297779424569682263507887877', '33.50', '1.49500309129149641128186438711123435190411e+40');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 0 });
    T('-27.315', '-20.342583461', '1.342749806206632625696665932435276540218000583283928648889323');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 4 });
    T('-4.90239', '-1203284257311414630620587028501239894112650148935741214512974', '0');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 6 });
    T('1540.7100926644385965642886366140301649420536640800072', '-74261873930837283483541410115094', '0');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 6 });
    T('155.7220256964369725', '-0.000000020746714034683094342180099017091', '-7505864564.19606322718679');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 3 });
    T('32283641211618963310071449025.8495', '-576447533321496.2747620144597', '-56004474553998.53948365650714366827469487780203947325964417173665506');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 1 });
    T('-6433147.186', '59931478302051899030586452865719', '-1.0734170703377669987152475363845462e-25');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 6 });
    T('0.00000000466577741427532463', '-18573976984136355921', '-2.51199698280032716540277156996073220430913119443365130462967571657e-28');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 5 });
    T('-228072032680546.770883', '667966.49336024786', '-341442325.24780685952619124738397467667467644134322751996736273482306290614526993858625428910843656185');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 0 });
    T('53808201.2', '48235479867479092736228179549920990039221992991677076129.821', '1e-10');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 4 });
    T('-0.00000000000004030778700864994296078948854865', '-72221323.757995430943875648364307870759083262', '5.5811476322029579127873718839080941865e-22');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 5 });
    T('746358785365811820360.654028722178793304905563959742', '0.00000000006840313334942773374783021640222512135814698', '1.091117831624968857486483033762341569518050806597252386832902689378185612786696e+31');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 3 });
    T('-1.9928460955491', '0.000002915414882846452686', '-683554.888628198725265418444707421403141297633390196771552126781196548031150391');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 6 });
    T('-0.00000000000000002640606620253759119845156292542123235528407885509361011', '2225877810.7054042845879699', '-1.186321462729763623968610113e-26');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 3 });
    T('491006992221852923.2372757', '-5771788.05147488482793524714404816081', '-85070170256.3');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 1 });
    T('0.0000981386485829161211029033509485910521986286585709653', '-0.00000000035935692266885312474359284336230032101002204910280529', '-273095.1941987513659486714742389901737409321797571382330304242394579590130429502291583079670345125880776264');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 0 });
    T('-3923683972442238455.688548446964266542022', '19713681370671230635254350180084405861128341616369.4584429555', '-1e-9');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 0 });
    T('-12019045506661.95195991748896', '-186454790035745012458002110.71958138495746529141878', '6.44609103598668391198203675729393100331753335263482e-14');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('-65488790684370436924148606100053700570184631958478581922', '460.84', '-1.42107435735549077606433048563609279945717888982029732492839163267077511e+53');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 1 });
    T('23908388557585898.944763203126346515', '-0.00000000000000210805209717029661834691580082360216713215139691', '-1.1341460009303786507920438774534305298096762e+31');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 3 });
    T('-0.0000000000001369312765059911255372554888849748138390660848424486', '-26311153142729071623.17111628', '0');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 3 });
    T('2833029876644.131673912415342', '-45.65379979003026165930', '-62054634875.3822709505913533021000904804');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 3 });
    T('19656492438.7641125283751890529465696420484811555300946', '-1005436.06768996539408355729', '-19550.2161404710578624949538334409283518604168677743645083066149816019041732132891539115571943493');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 3 });
    T('0.000063991196310882687246812203176', '-764595382.4375863', '-8.36928887889357219598670551030780707299e-14');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 3 });
    T('-9810.22806', '-55098903081097.965527877279202077917868239272912209454994647', '1.78047610958074809297040708909727550678747899737824375163321547306442698717870558649741e-10');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 3 });
    T('-257974616398835703621139090661778182291833909045.657', '-0.00000000000510402729238806919217601232779156465287463125660636', '5.054334579745844122489589261660803166075894965367213510821807688904375456262367095936903170827544723e+58');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 6 });
    T('-479439506286434445997467789.002', '0.0000000000007160566', '-6.695553204682904200554366638084196137567896169101716260977135047704329518085581502914713725144073806456081823699411471104379178964344438694e+38');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 6 });
    T('1.1', '-0.0000000000000106915112901957396962988796099221567390946735312', '-102885361119032.33566720201763022927171653367059674347435084890560649723342406596400208115045');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 4 });
    T('3', '414020.51', '0.00000724602');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 1 });
    T('-0.000000000000000000061882221', '-4050.56', '1.5277448303444462000316005688102385842945173013114236e-23');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 3 });
    T('3.493977827604', '-2260.9669858838401134240638110470714575857000205587', '-0.00154534668105211656336476613115631570453524176333962186796661763534818999');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 4 });
    T('3726948435765826.84326915', '-0.0000000000000001199875176686771574119495523565369900549966411022', '-3.10611345928256491693925279371396690965e+31');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 3 });
    T('0.00000000000000000839371334481157616928404090451838851429883790182523489', '0.000000000000000001174084780027432860197437306718', '7');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 1 });
    T('0', '-12107750456.14393218963304300', '0');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 4 });
    T('32452469555159529657043699375492918544407971123035001805', '-3477672163570311948206.46815498316391271788119679886142737565', '-9.331664409057631447563529641108012734742022362851228519678586e+33');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 1 });
    T('-0.0000000025249569', '41860562832054775078467864.9889979', '-6.0318274031e-35');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 0 });
    T('-57420834404667479679602871688255.649313755187824928', '-526.869920757904877517805158954329176436765', '1.08984840740324172059414548358126843066175829927983359182059463499020186860098749851485099825966999174869239633061771228495e+29');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 6 });
    T('-555674591960483912078.5951', '0.000000000000461167689042817244270167028412844448806527289735424240146', '-1.20492958453750680639966040339288280102588876934e+33');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 3 });
    T('-10269864203446021737948535841920170109700177003', '-8868278165.7332530984614728126275155317340', '1.15804488893102754123887900813714712918932223002003560913873793494119808283875232529043328266724198e+36');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 1 });
    T('682458542873211261451752430521.50', '-0.0000000000047317422583988520', '-1.44229864097488822202187839202570736463468686e+41');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 4 });
    T('-26794151020408.4608794932680594008286263653818575932035677696', '-0.000000000000010618255426571737851651013858255943564445', '2.5234042640712168480007125119498330722733482066532969571905761e+27');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 1 });
    T('0.00000000000000698022055022659864002062387583190', '1.4', '4.985871821590427600014731339879928571428571428571e-15');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 6 });
    T('-0.0000003324810418286578', '-153279272.1421553773097635827640004423163164355773643413303', '2.1691193935231230363867783229324e-15');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 6 });
    T('-9404703133195.13', '-45525021.3371016485784', '206583.16804633');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 3 });
    T('0.0000000000000001830187412365033410994083139636', '-2.404', '-7.61309239752509738350284167901830282861896838602329450915141431e-17');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('-13.1217336639451305439590042', '-0.0000000004897887830525073032777704194170244636961721242635', '26790596514.208918842869983534986205269964226588243435750012963390544818454757631234642456690595');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 5 });
    T('-4005965010496578889385402.4457424061322459174', '-495851632.0429975', '8078959010362204.171060091563633796500721355364945604379286889945542443933241987931947409');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 5 });
    T('1468007492719556720149.7243', '602653117999682820388399772457357438149080226', '2.43590790269557576647632180273158488611240246727647613867086194e-24');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 5 });
    T('-3067720546455460115054583624.90563917', '0.0000007922540348', '-3.87214253472358600483404395141067089709695726500072852642542326122085910517851994409306351947909322278910027205834307225922632e+33');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 4 });
    T('-162209.617275', '1770288709185568423.68896278566909349', '-9.16289057447728252989e-14');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('0.00000000000000276328664329193085095978498036928931806454342774', '-9294328798787592994233339.072', '0');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 4 });
    T('6.909024540243', '756611909', '9.13153025753e-9');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 4 });
    T('-12059873714133.493148039435702897368991609', '-2224844545756841788321221865009881', '5.4205466791528110588556926535e-21');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 1 });
    T('104754143837318182.4', '-11549180444', '-9070266.4440349774831174159114211862');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 4 });
    T('-334030072820632119710072', '-1.0', '3.34030072820632119710072e+23');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 6 });
    T('67796811842755861918265.1423594922053348', '0.00000000000000000013716284029732259235206650049087658840821899770489301325723', '4.942797312726634332534530226132606387503176112095456172429358696109437734575169459831901881448319263110745e+41');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 0 });
    T('2022854952999872055850234034154.369917295566462391873', '13.75836', '1.47027331237143965985061739491797708251242623567916016153088013396945566186667597010108762963027570146442e+29');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 4 });
    T('-0.038747', '16439037192115022080201430.915947', '-2.35701151759574969347678116027526521525307302208203579637e-27');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 3 });
    T('5835060438169234262736748.328559855177221323', '1140114664918923170677.221356634518134', '5117.959287528489228206379959134811856240476081634542669211680204610408031');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 6 });
    T('-0.0000000000000267595746177751020908523341076736116122831657874402545134', '4068716223280464463190.66605189736073370652', '-6.5769085749115693384978725140734e-36');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 2 });
    T('0.000000013615410894818066521708546825107702688528499647', '3', '4.53847029827268884056951560836924e-9');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 4 });
    T('6.2', '78756', '0.000078724160698867387881558230484026613845294');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 2 });
    T('-148428436744.287221266701376626964', '14647.3443717355154907539131930670153547426932766', '-10133470.81746125599475440250281824581067466');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 1 });
    T('-1131485176.36', '243.935512969657494', '-4638460.23313851');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 2 });
    T('-1384271134192800808858028587220494947', '-4', '3.4606778354820020221450714680512373675e+35');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 5 });
    T('-0.000000262795322', '0.00000000000000260448783427139897456119386569682623768617148230930', '-100900959.69809609139671503315458646839423292725929534450987089464573');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 5 });
    T('-3100575428627.4279', '0.0006563910304', '-4723671234108667.52148720403964861979');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 5 });
    T('-60.4901', '-7153802399007784077376399639542532364448308688190006085969', '8e-57');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 5 });
    T('-1.22360', '-0.00000017357767807793899723685184287804837922756376495441002', '7049293.512559749372859153421040296683');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 5 });
    T('1565440', '0.00000000000000000318507005', '4.91493114884553324031287789102158051437518619095991311086e+23');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 0 });
    T('0.00000000000000025', '1.64792487', '1.5170594518668803147560968601681458936899228907201333759833359393380597502604e-16');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 5 });
    T('-1.294', '-0.000000000000012346068350', '104810694653249.672');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 0 });
    T('-29168.554', '-8', '3646.06925');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 1 });
    T('43520', '-485.75606652', '-89.592293333115077284037786596164402751883515478364755925148502250351267522446834227135819652');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 3 });
    T('1148978.24', '-15564548', '-0.1');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 2 });
    T('74159102.0', '-2754521', '-26.92268528720601512930923380144860031925695974000561259108207924354179910046066085537');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 0 });
    T('-0.0000000000026876', '-10255741', '2.6205809994616673724502208080332761913546764e-19');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 1 });
    T('0', '320295', '0');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 5 });
    T('0.0000000000000000000443996740', '7513.561355', '5.909271502847799663705547793453800844087204502504525032922952686795488e-24');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 6 });
    T('-0.0000000000989', '146556533.88', '0');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 5 });
    T('0.00001391471605', '744.27894259', '1.869556594141772197897753236770100087428835180475907168e-8');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 3 });
    T('-40310.2', '87709217', '-0.0004595890988286898057704');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 3 });
    T('1044345208', '-78177.473', '-13358.6462689');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 5 });
    T('-4682.4005', '-9097023696.17', '5.1471785238631063197511178523858062911980363528445549978499721443800782131606e-7');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 6 });
    T('394883813', '-1.18', '-334647299.15254237288135593220338983050847457627118644067796610169491525423728813559322033898305');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 4 });
    T('25.579', '2', '12.7895');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 3 });
    T('0.0000000000030', '-30142812', '-9.952621541e-20');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 1 });
    T('-1.89', '1.5', '-1.26');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 0 });
    T('1843613.37', '-36', '-51211.4825');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 5 });
    T('-2', '-6556.35592955', '0.00030504750222388725256420745657319634802955829712150804993051660367510469671127160930692062');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 4 });
    T('10', '-0.123889533771', '-80.717068630544761887592');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 5 });
    T('0', '3.8', '0');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 4 });
    T('0', '-141.14989', '0');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 6 });
    T('342.75', '7034856', '0.00004872167959088288374');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 3 });
    T('-88980', '79214827', '-0.001123274560708186612589585028065516068096696089483348868514223984860813998874226');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 5 });
    T('-10.16', '-417.5', '0.02433532934131736526946');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 6 });
    T('-559.8', '-3.38112', '165.56643952299829642248722316865417376490630323679727');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 5 });
    T('-1.9', '65.8', '-0.028875379939209726443768996960486322188449848024316109422492');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 0 });
    T('0.0000000001462574', '-0.00015154345556', '-9.65118549392539666857785356415690803e-7');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 6 });
    T('-115.231696', '-2', '57.615848');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 4 });
    T('0.000233315045345', '-0.000000000000133029473', '-1753859803.270814');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 3 });
    T('0', '-3532615.6', '0');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 4 });
    T('-4.2', '1.17', '-3.5897435897435897435897435897435897435897435897435897435897435897435897435897435897435897436');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 6 });
    T('0', '11.3930229', '0');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 0 });
    T('-0.0000000000000020730', '0.000000000000000852834', '-2.43071922554682388366317477961713533935091706006092627639141966666432154440371749');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 6 });
    T('-136440751.770', '-303', '450299.51079207920792079207920792079207920792079207920792079207920792079207920792079207920792');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 5 });
    T('-85.113', '1', '-85.113');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 6 });
    T('-10.47', '-0.00000690102', '1517167.03');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 0 });
    T('-1.4292444', '-1144.70690499', '0.00124857');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 0 });
    T('-0.0000000000000000000465276721', '714.1', '-6.51556814171684639e-23');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 3 });
    T('3.20', '8.38866', '0.3814673618909337128933584148123776622249560716491072471646246241950442621');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 1 });
    T('-303854.8', '-0.685651', '443162.48353754315');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 2 });
    T('0', '3.73', '0');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 3 });
    T('21.0', '-0.000000000000000002895581456', '-7252429371822859194.32963795027149807800122891794068735049946');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 4 });
    T('27606161012', '1508', '18306472.81962864721485411140583554376657824933687002652519893899204244031830239');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 0 });
    T('4.28', '10.7', '0.4');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 0 });
    T('0.0000000000000347360853426', '-4.659453482', '-7.45496987506999646015566767278652273494250114e-15');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 6 });
    T('-1169747921', '4.12', '-283919398.30097087378640776699029126213592233009708737864077669902912621359223300970873786');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 4 });
    T('-0.004024373', '-7', '0.00057491042857143');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 0 });
    T('1.8735138997', '118.931177', '0.01575292490126453553890246961904698883119604542381683484053975182639');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 6 });
    T('-2.2', '764.12', '-0.00287912893262838297649583835');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 0 });
    T('-0.00000000000000000009903285', '-2.0', '4.9516425e-20');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 6 });
    T('13.43', '1.49', '9.013422818791946308724832214765100671140939597315');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 3 });
    T('0.00000000002818631', '1.2282333', '2.2948661300747993072e-11');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 4 });
    T('3080315675', '145441.14', '21179.12218647351086494509050190338167041319945649490921207026');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 4 });
    T('-275.0', '-16890338.700', '0.00001628149706672252818707537226592146432208609292127457');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 0 });
    T('-2.95', '-6976.96721', '0.0004228198171508964279624298248636888749259293136336812452928240148630424765891941177692');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 4 });
    T('-2267', '-3.5', '647.7142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857143');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 0 });
    T('3', '2', '1.5');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 2 });
    T('1', '1.5', '0.66666666666666666666666666666666666666666666666666666666666666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 3 });
    T('-0.0000000000000121', '-0.000001452', '8.333333333333333333333333333333333333333e-9');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 4 });
    T('2951740.2', '-6528832211.10', '-0.0004521084482737351136335745064281668900369882');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 3 });
    T('1.2913929', '-582958', '-0.0000022152417498344649185704630522267470383801234394244525334586711221048514644279690818206458');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 2 });
    T('0.0000000000126439856', '1.3', '9.72614276923076923076923076923076923076923076923076923076923076923076923076923077e-12');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 5 });
    T('2.1612', '-63497969.006', '-3.40357342735763028004650382313363403892805131714420176332151331360017074e-8');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 5 });
    T('-0.00000000002762629214', '69.16', '-3.99454773568536726431e-13');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 0 });
    T('-211.50', '-3.98', '53.14070351758793969849246231155778894472361809045226130653266331658291457286432160805');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 4 });
    T('-17667309622.8', '-0.000000050947899018', '346772093910253341.548302901600133653621272866125786431541286');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 6 });
    T('-0.000000000000000181', '7', '0');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 1 });
    T('0.05964073855', '112.04372', '0.00053229880755476522914448038676330989367364810807781105447052275665249243777339774152446919');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 5 });
    T('-7.77', '30279', '-0.0002566134945011394');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 4 });
    T('2819.841', '3566.03200', '0.790750335386782844349125302296782530274546050063487932805987158836488287');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 2 });
    T('651.8', '-48389.208224', '-0.013469945550312');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 0 });
    T('-164.881', '-496055826492', '0.1');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 0 });
    T('0.0000000000000000015713402282', '-119.9', '-1e-9');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 4 });
    T('-322.159598', '4.16', '-77.44221105769230769230769230769230769230769230769230769230769230769230769230769230769230769230769');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 5 });
    T('-2.47', '0.0000000000093', '-265591397849.46236559139784946236559139784946236559139784946237');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 1 });
    T('-1', '-51334.1413', '0.00001948021286955860699280850734713663165921117687031418211333');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 1 });
    T('8.36631', '-0.0000000000146683885', '-570363267921.353460197757920033274275493862192155600460132345144');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 0 });
    T('-2.7140570863', '0.000000000000000481895', '-5632050729515765.8826092821050228785');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 3 });
    T('1.9', '-1620.0524', '-0.0011728015711096752179127045520256011472221515797884068441243011645796148322116000692323285345586');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 6 });
    T('-4.72', '-1', '4.72');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 6 });
    T('-730000.67163', '57682668.476', '-0.0126554594459119211293404');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 2 });
    T('-9854.20', '100.05', '-98.49275362318840579710144927536231884057971014492753623188405797101449275362318840579710144927536231');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 0 });
    T('109901.8', '-0.00000001677866616', '-6550091583680.45150974027127314868752356176565110226854886062051549871232434128124997511721158173397974086');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 0 });
    T('23253.75', '-0.000000000000000339', '-68595132743362831858.4070796460176991150442477876106194690265486725663716814159292035398230088495575221238938054');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 6 });
    T('-1', '2051.814989', '-0.00048737337691804921306187026787530695829223226324720059836');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 6 });
    T('-2485.45799', '-22032614981', '1.12808125233584591726316065650854664658109744508497295743671308155194236133508913333e-7');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 2 });
    T('5', '879097.79', '0.00000568764937971235259276445229147942687923262780584');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 0 });
    T('-1624053653', '-45901.775', '35381.064305247455027610588043708549397054907');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 2 });
    T('736', '-31820', '-0.023130106851037083595223130106851037083595223130106851037083595223130106851037');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 1 });
    T('-33307.60', '-26398.486', '1.2617238731039348241410511193710124133634027345356093527484');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 6 });
    T('-5', '85111326221', '-5.8746587816256136023628558422155102937812556824e-11');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 1 });
    T('-1.649825', '-3', '0.5499416');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 0 });
    T('0.000000000116045', '-786270', '-1.47589250511910666819285995904714665445712032762282676435e-16');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 3 });
    T('-32.1', '3.29', '-9.756838905775075987841945288753799392097264437689969604863221884498480243161094225');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 5 });
    T('5.004', '0.00000000000000028911148288', '17308202186064620.13937977834220293976031506424543437352660297');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 5 });
    T('0.0000000000000000000942', '-2143.2', '-4.3952967525195968645016797e-23');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 5 });
    T('-2.7', '79.3695', '-0.034018105191540831175703513314308393022509');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 2 });
    T('-0.000000000000002036873550', '-215.2', '9.4650257899628252788104089219330855018587360594795539033457249070631971e-18');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 4 });
    T('4330632.78', '-0.000000001568875959', '-2760341093352173.67557354481712725384429196929264692748089971847162456264013667635020468817063440003927040863018285');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 1 });
    T('427991.031', '1293.75', '330.81432347826');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 5 });
    T('-8.92547', '-7', '1.275067142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 2 });
    T('-5.4', '-1.0', '5.4');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 6 });
    T('1.383447013', '222.81', '0.00621');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 4 });
    T('-2209000304', '-16.558357', '133406974.133967518637265762539121484094104264088520376749939622632849382339081105691827');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 6 });
    T('5', '-3', '-1.6666666666666666666666666666666666666666666666666666666666666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 0 });
    T('-1511.465', '1829195341.20', '-8.26300486315714874072e-7');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 6 });
    T('0', '-716.3', '0');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 4 });
    T('3', '-52345222089.7', '-5.731182102655194878948627237808030249e-11');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 6 });
    T('0.00012', '0.0000000000000101949523', '11770530794.930742343934262448682570098930232366070021');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 3 });
    T('-8374228864', '77.675', '-107811121.51915030576118442227228838107499195365304151915030576119');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 6 });
    T('52.243', '7', '7.46328571');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 2 });
    T('0', '-241759.4', '0');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 0 });
    T('-396.127118241', '-0.0000690786761', '5734434.13518169610665135488895103477525968393595199');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 3 });
    T('-6844.1', '0.0000224093', '-305413377.481670556420771733164355870107500011156082519311178840927650573645763142980816000499792497');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 2 });
    T('1.63871', '7842081035.3', '2.0896366571877829368596501781675487298187215660485e-10');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 1 });
    T('-371', '-32445244', '0.000011434649713221450885066544729945627778296258151117618348008108676883428585095553604096797669328');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 4 });
    T('-9', '0.19', '-47.3684210526315789473684210526315789473684210526315789473684');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 0 });
    T('352830191.6', '-0.000381293058187', '-925351731494.04473608489781199248613');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 5 });
    T('0', '-1.020', '0');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 1 });
    T('219.352562291', '21384681', '0.00001025746244664580219831195985574907570517418520294971900679');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 5 });
    T('161914.41633', '-695267', '-0.23288091672695525603832772158034');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 2 });
    T('0', '-1.09', '0');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 3 });
    T('-0.00000000000000900280', '78.30556', '-1.14970124726775467795645673180806062814e-16');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 3 });
    T('-32.37', '1.14707749', '-28.21954078');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 5 });
    T('21.571', '1', '21.571');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 2 });
    T('-0.00000000000000776386', '-1.5', '5.17590666666666666666666666666666666666666666666666666666666666667e-15');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('111482', '-1.911', '-58336.996336996336996336996336996336996336996336996336996336996336996336996336996336996336');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 5 });
    T('-10.7659', '96.707', '-0.1113249299430237728396083013639136773966724229');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 6 });
    T('386.5281', '412647.720', '0.00093670237654530115906129325033');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 1 });
    T('-5.7240', '1.16', '-4.934482758620689655172413793103');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 4 });
    T('-285', '5', '-57');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 6 });
    T('512168', '-7', '-73166.8571');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 5 });
    T('-0.000000000000000000285654941', '-63506.19980', '0');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 6 });
    T('-70.1', '4272.202', '-0.0164084001646');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 1 });
    T('-11.1381428', '-34', '0.32759243529411764705882352');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 4 });
    T('-2.0946', '-7.7', '0.272025974025974');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 3 });
    T('233298875909', '-118661.20', '-1966092.336071099904602346849686333864818491638378846665970005359797473816209510776');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 6 });
    T('-0.0000000000000002412', '310.1', '-7.778136085133827797484682360528862e-19');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 3 });
    T('-0.00000001472', '-796413753.5', '1.84828550929840264e-17');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('-1041.2', '-0.000000645681', '1612561001.485253553999575642');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 4 });
    T('8.37456', '-2808724.72451', '-0.0000029816236268796314943861290758029707760497802718151357226');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 6 });
    T('0', '-105271966383', '0');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 0 });
    T('-29', '30.9036', '-0.93840199847266986');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 0 });
    T('0.00000000000000002126401186', '-67.1', '-3.16900325782414307004470938897168405365126677e-19');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 3 });
    T('-7', '-10.381', '0.6743088334457181389076196898179366149696561024949426837491');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 1 });
    T('2.5', '2.3', '1.08695');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 1 });
    T('-0.219855997', '101.7824524', '0');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 2 });
    T('-5.21850', '-798', '0.00653947368421052631578948');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 0 });
    T('-494.272', '1866', '-0.2648831725616291532690246516613076098606645230439442658092175777063236870311');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 2 });
    T('-6.5449', '-26.022998995', '0.251504448094453765320141189');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 6 });
    T('0.00000000000000232033499669', '0.000000000000354', '0.006554618634718');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 3 });
    T('0.0000000005015', '639650467', '7.8402193990737757094453899617023182756466274e-19');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('0.0000000000103187470', '-0.000000000000000012571', '-820837.403547848222098481');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 5 });
    T('6', '0.00000000000000012', '50000000000000000');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 4 });
    T('1.090', '15002564.0', '7.265424763393777223679898982600574141860018060912787974108958975279158949097e-8');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 5 });
    T('-264.50930', '589878.7702', '-0.00044841298477366358352796335303677284299051045929640408679349348789294671924099023965856909');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 3 });
    T('-21198985599', '-30720.1', '690068.8994827490795928398670577244214699821940683786836631391173856855934713754186');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 5 });
    T('-813123', '-0.0000000001663', '4889494888755261.57546603');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 6 });
    T('-44239.76530', '-0.00000005206822', '849650041810.5324130534902095750536507681653031350025024862');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 3 });
    T('-316.68', '-8624321.244', '0.000036719411422703725065462090757');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 6 });
    T('-0.000000000000000007135328753', '41264989.38', '0');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 6 });
    T('176180337.2', '5.6', '31460774.5');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 3 });
    T('1.6', '-0.00523482', '-305.64565734829468826053235832368639227327778223511028077374198157720800334');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 2 });
    T('-0.00000000000021866724', '-28126.0189548', '7.77455353178172209997205217413586893583984552e-18');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 4 });
    T('2.135', '0.048050825667', '44.432');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 4 });
    T('-1.362', '-11.2026409', '0.1215784753039794393480915736574221530210791635747246');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 0 });
    T('-3.2', '-1.4', '2.28571428571428571428571428571428571428571429');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 5 });
    T('3', '-8.154', '-0.3679175864606328182487122884473877851361295069904341427520235467255334805003679176');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 3 });
    T('4885365', '32646', '149.64666421613673956993199779');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 6 });
    T('0.08525779', '-0.0000000000000015', '-56838526666666.66666666666666666666666666666666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 1 });
    T('-0.0000102', '-17150', '5.94752186588921e-10');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 2 });
    T('0', '-1.0', '0');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 1 });
    T('-2', '-123843217', '1.61494512856525682791331236170972528919367461198944791623105e-8');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 2 });
    T('0.000021', '2', '0.0000105');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('116116.0', '-5', '-23223.2');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 5 });
    T('3141195.729', '-0.00000000000000867781', '-361980237986312214717.7686536119136049302761871946954358300078015075232115015193925656357998159');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 5 });
    T('1.93448', '411691', '0.000005');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 5 });
    T('-2376.356', '2951222.65', '-0.0008052106810714535550206623685271594130656323066644937819245864083');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 6 });
    T('-0.000000000000001025074', '-0.000027628974509', '3.7101413216262778086592935152937492617525944238077548e-11');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 3 });
    T('-0.000000478862541855', '653620457.66', '-7.326308964828859515351663358155728873732633102e-16');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 1 });
    T('0.00000000000000318051', '5.368931740', '5.92391588126244272e-16');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 4 });
    T('-11799683', '-54', '218512.648148148148148148148148148148148148148148148148148148148148148148148148148148148');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 1 });
    T('325.3661', '1084482292.48', '0');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 2 });
    T('0.0000000000000000037', '3.458751534', '1.069750158006001479954818864996851780218104559574298695489931656941044670021678e-18');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 4 });
    T('0.0000000000000000066858340', '-1', '-6.685834e-18');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 5 });
    T('-5', '-2357875.2242', '0.00000212055326282010644149165490858123');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 6 });
    T('-70.0', '-0.0000000000000000160541', '4360256881419699640.59025420297618676848904641182003351168860291140580910795373144554973495867099370254327555');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 3 });
    T('2238692.91', '-304048.2', '-7.36295399874098909317667396156267328666967935');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 2 });
    T('48.36165096', '-17.2', '-2.811723893023255813953488372093023255813953488372093');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 1 });
    T('0.0000000234101105561', '-0.00000056848429', '-0.041179872457161481102670400970974941101714525831487797138598148420249220959122722634956192');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('0.000031224', '-71558987.88', '-4.36339318442579403346362701517851596533788202595243302091264849231123585e-13');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 4 });
    T('520778', '-14.1', '-36934.6099290780141844');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 3 });
    T('-1', '-1', '1');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 1 });
    T('0', '349262', '0');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 5 });
    T('-12.1', '-9.25', '1.308108108108108108108108108108');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 5 });
    T('-0.0767', '-98934421979', '7.7526101094e-13');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 2 });
    T('0.000000000000024', '4', '6e-15');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 0 });
    T('0', '6.94', '0');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 5 });
    T('-1.2283864', '0.0000000000000084', '-146236476190476.19047619047619047619047619047619047619047619047619047619047619047619047619047619047619047619047619');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 3 });
    T('632.884', '1.4', '452.06');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 1 });
    T('-18.23', '208221530', '-8e-8');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 0 });
    T('-0.000062913', '400.8777994', '-1.569381e-7');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 2 });
    T('9768.95198', '5', '1953.790396');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 5 });
    T('-10', '-0.0000000000000000277023144493', '360980668900489159.96729444430868143982879657940927594970630669325877985206687832887720379010476659480245');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 1 });
    T('-5892110.9', '1.5', '-3928073.93333333333333333333333333333333333');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 3 });
    T('-5.03', '6044.396507', '-0.00083217571748887915899922281521495823338116425127501980405733829201949805176803236479006191047685');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 1 });
    T('-0.13389091', '-117.19', '0.0011425113917569758511818414540489802884205136957');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 5 });
    T('-19.20906', '-0.00001042226563602', '1843079.103032289899499099103753645');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 1 });
    T('-0.000000006355', '260160366.550', '-2.44272411062222190738222574202473193740201e-17');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 5 });
    T('-1.10', '-0.00000000000000017597992', '6250713149545698.1682910187');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 2 });
    T('-13228586', '-20693329673.3', '0.000639268123');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 0 });
    T('1.26', '2.9', '0.44');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 2 });
    T('-197.26', '-9.309', '21.190245998496079063272102266623697497045869589');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 1 });
    T('-47.49', '-0.000000045', '1055333333.333333333333333333');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 4 });
    T('-0.063686480', '18267', '-0.00000348642251053812886626156456998959872995018339081403624021459462418569');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 0 });
    T('-21.023531339', '541241.4', '-0.1');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 5 });
    T('2693.21', '-0.00000000000000000011874', '-2.2681573185110325080007e+22');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 3 });
    T('0.0000000000000006163225', '793', '7.7720365699873896595208e-19');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 5 });
    T('59804615', '0.000058386725465', '1024284450338.8009961589305922895534');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 2 });
    T('-1.88', '-6237933.024', '0.0001');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 1 });
    T('-46.3', '-7840795.2', '0.00000590501330783387889024317329');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 2 });
    T('698', '1.6957655', '411.61351613769710493579448337638665251769775950743189432737014640290771336013145685532582');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 0 });
    T('-119345', '-0.00004408673767', '2707049927.1986617829506548743461');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 5 });
    T('-24.8', '8989.322', '-0.002759');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 0 });
    T('9.726', '2.529', '3.84578884934756820877817319098457888493475682087781731909845788849347568208778173190985');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 3 });
    T('0', '-592.8', '0');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 2 });
    T('0.00000000000000005825980', '2.8891214', '2.016523085530431500732367978721835641797537479733458067909503560494204224163096781e-17');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 6 });
    T('-2424545.2084', '871.2930285', '-2782.69781702953221781689029088794092193290170460717740036');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 2 });
    T('0.03141', '7784326.563', '4.035031128999154759638261594344677032275733419792809892166390604700020214195630990771e-9');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 3 });
    T('0', '7', '0');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 3 });
    T('-4', '-1', '4');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 4 });
    T('1599.3', '63', '25.385714285714285714285714285714285714285714285714285714286');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 4 });
    T('0', '703.9', '0');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 0 });
    T('2', '0.0000000000000000001711184', '11687813817801007957.063647158926217168930985796968648608215130576255972472860896315066059523698211296973323734');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 3 });
    T('-4.2', '-30.1', '0.13953488372093023255813953488372093023255813953488372093023255813953488372093023255813953488372');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 6 });
    T('-0.00000000011', '1', '-1.1e-10');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('69561.2', '10940288', '0.00635826040411');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 1 });
    T('9940.98', '43061', '0.2308580850421495088363019901999489');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 3 });
    T('30459876832', '228', '133595951.017543859649122807017');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 4 });
    T('117805414517', '-0.000000000000000400355774890', '-2.9425181777224944477183434889855598655680977380992961852266e+26');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 2 });
    T('36555877196', '0.00000000000012', '3.046323099666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666667e+23');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 2 });
    T('-0.000000000000178916341', '47.6', '-3.75874665966386554e-15');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 1 });
    T('3.293', '-0.000000234257318', '-14057191.587927255275756209246790744868000238950912944371710086768772790269886040443782422');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 0 });
    T('0.3088049717', '1229.0', '1');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 6 });
    T('-1', '76968695', '-1.29922951142669107225996231324956204597206695527317957e-8');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 1 });
    T('1079641.41691', '22.7138', '47532.3995504935325661');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 5 });
    T('0', '1.1', '0');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 5 });
    T('678740.294', '4.6', '147552.237826086956521739130434782608695652');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 1 });
    T('-0.00000000427', '11048.19', '0');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 0 });
    T('-0.000029833', '-46.65726057', '6.3940745e-7');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 1 });
    T('-0.0000000000000016492401761', '53.1', '-3.10591370263653483992467043314500941619585687382297551789077e-17');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 5 });
    T('-115.81587', '-1.2', '96.513225');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 5 });
    T('61515421', '-324783.60', '-189.40433260792724755806635556721460073722934286090800151239163553824762087740883');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 2 });
    T('2438034', '-9.7', '-251343.71134020618556701030927835051546391752577319587628865979381443298969072164948453608247422680412');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 5 });
    T('-215251219372', '-0.000000000000000000347192993', '6.199757014451037610658231227610057211033633965072561e+29');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 1 });
    T('-39.9', '-0.000000000000045976', '867844092570036.54080389768574908647990255785627283800243605359317904993909');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 4 });
    T('-0.00000000000000084628779457', '917.5', '-9.22384517242506811989100817438692e-19');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 5 });
    T('-6294.4404575', '-0.0000000342498', '183780356600.622485386775981173612692628862066347832688074090943596750929932438');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 1 });
    T('-146382323610', '6', '-24397053935');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 2 });
    T('-147.42', '-860.2860220', '0.171361612568430177283526757104510992509');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 3 });
    T('29.2', '2566652156', '1.1376687694801133777007218269899444839302953835868361431364913010051058901648845e-8');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 4 });
    T('3493', '-5', '-698.6');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 2 });
    T('36.33598029', '-0.2664688060', '-136.36110295776984867789740462153757689746243693530116241823817831795290890446666391412434219411033');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 6 });
    T('-206.53', '0.00000000000003011551082', '-6857927837732091.3064293159480932224811586310658502056250361155255343598');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 5 });
    T('-2185167.14998', '2', '-1092583.57');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 1 });
    T('0.00000015544', '22.360', '6.9516994633273703041144901610017889087656529516994633273703041144901610017889087656e-9');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 2 });
    T('-1', '-243969', '0.000004098881415261775061585693264308171');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 5 });
    T('0.0000000000000015909805', '1', '1.5909805e-15');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 4 });
    T('3740375.9865', '-9436', '-396.394233414582450190758796100042390843577787198');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 0 });
    T('179.506', '312', '0.5753397435897435897435897435897435898');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 2 });
    T('74542005.0369', '49234198.2063', '1.51402902357738847367808769587778211275856571');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 5 });
    T('52693.3621208', '34', '1549.80476825882352941176470588235294117647058824');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 0 });
    T('0', '9.6', '0');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 4 });
    T('11.2', '1.31715041933', '8.5032049761614526410948365863433733808854270153846483990095181591608779');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 2 });
    T('-1.006', '13234.8943280', '-0.000076011184907739446214');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 4 });
    T('-38581.7829', '-0.0000000000000000056', '6.8896040892857142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857e+21');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 0 });
    T('0.00000017788', '-1773.0821', '-1.003224836571301464269477425777407601e-10');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 4 });
    T('0.0000000000000217830374553', '-0.00000000000000002371157929', '-918.666664454807809640418092961196428177686345918631554802691508');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 5 });
    T('2.3', '-0.000000197', '-11675126.90355329949238578680203045685279187817258883248730964467005076142132');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 3 });
    T('27.6', '5111.79861782', '0.0053992737319081');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 0 });
    T('-41484045.3618', '2', '-20742022.6809');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 5 });
    T('-1.3', '278.24', '-0.0046722254169062679700977573317998849913743530764807');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 1 });
    T('-3', '14.13', '0');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 3 });
    T('3942.3337', '39.4', '100.05923096446700507614213197969543147208121827411167512');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 6 });
    T('806322064.23', '11.937959', '67542706.775086093024779193830369161093617426563451926748952647600816856549767');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 0 });
    T('122', '-3582', '-0.0340591848129536571747628');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 2 });
    T('-1.18', '0.00000000000343', '-344023323615.160349854227405247813411078717201166180758');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 0 });
    T('-6.9', '-1.6822', '4.10177148971584829390084413268339079776483176792295803114968493639282');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 0 });
    T('-20047', '22.44', '-893.360071301247771836007130124777183600713012477718360071301247771836007130124778');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 1 });
    T('-0.000000000000003783719', '11.7', '-3.2339478632478632478632478632478632478632478632478632478632478632478e-16');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 3 });
    T('12.30', '-40.5769', '-0.30312813448045562869514428159864356320960940830866823241795208603910106489160088621852');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 0 });
    T('-6.73', '-0.000000000000034239868273', '196554494495732.9567586213476318416909932952533237101218564025052083178614511371312482735964175243951879674335686');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('-0.0000000183', '-13836.03071', '1.322633e-12');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 0 });
    T('0.000014732663289', '-11907.468', '-1');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 0 });
    T('1', '-3.0', '-0.333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333334');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 0 });
    T('-2', '-2152240.45', '9.2926420001073764783112407352068863866953155721982643714367509448119516572e-7');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 1 });
    T('-0.0000488540655', '7.117', '-0.000006864418364479415');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 3 });
    T('19.7779357', '15.5318', '1.2733833618769234731325409804401292831481219176141850912321817175085952690608944');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 4 });
    T('0', '-7790934', '0');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 2 });
    T('-5433809', '-24.9847486', '217485.03805237407912121237033379635446882183157128104943189222244165386559062675539589');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 5 });
    T('6.4506726', '-0.0000006634', '-9723654.808561953572505275851673198673500150738619234247814290021103406692794694000602954476937');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 2 });
    T('0', '2', '0');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 0 });
    T('2732.745', '2.9', '942.325862068965517241379310344827586206896551724138');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 2 });
    T('102.610852', '0.0000021', '48862310.476190476190476190476190476190476190476190476190476190476190476190476191');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 1 });
    T('-45983380565.6', '-21990.85', '2091023.337688174854541775329284679764538433030101155707942166855760464011168281353381');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 3 });
    T('0.000000000000000067586178898', '-80', '-8.44827236225e-19');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 4 });
    T('-166379189.9', '0.00000000002611', '-6372240134048257372.654155496');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 2 });
    T('-20635674995', '0.0000000006175', '-33418097157894736842.105263157894736842105263157894736');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 4 });
    T('0.000000000000000002728336', '5540100.5', '4.924704885768768996158102186052401035e-25');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 3 });
    T('48.99', '-0.000000000000000055715', '-879296419276675940.052050614735708516557480032307278111819079242573813156241586646325047114780579736157228753477519519');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 1 });
    T('285265.038', '359018944.70', '0.000794568203743037741707227518347724673');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 3 });
    T('-3', '26715362', '-1.122949410155849656837889750473903366909271152679870106195828453e-7');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 1 });
    T('35', '-5.48580575', '-6.3801');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 5 });
    T('-194676582', '-0.000000000024805310', '7848181780433302385.65855455948746457915664025162354350741837130840130601068884041');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 3 });
    T('-256.3169164', '7938.868', '-0.032286330544859');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 4 });
    T('3094.61', '468.530210', '6.604931622232000792435561412358020627954812');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 0 });
    T('-16.54', '-183.3', '0.091');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 3 });
    T('-29526831086', '-0.0032601', '9057032326002.269869022422625072850526057482899297567559277322781509769');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 5 });
    T('32.4', '0.000001833940816', '17666873.2803861648717457848432552689312085194356675466456274126569196767362');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 0 });
    T('-0.0000000000000616896835', '-70.8235095584', '8.710339812958805083264135380603e-16');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 1 });
    T('1', '-52.2', '-0.0191570881226053639846743295019157088122605363984674329501915708812260536398467432950191570881');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 5 });
    T('-1', '717', '-0.0013947');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 1 });
    T('3068126.8849', '4022', '762.83612255096966683242168075584286424664346096469418199900546991546494281452013923421183490800596');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 5 });
    T('0.000855562', '0.00000000000606', '141181848.184818481848184818481848184818481848184818481848184818481848184818481848184818481848');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 1 });
    T('-1.3', '0.857190837559', '-1.51658177273800091850428574583107013319652621945040908472429380581341');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 4 });
    T('16070', '-2228', '-7.2127468581687612208258528');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 4 });
    T('2.8', '-0.0056', '-500');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 1 });
    T('7', '-3534', '-0.001980758');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 5 });
    T('2317042.797', '9', '257449.19966666666666667');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 2 });
    T('9.192', '-2575227269', '-3.5693937038688603603785464575243281178535858382136446691998740247884506227632680445960282e-9');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 1 });
    T('0.003172163', '-4799.9', '-6.608810600220837934123627575574491135231983999666659722077543e-7');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 4 });
    T('0', '174602409.27', '0');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 4 });
    T('-160.15373', '-1570.58626986', '0.10197066730646759914875956726708577391128728531899124518938954835414');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 5 });
    T('-4.0', '14.3', '-0.28');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 3 });
    T('-1621865.6', '-0.000000000000000000021', '7.7231695238095238095238095238095238095238095238095238095238e+25');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('-1.1', '-32.701912', '0.0336371769332631070623638153022979206842706934077738329183932731517349811228163050527443166014269');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 4 });
    T('1', '2', '0.5');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 4 });
    T('-3.04', '3059.4705628', '-0.000993635969884220518312221493880228681506044526796517148042029855480066');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 1 });
    T('-0.00000047745', '0.820', '-5.8225609e-7');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 4 });
    T('7871755256', '-15.0', '-524783683.7333333333333333333333333333333333333333333333333333333333333333333333333333');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 6 });
    T('-782997903.71', '2', '-391498951.855');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 2 });
    T('-11', '0.0000000000000022091766', '-4979230723338279.06741362370034156617447423623806263383380033990944861538004702747620991458989743056304326236299');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 0 });
    T('0.00000000000000001791715', '2098052450.48', '8.53989612886029129450365274644980714458e-27');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 2 });
    T('-14.358261', '-46.3', '0.310113628509719222462203023758099352052');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 3 });
    T('0.007315', '-118203872186', '-6.188460551012629583e-14');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 4 });
    T('-105.225331', '57', '-1.8460584385964912280701754385964912280701754');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 6 });
    T('3584', '160.004614', '22.39935405862733433424613617704799437846211109887118630216501131648616083033705515517196272852481617');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 4 });
    T('-1626627.5', '-65167101663', '0.000024961');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 2 });
    T('-56643985.906', '-22360018221', '0.002533271008375176940782690608166119347278147282866');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 4 });
    T('8.80', '8020.1258054', '0.001097239646050802084840822414763065058191412494523012660172454107274570159574968404896488109146');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('-23.0', '-1953.512250', '0.011773665611771822777154328057067469118762884645335600019912851839040169827447972236');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 5 });
    T('-164004', '7.1', '-23099.15492957746478873239437');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 2 });
    T('0.000000000000306300993', '1', '3.06300993e-13');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 6 });
    T('0.000012616277', '4.9', '0.00000257475040816326530612244897959183673469387755102041');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 0 });
    T('-1424554.476', '-1', '1424554.476');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 0 });
    T('0', '9', '0');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 3 });
    T('-352', '-1.840340', '191.2690046404468739472054076964039253616179618983448710564352239260136713868089592140582718');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 4 });
    T('-1.45800767', '-5.2640370', '0.2769751941333239109071611768686276331264388909121');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 1 });
    T('0.0000000000000317829012497', '0.0000000000000000000411245727', '772844.53461810680406169910186082006391278565187377618637238752391948865161096251341719108');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 6 });
    T('-4.3', '8.43', '-0.51008303677342823250296559905100830367734282325029655990510083037');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 5 });
    T('-3.89', '-2489.03', '0.001562857820114663141866510246963676612977746350988135940506944472344648316814180625');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 3 });
    T('8.3', '-955494.70778', '-0.00000868659965609255046166133355661190473328568036540381307940099954742');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 4 });
    T('-7.20242138', '-1368431.52', '0.0000052632676715894413189196343562738163178235');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('355695.465', '-1', '-355695.465');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 6 });
    T('-309', '0.0000000000007297626', '-423425371483822.2731611622738682415349868573697802545649777064486450799205111360872700245257841');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 4 });
    T('-40640.908302', '0.00000000000000290351316', '-13997149681250282330.389024308744651944336288112432733041237533085608608021600977');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 3 });
    T('-0.000000158322', '3.09268248', '-5.11924521912123355126970551467669581133333804122044886e-8');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 3 });
    T('7978.2', '0.0076056771525', '1048979.57');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 4 });
    T('-7742.6895', '475.0762115', '-16');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 2 });
    T('21578.902630', '32.5630', '662.681651874827257930780333507354973436108466664619353253692841569');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 0 });
    T('3.13693', '-24541106.36', '-1.278235e-7');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 3 });
    T('63409', '-3.1', '-20454.5161290322580645162');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 3 });
    T('0.00002566', '0.0000000001944451620', '131965.227296321');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 5 });
    T('-0.000000245', '-0.253', '9.68379446640316205533596837944664031620553359683794466403162055335968379446640316205533597e-7');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 3 });
    T('-0.0000000000000000000171175545', '133490374.369', '-1.2823062772063923029449392375e-28');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 6 });
    T('-1954781', '0.00049611053', '-3940212678.009475025656077084273941937898395343473157080540096578881323079354917139130265991330601267423209098');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 6 });
    T('-6.2', '1', '-6.2');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 3 });
    T('-12286.3140300', '7', '-1755.187718571428571428571428571428571428571428571428571428571428572');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 1 });
    T('19.849636679', '519.354', '0.03821985905374754021341897819213869537925961868012954555081890194356835607312160876781540144102096');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 5 });
    T('7.6', '-42', '-0.180952380952381');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 4 });
    T('433249', '-30893585.3', '-0.0140239145373651403289860306372404111995379183134176');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 3 });
    T('-8969', '57.600315', '-155.8');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 0 });
    T('0.0000108950356', '-81.23', '-1.3412576141819524806106118429151791211e-7');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 4 });
    T('17257554596.7', '608', '28384135.84983552631578947368421052631578947368421052631578947368421052631578947368421052631578947368');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 0 });
    T('2.9', '-22840.8', '-0.000126965780533081153024412454905257258940142201674197050892');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 5 });
    T('-13734.55427', '-827538', '0.01659688651155596480162');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 2 });
    T('-17.55380', '-357081.491', '0.00004915908676991605818068010699552052671360667080893307908810092876');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 5 });
    T('9609', '-0.00006559', '-146500991.004726330233267266351577984448848909894801036743');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 6 });
    T('-1986505519.2', '-1', '1986505519.2');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 4 });
    T('2', '-452173479694', '-4.4230811620209633602979431439702536337489266551571568427190599366243954435520300874941211e-12');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 0 });
    T('-3', '-1', '3');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 2 });
    T('-0.000000000000000045', '-52784.4850', '8.52523236704876442386432301082411e-22');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 2 });
    T('-18291.6313', '-45', '406.480695555555555555555555555555555555555555555555555555555555555555555555556');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 6 });
    T('-4.207', '-213213497', '1.97313962727228286115e-8');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 4 });
    T('1.641', '-1.6', '-1.025625');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 4 });
    T('5790881110', '24095.79849', '240327.4210814501213070196122809624309735833950361028272360855056270849482855216224876389228137174715');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 0 });
    T('0', '-0.000000000743462591', '0');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 5 });
    T('96.5', '-2791122983', '-3.457389752718037075e-8');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 1 });
    T('0.000000020126701423', '0.0000000000045', '4472.60031622222222222222222222222222222222222222222222222');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 2 });
    T('2.3', '10.69', '0.215154349859681945743685687558465855940131');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 3 });
    T('1.66', '-0.0000000000000000391535668164', '-42397159057924873.1803926502001743692152496396540277885915094781888235162703821490195813464452711347436564423093');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 4 });
    T('5.5', '8', '0.6875');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 2 });
    T('-21.2', '-8', '2.65');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 0 });
    T('0', '3', '0');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 2 });
    T('-16289', '60495201941.0', '-2.6e-7');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 0 });
    T('-13.34453', '1.6800901', '-7.94274664198068901185716170817267478690577368439942595935777491934');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 1 });
    T('2.6', '-837.2419', '-0.003105434642');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 5 });
    T('53.3', '1', '53.3');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 5 });
    T('3315.66598', '-1', '-3315.66598');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 0 });
    T('-0.00000000232', '-1.4301592', '1.7e-9');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 5 });
    T('30.1580564592', '0.0000000000000042', '7180489633142857.14285714285714285714285714285714285714285714285714285714285714285714285714285714285714286');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 4 });
    T('-3640656264', '0.000614500900', '-5924574339923.668134579');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 0 });
    T('8', '206.213627', '0.0387947203897');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 1 });
    T('86.96253', '3.52672', '24.65818947917611831957172670356591960802105072135014971');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 4 });
    T('193776850', '-211004.2379', '-918.35525166956848121200697457650446555320109994814469079438332930279027348388626842835558043547712');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 1 });
    T('9.1', '571.3', '0.015928583931384561526343427271136005601260283563801855417468930509364607036583231227026');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 0 });
    T('-0.0000001420', '2864706.57', '-4.95687766024846307382888434e-14');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 6 });
    T('183.9357', '-14954.475716', '0');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 0 });
    T('-538.13', '-221752.405754', '0.00242671549907319613376373579869');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 2 });
    T('-0.020915', '-84.2', '0.000248396674584323040380047505938242280285035629453681710213776723');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 5 });
    T('-76.09', '0.0212', '-3589.150943396226415094339622641509434');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 6 });
    T('5.5438330', '-1029137.3', '-0.000005386874035174898431919628216759804546973469915');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 5 });
    T('6', '-22', '-0.2727272727272727272727272727272727272727272727272727272727272727272727272727272727272727');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 0 });
    T('-24.077', '1951789.43472', '-0.000012335859376887159257283511523895190685203526266580589086262045958945040026054148206461197');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 2 });
    T('-173648245', '-0.00000077', '225517201298701.2987012987012987012987013');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 1 });
    T('0.003909285793', '-5380.4971', '-7.26565913956165871737018499647551152847940388258921280712148325e-7');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 4 });
    T('-99509.037', '1.016538634', '-97890.06897695538');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 1 });
    T('197708682', '-118627.91', '-1666.6287216895248344171283132274689826365481782491');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 4 });
    T('16225844', '0.0000001233', '131596463909164.6390916463909164639091646390916463909164639091646390916463909164639');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 2 });
    T('-2123.68659', '1893.270', '-1.12170297421920803688855789190131360027888256825492402034575100223422966613319811754266427926286');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 3 });
    T('0', '-0.0000000000000000000121761598463', '0');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 2 });
    T('-0.10981880570', '-0.00000000000000101', '108731490792079.2079207920792079208');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 1 });
    T('1', '-4', '-0.25');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 5 });
    T('-18179003', '-147331727447', '0.00012338824308253344062211089157949279630698091288089992960061977328564784516043454247492639188');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 6 });
    T('-4886160', '2', '-2443080');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 3 });
    T('-2955.153579', '-1.4', '2110.823985');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 4 });
    T('2.5', '-0.000000000000054366301', '-45984368147466.9391246610653169138728051408169189218887634087888377765483806');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 4 });
    T('-799.2', '-18.646', '42.861739783331545639815510028960634988737530837713182452000429046444277593');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 0 });
    T('0', '-7730750.2', '0');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 5 });
    T('-17.8487823412', '7', '-2.54982604874285714285714285714285714285714285714285714285714285714');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 3 });
    T('1843.40', '-5.5', '-335.16363636363636363636363636364');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 0 });
    T('93758166.45', '-59380379', '-1.57894186647074111803833384088034');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 0 });
    T('0.000000000000000000028', '0.00000370007', '7.567424400078917425886537281727102460223725497085190280183888413e-15');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 3 });
    T('1', '-0.00000000000000151725384', '-659085496201479.37803208987100009580466772784704239074458364857392616650091984608191863267915670590756258');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 3 });
    T('1.18', '147.003', '0.00802704706706665850356795439548852744501812888172350224145085474446099739461099');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 2 });
    T('-1', '0.0001050274026', '-9521.324675699444556196');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 3 });
    T('151068', '-0.0000000000007817', '-193255724702571318.9203019061020851989254189586798004349494691057951');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 3 });
    T('1165746.4', '54210098.36', '0.02150422956731193062531827510965615595315440781649967107715094726863727461423480804029295622181933');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 3 });
    T('-344.953', '-15.8', '21.8324683544303797468354430379746835443037974683544303797468354430379746835443037');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 1 });
    T('-247522439806', '2', '-123761219903');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 3 });
    T('16.4131', '0.0000000006580318', '24942715534.41642182034363688806528803');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 3 });
    T('24.14', '6.521', '3.701886');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 5 });
    T('25194.6', '-436989173', '-0.000057654975355647999086695907680989615731280372019651846156838306838325259834297999872870992');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 4 });
    T('346.01', '-0.0000000000000000011604272172', '-298174667804577239969.27293028679920556');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 5 });
    T('-7253986.6', '0.000000000000000001040', '-6.97498711538461538461538461538461538461538461538461538461538461538461538461538461538461538461538462e+24');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 4 });
    T('0.0000000000013848905844', '-0.0000000038192393595', '-0.000362609005103389095401366660533338065060857833359370520490154684');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 4 });
    T('-315.3003', '-1.30', '242.5386923076923076923076923076923076923076923076923');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 2 });
    T('-0.00000000000097624807', '23974440745.1', '-4.072036884528911513157680911262659441396e-23');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 1 });
    T('-0.00000972384040183', '-6489.7', '1.4983497545079125383299690278e-9');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 4 });
    T('-340.6133115', '-0.000000000001381520', '246549678252938.79205512768545');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 5 });
    T('-2398.15210', '-14', '171.296578571428571429');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 2 });
    T('-4506.7756', '4067', '-1.10813267764937300221293336611753134988935333169412343250553233341529382837472338332923530858126383');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 5 });
    T('-0.0000000000002056', '8555298162', '-2.403189182969822016590051370789384301063474729660743e-23');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 6 });
    T('-1890.634', '0.00000000000000129874859126', '-1455735169010480840.6735549493465249989787');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 1 });
    T('-215', '4.3', '-50');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 4 });
    T('-9045.91', '-93.909595', '96.325726887');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 2 });
    T('0', '0.029309783', '0');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 5 });
    T('-0.000000000000000072', '-11.4', '6.315789473684210526315789473684210526315789473684210526315789473684210526e-18');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 4 });
    T('-5', '7930.738', '-0.0006304583507865220109402176695283591514434091757917106831671907456784');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 3 });
    T('2.52', '1.4', '1.8');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 6 });
    T('-2362.497', '7646.45', '-0.3089665138724506143373722446363998979918785841795866055489802457349488978545599591967514336718346');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 0 });
    T('1.6', '131684.99', '0.000012150207855883954579789237938203890967376008457759688480820783');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 3 });
    T('-3', '-0.00000000031029503961', '9668217718.7576214892621950412493092576898122');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 3 });
    T('-0.0000000000000004155575', '-30.947327569', '1.3427896126845691837127043142521241072142153e-17');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 1 });
    T('-274.3080', '1', '-274.308');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 4 });
    T('2.7', '-8.06', '-0.334987593052109181141439205955334987593052109181141439205955334987593052109181141439205955334987593');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 4 });
    T('1355257.02789', '-0.00000000000000037743272', '-3.5907247996146174078389388180229843347974706591415815777709998221669811774665429112770085222076135847e+21');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 2 });
    T('-1.8560488417', '-79.0', '1');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 3 });
    T('0', '-55610.94717', '0');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 6 });
    T('-1', '0.00000000000000102635', '-974326496809080.7229502606323378964290933891947191503872947824816095873727286013543138305646');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 1 });
    T('-1048642006.2', '-0.0000000000000000000117799', '8.901960171138974015059550590412482279136495216427983259620200511e+28');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 6 });
    T('-10.606', '-308371.8482', '0.000034393541634583');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 3 });
    T('-1563.76', '-1.0', '1563.76');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 2 });
    T('3620.41', '-0.00839', '-431514.8986889153754469606674612634088200238379');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 3 });
    T('-34.639108', '-421919490.29', '8.20988572397812942949457600417220109644629519729125192293329929449180744079249773972322457888e-8');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 1 });
    T('-8', '67714.5152', '-0.0001');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 4 });
    T('-78539595.81', '-27567.48437', '2848.9939363299256311503623788941319348973299154898550505644124538593145487');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 1 });
    T('-12631.2256', '-10622.81721', '1.189065513441137334603538753727646980757941517850894094411326126922972818431844220729088493842209');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 3 });
    T('1.4621430288', '583933', '0.00000250395683888391305166859896597726108988531218478832331791489');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 5 });
    T('-17.4045', '663.99681', '-0.02621172231234062705813300518717853478844273363301248390033681');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 4 });
    T('889993.2', '-0.0000000090576728', '-98258484232285.36142307988868840570173830965');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 6 });
    T('-1429240.257', '-490.4', '2914.437718189233278955954323001631321370309951060358890701468189233278955954');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 5 });
    T('49.299562', '-7459284.2', '-0.000006609154535230069394594189077820630564');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 2 });
    T('-9308.8', '-0.000000090', '103431111111.2');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('-3180', '112.741', '-28.20624262690592');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 1 });
    T('-15.5696', '-7.6', '2.048631578947368421052');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 1 });
    T('-0.00007028933030', '0.000801688', '-0.0876766651116144934188861502230294079492');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 5 });
    T('-172.12151767', '-0.000000000008024', '21450837197158.52442671984047856430707876370887337986041874376869391824526420737786640079760718');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 2 });
    T('-167.292', '-31.31291781', '5.34258739524344569535980907682777199484496076095');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 6 });
    T('-29.5080', '1.2916', '-22.85');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 2 });
    T('-66.6420', '-18434630213', '3.615044035600151476713540519121667721407198047385101621620469442285526e-9');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 0 });
    T('-161.612097', '-12126', '0.013327733547748639287481444829292429490351311232063334982681840672934191');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 4 });
    T('2', '42059.8', '0.000047551343563212378565756375446388237699656203786037974502969581405522613');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 3 });
    T('-538162', '422869947.0', '-0.00127264186972360085924952240694465809366206863596291462159641247808986529847');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 0 });
    T('36', '3.274', '10.995723885155772755039706780696395846059865608');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 5 });
    T('-4.7855', '40.6', '-0.11786945812807881773399014778325123152709359605911330049261083743842364532019704433');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 2 });
    T('353.14338096', '19.9', '17.74589854070351758793969849246231155778894472361809045226130653266331658291458');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 5 });
    T('27145.87391', '-0.00000000000000013462451', '-201641394349364762776.1096400647994930492226118408898944181858');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 2 });
    T('1', '-571.2813795', '-0.001750450891424512112949062082987075548468843451950808769533858052168493617075786381376359');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 3 });
    T('89', '2.2', '40.4545454545454545454545454545454545454545454545454545454545454545454');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 0 });
    T('-0.0000000000000000005676736475', '-99940906931', '5.68009301628537769948086484010175807156744441931224083180018186e-30');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 4 });
    T('-2', '0.000000000000278785654264', '-7173970286527.2681655161538703269695');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 4 });
    T('-404537.8', '-65334.7', '6.19177558020469979964705');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 4 });
    T('16203134.062', '10', '1620313.4062');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 2 });
    T('11129875.4', '2037.690514', '5462.0048155163566708344601932028231447123476180642415259337071242802085302341452623555767311189');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 2 });
    T('-0.00000000000000010', '-41381717', '2.416526119493785141877994090965341046626943971416169126090152325e-24');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 1 });
    T('0.000011380', '-939.665917947', '-1.2110687194937580380915434840947927246809264549787460761281687158465110383410384423797682e-8');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 3 });
    T('-102081', '15.22005110', '-6707.0077051186773');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 0 });
    T('49804.0200', '-7', '-7114.86');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 2 });
    T('14.12', '0.224636', '62.8572446090564290674691500917039121066970565715201481507861607222350825335208960273509143681333357076');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 6 });
    T('71855082', '-4598.44013', '-15625.96879999');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 1 });
    T('8.656024', '4', '2.164006');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 4 });
    T('-6', '-1812116344', '3.31104568416165667561574622606019605549123616314560429791035536292254753815078442888e-9');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 0 });
    T('1515436', '127663', '11.87059680565238166109209402881022692557749700383039721767466');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 6 });
    T('-5.5', '-188266070.4', '0');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 5 });
    T('-72175.13', '-8', '9021.89125');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 2 });
    T('0.00000000718317730486', '0.0000000440347595048', '0.163125162613344106476974134238442341342990115832326674658114845878539402');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 4 });
    T('3.1', '2.32', '1.33620689655172413793103448275862068965517241379');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 0 });
    T('2575460.6269', '0.0000000000000000066369929', '3.88046313398949093346174892e+23');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 2 });
    T('-102052425223.2', '-5.0', '20410485044.64');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 3 });
    T('-6.27', '4', '-1.5675');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 4 });
    T('-1.313021', '2081.6', '-0.000630774884704073789393');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 5 });
    T('-3.366795', '1777.602', '-0.0018940094577');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 4 });
    T('-57628.4', '-446564.474', '0.1290483308799884515667943617028523410933042559941747627689702875916636');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 1 });
    T('-615.29440145', '-84.0341', '7.321960983100907845743573144711492120460622532995533955858395579');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 0 });
    T('-5582198049', '-471953164.3', '11.8278644392171945863569666080105144026470509671291974003192418049012750310317179920219469116504');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 5 });
    T('1023670813', '-46.346047', '-22087553.9');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 2 });
    T('-1.489', '-2651742.7', '5.61517525814250379571140141160754397476044715801423720334e-7');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 1 });
    T('-4.9', '-0.00000000000473', '1035940803382.663');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 2 });
    T('16249004.8', '4798211827.3', '0.0033864709155917927600328225718');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 2 });
    T('808.0', '8607051.1', '0.0000938765194504305894036112');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 3 });
    T('-0.0000000000002115738944', '-43.9', '4.81945089749430523917995444191343963553530751708e-15');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 4 });
    T('231.525', '-254.160', '-0.910941926346');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 4 });
    T('0.004330', '33883.93892', '1.27789157282544174767e-7');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 1 });
    T('-0.064056046', '0.00000000006905', '-927676263.577118030412744388124547429398986241853729181752');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 1 });
    T('3.74', '2.304', '1.623263888888888888888888888888');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 1 });
    T('-0.00000000000000008849245494', '4748.9', '0');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 2 });
    T('-0.00000000000001435592', '-493380', '2.90970854108395151809963922331671328388e-20');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 4 });
    T('35.32695347', '-0.00000000000703246216', '-5023411810295.4712521339752221290302683974911000445397348572437963889449495');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 3 });
    T('-103.47554767', '364.6', '-0.28380567106418');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 4 });
    T('-54.0643414821', '36523221', '-0.0000014802730975479955615086632145614977386578');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 1 });
    T('-151.46', '-12485.2', '0.0121311632973440553615480729183353090058629417230000320379329125684810816006151283');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 5 });
    T('1703565.3599', '-2025802.6', '-0.8409');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 6 });
    T('-2534.536', '-2.4', '1056.05666666666666666666666666666666666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 1 });
    T('0.00096', '3.1', '0.00030967741935483870967741935483870967741935483870967741935');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 6 });
    T('-2.15', '71252.588329', '-0.0000301743424403425365704233152672395461211624948435212');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 6 });
    T('0.00008312', '0.0539653', '0.00154024901186503178894585965425931107582094419932808675204251620949017238855339');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 1 });
    T('-430', '0.000000000000118546277487', '-3627275432981474.940271820633284192902916707002');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 6 });
    T('-808820928', '-0.0017', '475777016470.588235294117647058823529411764705882352941176470588235294117647058823529411764705882352941');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 5 });
    T('916.17962481', '-282479.3', '-0.0032433513705606039097378108767615892562747075626426431954483036456122626');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 3 });
    T('0.0000012273818', '208020665.891', '5.900287813919081346067702e-15');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('-511248315191', '-180948.231', '2825384.433799742424671728346435174599745050837219845492714432781605916887908122185510618');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 6 });
    T('-1', '22081167', '0');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 6 });
    T('-1.699677', '-85162.06', '0.000019958148029768185504202223384450775380492205097');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 5 });
    T('-998641097.19', '-16.9172897211', '59030797.11074819395941497103146162421254509397656638');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 1 });
    T('212.16740294', '1572.3589', '0.13493573441788639985438439023050017397427521159450301073120138156752888923769248');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 0 });
    T('-211336.5909', '9.62149', '-21965.058520042114059256934217049542222670293270584909405923614741583684023992126');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 3 });
    T('1.36768', '-4526', '-0.000302182942996022978347327');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 6 });
    T('-4.6661', '8.66', '-1');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 0 });
    T('0.0000000352', '2181349.67771', '1.6136798404991751871451949779e-14');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 2 });
    T('0', '2.2', '0');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 1 });
    T('-5', '0.000000000043501390', '-114938855976.7860291360804792674440977633');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 1 });
    T('-236277460749', '681.9', '-346498695.92168939727232732072151341838979322481302243730752309722833260008798944126704795');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 4 });
    T('311', '2.40', '129.583333333333333333333333333333333333333333333333333333333333333333333333333333333333333333');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 4 });
    T('-100.925767', '-500.2', '0.201770825669732107157137145141943222710915633746501399440223910435825669732107157137145142');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 6 });
    T('-273471796', '-308.40', '886743.82619974059662775616083009079118028534370946822308690012970168612191958495460441');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 0 });
    T('-206.253', '37617.8137197', '-0.005482854520383457743277778061233467488667495061608281272505660236');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 4 });
    T('36648083.4', '-0.6364', '-57586554.6825895663104965430546825895663104965430546825895663104965430546825895663105');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 1 });
    T('0', '2.50230', '0');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 4 });
    T('-159', '0.0000000000000347', '-4582132564841498.5590778097982708933717579250720461095100864553314121037463976945244956772334293948127');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 5 });
    T('1', '4.076946653', '0.2452816004507086691085040302586466048615230678614425323460321471123257');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 5 });
    T('6.3', '5.7303908215', '1.0994014538001262921365301506250850747492947414494248906788983485042041996785995305782827');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 3 });
    T('-0.00000000042', '-5', '0');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 6 });
    T('-0.000000000000000000922546501', '319.02', '0');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 1 });
    T('656909.320', '13246.7992', '49.59004134372324448007032521486398012283601309514829816398213');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 6 });
    T('2', '-0.0079292', '-252.23225546082833072693336023810724915502194420623');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 6 });
    T('17098545635', '-5046745176', '-3.38803427530140071411443897321119666534159877304651135411319606520192570150880944736647824756');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 2 });
    T('29', '1969.07179352', '0.0147277514692129710661135122185059778805012273628863880491832723208506691523957308755955');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 4 });
    T('0', '-63049974183', '0');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 5 });
    T('-8.136797', '-268.885', '0.030261252952005504211837774513267753872473362218048608141026833032709150752180300128307640813');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 6 });
    T('-218.6', '-11670862', '0.000018730407402640867486908850434526601377001972947670874696316347498582366923711376246');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 1 });
    T('-16720419', '-24.4844', '682900.9083334');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 3 });
    T('-5', '-1', '5');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 4 });
    T('189666', '1148004.40', '0.165213652491227385539637304526010527485783155534943942723564474143');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 4 });
    T('-4.624690795', '37651159', '-1.2282997171481494102213427215e-7');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 0 });
    T('-903888809', '1.166952', '-774572398.00780152054240448621708519287854170522866407530044081');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 1 });
    T('926476.5835', '0.00563907060931', '164295971.3911729543425435735936');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 4 });
    T('-1.15128', '-0.00000000026989', '4265737893.21575456667531216421505057616065804587053984956834265811997480455000185260661751083774871243840083');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 6 });
    T('0.000004894020116', '-1.1790', '-0.00000415099246480067854113655640373197625106022052586938083121289228159457167090754877014418999');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 3 });
    T('7748609', '-123.269089', '-62859.302870324611549615654253760243170126778498379265218711886481127478763147182826994040655236772294148');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 3 });
    T('10712886249.5', '-0.000000000000000000275092754', '-3.894281508229038995334642656563756673867171361409250350519956e+28');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 6 });
    T('0', '-396.6', '0');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 6 });
    T('0.0000008557', '-6.2', '-1.3801612903225806451612903225806451612903225806451612903225806451612903225806451612903226e-7');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 3 });
    T('0.000000000000000944', '7600017284', '1.2421024383554546663580982456092003803395560804095666054014200318231e-25');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 3 });
    T('-107898.743', '-2441.7', '44.190008191');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 3 });
    T('0', '13879311.683', '0');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 5 });
    T('-92630.816', '-131044.0', '0.7068680443209914227282439485974176612435517841');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 5 });
    T('-73.4429', '16619210', '-0.00000441915710794917447941268');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 5 });
    T('26097.0', '-0.00001000', '-2609700000');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 2 });
    T('10397870028', '-1.9683', '-5282665258');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 1 });
    T('-0.000011017', '6', '-0.00000183616666666666666');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 3 });
    T('-0.00009577512', '0.0000000000000000006721', '-142501294450230.62044338640083320934384764171998215');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 4 });
    T('0.00000000001915129223', '0.000000000000000368382', '51987.589594497016683768479458822635199331129099684566564055789913730855');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 1 });
    T('36.0', '-2.9', '-12.4137931034482758620689655');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 1 });
    T('-6264.93', '-30.685', '204.16913801531693009613817826299494867198957145184943783');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 1 });
    T('-1354.9273761', '-1', '1354.9273761');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('0.0000000005858', '-3.244', '-1.80579531442663378545006165228113440197287299630086313193588162762022195e-10');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 4 });
    T('-0.0000000000000000431435', '0.000000033279193', '-1.296411e-9');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 3 });
    T('-3', '64.431247157', '-0.04656125920843782992862548044748846114594540751456464935737391596490900127246159');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 5 });
    T('5.4794', '-384.98124', '-0.0142329013226722');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 4 });
    T('0', '-8.386', '0');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 1 });
    T('4830.7056843', '-21348.245121', '-0.2262811606724571297843306227793429691152364392040840292167263615709914444915746103');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 2 });
    T('2', '1.7', '1.176470588235294117647058823529411764705882352941177');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 4 });
    T('0.00000000000023428329582', '1', '2.3428329582e-13');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 6 });
    T('5.711', '47494.99695', '0.00012024424395715220695');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 5 });
    T('3.34147426764', '0.000000000000361719', '9237762649017.60759');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 0 });
    T('-19.9', '0.013696', '-1452.9789719626168224299065420560747663551401869158878504672897197');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 3 });
    T('-1483166687.75', '-1.819', '815374759.6206706981858163826278174821330401319406267179769103903243540406816932380428807036833424');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 5 });
    T('-5648.6465', '-2803396092', '0.000002014929861720018406874486004669796051067620593658157956795781964013667462870958443213810402');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 6 });
    T('-2032', '-75185.56', '0.027026466252');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 1 });
    T('45.49507152', '-17965.8272947', '-0.0025323115253045570066297003831901140467329');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 2 });
    T('3217.36', '528742465142', '6.0849283197557059817291008593275512266174569e-9');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 5 });
    T('-0.00477', '-103', '0.0000463106796116504854368932038834951456310679611650485436893203883495146');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 3 });
    T('-1.8', '-1.57443061', '1.1432704550885');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 6 });
    T('-35.079', '-3475909.119', '0.000010092036011025523017996950109557798251514066700200167');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 0 });
    T('28633605453', '-4499.466765', '-6363777.520423578459302165775637193755336028134880557');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 3 });
    T('-0.00001962946', '1.17', '-0.0000167773162393162393162393162393162393162394');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 5 });
    T('20.9', '-81191', '-0.000257417694079393036173960167998916136');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 6 });
    T('13859.720', '0.002234750963', '6201908.055738915907114434030115238393120227061291571753536816800109820559008');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 1 });
    T('66862279', '8', '8357784.875');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 6 });
    T('-0.33207744', '86.5469', '-0.003836965159930627209062369651599306272090623696515993062720906236965159930627');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 4 });
    T('-0.00000000072', '0.011', '-6.545454545454545454545454545454545454545454545455e-8');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 6 });
    T('100.7246', '2', '50.3623');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 2 });
    T('-290.44553', '0.00000000000000000288851173', '-100551964869465840805.15400918936202485146217495194315863138281249');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 0 });
    T('5', '3', '1.6667');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 3 });
    T('-7', '51.074', '-0.137056036339429063711477464071739045306809727062693346908407408857736');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 1 });
    T('-0.000125563936', '14842', '-8.46004150384045276916857566365718905807842608812828459776310470287023312e-9');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 3 });
    T('-0.00000000000215831568', '1', '-2.15831568e-12');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 4 });
    T('83.467991', '-160369', '-0.0005204745992055821262214018918868359845107');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('-653.190854', '-1', '653.190854');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 3 });
    T('0.0000000000000018012391', '-347451712', '-5.184142249959614531989987719502156316904260929357573578454550829786e-24');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 0 });
    T('-0.0000000000899441471', '79.7', '-1');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 1 });
    T('18523658.1', '40.5', '457374.27407407407407407407407407407407407407407407407407407407407407407407407407407407407407407407');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 6 });
    T('-9.141003204', '-1097.67920', '0.00832757257676013173976513356543514717232502902487356961851878035039745674');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 0 });
    T('26.8', '4890416541', '5.480105789622553135397633606196328e-9');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 6 });
    T('-1.5', '-0.00324588908', '462.1230002104692992158561376348695193244249738811');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 4 });
    T('-2544699.37', '-229680', '11.0793250174155346569139672587948450017415534656913967258794845001741553465691396725879484500174155');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 6 });
    T('-47.19', '-0.00000000000000161461381', '29226803157344479.7923536');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 1 });
    T('-13.76945', '104171642.7', '-1.32180405752591631157986913457783074779140446443204643829620630528849287311e-7');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 6 });
    T('225855509.5', '4', '56463877.375');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 2 });
    T('0.0000000000000120918545', '34.696', '3.4850860329721005303204980401198985473829836292367996310813926677427e-16');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 5 });
    T('5387.3366', '52.3632', '102.884022');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 6 });
    T('3.8', '-26369.6', '0');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 4 });
    T('8', '-1', '-8');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 5 });
    T('0', '-6.402', '0');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 6 });
    T('0', '-3', '0');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 2 });
    T('-9916091.06', '95.15076964', '-104214.51237354384472638302455668922952917903');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 2 });
    T('0.000000000000000000106526', '-0.00000000436617', '-2.439804222006930559277352920293987636761738548888385e-11');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 6 });
    T('16.0', '-31.1', '-0.514469453376205787781350482315112540192926045');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 4 });
    T('-0.001435007', '-0.000000364478', '3937.156700815961457207293718688096400880162863053462760440959399469926854295732527066');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 2 });
    T('-27334994', '1.8', '-15186107.77777777777777777777777');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 1 });
    T('0.000000000000000000449195', '-0.000000056604', '-7.935746590346971945445551551127128824e-12');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 4 });
    T('-1.01546', '-244.337', '0.004155981288138922881102739249479202904185612494219049918759745760977666092323');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 1 });
    T('-24376.6', '1', '-24376.6');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 6 });
    T('-0.00015178729927', '-17287059', '8.7804003717462872082521382034966155897e-12');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 5 });
    T('6.847', '-331569.11', '-0.000020650295197884989949757382405134181528550715');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 5 });
    T('12', '1', '12');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 6 });
    T('-41177.8', '0.000000000000001601174', '-25717254964170040232.9790516208731843010191272154056960705082645608784554333257971963072095849670304414136127616361495');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 0 });
    T('9.7', '-96483.25', '-0.0001005355851922483954468780850562144206377790963716500014251178313334179766954367727040703956387');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 2 });
    T('-1935', '-0.000000000879301578', '2200610175636.46405738623614752571273106483609654115735022597673536757828950467321918078031698926394966619747');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 3 });
    T('61.519', '-7', '-8.788428571428571428571428571428572');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 2 });
    T('0', '7467389320.2', '0');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 2 });
    T('-9417.3', '0.0002750016', '-34244528.0318369056761851567409062347273615862598617608043007749773092229281575089017663897');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 0 });
    T('-2', '5.2', '-0.38461538461538461538461538461538461538461538461538461538461538461538461538461538461538462');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 4 });
    T('228504', '-16257', '-14.05572983945377375899612474626314818232146152426646982838162022513378852');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 2 });
    T('0', '4.8', '0');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 0 });
    T('-7', '-1.846', '3.79198266522210184182015167930660889');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 3 });
    T('89.4', '-0.0000000000000115477', '-7741801397680923.473938533214406331996847857149042666505018315335521359231708478744685088805563012548');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 2 });
    T('-0.0000374074', '-9751265', '3.836158693256721051063631231435100984333827457258109588858471182969594201368e-12');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 0 });
    T('0.000000021799764755', '-1355736924.87', '-0.1');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 4 });
    T('29.054', '-12.2428480', '-2.37314062871645551753970971460235396208463912971883666284184856334');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 4 });
    T('2', '662578.45207', '0.00000301851');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 5 });
    T('45.3', '6.868840', '6.595000029116997921046348437290721577442479370606972938662132');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 4 });
    T('-204303.3533', '1', '-204303.3533');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 5 });
    T('1.04', '-1', '-1.04');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 0 });
    T('10911.805832', '-0.00000000014725661492', '-74100615703600.474968734260240185072970846205025612577078788658603235533346049294068615820929261926021734');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 4 });
    T('109994.8', '-33.89433', '-3245.22715156192790947630473887520420082');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 2 });
    T('0', '-0.0000000000000001972885', '0');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 6 });
    T('0.0000000001829998084', '0.0000000000000000927080191434', '1973937.2072758604029349566645268001499078182061383370648849962471476338865469');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 1 });
    T('-122741857.9', '-9.19018', '13355762.117825766198268151439906508904069343581953781101131860311767560591849');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 3 });
    T('-302441205691', '-0.00000000003062798189', '9.87466973100655702392411203035356111084601e+21');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 5 });
    T('73905087.2', '-0.00000000212', '-34860890188679245.283018867924528301886792452830188679245283018867925');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('930.90', '-3.49755383', '-266.15744753240867203464885628365010753815903385252543775716526999099825148366622851949');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 0 });
    T('0', '697494057', '0');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 6 });
    T('-2', '4722857.909', '-4.2347240559339046589979e-7');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 2 });
    T('-93.2', '0.000000000000000000012', '-7.766666666666666666666666666666666666666666666666666666666666666666666666666666e+21');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 1 });
    T('0.00779751', '-0.000000000000230916455685', '-33767667084.91669875510630609997966719831173559786573510087001576351');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 4 });
    T('-79577437', '0.00000000000000000921603', '-8.6346764279196139769510298903106869226771180215342180960782462730698576285016433323242220348675080267750864526265648e+24');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 6 });
    T('-9', '-4.7', '1.9148936170212765957446808510638297872340425531914893617021276595744680851063829787');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 1 });
    T('0', '-93.161757', '0');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 0 });
    T('0.00000000000000955711816', '-0.000002757595', '-3.46574393991866100714571936778243360609516625900467617616074876840145126459832e-9');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 3 });
    T('-4848.3', '3', '-1616.1');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 6 });
    T('-6.5', '-0.56', '11.60714285714285714285714286');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 1 });
    T('6.76843', '-0.0000000000000000000149', '-454257046979865771812.0805369127');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 0 });
    T('791937322.74', '-1.48513147', '-533243917.280939444371211122473891149852208033811309647892655');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 4 });
    T('-7.681', '-318681.61501', '0.00002410242586400528860555682546652222703633147375');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 1 });
    T('-60629466.21', '-6', '10104911.035');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 1 });
    T('-5', '378.6', '-0.013206550449022715266772319070258');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 4 });
    T('169365429578', '0.000000000000003750', '4.5164114554133333333333333333333333333333333333333e+25');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 0 });
    T('-72.26816939', '-99300810870', '7.277701839173309864433335618742666970127229938903e-10');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 6 });
    T('-615.3', '-237.99', '2.5854027480146224631287028866759107525526282616916677171309718895751922349678557922601789991');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 0 });
    T('10000.265176', '6', '1666.7108627');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 4 });
    T('15.089279', '-3526', '-0.0042794325014180374');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 5 });
    T('11.93', '-476103.58589', '-0.000025057572245961');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 3 });
    T('0.00000000000000057027', '11902546551', '0');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 3 });
    T('-503944526.66', '46.8', '-10768045.441452991453');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 5 });
    T('31910346.2914', '-15.345731', '-2079428.2326074919467831151217');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 5 });
    T('0', '-0.0000000000007322481773', '0');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 3 });
    T('-4.69', '-4', '1.1725');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 5 });
    T('-16.9850', '28555184.76', '-5.948131711545612846526719514036161327e-7');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 0 });
    T('-51521013', '-35.308', '1459188.08768551036592273705675767531437634530418035572674747932479891242777840715985045881953098448');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 0 });
    T('39364.463651', '-2', '-19682.2318255');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 0 });
    T('0.00000029202905324', '-2189.5379715', '-1.333747379772262606773430875848137808831e-10');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 1 });
    T('-4.5507392', '-241.78', '0.01882181818181818181818181818181818181818181818181818181818181818181818181818181');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 3 });
    T('16.2836', '-57', '-0.285677192982456140350877192982456140350877192982456140350877192982456141');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 0 });
    T('3.1', '0.00100', '3100');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 0 });
    T('36.9', '0.000000000000000000146420913', '252013180658148197723.640747957909537143782187');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 5 });
    T('0', '-1.6', '0');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 6 });
    T('-178325.79522', '-7.7356', '23052.61327111019184032266404674491959253322302083871968560939035110398676250065');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 1 });
    T('-0.0000000000468001021084', '59.857', '-7.818651470738593648194864426884073709006465409225320346826603404781395659655e-13');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 5 });
    T('0.00000000000059958', '0.00000000000000988455', '60.65830007435846851905246065830007435846851905246065830007');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 0 });
    T('-0.00000243467', '-6', '4.057783333333333333333333333333333333333333333333333333333333334e-7');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 0 });
    T('0.0042', '3', '0.0014');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 0 });
    T('-1960.96871613', '939803.491', '-0.0020866');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 3 });
    T('102512.0', '-0.000000000000000000016', '-6.407e+24');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 1 });
    T('-270.92449', '-1773880.4', '0');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 5 });
    T('205674.52799', '1.33', '154642.5022481203007518796992481203007518796992481203007518796992481203007518796992481203');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 2 });
    T('0.0000441990616', '6.96', '0.0000063504398851');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 1 });
    T('0', '-13844.13', '0');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 5 });
    T('-344.0', '-1375921.3', '0.00025001429950971759794691745814240974392939479896124872839747447765');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 5 });
    T('7', '6055.93', '0.00115589182834015584724394106272694697593928596');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 5 });
    T('0.0000000086955', '-1.409328', '-6.1699618542e-9');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 0 });
    T('-112561144099', '12726026.1', '-8844.9562506397814161327234744552346941988434237141789297446121063668099816328366637563316014258370882958');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 6 });
    T('-880056994.8', '62', '-14194467.658064516129032258064516129032258064516129032');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 5 });
    T('2.4', '14.5', '0.165517241379310344828');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 4 });
    T('2.2053382305', '15285423607.9', '0');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 0 });
    T('4.2', '-13879644.5293', '-3.0260140964948912756879101350430288789629484996093098033920986060278064645953483e-7');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 2 });
    T('0', '-3.067', '0');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 6 });
    T('-0.000198747592', '11443941', '-1.7367058428560580660106514005970495653552e-11');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 5 });
    T('-7866052296', '5559461.4595', '-1414.8946536104681130041027492799727717943360625252302822');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 4 });
    T('-2303.7', '-191766.627641', '0.0120130391212421');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 0 });
    T('0.000000000097', '40.3996', '2.4010138715e-12');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 0 });
    T('2775578.4', '450.4', '6162.47424511545294');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 2 });
    T('-0.0000000004032838', '0.000000000000214', '-1884.50373831775700934579439252336448598130841121495327102803738317757009345794392523364485981308');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 1 });
    T('-0.0007736003596', '6.140', '-0.000125');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 2 });
    T('-8', '718737.77', '-0.0000111306241774381774871800601212316976190078336915562403239223117493');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 0 });
    T('20.597', '211523', '0.0000973747535728975099634555107482401440978049668357578135711010150196432539251050713162');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 6 });
    T('-0.0000000001384248666', '43747263.81', '-3.164194844303795099454015430456700830177017646946637689613255837588348591166438e-18');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 0 });
    T('3', '10761.278', '0.0002787772976406705597606529633376258842118937917968479208510364661148982490741342');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 1 });
    T('-58712', '-6076444.1169', '0.00966222989473536254188076428485783');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 6 });
    T('0', '2222570', '0');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 3 });
    T('-753067', '29', '-25967.8275862068965517241379310344827586206896551725');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 3 });
    T('2068746.523', '26663971.323', '0.07758583663100199022067482591');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 1 });
    T('-170411.0', '-0.000000000000000923174', '184592503688362107251.7206940403434238832549443550186638705162840374620602399980935338300255423137999987');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 0 });
    T('0.00000038326528', '5.184', '7.393234567902e-8');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 3 });
    T('-0.00000000000001092', '-0.00000000000000000227083393', '4808.806');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 4 });
    T('-0.00000000000029', '621.83', '0');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 0 });
    T('2950.6', '-2657.941', '-1.110107410209632192738665004226956128823025040811665872192046399826030750870692765565526097080409235');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 3 });
    T('0.47939552', '-3881.69149183', '-0.001');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 5 });
    T('0', '1417.60582117', '0');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 0 });
    T('-0.000000186729799', '-111357.44676', '1.676850578322293423244072949863671964096673942096e-12');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 1 });
    T('-26651082640.7', '-4.9', '5438996457.285714285714285714285714285714');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 2 });
    T('0.0000000000000018629', '-237', '-7.860337552742616033755274261603375527426160337e-18');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 1 });
    T('-0.0000000017', '0.00000000000177', '-960.451977401129');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 2 });
    T('-11.7760', '-36788.11', '0.00032010342472065023182762039147974712481831765752576036116016832612493547507605038693209');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 5 });
    T('3.2055791071', '-345', '-0.009291533643768115942028985507246376811594202898550724637681');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 4 });
    T('0.00000000000000000024877145', '-397.8', '-6.253681498240322e-22');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 1 });
    T('-4.035', '-17306', '0.00023315613082168034');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 1 });
    T('0.24', '5', '0.048');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 6 });
    T('7.3', '0.000000000000010341641502', '705884070588622.8853342822055213802943137450095685979813613539047236642452315400325506274738781793056976149665026');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 0 });
    T('-0.0000000000000000008919436032', '305.8173', '-2.917e-21');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 0 });
    T('-0.00000000000289', '0.1070651024', '-2.69929223922359971515798036541176464610563899297218623871601e-11');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 3 });
    T('0.00000000000000175906577', '-981337', '-1.79251957e-21');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 2 });
    T('-2812463.8', '-299.652460965', '9385.7523844214359162388132599663797325');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 6 });
    T('-473960479', '765598.68', '-619.0717035');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 6 });
    T('3674759.55', '50.2', '73202.381474103585657370517928286852589641434262948207171314741');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 0 });
    T('-0.0000219', '2314833250.79', '-1e-14');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 4 });
    T('8.7298024', '-466.52', '-0.018712600531595644345365686358569836234245');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 5 });
    T('82.70455184', '6362544', '0.0000129986608878461194138696722568834101579493989');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 4 });
    T('-10.20008', '-5', '2.040016');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 3 });
    T('14643850.501', '2.4', '6101604.3754166666666666');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 3 });
    T('0.00000000000000000786002', '0.0000000053443', '0');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 2 });
    T('399.150', '0.009672', '41268.6104219');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 0 });
    T('3.552', '689368375511', '5.152542713272929982489453159129746031190798066507624e-12');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 4 });
    T('0.000000000008575422', '5', '1.7150844e-12');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 0 });
    T('0', '-80802828.4', '0');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 5 });
    T('37009.867', '-2368.6', '-15.6252077176391117115595710546314278476737313180781896478932702862450392637000759943');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 1 });
    T('-44.3025265', '-848426.1538', '0.000052217304124318002607052588010400393199194185425640281576147705973');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 5 });
    T('0.0000000000000092', '4.6', '2e-15');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 0 });
    T('32161496195.4', '-1134104527', '-28.3584937981646906872808911730937830918295946454678070427982693344809');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 0 });
    T('24.54073', '6', '4.09012166666666666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 1 });
    T('0.0000000000001885095', '617379873', '3.05337942236e-22');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 2 });
    T('-1.683046172', '-94685.625215', '0.00001777509699258313124716266890417659687626323078718026501653490718834030988871682870474');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('-30785853314', '1.526001', '-20174202581.7807458841770090583164755462152383910626533010135642112947501345018777838284509643178477602570378');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 6 });
    T('-0.0000000000000253748445', '3', '-8.4582815e-15');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 5 });
    T('0', '-2631.4486', '0');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 6 });
    T('0', '650.53', '0');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 4 });
    T('1.7034706', '-183997774.362', '-9.258104376026669843725095916495e-9');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 0 });
    T('-4106.133278', '2', '-2053.066639');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 4 });
    T('-14.82528089', '1236.4941006', '-0.0119897708228499735714792459237067548043908556598575655185782615');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('0', '-24146874.220', '0');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 4 });
    T('-0.0000000001425', '-58741317.18', '2.425890443745749182398568747926738267941576995464983204518601841812e-18');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 1 });
    T('5891398', '0.009468', '622243134.76975073933248838191803971271651880016899028');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 4 });
    T('6173', '29807783.1', '0.00020709356275475582080439923759');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 3 });
    T('-0.00000003589532', '8.8', '-4.07901363636363636363636363636363636363636363636363636363637e-9');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 6 });
    T('0', '-0.0000000000000006638389', '0');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 0 });
    T('901.626592', '8167935.7', '1');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 6 });
    T('9358.84', '2594.09', '3.60775454976504284739542575623821841185155488051686718656638744222444094075379035');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 2 });
    T('-2', '-1.4', '1.4285715');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 1 });
    T('3529307', '233817.80047', '15.09426139885713210259076901665458558831853166649');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 0 });
    T('1.31', '0.0000000000835735480', '15674816151.158258830892281849754661606564794879834466283518320892634593');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 1 });
    T('172119', '1313.7', '131.018497373829641470655400776432975');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 1 });
    T('-2.0', '-0.0000000000000000000158', '126582278481012658227.848101265822');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 2 });
    T('-4.2', '-1408.340483', '0.002982233380846441236611104361756815308418567983463981699658348882384573192');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 5 });
    T('702263', '-19', '-36961.21052631578947368421052631578947368421052631578947368421052631578947368421');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 4 });
    T('0', '-16.6', '0');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 1 });
    T('1.39', '2479563.189', '5.60582608326502301530981471e-7');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 0 });
    T('130384.6', '7738.439', '16.8489536455608166');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 0 });
    T('-77.37646245', '-15575006446', '4.96798911244572591812845789688349257e-9');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 6 });
    T('-0.000000000000105997475333', '1566533913.92', '-6.7663696515677920855567403738e-23');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 5 });
    T('-0.078', '-9.3', '0');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 3 });
    T('1459231246.57', '-0.00000000000000000248564', '-5.870645976770570154970148533174554641862860269387361001593151059686841215944384544825477543007032394071546965771390869152412e+26');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 4 });
    T('-6980419.8336', '40', '-174510.49584');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 2 });
    T('-817230113.72', '2.9678', '-275365628.991');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 0 });
    T('-15.129', '-0.00000000000000000012903362315', '117248509579652146658.3339909882');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 5 });
    T('-88.78607', '-8.02', '11.07058229426433915211970074812967581047381546134663341646');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 3 });
    T('0.0007810', '160509488837', '4.865755947881176168373644971512582227188e-15');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 0 });
    T('439.43430', '4', '109.858575');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 1 });
    T('6', '-2.062276', '-2.90940688831174876689638050387048096375072977');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 5 });
    T('7.22', '67307.673', '0.00010726860219934');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 6 });
    T('2.7', '18020.888185', '0.0001498261335558028712112560061');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 6 });
    T('-1.8', '61', '-0.02950819672131147540983606557377049180327868852459016393442622950819672131147540983606557');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 1 });
    T('358020', '99441.0', '3.6003258213412978550095031224545207711105077382568558240564756991582948683138745587836003258213412978');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 1 });
    T('0', '-1.22', '0');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 5 });
    T('0', '490.85100', '0');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 2 });
    T('8206.27628159', '4114304', '0.0019945721758990098932893631583859628');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 3 });
    T('-0.182715262', '853.02', '-0.000214198098520550514642095144310801622470750978875055685');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 2 });
    T('-8363.1', '0.00000000000000091', '-9190219780219780219.7802197802197802197802197802197802197802197802197802197');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 6 });
    T('1169.5', '-15463.00667', '-0.07563212155039444214376711511823980866');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 1 });
    T('908786', '-200681.3', '-4.528503652308411');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 4 });
    T('-0.0000000000000035169', '15994.995', '-2e-19');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 6 });
    T('0.00000000026', '-8587343224', '-3.027711752260573206e-20');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 0 });
    T('-6703488.435', '11.1', '-603917.8770270270270270270270270270271');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 4 });
    T('-170483104.5', '-10', '17048310.45');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 6 });
    T('-13213.36', '0.000000000000002009', '-6577083125933300149.3');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 0 });
    T('8.76590183928', '-0.000000000000000131359888', '-66731952750142417.90461940710547');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 1 });
    T('0.0000063876', '-1929.4276714', '-3.31061904765009062676e-9');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 2 });
    T('-0.000022982731', '-1326798.381', '0.1');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 4 });
    T('-0.000000000000000000899452', '-0.00000000000000010457', '0.008601434445825762647030697');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 1 });
    T('-128.5', '93543.2', '-0.0013736968587775487689110485850387842194836182640747804223075541567960044129343447733239829298');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 0 });
    T('38279', '72312.99', '0.52935164207703207957519112402902991564862689262330322670933673189284525505030285707');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('-2.28', '2.6', '-0.87692307692308');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 5 });
    T('1.55', '-184.292', '-0.0084106');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 3 });
    T('1.0', '-1923', '-0.000520020800832033281331253250130005200208008320333');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 2 });
    T('-0.117024182', '-21025', '0.00000556595395957193816884661117717003567182');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 2 });
    T('-478713.598', '12517', '-38.24507453862746664536230726212351202364783893904290165375089877766');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 2 });
    T('-13.57330521', '-726098987.961', '1.869346388722558733493483109779855307113324826e-8');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 1 });
    T('90.9813', '161525.59', '0');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 4 });
    T('-6', '40925001', '-1.4660964821967872401518084263455e-7');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 6 });
    T('0.00000000000000000041', '-4.5', '-9.111111111e-20');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 1 });
    T('-3', '-0.0000000006696', '4480286738.35125448028673835125448028673835125448028673835125448028673835125448028673835125448028');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 6 });
    T('10.2', '-0.00000000675155509', '-1510763055.92286887493944746883491696');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 1 });
    T('-1033130.9', '-8332.83', '123.983196585073');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 2 });
    T('-4.03', '3.53', '-1.141643059490084985835694050991501416430594900849858356940509915014164305949008');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 6 });
    T('100.9', '0.0000000000000000100', '10090000000000000000');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 5 });
    T('-16.7', '-495.59', '0.0336972093867915010391654391735103613874371960693315038640811962');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 1 });
    T('-96.6', '-495003.5298', '0.0001951501235');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 4 });
    T('2.1', '-129939161', '-1.6161409569206007109742689503743986772394197619915369470486268569950209236767351453e-8');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 3 });
    T('0.000000013437161974', '103.31', '1.30066421198e-10');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 0 });
    T('-0.007308316', '2784', '-0.00000262511350574712643678160919540229885057471264367816091954022989');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 5 });
    T('1', '-0.000000000000017670059', '-56592906679032.5940620798153531915201867747018');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 4 });
    T('0.00000000000000089362492', '64229.8', '0');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 0 });
    T('0.0000000001502918671', '0.00000000000482694', '31.136054539729103738600438372965066895382996266785996925588468057');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 3 });
    T('-17086.184193', '-5.4439535869', '3138.5616942280988938605383244950971020189');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 6 });
    T('0.0254426530', '-458197.07198', '-5.5527751170593589e-8');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 1 });
    T('85008.0462', '-84385.98078', '-1.0073716678321458030223299373021');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 3 });
    T('0.000000000000000001936', '1', '1.936e-18');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 0 });
    T('-0.0000000010049430843', '0.000000000871553', '-1.153049');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 2 });
    T('248.283056', '-8249.702', '-0.0300960029828956245934701641344135824542510747660945813557871544935804953924396299405723988575587');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 6 });
    T('48518.8', '2042', '23.76043095');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 2 });
    T('2192632.42', '-3.847', '-569959.03821159344944112295295035092279698466337405770730439303353262282297894463');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 2 });
    T('-45908816104', '12341.507108', '-3719871.139096215476570951062162609905454668559592908350979009135129689867371423467481423906497498');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 6 });
    T('-2.17011', '-87.7089375', '0.0247421763603053565664274521624435366122181106115896113779738809400125272296224');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 3 });
    T('192.7', '-103777225', '-0.000001856862139067603705919097374207105653480327692323628811620276028772209');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 0 });
    T('-5', '-6389', '0.000782595085302864298012208483330724683049');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 5 });
    T('168756033.40', '312791485989', '0.001');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 3 });
    T('-0.000000000000000999', '27.8637832', '-3.58529921378371907516133702906502660414038823e-17');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 2 });
    T('-111914.7041', '0.000000831', '-134674734175.691937424789410348977135980746089049338146811070998796630565583634175691937424789410348977135');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 4 });
    T('-8305.7958', '37623.0', '-0.220763782792440794');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 1 });
    T('575781866', '39425376.5337', '14.60434665748426061683343511539359013125051608769944423598665');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 6 });
    T('8.5', '104.7', '0.0811843361986628462273161413562559694364851957975167144221585482330468004');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 2 });
    T('0.00000143', '-1135.09', '-1.25981199728655877507510417676131408082178505669153987789514487837e-9');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 1 });
    T('0.000000000000000000010446', '0.0000000000000000704440', '0.0001482880018170461643');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 6 });
    T('-4.5', '-96852.6', '0.0000464623561990075640715891984314308547215046369431486609549');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 1 });
    T('-1227.44993882', '1.94852', '-629.9396151027446472194280787469464003448771375197585860037361689897973846817071418307228050007184940364');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 3 });
    T('81549.77863', '-344.6631181', '-236.6072096125449');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 6 });
    T('-1', '4.1', '-0.243902439024390243902439024390243902439024390243902439024390243902');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 1 });
    T('14.132', '1773988', '0.000007966232015098185557061265352415010699057716286');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 6 });
    T('-1.3227014', '31.6', '-0.041857639240506');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 1 });
    T('1.1978', '0.000000000009367527', '127867258882.73393821015941560670174743024493017207209544205210190480369045106568681360619510357429');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 4 });
    T('-1023459.1258', '-6', '170576.520966666666666666666666666666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 2 });
    T('-3.53665238783', '140942000.890', '-2.509296281801920713458660761318783062722843965437335008448665709871347e-8');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 2 });
    T('-4', '0.00000000059523', '-6720091393.24294810409421568133326613241940090385229239117652');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 4 });
    T('0.0004846', '-92789.337', '-5.223e-9');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 0 });
    T('-5296416.381', '3271.11', '-1619.149579500536515127892366812');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 2 });
    T('9', '113372725.7', '7.93841723785952867851002015734371639968430255355499493e-8');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 3 });
    T('-188.1', '-65.559116130', '2.869166198443072267820093931458');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 3 });
    T('264105.994294', '4.228', '62465.9399938505203405865657521286660359508041627246925260170293282876064333017975402081362');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 6 });
    T('-1632935027.5', '5', '-326587005.5');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('-0.000000000000000000159617451', '-14742180', '0');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 2 });
    T('9420.387558', '-2.7899', '-3376.604020932649915767590236209183124843184343524857521774974013');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 2 });
    T('-12.7', '-0.0034855', '3643.666618849519437670348587003299384');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 5 });
    T('-9951.6613', '0.00000248255061', '-4008643876.1463960648117461742300593017920387935213');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 1 });
    T('-4029471522.6', '-0.0000194', '207704717659793.8144329896907216494845360824742268041237113402061855670103092783505154639175257731958762886597');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 6 });
    T('1', '-66871334.88', '-1.49540905949386365831134729099339313204e-8');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 5 });
    T('909516', '-1.17640904', '-773129.04701922385771534023573977296196227801853681777215856824765644439454495');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 1 });
    T('13196.6012', '-3.68', '-3586');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('2', '-0.0000000000000000021855345112', '-915107947163858997.31383');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 0 });
    T('-1872907', '7', '-267558.14285714285715');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 4 });
    T('-2', '-88.0', '0.022727272727272727272727272727272727272727272727272727272727273');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 6 });
    T('9.7', '-267.844331', '-0.036215065533718538922520633822935009216230154223424650342888907363135492309523624003824819');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 5 });
    T('-2749.160035', '-0.000000001363677066', '2015990518241.94864035353660483133768563355746865658588409523050525512027640127519751072795412');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 0 });
    T('-133043843', '-2161.2339', '61559.206062795887108748386743332130779551440498874277328335447634797880969755286551816534064175099234');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 4 });
    T('1.5', '0.00000000000361964685787', '414405067372.423947871882454568264051104256736485079886692');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 0 });
    T('-1199.8951', '-289851.54', '0.004139688545384302598495767867923006377678724770618779531067');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 2 });
    T('-932.59698', '-4.168240', '223.738791432355142698117190948697771721398000115156516899218854960366965433852177417807036063183');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 0 });
    T('76943694944091384167086915802330', '-3170514344.13111437411632629436402363000882134793762203080559731', '-2.426852131627177782103584719976324063198598249615667667537013034965147477765909459742787670213e+22');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 3 });
    T('-100106813802380591049673190434.29485007726830983381860757169221843019100', '-78094528555018220969404221099599857932226474465981358723152985003774326996070488958663.442862362122064587341729645', '0');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 6 });
    T('2765444538823009380150927888.62817583856680697300833760', '-373748288687906995883.519458069547968158219485', '-7399216.591817636693983101292832142580414091203843524104084009183630806757');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 0 });
    T('0.0000172463179744500990608615554398722487', '128351898662310623329971900021427807014001736937674026359996931286121280901491747367836548202.528608641660908590739943216651336106395324584507151', '1e-12');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 5 });
    T('1618182994977486168089504.303412002229357379185662538096814339710756228978272205292369429799229740090454', '-1', '-1.618182994977486168089504303412002229357379185662538096814339710756228978272205292369429799229740090454e+24');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 1 });
    T('0.0000000000000001522032939763705088667535980533375348092536476465289413241', '1496543943364674787461682993652979296106902960456836.034677750383049103427390868675285804492754316540692799996989618573', '0');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 2 });
    T('289251150440844894569227868596141248263971687018908.7582', '969818345137713519457348076418917350.37856042901482781836418515983', '298252917044760.00160068480697641721380359737601457865036690355925562692260445875');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 1 });
    T('-2213024.10057343', '-0.00000000000890742736591171593701106620816057819688709922018889419831412741863646672006726805124790913781880723722136288', '248447055436293962.98257200988127959945635068362403073');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 3 });
    T('-15000278752002677229489373453133974451779691958658411412581239029394262255826590548325824084926.364426980013744537479550093154967968151133218', '19930817564922229.5291352024629512480065750746678111999803194282693935048894', '-7.5261733258764132558180496549931107141952632304821423841286112570949320236190648553080458511753045259342783429114610461572193346219434419429e+77');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 1 });
    T('2096800095471614267703827121104.6754238308397', '2.973744016791308902667556831639027', '7.05104435227776125703251584926381124242257216881232643916317132478678635644883e+29');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('-576734896916364067204534325671000853418944286761094369396994587390.20170231389237709680027328398585710017952537281946222360187352', '482009602275141687123306632546133845144058354871522511369929211612892', '-0.001196521592503775676990724935172199634474240903524148649627067119770277994733693557');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 4 });
    T('-75918192392719163505045309838518111893013980009840517848891803953427.331330077457915525677681132397253540608104431728701657413', '-60979444819.8751292844264416314741570622847181849330960883', '1.24498005216300401626112591056125561055479097283160657526274169782872486314816546784862028914263938033873610945100941389665795564937849448482476657e+57');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 2 });
    T('294.95', '0.00000000019352898985320522149531968704', '1524061073349.9110789035044962295678018844264382');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 4 });
    T('-0.28285407443755989683129372477710347255628834145187398883521459316293173768845235732814560306340433698915', '0.13871292707912833655802036597064044560547677333278215519941645627237614443', '-2.0391327642895655512488938334656344761249691410161901311361129106689190000978968816312793966');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 6 });
    T('242992584878322186712025587579252842.56039954525291656310959074824986645465943491015032457106137684405819694', '87473659275731441930066028841855978813198.22321903332667067910515', '0.00000277789436145994');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 1 });
    T('2.269347201823999184', '-7.241321231807619199976531960675934417862803419339662663862610722343621731', '-0.3133885556');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 3 });
    T('3417885238696572270129533944698388854525514341906650023562052290280297627647749736866679.81692498536029901538050463542979536148441', '3298004280850374294213354990796411195649603604998968859911.9799801664027118', '1.0363495458578626394360904317930653776117e+30');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 5 });
    T('-11601794306', '-81767908348879851406690153959787322235864066.27197447304998889596792931520034109538966807267862795165181056608451', '1.4188689108321717760383402370309730605641516497841200518e-34');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 1 });
    T('-0.00000000006616495227868586', '235258142311710116186006815624097650601046483181302591778203830815439582160063948086684271928090450039326479.93618472866635377602947742', '0');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 2 });
    T('0.0000000000000007067996790061306734918199720686295541286585430436464239709795110073573528404300274616929677689236', '-971695691184134545850288955136758986951477249164414605379951990283064015944899942693392909033092608070796379272686752559239639568070', '0');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 1 });
    T('-4496428489.8107752661458715428395066220930608392696841546473410', '10562602494277713859668354432350036023079132.087319618829217004735542670195303530490537681062066586195417639', '-4.2569324105936144046817190246976033493852315745693034949779e-34');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 0 });
    T('35920122558051508748063125686822913942860176999279879579817.4020267319839180494015750914006655283919319821515593314026309161089242741254532628', '-3950.5538090611987650712194288974', '-9.092427111273163634904721539148569267471666846523573342584757998200405808139310245590083081928179492591002169976154857060760636871413767504456e+54');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 2 });
    T('-243088505742038547731796747307.96086361844657478672072692415024978317837834142', '-8232283011028479.1700368570722455752415600074197665455778628677608248', '29528686685866.1250710377075976261763077799873288950475673');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 0 });
    T('-1162784776.475576897828', '295.56', '-3934175.0455933715584923534984436325');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 1 });
    T('23003353363599076353472193017303616218.849544590304416073580685', '72774733771332685416379.473364778', '316089831889711.742249');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 6 });
    T('-567752330920072378093754598619213748233796179.54236418430788356845643', '-516520833.596513462515354879978446982223512087368936146936784699018442590224803283390144545006111713728220298', '1.099185732677685220775424804772784445315257767579090407441376702516440306426402195129e+36');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 3 });
    T('5129631143957037743474086115152.0138944779473626911495605637223009720022208294444131290756814960940058345929700', '-0.001628420094254817289714854197741233263679962156674346005003765993855502866127511748662568192380989025289687', '-3.1500662280296980938785103011087640202801405120334662125500878292149054795017318453511463392253496963668008164268072237026849994e+33');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 5 });
    T('-8052237465249088503330516428019461935931483233368828144163108905362304793799154588586652106494205591271530372984422846128124216637054101172159.8198', '-24948480627686294479961182555344635149376544700047', '3.2275462323397798259929627015697611798773642903722190156638697307068475254156318133306212183904140821509558932647674966629e+92');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 2 });
    T('-12397061088902295.897360560', '634103874676968188199675493521107.0366802278632285774300608544418732486752517833267525055540644', '0');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 6 });
    T('0.0000000000000335809635072419405931374425439253273613830562335226929106905186893650025407202550455008965953735437464348179712812728248580871044244477117', '19646313.80579117165029', '1.7092755332729762558466647740958821730919210007978474484e-21');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 6 });
    T('0.0000000582449227209204919890209314208406523857981092654', '36223019307853521430962039853003183168570769.95', '1.608e-51');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 3 });
    T('-772946745603673867.340258837457273595019679255997676192580433280245108013129', '-1696902776617312106444048777217345449275764437258316904173651389899152.0177594787711491431721464369846363398155263812514418858122974236900857586', '0');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 4 });
    T('0.00000000000000000003116524543476809140307229914816902649111431106585959830341459426429296249727811891222585676328199187921592070560172826', '-3150132884709031864614.11492430581197981118226227987562414450886655921687736229752913126421963646080717789305641758399', '0');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 0 });
    T('119359.6666412324178632889818329515821650909368467852407575', '-224637567294185974886852529049358455101868576658680255021071380843.728422713272676496', '-1e-57');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 0 });
    T('0.0000000000000000128654230542111067189423898238246405929981191833566220411470745683627400928267331464973925678552845736018633685886179568342056880782221550361374348', '-2887131640135059115551339664820433789010005472214094930355978045276915703595155257443084452714940719251528954510676362728841175644799114073678579', '-1e-11');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 2 });
    T('-0.000774747', '-0.00000000000092798776373720020193054530221803748143507437902179574930854083957227391839348385502561988739064', '834867689.289277159219024232798273768579767988713805739979498226428144');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 1 });
    T('-827868461536829883533615801499842330245604823727789265080484494296581973230327572709857581087284918649127281', '49303677512716864518400823500434096286826505119302.9743946395242917733813874643090568032061657164233181387246372366819', '-1.679121118953648692303782747314078964567544504528672079427533110600711645262450980541570282263724901434251183336538506148689706453e+58');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 0 });
    T('-0.0000000000069385090826146798419962983124409745984969407476180725103074040574177183775134748722769', '50.2643657525834508627402118587581506961727676928022152870922843242765047348968567892276415345576593488544742272811011442', '-1.38040318995929228e-13');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 6 });
    T('-36465830.99057', '4246.9295268361765684367203054099354321276927054849374739', '-8586.39889363453836551650372642855884118816685562303698224837571');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 5 });
    T('1476708674658145763017333981.841951672822642013473098', '1507399190942938621889136186496523930356618676890447430300602059037448422589737696344109263118154130274452931568.00767568326234', '0');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 1 });
    T('31151456263.8', '719445144017520697175948798073.23266041169', '4.32992793444184626238433952e-20');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 1 });
    T('0.00000000000000001944284988655185994709008040377222083156202951329463977687875625', '36570102195549551310626600317527912852058509458312802954769714868502228113301386469182240406317883836444017.7959365986203099011251100198700', '0');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 5 });
    T('-3.41', '-180189999778582206969329154333161380.21867908917048900452072652645219508769542874832226452800919404132628121507168368', '1.89244686397148236887940388896859740933131345108857683e-35');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 0 });
    T('0.043254', '-33900799706350726803823554324197.2289101658777904906663', '-1.27589910487855286067700916396919354333975443789157114e-33');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 2 });
    T('45767308681814684662405180145407351015025789138220579904890513', '11703616727219168124423089130009645431065621809814113.44438980735', '3910526954.91756783366082309176987991868244379431829011307706609785215151070062077');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 0 });
    T('0', '409946135037084139112508529443331984520338808007410045687712390.37341052002741668352098872558939749', '0');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 2 });
    T('83991645554946550648660501622076948829205475727077980602090363500.3529373353607961673548760361397', '-62417534038612853524431031149788470754766910341134390055001497443989592787068960019605873895837530483.711068197247897385515638370383789971173', '0');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 5 });
    T('399.15978890', '0.000000000000000508936472472487791935715900753504990212713895672381439601328142012887053703220389114369591028834', '784301794997759517.3613143903819238439194126203801675984212192753757427861426142820114480649605235');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 2 });
    T('-1096651136061566062469896114565053904890092964982004245212697461541271120220336327715857955687292684162607855553175728010418531321461909990074196341', '10154.984', '-1.079914193918538977973669002890653402201414561541410843397387392773116255249970189727387020685894418112926475859711574149618090310592227412740577770481962354642803966997880055744056317567807098465147754048652366168179093142835e+143');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 2 });
    T('530291710465271519400057929362823808769925622.725711326079625482029469223470276638323050654170531083472274717560', '0.00000000000000010530294239590880893716635789973366225869274314505', '5.0358679292315218085087477235739742436851272590298887703889366505136434193799912706129762097494055328994e+60');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 2 });
    T('250890059887771999498847058254721688658828501929057517825850189564527881369512022170292724566387372942161149167967', '-5938359923718710898348182592.6693', '-4.2249049082673318364687888913057932494050497269933317856958173693850003558331497456054093e+85');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 4 });
    T('-1378616154058662492767568271138278820747355923137795.2894351872685597640513128546176', '-37903646936042996172994267.048159645793972584', '3.637159654808100213648289387294782958927162e+25');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 6 });
    T('-405032149949645531698438.280211765368612513947036412222426700623121403877400357070475693933100669', '176191874946088045557632944491735936258291661871674031465169621', '-2.2988128713289362888558334108185818798e-39');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 5 });
    T('-2580695182601869673918196714341800309674884455224565088301569943.2288274', '-0.000000000000002540862334586134935858336175389092350190923138909786692053890433753196878414040354336771350453861966', '1.0156769012919477433312399525282475220324945569172607675511111700657141391184536754311230324749217531787797433524338875588150029457904343196733453131e+78');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 3 });
    T('1683784432854764760318037677647356479258132056087368331404.7901349274121272631991953907393965668110904782111', '6098763.78830840832873090895083360527456728317690850679', '2.760861858730537673264019978069684088098674051042009367085739711554244066456823360955119091386170307547779216190046166314369772727903423469613814e+50');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 5 });
    T('-2530637191334289339737358351191006220110627855345270379.24464258326802980441960151480838549544839800106528099664769831900729044019049792251953842', '0.0000000000005630735131653553549064876725', '-4.4943282398565391204427516201011048233046420457279955876277507634918635719590037824058731199609495e+66');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 1 });
    T('-6016514303387087370402318550.6923153806838045524779637206539897873368973099362667678596187646318534447942829547334688115', '42063250650445111261623586421695502971901833122937548372402100380934529958016372546.6', '0');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 6 });
    T('-0.000000026315944617863612115639219149412047957937278455665071240177388414490625437453442371901796371717069144110689088162500312', '-2.72299972943683965188220367', '1e-8');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 6 });
    T('-0.0000000025474072806440830689586180541261721100964401394173677164038', '836486791609582458507489170248190.24332716383034253743391258375515097987391331247574', '-3.05e-42');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 5 });
    T('-53013010047301437313195229107041695663054443105621563368715814088060231437445919515771354548001642958971257675436953938693573030623638', '-0.00796582379779070199223958039275317264241408196576173862276559143700498102322472', '6.655056826891456110588198397760479231210742064163853251683197496717259792361971893844369531103744582917298501592030438072823956184780768158137980361044298970332381029403854666621122182e+135');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 5 });
    T('-0.000021687139718147001344084346966546200647538067256875719646483903526067224', '379125104172643148686301251195225058433045909719144509494703160390891.0170200088661', '0');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 1 });
    T('4750140431498572971884.02444080212658169679978723632529229252457007826396773526300081724651204250517439743049309878', '22950611345566180502757288198630366770990837912160599255293.240692976132843', '2.0697228322051e-37');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 0 });
    T('-0.000000000036570892794447705585614624821983128340381593076828081186793139782426772027967459744045422188551482237816591716314', '2560596797097993138941873567696297135779266794271386064153376725986803756424263745.682976536715541668128630255613888292075729181635435292', '-1e-52');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 6 });
    T('3215201509569438794539395241433586240904044490694071836228405661637343', '19209955897019.37898330988372930240098575251229', '1.673716236937488322770450732532987109445543659818411514193939316406168e+56');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 6 });
    T('0.00000282494954542178986719684575203456013530718295572798942815487088262092660380952260355573509586164313188435614251378', '-2393493491867465608168880873625388541785217835882244163382042684.14580574857237744565825651728634720874755475134164710774169412', '0');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 5 });
    T('-138911208177979510918803338057536699138', '47484983457487684526753652269251469092668812125.2717610240593097820889181874231447310274090873968404783764276108027743740', '-2.925371308223026314e-9');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 3 });
    T('731241406311509903674243319413234680513560211005222568707790678525996236175934378681980527062623332869973136034551326117781889599187427211146.193394487', '-2687825772761.8689341190319351155213905676762471173107963898510595496404265593416492000662004897007501358729657', '-2.7205684747941253212498747243949969403982533754958137154056312955596826856387360980498258942150169615667959998506179760995692747353769627150318824922188291195e+128');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 6 });
    T('206939904334186501184151978408304545220002459073583245265171036400836008.478', '-10084745301004162428994304777972806212660507886355223903181084400320349971431386594095351596008397278869696036276954123347146', '0');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 5 });
    T('-39897603831431975.898726350018069055698508506479008835931923112170261', '2387737702875316321155641022232111227438399324663798098137222136357169394335629586576077266281484468887573', '0');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 0 });
    T('244402366994683.389936331', '46893212566947754952628148221078712047972256.355523427887089555207033604948598651391255670650506432106005809409641579984514266497954', '5.211892161275129331004143444134219900562480265421439944e-30');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 6 });
    T('921553120546680443171008695023439170379233255684062899262992193.794917224650781623583', '34776592716492405622044088435.4067262371762', '2.64992355076132660490737878527388874952228235144501129356105179745782042120074057971014066235636686580551171373518e+34');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 2 });
    T('0.000000000000001096563555410145551886745', '-13045975821369490557686183610', '-8.4053777994e-44');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 0 });
    T('-221260119049855126902502314167490585.20799122411762790676886491913916461096538682265', '1593466127202707486930181372092240602166083899835008909740648436940251311560988478236191', '-1.3885461088418119708264230587238319e-52');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 3 });
    T('21144017850052012114002430609072631261540111692934004274597.9268271743256176148636873010674646547207', '69525139905449724584797389144221440768597505', '304120464609013.16850543564659082427975287876469553');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 2 });
    T('-0.00000000000583266788198021', '0.0000000000000061025691356020273372684847905447', '-955.7725201264448788049473037983438124250855924615229');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 0 });
    T('-156663038406770648005174622303705622.7579041672395005235498789260', '-0.00000000000000000279640660545545434058450137348238079234837546590841727943835550147521988427900118849', '5.602298253091657872084698931378902499954041862670597788676126142104438506469e+52');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 0 });
    T('-10566951247364.13067143255962777017389679088649800105253368256681791614050139262091025457535223660042444759101038199584', '1487798968.81452848476368061577537587057227379428626', '-7102.4052770945457887313');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 3 });
    T('-4668.1', '119725391676743966273773855042970.28053142529825905284', '-3.899005828775045144018056878422920342348377535725165495259672533200529e-29');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 0 });
    T('55145840802614703675780118424602174215345069858293299936255447790771825169501037382715931054297849423823668684444190452788350', '-5109708972121238121337032349.891448492221030161628519862566339', '-1.07923643212348215319627390227472765176959299472361859473063017742967902546478586994945026310016152356068340783023191816582426745086395041456559937e+97');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 0 });
    T('-197225815302194313889667990513694164420673065787.084932500684', '81738452500743439114379636892702094715301199582161638069266331867043759961814861.28757610773710532695', '-3e-33');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 5 });
    T('338100639769773661810919487422094307.5336058', '-880545986717635548339964965154416822474394118319503023985079917', '-3.8396704416323949e-28');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 4 });
    T('-1662797505.65535176968783183655568367434611', '-581.960249598597596154667772484', '2857235.53593609354275465707353881349082806891990385315');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 3 });
    T('0.000160610077675684146304552027076418779474569051481519903465057107576282597616429863413312032', '-34060940888951667885141940759531275369588062486617036626790624.473751149557296807287327702821902987273566077309855776874103947410793018863211877420', '-4.715374076110186525798803e-66');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 0 });
    T('-207405485962595796054501054613781720814263441017518647041343154889940476237161034783864767115064779.34235138081465997406408488906217129281505944644784', '-0.00000000093303413425827094526096475567364786774471842617364847706513764924856542906038903595215249479094234074185548433373674778967214814', '2.2229142359028033154511990611173655293296336332206588038453748114511470584621308854680838501629883581745482679024467353488331250486413881244065e+107');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 6 });
    T('1477.22889187002425723777429417396550491538475837092', '1761.3', '0.8387');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 4 });
    T('34098317161560739433890908142909751278554.6930022877561086429320566396040491171871835072970338682888', '-37724261420227885.58215329250987023415665188141548153119211386522822083124724793770295346648801201311871412682289433', '-9.038829622593246661590439e+23');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 6 });
    T('50623519047580605172184984056336202404.3760583038771349760555077386002334157410700615188634691157835559775', '-0.00000000000000006139710831330702021319614773510605739787476066740813000994936327277523', '-8.24526112683528770106542983732390678768189877193258726520495343940809472671727076e+53');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 4 });
    T('10728.59', '5824163674089127623690504744435273553136', '1.84208250323217471512375284637258221177216212e-36');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 3 });
    T('-1.4', '-3813346210311479709541381781490830445870609120466', '3.6713162739179822524861e-49');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 2 });
    T('-4799217929592734484537517487908.36992727', '3.3934141944923', '-1.4142741364676708625668237899363022984645293725867854343852978917115114e+30');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 2 });
    T('0.000000000003576650362579233331081232620172381206846121159501556354149447107365', '-54512905937178594044728031220880675540771601222564092923', '0');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 2 });
    T('-8125372282301887408375220913379041960349929890.62455', '-1790460199295669106247191209704778284796248830123278272533504949.777383', '5e-18');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 1 });
    T('-765746835279349140819409189902608939522965225756855681984520198', '-0.2458823151440970935522013071618517432598781582118744011898171590155937054619264848359000725442111657566195240237628055', '3.1142818662277121288437132157877831416359946632925686448321076827434830094251546601195911606253987567029621850150409881252598708742138280652195860931073145758e+63');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 6 });
    T('81965007161658.0547343638301154851084560488552', '-0.000000000000004261559354294540140114492951839225329005337277856986267793697637058674710822403261836354253969282946127380963265117', '-1.923357164533182185195153252080481961629834669817308e+28');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 5 });
    T('-0.000000000000000000065889933115566879895515836698319434467360644777858211720588117831158517205383027852887070850900716340952465033158953134', '-0.00000000000000007908737871894736179930044739134129252658812997987977029914237397560831585918570996834124936441532405901393160446609993', '0.0008331282966112682229331');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 4 });
    T('0.0000000000458887', '-0.00000000000007920739464409770182', '-579.348685892163588470293269827812483800348640005621965767695626614309958240238636967681609128');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 2 });
    T('-0.0000000037666515796183731842937900251875355', '-3275441302599371054338586817042216323073127784053613466464433018.537786728515034048117509170969225078859247721', '1.1499677e-72');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 2 });
    T('83.39662443568', '-0.00000000000000002003152279999036168607346445798938073488008467463259124348624491238949667009462878406718904207439173283600253638482948274209051576357898888377243147402', '-4163269326469784259.074364130103393795783206135919553720762453192372920347086091930230269553807323');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 6 });
    T('-0.00000330', '109434048584872145809570196046154298805745503330569166951015891452732202220587810005.98717361588303691003203719491658892592695834034237414897181323', '0');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 2 });
    T('661510957981362354.675586031673491649623307368815700089', '-6132046439808977110693422347539910465597.524926496445313468843607211615349406925814780881225164808283588825422222481814130200680430', '-1.0787768234872817780707108935091697973540974676747895321936128e-22');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 1 });
    T('240645477863953208383256180378821461697005668395222275831882459357397472109203767724881575267577033502461473493422161508786793834549218188', '179.633068890179035550126501837996890817635942524483', '1.339650206672552513732915483211084687492828115679933306207775936177308128834624497824175070285464372582119837653218399512382664275446656108624090174313226738623291795409543341109107394925580009120035261319741987854221053573864750278e+135');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 2 });
    T('-766365170984667044870484337547371150484988429808969008514795576128048891668669105924989237341486385915120644587680287103858354', '2445751367297732436141052279257892687788556037231498276997324552712597131221011195516437849402580435388649388861322697306622577156219766103731', '-3.13345494244335396303e-16');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 4 });
    T('-18058842314368683976478687652768663959807272264111648002186418.202272100393867', '-0.0000000231279891873873831524846024981', '7.8082198015800234109110710756825533282836360892482051132376093488274557258e+68');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 5 });
    T('-11711339209668773344982626987099295880675887894380080989641832695807303807116201', '0.000000000000604980060637221761498279329982314575639688591904703076944583644618268838055262788114307046405084556659222251998944445759115019204243245798541095876396', '-1.935822347158564545902799821915818258071805920079266430341870600078973567248346441460842317610956938785440088712560444671603373719507540064391699452526437e+91');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 3 });
    T('-0.000028154022631163645234323579837517742974', '763714225', '-3.68646042060610370775e-14');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 2 });
    T('21062233519542444965824728279914.653213795455323072654677744778683570844371223391434996821852872307725640641729538169125085230104549811712864738905143', '0.000000171703083251092985870323746701708482113299956795635958844911266243301132752', '1.2266660051026411667366702282614551559014534199266716754244013766513719984823303199747701978506983918117786457e+38');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 0 });
    T('-121257486105813564310134681312053320611077676259088875416194.47153110485053263404554085813496448318', '-4084791526573552732873599473516219634802268496638841468581734356', '0.00002968511007648119281280433886543605');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 2 });
    T('0.000000164578657788588019000116202176232404908041728145', '63119865.4177618888922134116051365657910248178312341961601', '2.60739874363350103433523981000588299516706471965550343854536e-15');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 4 });
    T('0.00000000000000006596271466668487', '-539419239.136', '-1.2228469042435127550630100260688526099356201e-25');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 6 });
    T('-0.00000000000000199788581510442427115087092276680447460565666179306750837088275882162058969391398191642075728411841395624008869134397568404721265572447381', '-0.002028577018227795', '9.848705753601688878231692808052534233554172889775981022319906806336915094632912895e-13');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 2 });
    T('-9887034207993526508563691608159867317275531523.01396873087646480937106267730699598450248258523176444512402264482606024599663403761737647463303159', '8772920062368017041328549154681563574802.98973126923491698447317067300819744100491915062397666591201700', '-1126994.6765392940225916166969206228895948211119254973175');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 5 });
    T('34648817936384012285095138.9033284237027691083719295724088752091659041134562734817206655068482823303472564684527417382649419001003061975214289', '0.00000000000073129840984615009847770183025645601294694470', '4.7379862269457688865194244036393170482427099288471334761305588440042180924511828827769256776661666757793969933190342816957e+37');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 5 });
    T('-410236615838101179461003106082923506552161864023253078619.42383715734657498731871501341149044489675184080204634673208', '-16700539039984360840000288381875688192758730134701984438502896.059622768667942635184286', '0.00002456427393486607747670324');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 5 });
    T('-0.0000000000008261580047417753196019777820265960458240724510855824773446269060589966697084218488066759878381989061', '1472567393186391365433240354050309702841455502933514845209507757008252424524630725988331270495257462495809930443112514286386727777534106903540357537840', '0');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 0 });
    T('-0.0000000000010133051516043563571444092178778617007841179', '2841.631237610061318204026527525461909600878371', '-1e-9');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 5 });
    T('0.000434746683110784676350512124273115131526691635488621245898351568418905144524240538757666', '-72.754939209315378716529155446322462548155056', '-0.0000059754937305359013925521167107');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 4 });
    T('0.00000000000000000854651118154424773615696011872928173942382083706149187646457857355809608100811648271879534541972313644107157431654992339085547463379527', '22', '3.88477781e-19');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 5 });
    T('-0.00000394892074850948987873089825542954517462502155991604329884199934813459956719272328729708509121706336173939287967480', '322144987032878601907718372304451697.01159', '0');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 4 });
    T('208859709030919022668026840603676129671468435.33607886149686015823', '0.01889073200221273425874122349502352549427956172837681307889380375053438909209797825161457166530112944290616595', '1.1056199887143314002138931452389730341497907319575118366203107346836990822658147120643404038323533401588660264603730440281486699288371e+46');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 6 });
    T('-2587030969033635395116299220693238227817249983119048917425686389.9938', '9002647902.166073', '-2.87363339891498524938146402047434581585175314551744655959347825635385293396011197036576520825766337679980778948659204e+53');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 3 });
    T('10942687.37267270972749191', '1223028609417510798257150450863710728400112574753822913624040596375380.636103063240116883753619541538711824386875697240375421870207137471575150', '0');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 1 });
    T('-0.000000000000727175557022683250030094239938027469890979345925006324236384264240507152468370259771726832762008917826728798232836587230180549086738583336336196136', '-99692702089561102666910827430004445013.4633346742701326', '7.29417040346051916273494433969764735713e-51');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 6 });
    T('-0.000435854665924446274149989727822707565279192689899987869618794982461629756411792802473', '-21479980655764289345477008567297503725301337815770106747360860697561555706454247768461577', '0');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 1 });
    T('0.0003661424946181228662544929843135642461', '-35541723023331275234931465000.3434160778574144692609693947', '0');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 2 });
    T('29511043086232682578298902433029441912767122483715484336528860737562383987162415257', '0.00000000000000046991515004893762897688645593294701223251163738620756601403640138', '6.2800790915464974417238635529785551698938085918374781178739742809295933496204542846776626640063091485312691640142866673025483528632260971e+97');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 0 });
    T('-629.54486', '-3804390832054237197732585520105512857086714514451063674129724348813938242029720919803496627174331383149317667508624916115174380162610.4', '1e-12');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 4 });
    T('-0.00092138581743579282981369074351185363008543791080560303477', '-0.000230991881481976', '3.98882337995799814468394510251061380533');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 1 });
    T('-23033476615970509548342', '6667695578819.681810038616467102328949290169', '-3454488337.64061930527858389624314516095365835459827');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 0 });
    T('-17609583262089829349614527901463987025975160200151.4820645710897030443374385465092892', '16870249287558515727103701322636559681739080746456750537410713485304497780078664815867842085135794504652737821295544703167229966788.07959249777', '-1.04382473e-81');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 6 });
    T('1349754860300394469926085895424254955915398031581010550799071969866756394839212719635286006491', '13412861067171333299.84177303429285692571286631558385009295979180821715177980990983167100956466924033094092553925260547177604110713037231783105431476', '1.00631390539337565310018357332892955002994225647946004870372436649442631607699915701e+74');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 3 });
    T('-6186799896.21170397141881093515171173147157756732289393211637798253167', '893.091', '-6927401.45876702818796607617269876387901297579678094833798165918427');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 3 });
    T('214744420800036091723235327386836286091072499.82497486682144788792915901591597911', '-715116823112325737.2466174071298635872411470704596237300360657750552662790180883559706657', '-3.002927827448208186141147717660718139667684913298399093948689796248917476883191412928e+26');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 2 });
    T('10784824161.537439230227463899676', '-11262180156432062747048177456745766565363391724436692706657204194840723282194660736622526420015840791431252480525869816968701138773587059519556961', '0');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 3 });
    T('1065475535010405771216088743120999368', '78256467309231123490607919376895818.6878352116648506364836670768071490932035482239738554', '13.615175481921126856133686342327097687306334430228791860260596510008956841778876892927993075408915');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 5 });
    T('-4720967076711694069198987.566', '-26730767756103443137829904940659855284477689929810503207977148998370094841105845647981234', '0');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 0 });
    T('-4142076414964352827467635184212322570640153530421111422699654544405985173134941479224380826617774348813350115902374014129112579647', '-1123920.836060533', '3.68538092903659423188259410965646827940853170201720041177477321176740140646972165385369647666630547277380365846243405462714106940736106225684761023365016040126731384881104356605229898933571882395330993973105263208971e+123');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 1 });
    T('-9012546797305778913749072705664218779598777693194018397051301720249575705315186211819737108442078207855.95097311271066311789437126035831079152248451', '-221696431298318943617594310436493479484437358300747895944247886573964283577260576.230554488', '4.0652647155958609721257535779485826311570413278384982152932483257957600446920806933441382642212114e+22');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 4 });
    T('0.00000000002538387070543995416405436499183653403597088747366207520144542550245681558184831091988077404423487890839376340304725844427690', '14562891408915478681.421127181921914449589980053944489651677113447812731103604100978570606466', '0');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 4 });
    T('0.0000001139087102258881402161089659878951562048252365503155737106113169695', '112999330291096081712666114036319726856888730969', '0');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('0.0017737339683220256362258495322853553726', '344311488386394946670123243419052980555279569441.2581092289564252509313088826893414', '5.151538732078254393229534399097e-51');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 3 });
    T('-230601295798682631284071108851165376367326185083060912813945409971432014125737.67610944055117004937', '2759980627394.674745824644987752843648703444381939763379508829430416469000302357857891571669', '-8.35517805849101902114638182220772719501729983601164872340485404304496519183873969e+64');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 5 });
    T('-842570312246603784256854878768113013090390680.4800826', '1835117010332854583781870084893679257611413400275028539694753574598984870187.174117913536', '0');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 6 });
    T('-0.00000000000100684943301409650686603204274713', '-31144152.5321601643531272794334628', '0');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 2 });
    T('-0.026503227279838553113169386052389485374661223774285251294146269277263514377060436706297988370', '-71045451218274393350706888.0027862323455368609062085008505902080395372345116114084151338799957479745433746186733925305567951229335217540', '1e-18');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 5 });
    T('-110419631346006605487521542409376009922843127021.32729252503643353043', '244333847708274713267176368482599559622993490167843827', '-4.51921141428769337154851414365744921974137172e-7');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 4 });
    T('138893.800038647216078219578724974257662781528220275806760809453342527939336259698744105819334031462550443269', '0.000000000000000006348171111337101567342719021981976900938596754527204884080611802666618593', '2.187934093184711195124371794142911460872e+22');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 4 });
    T('-0.583518556009536368891167105653', '-10441784574938354731049901890211616945183846927326453960214418739234414890916007304010255785348300872046501133.6', '0');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('-7.7538588120693509533017285566489706570750381485420112364801121058765556097495024175321672371025233059644071513855874611523627', '-305644204.4597562604754745015566044566739234835770195994902485', '2.536891e-8');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 2 });
    T('31789997685790129513765060203181448380957005660036613335.44368544620228705185948716548766405754804498731108711764', '-52434089730.1286441452387', '-6.06284915966102621783408308497372568922152725e+44');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 2 });
    T('569876777333896496210397829911575985990203658453376498274111925946243606155.0604438014870819666635730795627745086491091661201979151197', '199620035528203630659934347139027630264446304681', '2.8548075138148172480690662079981736361263912869268405656928082643654167528071203766793714948500869935874115843576114943669e+27');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 4 });
    T('464203469483216305594181907657494380404.0131577756200', '2048.0377607488', '2.266576712499163303328179649892198707410967454841685911989506281906764109714566510065582e+35');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 4 });
    T('1047446033974859.93', '-610168529437812151818980787637.081958441810504970300511542324279', '-1.7166503735286706929530210967953340945869136079522966136115448125308e-15');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 5 });
    T('-118.33066509', '-9606875158.2747354159409455217', '1.2317289768055087728278381056836e-8');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 2 });
    T('-38916180536707971109723954801032296697.305', '-2761.28', '1.409352928232847487749303033413210420432009792559972186811913315563796500173832425541777727e+34');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 1 });
    T('0.000000000000000025459344835883054040696405051913272865874831295085304164847010428416894706100600297496207917376', '-0.000000000000082408868083455992459669242206585971307278856656421299962183', '-0.000308939382714251228962409534148751406407122642268738288023');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 4 });
    T('1608.221', '7042457108573780622242600547019826545691513759236748675875889745320169815672519884725638137576300515921692993080878948', '0');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 1 });
    T('0.000000000005815702621450130899297250913060333774296826828362981337889656145076977693211768352238805403527766702548620501917360720005422693391397563666452561', '-0.0000410389771294771', '-1.417116e-7');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 2 });
    T('-11283729679337191958753450479886227801706907034479328160816332391375318739208071063224069992461362595601882', '12969.8423904513102281564841724235620506702074460180022088158788721958927648069337750397204515848010713511642997', '-8.6999744018821135539847925790643947979489690032352266720739413327073294318035168762931945901643780530767800577835469292594593782001806376e+101');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 2 });
    T('963562926172000437989222165501001948619777097693976.019152224055600155732251799412248644709320568223', '412176.45445765048731626271608246638', '2.337743739971451343920642558467838059208364280737481450784483438693973819066391311731602887641315626777957478045350411084e+45');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 1 });
    T('188017317881037467142744350440647251727837092834115555212.61169097805664040953502697463903428907436616545320956525738548268521889', '0.03430362603533945933717', '5.48097503416527374671169477464124580416386360623089291577202404593e+57');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 6 });
    T('-77688889373197281303709368144116728208944181866527.194329986257499976867357688522213395034508535505986832056929680', '408619346377674.710100303477364202860289496630069330695596842055267', '-1.901253331784045075849928931814210121717387026383480878918888601880392000146415858910823265784124031638153758876778e+35');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 2 });
    T('-0.000598131376898130173273368371', '-33834310680426732.864137084262872986652328820914', '1.76782492348558845634046504235670092482442601e-20');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 2 });
    T('10.07882789313470526436392', '-0.00000025401734936054768178518709450341982916789030441578045976075113', '-39677714.60692236908709650312064312268828912885512989366573740586526');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 2 });
    T('-25761367516448895365422437716902', '-7294379443336532687174200876161368710123746577153289824016319241010661.65837654623', '1e-38');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 4 });
    T('35771326681716.57241202022647225590857673709935880130954808350655811207', '349118337811509482840869951583553281668788032940835136131494252501238463766250167', '0');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 1 });
    T('-0.09624422709388953184652715019078120429546513', '5170531470626723240558594459627185589778150939979586184270820777476797.5956769453369948985727876109875514210900', '0');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 4 });
    T('0.000057884266097199895462680021752066848854688228217', '-4761853299294789852.955408629409', '-1.215582725023728e-23');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 5 });
    T('20728450374669601887839.552320873488315014522133858670895309037684623025097732', '1132688096327184110103004437024774873963.26815201444568485699742053281035020679063787648576003176844763889605228900976272254054879', '1.83002279637995401752873042212819846136694755879267663e-17');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 2 });
    T('0.000000000086774370372564903480577294114866314088427466069062376707737298079241239', '0.000338137223353011131111513637077704972150', '2.566247203194589454868423478287602357042300504761582701917771480785000084144e-7');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('2983534726729756.75814502398727035291', '232407189512289916975300.944276368684577331714804764466', '1.2837531975e-8');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 2 });
    T('-57415411067167602331063928.20050398168346262738205597292826088263171232118273941933890', '6310863991456586.974151639438526476457', '-9097868555.69925941317721185720709058423706826912790945475135548324');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 5 });
    T('-0.00000015775728458726498306773317209748308498729981829072132370543723712809732386345160025746366490983542448171', '19242719862', '-8.19828411568781289925e-18');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 5 });
    T('11552994563085256986187084346.142302277913480048628672763423906524750187841526866411217768', '-20.5', '-5.63560710394402779814004114445965965e+26');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 2 });
    T('812144110944150119838381673295335582060267859298353045809434439357', '0.0000000000000000031349423794202464326668987343219568331222224557022625230990', '2.590618941756569628392306103273989328011790305545243608100444916082914443451931168413483853055477086e+83');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 1 });
    T('9614489376768900692760895.527073066530251785421855330349', '-32601067987574457100555933941600938282851621206745972.05932516695823657436199460272778', '-2.94913325552198439358718281779388167358864451629725021092083494e-28');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 0 });
    T('-11583534251297278', '-7883365928383773610465677991775637448155254748377729591041178141612700383829044484308620681465778556959039879269907314046', '1e-95');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 5 });
    T('223612641244955642904353401755577586252256232079489239167850500206850757881664490453712619388439.9866968252386670188226025069540843', '-60481932676102623838187954032557013742871278087143283642052995554284640962756152740.025029', '-3697180816665.74394403322603085612547303191221613672256862205285142592077737141641318238108646439426145');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 4 });
    T('-350.349', '3', '-116.783');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 4 });
    T('-0.0000000078925715817074841568218505489212637237837850245467046523569515632845796706869299872723194727515353882743977331', '2', '-3.94628579085374207841092527446063186e-9');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 3 });
    T('95368714741420394016083342043033.00784372549234384294358546454', '3585012151550330759303021666823107542630331906734992426474705980905403008440453961.7841322904181', '0');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 1 });
    T('-2485620832769956808425209188746139311251888822574439855533201630539287597598325860653.28414365674', '241.3782617750', '-1.02976167550950407386792492314364679132750326251886020962427722766265976338801806778951983513045579433475477474984812144647817260966767934212413813791538146476073653049654371e+82');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 0 });
    T('-39833308190442209260.09353105836552704367203454209099943130776671246082562477353686588645', '-4562390593', '8730797457.7095155912474');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('0.00000000000000509749647074186006528231614714908640308021420659866055767456046470814261818879186939103185920091216299799980890886608080876743163190', '923912437853859095256023537649611274', '0');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 6 });
    T('-0.00000000000000000061303283331263000157056558184702117427444976518223689103457982927186788642884636448192218746034798482034003261983960690948357701483527632814588196145', '1.349016634998595471349205316201900685818511461958790386', '-4.54429409844355448e-19');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 2 });
    T('-0.000000001125145029887940635965123902335679328124477202368746008308468242235158851466733207', '-149242808842832237.51452433265921089167595693212751981437458634433350017668814156835361282628', '7.5390234116595331363755680397164907341667188430847036e-27');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 0 });
    T('-1067698823499635663628797160629920191921919332668840833079974729.4592792194147191454910492415227008133926462', '2986573924530388563776047596678868501.078041067258658328747831898425248466411204698171209735', '-3.574995464636026175354026069188351714579231839156305431953167715148767959230683015424161196084094280821534908951785386901092e+26');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 3 });
    T('-131558573136380341351526263881272015691105162167477.43641577', '-21028836019557051563771351115247425946031595498611415211335954724493007138746037794.5902422656034786549274717494663973261907892978493002913117916917673', '0');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 0 });
    T('484912688854430445901238078539.9327388805215', '7675343013.208368630074287849959404386587228380884784634212253665072295641059597176646', '63177982797635540171.37420635');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 2 });
    T('-12489030880907701606924229137856109508824645513538011.4866636311446461213479265402263844866290245240119778', '0.000000000012635859212', '-9.8838002793250032983386085687388628280520964651738883956976705389443692924287230705055806133213539416395010717059895016500441837939654942081353731372992445e+62');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 2 });
    T('0.0000000000000068486422494524596969719924543', '-0.0000000000000000860530227743174154892543321017696403856276705035877305470475366175730095253824587965', '-79.5');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 5 });
    T('-7583869705359432525760481762644610763035183738780200118821468808036843413330936716113850064916779065729143081765539679358825051304836745850.6', '-0.0000006055982309374903162654476366299493807077266080677782248313129886619903156891521074690993808095640197564654707619837534400871511071579', '1.2522939001356226686471860751979813853162302842384027385533502758473626983036115201672725792177064268800542320082925102987771543970384192138191248037631285529883852e+145');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 6 });
    T('-2324158705657062571504768932244003687791982053032086887435609400349623234.8847490173933459569044283100698303779486', '7947361216056610348892930352280110458365416285971299474457628074690297636141245156892456233813439323211882813717047908148127893604121840938', '-2.92444075772144595364474e-67');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 0 });
    T('330860553574997611420845241615411032271.580685318332472617576015516495972857272447322507213797761155935319903525405236867', '0.00000000278434864148915656819429165228781824741971614143838388587', '1.18828708677101248141214779984169455306527259694791290514596002265144928984957405e+47');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('-0.0000000000000000121020668919213362550711754611616886638', '-0.000000000000000049375156639', '0.24510437466364');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 2 });
    T('-394802176170946185383623287716098305655356865182282630086828.5964628406385145629597276869513411714693556446431818475220471434691425179044277034838', '-0.00000000026746586998637309623288792', '1.476084317565679106389290357424595824168694787489557585159991218711391385243481240043321664965214926198007610749846626169138875626812596915597784301572627506e+69');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 0 });
    T('10.4', '-61109341288178920361559650208577059902457327675126037235513424500323768453228146026659.5878105570337704702103', '-1e-25');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 5 });
    T('-16361357720439859515991210103353300934432258144405930670633090423823', '385748.287755599110761', '-4.241459583822190406083003028241023712304490745393782567275050213693077008095405973640051052432256215016050136707300274703155e+61');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 1 });
    T('-86705405.255842516299401932228291720865', '56640479994980166550590540661976482821130455927516362968094944322340974875957471148423417325066529533995371.3462406278132009081978405932425088209056', '0');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 1 });
    T('-0.000000000000000094914', '-137839741941703276714729.323085324892718177', '0');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 3 });
    T('60455124150058896265786012923520033281598.78998030686', '0.0021523827516723502651678484010701159886163599243977186686131893032242096226863503971597799739241221486460582591097338509479887173743585631534', '2.80875342004514303962666735157334054635296243757109157067891469696250405517688687660013099745158145798413670468674921462694333819e+43');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 3 });
    T('-5919427358277736121036355510363929980734158554498206', '-0.00050337563645548537163555889565612', '1.1759463370057649309214690061769196099262493416877295782378711895907257439993109937747833453695247307759245320841939666397716819524e+55');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 4 });
    T('0.0000000729423656823523161763149207076345620182644168427894042787797012912731740507538998522001444213', '-7257094262641984828367782787823231874022685970775.12563012911815916459640884557517', '0');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 6 });
    T('41454575815121550945249311651184611690694.79913841331976343412188746472269', '-3200381443148112294922788210421014186475008201856838957.897657078709224585556728313319365060099241381051762595', '-1.29530109305795805322575761019374322e-14');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 5 });
    T('0.0038649725946740304936644001354450316452925391', '873644820559845353883954013774352313795619130308608659936964087919658936.3765726', '0');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 1 });
    T('-39380858140905900403039619284673213946855305695.49283157048331780783', '0.0000025661629', '-1.5346203524688904357178423585140761697885705422478374841473749701482318211365303e+52');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 4 });
    T('1819197663957471386300657897690721503401952356057608245592494045176595405462249961528464032031032015078641', '-6657150166644585302700536.2593980027370484802132928884784544640921459772735357204016065961305999', '-2.732697353099373860882510376433695374553785919029713342177411174901743822440081364060822427039104225620224778168e+80');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 4 });
    T('-437210.0040882405119137212856092357997132509560463755042436533856183328172199610437076429802232051886233820671923098242562931012214927104557786295', '-0.000000078910911692107846719217617946420187723860855364977370954912695662426156352492348548312315002258612', '5540551930183.407030727075237');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 0 });
    T('372890080685858653791897049490719597078914761123261687954344045467510', '83858134146406399034530033386323890867261870710050374409850683224382501969089447382261002756360912920886906350.392630718449167908115', '1e-18');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 0 });
    T('12012.987358266093130258964056', '0.00000000000001474962686582364625240831800934374536576500883104176098826397051575455266411752404100168850259065089232372355634', '814460424493949790.091156618252295069546');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 3 });
    T('-41414660318908334595689654490453470.7564694125513827283706590498180415906833323210401065562381722595732070094746258542216964188761695276', '2145398530225886920232708565246589418530838144185820004.68', '-1e-7');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 5 });
    T('-1130924704242056012035837690878098284338180004218796434072.66974326603183473779429828776647877764258010306835905546', '-265757117331641918530768430756590909287777877780654167947006623461453966259037320614699138149641422190822683223340030806919', '0');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 1 });
    T('-4588.1925442043', '863447601549324043065532673831998405845285228974578665227645766290170863.2030322709793216613222988785114827410963651195713781145023', '-5.313e-69');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('-0.000004509022482841480424627317183136893777310912377293389091294708900407185726477457642860649845324817864813234873826655348443838', '-89614218054668846271654743413464030769218741689857702835170614842564565478.587308139851769991297516306392988850870848647896160655995714431207976872', '0');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 4 });
    T('-2410.41', '2892050006077318614173832.836587226318414081034320363', '0');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 6 });
    T('-0.0000000000000045621481849548325001418900905909585251735259336553615288352493594048801397', '0.00000000000495380040070865399628832449529636589128087028242937324760231897728877786675113319670285338494203209262776532652', '-0.00092093903991412439006804009722438948506568506335922341009');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 1 });
    T('1889965641287467460605353585809007676852655515492287271970671.92', '-872540642268987950148.40330774513868729000074986271252895505805', '-2.16604883455368767186597041313318871847793456249174819460223460987219195e+39');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 1 });
    T('453168756013294702791780936116383819338712265758', '-0.00000000000000000001703576853626528442876796272592863047189717967103246543141068505181358950127191381821131519024957914097587584926194882458231864219623435762974766946', '-2.660101627047827526234592323586601021537755776148906617805742448861452674889193803229068376798406303532428574864840806318986515350355248e+67');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 0 });
    T('0.281191748267215900387851412002796180529424194708369219618787534241641927302840921591590699686487262437912311492191253047679223717038629398067060', '-736823256514559562094254.92461890400692007068515177306', '-3.8162713484011694793905318647490767069533087178909746e-25');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 1 });
    T('3840619393321571903696669805269490076853531507895686473256344089016810829967129561480080890216396664625065300119841824271269406520025', '102172.78', '3.7589457713899650216982153223877142981266943190698016372426629568235403108020840398784107569710804234014825671963137581959396685888599683790535992071469524466301102896485737199281452457298313699597877242842956803172038580138467e+127');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 3 });
    T('1892247491641900606228794628270696213035658424492967998934163234332192991517343447153747403277987998711948422992.8183708552424749795191945092', '-244505466618807008712853320517611846387936179619142959452870395575986399.050340202551610512633848260213360590087334138150506', '-7.7390805114062494814637570263377044612370608350798535119814354463968478114343712347541731534774816203430823292900983341989240167e+39');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 2 });
    T('2295381812038943850502.324', '-253779137094126721187776702581.895891744352896517020905474133325281', '-9.0448010751474278262007767239558082785217770867577559e-9');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 1 });
    T('-5695943614.77072609944987', '-176532479661877276147.9912373264637178949262666646514566005927690534500079605735234199101141069403355519979895408614', '3.226569765337512e-11');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 5 });
    T('-27584738609667485013722216661.8421350233359390210635886470920620796816370800366533139814805753573380984948', '4313107568442504734715067084549266805421558688193581510035', '0');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 4 });
    T('-2555742210398264587305957454082174995014909.3900530099814369606374837', '-0.00001440', '1.77482097944323929674024823200151041320479818753681248710900044269701388888888888888888888888888888888888888888888888888888888888888888888888889e+47');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 0 });
    T('0.000000000000314944695132472241453869823257342603122172592363685042887405988618869983581296798806139236459037902793571160951361312344558248775', '-4325.4336', '-7.28122829425638e-17');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 5 });
    T('2372983283183260603073328946737270500842645483514847068961453233913956606640900074365120698178842980420863', '4.264390312970053218050821223418104420963791650352392308523490460052', '5.5646484234003674193443140692245726820653101384942591564293156359613261141751452349867413237846987898668588317611130126820465847686933141838e+104');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 4 });
    T('-4929737321564416946794444595100034584584275413658668225267555783372750233317098821588418499', '28424.5505500279699822525350080435474958567777045000729250347252638401490401918318893925377023852720881450800154637429835312060509335334460', '-1.734323753998483556086516853465012393861506598300167231474336706569606213704384969174734553709154637e+86');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 6 });
    T('-21761034747572684690940063300423799039711372853154062067483292390919972513.128461864192183766012455023397983865176796343513765704515560', '-0.000000000000000370518717601007734760218875634135874385738169288508545052430993920619674833347596206435018730919635286496687530863892283219235', '5.873126974115787328556301649295695597865740591759543814911655466898584785840651110993004783773323892447812676985881696237e+88');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 1 });
    T('-0.0000000000529128815853925126111888246377363492558042670403782845160556805724033452691946651390343077935752291223303254497743198268934438129373549547732', '190796845584739495286083824726789854300125556149509941677391175737424747877187365711691200873797144752399737466401564047525537368619366814232389026', '0');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 5 });
    T('0.1738288617078757424969996650252925445723904180162162644658038108320637527055349684164347129085119473', '40150435051330116187710586057442183955103686265758761407957348994528421914113', '0');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 3 });
    T('-2818021876.06049744914273', '-0.000000001255994176045901959662683145025352204805973683344595325551280381851348919327804825422941616667063462747364903546976156151893968477515151694091036435671', '2243658394127385772.2399616417668729072667716977061852452476766052844368573039742148337572714669721107189733096726223487');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 4 });
    T('-0.0000000000000000000798739998076872124738417560415802504246249107273298126348402299690351215611460652085120914256051181363877348346676552311861855515', '46182994916067780015766084495323699010504604.09567815372129601618556544089749998205672086702635417005840603957254140819968739', '-1.7295110452e-63');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 1 });
    T('-0.00000000000018278570237602871909777071990589057201', '2533783600.22686301', '-7.213942909712690186846064e-23');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 3 });
    T('-23635856566188883656725779.261087946565827087612147083445053753', '-0.000015983055409', '1.478807146778682837808197406411678327043900671754661965274912036688916918213256505141106590528994893256707723148455738423073873e+30');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 4 });
    T('9675925041663.288671218488108323029451158936618138578', '0.00000000000000019145059354550346438348756476', '5.0540062908520263838834301351259547717147667612660420461717525400109588153798536731552786867471188611602627e+28');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('27530734744572553145811394409155751285114981369827827050606790395212699176195816502875540648483743', '10018638440069269682362497.5296', '2.74795172111053878923517565227297764074667648991325127688577578258955262100838901555647e+72');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 0 });
    T('1753543712820093784913450707262591849304835890313674574592777278930623364571260530603857542.4236', '-418723139520592512428', '-4.1878357017187384892049546833395312659786498094293034760966309470263223675167624157719477e+69');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 5 });
    T('-183691591904659333.339525462569802158358640667215860831779055844371698407987', '5571790194707557578583124091999072068420790617488114407485574879343772879636.5578258978128192695105710627695803', '-3.2968145871526416609414243846e-59');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 2 });
    T('-1339912.18', '3181724877175664388202135340557380053309.6372658165999319399125323931357918678887932697638825057102937395296864993629927588640544725548279185663', '-4.21127605850511403837900068294021511687794e-34');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 0 });
    T('28291.7789788', '164513902542210734619823233869308585615437864478107318378622012226.0637862143099668913711386819475125439510804551009962207503163661950620', '1e-50');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 2 });
    T('4352123217.5125039454242550283437', '-8.5571089855709125117416994669008071143304642667730834779287190411862924930833429021927127165224334637039644012852088175', '-508597380.8269942628609');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 0 });
    T('0.00000017280194538643380427938241203330369357202306777699418921781472580047363492702741507862927802298171165219765', '70198248850625050655990271091780809131279636646410342739025918526822476835014657892897365995822005281543632450103200002855646347949575', '1e-8');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 0 });
    T('0.000000000000000462366653119210200754101536012131893385', '0.000000000000000060263928158724437406735', '7.67236169');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 5 });
    T('-18261.2123919216000349573172534364099590430911319328288424188440187724443811421013387223457238536215926225022443140045861926293507393814035703', '-140319509983436944302669669.22959469450941740188', '1.301402235090267903971468121955525131756831209565e-22');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 5 });
    T('-472475346818122468757665022906424104282086514700546139294778422104033911157201097185232.9356094878445129096993717075115024401337423343569832676', '-0.0000000000000004866153002299724920226970875', '9.709422342347897066545280432474293134156576409161562172783895377093807646331921987845386179891007510935026172502905186314192871935707338193e+101');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 0 });
    T('-18391179105879192585113220019333608029947244529.44652382528440055358228582356376', '-131856.225044', '1.39479035591547649867005698253422296192664877953007294083780114392748319544889397068851823484029819348329500170913447525741073725321e+41');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 2 });
    T('6450896314113636045.47096019696529028907229538', '-431908.8200970344', '-14935782771614.5072603449252406146201767873137666360901845966631813');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 0 });
    T('0.12205908631751491295961258226918082044380232821819630409', '256278517003835644401361472618.144928103006342169734856778810127134997704942359589946928195523242347769590471009525560528282944606865058637605240700', '1e-27');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 0 });
    T('0.0000000000000000406425098059398281508518444917684297358996203687406103075406950878391785627772387778578061805193849419781', '6197978318930058354121079353391.356270123951020905563904056655371685259878584579853787609139742190928595107285545069512308177337377747424', '6.5573817323316877872201363880688482034050776e-48');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 6 });
    T('0.0000000038480677023934917705398182426209', '-6669689628206425960506958408211403952828561513641383982126683688644654333164720823552653985031621158.891769852084720550', '0');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 6 });
    T('-6', '-6793365827756549193323796860313499.15', '8.83214617338140399504359557075447443839092597350907e-34');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 6 });
    T('1408518677090.220167896131480891051094648589004373065909215871954', '1911711346095095923944902803491781359370106605817791906518095.504218912499767051381623040172453209730092773055639822964346295', '0');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 5 });
    T('-132797007578088940349926211760241414803647402421376896348997.23792892159645', '-1701611827927775516564614973063779810105086000983882827308815123378.912703618670806447441030040099430523', '7.80418926329451182750361401585051547668455844772811334047553570784185e-8');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 5 });
    T('-590884861242163293617093.7024642253223740276992787995660007437880', '-0.000001042308695399276450393851409116010874384694561153002962237741039042501567066057521316448629055624780547030086947926312392019625361821', '5.669000593109447774561219009958841393772088394420613441914214578498439067447745711711104172222799598120242237250785925636e+29');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 1 });
    T('-1447472364909393408577030447805951858384942637', '-54508619973776022181790674.1711738879483079027661870', '26554925910906737257.865651374015548');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 3 });
    T('-1698282253323721125622279589.08132160264778', '-36588616017.336159354547769118704090', '46415591464816625.89950467791588764198225854888984659204128685329179391195181112277308784235988205647130513265');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 6 });
    T('-0.0000000001728346681414185953835115837332393528661230771657299247831783196382015218634433005619336173179480399892092671637927785667244664', '1383965881.8', '-1.2488361918e-19');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 5 });
    T('-4200.655301241575', '-0.000000000003291749081743256944461923783605118923797595707726863855985331722143509605373389325015410154615732', '1276116495190750.09745770589788051603719885202408563');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 2 });
    T('877038807529.783172486', '-0.000029209862891093207595413365024177509128219463737317144089467908137420440648512427860174664', '-30025433902232162.7');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 1 });
    T('-4.6408633251187', '286479092605471083193073918698008180482239006030252783557309183848433607004260792891230391548122.7823829749544423447444227336', '0');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 6 });
    T('-420332834811837519083151310779822.674520517011425285434915490010798556682722514686372849111363615703534', '-119372093809512401458364321778161263935763724902835.69976360734010871610858783314726459546649469292009', '3.52119847610767522253039707960588498792e-18');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 4 });
    T('-503265559715361658183921070977047895861177537026026456.109010394162', '0.0000193627364272292518121424322', '-2.5991448140957699129320512332375913453644658627723198493046925506570999856031259401970274657799e+58');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 6 });
    T('-718740639593637440650569998843587880832228790327991524480269330285905900765.7553786602112662963770525293', '-0.0000000223532388156215347002372187473397195850067720560979370528409860479426378092382492968866513342888989186813893183200510613958831588511668595170632436', '3.215375836683435729143752908778275268383734423571405894740894706182122467630835805745819338225351859e+82');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 0 });
    T('15919129.761571574442700544984542588386223768822496273633714907581964890531644168371312042732204', '-11391106082802056.177820844865101395010096479188135272401778080252913008122776891526790', '-1.39751e-9');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 1 });
    T('0.0000085600717551026795869429429343722866818966395448334155574126290636650121748943963191466064495151249911159090570604721962959493346606872796618273', '-20281610814854557999097269', '0');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 5 });
    T('131977712013758710275585422995136772245460579344.8993481134', '-212818196441274972834262534532930203096181143190471914219945641669731308697988948532275323902939404240614', '-6.20143e-58');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 0 });
    T('0.00000000070676459140821697142817934837622264413789864469815713676245717459192837442971756953392484226804353805992171088', '294614725303407521512.865852425148708127118528745039606260252144109322440114', '1');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 6 });
    T('-19539376265352952757542646.875375665421754785138638245258349740095637', '-4019709446983400741462046003126425681656527577169108611440961983729973333374593190790505052551972072130345000734988733070851.872292165009202108', '0');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 1 });
    T('0.0000000000000000007561234954961080050633722714187119744', '199373925591174867153218862608600168609366436830371491017392311675346692689691839738870943992670941223084334019596882033', '0');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 2 });
    T('-128298154020104176451531500186484300024132654695151917200818949908639571998471784180307267585182706454784622128226532979088995574532696165', '0.000000000443354899283588936652619267294663168843825983520909084201176620380223190447785', '-2.8938025547348048479226089027796572991789582389568685480052735464004698133602112614940908387407001993590568619301937067062832523941619422261651454208578361981242657638225443184931394e+146');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 4 });
    T('-843919557133465751446790586000226211580634781.8357483272722173434588169966498670918397654653934539459854951483221431386642465994284', '70034415.278623319628438752687950698005396341384886586801532577403985022211340601119987996696748996231070239588849449239144047229936071714710', '-1.205006929487503312130170074289300991689357468539547863091483694640727735272757699346713785308038760543e+37');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 2 });
    T('100901.9733615553273', '-201226503873.0056976868225638569100371875796147830855791027270519481558676022991', '-5.014348081365797167297948455069034074781065192103055317568e-7');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 1 });
    T('2185509476186193976476236444601120840637672231.456972175916243', '17078841521730582448797416.1348671910989474552473005821932271105320514992112534243771176204', '127965908776975314465.14597896958267934913124');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 6 });
    T('15647.411671367548270936100581196549646878636254953620208916953892648092855965022422928937005171', '657859080531868266652575163546476845742007642976608029557287829321150761791174807914502468723877871807128210385430721558259', '0');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 4 });
    T('6218218196156610.479944398920633145718283090445629229605963564515717383573301858136594053085442738204555751890652557571914754051153724128880885', '-0.00227638385362701198988915503005665906945025452190948795341724419090807930977738985287537088037219', '-2731621113130365931.381125250298985420736');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 3 });
    T('18324964603109953.1163476979058181', '321600514724219251804651628897079178363374739602892807118446489711142934604331244130586732142939.4647', '0');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 4 });
    T('-0.0000000000276771889943352608976901953339522239882950165675081930010870226838224396', '0.185461366631453934267511690392859410170948689453367173967962195436705541199337', '-1.4923425561365003136538631417892207196116550900382828714295993797e-10');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 6 });
    T('-2466348.4', '-0.000000058622601163072624633393966377309533289471872220745058713', '42071630242732.9833712403637446802055286788851079998534');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 5 });
    T('7500046826932982536787796.8043713713985004174711286749227848244678', '1733234.96442639227196567268762930', '4327195666408158002.8338323040764618434874465533058375322047867728565960041098650697742959068730580953');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 2 });
    T('2183260098757326474321869599229.9638303553687602348196802744272160921854211920592502212331209', '1243856652233713967422651273546182917195982.51197260', '1.75523449172107949421864358033410249400625452303716723173804599075162589353e-12');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 5 });
    T('12929676.38209541477994771901774848256324688104514698097696', '-138214486183191079184253392392467034619894009052172102200211912574644783047595398295251.512899180092115', '0');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 4 });
    T('-424059582917507499884433612600401977628239624.18274777', '-5277.72913180397245831', '8.034887208630965636246243719527896316953239535951297778143391326854211891017316e+40');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 4 });
    T('426152213.40873786736352916197808', '-2757276145.138176463942019897552966', '-0.15455550731114091362818891934919369745035508020805219');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 6 });
    T('0.0000000000000038217663585091307293590381', '74567612397014152796.99581455716974', '5.1252363266792252220034125739415901045092179113e-35');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 2 });
    T('-305636263804921543022341715022100896164734554367656410607052185540656585843997.765306320759234861824222722689967858185363762', '1623413941844.8092848033119', '-1.88267610574788896420488400269727736260775847848662788465722368125250685169287203525838917354839721585720330490870890824159789959047770663722e+65');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 6 });
    T('87942.865445', '104793948401400040302571994912565224194061969756796544296236980540194230254746.80', '8.391979383e-73');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 6 });
    T('776840698021740039806762816816872348656324347091831898695969961991462149507117612390142161282.1653768037952714605661541111885036281', '-16172748219127975263940729848368583364374580459090634000636139706780939015861371915.09500704', '-48033932606.639');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 1 });
    T('47095012065726011307417335907012751959524942794714112221907715739961716166309275.16497012213523813719418727309317419958331373001', '0.00000000000067248144935870176704051772559991208784645061252866075217397512891140598198919813862137173221677873526377828856026', '7.0031689514464986423359090219717723853721214893756358432888292505514066899200923039123867705876470436047631369105377740265789600367951175515936768289179e+91');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 5 });
    T('4710530214890381370276579800620538761177847584623583448617839732450139121804', '-147616758473374826828851587343791481465215900415842328993525561197826639880872', '-0.0319105382316060339224807086317037923016040448952462317561753805309673424747818626928');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 5 });
    T('0.000000278200129486982077688649271481571260509854740782714876539836790025938358311', '0.000000000000000252909979128753340269124880782612176600424812163698540567255360265224242218771207153316039138784961398652914905155828749095593663889994006049007679', '1099996648.7892272327941351901883441557717512310930206254292705843067');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 4 });
    T('-3165462945043449825822697770173873801013', '-0.000000000000000000559089342606676757512810461453126381542470013180847602350714641444372036204185074951205986112031426110205407', '5.6618195050632096057165840473322988023200165281880374735653572833787186852205013065308132e+57');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 4 });
    T('-262429733692810207972645037144400.18269806103689', '110033413673906528545769691721255999.406368311361429', '-0.002385000382434223681365443460195');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 5 });
    T('5213379032418921.8', '0.0000000000000264675185669630528861090418602094343870859301566265134428963592318723379747899679393693690958264490140098', '1.969727165479841778395949688752678132716083506911032610296299084980225536183461145035291112e+29');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 1 });
    T('-2236796860017822677036286909688240244682842748105504673512925531404527284134033477894225886620573808344252929159403', '-0.000000000136393998351376511719645635269388412449720942729207758590290341887036848011273', '1.639952554404494102088386417346975718433527554531410172228983218567080475972061304927175860610465118785193152751004073154230056e+124');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 0 });
    T('-353294560586778145181637320.920664427927685483540489865359547', '-11440419371887358998629655429786795668646167348160026994881761059011238817402656120075565.452943242502601569758041', '1e-29');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 1 });
    T('-0.000000000000001477376383378754834999381638465885543873270974437045233067902339463097874724054585824664003739542997850789686186258897', '-750257596591194896760725709388346524334189578568310794940856716941291827.154063498104', '0');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 2 });
    T('22866110851600356915197767841862317221498636583609951091122365228465381622784182673719955.762216878558951', '3244540191694802958857712.162', '7.0475659109206846830966960354624130300913036527250327266345842026204020975929256857716622957477137929033200652171298089486537004211007879488390083991205634127e+63');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 0 });
    T('0.0301241657700865517241455145898807840960061286158190134771938997287189891336704261487445150480999772482991', '5214673821583031951476391179363041242596704869859858115848572474453289.7076117703318753', '1e-55');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 5 });
    T('-2109247614259596462261104154037710034.8118633945841888040142011292353494685949644320160729063575699923835624', '5564588430118519605437541058812832442564871117702632074340959538752166301566932366470175090929575395276087470139854820', '0');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 1 });
    T('-12495599787027704660395044587542386281629884014618025485933557.5356936686795029718495623556234410602257435149070394722171923443103572129665', '8.3418405831175531566609189025648844027', '-1.497942769646862329558576775763500083835492309824060671140650026458127671289048e+60');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 6 });
    T('-6180031466962071416984693901620893946222715098068634438275786.202095455277150189161450660984327458412445725163', '8244204.49927', '-7.496213209545317539468486112883412138142866524178365171000800452704094992e+53');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 6 });
    T('-137253440641025747708581049786105390865287089352987718766633682921586.811574722902566767075663921435484548776831982025538', '-6523941909150.6993143270831567220247575410360173605953571356142335551628703309802', '2.103842164022176182023934114545642548562175441928005779467112545165684329700005415352595605350561965332552757982929548425958227572e+55');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 1 });
    T('-4165494587924624849546177349771071835027598328578240377.4240162018756639096756752853356052697859975974337308943842128108922477811014882670', '-172424234368962791956594727', '2.4158405592865049774748458477501160510327372601190215397634596612506304490787184143867728540352248333915351590364e+28');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 0 });
    T('-2916194358790793748898617610079310564.2186861795', '-115837440673706918264621131113267068002459561', '2.51748859594126e-8');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 4 });
    T('193251171594020881589793807041776404775969357399045403556625230079459931.346633134861296746184020663851437287163504617087610577194728060332714220386', '31730278802310092089786310690.457828758669228337957197427153110050322113084658820753290356126127083760756700405541415', '6.0904340865719534107289036145051050895212278e+42');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 3 });
    T('0.000000000000000000276239841509500540675216476212', '0.0000000000000000002047828473753414442566556610560196982396419464842721556757755317854235892376563808430565208641170660276', '1.34894032898755103925760363733943868773491371994767801808902220616653851248892194');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 3 });
    T('224651620300431636505792537643599012708467099084801373094962622700759738677436409866260582748022310704030786577703815641', '-0.0066805684041666466359904650227745786004054235142965354005566220331912860200763605067655193391533215030524905', '-3.36276206917239592778149757849243713734324410400943767318036544487399178832022185895841600254358259100728250836619547719389983155856391854740459e+121');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 3 });
    T('42323448156024821152475613027193905826841455573105120602956661894.72517130154846768153348728741130739577095', '16128690281486824.08571036282540824142003942384354643373591662239551428402612976639671736835787340626002', '2.624109423479067021808258190546466725373963253821247012578250624167785203029270785095406864296817560595583925953580754373213850245877904131849442e+48');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 1 });
    T('-17260355744028898102536840251428727.47167067', '584813681248.65268', '-2.951428172332735296210773054759418636496212202657535000383311484056900119295387196738446790702384e+22');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 1 });
    T('6351.102', '-722457543832900.8959669257551893317038692505171023051335267221678929', '-8.79096917765587492179148479688691152233917e-12');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 4 });
    T('391260775279904506743696126065386641.59', '0.00000000001211721537826195346423931590711810292741787138412158', '3.2289660872234610718256524076193001098974866804053393534890149668394152381149166140221132895885314238326241867228211778809596955e+46');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 4 });
    T('-216805576094.3459931437568298361', '189836620399483756266459271154782254859777972784322384879244638098502745619017524990605375423805.391793092702277561096789473723751120401', '-1.14206403189285e-84');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 1 });
    T('-101635158639251759816081198995530080536806974830945335098720636320332879027548146875327300652940771.33881663612345434488400915938302448892654931', '-22870.4438146458357541', '4.44395217963222760435076883637477124931022534160832120922225388368844186768410598943777557078009307922192e+93');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 2 });
    T('0.18218115325918652080364187814856610785', '-0.000000000007500258887274874455316113171960391907638358845596334587266282124798879070171140855266399060309474525609221663629927361079959195487451564950409729473', '-24289981985.592469487742089854303512889');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 6 });
    T('-16512932730081.3826300879467559316857426018', '2998167170026065614480429332151694554768142821397043829992688178659454700940895488489009003609801879265966117001.524753950', '0');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 3 });
    T('65474243896431235221407155339193508007673819185311743.4929500841614637675', '1529079623512331186190745074117513973129237085479934070925384733161', '4.28193816003089399970159121184642628971634901538631146521985635e-14');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 4 });
    T('0.0000000000151377175539751752889574872158236224600095494349763057043523648238554292274543641471058359', '2302258641188299400222169194354367203323152593379218803549050.6822267840859875402431199757840123770587', '0');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 4 });
    T('-138012747.387969833778248240153500672517982002657538729811077629341411108511165', '-0.001167923728331321995156', '118169315375.71924426365139520957072649480751778080726907344125768775443144630784');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 6 });
    T('-2136879710630007092.831760313', '-12298.06630126523380017449215', '173757374393904.78726879348213705478299093879933824375736159');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 0 });
    T('-5522342293.36236639957030059768955363363752219815573866587', '-149888210623104707936695808130558228', '3.68430730502770973586717827530357582250469108e-26');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 3 });
    T('12070.634461810887', '0.0000000000000002170518561169756999134341773912905638576608788683698885269302555876693467937968126587531469', '55611754157521063233.894395304456955302199815766485498922427745701707936648911812149');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 4 });
    T('-2794613797196490246184890667417633192277951134708479902', '-0.00000000000055205', '5.0622476174196001198893047140976962091802393527913774150892129336110859523593877366180599583371071460918395072910062494339280862240739063e+66');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 0 });
    T('-128399182252646', '0.00000000000004384918822899140', '-2.928199755537398742704957490883343090005134e+27');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 1 });
    T('1664173189394725629403489840805310542525504230268679885491575546', '159061.358657019355995297593905911963566606708503108682009776024201484457881481319453646694970757989247313791259204388464904626025769', '1.046246054633009319037426165868548680330954199316448547207790019679e+58');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 0 });
    T('-5496103887001714123841940726282631687942749309284260662935217418127390919', '-0.000000007339252011667030488716008717202577100006089170051776558272379465113872814464160200450895', '7.488643090964435337146734997991813537601962498849148092015498704386560923558302953709572716175492692383364303721239607490582899235482e+80');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 0 });
    T('-0.00000000000000000603190124983089384094465950250297812148627842353213834389603743882587401977996871804237119069462599161650353808957273964000758388009', '66788687461109134007614298445509100076155808825659873241790965563.06996512177773338', '-9.1e-83');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 1 });
    T('24097795042803693912303347503674593023831164126744932918807129120748045585536768104874424890756691468811871628918125864', '-15.4057104716018806266376902241538417152751548380294763345892341696102303929964485772895', '-1.5642118607398450762022724835594933407291033309911318100172674173373431537337675741460926956370922433277124703376970506670995965626718654049750834794e+117');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 2 });
    T('-23143914572846690460428694056056827835103733729201347085682.308830442829417669669924', '-0.0774311952961774201982867710899774700743693779812149334972367752131408074834460856251764984838809211962487092302927716073627998787103534217040352', '2.988965168924525984775056195638973797379606793876425146799465499304310477199305787549502376231360786464086479911412221475401723286892697363101427429481e+59');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 4 });
    T('-5727778678002877810.45076524', '2.583704665523832219756485515353', '-2216885991047123607.997005418357098898392502671610881062456959608308446729212866225064625107778214916480465');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 1 });
    T('-0.00000013250095007649612402266873643120113209217614680', '0.00015890369', '-0.0008');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 5 });
    T('-0.0000000000000004774820408646375541748977713421637649627137243928356160113440521759916440485963369649386109947525', '35468804410', '-1.346202807811636507808913120740186136324051314118810513385850132679991409e-26');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 6 });
    T('0.0000000000052518667918689286398325836253575966191256561666116790606153644659683456893044628665340335722703201936579', '0.000000000000000011272257625878610370791190193812022718920399732384785698873', '465910.819835398728447831810232764270036767345693331370229970563773777510712840455109132787683');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 2 });
    T('-0.00000000003830276111906255993970801935061062576870925900747891436201795529213200339740471374458939163', '-0.3504438911421781941823943397315623033180425382039257701257425602048412142481828164193', '1.09297842215e-10');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 5 });
    T('-2.31', '0.00000000052946', '-4362935821.40293884334982812677067200543950440071');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 6 });
    T('12860033851084408135641782273271604741.8559086833177152223624717900', '9.543', '1.34758816421297371221227939571116050946829180376377608952766130042963428691187257675783296657235670124698732054909357644347e+36');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 1 });
    T('-0.000000000000008921227585895644291500450248495227316599941600725625147897184043668351138336583927985640057798252088782407315089474562798', '0.0002620485518132748289137743426953465691588558655478950066741046970927911736988499887', '-3.404417816532162819930437617419212728487e-11');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 0 });
    T('-3056.440815582082124272599611849059840816357258009892', '302.3482139292620457592248865327186477257473960864801952575203547892864175', '-10.109008999461703');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 0 });
    T('-363289907705301330185166342887.7847', '81582297388203841077960836800056398595444981404938864424325392220121106294894259978964856232971907601192942535015535832951975168528.252', '-1e-74');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 2 });
    T('2296516224651979830297464.96956839247', '68045824807116579941624973733395808321854798672516523570524572686043511663861855683892323399666954637758699354872406770699870692899336', '1e-79');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 1 });
    T('1109420413960762331029.455835780280393628978489105963', '0.0527574753126000904825740856791060169906867869935640611893325419321672632064534436917408156809749496179791161907245616', '2.102868659630114970998941026066197338658552286853e+22');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 0 });
    T('14291471321399196708748924587453402129076677581537443839514.573203083365312707541768208100608749831043311867206549317352', '638388488420920295891589359021608', '2.2386793591390922648023566830716199778412530029e+25');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 2 });
    T('-57911300960614165692638274958417991410207402319875633999887568371029868356080110249', '-1.4810200486324264339038329783179927289228434911039171470629063157559084909999560995832114991931104344335048303411052183180236470833601835780733623', '3.9102307233510746487570180875868531324897993346810427093406827425659614992815954340589420570161650813e+82');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 2 });
    T('0.0000000000000426285056506080950064133048850537137499693259922650165245373450531748781558436899315472239295724725841163665769432778350314366433266150', '-5779195907704654032548969461228542570066713638682962217178649788187658662', '0');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 6 });
    T('-0.000000000001398031380745122555139341299781437884251788646184279', '0.00000020146216689857977364011615129682178851026745397012075427830879338861', '-0.00000693942392394161282059818741243869455460096745989016115912589356045542051718796348936');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 3 });
    T('-0.0000000018281405235993306573729847264951062317741802688456526747584219244685755244146239709408859742677', '-0.000039977411760397363452116441068400613873854122773419085299', '0.000045729336720350989782');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 2 });
    T('93.874830678659540224', '0.46388617207938526711279072582642076655074168793377847', '202.36608963328756896829965459129398111962414293407503586');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 1 });
    T('-6067609112729336.5641389158174028843', '0.0000000007132038331186246087595345637228616705970872979896242214523505385786974090998151199635608250797124420975179730066666021352180478401103585117451', '-8.5075385618687962529929035371789625929642334291459295164276298211538189129665534e+24');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 5 });
    T('0.00000000000000433771844284352802326548983713676100075889655381535915309063548269887629783063924332916', '0.60476927774613064820958465516606346665521900423', '7.172517855089210536653893878745196319021954130581531446479671815157566119078637208e-15');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 1 });
    T('26762355160537621016082743064295.080067862585415820836397592379007572501818714958250145285385957435', '-5871.665530424', '-4.55788140892369243973252976993880089852606673167328454816855114006281555607073627955e+27');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 0 });
    T('5400782777118266253220.3604549383146344518474984883630457317782760', '212080883610.0053405387143231717032886408372941339512826', '25465674629.353880655491465646635526501057360762443680100871194655924059751770000081549139011336011');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 4 });
    T('20.77041654716778297414458217600899840770494097528715266455063312827520464248564409990015045356357538488', '0.0000000000004484442840189590379525674891037241309254709670584590669581148534191', '46316604508866.17770208200452');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 6 });
    T('-92171139886.2', '-592514313065668557458.16374560297863802699287438060780939136308560270752159071394275940584781865057712029', '1.5555934743467478405847657874615348589160126124969369199300225288497841912e-10');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 2 });
    T('-1.73141', '0.0000000000000065059890886460822933200792819554410184307914670072084454675279458029847045326173763458710374392', '-266125561603164.6481065129861199786500770384274172169619885156974022934989');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 0 });
    T('0.001859328353159714363321469660024984845786586153722037720449296018893801641919319381453625004345627219334745099168087651782771195701785834366016', '0.0000000000029762686563045156688993', '624717916.247637951532404712362243884526');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('67162649430668510155429.787732014861061501618925863', '-236.614826553838478207932465774710561701685', '-283848017509530683827.9556713847709');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 4 });
    T('-0.000000217646930938741115111466517044242535716684253500115893355171981150347876580196232672533925973269540234380973583815450', '-132285417864115507435251390828437786854099674431111764370942550850977334692494917177761883791402633834197328087', '0');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 4 });
    T('-0.000000000000000000046680932882216251617394884793706741937714919553715649951530456939224676411667594694333115693147475611796139019549919', '-3644474484546523437086163830771009643582875859529700136548813411552777987975614101', '0');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 0 });
    T('43.86754082995769124119405561033228740811050643940714559', '-87769101040835904261149660962349618325876095974465061347561.07734541439622400299392053847494492509159707970719758153633707200', '-1e-37');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 6 });
    T('-69097286533891955501666445951695889917944041836679579490274884686479808450601762828719379232555211.464168189127859822639025310124291164355646968878', '-58821105741403076530530664065722948506417551033305709063129798777107826508171796269342.01217334150981725', '1174702271624.51431865906695984974463725771232026205875331837518080884');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 1 });
    T('9041636265152378637157327151399645223627585778021483146050449875915960587780957.011514048616324401939780019262', '375428654351101566466264093976.530146667443907343822845172341997674633876621072243523265376455244592144', '2.40835007140840768388739392208756303107845733097464640610139246515054013647374065111574787070276398115296145362274543291398075e+49');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 2 });
    T('4360624497214267907387005.48284527700915574059974152280230117285400903188809898048729116969500966813507856427810907', '-8119801838999011.02575801936508385856521986', '-537035827.18858996800046363321799539681458780089399070149208302130584117879861378917309001785362625');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 6 });
    T('447538448932939821135533209385574726.999129182629528513369697885680276177980080472433938883828696128997303875333052874470109', '-6368301359731239874931361545116070401531720301695926947100905984400301695842082221435827011552438929050651858585139063', '0');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 4 });
    T('-2063834.517626562523135232310567316793', '-0.00000000000000070107213975625877203258839288362815899327451913231793067497874753297109809930914797490313679024856727952374866847', '2.9438261779224236904702214889776893449887784437556784352025548527885572862188847200352206246068587691771714286e+21');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 2 });
    T('33027008169690105634816068559724706808923415773327.015527858161928614391285425483366275198184587804406704994844593736881', '1955751768.2230', '1.68871166097415889595880934015019445864504426875448780412584825158719987844520908736012871751e+40');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 5 });
    T('3374245896870844425548461008173716930805794726086165400744655538619069411443360465712914030117090495412392208057262216', '1438668236215834660636686862218.430303427456916257331950800032119083925643', '2.34539542330218431284055647074890096403960687735631018435380799106468168265649361938388230442569966738108031238185858529671402260720524113238085600314009172748923207492215e+87');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 1 });
    T('-4397991762183334515646102.4647946033986239732551193534808541946505424403119697025954989227216087600038', '-0.000000000000000001309310777068216172367884926521215644215562451382653727249946321416245076207309362533728642519049131116066668568201', '3.3590128785399858616894844930849641709373058417350705338336537223329422059258815134387660076274443568160804503424980334109854992673514690137e+42');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 3 });
    T('3778149113705545526018562196775435279458', '-0.0006964468917648584', '-5.42489191692905607968787881365542888273387455388666683403075199311e+42');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 6 });
    T('-49586497931839593912557000362055451669722521481472795709900395803665510112669010598789.93256203887798759539', '0.000000007730636239396951030874083637860149480910614389067389278444', '-6.414284205889335880923458303359224556138242167330384329448398345627090947349457268582143476335216106813906433026801672417197666018496833222575399337393674433139347850478041119759e+93');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 0 });
    T('-30.61', '-1218773636243305682928698105414537557722577755117520364308947828946', '2.51154103516309388992739424407303e-65');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 0 });
    T('7837.85425197', '-4924201364768546154091768054816877908044319654750206853683883187450708815915970.26120', '-1e-57');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 3 });
    T('328612846507912440195895320949.97880973689', '-74093433362687796234732796000026611813849885047953975898959442905406582392244924227468980782203235995581849287944526627.9467766', '-1e-69');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 0 });
    T('-0.000000000000000262386736781607554119176572519838669441588659442395142995275179459235189042024362526997735063369741519818929464815095248173849714455', '0.00000000000000103533440318658130846004063466103711293231818809309123094434209882633604277459619235001', '-0.25343187280749706110681147629427095838017850949849764966606755516172');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 5 });
    T('-0.000000000000322432448564741584339199183214950196731593789971512714485477682494095134481209913223923119930846635502812', '326622415640382004330091150077429.9604314115936583647', '-9.872e-46');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 3 });
    T('-1522584539163.51961939035517', '-18701310931279048588339319679178119484886874', '8.1415925587168700943027845074751571624847931e-32');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 0 });
    T('-90558127980337144935926146713051405660023043.709734425117178325791783664294624970951', '227135242088470738342348340673455214034602753816278843099968.5147421782261587205588136', '-3.98696949e-16');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 3 });
    T('-142360756712.9628518058827179348092374075157599015252566070459583192544507613919918737005236747495977670122253720', '452664.7791873838', '-314494.8828767426713618550484858325223775720701584135560211010457708');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 4 });
    T('-332430460212660418334640685435602340486744367646333583929761668829129441741273860735150261087380331642775562434.493628257286898761531415430936915752', '-12773822173744527946945352241777487614384940699496786026430373.94891373254810706379263055687667186587167044988100388564148365146145721007864602228580', '2.60243532195040335686018540229438057542066541716911101476582563056311201664783530252883873795758810590583577899737316941873834280768183214833003e+49');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 6 });
    T('-1456234373638105442126887571003692582872067748502.83060615310841144160798623533155017503004909109', '-2577402016398059729629852253016480016715321902659900317234011361788515601490353326785.9736500332116358015946986445909693', '5.650008669090764573237722103893029526602580293053061797e-37');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 5 });
    T('-1', '0.000001505173689176735670136790476340231206410120652137741696393873992345105366801675965982936861911208213462', '-664375.1529745091180083851734560063139843083140854426978539692950873529056');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 3 });
    T('9398596543542648604069684434464332961225347551100554373590714483735425042927783468545519.30', '-240475881254266057645992650522163857746548650866202234477713142554822191906958234727013391569735402429880449813542023581766.26252785778572365938', '-1e-15');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 0 });
    T('23619943335582180681563953221208403530666785379061989956504046069219190202869927837503698514687381277', '6471793226090782771143276213019502359606942573956983356423480330897279844876426842310422683095354515904769089', '3.649675215264804421572736003455667285562991725200480593830141860993925734727e-9');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 4 });
    T('15280144164041863971453423592085478238323177732723827062915112531134543514121698538407599390583581.978317', '-7.93', '-1.92687820479720857143170537100699599474441081118837667880392339610776084667360637306527104547081739953556116e+96');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 4 });
    T('0.00000000000012183457923138078266692462295149758615914063', '0.0000000002143248855015892192235420872657900272424743646164899393878249562420', '0.001');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 6 });
    T('-733440663', '1038507994476889827158389690702181172393885088789796311046631163736129461192.247844400116002721704647439830896', '0');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 3 });
    T('-0.0000000000691051292899636275946254155870639156043778701438855762023283310983413001370155778120594530140708378895345280', '-10027311689094384145668140987547', '6.8916905e-42');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 0 });
    T('11359120624522154.53023', '-2550066103468355693910845303600708535551713199276185341634363815744.004717047270320163183448760067867802013667339034541657861414156903356182450297949', '-4.45444163548253378e-51');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 0 });
    T('-52708994559929466242780826241190188267288957045778695793224196458877.89252001756041056', '-1522917728921740097150220037765480825123518302856603628725087304924959086265252527519267055328761803397973987775137611395540037908247690091091996', '3.4610533162056374751e-77');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 5 });
    T('-11165328701081.4257112898', '-24959530845518955496605684781380264355964682863741574790385933551049268928275747739569707770147273583424324.041182416708196547861', '0');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 5 });
    T('-4773610.84', '22', '-216982.310909090909090909090909090909090909090909090909090909090909090909090909091');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 1 });
    T('-6836773211644461696107713553277748809321479076423818938386143460001184753786637479647627545709037633619234477587974458.12414165847', '-0.00000000000000515154630003858448134268186053972', '1.32713030485492386268968038852626076949228451353445518063130642075005837958980212169859615469571874484247092297182951469771823174308362479399401805152010109664594972766438102187936770325839048e+132');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 3 });
    T('-2778.0429380436', '-228574120304150509.93633862948886848632880765855966', '1.21537947268352914851929108947295372671956410842896564239e-14');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 6 });
    T('-40155867.4692', '0.021958056331393069602794177925507490', '-1828753276.84581176220235398719333810712');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 6 });
    T('-0.00000000051364856828450921948681529991843102776822771569870399038842327218548974035030728793', '45297873834227276911847741.460307540547555645664226582603209420807095413867035', '-1.133935270702251049987351810993966712e-35');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 2 });
    T('-34755259101316819628107054698802052991490868848405157436437774467957274927694958294973057545663400', '0.00000000016806976065534297209525672681893628545526073', '-2.067906740974581308588601710681711152047271605697020136705387772142288905538099935023745554546254066549719693916540022e+107');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 2 });
    T('483701128655610710462059386841552.23428026777405745634056109804544166892563233022827515', '-0.147748426679463517910246778', '-3.27381576593697406393008840795433400914034e+33');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 3 });
    T('-1768719208173205132370941848398177.82555203735963819962601112417663490', '-651791921152437137591780698038712686697839014597685.556625352529548108696424', '2.713625546395116826835505296902051157787896068444841552527408183059190079795466e-18');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 4 });
    T('0.0000000000000000000116409211334756117796421454726040182728029706782586560372354', '-195750459249224092174322.9524725753284699693145539754539744261301487720930697298545585583', '-5.94681676769642296321783820617365e-44');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 5 });
    T('-1001663574341113191015107704016663769094751976791065070936063655062457138070317805959215957410832028469518206846767458394047588', '0.000000000000001927638461729248159701611055290267930819901123886819050275079158796663198260911909162569824451599603350160262664574539026827892407612679905597', '-5.1963249033874311854914483288632911031720642484893401316699761274458777624492546940478687383187802093971235833254047331529086538329373017559921977388196364330715192133449754987426594465068690278313031907606982151272535658547549332601211e+140');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 6 });
    T('45107984107407546633731040234669943746223757421086812276151175', '6570739.55512198111283137872024497742259916654387981139', '6.8649782462074999939174187484334558889424532842877095510401752511100114530695303139647748256181475528007192674225442277871479186150732365801782e+54');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 5 });
    T('-1939019173017959289673537548091.42574322', '-28364816051020445350371723077313', '0.06836');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 0 });
    T('0.00000000000000000003958711472302434', '-10336921715770888655018287383263237433033131293696708328095462.26581633038219092238605955538842322', '-1e-73');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 0 });
    T('0.00000000360620216751902973550311438153812255550584486477376375794853593093274243571181897148522432', '-0.00000000021361331', '-16.88191699065488819729030172107778562817947');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 4 });
    T('-790158223.981507618099539817069435823662655715183365767487593453916243957788511546656932240172412405293980469406614365235479450821540090', '-6.390823560', '123639499.129202624723931482951069896797879319826405247759272117022');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 1 });
    T('2816568668914919894184461316328112686403162283419526.037898686935349578022761207496388884025302185306760500150819738851518852348581120296091201', '-24359069157465989851999751295699220564079490972064971615148408960511.069800945647793749994706', '-1.156271058925767323491e-16');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 1 });
    T('-0.0000000000000000024890937874691414832780758414290817480213020179263215656654817118841152359625327670686290364905590966774686272638666774', '895259242907016.0502793593420537333', '0');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 6 });
    T('19.8064649721071437008269', '-0.000000610471699350340626524661977449179143416264680806880502799487146825848660614272804299271821502010143241929387462842', '-32444526.082347526');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 5 });
    T('-45289296066158223218975737417', '-928257556134713226122051113853071323481509785437.9580004683247946082155141', '4.8789579752783204416317411498894373813729502066779191802429763220593603e-20');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 1 });
    T('-0.00078535502903380947391345955437624724068791174093701655373526043250494899077637070000824976392144327726121891764125927532007759185560467741', '0.00033304165069526690096299415595923020128400941162386700917975599797630916234477195385920220999258987846764383579764299409515938262', '-2.35812856258152917551026948879551194972598994164');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 6 });
    T('-0.00000000000000000008825251516501312058940920752063296903840000436871599720760748237461134319724333864621583004595932821349886876529856620', '-1.069022355834988402', '8.2554414959901509e-20');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 5 });
    T('772501446257033183307692089313828879302168968892627034487', '-81384567655316761750463795931268411572976483902961095936051873255429098175748058407202432776421996767418992938712067148960006', '0');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 3 });
    T('-0.00265017197393737674878379337531359823824938425704924996611013433756744890535609162913776080524748014471110688967245', '-7', '0.00037859599627676810696911333933051403403562632243');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 4 });
    T('-277310922478082.727664976536472274', '154529797348502559260809623214894553999958281920.68284', '0');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 5 });
    T('0.0000009313320140538311704253939589245127674', '3863.515', '2.4105821099538404029113228728878049325549402551821333681893301824892617215152523026311532e-10');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 1 });
    T('-2568129441898937556137786104568163040208787348887340706590516102430677178523003610340952122154266048038803517.9730399', '2008033988816.448818286257251013236779556387322447708', '-1.2789272772283169601264070833637617968495425557009005099026629460069620253257540859429895418421573577447732149647655339979825739828772894437610209251266094e+96');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 4 });
    T('-19864358680856516816965874962516514095825848944861003560824471282641009178302723950309966162223203662500825173538382807849542795490864', '-212016590736544138965692245918445194436743.36955', '9.369247289491768092776264587159160494552988464730248092984466747489758038653366618968029715883528381407847681571034553201507075708328995885146302574046779291068619982154e+91');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 1 });
    T('1511027826251489127749427412.594728420145970907761608905', '-0.000000000005054254929588544894407021979291751880822369870454217947279389954476649584113736749761735972913677160254565233609609842627', '-2.98961537813546413033570359173078020590873199079297173668655504760939876822597828916836670706313129157434826e+38');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 6 });
    T('22285404622935267793795197992056404.53391687803083721925751604043871437161875065851355130686038100493717842376997', '-4433819880661.57', '-5.026231381237359578736427609583397447404830026960320692274017472790674094608582126881777430863932037366e+21');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 6 });
    T('123562606073560146296123.7046584273217991', '123660907906476375.21060629614283', '999205.0694550085812041263906');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 6 });
    T('78898068989628943401506603.08270675806502466782931937791', '1194290107270593798187109116843401631571498310092606492.3812296137492117', '0');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 6 });
    T('169618.404758790672300669003011659982169103226788460655085196350560268581341040077434921194540955861041765539534830329925806180771926', '-33241831203.2932498831181596750871234634196372764398718354398950105612738023294', '-0.000005102558993259874037640634199954927858349496975542935252463143304542819421369658162930206');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 0 });
    T('0.0000000000004256523277467355704328266207146459724948242380197393426799174232335053760581798310771934582472', '-3751.6999327899249360004425625782491517752048297958012648165386626140051399995905192389910930599494479093645321707694003235782006873', '-1.13455856111126203084455485321856616400159860094794231149790756129248740961379556119e-16');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 3 });
    T('23813599381691561229007340870372803387640938880462859216356795005078604814.9882719216101924236603961', '38308651070420356711.31559427577116814710341917692560657321003533709179197980154442215370094187551437840068447305431970852934823060423749792', '6.2162458651745622955827942872136467555275870267453834906201072823776003e+53');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 6 });
    T('123318241287275162822.18921655260382872027152248806374505432037854629660201486592877056393401883557841579361303737894282226111043730914426777', '-456456870233698104500134908313823656919763409036810694906752062765896775554992772273526763414.821049', '-2.702e-73');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 6 });
    T('-0.00044924439041557164526403710647109171619023074888798', '2896537554.9643121132126596022879137094956679374358705958834082310239566109418666114233785128708983990494959155411325221335148', '-1.550970363376168035694279112e-13');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 0 });
    T('17745.2955392961297211454125402462484113848245919170', '-0.000000000099224718451726955927686055622403272238198795216324565595298085034868448575767391976853193092154', '-178839464764309.2591447558517793515299087235428648310893153237708280103884');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 0 });
    T('-0.0000000000694814101631245596793089297088211135109252430430852936684424089336464000093052558120735468149', '-3798.732284911850396016', '1.829068356280255116529398511883463143917963805234e-14');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 5 });
    T('108362353608827313268923', '-7587475', '-14281741107394398.43543774444067361012721623465');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('-2437306615589890757396045177852340188890781157666797.758328182028601588889289381762106826', '-0.0000000067236341318004956925274693470194553548248404304579053109249950576333554557142672086384285660967276155604', '3.62498400093226659476203739344917752015130930481260759192617567062207360357352316987495367303747021613308511833497156590706629890507591201133e+59');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 6 });
    T('244988517990808930085467508261590051387045702050595134044233866221490340947152783388022914260519574142338054725747610963833396.1981754822453301022423008', '0.00000000000004844724052', '5.056810570865697060045216962577790413790232155220285269701339559834446086778954141927729225815554750244793812783861956144977072022831533714979526398437687530030657770887628668597697047947365733679974720673729716071762759708981666e+138');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 2 });
    T('-8661.23764355576609715813061378733799386150386113736711466', '0.00000002746550005875609134264398274317779051', '-315349716008.339');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 3 });
    T('0.004084047591682', '0.0000000000032831619542706580584142574696305103978401516228210867372723583222083349', '1243937292.331731969037188');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 3 });
    T('277.3055135528460243580', '-12816393.20060667602565', '-0.0000216367826121095837692489281740042365093693285056386368353765783488626148054053296096');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 2 });
    T('108943826822403564658955722844387181692.08070', '17956512383891224117968085143785415430720528657689150267073648.4996172245174500838100977991267032167366120333319840181577617438967264566242034311425', '6.06709279025346830003806908834554369487376222264450832057860002548116e-24');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 5 });
    T('1218602407652272553917425396824889774408764317377422710850106480274990119689727903314661655850713934024851930707956995544036054851232204314825162118384', '761190693432782933.64337194443708884826858807341264891408761000973550405990790742592204569', '1.6009160623820493873575601067919584360157853271743142286601103008698951935875610296249851613091888583864370374493428467326933214038637700347112962807200988021831e+132');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 6 });
    T('0.357993343189568044894696414183551838912685603488527040312180940359257', '-0.00004871334604822953683966094899017750718162', '-7348.9787138647836935789771');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 1 });
    T('-70384419738273212082980167906205025390385278922361099370019370514471617614918759874825.0968041227010334018165511719334774882361', '-9485535443.3721609', '7.4201841486400220783041528838155943601598191710271697019152285206166947685907647495910649208911100666143546691486096311978840081494730449273473635655991898192730622510614237e+75');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 6 });
    T('728833029216775114.848868091419422053', '174273372885738292445587123518930875630273224225600720393234457013207634849211187407006878404245995795992915047839719297487000353613183952930220', '0');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 1 });
    T('14288725.298447668461069196056326124584479502434011463528734406498090064700828497758', '-23577164346464368715591356951222880586046465914352944685473402841563781393590871752173710073876024828233931511264641696246181697614580.9306164364', '0');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 6 });
    T('-1072383742631234330836349556630563550044561408769132023979982507867022584644999221.360492835541094441894060082118312853118651940513', '360947434543926891199091335810194343170924006386178839455975948816.1722627808116794053224391', '-2971024697782486.807471809419726509097566494');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 1 });
    T('-5868052.81873921557294337625030742481039656', '-58837964.45893536843884565909543056590172465704349797267166369942', '0.099732424000403528902172910358489624611810837087');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 2 });
    T('1612040', '0.00000794103475470686100081692084019937802726640263203606721720379054195533340757393430931', '203001252329.805170830142123506823342889353430474297766213449310326943');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 1 });
    T('21317146000144010768999844337.09405418305272761083343833305157341739156', '-0.0000000000000000757193290849889312911825751507888440033946174186910125790903709584028592109335626795542286954334597472983510498121', '-2.815284585553737269426231370641010660565418051037612422994606767099732969097097789353525e+44');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 6 });
    T('-0.014774874400113761275608315008410716240020003723449012821995398453187269704996948301479566757073214153779919007657996441', '-0.0000000000806493262726523159219918774844701743368445047223735259792392263754101924782666797204608953839743505777878942483435511937557', '183198981.10697335278713668584937529398989758670399283382712218949276209266326354897355313149339935535891');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 1 });
    T('-5020395207847045587727077822854380739791994932.504221342', '-74.560660543522053645514753840038270581853127300632212275', '6.73330301964877823929748011165377224591701723616789060326824962023526688646477888047535705e+43');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 1 });
    T('3609662930524403234872562856716221223809358860565279701563424303123905958311859287738683872033007265471771790.27931527380155673054427138450665409', '-16794861609975881587529093087945512128074521.8600898019055683338112609046', '-2.14926625437646992547969446513122412619322996353514537842439113690086159828370263502283952142780682828700756036392817917120126832820988735967571618352760750529351143e+65');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 4 });
    T('-209988405242950665631125009649210907924178901.5873429339493463688159064579862138303938474730301184064145339310589283537311', '122569030859976508852246994830123364416.839524872412501134762656285560330488', '-1713225.631055551867872200381862880712944424');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 4 });
    T('47420894138604525437802946544789192269386517706561870968888268715.94284369', '144391219557916288080545064326186839709918688878883756325748745387822257762330379166.90133558573313654585654061826370302276458556690373825246863081918', '3.284195138997609633701571208e-19');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 3 });
    T('-1308.3407640554295633138303751449390044619045210832648462939047683491785368189241638500544435394779', '139897.170891202872445332860351471360991118381599841632343765791145944598307655379', '-0.0093521602740123868377384615892236251');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 1 });
    T('22694078.88024570233564612', '-103651966799102889200282761567605028300454815274784159102379155983367521850058760610422.44835166114776390493475081358376300414537311', '0');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 0 });
    T('0.0000000016040003695568230879054824', '0.0000000002071223092570452784024285221', '7.8');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('-0.00000000000160486518', '2000593113460475653267471363183237276024632954073910660524421220510512507287858956989710464053183389648090530044356759951939404939121570506069293.9', '0');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 6 });
    T('9906428975181302.54887731911260593747588310831803790859593036337074878585870011073458494582', '-397802766783631216105934288942707453764433787034150600083769514863762243976304563720310383139730329806133430388364738219.0637920060892298', '0');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 5 });
    T('2372448042620504597371648108873793114912985466259613.353350132438952846988122884875738349', '-1764.80', '-1.344315527323495352091822364502375971732199380246834402396947211555330342318e+48');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 0 });
    T('-0.0001157332635650475407713018168116431237125041538776377390530686807857574178284175634791546302355710141408674979023683725384881981444027014280402', '0.00000281561515149383689194302008444442670960906950880195369760891106615998656', '-41.1041');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 1 });
    T('-2278482554690743451116787903639276368232226.66013929334144203016049308412938167233648262684966359705041443467563802410865800730861965740644319', '-0.0000285627859101525846417950839372511981150657031908402772381658512315358472462141610401734401821536946991257108968597050239867948233205', '7.977101960074774858211228278423949748026430860250159654207880264e+46');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 5 });
    T('59269537807238301464926245600012460478807876003104742707188939016142085932.461535987165237904369', '-258026813793798647883605234869509408101831192264071908426636279960581099948371251263586124700908939249794338905998034191710232991039.1707483647', '0');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 0 });
    T('-1223654840276336417110.720248945988622443849428748592681708133806032494842645', '0.000005831237077411969651152036899437660106177539656797108710536978889806840010886384299730740491464098643257049074427503358368686702426868', '-2.098448106348337933778408317445108689803477267456922732635079970475386825568124960925254029599e+26');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 3 });
    T('-160773012905405114202302264705.237006267046611946082538479652779007371207354482', '1.00882982', '-1.59365841213342716418020102444272519885511128077164232198898302795382484e+29');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 4 });
    T('0.00000000000000000004323777444337428413401949854456498464107873509686060294293240239522287718342572817672581228188853960600088276', '-1720809525311020427781913988340982076898548107102852062.676036648142132007995157885488336157', '0');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 1 });
    T('275964569992834158046.85755492921522352968031279303278320854591089076622628406831', '0.0000000000000000011567413250188073652649295282698546264', '2.385706847538686076052372330461031480699214143842428420048025129597251853556690269292568001621528e+38');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 1 });
    T('-461277.6333138647416813912224020971', '0.0000000000099173109876618658838716685018082208815532263892509632703426084173504611870016955196', '-46512369521107142.338455538950483324289471901187887073378652573449823154471');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 4 });
    T('0.0000002108442322507065273331916223534695254104558598616968253642258920245687870102832329146234616963726682601037919994780108', '-122733644498769014232860259898669330756311954767551860271513349667053602485734694104734533969504443767273932914.6142703760252739736307212317412780386', '0');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 0 });
    T('-0.0000000000000060594249199960178678557214', '19', '-3.18917101052421993045037968421052631578947368421052631579e-16');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 2 });
    T('-195811421292774532695127684610', '5364891515549654383840359386200881808248648273.38684679459888274463788963963832393300317472688786484183567033543759756562080', '-3.6498673034717063995885765222443344626881916521520475459963682437300164065e-17');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 3 });
    T('321599344772386898451916.7627715300945560317184253492986616105408473681672', '5198578201870724452821312525638369209544427519', '6.18629425746944383858562e-23');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 5 });
    T('-59021937615669339998841043645954574650537447011352862778879088165342870591133705', '-31043943961314907903.917022666104157063875271758', '1.901238376451746005226788041162920350756241738370907016373353852151918648648524831189935921563308495877744181071742471860065257227400576969614987717462942965288e+60');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 6 });
    T('74561832673.7829007984960603332233266617918423177170', '0.00000000000000006873561532223891756546085942022131897875653674106575946797061921115929939619806214882799422660', '1.08476271470372583117204400816138572483447652824576914007705772365515600352921907957e+27');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('-0.00000000000001181612138264114852893', '-2014138394172789635968869539481440379570926693879119877148890105101899856887', '0');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 1 });
    T('0.000000000000000001366669157340155864638406598347121179240648516312903388337468824794236443', '0.09279854219071497335086066371807349978611087519054983041812503112761286510457945850068199743095099213533450370544152422434530999', '1.472726968632163443775e-17');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 3 });
    T('-78371120871915218416109307836350714728084542.8509580566711220007561197751135664622126109003299', '43007007872.5122600819455753207310134111591735810929769934012081040632613037822382277069049207138502026056395', '-1.8222872212880862983930187423262228886865683284215449750904200136563208402080615970986029585126e+33');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 5 });
    T('-0.0000000000000517794840657346263669444830486376125575898943952169421632193391568427990119566089652988965287', '-2481869359091334705649978843485179', '2.0863098162706e-47');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 2 });
    T('-3800753242813048078685520378088479159769007810051420138798.318437359569382034181747551050841109869610287520897097665424309018', '2120739344587363.708696', '-1.7921831141170099205343015684935713366086039e+42');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 0 });
    T('0.00000000156378007339816589413849870302278061173107221245900492549184494264768908538501760700913700705661694518521990', '-147905231008539027703441521999592678242939864307282268778051433970041755560991878988691539683117377228346311196265663176368', '-1e-79');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 2 });
    T('741656271869496797735790303832261133537103891264692918629895512112118849942429341763013083975.14426416177529688110423', '-0.000000000000000437337826800047678192062342330646339091550872169853273984551870245339880543712828', '-1.695842953480867168862390919936147283150013042613258578865996738907912123224955139261119258615822423702514014472e+108');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 2 });
    T('-0.0000000000000000003945300955779', '847727675538094603.20881447452191164062072672479536794', '-4.65397210640164923961095649499515968287606288438807723038872665e-37');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 5 });
    T('30406270810174239529374782771.278433634', '29987421017195.34213074507456021388181141951276966130667', '1013967516337557.710497632723045632319445155498074564685828152439862518088518960613');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('1321582320879431980643741421114187366478053138649637668992881959.2129046722412557062278480288961369942243087270503235048', '5353687452618.583059658211501436312520038528750985790285597473822087079065473605352932561835681782367558615873020688109276602501572923764050812', '2.46854589957996657645910450288106599408003631101543652425393688899855419319127475552578960011427121170083197322297744165290631533010105e+50');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 3 });
    T('-71114384870614983561285', '1133992198.158', '-62711529220509.29484829183226353193172706639273290971086');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 5 });
    T('-39227358344309744601.6190052074465462527776360266851581447664962', '-1444964189776599171579507378211841602075962.41427204488178093029', '2.7147633568949932545095387341963803e-23');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 3 });
    T('-115837657853606995844720884404547510799589826002075856641765645.884897817702221155047697110251074014', '-0.000000000000000005854147', '1.97872820504177629712272145548356593709706684854473002884563106947771925956456431735822674509324781219193846686801680928066890018306680717105327215e+79');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 3 });
    T('-0.010373063953923606543561967610595048856094941146349335325081365967597094701818986463775428252905398466576085651939530455129876', '-775977129938895143191026019050875712630.081238325561355555977712789958391927923556', '1.3367744426617883252061067e-41');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 5 });
    T('7.07270032357039696248182238248680345100011862565879980707827264424914118160062052198454592559803381016252310534580195317268199231287552134562708919', '-0.0000000042430', '-1666910281.3034166774644879525069063047372421931790713662687420797193356543956211458837');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 1 });
    T('46.866633682813410785775987851527123392474653581600', '14744446532935759609287921364976802650424701828423320583228334739180.71031053744910344739840934476919166750128785863253737834003504018235025403581', '3.1785956548537e-66');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 4 });
    T('927926535231817963312783236933887609006699734378688849483896193306043550581226971475691162837812939291919734222589466', '69.511710136713279793', '1.33492117142105042044272745057547679402654942069096851346518705353507990873911816934880681475837540541622519330139834175120161949722916325495e+115');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 3 });
    T('787903250684746738646483568711405989.8072', '451387626240172731.019210241194149882', '1745513622620931050.6672583063048538001140979597440641826636496534946948935720003329273468561267262176104913662');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 3 });
    T('-35722157.881486131645169672', '100206671548947719359824357693430577834853556935970147502331389167925089539796326', '-3.56484826102991e-73');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 3 });
    T('0.0000000000000000059667', '-4900078900071412352023154638895657134937627488698766471691.9372614175301411259218255283959138249', '-1e-37');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 4 });
    T('-0.00000000008650', '-22396792171036667264820309801315647978357144334162083.12866630502374705743738714172542142604509322806665229821313430180867933237369724', '3.86216023e-63');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 4 });
    T('-0.0000000000108218545232858599713247632273393827652613606236609120082718375337518468', '-63988964186730552742407129236660184331567940737451910.3304633376739900323747684284915260758624361563', '1.691e-64');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 4 });
    T('-611570462009056827.435569946920300837761877488706885146112946472249255617564245022342854093878918337418143372753709154', '-0.00003825691236243693776344', '1.59858813543336415108781383220135731029245763562744870737466231608092674465245313558622952768650754e+22');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 6 });
    T('-0.00000000000002350727657', '-915612530549.4986498012664321383', '2.56738e-26');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 2 });
    T('0', '2081391145458817054585942415346886612310280066727237054540620444.4205926710227810347374001861892887965917226', '0');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 0 });
    T('64396.051084014341723823184970', '86155258221040764790041031697500330477136224068314716800965714827382301059502', '1e-45');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 4 });
    T('161926311334485920669832025449.009880427298015253186', '-86582605145623002508536223281526203729561742002210759062959789469031200041674589645110030900182321286311210186122668939505495973', '0');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 4 });
    T('42087279734600054895122284961359726', '-1582252444748.4434081621928924796519078616601687577335016738990864202624769180498313201555599178778167228264', '-2.659959848650533084475129893774578626283565245686747443405755946430798508683e+22');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('-24393115207688675596870569.60246572272274488061', '688252683.929', '-35442092384495610.853541920910354488');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 1 });
    T('-1567344498539073681247622389927625227296212807940565689018967154193560163921622741787409136074905827768114983650967330722209873040961151534', '258.33717', '-6.067049888868387314328876444406452340157681559879926256910560544553306688006308739030504731761619234925098016870616530800464652612557269764935491087093661357364873200399307618024924558862e+135');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 4 });
    T('-0.0129422056645921791719601465787390482811787325920494010286599323572427445323507748474706026834212758691218654442246584732314391687165342190568', '0.00003154136776197801492301730977304527456305458680388423929845888122232881776610108874270552996290271983429445948093446850212726414607906194786215098186', '-410.324807797128661323887265083889695306');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 1 });
    T('-406970415760561057780064386617119757.263519308742495691905858945535446149666597', '818672923102846493332563572860615696408176367551324730.55063831266', '-4.97109901006748024156434129695480500183959174647946e-19');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 5 });
    T('-78183.4852518372967216919908152105019548353604155968802880295485344023361930011504010144273262654014301571795708830431176358087718130912170253094607', '10607986437598718347213922016340671665645380719280718296850684653.76305', '0');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 1 });
    T('0.000000000000004145660464', '-5669081450251908.97', '-7.31275516215380030908528456273152405e-31');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 2 });
    T('8085929460048766432605442731895337580721930731531160363205580.26505446576581110416693140843978', '-1243721289394947316887845245824193097361966.249653947607831559997614092106', '-6501399894812812831.198713198187909917407983439');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 1 });
    T('-2.9', '-1699646950681199591783028036599109.904466', '1.7062366974727970760023478564214356178487652157693874893e-33');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 6 });
    T('32574896572752', '2109.25', '15443829120.659950219272253170558');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 2 });
    T('620515750041051508976194269482692426.792374124676375501721806655902069776290778032909930175761860106409778247875', '-0.00000000000000000025502027337128501334086671256562706677428', '-2.433201650355225687343826966938669897350496730043906032795984741439204415735680231346983110085327281725e+54');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 5 });
    T('-253.813', '-1869585213725782328284740947349296462812912473332034597003.3796368114407427121179229153285713', '1.3575898982116549522e-55');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 4 });
    T('-7749.189083081911855387', '-1189424888787048603763869473895462110995036714135783822648383660167677227173.24822876013469206546', '6.51507224721384284654098e-72');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 3 });
    T('-0.000000238652049254131502728658064452379793668878410887660555167523377063582772456856506170027418975766063658718364642', '3959898526590884727868890244043572810183271778744890639631359016535003209034837033601678211117581133648954265931607133', '-0.00001');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 5 });
    T('-3453361.707350403941292074070462462215003897171541056568419329951886979682783151212845680167855795597', '806968173732110495460370343360332907753082343769580247019418335040085295622247944.113181040401', '0');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 2 });
    T('-724857600294781667694752928854814757656504767543457037538172015151996311767.09336880355830077089902713137225902023265589', '35576495139923912764190751090614238451172063111222.28063124953341132555160276949186755806110953', '-2.0374620868185159744695260524883428541795538598441228267669481351163e+25');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 5 });
    T('90459314193271192639929240904675200094595891741', '-0.000000000019889929160726332308405810144349653373871391299062112473', '-4.5479957953740563425543786103581716954987416312106136180058330915250854154594112110449049208323220551385018515955e+57');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('44600.84022950209680023', '-0.00000000000000000115311776106711337183380070428186718210460174435684789414208726423071388959408295974956801272167126248976268399', '-3.8678478239922152849528900064954332217596446721701658710556060137824772796869614416953897607521919019343e+22');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 0 });
    T('-10715501213702182653755677059471903986745712416039481030034888018947251957554262751035425774219408354219229431010174855261565', '-2381854567973257344135529417942273596912976138767390831640225026922807713902.0071335774919922551743584084296711', '4.49880582877908634337568444276962272138025492001094392161322382200062887587834825326e+48');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 3 });
    T('2777668415334837530456350437716178428331624492107076073.41625457761506567113771425576298699683994847170140889', '184494.12575792230943', '1.5055592712905453936018666314097684118462644696286316455992236418268694912929902592e+49');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 2 });
    T('-428671235661827622145886760609974763913477446573786520227211838324915172681321030', '-54033836316293132277076121712987415255211481254501215369680720161566364356486560208721024943916240198460611516.16193777087396874626696220631068', '7.93338516911056208275506907306087670605307211111003e-30');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 0 });
    T('-978985672242747393376284400.086508828304570555143389028101128064378740092651676', '-0.00000000017031419270073073837437059', '5.7481156251198730821256455176555394133620762834287734861999760249384322e+36');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 4 });
    T('-0.0000000000000000001378730557', '-1699779642968351661661031.311690625306919991313407575', '8.1112311393040415341897777811568499173559964608262755e-44');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 1 });
    T('25035.81', '-15426707.4618102211736741817027124267128929389864672346971215453628022333618070343283714435933840549370440817800415731266379926224', '-0.00162288745423984430491332103031999704602');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 4 });
    T('-2606249681620290829340667099634910134015377448379297907355930709477129127287931080970.3823', '0.00000000000033908909007639111913931032300995225563862871453348017661978845392733842725731860200639', '-7.68603224902678592253345758414787292010555942627904562046643516437873453392526609764369131977904478093051086927914850258545236259386289331867081963276534886186775e+96');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 5 });
    T('-18.676019163851617971086645663075862553105101236104859133581502931178', '0.0000000000006375599116277133928718524563585300723831600550472104160406441918422002752', '-29292963411346.031950995103512983839156509002886050570463618693933772717951886862');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 2 });
    T('0.0000000000000000002964729033966907', '13895575541.08962049977303092171871262', '1e-17');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('-58980089059039419671272933750401215.5085969954169088', '-0.0000000000125213936688911194374', '4.710345399136598676040815418635405786309422752100955873790600841e+45');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 4 });
    T('39690352436779.4736', '-0.248929065534135392063186265360632', '-159444427879944.680634442270293792464789705288807312174022895428661121490808590177215482036142766');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 6 });
    T('-17123758708.9649564601228520', '5545507646642530171986596252367364902598174165564195515271857107056083463857906774263438570754254091969296', '0');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 3 });
    T('23365731929760087456.804640391878252648454186223486144064', '-117757934162037809278172617398911796345898781763536011679981980116.750540814266830722899218955991265238892913561', '-0.00001');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 3 });
    T('444807234941979522201.4377324457637171347360541790112723107359368409461559006408932036173841116665180019', '10596400391', '41977201552.3096254622677679871528475857812698783110065579944483659655019448236790586952995509611182643258803601');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 0 });
    T('0.000000000000000316569832379940145341666909905669974831156007789376490451096259060196030786124754300574665663045', '8171371376785690519385585.66701351562686282609022822813906461874031199730400050192', '3.8741334567083008327580963619961298167968009906262279841008e-41');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 5 });
    T('-472774357119430324036326668012132089659224779691780449119591400743359784143595980403408625527315308155508917631466423744737135', '-0.000000610999707968028327893541028926736631403178652', '7.73771821743929709056982083941520742372719279283796163835376988970165864888874811606092407408406612567500206742994576505018921387373967309708278272562624909756996817913608228003053914858831348442647458554996e+131');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 2 });
    T('-0.000000000000000011185187492603045638053', '-0.00000000000000000041164932486862498504970881233015226828321374130173621404210045031592096096', '27.1716405612294404297');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 0 });
    T('-54591088934771685301979038853788129815502105752730536628129386943849491450034859339399639788058404794249160.9775031630212873970742766620803112572621', '-2192151722.637650', '2.4902970159878517012397056375294605095675718386007277829874517342203381243325672186112045450193551435639746702061290325559872583574490985e+97');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 3 });
    T('-3231763423467127269100.18505608', '-3.13326711', '1.0314356580556986949957755296770724408491301592222056037858834193041396971737912252236931054371550212327732250060225474e+21');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 5 });
    T('1955114107801948058.5092090650976512', '-22524335.791647136092584364897400645950764607967220096', '-86800078185.967077384347495790490734197197');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 6 });
    T('-30.790', '-213014.6489630208957', '0.0001445440496693028350771572054962468560063314976370719645271743152409028882684');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 6 });
    T('34179925021617590935187180066109531776226514967114162257854629299928499', '0.000000003063508106169776354847939', '1.115711917092063862544394218888964553782373466442043171279573403322669964006576523132474048453129637844536324535553852396281087914037409662317072309775853147240349e+79');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 5 });
    T('304537523646.1753115318713779438263463839108727690259207871526017494105154110757369332548256496615515146708977376629630738464401627358793118283', '1645972458153509472825876526525124262646183411615223661149854250942320470406467.99248631705447915', '0');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 3 });
    T('10730', '600087011262096100947134546613401985681628488732289866802893293.4789959830436760144858111835538414084803511922254436397019080617747577133132694693548', '1.788074029036687096006233786675e-59');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 4 });
    T('-15944715365282477655012697051418033363146962116842560336620509095388747479936979318196.9150740135476751963209781689565411283717995989206', '-1137392888500286967783149313346277.16933385670644329340911202', '1.401865224100920229505756531471088159424213471155142253519954330647372862437731950075994514683169998514756e+52');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 0 });
    T('-77616949049052624869493746.7161905624535278878167162906431', '3378695176523.7711316772863751051858448279547509', '-22972462738976.6966249948641494590524792517967393648725860242712522790826048944088891928847068057083265738944');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 5 });
    T('-616684354616574331148.6921559', '2964745499577529510416017186535082094815367092403859067055344008400002.66303665626590704', '0');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 6 });
    T('-1830435241775442899837854942212586718896268738896751218940459076163231291718573878', '260711614318.2277418681340041036233554343169895542755968880936961527552712599392668923941074322045', '-7.020919442204793990907303359587024014267306822240973218186509927227632239199091884881925114776171913063759715175e+69');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 5 });
    T('-7.139876352757289461542505822558172659517318708717430099678198183806433553136298542230251443427747760829103651954310325030796995376', '-574567782248709473337780865800359181439010460721072288856336.06275720688321566', '0');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 2 });
    T('0.00000000132628378738601974691', '0.0000000000002978470409072811377360391343289749273535256379495688261910048831854626823170399869004467475206207549926', '4452.9023466071223660735776959961287235709');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 4 });
    T('-21847487066.7605217478921936229274321792356598452089386602086133607661585870779419', '2304935.749886714939313409', '-9478.5666228806168427849323830261036170085281053');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 1 });
    T('-2442312258500177154631833803193441592681917803929450596619096717808766254347447296555677450630527111828582774828661145181840466593999746747.51896', '-61343.55195783684341328877097596738024920167710546025', '3.98136752853640979247682810971631609686625145909735333930926456883544863739349358178072866001923197043975305147205378033628453560140556665797994093620519482465738244274740136379187291999268888231119420014170199550896828313558969806741e+133');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 6 });
    T('9275485496', '84678132215204827584759285347242680917856', '0');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 3 });
    T('-19794976320208680629831215516378854942', '-52750113072939297803954990926911853555613103143494221215262490371480858.0906154181519291193065190739944573225307343060444', '0');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 3 });
    T('18848799841030076029.711579280668537234365244317138', '743933756033367782502360177590134864044887', '2.533666430399838950967086928619016e-23');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 4 });
    T('-594784739002268205667736419524886418.55764520', '540342359808684924587533359548099389095421413554428744755.1538583364878', '-1.100755e-21');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 6 });
    T('-1726.075138495709002661567448098686057504327383296796313150002411931406077373073513344429353556354725453809', '207446120536', '0');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 2 });
    T('-0.0003059309163364787587041720955829015320065042366262609333245079352877246189593335615545342001672654994603853127687340113897933341007388519584605192', '19221450817116751204809732739853558613080514439575062008086842670295721483726006065798', '0');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 3 });
    T('3080212117568931.9406', '4807128.444773379988516521143439853225061609533551472005759', '640759270.93604856109428814416757191472828207863181401');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 0 });
    T('0.000005619525024600401578782145633650268269238119434994207418753350684434625741830141462900912224038939300796144023025797602584566889341737912', '-0.0000069522639073796584507616524', '-0.8083014539530659823420212243849918237162');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 5 });
    T('3.864084', '102777249767124272827613.3573725', '3.75966861e-23');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 1 });
    T('-0.00000000000411953726181119004487833370002571174457065444710109901614680047196797796656796232677318573024328647057612847991371591299583195680200706', '377302087299171244933.05643480446431808131642449619462015572621321620129', '0');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 0 });
    T('-0.0000003193716624856563111935912371', '-5900693350171710730666551514921044468319047071273346378968698377579186138999581.30001230345108893279944871641', '1e-73');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 0 });
    T('-179140388919344089254559094470262868418890624293750229460657170016298574966364977731008988659834641373781925948643291802091117038363735399985614', '-2342120530200004205488612809319553814303876.5177054493274516', '7.64864090508811200171925277947156369591644992014204322002567749382687218201510689321037413380175604998297096738437747e+100');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 6 });
    T('5122342360245340.2307953867169401811656978279121415427296587169957180771857874129658501373773578101964297176290109172', '-173381699.14828534877', '-29543731.46305618857056463280272225752453363229341936621254410075321');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 6 });
    T('174745315127421168141969852.302663004789400219681591352365728', '0.00000000000054859224166677445926266873407403088122175847297895300263721834565064', '3.18534062013886177412996818235873849681823288208176164339043124338500898204261604483e+38');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 6 });
    T('0.0000000000000000003438865298049905811857297760239525241590283770344974582124294742221853527597457038851486391', '-0.000001408257562047358432010666435253252367692495164316050607062209445651913855651914611164162643579923894622459642391547666557661182253651721761070', '-2.44192922568113280448908287037936546425898689105833556608787796260451693810871813e-13');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 4 });
    T('0.333646134598859999543235659901387624660147', '26910.5148946258', '0.00001');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 6 });
    T('0.00000000000000015741890085344004822612249961739147736218583594913176676336253154215235', '62123145933223032.424807076475104916', '2.5339814732282174972275675581954338603635890679015484811821792961e-33');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 0 });
    T('-0.00001111772731670302871436022591511635045245989853584437206248415827174517169914210538893490462', '-2989189.6', '3.7193115206553069481976740167690769607e-12');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('6144637543780035324041015542995572258526302.8252871899307509340889062293501037871784543277116702587456051549850203393161254', '-21341451922355.6', '-2.87920314238011329822491105116231108390047570221e+29');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 3 });
    T('17595014339836146135415402521949745038609937060624032692727913036850044940221238920872909675776808297288.7193819', '1047196892822332476619839790751710405870401699', '1.6802011599189607148737162149648470300229147254640276162383230992448471244724389879879553601659802830372798231756267150860965026188138336217927443534513e+58');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 0 });
    T('-861013991813852618661450041364763949463695247908562946826280097460259583454703930312.069436995804002', '-0.00000000660203117661869333391008179789075205463628255825253006598363232603233429020945770285962300076652626', '1.304165292134883401534205906114798959117533361222113075961516083831659756781081432844245620956768431433575470252e+92');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 1 });
    T('18964485733678635745669304324510.902018555784104664269930761786760150966793464250656714301947', '-0.000000000000860215048722322553274488581158728716058099505080456408033247509564134988530705172526450476527006322758428608526775577840014111509567748', '-2.2046214794598847316603626888696975599518688754676585469606709377707177e+43');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 5 });
    T('-0.0000000000000000045434184846937299216855854', '0.000000000000128896028168154367112959974017842928472622282602167727915227416370640935480721242519522231389', '-0.00003524870819732712');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 5 });
    T('-227.96443', '-3328395901354856091398502.9371246353045885377841478141934677904755836332251199452045365605447632170806766', '6.84907795695833089133170482400915385505896729289772851240872190258238e-23');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 6 });
    T('114008071806506716387885.38507236728281799424116444188215400334013368403508847006385630841', '-0.092161198210375125931229751981334900000406137583559552739482677605716216810182233366016217607914141', '-1.2370506679639952849967075598921609673812502409262589476568309350924370850875602067261353e+24');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 2 });
    T('-0.00000000000313461925140003543282334451012255842223674671', '19900672650541044585807033236451300959160004287619.0648430649265053', '0');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 6 });
    T('3134463.4599489676245689666482931402073621138180301351868682447', '-336216719580496.76450216809998', '-9.322747137e-9');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 6 });
    T('0.088282583111744550504636202154743748642063399', '0.000000000000000000550996644346331159832365099069695862403708163738892236086493022930354750458616053625423159680048909673004643337040164590864054509233', '160223449666336220.64193808051820590117106550792750292994');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 2 });
    T('26556317805978922234443810', '624803506430721758008370872058372614424539594328229548210393601746497748101', '4.25034711435690189965542552901251e-50');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 5 });
    T('170125016.39083', '-351725053753483997156877582904.929166310992204939591082080976355143002732995877138789215733131507530240637133709062658643626820354805857', '-4.837e-22');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 0 });
    T('0.00000000000000060672902231713', '-302299787979.930507332617490784681098721426', '-2.0070441543194544283e-27');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 1 });
    T('0.000000000000000000737973423458099877024435030273911792718652674094341316578909012531335052924748', '96417848024254236645960941993928926.52250382680747393523941801', '0');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 4 });
    T('-242859957233290455808872183680612124624710994232560919295721829.560013320945976377903570349006502732418839412155469', '8645849305546729917012.6166017448611858420073279623841460173130', '-2.80897744860628166749205149100563693174029572744220253953e+40');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 5 });
    T('195917418.5428342557982429', '-21867750879399792910325752536547917341411054205106', '0');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 0 });
    T('0.000000000067', '29554560673814924103706759848299150511394.639506674963', '2.267e-51');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 0 });
    T('-445586580996158504033858168624533127598605610225961613540082052766034223414816798644', '-3.745', '1.1898173057307303178474183407864703006638334051427546422966142931002248956336897160053404539385847797063e+83');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 5 });
    T('1173951598490.437863081165954920089348336351184472248', '-7591038.2297423708983385790992056156', '-154649.67544107337739455436720295321871040946156129707750914127');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 5 });
    T('-25848403775018429509421533550444829754070452453812121903169467045390.16089260751648127767043200260198750554242867590127133018718650', '-60764778736329651.1347128739950', '4.2538464407448510615791123884099536854965211831513714291799033426530933441e+50');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 0 });
    T('4.17214688', '-251219516428004386511040705610.96384233764396213404273184885321515253613560740334', '-1.66075746793966643415893578323122980582414069211921e-29');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 4 });
    T('738385014447825.2744649613568248193081196823091559906213393391515924596507031', '528744046652952500045873047514118006519343831570.6055160188912265483205', '1.4e-33');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 1 });
    T('-24721813728700698141804102457096980045.40077868084852547588922466', '-47549165347852161039888817749.7398279014650027', '519921086.89700491048524453452992996114180195745096554852');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 6 });
    T('-2380649854558566804310287486793735744438489385384174596945829539944405989796377753690487014587', '1846210304.96632772276', '-1.2894792365499154261619289250592786417884611467624141065080783828418902110954692888923809688e+84');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 1 });
    T('81379907744436270679953689228755.9789616404508106358141594775005145024091926647', '-29729588870688562494924450.87029786825008317879507669951862227147246427970218894287270952528817811236641140349341304337560139234485857703022584735', '-2737337.139050434604615498118226220078861478940583254360625857665497809765444');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 2 });
    T('-7709844161214836750776020358.1274071795526616454682187697436077137192366756444845181440101779945305669742181078575280047406690188175382988464771965448', '68329325585523340776034875809953930863439150253064542777137685289943715986380923062138742429709226.765893490', '0');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 3 });
    T('-48889782335266.086377', '0.00000000005213840929633658919173773558172137649863371740047717294985055200995827641435326516992288634783610601433819227055942786241582560435309996523457837', '-9.37692250206437316476205308e+23');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 4 });
    T('-0.07242273692298414', '-1786429774361846114108686636547373632377616190672350167658470002491036392680741614785076789310542626932592607813720533873534644187068', '0');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 1 });
    T('254974601967092218788476192946586504128676814334312654261585473166410687842163972307817871765635884357606460617712028784428411968638179161986126066', '2.6', '9.80671546027277764571062280563794246648756978208894824083021050640041107085246047337761045252445709067717156221969341478570815263992996776869715638461538461538461538461538461538461538461538461538461538461538461538461538461538461e+145');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 4 });
    T('10596945659336642172981413532963922636047011774616658548152', '-7', '-1.5138493799052345961402019332805603765781445392309512211645714285714285714285714285714285714285714285714285714285714285714285714285714285714285714285714285714e+57');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 1 });
    T('-11448.03560573913408027230411238283731632036730013355696241879027857826220399937671363883127461428783892', '-29804998339189975833666.7', '3.84097844108461125189805266746392343944172935238361545336748001974929e-19');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 3 });
    T('-0.00000001118626577241983092169798799781615911598627213942989996546499679308452345843584760', '-479705453526334356888471993672585986608943898326919381025096414969.578', '2.331902981337638528284e-74');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 4 });
    T('0.00000000000000000011023215294540131868482738585488798510803328353366743199871644564131839025', '9512617014966774607479593080377169504319326736213932454132662404835550339069903337929.267907379699416441528929275593487733629226173', '0');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 6 });
    T('0.922318702393468161912', '-32856722913699753279344300924099688774532365173499801898301087134616100249271607979170323503344120562205518024520829362642880218.77477287729539110', '0');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 2 });
    T('990692197960318254345', '0.0000000019958514844476048474683772034868524380391155636316290667434779936180379', '4.963757101568676040392331432075075194536862716171906745009359584710099259584e+29');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 0 });
    T('0.00000267577961293328590073330190603567586341977186329292283763326749435838585647273148748215125445518770966989536299055', '-0.000000000534924956459176991809287804932124460735595310705292913481', '-5002.158864759358209231');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 2 });
    T('-63.951', '-216987286235939383658727229.045550401204225424540632964306866889027056674906447443646897344466142216395389523166083598078', '2.94722336544931916265034e-25');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 0 });
    T('11510789089121773842747277991574245143192006347968441716186024266177181695494787551.6929006029617554949340615133422', '-3.3', '-3.48811790579447692204462969441643792217939586302073991399576492914460051378629925808875775847325924088910954949763636363636363636363636363636363636363636363636363636364e+81');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 6 });
    T('-1076837418780017750394539423290227716329', '26829833853133634906257281252196280791658739654971532905910450901148784990323817887790641264728864411617819849939207835877874123191782272043204768', '0');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 5 });
    T('-2535671051453184672175486679554799383311689468486426700142900252467439606395321615032170668.747374421788445865648420951070', '-2307678829387103212120719168615890.54676473', '1.09879720659682697294120796567016077464429761317598727017821612650108853106909408362925385398123039506e+57');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 3 });
    T('-4193824453980527155063464781349417.7109221225817851', '-7205240544019522682059877113650053149717497163473051082147335294423284132906750379765359943362406856556', '0');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 1 });
    T('0.00000000000002128789105780', '-0.000000000000000016728489676192358971910290882587685072991599967864946424620907043629', '-1272.553079797543642747971299307201473084777079061726229515761106118100904782849');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 1 });
    T('-16578303926910104271772733073671801041619099273970.7007444012126329543881758056281271923657016113802926145816768678539250147490504399773', '2015', '-8.2274461175732527403338625675790575888928532377e+45');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 3 });
    T('-14487.591832004633901826097169041931482452603200325693594573981988040294642062553194913546730', '-0.00000000066944947318505386532993382047344447', '21641053451094.2445851912759442973222376073188132058');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 4 });
    T('-8229686739239381708662.33742735636146287063045609345953036', '-2647244213404262439882911637252785489226846626705592856444818166118.7', '3.1087750414444368927e-45');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 3 });
    T('-29162473874916196402533253712288473659347188759.49669762440', '-342112791962012114732057946746742.191015086162490635163887048014672922771760017567924296835526832702720786302676', '85242278453459.2038768349559818828137934016217733');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 5 });
    T('42022948694867103603050802418471699.1269555229356577653143747225594108213237028987180', '-0.000000002589549669491921474956130959610694089747921144409250333417143147530431052981800286455172670362396763146881330017477403135680204127703', '-1.62278983060062911397750404176294133187723113887495920654288635923375022321120285877424175386244553506331367297632269e+43');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 0 });
    T('-37576455182.53312629439138776368260835830547508779050377503250764898041507099064344909409375764836587845407908603082292960740372745757708380884582', '15038952368828403397463320963862224104336906303009770585448088037198731970025090722789.7309099945900396936924597893781107548630293', '-2.4986085640127e-75');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 0 });
    T('-0.0025704619610525559048889484855316342846745707345232655654692885805316949824786950649707239599785246562460', '-0.0000001639379851158592830936587952150943293166731179544000508788937965215435683602082130899079539094330583016631933626587077980930603716999951112886316', '15679.47757340034936962097683761989900805628460355961239705163');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 6 });
    T('621373835929896923161801956794.974604713304611881031233924255943294696036229565470839021148054348533973666104715286', '-0.0000221383907720096686562557702482112891193705479203958187839941824986391636718743', '-2.806770565797046570282244463495974404992490502007941326057620478345027487811424868013719227888450907836431924130958601787532e+34');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 5 });
    T('-43815643032.093360955997667723954809856085692571904587', '-1443751908.07452438952296212150242732791674974781', '30.348457229420098337290930523241306667023389446013778578');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 2 });
    T('-3648429077136707350006880.75508', '0.0000023813463506255787368356136470956577201394502017369806001746304788424813592215178160715343676417785000441442827533703991799529845172346996453662553', '-1.532086702204518249148905726541046045137e+30');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 5 });
    T('-0.04102112755155243972860649114120550483844385123706738747864642737382503804224115885148147411378510728916810716421199', '-14345529964500998791249238442530092529872.23503597601326051620033137282158705769490871091028249206709104185199335720933172264039161327827', '2.85951e-42');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 2 });
    T('1483258325481.3703925', '5298367435599816838756.10465279563065128', '2.79946293553620614777007967985e-10');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 4 });
    T('15515711874492474279222649369110669742122491321521.384973179583240063940459149', '-0.00000000003851323858035178818868749158219136', '-4.0286697370623331350755811339199681973498641888036843097290579232484043908475099653101953714524328611085687323672558113562209907437467488034062014e+59');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 0 });
    T('1809441079505642251898574656526689262311176960954786766599586418966862504429126490564103686114541927452962102425362715821995439860.987664807608101612802', '8886507515234135658487361057354722120364139720518634483728476753617706207706378.0739530020162157090529669348095124438355675820458749525', '2.03616671274256873060301686909046894475972477482978706249459495430864061921907781920236e+50');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 3 });
    T('0.00011338640403965278766556287752138008589690261166663786562173105522347361014923788385015003240560715164368513988676785124410986436194123266260627', '1194173291180361867938', '9.49497069454448895061719689639e-26');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 4 });
    T('-3607506.157514134444092621724996152494529158024654713067567207423189505690130453507527458454805514268983007962623628550027832', '-1049845587607603619455497940480584252205596763467473908071260521.99', '0');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 4 });
    T('-2562573.457663482', '-64955620770904.9955952239222783363137640723336', '3.945114259936860102647311789451947576470640755487579267426703618724419529e-8');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 0 });
    T('1406524264866972950639758682647075849863477030298985657607215488204258.6812436400728750049833307611664374', '1360927253153346699297527569240275447559659.061092022245761564304848418732594389246', '1.0335043710881499017374911911396637e+27');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 2 });
    T('3.8499', '0.00000000000668010879682', '576322948786.80822940219928296661780715815');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 2 });
    T('812797217.913702325057604386169507459762507442451919184136830102450280614819341527456349446992755422236', '87740481081428271910312490106725838669473203724.90802817767034615465582676442943074383785527274486301804761', '9.263651257614819909298611813847881172603160519276e-39');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 2 });
    T('-14.4360070704007068204479133257569394125619', '794798851202363424.12766171785375637418589837', '-1.816309503789803631186015016110470706601e-17');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 6 });
    T('19912764824549679482731359446005915742994499830671769692141318634.353931', '2646191434.953476294', '7.5250658593790563887921238049035942881469707461572214800574841389995694907774044341260962759243376018518474121027832608631849532874480500276e+54');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 0 });
    T('-0.0000024659852564404444572628539348324013952275357810649510888727', '-10040524471155732557131859445425415047777281318160212640055', '2.4560324e-64');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 0 });
    T('177136493414989385164933402829.64366090452307132831344136120524494110951165735859018503268061065574916376715783557023', '60187891777818635280359606466814.5298388', '0.002943058614994');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 6 });
    T('-7393488401877396900086660', '4643522408356425475242044229446831856950172592312146157564105615175310306207', '0');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 1 });
    T('-24615528727.48934232611976802942607567911562025748187690514666465255067247750309129790993101081569116851641927920873', '420661451213815587302170651860471630012019395170556532739885724741635518501.278606598', '0');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 3 });
    T('1.91990063974867928918337381079148017337147001769888528317', '10078919218839044941769446643483607730880380733282185589593952094100268332736334083148.63627', '0');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 1 });
    T('237808077297578935819226799575402626259299593170.0910215981753307316735307961018153198874086067557017494183455119371304622833616995466406661936201146266', '63055475889159143979275262398175229543347025173856257439969', '3.771410396070997743720096841561e-12');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 5 });
    T('-4904079.8300344081', '-2720512536102937838958.994730305103198126564638420242641023343997346756526', '1.802630851706852482478134226173805253512179970696278185071576e-15');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 6 });
    T('-77889533745496738869229447644691273683680615077311174351663178838229431603707097369489978602526412919913781623378681628510061710888909916512637', '-318540594041982429254619641933716670156719361.47', '2.44519961356106458727374569781174504459604486259603208121953147086565777602048587638350292884194304991881592575e+98');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 3 });
    T('14938358488121669556367959655370514636497247545078914567687389702166565327568594244021707269351169822', '20039203490.062718824493588703801945499927733204130', '7.45456699191137131792448342334165752468308824781653798839660824653749117672120923041575637442535087400245776884709209254088706501844782272751475e+89');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 3 });
    T('48407.441100399893527', '-49914762867435341373609229012871802878249769536300098081350', '-9.6980208498558584478e-55');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 2 });
    T('180759825156221312434054874665347131160072363893777191871968586225.5657480309810428', '99628.17982080675982529333128191115209263398377929', '1.8143443499754743617602178758840533560819368250726775194861051560387e+60');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 2 });
    T('124.635963997546839885349003747702526642207986139957268624399953842642619921009173610970240559859680382383501844241469647750263340', '-4901973690204727768135111108893445830.3560228505490541617954169857232989892975669919037', '0');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 0 });
    T('0.0000000000014107925075310771591595606797625202818785', '12386394840432336963994.943755767352425361629457315680330718156042295375708947556653121969360110805455673853', '1.138985577083246445675665789069355266675e-34');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 5 });
    T('9654625784529107951076400463831.0872923536217679265793513418784115088017810854222268497016908434175871293339894417742419307', '9598314040263728069176699.289649494001504772215073860394143265011510137892369266453693446307858079047419515709091577', '1005866.837032957991474180272580014087774352588529848202663465642879021736593180124870412868019');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 6 });
    T('305112099545450647851161993868110882113552656790670653094321170385003482454988168963700802006692063568727922463910455736702339', '-13912342973908647095916614853904635361452200346181547010', '-2.19310363551028792881568403878783264015797115276059035942137691575167395810185293868248322264575508137759030028125512759614112610711722e+70');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 3 });
    T('9591317249950356059905450.0654567438881311397254557514865420468428527233233343654118556442146884475779577627527', '167400348511026.156411559469772317845282601856890283690919584627900184214866552631440483460616938973350076', '57295682686.81713587288932313674148715326928262035243294822467450010618535314143');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 4 });
    T('-1134159886712762259916', '5391492078578729.9905053192078034900355415036138560079058188424664', '-210361.0410963902');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 5 });
    T('0.00000000015155872936389446115086395444549864431108799133925534531833041920912063350103994949352660099057234865771387382603864541362945437298342151575604', '-622159863431038059284262654920095960874083417068435366133209240250136536455236664687427878038827741144480740332157803741', '0');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 4 });
    T('-17179571683888479010516907983936833492365898013', '643476582358418286773845.204359506070957148049161813771020', '-2.66980526640508087899147870788071473464567607445862283728735350208490313645231744512865423954721325399938916370550532299286e+22');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 5 });
    T('0.000000000000491253980431211194628211603829815779547378344214049628399550111067969369495996507232841888591232316180093349726878502552172395323628992306897115057', '-2461317363809255772941739237350560508540968577481675200105985067118684968609180345403471054855329464172680700029391770335329021626461730', '0');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 6 });
    T('0.000000000000002727798649835142592267521965189153594719932631321976839730535108261624538480157874684', '558597754.84705249026', '4.88329683777914696940924735055866083084342614872979e-24');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 3 });
    T('-0.0000024695353690719742170166999884925860383022208953944079760760718103780990393208319641197541882950879886135590160617494388826084', '-19570', '1.2618985023362157470703627943e-10');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 6 });
    T('0.00000000102941670501711766403028451056161724837846810205454548884791390579294602029552939970405798284307096', '20.21', '5.0936007175513e-11');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 1 });
    T('-0.00000000000000151716614076504814328783108682909811751320774837258276317548888490554882197937101195183442708090549911467547044574', '-0.00000020612950877125844270441932140528002337207503037258962381', '0');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 3 });
    T('-19023576472120.882634755212040837', '4969543365948128059514362544.8953383', '-3.8280330950470369916153263106827902688133956281641084095e-15');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 3 });
    T('8015238463394289363558971679414816161212655906736576586294568265577767998859345177411864246.36494068479930419778282085399344281', '-29378933132528128568860352313616963906152072539954868687102763084161250224427.95910623401937244440593318573897458404308423', '-272822652450911.46785512');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 3 });
    T('-0.00000018318044998712501785746962041819300124984449527091314836844439518496634538990915126201633478731094683459903373857950606912', '-50260274422193098.4', '0');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 0 });
    T('0.000000000000000036252201669267818816776342223191339936664870703543979984168233662004415270348005127497058056162419795842866210204395036776840289942792064495234730329', '-0.000000000000000000179357830194059685645082549154616146217418239903075662373840804948063674789835931643935119', '-202.1222136220316981945903839685168646072941300843510375');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 4 });
    T('-15506570654579796521.6790299986404', '46237357.2351996389438346207980862758109085552721319697903907757349293013499894765305689197502226168047624', '-335368878798.612068489270224488944266921938533586240305257228015010387166812348642052419150264631141293');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 4 });
    T('87303051951341802985849174960942.48597277207212', '-9790069486471041695911133718356799467162093870.77074889053617528930', '-8.9175109606715699974377398786681160043722188142272519517213e-15');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 6 });
    T('35127196371069787906060832446215347331792852844200192936928233943480174200', '2184057692.451489741162559775349505027286458', '1.608345626238534014016197707074111572037505787153919166460397078040153304043718501523011310281155674900096563938183838e+64');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 1 });
    T('-1796807569032560044825646.4933720663', '31919477195377684793.4892949188374533179325727172274534682789622643294909528', '-56291.88592389473362473590361682233454869146948381216614543943476730342346322360148922436785128008717351');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 5 });
    T('-1867145331240446.087650013540', '-0.00047142351608451', '3960653780592759476.70824175988578916982166828788059612408306509163140722302497479905554685933786921');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 4 });
    T('-0.000000886198008813381153171572516080682289250189118704', '1676630.001919031433124112364037338782527148402428443521503521055117443828166058373828898575321636896507000025367376195681548902071870055', '-5.2855907850811429311e-13');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 1 });
    T('-0.00696731522879746863342805456414992288137602555612523782621801699385593834422373877830117876938169998381', '1506871780355070817620232129801244762594678082853.179820986414123157031119020247899457342741288883124549493377298953978878279235', '0');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 6 });
    T('0.000000000000026434094823195651047980957065649061963909889572510258818902856974563655611705651078469733111978752', '-5829010583471183110.4852999750745072899', '-4.534919682278928791967808836144339886747533e-33');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 0 });
    T('-0.00000000009774366677344691632363185045504747838493202785984732', '303777905886959208857921976715266674582800967574973181037568112324955188454105325264.647926672180', '-1e-58');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 5 });
    T('11729879984042237752390640528185467775033789', '-642441140275916528357087522523498004204346.17673939464', '-18.2582951941783683540161358951084876460655385807847498645257448131090813546626822820609780242');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 1 });
    T('0.0000000094627011794347618529524997222170576314794185732745500031818009896922860311058011263671330388964339345488041698159291689162802654', '0.00000064402079018526723251400695114040196576445422066519624238599940859942799204247280522505080098899034173142881793573499053489', '0.01469316103399798');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 0 });
    T('16189723838.0710', '-10341660196826579284206836275245254', '-1.56548595969522819699492533334627666171180039e-24');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 3 });
    T('3277924795654216922713743886215213934558234408140793494048978796379635435165013745039489920249982941', '-0.54336735219777618442798665488056187857763074465503032864685931626951307213110815707731128151986180054979480494732', '-6.03261271108005362564469759900983422465897159205493476850675475134859937498517293647602955946712704041955397379463380294821897465280042707212449897288998004817421217878e+99');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 5 });
    T('-2738644792905685920749846986139017784488537398665640730199038259627285642508874157110249240094.08654233854806396870983593', '0.07048893791651941015', '-3.88521216782849523903601264082805246827857943249490151440012419399068263560000616742255426701819991440598148799889467166221774e+94');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 0 });
    T('-1021492542122916481066194044577113755476618195682639369591088612908207031655730855760.261897889905155831270857', '183374554200722282407413873055918925009662.3033597426494437840028349983737706403409956', '-5.5705250195443582915852472906193737439842541509498802273574427448473176103922133808156e+42');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 3 });
    T('-0.0000000000020947631992437788260334128526352108784946954262421715067727671602313406673460244799969353876741630755', '0.0061599517660707198340969727429459623695874102739196597068259959714844228339373452774105407166290813820782551809253247300937', '-3.400616236610528233193564938520924106947596863e-10');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 1 });
    T('-0.0000000000000028364', '4339706650281920237449218962507595352433911428075316457722836609039165542220916550034260996', '0');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 4 });
    T('-0.0000000000000003965078289242872199294090729766510245471592367757563323807071211599581999702793982', '-7', '5.664397556e-17');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 0 });
    T('-41276579348139205664214817.061117397441511425496021813583663543794498584294575611567172200905096831', '-15546273984390733433793478381454318749597894128472412011914574903190265845285785437910787598246818563648418017.01917873031659900', '0.0001');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 4 });
    T('180137628272858932211726828049207473719', '-407.572', '-4.41977437784879560449998596687720142009264620729588882455124493341053850607990735379270411117544875506658946149392e+35');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 6 });
    T('20359545447084534827352882996697649022', '810959908914768942946403650700500307542126770380805304862862857933904161563272040920256887.419445309474077045303', '2.51054894616551287888852631e-53');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 5 });
    T('28908998.73515783', '-3723.0255452473490444394049082', '-7764.920864446334129042781339351349873376126336');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 1 });
    T('11353771731770213109935979314204766077.803429457229492', '14676941568007005489652401648364649.3704053248573450123647291147308307652519058222332972283634934609881798030115404111740716259266007518901366', '773.5788603614337');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 2 });
    T('2765022680224928913934.856366328820914512549419399744601258906300255803783271856072003411006086986', '-30143729465582', '-91727955.67257268853455784760512905058366719627007010404874350870901551402319849087');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 6 });
    T('-27973803353732467597874093314681240300146817936274.7', '2711805085115170134405647647869391029436491912213838402534819182816577170039191806230633438', '0');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 3 });
    T('0.000000000000000003186937962056', '-40287888691067864531255656654498186477826119257.83486205924350399940026473132675064210251730473941889097', '-1e-13');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 6 });
    T('-4853119707399881662896013751041882676424871.34255119620658968812561471551918847065999919327264257586536', '0.0000000000000000789787666480410402195930327956520638436124171894371726007897667552693325038787239588213130213', '-6.1448410925777056667540794754946487747565056729325715792347269833451509500111345747271066474343e+58');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 4 });
    T('0.00018632202618906250236563803490223248286137802628984042368050529522909420866005529457506429136800674003703919089708163008', '-1060413927490185650862162264.58587819883181633855751353684185941850759798616987753412241670431421648686406805818216488438279040756757650735508', '-1.75706883282883844492e-31');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 0 });
    T('-296582197552258351073088798547782213145621017034908997551219368985808845357104758012233532715885021.06854', '-514.52972472839968458051708733863739311617381978335602510446807660384466862964082668954528387294081831892060089004743575941830665737716796', '5.7641411817133132081079568811889594648454414358403776418817860520037551325103997146756972692460525581477037712081162821534951403163113421454367610771414410931943153871696e+95');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 2 });
    T('-8.785756028885638309942', '246947608177624323.263', '-3.5577408883289224383160281388273242173e-17');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 2 });
    T('0.000000000000000000063225585970325864485396075291771611465795264', '181237332716316048045378472203695275160865853026681059427519806.128226535863849358551920805', '1e-78');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 2 });
    T('-11691010859512', '-4034859089160127161470.5773065004370792550445178779530908274730755343554226624691455824126275628788101015', '2.89750164780736690697856634400408978e-9');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 0 });
    T('17264790298661.24778339612120219726129732910714646561221181455417055130204095335327479350715774222457892429326697', '-5015531732.061071723293298831498173782290062679330257', '-3442.2651916045');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 1 });
    T('1778308318430766333341410656754788654176198566926863100735.785026985865888502589345119640126859619824416787029438709834800499047327', '-0.0000045139150996358534708356166705107677927082820813299926711361781861773080211743798815762556302066561', '-3.9396140139503864622623283819637870320019602693311774326400218864636615597136804e+62');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 4 });
    T('-2979525352792790601198298192688649786141341801230834442555941134313501985214547248972630509147162876124367050537418867965756714363', '2393739131031912074274211806414.55564866983450529413395930977988062148062512555673551', '-1.24471598185736853893414811397455283846630654230489745594456593361104535938282880638009772610705876945e+99');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 4 });
    T('10760437822305315859349467186067685011962223758508.2292898340272957', '1.3', '8.277259863311781430268820912359757701509402891160176376795405612076923076923076923076923076923076923076923076923076923076923076923e+48');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 0 });
    T('-130518920372713990312225179896', '0.0020846050392103976518667096210508344925578933815526902355', '-6.2610862929771902834996819889289388566333471712217742449678778762921696831584778992829913092129129392e+31');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 0 });
    T('1680290348239783460061677586576479477632276448', '1877861105146962.868326502', '8.94789472785998532406201969642850131006e+29');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 0 });
    T('98212340272764478744036769743.53998661159918447', '-1.2847611573829504844252349018435944786279389740735941066061131438086743', '-7.644404542305927958394180943795163441854807258471249766705603049665551139607897850853477407663496394813688800957599e+28');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 4 });
    T('-4431446791145757147387577.2991245746222262915497590341158402040826616731440394107005242509097835958746301836678363344980328789760128354932814748534502', '-6841473917438138930486.423986', '647.73276118915008474176790489779406139826138');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 2 });
    T('-0.0000002933887640674863470860654803397102517051207073431749289429108077', '5806535990808146428.630716856942036', '0');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 1 });
    T('-0.00000000000001013', '-80382710505730005224826.82791298310513883887498469801317728041502291077554033850826919518584870075231296208018469022107', '1.26022125109576798417096730794451e-37');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 0 });
    T('-35322105230793066143717772.4724214458026', '10987517620163601004566319950522202204012434627922114545224282.322402022609687901968441581170778347', '-1e-23');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 4 });
    T('4068944423230418685355265614343228850013418408713106622.555979248442241363299377756681660955324620808272691427', '0.0000000000000000000253599045776991074682670099070661463705', '1.604479390197923272303517472845245208647420620622818342987962920172750468047384281772486395946256298141734032492716380712631097003768968808547509013483e+74');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 1 });
    T('-678745033872819590083932457185.28205218134760913393462346391518927873560028807493242245873888505764916957404997931370614312848474046307949', '-0.00000009109974910356490384074814252070846305493', '7.45056973868503250802841453952887682821722695744750483500736625069335e+36');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 2 });
    T('-28572733163749836041333377030383051825005531243253823754744624351600443418642018015', '16183335809283440758996327657609', '-1.76556511589899264660470022054852754988618384672249007081146582068834188443575378733749175348905663865558480287081232429e+51');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 2 });
    T('1598794110', '-51767803619804258370774453270228164567580041461709925160228565195668850468842561401214442136634964740940140592975009300449359120696952748.5023659', '0');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 3 });
    T('2571550152173393501524176098.3132351998625568672957719726318367033934862940482388662', '-5237440273565.1207228524099679581472775379477956505205110714835', '-490993694983549.98991681993164368998534323741524989204756100064018596814230660552');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 1 });
    T('456912203930126460719485395721.22003648609684663992', '524305770799388126062304932995736997191627321086276395583819883638111833622261358604755.224661770965322643572815974062105794498422593010687236', '0');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 5 });
    T('-0.000000005648452498863216040118255040511384505604423060351742890041607', '1232794216550095854019195950450', '-4.58182916745836744846893637910381661110173368619e-39');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 4 });
    T('4544417.73193287626082515217201228429174646210', '58863320549389442176353896248682433.6871043363476740', '7.720287760728464513638913975135e-29');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 3 });
    T('302008786430477451865913173921469918.53981539706766348678537', '-1036387133038666959306417848321396092934291038310964313295788481128308560831899639810737318.04874620326477804842185662604869006953286', '-2.9140538009671497136586147729651e-55');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 4 });
    T('-211813072139414419237378700885656074457716799267611690735376412291752663699064535170948683056877853428140.0', '5078436005033133716156804205372383900390695294047690451360304263387981919977197326.4265641830646742373766008824737575346807071215634501435369', '-4.17083275105742850356678471870739792069246340665612254152335879755994125516033e+22');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 2 });
    T('-736668226198969993047756194703946262763078078728962850215087025295', '-311409300431151235535387264151286378806946020073530456668535824508403904628.872991645815365337057086066602882613894892', '2.365594814217304576715789902252463013970450697280445921986656073155597e-9');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 1 });
    T('-12038519896178.343050583830622798587165301678714', '40340462361494993145172207379228147634247889779962825870865259393574788283.813082482302180257936546709351060751528560844883', '0');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 1 });
    T('0.0000000000000000268509610166701800334912706135203400873603368954922062436317253116942166789935714', '-486998463662879616958481229259078824081826501329210169074798.43828397140', '0');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 1 });
    T('-64909823269900045761346114378555621.369886684266321123849', '-2715516319.9228794823292737397897142541381156835304385138078896200673726', '2.39033081089136968459642354284372461779770166025252776375238847685969761e+25');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 0 });
    T('-15480951193336067629393671.418465', '-0.00424708358273824697058394287931995107788656965461947522851981137664770296921298466356688037954760782850606341865212940941984', '3.645078061627161024601523640016341e+27');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 4 });
    T('24684896.01518271685680962063108620101646702283705428496221148607065462671230839758975796837001445596441348271619831917', '-0.0000000000000012485922867340065887180882914038664278123625622790446817239268277611161569655245749385870285984733170601212773880677779079333429006', '-1.9770181409459127030130282324344514639776814627422747067000085599690053740763589018259832855036376e+22');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 5 });
    T('-0.000000000014807613715736006881724155523216287303286101406215339189727852651201006329891411214269372813', '47138481795.674594971801063274107203438644606484339365703302891787822073636', '-3.141300515345563502246717814357829328909e-22');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 0 });
    T('-408933410930331366351505306747613637.4', '502301608967263078078817020044251410495859611955292180874725849617629549750600278.3033594011017317450703182714619757255669621249363839878', '-1e-27');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 4 });
    T('-115835252133107207748230083386149347695375947320217160', '-1145645316426674131036122720039891961130160258839262814.833163686', '0.10110917442965964049616495551603037176187');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 3 });
    T('324410114528078358164225634288515521712.1960331540300033585581775465', '0.00000000000000000016880505004767778581153232729174744246812547975061933315858340411987958904970545075748755970918513886980214608665646', '1.92180337280461116882324890306010466157811443930093788648147283137848170478431669854800995664511056948150066785236743353315873955132013676480239319e+57');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 3 });
    T('-7348240073236898148127361553814999208471464251945186075790063614750080486706532516500107114083265070307972262437836405550898.6921976', '-28201182611399638209563658840984116442017737602945387683718986735940565751787618797824404568.7303145140391777544083084880689164015722', '2.60564961919949834024024286204035087946016558710246303922541253929369674984466140038019986841816135896968210977328511278536e+32');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 1 });
    T('0.007297026672050746404702116781', '-49010133555716180456644577253738369084643566864099762865278837386925212233307.48376173767127842352706140893647414334624473813072778322', '0');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 5 });
    T('4852490500852643734640383257370930860500.926230004246358888434335013807764035654376140471319113288921733192', '41022016177492389242191788983456656934790212440217758123.250284', '0');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 4 });
    T('21154142945164.4737436207974497074070105471573040015764205565068333127130276476', '-4290761302747137287019137676906342923979101397205720416062341096.63', '0');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 3 });
    T('21404795109738399287315622682393563132970611482057057408015049430283263228.74111310068413183505876746078406010224917', '0.000000000000000000012615672770675627482534560056344943179462367364576860545296973446303598607717168976051891074817048788685311', '1.69668280866420045489481749515215838710659927672039090183748525662324101909299067643564687435794574199998889731079365486197322604330597129209311012e+93');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 0 });
    T('-3450790382821963036098567395961031863812208976201226121960.15676705645150163038246850982390947156903372055044602536001863326103241130492192695297810072', '-763049.4310', '4.5223680703091475552107021962526460016614690014770827107269761754877076916795218e+51');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 1 });
    T('42313230199651672735489325884062025582352.7419585331025893934481865894655211677073719001789932289247216', '95185821534871.759', '4.4453290960093282636970055658666540868060568467528026933472524977781314079115242997821941498675915753e+26');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 5 });
    T('1752257597609747491.69', '6539528305.78203897191908488589585858704158645216539398937460932', '267948621.930492772271645037284811611672582511391898595308741494002372333430228827163423');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 1 });
    T('790.3855380044418360414190826995162992', '0.00000000001009614138409195528319486359546033', '78285902300240.9089208169716490416659656953882740186474378912910833288707621998');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('-221096887211673464233.029434021207971903959700430242372811681549616265238747082824532995430363024140803', '741831053553803245328361052525454080331736054300671.7822498155210741048673906237917851738792555483456802791272418274661789835762', '0');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 4 });
    T('-0.000651139662592009486341738951403411968137306774317479717873592038049661141163082842698', '-505300425801028665383762175122150001868137480355285515208663655910011.666858266721037287776934243433208679', '0');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 5 });
    T('-3671341436129243736752381349616365042217.5945187056827841332382473006446185297629388254060464214310637055889519874', '-227247.573154384146163133510159381', '1.61556904004209596931865096874520063691595870755179037257644188612979896e+34');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 1 });
    T('-0.00000000000001540173930826297206570050485142539798943714098329265886679382', '-2811614151582023531974.44462398314990697512312968266966793', '5e-36');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 4 });
    T('95284078615312471887522819461623.26477693383735687249490580589167', '0.0000000000001907980575072794816854101364273354819844880911577900320625777457203327253927566347670488701269315396762013441731474428043', '4.99397529829029400445512070483471174259050367099609006118704282973842856741652045471476316647819741755371043523320670978724437e+44');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 4 });
    T('37696516976809.67', '-5588437953273115926044870421.35647', '0');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 3 });
    T('378929565.44023', '394795362320270792098898494652903896531440802470264311764198716459375.817', '9.598126057337777349449592e-61');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('15352006644304724464768062425561135603919740274357285270804381610637327574316835765230776715422094.5858877396272023484675903979294931153616243148725', '-405339297.6969596', '-3.78744590804077814687449048795712353471016256174527167078862900257992553642086103146670463435e+88');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('12391997349857348619953349.479939998811972166535711907181601637950135', '-0.0000000396579276389002618774584094439147848379360880516760322791085994648217599228277203973654235245715501926', '-3.12472135778020349928209979108857544599794304107991572220480753813907523425877732021587353067795034086798779299951e+32');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 4 });
    T('0.0000000000011729289882247307770578706071888573569106820969659193408240506544694', '-1255499908017820757805258295311505070506457152583896428367804075279506733427340869856179', '0');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 4 });
    T('17.57024622423931', '-32794563963723474099591095718112355996227112378370191106069881991104995.8038681166412740013882364843563458', '0');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 0 });
    T('-1306895671944468591070288992511351404563473756459932471509002653.277237767592929758', '-322376962163459308964.9329202915815135482520368155925183149799359954660406', '4.05393630851889150655852349978721479028532515056978951425002051162114902278959544833608646256e+42');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 4 });
    T('-32077490814252754358984388552327268106030042358073061263106246354805512173487060806485134928542905180083273866767283944301153567', '-2542480028804156750343727594232002464916104443196105627017424.46223250537045772824884122578939553140601', '1.2616614663966602655440794143610549039105196941635092999427352633032831829099547154979022790412911086871644372733806163239451594689228e+67');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 4 });
    T('153825947194693152969349223214523690589243544635139206926681835035412', '-23.641', '-6.5067445198888859595342508021878808252292011604897934489523216037989932743961761346812740577809737320756313184721458483e+66');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 6 });
    T('37106919766560282593678657.7096099958827461744354258881970168052165335487652453945420045841831351550299435322743323901', '-0.00000000612984026535971794707958117104425939246', '-6.0534888610809068134667815813473264511557573757042390207722922555568709364037060533844141625398223231686451724e+33');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 6 });
    T('-641144573.3', '-0.000000692650658567215776814444016562883106433269355122817556680783206508598080653325521680878424076700131284', '925639159322018.3806');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 1 });
    T('-0.000000001391455855279603850130715155412806189081748706188733572987679735751435531762129652831698896587955285725611545928297431036277318359077533', '-5879.778740003149453115553595686947102674472974724003724756870496314835', '2.36651057260508161353e-13');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 6 });
    T('18.4467637908568967309576906800818709287266942905204278027881957919506414846183259700', '327100340291470052.018885253570111280696645646468831427010411192851281152509330141749901256', '0');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 1 });
    T('0.0000000108233917338259594156939274553', '-0.0000000000000000004565264148381930450416004239178145878360488986541233507680378267783546624295898380997488887836168755720265634033974417939239163234566951897892', '-23708139073.75348961340655697764781672842871945294433941227257145619495165558942758765095741331331454732289173');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 3 });
    T('-6754599027838025126815716047495508066346043054422120219372348926712625080840725656799.23189671095732920949609178286055102546857205616253000915', '107595207784639024394558987050103336772457004049998529168426054849379721.85220030402155', '-62777879860206.52');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('-767567474494048891607.1575508751572148699', '0.000000004875311703403470460827491267679111088375437277', '-1.574396717974376118930413375427055257405913586777089372054019979803905250184355319308435849646064170819910667818190892995390347e+29');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 6 });
    T('-281313529988951591674.56365585621460813819037925750341565101965593423141074', '694790235093351991667165454140550441260.28362494255687291896654159682', '-4.0488987291416713079187223486286600048369859121398223177830254033691257405204e-19');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 0 });
    T('-22032516111912199200839884249875193102620746223509928608444522784451947328020683449560083423.3320014349559756171162999598598768265058038942598886', '-297286286479698401818930.7927086368819048356427445406005784385378018400774911418686083165798471', '7.411211722144739301662341736378327510690297157739590972291891536186909176131100719408304758388950100264204e+67');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 2 });
    T('-504095727490029865108405982465023657063', '0.0001418108435423937783007517785233764245161030889541884080802903629541241457204582638467882030562326189604752419580188697572669326', '-3.554705090935676477791525324089215907953481197167887910898400870765471810521830909e+42');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 2 });
    T('-70222200877721976565100755417575500277629999832398082509168582124795779398759382301433050650013056058674778167124529942105', '0.0000000000000010124346565650714258010', '-6.9359736376437089721359719899145571672143372111083474721223434403202326101970030123813824892397458056643609341113695530397807616524250937342611151136157870513639717824741934190318511787690333719478482297694861249299259683014e+136');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 3 });
    T('-0.0016821113685730833060380092942912079806011286446462149294640213475147323465279094621352205833715636184306521853469706773604977393588', '8818078.5109322786143396929032251482432725328678286150251496', '-1');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('68547944749882829549489008458779589815540451393182', '-211789487168159696858830149083691311508860082075074910244285500485575116345894739232630326.13876985196084241793739829236577541073416634745446063670192', '-3.23660752317966262199779983900851713515143928e-40');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 5 });
    T('-19.21616495486753037639761208089923695156492819521502781212915545358345288921278241726325489623906100082702841188492596712483469308850895965598096581', '7291143776818.0662432529008780776517831079', '-2.635548762042609445001785268618088938599105073054726315027e-12');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 1 });
    T('-94427654720186260692998219276328393584213089956492863260951740894504293965.2367915578312852891464633412219127621602825904441021', '-4450034212444858370097948816155700281600827527767526525517795.2803430536196384191292137870675323639390335877446605450463807155101063378', '21219534550119.223474139679249593535623337505741605175031723732');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 3 });
    T('-81339455827944255393951311490306552895', '-0.000000041862345870128785373777175927993230340289266744242636189306537061752041960893730298132985829504898420874', '1.943021924291745922388131837480037009278159092124366742577117398514961073879058349548510345118513679005293459532526878367e+45');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 3 });
    T('0.000000000884045464206287253425139994499348390288621', '-0.0000000036751322066576242171170006304801483172830300278718127470112736591597470668463955371955632851604', '-0.2405479352837455735885044998438611520131695520747394681512821220924441741246997083961404');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 2 });
    T('-49.3990403355615170766063344213815145105583203699819922', '-39262928148055071996.247714340202110107307994666794816646669962799497898937', '1.2581598639124562447879179724e-18');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 5 });
    T('30185936135911346753544000929543531356504696.9321307586198575820635046392369468170677443210', '0.00000000000889546501605943055462900338069432634169148894284443468891730291115009150304068070437440901803462', '3.39340732400331601441220953053085097561845467363670953317010393027311226659246041870152e+54');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 3 });
    T('65110764894005495791149102013197168751.46013107633104474', '122849867324792.4401485739882105228893993200368676056606566637252742726987458948922404', '5.300027286302606764232334083567823916748792625109725207432062806860743132346277174305e+23');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 3 });
    T('175732730964798637504787501648379401015078431281552342604541041523143130739596109605795217820445856365840690677006305370064088804787156156975', '0.000000000000000000044627078377391111797717707506386678729832320747307962147931472220466', '3.937804968514990885003457302559977315967418595600261882422669439995898759557598799552704733122198387306415523922855107365186616672946780150539751697306600548161005852808900873665263768623778598109224110276816147685618926161299826634e+159');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 6 });
    T('157404058876.132092550077030439261897362752853871830997192658734129732225056949295101038459', '9913222631494173169793541281586950606405', '1.58781926652248828880468116471553557806107509380640024881172932536875611e-29');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 3 });
    T('-500496066549058122523524538057773915826826913208646429765183500446544788213209101442562920.4215012300087556197473', '-3469701195497062066968643121', '1.4424759895710792261194716054180048222637307437625373952868356782579138408616912264789487837e+62');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 6 });
    T('-139994010285559455656361067601490015580658433314557659656116377008140532040106593085759989858103974008161.97612211191350004439596548', '3100374.4', '-4.5153904730202731533443531078533616965956896468554784756355999136149663743871254092976638517626765983e+97');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 6 });
    T('50.5825100008643335639002030', '-5113880152155098174745734107355881365.414192017256590724083', '0');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 2 });
    T('-85897819669896341477399212217868091056217064017.413943752402392352766779573867742413386438726379529922858959655464746614585', '-0.00000000956809058284455081136304901312313622213572227631594575563416175500319040573483454557180486339394375060900551570428', '8.977529939349644138129189595049487029809806737572203060359215020586723120622012130285548298605448267e+54');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 5 });
    T('-13406027181869131942219323628000052135440457119214139194062030510132615800506.105170187274525350527283076087883835545916891745544', '2432350930516151.718929383717436', '-5.51155140225770596842962683948996664881832225682187833028819954624461026110479445009418193371175496859534625381201886800812973958975e+60');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 2 });
    T('21.770063074003', '40284326517215758067539078.04686946078901278456139861931375323993', '5.4041025272445420756576743176730573932148771470344031142746e-25');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 0 });
    T('-169598834344610711289485636044177213069669025186093189522692330815495446385394933456802329829.89814856505555574078439109464846', '4073519161665461297.0705210797840162689150775433601758807115568150837151937266265880060497431564361229138188944851274622581', '-4.16344756496174436727634644468101079646812205801424950112551927499646520315786067377323933470114041655458820971891011661939688688329899108494027255245390225880835574143e+73');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 1 });
    T('6450825612664309385413262471232615420425386423840857373618549230654350482950448030796.355111967920589725979910671875290527521454517933967', '536453462509631523673841120977259976874895472096249453886631000037443998100180512286931180065863.3189583482454504212885227485664083196417293852676554', '1.2024949e-11');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 3 });
    T('-17520315251457681139169240125154352407.730053852981236520933835994797692974179310', '-2151609422402119268361091388577166717650764365388264909600751367254886131216642181208237', '8.142888e-51');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 4 });
    T('-0.0000000001714226329930445076430282571879111331855606207358607692264215328802202739969631292443117775558920847040670700105818', '-47421716329510804539274769917188268913032796877737499941241566424898458543604931480945.6047437099021683973588923557', '0');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 6 });
    T('0.009285228717006832804766101423935067607438919314783568187443629529274565217625420900069661204469159210493915283768314424133122124990655979854', '26010741084328545870244893269433803874392121409768666543901152710348.7987991180143214803077412711160363271863', '0');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 6 });
    T('-38096329876334489238903761051687.505909434494982846476648545901', '16745736743363870967810665450.021', '-2274.9867897828738483201764635987308032940474942543283340120073308886436858862021063712926662');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 2 });
    T('-1852217789725050122438170820.28325931905146699020306554945621134740056415276362', '-0.0000000000000022219735130576607077241455597715090688027', '8.335913001844071298418070909327002279799405145610418355663896072274220673173691352497252427009443461242778791749718486195e+41');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 4 });
    T('-5.052912753102736', '107023920349655873.54567', '-4.7212929003109380284034549969485e-17');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 0 });
    T('-266.97485346716564956157280050094877184640708568130912395456679351152029', '-1753853035.61160', '1.5222190688e-7');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 3 });
    T('954586193559726460107731285168494722.9037565484058748268362752807954096508569225053466442585', '175025134902024857.946659604982714683517822925827863152370160381284460535905875321378737938766', '5453994902469764616.58150337495');
    BigNumber.config({ DECIMAL_PLACES : 57, ROUNDING_MODE : 5 });
    T('-267237149648929650770841208112045365329816.439542499886044710089179505546406746998352250053357569589659024098206947838778804412901042009', '2865956990464.2419103294110091444804788397357697927936776876529534305', '-9.3245345459856762702231422155008533916528403844303985372147870486165483887045103066371e+28');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 3 });
    T('0.000000000000011798785370557154', '-0.000007172072059991226804827454975003309679226745300089619652718388564816837765575110301627043075680798604465594161926', '-1.7e-9');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 0 });
    T('84607', '2382032689860148308531395739.145192996759100481488003531576684203267158718171003088620851830764617037937929195251940479071065144531602276588713499264237', '3.551882405315242237e-23');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 5 });
    T('0.00000000000000000047538803909839962706', '0.00000000000024039', '0.0000019775699450825725989433836682058321893589583593327509463788011148550272473897');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 6 });
    T('19679924297334293397819794933736106194546137901961386201611155750965635026795564258383470442575.260572732334661986776494114890517593816154', '-0.028543668858124904602163953705481332784469412744477052870101191010922069308523653503847377589791', '-6.894672298488509801002555119667337674521780487655722074777233542267155675228661637040428771077684735646741948664238280164160260869674e+95');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 5 });
    T('199552146833565065.60343239349268850658366323254334', '0.0000000000000506642066169812124424066588866', '3.9387204529258495649874909100478672979187554902310346669093354173798682952241546650577690501640693752238250721462665745e+30');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 1 });
    T('-387161866735686167691534321080543.0837014138', '-322.7859891874614323881383732336514774516575971614318648517427391578', '1.1994382646851432963916978216940809600824844920678376351532980676778233546372312577779858407685e+30');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 6 });
    T('2760024313.5778704057669856497022953922822386', '5872891.20345055160524909866', '469.9600619123080229602253503600815885043009784997903363248726938530266220060896484204883406');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 3 });
    T('-4528131.806393258706983', '3168972957516567936169681971345116655042036400321964003489252924457666024659.040760470145109369158157885488664797', '-0.0001');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 0 });
    T('273292204162.856672176868803568506201360158581697337', '-203923668506156435403094859695837035346323412975048716798801109398063980603468004686', '-1.3401692e-72');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 3 });
    T('-0.00000010004256187631071099217302483879302028757550203011673627029202998985108084948622165168409499', '117972776380484.93915178837827763865573', '-8.48013965134245625178836063051441323435647271026797907086855220052226306901e-22');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 3 });
    T('674605103234322783.3237', '-1547968573115392911964985462870966980028921979919547094140583060509734631.576774388506268665328912809339946759987978943451323455847', '-0.00001');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 0 });
    T('-15486548575410436752622064418.0181922761103719158776264635687475932616828979736848925661001354060303348716362733980966953827228197', '-26502027044661430625285256551247785723966919.24648766263790801109567144985787101364907', '5.8435336094527334313380874442292552757714007922160676702287943e-16');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 5 });
    T('627040165425499495171153029889504.31671937321473687047233822601663676265664744306887293941652655644769', '-299694032178944026.84069784469535597844847667649446020292184', '-2092267773457366.2599983671489917243335863920764461348071');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 0 });
    T('-5407835010747849549162812758879087690424595044353151941744462471604631573009700167584742.679971019552971807722846633879079646240318162581665', '23785912294.196714', '-2.27354534224329622818940004179260458785011107401324434849239099642317816441985626899544554395e+77');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 6 });
    T('-3437992854142703284538293514293287579724965437595255626789898452286905464879603.686908794794846726361032049594', '0.0000000000074777328304945359092709244468056835524', '-4.59764066472448901851878980248313723924655316906084357740049123168021045989767328444918153657822331149e+89');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 3 });
    T('-33240294219', '-226069762860245268437272123400574797895866315054579499385790733208804786814838316285516673786443254579', '1.47e-91');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 1 });
    T('0.000000000000000000559929373520986063303443207', '36933.4273431237036497606164370219728463', '1.516050401494174305838357e-23');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 2 });
    T('-0.000000035811883955605972145313778465', '5527078033940442210732762483079568725277452988799329891469839611510732047337136057081786294644193232432266432240833609588710665413078739225994547', '0');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 2 });
    T('-7739007094817715141415534.4', '-0.0010310442772165592938636050348144881712', '7.5059890887617268105018254498699286018459975922907203293975111378837e+27');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 2 });
    T('664736881718687667849986931928276145068978792429084590393781571627859660480521515527094764276561967727571596730811078810632063149488381786440881', '62937288793949374018170767795206877739598679449526233914308932715137189098568527056769931656294739322689322329056.946645', '1.056189255140894676319184795924484581774417112174941320662584460123968687363680482001e+31');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 2 });
    T('1479520195156023160509166908192716104626988.6', '2567', '5.7636158751695487359141679321882201193104347487339306583560576549e+38');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 2 });
    T('4144933797043719944241370197349096775202783978960.7117056182390516050247135310919420201434961226284796322442627509451846774324333806928133', '-0.000001436549536960041433102142293970410560736641737553385170498154902239727624354281411916039988931974674024884950365465641053670732852912317910923743', '-2.88533996942077883558047681601227555314984906258385914674338622914140371267219866e+54');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 3 });
    T('41.7256544', '417768338427947272756830602167.8630664876', '9.98774932466464204745666911992458172855e-29');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('-0.6477113172989271633442504679000622043976951893186690203208872837111958128235', '-0.00002712595585889323017717655462257053054998647101877672740855721465714609886151470803531089253836693185401695482758345567991720762267657', '23877.916806628414276926998089074622687649042325041355101856950977903586156136500718471');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 1 });
    T('-21917091964871342451992206772564762844369711509423475', '1879669887488887416581267987281341214.4429304654218', '-11660075054003819.59818915298550278545677359');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 0 });
    T('-319.941085435931955099871648217609532586578785076603616857456171814802275189049894025923049360257324887671288005110624870117659723756', '-1209259540630640.7050906072352737775129200512204839', '2.645760274664275483725949459220661851854853412747262139035971e-13');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 4 });
    T('0.00001042424466361432633821283150526031692563832637225253937116119282386305414197932321951800953816212514', '18954988639424361425607124230156398503821983407305007.278', '0');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 1 });
    T('4064061441012260075188848967395.41163501510560019', '-178.0811111', '-2.282140658213952526933020111527938257015460411842634780146539640497559766180052e+28');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 1 });
    T('-10076.89199988877284010331336055060877115259816336517467218371386440933122838419234529824881687047023444626634100506929123', '100519630764850777276127225937170937041300592.5914818239675539', '0');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 2 });
    T('-422609553944352857434436099933780797900138739284126565812881817586613739212989790522.7001416029294745327091', '-0.0000000000000223093898794034569593357582034154446629578960334147394270717104933058850702702132394868082939876147817328216231591836904251475523241182', '1.8943124676597083462180954817109145444459795027300602126169075731888263640006849874136104374769000225600307547924918475955454550867487558013232495157156648486742206063763750307325894278109e+97');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 2 });
    T('886675680842288459.5356266771584490143609421165282813737701213', '12759521004999265123255659902105793387283770693576146370411779987827655324263758528791529730160060932010958838163', '1e-79');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 1 });
    T('-11177657150.65646', '22.5757', '-495118962.0103234894156105901478137997935833661857661113498141807341522079049597576154892207107642287946');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 3 });
    T('-327878164464081720402874194688.12136244531891652019031713687558058155067131079890467794666951656', '-0.000000000000001665773016162063861285566461795871095629939669512108146362381274207388415', '1.9683243832314684068694981732003714767530521361138727e+44');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 6 });
    T('-63094305154421569864857062196205834006893528165294358709622717600166658284820486095.20979871251009575334824980244215983875178120163105', '2278599435786497009442063983727216254769084513168684321.9495220026945639870449781267261382539211632677463356802966665042258410858909072740', '-2.76899503104825033690325751380556830457514694175768561291465961820072546587796850359413e+28');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 2 });
    T('-0.0000000000000000464315768550899871500193684502284909370813260407289530945283911817805543721614906648675621468311473606607374316', '-14657114581570295624445573315579518326047.7216185748486577279127938474270096670527475557629714', '1e-10');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 5 });
    T('1415848354602977301022564605988276509146139307061146005729375907494474657847229204078089112651532247961.2498603051', '20795855.976728151580671182795037498', '6.808319677667508066571933391558937430285632750111632425581199108274540329768069465268012060040463006349928435431691118523e+94');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 1 });
    T('209217270216491723249057454930875024026196514659170035978197086188701765103863307225136265641715805608441566738879373033369122705449646277801782103367', '93106124.64158412311457273725223321043451262597909109831281377', '2.24708386287027041878070444131306874150351695153291788748025452289178038734621019319316274325504310951050759884886886403662534783223656676396335186772970019e+141');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 1 });
    T('-0.00000273732923294441935493666908942841033515730542834279103731869694419', '-0.000407328055840682087718999158109736', '0.00672020793484225121288');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 1 });
    T('73.16779', '-0.000000090700563689158672612164381048472768963053510275398964035070908', '-806696089.0205102044317056193127811340361540554326111841171123845420023017343855213762056939934454003594181');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 3 });
    T('-0.0037095970887334179057042966617363226689978735352342006055636068569109547526674', '-1.746', '0.00212462605311192319914335433089136464432867900070687319906');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 5 });
    T('588.861433890458300987619308938508241304189748563107484117213', '0.00000000000004293063193126322253506919708910593505519175028839767667711868920297535260471779185028676340081594977910156663986146041705819', '13716579686814109.4801527962530600690169654844007549458818514715312002107436724472149246597821861495065');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 6 });
    T('0.00000000001663472681569937736021764468636408343947938441762572896949579084480124706652852698', '-127027.21905243629769199', '0');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 6 });
    T('0.000077881388218281005687336778116246367234713307125149611494456661038547296704075668396994096946267492966671812957606989', '15691751660415623132113012675219564855125381001352467351543756776971649081573575472.9720306430671202626044375403', '0');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 0 });
    T('5018470142843172752988238446296281104766400309565140338441746808488124.521663', '414014171618758740750133.4674670147070027117433150268900290176025747146917972092888324395268942570587534672207640945924', '1.21214936271901007471005718838156413163402153170883868246954488e+46');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 4 });
    T('-1832914338931696283253701994430445171212271.95823483324541134507191539703991467075728062389781178462788555134423060709657917771', '-12031.4', '1.52344227515642093459921704409332677095954914493311937548e+38');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 3 });
    T('-105.5668573855974034', '-0.0000000000000000000505080467178606893826007693521151808014830274', '2.0900997810368061695852459723885371044945030594418173202307869811934383649e+21');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 2 });
    T('108718250076038260153655912870515978342.00377869107800089604074247785733113514358982948124392501830228193022809726014441184715572080686', '-15899622644794646191471360921732059006346455.85705357407498455317820', '-0.000006837788');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 4 });
    T('0.19980713409898847304465279726012318707675751396900400173162554118780539343821', '-47368350449574490517752260479972114089188459037.897173178741491196402302380732406318', '0');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 0 });
    T('-174074481522451307041170611922566358145', '15533147612724894801435359564263920589962105182625817145924486476064075469456376251836463637221004382078005938389749352027440867705', '-1e-87');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 5 });
    T('532164888257576692409296532357256109132835857046340194756990817306212087277.733837988', '2807856120005059255374873.6034089884', '1.895271215879173418261611419721318714981393843995758414176773287420225360469468444791198118615652714e+50');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 5 });
    T('0.00000000000000078936739235676687781048697471069755245617', '0.000226', '0');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 3 });
    T('-4.757', '-0.00015390799666060423372811043004740375083032283821397005011836280302139314159964357942698276528052695369075098060467955891231827', '30908.0756244918840088857418083632668135191730355459469328351');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 4 });
    T('0.0000000000000024086600463806299424374121416890201561074038886878296571892378709973569307557556598815096869720271879070921871793621514095998237208', '-0.00018267383650436296642734825224979356749023139391700542706611803293888182378140451160391086957687806217665', '-1.31855775981532073973356030848385469374644265678625171094991413730337640548e-11');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 4 });
    T('-0.00000000000000566339', '-96726469543567045686080198731796552602525901758368736232549164989040575593444074453855788545532851.5949763831974132484492570065944329423352571', '0');
    BigNumber.config({ DECIMAL_PLACES : 78, ROUNDING_MODE : 4 });
    T('16233126225250017239357792388796845628839602788760722792.453362213405880166713109524605579504406984411465580205725967962502654508133808950000768194', '-784330484460898350357646319220780944579454673767199974320.7460455944153056585632904028918800511788168812967069164912', '-0.020696793694570845174286957594940800138344900939750553472711294668787393104488');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 1 });
    T('-0.001027227256904838404076883669167087383248041', '-0.0000000147801674790446518333269676210150733391205337179850941245838314675715834402855498818739028333287912525977435496', '69500.380043815001799615692643077023293588724619925816701350653879436495088501077999309');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 3 });
    T('-0.0000001990043750371168', '2415439288627895583143324072485704.15761799024842376407789705776116715405499594097624', '-8.23884814551320804683528445216952331803735569672513e-41');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 6 });
    T('-56876.55', '-286884694441389260975558562.68761178612544125809046971858121051871389394063721121229978222388403502505799617452213418492118893453300399160186065', '1.9825578395092777601362722054536146763450825e-22');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 2 });
    T('23183117357670318840207286779.242191940176', '2441594243119571302087603432924028052316961487487341075546889771795605508900', '9.495073730207423539895e-48');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 0 });
    T('-31031314146924995', '80943698506460330141829058227002559323342352405399480229766085802.73623295758518488008784968699935295906439393184586098019102870553480600201153317', '-3.833691161e-49');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 6 });
    T('9554004513125108404454.332182829', '-0.0000000000000428070507696677372446142868295574463706781408788400262', '-2.2318763711455904495917325800934504534278861298096679501991840956753990995597092670470281864283769126772933167094010772479607488715139e+35');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 3 });
    T('-188318292118020514853926201588010679957912685912520050100632462422877619868161685230958711843756798778233311', '132996437.39', '-1.41596493720951478829628672046649534660826666157452061731976640598400934255402677919024453233706878302895050954417148241176658e+99');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('-0.0000000000253046119541707155341319133738179042090207530859028', '183617314322876.3843388', '-1.37811687571437713828216455135235670426253451409492363018493e-25');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 6 });
    T('-42983.951863855905', '-2813978704145178281459185721082321712134272674268203694186397209647978.65393904624792638717190430063059680799351572965675889514606153', '1.527515179860376253681e-65');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 3 });
    T('-0.0000000000000000052576336175273095418683503744328917024741423886898192072968825295608281835403325939628995766411924797296362311459317663462998083', '0.00000000000000000635138682360814339656226767395782178622304745960310840815806579774726400528516117064673477214645140209682965', '-0.8277930101792341563711820383870995947773403726418026909269');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 5 });
    T('14.510662', '-6460977193611710.382458732290006019458367086538', '-2.24589277522097021144960364847064895052756482295594419405304216930508553877595513258e-15');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 3 });
    T('0.00000305075352127112867790436342132153304812674804825099', '1145593318925749490712370981825229018726.0929629635595122268970069928215193250755895206273738836343252203924372011249888557339544475354757', '0');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('-0.00010409292164615733255094982837667284444963881640472653539261289047143443796793765346308903423063400761614619592811443', '-910008186461205239.127162051', '1.143867969484414533732048839930898965202065938776741991472557932224816704971e-22');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 5 });
    T('-69224654862065764827457960920931035032846898.270747371880524018589045953231029264548773980415492085057935536963', '27722.7974739183517122996227898377773462139628445426903600322572140365864846885180318665848321733332850952117877469580659938958717', '-2.4970299237366799314615107853411874721389361788061682389441515126234e+39');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 6 });
    T('748328219291816002567179573245615631918010310524147605072502032845081519883', '53976076527955807214798385812228741.42671549665780851140356826764262550967043918485146793472932279132292584518392976084673452210', '1.38640721487830756717514342962081532673049970583869580500187134917531707860796097770789341042590001302971710208e+40');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 6 });
    T('-66096336983025155007.5220511215740675352418119840246737832194293904729678484038594073569399935657025712484320547254202112738396447702225', '-47395071000079000864207822463847460164969086692962555384461096.91095392786373863613723947638365443737557314257197', '1.39458250801892419961095624497744143748492803636e-42');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 5 });
    T('258659989403036381662678196509125919573150803197965079', '-0.0024128949479267778078540054019202956570751016107942978992781301281505845332707173003934035748317893220323526695673189852303394867', '-1.0719902647451924184519408522873337172855140546829120811209098609498644614493683652023e+56');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 2 });
    T('-255669456502609829675.1754570053733971644767575667708240795171306472406606028703384242193104814321565455014432265673237865614999', '-160209080640356763214498353032787518205.81824768012172641778084256321801379237119003770288489188251214191941127578937229900265229222', '1.5958487214376195646051132916531607859987846926501e-18');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 4 });
    T('79332245721730794305433305.57125077116744904', '63.16069259007087721', '1.25603824892512581959792292319223137051e+24');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 2 });
    T('5646984399916039752736634417752740757912946759288778', '27102250627116511555658883115535676464038667691892505474.49934453626777172121212764261264232359174493', '0.00020835850415559525403700740238114');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 0 });
    T('-0.000001833204', '-70032493828.0462760607863944502271405984706585431640042645892591362349650922351', '2.6176477514868209438502651278222355064223158661452876524235e-17');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 0 });
    T('1643290537424155577796064755302208.463709290498773494124727961655077611185', '0.0000000000000021758574682770342707923991356114108943145438806402313572809257501515087667155834891', '7.55238135485687397818640667440855290096077122043429316369443181871884343547076279457111380079552675248e+47');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 2 });
    T('0.00000000000000001669225353724326249448998648071682103917420867656893815385345849552816287588317523521565176863936380610879001200667158874656768007418618', '97251151442885135849001043061692210364802177672125457972893459880', '0.1');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 0 });
    T('2232749647333352791881113926645372.34182416259209', '-1919220460056572909075401113153052783819875527740981924724295791352984029662689499.76611798540319163843370902120280294536', '-1.16336277869168714e-48');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 0 });
    T('9191674.4793132900722157785788553450700110648470547649053246813005103102798867779412063404788356', '27987515814537513427.54295693583755847320485566632537666454854542018912274848528', '3.28420519356665172912117731679711366e-13');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 4 });
    T('268544456176590551228416255234754012.978423972942', '42755282940.90691715500064', '6.28096547852933553492632311532241190003741515146399629261029875555487046371736315e+24');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 1 });
    T('0.00000000022793719926001557870302579145905527347886600946741374898155679045335596131204096937048478565755124577951330735710', '35792534427563863196938393781453935443.7999401092216381109498', '0');
    BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 0 });
    T('-3442643999906587666844868172078592801320762633923948733756859111208732345488468033455180794679714351516847250384856323399581196946136110965', '0.000000036014507575334065020', '-9.559047816231745969792741298249599865990162294983728442351441090864464819322143517836559818831355892530917986753014028183477511513031345894970186973963363057009372137e+145');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 2 });
    T('81741616723017006497822269553968297189299929736044754049602310386728770988752923740377486132998273316651271846247370444225', '81126403311021362988339148734237367331633947754186757315875171456.00', '1.007583393160387577305293909526638721713866926529770426708181568314812209839363396126767228220188033476873315883402864084678038379973e+57');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 2 });
    T('-0.00000025775621672283396732767630591013281284', '-0.00000000000113112177508646706263827769038192496', '227876.628670799078731022374792437747137208249884441244875762679381641243743018');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 4 });
    T('-1238055996867338715989439845494196.602994794912408122120948795262806329177848717052374938', '-349378147055192824558611337219704719883737450677311892640541798481423792746924344638864749321302858195330089126865026761152814882033404.742', '0');
    BigNumber.config({ DECIMAL_PLACES : 86, ROUNDING_MODE : 1 });
    T('-0.00000000058946410475204713', '-0.000011832888717583602387597691727694768559040334127243145271303547', '0.00004981573974207219321950980265928387761714878244676413448555988336825599553422671373');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 0 });
    T('-513.63491785227008061291411777776338954398572267897385330505688506258027422', '7463219701943872073370450.8', '-6.882216233276485231e-23');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 1 });
    T('-959552258348866338791129314756377976624367468137765850396480512899835638462382059570865324.45799673346664713198692357941260320331283378490142926303', '-2.22', '4.322307470039938463023105021425126020830484090710656983767930238287547921001720989057951911972958258858770864805962069426140555463215247303735419054054054e+89');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 4 });
    T('-77883119700103963752264584100183435.0736204991947993893718715649695', '2333460567880718719594262823561329375619353258748990.918298159216358793650603321367179889345579967711807431663116', '-3.3376659872525077302924522309136969705216916179e-17');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 2 });
    T('-23085170097384093274972665451689092687328238951119453595497082490949759588867071346163017183648834094422009033630029341272143696439695402896', '-18086866658375839947851624913063503607', '1.27634988046387741564665512404914275394621578213783045249404842019782171899530433736356246229042901270714260617530954223288074096395550492077535596e+102');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 4 });
    T('-1449068720600143437592.86874345113339256703842757704', '638423709046022938156322320162140640541195697853560467728060213175.52059634523456808011795512606785071804714042267000908673888494366196867266', '0');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 0 });
    T('-3', '2.190000177676247587968922', '-1.3698629025607');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 4 });
    T('-0.000000000000000000212636955011389414839466', '-0.00000000000547133250917031259091402456004843035767087076198801752343779161394408952098079493807626900940806528936571596926583827387986856031746662474220', '3.88638333815383938463911113305e-8');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 4 });
    T('4105803267451796098700354366317990626490793344.9427541580688128905741135112842298255240509063197472146451', '0.00000000000000000002415371770318597612543137459331265437239426595378149520249777367302756992574408286672', '1.6998638958632126100530099316755376351587863359383119895961776609478443848995573253450009639527748020320992925483242261075260845703161199802713e+65');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 0 });
    T('1536560320642901878970181558216997347019834883976330464476424777280620033456797921497798356588806450402450622059908047462407498', '-6368600156760249976930924897417348481170030471234872668542819714438402228393329736938892817571664495264216294', '-241271281415249111.58830548698631847070138657104720205374313339216470189795216775425226632343021943837');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 2 });
    T('6844820358486326194744159322308790843106744280320377008954541441044086', '-6232776150615393168477614896815395922933568579837.418', '-1.098197688009459932217399879700623500892903624890944427014883279240052795368e+21');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 5 });
    T('1204688342277055965926379717661660411720688849872516698942674329382163376498291205040236943207092922171959399494914.39011443079158181256672596', '3034517350117681138346738557210062717172939593791401204645.3', '3.969950418079953101894124164568887836138078905589854545003614622505225873033172829206408652910629734844182990422e+56');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 5 });
    T('-0.000000000000161196500013731342135880240572358905856843574326480831737185683677379073538753176666026540859531189671616672113637670083', '128440423109099451950325153756824777809528912713046540.743', '0');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 5 });
    T('-8021209952320152857.4878831448334373766839169468808096800382793135409190492245466152537276074399945804162378509725564895492004776', '-12294.73904503469', '652409939156827.4442134394077978312360046849763214154626418660528098970087455');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 4 });
    T('-0.00517388086766833111733245112786346947323639422972973966551869774864327198718901177259417949555417334912135153898206114320954172867814126447584055', '-0.03517476661743945594675386610533927084329952861306622597741716386233453296240601914139672354527111013300704519530092', '0.1470906949842603766410501906977565055631364274063897751633');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 1 });
    T('2573184278501499.8946176652926360190865431824560912727401079791346260554669708241862345911576291903764866699897164309950153863449330050713632041175', '0.000000043241501321629753526820632045775520519389477498990882842872887482968503164029794600119774116937359114105067670589634593793488348204314020725411100465', '5.95072835090110994658531253952277104918859305783e+22');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 0 });
    T('-6940702240308624593019484948231957948843766.184509559555320218721368728491521296608512372180710521266142766421504400057555709716770169544671', '-23375842193663737842275569.6936158276446636235603347421129063536999054607538810111679250798539565263876614', '296917740238252174.47986428376657061330786593813063');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 2 });
    T('65648425.01180871514246724305614457967515067023467295347850669937619354644479642108771771127641', '0.00000000000000166331728135031480258375999655996342572341481785346', '3.946837187822276959776576071102153502915106781806411650618747392665080222989322793033450482203813683884929e+22');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 5 });
    T('1153.8', '1.032', '1118.02325581395348837209302326');
    BigNumber.config({ DECIMAL_PLACES : 93, ROUNDING_MODE : 1 });
    T('599854675229234875531510843632464421316765301', '10692666448967456551.17357142627520572161147276567490382868418740', '5.6099634089601680710080397632397697057201190308769900155756132849191067585240528670316228985292264623266972777421914641e+25');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 2 });
    T('-91003154193327422318054977979559798038617.24475602943727257350', '-97164.43555398453386646402573925477261096177733241758254990430', '9.36589130317811548377193954259236823396468645893594190648495337e+35');
    BigNumber.config({ DECIMAL_PLACES : 95, ROUNDING_MODE : 0 });
    T('0.000000008923846499877102966022022724927927305505623352384958714910299624734808349340038032388088533376134576612671621098639464445', '2323043673890365404072353101065788418599089133008528.48664319918012059564599954103135', '3.84144585836928106349595541556116685e-60');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 4 });
    T('-46799039556564983375609015238952166942332338.336', '70591564515825593103568139941828658075146291678283188216481741557727018642248891354.59565', '-6.62955126119542587893e-40');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 6 });
    T('-36.1179461029742312522673847078996883965738928503', '-100569467167841102140550919449278060898188922968819.602233099844893563645024785643324195812', '3.5913430905124e-49');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 3 });
    T('0.00000002479295909306169487242742853847942399677274865352201616277394801303697463391770681143478578', '-975102087.940198171467818631687898893644299737144418720321072409833167062645', '-2.542601374737515379702975646189299020480969558649620454043232922284568672e-17');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 6 });
    T('-22704.6514007298851360157029855944029770', '-0.0000237259788727499103563872516086869904668403642073415041045581124411757882484640913456570', '956953199.802725341519292592452059918169329599946179917320348608125261079184320112813');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 6 });
    T('0.000000000006696949688432960159969756123681564135755842', '-2108422300081693781235179093528225050930052974845697.955570499448273929659693052830371912141313813942220496005', '0');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 3 });
    T('388544724722977238072599.85105881568', '1119502301548081', '347069161.1671419201048623305561411516977843187446263880418');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 3 });
    T('2499833150241992476861383217158', '24842.806938577597611681288280499261519959074131335827532312007098774218994152805597', '1.00626034587101419900384153906414128379e+26');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 6 });
    T('0.000000000000000075207971460109815781578029738530719182', '-0.000001252114075716431179907851124948371096085525196590897471', '0');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 4 });
    T('-2431215342181996772981861978777959489747291159041531887.4260610078297188041001258499984761128614584389853180540573473285885761798543658353', '-0.0000000000000000000602452416497034439753397868859220924283164668346443307865392234488622501612643356251294446058052370612921519704379', '4.035530899383427708420533850950801617603263881782841628213157245563085253796113721165322376257920697853813979429237609632e+73');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 0 });
    T('-407831746738950597449364836360790405890616752952418.9819287191146342464653389498070582', '-0.0016562936145919801805083922955297251024054241416693402898660748687576109090725423948840534145442012567640833878946340376579461613517664', '2.462315516681007978854774489192771647323890746368098663553118408304656288381857357663609206216e+53');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 2 });
    T('-3374732972793083645750776092246840863415276871396777646.420558762189352107316007310937411', '-0.000104684541074035590084725187308919085090334423139351523445490833599909272825834065737033457170315371799582109616299652457425059891608379866921', '3.22371664256175704755746904789107482221884721469026471438546648065568416093642164068502446507190361997825460584330769561155220142746e+58');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 0 });
    T('-2473283609019884187026789617880425.5292', '-0.000000000000000000012629560700156750844742128651038940562337604172', '1.9583290881916322023307410267121451340090794305482720970277e+53');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 2 });
    T('-1404482098715017500566440471472979845183069261054584897287814242487239267004568787170554993685910209103145003498', '-1617536252667148116081061850408841416455174665207754497642731794305747363754.714903728875245403788805437786097579', '8.682847734628348531930390594592919060197228137041571171563249190604755150351229996013258337462929641275023754412046e+35');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 5 });
    T('2168165259874', '0.00000000000075588149586060819104186427987769944909836644183903985432252629601447845760197250954050695394086860163', '2.86839309038176336264134620990047211480103555575604119209136497e+24');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 2 });
    T('-49999037754203038494748194130135480756653249820.50', '-477838183854181143128032706335056029040474575.159731344891403379', '104.6359195301582024018051689988803119224761424364673522247848762110933344858');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 3 });
    T('3384425457979559561425092835866696982506431871523977204902603949.76146368711218894575822938101642716816585813052249478551420475924034476', '30321929004931437310276217291757920766818622486697561816.3163126783639034538589498855266374840067252586426724325300151111694988282999082345719', '111616429.72744676420247993931734393915595006879474992');
    BigNumber.config({ DECIMAL_PLACES : 89, ROUNDING_MODE : 0 });
    T('-224818432373113057932269131568462251173627386571177801533800760.32409', '-1695376460710.3108459', '1.3260679122495366951431400279524987016153243439210812707665894116283984110338827213610756814616975001334055919534976385903817839190792064322e+50');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 3 });
    T('-237.578', '84.91553751340315592695506241570789130308896653823', '-2.7978154170254229823460689077145936');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 3 });
    T('-103772.11', '-0.00000000000000000012359388598271456139794552736048812520958193178449264362833512730122738103677292334672889946035166832053771059016318012811', '8.396217108548009367707120637040570491415491600095837475920856749568873747971260965596560371476662507942284833617000732e+23');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 0 });
    T('22909648747874321834002861748166913834938225445334337582075.91577617352530837700404418138563', '344997348755274633375686780004807427237266721270788600978798421.31667232973698994105219242156804410304', '0.000066405289288542853704464526792983880279517370745526436521714');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 2 });
    T('22.7093', '0.000000000000000000031482402641136721681302175040141334303861664544258583558677552712724221091570109031291009573901616627307034449943797019159196295837', '721333128823107034407.245588580283601865156902265694027404835211281464004207920098622691');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 5 });
    T('-53.3482008111094893315', '-179875603511294433120572352881730127395532524029934609151628237104587157.20139982', '2.966e-70');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 1 });
    T('-0.0000000000016965884607882112341570473022123635213887877', '-254193932392350141293665499056643496334844702171.0011957979', '0');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 0 });
    T('-3608818103.6257', '0.00000000066687566458790594', '-5411530657451355102.96900423991961831653534633882826719471593894648307767');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 6 });
    T('2318242408326881364050125597979239', '112310944635701210834391077699249659690575868442.76453626831', '2.06e-14');
    BigNumber.config({ DECIMAL_PLACES : 72, ROUNDING_MODE : 6 });
    T('-0.00000000000000618702564082704832709012756540185267449760034770120968177308119606015', '0.0000000636992736953289541753851889023710808159676823930954566680270109511630825121023467230722909747266089629998915475752295286219924691553386019', '-9.712866853740501579238837122769674331721942058210092878959040848e-8');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 1 });
    T('-598192155524599.543469895866422907968312515845807798812410543694536906451748175', '5694882.75800932980130397772', '-105040293.3551699886292866504040483598198656759423392804848834787366');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 5 });
    T('-2049743760490918742562713287128097078960201454.7049014175851231280129287812874', '0.0000000000000005771177413168', '-3.55169077944831902790783522124802412003623956082372578582048268563797255797286310356936e+60');
    BigNumber.config({ DECIMAL_PLACES : 17, ROUNDING_MODE : 1 });
    T('-0.00000000009884649504038136938680320284773210466871053456420299408286245343032575711592101304225442', '-1098525608842646403217112781968194558531214', '0');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 0 });
    T('-92318581224219215407076957352744169354858712728142497119299358628912215021294586712890999326827690277362149690350438983927874511888748137479592656043', '-290760936622051110642', '3.1750682294788645045471768037259286560603641852570628867381214349882098982439068147409937961868755790796593059293749776446591995499123894524476912116518548983598710420846017432939463458659085485919e+128');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 3 });
    T('-9269786200775977340361260306515894998.021', '33193', '-2.79269309817611464476282960459009279005242069110957129515259241406320609767119573404031e+32');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 0 });
    T('0.0000000000000523838637138708498596608193031525072735103662301710366353432022220335881062938126235613172748770850903840988895888', '-0.000000005390098997912356392648612061230099204506807958291145755415705955992896925483127908', '-0.00000971853461952362777213043286495');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 4 });
    T('11958219415768809322523664.23510148866112269670', '-197354727314347918145898028040.448589287170209', '-0.00006059251571269269954205910357');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 3 });
    T('1970642653364229432816602515045582440712477643422054228961879708118806395724379583117602361343660652032', '-31644394765386367730800662519558297968988.94299193490', '-6.2274619817339032278732958869917127861770080996927559003305288e+61');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('12.908', '-6090845987261539127416937275863176894837056503709934034705496307351876662575410450246138356839229866026764921029348319480510482423385605152870', '-1e-81');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 5 });
    T('-3739413063818.436', '-0.000000000112265754744654239729057667928492728400303558521884186145185975438813258745093576284952622933', '3.330858169816469071325141276282506e+22');

    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 2 });
    T('-770817.6149120', '1', '-770817.6');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 0 });
    T('-0.0187466210691', '1', '-0.0187466210691');
    BigNumber.config({ DECIMAL_PLACES : 167, ROUNDING_MODE : 5 });
    T('741750111.2', '1', '741750111.2');
    BigNumber.config({ DECIMAL_PLACES : 108, ROUNDING_MODE : 4 });
    T('-658788.8898', '1', '-658788.8898');
    BigNumber.config({ DECIMAL_PLACES : 175, ROUNDING_MODE : 0 });
    T('9.61', '1', '9.61');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 3 });
    T('-0.0200812135393285', '1', '-0.0200812135393285');
    BigNumber.config({ DECIMAL_PLACES : 83, ROUNDING_MODE : 2 });
    T('0', '1', '0');
    BigNumber.config({ DECIMAL_PLACES : 227, ROUNDING_MODE : 4 });
    T('0.019711206', '1', '0.019711206');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 4 });
    T('-37901147', '1', '-37901147');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 5 });
    T('18.9', '1', '18.9');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 3 });
    T('15.5', '1', '15.5');
    BigNumber.config({ DECIMAL_PLACES : 290, ROUNDING_MODE : 4 });
    T('-7897.752568795', '1', '-7897.752568795');
    BigNumber.config({ DECIMAL_PLACES : 111, ROUNDING_MODE : 5 });
    T('-1251.5193', '1', '-1251.5193');
    BigNumber.config({ DECIMAL_PLACES : 183, ROUNDING_MODE : 6 });
    T('-322.51', '1', '-322.51');
    BigNumber.config({ DECIMAL_PLACES : 279, ROUNDING_MODE : 0 });
    T('-1', '1', '-1');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 0 });
    T('-30817.8', '1', '-30817.8');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 3 });
    T('5945.68390922', '1', '5945.68390922');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 1 });
    T('-34433584302.1', '1', '-34433584302.1');
    BigNumber.config({ DECIMAL_PLACES : 124, ROUNDING_MODE : 2 });
    T('674578813.88', '1', '674578813.88');
    BigNumber.config({ DECIMAL_PLACES : 124, ROUNDING_MODE : 0 });
    T('-27788.40581695', '1', '-27788.40581695');
    BigNumber.config({ DECIMAL_PLACES : 166, ROUNDING_MODE : 0 });
    T('-0.00000001312054398836', '1', '-1.312054398836e-8');
    BigNumber.config({ DECIMAL_PLACES : 259, ROUNDING_MODE : 6 });
    T('7285863936.63', '1', '7285863936.63');
    BigNumber.config({ DECIMAL_PLACES : 152, ROUNDING_MODE : 1 });
    T('-160424.958593708', '1', '-160424.958593708');
    BigNumber.config({ DECIMAL_PLACES : 152, ROUNDING_MODE : 0 });
    T('-1', '1', '-1');
    BigNumber.config({ DECIMAL_PLACES : 181, ROUNDING_MODE : 4 });
    T('8462674971.041', '1', '8462674971.041');
    BigNumber.config({ DECIMAL_PLACES : 230, ROUNDING_MODE : 4 });
    T('0', '1', '0');
    BigNumber.config({ DECIMAL_PLACES : 286, ROUNDING_MODE : 0 });
    T('-2', '1', '-2');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 3 });
    T('572.2', '1', '572.2');
    BigNumber.config({ DECIMAL_PLACES : 193, ROUNDING_MODE : 2 });
    T('-0.00000078870910606', '1', '-7.8870910606e-7');
    BigNumber.config({ DECIMAL_PLACES : 194, ROUNDING_MODE : 3 });
    T('-1.13508762818546', '1', '-1.13508762818546');
    BigNumber.config({ DECIMAL_PLACES : 127, ROUNDING_MODE : 5 });
    T('-66055.885279477', '1', '-66055.885279477');
    BigNumber.config({ DECIMAL_PLACES : 210, ROUNDING_MODE : 5 });
    T('7', '1', '7');

    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 5 });
    T('-3627799291965346540712456501882577638718153439964273.69768754745407377945437075521783565726672078877524231088948196974675990545252844538838313048', '2902582598160223924761958365823830027858536030974673247874848195750710639118580059329', '0');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 4 });
    T('-36001492.432242546296733753651918782904968060628', '0.0000000268571386752795633902', '-1340481309923749.60424676488025244368284003');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 1 });
    T('0.028761002817864251956109170412427462717070528743863157542939339484227653369339502297446', '-0.000000094653664305603408767633117494180308734767461188738807756952982012636', '-303855.1442129602517346583444983127341880783118168865288269447897099302126198776');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 0 });
    T('-85322335566464', '6469888.5944307193591905163370', '-13187605.060141139610979582454208887767681099267106809857522822603509317013524918783027403');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 5 });
    T('16809851622.475024268444162553728588984396380486399687835621352324230348800918507804359930399204804510891779303641052273377163383820147883', '-57215392073691534065404484981855847094198821321.61', '0');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 2 });
    T('-6811137700468.4120764694970441135733', '0.0000000023059798665870351445075811611361310997931893558813170397607609131', '-2.9536848084234293518878460220105623971538070065410169e+21');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 2 });
    T('-638779241138332540350253234404280665291777745188393412936839021876823463401783663308918096038128976596374.561', '-68051131834015582432107963260604318921316821583135690566786271984905882370557171397765996', '9386754105668476.6600599');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 4 });
    T('-14657920224077.8196317636342', '-0.00000000000465223224472437622998002168098960600459077322855753439284117569067355580658376103876790291367613451291596099691519239625284134126680082838843170451', '3.1507283929558497932940390469545446644371974034666360324e+24');
    BigNumber.config({ DECIMAL_PLACES : 80, ROUNDING_MODE : 0 });
    T('0.000000000000000799413784708489070154804455019351539040017795947686353303982626226154902676475791766853951996180403160495135659', '0.00015899044548165972', '5.02806179507626533025725613512141576199220345614439279312943689111263e-12');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 2 });
    T('112.4', '-247122773803885104678938490543776215767287187710036178178642833042340408207332559624129671164074382472407914940407329096987525835763247', '0');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 5 });
    T('-6749239072680037611477387165520399718627171261275656871594447516707739157447375453.0850906452508074838041592952394', '-0.0000000000000000000425367400205957', '1.58668460944871412110921030222520659939459453295210959028883529105346640505416908988034240818782790363642220342859700167068855612092040209711e+101');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 0 });
    T('-78585520044519312578903851346721582390295041942545224540.4077480063430', '15608189483426918496442359748.328547440633', '-5.03489018556335172543283965718069901158499515404324025173365767509373422432477748944903e+27');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 6 });
    T('0.0002433958238870374223584900446577514807866249098', '-974085668642024438754153215750261556218494099322336875511140345748788013.37160781313866594498158089317715605416277197000420491691481779975851730965', '0');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 2 });
    T('35355658849855129861180132974521949639236227942273180070920909591997.5412718864453961655409496833643232', '-6829894701612572880956944.30', '-5.17660379764090344784461795557673945820085318e+42');
    BigNumber.config({ DECIMAL_PLACES : 84, ROUNDING_MODE : 2 });
    T('0.0000000000000004863277441095313650020277658', '-1915156649006139193824415428828548.226120476308930617348969557716204059468127709020706212182973396317634270963094', '-2.53936274279134646909595038496863193e-49');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 6 });
    T('3110214615781612992890984598602049585353025840029996756.8', '-12363633.735703916761979890620833004650965570622978', '-2.51561529746702304379852124316472359173133213146019874592196121688793016060937069742986516173e+47');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 3 });
    T('-2492672185265151812046174378926367157329542788.012959590780989023454605', '2952729318474530090870658399786053537408219.3906284777551455998495603485592436', '-844.19258130743328424729732809565777445198353443');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 4 });
    T('-0.0000000000000000007320310887201006223680530966667619613517348866729624512960684347441584440958295121362771380217317647500564562116357111207761629175246399818', '-138414223976457986589511933703538109754713884281537728200.91943242818721', '5.288698427732450616331e-75');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 1 });
    T('10999864907092520920895380713856004127397682.532596580677990930328362005963039243358204558185910', '196343713.6849006266166504', '5.602351458394789894333113940137448028976772623932537000358638579200945e+34');
    BigNumber.config({ DECIMAL_PLACES : 64, ROUNDING_MODE : 5 });
    T('221045710673710276492009437067143592662773.856846445724783089474622164404197148759178814745808223790625805135636', '-0.0000000389477677414362297767674108298752973871495647000802842813777875775407282', '-5.6754397874911185057037157523236644823930384830352417175752110746497657133548282615982344419113556016327559255673e+48');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('240678363889896535476608890834256839099354200642282132.3567674776854817276669811640194672649868976944164254551737266436840749954620074', '-0.0000000000003270561052230022070885151941886998875327220508415003856939907938256551789027282736470999947552147075245018856709429461672576524075', '-7.358932001155909554704741657237282173970051372138657023587316029170115689537846892416866064347805401735668699561439620407617493743577191366190959232502857112108757e+65');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 4 });
    T('-7.178031909440888369704885323707', '1516020040884738327154002675958432784538802896161509426211008572828005010593393496212499875624324908766875671036834866713', '0');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 2 });
    T('54965252469790288.652938530020939781427224341939297915034220301430902042349180160604051708024915967324883143322801228723358372853', '623946023243580345168323881734.4620771717220859', '0.0001');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 4 });
    T('-2795638.1', '-2161096419.94539189', '0.001293620254144256162867799066739494523291287326399017485930407237805526109189927');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 5 });
    T('0.000000000000000003852018722689322934971027565056757680249879397479902038546745253385039422647290', '-17246108988600613193981252482413.01314088520161996158451216439550151353590714427134854025418012751181842007418232652053551313400069601766742100', '0');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 0 });
    T('221801304731867898722038636258624536262037365890856604315282884653157', '2094327674927908258391134166024509186528722409321102998398672460295465253591729278.96582716180542732018913846048640937', '1.05905731651806982574099150484324282372652447760899e-13');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 4 });
    T('1532838983776695487599528998729549071388657144993487023435228991.9', '990.589', '1.547401580046513223546323448705314788866681484443585607588241936766913422216479287e+60');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 6 });
    T('465700444880360273077764592.7986182609', '-2503537671301153955344095007925259354071482854', '-1.860169512202001663e-19');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 6 });
    T('-737.9477460', '-2208882228473942560046621538408466604050799418518411.359689327180780337087341150988044640763423839783525726874628300323581490779705', '3.34081978879348533408762709794460530393880741912e-49');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 2 });
    T('-1780.935', '0.0000000063599557312757408886184969827919637733185077905549489709055686000144560690972584654631309913966808095690705362617488552800127402759644403578323745', '-280023175513.9532999919255525243358694199755546');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 2 });
    T('-3174812496720.2024472161401049345990356687496259647362835882746075189931008133652106507076289350917733050877266685', '-11577402298228661788066668885649046899568558593977323012221669916977009075263.68987879858', '2.74224943985e-64');
    BigNumber.config({ DECIMAL_PLACES : 24, ROUNDING_MODE : 6 });
    T('0.000000000000037393089998235', '30.48028567299956', '1.226795917e-15');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 6 });
    T('-0.000000000000000014361552929811982736615965481580567217525637319317240063009008734218786729641811914528272953', '38894055.24', '-3.6924802109711773877287179688750211220005551983e-25');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 3 });
    T('-1106712834746496271590139438978918.284493457211966539186940267648623517601413699972073', '12.651903442803950284122677894500273050579262355162185398259009250085918287743090096911728314267336', '-8.74740184154632998685570715135187099129190523606826573808969334655308536685525947172863935518914297815606e+31');
    BigNumber.config({ DECIMAL_PLACES : 19, ROUNDING_MODE : 1 });
    T('1965816920105.701', '193318595333060825523082692725318850724848310012764635800422866840602225944616048379730199886885832561560510098980592365407100269336056728309672617390', '0');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 3 });
    T('-93640040324023752251529412531185332867956555140665056973180546778724498284012702822548570943019087150145776861957801211909463864512251577824034', '-143231624126283297491786421936221797175607422617226.013004717269172628467439784881071187990876523911857290645231919390', '6.537665190577184298014654831331041237300337917886585974164714424079643658287946824279228245192047128164615398717555388e+92');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 6 });
    T('-12131310205530178549986982444919200922452750101913903755227517798481860220928943578277008850211909085315660306919866449158279174719742979917858572', '10099444477949939699307890962009803302145119975370786040785982897958245734502493657340584708838245922196599201528769240812710', '-1.20118589017607848240663555410549241113804583900945574602316648957593596767104398128e+21');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 2 });
    T('-155911155981121697946504715907032', '0.00007713234002563812643249182407072677029361418001885804605134796432669022', '-2.021346116678142665492634136637705651399478440912868181711281002264263231182256160625624195021327e+36');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 4 });
    T('-314519720816.294641993510410042', '-73900264788779898482484025551.2789786937107751050093524120030925959202365579923494746768958358324131625416622963', '0');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 4 });
    T('-0.000000000000000000022056684946133452223154877758058559745782371622496016852274708161609469345202799864210511471961718727568797250983', '2192.4', '-1.00605204096576592880655e-23');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 4 });
    T('-36718441550169372371365706865920954220515130374010754420775299383130574258014428968818638300100167261047519525107435192917209537633068.6987406', '486669343803413216.6570235994569604541241883174903', '-7.544843746106501830550929477783142021319040138888657861453606554546672602582819541534595959892887319664966162568994848849103211961019778178e+115');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 6 });
    T('-174897603.6829025255536616965100335620728022186021824024738814468540609170297407222690674769997151788917219289220320647', '-3090631934656302827461849613845387320538781882390263576900269.96203524879585780492687738568481060148212201875530310065841371200747460299396388019057826', '5.7e-53');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 1 });
    T('-0.0000000000000000000516635551329299730054951454997484763051286676348350719016083089595328539668314795616230172195369791117989547921474840417479838289', '37158674757939157993806627436353261.1693133803498125', '0');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 3 });
    T('-116211456037739778354514403171070990290045964305800566666581525149565486.32', '691105844361415778213381366158312468', '-1.681529059345744224343857153033090610271694090791790398037247261895639783202993203557556001605441340067039008803140995633541845972971384e+35');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 0 });
    T('-266123221842708273091923489090.44699490158783091683586819391224186615489948199901610194471068906250718585', '-32022496369765241675524333697024321255620899023355408645576679616065845108442066436105122545172230348409185.3287445324413516115', '1e-16');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 3 });
    T('-1797688265425.7165515', '0.00000001738534543188409980783340157189761914309185224423152375400233581685255509123238', '-103402504854969448367.9442019148179289847567704024747005025133086683014233516225496372066135892');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 4 });
    T('-10984212754657202637672673959837294920049108', '66798422529499247294838021394095462563622966883604447314209247', '-1.64438205854433154292727033196794337117905605306943236068e-19');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 6 });
    T('-53728320914823485656962471346789246888085720599563024297225728806563759597.08997812964997715166804294389691757990554791437598952982626', '161986897.212190847247930402167370789598105972372356016401292522857077503612014300986685393882', '-3.316831289412461645528953055028515828986318158340012081483263853064100616867908460183631017188747235206664340288823720112312483935290441934775455091087550590435261e+65');
    BigNumber.config({ DECIMAL_PLACES : 62, ROUNDING_MODE : 1 });
    T('43499319623237565178359324186732885047347808350193390861109947292568223373928330829578849395492942843044863204487853834423629319010077404', '41.61584639', '1.04525855885728544900944700422643224407931616142707006135481718584285228504584382741371535986902567099380489626244638381422162201060732538906317315441244351440427353999563818555319307059754840660829e+135');
    BigNumber.config({ DECIMAL_PLACES : 12, ROUNDING_MODE : 0 });
    T('-0.0000000029566841246534331279657636450833574893146205734156302396324472852389800000520273047202036875', '178293878201991423271468500825009131886066263126087140735726743237756163465204105131686', '-1e-12');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 4 });
    T('-53285984.2730196558626413', '0.00000022251203859045276846118178068673238976534040397169920739300651950103910444091385416803551627124476836809100670767957171883776738529248470267338926312', '-239474612747114.418096957880031470643644150387920667074980777785');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 0 });
    T('-0.0000000000021241416901713887978056248575347198323545756122975232381823836383371939553270979083264153498307676759237644777281660799420859049004048904361204700', '36679048355616055800277781408267813021767139312403514628691728644295598845421524239970510639806879.6945149256633616388109328661753190177005', '-1e-41');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 0 });
    T('137574367839771834643.393381075516790041905084899117844552825342262', '2611019781396503523904141094448721642995445153136976323137569094666196747752629789123.3341477720667223549496535765203833491631689201904030781304366462', '1e-21');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 2 });
    T('-46528959.7394442732924916035177731048000767876497850170219980388259', '1037248701397072471510989839316688758413582838330610129126886393101433389394585975632286834135743.787548166373358914448', '0');
    BigNumber.config({ DECIMAL_PLACES : 13, ROUNDING_MODE : 3 });
    T('-0.00000000056695591361167840304172988714223322951491340767159863538777178312445969763826386935046712059795678046539270261679031967257607760440924899096022660', '-779029210176534831045360217249568.30980168036216148309578587927769139848738105890895104989746513915926410335893309428593918260725239773017045566033087', '0');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 0 });
    T('-13536625136815780.744306114543699', '2.3', '-5885489189919904.67143744110595608695652173913043478260869565217391304348');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 2 });
    T('3828596461558459272689391034.819361202105624858791543660878267672483858601126237474504353490573335717987597176461232833', '3961994280872253514567880', '966.330638093595121842939810134710239620276');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 1 });
    T('12599638221152309.759580', '11336877437079.7', '1111.3852373443218654215797135397663113');
    BigNumber.config({ DECIMAL_PLACES : 56, ROUNDING_MODE : 2 });
    T('-88.37874582921555583012595131704636995244428718407695437048798589292198100811998511949731349', '9771661424624630602696201302125658718468318947410559134582776640149515206573413089145551182999199848.976786489964321075171160128096611871174701344', '0');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 4 });
    T('-2927120046541815610111604317174084416389151672310745506669425625751707198319307905481195306939915434378276670663938336984100459602882414666739238', '28375670960860533566126717597042623586721711867346949078603553.961690252700453027034899981369000418', '-1.031559764905395713608499094713689979147866827815838375742327221955329968696830466391247813620712877131843983043022446116077328828325714886717168694179208257626570794495812884425806e+83');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 3 });
    T('-19470574904101509325332331844986037767740399660560019057.7119', '-492073026322248393605882095057847550345748645576816340124093551078296738464192541723849045789', '3.9568466188086958171880465233173766690032026629745e-38');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 4 });
    T('211872876026497009829063883393233809481191362190883849253684099737680426913907201054617907234117865033184.403186292426187511', '0.0000000000235411610950606792007241228964067314935178706017234354189703612990579977911087014870100085875178570060549626', '9.000103060802358048215024300287481951213931206246371042229672906316070218904715481032206444135472089495320677006553492015303007635540926239602846226244158732372969514391243502512e+114');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 3 });
    T('-5844455100853651376654250475252964203821845263432078985483833480198.51472537564940283680797304546064130915324997343772', '0.000058497152341298204924493051718564688435050872861886324684792417903238087063888341977808292118', '-9.991007881468350499077540958997813363816099982733021160139526414847479777982598244125723450988545976629726106e+70');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 2 });
    T('-208539893283563850007.12643120990936066514350129267100171', '0.00000000003593389363501178150231050905656637424998749048521394992496271441393538046117383924866658559', '-5.8034315847246614933801374673895793847064415344319377921323484677322966821185e+30');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 6 });
    T('8043645587396641021732938502681359817543439337253058801052675740727721571730611228132672600646378605923337', '-1323168.0924182', '-6.0790806802907468246561587887883818559253301923676419145425764182242811472128643594651107453686007508486594959358274782215931402672682865301655132211915388078279766064418822e+99');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 3 });
    T('5345077442239697454774886011336423018078704256068877803956836.23670510981228', '0.00000000000000011060002574332742516535915190923257434052767174581226361318129403016189732388821484995223249750300118960318109112292', '4.83279945580136505083168821214294440490791659361794451962055705475361639771415302893151132245139970562331724322926429058741027119693014735827818262705360391630191471509021e+76');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 6 });
    T('37380113626925218715479908638517128519818838419387968758726972455361593237513712458449673118747923669546576138252264740929482975939', '-0.0000000000000006801939143670958029711273998707649', '-5.495508389207880808350127256226214657608101009599899937862259967580635635162812932348658262637085316678783747639804163466588837613458273577204072680194370104490392648318243300970515044257684662231363345437817216189655097e+145');
    BigNumber.config({ DECIMAL_PLACES : 76, ROUNDING_MODE : 1 });
    T('-0.9240980589910997704959111664719986817089775045950366247068688279255379005723485652', '2755.6517853', '-0.0003353464555720329641810317761965302698250818448919198516365858150087574131');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 0 });
    T('-14735206357348664992865735695185105417857687409468279761627208898647639982660985611846182127951822610594979835', '-1101.435920065550795028', '1.33781785112580264818549467778872109422330749864153338258575618875337349603120233840090224841974504016817513947058883351448908524776104006557258225856439835456989256889447413801105919735883507e+106');
    BigNumber.config({ DECIMAL_PLACES : 79, ROUNDING_MODE : 6 });
    T('-11526.519029803437218611745', '-1980641645745226278812446291533504566961012681.6852819482283250153725775125045633888369820790039112495797481', '5.8195883412653009499001562175289054617e-42');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 3 });
    T('-6932745342923694183863.4407712889787388', '34870883.827073144167437289748257172399669498831227487', '-198811861990754.361');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 3 });
    T('33243257027', '12751607507856865851589951449477366328020361795144300426079667590.64133288964626', '2.60698e-54');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 5 });
    T('-1069197506689172.41', '1533236526211500507519256343794194823892728051.876524428551329407055560589140164359', '0');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 5 });
    T('28.66476546644904598250037221', '13561.3771956', '0.0021137060825761378236596338190565475019637983');
    BigNumber.config({ DECIMAL_PLACES : 40, ROUNDING_MODE : 4 });
    T('-10.096692387169004444076101', '-7410.64884007451703882184197', '0.0013624572699449996017890531485487416503');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 3 });
    T('44.7', '-0.0000000000000000301026373988561927150', '-1484919723402656472.793582');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 4 });
    T('3.56894291995338299991755', '1743568375310759.8', '0');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 3 });
    T('3', '-826.135811839846027331161', '-0.0036313641861364767959206955234182098243004715472601430821909469785');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 2 });
    T('-1808754472.784798621211119', '-4.80680493504930', '376290383.576019');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 2 });
    T('-13719.54124584038123510031', '-82799.7597925792605642', '0.165695423274283022702');
    BigNumber.config({ DECIMAL_PLACES : 38, ROUNDING_MODE : 0 });
    T('211', '-3', '-70.33333333333333333333333333333333333334');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 2 });
    T('3928.421774', '9', '436.49130822222222222222222222222222222222223');
    BigNumber.config({ DECIMAL_PLACES : 66, ROUNDING_MODE : 5 });
    T('-2004652978881980253.113402793', '10322816999041770.04392455520279', '-194.196310858563604831647952256897110242003406104346850039990186256351');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 2 });
    T('-2018773348883.71465054', '-95.6599547821640', '21103641053.153823906720595724139611921871346297547041415');
    BigNumber.config({ DECIMAL_PLACES : 47, ROUNDING_MODE : 6 });
    T('-4', '3.4', '-1.17647058823529411764705882352941176470588235294');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 4 });
    T('-0.0000000000028137592443635124', '-13000014', '0');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 3 });
    T('2493563679699245721581.10118959', '-2.3', '-1.084158121608367705035261386778260869565217391304347826086956521739130434782608695652173914e+21');
    BigNumber.config({ DECIMAL_PLACES : 37, ROUNDING_MODE : 1 });
    T('4263', '-377673230.165946', '-0.0000112875355188051814813466004829001');
    BigNumber.config({ DECIMAL_PLACES : 39, ROUNDING_MODE : 5 });
    T('581039154', '126.1997353157348695726852159', '4604123.396505687590451186522030874068448145555');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 5 });
    T('36718233569568035.5623632966', '-0.0000000000000000004253531230970461102986', '-8.632411889259977432652492553440731066395804170439188684436466736195285017185879275448308e+34');
    BigNumber.config({ DECIMAL_PLACES : 48, ROUNDING_MODE : 0 });
    T('1589.0', '29956064269104627619425204', '5.3044351411638043170732068e-23');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 0 });
    T('-1', '6430.54347880709805273799', '-0.00015550785144298652946840350151154071856470065693057863326908156052');
    BigNumber.config({ DECIMAL_PLACES : 67, ROUNDING_MODE : 2 });
    T('0', '-0.00142730507727', '0');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 0 });
    T('-144192.00037156754667924551', '-7.162', '20132.92381619206180944505864283719631387880480312761798380340686958950013962580284836637810667411337616');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 1 });
    T('0.0000002125446846991632617065', '30187422146964858.751132393', '7.040835870794392858896523523804956400228144991244039904910599480948e-24');
    BigNumber.config({ DECIMAL_PLACES : 23, ROUNDING_MODE : 2 });
    T('-0.000000000000766736698720', '56374815559565768750.730069', '0');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 2 });
    T('25544518.93', '0.0000000000000000469', '5.446592522388059701492537313432835820895522388059701492537313432835820895522388059701492537313432835820895522388059701492538e+23');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 5 });
    T('-1', '0.000000000113429652580411765983', '-8816036876.169455829162161705581854144993945032508218');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 1 });
    T('0.00000000000000035422355864762072645518', '-1.6', '-2.213897241547629540344875e-16');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 6 });
    T('0.00000000000000026', '-0.000000000000260917323134327', '-0.000996484238289326852105214922572476320767735966922488817544716433433861636109648679809');
    BigNumber.config({ DECIMAL_PLACES : 92, ROUNDING_MODE : 4 });
    T('0.0000422503149', '-73.0', '-5.787714369863013698630136986301369863013698630136986301369863013698630136986301369863e-7');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 3 });
    T('-0.000000000648027233537154668482004765', '-134504033.997745367898', '4.8179018448473e-18');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 0 });
    T('243894540410762058029407888', '-0.00000000000000002232190341731310376303022675', '-1.092624297539048035018341587483106663186005083e+43');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 6 });
    T('-30848889531', '-0.000000000276330963520701001', '111637469568946777225.042184589341630228759558909484344277094396913777361082423533527');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 3 });
    T('0.0733847676285075658223', '3200754441.76241498', '2.292733446558933402859704013400566526564506089725566867031e-11');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 3 });
    T('55459.7094802769', '0.00026', '213306574.924141923076923076923076923076923076923076923');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 0 });
    T('-3824411944005565', '-1944006272447294.9050169336', '1.967283747079191009528212074542465311767640289');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 4 });
    T('-49988911.88240', '-0.0000000000000000000602946', '8.290777595738258484176029030792143906751185014910124621442052853821071870449426648489251110381361e+26');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 2 });
    T('905.265', '-0.0003762667212876294', '-2405913.0100639133708110280512999354206013620719162208025088154429338195961215800157338592084057296053077');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 0 });
    T('491681428.2', '9889159450842871336.20055172', '4.971923353486762549830247141081325652241006265772730475626693624654733935080926456805817e-11');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 4 });
    T('11.516921', '-967562944223487787311', '-1.190301992108930994314e-20');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 5 });
    T('-147.2', '2762717260.3346237541', '-5.328087753075787159592127888919297641410658444033425936501613e-8');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 3 });
    T('-463636264923890408.70', '-1523796614007631384233641.36636', '3.042638765973583e-7');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 3 });
    T('-37055587088693300137.079346', '-929484432460697135181725', '0.0000398668184152295421171433434');
    BigNumber.config({ DECIMAL_PLACES : 49, ROUNDING_MODE : 0 });
    T('0.000000015003766126680', '-3126735711697635910537.847162', '-4.7985399183398926661e-30');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 1 });
    T('21403298.27', '490950349594', '0.0000435956472741079271932239552');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 6 });
    T('12747419090.74910385808', '5609552870700.213864971009786', '0.0022724483367170588812509767026961008324355580443991349489495630841');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 4 });
    T('-0.00000000031650284413470156532719022', '24884.25268228752104', '0');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 1 });
    T('-0.0000000000000000025560659549131481713245589909', '-1839.19039965941103767929', '1.3897777823255771365831427167461403931142788015230608260379260680349248504469029e-21');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 5 });
    T('0', '0.436', '0');
    BigNumber.config({ DECIMAL_PLACES : 25, ROUNDING_MODE : 4 });
    T('1.647', '491019608.868', '3.3542448616196921e-9');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 0 });
    T('-0.000047732386384257731', '-148.74', '3.20911566386027504370041683474519295414817802877504370041683474519295414817802877504370042e-7');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 5 });
    T('0.0000000000000600', '881.6632103841255050511', '6.8053196836759278403754559818100822e-17');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 2 });
    T('0.0000000000000000006637245', '13014712642.3817540382848', '5.099801418885075542945e-29');
    BigNumber.config({ DECIMAL_PLACES : 87, ROUNDING_MODE : 6 });
    T('143776841518863171', '-0.00000000000034609861', '-4.15421609231147073950975994962822878716560000053164039000329992657294983068553785870448887385014346055882743938208824e+29');
    BigNumber.config({ DECIMAL_PLACES : 21, ROUNDING_MODE : 6 });
    T('645.46862418407791010997', '-0.000000000000000167', '-3865081581940586288.083652694610778443114');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 4 });
    T('-7', '34.6', '-0.2023121387283236994219653179190751445086705202312138728323699422');
    BigNumber.config({ DECIMAL_PLACES : 65, ROUNDING_MODE : 4 });
    T('-1121235833199899', '-32.8', '34184019304874.96951219512195121951219512195121951219512195121951219512195121951');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 2 });
    T('0.0000000000188990009740969592', '3378889801717.569696743', '5.59325757368297407e-24');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 5 });
    T('-0.0000038752364', '21865.820957', '-1.77228031255757803194199e-10');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 5 });
    T('3932331.838871822', '-23243490297748.2880832875437', '-1.69179920420676512721486683805551646729696968236e-7');
    BigNumber.config({ DECIMAL_PLACES : 18, ROUNDING_MODE : 3 });
    T('206040930636923340359166692', '538.2', '3.82833390258125864658429379412857673727238e+23');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 1 });
    T('0.0075', '22087187408224417.09296328', '3.3956337950060989374730469091936150605677e-19');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 4 });
    T('4706.821112', '-4484.0913', '-1.04967111441285773998401861264510827422269479660238');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 5 });
    T('-0.0000000000000003941356879017724141765125', '-2978880330505.199022894078127', '0');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 4 });
    T('-3717638164756266179.31373', '-0.0000000000561', '6.6268059977830056672259001782531194295900178253119429590017825e+28');
    BigNumber.config({ DECIMAL_PLACES : 42, ROUNDING_MODE : 2 });
    T('-166897.9202', '-288870139993051017637902283', '5.7776106663019878573e-22');
    BigNumber.config({ DECIMAL_PLACES : 1, ROUNDING_MODE : 0 });
    T('-109773551.005', '0.000000000000000291', '-3.772286976116838487972509e+23');
    BigNumber.config({ DECIMAL_PLACES : 33, ROUNDING_MODE : 5 });
    T('-69483831516149064933', '45666797733.7', '-1521539388.886757599986395999920494858843131');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 0 });
    T('-2615008789.04', '-0.000000448699711223001786', '5827970742197229');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 4 });
    T('-15.73379275132695121', '6940.2776264951217530', '-0.00226703');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 5 });
    T('-6.2', '0.0000000000000061493836805438314318105727', '-1008231120724556');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 1 });
    T('690', '0.000014578939930754707820', '47328544.0009547235807333066257912877');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 6 });
    T('-29256.628612', '-755504.1526726314415', '0.03872464301950333628903545496047362726515935622535422');
    BigNumber.config({ DECIMAL_PLACES : 28, ROUNDING_MODE : 6 });
    T('-322915.4117033386', '9.11', '-35446.2581452621953896816684961581');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 4 });
    T('-4882625292842289459782.0713', '-13.38', '364919678089857209251.275881913303437967115097159940209267563527653213751868460388639760837070254110612855007473841555');
    BigNumber.config({ DECIMAL_PLACES : 58, ROUNDING_MODE : 4 });
    T('0.000000000129351956271', '-1.23277829937087117', '-1.049271846665476808964426796136761445163472822311e-10');
    BigNumber.config({ DECIMAL_PLACES : 41, ROUNDING_MODE : 2 });
    T('-48182353470928.914851766197711', '2272941918553283127', '-0.00002119823347778141066704688834669339833');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 4 });
    T('3196.64592323932531030', '0.0000000003245910077253889108961189213', '9848226990760.5008268589452525184898665826000345443245395549409514626098519146023853166565543551373496');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 2 });
    T('406.7745', '-6.090912', '-66.783841237568364146452944977697921');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 5 });
    T('-1914.2', '-165340.870423515601', '0.01157729480373990431549028002660588664420183544300321207365966680648027280245');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 3 });
    T('79689754768065472164971.285', '3449964290146359.9564723427', '23098718.730414668928941553485511848664319501601702219791827719624588756164690478609945244772535870938469521');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 1 });
    T('9001.46330089645627336', '-5365000999.299', '-0.00000167781204552852879566574147623862228074948620117785436144852086837922548');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 0 });
    T('-9587016002791929.4856188', '-3031413369917389888311716631', '3.162556482045597308235495224067632584707461093481480654259077736452205618657579410106e-12');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 2 });
    T('4296083.76674', '-194.0', '-22144.7616842268041237113402061855670103092783505154639175257731958762886597938144329896907216494845360824');
    BigNumber.config({ DECIMAL_PLACES : 91, ROUNDING_MODE : 3 });
    T('18.755207714630171', '0.0094306822594364919143130833', '1988.7434650725730232507495283304038983882113409878102620841865180583795237557817888781235508759');
    BigNumber.config({ DECIMAL_PLACES : 70, ROUNDING_MODE : 3 });
    T('357139.77763854332', '31461893637685', '1.13515029245017195115729683926708304080654495656947213475032038e-8');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 2 });
    T('495109692881305.22330433373579', '18890', '26210147849.72499858679');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 0 });
    T('725835.2', '-56469.3051', '-12.8536237291150940690431836038301098201401455');
    BigNumber.config({ DECIMAL_PLACES : 53, ROUNDING_MODE : 1 });
    T('-0.0000000000000008539291084466621', '-66462.10331086', '1.284836118490894791666770536323048e-20');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 0 });
    T('-437950623250185.1796', '4525961511', '-96764.107');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 0 });
    T('0', '-419919711657396843.359722150078', '0');
    BigNumber.config({ DECIMAL_PLACES : 15, ROUNDING_MODE : 6 });
    T('1418494254750712738754757', '4591733826207580942881672', '0.308923449929649');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 6 });
    T('-0.00000000000000001121505882526814442165', '-0.00000034022765195967647788365', '3.296339601049636215256616888976508295137995323068555837387e-11');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 5 });
    T('7633721603085398572526346', '45335909347835.3783', '168381349638.6806344236154879430718880607974785');
    BigNumber.config({ DECIMAL_PLACES : 29, ROUNDING_MODE : 0 });
    T('14896648161672846137148209', '4.125', '3.61130864525402330597532339393939393939393939393939394e+24');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 6 });
    T('-7914781164126.1', '-119014.0', '66502942.20953921387399801704001209941687532559194716587964441158183070899222');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 2 });
    T('91019909259953143323', '-5522.06153359199', '-16482958168114892.84740240589841073937417129944138279714524430633829860712832274184766934216152');
    BigNumber.config({ DECIMAL_PLACES : 99, ROUNDING_MODE : 0 });
    T('-1137517608314921022353199', '-0.000000000000000000107056140182953206696174', '1.0625430791461044518578148113716784804459024574335198467207328302373884979194708111129803963870744434655116384071360289838829502244352737346538e+43');
    BigNumber.config({ DECIMAL_PLACES : 11, ROUNDING_MODE : 5 });
    T('-1173767.2326305257', '-233061127762110315635636', '0');
    BigNumber.config({ DECIMAL_PLACES : 31, ROUNDING_MODE : 2 });
    T('5.8876889668', '3.1', '1.8992545054193548387096774193549');
    BigNumber.config({ DECIMAL_PLACES : 52, ROUNDING_MODE : 4 });
    T('-2.14761558914686180054', '-301574070805882062973', '7.1213535812541532012972515757551e-21');
    BigNumber.config({ DECIMAL_PLACES : 4, ROUNDING_MODE : 3 });
    T('0.000000053624403845025055012694', '-0.000000006053504014848', '-8.8585');
    BigNumber.config({ DECIMAL_PLACES : 90, ROUNDING_MODE : 3 });
    T('-504313761620588', '-0.00000000000377', '1.33770228546575066312997347480106100795755968169761273209549071618037135278514588859416445623342175066312997347480106e+26');
    BigNumber.config({ DECIMAL_PLACES : 5, ROUNDING_MODE : 6 });
    T('53662399.4035417690', '-65017.90', '-825.34809');
    BigNumber.config({ DECIMAL_PLACES : 81, ROUNDING_MODE : 3 });
    T('704021459384072.011987216647', '261808795961066517287.30237', '0.000002689067251540191817460319532140345637081639220151448601586269279206225927743');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 3 });
    T('-3.00', '6046001143510655285.0', '-4.961957381069941064583069603421034150719179715307203065064584517e-19');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 3 });
    T('973187354320146232724757050', '-568184.017437886808358801', '-1.71280311387240648806239296872607262685395385114971208588734369281880271e+21');
    BigNumber.config({ DECIMAL_PLACES : 36, ROUNDING_MODE : 3 });
    T('-7', '-228023476845.9625107669', '3.0698593394086058293957362e-11');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 6 });
    T('-0.35128712', '84029956765557847990155625003', '-4.1804986402656983115928354008537100293091431728296533e-30');
    BigNumber.config({ DECIMAL_PLACES : 6, ROUNDING_MODE : 5 });
    T('1.580', '26596811565693', '0');
    BigNumber.config({ DECIMAL_PLACES : 82, ROUNDING_MODE : 1 });
    T('89476761206818481.30255306413', '6431672239.9', '13911896.917217546364625511259955397093741757541639618090079161404687487019778350630314121');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 1 });
    T('-285.84043874171354004290', '-3.80', '75.22116808992461580076315789473684210526315789473684210526315789473684');
    BigNumber.config({ DECIMAL_PLACES : 61, ROUNDING_MODE : 4 });
    T('5023551710351214.645250', '59', '85144944243240.9261906779661016949152542372881355932203389830508474576271186');
    BigNumber.config({ DECIMAL_PLACES : 30, ROUNDING_MODE : 6 });
    T('55.8578416393', '-691700380830418738.5565', '-8.0754389020634e-17');
    BigNumber.config({ DECIMAL_PLACES : 34, ROUNDING_MODE : 6 });
    T('-3911724.737800850440974979', '5777887024710204784553820488', '-6.770164804316e-22');
    BigNumber.config({ DECIMAL_PLACES : 98, ROUNDING_MODE : 2 });
    T('50', '-1.7', '-29.41176470588235294117647058823529411764705882352941176470588235294117647058823529411764705882352941');
    BigNumber.config({ DECIMAL_PLACES : 2, ROUNDING_MODE : 1 });
    T('53803800627864394248948141885', '0.0000000000000001263391910050269947733', '4.2586785778708650076551456104714784704241888012e+44');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 0 });
    T('-4427033.670465245740417', '0.0000236581313971487858', '-187125246544.145067202651826613329029261197764651089163179');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 5 });
    T('0.00000487987924778308703036015', '-14382977', '-3.392815859875940168965124535761963604613982209663548791046526737823470064646561000549e-13');
    BigNumber.config({ DECIMAL_PLACES : 44, ROUNDING_MODE : 4 });
    T('0.0000000000000000013173879240462', '8815.9760593357349633294', '1.4943188538393812027029e-22');
    BigNumber.config({ DECIMAL_PLACES : 94, ROUNDING_MODE : 1 });
    T('34082970570302.46', '-0.15378396401309', '-221628898624315.1965897283937656884389168635185823292768143062677620972948453464654511988959215787053869058463');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 3 });
    T('-9422972.687', '-4.8', '1963119.3097916666666666666666666666666666666666666666');
    BigNumber.config({ DECIMAL_PLACES : 75, ROUNDING_MODE : 1 });
    T('17603175301812980820940043.5084', '203586376416168.590708', '86465389343.286908319080296673397986841425082701014310790406348979937008055804195811226');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 0 });
    T('1118292325.2750', '118787658708800084.56755', '9.41421303720126381391248975149497111817115e-9');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 0 });
    T('-0.000000026208118477668289226', '0.0000005384213204675190936272', '-0.04867585565688854465822983');
    BigNumber.config({ DECIMAL_PLACES : 71, ROUNDING_MODE : 5 });
    T('31749974', '0.0000000004175827007223264109812', '76032780919993846.10794696063811129544098498574186417516454488089632546613360229415793309');
    BigNumber.config({ DECIMAL_PLACES : 77, ROUNDING_MODE : 5 });
    T('-0.000000031738815698', '0.0000000001049015889731270620336856856', '-302.55800706823061140814796512005417608408899124716685671684150270243619123677554');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 6 });
    T('-0.003598212372110673145921', '-50235787946648897670', '7.162647426e-23');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 5 });
    T('3715826298925020920', '1321522734797', '2811776.294938892222593957205879302040757927871951336015423');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 2 });
    T('-0.0000000420723296', '19531.99', '-2.154021663947196368623985574434555823548e-12');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 6 });
    T('922.0412414065612641312654', '279432164508408308430442379', '3.3e-24');
    BigNumber.config({ DECIMAL_PLACES : 26, ROUNDING_MODE : 5 });
    T('-4639753615932249995340108', '76003590732624477.33', '-61046505.45070418182476591842813719');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 2 });
    T('0.00492075860196', '14', '0.000351482757282857142857142857142857142857142857143');
    BigNumber.config({ DECIMAL_PLACES : 59, ROUNDING_MODE : 2 });
    T('0.0000000016012749138112683', '-34037956761326454044211', '-4.704380245381294320617370852e-32');
    BigNumber.config({ DECIMAL_PLACES : 16, ROUNDING_MODE : 2 });
    T('-33029000879564897264715723.4560', '1.4', '-2.35921434854034980462255167542857142857142e+25');
    BigNumber.config({ DECIMAL_PLACES : 8, ROUNDING_MODE : 6 });
    T('-15.036556', '-2069699249431016.1324294', '0');
    BigNumber.config({ DECIMAL_PLACES : 22, ROUNDING_MODE : 6 });
    T('-0.000197817958547740627072816814714', '555.517400440320', '-3.560967818306755e-7');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 1 });
    T('-0.000000000105900350', '1', '-1.0590035e-10');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 6 });
    T('5646.1', '2.4', '2352.541666666666666666666666666666666666666666666666666666666666666666667');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 5 });
    T('-8043002.78244', '4.763038409266', '-1688628.5793524502308694794819969125421740476382083');
    BigNumber.config({ DECIMAL_PLACES : 32, ROUNDING_MODE : 1 });
    T('75.921737052807005487819999', '1.658', '45.79115624415380306864897406513872');
    BigNumber.config({ DECIMAL_PLACES : 0, ROUNDING_MODE : 5 });
    T('2508.200950', '16.71', '150');
    BigNumber.config({ DECIMAL_PLACES : 60, ROUNDING_MODE : 6 });
    T('-65726540475412104681231', '-2069320713111227459943487969.92', '0.000031762374995315313595244296992084961374019662798752859038');
    BigNumber.config({ DECIMAL_PLACES : 96, ROUNDING_MODE : 2 });
    T('5088562922.2405271423822', '-38730', '-131385.564736393677830679060160082623289439710818486961012135295636457526465272398657371546604699199586');
    BigNumber.config({ DECIMAL_PLACES : 54, ROUNDING_MODE : 6 });
    T('64320.654498', '-62061861429.158163', '-0.000001036395831785035719284619257911539667175955615207');
    BigNumber.config({ DECIMAL_PLACES : 51, ROUNDING_MODE : 3 });
    T('2.204900879951290506663426', '53104454625924734.643', '4.1520073889901010464572015511640417e-17');
    BigNumber.config({ DECIMAL_PLACES : 68, ROUNDING_MODE : 1 });
    T('-452538835226053697.9513964592', '-1.47441386143616894803945', '306927957653120064.86755228873937747952745849883789748764499494386053150512496291850412');
    BigNumber.config({ DECIMAL_PLACES : 10, ROUNDING_MODE : 4 });
    T('525553312.763821648302342614504', '6', '87592218.7939702747');
    BigNumber.config({ DECIMAL_PLACES : 69, ROUNDING_MODE : 4 });
    T('397688', '-68.03', '-5845.773923269145965015434367190945171247978832867852418050859914743495517');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 3 });
    T('-0.000000000059202582311012372084', '0.0000210309', '-0.001');
    BigNumber.config({ DECIMAL_PLACES : 35, ROUNDING_MODE : 0 });
    T('0.000000466389968406448397778096', '7134.82908265011410', '6.536806460305781678007928e-11');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 1 });
    T('-252296.9378333427567934319534', '2406.8709161566', '-104.8236264519835084047570650788548743295593201143617169663331272407432390421138849167950000780307334885');
    BigNumber.config({ DECIMAL_PLACES : 46, ROUNDING_MODE : 0 });
    T('522.9', '-912873877159409564322', '-5.728064008437927742351620614e-19');
    BigNumber.config({ DECIMAL_PLACES : 27, ROUNDING_MODE : 1 });
    T('7093.173057', '614703552193.1495338', '1.1539176944224349223e-8');
    BigNumber.config({ DECIMAL_PLACES : 50, ROUNDING_MODE : 1 });
    T('0.0001341235', '-0.234609357848', '-0.00057168861988402299887104885146311779013688748127');
    BigNumber.config({ DECIMAL_PLACES : 100, ROUNDING_MODE : 2 });
    T('149.469751611688514266726302', '23047796109300906.73', '6.4852079957167878439324712165596730871967775320908715873906582105380758688019048047119e-15');
    BigNumber.config({ DECIMAL_PLACES : 45, ROUNDING_MODE : 1 });
    T('5917.3544', '-8.23', '-718.99810449574726609963547995139732685297691373');
    BigNumber.config({ DECIMAL_PLACES : 73, ROUNDING_MODE : 2 });
    T('1.99', '-420666718873240.2935832610537', '-4.7305857837535459160671048752049702182468640700531401206877e-15');
    BigNumber.config({ DECIMAL_PLACES : 9, ROUNDING_MODE : 3 });
    T('-0.000000000002700385943990773294175301648', '-242', '0');
    BigNumber.config({ DECIMAL_PLACES : 97, ROUNDING_MODE : 2 });
    T('0.00104', '-9205109310.92', '-1.129807332940903148676935060015840240444187292197548894851554458807026366305859299241e-13');
    BigNumber.config({ DECIMAL_PLACES : 88, ROUNDING_MODE : 0 });
    T('3044202687.526990830', '-225715777273711234248.5778', '-1.34868848083910365863654079744878054936819021293833286108835021122610654896355e-11');
    BigNumber.config({ DECIMAL_PLACES : 3, ROUNDING_MODE : 5 });
    T('43549623346172485962556947.75', '4010974.58356981', '10857616381954945829.173');
    BigNumber.config({ DECIMAL_PLACES : 43, ROUNDING_MODE : 0 });
    T('-5500861681629397.60268386296', '-24688659063.6', '222809.2529229201600939986565500250719740754417828');
    BigNumber.config({ DECIMAL_PLACES : 14, ROUNDING_MODE : 3 });
    T('0', '0.000000000000000001611281945098345849', '0');
    BigNumber.config({ DECIMAL_PLACES : 7, ROUNDING_MODE : 6 });
    T('286037.7278439472555897310', '1766.08071636693189589823', '161.9618657');
    BigNumber.config({ DECIMAL_PLACES : 74, ROUNDING_MODE : 4 });
    T('1.30', '22016412865861919.05', '5.904685781105360772902691452716470778294132411902331064455e-17');
    BigNumber.config({ DECIMAL_PLACES : 85, ROUNDING_MODE : 3 });
    T('342975419362.63241869', '0.000000000132776429612170725496026', '2.5831046998660533379821777956012147966560751819092431647637200684436601466266722365014710913251120473656227e+21');
    BigNumber.config({ DECIMAL_PLACES : 63, ROUNDING_MODE : 5 });
    T('263838.7497999996', '129.28310', '2040.782977821537385783602033057685033852065737903871426350389184665');
    BigNumber.config({ DECIMAL_PLACES : 55, ROUNDING_MODE : 4 });
    T('-16986431229246565059.38639', '908.214', '-18703115377264130.5456493623749468737544235169244253006450021690923064388');
    BigNumber.config(