/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.dff;

import com.kreative.dff.DFFResource;
import com.kreative.dff.DFFResourceAlreadyExistsException;
import com.kreative.dff.DFFResourceProvider;
import com.kreative.dff.DFFResourceTooBigException;
import com.kreative.dff.NotADFFFileException;
import com.kreative.ksfl.KSFLUtilities;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;

public class DFFResourceFile
extends DFFResourceProvider {
    public static final int CREATE_NEVER = 0;
    public static final int CREATE_IF_EMPTY = 1;
    public static final int CREATE_ALWAYS = 2;
    private RandomAccessFile raf;
    private boolean readOnly;
    private int version;
    private boolean sb;
    private int d2objectCount;
    private long d2headerSpace;
    private long d2nameSpace;
    private long d2dataSpace;
    private String textEncoding;
    private static final int INSERTED_TYPE_RECORD = 1;
    private static final int INSERTED_OBJECT_RECORD = 2;
    private static final int INSERTED_NAME = 3;
    private static final int INSERTED_DATA = 4;
    private static final int REMOVED_TYPE_RECORD = 1;
    private static final int REMOVED_OBJECT_RECORD = 2;
    private static final int REMOVED_NAME = 3;
    private static final int REMOVED_DATA = 4;

    private String ns(byte[] a) {
        try {
            return new String(a, this.textEncoding);
        }
        catch (UnsupportedEncodingException uue) {
            return new String(a);
        }
    }

    private byte[] gb(String a) {
        try {
            return a.getBytes(this.textEncoding);
        }
        catch (UnsupportedEncodingException uue) {
            return a.getBytes();
        }
    }

    private long d1locate(long type, int id) {
        try {
            this.raf.seek(4L);
            while (this.raf.getFilePointer() + 16L <= this.raf.length()) {
                int l;
                long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                short i = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                this.raf.readShort();
                int n = l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                if (t == type && i == (short)id) {
                    return this.raf.getFilePointer() - 16L;
                }
                this.raf.skipBytes(l);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0L;
    }

    private long[] d2locate(long type, int id) {
        int i = 0;
        long hi = this.d2headerSpace;
        long ni = this.d2nameSpace;
        long di = this.d2dataSpace;
        try {
            while (i < this.d2objectCount && hi < this.d2nameSpace && ni < this.d2dataSpace && di < this.raf.length()) {
                this.raf.seek(hi);
                long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                short id1 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                this.raf.readShort();
                this.raf.readShort();
                short id2 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                int l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                this.raf.seek(ni);
                int nl = this.raf.readByte() & 0xFF;
                if (t == type && (id1 & 0xFFFF) == (id & 0xFFFF) && (id2 << 16 & 0xFFFF0000) == (id & 0xFFFF0000)) {
                    return new long[]{hi, ni, di, 20L, (long)nl + 1L, l};
                }
                di += (long)l;
                ni += 1L + (long)nl;
                hi += 20L;
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private long[] d2locate(long type, String name) {
        int i = 0;
        long hi = this.d2headerSpace;
        long ni = this.d2nameSpace;
        long di = this.d2dataSpace;
        try {
            while (i < this.d2objectCount && hi < this.d2nameSpace && ni < this.d2dataSpace && di < this.raf.length()) {
                this.raf.seek(hi);
                long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                this.raf.readShort();
                this.raf.readShort();
                this.raf.readShort();
                this.raf.readShort();
                int l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                this.raf.seek(ni);
                int nl = this.raf.readByte() & 0xFF;
                byte[] nb = new byte[nl];
                this.raf.read(nb);
                String n = this.ns(nb);
                if (t == type && n.equals(name)) {
                    return new long[]{hi, ni, di, 20L, (long)nl + 1L, l};
                }
                di += (long)l;
                ni += 1L + (long)nl;
                hi += 20L;
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void d3adjustTypeMap(long offset, long length, int whatInserted, long typeInserted, int idInserted) throws IOException {
        this.raf.seek(4L);
        int typeCnt = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
        int ti = 0;
        while (ti < typeCnt) {
            int objTblOfst;
            long thisType = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
            this.raf.readInt();
            int n = objTblOfst = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
            if ((long)objTblOfst > offset || (long)objTblOfst == offset && length > 0L && (whatInserted != 2 || typeInserted != thisType)) {
                if ((long)objTblOfst + length > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException("Map too big. Map now corrupted. You're screwed.");
                }
                this.raf.seek(this.raf.getFilePointer() - 4L);
                this.raf.writeInt(this.sb ? Integer.reverseBytes((int)((long)objTblOfst + length)) : (int)((long)objTblOfst + length));
            }
            ++ti;
        }
    }

    private void d3adjustObjectMaps(long offset, long length, int whatInserted, long typeInserted, int idInserted) throws IOException {
        this.raf.seek(4L);
        int typeCnt = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
        int ti = 0;
        while (ti < typeCnt) {
            this.raf.seek(8L + 16L * (long)ti);
            long thisType = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
            int objCnt = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
            int objTblOfst = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
            this.raf.seek(objTblOfst);
            int oi = 0;
            while (oi < objCnt) {
                long dataOfst;
                int nameOfst;
                int thisID = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                this.raf.readInt();
                int n = nameOfst = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                if (nameOfst > 0 && ((long)nameOfst > offset || (long)nameOfst == offset && length > 0L && (whatInserted != 3 || typeInserted != thisType || idInserted != thisID))) {
                    if ((long)nameOfst + length > Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException("Map too big. Map now corrupted. You're screwed.");
                    }
                    this.raf.seek(this.raf.getFilePointer() - 4L);
                    this.raf.writeInt(this.sb ? Integer.reverseBytes((int)((long)nameOfst + length)) : (int)((long)nameOfst + length));
                }
                long l = dataOfst = this.sb ? KSFLUtilities.reverseUInt48(KSFLUtilities.readUInt48(this.raf)) : KSFLUtilities.readUInt48(this.raf);
                if (dataOfst > 0L && (dataOfst > offset || dataOfst == offset && length > 0L && (whatInserted != 4 || typeInserted != thisType || idInserted != thisID))) {
                    if (dataOfst + length > 0xFFFFFFFFFFFFL) {
                        throw new DFFResourceTooBigException("Map too big. Map now corrupted. You're screwed.");
                    }
                    this.raf.seek(this.raf.getFilePointer() - 6L);
                    KSFLUtilities.writeUInt48(this.raf, this.sb ? KSFLUtilities.reverseUInt48(dataOfst + length) : dataOfst + length);
                }
                KSFLUtilities.readUInt48(this.raf);
                ++oi;
            }
            ++ti;
        }
    }

    private void d3adjustMetrics(long[] a, long offset, long length, int whatInserted) {
        if (a[1] > offset || a[1] == offset && length > 0L && whatInserted != 1) {
            a[1] = a[1] + length;
        }
        if (a[3] > offset || a[3] == offset && length > 0L && whatInserted != 2) {
            a[3] = a[3] + length;
        }
        if (a[4] > offset || a[4] == offset && length > 0L && whatInserted != 2) {
            a[4] = a[4] + length;
        }
        if (a[5] > offset || a[5] == offset && length > 0L && whatInserted != 3) {
            a[5] = a[5] + length;
        }
        if (a[6] > offset || a[6] == offset && length > 0L && whatInserted != 3) {
            a[6] = a[6] + length;
        }
        if (a[7] > offset || a[7] == offset && length > 0L && whatInserted != 4) {
            a[7] = a[7] + length;
        }
        if (a[8] > offset || a[8] == offset && length > 0L && whatInserted != 4) {
            a[8] = a[8] + length;
        }
    }

    private void d3adjustLocation(long[] a, long offset, long length, int whatInserted) {
        if (a[0] > offset || a[0] == offset && length > 0L && whatInserted != 1) {
            a[0] = a[0] + length;
        }
        if (a[3] > offset || a[3] == offset && length > 0L && whatInserted != 2) {
            a[3] = a[3] + length;
        }
        if (a[5] > offset || a[5] == offset && length > 0L && whatInserted != 2) {
            a[5] = a[5] + length;
        }
        if (a[7] > offset || a[7] == offset && length > 0L && whatInserted != 3) {
            a[7] = a[7] + length;
        }
        if (a[9] > offset || a[9] == offset && length > 0L && whatInserted != 4) {
            a[9] = a[9] + length;
        }
    }

    private long[] d3metrics() throws IOException {
        long objTblMin = Long.MAX_VALUE;
        long objTblMax = 0L;
        long nameMin = Long.MAX_VALUE;
        long nameMax = 0L;
        long dataMin = Long.MAX_VALUE;
        long dataMax = 0L;
        this.raf.seek(4L);
        int typeCnt = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
        int ti = 0;
        while (ti < typeCnt) {
            int objTblOfst;
            this.raf.seek(8L + 16L * (long)ti + 8L);
            int objCnt = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
            int n = objTblOfst = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
            if (objTblOfst > 0) {
                if ((long)objTblOfst < objTblMin) {
                    objTblMin = objTblOfst;
                }
                if ((long)(objTblOfst + 24 * objCnt) > objTblMax) {
                    objTblMax = objTblOfst + 24 * objCnt;
                }
            }
            int oi = 0;
            while (oi < objCnt) {
                long dataLen;
                this.raf.seek((long)objTblOfst + 24L * (long)oi + 8L);
                int nameOfst = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                long dataOfst = this.sb ? KSFLUtilities.reverseUInt48(KSFLUtilities.readUInt48(this.raf)) : KSFLUtilities.readUInt48(this.raf);
                long l = dataLen = this.sb ? KSFLUtilities.reverseUInt48(KSFLUtilities.readUInt48(this.raf)) : KSFLUtilities.readUInt48(this.raf);
                if (nameOfst > 0) {
                    this.raf.seek(nameOfst);
                    int nameLen = (this.raf.readByte() & 0xFF) + 1;
                    if ((long)nameOfst < nameMin) {
                        nameMin = nameOfst;
                    }
                    if ((long)(nameOfst + nameLen) > nameMax) {
                        nameMax = nameOfst + nameLen;
                    }
                }
                if (dataOfst > 0L) {
                    if (dataOfst < dataMin) {
                        dataMin = dataOfst;
                    }
                    if (dataOfst + dataLen > dataMax) {
                        dataMax = dataOfst + dataLen;
                    }
                }
                ++oi;
            }
            ++ti;
        }
        if (objTblMin > objTblMax) {
            objTblMin = objTblMax = 8L + (long)typeCnt * 16L;
        }
        if (nameMin > nameMax) {
            nameMin = nameMax = objTblMax;
        }
        if (dataMin > dataMax) {
            dataMin = dataMax = nameMax;
        }
        return new long[]{typeCnt, 8L, (long)typeCnt * 16L, objTblMin, objTblMax, nameMin, nameMax, dataMin, dataMax};
    }

    private long[] d3getType(long type) throws IOException {
        this.raf.seek(4L);
        int typeCnt = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
        int ti = 0;
        while (ti < typeCnt) {
            int objTblOfst;
            long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
            int objCnt = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
            int n = objTblOfst = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
            if (t == type) {
                return new long[]{this.raf.getFilePointer() - 16L, 16L, objCnt, objTblOfst, 24L * (long)objCnt};
            }
            ++ti;
        }
        return null;
    }

    private long[] d3locate(long type, int id) throws IOException {
        long[] ty = this.d3getType(type);
        if (ty != null) {
            int oi = 0;
            while ((long)oi < ty[2]) {
                int i;
                this.raf.seek(ty[3] + 24L * (long)oi);
                int n = i = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                if (i == id) {
                    this.raf.readInt();
                    int nameOfst = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    long dataOfst = this.sb ? KSFLUtilities.reverseUInt48(KSFLUtilities.readUInt48(this.raf)) : KSFLUtilities.readUInt48(this.raf);
                    long dataLen = this.sb ? KSFLUtilities.reverseUInt48(KSFLUtilities.readUInt48(this.raf)) : KSFLUtilities.readUInt48(this.raf);
                    int nameLen = 0;
                    if (nameOfst > 0) {
                        this.raf.seek(nameOfst);
                        nameLen = (this.raf.readByte() & 0xFF) + 1;
                    }
                    return new long[]{ty[0], ty[1], ty[2], ty[3], ty[4], ty[3] + 24L * (long)oi, 24L, nameOfst, nameLen, dataOfst, dataLen};
                }
                ++oi;
            }
        }
        return null;
    }

    private long[] d3locate(long type, String name) throws IOException {
        long[] ty = this.d3getType(type);
        if (ty != null) {
            int oi = 0;
            while ((long)oi < ty[2]) {
                int nameOfst;
                this.raf.seek(ty[3] + 24L * (long)oi + 8L);
                int n = nameOfst = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                if (nameOfst > 0) {
                    this.raf.seek(nameOfst);
                    int nameLen = (this.raf.readByte() & 0xFF) + 1;
                    byte[] b = new byte[nameLen - 1];
                    this.raf.read(b);
                    String n2 = this.ns(b);
                    if (n2.equals(name)) {
                        this.raf.seek(ty[3] + 24L * (long)oi + 12L);
                        long dataOfst = this.sb ? KSFLUtilities.reverseUInt48(KSFLUtilities.readUInt48(this.raf)) : KSFLUtilities.readUInt48(this.raf);
                        long dataLen = this.sb ? KSFLUtilities.reverseUInt48(KSFLUtilities.readUInt48(this.raf)) : KSFLUtilities.readUInt48(this.raf);
                        return new long[]{ty[0], ty[1], ty[2], ty[3], ty[4], ty[3] + 24L * (long)oi, 24L, nameOfst, nameLen, dataOfst, dataLen};
                    }
                }
                ++oi;
            }
        }
        return null;
    }

    private void d3cut(long[] metrics, long[] loc, long offset, long length, int what, long type, int id) throws IOException {
        KSFLUtilities.cut(this.raf, offset, length);
        this.d3adjustTypeMap(offset, -length, what, type, id);
        this.d3adjustObjectMaps(offset, -length, what, type, id);
        if (loc != null) {
            this.d3adjustLocation(loc, offset, -length, what);
        }
        if (metrics != null) {
            this.d3adjustMetrics(metrics, offset, -length, what);
        }
    }

    private void d3paste(long[] metrics, long[] loc, long offset, byte[] stuff, int what, long type, int id) throws IOException {
        KSFLUtilities.paste(this.raf, offset, stuff);
        this.d3adjustTypeMap(offset, stuff.length, what, type, id);
        this.d3adjustObjectMaps(offset, stuff.length, what, type, id);
        if (loc != null) {
            this.d3adjustLocation(loc, offset, stuff.length, what);
        }
        if (metrics != null) {
            this.d3adjustMetrics(metrics, offset, stuff.length, what);
        }
    }

    private void d3paste(long[] metrics, long[] loc, long offset, long length, int what, long type, int id) throws IOException {
        KSFLUtilities.paste(this.raf, offset, length);
        this.d3adjustTypeMap(offset, length, what, type, id);
        this.d3adjustObjectMaps(offset, length, what, type, id);
        if (loc != null) {
            this.d3adjustLocation(loc, offset, length, what);
        }
        if (metrics != null) {
            this.d3adjustMetrics(metrics, offset, length, what);
        }
    }

    public DFFResourceFile(File f, String mode, int create, int version, boolean le) throws IOException {
        block21: {
            block20: {
                this.readOnly = false;
                this.textEncoding = "UTF-8";
                this.raf = new RandomAccessFile(f, mode);
                this.readOnly = mode.equalsIgnoreCase("r");
                if (create != 2 && (create != 1 || this.raf.length() != 0L)) break block20;
                this.version = version;
                this.sb = le;
                switch (version) {
                    case 1: {
                        this.raf.seek(0L);
                        this.raf.setLength(0L);
                        this.raf.writeInt(625231430);
                        break block21;
                    }
                    case 2: {
                        this.raf.seek(0L);
                        this.raf.setLength(0L);
                        this.raf.writeInt(625231410);
                        this.raf.writeInt(0);
                        this.d2objectCount = 0;
                        this.d2dataSpace = 8L;
                        this.d2nameSpace = 8L;
                        this.d2headerSpace = 8L;
                        break block21;
                    }
                    case 3: {
                        this.raf.seek(0L);
                        this.raf.setLength(0L);
                        this.raf.writeInt(625231411);
                        this.raf.writeInt(0);
                        break block21;
                    }
                    default: {
                        throw new NotADFFFileException("Invalid version number: " + version);
                    }
                }
            }
            if (this.raf.length() < 4L) {
                throw new NotADFFFileException("File is too small");
            }
            this.raf.seek(0L);
            int v = this.raf.readInt();
            switch (v) {
                case 625231430: {
                    this.version = 1;
                    this.sb = false;
                    break;
                }
                case 1179010085: {
                    this.version = 1;
                    this.sb = true;
                    break;
                }
                case 625231410: {
                    if (this.raf.length() < 8L) {
                        throw new NotADFFFileException("File is too small");
                    }
                    this.version = 2;
                    this.sb = false;
                    this.raf.seek(4L);
                    this.d2objectCount = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    this.d2headerSpace = 8L;
                    this.d2dataSpace = this.d2nameSpace = this.d2headerSpace + 20L * (long)this.d2objectCount;
                    this.raf.seek(this.d2nameSpace);
                    int nh2 = this.d2objectCount;
                    while (nh2 > 0) {
                        int sl = this.raf.readByte() & 0xFF;
                        this.d2dataSpace += (long)(sl + 1);
                        this.raf.skipBytes(sl);
                        --nh2;
                    }
                    break;
                }
                case 843465765: {
                    if (this.raf.length() < 8L) {
                        throw new NotADFFFileException("File is too small");
                    }
                    this.version = 2;
                    this.sb = true;
                    this.raf.seek(4L);
                    this.d2objectCount = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    this.d2headerSpace = 8L;
                    this.d2dataSpace = this.d2nameSpace = this.d2headerSpace + 20L * (long)this.d2objectCount;
                    this.raf.seek(this.d2nameSpace);
                    int nh2 = this.d2objectCount;
                    while (nh2 > 0) {
                        int sl = this.raf.readByte() & 0xFF;
                        this.d2dataSpace += (long)(sl + 1);
                        this.raf.skipBytes(sl);
                        --nh2;
                    }
                    break;
                }
                case 625231411: {
                    if (this.raf.length() < 8L) {
                        throw new NotADFFFileException("File is too small");
                    }
                    this.version = 3;
                    this.sb = false;
                    break;
                }
                case 860242981: {
                    if (this.raf.length() < 8L) {
                        throw new NotADFFFileException("File is too small");
                    }
                    this.version = 3;
                    this.sb = true;
                    break;
                }
                default: {
                    throw new NotADFFFileException("Invalid magic number: " + Integer.toHexString(v));
                }
            }
        }
    }

    public synchronized String getTextEncoding() {
        return this.textEncoding;
    }

    public synchronized void setTextEncoding(String encoding) {
        this.textEncoding = encoding;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void close() {
        try {
            this.raf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean add(DFFResource r) throws DFFResourceAlreadyExistsException {
        if (r.name == null) {
            r.name = "";
        }
        if (r.data == null) {
            r.data = new byte[0];
        }
        switch (this.version) {
            case 1: {
                if (this.d1locate(r.type, r.id) > 0L) {
                    throw new DFFResourceAlreadyExistsException();
                }
                long l2 = this.raf.length();
                try {
                    this.raf.seek(l2);
                    this.raf.writeLong(this.sb ? Long.reverseBytes(r.type) : r.type);
                    this.raf.writeShort(this.sb ? Short.reverseBytes((short)r.id) : (short)r.id);
                    this.raf.writeShort(0);
                    this.raf.writeInt(this.sb ? Integer.reverseBytes(r.data.length) : r.data.length);
                    this.raf.write(r.data);
                    return true;
                }
                catch (IOException ioe2) {
                    try {
                        this.raf.setLength(l2);
                    }
                    catch (IOException l2) {}
                }
                break;
            }
            case 2: {
                if (this.d2locate(r.type, r.id) != null) {
                    throw new DFFResourceAlreadyExistsException();
                }
                byte[] n = this.gb(r.name);
                if (n.length > 255) {
                    n = KSFLUtilities.cut(n, 255, n.length - 255);
                }
                n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                try {
                    KSFLUtilities.paste(this.raf, this.d2nameSpace, 20L);
                    this.raf.seek(this.d2nameSpace);
                    this.raf.writeLong(this.sb ? Long.reverseBytes(r.type) : r.type);
                    this.raf.writeShort(this.sb ? Short.reverseBytes((short)(r.id & 0xFFFF)) : (short)(r.id & 0xFFFF));
                    this.raf.writeShort(this.sb ? Short.reverseBytes(r.datatype) : r.datatype);
                    this.raf.writeShort(this.sb ? Short.reverseBytes(r.getAttributes()) : r.getAttributes());
                    this.raf.writeShort(this.sb ? Short.reverseBytes((short)(r.id >> 16 & 0xFFFF)) : (short)(r.id >> 16 & 0xFFFF));
                    this.raf.writeInt(this.sb ? Integer.reverseBytes(r.data.length) : r.data.length);
                    this.d2nameSpace += 20L;
                    this.d2dataSpace += 20L;
                    KSFLUtilities.paste(this.raf, this.d2dataSpace, n);
                    this.d2dataSpace += (long)n.length;
                    this.raf.seek(this.raf.length());
                    this.raf.write(r.data);
                    ++this.d2objectCount;
                    this.raf.seek(4L);
                    this.raf.writeInt(this.sb ? Integer.reverseBytes(this.d2objectCount) : this.d2objectCount);
                    return true;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            case 3: {
                try {
                    if (this.raf.length() + 24L + (r.name.length() > 0 ? (long)this.gb(r.name).length + 1L : 0L) + (this.d3getType(r.type) == null ? 16L : 0L) + (long)r.data.length > 0xFFFFFFFFFFFFL) {
                        throw new DFFResourceTooBigException();
                    }
                    if (this.d3locate(r.type, r.id) != null) {
                        throw new DFFResourceAlreadyExistsException();
                    }
                    long[] t = this.d3getType(r.type);
                    long[] m = this.d3metrics();
                    if (t == null) {
                        if (m[0] == Integer.MAX_VALUE) {
                            throw new DFFResourceTooBigException("Too many types.");
                        }
                        byte[] th = new byte[16];
                        KSFLUtilities.putLong(th, 0, this.sb, r.type);
                        KSFLUtilities.putInt(th, 8, this.sb, 0);
                        KSFLUtilities.putInt(th, 12, this.sb, (int)m[4]);
                        this.raf.seek(4L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes((int)m[0] + 1) : (int)m[0] + 1);
                        this.d3paste(m, null, m[1] + m[2], th, 1, r.type, r.id);
                        t = this.d3getType(r.type);
                    } else if (t[2] == Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException("Too many objects of this type.");
                    }
                    byte[] h = new byte[24];
                    KSFLUtilities.putInt(h, 0, this.sb, r.id);
                    KSFLUtilities.putShort(h, 4, this.sb, r.datatype);
                    KSFLUtilities.putShort(h, 6, this.sb, r.getAttributes());
                    KSFLUtilities.putInt(h, 8, this.sb, r.name.length() > 0 ? (int)m[6] : 0);
                    KSFLUtilities.putUInt48(h, 12, this.sb, r.data.length > 0 ? m[8] : 0L);
                    KSFLUtilities.putUInt48(h, 18, this.sb, r.data.length);
                    this.raf.seek(t[0] + 8L);
                    this.raf.writeInt(this.sb ? Integer.reverseBytes((int)t[2] + 1) : (int)t[2] + 1);
                    this.d3paste(m, null, t[3] + t[4], h, 2, r.type, r.id);
                    if (r.name.length() > 0) {
                        byte[] n = this.gb(r.name);
                        if (n.length > 255) {
                            n = KSFLUtilities.cut(n, 255, n.length - 255);
                        }
                        n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                        this.d3paste(m, null, m[6], n, 3, r.type, r.id);
                    }
                    if (r.data.length > 0) {
                        this.d3paste(m, null, m[8], r.data, 4, r.type, r.id);
                    }
                    return true;
                }
                catch (DFFResourceTooBigException e) {
                    throw e;
                }
                catch (DFFResourceAlreadyExistsException e) {
                    throw e;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public synchronized boolean contains(long type, int id) {
        switch (this.version) {
            case 1: {
                long d1i = this.d1locate(type, id);
                return d1i > 0L;
            }
            case 2: {
                long[] d2i = this.d2locate(type, id);
                return d2i != null;
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, id);
                    return d3i != null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public synchronized boolean contains(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                long[] d2i = this.d2locate(type, name);
                return d2i != null;
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, name);
                    return d3i != null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized DFFResource get(long type, int id) {
        switch (this.version) {
            case 1: {
                long d1i = this.d1locate(type, id);
                if (d1i <= 0L) return null;
                try {
                    this.raf.seek(d1i);
                    long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                    short i = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    this.raf.readShort();
                    int l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    byte[] b = new byte[l];
                    this.raf.read(b);
                    return new DFFResource(t, i, b);
                }
                catch (IOException t) {
                    return null;
                }
            }
            case 2: {
                long[] d2i = this.d2locate(type, id);
                if (d2i == null) return null;
                try {
                    this.raf.seek(d2i[0]);
                    long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                    short id1 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short dt = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short f = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short id2 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    int l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    int i = id1 & 0xFFFF | id2 << 16 & 0xFFFF0000;
                    this.raf.seek(d2i[1]);
                    int nl = this.raf.readByte() & 0xFF;
                    byte[] nb = new byte[nl];
                    this.raf.read(nb);
                    String n = this.ns(nb);
                    this.raf.seek(d2i[2]);
                    byte[] d = new byte[l];
                    this.raf.read(d);
                    return new DFFResource(t, i, dt, f, n, d);
                }
                catch (IOException t) {
                    return null;
                }
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, id);
                    if (d3i == null) return null;
                    this.raf.seek(d3i[0]);
                    long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                    this.raf.seek(d3i[5]);
                    int i = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    short dt = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short f = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    String n = "";
                    if (d3i[7] > 0L) {
                        byte[] nb = new byte[(int)d3i[8] - 1];
                        this.raf.seek(d3i[7] + 1L);
                        this.raf.read(nb);
                        n = this.ns(nb);
                    }
                    if (d3i[10] > Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException();
                    }
                    byte[] d = new byte[(int)d3i[10]];
                    if (d3i[9] <= 0L) return new DFFResource(t, i, dt, f, n, d);
                    this.raf.seek(d3i[9]);
                    this.raf.read(d);
                    return new DFFResource(t, i, dt, f, n, d);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized DFFResource get(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                long[] d2i = this.d2locate(type, name);
                if (d2i == null) return null;
                try {
                    this.raf.seek(d2i[0]);
                    long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                    short id1 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short dt = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short f = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short id2 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    int l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    int i = id1 & 0xFFFF | id2 << 16 & 0xFFFF0000;
                    this.raf.seek(d2i[1]);
                    int nl = this.raf.readByte() & 0xFF;
                    byte[] nb = new byte[nl];
                    this.raf.read(nb);
                    String n = this.ns(nb);
                    this.raf.seek(d2i[2]);
                    byte[] d = new byte[l];
                    this.raf.read(d);
                    return new DFFResource(t, i, dt, f, n, d);
                }
                catch (IOException t) {
                    return null;
                }
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, name);
                    if (d3i == null) return null;
                    this.raf.seek(d3i[0]);
                    long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                    this.raf.seek(d3i[5]);
                    int i = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    short dt = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short f = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    String n = "";
                    if (d3i[7] > 0L) {
                        byte[] nb = new byte[(int)d3i[8] - 1];
                        this.raf.seek(d3i[7] + 1L);
                        this.raf.read(nb);
                        n = this.ns(nb);
                    }
                    if (d3i[10] > Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException();
                    }
                    byte[] d = new byte[(int)d3i[10]];
                    if (d3i[9] <= 0L) return new DFFResource(t, i, dt, f, n, d);
                    this.raf.seek(d3i[9]);
                    this.raf.read(d);
                    return new DFFResource(t, i, dt, f, n, d);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized DFFResource getAttributes(long type, int id) {
        switch (this.version) {
            case 1: {
                long d1i = this.d1locate(type, id);
                if (d1i <= 0L) return null;
                try {
                    this.raf.seek(d1i);
                    long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                    short i = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    return new DFFResource(t, i, new byte[0]);
                }
                catch (IOException t) {
                    return null;
                }
            }
            case 2: {
                long[] d2i = this.d2locate(type, id);
                if (d2i == null) return null;
                try {
                    this.raf.seek(d2i[0]);
                    long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                    short id1 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short dt = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short f = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short id2 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    int i = id1 & 0xFFFF | id2 << 16 & 0xFFFF0000;
                    this.raf.seek(d2i[1]);
                    int nl = this.raf.readByte() & 0xFF;
                    byte[] nb = new byte[nl];
                    this.raf.read(nb);
                    String n = this.ns(nb);
                    return new DFFResource(t, i, dt, f, n, new byte[0]);
                }
                catch (IOException t) {
                    return null;
                }
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, id);
                    if (d3i == null) return null;
                    this.raf.seek(d3i[0]);
                    long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                    this.raf.seek(d3i[5]);
                    int i = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    short dt = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short f = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    String n = "";
                    if (d3i[7] <= 0L) return new DFFResource(t, i, dt, f, n, new byte[0]);
                    byte[] nb = new byte[(int)d3i[8] - 1];
                    this.raf.seek(d3i[7] + 1L);
                    this.raf.read(nb);
                    n = this.ns(nb);
                    return new DFFResource(t, i, dt, f, n, new byte[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized DFFResource getAttributes(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                long[] d2i = this.d2locate(type, name);
                if (d2i == null) return null;
                try {
                    this.raf.seek(d2i[0]);
                    long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                    short id1 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short dt = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short f = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short id2 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    int i = id1 & 0xFFFF | id2 << 16 & 0xFFFF0000;
                    this.raf.seek(d2i[1]);
                    int nl = this.raf.readByte() & 0xFF;
                    byte[] nb = new byte[nl];
                    this.raf.read(nb);
                    String n = this.ns(nb);
                    return new DFFResource(t, i, dt, f, n, new byte[0]);
                }
                catch (IOException t) {
                    return null;
                }
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, name);
                    if (d3i == null) return null;
                    this.raf.seek(d3i[0]);
                    long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                    this.raf.seek(d3i[5]);
                    int i = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    short dt = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    short f = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    String n = "";
                    if (d3i[7] <= 0L) return new DFFResource(t, i, dt, f, n, new byte[0]);
                    byte[] nb = new byte[(int)d3i[8] - 1];
                    this.raf.seek(d3i[7] + 1L);
                    this.raf.read(nb);
                    n = this.ns(nb);
                    return new DFFResource(t, i, dt, f, n, new byte[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized long getLength(long type, int id) {
        switch (this.version) {
            case 1: {
                long d1i = this.d1locate(type, id);
                if (d1i <= 0L) return 0L;
                try {
                    this.raf.seek(d1i + 12L);
                    int l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    return l;
                }
                catch (IOException l) {
                    return 0L;
                }
            }
            case 2: {
                long[] d2i = this.d2locate(type, id);
                if (d2i == null) return 0L;
                return d2i[5];
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, id);
                    if (d3i == null) return 0L;
                    return d3i[10];
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized long getLength(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                long[] d2i = this.d2locate(type, name);
                if (d2i == null) return 0L;
                return d2i[5];
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, name);
                    if (d3i == null) return 0L;
                    return d3i[10];
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized byte[] getData(long type, int id) {
        switch (this.version) {
            case 1: {
                long d1i = this.d1locate(type, id);
                if (d1i <= 0L) return null;
                try {
                    this.raf.seek(d1i + 12L);
                    int l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    byte[] b = new byte[l];
                    this.raf.read(b);
                    return b;
                }
                catch (IOException l) {
                    return null;
                }
            }
            case 2: {
                long[] d2i = this.d2locate(type, id);
                if (d2i == null) return null;
                try {
                    this.raf.seek(d2i[0] + 16L);
                    int l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    this.raf.seek(d2i[2]);
                    byte[] d = new byte[l];
                    this.raf.read(d);
                    return d;
                }
                catch (IOException l) {
                    return null;
                }
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, id);
                    if (d3i == null) return null;
                    if (d3i[10] > Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException();
                    }
                    byte[] d = new byte[(int)d3i[10]];
                    if (d3i[9] <= 0L) return d;
                    this.raf.seek(d3i[9]);
                    this.raf.read(d);
                    return d;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized byte[] getData(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                long[] d2i = this.d2locate(type, name);
                if (d2i == null) return null;
                try {
                    this.raf.seek(d2i[0] + 16L);
                    int l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    this.raf.seek(d2i[2]);
                    byte[] d = new byte[l];
                    this.raf.read(d);
                    return d;
                }
                catch (IOException l) {
                    return null;
                }
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, name);
                    if (d3i == null) return null;
                    if (d3i[10] > Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException();
                    }
                    byte[] d = new byte[(int)d3i[10]];
                    if (d3i[9] <= 0L) return d;
                    this.raf.seek(d3i[9]);
                    this.raf.read(d);
                    return d;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized int read(long type, int id, long doffset, byte[] data, int off, int len) {
        switch (this.version) {
            case 1: {
                long d1i = this.d1locate(type, id);
                if (d1i <= 0L) return 0;
                try {
                    this.raf.seek(d1i + 12L);
                    long d1l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    long begin = d1i + 16L + doffset;
                    long end = d1i + 16L + Math.min(d1l, doffset + (long)len);
                    if (begin >= end) return 0;
                    this.raf.seek(begin);
                    return this.raf.read(data, off, len);
                }
                catch (IOException d1l) {}
                return 0;
            }
            case 2: {
                long[] d2i = this.d2locate(type, id);
                if (d2i == null) return 0;
                try {
                    long begin = d2i[2] + doffset;
                    long end = Math.min(d2i[2] + d2i[5], d2i[2] + doffset + (long)len);
                    if (begin >= end) return 0;
                    this.raf.seek(begin);
                    return this.raf.read(data, off, (int)(end - begin));
                }
                catch (IOException begin) {}
                return 0;
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, id);
                    if (d3i == null) return 0;
                    long begin = d3i[9] + doffset;
                    long end = Math.min(d3i[9] + d3i[10], d3i[9] + doffset + (long)len);
                    if (begin >= end) return 0;
                    this.raf.seek(begin);
                    return this.raf.read(data, off, (int)(end - begin));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized int read(long type, String name, long doffset, byte[] data, int off, int len) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                long[] d2i = this.d2locate(type, name);
                if (d2i == null) return 0;
                try {
                    long begin = d2i[2] + doffset;
                    long end = Math.min(d2i[2] + d2i[5], d2i[2] + doffset + (long)len);
                    if (begin >= end) return 0;
                    this.raf.seek(begin);
                    return this.raf.read(data, off, (int)(end - begin));
                }
                catch (IOException begin) {}
                return 0;
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, name);
                    if (d3i == null) return 0;
                    long begin = d3i[9] + doffset;
                    long end = Math.min(d3i[9] + d3i[10], d3i[9] + doffset + (long)len);
                    if (begin >= end) return 0;
                    this.raf.seek(begin);
                    return this.raf.read(data, off, (int)(end - begin));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    @Override
    public synchronized boolean remove(long type, int id) {
        switch (this.version) {
            case 1: {
                long d1i = this.d1locate(type, id);
                if (d1i <= 0L) break;
                try {
                    this.raf.seek(d1i + 12L);
                    int d1l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    KSFLUtilities.cut(this.raf, d1i, (long)d1l + 16L);
                    return true;
                }
                catch (IOException d1l) {
                    break;
                }
            }
            case 2: {
                long[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                try {
                    KSFLUtilities.cut(this.raf, d2i[2], d2i[5]);
                    KSFLUtilities.cut(this.raf, d2i[1], d2i[4]);
                    KSFLUtilities.cut(this.raf, d2i[0], d2i[3]);
                    this.d2dataSpace -= d2i[3] + d2i[4];
                    this.d2nameSpace -= d2i[3];
                    --this.d2objectCount;
                    this.raf.seek(4L);
                    this.raf.writeInt(this.sb ? Integer.reverseBytes(this.d2objectCount) : this.d2objectCount);
                    return true;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, id);
                    if (d3i == null) break;
                    if (d3i[9] > 0L) {
                        this.d3cut(null, d3i, d3i[9], d3i[10], 4, type, id);
                    }
                    if (d3i[7] > 0L) {
                        this.d3cut(null, d3i, d3i[7], d3i[8], 3, type, id);
                    }
                    if (d3i[2] < 2L) {
                        this.raf.seek(4L);
                        int tc = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                        this.raf.seek(4L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes(tc - 1) : tc - 1);
                        this.d3cut(null, d3i, d3i[0], d3i[1], 1, type, id);
                    } else {
                        this.raf.seek(d3i[0] + 8L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes((int)d3i[2] - 1) : (int)d3i[2] - 1);
                    }
                    if (d3i[5] > 0L) {
                        this.d3cut(null, d3i, d3i[5], d3i[6], 2, type, id);
                    }
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public synchronized boolean remove(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                long[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                try {
                    KSFLUtilities.cut(this.raf, d2i[2], d2i[5]);
                    KSFLUtilities.cut(this.raf, d2i[1], d2i[4]);
                    KSFLUtilities.cut(this.raf, d2i[0], d2i[3]);
                    this.d2dataSpace -= d2i[3] + d2i[4];
                    this.d2nameSpace -= d2i[3];
                    --this.d2objectCount;
                    this.raf.seek(4L);
                    this.raf.writeInt(this.sb ? Integer.reverseBytes(this.d2objectCount) : this.d2objectCount);
                    return true;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            case 3: {
                try {
                    int id;
                    long[] d3i = this.d3locate(type, name);
                    if (d3i == null) break;
                    this.raf.seek(d3i[5]);
                    int n = id = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    if (d3i[9] > 0L) {
                        this.d3cut(null, d3i, d3i[9], d3i[10], 4, type, id);
                    }
                    if (d3i[7] > 0L) {
                        this.d3cut(null, d3i, d3i[7], d3i[8], 3, type, id);
                    }
                    if (d3i[2] < 2L) {
                        this.raf.seek(4L);
                        int tc = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                        this.raf.seek(4L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes(tc - 1) : tc - 1);
                        this.d3cut(null, d3i, d3i[0], d3i[1], 1, type, id);
                    } else {
                        this.raf.seek(d3i[0] + 8L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes((int)d3i[2] - 1) : (int)d3i[2] - 1);
                    }
                    if (d3i[5] > 0L) {
                        this.d3cut(null, d3i, d3i[5], d3i[6], 2, type, id);
                    }
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public synchronized boolean set(long type, int id, DFFResource r) throws DFFResourceAlreadyExistsException {
        if (!this.contains(type, id)) {
            return false;
        }
        if (r.name == null) {
            r.name = "";
        }
        if (r.data == null) {
            r.data = new byte[0];
        }
        return this.setAttributes(type, id, r) && this.setData(r.type, r.id, r.data);
    }

    @Override
    public synchronized boolean set(long type, String name, DFFResource r) throws DFFResourceAlreadyExistsException {
        int id = this.getIDFromName(type, name);
        if (!this.contains(type, id)) {
            return false;
        }
        if (r.name == null) {
            r.name = "";
        }
        if (r.data == null) {
            r.data = new byte[0];
        }
        return this.setAttributes(type, id, r) && this.setData(r.type, r.id, r.data);
    }

    @Override
    public synchronized boolean setAttributes(long type, int id, DFFResource r) throws DFFResourceAlreadyExistsException {
        if (r.name == null) {
            r.name = "";
        }
        switch (this.version) {
            case 1: {
                long d1i = this.d1locate(type, id);
                if (d1i <= 0L) break;
                long d1e = this.d1locate(r.type, r.id);
                if (d1e > 0L && d1e != d1i) {
                    throw new DFFResourceAlreadyExistsException();
                }
                try {
                    this.raf.seek(d1i);
                    this.raf.writeLong(this.sb ? Long.reverseBytes(r.type) : r.type);
                    this.raf.writeShort(this.sb ? Short.reverseBytes((short)r.id) : (short)r.id);
                    return true;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            case 2: {
                long[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                long[] d2e = this.d2locate(r.type, r.id);
                if (d2e != null && (d2e[0] != d2i[0] || d2e[1] != d2i[1] || d2e[2] != d2i[2])) {
                    throw new DFFResourceAlreadyExistsException();
                }
                try {
                    this.raf.seek(d2i[0]);
                    this.raf.writeLong(this.sb ? Long.reverseBytes(r.type) : r.type);
                    this.raf.writeShort(this.sb ? Short.reverseBytes((short)(r.id & 0xFFFF)) : (short)(r.id & 0xFFFF));
                    this.raf.writeShort(this.sb ? Short.reverseBytes(r.datatype) : r.datatype);
                    this.raf.writeShort(this.sb ? Short.reverseBytes(r.getAttributes()) : r.getAttributes());
                    this.raf.writeShort(this.sb ? Short.reverseBytes((short)(r.id >> 16 & 0xFFFF)) : (short)(r.id >> 16 & 0xFFFF));
                    byte[] n = this.gb(r.name);
                    if (n.length > 255) {
                        n = KSFLUtilities.cut(n, 255, n.length - 255);
                    }
                    n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                    KSFLUtilities.cut(this.raf, d2i[1], d2i[4]);
                    KSFLUtilities.paste(this.raf, d2i[1], n);
                    this.d2dataSpace = this.d2dataSpace - d2i[4] + (long)n.length;
                    return true;
                }
                catch (IOException n) {
                    break;
                }
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, id);
                    if (d3i == null) break;
                    long[] d3e = this.d3locate(r.type, r.id);
                    if (d3e != null && (d3e[0] != d3i[0] || d3e[1] != d3i[1] || d3e[2] != d3i[2] || d3e[3] != d3i[3] || d3e[4] != d3i[4] || d3e[5] != d3i[5] || d3e[6] != d3i[6] || d3e[7] != d3i[7] || d3e[8] != d3i[8] || d3e[9] != d3i[9] || d3e[10] != d3i[10])) {
                        throw new DFFResourceAlreadyExistsException();
                    }
                    if (this.raf.length() - d3i[8] + 1L + (long)this.gb(r.name).length > 0xFFFFFFFFFFFFL) {
                        throw new DFFResourceTooBigException();
                    }
                    if (type != r.type) {
                        long[] m = this.d3metrics();
                        long[] t = this.d3getType(r.type);
                        if (t == null) {
                            int n;
                            if (m[0] == Integer.MAX_VALUE) {
                                throw new DFFResourceTooBigException("Too many types.");
                            }
                            byte[] th = new byte[16];
                            KSFLUtilities.putLong(th, 0, this.sb, r.type);
                            KSFLUtilities.putInt(th, 8, this.sb, 0);
                            KSFLUtilities.putInt(th, 12, this.sb, (int)m[4]);
                            this.raf.seek(4L);
                            if (this.sb) {
                                m[0] = m[0] + 1L;
                                n = Integer.reverseBytes((int)m[0]);
                            } else {
                                m[0] = m[0] + 1L;
                                n = (int)m[0];
                            }
                            this.raf.writeInt(n);
                            this.d3paste(m, d3i, m[1] + m[2], th, 1, r.type, r.id);
                            t = this.d3getType(r.type);
                        } else if (t[2] == Integer.MAX_VALUE) {
                            throw new DFFResourceTooBigException("Too many objects of this type.");
                        }
                        byte[] h = new byte[24];
                        KSFLUtilities.putInt(h, 0, this.sb, r.id);
                        KSFLUtilities.putShort(h, 4, this.sb, r.datatype);
                        KSFLUtilities.putShort(h, 6, this.sb, r.getAttributes());
                        KSFLUtilities.putInt(h, 8, this.sb, (int)d3i[7]);
                        KSFLUtilities.putUInt48(h, 12, this.sb, d3i[9]);
                        KSFLUtilities.putUInt48(h, 18, this.sb, d3i[10]);
                        this.raf.seek(t[0] + 8L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes((int)t[2] + 1) : (int)t[2] + 1);
                        this.d3paste(m, d3i, t[3] + t[4], h, 2, r.type, r.id);
                        if (d3i[2] < 2L) {
                            int n;
                            this.raf.seek(4L);
                            if (this.sb) {
                                m[0] = m[0] - 1L;
                                n = Integer.reverseBytes((int)m[0]);
                            } else {
                                m[0] = m[0] - 1L;
                                n = (int)m[0];
                            }
                            this.raf.writeInt(n);
                            this.d3cut(m, d3i, d3i[0], d3i[1], 1, type, id);
                        } else {
                            this.raf.seek(d3i[0] + 8L);
                            this.raf.writeInt(this.sb ? Integer.reverseBytes((int)d3i[2] - 1) : (int)d3i[2] - 1);
                        }
                        if (d3i[5] > 0L) {
                            this.d3cut(m, d3i, d3i[5], d3i[6], 2, type, id);
                        }
                    } else {
                        long[] t = this.d3getType(r.type);
                        this.raf.seek(t[0] + 8L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes((int)t[2] - 1) : (int)t[2] - 1);
                        this.d3cut(null, d3i, d3i[5], d3i[6], 2, type, id);
                        byte[] h = new byte[24];
                        KSFLUtilities.putInt(h, 0, this.sb, r.id);
                        KSFLUtilities.putShort(h, 4, this.sb, r.datatype);
                        KSFLUtilities.putShort(h, 6, this.sb, r.getAttributes());
                        KSFLUtilities.putInt(h, 8, this.sb, (int)d3i[7]);
                        KSFLUtilities.putUInt48(h, 12, this.sb, d3i[9]);
                        KSFLUtilities.putUInt48(h, 18, this.sb, d3i[10]);
                        this.raf.seek(t[0] + 8L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes((int)t[2]) : (int)t[2]);
                        this.d3paste(null, d3i, d3i[5], h, 2, r.type, r.id);
                    }
                    if (r.name.length() > 0) {
                        byte[] n = this.gb(r.name);
                        if (n.length > 255) {
                            n = KSFLUtilities.cut(n, 255, n.length - 255);
                        }
                        n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                        if (d3i[7] > 0L) {
                            this.d3paste(null, d3i, d3i[7], n, 3, r.type, r.id);
                            this.d3cut(null, d3i, d3i[7] + (long)n.length, d3i[8], 3, r.type, r.id);
                        } else {
                            d3i[7] = this.d3metrics()[6];
                            this.raf.seek(d3i[5] + 8L);
                            this.raf.writeInt(this.sb ? Integer.reverseBytes((int)d3i[7]) : (int)d3i[7]);
                            this.d3paste(null, d3i, d3i[7], n, 3, r.type, r.id);
                        }
                        d3i[8] = n.length;
                    } else if (d3i[7] > 0L) {
                        this.d3cut(null, d3i, d3i[7], d3i[8], 3, r.type, r.id);
                        this.raf.seek(d3i[5] + 8L);
                        d3i[7] = 0L;
                        this.raf.writeInt((int)0L);
                        d3i[8] = 0L;
                    }
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public synchronized boolean setAttributes(long type, String name, DFFResource r) throws DFFResourceAlreadyExistsException {
        if (r.name == null) {
            r.name = "";
        }
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                long[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                long[] d2e = this.d2locate(r.type, r.id);
                if (d2e != null && (d2e[0] != d2i[0] || d2e[1] != d2i[1] || d2e[2] != d2i[2])) {
                    throw new DFFResourceAlreadyExistsException();
                }
                try {
                    this.raf.seek(d2i[0]);
                    this.raf.writeLong(this.sb ? Long.reverseBytes(r.type) : r.type);
                    this.raf.writeShort(this.sb ? Short.reverseBytes((short)(r.id & 0xFFFF)) : (short)(r.id & 0xFFFF));
                    this.raf.writeShort(this.sb ? Short.reverseBytes(r.datatype) : r.datatype);
                    this.raf.writeShort(this.sb ? Short.reverseBytes(r.getAttributes()) : r.getAttributes());
                    this.raf.writeShort(this.sb ? Short.reverseBytes((short)(r.id >> 16 & 0xFFFF)) : (short)(r.id >> 16 & 0xFFFF));
                    byte[] n = this.gb(r.name);
                    if (n.length > 255) {
                        n = KSFLUtilities.cut(n, 255, n.length - 255);
                    }
                    n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                    KSFLUtilities.cut(this.raf, d2i[1], d2i[4]);
                    KSFLUtilities.paste(this.raf, d2i[1], n);
                    this.d2dataSpace = this.d2dataSpace - d2i[4] + (long)n.length;
                    return true;
                }
                catch (IOException n) {
                    break;
                }
            }
            case 3: {
                try {
                    int id;
                    long[] d3i = this.d3locate(type, name);
                    if (d3i == null) break;
                    long[] d3e = this.d3locate(r.type, r.id);
                    if (d3e != null && (d3e[0] != d3i[0] || d3e[1] != d3i[1] || d3e[2] != d3i[2] || d3e[3] != d3i[3] || d3e[4] != d3i[4] || d3e[5] != d3i[5] || d3e[6] != d3i[6] || d3e[7] != d3i[7] || d3e[8] != d3i[8] || d3e[9] != d3i[9] || d3e[10] != d3i[10])) {
                        throw new DFFResourceAlreadyExistsException();
                    }
                    if (this.raf.length() - d3i[8] + 1L + (long)this.gb(r.name).length > 0xFFFFFFFFFFFFL) {
                        throw new DFFResourceTooBigException();
                    }
                    this.raf.seek(d3i[5]);
                    int n = id = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    if (type != r.type) {
                        long[] m = this.d3metrics();
                        long[] t = this.d3getType(r.type);
                        if (t == null) {
                            int n2;
                            if (m[0] == Integer.MAX_VALUE) {
                                throw new DFFResourceTooBigException("Too many types.");
                            }
                            byte[] th = new byte[16];
                            KSFLUtilities.putLong(th, 0, this.sb, r.type);
                            KSFLUtilities.putInt(th, 8, this.sb, 0);
                            KSFLUtilities.putInt(th, 12, this.sb, (int)m[4]);
                            this.raf.seek(4L);
                            if (this.sb) {
                                m[0] = m[0] + 1L;
                                n2 = Integer.reverseBytes((int)m[0]);
                            } else {
                                m[0] = m[0] + 1L;
                                n2 = (int)m[0];
                            }
                            this.raf.writeInt(n2);
                            this.d3paste(m, d3i, m[1] + m[2], th, 1, r.type, r.id);
                            t = this.d3getType(r.type);
                        } else if (t[2] == Integer.MAX_VALUE) {
                            throw new DFFResourceTooBigException("Too many objects of this type.");
                        }
                        byte[] h = new byte[24];
                        KSFLUtilities.putInt(h, 0, this.sb, r.id);
                        KSFLUtilities.putShort(h, 4, this.sb, r.datatype);
                        KSFLUtilities.putShort(h, 6, this.sb, r.getAttributes());
                        KSFLUtilities.putInt(h, 8, this.sb, (int)d3i[7]);
                        KSFLUtilities.putUInt48(h, 12, this.sb, d3i[9]);
                        KSFLUtilities.putUInt48(h, 18, this.sb, d3i[10]);
                        this.raf.seek(t[0] + 8L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes((int)t[2] + 1) : (int)t[2] + 1);
                        this.d3paste(m, d3i, t[3] + t[4], h, 2, r.type, r.id);
                        if (d3i[2] < 2L) {
                            int n3;
                            this.raf.seek(4L);
                            if (this.sb) {
                                m[0] = m[0] - 1L;
                                n3 = Integer.reverseBytes((int)m[0]);
                            } else {
                                m[0] = m[0] - 1L;
                                n3 = (int)m[0];
                            }
                            this.raf.writeInt(n3);
                            this.d3cut(m, d3i, d3i[0], d3i[1], 1, type, id);
                        } else {
                            this.raf.seek(d3i[0] + 8L);
                            this.raf.writeInt(this.sb ? Integer.reverseBytes((int)d3i[2] - 1) : (int)d3i[2] - 1);
                        }
                        if (d3i[5] > 0L) {
                            this.d3cut(m, d3i, d3i[5], d3i[6], 2, type, id);
                        }
                    } else {
                        long[] t = this.d3getType(r.type);
                        this.raf.seek(t[0] + 8L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes((int)t[2] - 1) : (int)t[2] - 1);
                        this.d3cut(null, d3i, d3i[5], d3i[6], 2, type, id);
                        byte[] h = new byte[24];
                        KSFLUtilities.putInt(h, 0, this.sb, r.id);
                        KSFLUtilities.putShort(h, 4, this.sb, r.datatype);
                        KSFLUtilities.putShort(h, 6, this.sb, r.getAttributes());
                        KSFLUtilities.putInt(h, 8, this.sb, (int)d3i[7]);
                        KSFLUtilities.putUInt48(h, 12, this.sb, d3i[9]);
                        KSFLUtilities.putUInt48(h, 18, this.sb, d3i[10]);
                        this.raf.seek(t[0] + 8L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes((int)t[2]) : (int)t[2]);
                        this.d3paste(null, d3i, d3i[5], h, 2, r.type, r.id);
                    }
                    if (r.name.length() > 0) {
                        byte[] n4 = this.gb(r.name);
                        if (n4.length > 255) {
                            n4 = KSFLUtilities.cut(n4, 255, n4.length - 255);
                        }
                        n4 = KSFLUtilities.paste(n4, 0, new byte[]{(byte)n4.length});
                        if (d3i[7] > 0L) {
                            this.d3paste(null, d3i, d3i[7], n4, 3, r.type, r.id);
                            this.d3cut(null, d3i, d3i[7] + (long)n4.length, d3i[8], 3, r.type, r.id);
                        } else {
                            d3i[7] = this.d3metrics()[6];
                            this.raf.seek(d3i[5] + 8L);
                            this.raf.writeInt(this.sb ? Integer.reverseBytes((int)d3i[7]) : (int)d3i[7]);
                            this.d3paste(null, d3i, d3i[7], n4, 3, r.type, r.id);
                        }
                        d3i[8] = n4.length;
                    } else if (d3i[7] > 0L) {
                        this.d3cut(null, d3i, d3i[7], d3i[8], 3, r.type, r.id);
                        this.raf.seek(d3i[5] + 8L);
                        d3i[7] = 0L;
                        this.raf.writeInt((int)0L);
                        d3i[8] = 0L;
                    }
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public synchronized boolean setLength(long type, int id, long len) {
        switch (this.version) {
            case 1: {
                if (len > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                long d1i = this.d1locate(type, id);
                if (d1i <= 0L) break;
                try {
                    int d1l;
                    this.raf.seek(d1i + 12L);
                    int n = d1l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    if (len < (long)d1l) {
                        KSFLUtilities.cut(this.raf, d1i + 16L + len, (long)d1l - len);
                    } else {
                        KSFLUtilities.paste(this.raf, d1i + 16L + (long)d1l, len - (long)d1l);
                    }
                    this.raf.seek(d1i + 12L);
                    this.raf.writeInt(this.sb ? Integer.reverseBytes((int)len) : (int)len);
                    return true;
                }
                catch (IOException d1l) {
                    break;
                }
            }
            case 2: {
                if (len > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                long[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                try {
                    if (len < d2i[5]) {
                        KSFLUtilities.cut(this.raf, d2i[2] + len, d2i[5] - len);
                    } else {
                        KSFLUtilities.paste(this.raf, d2i[2] + d2i[5], len - d2i[5]);
                    }
                    this.raf.seek(d2i[0] + 16L);
                    this.raf.writeInt(this.sb ? Integer.reverseBytes((int)len) : (int)len);
                    return true;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, id);
                    if (d3i == null) break;
                    this.raf.seek(d3i[5]);
                    if (this.raf.length() - d3i[10] + len > 0xFFFFFFFFFFFFL) {
                        throw new DFFResourceTooBigException();
                    }
                    this.raf.seek(d3i[5] + 18L);
                    KSFLUtilities.writeUInt48(this.raf, this.sb ? KSFLUtilities.reverseUInt48(len) : len);
                    if (len < d3i[10]) {
                        this.d3cut(null, d3i, d3i[9] + len, d3i[10] - len, 4, type, id);
                    } else {
                        this.d3paste(null, d3i, d3i[9] + d3i[10], len - d3i[10], 4, type, id);
                    }
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public synchronized boolean setLength(long type, String name, long len) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                if (len > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                long[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                try {
                    if (len < d2i[5]) {
                        KSFLUtilities.cut(this.raf, d2i[2] + len, d2i[5] - len);
                    } else {
                        KSFLUtilities.paste(this.raf, d2i[2] + d2i[5], len - d2i[5]);
                    }
                    this.raf.seek(d2i[0] + 16L);
                    this.raf.writeInt(this.sb ? Integer.reverseBytes((int)len) : (int)len);
                    return true;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            case 3: {
                try {
                    int id;
                    long[] d3i = this.d3locate(type, name);
                    if (d3i == null) break;
                    this.raf.seek(d3i[5]);
                    int n = id = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    if (this.raf.length() - d3i[10] + len > 0xFFFFFFFFFFFFL) {
                        throw new DFFResourceTooBigException();
                    }
                    this.raf.seek(d3i[5] + 18L);
                    KSFLUtilities.writeUInt48(this.raf, this.sb ? KSFLUtilities.reverseUInt48(len) : len);
                    if (len < d3i[10]) {
                        this.d3cut(null, d3i, d3i[9] + len, d3i[10] - len, 4, type, id);
                    } else {
                        this.d3paste(null, d3i, d3i[9] + d3i[10], len - d3i[10], 4, type, id);
                    }
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public synchronized boolean setData(long type, int id, byte[] data) {
        switch (this.version) {
            case 1: {
                long d1i = this.d1locate(type, id);
                if (d1i <= 0L) break;
                try {
                    this.raf.seek(d1i + 12L);
                    int d1l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    KSFLUtilities.cut(this.raf, d1i + 16L, d1l);
                    this.raf.seek(d1i + 12L);
                    this.raf.writeInt(0);
                    KSFLUtilities.paste(this.raf, d1i + 16L, data);
                    this.raf.seek(d1i + 12L);
                    this.raf.writeInt(this.sb ? Integer.reverseBytes(data.length) : data.length);
                    return true;
                }
                catch (IOException d1l) {
                    break;
                }
            }
            case 2: {
                long[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                try {
                    KSFLUtilities.cut(this.raf, d2i[2], d2i[5]);
                    KSFLUtilities.paste(this.raf, d2i[2], data);
                    this.raf.seek(d2i[0] + 16L);
                    this.raf.writeInt(this.sb ? Integer.reverseBytes(data.length) : data.length);
                    return true;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, id);
                    if (d3i == null) break;
                    this.raf.seek(d3i[5]);
                    if (d3i[9] > 0L) {
                        this.d3cut(null, d3i, d3i[9], d3i[10], 4, type, id);
                    }
                    if (data.length > 0) {
                        if (d3i[9] <= 0L) {
                            d3i[9] = this.d3metrics()[8];
                            this.raf.seek(d3i[5] + 12L);
                            KSFLUtilities.writeUInt48(this.raf, this.sb ? KSFLUtilities.reverseUInt48(d3i[9]) : d3i[9]);
                        }
                        this.raf.seek(d3i[5] + 18L);
                        KSFLUtilities.writeUInt48(this.raf, this.sb ? KSFLUtilities.reverseUInt48(data.length) : (long)data.length);
                        this.d3paste(null, d3i, d3i[9], data, 4, type, id);
                    } else if (d3i[9] > 0L) {
                        this.raf.seek(d3i[5] + 18L);
                        KSFLUtilities.writeUInt48(this.raf, 0L);
                    }
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public synchronized boolean setData(long type, String name, byte[] data) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                long[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                try {
                    KSFLUtilities.cut(this.raf, d2i[2], d2i[5]);
                    KSFLUtilities.paste(this.raf, d2i[2], data);
                    this.raf.seek(d2i[0] + 16L);
                    this.raf.writeInt(this.sb ? Integer.reverseBytes(data.length) : data.length);
                    return true;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            case 3: {
                try {
                    int id;
                    long[] d3i = this.d3locate(type, name);
                    if (d3i == null) break;
                    this.raf.seek(d3i[5]);
                    int n = id = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    if (d3i[9] > 0L) {
                        this.d3cut(null, d3i, d3i[9], d3i[10], 4, type, id);
                    }
                    if (data.length > 0) {
                        if (d3i[9] <= 0L) {
                            d3i[9] = this.d3metrics()[8];
                            this.raf.seek(d3i[5] + 12L);
                            KSFLUtilities.writeUInt48(this.raf, this.sb ? KSFLUtilities.reverseUInt48(d3i[9]) : d3i[9]);
                        }
                        this.raf.seek(d3i[5] + 18L);
                        KSFLUtilities.writeUInt48(this.raf, this.sb ? KSFLUtilities.reverseUInt48(data.length) : (long)data.length);
                        this.d3paste(null, d3i, d3i[9], data, 4, type, id);
                    } else if (d3i[9] > 0L) {
                        this.raf.seek(d3i[5] + 18L);
                        KSFLUtilities.writeUInt48(this.raf, 0L);
                    }
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized int write(long type, int id, long doffset, byte[] data, int off, int len) {
        switch (this.version) {
            case 1: {
                long d1i = this.d1locate(type, id);
                if (d1i <= 0L) return 0;
                try {
                    this.raf.seek(d1i + 12L);
                    long d1l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    if (doffset + (long)len > d1l) {
                        if (doffset + (long)len > Integer.MAX_VALUE) {
                            throw new DFFResourceTooBigException();
                        }
                        if (doffset > d1l) {
                            KSFLUtilities.paste(this.raf, d1i + 16L + d1l, doffset - d1l + (long)len);
                        } else {
                            KSFLUtilities.paste(this.raf, d1i + 16L + d1l, (long)len - (d1l - doffset));
                        }
                        this.raf.seek(d1i + 12L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes((int)(doffset + (long)len)) : (int)(doffset + (long)len));
                    }
                    this.raf.seek(d1i + 16L + doffset);
                    this.raf.write(data, off, len);
                    return len;
                }
                catch (IOException d1l) {
                    return 0;
                }
            }
            case 2: {
                long[] d2i = this.d2locate(type, id);
                if (d2i == null) return 0;
                try {
                    if (doffset + (long)len > d2i[5]) {
                        if (doffset + (long)len > Integer.MAX_VALUE) {
                            throw new DFFResourceTooBigException();
                        }
                        if (doffset > d2i[5]) {
                            KSFLUtilities.paste(this.raf, d2i[2] + d2i[5], doffset - d2i[5] + (long)len);
                        } else {
                            KSFLUtilities.paste(this.raf, d2i[2] + d2i[5], (long)len - (d2i[5] - doffset));
                        }
                        this.raf.seek(d2i[0] + 16L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes((int)(doffset + (long)len)) : (int)(doffset + (long)len));
                    }
                    this.raf.seek(d2i[2] + doffset);
                    this.raf.write(data, off, len);
                    return len;
                }
                catch (IOException iOException) {
                    return 0;
                }
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, id);
                    if (d3i == null) return 0;
                    if (doffset + (long)len > d3i[10]) {
                        if (this.raf.length() - d3i[10] + doffset + (long)len > 0xFFFFFFFFFFFFL) {
                            throw new DFFResourceTooBigException();
                        }
                        this.raf.seek(d3i[5] + 18L);
                        KSFLUtilities.writeUInt48(this.raf, this.sb ? KSFLUtilities.reverseUInt48(doffset + (long)len) : doffset + (long)len);
                        if (doffset > d3i[10]) {
                            this.d3paste(null, d3i, d3i[9] + d3i[10], doffset - d3i[10], 4, type, id);
                        } else {
                            this.d3cut(null, d3i, d3i[9] + doffset, d3i[10] - doffset, 4, type, id);
                        }
                        this.d3paste(null, d3i, d3i[9] + doffset, KSFLUtilities.copy(data, off, len), 4, type, id);
                        return len;
                    } else {
                        KSFLUtilities.cut(this.raf, d3i[9] + doffset, len);
                        KSFLUtilities.paste(this.raf, d3i[9] + doffset, KSFLUtilities.copy(data, off, len));
                    }
                    return len;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized int write(long type, String name, long doffset, byte[] data, int off, int len) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                long[] d2i = this.d2locate(type, name);
                if (d2i == null) return 0;
                try {
                    if (doffset + (long)len > d2i[5]) {
                        if (doffset + (long)len > Integer.MAX_VALUE) {
                            throw new DFFResourceTooBigException();
                        }
                        if (doffset > d2i[5]) {
                            KSFLUtilities.paste(this.raf, d2i[2] + d2i[5], doffset - d2i[5] + (long)len);
                        } else {
                            KSFLUtilities.paste(this.raf, d2i[2] + d2i[5], (long)len - (d2i[5] - doffset));
                        }
                        this.raf.seek(d2i[0] + 16L);
                        this.raf.writeInt(this.sb ? Integer.reverseBytes((int)(doffset + (long)len)) : (int)(doffset + (long)len));
                    }
                    this.raf.seek(d2i[2] + doffset);
                    this.raf.write(data, off, len);
                    return len;
                }
                catch (IOException iOException) {
                    return 0;
                }
            }
            case 3: {
                try {
                    int id;
                    long[] d3i = this.d3locate(type, name);
                    if (d3i == null) return 0;
                    this.raf.seek(d3i[5]);
                    int n = id = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    if (doffset + (long)len > d3i[10]) {
                        if (this.raf.length() - d3i[10] + doffset + (long)len > 0xFFFFFFFFFFFFL) {
                            throw new DFFResourceTooBigException();
                        }
                        this.raf.seek(d3i[5] + 18L);
                        KSFLUtilities.writeUInt48(this.raf, this.sb ? KSFLUtilities.reverseUInt48(doffset + (long)len) : doffset + (long)len);
                        if (doffset > d3i[10]) {
                            this.d3paste(null, d3i, d3i[9] + d3i[10], doffset - d3i[10], 4, type, id);
                        } else {
                            this.d3cut(null, d3i, d3i[9] + doffset, d3i[10] - doffset, 4, type, id);
                        }
                        this.d3paste(null, d3i, d3i[9] + doffset, KSFLUtilities.copy(data, off, len), 4, type, id);
                        return len;
                    } else {
                        KSFLUtilities.cut(this.raf, d3i[9] + doffset, len);
                        KSFLUtilities.paste(this.raf, d3i[9] + doffset, KSFLUtilities.copy(data, off, len));
                    }
                    return len;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    @Override
    public synchronized int getTypeCount() {
        switch (this.version) {
            case 1: {
                ArrayList<Long> d1s = new ArrayList<Long>();
                try {
                    this.raf.seek(4L);
                    while (this.raf.getFilePointer() + 16L <= this.raf.length()) {
                        int l;
                        long ty = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        this.raf.readShort();
                        this.raf.readShort();
                        int n = l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                        if (!d1s.contains(ty)) {
                            d1s.add(ty);
                        }
                        this.raf.skipBytes(l);
                    }
                }
                catch (IOException ty) {
                    // empty catch block
                }
                return d1s.size();
            }
            case 2: {
                ArrayList<Long> d2s = new ArrayList<Long>();
                int d2i = 0;
                long d2h = this.d2headerSpace;
                try {
                    this.raf.seek(this.d2headerSpace);
                    while (d2i < this.d2objectCount && d2h < this.d2nameSpace) {
                        long ty;
                        long l = ty = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        if (!d2s.contains(ty)) {
                            d2s.add(ty);
                        }
                        this.raf.skipBytes(12);
                        d2h += 20L;
                        ++d2i;
                    }
                }
                catch (IOException ty) {
                    // empty catch block
                }
                return d2s.size();
            }
            case 3: {
                try {
                    this.raf.seek(4L);
                    int d3typeCnt = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    return d3typeCnt;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized long getType(int index) {
        switch (this.version) {
            case 1: {
                ArrayList<Long> d1s = new ArrayList<Long>();
                try {
                    this.raf.seek(4L);
                    while (true) {
                        int l;
                        if (this.raf.getFilePointer() + 16L > this.raf.length()) {
                            return 0L;
                        }
                        long ty = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        this.raf.readShort();
                        this.raf.readShort();
                        int n = l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                        if (!d1s.contains(ty)) {
                            if (d1s.size() == index) {
                                return ty;
                            }
                            d1s.add(ty);
                        }
                        this.raf.skipBytes(l);
                    }
                }
                catch (IOException ty) {
                    return 0L;
                }
            }
            case 2: {
                ArrayList<Long> d2s = new ArrayList<Long>();
                int d2i = 0;
                long d2h = this.d2headerSpace;
                try {
                    this.raf.seek(this.d2headerSpace);
                    while (d2i < this.d2objectCount) {
                        long ty;
                        if (d2h >= this.d2nameSpace) {
                            return 0L;
                        }
                        long l = ty = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        if (!d2s.contains(ty)) {
                            if (d2s.size() == index) {
                                return ty;
                            }
                            d2s.add(ty);
                        }
                        this.raf.skipBytes(12);
                        d2h += 20L;
                        ++d2i;
                    }
                    return 0L;
                }
                catch (IOException ty) {
                    return 0L;
                }
            }
            case 3: {
                try {
                    long l;
                    this.raf.seek(4L);
                    int d3typeCnt = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    if (index < 0) return 0L;
                    if (index >= d3typeCnt) return 0L;
                    this.raf.seek(8L + 16L * (long)index);
                    if (this.sb) {
                        l = Long.reverseBytes(this.raf.readLong());
                        return l;
                    }
                    l = this.raf.readLong();
                    return l;
                }
                catch (IOException iOException) {
                    // empty catch block
                    return 0L;
                }
            }
        }
        return 0L;
    }

    @Override
    public synchronized long[] getTypes() {
        switch (this.version) {
            case 1: {
                ArrayList<Long> d1s = new ArrayList<Long>();
                try {
                    this.raf.seek(4L);
                    while (this.raf.getFilePointer() + 16L <= this.raf.length()) {
                        int l;
                        long ty = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        this.raf.readShort();
                        this.raf.readShort();
                        int n = l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                        if (!d1s.contains(ty)) {
                            d1s.add(ty);
                        }
                        this.raf.skipBytes(l);
                    }
                }
                catch (IOException ty) {
                    // empty catch block
                }
                long[] d1a = new long[d1s.size()];
                Iterator d1si = d1s.iterator();
                int d1ai = 0;
                while (d1si.hasNext()) {
                    d1a[d1ai++] = (Long)d1si.next();
                }
                return d1a;
            }
            case 2: {
                ArrayList<Long> d2s = new ArrayList<Long>();
                int d2i = 0;
                long d2h = this.d2headerSpace;
                try {
                    this.raf.seek(this.d2headerSpace);
                    while (d2i < this.d2objectCount && d2h < this.d2nameSpace) {
                        long ty;
                        long l = ty = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        if (!d2s.contains(ty)) {
                            d2s.add(ty);
                        }
                        this.raf.skipBytes(12);
                        d2h += 20L;
                        ++d2i;
                    }
                }
                catch (IOException ty) {
                    // empty catch block
                }
                long[] d2a = new long[d2s.size()];
                Iterator d2si = d2s.iterator();
                int d2ai = 0;
                while (d2si.hasNext()) {
                    d2a[d2ai++] = (Long)d2si.next();
                }
                return d2a;
            }
            case 3: {
                try {
                    this.raf.seek(4L);
                    int d3typeCnt = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    long[] d3a = new long[d3typeCnt];
                    int d3i = 0;
                    while (d3i < d3typeCnt) {
                        d3a[d3i] = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        this.raf.readLong();
                        ++d3i;
                    }
                    return d3a;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized int getResourceCount(long type) {
        switch (this.version) {
            case 1: {
                ArrayList<Integer> d1s = new ArrayList<Integer>();
                try {
                    this.raf.seek(4L);
                    while (this.raf.getFilePointer() + 16L <= this.raf.length()) {
                        int l;
                        long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        short i = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                        this.raf.readShort();
                        int n = l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                        if (t == type && !d1s.contains(i)) {
                            d1s.add(Integer.valueOf(i));
                        }
                        this.raf.skipBytes(l);
                    }
                    return d1s.size();
                }
                catch (IOException t) {
                    // empty catch block
                }
                return d1s.size();
            }
            case 2: {
                ArrayList<Integer> d2s = new ArrayList<Integer>();
                int d2i = 0;
                long d2h = this.d2headerSpace;
                try {
                    this.raf.seek(this.d2headerSpace);
                    while (d2i < this.d2objectCount && d2h < this.d2nameSpace) {
                        long ty;
                        long l = ty = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        if (ty == type) {
                            short id1 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                            this.raf.readShort();
                            this.raf.readShort();
                            short id2 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                            int id = id1 & 0xFFFF | id2 << 16 & 0xFFFF0000;
                            if (!d2s.contains(id)) {
                                d2s.add(id);
                            }
                            this.raf.skipBytes(4);
                        } else {
                            this.raf.skipBytes(12);
                        }
                        d2h += 20L;
                        ++d2i;
                    }
                    return d2s.size();
                }
                catch (IOException ty) {
                    // empty catch block
                }
                return d2s.size();
            }
            case 3: {
                try {
                    long[] d3t = this.d3getType(type);
                    if (d3t == null) return 0;
                    return (int)d3t[2];
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int getID(long type, int index) {
        switch (this.version) {
            case 1: {
                ArrayList<Integer> d1s = new ArrayList<Integer>();
                try {
                    this.raf.seek(4L);
                    while (true) {
                        int l;
                        if (this.raf.getFilePointer() + 16L > this.raf.length()) {
                            return 0;
                        }
                        long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        short i = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                        this.raf.readShort();
                        int n = l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                        if (t == type && !d1s.contains(i)) {
                            if (d1s.size() == index) {
                                return i;
                            }
                            d1s.add(Integer.valueOf(i));
                        }
                        this.raf.skipBytes(l);
                    }
                }
                catch (IOException t) {
                    return 0;
                }
            }
            case 2: {
                ArrayList<Integer> d2s = new ArrayList<Integer>();
                int d2i = 0;
                long d2h = this.d2headerSpace;
                try {
                    this.raf.seek(this.d2headerSpace);
                    while (d2i < this.d2objectCount) {
                        long ty;
                        if (d2h >= this.d2nameSpace) {
                            return 0;
                        }
                        long l = ty = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        if (ty == type) {
                            short id1 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                            this.raf.readShort();
                            this.raf.readShort();
                            short id2 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                            int id = id1 & 0xFFFF | id2 << 16 & 0xFFFF0000;
                            if (!d2s.contains(id)) {
                                if (d2s.size() == index) {
                                    return id;
                                }
                                d2s.add(id);
                            }
                            this.raf.skipBytes(4);
                        } else {
                            this.raf.skipBytes(12);
                        }
                        d2h += 20L;
                        ++d2i;
                    }
                    return 0;
                }
                catch (IOException ty) {
                    return 0;
                }
            }
            case 3: {
                try {
                    int n;
                    long[] d3t = this.d3getType(type);
                    if (d3t == null) return 0;
                    if (index < 0) return 0;
                    if ((long)index >= d3t[2]) return 0;
                    this.raf.seek(d3t[3] + 24L * (long)index);
                    if (this.sb) {
                        n = Integer.reverseBytes(this.raf.readInt());
                        return n;
                    }
                    n = this.raf.readInt();
                    return n;
                }
                catch (IOException iOException) {
                    // empty catch block
                    return 0;
                }
            }
        }
        return 0;
    }

    @Override
    public synchronized int[] getIDs(long type) {
        switch (this.version) {
            case 1: {
                ArrayList<Integer> d1s = new ArrayList<Integer>();
                try {
                    this.raf.seek(4L);
                    while (this.raf.getFilePointer() + 16L <= this.raf.length()) {
                        int l;
                        long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        short i = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                        this.raf.readShort();
                        int n = l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                        if (t == type && !d1s.contains(i)) {
                            d1s.add(Integer.valueOf(i));
                        }
                        this.raf.skipBytes(l);
                    }
                }
                catch (IOException t) {
                    // empty catch block
                }
                int[] d1a = new int[d1s.size()];
                Iterator d1si = d1s.iterator();
                int d1ai = 0;
                while (d1si.hasNext()) {
                    d1a[d1ai++] = (Integer)d1si.next();
                }
                return d1a;
            }
            case 2: {
                ArrayList<Integer> d2s = new ArrayList<Integer>();
                int d2i = 0;
                long d2h = this.d2headerSpace;
                try {
                    this.raf.seek(this.d2headerSpace);
                    while (d2i < this.d2objectCount && d2h < this.d2nameSpace) {
                        long ty;
                        long l = ty = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        if (ty == type) {
                            short id1 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                            this.raf.readShort();
                            this.raf.readShort();
                            short id2 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                            int id = id1 & 0xFFFF | id2 << 16 & 0xFFFF0000;
                            if (!d2s.contains(id)) {
                                d2s.add(id);
                            }
                            this.raf.skipBytes(4);
                        } else {
                            this.raf.skipBytes(12);
                        }
                        d2h += 20L;
                        ++d2i;
                    }
                }
                catch (IOException ty) {
                    // empty catch block
                }
                int[] d2a = new int[d2s.size()];
                Iterator d2si = d2s.iterator();
                int d2ai = 0;
                while (d2si.hasNext()) {
                    d2a[d2ai++] = (Integer)d2si.next();
                }
                return d2a;
            }
            case 3: {
                try {
                    long[] d3t = this.d3getType(type);
                    if (d3t != null) {
                        int[] d3a = new int[(int)d3t[2]];
                        this.raf.seek(d3t[3]);
                        int d3i = 0;
                        while ((long)d3i < d3t[2]) {
                            d3a[d3i] = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                            this.raf.skipBytes(20);
                            ++d3i;
                        }
                        return d3a;
                    }
                    return new int[0];
                }
                catch (IOException iOException) {
                    return new int[0];
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized String getName(long type, int index) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                ArrayList<String> d2s = new ArrayList<String>();
                int d2i = 0;
                long d2h = this.d2headerSpace;
                long d2n = this.d2nameSpace;
                try {
                    while (d2i < this.d2objectCount) {
                        if (d2h >= this.d2nameSpace) return null;
                        if (d2n >= this.d2dataSpace) {
                            return null;
                        }
                        this.raf.seek(d2h);
                        long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        this.raf.seek(d2n);
                        int nl = this.raf.readByte() & 0xFF;
                        if (t == type) {
                            byte[] nb = new byte[nl];
                            this.raf.read(nb);
                            String n = this.ns(nb);
                            if (d2s.size() == index) {
                                return n;
                            }
                            d2s.add(n);
                        }
                        d2n += (long)(1 + nl);
                        d2h += 20L;
                        ++d2i;
                    }
                    return null;
                }
                catch (IOException t) {
                    return null;
                }
            }
            case 3: {
                try {
                    long[] d3t = this.d3getType(type);
                    if (d3t == null) return null;
                    if (index < 0) return null;
                    if ((long)index >= d3t[2]) return null;
                    this.raf.seek(d3t[3] + 24L * (long)index + 8L);
                    int nameOfst = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                    String n = "";
                    if (nameOfst <= 0) return n;
                    this.raf.seek(nameOfst);
                    int nameLen = this.raf.readByte() & 0xFF;
                    byte[] nb = new byte[nameLen];
                    this.raf.read(nb);
                    return this.ns(nb);
                }
                catch (IOException iOException) {
                    // empty catch block
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public synchronized String[] getNames(long type) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                ArrayList<String> d2s = new ArrayList<String>();
                int d2i = 0;
                long d2h = this.d2headerSpace;
                long d2n = this.d2nameSpace;
                try {
                    while (d2i < this.d2objectCount && d2h < this.d2nameSpace && d2n < this.d2dataSpace) {
                        this.raf.seek(d2h);
                        long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        this.raf.seek(d2n);
                        int nl = this.raf.readByte() & 0xFF;
                        if (t == type) {
                            byte[] nb = new byte[nl];
                            this.raf.read(nb);
                            String n = this.ns(nb);
                            d2s.add(n);
                        }
                        d2n += (long)(1 + nl);
                        d2h += 20L;
                        ++d2i;
                    }
                }
                catch (IOException t) {
                    // empty catch block
                }
                return d2s.toArray(new String[0]);
            }
            case 3: {
                ArrayList<String> d3s = new ArrayList<String>();
                try {
                    long[] d3t = this.d3getType(type);
                    if (d3t != null) {
                        int d3i = 0;
                        while ((long)d3i < d3t[2]) {
                            this.raf.seek(d3t[3] + 24L * (long)d3i + 8L);
                            int nameOfst = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                            String n = "";
                            if (nameOfst > 0) {
                                this.raf.seek(nameOfst);
                                int nameLen = this.raf.readByte() & 0xFF;
                                byte[] nb = new byte[nameLen];
                                this.raf.read(nb);
                                n = this.ns(nb);
                            }
                            d3s.add(n);
                            ++d3i;
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return d3s.toArray(new String[0]);
            }
        }
        return null;
    }

    @Override
    public synchronized int getNextAvailableID(long type, int start) {
        switch (this.version) {
            case 1: {
                ArrayList<Integer> d1s = new ArrayList<Integer>();
                try {
                    this.raf.seek(4L);
                    while (this.raf.getFilePointer() + 16L <= this.raf.length()) {
                        int l;
                        long t = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        short i = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                        this.raf.readShort();
                        int n = l = this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                        if (t == type && !d1s.contains(i)) {
                            d1s.add(Integer.valueOf(i));
                        }
                        this.raf.skipBytes(l);
                    }
                }
                catch (IOException t) {
                    // empty catch block
                }
                int d1n = start;
                while (d1s.contains(d1n)) {
                    ++d1n;
                }
                return d1n;
            }
            case 2: {
                ArrayList<Integer> d2s = new ArrayList<Integer>();
                int d2i = 0;
                long d2h = this.d2headerSpace;
                try {
                    this.raf.seek(this.d2headerSpace);
                    while (d2i < this.d2objectCount && d2h < this.d2nameSpace) {
                        long ty;
                        long l = ty = this.sb ? Long.reverseBytes(this.raf.readLong()) : this.raf.readLong();
                        if (ty == type) {
                            short id1 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                            this.raf.readShort();
                            this.raf.readShort();
                            short id2 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                            int id = id1 & 0xFFFF | id2 << 16 & 0xFFFF0000;
                            if (!d2s.contains(id)) {
                                d2s.add(id);
                            }
                            this.raf.skipBytes(4);
                        } else {
                            this.raf.skipBytes(12);
                        }
                        d2h += 20L;
                        ++d2i;
                    }
                }
                catch (IOException ty) {
                    // empty catch block
                }
                int d2n = start;
                while (d2s.contains(d2n)) {
                    ++d2n;
                }
                return d2n;
            }
            case 3: {
                try {
                    ArrayList<Integer> d3s = new ArrayList<Integer>();
                    long[] d3t = this.d3getType(type);
                    if (d3t != null) {
                        this.raf.seek(d3t[3]);
                        int d3i = 0;
                        while ((long)d3i < d3t[2]) {
                            d3s.add(this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt());
                            this.raf.skipBytes(20);
                            ++d3i;
                        }
                    }
                    int d3n = start;
                    while (d3s.contains(d3n)) {
                        ++d3n;
                    }
                    return d3n;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return start;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized String getNameFromID(long type, int id) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                long[] d2i = this.d2locate(type, id);
                if (d2i == null) return null;
                try {
                    this.raf.seek(d2i[1]);
                    int nl = this.raf.readByte() & 0xFF;
                    byte[] nb = new byte[nl];
                    this.raf.read(nb);
                    return this.ns(nb);
                }
                catch (IOException nl) {
                    return null;
                }
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, id);
                    if (d3i == null) return null;
                    String n = "";
                    if (d3i[7] <= 0L) return n;
                    byte[] nb = new byte[(int)d3i[8] - 1];
                    this.raf.seek(d3i[7] + 1L);
                    this.raf.read(nb);
                    return this.ns(nb);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized int getIDFromName(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                long[] d2i = this.d2locate(type, name);
                if (d2i == null) return 0;
                try {
                    this.raf.seek(d2i[0] + 8L);
                    short id1 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    this.raf.readShort();
                    this.raf.readShort();
                    short id2 = this.sb ? Short.reverseBytes(this.raf.readShort()) : this.raf.readShort();
                    return id1 & 0xFFFF | id2 << 16 & 0xFFFF0000;
                }
                catch (IOException id1) {
                    return 0;
                }
            }
            case 3: {
                try {
                    long[] d3i = this.d3locate(type, name);
                    if (d3i == null) return 0;
                    this.raf.seek(d3i[5]);
                    return this.sb ? Integer.reverseBytes(this.raf.readInt()) : this.raf.readInt();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }
}

