/*
 *	bitz-server, An ICAP server implementation in C++
 *	Copyright (C) 2012	Uditha Atukorala
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef BITZ_OPTIONS_REQUEST_HANDLER_H
#define BITZ_OPTIONS_REQUEST_HANDLER_H

#include "request_handler.h"


namespace bitz {

	class OptionsRequestHandler : public RequestHandler {
	public:
		OptionsRequestHandler();
		virtual ~OptionsRequestHandler();

		icap::Response * process( icap::RequestHeader * req_header, psocksxx::iosockstream * socket ) throw();

		/**
		*   Register a request handler so it is known to the OPTIONS
		*   handler
		*
		*   @param req_handler request handler
		*/
		void register_handler( RequestHandler * req_handler ) throw();

	private:
		std::vector<std::string> _methods;

	};

} /* end of namespace bitz */

#endif /* !BITZ_OPTIONS_REQUEST_HANDLER_H */

