//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Data/MaskUnitsConverter.h
//! @brief     Defines class MaskUnitsConverter
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_DATA_MASKUNITSCONVERTER_H
#define BORNAGAIN_GUI_MODEL_DATA_MASKUNITSCONVERTER_H

class IntensityDataItem;
class Datafield;
class MaskItem;

//! The MaskUnitsConverter converts coordinates of all masks from one units to anoter.
//! I.e. masks in 'mm' into masks in 'deg'. This is done in two steps.
//! On first step masks are converted from native coordinates (as given by axes of Datafield)
//! into bin-fraction coordinates.
//! On second step masks are converted from bin-fraction coordinates into current axes of
//! Datafield.

class MaskUnitsConverter {
public:
    enum EConvertionDirection { TO_NBINS, FROM_NBINS, UNDEFINED };

    MaskUnitsConverter();

    void convertToNbins(IntensityDataItem* intensityData);
    void convertFromNbins(IntensityDataItem* intensityData);

private:
    enum class Axis { X, Y };

    void convertIntensityDataItem(IntensityDataItem* intensityData);
    void convertMask(MaskItem* maskItem);

    double convert(double value, Axis axis);

    const Datafield* m_data;
    EConvertionDirection m_direction;
};

#endif // BORNAGAIN_GUI_MODEL_DATA_MASKUNITSCONVERTER_H
