//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Device/InstrumentNotifier.h
//! @brief     Defines class InstrumentNotifier
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_DEVICE_INSTRUMENTNOTIFIER_H
#define BORNAGAIN_GUI_MODEL_DEVICE_INSTRUMENTNOTIFIER_H

#include <QObject>

class InstrumentItem;
class RealItem;
class MultiInstrumentNotifier;
class DoubleProperty;

//! Single-instrument-adapter to InstrumentsEditorController
//!
//! InstrumentsEditorController is not instrument-wise, but handles all instruments. This is
//! sometimes unhandy, e.g. if the changed instrument has to be passed through many hierarchies to
//! only be able to notify correctly. Instantiate this class instead and pass it to editors.
//!
//! Calling notification methods or change methods also take care of dependent data, like in
//! notifyWavelengthDistributionChanged().
class InstrumentNotifier : public QObject {
    Q_OBJECT
public:
    InstrumentNotifier(MultiInstrumentNotifier* ec, InstrumentItem* instrument);

    //! Set the instrument name and emit the respective signal.
    //!
    //! The signal is emitted by the parent MultiInstrumentNotifier.
    void setInstrumentName(const QString& name);

    //! Call this if any instrument value has been changed outside this controller.
    //!
    //! emits MultiInstrumentNotifier::instrumentChanged
    //! For example if a double has been changed, but setDouble() has not been called
    void notifyInstrumentChanged();

    //! Update dependent data and emit a changed signal
    void notifyWavelengthDistributionChanged();

    //! Update dependent data and emit a changed signal
    void notifyInclinationAxisChanged();

private:
    InstrumentItem* m_instrumentItem;
    MultiInstrumentNotifier* m_ec;
};

#endif // BORNAGAIN_GUI_MODEL_DEVICE_INSTRUMENTNOTIFIER_H
