//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Util/String.cpp
//! @brief     Implements functions from Utils namespace
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Support/Util/String.h"
#include <QDir>
#include <QRegularExpression>
#include <QRegularExpressionMatch>

QStringList GUI::Util::String::fromStdStrings(const std::vector<std::string>& container)
{
    QStringList result;
    for (const std::string& str : container)
        result.append(QString::fromStdString(str));
    return result;
}

QString GUI::Util::String::suggestName(const QStringList& existingNames, const QString& name)
{
    int newNumber = -1;
    QRegularExpression regexp(R"(\((\d+)\))");

    QString baseName = name;
    QRegularExpressionMatch matched{regexp.match(baseName)};
    if (matched.hasMatch()) {
        newNumber = matched.captured(1).toInt();
        baseName.replace(matched.captured(0), "");
        baseName = baseName.trimmed();
    }

    for (const auto& name : existingNames) {
        if (name == baseName)
            newNumber = std::max(newNumber, 2);
        else {
            QRegularExpressionMatch matched{regexp.match(name)};
            if (matched.hasMatch())
                newNumber = std::max(newNumber, matched.captured(1).toInt() + 1);
        }
    }

    if (newNumber == -1)
        return baseName;

    return QString("%1 (%2)").arg(baseName).arg(newNumber);
}
