/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// pml/lml
#include <pml/Atom.h>

#include "AtomDecoration.h"
#include "AtomDC.h"

//-- CamiTK
#include <InteractiveViewer.h>
#include <GeometricObject.h>
using namespace camitk;

//-- vtk
#include <vtkActor.h>

#include <math.h> // for sqrt!

// ------------- constructor --------------
AtomDecoration::AtomDecoration(AtomDC * adc, GeometricObject::Geometry t) : Decoration(adc) {
    myAtom = adc->getAtom();
    myObject = new GeometricObject(t);
    update();
}

// ------------- destructor --------------
AtomDecoration::~AtomDecoration() {
    show(false);
    dc->removeProp("AtomDecoration");
    delete myObject;
    myObject = NULL;
}

// ------------- update --------------
void AtomDecoration::update() {
    double pos[3];
    myAtom->getPosition(pos);
    myObject->setPosition(pos[0], pos[1], pos[2]);
}

void AtomDecoration::update(const double x, const double y, const double z) {
    switch (myObject->getType()) {
        case GeometricObject::ARROW:
            setDirection(x,y,z);
            update();
            break;
        case GeometricObject::SPHERE:
            setPosition(x,y,z);
            break;
    }

}

void AtomDecoration::update(const double v[3]) {
    update(v[0], v[1], v[2]);
}

// ------------- show --------------
void AtomDecoration::show(const bool d) {
    if (d) {
      dc->addProp("AtomDecoration", myObject->getActor());
      dc->getProp("AtomDecoration")->VisibilityOn();
    }
    else {
      if (dc->getProp("AtomDecoration"))
        dc->getProp("AtomDecoration")->VisibilityOff();
    }
}

// ------------- setDirection --------------
void AtomDecoration::setDirection(const double x, const double y, const double z) {
    myObject->setDirection(x,y,z);
    double norm = sqrt(x*x+y*y+z*z);
    myObject->setSize(norm);
}

void AtomDecoration::setDirection(const double v[3]) {
    setDirection(v[0], v[1], v[2]);
}

// ------------- setColor --------------
void AtomDecoration::setColor(const double r, const double g, const double b) {
    myObject->setColor(r,g,b);
}

// ------------- setSize --------------
void AtomDecoration::setSize(const double s) {
    myObject->setSize(s);
}

// ------------- setPosition --------------
void AtomDecoration::setPosition(const double x, const double y, const double z) {
    myObject->setPosition(x,y,z);
}
