/*
	CabIIIModels.h
	
	Copyright 2014 Tim Goetze <tim@quitte.de>
	
	http://quitte.de/dsp/

	31st-order IIR filter models
*/
/*
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 3
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA or point your web browser to http://www.gnu.org.
*/

#define CabIIIModelDict "{0:\"off\",1:\"twin\",2:\"wookie\",3:\"blue\",4:\"indigo\",5:\"supra\",6:\"tweedie\",7:\"basswoman\",8:\"martial\",9:\"poser\",10:\"cabby\",11:\"angel\",12:\"matched\",13:\"yellow\",14:\"piquey\",15:\"paladin\",16:\"turtle\"}"
#define CabIIIModels 17
Model32
CabinetIII::allmodels[] =
{
/* 48k */
	{ /* off */
		1.000000,
		{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
	},
	{ /* twin */
		0.297964,
		{0.0278346166015,0.0848194352761,-0.0953075112981,0.0400599511643,-0.0241677661597,-0.0120347700071,-0.0105021056765,-0.00631847906313,0.0142808849172,-0.00975694728286,-0.0086835411626,-0.0101143521865,0.0418824932343,-0.027149857207,0.0323595121531,0.00806643298997,-0.0225102286873,-0.00940228428314,-0.00848439890007,0.00307815046102,-0.0100345753997,0.0116577363984,-0.0246590919263,0.034138303662,-0.00370643311065,0.00297211357181,0.00414092674394,-0.00718102425539,0.00269270176152,-0.0165821532816,0.00290028387549,-0.00549787118151},
		{-1.0,3.85855562664,-6.56415173422,6.23510637035,-3.22507666806,0.480079693515,0.144896740451,0.530217103611,-0.8020754909,0.395595698101,0.100038946511,-0.742234999313,1.49060062695,-1.67596136257,0.951821544636,0.381632080747,-1.39833594348,1.27532002921,-0.345878122053,-0.309804613435,-0.0411168032813,1.27534888306,-2.36749016557,2.27255376901,-1.22640057901,0.324252969463,-0.0497051461709,0.0907647867953,-0.078428076678,-0.0179189827774,0.0541184085853,-0.0199074749777}
	},
	{ /* wookie */
		0.324089,
		{0.0415171384811,0.134360012085,-0.105446832146,0.0232827107318,-0.0371629856884,-0.029693292348,-0.00828994357036,-0.007646662263,-0.0382464871043,0.0185069748207,-0.00187819574864,0.0443369508539,0.0212304579412,-0.00859312798725,-0.00951195942302,-0.00548289405317,-0.0260155420687,-0.00441738317252,-0.0209096850275,0.0149914050128,0.00710699120652,0.0197297319054,0.0111272763064,-0.00959805483123,0.00214388473172,0.00316023886343,-0.00975831288926,-0.00600358584987,0.00764147823913,-0.019124167339,0.0180197449987,-0.00723768660329},
		{-1.0,3.12465587931,-4.19656843424,3.52662402657,-2.39523876289,1.06759646245,0.150518199604,-0.0260594262901,-1.15166728634,1.90488075056,-1.88335746388,1.32603540448,-0.488012085645,0.130297810791,-0.489779679734,1.08579349063,-1.47966752488,1.33358532838,-0.765029702279,0.389940895742,-0.386125417754,0.446752952441,-0.525354277138,0.576700256906,-0.348840284246,-0.0113121004823,0.153951983114,-0.159109958543,0.183877241665,-0.133437127876,0.0173165960317,0.0162427114845}
	},
	{ /* blue */
		0.329318,
		{0.0422962754965,0.116994719141,-0.125644772208,0.073598933118,-0.0803803572158,0.0292035038888,-0.0349795151569,0.0208136447416,-0.0179647570901,-0.0100669790949,0.0167386389215,0.0173735093815,0.0167713509135,-0.0244084981983,0.00432068064363,-0.020781875919,0.0119333111019,-0.0396539744438,0.0353306314,-0.045286155383,0.0174704718921,-0.00587113971255,0.0232439985001,-0.00224128702745,0.00386142310404,0.00901083519063,-0.0141397120573,0.0190555373552,-0.0308016636247,0.0141803968654,-0.0233487908568,0.0040565808435},
		{-1.0,3.4148934207,-5.22579778766,5.02680812224,-3.78821988747,2.37698406169,-1.15165814089,0.620213062012,-0.349541861569,-0.114305643389,0.0914336141532,0.625388551381,-1.45690807409,1.99429747327,-1.73619288887,0.747822316507,0.241420988084,-0.987093593248,1.46294732807,-1.3295211108,0.775515509482,-0.295579137932,-0.114662387756,0.476640043418,-0.670823609381,0.739611547173,-0.662632557607,0.409323419079,-0.14797199574,0.00695035566391,0.0303398204249,-0.0161614198712}
	},
	{ /* indigo */
		0.308208,
		{0.0567150339484,0.0862529126422,-0.104488031689,0.00870294410145,-0.065008842559,0.0240028729306,-0.0252076785236,0.00445751643631,0.00448801400403,0.029139018892,-0.0151661634356,0.0247882870752,-0.00998311520916,-0.0131166490144,0.0337185158825,-0.0194690601436,0.000373284051976,-0.0461948503346,-0.00263170723995,0.0087391618231,0.0123469077677,0.00420640140511,0.0286647379282,-0.0109617190276,-0.0018592481626,0.0080433919558,-0.0300917678306,0.0110236949511,0.00408101918602,0.00671229154972,-0.00374368469903,-0.00658205895128},
		{-1.0,3.57244137202,-5.69481614454,5.64029649883,-4.11811724948,2.51707774357,-1.6095833501,1.35501693319,-1.43361475646,1.55111698965,-1.36499888422,0.73511443103,0.460482481484,-1.899860115,2.58501344122,-2.20342428809,1.52671562376,-1.08935718278,0.793222447831,-0.430586230915,0.121392786852,-0.180348936219,0.365582776142,-0.0793475632648,-0.699279700597,1.37552231311,-1.43610084247,0.962951095871,-0.368371630783,-0.0208393827203,0.0928657287639,-0.0281178742415}
	},
	{ /* supra */
		0.308023,
		{0.0319609567523,0.0766048503978,-0.0834799987584,0.0641687999269,-0.0502583655055,0.0343282065711,-0.0344061925794,0.0233287287476,-0.0461912755058,0.0172214886387,-0.0119838960587,-0.00813777174589,-0.00543911779947,-0.00503343673981,-0.0145269661188,0.0117326929196,0.0131024434199,-0.000644788156196,0.013599557416,-0.0147163668928,0.0109460567533,-0.000292411894631,0.00527225713667,-0.0144728353026,0.00963063410954,-0.0183556313846,0.0104100124394,-0.00771896711119,0.00108958732484,-0.00264500143915,-0.0054441124077,0.00346325131443},
		{-1.0,3.64608167975,-5.88846504086,5.69461601423,-4.30094904787,3.58199912063,-3.42562759694,3.4656373407,-3.74228944525,3.54141833475,-2.39992865242,1.23829956407,-0.9106749997,1.27375666831,-1.72832558657,1.69004113574,-1.19206495848,0.784390357548,-0.500093382319,0.123325062084,0.0240097510815,0.0444156751002,0.324072950966,-1.00425770399,1.28367169782,-1.24369248861,1.20429351855,-0.87892333308,0.231424289965,0.184639179021,-0.165289836904,0.0384474694686}
	},
	{ /* tweedie */
		0.359358,
		{0.0190042480826,0.0897675642301,-0.0804086070009,0.0377925367694,-0.0295853992674,0.0194095233341,-0.0453399420659,0.0199810606247,-0.0037696310194,-0.0170956279881,0.031617048041,-0.0280758843077,0.0248633208745,-0.021773039829,0.0247262627408,-0.0341387769363,0.0100084194017,0.0108816252884,-0.0182515182884,-0.00486526074953,0.000591909872312,0.00704968492764,-0.0186070380409,0.0213286540683,-0.00149964104223,0.0012220970362,-0.00640330430029,0.00235308377072,-0.000882630761367,-0.00138600139137,-0.000462631723554,-0.00752227668701},
		{-1.0,4.29324084693,-9.13487584298,12.964120664,-14.1897015411,13.5279508117,-12.5053356478,11.5587063195,-10.020933903,7.30372667216,-3.48780646551,-0.691114679925,4.08468071729,-5.93380114329,6.50159512956,-6.44706394463,5.90550277842,-4.52694609905,2.45072425308,-0.416398024124,-1.07289015135,2.09695694046,-2.84878640643,3.29480772742,-3.33568176103,3.05061639728,-2.58698840471,1.9289922448,-1.11973311273,0.44742226953,-0.104452027272,0.00781708682996}
	},
	{ /* basswoman */
		0.314517,
		{0.0344249196351,0.0797957248373,-0.0678511902545,0.0347065516092,-0.0863649776308,0.0828863800441,-0.0537533301902,0.0441489919572,-0.0572582129913,0.0106543564337,-0.0043829851854,0.0239323469433,0.00334726894483,-0.0109464906822,-0.00883482345855,-0.00653099758416,0.00185717388328,0.00935862834652,0.00228173355247,-0.0055150768621,-0.0234423595727,-0.00531151838704,0.0176501790409,-0.000195627352985,0.0107901389843,-0.00835440879464,-0.000231825400666,0.0011683704874,0.00961998468864,-0.00740702759267,-0.00742421308883,-0.0135061214485},
		{-1.0,3.84708042246,-7.14614547585,9.31853521271,-10.7849705832,11.7958855103,-11.2584673568,9.02381063948,-6.4433602052,4.27597661413,-2.17984483696,0.230625402378,0.959873392289,-1.33858336147,1.53389915601,-1.67142239291,1.34834517292,-0.732541090604,0.305245715218,0.0773195065231,-0.469114524739,0.380218475304,0.147804233613,-0.499203886787,0.473080064261,-0.319670293136,0.115582251037,0.174661918908,-0.417648105618,0.448043142732,-0.273737871317,0.0761476390111}
	},
	{ /* martial */
		0.322221,
		{0.0557462386787,0.199000674182,-0.0945173574265,0.021465846647,-0.115490456855,-0.0580339437486,-0.0207939221364,0.0141453368581,0.00100195685568,0.0438253192495,0.0158693520151,0.0402170363874,-0.00458527925237,-0.0378026583019,-0.0470156175361,-0.0275984994955,-0.0137668689487,0.0157085995741,0.00442331500001,0.038589012906,-0.0244029484172,0.0194267074269,0.00324357172213,-0.0208227729065,0.0176805109506,0.000660308911331,0.0214351754372,-0.0310266325308,-0.00554771050575,-0.0114860889457,0.00675873118395,-0.000636905435237},
		{-1.0,2.7463259832,-3.29470519245,2.60205730694,-1.75471167871,1.17705685206,-1.16131534069,1.49115846798,-1.64006629191,1.36006662573,-0.820335807248,0.643992154588,-0.81837180616,0.841614479559,-0.592707797775,0.30525550444,-0.0642753019632,0.163843332102,-0.718052010757,1.28812073116,-1.53005644745,1.2365913632,-0.590659469528,0.142256527991,-0.0611187645244,0.162420234609,-0.134099643801,-0.0591723887005,0.136902343232,-0.16779075808,0.180977351298,-0.0773146795199}
	},
	{ /* poser */
		0.367744,
		{0.03793502599,0.154727620399,-0.0286236985568,0.125864767062,-0.121480270829,0.053493734898,-0.12637280613,0.0239879412843,-0.0908453580039,0.0324396810594,-0.0592105558846,0.0335906359692,-0.0588970095936,0.0434764051901,-0.0289199014462,0.0500710687139,-0.0351479684529,0.0267573169718,-0.0308911305379,0.0233094489737,0.00781323897793,0.0398598414598,0.0215694302252,-0.00278469562828,0.00870138084984,-0.051406976077,0.0177526994787,-0.0358979075121,0.0131687908485,-0.0118921955427,-0.0104357633702,-0.0200735827425},
		{-1.0,3.05615405185,-5.04894894179,6.40097409574,-7.01754862592,7.08663522233,-6.71999014097,6.10438913784,-5.55641690689,5.29422454655,-5.13097733132,5.13167769918,-5.40837371459,5.59267623557,-5.55890096112,5.43736751994,-5.22732166864,4.88140625617,-4.42101909786,3.93825155661,-3.59896868262,3.23975790835,-2.66550020635,2.02710777387,-1.35834062171,0.718733221941,-0.326814760005,0.25712323727,-0.324213484911,0.322407447183,-0.181104455927,0.0451536011222}
	},
	{ /* cabby */
		0.336933,
		{0.0486002378166,0.137913866638,-0.126956139744,0.0343440220471,-0.0512008493055,-0.0430975887385,0.0477147802263,-0.0289541218874,-0.015451153119,0.0300745444554,0.0267729388133,-0.00801800544566,0.00691058781321,-0.0382891133947,-0.0409594818537,0.0049625930889,0.00919927792713,0.0128613183754,0.0168573450249,-0.0133344589157,0.00518516293661,-0.0154809180061,-0.000678567281429,0.0183607158673,0.00158209368268,0.0204093984489,-0.034834610107,0.0319542805183,-0.0182020477211,0.0197891272445,-0.0153744487774,-0.0245055727801},
		{-1.0,3.19579380913,-4.43863990309,3.72209878762,-2.08078841242,0.18159320185,1.20381137174,-1.10905446066,0.114131043793,0.417287677774,-0.180916451391,-0.342937225826,0.768863753298,-0.625369968229,-0.0061834492926,0.366838921235,-0.193707024916,-0.198564290609,0.585570823077,-0.667572129611,0.29137019032,0.234737344638,-0.637604749342,0.747757704552,-0.574303960019,0.601361850468,-1.05141030217,1.42829870934,-1.501686944,1.32683005621,-0.79236308637,0.212296987712}
	},
	{ /* angel */
		0.337571,
		{0.0645253956318,0.15191071968,-0.147356112101,-0.0020884213643,-0.0336726595518,-0.035220159535,-0.0126209859901,-0.00697985879664,0.022032599724,0.0514466708624,0.0180080050018,-0.0236265081338,-0.00711071145998,-0.00909921162731,-0.0585473918842,0.0182905392628,0.00901100663319,0.0272243441401,0.00156177646218,0.00038020624146,-0.0143902564653,0.0202765420394,-0.0125073444801,-0.0180994671541,-0.000146719456577,0.0273216220304,-0.0174309744669,0.0130499065471,0.000103550470795,-0.0249963047183,0.0151568087434,-0.0208432962292},
		{-1.0,2.96126718857,-3.45821344231,1.9886734421,-0.562075616502,-0.172407181364,0.862731740457,-1.38375442074,1.19484499659,-0.652791545414,0.565541536528,-0.755574968388,0.405436518064,0.584185750207,-1.32676645664,1.32100543632,-1.05255460425,0.754681298898,-0.276678718751,-0.0353380941049,-0.0537708955546,0.226734422117,-0.220780759716,0.174141319892,-0.341911674216,0.568003825905,-0.57268431707,0.37233272692,-0.100237622902,-0.0596732432978,0.0389533706966,0.00429996259289}
	},
	{ /* matched */
		0.326472,
		{0.0352369174361,0.0990866593386,-0.0867160236808,0.0370713211417,-0.0316807265848,0.00475739401955,-0.0318911640487,0.017066360352,-0.0423909852827,0.00365337384176,0.0194515701626,-0.00073952210658,0.0187508659465,0.0144005765064,-0.0264454440799,0.0104400332806,-0.00631991676892,-0.0131901650597,-0.0238143426299,0.00282253991291,-0.0242964721753,0.0224843693994,0.0277528760719,-0.000125078873862,-0.00563736853266,0.0127312200877,0.00947056402382,-0.0203962807834,-0.00265820184968,-0.00807241892968,-0.0029614800021,-0.00859523710436},
		{-1.0,3.52706658227,-5.51719859072,4.9848836109,-2.65053799169,0.361627476138,0.458907425164,0.617729950321,-1.97428610003,1.60876809729,0.103976958977,-1.4057515974,1.11955298382,0.712380791303,-2.45310536406,2.42331271148,-0.867765053543,-0.531316911039,0.585862975715,0.57985480157,-1.86230088819,1.97555360161,-0.796866780802,-0.374696399183,0.392478731566,0.461135741265,-1.10894621775,1.0416333808,-0.562359688344,0.146578456671,0.00751754685458,-0.00855433589129}
	},
	{ /* yellow */
		0.348142,
		{0.056293245405,0.151811342348,-0.107149064271,0.0871964008404,-0.118859965761,0.0401551850541,-0.0583121334964,0.0459887816232,-0.053185386141,0.00720871062564,-0.0317168228042,0.0247965593967,0.0125779813303,-0.00142914784686,0.00653623892318,-0.0035345661272,-0.0285245356239,0.0035080169519,-0.0282455660499,0.00143082853199,-0.0280711266922,0.0146700124573,0.0295186904254,0.0181321096052,0.00665832022864,0.0135823830134,-0.0133089961773,0.00294134744847,0.0119329745518,-0.0482594070179,0.00175344870875,-0.022560516512},
		{-1.0,3.02530960783,-4.2635017331,4.18790337823,-3.89830217251,3.45542230875,-2.57228147415,1.84473812285,-1.18207176474,0.426096741799,-0.143156983854,0.0685339329089,0.289874293557,-0.329411109138,-0.124464720133,0.657754214498,-1.18334308523,1.54836169129,-1.57658313933,1.63232925673,-1.61156697646,1.08268356399,-0.601760679662,0.616126274644,-0.699570892184,0.666735846987,-0.604260762574,0.287847030567,0.216186561792,-0.405280471265,0.23211109001,-0.0519295690926}
	},
	{ /* piquey */
		0.342963,
		{0.0636743158102,0.262007856948,-0.140663902623,-0.0612527476563,-0.0210354380765,-0.071233099139,0.0373292784193,-0.11043869161,0.044365121117,0.065989108338,-0.015054834878,0.049579772912,-0.0794968237547,-0.00335787600012,-0.00952941881786,-0.0518376915842,0.111773969086,0.00820948285191,-0.0133931773931,-0.0338445536298,-0.0593999373905,0.0187296082489,-0.0255415973334,0.00314235781516,0.0177091958286,0.0371307476827,0.0446094781406,0.0165655412512,-0.0369492884125,-0.0141722237182,-0.00946664750867,-0.0298338263778},
		{-1.0,2.56814774087,-2.71214610847,1.7834071396,-1.37627865695,1.12490492369,-0.218113055482,-0.420791127814,0.0592110041818,0.422530367905,-0.374414235473,0.405715588043,-0.854359411713,1.22066275696,-1.13561688526,0.826933178603,-0.585191042038,0.295059940918,0.177456637116,-0.212836102358,-0.332931614583,0.623702510429,-0.380057347404,0.309012257932,-0.562950254894,0.534354682926,-0.425087162088,0.667059812279,-0.862836182324,0.63440943683,-0.264608219471,0.0538218094236}
	},
	{ /* paladin */
		0.343892,
		{0.026286015287,0.0907600580728,-0.0834758404272,0.0773681577442,-0.0627093838038,0.0139372716433,0.0224433832524,-0.0466137693061,0.0501306110122,-0.0534222739157,0.0156224362785,-0.000390186637714,-0.0323237095133,0.0143224446662,-0.0287387322484,0.0155821975304,-0.00285930343908,0.00185521965317,-0.000251808206545,-0.00435837522963,-0.0171453773541,0.0103575026706,-0.010541769426,0.0220792242276,-0.0142339959925,0.006085388315,-0.00372061064905,-0.00944170429588,0.0109893544261,-0.00696813289816,0.00617150002068,-0.00282952020276},
		{-1.0,4.27203311074,-9.4219667949,14.254237169,-16.1484087166,13.6520709904,-7.57964432449,0.110659656516,6.60137420619,-10.5598928994,10.695746696,-7.42196628789,2.25372681403,2.81348190908,-6.08549031446,7.01318085141,-5.93630364881,3.72721086513,-1.62790382607,0.54935328498,-0.646746413498,1.61124236447,-2.87306445743,3.82067539228,-4.05604021283,3.36157062865,-1.91000595478,0.418944831231,0.452577693678,-0.605197786365,0.345573569391,-0.0850505081638}
	},
	{ /* turtle */
		0.287925,
		{0.0553567223251,0.108944645884,-0.167486225245,0.0659313669447,-0.101516160149,0.0407242608874,0.0364266447341,-0.020235265008,-0.0424023449895,0.0209802321019,-0.0097433818907,0.0753488200735,-0.0363073062533,0.0405032778471,-0.0742814714057,0.0203823314999,-0.0127054552363,-0.020815864624,0.0347327394802,-0.0158946502788,5.08820371009e-06,0.0224923254439,-0.0242644556343,0.0193490923077,0.0260102234874,-0.0331929196278,0.0101483350319,-0.0301249314684,0.013390467519,0.00602228331321,0.00501064003586,-0.00585752164308},
		{-1.0,3.33652354675,-4.67206995684,4.01745236218,-2.81152187353,1.43979531041,-0.0910790485494,-0.381082604706,-0.212712928465,1.35285480591,-2.21281806416,2.60837578964,-2.89171558742,2.79120328982,-2.0246695785,0.977198823747,0.012593020977,-0.706813852886,0.687512532801,0.140542218361,-1.17712864461,1.67688808802,-1.40449287296,0.594776075722,0.283736752873,-0.757092951284,0.679742981441,-0.3018857026,0.0239028443565,0.0142871793469,0.0108867295064,-0.00520813730442}
	},

/* 44.1k */
	{ /* off */
		1.000000,
		{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
	},
	{ /* twin */
		0.315285,
		{0.0280945673585,0.104049704633,-0.0992504206968,0.0305535866313,-0.0197077743193,-0.0235026900687,-0.00760171596063,-0.00499583493171,0.0196381160874,-0.0231699963634,-0.0191015143213,0.0444533017164,-0.00935705876968,0.0254842317103,0.01443174703,-0.0311348258072,-0.0148954094538,-0.00647796888484,-0.00821619565165,0.00965378492733,-0.0195561820615,0.0182593938014,0.0201784008831,-0.0138520246996,0.0157087801864,-0.00849850936313,0.00150725734818,-0.0176917251784,-0.00217355067089,-0.00364632520696,-0.00108824267139,-0.000296770567039},
		{-1.0,3.74803072913,-6.30017372298,6.03100499285,-3.12760364239,0.0631940639625,1.20867641433,-0.805282339315,0.0998244471421,0.400126632964,-1.1996917332,1.99361608166,-1.95429848315,1.09957712783,0.110631815191,-1.0117489652,0.97214414492,-0.0423049075549,-1.25001586224,2.2826692669,-2.34373229634,1.25230472504,0.135668288332,-0.879083189975,0.879295999345,-0.54435189937,0.221937091305,0.010685657883,-0.189773454508,0.238726032279,-0.13399901736,0.0287326736952}
	},
	{ /* wookie */
		0.342093,
		{0.0417681150138,0.156476453479,-0.113925536443,0.00578800779355,-0.0290618198362,-0.0389060230608,0.0125695705598,-0.0391959274955,-0.0145834119721,0.0222690593631,0.026993579784,0.0404858219244,-0.0334554141904,-0.00648373062688,-0.0079821349869,-0.00996660015294,-0.00420761127468,-0.018590275465,0.0157764373566,0.0169900158284,0.012178801658,-0.0205826564994,0.0066290495229,0.0031935246776,-0.00628065563096,0.0137066722522,0.00291985407983,-0.0149928461304,0.0167813001539,-0.00679997652787,-0.0157351796644,-0.00831035539088},
		{-1.0,3.01921887537,-3.83727915797,2.97078937174,-2.02886715337,1.04716943592,0.511008092791,-1.40168723414,0.831638191657,0.157060394377,-0.905246881326,1.52885984261,-1.55714620961,0.848730376428,-0.057232274639,-0.470521138003,0.666003110427,-0.340500731821,-0.20843081182,0.445177312791,-0.384768635053,0.17405324808,0.222755170071,-0.555085792755,0.481669827598,-0.245484045179,0.174836118667,-0.0843035338587,-0.161824943942,0.292977700986,-0.190179741011,0.0513898859896}
	},
	{ /* blue */
		0.344986,
		{0.0437820143998,0.139531711619,-0.127103563396,0.0457744720806,-0.0552707039423,0.00223376511818,0.00189543115494,-0.00944207156066,-0.01580130316,-0.0116636656109,0.040732435983,0.0146263947352,-0.0119980542548,-0.0263728946517,0.00856071191126,-0.0275151219501,0.0189927357088,-0.0101162052988,-0.0215420313039,-0.000490223270253,0.03100178709,-0.0133674602195,0.00763431047179,0.0039846814804,0.00312094121566,0.00260912716631,-0.00642708729308,-0.00726726138514,-0.0100013787577,-0.00682140837256,0.00487960852482,-0.0105360892904},
		{-1.0,3.27861084591,-4.77123070971,4.28244420787,-3.04281796603,1.79239782991,-0.513640393101,-0.0512030474569,0.0184724020718,-0.45852635318,1.16698820289,-1.54319360187,1.77661116503,-1.57915568801,0.853395005336,-0.347931493612,0.0844025482544,0.45392535283,-0.789695608789,0.514309177106,-0.147129085196,0.00351496830405,-0.0299847004476,0.18928543243,-0.255346303014,0.0732922599619,0.156440309656,-0.312874970598,0.408692135627,-0.350892053274,0.164781455355,-0.0314806520822}
	},
	{ /* indigo */
		0.311001,
		{0.058318156749,0.127607332145,-0.122186650857,-0.0161615890153,-0.0580943748622,-0.00155755534642,-0.00519386874954,-0.00661561549124,0.0376785727692,0.00570959578938,0.0162567397227,0.0043646825103,-0.0297630953991,0.0348714573369,-0.0161653172837,-0.0193045305812,-0.0439040549845,0.0013253058251,0.0134035242078,0.00924925289529,0.029911284582,0.0100992347455,-0.0124366888576,0.0117512811251,-0.0327085427297,-0.00488197142677,0.027789492259,-0.00928344003499,0.0100312640546,-0.0147337095774,-0.00174390794614,-0.0047420701833},
		{-1.0,3.35229613767,-4.94509243403,4.41020756688,-2.58908351056,0.656264973531,0.570503785602,-0.92817498379,0.645616830936,-0.0175799251366,-0.594894007676,1.31205690754,-2.02341769308,2.01047185931,-1.24296334404,0.497929619582,-0.214896028964,0.319583458035,-0.397260516936,0.156897571684,0.0273052952349,0.221232252694,-0.682638414852,0.887076322125,-0.558680529626,-0.124271156544,0.787128805672,-1.13694173218,1.01177267471,-0.601277713143,0.235457119508,-0.047376359197}
	},
	{ /* supra */
		0.318253,
		{0.0328027568758,0.097731563376,-0.0891769675666,0.0471637083398,-0.0249008818126,0.0179653736496,-0.0277859043669,0.000727259843442,-0.0289050107673,0.0252157855949,-0.0362028897875,0.00178521228859,-0.0111209706342,-0.0114208007778,0.0165781580121,0.0061661306704,0.00719132190557,-0.000442040307733,-0.00964515245733,0.0122792136304,0.00759256436545,-0.0162019561412,0.00892139785508,-0.00680610648461,0.00712771077934,-0.00958026308563,0.00088309247527,-0.00385305925474,0.00272621568559,-0.00130244770661,0.000209196417944,-0.0177018377569},
		{-1.0,3.49741144969,-5.28808745943,4.37142455921,-2.34261037571,1.52338452655,-1.51689553734,1.31809960709,-1.53506444922,2.47967904213,-2.93917785921,2.22292429928,-1.04192941451,0.237956220462,-0.0445472088669,0.164526806484,-0.160528167045,0.154191457596,-0.465356008604,0.567050446426,0.105364574904,-0.801837650163,0.662793667215,-0.279422150708,0.400043959678,-0.48215979042,-0.0396828997455,0.515443796338,-0.310129095451,-0.0935470092136,0.156971715933,-0.0449306999625}
	},
	{ /* tweedie */
		0.365289,
		{0.0196054838598,0.122277316047,-0.0668235499195,0.00182972560887,0.00191239456974,-0.0151886873028,-0.0345597370657,0.0191202281163,-0.0290278249911,0.0268582284418,-0.00629570944418,0.0028244025948,0.00638254066275,0.0046992569752,-0.0377492323257,0.0103148618298,0.0104675165835,-0.0205562013301,-0.00834579907236,0.00906532823913,-0.00472332068176,0.00247703222006,0.00926873536523,-0.00201579600835,0.00477821937185,-0.00445789783686,-0.00522457214847,0.00369695570142,-0.0020305744953,-0.0184580622727,0.00563297104294,-0.00808056201994},
		{-1.0,3.87658694466,-7.46816470847,9.52549438441,-9.1829301439,7.59276338149,-6.45228043941,6.51635645355,-7.50198314794,8.79339270963,-9.70357364902,9.53677441151,-8.25530971599,6.83558800635,-6.2167957872,6.32966739075,-6.34386579238,5.86048525563,-5.14170733222,4.43572583598,-3.71212065025,3.03934226564,-2.64766962632,2.5523627568,-2.48403177887,2.19234429029,-1.75002325814,1.38662472421,-1.0828159115,0.709628709178,-0.318997654283,0.0706244975525}
	},
	{ /* basswoman */
		0.326832,
		{0.03464275226,0.11001485404,-0.0812538255456,0.0124599783973,-0.0706347794136,0.09449740463,-0.0643424291234,0.0369528668351,-0.0805619634623,0.0530576520335,-0.0116510402059,0.0368623687518,-0.0422713196941,0.0091281132503,-0.0139546006896,0.0125908141756,0.00848433756367,0.0011299842446,-0.0236780535289,-0.0280292001671,0.0275628298268,0.00681964496917,0.00426912357836,-0.00886809847108,-0.00333178622976,0.00577948642528,0.00729728954949,-0.0140508750454,-0.0162549627392,-0.0106048389112,0.0103609422123,-0.00217520310752},
		{-1.0,3.62197936874,-6.18186939201,7.21375633526,-7.88488270953,9.30333902109,-10.2766271873,9.65058456729,-8.31309793031,7.49476462787,-6.86674836811,5.69800711244,-4.2965946117,3.46522157073,-3.05030821495,2.30161301279,-1.34310492392,0.878598546562,-0.618011077573,-0.114621435303,0.840274095202,-0.801309565608,0.310803960474,-0.0731085425924,0.0566042384429,0.131827764786,-0.449771522182,0.569535316077,-0.377253112676,0.0840241989377,0.0482245657333,-0.0262460551803}
	},
	{ /* martial */
		0.345228,
		{0.0558865703642,0.216856581451,-0.135190485698,0.0272854955006,-0.15096300331,0.0039286966471,-0.00785944138835,-0.0246787351683,0.0285005015478,0.0227847938955,0.0487700850417,0.00937843104342,-0.0434943900951,-0.0416011750268,-0.0318905939186,-0.0038771245921,0.0164174086376,0.00628298040469,0.0200980086631,-0.0219764959322,0.032505766629,-0.0209349941542,0.0425583916193,-0.014064752799,0.0217036764566,-0.0318905930993,-0.0136440165827,0.00295747442186,0.00181294623449,-0.0108998166966,-0.0247516772807,0.0259336711206},
		{-1.0,2.81558979161,-3.53523814269,2.97015110113,-2.1502540075,1.30480575764,-0.543734220907,0.246111825349,-0.540975807946,0.971375922246,-0.883540442918,0.490534994815,-0.324718902858,0.471980628523,-0.644032655253,0.87321745175,-1.08151399234,0.957272036645,-0.516591061715,-0.0878166257405,0.571090648363,-0.799776896639,0.864747485823,-0.731983099915,0.503222456961,-0.316459541382,0.113352777609,-0.0850058835877,0.267147480716,-0.320685634324,0.174889950483,-0.0388740695666}
	},
	{ /* poser */
		0.374207,
		{0.0392791554332,0.195267047794,0.0123069561678,0.119243200454,-0.0847928158579,-0.000174506467018,-0.124517331888,0.00575457727875,-0.0765106321545,0.0509892752549,-0.0607760295438,0.00381192532687,-0.0790139680297,0.00011207945643,-0.0318169550053,0.0246598673999,0.000716487122319,0.020139149137,0.0176149505594,0.0523132356609,0.0500158453523,0.0130310294118,0.0185702532303,-0.0283774292442,0.0107829579914,-0.0128418451269,0.00243044901123,0.00698117606704,-0.0206044185851,-0.0473587435657,-0.0341107026614,-0.0670437332375},
		{-1.0,2.70265768224,-4.01059425591,4.59350436186,-4.53255184779,4.35070490173,-4.30484609436,4.20313545256,-4.03430096328,4.02397794661,-3.81169031219,3.42163322037,-3.1095119937,2.82304183072,-2.61466626657,2.42201819623,-2.17217075888,1.98483839435,-1.94919016449,1.73497306843,-1.33092915145,0.971920491322,-0.744751487358,0.651643707835,-0.689621577082,0.862337130807,-1.10569939533,1.17024926998,-0.798207280593,0.38156887291,-0.142706046628,0.0348213596838}
	},
	{ /* cabby */
		0.345872,
		{0.0498846136034,0.15339331614,-0.181429447237,0.079513854912,-0.0936531465984,0.0408423064611,-0.0155707794524,-0.0238533739377,0.023923818389,0.0244094457768,0.00342936527077,-0.00396792361376,-0.0434472988914,-0.0334981638128,-0.00279651327079,0.0291786244305,0.00891714261244,-0.0133261325983,0.0141622258541,-0.00419195642853,0.00827032445594,0.00982054025308,-0.0179936967069,0.00226501612227,-0.0132538986545,0.0378707800394,-0.00688992115794,0.0111456129937,-0.0273419433978,0.00872578616182,0.00717947556427,-0.0374044457192},
		{-1.0,3.37089394253,-5.15333644831,5.14536267716,-4.33107788239,3.24409832424,-1.72361753859,0.427378040676,-0.0512596154251,0.31097749561,-0.678361642005,1.02920903854,-1.05097349619,0.726333135324,-0.589488091684,0.715381386209,-0.697946485373,0.610488298041,-0.713053457725,0.790022780234,-0.705214670903,0.634220904674,-0.495299068869,0.315537000476,-0.48835828659,0.817654014281,-0.910925009656,0.928943449239,-0.966258107958,0.809711931099,-0.43608089268,0.112957243583}
	},
	{ /* angel */
		0.343298,
		{0.0674554035068,0.173853897146,-0.190367328842,0.0085766800113,-0.0362408310668,-0.0344590253772,0.0128993872883,0.0090186446939,0.0216906482266,0.0526586573573,-0.0301123625897,-0.0167065766584,-0.030645306509,-0.0435668208454,0.0429456395194,0.0235224862389,-0.00608330559965,-0.00849192171666,0.000431880417087,0.00750113101949,0.0076487237502,-0.00980802851758,-0.00779085308771,0.0177135080685,-0.0201191052118,0.023400075497,-0.0156595997953,-0.0212109914638,0.0130985258166,0.00367464067579,-0.00456928441199,-0.0166285401274},
		{-1.0,3.04218379857,-3.77708727323,2.50853899492,-1.20710044581,0.760313142708,-0.484310865719,0.136751407887,-0.0923864104563,0.432689273295,-0.708695463146,0.551579252495,0.0739872464931,-0.741575610092,0.888168414486,-0.585160958443,0.318044721782,-0.164564138889,-0.00915073024011,0.167484452794,-0.242147098285,0.26493116484,-0.298181064615,0.341886465159,-0.422148140217,0.413877725334,-0.128543042603,-0.117424005164,-0.0859717398993,0.392306512545,-0.329952270786,0.0991633408107}
	},
	{ /* matched */
		0.347590,
		{0.0356429517269,0.114664940029,-0.0996221254047,0.0474223445081,-0.054493571966,0.0182188583147,-0.0334377646895,0.00667856755707,-0.0562529960078,0.0465141629295,-0.0284384634532,0.0356366790974,-0.00661222691683,-0.0150371925945,0.0044423676192,-0.00149065455487,-0.0154778025158,-0.0124280060125,-0.00728826131358,0.00306045135204,0.0392782805064,-0.00102375240912,-0.0109535694024,0.0134482192913,0.01041517667,-0.000333748337446,-0.0205624553457,0.00311112722721,-0.010388256855,0.00214655490338,-0.00499339188307,-0.00115561865998},
		{-1.0,3.56476080851,-5.92650569124,6.3437762761,-5.11735165629,3.07163715178,-0.983506246633,0.317494270275,-1.45834037917,2.91222238777,-3.43915984435,2.74285930764,-0.90702728274,-1.01602314183,1.71922720485,-1.05688136905,-0.155072866771,1.1521043093,-1.48485854039,0.929361650748,0.106979297432,-0.67914082381,0.293687286007,0.553809280568,-1.26291378098,1.75754481691,-2.00288239568,1.87459352605,-1.52330419045,1.08766890004,-0.567020376197,0.149416204601}
	},
	{ /* yellow */
		0.356462,
		{0.0591350719333,0.188834224461,-0.110103587246,0.0485099222026,-0.0986117831709,-0.00646202955451,-0.0180746227735,-0.00268951432163,-0.0398040193285,0.0117977516248,-0.00668702668617,0.0364224767044,-0.017788722936,0.010315989934,-0.0119623467197,-0.0169025195171,0.000277087198409,-0.0282380172841,-0.0146539275351,-0.00963944771848,0.0402906039624,0.0355058877894,0.00298589574328,0.0184286465315,-0.0209071725321,0.0138145009696,3.91884512311e-05,-0.0679331450887,0.0104304093444,-0.0123089201893,0.00248924698137,-0.00159173416449},
		{-1.0,2.83999526574,-3.59667158468,2.93932120941,-2.3653851791,2.14757793293,-1.64648753307,1.36497793848,-1.4056938196,1.1127810719,-0.824313520261,0.991920787609,-0.970039605687,0.59253355964,-0.265796821334,-0.0340676405762,0.309875722045,-0.239738290398,0.147615987989,-0.372986007447,0.300746038755,0.211796118065,-0.523065931395,0.547159146163,-0.591772609984,0.401172504427,0.210014632958,-0.624153315574,0.395354256505,0.0447401511345,-0.176556072242,0.0697522386378}
	},
	{ /* piquey */
		0.360461,
		{0.0646681115031,0.28877348351,-0.224761212198,-0.0355966340878,-0.0234687637422,-0.0175639424127,-0.019760710441,-0.0822026741831,0.114751646039,-0.000809618231681,-0.0213435022819,-0.0629633018586,0.0275072268495,0.0155924008778,-0.0421240683324,0.130551698905,-0.0177723591786,-0.0735551158674,-0.0382425779115,-0.00988787339238,0.03675172554,-0.0259340691631,0.00648399674334,0.0542174817004,0.0265246792025,-0.00888042173163,-0.053558013001,0.0300234887403,-0.00925278863944,-0.0166501506442,0.029668250203,-0.0488332719051},
		{-1.0,2.65776078764,-2.90802241759,1.83204209369,-1.38337093417,1.70188512425,-1.32919952408,0.384504912207,-0.224089513221,0.934504600347,-1.16673958209,0.469736896625,0.0866489841793,0.124978602433,-0.463430893402,0.323403520166,-0.055987835103,0.415656538413,-0.968039171067,0.685616296343,0.125177586584,-0.233786165931,-0.301142319974,0.357001670134,-0.0710409045623,0.312464366422,-0.848971019752,0.858948039707,-0.426420194347,0.103072980273,-0.0171537509268,0.0137894428053}
	},
	{ /* paladin */
		0.346870,
		{0.027287658304,0.121131119748,-0.106057553324,0.109076864875,-0.109235349448,0.0761838981049,-0.0449689979972,0.0199711186079,-0.021318925124,-0.00911252522638,0.00411423219964,-0.0177847725842,-0.0190067525985,-0.000320503528839,-0.0113056542017,0.017423656678,-0.00849583500871,-0.00320936166863,-0.0135428378985,-0.020296926537,0.01286958181,-0.0123004251539,0.0196373036656,-0.0237519331668,0.0161073420318,-0.0290528211401,0.0221487720088,-0.0103982222082,0.00506928894893,-0.000545602287835,0.00736960113,0.0110030289608},
		{-1.0,4.16247053877,-9.32005905553,15.092576254,-19.6856463706,21.6052079631,-20.7138011964,17.9285737316,-13.9885727447,9.66766083561,-5.76452066414,2.78972370735,-1.03551838584,0.630784571594,-1.17708849846,2.15411166976,-3.16881653169,3.76203551963,-3.57820072088,2.70862936877,-1.37899345387,-0.204583382278,1.79700650009,-3.27178252805,4.53816419218,-5.22226251677,4.98751419758,-3.93280630933,2.45801100277,-1.14429798174,0.362437931178,-0.0652454212825}
	},
	{ /* turtle */
		0.298113,
		{0.0567538999021,0.121907137429,-0.200088805888,0.0943425970383,-0.135668593734,0.10737250017,-0.024394010503,-0.00953803323669,-0.0610851614693,0.0815055297527,-0.0240674955287,0.0390354075174,0.00720460116134,-0.0497322432165,0.0338639632801,-0.0558422134941,0.00493075352548,0.0223037854159,-0.00325178324098,0.0110034123712,-0.00884150249387,-0.0079441966229,0.0364410690247,-0.00602504172372,-0.0210176294269,0.00554470785618,-0.0220435339778,0.0350113281306,-0.00854090491893,-0.0116893948249,0.00328729358729,-0.0071568291508},
		{-1.0,3.42559865729,-5.07788984119,4.87462873365,-4.1886826727,3.41866830144,-2.37535556405,1.49642726044,-1.08365410753,1.19077059888,-1.15960221634,0.35512909413,0.494403736308,-0.745806625051,0.764375341619,-0.494595923544,-0.29652000072,1.07683939125,-1.29006953568,0.950912540233,-0.426547261763,0.110487490402,-0.126184145166,0.408716048242,-0.912352414522,1.41015812894,-1.49745850278,1.05672083203,-0.402589080111,-0.0341072701312,0.105813238542,-0.0299478314567}
	},

};
