// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// TODO(b/172340451): Use the types generated by Mojo TypeScript binding
// generator once https://crbug.com/1002798 is finished.
type MojomNamespace = {
  mojom: any
};

declare var arc: MojomNamespace;
declare var blink: MojomNamespace;
declare var chromeosCamera: MojomNamespace;
declare var cros: MojomNamespace;

declare namespace chromeosCamera.mojom {
  export type CameraAppHelperRemote = any;
  export type ScreenState = any;
  export type WindowStateControllerRemote = any;
  export type WindowStateType = any;
}

declare namespace cros.mojom {
  export type CameraAppDeviceProviderRemote = any;
  export type CameraAppDeviceRemote = any;
  export type CameraMetadata = any;
  export type CameraMetadataEntry = any;
  export type CameraMetadataTag = any;
  export type CaptureIntent = any;
  export type Effect = any;
  export type StreamType = any;
}

// TODO(b/172340451): Remove this once we fully removed the legacy Chrome app
// support.
declare var chrome: any;

// This is currently a Chrome only API, and the spec is still in working draft
// stage.
// https://developer.mozilla.org/en-US/docs/Web/API/UIEvent/sourceCapabilities

interface UIEvent extends Event {
  readonly sourceCapabilities: InputDeviceCapabilities|null;
}

interface InputDeviceCapabilities {
  readonly firesTouchEvents: boolean;
  readonly pointerMovementScrolls: boolean;
}

// Chrome WebUI specific helper.
// https://source.chromium.org/chromium/chromium/src/+/master:ui/webui/resources/js/load_time_data.js

declare var loadTimeData: {
  getString(id: string): string;
  getStringF(id: string, ...args: (number|string)[]): string;
}
