/*
$Id: courierpassd.h,v 1.1 2005/10/15 21:52:08 astjean Exp $

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Copyright (c) Andrew St. Jean <andrew@arda.homeunix.net> 2002-2005
*/

#ifndef COURIERPASSD_H
#define COURIERPASSD_H 1

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "logging.h"
#include "getopt.h"
#include "courierauth.h"
#include "courierauthdebug.h"
#include <syslog.h>
#include <stdio.h>
#include <ctype.h>
#include <pwd.h>

#ifdef HAVE_STDARG_H
#include <stdarg.h>
#define VA_START(a, f)	va_start(a, f)
#else
#ifdef HAVE_VARARGS_H
#include <varargs.h>
#define VA_START(a, f)	va_start(a)
#endif
#endif

#ifndef VA_START
  error no variadic api
#endif

#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#elif HAVE_STRINGS_H
#include <strings.h>
#endif /* STDC_HEADERS */

#if !__GLIBC__ >= 2
#include <ulimit.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#if HAVE_ERRNO_H
#include <errno.h>
#endif
#ifndef errno
  extern int errno;
#endif

enum { OPT_STDIN = 1, OPT_STDOUT = 2, OPT_STDERR = 3 };

/* define what we consider safe characters in strings */
#define SAFE_CHARS      "abcdefghijklmnopqrstuvwxyz \
                         ABCDEFGHIJKLMNOPQRSTUVWXYZ \
		                 1234567890+_-.@"

#define XMALLOC(type, num)                              	\
	         ((type *)xmalloc ((num) * sizeof(type)))
#define XCALLOC(type, num)                              	\
	        ((type *)xcalloc ((num), sizeof(type)))
#define XREALLOC(type, p, num)                          	\
	        ((type *)xrealloc ((p), (num) * sizeof(type)))
#define XFREE(stale)                                    	\
	        do{                                     	\
			if (stale){ free (stale); stale = 0; }  \
		} while (0)

extern void *xmalloc(size_t num);
extern void *xcalloc(size_t num, size_t size);
extern void *xrealloc(void *p, size_t num);

#endif /* COURIERPASSD_H */
