/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public final class UntypedAtomicConverter
extends UnaryExpression {
    private AtomicType requiredItemType;
    private boolean allConverted;

    public UntypedAtomicConverter(Expression expression, AtomicType atomicType, boolean bl) {
        super(expression);
        this.requiredItemType = atomicType;
        this.allConverted = bl;
        ExpressionTool.copyLocationInfo(expression, this);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.allConverted) {
            return this.requiredItemType;
        }
        return Type.getCommonSuperType(this.requiredItemType, this.operand.getItemType(typeHierarchy), typeHierarchy);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.allConverted && this.requiredItemType.isNamespaceSensitive()) {
            StaticError staticError = new StaticError("Cannot convert untypedAtomic values to QNames or NOTATIONs");
            staticError.setErrorCode("XPTY0004");
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        this.operand = this.operand.typeCheck(staticContext, itemType);
        if (this.operand instanceof Value) {
            return ((Value)SequenceExtent.makeSequenceExtent(this.iterate(staticContext.makeEarlyEvaluationContext()))).reduce();
        }
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        ItemType itemType2 = this.operand.getItemType(typeHierarchy);
        if (itemType2 instanceof NodeTest) {
            return this;
        }
        if (itemType2 == Type.ANY_ATOMIC_TYPE || itemType2 instanceof AnyItemType || itemType2 == Type.UNTYPED_ATOMIC_TYPE) {
            return this;
        }
        ComputedExpression.setParentExpression(this.operand, this.getParentExpression());
        return this.operand;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public SequenceIterator iterate(final XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

            public Item map(Item item) throws XPathException {
                if (item instanceof UntypedAtomicValue) {
                    AtomicValue atomicValue = ((UntypedAtomicValue)item).convert(UntypedAtomicConverter.this.requiredItemType, xPathContext, true);
                    if (atomicValue instanceof ValidationErrorValue) {
                        ValidationException validationException = ((ValidationErrorValue)atomicValue).getException();
                        if (validationException.getLineNumber() == -1) {
                            validationException.setLocator(ExpressionTool.getLocator(UntypedAtomicConverter.this));
                        }
                        throw validationException;
                    }
                    return atomicValue;
                }
                return item;
            }
        };
        return new ItemMappingIterator(sequenceIterator, itemMappingFunction);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.operand.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        if (item instanceof UntypedAtomicValue) {
            try {
                AtomicValue atomicValue = ((UntypedAtomicValue)item).convert(this.requiredItemType, xPathContext, true);
                if (atomicValue instanceof ValidationErrorValue) {
                    throw ((ValidationErrorValue)atomicValue).getException();
                }
                return atomicValue;
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }
        return item;
    }

    protected String displayOperator(Configuration configuration) {
        return "convert untyped atomic items to " + this.requiredItemType.toString(configuration.getNamePool());
    }
}

