/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.om.AtomizableIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class SingletonIterator
implements AxisIterator,
ReversibleIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator,
AtomizableIterator {
    private Item item;
    private int position = 0;

    private SingletonIterator(Item item) {
        this.item = item;
    }

    public static AxisIterator makeIterator(Item item) {
        if (item == null) {
            return EmptyIterator.getInstance();
        }
        return new SingletonIterator(item);
    }

    public boolean hasNext() {
        return this.position == 0;
    }

    public Item next() {
        if (this.position == 0) {
            this.position = 1;
            return this.item;
        }
        if (this.position == 1) {
            this.position = -1;
            return null;
        }
        return null;
    }

    public Item current() {
        if (this.position == 1) {
            return this.item;
        }
        return null;
    }

    public int position() {
        return this.position;
    }

    public int getLastPosition() {
        return 1;
    }

    public SequenceIterator getAnother() {
        return new SingletonIterator(this.item);
    }

    public SequenceIterator getReverseIterator() {
        return new SingletonIterator(this.item);
    }

    public Item getValue() {
        return this.item;
    }

    public Value materialize() {
        if (this.item instanceof AtomicValue) {
            try {
                Value value = ((Value)((Object)this.item)).reduce();
                if (value != this.item && value instanceof AtomicValue) {
                    this.item = (AtomicValue)value;
                }
                return value;
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return new SingletonNode((NodeInfo)this.item);
    }

    public void setIsAtomizing(boolean bl) {
        if (bl && this.item instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)this.item;
            switch (nodeInfo.getNodeKind()) {
                case 3: 
                case 9: {
                    this.item = new UntypedAtomicValue(nodeInfo.getStringValueCS());
                    return;
                }
                case 1: 
                case 2: {
                    int n = ((NodeInfo)this.item).getTypeAnnotation();
                    if (n == -1 || n == 641 || n == 642) {
                        this.item = new UntypedAtomicValue(nodeInfo.getStringValueCS());
                        return;
                    }
                    return;
                }
                case 7: 
                case 8: 
                case 13: {
                    this.item = new StringValue(nodeInfo.getStringValueCS());
                    return;
                }
            }
            return;
        }
    }

    public int getProperties() {
        return 15;
    }
}

