/*
 * This file is part of the ESO UVES Pipeline
 * Copyright (C) 2004,2005 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jtaylor $
 * $Date: 2012-11-19 09:16:16 $
 * $Revision: 1.22 $
 * $Name: not supported by cvs2svn $
 * $Log: not supported by cvs2svn $
 * Revision 1.21  2010/09/24 09:31:26  amodigli
 * put back QFITS dependency to fix problem spot by NRI on FIBER mode (with MIDAS calibs) data
 *
 * Revision 1.19  2008/03/25 08:24:02  amodigli
 * added FLAMES_UTL_UNPACK
 *
 * Revision 1.18  2007/10/24 09:32:17  amodigli
 * added FLAMES_MKMASTER_DOM FLAMES_MKMASTER_ID
 *
 * Revision 1.17  2007/07/03 08:44:15  jmlarsen
 * Moved definition of FLAMES_DEBUG
 *
 * Revision 1.16  2007/06/28 09:32:04  jmlarsen
 * Shortened message domains
 *
 * Revision 1.15  2007/06/26 13:36:04  jmlarsen
 * Fixed typo in flames_cal_prep_sff_ofpos
 *
 * Revision 1.14  2007/06/25 06:00:45  amodigli
 * added FLAMES_REDCHAIN_ID FLAMES_REDCHAIN_DOM flames_redchain_get_info
 *
 * Revision 1.13  2007/05/07 16:23:59  jmlarsen
 * Removed double quotes from definition of recipe id
 *
 * Revision 1.12  2007/05/07 06:40:43  amodigli
 * added FLAMES_PREPPA_ID & FLAMES_PREPPA_DOM
 *
 * Revision 1.11  2007/01/10 08:06:54  jmlarsen
 * Moved most definitions to flames_uves.h
 *
 * Revision 1.10  2006/11/13 12:24:22  jmlarsen
 * Fixed WAVECAL_DOM
 *
 * Revision 1.9  2006/10/24 14:43:31  jmlarsen
 * Removed flames_cal_mkmaster recipe
 *
 * Revision 1.8  2006/10/24 14:23:18  jmlarsen
 * Fixed wavecal, predict recipe names
 *
 * Revision 1.7  2006/10/19 08:24:02  jmlarsen
 * Added recipe id, msg domains
 *
 * Revision 1.6  2006/10/17 12:43:05  jmlarsen
 * Include uves_recipe
 *
 * Revision 1.5  2006/10/17 12:39:05  jmlarsen
 * Added flames_orderpos definitions
 *
 * Revision 1.4  2006/10/17 12:33:42  jmlarsen
 * Moved FLAMES source to flames directory
 *
 * Revision 1.8  2006/08/24 07:18:12  amodigli
 * fixed doxygen warnings
 *
 * Revision 1.7  2006/07/31 06:28:11  amodigli
 * porting to CPL
 *
 * Revision 1.6  2006/07/06 06:53:12  jmlarsen
 * Excluded some typedefs from doxygen doc.
 *
 * Revision 1.5  2006/06/26 08:16:40  amodigli
 * added get_info stuff
 *
 * Revision 1.4  2006/06/26 07:52:49  amodigli
 * added defines for new recipes
 *
 * Revision 1.3  2006/06/22 15:25:35  amodigli
 * changes for flames_cal_prep_sff_ofpos
 *
 * Revision 1.2  2006/06/22 06:42:38  amodigli
 * fixed some compilation warnings
 *
 * Revision 1.1  2006/06/19 06:50:36  amodigli
 * added
 *
 * Revision 1.2  2006/05/15 06:09:10  amodigli
 * fixed compilation warning
 *
 * Revision 1.14  2006/02/03 07:46:30  jmlarsen
 * Moved recipe implementations to ./uves directory
 *
 * Revision 1.3  2005/12/19 16:17:55  jmlarsen
 * Replaced bool -> int
 *
 */

#ifndef FLAMES_H
#define FLAMES_H

#include <cpl.h>
#include <stdint.h>
/*-----------------------------------------------------------------------------
                                   Defines
 ----------------------------------------------------------------------------*/
#define FLAMES_DEBUG 0

#define FLAMES_CAL_ORDERPOS_ID flames_cal_orderpos
#define FLAMES_CAL_ORDERPOS_DOM "OrderPos"

#define FLAMES_MKMASTER_ID flames_cal_mkmaster
#define FLAMES_MKMASTER_DOM "mkmaster"

#define FLAMES_CAL_PREP_SFF_OFPOS_ID flames_cal_prep_sff_ofpos
#define FLAMES_CAL_PREP_SFF_OFPOS_DOM "OFPos"

#define FLAMES_CAL_PREDICT_ID flames_cal_predict
#define FLAMES_CAL_PREDICT_DOM "Predict"

#define FLAMES_CAL_WAVECAL_ID flames_cal_wavecal
#define FLAMES_CAL_WAVECAL_DOM "Wavecal"

#define FLAMES_OBS_SCIRED_ID flames_obs_scired
#define FLAMES_OBS_SCIRED_DOM "SciRed"

#define FLAMES_OBS_REDCHAIN_ID flames_obs_redchain
#define FLAMES_OBS_REDCHAIN_DOM "RedChain"

#define FLAMES_EXTRACT_ID flames_extract
#define FLAMES_EXTRACT_DOM "extract"

#define FLAMES_FILLORDTAB_ID flames_fillordtab
#define FLAMES_FILLORDTAB_DOM "fillordtab"

#define FLAMES_MES_SLITFF_SIZE_ID flames_mes_slitff_size
#define FLAMES_MES_SLITFF_SIZE_DOM "mes_slitff_size"

#define FLAMES_PREPBKG_ID flames_prepbkg
#define FLAMES_PREPBKG_DOM "prepbkg"

#define FLAMES_PREPFIBREFF_ID flames_prepfibreff
#define FLAMES_PREPFIBREFF_DOM "prepfibreff"

#define FLAMES_PREPNORM_ID flames_prepnorm
#define FLAMES_PREPNORM_DOM "prepnorm"

#define FLAMES_PREPPA_ID flames_preppa
#define FLAMES_PREPPA_DOM "preppa"


#define FLAMES_PREPSLITFF_ID flames_prepslitff
#define FLAMES_PREPSLITFF_DOM "prepslitff"

#define FLAMES_UTL_UNPACK_ID flames_utl_unpack
#define FLAMES_UTL_UNPACK_DOM "unpack"


int flames_utl_unpack_get_info(cpl_pluginlist *);
int flames_cal_orderpos_get_info(cpl_pluginlist *);
int flames_cal_predict_get_info(cpl_pluginlist *);
int flames_cal_prep_sff_ofpos_get_info(cpl_pluginlist *);
int flames_cal_wavecal_get_info(cpl_pluginlist *);
int flames_cal_mkmaster_get_info(cpl_pluginlist *);
int flames_obs_scired_get_info(cpl_pluginlist *);
int flames_obs_redchain_get_info(cpl_pluginlist *);

int flames_extract_get_info(cpl_pluginlist *);
int flames_fillordtab_get_info(cpl_pluginlist *);
int flames_mes_slitff_size_get_info(cpl_pluginlist *);
int flames_prepbkg_get_info(cpl_pluginlist *);
int flames_prepfibreff_get_info(cpl_pluginlist *);
int flames_prepnorm_get_info(cpl_pluginlist *);
int flames_preppa_get_info(cpl_pluginlist *);
int flames_prepslitff_get_info(cpl_pluginlist *);
#endif /* FLAMES_H */


