/*
 * This file is part of the ESO UVES Pipeline
 * Copyright (C) 2004,2005 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: amodigli $
 * $Date: 2010-09-24 09:31:29 $
 * $Revision: 1.8 $
 * $Name: not supported by cvs2svn $
 * $Log: not supported by cvs2svn $
 * Revision 1.6  2007/06/06 08:17:33  amodigli
 * replace tab with 4 spaces
 *
 * Revision 1.5  2007/06/05 15:13:32  amodigli
 * added ifnded-define guard
 *
 * Revision 1.4  2007/05/18 15:45:35  amodigli
 * changed interface: pass BADPXFRAME
 *
 * Revision 1.3  2007/05/07 16:24:21  jmlarsen
 * Enabled flames_preppa
 *
 * Revision 1.2  2007/01/29 13:09:57  jmlarsen
 * Work on conversion to CPL
 *
 * Revision 1.1  2007/01/10 08:06:10  jmlarsen
 * Added source files
 *
 * Revision 1.1  2006/10/20 06:42:09  jmlarsen
 * Moved FLAMES source to flames directory
 *
 * Revision 1.78  2006/10/12 11:37:28  jmlarsen
 * Temporarily disabled FLAMES code generation
 *
 */
#ifndef FLAMES_PREPPA_IMPL_H
#define FLAMES_PREPPA_IMPL_H


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

/*-----------------------------------------------------------------------------
                    Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

/*-----------------------------------------------------------------------------
                             Defines
 -----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                                   Prototypes
 -----------------------------------------------------------------------------*/
void
flames_preppa_process(cpl_frame *image,
              const char * BADPXFRAME, 
              const char *filterswitch,
              int drs_pthre_min,
              int drs_pthre_max);

#endif
