DACSSCHED(1)                 DACS Commands Manual                 DACSSCHED(1)



[1mNAME[0m
       dacssched - rule-based command scheduling

[1mSYNOPSIS[0m
       [1mdacssched [22m[[1m-h [22m| [1m-help[22m] [[1m-ll [4m[22mlog_level[24m] [[1m-q[22m] [{[1m-r [22m| [1m-rules[22m} [4mrules_uri[24m]
                 [{[1m-s [22m| [1m-sched[22m} [4msched_uri[24m] [[1m-v[22m]

       [1mdacssched --version[0m

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite. It is a stand-alone program
       that neither accepts the usual [1mDACS [22mcommand line options ([4mdacsoptions[24m)
       nor accesses any [1mDACS [22mconfiguration files.

       The [1mdacssched [22mcommand runs other programs when specified conditions
       have been met. It does this by periodically examining a schedule,
       which, for each scheduled event, identifies the necessary conditions
       and the command line to be executed should the conditions be satisfied.
       Rules are stored separately from the schedule, although in a future
       version it might be possible to contain them with their schedule.

       Although [1mdacssched [22mis conceptually similar to [34m[1mcron(8)[0m[1m[22m[1], [34m[1matrun(8)[0m[1m[22m[2],
       and other programs used to schedule a command to be executed or a
       reminder to be sent at certain times or dates, there are some important
       differences. First, because the [1mDACS [22mrule evaluation engine is used,
       conditions much more broad and complex than simply the time or date can
       be used to schedule a command - [1mDACS [34mexpressions[0m[1m[22m[3] are available. For
       instance, a rule to manage automated file backup could be written to
       take into account context other than simply the day of the week and the
       time of day, if necessary even running external programs to assist in
       making the determination. Second, both a schedule and the rules
       referenced by a schedule are accessed through the [1mDACS [22mvirtual
       filestore, which means they can be stored in file or database,
       retrieved by HTTP, and so on.

           [1mNote[0m
           Although this program may be useful, it is currently merely a
           prototype intended for demonstration and experimentation purposes.
           Some configuration capabilities, features, and security steps
           required by a production version have not been implemented. The
           prototype must be invoked periodically; a production version would
           run in the background and automatically rescan the schedule at a
           given frequency. Note that because of its flexibility, the schedule
           must be polled at a suitable frequency - in general, the program
           cannot compute when the next scheduled event will occur. Also
           because events need not be triggered by a time or date, some events
           may need to "self-disabling" so that they are not repeatedly
           executed unintentionally.

   [1mOperation[0m
       The program loads a [4mschedule[24m, which either comes from a default file or
       a location specified on the command line. A schedule is an ordinary
       text file, each line of which is either blank, a comment, or a
       scheduled event. The file is processed in the order in which the events
       appear from the top. Initial whitespace on any line is ignored. A
       comment line begins with a "#" character. A scheduled event consists of
       a [4mname[24m, followed by whitespace, followed by a command. If [4mname[0m
       evaluates to [1mTrue [22m(i.e., it grants access), the command is executed
       through [34m[1msystem(3)[0m[1m[22m[4]. If rule evaluation fails because of an error, the
       event is not executed. Events are not removed from the schedule after
       their command has been executed.

       A [4mname[24m, which must begin with a slash, has no significance to
       [1mdacssched[22m; it is simply a label that is used to identify the rule to
       apply and is matched against a rule's service element.

       Here is a simple schedule containing one event:

           # A simple schedule
           /setdate   /usr/local/sbin/rdate -a

       If the condition labelled /setdate is [1mTrue [22mthe specified command will
       be executed.

       A simple rule such as the following might be associated with the event:

           <acl_rule status="enabled">
               <services>
                 <service url_pattern="/setdate"/>
               </services>

              <rule order="allow,deny">
                <allow>
                  time(hour) eq 2 and time(min) eq 0
                </allow>
              </rule>
           </acl_rule>

       This rule enables the event /setdate at 2:00am every day. We will
       assume that the schedule is processed exactly once per minute.

       Internally, [1mdacssched [22mconverts the scheduled event above into the
       expression:

           rule("/setdate", [4mrule_uri[24m)

       (where [4mrule_uri[24m specifies the ruleset to use) and then evaluates the
       expression. Please refer to the [34m[1mrule [22mpredicate[0m[5] for additional
       information.

[1mOPTIONS[0m
       The arguments are processed as they are examined (left-to-right) and
       their ordering can be significant.

       By default, the program will look for a schedule in the file
       [4m${Conf::DACS_HOME}[24m/dacssched/sched. (default:
       /usr/local/dacs/dacssched/sched) The default location for the rules is
       [4m${Conf::DACS_HOME}[24m/dacssched/acls. (default:
       /usr/local/dacs/dacssched/acls)

       The following command line flags are recognized:

       [1m-h[0m
           Prints the usage blurb.

       [1m-ll [4m[22mlog_level[0m
           Set the debugging output level to [4mlog_level[24m (see [34m[1mdacs(1)[0m[1m[22m[6]). The
           default level is warn, and the [1m-v [22mflag bumps the level to debug or
           trace.

       [1m-q[0m
           Be quiet, except for error messages. The [1m-v [22mand [1m-ll [22mflags are
           independent of this.

       [1m-r [4m[22mrule_uri[0m
       [1m-rules [4m[22mrule_uri[0m
           This flag specifies the ruleset to be used. It can be an absolute
           pathname or a URI in the syntax of the [34m[1mVFS[0m[1m[22m[7] configuration
           directive. Examples:

               -r "[acls1]dacs-fs:/local/acls"
               -rules /usr/local/myrules


       [1m-s [4m[22msched_uri[0m
       [1m-sched [4m[22msched_uri[0m
           This flag specifies the schedule. It can be an absolute pathname or
           a URI in the syntax of the [34m[1mVFS[0m[1m[22m[7] configuration directive.

       [1m-v[0m
           Increase the level of debugging output. The flag may be repeated.

       [1m--version[0m
           Display the program's version information and then exit.

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacs.exprs(5)[0m[1m[22m[3], [34m[1mdacs.acls(5)[0m[1m[22m[8]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[9])

[1mCOPYING[0m
       Copyright (C) 2003-2015 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[10] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. cron(8)
           http://www.freebsd.org/cgi/man.cgi?query=cron&apropos=0&sektion=8&manpath=FreeBSD+10.1-RELEASE&format=html

        2. atrun(8)
           http://www.freebsd.org/cgi/man.cgi?query=atrun&apropos=0&sektion=8&manpath=FreeBSD+10.1-RELEASE&format=html

        3. expressions
           http://dacs.dss.ca/man/dacs.exprs.5.html

        4. system(3)
           http://www.freebsd.org/cgi/man.cgi?query=system&apropos=0&sektion=3&manpath=FreeBSD+10.1-RELEASE&format=html

        5. [1mrule [22mpredicate
           http://dacs.dss.ca/man/dacs.exprs.5.html#rule

        6. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        7. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        8. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

        9. www.dss.ca
           http://www.dss.ca

       10. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.38a                      11/23/2016                      DACSSCHED(1)
