# -*- coding: utf-8 -*-
info = {
    "name": "de",
    "date_order": "DMY",
    "january": [
        "januar",
        "jan"
    ],
    "february": [
        "februar",
        "feb"
    ],
    "march": [
        "märz",
        "mär"
    ],
    "april": [
        "april",
        "apr"
    ],
    "may": [
        "mai"
    ],
    "june": [
        "juni",
        "jun"
    ],
    "july": [
        "juli",
        "jul"
    ],
    "august": [
        "august",
        "aug"
    ],
    "september": [
        "september",
        "sep"
    ],
    "october": [
        "oktober",
        "okt"
    ],
    "november": [
        "november",
        "nov"
    ],
    "december": [
        "dezember",
        "dez"
    ],
    "monday": [
        "montag",
        "mo",
        "Mon"
    ],
    "tuesday": [
        "dienstag",
        "di",
        "Die"
    ],
    "wednesday": [
        "mittwoch",
        "mi",
        "Mit"
    ],
    "thursday": [
        "donnerstag",
        "do",
        "Don"
    ],
    "friday": [
        "freitag",
        "fr",
        "Fre"
    ],
    "saturday": [
        "samstag",
        "sa",
        "Sam"
    ],
    "sunday": [
        "sonntag",
        "so",
        "Son"
    ],
    "am": [
        "vorm"
    ],
    "pm": [
        "nachm"
    ],
    "year": [
        "jahr",
        "j",
        "Jahre"
    ],
    "month": [
        "monat",
        "m",
        "Monate",
        "Monaten"
    ],
    "week": [
        "woche",
        "w",
        "Wochen"
    ],
    "day": [
        "tag",
        "Tage"
    ],
    "hour": [
        "stunde",
        "std",
        "Stunden"
    ],
    "minute": [
        "minute",
        "min",
        "Minuten"
    ],
    "second": [
        "sekunde",
        "sek",
        "Sekunden"
    ],
    "relative-type": {
        "1 year ago": [
            "letztes jahr"
        ],
        "0 year ago": [
            "dieses jahr"
        ],
        "in 1 year": [
            "nächstes jahr"
        ],
        "1 month ago": [
            "letzten monat"
        ],
        "0 month ago": [
            "diesen monat"
        ],
        "in 1 month": [
            "nächsten monat"
        ],
        "1 week ago": [
            "letzte woche"
        ],
        "0 week ago": [
            "diese woche"
        ],
        "in 1 week": [
            "nächste woche"
        ],
        "1 day ago": [
            "gestern"
        ],
        "0 day ago": [
            "heute"
        ],
        "in 1 day": [
            "morgen"
        ],
        "0 hour ago": [
            "in dieser stunde"
        ],
        "0 minute ago": [
            "in dieser minute"
        ],
        "0 second ago": [
            "jetzt"
        ],
        "2 day ago": [
            "vorgestern"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "in (\\d+) jahr",
            "in (\\d+) jahren"
        ],
        "\\1 year ago": [
            "vor (\\d+) jahr",
            "vor (\\d+) jahren"
        ],
        "in \\1 month": [
            "in (\\d+) monat",
            "in (\\d+) monaten"
        ],
        "\\1 month ago": [
            "vor (\\d+) monat",
            "vor (\\d+) monaten"
        ],
        "in \\1 week": [
            "in (\\d+) woche",
            "in (\\d+) wochen",
            "in (\\d+) wo"
        ],
        "\\1 week ago": [
            "vor (\\d+) woche",
            "vor (\\d+) wochen",
            "vor (\\d+) wo"
        ],
        "in \\1 day": [
            "in (\\d+) tag",
            "in (\\d+) tagen"
        ],
        "\\1 day ago": [
            "vor (\\d+) tag",
            "vor (\\d+) tagen"
        ],
        "in \\1 hour": [
            "in (\\d+) stunde",
            "in (\\d+) stunden",
            "in (\\d+) std"
        ],
        "\\1 hour ago": [
            "vor (\\d+) stunde",
            "vor (\\d+) stunden",
            "vor (\\d+) std",
            "vor (\\d+)\\s*h"
        ],
        "in \\1 minute": [
            "in (\\d+) minute",
            "in (\\d+) minuten",
            "in (\\d+) min",
            "in (\\d+) m"
        ],
        "\\1 minute ago": [
            "vor (\\d+) minute",
            "vor (\\d+) minuten",
            "vor (\\d+) min",
            "vor (\\d+) m",
            "vor (\\d+)\\s*m"
        ],
        "in \\1 second": [
            "in (\\d+) sekunde",
            "in (\\d+) sekunden",
            "in (\\d+) sek",
            "in (\\d+) s"
        ],
        "\\1 second ago": [
            "vor (\\d+) sekunde",
            "vor (\\d+) sekunden",
            "vor (\\d+) sek",
            "vor (\\d+) s",
            "vor (\\d+)\\s*s"
        ]
    },
    "locale_specific": {
        "de-LU": {
            "name": "de-LU"
        },
        "de-AT": {
            "name": "de-AT",
            "january": [
                "jänner",
                "jän"
            ]
        },
        "de-CH": {
            "name": "de-CH"
        },
        "de-LI": {
            "name": "de-LI"
        },
        "de-BE": {
            "name": "de-BE"
        },
        "de-IT": {
            "name": "de-IT",
            "january": [
                "jänner",
                "jän"
            ]
        }
    },
    "skip": [
        "um",
        "uhr",
        "etwa",
        "und",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "vor"
    ],
    "in": [
        "in",
        "im"
    ],
    "simplifications": [
        {
            "einer": "1"
        },
        {
            "einem": "1"
        }
    ]
}