% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dbDisconnect}
\alias{dbDisconnect}
\title{Disconnect (close) a connection}
\usage{
dbDisconnect(conn, ...)
}
\arguments{
\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link{dbConnect}}.}

\item{...}{Other parameters passed on to methods.}
}
\value{
a logical vector of length 1, indicating success or failure.
}
\description{
This closes the connection, discards all pending work, and frees
resources (e.g., memory, sockets).
}
\examples{
if (require("RSQLite")) {
con <- dbConnect(RSQLite::SQLite(), ":memory:")
dbDisconnect(con)
}
}
\seealso{
Other connection methods: \code{\link{dbExistsTable}};
  \code{\link{dbGetException}}; \code{\link{dbGetQuery}},
  \code{\link{dbGetQuery,DBIConnection,character-method}};
  \code{\link{dbListFields}}; \code{\link{dbListResults}};
  \code{\link{dbListTables}}; \code{\link{dbReadTable}},
  \code{\link{dbWriteTable}}; \code{\link{dbRemoveTable}};
  \code{\link{dbSendQuery}}
}

