// Code generated by go-swagger; DO NOT EDIT.

package network

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	timeext "time"
)

// Network network
//
// swagger:model Network
type Network struct {

	// Name of the network.
	//
	// Example: my_network
	Name string `json:"Name"`

	// ID that uniquely identifies a network on a single machine.
	//
	// Example: 7d86d31b1478e7cca9ebed7e73aa0fdeec46c5ca29497431d3007d2d9e15ed99
	ID string `json:"Id"`

	// Date and time at which the network was created in
	// [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format with nano-seconds.
	//
	// Example: 2016-10-19T04:33:30.360899459Z
	Created timeext.Time `json:"Created"`

	// The level at which the network exists (e.g. `swarm` for cluster-wide
	// or `local` for machine level)
	//
	// Example: local
	Scope string `json:"Scope"`

	// The name of the driver used to create the network (e.g. `bridge`,
	// `overlay`).
	//
	// Example: overlay
	Driver string `json:"Driver"`

	// Whether the network was created with IPv4 enabled.
	//
	// Example: true
	EnableIPv4 bool `json:"EnableIPv4"`

	// Whether the network was created with IPv6 enabled.
	//
	// Example: false
	EnableIPv6 bool `json:"EnableIPv6"`

	// The network's IP Address Management.
	//
	IPAM IPAM `json:"IPAM"`

	// Whether the network is created to only allow internal networking
	// connectivity.
	//
	// Example: false
	Internal bool `json:"Internal"`

	// Whether a global / swarm scope network is manually attachable by regular
	// containers from workers in swarm mode.
	//
	// Example: false
	Attachable bool `json:"Attachable"`

	// Whether the network is providing the routing-mesh for the swarm cluster.
	//
	// Example: false
	Ingress bool `json:"Ingress"`

	// config from
	ConfigFrom ConfigReference `json:"ConfigFrom"`

	// Whether the network is a config-only network. Config-only networks are
	// placeholder networks for network configurations to be used by other
	// networks. Config-only networks cannot be used directly to run containers
	// or services.
	//
	ConfigOnly bool `json:"ConfigOnly"`

	// Network-specific options uses when creating the network.
	//
	// Example: {"com.docker.network.bridge.default_bridge":"true","com.docker.network.bridge.enable_icc":"true","com.docker.network.bridge.enable_ip_masquerade":"true","com.docker.network.bridge.host_binding_ipv4":"0.0.0.0","com.docker.network.bridge.name":"docker0","com.docker.network.driver.mtu":"1500"}
	Options map[string]string `json:"Options"`

	// Metadata specific to the network being created.
	//
	// Example: {"com.example.some-label":"some-value","com.example.some-other-label":"some-other-value"}
	Labels map[string]string `json:"Labels"`

	// List of peer nodes for an overlay network. This field is only present
	// for overlay networks, and omitted for other network types.
	//
	Peers []PeerInfo `json:"Peers,omitempty"`
}
